export G_TestEntityPosition
code
proc G_TestEntityPosition 68 28
file "..\g_mover.c"
line 33
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:#include "g_local.h"
;5:
;6:
;7:
;8:/*
;9:===============================================================================
;10:
;11:PUSHMOVE
;12:
;13:===============================================================================
;14:*/
;15:
;16:void MatchTeam( gentity_t *teamLeader, int moverState, int time );
;17:
;18:typedef struct {
;19:	gentity_t	*ent;
;20:	vec3_t	origin;
;21:	vec3_t	angles;
;22:	float	deltayaw;
;23:} pushed_t;
;24:pushed_t	pushed[MAX_GENTITIES], *pushed_p;
;25:
;26:
;27:/*
;28:============
;29:G_TestEntityPosition
;30:
;31:============
;32:*/
;33:gentity_t	*G_TestEntityPosition( gentity_t *ent ) {
line 37
;34:	trace_t	tr;
;35:	int		mask;
;36:
;37:	if ( ent->clipmask ) {
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
INDIRI4
CNSTI4 0
EQI4 $48
line 38
;38:		mask = ent->clipmask;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
INDIRI4
ASGNI4
line 39
;39:	} else {
ADDRGP4 $49
JUMPV
LABELV $48
line 40
;40:		mask = MASK_SOLID;
ADDRLP4 56
CNSTI4 1
ASGNI4
line 41
;41:	}
LABELV $49
line 42
;42:	if ( ent->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $50
line 43
;43:		trap_Trace( &tr, ent->client->ps.origin, ent->r.mins, ent->r.maxs, ent->client->ps.origin, ent->s.number, mask );
ADDRLP4 0
ARGP4
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
ADDRLP4 60
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
CNSTI4 424
ADDP4
ARGP4
ADDRLP4 60
INDIRP4
CNSTI4 436
ADDP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
INDIRI4
ARGI4
ADDRLP4 56
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 44
;44:	} else {
ADDRGP4 $51
JUMPV
LABELV $50
line 45
;45:		trap_Trace( &tr, ent->s.pos.trBase, ent->r.mins, ent->r.maxs, ent->s.pos.trBase, ent->s.number, mask );
ADDRLP4 0
ARGP4
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
ADDRLP4 60
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
CNSTI4 424
ADDP4
ARGP4
ADDRLP4 60
INDIRP4
CNSTI4 436
ADDP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
INDIRI4
ARGI4
ADDRLP4 56
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 46
;46:	}
LABELV $51
line 48
;47:	
;48:	if (tr.startsolid)
ADDRLP4 0+4
INDIRI4
CNSTI4 0
EQI4 $52
line 49
;49:		return &g_entities[ tr.entityNum ];
CNSTI4 792
ADDRLP4 0+52
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
RETP4
ADDRGP4 $47
JUMPV
LABELV $52
line 51
;50:		
;51:	return NULL;
CNSTP4 0
RETP4
LABELV $47
endproc G_TestEntityPosition 68 28
export G_TryPushingEntity
proc G_TryPushingEntity 144 16
line 62
;52:}
;53:
;54:
;55:/*
;56:==================
;57:G_TryPushingEntity
;58:
;59:Returns qfalse if the move is blocked
;60:==================
;61:*/
;62:qboolean	G_TryPushingEntity( gentity_t *check, gentity_t *pusher, vec3_t move, vec3_t amove ) {
line 69
;63:	vec3_t		forward, right, up;
;64:	vec3_t		org, org2, move2;
;65:	gentity_t	*block;
;66:
;67:	// EF_MOVER_STOP will just stop when contacting another entity
;68:	// instead of pushing it, but entities can still ride on top of it
;69:	if ( ( pusher->s.eFlags & EF_MOVER_STOP ) && 
ADDRLP4 76
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
EQI4 $57
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ADDRLP4 76
INDIRP4
INDIRI4
EQI4 $57
line 70
;70:		check->s.groundEntityNum != pusher->s.number ) {
line 71
;71:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $56
JUMPV
LABELV $57
line 75
;72:	}
;73:
;74:	// save off the old position
;75:	if (pushed_p > &pushed[MAX_GENTITIES]) {
ADDRGP4 pushed_p
INDIRP4
CVPU4 4
ADDRGP4 pushed+32768
CVPU4 4
LEU4 $59
line 76
;76:		G_Error( "pushed_p > &pushed[MAX_GENTITIES]" );
ADDRGP4 $62
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 77
;77:	}
LABELV $59
line 78
;78:	pushed_p->ent = check;
ADDRGP4 pushed_p
INDIRP4
ADDRFP4 0
INDIRP4
ASGNP4
line 79
;79:	VectorCopy (check->s.pos.trBase, pushed_p->origin);
ADDRGP4 pushed_p
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 80
;80:	VectorCopy (check->s.apos.trBase, pushed_p->angles);
ADDRGP4 pushed_p
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 60
ADDP4
INDIRB
ASGNB 12
line 81
;81:	if ( check->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $63
line 82
;82:		pushed_p->deltayaw = check->client->ps.delta_angles[YAW];
ADDRGP4 pushed_p
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 60
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 83
;83:		VectorCopy (check->client->ps.origin, pushed_p->origin);
ADDRGP4 pushed_p
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 84
;84:	}
LABELV $63
line 85
;85:	pushed_p++;
ADDRLP4 80
ADDRGP4 pushed_p
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
line 88
;86:
;87:	// we need this for pushing things later
;88:	VectorSubtract (vec3_origin, amove, org);
ADDRLP4 84
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 0
ADDRGP4 vec3_origin
INDIRF4
ADDRLP4 84
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRGP4 vec3_origin+4
INDIRF4
ADDRLP4 84
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRGP4 vec3_origin+8
INDIRF4
ADDRFP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 89
;89:	AngleVectors (org, forward, right, up);
ADDRLP4 0
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 48
ARGP4
ADDRLP4 60
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 92
;90:
;91:	// try moving the contacted entity 
;92:	VectorAdd (check->s.pos.trBase, move, check->s.pos.trBase);
ADDRLP4 88
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 92
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 96
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 96
INDIRP4
ADDRLP4 96
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDF4
ASGNF4
line 93
;93:	if (check->client) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $69
line 95
;94:		// make sure the client's view rotates when on a rotating mover
;95:		check->client->ps.delta_angles[YAW] += ANGLE2SHORT(amove[YAW]);
ADDRLP4 100
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 60
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRI4
CNSTF4 1199570944
ADDRFP4 12
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ADDI4
ASGNI4
line 96
;96:	}
LABELV $69
line 99
;97:
;98:	// figure movement due to the pusher's amove
;99:	VectorSubtract (check->s.pos.trBase, pusher->r.currentOrigin, org);
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 104
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 100
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 104
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 100
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 104
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
SUBF4
ASGNF4
line 100
;100:	org2[0] = DotProduct (org, forward);
ADDRLP4 24
ADDRLP4 0
INDIRF4
ADDRLP4 36
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 36+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 101
;101:	org2[1] = -DotProduct (org, right);
ADDRLP4 24+4
ADDRLP4 0
INDIRF4
ADDRLP4 48
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 48+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 48+8
INDIRF4
MULF4
ADDF4
NEGF4
ASGNF4
line 102
;102:	org2[2] = DotProduct (org, up);
ADDRLP4 24+8
ADDRLP4 0
INDIRF4
ADDRLP4 60
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 60+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 60+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 103
;103:	VectorSubtract (org2, org, move2);
ADDRLP4 12
ADDRLP4 24
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 24+4
INDIRF4
ADDRLP4 0+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+8
ADDRLP4 24+8
INDIRF4
ADDRLP4 0+8
INDIRF4
SUBF4
ASGNF4
line 104
;104:	VectorAdd (check->s.pos.trBase, move2, check->s.pos.trBase);
ADDRLP4 108
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 108
INDIRP4
ADDRLP4 108
INDIRP4
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
ADDRLP4 112
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 116
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 116
INDIRP4
ADDRLP4 116
INDIRP4
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDF4
ASGNF4
line 105
;105:	if ( check->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $95
line 106
;106:		VectorAdd (check->client->ps.origin, move, check->client->ps.origin);
ADDRLP4 120
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 120
INDIRP4
ADDRLP4 120
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 124
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 124
INDIRP4
ADDRLP4 124
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 128
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDF4
ASGNF4
line 107
;107:		VectorAdd (check->client->ps.origin, move2, check->client->ps.origin);
ADDRLP4 132
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 132
INDIRP4
ADDRLP4 132
INDIRP4
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
ADDRLP4 136
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 136
INDIRP4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 140
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 140
INDIRP4
ADDRLP4 140
INDIRP4
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDF4
ASGNF4
line 108
;108:	}
LABELV $95
line 111
;109:
;110:	// may have pushed them off an edge
;111:	if ( check->s.groundEntityNum != pusher->s.number ) {
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
INDIRI4
EQI4 $99
line 112
;112:		check->s.groundEntityNum = -1;
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 -1
ASGNI4
line 113
;113:	}
LABELV $99
line 115
;114:
;115:	block = G_TestEntityPosition( check );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 120
ADDRGP4 G_TestEntityPosition
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 120
INDIRP4
ASGNP4
line 116
;116:	if (!block) {
ADDRLP4 72
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $101
line 118
;117:		// pushed ok
;118:		if ( check->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $103
line 119
;119:			VectorCopy( check->client->ps.origin, check->r.currentOrigin );
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 124
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 120
;120:		} else {
ADDRGP4 $104
JUMPV
LABELV $103
line 121
;121:			VectorCopy( check->s.pos.trBase, check->r.currentOrigin );
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 124
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 122
;122:		}
LABELV $104
line 123
;123:		trap_LinkEntity (check);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 124
;124:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $56
JUMPV
LABELV $101
line 130
;125:	}
;126:
;127:	// if it is ok to leave in the old position, do it
;128:	// this is only relevent for riding entities, not pushed
;129:	// Sliding trapdoors can cause this.
;130:	VectorCopy( (pushed_p-1)->origin, check->s.pos.trBase);
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRGP4 pushed_p
INDIRP4
CNSTI4 -28
ADDP4
INDIRB
ASGNB 12
line 131
;131:	if ( check->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $105
line 132
;132:		VectorCopy( (pushed_p-1)->origin, check->client->ps.origin);
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 pushed_p
INDIRP4
CNSTI4 -28
ADDP4
INDIRB
ASGNB 12
line 133
;133:	}
LABELV $105
line 134
;134:	VectorCopy( (pushed_p-1)->angles, check->s.apos.trBase );
ADDRFP4 0
INDIRP4
CNSTI4 60
ADDP4
ADDRGP4 pushed_p
INDIRP4
CNSTI4 -16
ADDP4
INDIRB
ASGNB 12
line 135
;135:	block = G_TestEntityPosition (check);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 124
ADDRGP4 G_TestEntityPosition
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 124
INDIRP4
ASGNP4
line 136
;136:	if ( !block ) {
ADDRLP4 72
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $107
line 137
;137:		check->s.groundEntityNum = -1;
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 -1
ASGNI4
line 138
;138:		pushed_p--;
ADDRLP4 128
ADDRGP4 pushed_p
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRP4
CNSTI4 -32
ADDP4
ASGNP4
line 139
;139:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $56
JUMPV
LABELV $107
line 143
;140:	}
;141:
;142:	// blocked
;143:	return qfalse;
CNSTI4 0
RETI4
LABELV $56
endproc G_TryPushingEntity 144 16
export G_MoverPush
proc G_MoverPush 4240 32
line 156
;144:}
;145:
;146:
;147:/*
;148:============
;149:G_MoverPush
;150:
;151:Objects need to be moved back on a failed push,
;152:otherwise riders would continue to slide.
;153:If qfalse is returned, *obstacle will be the blocking entity
;154:============
;155:*/
;156:qboolean G_MoverPush( gentity_t *pusher, vec3_t move, vec3_t amove, gentity_t **obstacle ) {
line 165
;157:	int			i, e;
;158:	gentity_t	*check;
;159:	vec3_t		mins, maxs;
;160:	pushed_t	*p;
;161:	int			entityList[MAX_GENTITIES];
;162:	int			listedEntities;
;163:	vec3_t		totalMins, totalMaxs;
;164:
;165:	*obstacle = NULL;
ADDRFP4 12
INDIRP4
CNSTP4 0
ASGNP4
line 170
;166:
;167:
;168:	// mins/maxs are the bounds at the destination
;169:	// totalMins / totalMaxs are the bounds for the entire move
;170:	if ( pusher->r.currentAngles[0] || pusher->r.currentAngles[1] || pusher->r.currentAngles[2]
ADDRLP4 4164
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4168
CNSTF4 0
ASGNF4
ADDRLP4 4164
INDIRP4
CNSTI4 488
ADDP4
INDIRF4
ADDRLP4 4168
INDIRF4
NEF4 $116
ADDRLP4 4164
INDIRP4
CNSTI4 492
ADDP4
INDIRF4
ADDRLP4 4168
INDIRF4
NEF4 $116
ADDRLP4 4164
INDIRP4
CNSTI4 496
ADDP4
INDIRF4
ADDRLP4 4168
INDIRF4
NEF4 $116
ADDRLP4 4172
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 4172
INDIRP4
INDIRF4
ADDRLP4 4168
INDIRF4
NEF4 $116
ADDRLP4 4172
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 4168
INDIRF4
NEF4 $116
ADDRLP4 4172
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 4168
INDIRF4
EQF4 $110
LABELV $116
line 171
;171:		|| amove[0] || amove[1] || amove[2] ) {
line 174
;172:		float		radius;
;173:
;174:		radius = RadiusFromBounds( pusher->r.mins, pusher->r.maxs );
ADDRLP4 4180
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4180
INDIRP4
CNSTI4 424
ADDP4
ARGP4
ADDRLP4 4180
INDIRP4
CNSTI4 436
ADDP4
ARGP4
ADDRLP4 4184
ADDRGP4 RadiusFromBounds
CALLF4
ASGNF4
ADDRLP4 4176
ADDRLP4 4184
INDIRF4
ASGNF4
line 175
;175:		for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $117
line 176
;176:			mins[i] = pusher->r.currentOrigin[i] + move[i] - radius;
ADDRLP4 4188
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4188
INDIRI4
ADDRLP4 16
ADDP4
ADDRLP4 4188
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDP4
INDIRF4
ADDRLP4 4188
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDF4
ADDRLP4 4176
INDIRF4
SUBF4
ASGNF4
line 177
;177:			maxs[i] = pusher->r.currentOrigin[i] + move[i] + radius;
ADDRLP4 4192
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4192
INDIRI4
ADDRLP4 28
ADDP4
ADDRLP4 4192
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDP4
INDIRF4
ADDRLP4 4192
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDF4
ADDRLP4 4176
INDIRF4
ADDF4
ASGNF4
line 178
;178:			totalMins[i] = mins[i] - move[i];
ADDRLP4 4196
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4196
INDIRI4
ADDRLP4 4140
ADDP4
ADDRLP4 4196
INDIRI4
ADDRLP4 16
ADDP4
INDIRF4
ADDRLP4 4196
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 179
;179:			totalMaxs[i] = maxs[i] - move[i];
ADDRLP4 4200
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4200
INDIRI4
ADDRLP4 4152
ADDP4
ADDRLP4 4200
INDIRI4
ADDRLP4 28
ADDP4
INDIRF4
ADDRLP4 4200
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 180
;180:		}
LABELV $118
line 175
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 3
LTI4 $117
line 181
;181:	} else {
ADDRGP4 $111
JUMPV
LABELV $110
line 182
;182:		for (i=0 ; i<3 ; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $121
line 183
;183:			mins[i] = pusher->r.absmin[i] + move[i];
ADDRLP4 4176
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4176
INDIRI4
ADDRLP4 16
ADDP4
ADDRLP4 4176
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
ADDP4
INDIRF4
ADDRLP4 4176
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDF4
ASGNF4
line 184
;184:			maxs[i] = pusher->r.absmax[i] + move[i];
ADDRLP4 4180
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4180
INDIRI4
ADDRLP4 28
ADDP4
ADDRLP4 4180
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 464
ADDP4
ADDP4
INDIRF4
ADDRLP4 4180
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDF4
ASGNF4
line 185
;185:		}
LABELV $122
line 182
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 3
LTI4 $121
line 187
;186:
;187:		VectorCopy( pusher->r.absmin, totalMins );
ADDRLP4 4140
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
INDIRB
ASGNB 12
line 188
;188:		VectorCopy( pusher->r.absmax, totalMaxs );
ADDRLP4 4152
ADDRFP4 0
INDIRP4
CNSTI4 464
ADDP4
INDIRB
ASGNB 12
line 189
;189:		for (i=0 ; i<3 ; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $125
line 190
;190:			if ( move[i] > 0 ) {
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
CNSTF4 0
LEF4 $129
line 191
;191:				totalMaxs[i] += move[i];
ADDRLP4 4176
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4180
ADDRLP4 4176
INDIRI4
ADDRLP4 4152
ADDP4
ASGNP4
ADDRLP4 4180
INDIRP4
ADDRLP4 4180
INDIRP4
INDIRF4
ADDRLP4 4176
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDF4
ASGNF4
line 192
;192:			} else {
ADDRGP4 $130
JUMPV
LABELV $129
line 193
;193:				totalMins[i] += move[i];
ADDRLP4 4176
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4180
ADDRLP4 4176
INDIRI4
ADDRLP4 4140
ADDP4
ASGNP4
ADDRLP4 4180
INDIRP4
ADDRLP4 4180
INDIRP4
INDIRF4
ADDRLP4 4176
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDF4
ASGNF4
line 194
;194:			}
LABELV $130
line 195
;195:		}
LABELV $126
line 189
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 3
LTI4 $125
line 196
;196:	}
LABELV $111
line 199
;197:
;198:	// unlink the pusher so we don't get it in the entityList
;199:	trap_UnlinkEntity( pusher );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 201
;200:
;201:	listedEntities = trap_EntitiesInBox( totalMins, totalMaxs, entityList, MAX_GENTITIES );
ADDRLP4 4140
ARGP4
ADDRLP4 4152
ARGP4
ADDRLP4 40
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 4176
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 4136
ADDRLP4 4176
INDIRI4
ASGNI4
line 204
;202:
;203:	// move the pusher to it's final position
;204:	VectorAdd( pusher->r.currentOrigin, move, pusher->r.currentOrigin );
ADDRLP4 4180
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ASGNP4
ADDRLP4 4180
INDIRP4
ADDRLP4 4180
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4184
ADDRFP4 0
INDIRP4
CNSTI4 480
ADDP4
ASGNP4
ADDRLP4 4184
INDIRP4
ADDRLP4 4184
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4188
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ASGNP4
ADDRLP4 4188
INDIRP4
ADDRLP4 4188
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDF4
ASGNF4
line 205
;205:	VectorAdd( pusher->r.currentAngles, amove, pusher->r.currentAngles );
ADDRLP4 4192
ADDRFP4 0
INDIRP4
CNSTI4 488
ADDP4
ASGNP4
ADDRLP4 4192
INDIRP4
ADDRLP4 4192
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4196
ADDRFP4 0
INDIRP4
CNSTI4 492
ADDP4
ASGNP4
ADDRLP4 4196
INDIRP4
ADDRLP4 4196
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4200
ADDRFP4 0
INDIRP4
CNSTI4 496
ADDP4
ASGNP4
ADDRLP4 4200
INDIRP4
ADDRLP4 4200
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDF4
ASGNF4
line 206
;206:	trap_LinkEntity( pusher );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 209
;207:
;208:	// see if any solid entities are inside the final position
;209:	for ( e = 0 ; e < listedEntities ; e++ ) {
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 $134
JUMPV
LABELV $131
line 210
;210:		check = &g_entities[ entityList[ e ] ];
ADDRLP4 8
CNSTI4 792
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 40
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 213
;211:
;212:		// only push items and players
;213:		if ( check->s.eType != ET_ITEM && check->s.eType != ET_PLAYER && !check->physicsObject ) {
ADDRLP4 4208
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 4208
INDIRI4
CNSTI4 2
EQI4 $135
ADDRLP4 4208
INDIRI4
CNSTI4 1
EQI4 $135
ADDRLP4 8
INDIRP4
CNSTI4 552
ADDP4
INDIRI4
CNSTI4 0
NEI4 $135
line 214
;214:			continue;
ADDRGP4 $132
JUMPV
LABELV $135
line 218
;215:		}
;216:
;217:		// if the entity is standing on the pusher, it will definitely be moved
;218:		if ( check->s.groundEntityNum != pusher->s.number ) {
ADDRLP4 8
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
EQI4 $137
line 220
;219:			// see if the ent needs to be tested
;220:			if ( check->r.absmin[0] >= maxs[0]
ADDRLP4 8
INDIRP4
CNSTI4 452
ADDP4
INDIRF4
ADDRLP4 28
INDIRF4
GEF4 $149
ADDRLP4 8
INDIRP4
CNSTI4 456
ADDP4
INDIRF4
ADDRLP4 28+4
INDIRF4
GEF4 $149
ADDRLP4 8
INDIRP4
CNSTI4 460
ADDP4
INDIRF4
ADDRLP4 28+8
INDIRF4
GEF4 $149
ADDRLP4 8
INDIRP4
CNSTI4 464
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
LEF4 $149
ADDRLP4 8
INDIRP4
CNSTI4 468
ADDP4
INDIRF4
ADDRLP4 16+4
INDIRF4
LEF4 $149
ADDRLP4 8
INDIRP4
CNSTI4 472
ADDP4
INDIRF4
ADDRLP4 16+8
INDIRF4
GTF4 $139
LABELV $149
line 225
;221:			|| check->r.absmin[1] >= maxs[1]
;222:			|| check->r.absmin[2] >= maxs[2]
;223:			|| check->r.absmax[0] <= mins[0]
;224:			|| check->r.absmax[1] <= mins[1]
;225:			|| check->r.absmax[2] <= mins[2] ) {
line 226
;226:				continue;
ADDRGP4 $132
JUMPV
LABELV $139
line 230
;227:			}
;228:			// see if the ent's bbox is inside the pusher's final position
;229:			// this does allow a fast moving object to pass through a thin entity...
;230:			if (!G_TestEntityPosition (check)) {
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 4216
ADDRGP4 G_TestEntityPosition
CALLP4
ASGNP4
ADDRLP4 4216
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $150
line 231
;231:				continue;
ADDRGP4 $132
JUMPV
LABELV $150
line 233
;232:			}
;233:		}
LABELV $137
line 236
;234:
;235:		// the entity needs to be pushed
;236:		if ( G_TryPushingEntity( check, pusher, move, amove ) ) {
ADDRLP4 8
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4212
ADDRGP4 G_TryPushingEntity
CALLI4
ASGNI4
ADDRLP4 4212
INDIRI4
CNSTI4 0
EQI4 $152
line 237
;237:			continue;
ADDRGP4 $132
JUMPV
LABELV $152
line 243
;238:		}
;239:
;240:		// the move was blocked an entity
;241:
;242:		// bobbing entities are instant-kill and never get blocked
;243:		if ( pusher->s.pos.trType == TR_SINE || pusher->s.apos.trType == TR_SINE ) {
ADDRLP4 4216
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4220
CNSTI4 4
ASGNI4
ADDRLP4 4216
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ADDRLP4 4220
INDIRI4
EQI4 $156
ADDRLP4 4216
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
ADDRLP4 4220
INDIRI4
NEI4 $154
LABELV $156
line 244
;244:			G_Damage( check, pusher, pusher, NULL, NULL, 99999, 0, MOD_CRUSH );
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 4224
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4224
INDIRP4
ARGP4
ADDRLP4 4224
INDIRP4
ARGP4
ADDRLP4 4228
CNSTP4 0
ASGNP4
ADDRLP4 4228
INDIRP4
ARGP4
ADDRLP4 4228
INDIRP4
ARGP4
CNSTI4 99999
ARGI4
CNSTI4 0
ARGI4
CNSTI4 17
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 245
;245:			continue;
ADDRGP4 $132
JUMPV
LABELV $154
line 250
;246:		}
;247:
;248:		
;249:		// save off the obstacle so we can call the block function (crush, etc)
;250:		*obstacle = check;
ADDRFP4 12
INDIRP4
ADDRLP4 8
INDIRP4
ASGNP4
line 255
;251:
;252:		// move back any entities we already moved
;253:		// go backwards, so if the same entity was pushed
;254:		// twice, it goes back to the original position
;255:		for ( p=pushed_p-1 ; p>=pushed ; p-- ) {
ADDRLP4 0
ADDRGP4 pushed_p
INDIRP4
CNSTI4 -32
ADDP4
ASGNP4
ADDRGP4 $160
JUMPV
LABELV $157
line 256
;256:			VectorCopy (p->origin, p->ent->s.pos.trBase);
ADDRLP4 0
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRB
ASGNB 12
line 257
;257:			VectorCopy (p->angles, p->ent->s.apos.trBase);
ADDRLP4 0
INDIRP4
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRB
ASGNB 12
line 258
;258:			if ( p->ent->client ) {
ADDRLP4 0
INDIRP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $161
line 259
;259:				p->ent->client->ps.delta_angles[YAW] = p->deltayaw;
ADDRLP4 0
INDIRP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CVFI4 4
ASGNI4
line 260
;260:				VectorCopy (p->origin, p->ent->client->ps.origin);
ADDRLP4 0
INDIRP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRB
ASGNB 12
line 261
;261:			}
LABELV $161
line 262
;262:			trap_LinkEntity (p->ent);
ADDRLP4 0
INDIRP4
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 263
;263:		}
LABELV $158
line 255
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 -32
ADDP4
ASGNP4
LABELV $160
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 pushed
CVPU4 4
GEU4 $157
line 264
;264:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $109
JUMPV
LABELV $132
line 209
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $134
ADDRLP4 12
INDIRI4
ADDRLP4 4136
INDIRI4
LTI4 $131
line 267
;265:	}
;266:
;267:	return qtrue;
CNSTI4 1
RETI4
LABELV $109
endproc G_MoverPush 4240 32
export G_MoverTeam
proc G_MoverTeam 72 16
line 276
;268:}
;269:
;270:
;271:/*
;272:=================
;273:G_MoverTeam
;274:=================
;275:*/
;276:void G_MoverTeam( gentity_t *ent ) {
line 281
;277:	vec3_t		move, amove;
;278:	gentity_t	*part, *obstacle;
;279:	vec3_t		origin, angles;
;280:
;281:	obstacle = NULL;
ADDRLP4 52
CNSTP4 0
ASGNP4
line 286
;282:
;283:	// make sure all team slaves can move before commiting
;284:	// any moves or calling any think functions
;285:	// if the move is blocked, all moved objects will be backed out
;286:	pushed_p = pushed;
ADDRGP4 pushed_p
ADDRGP4 pushed
ASGNP4
line 287
;287:	for (part = ent ; part ; part=part->teamchain) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $167
JUMPV
LABELV $164
line 289
;288:		// get current position
;289:		BG_EvaluateTrajectory( &part->s.pos, level.time, origin );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 28
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 290
;290:		BG_EvaluateTrajectory( &part->s.apos, level.time, angles );
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 40
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 291
;291:		VectorSubtract( origin, part->r.currentOrigin, move );
ADDRLP4 4
ADDRLP4 28
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 28+4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 28+8
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
SUBF4
ASGNF4
line 292
;292:		VectorSubtract( angles, part->r.currentAngles, amove );
ADDRLP4 16
ADDRLP4 40
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 488
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 40+4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 492
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+8
ADDRLP4 40+8
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 496
ADDP4
INDIRF4
SUBF4
ASGNF4
line 293
;293:		if ( !G_MoverPush( part, move, amove, &obstacle ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 52
ARGP4
ADDRLP4 64
ADDRGP4 G_MoverPush
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
NEI4 $178
line 294
;294:			break;	// move was blocked
ADDRGP4 $166
JUMPV
LABELV $178
line 296
;295:		}
;296:	}
LABELV $165
line 287
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
LABELV $167
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $164
LABELV $166
line 298
;297:
;298:	if (part) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $180
line 300
;299:		// go back to the previous position
;300:		for ( part = ent ; part ; part = part->teamchain ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $185
JUMPV
LABELV $182
line 301
;301:			part->s.pos.trTime += level.time - level.previousTime;
ADDRLP4 56
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRI4
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+36
INDIRI4
SUBI4
ADDI4
ASGNI4
line 302
;302:			part->s.apos.trTime += level.time - level.previousTime;
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRI4
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+36
INDIRI4
SUBI4
ADDI4
ASGNI4
line 303
;303:			BG_EvaluateTrajectory( &part->s.pos, level.time, part->r.currentOrigin );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 304
;304:			BG_EvaluateTrajectory( &part->s.apos, level.time, part->r.currentAngles );
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 488
ADDP4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 305
;305:			trap_LinkEntity( part );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 306
;306:		}
LABELV $183
line 300
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
LABELV $185
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $182
line 309
;307:
;308:		// if the pusher has a "blocked" function, call it
;309:		if (ent->blocked) {
ADDRFP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $163
line 310
;310:			ent->blocked( ent, obstacle );
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
CNSTI4 680
ADDP4
INDIRP4
CALLV
pop
line 311
;311:		}
line 312
;312:		return;
ADDRGP4 $163
JUMPV
LABELV $180
line 316
;313:	}
;314:
;315:	// the move succeeded
;316:	for ( part = ent ; part ; part = part->teamchain ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $197
JUMPV
LABELV $194
line 318
;317:		// call the reached function if time is at or past end point
;318:		if ( part->s.pos.trType == TR_LINEAR_STOP ) {
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 3
NEI4 $198
line 319
;319:			if ( level.time >= part->s.pos.trTime + part->s.pos.trDuration ) {
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDI4
LTI4 $200
line 320
;320:				if ( part->reached ) {
ADDRLP4 0
INDIRP4
CNSTI4 676
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $203
line 321
;321:					part->reached( part );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 676
ADDP4
INDIRP4
CALLV
pop
line 322
;322:				}
LABELV $203
line 323
;323:			}
LABELV $200
line 324
;324:		}
LABELV $198
line 325
;325:	}
LABELV $195
line 316
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
LABELV $197
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $194
line 326
;326:}
LABELV $163
endproc G_MoverTeam 72 16
export G_RunMover
proc G_RunMover 8 4
line 334
;327:
;328:/*
;329:================
;330:G_RunMover
;331:
;332:================
;333:*/
;334:void G_RunMover( gentity_t *ent ) {
line 337
;335:	// if not a team captain, don't do anything, because
;336:	// the captain will handle everything
;337:	if ( ent->flags & FL_TEAMSLAVE ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
EQI4 $206
line 338
;338:		return;
ADDRGP4 $205
JUMPV
LABELV $206
line 342
;339:	}
;340:
;341:	// if stationary at one of the positions, don't move anything
;342:	if ( ent->s.pos.trType != TR_STATIONARY || ent->s.apos.trType != TR_STATIONARY ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $210
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $208
LABELV $210
line 343
;343:		G_MoverTeam( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_MoverTeam
CALLV
pop
line 344
;344:	}
LABELV $208
line 347
;345:
;346:	// check think function
;347:	G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 348
;348:}
LABELV $205
endproc G_RunMover 8 4
export SetMoverState
proc SetMoverState 56 12
line 365
;349:
;350:/*
;351:============================================================================
;352:
;353:GENERAL MOVERS
;354:
;355:Doors, plats, and buttons are all binary (two position) movers
;356:Pos1 is "at rest", pos2 is "activated"
;357:============================================================================
;358:*/
;359:
;360:/*
;361:===============
;362:SetMoverState
;363:===============
;364:*/
;365:void SetMoverState( gentity_t *ent, moverState_t moverState, int time ) {
line 369
;366:	vec3_t			delta;
;367:	float			f;
;368:
;369:	ent->moverState = moverState;
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
ADDRFP4 4
INDIRI4
ASGNI4
line 371
;370:
;371:	ent->s.pos.trTime = time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 372
;372:	switch( moverState ) {
ADDRLP4 16
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
LTI4 $212
ADDRLP4 16
INDIRI4
CNSTI4 3
GTI4 $212
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $227
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $227
address $215
address $216
address $217
address $222
code
LABELV $215
line 374
;373:	case MOVER_POS1:
;374:		VectorCopy( ent->pos1, ent->s.pos.trBase );
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 24
INDIRP4
CNSTI4 600
ADDP4
INDIRB
ASGNB 12
line 375
;375:		ent->s.pos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 376
;376:		break;
ADDRGP4 $213
JUMPV
LABELV $216
line 378
;377:	case MOVER_POS2:
;378:		VectorCopy( ent->pos2, ent->s.pos.trBase );
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 28
INDIRP4
CNSTI4 612
ADDP4
INDIRB
ASGNB 12
line 379
;379:		ent->s.pos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 380
;380:		break;
ADDRGP4 $213
JUMPV
LABELV $217
line 382
;381:	case MOVER_1TO2:
;382:		VectorCopy( ent->pos1, ent->s.pos.trBase );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 32
INDIRP4
CNSTI4 600
ADDP4
INDIRB
ASGNB 12
line 383
;383:		VectorSubtract( ent->pos2, ent->pos1, delta );
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 36
INDIRP4
CNSTI4 612
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 36
INDIRP4
CNSTI4 616
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 40
INDIRP4
CNSTI4 620
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
SUBF4
ASGNF4
line 384
;384:		f = 1000.0 / ent->s.pos.trDuration;
ADDRLP4 12
CNSTF4 1148846080
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CVIF4 4
DIVF4
ASGNF4
line 385
;385:		VectorScale( delta, f, ent->s.pos.trDelta );
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
line 386
;386:		ent->s.pos.trType = TR_LINEAR_STOP;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 3
ASGNI4
line 387
;387:		break;
ADDRGP4 $213
JUMPV
LABELV $222
line 389
;388:	case MOVER_2TO1:
;389:		VectorCopy( ent->pos2, ent->s.pos.trBase );
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 44
INDIRP4
CNSTI4 612
ADDP4
INDIRB
ASGNB 12
line 390
;390:		VectorSubtract( ent->pos1, ent->pos2, delta );
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 48
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
ADDRLP4 48
INDIRP4
CNSTI4 612
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 48
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
ADDRLP4 48
INDIRP4
CNSTI4 616
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 52
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
ADDRLP4 52
INDIRP4
CNSTI4 620
ADDP4
INDIRF4
SUBF4
ASGNF4
line 391
;391:		f = 1000.0 / ent->s.pos.trDuration;
ADDRLP4 12
CNSTF4 1148846080
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CVIF4 4
DIVF4
ASGNF4
line 392
;392:		VectorScale( delta, f, ent->s.pos.trDelta );
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
line 393
;393:		ent->s.pos.trType = TR_LINEAR_STOP;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 3
ASGNI4
line 394
;394:		break;
LABELV $212
LABELV $213
line 396
;395:	}
;396:	BG_EvaluateTrajectory( &ent->s.pos, level.time, ent->r.currentOrigin );	
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 24
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 397
;397:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 398
;398:}
LABELV $211
endproc SetMoverState 56 12
export MatchTeam
proc MatchTeam 4 12
line 408
;399:
;400:/*
;401:================
;402:MatchTeam
;403:
;404:All entities in a mover team will move from pos1 to pos2
;405:in the same amount of time
;406:================
;407:*/
;408:void MatchTeam( gentity_t *teamLeader, int moverState, int time ) {
line 411
;409:	gentity_t		*slave;
;410:
;411:	for ( slave = teamLeader ; slave ; slave = slave->teamchain ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $233
JUMPV
LABELV $230
line 412
;412:		SetMoverState( slave, moverState, time );
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 SetMoverState
CALLV
pop
line 413
;413:	}
LABELV $231
line 411
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
LABELV $233
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $230
line 414
;414:}
LABELV $229
endproc MatchTeam 4 12
export ReturnToPos1
proc ReturnToPos1 8 12
line 423
;415:
;416:
;417:
;418:/*
;419:================
;420:ReturnToPos1
;421:================
;422:*/
;423:void ReturnToPos1( gentity_t *ent ) {
line 424
;424:	MatchTeam( ent, MOVER_2TO1, level.time );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 MatchTeam
CALLV
pop
line 427
;425:
;426:	// looping sound
;427:	ent->s.loopSound = ent->soundLoop;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 156
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
line 430
;428:
;429:	// starting sound
;430:	if ( ent->sound2to1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
CNSTI4 0
EQI4 $236
line 431
;431:		G_AddEvent( ent, EV_GENERAL_SOUND, ent->sound2to1 );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 432
;432:	}
LABELV $236
line 433
;433:}
LABELV $234
endproc ReturnToPos1 8 12
export Reached_BinaryMover
proc Reached_BinaryMover 12 12
line 441
;434:
;435:
;436:/*
;437:================
;438:Reached_BinaryMover
;439:================
;440:*/
;441:void Reached_BinaryMover( gentity_t *ent ) {
line 444
;442:
;443:	// stop the looping sound
;444:	ent->s.loopSound = ent->soundLoop;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 156
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
line 446
;445:
;446:	if ( ent->moverState == MOVER_1TO2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 2
NEI4 $239
line 448
;447:		// reached pos2
;448:		SetMoverState( ent, MOVER_POS2, level.time );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 SetMoverState
CALLV
pop
line 451
;449:
;450:		// play sound
;451:		if ( ent->soundPos2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 580
ADDP4
INDIRI4
CNSTI4 0
EQI4 $242
line 452
;452:			G_AddEvent( ent, EV_GENERAL_SOUND, ent->soundPos2 );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 580
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 453
;453:		}
LABELV $242
line 456
;454:
;455:		// return to pos1 after a delay
;456:		ent->think = ReturnToPos1;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 ReturnToPos1
ASGNP4
line 457
;457:		ent->nextthink = level.time + ent->wait;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ADDRLP4 4
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 460
;458:
;459:		// fire targets
;460:		if ( !ent->activator ) {
ADDRFP4 0
INDIRP4
CNSTI4 752
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $245
line 461
;461:			ent->activator = ent;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 752
ADDP4
ADDRLP4 8
INDIRP4
ASGNP4
line 462
;462:		}
LABELV $245
line 463
;463:		G_UseTargets( ent, ent->activator );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 752
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 464
;464:	} else if ( ent->moverState == MOVER_2TO1 ) {
ADDRGP4 $240
JUMPV
LABELV $239
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 3
NEI4 $247
line 466
;465:		// reached pos1
;466:		SetMoverState( ent, MOVER_POS1, level.time );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 SetMoverState
CALLV
pop
line 469
;467:
;468:		// play sound
;469:		if ( ent->soundPos1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 568
ADDP4
INDIRI4
CNSTI4 0
EQI4 $250
line 470
;470:			G_AddEvent( ent, EV_GENERAL_SOUND, ent->soundPos1 );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 568
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 471
;471:		}
LABELV $250
line 474
;472:
;473:		// close areaportals
;474:		if ( ent->teammaster == ent || !ent->teammaster ) {
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
ADDRLP4 4
INDIRP4
CNSTI4 760
ADDP4
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 8
INDIRU4
ADDRLP4 4
INDIRP4
CVPU4 4
EQU4 $254
ADDRLP4 8
INDIRU4
CNSTU4 0
NEU4 $248
LABELV $254
line 475
;475:			trap_AdjustAreaPortalState( ent, qfalse );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_AdjustAreaPortalState
CALLV
pop
line 476
;476:		}
line 477
;477:	} else {
ADDRGP4 $248
JUMPV
LABELV $247
line 478
;478:		G_Error( "Reached_BinaryMover: bad moverState" );
ADDRGP4 $255
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 479
;479:	}
LABELV $248
LABELV $240
line 480
;480:}
LABELV $238
endproc Reached_BinaryMover 12 12
export Use_BinaryMover
proc Use_BinaryMover 20 12
line 488
;481:
;482:
;483:/*
;484:================
;485:Use_BinaryMover
;486:================
;487:*/
;488:void Use_BinaryMover( gentity_t *ent, gentity_t *other, gentity_t *activator ) {
line 493
;489:	int		total;
;490:	int		partial;
;491:
;492:	// only the master should be used
;493:	if ( ent->flags & FL_TEAMSLAVE ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
EQI4 $257
line 494
;494:		Use_BinaryMover( ent->teammaster, other, activator );
ADDRFP4 0
INDIRP4
CNSTI4 760
ADDP4
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Use_BinaryMover
CALLV
pop
line 495
;495:		return;
ADDRGP4 $256
JUMPV
LABELV $257
line 498
;496:	}
;497:
;498:	ent->activator = activator;
ADDRFP4 0
INDIRP4
CNSTI4 752
ADDP4
ADDRFP4 8
INDIRP4
ASGNP4
line 500
;499:
;500:	if ( ent->moverState == MOVER_POS1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 0
NEI4 $259
line 503
;501:		// start moving 50 msec later, becase if this was player
;502:		// triggered, level.time hasn't been advanced yet
;503:		MatchTeam( ent, MOVER_1TO2, level.time + 50 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 level+32
INDIRI4
CNSTI4 50
ADDI4
ARGI4
ADDRGP4 MatchTeam
CALLV
pop
line 506
;504:
;505:		// starting sound
;506:		if ( ent->sound1to2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 572
ADDP4
INDIRI4
CNSTI4 0
EQI4 $262
line 507
;507:			G_AddEvent( ent, EV_GENERAL_SOUND, ent->sound1to2 );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 572
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 508
;508:		}
LABELV $262
line 511
;509:
;510:		// looping sound
;511:		ent->s.loopSound = ent->soundLoop;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 156
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
line 514
;512:
;513:		// open areaportal
;514:		if ( ent->teammaster == ent || !ent->teammaster ) {
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 12
INDIRP4
CNSTI4 760
ADDP4
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 16
INDIRU4
ADDRLP4 12
INDIRP4
CVPU4 4
EQU4 $266
ADDRLP4 16
INDIRU4
CNSTU4 0
NEU4 $256
LABELV $266
line 515
;515:			trap_AdjustAreaPortalState( ent, qtrue );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 trap_AdjustAreaPortalState
CALLV
pop
line 516
;516:		}
line 517
;517:		return;
ADDRGP4 $256
JUMPV
LABELV $259
line 521
;518:	}
;519:
;520:	// if all the way up, just delay before coming down
;521:	if ( ent->moverState == MOVER_POS2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 1
NEI4 $267
line 522
;522:		ent->nextthink = level.time + ent->wait;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ADDRLP4 8
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 523
;523:		return;
ADDRGP4 $256
JUMPV
LABELV $267
line 527
;524:	}
;525:
;526:	// only partway down before reversing
;527:	if ( ent->moverState == MOVER_2TO1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 3
NEI4 $270
line 528
;528:		total = ent->s.pos.trDuration;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
line 529
;529:		partial = level.time - ent->s.time;
ADDRLP4 4
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
SUBI4
ASGNI4
line 530
;530:		if ( partial > total ) {
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
LEI4 $273
line 531
;531:			partial = total;
ADDRLP4 4
ADDRLP4 0
INDIRI4
ASGNI4
line 532
;532:		}
LABELV $273
line 534
;533:
;534:		MatchTeam( ent, MOVER_1TO2, level.time - ( total - partial ) );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
SUBI4
SUBI4
ARGI4
ADDRGP4 MatchTeam
CALLV
pop
line 536
;535:
;536:		if ( ent->sound1to2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 572
ADDP4
INDIRI4
CNSTI4 0
EQI4 $256
line 537
;537:			G_AddEvent( ent, EV_GENERAL_SOUND, ent->sound1to2 );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 572
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 538
;538:		}
line 539
;539:		return;
ADDRGP4 $256
JUMPV
LABELV $270
line 543
;540:	}
;541:
;542:	// only partway up before reversing
;543:	if ( ent->moverState == MOVER_1TO2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 2
NEI4 $278
line 544
;544:		total = ent->s.pos.trDuration;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
line 545
;545:		partial = level.time - ent->s.time;
ADDRLP4 4
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
SUBI4
ASGNI4
line 546
;546:		if ( partial > total ) {
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
LEI4 $281
line 547
;547:			partial = total;
ADDRLP4 4
ADDRLP4 0
INDIRI4
ASGNI4
line 548
;548:		}
LABELV $281
line 550
;549:
;550:		MatchTeam( ent, MOVER_2TO1, level.time - ( total - partial ) );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
SUBI4
SUBI4
ARGI4
ADDRGP4 MatchTeam
CALLV
pop
line 552
;551:
;552:		if ( ent->sound2to1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
CNSTI4 0
EQI4 $256
line 553
;553:			G_AddEvent( ent, EV_GENERAL_SOUND, ent->sound2to1 );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
CNSTI4 45
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 554
;554:		}
line 555
;555:		return;
LABELV $278
line 557
;556:	}
;557:}
LABELV $256
endproc Use_BinaryMover 20 12
export InitMover
proc InitMover 100 12
line 569
;558:
;559:
;560:
;561:/*
;562:================
;563:InitMover
;564:
;565:"pos1", "pos2", and "speed" should be set before calling,
;566:so the movement delta can be calculated
;567:================
;568:*/
;569:void InitMover( gentity_t *ent ) {
line 579
;570:	vec3_t		move;
;571:	float		distance;
;572:	float		light;
;573:	vec3_t		color;
;574:	qboolean	lightSet, colorSet;
;575:	char		*sound;
;576:
;577:	// if the "model2" key is set, use a seperate model
;578:	// for drawing, but clip against the brushes
;579:	if ( ent->model2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 532
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $287
line 580
;580:		ent->s.modelindex2 = G_ModelIndex( ent->model2 );
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 532
ADDP4
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 G_ModelIndex
CALLI4
ASGNI4
ADDRLP4 44
INDIRP4
CNSTI4 164
ADDP4
ADDRLP4 48
INDIRI4
ASGNI4
line 581
;581:	}
LABELV $287
line 584
;582:
;583:	// if the "loopsound" key is set, use a constant looping sound when moving
;584:	if ( G_SpawnString( "noise", "100", &sound ) ) {
ADDRGP4 $291
ARGP4
ADDRGP4 $292
ARGP4
ADDRLP4 40
ARGP4
ADDRLP4 44
ADDRGP4 G_SpawnString
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
EQI4 $289
line 585
;585:		ent->s.loopSound = G_SoundIndex( sound );
ADDRLP4 40
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 156
ADDP4
ADDRLP4 48
INDIRI4
ASGNI4
line 586
;586:	}
LABELV $289
line 589
;587:
;588:	// if the "color" or "light" keys are set, setup constantLight
;589:	lightSet = G_SpawnFloat( "light", "100", &light );
ADDRGP4 $293
ARGP4
ADDRGP4 $292
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 48
ADDRGP4 G_SpawnFloat
CALLI4
ASGNI4
ADDRLP4 28
ADDRLP4 48
INDIRI4
ASGNI4
line 590
;590:	colorSet = G_SpawnVector( "color", "1 1 1", color );
ADDRGP4 $294
ARGP4
ADDRGP4 $295
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 52
ADDRGP4 G_SpawnVector
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 52
INDIRI4
ASGNI4
line 591
;591:	if ( lightSet || colorSet ) {
ADDRLP4 56
CNSTI4 0
ASGNI4
ADDRLP4 28
INDIRI4
ADDRLP4 56
INDIRI4
NEI4 $298
ADDRLP4 32
INDIRI4
ADDRLP4 56
INDIRI4
EQI4 $296
LABELV $298
line 594
;592:		int		r, g, b, i;
;593:
;594:		r = color[0] * 255;
ADDRLP4 60
CNSTF4 1132396544
ADDRLP4 12
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 595
;595:		if ( r > 255 ) {
ADDRLP4 60
INDIRI4
CNSTI4 255
LEI4 $299
line 596
;596:			r = 255;
ADDRLP4 60
CNSTI4 255
ASGNI4
line 597
;597:		}
LABELV $299
line 598
;598:		g = color[1] * 255;
ADDRLP4 64
CNSTF4 1132396544
ADDRLP4 12+4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 599
;599:		if ( g > 255 ) {
ADDRLP4 64
INDIRI4
CNSTI4 255
LEI4 $302
line 600
;600:			g = 255;
ADDRLP4 64
CNSTI4 255
ASGNI4
line 601
;601:		}
LABELV $302
line 602
;602:		b = color[2] * 255;
ADDRLP4 68
CNSTF4 1132396544
ADDRLP4 12+8
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 603
;603:		if ( b > 255 ) {
ADDRLP4 68
INDIRI4
CNSTI4 255
LEI4 $305
line 604
;604:			b = 255;
ADDRLP4 68
CNSTI4 255
ASGNI4
line 605
;605:		}
LABELV $305
line 606
;606:		i = light / 4;
ADDRLP4 72
ADDRLP4 36
INDIRF4
CNSTF4 1082130432
DIVF4
CVFI4 4
ASGNI4
line 607
;607:		if ( i > 255 ) {
ADDRLP4 72
INDIRI4
CNSTI4 255
LEI4 $307
line 608
;608:			i = 255;
ADDRLP4 72
CNSTI4 255
ASGNI4
line 609
;609:		}
LABELV $307
line 610
;610:		ent->s.constantLight = r | ( g << 8 ) | ( b << 16 ) | ( i << 24 );
ADDRFP4 0
INDIRP4
CNSTI4 152
ADDP4
ADDRLP4 60
INDIRI4
ADDRLP4 64
INDIRI4
CNSTI4 8
LSHI4
BORI4
ADDRLP4 68
INDIRI4
CNSTI4 16
LSHI4
BORI4
ADDRLP4 72
INDIRI4
CNSTI4 24
LSHI4
BORI4
ASGNI4
line 611
;611:	}
LABELV $296
line 614
;612:
;613:
;614:	ent->use = Use_BinaryMover;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ADDRGP4 Use_BinaryMover
ASGNP4
line 615
;615:	ent->reached = Reached_BinaryMover;
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
ADDRGP4 Reached_BinaryMover
ASGNP4
line 617
;616:
;617:	ent->moverState = MOVER_POS1;
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
CNSTI4 0
ASGNI4
line 618
;618:	ent->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 128
ASGNI4
line 619
;619:	ent->s.eType = ET_MOVER;
ADDRLP4 60
CNSTI4 4
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
ADDRLP4 60
INDIRI4
ASGNI4
line 620
;620:	VectorCopy (ent->pos1, ent->r.currentOrigin);
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 64
INDIRP4
CNSTI4 600
ADDP4
INDIRB
ASGNB 12
line 621
;621:	trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 623
;622:
;623:	ent->s.pos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 624
;624:	VectorCopy( ent->pos1, ent->s.pos.trBase );
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 68
INDIRP4
CNSTI4 600
ADDP4
INDIRB
ASGNB 12
line 627
;625:
;626:	// calculate time to reach second position from speed
;627:	VectorSubtract( ent->pos2, ent->pos1, move );
ADDRLP4 72
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 72
INDIRP4
CNSTI4 612
ADDP4
INDIRF4
ADDRLP4 72
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 72
INDIRP4
CNSTI4 616
ADDP4
INDIRF4
ADDRLP4 72
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 76
INDIRP4
CNSTI4 620
ADDP4
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
SUBF4
ASGNF4
line 628
;628:	distance = VectorLength( move );
ADDRLP4 0
ARGP4
ADDRLP4 80
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 80
INDIRF4
ASGNF4
line 629
;629:	if ( ! ent->speed ) {
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
NEF4 $311
line 630
;630:		ent->speed = 100;
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
CNSTF4 1120403456
ASGNF4
line 631
;631:	}
LABELV $311
line 632
;632:	VectorScale( move, ent->speed, ent->s.pos.trDelta );
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ADDRLP4 84
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 88
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 92
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
ASGNF4
line 633
;633:	ent->s.pos.trDuration = distance * 1000 / ent->speed;
ADDRLP4 96
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
CNSTI4 20
ADDP4
CNSTF4 1148846080
ADDRLP4 24
INDIRF4
MULF4
ADDRLP4 96
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
DIVF4
CVFI4 4
ASGNI4
line 634
;634:	if ( ent->s.pos.trDuration <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CNSTI4 0
GTI4 $315
line 635
;635:		ent->s.pos.trDuration = 1;
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
CNSTI4 1
ASGNI4
line 636
;636:	}
LABELV $315
line 637
;637:}
LABELV $286
endproc InitMover 100 12
export Blocked_Door
proc Blocked_Door 8 32
line 656
;638:
;639:
;640:/*
;641:===============================================================================
;642:
;643:DOOR
;644:
;645:A use can be triggered either by a touch function, by being shot, or by being
;646:targeted by another entity.
;647:
;648:===============================================================================
;649:*/
;650:
;651:/*
;652:================
;653:Blocked_Door
;654:================
;655:*/
;656:void Blocked_Door( gentity_t *ent, gentity_t *other ) {
line 658
;657:	// remove anything other than a client
;658:	if ( !other->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $318
line 660
;659:		// except CTF flags!!!!
;660:		if( other->s.eType == ET_ITEM && other->item->giType == IT_TEAM ) {
ADDRLP4 0
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $320
ADDRLP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 7
NEI4 $320
line 661
;661:			Team_DroppedFlagThink( other );
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Team_DroppedFlagThink
CALLV
pop
line 662
;662:			return;
ADDRGP4 $317
JUMPV
LABELV $320
line 664
;663:		}
;664:		G_TempEntity( other->s.origin, EV_ITEM_POP );
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
ARGP4
CNSTI4 41
ARGI4
ADDRGP4 G_TempEntity
CALLP4
pop
line 665
;665:		G_FreeEntity( other );
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 666
;666:		return;
ADDRGP4 $317
JUMPV
LABELV $318
line 669
;667:	}
;668:
;669:	if ( ent->damage ) {
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
CNSTI4 0
EQI4 $322
line 670
;670:		G_Damage( other, ent, ent, NULL, NULL, ent->damage, 0, MOD_CRUSH );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
CNSTP4 0
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 17
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 671
;671:	}
LABELV $322
line 672
;672:	if ( ent->spawnflags & 4 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $324
line 673
;673:		return;		// crushers don't reverse
ADDRGP4 $317
JUMPV
LABELV $324
line 677
;674:	}
;675:
;676:	// reverse direction
;677:	Use_BinaryMover( ent, ent, other );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Use_BinaryMover
CALLV
pop
line 678
;678:}
LABELV $317
endproc Blocked_Door 8 32
proc Touch_DoorTriggerSpectator 72 12
line 685
;679:
;680:/*
;681:================
;682:Touch_DoorTriggerSpectator
;683:================
;684:*/
;685:static void Touch_DoorTriggerSpectator( gentity_t *ent, gentity_t *other, trace_t *trace ) {
line 689
;686:	int i, axis;
;687:	vec3_t origin, dir, angles;
;688:
;689:	axis = ent->count;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
ASGNI4
line 690
;690:	VectorClear(dir);
ADDRLP4 44
CNSTF4 0
ASGNF4
ADDRLP4 20+8
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 20+4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 20
ADDRLP4 44
INDIRF4
ASGNF4
line 691
;691:	if (fabs(other->s.origin[axis] - ent->r.absmax[axis]) <
ADDRLP4 48
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 48
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
ADDP4
INDIRF4
ADDRLP4 48
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 464
ADDP4
ADDP4
INDIRF4
SUBF4
ARGF4
ADDRLP4 52
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 56
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 56
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
ADDP4
INDIRF4
ADDRLP4 56
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
ADDP4
INDIRF4
SUBF4
ARGF4
ADDRLP4 60
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 52
INDIRF4
ADDRLP4 60
INDIRF4
GEF4 $329
line 692
;692:		fabs(other->s.origin[axis] - ent->r.absmin[axis])) {
line 693
;693:		origin[axis] = ent->r.absmin[axis] - 10;
ADDRLP4 64
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 64
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 64
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
ADDP4
INDIRF4
CNSTF4 1092616192
SUBF4
ASGNF4
line 694
;694:		dir[axis] = -1;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 20
ADDP4
CNSTF4 3212836864
ASGNF4
line 695
;695:	}
ADDRGP4 $330
JUMPV
LABELV $329
line 696
;696:	else {
line 697
;697:		origin[axis] = ent->r.absmax[axis] + 10;
ADDRLP4 64
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 64
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 64
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 464
ADDP4
ADDP4
INDIRF4
CNSTF4 1092616192
ADDF4
ASGNF4
line 698
;698:		dir[axis] = 1;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 20
ADDP4
CNSTF4 1065353216
ASGNF4
line 699
;699:	}
LABELV $330
line 700
;700:	for (i = 0; i < 3; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $331
line 701
;701:		if (i == axis) continue;
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $335
ADDRGP4 $332
JUMPV
LABELV $335
line 702
;702:		origin[i] = (ent->r.absmin[i] + ent->r.absmax[i]) * 0.5;
ADDRLP4 64
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRI4
ADDRLP4 8
ADDP4
CNSTF4 1056964608
ADDRLP4 64
INDIRI4
ADDRLP4 68
INDIRP4
CNSTI4 452
ADDP4
ADDP4
INDIRF4
ADDRLP4 64
INDIRI4
ADDRLP4 68
INDIRP4
CNSTI4 464
ADDP4
ADDP4
INDIRF4
ADDF4
MULF4
ASGNF4
line 703
;703:	}
LABELV $332
line 700
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $331
line 704
;704:	vectoangles(dir, angles);
ADDRLP4 20
ARGP4
ADDRLP4 32
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 705
;705:	TeleportPlayer(other, origin, angles );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 32
ARGP4
ADDRGP4 TeleportPlayer
CALLV
pop
line 706
;706:}
LABELV $326
endproc Touch_DoorTriggerSpectator 72 12
export Touch_DoorTrigger
proc Touch_DoorTrigger 8 12
line 713
;707:
;708:/*
;709:================
;710:Touch_DoorTrigger
;711:================
;712:*/
;713:void Touch_DoorTrigger( gentity_t *ent, gentity_t *other, trace_t *trace ) {
line 714
;714:	if ( other->client && other->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $338
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $338
line 716
;715:		// if the door is not open and not opening
;716:		if ( ent->parent->moverState != MOVER_1TO2 &&
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 2
EQI4 $339
ADDRLP4 4
INDIRI4
CNSTI4 1
EQI4 $339
line 717
;717:			ent->parent->moverState != MOVER_POS2) {
line 718
;718:			Touch_DoorTriggerSpectator( ent, other, trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Touch_DoorTriggerSpectator
CALLV
pop
line 719
;719:		}
line 720
;720:	}
ADDRGP4 $339
JUMPV
LABELV $338
line 721
;721:	else if ( ent->parent->moverState != MOVER_1TO2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 2
EQI4 $342
line 722
;722:		Use_BinaryMover( ent->parent, ent, other );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Use_BinaryMover
CALLV
pop
line 723
;723:	}
LABELV $342
LABELV $339
line 724
;724:}
LABELV $337
endproc Touch_DoorTrigger 8 12
export Think_SpawnNewDoorTrigger
proc Think_SpawnNewDoorTrigger 52 12
line 735
;725:
;726:
;727:/*
;728:======================
;729:Think_SpawnNewDoorTrigger
;730:
;731:All of the parts of a door have been spawned, so create
;732:a trigger that encloses all of them
;733:======================
;734:*/
;735:void Think_SpawnNewDoorTrigger( gentity_t *ent ) {
line 741
;736:	gentity_t		*other;
;737:	vec3_t		mins, maxs;
;738:	int			i, best;
;739:
;740:	// set all of the slaves as shootable
;741:	for ( other = ent ; other ; other = other->teamchain ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $348
JUMPV
LABELV $345
line 742
;742:		other->takedamage = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 1
ASGNI4
line 743
;743:	}
LABELV $346
line 741
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
LABELV $348
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $345
line 746
;744:
;745:	// find the bounds of everything on the team
;746:	VectorCopy (ent->r.absmin, mins);
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
INDIRB
ASGNB 12
line 747
;747:	VectorCopy (ent->r.absmax, maxs);
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 464
ADDP4
INDIRB
ASGNB 12
line 749
;748:
;749:	for (other = ent->teamchain ; other ; other=other->teamchain) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
ADDRGP4 $352
JUMPV
LABELV $349
line 750
;750:		AddPointToBounds (other->r.absmin, mins, maxs);
ADDRLP4 0
INDIRP4
CNSTI4 452
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 AddPointToBounds
CALLV
pop
line 751
;751:		AddPointToBounds (other->r.absmax, mins, maxs);
ADDRLP4 0
INDIRP4
CNSTI4 464
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 AddPointToBounds
CALLV
pop
line 752
;752:	}
LABELV $350
line 749
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
LABELV $352
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $349
line 755
;753:
;754:	// find the thinnest axis, which will be the one we expand
;755:	best = 0;
ADDRLP4 32
CNSTI4 0
ASGNI4
line 756
;756:	for ( i = 1 ; i < 3 ; i++ ) {
ADDRLP4 4
CNSTI4 1
ASGNI4
LABELV $353
line 757
;757:		if ( maxs[i] - mins[i] < maxs[best] - mins[best] ) {
ADDRLP4 36
CNSTI4 2
ASGNI4
ADDRLP4 40
ADDRLP4 4
INDIRI4
ADDRLP4 36
INDIRI4
LSHI4
ASGNI4
ADDRLP4 44
ADDRLP4 32
INDIRI4
ADDRLP4 36
INDIRI4
LSHI4
ASGNI4
ADDRLP4 40
INDIRI4
ADDRLP4 20
ADDP4
INDIRF4
ADDRLP4 40
INDIRI4
ADDRLP4 8
ADDP4
INDIRF4
SUBF4
ADDRLP4 44
INDIRI4
ADDRLP4 20
ADDP4
INDIRF4
ADDRLP4 44
INDIRI4
ADDRLP4 8
ADDP4
INDIRF4
SUBF4
GEF4 $357
line 758
;758:			best = i;
ADDRLP4 32
ADDRLP4 4
INDIRI4
ASGNI4
line 759
;759:		}
LABELV $357
line 760
;760:	}
LABELV $354
line 756
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 3
LTI4 $353
line 761
;761:	maxs[best] += 120;
ADDRLP4 36
ADDRLP4 32
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 20
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1123024896
ADDF4
ASGNF4
line 762
;762:	mins[best] -= 120;
ADDRLP4 40
ADDRLP4 32
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRF4
CNSTF4 1123024896
SUBF4
ASGNF4
line 765
;763:
;764:	// create a trigger with this size
;765:	other = G_Spawn ();
ADDRLP4 44
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 44
INDIRP4
ASGNP4
line 766
;766:	VectorCopy (mins, other->r.mins);
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
ADDRLP4 8
INDIRB
ASGNB 12
line 767
;767:	VectorCopy (maxs, other->r.maxs);
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
ADDRLP4 20
INDIRB
ASGNB 12
line 768
;768:	other->parent = ent;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 769
;769:	other->r.contents = CONTENTS_TRIGGER;
ADDRLP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 770
;770:	other->touch = Touch_DoorTrigger;
ADDRLP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_DoorTrigger
ASGNP4
line 772
;771:	// remember the thinnest axis
;772:	other->count = best;
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 773
;773:	trap_LinkEntity (other);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 775
;774:
;775:	MatchTeam( ent, ent->moverState, level.time );
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
ARGP4
ADDRLP4 48
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 MatchTeam
CALLV
pop
line 776
;776:}
LABELV $344
endproc Think_SpawnNewDoorTrigger 52 12
export Think_MatchTeam
proc Think_MatchTeam 4 12
line 778
;777:
;778:void Think_MatchTeam( gentity_t *ent ) {
line 779
;779:	MatchTeam( ent, ent->moverState, level.time );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 MatchTeam
CALLV
pop
line 780
;780:}
LABELV $360
endproc Think_MatchTeam 4 12
export SP_func_door
proc SP_func_door 112 12
line 799
;781:
;782:
;783:/*QUAKED func_door (0 .5 .8) ? START_OPEN x CRUSHER
;784:TOGGLE		wait in both the start and end states for a trigger event.
;785:START_OPEN	the door to moves to its destination when spawned, and operate in reverse.  It is used to temporarily or permanently close off an area when triggered (not useful for touch or takedamage doors).
;786:NOMONSTER	monsters will not trigger this door
;787:
;788:"model2"	.md3 model to also draw
;789:"angle"		determines the opening direction
;790:"targetname" if set, no touch field will be spawned and a remote button or trigger field activates the door.
;791:"speed"		movement speed (100 default)
;792:"wait"		wait before returning (3 default, -1 = never return)
;793:"lip"		lip remaining at end of move (8 default)
;794:"dmg"		damage to inflict when blocked (2 default)
;795:"color"		constantLight color
;796:"light"		constantLight radius
;797:"health"	if set, the door must be shot open
;798:*/
;799:void SP_func_door (gentity_t *ent) {
line 805
;800:	vec3_t	abs_movedir;
;801:	float	distance;
;802:	vec3_t	size;
;803:	float	lip;
;804:
;805:	ent->sound1to2 = ent->sound2to1 = G_SoundIndex("sound/movers/doors/dr1_strt.wav");
ADDRGP4 $363
ARGP4
ADDRLP4 32
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
CNSTI4 576
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
ADDRLP4 36
INDIRP4
CNSTI4 572
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 806
;806:	ent->soundPos1 = ent->soundPos2 = G_SoundIndex("sound/movers/doors/dr1_end.wav");
ADDRGP4 $364
ARGP4
ADDRLP4 40
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 580
ADDP4
ADDRLP4 40
INDIRI4
ASGNI4
ADDRLP4 44
INDIRP4
CNSTI4 568
ADDP4
ADDRLP4 40
INDIRI4
ASGNI4
line 808
;807:
;808:	ent->blocked = Blocked_Door;
ADDRFP4 0
INDIRP4
CNSTI4 680
ADDP4
ADDRGP4 Blocked_Door
ASGNP4
line 811
;809:
;810:	// default speed of 400
;811:	if (!ent->speed)
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
NEF4 $365
line 812
;812:		ent->speed = 400;
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
CNSTF4 1137180672
ASGNF4
LABELV $365
line 815
;813:
;814:	// default wait of 2 seconds
;815:	if (!ent->wait)
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 0
NEF4 $367
line 816
;816:		ent->wait = 2;
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
CNSTF4 1073741824
ASGNF4
LABELV $367
line 817
;817:	ent->wait *= 1000;
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
CNSTF4 1148846080
ADDRLP4 48
INDIRP4
INDIRF4
MULF4
ASGNF4
line 820
;818:
;819:	// default lip of 8 units
;820:	G_SpawnFloat( "lip", "8", &lip );
ADDRGP4 $369
ARGP4
ADDRGP4 $370
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 823
;821:
;822:	// default damage of 2 points
;823:	G_SpawnInt( "dmg", "2", &ent->damage );
ADDRGP4 $371
ARGP4
ADDRGP4 $372
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 826
;824:
;825:	// first position at start
;826:	VectorCopy( ent->s.origin, ent->pos1 );
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 52
INDIRP4
CNSTI4 600
ADDP4
ADDRLP4 52
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 829
;827:
;828:	// calculate second position
;829:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 830
;830:	G_SetMovedir (ent->s.angles, ent->movedir);
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 60
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 60
INDIRP4
CNSTI4 656
ADDP4
ARGP4
ADDRGP4 G_SetMovedir
CALLV
pop
line 831
;831:	abs_movedir[0] = fabs(ent->movedir[0]);
ADDRFP4 0
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
ARGF4
ADDRLP4 64
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 64
INDIRF4
ASGNF4
line 832
;832:	abs_movedir[1] = fabs(ent->movedir[1]);
ADDRFP4 0
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
ARGF4
ADDRLP4 68
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 68
INDIRF4
ASGNF4
line 833
;833:	abs_movedir[2] = fabs(ent->movedir[2]);
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
INDIRF4
ARGF4
ADDRLP4 72
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 72
INDIRF4
ASGNF4
line 834
;834:	VectorSubtract( ent->r.maxs, ent->r.mins, size );
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 76
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 76
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12+8
ADDRLP4 80
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
SUBF4
ASGNF4
line 835
;835:	distance = DotProduct( abs_movedir, size ) - lip;
ADDRLP4 24
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 28
INDIRF4
SUBF4
ASGNF4
line 836
;836:	VectorMA( ent->pos1, distance, ent->movedir, ent->pos2 );
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTI4 612
ADDP4
ADDRLP4 84
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
ADDRLP4 84
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTI4 616
ADDP4
ADDRLP4 88
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
ADDRLP4 88
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTI4 620
ADDP4
ADDRLP4 92
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
ADDRLP4 92
INDIRP4
CNSTI4 664
ADDP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
line 839
;837:
;838:	// if "start_open", reverse position 1 and 2
;839:	if ( ent->spawnflags & 1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $381
line 842
;840:		vec3_t	temp;
;841:
;842:		VectorCopy( ent->pos2, temp );
ADDRLP4 96
ADDRFP4 0
INDIRP4
CNSTI4 612
ADDP4
INDIRB
ASGNB 12
line 843
;843:		VectorCopy( ent->s.origin, ent->pos2 );
ADDRLP4 108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
INDIRP4
CNSTI4 612
ADDP4
ADDRLP4 108
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 844
;844:		VectorCopy( temp, ent->pos1 );
ADDRFP4 0
INDIRP4
CNSTI4 600
ADDP4
ADDRLP4 96
INDIRB
ASGNB 12
line 845
;845:	}
LABELV $381
line 847
;846:
;847:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 849
;848:
;849:	ent->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 851
;850:
;851:	if ( ! (ent->flags & FL_TEAMSLAVE ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
NEI4 $384
line 854
;852:		int health;
;853:
;854:		G_SpawnInt( "health", "0", &health );
ADDRGP4 $386
ARGP4
ADDRGP4 $387
ARGP4
ADDRLP4 96
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 855
;855:		if ( health ) {
ADDRLP4 96
INDIRI4
CNSTI4 0
EQI4 $388
line 856
;856:			ent->takedamage = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 1
ASGNI4
line 857
;857:		}
LABELV $388
line 858
;858:		if ( ent->targetname || health ) {
ADDRFP4 0
INDIRP4
CNSTI4 640
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $392
ADDRLP4 96
INDIRI4
CNSTI4 0
EQI4 $390
LABELV $392
line 860
;859:			// non touch/shoot doors
;860:			ent->think = Think_MatchTeam;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Think_MatchTeam
ASGNP4
line 861
;861:		} else {
ADDRGP4 $391
JUMPV
LABELV $390
line 862
;862:			ent->think = Think_SpawnNewDoorTrigger;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Think_SpawnNewDoorTrigger
ASGNP4
line 863
;863:		}
LABELV $391
line 864
;864:	}
LABELV $384
line 867
;865:
;866:
;867:}
LABELV $362
endproc SP_func_door 112 12
export Touch_Plat
proc Touch_Plat 4 0
line 884
;868:
;869:/*
;870:===============================================================================
;871:
;872:PLAT
;873:
;874:===============================================================================
;875:*/
;876:
;877:/*
;878:==============
;879:Touch_Plat
;880:
;881:Don't allow decent if a living player is on it
;882:===============
;883:*/
;884:void Touch_Plat( gentity_t *ent, gentity_t *other, trace_t *trace ) {
line 885
;885:	if ( !other->client || other->client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $396
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $394
LABELV $396
line 886
;886:		return;
ADDRGP4 $393
JUMPV
LABELV $394
line 890
;887:	}
;888:
;889:	// delay return-to-pos1 by one second
;890:	if ( ent->moverState == MOVER_POS2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 1
NEI4 $397
line 891
;891:		ent->nextthink = level.time + 1000;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDI4
ASGNI4
line 892
;892:	}
LABELV $397
line 893
;893:}
LABELV $393
endproc Touch_Plat 4 0
export Touch_PlatCenterTrigger
proc Touch_PlatCenterTrigger 4 12
line 902
;894:
;895:/*
;896:==============
;897:Touch_PlatCenterTrigger
;898:
;899:If the plat is at the bottom position, start it going up
;900:===============
;901:*/
;902:void Touch_PlatCenterTrigger(gentity_t *ent, gentity_t *other, trace_t *trace ) {
line 903
;903:	if ( !other->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $401
line 904
;904:		return;
ADDRGP4 $400
JUMPV
LABELV $401
line 907
;905:	}
;906:
;907:	if ( ent->parent->moverState == MOVER_POS1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 0
NEI4 $403
line 908
;908:		Use_BinaryMover( ent->parent, ent, other );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Use_BinaryMover
CALLV
pop
line 909
;909:	}
LABELV $403
line 910
;910:}
LABELV $400
endproc Touch_PlatCenterTrigger 4 12
export SpawnPlatTrigger
proc SpawnPlatTrigger 60 4
line 922
;911:
;912:
;913:/*
;914:================
;915:SpawnPlatTrigger
;916:
;917:Spawn a trigger in the middle of the plat's low position
;918:Elevator cars require that the trigger extend through the entire low position,
;919:not just sit on top of it.
;920:================
;921:*/
;922:void SpawnPlatTrigger( gentity_t *ent ) {
line 928
;923:	gentity_t	*trigger;
;924:	vec3_t	tmin, tmax;
;925:
;926:	// the middle trigger will be a thin trigger just
;927:	// above the starting position
;928:	trigger = G_Spawn();
ADDRLP4 28
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 28
INDIRP4
ASGNP4
line 929
;929:	trigger->touch = Touch_PlatCenterTrigger;
ADDRLP4 12
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_PlatCenterTrigger
ASGNP4
line 930
;930:	trigger->r.contents = CONTENTS_TRIGGER;
ADDRLP4 12
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 931
;931:	trigger->parent = ent;
ADDRLP4 12
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 933
;932:	
;933:	tmin[0] = ent->pos1[0] + ent->r.mins[0] + 33;
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 32
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDF4
CNSTF4 1107558400
ADDF4
ASGNF4
line 934
;934:	tmin[1] = ent->pos1[1] + ent->r.mins[1] + 33;
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+4
ADDRLP4 36
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDF4
CNSTF4 1107558400
ADDF4
ASGNF4
line 935
;935:	tmin[2] = ent->pos1[2] + ent->r.mins[2];
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 40
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ADDF4
ASGNF4
line 937
;936:
;937:	tmax[0] = ent->pos1[0] + ent->r.maxs[0] - 33;
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 44
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
CNSTF4 1107558400
SUBF4
ASGNF4
line 938
;938:	tmax[1] = ent->pos1[1] + ent->r.maxs[1] - 33;
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16+4
ADDRLP4 48
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
ADDRLP4 48
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
CNSTF4 1107558400
SUBF4
ASGNF4
line 939
;939:	tmax[2] = ent->pos1[2] + ent->r.maxs[2] + 8;
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16+8
ADDRLP4 52
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
ADDRLP4 52
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 941
;940:
;941:	if ( tmax[0] <= tmin[0] ) {
ADDRLP4 16
INDIRF4
ADDRLP4 0
INDIRF4
GTF4 $410
line 942
;942:		tmin[0] = ent->pos1[0] + (ent->r.mins[0] + ent->r.maxs[0]) *0.5;
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 56
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 56
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDRLP4 56
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 943
;943:		tmax[0] = tmin[0] + 1;
ADDRLP4 16
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 944
;944:	}
LABELV $410
line 945
;945:	if ( tmax[1] <= tmin[1] ) {
ADDRLP4 16+4
INDIRF4
ADDRLP4 0+4
INDIRF4
GTF4 $412
line 946
;946:		tmin[1] = ent->pos1[1] + (ent->r.mins[1] + ent->r.maxs[1]) *0.5;
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+4
ADDRLP4 56
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 56
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDRLP4 56
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 947
;947:		tmax[1] = tmin[1] + 1;
ADDRLP4 16+4
ADDRLP4 0+4
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 948
;948:	}
LABELV $412
line 950
;949:	
;950:	VectorCopy (tmin, trigger->r.mins);
ADDRLP4 12
INDIRP4
CNSTI4 424
ADDP4
ADDRLP4 0
INDIRB
ASGNB 12
line 951
;951:	VectorCopy (tmax, trigger->r.maxs);
ADDRLP4 12
INDIRP4
CNSTI4 436
ADDP4
ADDRLP4 16
INDIRB
ASGNB 12
line 953
;952:
;953:	trap_LinkEntity (trigger);
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 954
;954:}
LABELV $405
endproc SpawnPlatTrigger 60 4
export SP_func_plat
proc SP_func_plat 56 12
line 968
;955:
;956:
;957:/*QUAKED func_plat (0 .5 .8) ?
;958:Plats are always drawn in the extended position so they will light correctly.
;959:
;960:"lip"		default 8, protrusion above rest position
;961:"height"	total height of movement, defaults to model height
;962:"speed"		overrides default 200.
;963:"dmg"		overrides default 2
;964:"model2"	.md3 model to also draw
;965:"color"		constantLight color
;966:"light"		constantLight radius
;967:*/
;968:void SP_func_plat (gentity_t *ent) {
line 971
;969:	float		lip, height;
;970:
;971:	ent->sound1to2 = ent->sound2to1 = G_SoundIndex("sound/movers/plats/pt1_strt.wav");
ADDRGP4 $420
ARGP4
ADDRLP4 8
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 576
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 572
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 972
;972:	ent->soundPos1 = ent->soundPos2 = G_SoundIndex("sound/movers/plats/pt1_end.wav");
ADDRGP4 $421
ARGP4
ADDRLP4 16
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 580
ADDP4
ADDRLP4 16
INDIRI4
ASGNI4
ADDRLP4 20
INDIRP4
CNSTI4 568
ADDP4
ADDRLP4 16
INDIRI4
ASGNI4
line 974
;973:
;974:	VectorClear (ent->s.angles);
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 24
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 24
INDIRP4
CNSTI4 120
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 24
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 976
;975:
;976:	G_SpawnFloat( "speed", "200", &ent->speed );
ADDRGP4 $422
ARGP4
ADDRGP4 $423
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 977
;977:	G_SpawnInt( "dmg", "2", &ent->damage );
ADDRGP4 $371
ARGP4
ADDRGP4 $372
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 978
;978:	G_SpawnFloat( "wait", "1", &ent->wait );
ADDRGP4 $424
ARGP4
ADDRGP4 $425
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 979
;979:	G_SpawnFloat( "lip", "8", &lip );
ADDRGP4 $369
ARGP4
ADDRGP4 $370
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 981
;980:
;981:	ent->wait = 1000;
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
CNSTF4 1148846080
ASGNF4
line 984
;982:
;983:	// create second position
;984:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 986
;985:
;986:	if ( !G_SpawnFloat( "height", "0", &height ) ) {
ADDRGP4 $428
ARGP4
ADDRGP4 $387
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 36
ADDRGP4 G_SpawnFloat
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $426
line 987
;987:		height = (ent->r.maxs[2] - ent->r.mins[2]) - lip;
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 40
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
SUBF4
ADDRLP4 4
INDIRF4
SUBF4
ASGNF4
line 988
;988:	}
LABELV $426
line 991
;989:
;990:	// pos1 is the rest (bottom) position, pos2 is the top
;991:	VectorCopy( ent->s.origin, ent->pos2 );
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
CNSTI4 612
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 992
;992:	VectorCopy( ent->pos2, ent->pos1 );
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 600
ADDP4
ADDRLP4 44
INDIRP4
CNSTI4 612
ADDP4
INDIRB
ASGNB 12
line 993
;993:	ent->pos1[2] -= height;
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 608
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ASGNF4
line 995
;994:
;995:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 999
;996:
;997:	// touch function keeps the plat from returning while
;998:	// a live player is standing on it
;999:	ent->touch = Touch_Plat;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_Plat
ASGNP4
line 1001
;1000:
;1001:	ent->blocked = Blocked_Door;
ADDRFP4 0
INDIRP4
CNSTI4 680
ADDP4
ADDRGP4 Blocked_Door
ASGNP4
line 1003
;1002:
;1003:	ent->parent = ent;	// so it can be treated as a door
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 52
INDIRP4
CNSTI4 588
ADDP4
ADDRLP4 52
INDIRP4
ASGNP4
line 1006
;1004:
;1005:	// spawn the trigger if one hasn't been custom made
;1006:	if ( !ent->targetname ) {
ADDRFP4 0
INDIRP4
CNSTI4 640
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $429
line 1007
;1007:		SpawnPlatTrigger(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SpawnPlatTrigger
CALLV
pop
line 1008
;1008:	}
LABELV $429
line 1009
;1009:}
LABELV $419
endproc SP_func_plat 56 12
export Touch_Button
proc Touch_Button 4 12
line 1026
;1010:
;1011:
;1012:/*
;1013:===============================================================================
;1014:
;1015:BUTTON
;1016:
;1017:===============================================================================
;1018:*/
;1019:
;1020:/*
;1021:==============
;1022:Touch_Button
;1023:
;1024:===============
;1025:*/
;1026:void Touch_Button(gentity_t *ent, gentity_t *other, trace_t *trace ) {
line 1027
;1027:	if ( !other->client ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $432
line 1028
;1028:		return;
ADDRGP4 $431
JUMPV
LABELV $432
line 1031
;1029:	}
;1030:
;1031:	if ( ent->moverState == MOVER_POS1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 0
NEI4 $434
line 1032
;1032:		Use_BinaryMover( ent, other, other );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 Use_BinaryMover
CALLV
pop
line 1033
;1033:	}
LABELV $434
line 1034
;1034:}
LABELV $431
endproc Touch_Button 4 12
export SP_func_button
proc SP_func_button 84 12
line 1050
;1035:
;1036:
;1037:/*QUAKED func_button (0 .5 .8) ?
;1038:When a button is touched, it moves some distance in the direction of it's angle, triggers all of it's targets, waits some time, then returns to it's original position where it can be triggered again.
;1039:
;1040:"model2"	.md3 model to also draw
;1041:"angle"		determines the opening direction
;1042:"target"	all entities with a matching targetname will be used
;1043:"speed"		override the default 40 speed
;1044:"wait"		override the default 1 second wait (-1 = never return)
;1045:"lip"		override the default 4 pixel lip remaining at end of move
;1046:"health"	if set, the button must be killed instead of touched
;1047:"color"		constantLight color
;1048:"light"		constantLight radius
;1049:*/
;1050:void SP_func_button( gentity_t *ent ) {
line 1056
;1051:	vec3_t		abs_movedir;
;1052:	float		distance;
;1053:	vec3_t		size;
;1054:	float		lip;
;1055:
;1056:	ent->sound1to2 = G_SoundIndex("sound/movers/switches/butn2.wav");
ADDRGP4 $437
ARGP4
ADDRLP4 32
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 572
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 1058
;1057:	
;1058:	if ( !ent->speed ) {
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
NEF4 $438
line 1059
;1059:		ent->speed = 40;
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
CNSTF4 1109393408
ASGNF4
line 1060
;1060:	}
LABELV $438
line 1062
;1061:
;1062:	if ( !ent->wait ) {
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 0
NEF4 $440
line 1063
;1063:		ent->wait = 1;
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
CNSTF4 1065353216
ASGNF4
line 1064
;1064:	}
LABELV $440
line 1065
;1065:	ent->wait *= 1000;
ADDRLP4 36
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
CNSTF4 1148846080
ADDRLP4 36
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1068
;1066:
;1067:	// first position
;1068:	VectorCopy( ent->s.origin, ent->pos1 );
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
CNSTI4 600
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1071
;1069:
;1070:	// calculate second position
;1071:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
ARGP4
ADDRLP4 44
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 1073
;1072:
;1073:	G_SpawnFloat( "lip", "4", &lip );
ADDRGP4 $369
ARGP4
ADDRGP4 $442
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 1075
;1074:
;1075:	G_SetMovedir( ent->s.angles, ent->movedir );
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 48
INDIRP4
CNSTI4 656
ADDP4
ARGP4
ADDRGP4 G_SetMovedir
CALLV
pop
line 1076
;1076:	abs_movedir[0] = fabs(ent->movedir[0]);
ADDRFP4 0
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
ARGF4
ADDRLP4 52
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 52
INDIRF4
ASGNF4
line 1077
;1077:	abs_movedir[1] = fabs(ent->movedir[1]);
ADDRFP4 0
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
ARGF4
ADDRLP4 56
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 56
INDIRF4
ASGNF4
line 1078
;1078:	abs_movedir[2] = fabs(ent->movedir[2]);
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
INDIRF4
ARGF4
ADDRLP4 60
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 60
INDIRF4
ASGNF4
line 1079
;1079:	VectorSubtract( ent->r.maxs, ent->r.mins, size );
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 64
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDRLP4 64
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 64
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDRLP4 64
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12+8
ADDRLP4 68
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDRLP4 68
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1080
;1080:	distance = abs_movedir[0] * size[0] + abs_movedir[1] * size[1] + abs_movedir[2] * size[2] - lip;
ADDRLP4 24
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 28
INDIRF4
SUBF4
ASGNF4
line 1081
;1081:	VectorMA (ent->pos1, distance, ent->movedir, ent->pos2);
ADDRLP4 72
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 612
ADDP4
ADDRLP4 72
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
ADDRLP4 72
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 616
ADDP4
ADDRLP4 76
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 620
ADDP4
ADDRLP4 80
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 664
ADDP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
line 1083
;1082:
;1083:	if (ent->health) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 0
EQI4 $451
line 1085
;1084:		// shootable button
;1085:		ent->takedamage = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 1
ASGNI4
line 1086
;1086:	} else {
ADDRGP4 $452
JUMPV
LABELV $451
line 1088
;1087:		// touchable button
;1088:		ent->touch = Touch_Button;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_Button
ASGNP4
line 1089
;1089:	}
LABELV $452
line 1091
;1090:
;1091:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 1092
;1092:}
LABELV $436
endproc SP_func_button 84 12
export Think_BeginMoving
proc Think_BeginMoving 0 0
line 1116
;1093:
;1094:
;1095:
;1096:/*
;1097:===============================================================================
;1098:
;1099:TRAIN
;1100:
;1101:===============================================================================
;1102:*/
;1103:
;1104:
;1105:#define TRAIN_START_ON		1
;1106:#define TRAIN_TOGGLE		2
;1107:#define TRAIN_BLOCK_STOPS	4
;1108:
;1109:/*
;1110:===============
;1111:Think_BeginMoving
;1112:
;1113:The wait time at a corner has completed, so start moving again
;1114:===============
;1115:*/
;1116:void Think_BeginMoving( gentity_t *ent ) {
line 1117
;1117:	ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1118
;1118:	ent->s.pos.trType = TR_LINEAR_STOP;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 3
ASGNI4
line 1119
;1119:}
LABELV $453
endproc Think_BeginMoving 0 0
export Reached_Train
proc Reached_Train 48 12
line 1126
;1120:
;1121:/*
;1122:===============
;1123:Reached_Train
;1124:===============
;1125:*/
;1126:void Reached_Train( gentity_t *ent ) {
line 1133
;1127:	gentity_t		*next;
;1128:	float			speed;
;1129:	vec3_t			move;
;1130:	float			length;
;1131:
;1132:	// copy the apropriate values
;1133:	next = ent->nextTrain;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRP4
ASGNP4
line 1134
;1134:	if ( !next || !next->nextTrain ) {
ADDRLP4 28
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRU4
EQU4 $458
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRU4
NEU4 $456
LABELV $458
line 1135
;1135:		return;		// just stop
ADDRGP4 $455
JUMPV
LABELV $456
line 1139
;1136:	}
;1137:
;1138:	// fire all other targets
;1139:	G_UseTargets( next, NULL );
ADDRLP4 0
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 1142
;1140:
;1141:	// set the new trajectory
;1142:	ent->nextTrain = next->nextTrain;
ADDRLP4 32
CNSTI4 592
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRP4
ASGNP4
line 1143
;1143:	VectorCopy( next->s.origin, ent->pos1 );
ADDRFP4 0
INDIRP4
CNSTI4 600
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1144
;1144:	VectorCopy( next->nextTrain->s.origin, ent->pos2 );
ADDRFP4 0
INDIRP4
CNSTI4 612
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1147
;1145:
;1146:	// if the path_corner has a speed, use that
;1147:	if ( next->speed ) {
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
EQF4 $459
line 1148
;1148:		speed = next->speed;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ASGNF4
line 1149
;1149:	} else {
ADDRGP4 $460
JUMPV
LABELV $459
line 1151
;1150:		// otherwise use the train's speed
;1151:		speed = ent->speed;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ASGNF4
line 1152
;1152:	}
LABELV $460
line 1153
;1153:	if ( speed < 1 ) {
ADDRLP4 16
INDIRF4
CNSTF4 1065353216
GEF4 $461
line 1154
;1154:		speed = 1;
ADDRLP4 16
CNSTF4 1065353216
ASGNF4
line 1155
;1155:	}
LABELV $461
line 1158
;1156:
;1157:	// calculate duration
;1158:	VectorSubtract( ent->pos2, ent->pos1, move );
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 36
INDIRP4
CNSTI4 612
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 600
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 36
INDIRP4
CNSTI4 616
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 604
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4+8
ADDRLP4 40
INDIRP4
CNSTI4 620
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 608
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1159
;1159:	length = VectorLength( move );
ADDRLP4 4
ARGP4
ADDRLP4 44
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 44
INDIRF4
ASGNF4
line 1161
;1160:
;1161:	ent->s.pos.trDuration = length * 1000 / speed;
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
CNSTF4 1148846080
ADDRLP4 20
INDIRF4
MULF4
ADDRLP4 16
INDIRF4
DIVF4
CVFI4 4
ASGNI4
line 1164
;1162:
;1163:	// looping sound
;1164:	ent->s.loopSound = next->soundLoop;
ADDRFP4 0
INDIRP4
CNSTI4 156
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
line 1167
;1165:
;1166:	// start it going
;1167:	SetMoverState( ent, MOVER_1TO2, level.time );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 SetMoverState
CALLV
pop
line 1170
;1168:
;1169:	// if there is a "wait" value on the target, don't start moving yet
;1170:	if ( next->wait ) {
ADDRLP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 0
EQF4 $466
line 1171
;1171:		ent->nextthink = level.time + next->wait * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
CNSTF4 1148846080
ADDRLP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 1172
;1172:		ent->think = Think_BeginMoving;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Think_BeginMoving
ASGNP4
line 1173
;1173:		ent->s.pos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 1174
;1174:	}
LABELV $466
line 1175
;1175:}
LABELV $455
endproc Reached_Train 48 12
export Think_SetupTrainTargets
proc Think_SetupTrainTargets 28 12
line 1185
;1176:
;1177:
;1178:/*
;1179:===============
;1180:Think_SetupTrainTargets
;1181:
;1182:Link all the corners together
;1183:===============
;1184:*/
;1185:void Think_SetupTrainTargets( gentity_t *ent ) {
line 1188
;1186:	gentity_t		*path, *next, *start;
;1187:
;1188:	ent->nextTrain = G_Find( NULL, FOFS(targetname), ent->target );
CNSTP4 0
ARGP4
CNSTI4 640
ARGI4
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 592
ADDP4
ADDRLP4 16
INDIRP4
ASGNP4
line 1189
;1189:	if ( !ent->nextTrain ) {
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $470
line 1190
;1190:		G_Printf( "func_train at %s with an unfound target\n",
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
ARGP4
ADDRLP4 20
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $472
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 1192
;1191:			vtos(ent->r.absmin) );
;1192:		return;
ADDRGP4 $469
JUMPV
LABELV $470
line 1195
;1193:	}
;1194:
;1195:	start = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
line 1196
;1196:	for ( path = ent->nextTrain ; path != start ; path = next ) {
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRP4
ASGNP4
ADDRGP4 $476
JUMPV
LABELV $473
line 1197
;1197:		if ( !start ) {
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $477
line 1198
;1198:			start = path;
ADDRLP4 8
ADDRLP4 4
INDIRP4
ASGNP4
line 1199
;1199:		}
LABELV $477
line 1201
;1200:
;1201:		if ( !path->target ) {
ADDRLP4 4
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $479
line 1202
;1202:			G_Printf( "Train corner at %s without a target\n",
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 20
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $481
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 1204
;1203:				vtos(path->s.origin) );
;1204:			return;
ADDRGP4 $469
JUMPV
LABELV $479
line 1210
;1205:		}
;1206:
;1207:		// find a path_corner among the targets
;1208:		// there may also be other targets that get fired when the corner
;1209:		// is reached
;1210:		next = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
LABELV $482
line 1211
;1211:		do {
line 1212
;1212:			next = G_Find( next, FOFS(targetname), path->target );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 640
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 20
INDIRP4
ASGNP4
line 1213
;1213:			if ( !next ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $485
line 1214
;1214:				G_Printf( "Train corner at %s without a target path_corner\n",
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 24
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $487
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 1216
;1215:					vtos(path->s.origin) );
;1216:				return;
ADDRGP4 $469
JUMPV
LABELV $485
line 1218
;1217:			}
;1218:		} while ( strcmp( next->classname, "path_corner" ) );
LABELV $483
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
INDIRP4
ARGP4
ADDRGP4 $488
ARGP4
ADDRLP4 20
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 0
NEI4 $482
line 1220
;1219:
;1220:		path->nextTrain = next;
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 1221
;1221:	}
LABELV $474
line 1196
ADDRLP4 4
ADDRLP4 0
INDIRP4
ASGNP4
LABELV $476
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRP4
CVPU4 4
NEU4 $473
line 1224
;1222:
;1223:	// start the train moving from the first corner
;1224:	Reached_Train( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Reached_Train
CALLV
pop
line 1225
;1225:}
LABELV $469
endproc Think_SetupTrainTargets 28 12
export SP_path_corner
proc SP_path_corner 4 8
line 1235
;1226:
;1227:
;1228:
;1229:/*QUAKED path_corner (.5 .3 0) (-8 -8 -8) (8 8 8)
;1230:Train path corners.
;1231:Target: next path corner and other targets to fire
;1232:"speed" speed to move to the next corner
;1233:"wait" seconds to wait before behining move to next corner
;1234:*/
;1235:void SP_path_corner( gentity_t *self ) {
line 1236
;1236:	if ( !self->targetname ) {
ADDRFP4 0
INDIRP4
CNSTI4 640
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $490
line 1237
;1237:		G_Printf ("path_corner with no targetname at %s\n", vtos(self->s.origin));
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 0
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $492
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 1238
;1238:		G_FreeEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 1239
;1239:		return;
LABELV $490
line 1242
;1240:	}
;1241:	// path corners don't need to be linked in
;1242:}
LABELV $489
endproc SP_path_corner 4 8
export SP_func_train
proc SP_func_train 12 8
line 1258
;1243:
;1244:
;1245:
;1246:/*QUAKED func_train (0 .5 .8) ? START_ON TOGGLE BLOCK_STOPS
;1247:A train is a mover that moves between path_corner target points.
;1248:Trains MUST HAVE AN ORIGIN BRUSH.
;1249:The train spawns at the first target it is pointing at.
;1250:"model2"	.md3 model to also draw
;1251:"speed"		default 100
;1252:"dmg"		default	2
;1253:"noise"		looping sound to play when the train is in motion
;1254:"target"	next path corner
;1255:"color"		constantLight color
;1256:"light"		constantLight radius
;1257:*/
;1258:void SP_func_train (gentity_t *self) {
line 1259
;1259:	VectorClear (self->s.angles);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 1261
;1260:
;1261:	if (self->spawnflags & TRAIN_BLOCK_STOPS) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $494
line 1262
;1262:		self->damage = 0;
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 0
ASGNI4
line 1263
;1263:	} else {
ADDRGP4 $495
JUMPV
LABELV $494
line 1264
;1264:		if (!self->damage) {
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
CNSTI4 0
NEI4 $496
line 1265
;1265:			self->damage = 2;
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 2
ASGNI4
line 1266
;1266:		}
LABELV $496
line 1267
;1267:	}
LABELV $495
line 1269
;1268:
;1269:	if ( !self->speed ) {
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
NEF4 $498
line 1270
;1270:		self->speed = 100;
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
CNSTF4 1120403456
ASGNF4
line 1271
;1271:	}
LABELV $498
line 1273
;1272:
;1273:	if ( !self->target ) {
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $500
line 1274
;1274:		G_Printf ("func_train without a target at %s\n", vtos(self->r.absmin));
ADDRFP4 0
INDIRP4
CNSTI4 452
ADDP4
ARGP4
ADDRLP4 8
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $502
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 1275
;1275:		G_FreeEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 1276
;1276:		return;
ADDRGP4 $493
JUMPV
LABELV $500
line 1279
;1277:	}
;1278:
;1279:	trap_SetBrushModel( self, self->model );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 1280
;1280:	InitMover( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 1282
;1281:
;1282:	self->reached = Reached_Train;
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
ADDRGP4 Reached_Train
ASGNP4
line 1286
;1283:
;1284:	// start trains on the second frame, to make sure their targets have had
;1285:	// a chance to spawn
;1286:	self->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 1287
;1287:	self->think = Think_SetupTrainTargets;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Think_SetupTrainTargets
ASGNP4
line 1288
;1288:}
LABELV $493
endproc SP_func_train 12 8
export SP_func_static
proc SP_func_static 12 8
line 1305
;1289:
;1290:/*
;1291:===============================================================================
;1292:
;1293:STATIC
;1294:
;1295:===============================================================================
;1296:*/
;1297:
;1298:
;1299:/*QUAKED func_static (0 .5 .8) ?
;1300:A bmodel that just sits there, doing nothing.  Can be used for conditional walls and models.
;1301:"model2"	.md3 model to also draw
;1302:"color"		constantLight color
;1303:"light"		constantLight radius
;1304:*/
;1305:void SP_func_static( gentity_t *ent ) {
line 1306
;1306:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 1307
;1307:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 1308
;1308:	VectorCopy( ent->s.origin, ent->s.pos.trBase );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1309
;1309:	VectorCopy( ent->s.origin, ent->r.currentOrigin );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1310
;1310:}
LABELV $504
endproc SP_func_static 12 8
export SP_func_rotating
proc SP_func_rotating 16 8
line 1333
;1311:
;1312:
;1313:/*
;1314:===============================================================================
;1315:
;1316:ROTATING
;1317:
;1318:===============================================================================
;1319:*/
;1320:
;1321:
;1322:/*QUAKED func_rotating (0 .5 .8) ? START_ON - X_AXIS Y_AXIS
;1323:You need to have an origin brush as part of this entity.  The center of that brush will be
;1324:the point around which it is rotated. It will rotate around the Z axis by default.  You can
;1325:check either the X_AXIS or Y_AXIS box to change that.
;1326:
;1327:"model2"	.md3 model to also draw
;1328:"speed"		determines how fast it moves; default value is 100.
;1329:"dmg"		damage to inflict when blocked (2 default)
;1330:"color"		constantLight color
;1331:"light"		constantLight radius
;1332:*/
;1333:void SP_func_rotating (gentity_t *ent) {
line 1334
;1334:	if ( !ent->speed ) {
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 0
NEF4 $506
line 1335
;1335:		ent->speed = 100;
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
CNSTF4 1120403456
ASGNF4
line 1336
;1336:	}
LABELV $506
line 1339
;1337:
;1338:	// set the axis of rotation
;1339:	ent->s.apos.trType = TR_LINEAR;
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 1340
;1340:	if ( ent->spawnflags & 4 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $508
line 1341
;1341:		ent->s.apos.trDelta[2] = ent->speed;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ASGNF4
line 1342
;1342:	} else if ( ent->spawnflags & 8 ) {
ADDRGP4 $509
JUMPV
LABELV $508
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $510
line 1343
;1343:		ent->s.apos.trDelta[0] = ent->speed;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ASGNF4
line 1344
;1344:	} else {
ADDRGP4 $511
JUMPV
LABELV $510
line 1345
;1345:		ent->s.apos.trDelta[1] = ent->speed;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ASGNF4
line 1346
;1346:	}
LABELV $511
LABELV $509
line 1348
;1347:
;1348:	if (!ent->damage) {
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
CNSTI4 0
NEI4 $512
line 1349
;1349:		ent->damage = 2;
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 2
ASGNI4
line 1350
;1350:	}
LABELV $512
line 1352
;1351:
;1352:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 1353
;1353:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 1355
;1354:
;1355:	VectorCopy( ent->s.origin, ent->s.pos.trBase );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1356
;1356:	VectorCopy( ent->s.pos.trBase, ent->r.currentOrigin );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 1357
;1357:	VectorCopy( ent->s.apos.trBase, ent->r.currentAngles );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 488
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 60
ADDP4
INDIRB
ASGNB 12
line 1359
;1358:
;1359:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 1360
;1360:}
LABELV $505
endproc SP_func_rotating 16 8
export SP_func_bobbing
proc SP_func_bobbing 28 12
line 1382
;1361:
;1362:
;1363:/*
;1364:===============================================================================
;1365:
;1366:BOBBING
;1367:
;1368:===============================================================================
;1369:*/
;1370:
;1371:
;1372:/*QUAKED func_bobbing (0 .5 .8) ? X_AXIS Y_AXIS
;1373:Normally bobs on the Z axis
;1374:"model2"	.md3 model to also draw
;1375:"height"	amplitude of bob (32 default)
;1376:"speed"		seconds to complete a bob cycle (4 default)
;1377:"phase"		the 0.0 to 1.0 offset in the cycle to start at
;1378:"dmg"		damage to inflict when blocked (2 default)
;1379:"color"		constantLight color
;1380:"light"		constantLight radius
;1381:*/
;1382:void SP_func_bobbing (gentity_t *ent) {
line 1386
;1383:	float		height;
;1384:	float		phase;
;1385:
;1386:	G_SpawnFloat( "speed", "4", &ent->speed );
ADDRGP4 $422
ARGP4
ADDRGP4 $442
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 1387
;1387:	G_SpawnFloat( "height", "32", &height );
ADDRGP4 $428
ARGP4
ADDRGP4 $515
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 1388
;1388:	G_SpawnInt( "dmg", "2", &ent->damage );
ADDRGP4 $371
ARGP4
ADDRGP4 $372
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 1389
;1389:	G_SpawnFloat( "phase", "0", &phase );
ADDRGP4 $516
ARGP4
ADDRGP4 $387
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 1391
;1390:
;1391:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 1392
;1392:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 1394
;1393:
;1394:	VectorCopy( ent->s.origin, ent->s.pos.trBase );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1395
;1395:	VectorCopy( ent->s.origin, ent->r.currentOrigin );
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 16
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1397
;1396:
;1397:	ent->s.pos.trDuration = ent->speed * 1000;
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 20
ADDP4
CNSTF4 1148846080
ADDRLP4 20
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 1398
;1398:	ent->s.pos.trTime = ent->s.pos.trDuration * phase;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 24
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 1399
;1399:	ent->s.pos.trType = TR_SINE;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 4
ASGNI4
line 1402
;1400:
;1401:	// set the axis of bobbing
;1402:	if ( ent->spawnflags & 1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $517
line 1403
;1403:		ent->s.pos.trDelta[0] = height;
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ASGNF4
line 1404
;1404:	} else if ( ent->spawnflags & 2 ) {
ADDRGP4 $518
JUMPV
LABELV $517
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $519
line 1405
;1405:		ent->s.pos.trDelta[1] = height;
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0
INDIRF4
ASGNF4
line 1406
;1406:	} else {
ADDRGP4 $520
JUMPV
LABELV $519
line 1407
;1407:		ent->s.pos.trDelta[2] = height;
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0
INDIRF4
ASGNF4
line 1408
;1408:	}
LABELV $520
LABELV $518
line 1409
;1409:}
LABELV $514
endproc SP_func_bobbing 28 12
export SP_func_pendulum
proc SP_func_pendulum 44 12
line 1431
;1410:
;1411:/*
;1412:===============================================================================
;1413:
;1414:PENDULUM
;1415:
;1416:===============================================================================
;1417:*/
;1418:
;1419:
;1420:/*QUAKED func_pendulum (0 .5 .8) ?
;1421:You need to have an origin brush as part of this entity.
;1422:Pendulums always swing north / south on unrotated models.  Add an angles field to the model to allow rotation in other directions.
;1423:Pendulum frequency is a physical constant based on the length of the beam and gravity.
;1424:"model2"	.md3 model to also draw
;1425:"speed"		the number of degrees each way the pendulum swings, (30 default)
;1426:"phase"		the 0.0 to 1.0 offset in the cycle to start at
;1427:"dmg"		damage to inflict when blocked (2 default)
;1428:"color"		constantLight color
;1429:"light"		constantLight radius
;1430:*/
;1431:void SP_func_pendulum(gentity_t *ent) {
line 1437
;1432:	float		freq;
;1433:	float		length;
;1434:	float		phase;
;1435:	float		speed;
;1436:
;1437:	G_SpawnFloat( "speed", "30", &speed );
ADDRGP4 $422
ARGP4
ADDRGP4 $522
ARGP4
ADDRLP4 12
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 1438
;1438:	G_SpawnInt( "dmg", "2", &ent->damage );
ADDRGP4 $371
ARGP4
ADDRGP4 $372
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 1439
;1439:	G_SpawnFloat( "phase", "0", &phase );
ADDRGP4 $516
ARGP4
ADDRGP4 $387
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 1441
;1440:
;1441:	trap_SetBrushModel( ent, ent->model );
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 16
INDIRP4
CNSTI4 528
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_SetBrushModel
CALLV
pop
line 1444
;1442:
;1443:	// find pendulum length
;1444:	length = fabs( ent->r.mins[2] );
ADDRFP4 0
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ARGF4
ADDRLP4 20
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 20
INDIRF4
ASGNF4
line 1445
;1445:	if ( length < 8 ) {
ADDRLP4 0
INDIRF4
CNSTF4 1090519040
GEF4 $523
line 1446
;1446:		length = 8;
ADDRLP4 0
CNSTF4 1090519040
ASGNF4
line 1447
;1447:	}
LABELV $523
line 1449
;1448:
;1449:	freq = 1 / ( M_PI * 2 ) * sqrt( g_gravity.value / ( 3 * length ) );
ADDRGP4 g_gravity+8
INDIRF4
CNSTF4 1077936128
ADDRLP4 0
INDIRF4
MULF4
DIVF4
ARGF4
ADDRLP4 24
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 4
CNSTF4 1042479491
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
line 1451
;1450:
;1451:	ent->s.pos.trDuration = ( 1000 / freq );
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
CNSTF4 1148846080
ADDRLP4 4
INDIRF4
DIVF4
CVFI4 4
ASGNI4
line 1453
;1452:
;1453:	InitMover( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 InitMover
CALLV
pop
line 1455
;1454:
;1455:	VectorCopy( ent->s.origin, ent->s.pos.trBase );
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 28
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1456
;1456:	VectorCopy( ent->s.origin, ent->r.currentOrigin );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 32
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1458
;1457:
;1458:	VectorCopy( ent->s.angles, ent->s.apos.trBase );
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 36
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 1460
;1459:
;1460:	ent->s.apos.trDuration = 1000 / freq;
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1148846080
ADDRLP4 4
INDIRF4
DIVF4
CVFI4 4
ASGNI4
line 1461
;1461:	ent->s.apos.trTime = ent->s.apos.trDuration * phase;
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 8
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 1462
;1462:	ent->s.apos.trType = TR_SINE;
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 4
ASGNI4
line 1463
;1463:	ent->s.apos.trDelta[2] = speed;
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 1464
;1464:}
LABELV $521
endproc SP_func_pendulum 44 12
bss
export pushed_p
align 4
LABELV pushed_p
skip 4
export pushed
align 4
LABELV pushed
skip 32768
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $522
byte 1 51
byte 1 48
byte 1 0
align 1
LABELV $516
byte 1 112
byte 1 104
byte 1 97
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $515
byte 1 51
byte 1 50
byte 1 0
align 1
LABELV $502
byte 1 102
byte 1 117
byte 1 110
byte 1 99
byte 1 95
byte 1 116
byte 1 114
byte 1 97
byte 1 105
byte 1 110
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 97
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $492
byte 1 112
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 99
byte 1 111
byte 1 114
byte 1 110
byte 1 101
byte 1 114
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $488
byte 1 112
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 99
byte 1 111
byte 1 114
byte 1 110
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $487
byte 1 84
byte 1 114
byte 1 97
byte 1 105
byte 1 110
byte 1 32
byte 1 99
byte 1 111
byte 1 114
byte 1 110
byte 1 101
byte 1 114
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 97
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 112
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 99
byte 1 111
byte 1 114
byte 1 110
byte 1 101
byte 1 114
byte 1 10
byte 1 0
align 1
LABELV $481
byte 1 84
byte 1 114
byte 1 97
byte 1 105
byte 1 110
byte 1 32
byte 1 99
byte 1 111
byte 1 114
byte 1 110
byte 1 101
byte 1 114
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 97
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $472
byte 1 102
byte 1 117
byte 1 110
byte 1 99
byte 1 95
byte 1 116
byte 1 114
byte 1 97
byte 1 105
byte 1 110
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 117
byte 1 110
byte 1 102
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $442
byte 1 52
byte 1 0
align 1
LABELV $437
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 115
byte 1 119
byte 1 105
byte 1 116
byte 1 99
byte 1 104
byte 1 101
byte 1 115
byte 1 47
byte 1 98
byte 1 117
byte 1 116
byte 1 110
byte 1 50
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $428
byte 1 104
byte 1 101
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $425
byte 1 49
byte 1 0
align 1
LABELV $424
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $423
byte 1 50
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $422
byte 1 115
byte 1 112
byte 1 101
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $421
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 116
byte 1 115
byte 1 47
byte 1 112
byte 1 116
byte 1 49
byte 1 95
byte 1 101
byte 1 110
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $420
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 116
byte 1 115
byte 1 47
byte 1 112
byte 1 116
byte 1 49
byte 1 95
byte 1 115
byte 1 116
byte 1 114
byte 1 116
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $387
byte 1 48
byte 1 0
align 1
LABELV $386
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $372
byte 1 50
byte 1 0
align 1
LABELV $371
byte 1 100
byte 1 109
byte 1 103
byte 1 0
align 1
LABELV $370
byte 1 56
byte 1 0
align 1
LABELV $369
byte 1 108
byte 1 105
byte 1 112
byte 1 0
align 1
LABELV $364
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 100
byte 1 111
byte 1 111
byte 1 114
byte 1 115
byte 1 47
byte 1 100
byte 1 114
byte 1 49
byte 1 95
byte 1 101
byte 1 110
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $363
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 100
byte 1 111
byte 1 111
byte 1 114
byte 1 115
byte 1 47
byte 1 100
byte 1 114
byte 1 49
byte 1 95
byte 1 115
byte 1 116
byte 1 114
byte 1 116
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $295
byte 1 49
byte 1 32
byte 1 49
byte 1 32
byte 1 49
byte 1 0
align 1
LABELV $294
byte 1 99
byte 1 111
byte 1 108
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $293
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $292
byte 1 49
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $291
byte 1 110
byte 1 111
byte 1 105
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $255
byte 1 82
byte 1 101
byte 1 97
byte 1 99
byte 1 104
byte 1 101
byte 1 100
byte 1 95
byte 1 66
byte 1 105
byte 1 110
byte 1 97
byte 1 114
byte 1 121
byte 1 77
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 58
byte 1 32
byte 1 98
byte 1 97
byte 1 100
byte 1 32
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 83
byte 1 116
byte 1 97
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $62
byte 1 112
byte 1 117
byte 1 115
byte 1 104
byte 1 101
byte 1 100
byte 1 95
byte 1 112
byte 1 32
byte 1 62
byte 1 32
byte 1 38
byte 1 112
byte 1 117
byte 1 115
byte 1 104
byte 1 101
byte 1 100
byte 1 91
byte 1 77
byte 1 65
byte 1 88
byte 1 95
byte 1 71
byte 1 69
byte 1 78
byte 1 84
byte 1 73
byte 1 84
byte 1 73
byte 1 69
byte 1 83
byte 1 93
byte 1 0
