export G_BounceMissile
code
proc G_BounceMissile 72 12
file "..\g_missile.c"
line 13
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:
;5:#define	MISSILE_PRESTEP_TIME	0;//50
;6:
;7:/*
;8:================
;9:G_BounceMissile
;10:
;11:================
;12:*/
;13:void G_BounceMissile( gentity_t *ent, trace_t *trace ) {
line 19
;14:	vec3_t	velocity;
;15:	float	dot;
;16:	int		hitTime;
;17:
;18:	// reflect the velocity on the trace plane
;19:	hitTime = level.previousTime + ( level.time - level.previousTime ) * trace->fraction;
ADDRLP4 16
ADDRGP4 level+36
INDIRI4
CVIF4 4
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+36
INDIRI4
SUBI4
CVIF4 4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 20
;20:	BG_EvaluateTrajectoryDelta( &ent->s.pos, hitTime, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 21
;21:	dot = DotProduct( velocity, trace->plane.normal );
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 0
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 22
;22:	VectorMA( trace->endpos, 2, trace->plane.normal, ent->r.currentOrigin);
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 24
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 0
INDIRP4
CNSTI4 480
ADDP4
ADDRLP4 28
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 28
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ADDRLP4 32
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 32
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 23
;23:	VectorCopy(trace->endpos, ent->s.pos.trBase);
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 24
;24:	ent->s.pos.trTime = hitTime;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 16
INDIRI4
ASGNI4
line 26
;25:		
;26:	VectorMA( velocity, -2*dot, trace->plane.normal, ent->s.pos.trDelta );
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 27
;27:	if ( ent->s.eFlags & EF_BOUNCE_HALF ) {
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $54
line 28
;28:		VectorScale( ent->s.pos.trDelta, 0.65, ent->s.pos.trDelta );
ADDRLP4 36
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
CNSTF4 1059481190
ADDRLP4 36
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
CNSTF4 1059481190
ADDRLP4 40
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTF4 1059481190
ADDRLP4 44
INDIRP4
INDIRF4
MULF4
ASGNF4
line 30
;29:		// check for stop
;30:		if ( trace->plane.normal[2] > 0.2 && VectorLength( ent->s.pos.trDelta ) < 40 ) 
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 1045220557
LEF4 $56
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 48
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 48
INDIRF4
CNSTF4 1109393408
GEF4 $56
line 31
;31:		{
line 32
;32:			G_SetOrigin( ent, trace->endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 34
;33:			//## Hentai ## - set it gently on the ground
;34:			if(ent->s.eType == ET_ITEM)
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $46
line 35
;35:			{
line 36
;36:				int dt = level.time - ent->s.pos.trTime;
ADDRLP4 52
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
ASGNI4
line 38
;37:				//CG_Printf("rest?\n");
;38:				if(ent->s.angles[PITCH] > dt / 10)
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
ADDRLP4 52
INDIRI4
CNSTI4 10
DIVI4
CVIF4 4
LEF4 $61
line 39
;39:					ent->s.angles[PITCH] -= dt / 10;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRLP4 52
INDIRI4
CNSTI4 10
DIVI4
CVIF4 4
SUBF4
ASGNF4
ADDRGP4 $59
JUMPV
LABELV $61
line 40
;40:				else if(ent->s.angles[PITCH] < -dt / 10)
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
ADDRLP4 52
INDIRI4
NEGI4
CNSTI4 10
DIVI4
CVIF4 4
GEF4 $63
line 41
;41:					ent->s.angles[PITCH] += dt / 10;
ADDRLP4 60
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 52
INDIRI4
CNSTI4 10
DIVI4
CVIF4 4
ADDF4
ASGNF4
ADDRGP4 $59
JUMPV
LABELV $63
line 43
;42:				else
;43:				{
line 44
;44:					ent->s.angles[PITCH] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 0
ASGNF4
line 45
;45:					if(ent->s.angles[ROLL] == 0)
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
CNSTF4 0
NEF4 $65
line 46
;46:					{
line 47
;47:						ent->s.angles[ROLL] = ((rand() & 1) * 2) - 1; // 1 or -1
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 68
CNSTI4 1
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 64
INDIRI4
ADDRLP4 68
INDIRI4
BANDI4
ADDRLP4 68
INDIRI4
LSHI4
ADDRLP4 68
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 48
;48:					}
ADDRGP4 $59
JUMPV
LABELV $65
line 49
;49:					else if(ent->s.angles[ROLL] > 0)
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
CNSTF4 0
LEF4 $67
line 50
;50:					{
line 51
;51:						ent->s.angles[ROLL] += dt / 10;
ADDRLP4 64
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 52
INDIRI4
CNSTI4 10
DIVI4
CVIF4 4
ADDF4
ASGNF4
line 52
;52:						if(ent->s.angles[ROLL] > 75)
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
CNSTF4 1117126656
LEF4 $59
line 53
;53:							ent->s.angles[ROLL] = 75;
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
CNSTF4 1117126656
ASGNF4
line 54
;54:					}
ADDRGP4 $59
JUMPV
LABELV $67
line 56
;55:					else 
;56:					{
line 57
;57:						ent->s.angles[ROLL] -= dt / 10;
ADDRLP4 64
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 52
INDIRI4
CNSTI4 10
DIVI4
CVIF4 4
SUBF4
ASGNF4
line 58
;58:						if(ent->s.angles[ROLL] < -75)
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
CNSTF4 3264610304
GEF4 $59
line 59
;59:							ent->s.angles[ROLL] = -75;
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
CNSTF4 3264610304
ASGNF4
line 60
;60:					}
line 61
;61:				}
line 63
;62:				
;63:			}
line 66
;64:			else
;65:			//## Hentai ##
;66:				return;
LABELV $59
line 67
;67:		}
LABELV $56
line 68
;68:	}
LABELV $54
line 73
;69:
;70:	//VectorAdd( ent->r.currentOrigin, trace->plane.normal, ent->r.currentOrigin);
;71:	
;72:	
;73:}
LABELV $46
endproc G_BounceMissile 72 12
export G_MissileImpact
proc G_MissileImpact 60 32
line 82
;74:
;75:
;76:/*
;77:================
;78:G_MissileImpact
;79:
;80:================
;81:*/
;82:void G_MissileImpact( gentity_t *ent, trace_t *trace ) {
line 84
;83:	gentity_t		*other;
;84:	qboolean		hitClient = qfalse;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 86
;85:
;86:	other = &g_entities[trace->entityNum];		
ADDRLP4 0
CNSTI4 792
ADDRFP4 4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 89
;87:	
;88:	// check for bounce
;89:	if ( !(other->takedamage && (g_ImpactGrenades.integer)) &&
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
EQI4 $77
ADDRGP4 g_ImpactGrenades+12
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $74
LABELV $77
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 48
BANDI4
CNSTI4 0
EQI4 $74
line 90
;90:		( ent->s.eFlags & ( EF_BOUNCE | EF_BOUNCE_HALF ) ) ) {
line 91
;91:		G_BounceMissile( ent, trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 G_BounceMissile
CALLV
pop
line 92
;92:		if(other->takedamage && other->client)		
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $78
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $78
line 93
;93:		{
line 95
;94:			vec3_t velocity;
;95:			VectorCopy(ent->s.pos.trDelta, velocity);
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 96
;96:			VectorNormalize(velocity);
ADDRLP4 16
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 97
;97:			VectorCopy(other->s.pos.trDelta, ent->s.pos.trDelta);
ADDRLP4 28
CNSTI4 36
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 103
;98:			/*
;99:			ent->s.pos.trDelta[0] = (ent->s.pos.trDelta[0] + other->s.pos.trDelta[0]) / 2;
;100:			ent->s.pos.trDelta[1] = (ent->s.pos.trDelta[1] + other->s.pos.trDelta[1]) / 2;
;101:			ent->s.pos.trDelta[2] = (ent->s.pos.trDelta[2] + other->s.pos.trDelta[2]) / 2;
;102:			*/
;103:			G_Damage (other, ent, &g_entities[ent->r.ownerNum], velocity,
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
CNSTI4 792
ADDRLP4 32
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 16
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
CNSTI4 2
ARGI4
CNSTI4 16
ARGI4
ADDRLP4 32
INDIRP4
CNSTI4 732
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 105
;104:				trace->endpos, 2, DAMAGE_NO_BLEEDING, ent->methodOfDeath);
;105:		}
ADDRGP4 $73
JUMPV
LABELV $78
line 107
;106:		else
;107:			G_AddEvent( ent, EV_GRENADE_BOUNCE, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 44
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 108
;108:		return;
ADDRGP4 $73
JUMPV
LABELV $74
line 112
;109:	}
;110:
;111:	// impact damage
;112:	if (other->takedamage) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $80
line 114
;113:		// FIXME: wrong damage direction?
;114:		if ( ent->damage ) {
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
CNSTI4 0
EQI4 $82
line 116
;115:			vec3_t	velocity;
;116:			int dflags = 0;
ADDRLP4 12
CNSTI4 0
ASGNI4
line 118
;117:
;118:			if( LogAccuracyHit( other, &g_entities[ent->r.ownerNum] ) ) {
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 28
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
EQI4 $84
line 119
;119:				g_entities[ent->r.ownerNum].client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 32
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 120
;120:				hitClient = qtrue;
ADDRLP4 4
CNSTI4 1
ASGNI4
line 121
;121:			}
LABELV $84
line 122
;122:			BG_EvaluateTrajectoryDelta( &ent->s.pos, level.time, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 16
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 123
;123:			if ( VectorLength( velocity ) == 0 ) {
ADDRLP4 16
ARGP4
ADDRLP4 32
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 32
INDIRF4
CNSTF4 0
NEF4 $88
line 124
;124:				velocity[2] = 1;	// stepped on a grenade
ADDRLP4 16+8
CNSTF4 1065353216
ASGNF4
line 125
;125:			}
LABELV $88
line 126
;126:			if(ent->s.eFlags & (EF_BOUNCE | EF_BOUNCE_HALF))
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 48
BANDI4
CNSTI4 0
EQI4 $91
line 127
;127:				dflags = 0; // grenades have shrapnel				
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 $92
JUMPV
LABELV $91
line 129
;128:			else
;129:				dflags = DAMAGE_NO_BLEEDING; 
ADDRLP4 12
CNSTI4 16
ASGNI4
LABELV $92
line 131
;130:
;131:				G_Damage (other, ent, &g_entities[ent->r.ownerNum], velocity, 
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
ARGP4
CNSTI4 792
ADDRLP4 36
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 16
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 36
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 36
INDIRP4
CNSTI4 732
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 133
;132:				trace->endpos, ent->damage, dflags, ent->methodOfDeath);
;133:		}
LABELV $82
line 134
;134:	}
LABELV $80
line 136
;135:
;136:	if (!strcmp(ent->classname, "hook")) {
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
INDIRP4
ARGP4
ADDRGP4 $95
ARGP4
ADDRLP4 12
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $93
line 140
;137:		gentity_t *nent;
;138:		vec3_t v;
;139:
;140:		nent = G_Spawn();
ADDRLP4 32
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 32
INDIRP4
ASGNP4
line 141
;141:		if ( other->takedamage && other->client ) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $96
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $96
line 143
;142:
;143:			if(other->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $98
line 144
;144:				G_AddEvent( nent, EV_MISSILE_HIT, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 40
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 16
INDIRP4
ARGP4
CNSTI4 49
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
ADDRGP4 $99
JUMPV
LABELV $98
line 146
;145:			else
;146:				G_AddEvent( nent, EV_MISSILE_HIT_ROBOT, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 44
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 16
INDIRP4
ARGP4
CNSTI4 71
ARGI4
ADDRLP4 44
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
LABELV $99
line 149
;147:		
;148:			
;149:			nent->s.otherEntityNum = other->s.number;
ADDRLP4 16
INDIRP4
CNSTI4 140
ADDP4
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 151
;150:
;151:			ent->enemy = other;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 153
;152:
;153:			v[0] = other->r.currentOrigin[0] + (other->r.mins[0] + other->r.maxs[0]) * 0.5;
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 154
;154:			v[1] = other->r.currentOrigin[1] + (other->r.mins[1] + other->r.maxs[1]) * 0.5;
ADDRLP4 20+4
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 0
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 155
;155:			v[2] = other->r.currentOrigin[2] + (other->r.mins[2] + other->r.maxs[2]) * 0.5;
ADDRLP4 20+8
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 0
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 157
;156:
;157:			SnapVectorTowards( v, ent->s.pos.trBase );	// save net bandwidth
ADDRLP4 20
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 158
;158:		} else {
ADDRGP4 $97
JUMPV
LABELV $96
line 160
;159:			//VectorCopy(trace->endpos, v);
;160:			VectorMA( trace->endpos, 2, trace->plane.normal, v );
ADDRLP4 40
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 44
CNSTF4 1073741824
ASGNF4
ADDRLP4 20
ADDRLP4 40
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRLP4 44
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 20+4
ADDRLP4 40
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRLP4 44
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 48
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 20+8
ADDRLP4 48
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 48
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 162
;161:			
;162:			G_AddEvent( nent, EV_MISSILE_MISS, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 52
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRLP4 16
INDIRP4
ARGP4
CNSTI4 50
ARGI4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 163
;163:			ent->enemy = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
CNSTP4 0
ASGNP4
line 166
;164:			
;165:
;166:		}
LABELV $97
line 168
;167:
;168:		SnapVectorTowards( v, ent->s.pos.trBase );	// save net bandwidth
ADDRLP4 20
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 170
;169:
;170:		nent->freeAfterEvent = qtrue;
ADDRLP4 16
INDIRP4
CNSTI4 544
ADDP4
CNSTI4 1
ASGNI4
line 172
;171:		// change over to a normal entity right at the point of impact
;172:		nent->s.eType = ET_GENERAL;
ADDRLP4 16
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 173
;173:		ent->s.eType = ET_GRAPPLE;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 11
ASGNI4
line 175
;174:
;175:		G_SetOrigin( ent, v );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 176
;176:		G_SetOrigin( nent, v );
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 178
;177:
;178:		ent->think = Weapon_HookThink;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Weapon_HookThink
ASGNP4
line 179
;179:		ent->nextthink = level.time + FRAMETIME;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 181
;180:
;181:		ent->parent->client->ps.pm_flags |= PMF_GRAPPLE_PULL;
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
CNSTI4 2048
BORI4
ASGNI4
line 182
;182:		VectorCopy( ent->r.currentOrigin, ent->parent->client->ps.grapplePoint);
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 44
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 184
;183:
;184:		trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 185
;185:		trap_LinkEntity( nent );
ADDRLP4 16
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 187
;186:
;187:		return;
ADDRGP4 $73
JUMPV
LABELV $93
line 193
;188:	}
;189:
;190:	// is it cheaper in bandwidth to just remove this ent and create a new
;191:	// one, rather than changing the missile into the explosion?
;192:
;193:	if ( other->takedamage && other->client ) {
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
EQI4 $105
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $105
line 195
;194:			
;195:		if(other->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $107
line 196
;196:			G_AddEvent( ent, EV_MISSILE_HIT, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 20
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 49
ARGI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
ADDRGP4 $108
JUMPV
LABELV $107
line 198
;197:		else
;198:			G_AddEvent( ent, EV_MISSILE_HIT_ROBOT, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 24
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 71
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
LABELV $108
line 200
;199:		
;200:		ent->s.otherEntityNum = other->s.number;
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 201
;201:	} else {
ADDRGP4 $106
JUMPV
LABELV $105
line 202
;202:		VectorMA( trace->endpos, 2, trace->plane.normal, ent->s.pos.trBase);
ADDRLP4 20
CNSTI4 24
ASGNI4
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 0
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 24
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 28
CNSTI4 28
ASGNI4
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
ADDRLP4 32
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 32
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 36
CNSTI4 32
ASGNI4
ADDRLP4 40
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 0
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 40
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 203
;203:		ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 205
;204:		
;205:		G_AddEvent( ent, EV_MISSILE_MISS, DirToByte( trace->plane.normal ) );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 44
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 50
ARGI4
ADDRLP4 44
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 206
;206:	}
LABELV $106
line 208
;207:
;208:	ent->freeAfterEvent = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 544
ADDP4
CNSTI4 1
ASGNI4
line 211
;209:
;210:	// change over to a normal entity right at the point of impact
;211:	ent->s.eType = ET_GENERAL;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 213
;212:
;213:	SnapVectorTowards( trace->endpos, ent->s.pos.trBase );	// save net bandwidth
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRGP4 SnapVectorTowards
CALLV
pop
line 215
;214:
;215:	G_SetOrigin( ent, trace->endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 218
;216:
;217:	// splash damage (doesn't apply to person directly hit)
;218:	if ( ent->splashDamage ) {
ADDRFP4 0
INDIRP4
CNSTI4 724
ADDP4
INDIRI4
CNSTI4 0
EQI4 $110
line 219
;219:		if( G_RadiusDamage( trace->endpos, ent->parent, ent->splashDamage, ent->splashRadius, 
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
ARGP4
ADDRLP4 20
INDIRP4
CNSTI4 724
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 20
INDIRP4
CNSTI4 728
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 20
INDIRP4
CNSTI4 736
ADDP4
INDIRI4
ARGI4
ADDRLP4 24
ADDRGP4 G_RadiusDamage
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 0
EQI4 $112
line 220
;220:			other, ent->splashMethodOfDeath ) ) {
line 221
;221:			if( !hitClient ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $114
line 222
;222:				g_entities[ent->r.ownerNum].client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 28
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 223
;223:			}
LABELV $114
line 224
;224:		}
LABELV $112
line 225
;225:	}
LABELV $110
line 227
;226:
;227:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 228
;228:}
LABELV $73
endproc G_MissileImpact 60 32
export G_ExplodeMissile
proc G_ExplodeMissile 44 24
line 237
;229:
;230:/*
;231:================
;232:G_ExplodeMissile
;233:
;234:Explode a missile without an impact
;235:================
;236:*/
;237:void G_ExplodeMissile( gentity_t *ent ) {
line 241
;238:	vec3_t		dir;
;239:	vec3_t		origin;
;240:
;241:	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 242
;242:	SnapVector( origin );
ADDRLP4 0
ADDRLP4 0
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 243
;243:	G_SetOrigin( ent, origin );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 246
;244:
;245:	// we don't have a valid direction, so just point straight up
;246:	dir[0] = dir[1] = 0;
ADDRLP4 24
CNSTF4 0
ASGNF4
ADDRLP4 12+4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 24
INDIRF4
ASGNF4
line 247
;247:	dir[2] = 1;
ADDRLP4 12+8
CNSTF4 1065353216
ASGNF4
line 249
;248:
;249:	ent->s.eType = ET_GENERAL;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 250
;250:	G_AddEvent( ent, EV_MISSILE_MISS, DirToByte( dir ) );
ADDRLP4 12
ARGP4
ADDRLP4 28
ADDRGP4 DirToByte
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 50
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 252
;251:
;252:	ent->freeAfterEvent = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 544
ADDP4
CNSTI4 1
ASGNI4
line 255
;253:
;254:	// splash damage
;255:	if ( ent->splashDamage ) {
ADDRFP4 0
INDIRP4
CNSTI4 724
ADDP4
INDIRI4
CNSTI4 0
EQI4 $125
line 256
;256:		if( G_RadiusDamage( ent->r.currentOrigin, ent->parent, ent->splashDamage, ent->splashRadius, NULL
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 724
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 32
INDIRP4
CNSTI4 728
ADDP4
INDIRI4
CVIF4 4
ARGF4
CNSTP4 0
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 736
ADDP4
INDIRI4
ARGI4
ADDRLP4 36
ADDRGP4 G_RadiusDamage
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $127
line 257
;257:			, ent->splashMethodOfDeath ) ) {
line 258
;258:			g_entities[ent->r.ownerNum].client->ps.persistant[PERS_ACCURACY_HITS]++;
ADDRLP4 40
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 300
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 259
;259:		}
LABELV $127
line 260
;260:	}
LABELV $125
line 262
;261:
;262:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 263
;263:}
LABELV $117
endproc G_ExplodeMissile 44 24
export G_RunMissile
proc G_RunMissile 144 28
line 272
;264:
;265:
;266:/*
;267:================
;268:G_RunMissile
;269:
;270:================
;271:*/
;272:void G_RunMissile( gentity_t *ent ) {
line 275
;273:	vec3_t		origin, velocity;
;274:	trace_t		tr;
;275:	float dt = (level.time - ent->s.pos.trTime) * 0.001;
ADDRLP4 56
CNSTF4 981668463
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 278
;276:	vec3_t forward;
;277:	
;278:	if((ent->methodOfDeath == MOD_ROCKET) && (g_RocketAccel.value || g_RocketVeer.value))
ADDRFP4 0
INDIRP4
CNSTI4 732
ADDP4
INDIRI4
CNSTI4 6
NEI4 $132
ADDRLP4 96
CNSTF4 0
ASGNF4
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 96
INDIRF4
NEF4 $136
ADDRGP4 g_RocketVeer+8
INDIRF4
ADDRLP4 96
INDIRF4
EQF4 $132
LABELV $136
line 279
;279:	{
line 280
;280:		ent->s.angles[0] += crandom() * g_RocketVeer.value * dt;
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 104
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ASGNP4
ADDRLP4 104
INDIRP4
ADDRLP4 104
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRGP4 g_RocketVeer+8
INDIRF4
MULF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
line 281
;281:		ent->s.angles[1] += crandom() * g_RocketVeer.value * dt;
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 112
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRGP4 g_RocketVeer+8
INDIRF4
MULF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
line 282
;282:		ent->s.angles[2] += crandom() * g_RocketVeer.value * dt;
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 120
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
ASGNP4
ADDRLP4 120
INDIRP4
ADDRLP4 120
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 116
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRGP4 g_RocketVeer+8
INDIRF4
MULF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
line 283
;283:		AngleVectors(ent->s.angles, forward, NULL, NULL);		
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 60
ARGP4
ADDRLP4 124
CNSTP4 0
ASGNP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 284
;284:		VectorMA(ent->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, ent->s.pos.trDelta);
ADDRLP4 128
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRF4
ADDRLP4 60
INDIRF4
CNSTF4 1056964608
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 132
INDIRP4
ADDRLP4 132
INDIRP4
INDIRF4
ADDRLP4 60+4
INDIRF4
CNSTF4 1056964608
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 136
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 136
INDIRP4
INDIRF4
ADDRLP4 60+8
INDIRF4
CNSTF4 1056964608
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
MULF4
MULF4
ADDF4
ASGNF4
line 285
;285:	}
LABELV $132
line 288
;286:	// get current position
;287:
;288:	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 72
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 289
;289:	BG_EvaluateTrajectoryDelta( &ent->s.pos, level.time, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 84
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 292
;290:	// trace a line from the previous position to the current position,
;291:	// ignoring interactions with the missile owner
;292:	trap_Trace( &tr, ent->r.currentOrigin, ent->r.mins, ent->r.maxs, origin, 
ADDRLP4 0
ARGP4
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 100
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRLP4 100
INDIRP4
CNSTI4 424
ADDP4
ARGP4
ADDRLP4 100
INDIRP4
CNSTI4 436
ADDP4
ARGP4
ADDRLP4 72
ARGP4
ADDRLP4 100
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
ARGI4
ADDRLP4 100
INDIRP4
CNSTI4 560
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 297
;293:		ent->r.ownerNum, ent->clipmask );
;294:
;295:
;296:
;297:	if ( tr.startsolid ) {
ADDRLP4 0+4
INDIRI4
CNSTI4 0
EQI4 $147
line 299
;298:		//G_Printf("???");
;299:		tr.fraction = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 300
;300:	}
LABELV $147
line 302
;301:
;302:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 303
;303:	VectorCopy(tr.endpos, ent->r.currentOrigin);
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 0+12
INDIRB
ASGNB 12
line 304
;304:	if ( tr.fraction != 1.0 ) {
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
EQF4 $152
line 306
;305:		// never explode or bounce on sky
;306:		if ( tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 0+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $155
line 308
;307:			// If grapple, reset owner
;308:			if (ent->parent && ent->parent->client->hook == ent)
ADDRLP4 104
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
ADDRLP4 104
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
ASGNP4
ADDRLP4 108
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $158
ADDRLP4 108
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 104
INDIRP4
CVPU4 4
NEU4 $158
line 309
;309:				ent->parent->client->hook = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 708
ADDP4
CNSTP4 0
ASGNP4
LABELV $158
line 310
;310:			G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 311
;311:			return;
ADDRGP4 $130
JUMPV
LABELV $155
line 313
;312:		}
;313:		if((ent->methodOfDeath == MOD_ROCKET) && (tr.plane.normal[0] == -1 || tr.plane.normal[1] == -1 || tr.plane.normal[2] == -1))
ADDRFP4 0
INDIRP4
CNSTI4 732
ADDP4
INDIRI4
CNSTI4 6
NEI4 $160
ADDRLP4 104
CNSTF4 3212836864
ASGNF4
ADDRLP4 0+24
INDIRF4
ADDRLP4 104
INDIRF4
EQF4 $168
ADDRLP4 0+24+4
INDIRF4
ADDRLP4 104
INDIRF4
EQF4 $168
ADDRLP4 0+24+8
INDIRF4
ADDRLP4 104
INDIRF4
NEF4 $160
LABELV $168
line 314
;314:		{ // for some reason these specific angles don't show up
line 315
;315:			tr.plane.normal[0] += crandom() * 0.125;
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+24
ADDRLP4 0+24
INDIRF4
CNSTF4 1040187392
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 316
;316:			tr.plane.normal[1] += crandom() * 0.125;
ADDRLP4 112
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+24+4
ADDRLP4 0+24+4
INDIRF4
CNSTF4 1040187392
CNSTF4 1073741824
ADDRLP4 112
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 317
;317:			tr.plane.normal[2] += crandom() * 0.125;
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+24+8
ADDRLP4 0+24+8
INDIRF4
CNSTF4 1040187392
CNSTF4 1073741824
ADDRLP4 116
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 318
;318:			VectorNormalize(tr.plane.normal);
ADDRLP4 0+24
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 319
;319:		}
LABELV $160
line 321
;320:	
;321:		G_MissileImpact( ent, &tr );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_MissileImpact
CALLV
pop
line 322
;322:		if ( ent->s.eType != ET_MISSILE ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
EQI4 $153
line 323
;323:			return;		// exploded
ADDRGP4 $130
JUMPV
line 325
;324:		}
;325:	}
LABELV $152
line 328
;326:
;327:	else 
;328:	{
line 330
;329:		
;330:		if((ent->methodOfDeath == MOD_ROCKET) && (g_RocketAccel.value || g_RocketVeer.value))
ADDRFP4 0
INDIRP4
CNSTI4 732
ADDP4
INDIRI4
CNSTI4 6
NEI4 $177
ADDRLP4 104
CNSTF4 0
ASGNF4
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 104
INDIRF4
NEF4 $181
ADDRGP4 g_RocketVeer+8
INDIRF4
ADDRLP4 104
INDIRF4
EQF4 $177
LABELV $181
line 331
;331:		{
line 332
;332:			VectorMA(ent->s.pos.trBase, dt, ent->s.pos.trDelta, ent->s.pos.trBase);
ADDRLP4 108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 112
ADDRLP4 108
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRF4
ADDRLP4 108
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 116
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 120
ADDRLP4 116
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 120
INDIRP4
ADDRLP4 120
INDIRP4
INDIRF4
ADDRLP4 116
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 128
ADDRLP4 124
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRF4
ADDRLP4 124
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
line 333
;333:			VectorMA(ent->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, ent->s.pos.trDelta);
ADDRLP4 132
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 132
INDIRP4
ADDRLP4 132
INDIRP4
INDIRF4
ADDRLP4 60
INDIRF4
CNSTF4 1056964608
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 136
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 136
INDIRP4
INDIRF4
ADDRLP4 60+4
INDIRF4
CNSTF4 1056964608
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 140
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 140
INDIRP4
ADDRLP4 140
INDIRP4
INDIRF4
ADDRLP4 60+8
INDIRF4
CNSTF4 1056964608
ADDRGP4 g_RocketAccel+8
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
MULF4
MULF4
ADDF4
ASGNF4
line 334
;334:			ent->s.pos.trType = TR_INTERPOLATE;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 1
ASGNI4
line 335
;335:			ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 336
;336:		}
LABELV $177
line 337
;337:	}
LABELV $153
line 339
;338:	// check think function after bouncing
;339:	G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 340
;340:}
LABELV $130
endproc G_RunMissile 144 28
export fire_plasma
proc fire_plasma 32 4
line 351
;341:
;342:
;343://=============================================================================
;344:
;345:/*
;346:=================
;347:fire_plasma
;348:
;349:=================
;350:*/
;351:gentity_t *fire_plasma (gentity_t *self, vec3_t start, vec3_t dir) {
line 354
;352:	gentity_t	*bolt;
;353:
;354:	VectorNormalize (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 356
;355:
;356:	bolt = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 357
;357:	bolt->classname = "plasma";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $189
ASGNP4
line 358
;358:	bolt->nextthink = level.time + 10000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 359
;359:	bolt->think = G_ExplodeMissile;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_ExplodeMissile
ASGNP4
line 360
;360:	bolt->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 361
;361:	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 128
ASGNI4
line 362
;362:	bolt->s.weapon = WP_PLASMAGUN;
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 8
ASGNI4
line 363
;363:	bolt->r.ownerNum = self->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 500
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 364
;364:	bolt->parent = self;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 365
;365:	bolt->damage = 20;
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 20
ASGNI4
line 366
;366:	bolt->splashDamage = 15;
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
CNSTI4 15
ASGNI4
line 367
;367:	bolt->splashRadius = 20;
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTI4 20
ASGNI4
line 368
;368:	bolt->methodOfDeath = MOD_PLASMA;
ADDRLP4 0
INDIRP4
CNSTI4 732
ADDP4
CNSTI4 8
ASGNI4
line 369
;369:	bolt->splashMethodOfDeath = MOD_PLASMA_SPLASH;
ADDRLP4 0
INDIRP4
CNSTI4 736
ADDP4
CNSTI4 9
ASGNI4
line 370
;370:	bolt->clipmask = MASK_SHOT;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 100663297
ASGNI4
line 371
;371:	bolt->r.mins[0] = -4;
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
CNSTF4 3229614080
ASGNF4
line 372
;372:	bolt->r.mins[1] = -4;
ADDRLP4 0
INDIRP4
CNSTI4 428
ADDP4
CNSTF4 3229614080
ASGNF4
line 373
;373:	bolt->r.mins[2] = -4;
ADDRLP4 0
INDIRP4
CNSTI4 432
ADDP4
CNSTF4 3229614080
ASGNF4
line 374
;374:	bolt->r.maxs[0] = 4;
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
CNSTF4 1082130432
ASGNF4
line 375
;375:	bolt->r.maxs[1] = 4;
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
CNSTF4 1082130432
ASGNF4
line 376
;376:	bolt->r.maxs[2] = 4;
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTF4 1082130432
ASGNF4
line 377
;377:	bolt->s.pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 378
;378:	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 379
;379:	VectorCopy( start, bolt->s.pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 380
;380:	VectorScale( dir, 2000, bolt->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1157234688
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1157234688
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1157234688
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 381
;381:	if(g_MissilesAddVelocity.value)
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
CNSTF4 0
EQF4 $192
line 382
;382:		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $192
line 384
;383:	
;384:	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 386
;385:
;386:	VectorCopy (start, bolt->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 388
;387:
;388:	return bolt;
ADDRLP4 0
INDIRP4
RETP4
LABELV $188
endproc fire_plasma 32 4
export fire_grenade
proc fire_grenade 32 4
line 399
;389:}	
;390:
;391://=============================================================================
;392:
;393:
;394:/*
;395:=================
;396:fire_grenade
;397:=================
;398:*/
;399:gentity_t *fire_grenade (gentity_t *self, vec3_t start, vec3_t dir) {
line 402
;400:	gentity_t	*bolt;
;401:
;402:	VectorNormalize (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 404
;403:
;404:	bolt = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 405
;405:	bolt->classname = "grenade";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $199
ASGNP4
line 406
;406:	bolt->nextthink = level.time + 2500;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 2500
ADDI4
ASGNI4
line 407
;407:	bolt->think = G_ExplodeMissile;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_ExplodeMissile
ASGNP4
line 408
;408:	bolt->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 409
;409:	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 128
ASGNI4
line 410
;410:	bolt->s.weapon = WP_GRENADE_LAUNCHER;
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 4
ASGNI4
line 411
;411:	bolt->s.eFlags = EF_BOUNCE_HALF;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 32
ASGNI4
line 412
;412:	bolt->r.ownerNum = self->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 500
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 413
;413:	bolt->parent = self;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 414
;414:	bolt->damage = 100;
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 100
ASGNI4
line 415
;415:	bolt->splashDamage = 100;
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
CNSTI4 100
ASGNI4
line 416
;416:	bolt->splashRadius = 200;
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTI4 200
ASGNI4
line 417
;417:	bolt->methodOfDeath = MOD_GRENADE;
ADDRLP4 0
INDIRP4
CNSTI4 732
ADDP4
CNSTI4 4
ASGNI4
line 418
;418:	bolt->splashMethodOfDeath = MOD_GRENADE_SPLASH;
ADDRLP4 0
INDIRP4
CNSTI4 736
ADDP4
CNSTI4 5
ASGNI4
line 419
;419:	bolt->clipmask = MASK_SHOT;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 100663297
ASGNI4
line 420
;420:	bolt->r.mins[0] = -1;
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
CNSTF4 3212836864
ASGNF4
line 421
;421:	bolt->r.mins[1] = -1;
ADDRLP4 0
INDIRP4
CNSTI4 428
ADDP4
CNSTF4 3212836864
ASGNF4
line 422
;422:	bolt->r.mins[2] = -1;
ADDRLP4 0
INDIRP4
CNSTI4 432
ADDP4
CNSTF4 3212836864
ASGNF4
line 423
;423:	bolt->r.maxs[0] = 1;
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
CNSTF4 1065353216
ASGNF4
line 424
;424:	bolt->r.maxs[1] = 1;
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
CNSTF4 1065353216
ASGNF4
line 425
;425:	bolt->r.maxs[2] = 1;
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTF4 1065353216
ASGNF4
line 427
;426:	
;427:	bolt->s.pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 428
;428:	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 429
;429:	VectorCopy( start, bolt->s.pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 430
;430:	VectorScale( dir, 700, bolt->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1143930880
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1143930880
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1143930880
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 431
;431:	if(g_MissilesAddVelocity.value)
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
CNSTF4 0
EQF4 $202
line 432
;432:		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $202
line 434
;433:	
;434:	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 436
;435:
;436:	VectorCopy (start, bolt->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 438
;437:
;438:	return bolt;
ADDRLP4 0
INDIRP4
RETP4
LABELV $198
endproc fire_grenade 32 4
export fire_bfg
proc fire_bfg 32 4
line 449
;439:}
;440:
;441://=============================================================================
;442:
;443:
;444:/*
;445:=================
;446:fire_bfg
;447:=================
;448:*/
;449:gentity_t *fire_bfg (gentity_t *self, vec3_t start, vec3_t dir) {
line 452
;450:	gentity_t	*bolt;
;451:
;452:	VectorNormalize (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 454
;453:
;454:	bolt = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 455
;455:	bolt->classname = "bfg";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $209
ASGNP4
line 456
;456:	bolt->nextthink = level.time + 10000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 457
;457:	bolt->think = G_ExplodeMissile;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_ExplodeMissile
ASGNP4
line 458
;458:	bolt->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 459
;459:	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 128
ASGNI4
line 460
;460:	bolt->s.weapon = WP_BFG;
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 9
ASGNI4
line 461
;461:	bolt->r.ownerNum = self->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 500
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 462
;462:	bolt->parent = self;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 463
;463:	bolt->damage = 100;
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 100
ASGNI4
line 464
;464:	bolt->splashDamage = 100;
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
CNSTI4 100
ASGNI4
line 465
;465:	bolt->splashRadius = 120;
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTI4 120
ASGNI4
line 466
;466:	bolt->methodOfDeath = MOD_BFG;
ADDRLP4 0
INDIRP4
CNSTI4 732
ADDP4
CNSTI4 12
ASGNI4
line 467
;467:	bolt->splashMethodOfDeath = MOD_BFG_SPLASH;
ADDRLP4 0
INDIRP4
CNSTI4 736
ADDP4
CNSTI4 13
ASGNI4
line 468
;468:	bolt->clipmask = MASK_SHOT;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 100663297
ASGNI4
line 470
;469:
;470:	bolt->s.pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 471
;471:	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 472
;472:	VectorCopy( start, bolt->s.pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 473
;473:	VectorScale( dir, 2000, bolt->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1157234688
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1157234688
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1157234688
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 474
;474:	if(g_MissilesAddVelocity.value)
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
CNSTF4 0
EQF4 $212
line 475
;475:		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $212
line 476
;476:	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 477
;477:	VectorCopy (start, bolt->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 479
;478:
;479:	return bolt;
ADDRLP4 0
INDIRP4
RETP4
LABELV $208
endproc fire_bfg 32 4
export fire_rocket
proc fire_rocket 32 8
line 518
;480:}
;481:
;482://=============================================================================
;483:
;484:
;485:/*void RocketThink( gentity_t *self )
;486:{
;487:	vec3_t forward;
;488:	
;489:	self->nextthink +=10;
;490:	
;491:	self->count++;
;492:	if(self->count >= 100)
;493:	{
;494:		G_ExplodeMissile(self);
;495:		return;
;496:	}
;497:	if(g_RocketAccel.value || g_RocketVeer.value)
;498:	{
;499:		float dt = (level.time - self->s.pos.trTime) * 0.001;
;500:		self->s.angles[0] += crandom() * g_RocketVeer.value * dt;
;501:		self->s.angles[1] += crandom() * g_RocketVeer.value * dt;
;502:		self->s.angles[2] += crandom() * g_RocketVeer.value * dt;
;503:		AngleVectors(self->s.angles, forward, NULL, NULL);		
;504:		//VectorScale(self->s.pos.trDelta, 0.9, self->s.pos.trDelta );
;505:		VectorMA(self->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, self->s.pos.trDelta);
;506:		VectorMA(self->s.pos.trBase, dt, self->s.pos.trDelta, self->s.pos.trBase);
;507:		VectorMA(self->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, self->s.pos.trDelta);
;508:		self->s.pos.trType = TR_INTERPOLATE;
;509:		self->s.pos.trTime = level.time;
;510:	}
;511:	
;512:}*/
;513:/*
;514:=================
;515:fire_rocket
;516:=================
;517:*/
;518:gentity_t *fire_rocket (gentity_t *self, vec3_t start, vec3_t dir) {
line 521
;519:	gentity_t	*bolt;
;520:
;521:	VectorNormalize (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 523
;522:
;523:	bolt = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 524
;524:	bolt->classname = "rocket";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $219
ASGNP4
line 525
;525:	bolt->nextthink = level.time + 10000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 526
;526:	bolt->think = G_ExplodeMissile;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_ExplodeMissile
ASGNP4
line 527
;527:	bolt->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 528
;528:	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 128
ASGNI4
line 529
;529:	bolt->s.weapon = WP_ROCKET_LAUNCHER;
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 5
ASGNI4
line 530
;530:	bolt->r.ownerNum = self->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 500
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 531
;531:	bolt->parent = self;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 532
;532:	bolt->damage = 150;
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 150
ASGNI4
line 533
;533:	bolt->splashDamage = 100;
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
CNSTI4 100
ASGNI4
line 534
;534:	bolt->splashRadius = 150;
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTI4 150
ASGNI4
line 535
;535:	bolt->methodOfDeath = MOD_ROCKET;
ADDRLP4 0
INDIRP4
CNSTI4 732
ADDP4
CNSTI4 6
ASGNI4
line 536
;536:	bolt->splashMethodOfDeath = MOD_ROCKET_SPLASH;
ADDRLP4 0
INDIRP4
CNSTI4 736
ADDP4
CNSTI4 7
ASGNI4
line 537
;537:	bolt->clipmask = MASK_SHOT;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 100663297
ASGNI4
line 538
;538:	bolt->count = 0;
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
CNSTI4 0
ASGNI4
line 539
;539:	bolt->s.pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 540
;540:	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 541
;541:	VectorCopy( start, bolt->s.pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 542
;542:	bolt->r.mins[0] = -2;
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
CNSTF4 3221225472
ASGNF4
line 543
;543:	bolt->r.mins[1] = -2;
ADDRLP4 0
INDIRP4
CNSTI4 428
ADDP4
CNSTF4 3221225472
ASGNF4
line 544
;544:	bolt->r.mins[2] = -2;
ADDRLP4 0
INDIRP4
CNSTI4 432
ADDP4
CNSTF4 3221225472
ASGNF4
line 545
;545:	bolt->r.maxs[0] = 2;
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
CNSTF4 1073741824
ASGNF4
line 546
;546:	bolt->r.maxs[1] = 2;
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
CNSTF4 1073741824
ASGNF4
line 547
;547:	bolt->r.maxs[2] = 2;
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTF4 1073741824
ASGNF4
line 549
;548:		
;549:	vectoangles(dir, bolt->s.angles);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 550
;550:	VectorScale( dir, g_RocketSpeed.value, bolt->s.pos.trDelta );	
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 8
INDIRP4
INDIRF4
ADDRGP4 g_RocketSpeed+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 g_RocketSpeed+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 g_RocketSpeed+8
INDIRF4
MULF4
ASGNF4
line 551
;551:	if(g_MissilesAddVelocity.value)
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
CNSTF4 0
EQF4 $225
line 552
;552:		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 g_MissilesAddVelocity+8
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $225
line 553
;553:	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 554
;554:	VectorCopy (start, bolt->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 555
;555:	return bolt;
ADDRLP4 0
INDIRP4
RETP4
LABELV $218
endproc fire_rocket 32 8
export fire_grapple
proc fire_grapple 20 4
line 563
;556:}
;557:
;558:/*
;559:=================
;560:fire_grapple
;561:=================
;562:*/
;563:gentity_t *fire_grapple (gentity_t *self, vec3_t start, vec3_t dir) {
line 566
;564:	gentity_t	*hook;
;565:
;566:	VectorNormalize (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 568
;567:
;568:	hook = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 569
;569:	hook->classname = "hook";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $95
ASGNP4
line 570
;570:	hook->nextthink = level.time + 10000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 571
;571:	hook->think = Weapon_HookFree;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Weapon_HookFree
ASGNP4
line 572
;572:	hook->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 573
;573:	hook->r.svFlags = SVF_USE_CURRENT_ORIGIN;
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 128
ASGNI4
line 574
;574:	hook->s.weapon = WP_GRAPPLING_HOOK;
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 -1
ASGNI4
line 575
;575:	hook->r.ownerNum = self->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 500
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 576
;576:	hook->methodOfDeath = MOD_GRAPPLE;
ADDRLP4 0
INDIRP4
CNSTI4 732
ADDP4
CNSTI4 23
ASGNI4
line 577
;577:	hook->clipmask = MASK_SHOT;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 100663297
ASGNI4
line 578
;578:	hook->parent = self;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 580
;579:
;580:	hook->s.pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 581
;581:	hook->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 582
;582:	hook->s.otherEntityNum = self->s.number; // use to match beam in client
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 583
;583:	VectorCopy( start, hook->s.pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 584
;584:	VectorScale( dir, 800, hook->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1145569280
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1145569280
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1145569280
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 586
;585:	
;586:	SnapVector( hook->s.pos.trDelta );			// save net bandwidth
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 587
;587:	VectorCopy (start, hook->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 589
;588:
;589:	self->client->hook = hook;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 708
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 591
;590:
;591:	return hook;
ADDRLP4 0
INDIRP4
RETP4
LABELV $231
endproc fire_grapple 20 4
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_blaster
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $219
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $209
byte 1 98
byte 1 102
byte 1 103
byte 1 0
align 1
LABELV $199
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $189
byte 1 112
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 0
align 1
LABELV $95
byte 1 104
byte 1 111
byte 1 111
byte 1 107
byte 1 0
