export Pickup_Powerup
code
proc Pickup_Powerup 132 28
file "..\g_items.c"
line 30
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:
;5:/*
;6:
;7:  Items are any object that a player can touch to gain some effect.
;8:
;9:  Pickup will return the number of seconds until they should respawn.
;10:
;11:  all items should pop when dropped in lava or slime
;12:
;13:  Respawnable items don't actually go away when picked up, they are
;14:  just made invisible and untouchable.  This allows them to ride
;15:  movers and respawn apropriately.
;16:*/
;17:
;18:
;19:#define	RESPAWN_ARMOR		25
;20:#define	RESPAWN_TEAM_WEAPON	30
;21:#define	RESPAWN_HEALTH		35
;22:#define	RESPAWN_AMMO		40
;23:#define	RESPAWN_HOLDABLE	60
;24:#define	RESPAWN_MEGAHEALTH	120
;25:#define	RESPAWN_POWERUP		120
;26:
;27:
;28://======================================================================
;29:
;30:int Pickup_Powerup( gentity_t *ent, gentity_t *other ) {
line 35
;31:	int			quantity;
;32:	int			i;
;33:	gclient_t	*client;
;34:
;35:	if ( !other->client->ps.powerups[ent->item->giTag] ) {
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $47
line 38
;36:		// round timing to seconds to make multiple powerup timers
;37:		// count in sync
;38:		other->client->ps.powerups[ent->item->giTag] = 
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
MODI4
SUBI4
ASGNI4
line 40
;39:			level.time - ( level.time % 1000 );
;40:	}
LABELV $47
line 42
;41:
;42:	if ( ent->count ) {
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
EQI4 $51
line 43
;43:		quantity = ent->count;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
ASGNI4
line 44
;44:	} else {
ADDRGP4 $52
JUMPV
LABELV $51
line 45
;45:		quantity = ent->item->quantity;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ASGNI4
line 46
;46:	}
LABELV $52
line 48
;47:
;48:	other->client->ps.powerups[ent->item->giTag] += quantity * 1000;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1000
ADDRLP4 8
INDIRI4
MULI4
ADDI4
ASGNI4
line 51
;49:
;50:	// give any nearby players a "denied" anti-reward
;51:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $56
JUMPV
LABELV $53
line 57
;52:		vec3_t		delta;
;53:		float		len;
;54:		vec3_t		forward;
;55:		trace_t		tr;
;56:
;57:		client = &level.clients[i];
ADDRLP4 0
CNSTI4 760
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 58
;58:		if ( client == other->client ) {
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
NEU4 $58
line 59
;59:			continue;
ADDRGP4 $54
JUMPV
LABELV $58
line 61
;60:		}
;61:		if ( client->pers.connected == CON_DISCONNECTED ) {
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 0
NEI4 $60
line 62
;62:			continue;
ADDRGP4 $54
JUMPV
LABELV $60
line 64
;63:		}
;64:		if ( client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $62
line 65
;65:			continue;
ADDRGP4 $54
JUMPV
LABELV $62
line 70
;66:		}
;67:
;68:    // if same team in team game, no sound
;69:    // cannot use OnSameTeam as it expects to g_entities, not clients
;70:  	if ( g_gametype.integer >= GT_TEAM && other->client->sess.sessionTeam == client->sess.sessionTeam  ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
LTI4 $64
ADDRLP4 100
CNSTI4 592
ASGNI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ADDRLP4 100
INDIRI4
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
ADDRLP4 100
INDIRI4
ADDP4
INDIRI4
NEI4 $64
line 71
;71:      continue;
ADDRGP4 $54
JUMPV
LABELV $64
line 75
;72:    }
;73:
;74:		// if too far away, no sound
;75:		VectorSubtract( ent->s.pos.trBase, client->ps.origin, delta );
ADDRLP4 104
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
CNSTI4 24
ASGNI4
ADDRLP4 16
ADDRLP4 104
INDIRP4
ADDRLP4 108
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 104
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 108
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+8
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
SUBF4
ASGNF4
line 76
;76:		len = VectorNormalize( delta );
ADDRLP4 16
ARGP4
ADDRLP4 116
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 40
ADDRLP4 116
INDIRF4
ASGNF4
line 77
;77:		if ( len > 192 ) {
ADDRLP4 40
INDIRF4
CNSTF4 1128267776
LEF4 $69
line 78
;78:			continue;
ADDRGP4 $54
JUMPV
LABELV $69
line 82
;79:		}
;80:
;81:		// if not facing, no sound
;82:		AngleVectors( client->ps.viewangles, forward, NULL, NULL );
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 120
CNSTP4 0
ASGNP4
ADDRLP4 120
INDIRP4
ARGP4
ADDRLP4 120
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 83
;83:		if ( DotProduct( delta, forward ) < 0.4 ) {
ADDRLP4 16
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDRLP4 16+4
INDIRF4
ADDRLP4 28+4
INDIRF4
MULF4
ADDF4
ADDRLP4 16+8
INDIRF4
ADDRLP4 28+8
INDIRF4
MULF4
ADDF4
CNSTF4 1053609165
GEF4 $71
line 84
;84:			continue;
ADDRGP4 $54
JUMPV
LABELV $71
line 88
;85:		}
;86:
;87:		// if not line of sight, no sound
;88:		trap_Trace( &tr, client->ps.origin, NULL, NULL, ent->s.pos.trBase, ENTITYNUM_NONE, CONTENTS_SOLID );
ADDRLP4 44
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 124
CNSTP4 0
ASGNP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTI4 1023
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 89
;89:		if ( tr.fraction != 1.0 ) {
ADDRLP4 44+8
INDIRF4
CNSTF4 1065353216
EQF4 $77
line 90
;90:			continue;
ADDRGP4 $54
JUMPV
LABELV $77
line 94
;91:		}
;92:
;93:		// anti-reward
;94:		client->ps.persistant[PERS_REWARD_COUNT]++;
ADDRLP4 128
ADDRLP4 0
INDIRP4
CNSTI4 268
ADDP4
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 95
;95:		client->ps.persistant[PERS_REWARD] = REWARD_DENIED;
ADDRLP4 0
INDIRP4
CNSTI4 272
ADDP4
CNSTI4 3
ASGNI4
line 96
;96:	}
LABELV $54
line 51
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $56
ADDRLP4 4
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $53
line 98
;97:
;98:	return RESPAWN_POWERUP;
CNSTI4 120
RETI4
LABELV $46
endproc Pickup_Powerup 132 28
export Pickup_Holdable
proc Pickup_Holdable 0 0
line 103
;99:}
;100:
;101://======================================================================
;102:
;103:int Pickup_Holdable( gentity_t *ent, gentity_t *other ) {
line 105
;104:
;105:	other->client->ps.stats[STAT_HOLDABLE_ITEM] = ent->item - bg_itemlist;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 188
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
ASGNI4
line 107
;106:
;107:	return RESPAWN_HOLDABLE;
CNSTI4 60
RETI4
LABELV $80
endproc Pickup_Holdable 0 0
export Add_Ammo
proc Add_Ammo 4 0
line 114
;108:}
;109:
;110:
;111://======================================================================
;112:
;113:void Add_Ammo (gentity_t *ent, int weapon, int count)
;114:{
line 115
;115:	ent->client->ps.ammo[weapon] += count;
ADDRLP4 0
ADDRFP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
ASGNI4
line 116
;116:	if ( ent->client->ps.ammo[weapon] > 200 ) {
ADDRFP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
CNSTI4 200
LEI4 $82
line 117
;117:		ent->client->ps.ammo[weapon] = 200;
ADDRFP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
CNSTI4 200
ASGNI4
line 118
;118:	}
LABELV $82
line 119
;119:}
LABELV $81
endproc Add_Ammo 4 0
export Pickup_Ammo
proc Pickup_Ammo 20 12
line 122
;120:
;121:int Pickup_Ammo (gentity_t *ent, gentity_t *other)
;122:{
line 125
;123:	int		quantity;
;124:
;125:	if ( ent->count ) {
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
EQI4 $85
line 126
;126:		quantity = ent->count;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
ASGNI4
line 127
;127:	} else {
ADDRGP4 $86
JUMPV
LABELV $85
line 128
;128:		quantity = ent->item->quantity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ASGNI4
line 129
;129:	}
LABELV $86
line 131
;130:
;131:	if(g_GenericEnergyAmmo.integer && ent->item->giTag == WP_ENERGY)
ADDRGP4 g_GenericEnergyAmmo+12
INDIRI4
CNSTI4 0
EQI4 $87
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 11
NEI4 $87
line 132
;132:	{
line 133
;133:		switch(other->s.weapon)
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
CNSTI4 1
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $93
ADDRLP4 4
INDIRI4
ADDRLP4 12
INDIRI4
LTI4 $90
LABELV $97
ADDRLP4 4
INDIRI4
CNSTI4 6
EQI4 $94
ADDRLP4 4
INDIRI4
CNSTI4 8
EQI4 $95
ADDRLP4 4
INDIRI4
CNSTI4 9
EQI4 $96
ADDRGP4 $90
JUMPV
line 134
;134:		{
LABELV $93
line 136
;135:		case WP_GAUNTLET:
;136:			Add_Ammo (other, WP_GAUNTLET, quantity * 10);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
CNSTI4 10
ADDRLP4 0
INDIRI4
MULI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
LABELV $94
line 138
;137:		case WP_LIGHTNING:
;138:			Add_Ammo (other, WP_LIGHTNING, quantity * 5);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 6
ARGI4
CNSTI4 5
ADDRLP4 0
INDIRI4
MULI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
line 139
;139:			break;
ADDRGP4 $88
JUMPV
LABELV $95
line 141
;140:		case WP_PLASMAGUN:
;141:			Add_Ammo (other, WP_PLASMAGUN, quantity * 2);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 8
ARGI4
ADDRLP4 0
INDIRI4
CNSTI4 1
LSHI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
line 142
;142:			break;
ADDRGP4 $88
JUMPV
LABELV $96
line 144
;143:		case WP_BFG:			
;144:			Add_Ammo (other, WP_BFG, quantity);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 9
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
line 145
;145:			break;
ADDRGP4 $88
JUMPV
LABELV $90
line 147
;146:		default:
;147:			Add_Ammo (other, ent->item->giTag, quantity);
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
line 148
;148:			break;
line 152
;149:
;150:		}
;151:		
;152:	}
ADDRGP4 $88
JUMPV
LABELV $87
line 154
;153:	else
;154:		Add_Ammo (other, ent->item->giTag, quantity);
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
LABELV $88
line 156
;155:
;156:	return RESPAWN_AMMO;
CNSTI4 40
RETI4
LABELV $84
endproc Pickup_Ammo 20 12
export Pickup_Weapon
proc Pickup_Weapon 8 12
line 162
;157:}
;158:
;159://======================================================================
;160:
;161:
;162:int Pickup_Weapon (gentity_t *ent, gentity_t *other) {
line 165
;163:	int		quantity;
;164:
;165:	if ( ent->count <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
GTI4 $99
line 166
;166:		quantity = 0; // None for you, sir!
ADDRLP4 0
CNSTI4 0
ASGNI4
line 167
;167:	} else {
ADDRGP4 $100
JUMPV
LABELV $99
line 169
;168:		//if ( ent->count ) {
;169:			quantity = ent->count;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
ASGNI4
line 175
;170:		//} else {
;171:		//	quantity = ent->item->quantity;
;172:		//}
;173:		// ## Hentai ## - always add full amount of ammo
;174:		// dropped items and teamplay weapons always have full ammo
;175:		if ( ! (ent->flags & FL_DROPPED_ITEM) && g_gametype.integer != GT_TEAM ) 
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
NEI4 $101
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
EQI4 $101
line 176
;176:		{
line 178
;177:			// respawning rules
;178:			if((other->client->ps.stats[STAT_WEAPONS] & ( 1 << ent->item->giTag )) == 0)
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $104
line 179
;179:			{ // ## Hentai - we don't have this gun, so grab it.
line 181
;180:				
;181:			}			
ADDRGP4 $105
JUMPV
LABELV $104
line 182
;182:			else if(other->client->ps.ammo[ent->item->giTag] <  ent->item->quantity)
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
GEI4 $106
line 183
;183:				quantity -= other->client->ps.ammo[ent->item->giTag];
ADDRLP4 0
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
SUBI4
ASGNI4
ADDRGP4 $107
JUMPV
LABELV $106
line 185
;184:			else			
;185:				quantity = 1;		// only add a single shot
ADDRLP4 0
CNSTI4 1
ASGNI4
LABELV $107
LABELV $105
line 186
;186:		}
LABELV $101
line 188
;187:		// ## Hentai ##		
;188:	}
LABELV $100
line 191
;189:
;190:	// add the weapon
;191:	other->client->ps.stats[STAT_WEAPONS] |= ( 1 << ent->item->giTag );
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 192
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LSHI4
BORI4
ASGNI4
line 193
;192:
;193:	Add_Ammo( other, ent->item->giTag, quantity );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Add_Ammo
CALLV
pop
line 195
;194:
;195:	if (ent->item->giTag == WP_GRAPPLING_HOOK)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $108
line 196
;196:		other->client->ps.ammo[ent->item->giTag] = -1; // unlimited ammo
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
CNSTI4 -1
ASGNI4
LABELV $108
line 199
;197:
;198:	// team deathmatch has slow weapon respawns
;199:	if ( g_gametype.integer == GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $110
line 200
;200:		return RESPAWN_TEAM_WEAPON;
CNSTI4 30
RETI4
ADDRGP4 $98
JUMPV
LABELV $110
line 203
;201:	}
;202:
;203:	return g_weaponRespawn.integer;
ADDRGP4 g_weaponRespawn+12
INDIRI4
RETI4
LABELV $98
endproc Pickup_Weapon 8 12
export Pickup_Health
proc Pickup_Health 32 4
line 209
;204:}
;205:
;206:
;207://======================================================================
;208:
;209:int Pickup_Health (gentity_t *ent, gentity_t *other) {
line 213
;210:	int			max;
;211:	int			quantity;
;212:
;213:	other->client->ps.stats[STAT_LEG_DAMAGE] /= (1 + sqrt(ent->item->quantity));
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 8
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 12
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CVIF4 4
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
ADDF4
DIVF4
CVFI4 4
ASGNI4
line 215
;214:	// small and mega healths will go over the max
;215:	if ( ent->item->quantity != 5 && ent->item->quantity != 100  ) {
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 5
EQI4 $115
ADDRLP4 16
INDIRI4
CNSTI4 100
EQI4 $115
line 216
;216:		max = other->client->ps.stats[STAT_MAX_HEALTH];
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
ASGNI4
line 217
;217:	} else {
ADDRGP4 $116
JUMPV
LABELV $115
line 218
;218:		max = other->client->ps.stats[STAT_MAX_HEALTH] * 2;
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ASGNI4
line 219
;219:	}
LABELV $116
line 220
;220:	other->client->bleeding = 0;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 720
ADDP4
CNSTF4 0
ASGNF4
line 221
;221:	other->client->bleed_damage = 0;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 724
ADDP4
CNSTF4 0
ASGNF4
line 222
;222:	other->client->bleedtime = level.time;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 716
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 223
;223:	if ( ent->count ) {
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
EQI4 $118
line 224
;224:		quantity = ent->count;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
ASGNI4
line 225
;225:	} else {
ADDRGP4 $119
JUMPV
LABELV $118
line 226
;226:		quantity = ent->item->quantity;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ASGNI4
line 227
;227:	}
LABELV $119
line 229
;228:
;229:	other->health += quantity;	
ADDRLP4 20
ADDRFP4 4
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 231
;230:
;231:	if (other->health > max ) {
ADDRFP4 4
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
LEI4 $120
line 232
;232:		other->health = max;
ADDRFP4 4
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 233
;233:	}
LABELV $120
line 234
;234:	other->client->ps.stats[STAT_HEALTH] = other->health;
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 24
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ASGNI4
line 235
;235:	if(other->health >= other->client->ps.stats[STAT_MAX_HEALTH])
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 28
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
LTI4 $122
line 236
;236:		other->client->ps.stats[STAT_LEG_DAMAGE] = 0;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
CNSTI4 0
ASGNI4
LABELV $122
line 237
;237:	if ( ent->item->giTag == 100 ) {		// mega health respawns slow
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 100
NEI4 $124
line 238
;238:		return RESPAWN_MEGAHEALTH;
CNSTI4 120
RETI4
ADDRGP4 $114
JUMPV
LABELV $124
line 241
;239:	}
;240:
;241:	return RESPAWN_HEALTH;
CNSTI4 35
RETI4
LABELV $114
endproc Pickup_Health 32 4
export Pickup_Armor
proc Pickup_Armor 12 0
line 246
;242:}
;243:
;244://======================================================================
;245:
;246:int Pickup_Armor( gentity_t *ent, gentity_t *other ) {
line 247
;247:	if(!g_allowArmor.integer)
ADDRGP4 g_allowArmor+12
INDIRI4
CNSTI4 0
NEI4 $127
line 248
;248:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $126
JUMPV
LABELV $127
line 249
;249:	other->client->ps.stats[STAT_ARMOR] += ent->item->quantity;
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 196
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ADDI4
ASGNI4
line 250
;250:	if ( other->client->ps.stats[STAT_ARMOR] > other->client->ps.stats[STAT_MAX_HEALTH] * 2 ) {
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
LSHI4
LEI4 $130
line 251
;251:		other->client->ps.stats[STAT_ARMOR] = other->client->ps.stats[STAT_MAX_HEALTH] * 2;
ADDRLP4 8
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 196
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ASGNI4
line 252
;252:	}
LABELV $130
line 254
;253:
;254:	return RESPAWN_ARMOR;
CNSTI4 25
RETI4
LABELV $126
endproc Pickup_Armor 12 0
export RespawnItem
proc RespawnItem 28 12
line 264
;255:}
;256:
;257://======================================================================
;258:
;259:/*
;260:===============
;261:RespawnItem
;262:===============
;263:*/
;264:void RespawnItem( gentity_t *ent ) {
line 266
;265:	// randomly select from teamed entities
;266:	if (ent->team) {
ADDRFP4 0
INDIRP4
CNSTI4 644
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $133
line 271
;267:		gentity_t	*master;
;268:		int	count;
;269:		int choice;
;270:
;271:		if ( !ent->teammaster ) {
ADDRFP4 0
INDIRP4
CNSTI4 760
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $135
line 272
;272:			G_Error( "RespawnItem: bad teammaster");
ADDRGP4 $137
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 273
;273:		}
LABELV $135
line 274
;274:		master = ent->teammaster;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 760
ADDP4
INDIRP4
ASGNP4
line 276
;275:
;276:		for (count = 0, ent = master; ent; ent = ent->teamchain, count++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRFP4 0
ADDRLP4 8
INDIRP4
ASGNP4
ADDRGP4 $141
JUMPV
LABELV $138
line 277
;277:			;
LABELV $139
line 276
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $141
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $138
line 279
;278:
;279:		choice = rand() % count;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 12
INDIRI4
ADDRLP4 0
INDIRI4
MODI4
ASGNI4
line 281
;280:
;281:		for (count = 0, ent = master; count < choice; ent = ent->teamchain, count++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRFP4 0
ADDRLP4 8
INDIRP4
ASGNP4
ADDRGP4 $145
JUMPV
LABELV $142
line 282
;282:			;
LABELV $143
line 281
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $145
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $142
line 283
;283:	}
LABELV $133
line 284
;284:	if ( ent->item->giType == IT_WEAPON && ent->count == 0) 
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $146
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
NEI4 $146
line 285
;285:	{
line 286
;286:		ent->count = ent->item->quantity;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 740
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ASGNI4
line 288
;287:	
;288:	}
LABELV $146
line 290
;289:	
;290:	ent->r.contents = CONTENTS_TRIGGER;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 291
;291:	ent->s.eFlags &= ~EF_NODRAW;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -129
BANDI4
ASGNI4
line 292
;292:	ent->r.svFlags &= ~SVF_NOCLIENT;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 294
;293:
;294:	trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 296
;295:
;296:	if ( ent->item->giType == IT_POWERUP ) {
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 5
NEI4 $148
line 300
;297:		// play powerup spawn sound to all clients
;298:		gentity_t	*te;
;299:
;300:		te = G_TempEntity( ent->s.pos.trBase, EV_GLOBAL_SOUND );
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTI4 46
ARGI4
ADDRLP4 16
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 16
INDIRP4
ASGNP4
line 301
;301:		te->s.eventParm = G_SoundIndex( "sound/items/poweruprespawn.wav" );
ADDRGP4 $150
ARGP4
ADDRLP4 20
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 20
INDIRI4
ASGNI4
line 302
;302:		te->r.svFlags |= SVF_BROADCAST;
ADDRLP4 24
ADDRLP4 12
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 303
;303:	}
LABELV $148
line 306
;304:
;305:	// play the normal respawn sound only to nearby clients
;306:	G_AddEvent( ent, EV_ITEM_RESPAWN, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 40
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 308
;307:
;308:	ent->nextthink = 0;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
CNSTI4 0
ASGNI4
line 309
;309:}
LABELV $132
endproc RespawnItem 28 12
export Touch_Item
proc Touch_Item 48 12
line 317
;310:
;311:void TossClientWeapon(gentity_t *self);
;312:/*
;313:===============
;314:Touch_Item
;315:===============
;316:*/
;317:void Touch_Item (gentity_t *ent, gentity_t *other, trace_t *trace) {
line 320
;318:	int			respawn;
;319:
;320:	if (!other->client)
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $152
line 321
;321:		return;
ADDRGP4 $151
JUMPV
LABELV $152
line 322
;322:	if (other->health < 1)
ADDRFP4 4
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 1
GEI4 $154
line 323
;323:		return;		// dead people can't pickup
ADDRGP4 $151
JUMPV
LABELV $154
line 324
;324:	if(other == ent->enemy)
ADDRFP4 4
INDIRP4
CVPU4 4
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
CVPU4 4
NEU4 $156
line 325
;325:		return; // ## Hentai - my old gun that i'm trying to drop
ADDRGP4 $151
JUMPV
LABELV $156
line 327
;326:	// the same pickup rules are used for client side and server side
;327:	if ( !BG_CanItemBeGrabbed( &ent->s, &other->client->ps ) ) {		
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BG_CanItemBeGrabbed
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $158
line 328
;328:		return;
ADDRGP4 $151
JUMPV
LABELV $158
line 331
;329:	}
;330:
;331:	G_LogPrintf( "Item: %i %s\n", other->s.number, ent->item->classname );
ADDRGP4 $160
ARGP4
ADDRFP4 4
INDIRP4
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 334
;332:
;333:	// call the item-specific pickup function
;334:	switch( ent->item->giType ) {
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 1
LTI4 $151
ADDRLP4 8
INDIRI4
CNSTI4 7
GTI4 $151
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $174-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $174
address $164
address $165
address $169
address $170
address $171
address $173
address $172
code
LABELV $164
line 336
;335:	case IT_WEAPON:
;336:		respawn = Pickup_Weapon(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 Pickup_Weapon
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 16
INDIRI4
ASGNI4
line 337
;337:		break;
ADDRGP4 $162
JUMPV
LABELV $165
line 339
;338:	case IT_AMMO:
;339:		if(g_InventoryAmmo.integer)
ADDRGP4 g_InventoryAmmo+12
INDIRI4
CNSTI4 0
EQI4 $166
line 340
;340:			respawn = Pickup_Holdable(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 Pickup_Holdable
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 20
INDIRI4
ASGNI4
ADDRGP4 $162
JUMPV
LABELV $166
line 342
;341:		else
;342:			respawn = Pickup_Ammo(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 Pickup_Ammo
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 24
INDIRI4
ASGNI4
line 343
;343:		break;
ADDRGP4 $162
JUMPV
LABELV $169
line 345
;344:	case IT_ARMOR:
;345:		respawn = Pickup_Armor(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 Pickup_Armor
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 28
INDIRI4
ASGNI4
line 346
;346:		break;
ADDRGP4 $162
JUMPV
LABELV $170
line 348
;347:	case IT_HEALTH:
;348:		respawn = Pickup_Health(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 Pickup_Health
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 32
INDIRI4
ASGNI4
line 349
;349:		break;
ADDRGP4 $162
JUMPV
LABELV $171
line 351
;350:	case IT_POWERUP:
;351:		respawn = Pickup_Powerup(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 Pickup_Powerup
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 36
INDIRI4
ASGNI4
line 352
;352:		break;
ADDRGP4 $162
JUMPV
LABELV $172
line 354
;353:	case IT_TEAM:
;354:		respawn = Pickup_Team(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 Pickup_Team
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 40
INDIRI4
ASGNI4
line 355
;355:		break;
ADDRGP4 $162
JUMPV
LABELV $173
line 357
;356:	case IT_HOLDABLE:
;357:		respawn = Pickup_Holdable(ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 44
ADDRGP4 Pickup_Holdable
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 44
INDIRI4
ASGNI4
line 358
;358:		break;
line 360
;359:	default:
;360:		return;
LABELV $162
line 363
;361:	}
;362:
;363:	if ( !respawn ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $176
line 366
;364:		//ent->nextthink = 0;
;365:		//ent->think = 0;
;366:		if(ent->item->giType == IT_WEAPON && g_weaponRespawn.integer == 0)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $151
ADDRGP4 g_weaponRespawn+12
INDIRI4
CNSTI4 0
NEI4 $151
line 367
;367:			respawn = 999999999; // if it respawns, it won't be in this lifetime
ADDRLP4 0
CNSTI4 999999999
ASGNI4
line 369
;368:		else
;369:			return;
LABELV $179
line 370
;370:	}
LABELV $176
line 373
;371:
;372:	// play the normal pickup sound
;373:	if ( other->client->pers.predictItemPickup ) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 480
ADDP4
INDIRI4
CNSTI4 0
EQI4 $181
line 374
;374:		G_AddPredictableEvent( other, EV_ITEM_PICKUP, ent->s.modelindex );
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 19
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddPredictableEvent
CALLV
pop
line 375
;375:	} else {
ADDRGP4 $182
JUMPV
LABELV $181
line 376
;376:		G_AddEvent( other, EV_ITEM_PICKUP, ent->s.modelindex );
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 19
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 377
;377:	}
LABELV $182
line 380
;378:
;379:	// powerup pickups are global broadcasts
;380:	if ( ent->item->giType == IT_POWERUP || ent->item->giType == IT_TEAM) {
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 5
EQI4 $185
ADDRLP4 16
INDIRI4
CNSTI4 7
NEI4 $183
LABELV $185
line 383
;381:		gentity_t	*te;
;382:
;383:		te = G_TempEntity( ent->s.pos.trBase, EV_GLOBAL_ITEM_PICKUP );
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTI4 20
ARGI4
ADDRLP4 24
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 20
ADDRLP4 24
INDIRP4
ASGNP4
line 384
;384:		te->s.eventParm = ent->s.modelindex;
ADDRLP4 20
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ASGNI4
line 385
;385:		te->r.svFlags |= SVF_BROADCAST;
ADDRLP4 28
ADDRLP4 20
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 386
;386:	}
LABELV $183
line 389
;387:
;388:	// fire item targets
;389:	G_UseTargets (ent, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 392
;390:
;391:	// wait of -1 will not respawn
;392:	if ( ent->wait == -1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 3212836864
NEF4 $186
line 393
;393:		ent->r.svFlags |= SVF_NOCLIENT;
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 394
;394:		ent->s.eFlags |= EF_NODRAW;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 395
;395:		ent->r.contents = 0;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 0
ASGNI4
line 396
;396:		ent->unlinkAfterEvent = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 548
ADDP4
CNSTI4 1
ASGNI4
line 397
;397:		return;
ADDRGP4 $151
JUMPV
LABELV $186
line 401
;398:	}
;399:
;400:	// non zero wait overrides respawn time
;401:	if ( ent->wait ) {
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CNSTF4 0
EQF4 $188
line 402
;402:		respawn = ent->wait;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
INDIRF4
CVFI4 4
ASGNI4
line 403
;403:	}
LABELV $188
line 406
;404:
;405:	// random can be used to vary the respawn time
;406:	if ( ent->random ) {
ADDRFP4 0
INDIRP4
CNSTI4 780
ADDP4
INDIRF4
CNSTF4 0
EQF4 $190
line 407
;407:		respawn += crandom() * ent->random;
ADDRLP4 20
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 0
INDIRI4
CVIF4 4
CNSTF4 1073741824
ADDRLP4 20
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 0
INDIRP4
CNSTI4 780
ADDP4
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 408
;408:		if ( respawn < 1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 1
GEI4 $192
line 409
;409:			respawn = 1;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 410
;410:		}
LABELV $192
line 411
;411:	}
LABELV $190
line 414
;412:
;413:	// dropped items will not respawn
;414:	if ( ent->flags & FL_DROPPED_ITEM ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $194
line 415
;415:		ent->freeAfterEvent = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 544
ADDP4
CNSTI4 1
ASGNI4
line 416
;416:	}
LABELV $194
line 421
;417:
;418:	// picked up items still stay around, they just don't
;419:	// draw anything.  This allows respawnable items
;420:	// to be placed on movers.
;421:	ent->r.svFlags |= SVF_NOCLIENT;
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 422
;422:	ent->s.eFlags |= EF_NODRAW;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 423
;423:	ent->r.contents = 0;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 0
ASGNI4
line 430
;424:
;425:	// ZOID
;426:	// A negative respawn times means to never respawn this item (but don't 
;427:	// delete it).  This is used by items that are respawned by third party 
;428:	// events such as ctf flags
;429:	// ## Hentai ##
;430:	if(ent->item->giType == IT_WEAPON && g_weaponRespawn.integer == -1)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $196
ADDRGP4 g_weaponRespawn+12
INDIRI4
CNSTI4 -1
NEI4 $196
line 431
;431:	{
line 432
;432:		ent->nextthink = level.time + 1; // respawn NOW.
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 433
;433:		ent->think = RespawnItem;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 RespawnItem
ASGNP4
line 434
;434:	}// ## Hentai
ADDRGP4 $197
JUMPV
LABELV $196
line 435
;435:	else if ( respawn <= 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
GTI4 $200
line 436
;436:		ent->nextthink = 0;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
CNSTI4 0
ASGNI4
line 437
;437:		ent->think = 0;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
CNSTP4 0
ASGNP4
line 438
;438:	} else {
ADDRGP4 $201
JUMPV
LABELV $200
line 439
;439:		ent->nextthink = level.time + respawn * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDRLP4 0
INDIRI4
MULI4
ADDI4
ASGNI4
line 440
;440:		ent->think = RespawnItem;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 RespawnItem
ASGNP4
line 441
;441:	}
LABELV $201
LABELV $197
line 442
;442:	trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 443
;443:}
LABELV $151
endproc Touch_Item 48 12
export LaunchItem
proc LaunchItem 16 8
line 455
;444:
;445:
;446://======================================================================
;447:
;448:/*
;449:================
;450:LaunchItem
;451:
;452:Spawns an item and tosses it forward
;453:================
;454:*/
;455:gentity_t *LaunchItem( gitem_t *item, vec3_t origin, vec3_t velocity ) {
line 458
;456:	gentity_t	*dropped;
;457:
;458:	dropped = G_Spawn();
ADDRLP4 4
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 460
;459:
;460:	dropped->s.eType = ET_ITEM;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 2
ASGNI4
line 461
;461:	dropped->s.modelindex = item - bg_itemlist;	// store item number in modelindex
ADDRLP4 0
INDIRP4
CNSTI4 160
ADDP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
ASGNI4
line 462
;462:	dropped->s.modelindex2 = 1; // This is non-zero is it's a dropped item
ADDRLP4 0
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 1
ASGNI4
line 463
;463:	vectoangles(velocity, dropped->s.angles); //## Hentai ##
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 464
;464:	dropped->classname = item->classname;
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRFP4 0
INDIRP4
INDIRP4
ASGNP4
line 465
;465:	dropped->item = item;
ADDRLP4 0
INDIRP4
CNSTI4 784
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 466
;466:	VectorSet (dropped->r.mins, -ITEM_RADIUS, -ITEM_RADIUS, -ITEM_RADIUS);
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
CNSTF4 3245342720
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 428
ADDP4
CNSTF4 3245342720
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 432
ADDP4
CNSTF4 3245342720
ASGNF4
line 467
;467:	VectorSet (dropped->r.maxs, ITEM_RADIUS, ITEM_RADIUS, ITEM_RADIUS);
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
CNSTF4 1097859072
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
CNSTF4 1097859072
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTF4 1097859072
ASGNF4
line 468
;468:	dropped->r.contents = CONTENTS_TRIGGER;
ADDRLP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 470
;469:
;470:	dropped->touch = Touch_Item;
ADDRLP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_Item
ASGNP4
line 472
;471:
;472:	G_SetOrigin( dropped, origin );
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 473
;473:	dropped->s.pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 474
;474:	dropped->s.pos.trTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 475
;475:	VectorCopy( velocity, dropped->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 8
INDIRP4
INDIRB
ASGNB 12
line 477
;476:
;477:	dropped->s.eFlags |= EF_BOUNCE_HALF;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 479
;478:
;479:	if (item->giType == IT_TEAM) { // Special case for CTF flags
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 7
NEI4 $205
line 480
;480:		dropped->think = Team_DroppedFlagThink;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 Team_DroppedFlagThink
ASGNP4
line 481
;481:		dropped->nextthink = level.time + 30000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 30000
ADDI4
ASGNI4
line 482
;482:		Team_CheckDroppedItem( dropped );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 Team_CheckDroppedItem
CALLV
pop
line 483
;483:	} else if(g_weaponRespawn.integer <= 0 && g_OneWeaponPerPlayer.integer == 0) { // auto-remove after 30 seconds
ADDRGP4 $206
JUMPV
LABELV $205
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 g_weaponRespawn+12
INDIRI4
ADDRLP4 12
INDIRI4
GTI4 $208
ADDRGP4 g_OneWeaponPerPlayer+12
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $208
line 484
;484:		dropped->think = G_FreeEntity;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_FreeEntity
ASGNP4
line 485
;485:		dropped->nextthink = level.time + 30000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 30000
ADDI4
ASGNI4
line 486
;486:	}
ADDRGP4 $209
JUMPV
LABELV $208
line 488
;487:	else
;488:	{
line 489
;489:		dropped->think = G_FreeEntity;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 G_FreeEntity
ASGNP4
line 490
;490:		dropped->nextthink = level.time + 9999999;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 9999999
ADDI4
ASGNI4
line 491
;491:	}
LABELV $209
LABELV $206
line 493
;492:	
;493:	dropped->flags = FL_DROPPED_ITEM;
ADDRLP4 0
INDIRP4
CNSTI4 524
ADDP4
CNSTI4 4096
ASGNI4
line 495
;494:
;495:	trap_LinkEntity (dropped);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 497
;496:
;497:	return dropped;
ADDRLP4 0
INDIRP4
RETP4
LABELV $203
endproc LaunchItem 16 8
export Drop_Item
proc Drop_Item 40 16
line 507
;498:}
;499:
;500:/*
;501:================
;502:Drop_Item
;503:
;504:Spawns an item and tosses it forward
;505:================
;506:*/
;507:gentity_t *Drop_Item( gentity_t *ent, gitem_t *item, float angle ) {
line 511
;508:	vec3_t	velocity;
;509:	vec3_t	angles;
;510:
;511:	VectorCopy( ent->s.apos.trBase, angles );
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 60
ADDP4
INDIRB
ASGNB 12
line 512
;512:	angles[YAW] += angle;
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRFP4 8
INDIRF4
ADDF4
ASGNF4
line 513
;513:	angles[PITCH] = 0;	// always forward
ADDRLP4 12
CNSTF4 0
ASGNF4
line 515
;514:
;515:	AngleVectors( angles, velocity, NULL, NULL );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 24
CNSTP4 0
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 516
;516:	VectorScale( velocity, 150, velocity );
ADDRLP4 28
CNSTF4 1125515264
ASGNF4
ADDRLP4 0
ADDRLP4 28
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 28
INDIRF4
ADDRLP4 0+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+8
CNSTF4 1125515264
ADDRLP4 0+8
INDIRF4
MULF4
ASGNF4
line 517
;517:	velocity[2] += 200 + crandom() * 50;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1112014848
CNSTF4 1073741824
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1128792064
ADDF4
ADDF4
ASGNF4
line 519
;518:	
;519:	return LaunchItem( item, ent->s.pos.trBase, velocity );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 36
ADDRGP4 LaunchItem
CALLP4
ASGNP4
ADDRLP4 36
INDIRP4
RETP4
LABELV $214
endproc Drop_Item 40 16
export Use_Item
proc Use_Item 0 4
line 530
;520:}
;521:
;522:
;523:/*
;524:================
;525:Use_Item
;526:
;527:Respawn the item
;528:================
;529:*/
;530:void Use_Item( gentity_t *ent, gentity_t *other, gentity_t *activator ) {
line 531
;531:	RespawnItem( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 RespawnItem
CALLV
pop
line 532
;532:}
LABELV $221
endproc Use_Item 0 4
export FinishSpawningItem
proc FinishSpawningItem 96 28
line 544
;533:
;534://======================================================================
;535:
;536:/*
;537:================
;538:FinishSpawningItem
;539:
;540:Traces down to find where an item should rest, instead of letting them
;541:free fall from their spawn points
;542:================
;543:*/
;544:void FinishSpawningItem( gentity_t *ent ) {
line 548
;545:	trace_t		tr;
;546:	vec3_t		dest;
;547:
;548:	VectorSet( ent->r.mins, -ITEM_RADIUS, -ITEM_RADIUS, -ITEM_RADIUS );
ADDRFP4 0
INDIRP4
CNSTI4 424
ADDP4
CNSTF4 3245342720
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
CNSTF4 3245342720
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 432
ADDP4
CNSTF4 3245342720
ASGNF4
line 549
;549:	VectorSet( ent->r.maxs, ITEM_RADIUS, ITEM_RADIUS, ITEM_RADIUS );
ADDRFP4 0
INDIRP4
CNSTI4 436
ADDP4
CNSTF4 1097859072
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 440
ADDP4
CNSTF4 1097859072
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTF4 1097859072
ASGNF4
line 551
;550:
;551:	ent->s.eType = ET_ITEM;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 2
ASGNI4
line 552
;552:	ent->s.modelindex = ent->item - bg_itemlist;		// store item number in modelindex
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTI4 160
ADDP4
ADDRLP4 68
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
ASGNI4
line 553
;553:	ent->s.modelindex2 = 0; // zero indicates this isn't a dropped item
ADDRFP4 0
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 0
ASGNI4
line 554
;554:	ent->s.angles[YAW] = rand() % 360;
ADDRLP4 72
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
ADDRLP4 72
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 555
;555:	ent->r.contents = CONTENTS_TRIGGER;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 1073741824
ASGNI4
line 556
;556:	ent->touch = Touch_Item;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 Touch_Item
ASGNP4
line 558
;557:	// useing an item causes it to respawn
;558:	ent->use = Use_Item;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ADDRGP4 Use_Item
ASGNP4
line 560
;559:
;560:	if ( ent->spawnflags & 1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $223
line 562
;561:		// suspended
;562:		G_SetOrigin( ent, ent->s.origin );
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 563
;563:	} else {
ADDRGP4 $224
JUMPV
LABELV $223
line 565
;564:		// drop to floor
;565:		VectorSet( dest, ent->s.origin[0], ent->s.origin[1], ent->s.origin[2] - 4096 );
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
ADDRLP4 76
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ASGNF4
ADDRLP4 56+4
ADDRLP4 76
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ASGNF4
ADDRLP4 56+8
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
CNSTF4 1166016512
SUBF4
ASGNF4
line 566
;566:		trap_Trace( &tr, ent->s.origin, ent->r.mins, ent->r.maxs, dest, ent->s.number, MASK_SOLID );
ADDRLP4 0
ARGP4
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 80
INDIRP4
CNSTI4 424
ADDP4
ARGP4
ADDRLP4 80
INDIRP4
CNSTI4 436
ADDP4
ARGP4
ADDRLP4 56
ARGP4
ADDRLP4 80
INDIRP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 567
;567:		if ( tr.startsolid ) {
ADDRLP4 0+4
INDIRI4
CNSTI4 0
EQI4 $227
line 568
;568:			G_Printf ("FinishSpawningItem: %s startsolid at %s\n", ent->classname, vtos(ent->s.origin));
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 84
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $230
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 569
;569:			G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 570
;570:			return;
ADDRGP4 $222
JUMPV
LABELV $227
line 574
;571:		}
;572:
;573:		// allow to ride movers
;574:		ent->s.groundEntityNum = tr.entityNum;
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ADDRLP4 0+52
INDIRI4
ASGNI4
line 576
;575:
;576:		G_SetOrigin( ent, tr.endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0+12
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 577
;577:	}
LABELV $224
line 580
;578:
;579:	// team slaves and targeted items aren't present at start
;580:	if ( ( ent->flags & FL_TEAMSLAVE ) || ent->targetname ) {
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
NEI4 $235
ADDRLP4 76
INDIRP4
CNSTI4 640
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $233
LABELV $235
line 581
;581:		ent->s.eFlags |= EF_NODRAW;
ADDRLP4 80
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 582
;582:		ent->r.contents = 0;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 0
ASGNI4
line 583
;583:		return;
ADDRGP4 $222
JUMPV
LABELV $233
line 586
;584:	}
;585:	// ## Hentai ##
;586:	if ( ent->item->giType == IT_WEAPON && ent->count == 0) 
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $236
ADDRLP4 80
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 0
NEI4 $236
line 587
;587:	{
line 588
;588:		ent->count = ent->item->quantity;
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTI4 740
ADDP4
ADDRLP4 84
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ASGNI4
line 590
;589:	
;590:	}
ADDRGP4 $237
JUMPV
LABELV $236
line 591
;591:	else if(ent->item->giType == IT_AMMO)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 2
NEI4 $238
line 592
;592:	{
line 594
;593:	
;594:	}
ADDRGP4 $239
JUMPV
LABELV $238
line 595
;595:	else if ( ent->item->giType == IT_HEALTH && g_allowHealth.integer == 0) 
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 4
NEI4 $240
ADDRGP4 g_allowHealth+12
INDIRI4
CNSTI4 0
NEI4 $240
line 596
;596:	{
line 597
;597:		G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 598
;598:		return;
ADDRGP4 $222
JUMPV
LABELV $240
line 600
;599:	}
;600:	else if ( ent->item->giType == IT_ARMOR && g_allowArmor.integer == 0) 
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 3
NEI4 $243
ADDRGP4 g_allowArmor+12
INDIRI4
CNSTI4 0
NEI4 $243
line 601
;601:	{
line 602
;602:		G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 603
;603:		return;
ADDRGP4 $222
JUMPV
LABELV $243
line 605
;604:	}
;605:	else if ( ent->item->giType == IT_POWERUP ) {
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 5
NEI4 $246
line 608
;606:		float	respawn;
;607:		
;608:		if(g_allowPowerups.integer == 0) // don't spawn
ADDRGP4 g_allowPowerups+12
INDIRI4
CNSTI4 0
NEI4 $248
line 609
;609:		{
line 610
;610:			G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 611
;611:			return; 
ADDRGP4 $222
JUMPV
LABELV $248
line 615
;612:		} // ## Hentai ##
;613:		
;614:		// powerups don't spawn in for a while	
;615:		respawn = 45 + crandom() * 15;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 84
CNSTF4 1097859072
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1110704128
ADDF4
ASGNF4
line 616
;616:		ent->s.eFlags |= EF_NODRAW;
ADDRLP4 92
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 617
;617:		ent->r.contents = 0;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 0
ASGNI4
line 618
;618:		ent->nextthink = level.time + respawn * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
CNSTF4 1148846080
ADDRLP4 84
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 619
;619:		ent->think = RespawnItem;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 RespawnItem
ASGNP4
line 620
;620:		return;
ADDRGP4 $222
JUMPV
LABELV $246
LABELV $239
LABELV $237
line 624
;621:	}
;622:
;623:
;624:	trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 625
;625:}
LABELV $222
endproc FinishSpawningItem 96 28
export G_CheckTeamItems
proc G_CheckTeamItems 20 4
line 635
;626:
;627:
;628:qboolean	itemRegistered[MAX_ITEMS];
;629:
;630:/*
;631:==================
;632:G_CheckTeamItems
;633:==================
;634:*/
;635:void G_CheckTeamItems( void ) {
line 638
;636:
;637:	// Set up team stuff
;638:	Team_InitGame();
ADDRGP4 Team_InitGame
CALLV
pop
line 640
;639:
;640:	if ( g_gametype.integer == GT_CTF ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 4
NEI4 $253
line 644
;641:		gitem_t	*item;
;642:
;643:		// make sure we actually have two flags...
;644:		item = BG_FindItem( "Red Flag" );
ADDRGP4 $256
ARGP4
ADDRLP4 4
ADDRGP4 BG_FindItem
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 645
;645:		if ( !item || !itemRegistered[ item - bg_itemlist ] ) {
ADDRLP4 8
ADDRLP4 0
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 8
INDIRU4
CNSTU4 0
EQU4 $259
ADDRLP4 8
INDIRU4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
CNSTI4 2
LSHI4
ADDRGP4 itemRegistered
ADDP4
INDIRI4
CNSTI4 0
NEI4 $257
LABELV $259
line 646
;646:			G_Printf( "^1WARNING: No team_CTF_redflag in map" );
ADDRGP4 $260
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 647
;647:		}
LABELV $257
line 648
;648:		item = BG_FindItem( "Blue Flag" );
ADDRGP4 $261
ARGP4
ADDRLP4 12
ADDRGP4 BG_FindItem
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRP4
ASGNP4
line 649
;649:		if ( !item || !itemRegistered[ item - bg_itemlist ] ) {
ADDRLP4 16
ADDRLP4 0
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 16
INDIRU4
CNSTU4 0
EQU4 $264
ADDRLP4 16
INDIRU4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
CNSTI4 2
LSHI4
ADDRGP4 itemRegistered
ADDP4
INDIRI4
CNSTI4 0
NEI4 $262
LABELV $264
line 650
;650:			G_Printf( "^1WARNING: No team_CTF_blueflag in map" );
ADDRGP4 $265
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 651
;651:		}
LABELV $262
line 652
;652:	}
LABELV $253
line 653
;653:}
LABELV $252
endproc G_CheckTeamItems 20 4
export ClearRegisteredItems
proc ClearRegisteredItems 8 12
line 660
;654:
;655:/*
;656:==============
;657:ClearRegisteredItems
;658:==============
;659:*/
;660:void ClearRegisteredItems( void ) {
line 661
;661:	memset( itemRegistered, 0, sizeof( itemRegistered ) );
ADDRGP4 itemRegistered
ARGP4
CNSTI4 0
ARGI4
CNSTU4 1024
ARGU4
ADDRGP4 memset
CALLP4
pop
line 664
;662:
;663:	// players always start with the base weapon
;664:	RegisterItem( BG_FindItemForWeapon( WP_MACHINEGUN ) );
CNSTI4 2
ARGI4
ADDRLP4 0
ADDRGP4 BG_FindItemForWeapon
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 RegisterItem
CALLV
pop
line 665
;665:	RegisterItem( BG_FindItemForWeapon( WP_GAUNTLET ) );
CNSTI4 1
ARGI4
ADDRLP4 4
ADDRGP4 BG_FindItemForWeapon
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 RegisterItem
CALLV
pop
line 666
;666:}
LABELV $266
endproc ClearRegisteredItems 8 12
export RegisterItem
proc RegisterItem 0 4
line 675
;667:
;668:/*
;669:===============
;670:RegisterItem
;671:
;672:The item will be added to the precache list
;673:===============
;674:*/
;675:void RegisterItem( gitem_t *item ) {
line 676
;676:	if ( !item ) {
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $268
line 677
;677:		G_Error( "RegisterItem: NULL" );
ADDRGP4 $270
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 678
;678:	}
LABELV $268
line 679
;679:	itemRegistered[ item - bg_itemlist ] = qtrue;
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
CNSTI4 2
LSHI4
ADDRGP4 itemRegistered
ADDP4
CNSTI4 1
ASGNI4
line 680
;680:}
LABELV $267
endproc RegisterItem 0 4
export SaveRegisteredItems
proc SaveRegisteredItems 268 8
line 691
;681:
;682:
;683:/*
;684:===============
;685:SaveRegisteredItems
;686:
;687:Write the needed items to a config string
;688:so the client will know which ones to precache
;689:===============
;690:*/
;691:void SaveRegisteredItems( void ) {
line 696
;692:	char	string[MAX_ITEMS+1];
;693:	int		i;
;694:	int		count;
;695:
;696:	count = 0;
ADDRLP4 264
CNSTI4 0
ASGNI4
line 697
;697:	for ( i = 0 ; i < bg_numItems ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $275
JUMPV
LABELV $272
line 698
;698:		if ( itemRegistered[i] ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 itemRegistered
ADDP4
INDIRI4
CNSTI4 0
EQI4 $276
line 699
;699:			count++;
ADDRLP4 264
ADDRLP4 264
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 700
;700:			string[i] = '1';
ADDRLP4 0
INDIRI4
ADDRLP4 4
ADDP4
CNSTI1 49
ASGNI1
line 701
;701:		} else {
ADDRGP4 $277
JUMPV
LABELV $276
line 702
;702:			string[i] = '0';
ADDRLP4 0
INDIRI4
ADDRLP4 4
ADDP4
CNSTI1 48
ASGNI1
line 703
;703:		}
LABELV $277
line 704
;704:	}
LABELV $273
line 697
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $275
ADDRLP4 0
INDIRI4
ADDRGP4 bg_numItems
INDIRI4
LTI4 $272
line 705
;705:	string[ bg_numItems ] = 0;
ADDRGP4 bg_numItems
INDIRI4
ADDRLP4 4
ADDP4
CNSTI1 0
ASGNI1
line 707
;706:
;707:	G_Printf( "%i items registered\n", count );
ADDRGP4 $278
ARGP4
ADDRLP4 264
INDIRI4
ARGI4
ADDRGP4 G_Printf
CALLV
pop
line 708
;708:	trap_SetConfigstring(CS_ITEMS, string);
CNSTI4 27
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 709
;709:}
LABELV $271
endproc SaveRegisteredItems 268 8
export G_SpawnItem
proc G_SpawnItem 16 12
line 722
;710:
;711:
;712:/*
;713:============
;714:G_SpawnItem
;715:
;716:Sets the clipping size and plants the object on the floor.
;717:
;718:Items can't be immediately dropped to floor, because they might
;719:be on an entity that hasn't spawned yet.
;720:============
;721:*/
;722:void G_SpawnItem (gentity_t *ent, gitem_t *item) {
line 723
;723:	G_SpawnFloat( "random", "0", &ent->random );
ADDRGP4 $280
ARGP4
ADDRGP4 $281
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 780
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 724
;724:	G_SpawnFloat( "wait", "0", &ent->wait );
ADDRGP4 $282
ARGP4
ADDRGP4 $281
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 776
ADDP4
ARGP4
ADDRGP4 G_SpawnFloat
CALLI4
pop
line 726
;725:
;726:	if(g_GenericEnergyAmmo.integer && item->giType == IT_AMMO)
ADDRGP4 g_GenericEnergyAmmo+12
INDIRI4
CNSTI4 0
EQI4 $283
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 2
NEI4 $283
line 727
;727:	{
line 728
;728:		int qty = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 729
;729:		switch(item->giTag)
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 6
EQI4 $289
ADDRLP4 4
INDIRI4
CNSTI4 8
EQI4 $290
ADDRLP4 4
INDIRI4
CNSTI4 9
EQI4 $291
ADDRGP4 $286
JUMPV
line 730
;730:		{
LABELV $289
line 732
;731:		case WP_LIGHTNING:
;732:			qty = 5;
ADDRLP4 0
CNSTI4 5
ASGNI4
line 733
;733:			break;
ADDRGP4 $287
JUMPV
LABELV $290
line 735
;734:		case WP_PLASMAGUN:
;735:			qty = 10; 
ADDRLP4 0
CNSTI4 10
ASGNI4
line 736
;736:			break;
ADDRGP4 $287
JUMPV
LABELV $291
line 738
;737:		case WP_BFG:
;738:			qty = 20;
ADDRLP4 0
CNSTI4 20
ASGNI4
line 739
;739:			break;
ADDRGP4 $287
JUMPV
LABELV $286
line 741
;740:		default:
;741:			qty = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 742
;742:			break;
LABELV $287
line 744
;743:		}
;744:		if(qty)
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $292
line 745
;745:		{
line 747
;746:			//G_Printf("cell count: %d\n", qty);
;747:			ent->count = qty;
ADDRFP4 0
INDIRP4
CNSTI4 740
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 748
;748:			item = BG_FindAmmoForWeapon(WP_ENERGY);
CNSTI4 11
ARGI4
ADDRLP4 12
ADDRGP4 BG_FindAmmoForWeapon
CALLP4
ASGNP4
ADDRFP4 4
ADDRLP4 12
INDIRP4
ASGNP4
line 749
;749:		}
LABELV $292
line 750
;750:	}
LABELV $283
line 752
;751:
;752:	RegisterItem( item );
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 RegisterItem
CALLV
pop
line 753
;753:	ent->item = item;
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
ADDRFP4 4
INDIRP4
ASGNP4
line 756
;754:	// some movers spawn on the second frame, so delay item
;755:	// spawns until the third frame so they can ride trains
;756:	ent->nextthink = level.time + FRAMETIME * 2;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 757
;757:	ent->think = FinishSpawningItem;
ADDRFP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 FinishSpawningItem
ASGNP4
line 758
;758:	ent->physicsBounce = 0.50;		// items are bouncy
ADDRFP4 0
INDIRP4
CNSTI4 556
ADDP4
CNSTF4 1056964608
ASGNF4
line 759
;759:	ent->enemy = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
CNSTP4 0
ASGNP4
line 760
;760:	if ( item->giType == IT_POWERUP ) {
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 5
NEI4 $295
line 761
;761:		G_SoundIndex( "sound/items/poweruprespawn.wav" );
ADDRGP4 $150
ARGP4
ADDRGP4 G_SoundIndex
CALLI4
pop
line 762
;762:	}
LABELV $295
line 763
;763:}
LABELV $279
endproc G_SpawnItem 16 12
export G_BounceItem
proc G_BounceItem 64 12
line 772
;764:
;765:
;766:/*
;767:================
;768:G_BounceItem
;769:
;770:================
;771:*/
;772:void G_BounceItem( gentity_t *ent, trace_t *trace ) {
line 778
;773:	vec3_t	velocity;
;774:	float	dot;
;775:	int		hitTime;
;776:
;777:	// reflect the velocity on the trace plane
;778:	hitTime = level.previousTime + ( level.time - level.previousTime ) * trace->fraction;
ADDRLP4 16
ADDRGP4 level+36
INDIRI4
CVIF4 4
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+36
INDIRI4
SUBI4
CVIF4 4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 779
;779:	BG_EvaluateTrajectoryDelta( &ent->s.pos, hitTime, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 780
;780:	dot = DotProduct( velocity, trace->plane.normal );
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 0
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 781
;781:	VectorMA( velocity, -2*dot, trace->plane.normal, ent->s.pos.trDelta );
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 784
;782:
;783:	// cut the velocity to keep from bouncing forever
;784:	VectorScale( ent->s.pos.trDelta, ent->physicsBounce, ent->s.pos.trDelta );
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
ADDRLP4 24
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 24
INDIRP4
CNSTI4 556
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 36
ADDRLP4 32
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
ADDRLP4 32
INDIRP4
CNSTI4 556
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
ADDRLP4 40
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 556
ADDP4
INDIRF4
MULF4
ASGNF4
line 785
;785:	ent->enemy = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
CNSTP4 0
ASGNP4
line 787
;786:	// check for stop
;787:	if ( trace->plane.normal[2] > 0 && ent->s.pos.trDelta[2] < 40 ) {
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 0
LEF4 $305
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 1109393408
GEF4 $305
line 788
;788:		trace->endpos[2] += 1.0;	// make sure it is off ground
ADDRLP4 48
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 789
;789:		SnapVector( trace->endpos );
ADDRLP4 52
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 56
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 60
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 790
;790:		G_SetOrigin( ent, trace->endpos );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 791
;791:		ent->s.groundEntityNum = trace->entityNum;
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
ASGNI4
line 792
;792:		return;
ADDRGP4 $297
JUMPV
LABELV $305
line 795
;793:	}
;794:
;795:	VectorAdd( ent->r.currentOrigin, trace->plane.normal, ent->r.currentOrigin);
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 480
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDF4
ASGNF4
line 796
;796:	VectorCopy( ent->r.currentOrigin, ent->s.pos.trBase );
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 60
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 60
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 797
;797:	ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 798
;798:}
LABELV $297
endproc G_BounceItem 64 12
export G_RunItem
proc G_RunItem 88 28
line 807
;799:
;800:
;801:/*
;802:================
;803:G_RunItem
;804:
;805:================
;806:*/
;807:void G_RunItem( gentity_t *ent ) {
line 814
;808:	vec3_t		origin;
;809:	trace_t		tr;
;810:	int			contents;
;811:	int			mask;
;812:
;813:	// if groundentity has been set to -1, it may have been pushed off an edge
;814:	if ( ent->s.groundEntityNum == -1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $309
line 815
;815:		if ( ent->s.pos.trType != TR_GRAVITY ) {
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 5
EQI4 $311
line 816
;816:			ent->s.pos.trType = TR_GRAVITY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 817
;817:			ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 818
;818:		}
LABELV $311
line 819
;819:	}
LABELV $309
line 821
;820:
;821:	if ( ent->s.pos.trType == TR_STATIONARY ) {
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 0
NEI4 $314
line 823
;822:		// check think function
;823:		G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 824
;824:		return;
ADDRGP4 $308
JUMPV
LABELV $314
line 828
;825:	}
;826:
;827:	// get current position
;828:	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 56
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 831
;829:
;830:	// trace a line from the previous position to the current position
;831:	if ( ent->clipmask ) {
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
INDIRI4
CNSTI4 0
EQI4 $317
line 832
;832:		mask = ent->clipmask;
ADDRLP4 72
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
INDIRI4
ASGNI4
line 833
;833:	} else {
ADDRGP4 $318
JUMPV
LABELV $317
line 834
;834:		mask = MASK_PLAYERSOLID & ~CONTENTS_BODY;//MASK_SOLID;
ADDRLP4 72
CNSTI4 65537
ASGNI4
line 835
;835:	}
LABELV $318
line 836
;836:	trap_Trace( &tr, ent->r.currentOrigin, ent->r.mins, ent->r.maxs, origin, 
ADDRLP4 0
ARGP4
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 424
ADDP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 436
ADDP4
ARGP4
ADDRLP4 56
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
ARGI4
ADDRLP4 72
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 839
;837:		ent->r.ownerNum, mask );
;838:
;839:	VectorCopy( tr.endpos, ent->r.currentOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 0+12
INDIRB
ASGNB 12
line 841
;840:
;841:	if ( tr.startsolid ) {
ADDRLP4 0+4
INDIRI4
CNSTI4 0
EQI4 $320
line 842
;842:		tr.fraction = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 843
;843:	}
LABELV $320
line 845
;844:
;845:	trap_LinkEntity( ent );	// FIXME: avoid this for stationary?
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 848
;846:
;847:	// check think function
;848:	G_RunThink( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunThink
CALLV
pop
line 850
;849:
;850:	if ( tr.fraction == 1 ) {
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
NEF4 $324
line 851
;851:		return;
ADDRGP4 $308
JUMPV
LABELV $324
line 855
;852:	}
;853:
;854:	// if it is in a nodrop volume, remove it
;855:	contents = trap_PointContents( ent->r.currentOrigin, -1 );
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 80
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 68
ADDRLP4 80
INDIRI4
ASGNI4
line 856
;856:	if ( contents & CONTENTS_NODROP ) {
ADDRLP4 68
INDIRI4
CVIU4 4
CNSTU4 2147483648
BANDU4
CNSTU4 0
EQU4 $327
line 857
;857:		if (ent->item && ent->item->giType == IT_TEAM) {
ADDRLP4 84
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $329
ADDRLP4 84
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 7
NEI4 $329
line 858
;858:			Team_FreeEntity(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Team_FreeEntity
CALLV
pop
line 859
;859:		} else {
ADDRGP4 $308
JUMPV
LABELV $329
line 860
;860:			G_FreeEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 861
;861:		}
line 862
;862:		return;
ADDRGP4 $308
JUMPV
LABELV $327
line 865
;863:	}
;864:
;865:	G_BounceItem( ent, &tr );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_BounceItem
CALLV
pop
line 866
;866:}
LABELV $308
endproc G_RunItem 88 28
bss
export itemRegistered
align 4
LABELV itemRegistered
skip 1024
import TossClientWeapon
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import ArmorIndex
import Think_Weapon
import SetRespawn
import PrecacheItem
import UseHoldableItem
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $282
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $281
byte 1 48
byte 1 0
align 1
LABELV $280
byte 1 114
byte 1 97
byte 1 110
byte 1 100
byte 1 111
byte 1 109
byte 1 0
align 1
LABELV $278
byte 1 37
byte 1 105
byte 1 32
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 32
byte 1 114
byte 1 101
byte 1 103
byte 1 105
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $270
byte 1 82
byte 1 101
byte 1 103
byte 1 105
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 58
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 0
align 1
LABELV $265
byte 1 94
byte 1 49
byte 1 87
byte 1 65
byte 1 82
byte 1 78
byte 1 73
byte 1 78
byte 1 71
byte 1 58
byte 1 32
byte 1 78
byte 1 111
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 109
byte 1 97
byte 1 112
byte 1 0
align 1
LABELV $261
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $260
byte 1 94
byte 1 49
byte 1 87
byte 1 65
byte 1 82
byte 1 78
byte 1 73
byte 1 78
byte 1 71
byte 1 58
byte 1 32
byte 1 78
byte 1 111
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 109
byte 1 97
byte 1 112
byte 1 0
align 1
LABELV $256
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $230
byte 1 70
byte 1 105
byte 1 110
byte 1 105
byte 1 115
byte 1 104
byte 1 83
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 115
byte 1 111
byte 1 108
byte 1 105
byte 1 100
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $160
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $150
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 47
byte 1 112
byte 1 111
byte 1 119
byte 1 101
byte 1 114
byte 1 117
byte 1 112
byte 1 114
byte 1 101
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $137
byte 1 82
byte 1 101
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 58
byte 1 32
byte 1 98
byte 1 97
byte 1 100
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 109
byte 1 97
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 0
