export AddScore
code
proc AddScore 8 0
file "..\g_combat.c"
line 15
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// g_combat.c
;4:
;5:#include "g_local.h"
;6:
;7:
;8:/*
;9:============
;10:AddScore
;11:
;12:Adds score to both the client and his team
;13:============
;14:*/
;15:void AddScore( gentity_t *ent, int score ) {
line 16
;16:	if ( !ent->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $47
line 17
;17:		return;
ADDRGP4 $46
JUMPV
LABELV $47
line 20
;18:	}
;19:	// no scoring during pre-match warmup
;20:	if ( level.warmupTime ) {
ADDRGP4 level+16
INDIRI4
CNSTI4 0
EQI4 $49
line 21
;21:		return;
ADDRGP4 $46
JUMPV
LABELV $49
line 23
;22:	}
;23:	ent->client->ps.persistant[PERS_SCORE] += score;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRFP4 4
INDIRI4
ADDI4
ASGNI4
line 24
;24:	if (g_gametype.integer == GT_TEAM)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $52
line 25
;25:		level.teamScores[ ent->client->ps.persistant[PERS_TEAM] ] += score;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+44
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
ADDRFP4 4
INDIRI4
ADDI4
ASGNI4
LABELV $52
line 26
;26:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 27
;27:}
LABELV $46
endproc AddScore 8 0
export letmetouch
proc letmetouch 0 0
line 38
;28:
;29:/*
;30:=================
;31:TossClientItems
;32:
;33:Toss the weapon and powerups for the killed player
;34:=================
;35:*/
;36:// ## Hentai ## - drop a weapon
;37:void letmetouch(gentity_t *self)
;38:{
line 39
;39:	self->enemy = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
CNSTP4 0
ASGNP4
line 40
;40:}
LABELV $56
endproc letmetouch 0 0
export TossClientWeapon
proc TossClientWeapon 28 12
line 42
;41:void TossClientWeapon(gentity_t *self, int weapon)
;42:{	// drop the player's weapon and ammo
line 48
;43:
;44:	gentity_t	*drop;
;45:	gitem_t		*item;
;46:	//if ( weapon > WP_MACHINEGUN && weapon != WP_GRAPPLING_HOOK && 
;47:	//	self->client->ps.ammo[ weapon ] ) 
;48:	if(weapon != WP_NONE && weapon != WP_GRAPPLING_HOOK )
ADDRLP4 8
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $58
ADDRLP4 8
INDIRI4
CNSTI4 -1
EQI4 $58
line 49
;49:	{
line 51
;50:		// find the item type for this weapon
;51:		item = BG_FindItemForWeapon( weapon );
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 BG_FindItemForWeapon
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 12
INDIRP4
ASGNP4
line 54
;52:
;53:		// spawn the item
;54:		drop = Drop_Item( self, item, 0 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
CNSTF4 0
ARGF4
ADDRLP4 16
ADDRGP4 Drop_Item
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
line 55
;55:		drop->count = self->client->ps.ammo[weapon];
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
ADDRFP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
ASGNI4
line 56
;56:		if(self->client->ps.eFlags & EF_DEAD)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $60
line 57
;57:		{
line 58
;58:			return;
ADDRGP4 $57
JUMPV
LABELV $60
line 60
;59:		}
;60:		drop->enemy = self;
ADDRLP4 0
INDIRP4
CNSTI4 748
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 61
;61:		drop->s.eFlags |= EF_DEAD; // client-dropped gun
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 63
;62:		//G_SetOrigin( drop, drop->s.origin);
;63:		self->client->ps.ammo[weapon] = 0;
ADDRFP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
CNSTI4 0
ASGNI4
line 64
;64:		self->client->ps.stats[STAT_WEAPONS] &= ~(1 << weapon);
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 192
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
ADDRFP4 4
INDIRI4
LSHI4
BCOMI4
BANDI4
ASGNI4
line 65
;65:		if(self->client->ps.weapon != weapon)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ADDRFP4 4
INDIRI4
EQI4 $62
line 66
;66:		{ // nothing needed
line 67
;67:		}
ADDRGP4 $63
JUMPV
LABELV $62
line 68
;68:		else if(self->client->ps.stats[STAT_WEAPONS] & (1 << WP_GAUNTLET))
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $64
line 69
;69:			self->client->ps.weapon = WP_GAUNTLET;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 1
ASGNI4
ADDRGP4 $65
JUMPV
LABELV $64
line 71
;70:		else
;71:			self->client->ps.weapon = WP_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 0
ASGNI4
LABELV $65
LABELV $63
line 72
;72:	}
LABELV $58
line 74
;73:
;74:}
LABELV $57
endproc TossClientWeapon 28 12
export TossClientItems
proc TossClientItems 28 12
line 76
;75:// ## Hentai
;76:void TossClientItems( gentity_t *self ) {
line 83
;77:	gitem_t		*item;
;78:	float		angle;
;79:	int			i;
;80:	gentity_t	*drop;
;81:
;82:	// ## Hentai ##
;83:	TossClientWeapon(self, self->s.weapon);
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 16
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ARGI4
ADDRGP4 TossClientWeapon
CALLV
pop
line 87
;84:	// ## Hentai ##
;85:
;86:	// drop all the powerups if not in teamplay
;87:	if ( g_gametype.integer != GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
EQI4 $67
line 88
;88:		angle = 45;
ADDRLP4 12
CNSTF4 1110704128
ASGNF4
line 89
;89:		for ( i = 1 ; i < PW_NUM_POWERUPS ; i++ ) {
ADDRLP4 0
CNSTI4 1
ASGNI4
LABELV $70
line 90
;90:			if ( self->client->ps.powerups[ i ] > level.time ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $74
line 91
;91:				item = BG_FindItemForPowerup( i );
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 20
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 20
INDIRP4
ASGNP4
line 92
;92:				if ( !item ) {
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $77
line 93
;93:					continue;
ADDRGP4 $71
JUMPV
LABELV $77
line 95
;94:				}
;95:				drop = Drop_Item( self, item, angle );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
ADDRGP4 Drop_Item
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 24
INDIRP4
ASGNP4
line 97
;96:				// decide how many seconds it has left
;97:				drop->count = ( self->client->ps.powerups[ i ] - level.time ) / 1000;
ADDRLP4 4
INDIRP4
CNSTI4 740
ADDP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
SUBI4
CNSTI4 1000
DIVI4
ASGNI4
line 98
;98:				if ( drop->count < 1 ) {
ADDRLP4 4
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 1
GEI4 $80
line 99
;99:					drop->count = 1;
ADDRLP4 4
INDIRP4
CNSTI4 740
ADDP4
CNSTI4 1
ASGNI4
line 100
;100:				}
LABELV $80
line 101
;101:				angle += 45;
ADDRLP4 12
ADDRLP4 12
INDIRF4
CNSTF4 1110704128
ADDF4
ASGNF4
line 102
;102:			}
LABELV $74
line 103
;103:		}
LABELV $71
line 89
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 11
LTI4 $70
line 104
;104:	}
LABELV $67
line 105
;105:}
LABELV $66
endproc TossClientItems 28 12
export LookAtKiller
proc LookAtKiller 52 4
line 113
;106:
;107:
;108:/*
;109:==================
;110:LookAtKiller
;111:==================
;112:*/
;113:void LookAtKiller( gentity_t *self, gentity_t *inflictor, gentity_t *attacker ) {
line 117
;114:	vec3_t		dir;
;115:	vec3_t		angles;
;116:
;117:	if ( attacker && attacker != self ) {
ADDRLP4 24
ADDRFP4 8
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 24
INDIRU4
CNSTU4 0
EQU4 $83
ADDRLP4 24
INDIRU4
ADDRFP4 0
INDIRP4
CVPU4 4
EQU4 $83
line 118
;118:		VectorSubtract (attacker->s.pos.trBase, self->s.pos.trBase, dir);
ADDRLP4 28
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 32
CNSTI4 24
ASGNI4
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
CNSTI4 28
ASGNI4
ADDRLP4 0+4
ADDRLP4 28
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 44
CNSTI4 32
ASGNI4
ADDRLP4 0+8
ADDRFP4 8
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 119
;119:	} else if ( inflictor && inflictor != self ) {
ADDRGP4 $84
JUMPV
LABELV $83
ADDRLP4 28
ADDRFP4 4
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 28
INDIRU4
CNSTU4 0
EQU4 $87
ADDRLP4 28
INDIRU4
ADDRFP4 0
INDIRP4
CVPU4 4
EQU4 $87
line 120
;120:		VectorSubtract (inflictor->s.pos.trBase, self->s.pos.trBase, dir);
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
CNSTI4 24
ASGNI4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 32
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 44
CNSTI4 28
ASGNI4
ADDRLP4 0+4
ADDRLP4 32
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 48
CNSTI4 32
ASGNI4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 121
;121:	} else {
ADDRGP4 $88
JUMPV
LABELV $87
line 122
;122:		self->client->ps.stats[STAT_DEAD_YAW] = self->s.angles[YAW];
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 200
ADDP4
ADDRLP4 32
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
CVFI4 4
ASGNI4
line 123
;123:		return;
ADDRGP4 $82
JUMPV
LABELV $88
LABELV $84
line 126
;124:	}
;125:
;126:	self->client->ps.stats[STAT_DEAD_YAW] = vectoyaw ( dir );
ADDRLP4 0
ARGP4
ADDRLP4 32
ADDRGP4 vectoyaw
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 200
ADDP4
ADDRLP4 32
INDIRF4
CVFI4 4
ASGNI4
line 128
;127:
;128:	angles[YAW] = vectoyaw ( dir );
ADDRLP4 0
ARGP4
ADDRLP4 36
ADDRGP4 vectoyaw
CALLF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 36
INDIRF4
ASGNF4
line 129
;129:	angles[PITCH] = 0; 
ADDRLP4 12
CNSTF4 0
ASGNF4
line 130
;130:	angles[ROLL] = 0;
ADDRLP4 12+8
CNSTF4 0
ASGNF4
line 131
;131:}
LABELV $82
endproc LookAtKiller 52 4
export GibEntity
proc GibEntity 4 12
line 138
;132:
;133:/*
;134:==================
;135:GibEntity
;136:==================
;137:*/
;138:void GibEntity( gentity_t *self, int killer ) {
line 140
;139:	
;140:	if(g_BleedToDeath.value == 0 || g_PlayerClasses.value == 0)
ADDRLP4 0
CNSTF4 0
ASGNF4
ADDRGP4 g_BleedToDeath+8
INDIRF4
ADDRLP4 0
INDIRF4
EQF4 $98
ADDRGP4 g_PlayerClasses+8
INDIRF4
ADDRLP4 0
INDIRF4
NEF4 $94
LABELV $98
line 141
;141:		G_AddEvent( self, EV_GIB_PLAYER, killer );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 62
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
ADDRGP4 $95
JUMPV
LABELV $94
line 142
;142:	else if(!self->client)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $99
line 143
;143:	{
line 144
;144:		if(self->takedamage == -1)
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $101
line 145
;145:			G_AddEvent( self, EV_GIB_PLAYER, killer );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 62
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
ADDRGP4 $100
JUMPV
LABELV $101
line 147
;146:		else
;147:			G_AddEvent( self, EV_GIB_NOBLOOD, killer );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 66
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 148
;148:	}
ADDRGP4 $100
JUMPV
LABELV $99
line 149
;149:	else if(self->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $103
line 150
;150:		G_AddEvent( self, EV_GIB_PLAYER, killer );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 62
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
ADDRGP4 $104
JUMPV
LABELV $103
line 152
;151:	else
;152:	{
line 153
;153:		G_AddEvent( self, EV_GIB_NOBLOOD, killer );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 66
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 155
;154:		//G_Printf("noblood?\n");
;155:	}
LABELV $104
LABELV $100
LABELV $95
line 156
;156:	self->takedamage = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 0
ASGNI4
line 157
;157:	self->s.eType = ET_INVISIBLE;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 10
ASGNI4
line 158
;158:	self->r.contents = 0;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 0
ASGNI4
line 159
;159:}
LABELV $93
endproc GibEntity 4 12
export body_die
proc body_die 0 8
line 166
;160:
;161:/*
;162:==================
;163:body_die
;164:==================
;165:*/
;166:void body_die( gentity_t *self, gentity_t *inflictor, gentity_t *attacker, int damage, int meansOfDeath ) {
line 167
;167:	if ( self->health > GIB_HEALTH ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 -40
LEI4 $106
line 168
;168:		return;
ADDRGP4 $105
JUMPV
LABELV $106
line 170
;169:	}
;170:	if ( !g_blood.integer ) {
ADDRGP4 g_blood+12
INDIRI4
CNSTI4 0
NEI4 $108
line 171
;171:		self->health = GIB_HEALTH+1;
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
CNSTI4 -39
ASGNI4
line 172
;172:		return;
ADDRGP4 $105
JUMPV
LABELV $108
line 175
;173:	}
;174:
;175:	GibEntity( self, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 GibEntity
CALLV
pop
line 176
;176:}
LABELV $105
endproc body_die 0 8
data
export modNames
align 4
LABELV modNames
address $111
address $112
address $113
address $114
address $115
address $116
address $117
address $118
address $119
address $120
address $121
address $122
address $123
address $124
address $125
address $126
address $127
address $128
address $129
address $130
address $131
address $132
address $133
address $134
bss
align 4
LABELV $193
skip 4
export player_die
code
proc player_die 104 28
line 213
;177:
;178:
;179:// these are just for logging, the client prints its own messages
;180:char	*modNames[] = {
;181:	"MOD_UNKNOWN",
;182:	"MOD_SHOTGUN",
;183:	"MOD_GAUNTLET",
;184:	"MOD_MACHINEGUN",
;185:	"MOD_GRENADE",
;186:	"MOD_GRENADE_SPLASH",
;187:	"MOD_ROCKET",
;188:	"MOD_ROCKET_SPLASH",
;189:	"MOD_PLASMA",
;190:	"MOD_PLASMA_SPLASH",
;191:	"MOD_RAILGUN",
;192:	"MOD_LIGHTNING",
;193:	"MOD_BFG",
;194:	"MOD_BFG_SPLASH",
;195:	"MOD_WATER",
;196:	"MOD_SLIME",
;197:	"MOD_LAVA",
;198:	"MOD_CRUSH",
;199:	"MOD_TELEFRAG",
;200:	"MOD_FALLING",
;201:	"MOD_SUICIDE",
;202:	"MOD_TARGET_LASER",
;203:	"MOD_TRIGGER_HURT",
;204:	"MOD_GRAPPLE"
;205:	"MOD_BLOOD"
;206:};
;207:
;208:/*
;209:==================
;210:player_die
;211:==================
;212:*/
;213:void player_die( gentity_t *self, gentity_t *inflictor, gentity_t *attacker, int damage, int meansOfDeath ) {
line 221
;214:	gentity_t	*ent;
;215:	int			anim;
;216:	int			contents;
;217:	int			killer;
;218:	int			i;
;219:	char		*killerName, *obit;
;220:	
;221:	if ( self->client->ps.pm_type == PM_DEAD ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $136
line 222
;222:		return;
ADDRGP4 $135
JUMPV
LABELV $136
line 225
;223:	}
;224:
;225:	if ( level.intermissiontime ) {
ADDRGP4 level+4228
INDIRI4
CNSTI4 0
EQI4 $138
line 226
;226:		return;
ADDRGP4 $135
JUMPV
LABELV $138
line 229
;227:	}
;228:
;229:	if (self->client && self->client->hook)
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 32
CNSTU4 0
ASGNU4
ADDRLP4 28
INDIRP4
CVPU4 4
ADDRLP4 32
INDIRU4
EQU4 $141
ADDRLP4 28
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 32
INDIRU4
EQU4 $141
line 230
;230:		Weapon_HookFree(self->client->hook);
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
ARGP4
ADDRGP4 Weapon_HookFree
CALLV
pop
LABELV $141
line 232
;231:
;232:	self->client->ps.pm_type = PM_DEAD;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 234
;233:
;234:	if ( attacker ) {
ADDRFP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $143
line 235
;235:		killer = attacker->s.number;
ADDRLP4 8
ADDRFP4 8
INDIRP4
INDIRI4
ASGNI4
line 236
;236:		if ( attacker->client ) {
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $145
line 237
;237:			killerName = attacker->client->pers.netname;
ADDRLP4 16
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ASGNP4
line 238
;238:		} else {
ADDRGP4 $144
JUMPV
LABELV $145
line 239
;239:			killerName = "<non-client>";
ADDRLP4 16
ADDRGP4 $147
ASGNP4
line 240
;240:		}
line 241
;241:	} else {
ADDRGP4 $144
JUMPV
LABELV $143
line 242
;242:		killer = ENTITYNUM_WORLD;
ADDRLP4 8
CNSTI4 1022
ASGNI4
line 243
;243:		killerName = "<world>";
ADDRLP4 16
ADDRGP4 $148
ASGNP4
line 244
;244:	}
LABELV $144
line 246
;245:
;246:	if ( killer < 0 || killer >= MAX_CLIENTS ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
LTI4 $151
ADDRLP4 8
INDIRI4
CNSTI4 128
LTI4 $149
LABELV $151
line 247
;247:		killer = ENTITYNUM_WORLD;
ADDRLP4 8
CNSTI4 1022
ASGNI4
line 248
;248:		killerName = "<world>";
ADDRLP4 16
ADDRGP4 $148
ASGNP4
line 249
;249:	}
LABELV $149
line 251
;250:
;251:	if ( meansOfDeath < 0 || meansOfDeath >= sizeof( modNames ) / sizeof( modNames[0] ) ) {
ADDRLP4 40
ADDRFP4 16
INDIRI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
LTI4 $154
ADDRLP4 40
INDIRI4
CVIU4 4
CNSTU4 24
LTU4 $152
LABELV $154
line 252
;252:		obit = "<bad obituary>";
ADDRLP4 20
ADDRGP4 $155
ASGNP4
line 253
;253:	} else {
ADDRGP4 $153
JUMPV
LABELV $152
line 254
;254:		obit = modNames[ meansOfDeath ];
ADDRLP4 20
ADDRFP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 modNames
ADDP4
INDIRP4
ASGNP4
line 255
;255:	}
LABELV $153
line 257
;256:
;257:	G_LogPrintf("Kill: %i %i %i: %s killed %s by %s\n", 
ADDRGP4 $156
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
INDIRI4
ARGI4
ADDRFP4 16
INDIRI4
ARGI4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 44
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 262
;258:		killer, self->s.number, meansOfDeath, killerName, 
;259:		self->client->pers.netname, obit );
;260:
;261:	// broadcast the death event to everyone
;262:	ent = G_TempEntity( self->r.currentOrigin, EV_OBITUARY );
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
CNSTI4 58
ARGI4
ADDRLP4 48
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 48
INDIRP4
ASGNP4
line 263
;263:	ent->s.eventParm = meansOfDeath;
ADDRLP4 4
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 16
INDIRI4
ASGNI4
line 264
;264:	ent->s.otherEntityNum = self->s.number;
ADDRLP4 4
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 265
;265:	ent->s.otherEntityNum2 = killer;
ADDRLP4 4
INDIRP4
CNSTI4 144
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 266
;266:	ent->r.svFlags = SVF_BROADCAST;	// send to everyone
ADDRLP4 4
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 32
ASGNI4
line 268
;267:
;268:	self->enemy = attacker;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
ADDRFP4 8
INDIRP4
ASGNP4
line 270
;269:
;270:	self->client->ps.persistant[PERS_KILLED]++;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 280
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 272
;271:
;272:	if (attacker && attacker->client) {
ADDRLP4 56
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 60
CNSTU4 0
ASGNU4
ADDRLP4 56
INDIRP4
CVPU4 4
ADDRLP4 60
INDIRU4
EQU4 $157
ADDRLP4 56
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 60
INDIRU4
EQU4 $157
line 273
;273:		if ( attacker == self || OnSameTeam (self, attacker ) ) {
ADDRLP4 64
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CVPU4 4
ADDRLP4 68
INDIRP4
CVPU4 4
EQU4 $161
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 OnSameTeam
CALLI4
ASGNI4
ADDRLP4 72
INDIRI4
CNSTI4 0
EQI4 $159
LABELV $161
line 274
;274:			AddScore( attacker, -1 );
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 275
;275:		} else {
ADDRGP4 $158
JUMPV
LABELV $159
line 276
;276:			AddScore( attacker, 1 );
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 278
;277:
;278:			if( meansOfDeath == MOD_GAUNTLET ) {
ADDRFP4 16
INDIRI4
CNSTI4 2
NEI4 $162
line 279
;279:				attacker->client->ps.persistant[PERS_GAUNTLET_FRAG_COUNT]++;
ADDRLP4 76
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 292
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 280
;280:				attacker->client->ps.persistant[PERS_REWARD] = REWARD_GAUNTLET;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 272
ADDP4
CNSTI4 4
ASGNI4
line 281
;281:				attacker->client->ps.persistant[PERS_REWARD_COUNT]++;
ADDRLP4 80
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 268
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 284
;282:
;283:				// add the sprite over the player's head
;284:				attacker->client->ps.eFlags &= ~(EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET );
ADDRLP4 84
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRI4
CNSTI4 -73
BANDI4
ASGNI4
line 285
;285:				attacker->client->ps.eFlags |= EF_AWARD_GAUNTLET;
ADDRLP4 88
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 286
;286:				attacker->client->rewardTime = level.time + REWARD_SPRITE_TIME;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 692
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 2000
ADDI4
ASGNI4
line 289
;287:
;288:				// also play humiliation on target
;289:				self->client->ps.persistant[PERS_REWARD] = REWARD_GAUNTLET;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 272
ADDP4
CNSTI4 4
ASGNI4
line 290
;290:				self->client->ps.persistant[PERS_REWARD_COUNT]++;
ADDRLP4 92
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 268
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 291
;291:			}
LABELV $162
line 295
;292:
;293:			// check for two kills in a short amount of time
;294:			// if this is close enough to the last kill, give a reward sound
;295:			if ( level.time - attacker->client->lastKillTime < CARNAGE_REWARD_TIME ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 700
ADDP4
INDIRI4
SUBI4
CNSTI4 3000
GEI4 $165
line 296
;296:				attacker->client->ps.persistant[PERS_REWARD_COUNT]++;
ADDRLP4 76
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 268
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 297
;297:				attacker->client->ps.persistant[PERS_REWARD] = REWARD_EXCELLENT;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 272
ADDP4
CNSTI4 2
ASGNI4
line 298
;298:				attacker->client->ps.persistant[PERS_EXCELLENT_COUNT]++;
ADDRLP4 80
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 288
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 301
;299:
;300:				// add the sprite over the player's head
;301:				attacker->client->ps.eFlags &= ~(EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET );
ADDRLP4 84
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRI4
CNSTI4 -73
BANDI4
ASGNI4
line 302
;302:				attacker->client->ps.eFlags |= EF_AWARD_EXCELLENT;
ADDRLP4 88
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 303
;303:				attacker->client->rewardTime = level.time + REWARD_SPRITE_TIME;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 692
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 2000
ADDI4
ASGNI4
line 304
;304:			}
LABELV $165
line 305
;305:			attacker->client->lastKillTime = level.time;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 700
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 307
;306:
;307:		}
line 308
;308:	} else {
ADDRGP4 $158
JUMPV
LABELV $157
line 309
;309:		AddScore( self, -1 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 310
;310:	}
LABELV $158
line 311
;311:	if(ent->client->headhit)
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 756
ADDP4
INDIRI4
CNSTI4 0
EQI4 $170
line 312
;312:		ent->s.eFlags |= EF_AWARD_IMPRESSIVE;
ADDRLP4 64
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRI4
CNSTI4 32768
BORI4
ASGNI4
ADDRGP4 $171
JUMPV
LABELV $170
line 314
;313:	else
;314:		ent->s.eFlags &= ~EF_AWARD_IMPRESSIVE;
ADDRLP4 68
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 -32769
BANDI4
ASGNI4
LABELV $171
line 317
;315:	
;316:	// Add team bonuses
;317:	Team_FragBonuses(self, inflictor, attacker);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Team_FragBonuses
CALLV
pop
line 320
;318:
;319:	// if client is in a nodrop area, don't drop anything (but return CTF flags!)
;320:	contents = trap_PointContents( self->r.currentOrigin, -1 );
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 72
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 72
INDIRI4
ASGNI4
line 321
;321:	if ( !( contents & CONTENTS_NODROP ) ) {
ADDRLP4 12
INDIRI4
CVIU4 4
CNSTU4 2147483648
BANDU4
CNSTU4 0
NEU4 $172
line 322
;322:		TossClientItems( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 TossClientItems
CALLV
pop
line 323
;323:	}
ADDRGP4 $173
JUMPV
LABELV $172
line 324
;324:	else {
line 325
;325:		if ( self->client->ps.powerups[PW_REDFLAG] ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 0
EQI4 $174
line 326
;326:			Team_ReturnFlag(TEAM_RED);
CNSTI4 1
ARGI4
ADDRGP4 Team_ReturnFlag
CALLV
pop
line 327
;327:		}
ADDRGP4 $175
JUMPV
LABELV $174
line 328
;328:		else if ( self->client->ps.powerups[PW_BLUEFLAG] ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 344
ADDP4
INDIRI4
CNSTI4 0
EQI4 $176
line 329
;329:			Team_ReturnFlag(TEAM_BLUE);
CNSTI4 2
ARGI4
ADDRGP4 Team_ReturnFlag
CALLV
pop
line 330
;330:		}
LABELV $176
LABELV $175
line 331
;331:	}
LABELV $173
line 333
;332:
;333:	Cmd_Score_f( self );		// show scores
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Cmd_Score_f
CALLV
pop
line 336
;334:	// send updated scores to any clients that are following this one,
;335:	// or they would get stale scoreboards
;336:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $181
JUMPV
LABELV $178
line 339
;337:		gclient_t	*client;
;338:
;339:		client = &level.clients[i];
ADDRLP4 76
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 340
;340:		if ( client->pers.connected != CON_CONNECTED ) {
ADDRLP4 76
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
EQI4 $183
line 341
;341:			continue;
ADDRGP4 $179
JUMPV
LABELV $183
line 343
;342:		}
;343:		if ( client->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRLP4 76
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $185
line 344
;344:			continue;
ADDRGP4 $179
JUMPV
LABELV $185
line 346
;345:		}
;346:		if ( client->sess.spectatorClient == self->s.number ) {
ADDRLP4 76
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
NEI4 $187
line 347
;347:			Cmd_Score_f( g_entities + i );
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRGP4 Cmd_Score_f
CALLV
pop
line 348
;348:		}
LABELV $187
line 349
;349:	}
LABELV $179
line 336
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $181
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $178
line 351
;350:
;351:	self->takedamage = qtrue;	// can still be gibbed
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 1
ASGNI4
line 353
;352:
;353:	self->s.weapon = WP_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 0
ASGNI4
line 354
;354:	self->s.powerups = 0;
ADDRFP4 0
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 0
ASGNI4
line 355
;355:	self->r.contents = CONTENTS_CORPSE;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 67108864
ASGNI4
line 357
;356:
;357:	self->s.angles[0] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 0
ASGNF4
line 358
;358:	self->s.angles[2] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
CNSTF4 0
ASGNF4
line 359
;359:	LookAtKiller (self, inflictor, attacker);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 LookAtKiller
CALLV
pop
line 361
;360:
;361:	VectorCopy( self->s.angles, self->client->ps.viewangles );
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 152
ADDP4
ADDRLP4 76
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 363
;362:
;363:	self->s.loopSound = 0;
ADDRFP4 0
INDIRP4
CNSTI4 156
ADDP4
CNSTI4 0
ASGNI4
line 365
;364:
;365:	self->r.maxs[2] = -8;
ADDRFP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTF4 3238002688
ASGNF4
line 369
;366:
;367:	// don't allow respawn until the death anim is done
;368:	// g_forcerespawn may force spawning at some later time
;369:	self->client->respawnTime = level.time + 1700;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 680
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1700
ADDI4
ASGNI4
line 372
;370:
;371:	// remove powerups
;372:	memset( self->client->ps.powerups, 0, sizeof(self->client->ps.powerups) );
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 64
ARGU4
ADDRGP4 memset
CALLP4
pop
line 375
;373:
;374:	// never gib in a nodrop
;375:	if ( self->health <= GIB_HEALTH && !(contents & CONTENTS_NODROP) && g_blood.integer ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 -40
GTI4 $190
ADDRLP4 12
INDIRI4
CVIU4 4
CNSTU4 2147483648
BANDU4
CNSTU4 0
NEU4 $190
ADDRGP4 g_blood+12
INDIRI4
CNSTI4 0
EQI4 $190
line 377
;376:		// gib death
;377:		GibEntity( self, killer );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 GibEntity
CALLV
pop
line 378
;378:	} else {
ADDRGP4 $191
JUMPV
LABELV $190
line 382
;379:		// normal death
;380:		static int i;
;381:
;382:		switch ( i ) {
ADDRLP4 80
ADDRGP4 $193
INDIRI4
ASGNI4
ADDRLP4 80
INDIRI4
CNSTI4 0
EQI4 $196
ADDRLP4 80
INDIRI4
CNSTI4 1
EQI4 $197
ADDRLP4 80
INDIRI4
CNSTI4 2
EQI4 $198
ADDRGP4 $194
JUMPV
LABELV $196
line 384
;383:		case 0:
;384:			anim = BOTH_DEATH1;
ADDRLP4 24
CNSTI4 0
ASGNI4
line 385
;385:			break;
ADDRGP4 $195
JUMPV
LABELV $197
line 387
;386:		case 1:
;387:			anim = BOTH_DEATH2;
ADDRLP4 24
CNSTI4 2
ASGNI4
line 388
;388:			break;
ADDRGP4 $195
JUMPV
LABELV $198
LABELV $194
line 391
;389:		case 2:
;390:		default:
;391:			anim = BOTH_DEATH3;
ADDRLP4 24
CNSTI4 4
ASGNI4
line 392
;392:			break;
LABELV $195
line 397
;393:		}
;394:
;395:		// for the no-blood option, we need to prevent the health
;396:		// from going to gib level
;397:		if ( self->health <= GIB_HEALTH ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 -40
GTI4 $199
line 398
;398:			self->health = GIB_HEALTH+1;
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
CNSTI4 -39
ASGNI4
line 399
;399:		}
LABELV $199
line 401
;400:
;401:		self->client->ps.legsAnim = 
ADDRLP4 84
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 88
CNSTI4 128
ASGNI4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRI4
ADDRLP4 88
INDIRI4
BANDI4
ADDRLP4 88
INDIRI4
BXORI4
ADDRLP4 24
INDIRI4
BORI4
ASGNI4
line 403
;402:			( ( self->client->ps.legsAnim & ANIM_TOGGLEBIT ) ^ ANIM_TOGGLEBIT ) | anim;
;403:		self->client->ps.torsoAnim = 
ADDRLP4 92
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 84
ADDP4
ASGNP4
ADDRLP4 96
CNSTI4 128
ASGNI4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
ADDRLP4 96
INDIRI4
BANDI4
ADDRLP4 96
INDIRI4
BXORI4
ADDRLP4 24
INDIRI4
BORI4
ASGNI4
line 406
;404:			( ( self->client->ps.torsoAnim & ANIM_TOGGLEBIT ) ^ ANIM_TOGGLEBIT ) | anim;
;405:
;406:		G_AddEvent( self, EV_DEATH1 + 1, killer );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 56
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 409
;407:
;408:		// the body can still be gibbed
;409:		self->die = body_die;
ADDRFP4 0
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 body_die
ASGNP4
line 412
;410:
;411:		// globally cycle through the different death animations
;412:		i = ( i + 1 ) % 3;
ADDRLP4 100
ADDRGP4 $193
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 3
MODI4
ASGNI4
line 413
;413:	}
LABELV $191
line 415
;414:
;415:	trap_LinkEntity (self);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 416
;416:}
LABELV $135
endproc player_die 104 28
export CheckArmor
proc CheckArmor 20 4
line 425
;417:
;418:
;419:/*
;420:================
;421:CheckArmor
;422:================
;423:*/
;424:int CheckArmor (gentity_t *ent, int damage, int dflags)
;425:{
line 430
;426:	gclient_t	*client;
;427:	int			save;
;428:	int			count;
;429:
;430:	if (!damage)
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $202
line 431
;431:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $201
JUMPV
LABELV $202
line 433
;432:
;433:	client = ent->client;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 435
;434:
;435:	if (!client)
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $204
line 436
;436:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $201
JUMPV
LABELV $204
line 438
;437:
;438:	if (dflags & DAMAGE_NO_ARMOR)
ADDRFP4 8
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $206
line 439
;439:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $201
JUMPV
LABELV $206
line 442
;440:
;441:	// armor
;442:	count = client->ps.stats[STAT_ARMOR];
ADDRLP4 8
ADDRLP4 4
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ASGNI4
line 443
;443:	save = ceil( damage * ARMOR_PROTECTION );
CNSTF4 1059648963
ADDRFP4 4
INDIRI4
CVIF4 4
MULF4
ARGF4
ADDRLP4 12
ADDRGP4 ceil
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 12
INDIRF4
CVFI4 4
ASGNI4
line 444
;444:	if (save >= count)
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
LTI4 $208
line 445
;445:		save = count;
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
LABELV $208
line 447
;446:
;447:	if (!save)
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $210
line 448
;448:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $201
JUMPV
LABELV $210
line 450
;449:
;450:	client->ps.stats[STAT_ARMOR] -= save;
ADDRLP4 16
ADDRLP4 4
INDIRP4
CNSTI4 196
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
ASGNI4
line 452
;451:
;452:	return save;
ADDRLP4 0
INDIRI4
RETI4
LABELV $201
endproc CheckArmor 20 4
export G_Damage
proc G_Damage 180 20
line 481
;453:}
;454:
;455:
;456:/*
;457:============
;458:T_Damage
;459:
;460:targ		entity that is being damaged
;461:inflictor	entity that is causing the damage
;462:attacker	entity that caused the inflictor to damage targ
;463:	example: targ=monster, inflictor=rocket, attacker=player
;464:
;465:dir			direction of the attack for knockback
;466:point		point at which the damage is being inflicted, used for headshots
;467:damage		amount of damage being inflicted
;468:knockback	force to be applied against targ as a result of the damage
;469:
;470:inflictor, attacker, dir, and point can be NULL for environmental effects
;471:
;472:dflags		these flags are used to control how T_Damage works
;473:	DAMAGE_RADIUS			damage was indirect (from a nearby explosion)
;474:	DAMAGE_NO_ARMOR			armor does not protect from this damage
;475:	DAMAGE_NO_KNOCKBACK		do not affect velocity, just view angles
;476:	DAMAGE_NO_PROTECTION	kills godmode, armor, everything
;477:============
;478:*/
;479:
;480:void G_Damage( gentity_t *targ, gentity_t *inflictor, gentity_t *attacker,
;481:			   vec3_t dir, vec3_t point, int damage, int dflags, int mod ) {
line 488
;482:	gclient_t	*client;
;483:	int			take;
;484:	int			save;
;485:	int			asave;
;486:	int			knockback;
;487:
;488:	if (!targ->takedamage) {
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
NEI4 $213
line 489
;489:		return;
ADDRGP4 $212
JUMPV
LABELV $213
line 494
;490:	}
;491:
;492:	// the intermission has allready been qualified for, so don't
;493:	// allow any extra scoring
;494:	if ( level.intermissionQueued ) {
ADDRGP4 level+4224
INDIRI4
CNSTI4 0
EQI4 $215
line 495
;495:		return;
ADDRGP4 $212
JUMPV
LABELV $215
line 498
;496:	}
;497:
;498:	if ( !inflictor ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $218
line 499
;499:		inflictor = &g_entities[ENTITYNUM_WORLD];
ADDRFP4 4
ADDRGP4 g_entities+809424
ASGNP4
line 500
;500:	}
LABELV $218
line 501
;501:	if ( !attacker ) {
ADDRFP4 8
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $221
line 502
;502:		attacker = &g_entities[ENTITYNUM_WORLD];
ADDRFP4 8
ADDRGP4 g_entities+809424
ASGNP4
line 503
;503:	}
LABELV $221
line 506
;504:
;505:	// shootable doors / buttons don't actually have any health
;506:	if ( targ->s.eType == ET_MOVER ) {
ADDRLP4 20
CNSTI4 4
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $224
line 507
;507:		if ( targ->use && targ->moverState == MOVER_POS1 ) {
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 688
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $212
ADDRLP4 24
INDIRP4
CNSTI4 564
ADDP4
INDIRI4
CNSTI4 0
NEI4 $212
line 508
;508:			targ->use( targ, inflictor, attacker );
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 28
INDIRP4
CNSTI4 688
ADDP4
INDIRP4
CALLV
pop
line 509
;509:		}
line 510
;510:		return;
ADDRGP4 $212
JUMPV
LABELV $224
line 519
;511:	}
;512:
;513:	// reduce damage by the attacker's handicap value
;514:	// unless they are rocket jumping
;515://	if ( attacker->client && attacker != targ ) {
;516://		damage = damage * attacker->client->ps.stats[STAT_MAX_HEALTH] / 100;
;517://	}
;518:
;519:	client = targ->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 521
;520:
;521:	if ( client ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $228
line 522
;522:		if ( client->noclip ) {
ADDRLP4 0
INDIRP4
CNSTI4 620
ADDP4
INDIRI4
CNSTI4 0
EQI4 $230
line 523
;523:			return;
ADDRGP4 $212
JUMPV
LABELV $230
line 525
;524:		}
;525:		if(p_class[client->pers.playerclass].bleeds)
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+76
ADDP4
INDIRI4
CNSTI4 0
EQI4 $232
line 526
;526:			client->ps.stats[STAT_EXTENDED_INFO] |= EXT_BLEEDS;
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
ADDRGP4 $233
JUMPV
LABELV $232
line 528
;527:		else
;528:			client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_BLEEDS;
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
LABELV $233
line 529
;529:	}
LABELV $228
line 531
;530:
;531:	if ( !dir ) {
ADDRFP4 12
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $235
line 532
;532:		dflags |= DAMAGE_NO_KNOCKBACK;
ADDRFP4 24
ADDRFP4 24
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 533
;533:	} else {
ADDRGP4 $236
JUMPV
LABELV $235
line 534
;534:		VectorNormalize(dir);
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 535
;535:	}
LABELV $236
line 537
;536:
;537:	knockback = damage;
ADDRLP4 8
ADDRFP4 20
INDIRI4
ASGNI4
line 538
;538:	if ( knockback > 200 ) {
ADDRLP4 8
INDIRI4
CNSTI4 200
LEI4 $237
line 539
;539:		knockback = 200;
ADDRLP4 8
CNSTI4 200
ASGNI4
line 540
;540:	}
LABELV $237
line 541
;541:	if ( targ->flags & FL_NO_KNOCKBACK ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $239
line 542
;542:		knockback = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 543
;543:	}
LABELV $239
line 544
;544:	if ( dflags & DAMAGE_NO_KNOCKBACK ) {
ADDRFP4 24
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $241
line 545
;545:		knockback = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 546
;546:	}
LABELV $241
line 549
;547:
;548:	// figure momentum add, even if the damage won't be taken
;549:	if ( knockback && targ->client ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $243
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $243
line 553
;550:		vec3_t	kvel;
;551:		float	mass;
;552:
;553:		if(targ->client->ps.stats[STAT_MASS])
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
EQI4 $245
line 554
;554:			mass = targ->client->ps.stats[STAT_MASS];
ADDRLP4 36
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CVIF4 4
ASGNF4
ADDRGP4 $246
JUMPV
LABELV $245
line 557
;555:		
;556:		else
;557:			mass = 200;
ADDRLP4 36
CNSTF4 1128792064
ASGNF4
LABELV $246
line 559
;558:
;559:		VectorScale (dir, g_knockback.value * (float)knockback / mass, kvel);
ADDRLP4 40
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 44
ADDRLP4 8
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 48
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 24
ADDRLP4 40
INDIRP4
INDIRF4
ADDRGP4 g_knockback+8
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ADDRLP4 48
INDIRF4
DIVF4
MULF4
ASGNF4
ADDRLP4 24+4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 g_knockback+8
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ADDRLP4 48
INDIRF4
DIVF4
MULF4
ASGNF4
ADDRLP4 24+8
ADDRFP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 g_knockback+8
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ADDRLP4 36
INDIRF4
DIVF4
MULF4
ASGNF4
line 560
;560:		VectorAdd (targ->client->ps.velocity, kvel, targ->client->ps.velocity);
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
ADDF4
ASGNF4
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRLP4 24+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 60
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 24+8
INDIRF4
ADDF4
ASGNF4
line 564
;561:
;562:		// set the timer so that the other client can't cancel
;563:		// out the movement immediately
;564:		if ( !targ->client->ps.pm_time ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 0
NEI4 $254
line 567
;565:			int		t;
;566:
;567:			t = knockback * 2;
ADDRLP4 64
ADDRLP4 8
INDIRI4
CNSTI4 1
LSHI4
ASGNI4
line 568
;568:			if ( t < 50 ) {
ADDRLP4 64
INDIRI4
CNSTI4 50
GEI4 $256
line 569
;569:				t = 50;
ADDRLP4 64
CNSTI4 50
ASGNI4
line 570
;570:			}
LABELV $256
line 571
;571:			if ( t > 200 ) {
ADDRLP4 64
INDIRI4
CNSTI4 200
LEI4 $258
line 572
;572:				t = 200;
ADDRLP4 64
CNSTI4 200
ASGNI4
line 573
;573:			}
LABELV $258
line 574
;574:			targ->client->ps.pm_time = t;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 64
INDIRI4
ASGNI4
line 575
;575:			targ->client->ps.pm_flags |= PMF_TIME_KNOCKBACK;
ADDRLP4 68
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 576
;576:		}
LABELV $254
line 577
;577:	}
LABELV $243
line 580
;578:
;579:	// check for completely getting out of the damage
;580:	if ( !(dflags & DAMAGE_NO_PROTECTION) ) {
ADDRFP4 24
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $260
line 584
;581:
;582:		// if TF_NO_FRIENDLY_FIRE is set, don't do damage to the target
;583:		// if the attacker was on the same team
;584:		if ( targ != attacker && OnSameTeam (targ, attacker)  ) {
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRP4
CVPU4 4
EQU4 $262
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 OnSameTeam
CALLI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 0
EQI4 $262
line 585
;585:			if ( !g_friendlyFire.integer ) {
ADDRGP4 g_friendlyFire+12
INDIRI4
CNSTI4 0
NEI4 $264
line 586
;586:				return;
ADDRGP4 $212
JUMPV
LABELV $264
line 588
;587:			}
;588:		}
LABELV $262
line 591
;589:
;590:		// check for godmode
;591:		if ( targ->flags & FL_GODMODE ) {
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $267
line 592
;592:			return;
ADDRGP4 $212
JUMPV
LABELV $267
line 594
;593:		}
;594:	}
LABELV $260
line 598
;595:
;596:	// battlesuit protects from all radius damage (but takes knockback)
;597:	// and protects 50% against all damage
;598:	if ( client && client->ps.powerups[PW_BATTLESUIT] ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $269
ADDRLP4 0
INDIRP4
CNSTI4 320
ADDP4
INDIRI4
CNSTI4 0
EQI4 $269
line 599
;599:		G_AddEvent( targ, EV_POWERUP_BATTLESUIT, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 60
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 600
;600:		if ( dflags & DAMAGE_RADIUS ) {
ADDRFP4 24
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $271
line 601
;601:			return;
ADDRGP4 $212
JUMPV
LABELV $271
line 603
;602:		}
;603:		damage *= 0.5;
ADDRFP4 20
CNSTF4 1056964608
ADDRFP4 20
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 604
;604:	}
LABELV $269
line 607
;605:	
;606:	// add to the attacker's hit counter
;607:	if ( attacker->client && targ != attacker && targ->health > 0 && mod != MOD_BLEED) {
ADDRLP4 28
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $273
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRP4
CVPU4 4
EQU4 $273
ADDRLP4 32
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 0
LEI4 $273
ADDRFP4 28
INDIRI4
CNSTI4 24
EQI4 $273
line 608
;608:		if ( OnSameTeam( targ, attacker ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 OnSameTeam
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $275
line 609
;609:			attacker->client->ps.persistant[PERS_HITS] -= damage;
ADDRLP4 40
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 252
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
ADDRFP4 20
INDIRI4
SUBI4
ASGNI4
line 610
;610:		} else {
ADDRGP4 $276
JUMPV
LABELV $275
line 611
;611:			attacker->client->ps.persistant[PERS_HITS] += damage;
ADDRLP4 40
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 252
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
ADDRFP4 20
INDIRI4
ADDI4
ASGNI4
line 612
;612:		}
LABELV $276
line 613
;613:	}
LABELV $273
line 617
;614:
;615:	// always give half damage if hurting self
;616:	// calculated after knockback, so rocket jumping works
;617:	if ( targ == attacker) {
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRFP4 8
INDIRP4
CVPU4 4
NEU4 $277
line 618
;618:		damage *= g_SelfDamageFactor.value;
ADDRFP4 20
ADDRFP4 20
INDIRI4
CVIF4 4
ADDRGP4 g_SelfDamageFactor+8
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 619
;619:	}	
LABELV $277
line 621
;620:		
;621:	if ( damage < 1 ) {
ADDRFP4 20
INDIRI4
CNSTI4 1
GEI4 $280
line 622
;622:		damage = 1;
ADDRFP4 20
CNSTI4 1
ASGNI4
line 623
;623:	}
LABELV $280
line 624
;624:	take = damage;
ADDRLP4 4
ADDRFP4 20
INDIRI4
ASGNI4
line 625
;625:	save = 0;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 628
;626:
;627:	// save some from armor
;628:	asave = CheckArmor (targ, take, dflags);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRFP4 24
INDIRI4
ARGI4
ADDRLP4 36
ADDRGP4 CheckArmor
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 36
INDIRI4
ASGNI4
line 629
;629:	take -= asave;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 12
INDIRI4
SUBI4
ASGNI4
line 632
;630:
;631:	
;632:	targ->client->headhit = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 756
ADDP4
CNSTI4 0
ASGNI4
line 633
;633:	if(mod == MOD_FALLING)
ADDRFP4 28
INDIRI4
CNSTI4 19
NEI4 $282
line 634
;634:	{
line 635
;635:		if(targ->client->pers.playerclass >= 0 && targ->client->pers.playerclass < MAX_PCLASSES)
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
LTI4 $284
ADDRLP4 40
INDIRI4
CNSTI4 64
GEI4 $284
line 636
;636:			take *= p_class[targ->client->pers.playerclass].dmgfactor;		
ADDRLP4 4
ADDRLP4 4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+56
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
LABELV $284
line 637
;637:		targ->client->ps.stats[STAT_LEG_DAMAGE] += take * take / 10 + 1;
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
CNSTI4 10
DIVI4
CNSTI4 1
ADDI4
ADDI4
ASGNI4
line 638
;638:	}
ADDRGP4 $283
JUMPV
LABELV $282
line 639
;639:	else if((dflags & DAMAGE_RADIUS))
ADDRFP4 24
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $287
line 640
;640:	{
line 641
;641:		if(targ->client->pers.playerclass >= 0 && targ->client->pers.playerclass < MAX_PCLASSES)
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
LTI4 $289
ADDRLP4 40
INDIRI4
CNSTI4 64
GEI4 $289
line 642
;642:		{
line 643
;643:			take *= p_class[targ->client->pers.playerclass].dmgfactor;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+56
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 644
;644:			if(targ->s.origin[2] + targ->client->waistheight > point[2])
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 752
ADDP4
INDIRF4
ADDF4
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $288
line 645
;645:				targ->client->ps.stats[STAT_LEG_DAMAGE] += take;
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 646
;646:		}
ADDRGP4 $288
JUMPV
LABELV $289
line 647
;647:		else if((targ->s.origin[2] - point[2]) > 24)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
CNSTF4 1103101952
LEF4 $288
line 648
;648:			targ->client->ps.stats[STAT_LEG_DAMAGE] += take;
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 649
;649:	}
ADDRGP4 $288
JUMPV
LABELV $287
line 650
;650:	else if(point && dir && mod != MOD_BLEED && (targ->client->pers.playerclass >= 0 && targ->client->pers.playerclass < MAX_PCLASSES))
ADDRLP4 40
CNSTU4 0
ASGNU4
ADDRFP4 16
INDIRP4
CVPU4 4
ADDRLP4 40
INDIRU4
EQU4 $296
ADDRFP4 12
INDIRP4
CVPU4 4
ADDRLP4 40
INDIRU4
EQU4 $296
ADDRFP4 28
INDIRI4
CNSTI4 24
EQI4 $296
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
LTI4 $296
ADDRLP4 44
INDIRI4
CNSTI4 64
GEI4 $296
line 651
;651:	{
line 655
;652:		vec3_t start, end, vdir;
;653:		float xd, yd, zd, dis;
;654:		//G_Printf("%f %f %f - %f %f %f\n", point[0], point[1], point[2], targ->r.currentOrigin[0], targ->r.currentOrigin[1], targ->r.currentOrigin[2]);
;655:		VectorSubtract(point, targ->s.pos.trBase, start);
ADDRLP4 100
ADDRFP4 16
INDIRP4
ASGNP4
ADDRLP4 104
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 48
ADDRLP4 100
INDIRP4
INDIRF4
ADDRLP4 104
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 48+4
ADDRLP4 100
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 104
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 48+8
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
SUBF4
ASGNF4
line 656
;656:		VectorMA(start, -16, dir, start); // in case head sticks out of bounding box
ADDRLP4 108
CNSTF4 3246391296
ASGNF4
ADDRLP4 112
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 48
ADDRLP4 48
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 112
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 48+4
ADDRLP4 48+4
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 112
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 48+8
ADDRLP4 48+8
INDIRF4
CNSTF4 3246391296
ADDRFP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 657
;657:		VectorSubtract(targ->client->headpos, start, vdir);
ADDRLP4 116
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 60
ADDRLP4 116
INDIRP4
INDIRP4
CNSTI4 728
ADDP4
INDIRF4
ADDRLP4 48
INDIRF4
SUBF4
ASGNF4
ADDRLP4 60+4
ADDRLP4 116
INDIRP4
INDIRP4
CNSTI4 732
ADDP4
INDIRF4
ADDRLP4 48+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 60+8
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 736
ADDP4
INDIRF4
ADDRLP4 48+8
INDIRF4
SUBF4
ASGNF4
line 658
;658:		dis = VectorNormalize(vdir);
ADDRLP4 60
ARGP4
ADDRLP4 120
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 84
ADDRLP4 120
INDIRF4
ASGNF4
line 659
;659:		VectorMA(start, dis * DotProduct(vdir, dir), dir, end);
ADDRLP4 124
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 128
ADDRLP4 124
INDIRP4
INDIRF4
ASGNF4
ADDRLP4 132
ADDRLP4 84
INDIRF4
ASGNF4
ADDRLP4 136
ADDRLP4 60
INDIRF4
ASGNF4
ADDRLP4 140
ADDRLP4 124
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 144
ADDRLP4 124
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 72
ADDRLP4 48
INDIRF4
ADDRLP4 128
INDIRF4
ADDRLP4 132
INDIRF4
ADDRLP4 136
INDIRF4
ADDRLP4 128
INDIRF4
MULF4
ADDRLP4 60+4
INDIRF4
ADDRLP4 140
INDIRP4
INDIRF4
MULF4
ADDF4
ADDRLP4 60+8
INDIRF4
ADDRLP4 144
INDIRP4
INDIRF4
MULF4
ADDF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 148
ADDRLP4 140
INDIRP4
INDIRF4
ASGNF4
ADDRLP4 72+4
ADDRLP4 48+4
INDIRF4
ADDRLP4 148
INDIRF4
ADDRLP4 132
INDIRF4
ADDRLP4 136
INDIRF4
ADDRLP4 124
INDIRP4
INDIRF4
MULF4
ADDRLP4 60+4
INDIRF4
ADDRLP4 148
INDIRF4
MULF4
ADDF4
ADDRLP4 60+8
INDIRF4
ADDRLP4 144
INDIRP4
INDIRF4
MULF4
ADDF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 152
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 156
ADDRLP4 152
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
ADDRLP4 72+8
ADDRLP4 48+8
INDIRF4
ADDRLP4 156
INDIRF4
ADDRLP4 84
INDIRF4
ADDRLP4 60
INDIRF4
ADDRLP4 152
INDIRP4
INDIRF4
MULF4
ADDRLP4 60+4
INDIRF4
ADDRLP4 152
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 60+8
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
MULF4
MULF4
ADDF4
ASGNF4
line 660
;660:		xd = end[0] - targ->client->headpos[0];
ADDRLP4 88
ADDRLP4 72
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 728
ADDP4
INDIRF4
SUBF4
ASGNF4
line 661
;661:		yd = end[1] - targ->client->headpos[1];
ADDRLP4 92
ADDRLP4 72+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 732
ADDP4
INDIRF4
SUBF4
ASGNF4
line 662
;662:		zd = end[2] - targ->client->headpos[2];
ADDRLP4 96
ADDRLP4 72+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 736
ADDP4
INDIRF4
SUBF4
ASGNF4
line 663
;663:		dis = sqrt(xd*xd + yd*yd + zd*zd);
ADDRLP4 160
ADDRLP4 88
INDIRF4
ASGNF4
ADDRLP4 164
ADDRLP4 92
INDIRF4
ASGNF4
ADDRLP4 168
ADDRLP4 96
INDIRF4
ASGNF4
ADDRLP4 160
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDRLP4 164
INDIRF4
ADDRLP4 164
INDIRF4
MULF4
ADDF4
ADDRLP4 168
INDIRF4
ADDRLP4 168
INDIRF4
MULF4
ADDF4
ARGF4
ADDRLP4 172
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 84
ADDRLP4 172
INDIRF4
ASGNF4
line 666
;664:		
;665:		//G_Printf("%s: %f %f %f -> %f %f %f [%f]\n", targ->client->pers.netname, end[0], end[1], end[2], targ->client->headpos[0], targ->client->headpos[1], targ->client->headpos[2], dis);
;666:		if(dis < p_class[targ->client->pers.playerclass].headsize * g_HeadScale.value)
ADDRLP4 84
INDIRF4
CNSTI4 168
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+64
ADDP4
INDIRF4
ADDRGP4 g_HeadScale+8
INDIRF4
MULF4
GEF4 $320
line 667
;667:		{
line 668
;668:			take *= p_class[targ->client->pers.playerclass].head_dmgfactor;					
ADDRLP4 4
ADDRLP4 4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+60
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 669
;669:			if(take > targ->health)
ADDRLP4 4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
LEI4 $325
line 670
;670:				take = targ->health + 1;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $325
line 671
;671:			targ->client->headhit = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 756
ADDP4
CNSTI4 1
ASGNI4
line 672
;672:		}
ADDRGP4 $321
JUMPV
LABELV $320
line 674
;673:		else
;674:		{
line 675
;675:			take *= p_class[targ->client->pers.playerclass].dmgfactor;		
ADDRLP4 4
ADDRLP4 4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+56
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 676
;676:			if(start[2] < targ->client->waistheight)
ADDRLP4 48+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 752
ADDP4
INDIRF4
GEF4 $328
line 677
;677:			{ // leg hit
line 678
;678:				targ->client->ps.stats[STAT_LEG_DAMAGE] += take;
ADDRLP4 176
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 176
INDIRP4
ADDRLP4 176
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 679
;679:			}
LABELV $328
line 680
;680:		}
LABELV $321
line 681
;681:	}
LABELV $296
LABELV $288
LABELV $283
line 683
;682:	
;683:	if ( g_debugDamage.integer ) {
ADDRGP4 g_debugDamage+12
INDIRI4
CNSTI4 0
EQI4 $331
line 684
;684:		G_Printf( "client:%i health:%i damage:%i armor:%i\n", targ->s.number,
ADDRGP4 $334
ARGP4
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
INDIRI4
ARGI4
ADDRLP4 48
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRGP4 G_Printf
CALLV
pop
line 686
;685:			targ->health, take, asave );
;686:	}
LABELV $331
line 691
;687:
;688:	// add to the damage inflicted on a player this frame
;689:	// the total will be turned into screen blends and view angle kicks
;690:	// at the end of the frame
;691:	if ( client ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $335
line 692
;692:		if ( attacker ) {
ADDRFP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $337
line 693
;693:			client->ps.persistant[PERS_ATTACKER] = attacker->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
ADDRFP4 8
INDIRP4
INDIRI4
ASGNI4
line 694
;694:		} else {
ADDRGP4 $338
JUMPV
LABELV $337
line 695
;695:			client->ps.persistant[PERS_ATTACKER] = ENTITYNUM_WORLD;
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
CNSTI4 1022
ASGNI4
line 696
;696:		}
LABELV $338
line 697
;697:		if(g_BleedToDeath.value && !(dflags & DAMAGE_NO_BLEEDING) && (client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS))
ADDRGP4 g_BleedToDeath+8
INDIRF4
CNSTF4 0
EQF4 $339
ADDRLP4 48
CNSTI4 0
ASGNI4
ADDRFP4 24
INDIRI4
CNSTI4 16
BANDI4
ADDRLP4 48
INDIRI4
NEI4 $339
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 48
INDIRI4
EQI4 $339
line 698
;698:		{
line 699
;699:			if(save)
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $342
line 700
;700:				client->bleeding += take * g_BleedToDeath.value / (100.0 + save * save);
ADDRLP4 52
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 56
ADDRLP4 16
INDIRI4
ASGNI4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRLP4 4
INDIRI4
CVIF4 4
ADDRGP4 g_BleedToDeath+8
INDIRF4
MULF4
ADDRLP4 56
INDIRI4
ADDRLP4 56
INDIRI4
MULI4
CVIF4 4
CNSTF4 1120403456
ADDF4
DIVF4
ADDF4
ASGNF4
ADDRGP4 $343
JUMPV
LABELV $342
line 702
;701:			else
;702:				client->bleeding += take * g_BleedToDeath.value / 100.0;
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 4
INDIRI4
CVIF4 4
ADDRGP4 g_BleedToDeath+8
INDIRF4
MULF4
CNSTF4 1120403456
DIVF4
ADDF4
ASGNF4
LABELV $343
line 703
;703:			client->bleedtime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 704
;704:			if(client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $340
line 705
;705:				G_AddEvent(targ, EV_BLOOD, take);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 706
;706:		}
ADDRGP4 $340
JUMPV
LABELV $339
line 707
;707:		else if((dflags & DAMAGE_NO_BLEEDING) && !(client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS))
ADDRLP4 52
CNSTI4 0
ASGNI4
ADDRFP4 24
INDIRI4
CNSTI4 16
BANDI4
ADDRLP4 52
INDIRI4
EQI4 $349
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 52
INDIRI4
NEI4 $349
line 708
;708:		{ // non-bleeders take more damage from non-bleeding hits
line 709
;709:			take *= (1 + g_BleedToDeath.value / 50.0);
ADDRLP4 4
ADDRLP4 4
INDIRI4
CVIF4 4
ADDRGP4 g_BleedToDeath+8
INDIRF4
CNSTF4 1112014848
DIVF4
CNSTF4 1065353216
ADDF4
MULF4
CVFI4 4
ASGNI4
line 710
;710:		}
LABELV $349
LABELV $340
line 711
;711:		if(mod == MOD_BLEED && (client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS) )
ADDRFP4 28
INDIRI4
CNSTI4 24
NEI4 $352
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $352
line 712
;712:		{
line 713
;713:			G_AddEvent(targ, EV_BLOOD, take);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 714
;714:		}
ADDRGP4 $353
JUMPV
LABELV $352
line 716
;715:		else
;716:		{
line 717
;717:			client->damage_armor += asave;
ADDRLP4 56
ADDRLP4 0
INDIRP4
CNSTI4 640
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRI4
ADDRLP4 12
INDIRI4
ADDI4
ASGNI4
line 718
;718:			client->damage_blood += take;
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 644
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 719
;719:			client->damage_knockback += knockback;			
ADDRLP4 64
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRI4
ADDRLP4 8
INDIRI4
ADDI4
ASGNI4
line 720
;720:		}
LABELV $353
line 721
;721:		if ( dir ) {
ADDRFP4 12
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $354
line 722
;722:			VectorCopy ( dir, client->damage_from );
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
ADDRFP4 12
INDIRP4
INDIRB
ASGNB 12
line 723
;723:			client->damage_fromWorld = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 664
ADDP4
CNSTI4 0
ASGNI4
line 724
;724:		} else {
ADDRGP4 $355
JUMPV
LABELV $354
line 725
;725:			VectorCopy ( targ->r.currentOrigin, client->damage_from );
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 726
;726:			client->damage_fromWorld = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 664
ADDP4
CNSTI4 1
ASGNI4
line 727
;727:		}
LABELV $355
line 728
;728:	}
LABELV $335
line 731
;729:
;730:	// See if it's the player hurting the emeny flag carrier
;731:	Team_CheckHurtCarrier(targ, attacker);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Team_CheckHurtCarrier
CALLV
pop
line 733
;732:
;733:	if (targ->client) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $356
line 735
;734:		// set the last client who damaged the target
;735:		targ->client->lasthurt_client = attacker->s.number;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
ADDRFP4 8
INDIRP4
INDIRI4
ASGNI4
line 736
;736:		targ->client->lasthurt_mod = mod;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 676
ADDP4
ADDRFP4 28
INDIRI4
ASGNI4
line 737
;737:	}
LABELV $356
line 740
;738:
;739:	// do the damage
;740:	if (take) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $358
line 741
;741:		targ->health = targ->health - take;
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
SUBI4
ASGNI4
line 742
;742:		if(targ->health >= targ->client->ps.stats[STAT_MAX_HEALTH])
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 52
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 52
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
LTI4 $360
line 743
;743:		{
line 744
;744:			targ->client->ps.stats[STAT_LEG_DAMAGE] = 0;			
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 224
ADDP4
CNSTI4 0
ASGNI4
line 745
;745:		}		
LABELV $360
line 746
;746:		if(mod == MOD_BLEED && targ->health < -39)
ADDRFP4 28
INDIRI4
CNSTI4 24
NEI4 $362
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 -39
GEI4 $362
line 747
;747:			targ->health = -39;
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
CNSTI4 -39
ASGNI4
LABELV $362
line 748
;748:		if ( targ->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $364
line 749
;749:			targ->client->ps.stats[STAT_HEALTH] = targ->health;
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 56
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ASGNI4
line 750
;750:			targ->enemy = attacker;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
ADDRFP4 8
INDIRP4
ASGNP4
line 751
;751:		}
LABELV $364
line 753
;752:			
;753:		if ( targ->health <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 0
GTI4 $366
line 754
;754:			if ( client )
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $368
line 755
;755:				targ->flags |= FL_NO_KNOCKBACK;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRI4
CNSTI4 2048
BORI4
ASGNI4
LABELV $368
line 757
;756:
;757:			if (targ->health < -999)
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 -999
GEI4 $370
line 758
;758:				targ->health = -999;
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
CNSTI4 -999
ASGNI4
LABELV $370
line 759
;759:			targ->enemy = attacker;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
ADDRFP4 8
INDIRP4
ASGNP4
line 760
;760:			targ->die (targ, inflictor, attacker, take, mod);
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRFP4 28
INDIRI4
ARGI4
ADDRLP4 60
INDIRP4
CNSTI4 696
ADDP4
INDIRP4
CALLV
pop
line 761
;761:			return;
ADDRGP4 $212
JUMPV
LABELV $366
line 763
;762:		} 
;763:		else if(mod == MOD_BLEED)
ADDRFP4 28
INDIRI4
CNSTI4 24
NEI4 $372
line 764
;764:		{
line 765
;765:		}
ADDRGP4 $373
JUMPV
LABELV $372
line 766
;766:		else if ( targ->pain ) {
ADDRFP4 0
INDIRP4
CNSTI4 692
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $374
line 767
;767:			targ->pain (targ, attacker, take);
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 56
INDIRP4
CNSTI4 692
ADDP4
INDIRP4
CALLV
pop
line 768
;768:		}
LABELV $374
LABELV $373
line 769
;769:	}
LABELV $358
line 771
;770:
;771:}
LABELV $212
endproc G_Damage 180 20
export CanDamage
proc CanDamage 112 28
line 782
;772:
;773:
;774:/*
;775:============
;776:CanDamage
;777:
;778:Returns qtrue if the inflictor can directly damage the target.  Used for
;779:explosions and melee attacks.
;780:============
;781:*/
;782:qboolean CanDamage (gentity_t *targ, vec3_t origin) {
line 789
;783:	vec3_t	dest;
;784:	trace_t	tr;
;785:	vec3_t	midpoint;
;786:
;787:	// use the midpoint of the bounds instead of the origin, because
;788:	// bmodels may have their origin is 0,0,0
;789:	VectorAdd (targ->r.absmin, targ->r.absmax, midpoint);
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 80
INDIRP4
CNSTI4 452
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 464
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 80
INDIRP4
CNSTI4 456
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 468
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12+8
ADDRLP4 84
INDIRP4
CNSTI4 460
ADDP4
INDIRF4
ADDRLP4 84
INDIRP4
CNSTI4 472
ADDP4
INDIRF4
ADDF4
ASGNF4
line 790
;790:	VectorScale (midpoint, 0.5, midpoint);
ADDRLP4 88
CNSTF4 1056964608
ASGNF4
ADDRLP4 12
ADDRLP4 88
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 88
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+8
CNSTF4 1056964608
ADDRLP4 12+8
INDIRF4
MULF4
ASGNF4
line 792
;791:
;792:	VectorCopy (midpoint, dest);
ADDRLP4 0
ADDRLP4 12
INDIRB
ASGNB 12
line 793
;793:	trap_Trace ( &tr, origin, vec3_origin, vec3_origin, dest, ENTITYNUM_NONE, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 92
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1023
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 794
;794:	if (tr.fraction == 1.0)
ADDRLP4 24+8
INDIRF4
CNSTF4 1065353216
NEF4 $383
line 795
;795:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $376
JUMPV
LABELV $383
line 799
;796:
;797:	// this should probably check in the plane of projection, 
;798:	// rather than in world coordinate, and also include Z
;799:	VectorCopy (midpoint, dest);
ADDRLP4 0
ADDRLP4 12
INDIRB
ASGNB 12
line 800
;800:	dest[0] += 15.0;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1097859072
ADDF4
ASGNF4
line 801
;801:	dest[1] += 15.0;
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
CNSTF4 1097859072
ADDF4
ASGNF4
line 802
;802:	trap_Trace ( &tr, origin, vec3_origin, vec3_origin, dest, ENTITYNUM_NONE, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 96
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1023
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 803
;803:	if (tr.fraction == 1.0)
ADDRLP4 24+8
INDIRF4
CNSTF4 1065353216
NEF4 $387
line 804
;804:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $376
JUMPV
LABELV $387
line 806
;805:
;806:	VectorCopy (midpoint, dest);
ADDRLP4 0
ADDRLP4 12
INDIRB
ASGNB 12
line 807
;807:	dest[0] += 15.0;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1097859072
ADDF4
ASGNF4
line 808
;808:	dest[1] -= 15.0;
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
CNSTF4 1097859072
SUBF4
ASGNF4
line 809
;809:	trap_Trace ( &tr, origin, vec3_origin, vec3_origin, dest, ENTITYNUM_NONE, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 100
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 100
INDIRP4
ARGP4
ADDRLP4 100
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1023
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 810
;810:	if (tr.fraction == 1.0)
ADDRLP4 24+8
INDIRF4
CNSTF4 1065353216
NEF4 $391
line 811
;811:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $376
JUMPV
LABELV $391
line 813
;812:
;813:	VectorCopy (midpoint, dest);
ADDRLP4 0
ADDRLP4 12
INDIRB
ASGNB 12
line 814
;814:	dest[0] -= 15.0;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1097859072
SUBF4
ASGNF4
line 815
;815:	dest[1] += 15.0;
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
CNSTF4 1097859072
ADDF4
ASGNF4
line 816
;816:	trap_Trace ( &tr, origin, vec3_origin, vec3_origin, dest, ENTITYNUM_NONE, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 104
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 104
INDIRP4
ARGP4
ADDRLP4 104
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1023
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 817
;817:	if (tr.fraction == 1.0)
ADDRLP4 24+8
INDIRF4
CNSTF4 1065353216
NEF4 $395
line 818
;818:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $376
JUMPV
LABELV $395
line 820
;819:
;820:	VectorCopy (midpoint, dest);
ADDRLP4 0
ADDRLP4 12
INDIRB
ASGNB 12
line 821
;821:	dest[0] -= 15.0;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1097859072
SUBF4
ASGNF4
line 822
;822:	dest[1] -= 15.0;
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
CNSTF4 1097859072
SUBF4
ASGNF4
line 823
;823:	trap_Trace ( &tr, origin, vec3_origin, vec3_origin, dest, ENTITYNUM_NONE, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 108
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 108
INDIRP4
ARGP4
ADDRLP4 108
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1023
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 824
;824:	if (tr.fraction == 1.0)
ADDRLP4 24+8
INDIRF4
CNSTF4 1065353216
NEF4 $399
line 825
;825:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $376
JUMPV
LABELV $399
line 828
;826:
;827:
;828:	return qfalse;
CNSTI4 0
RETI4
LABELV $376
endproc CanDamage 112 28
export G_RadiusDamage
proc G_RadiusDamage 4196 32
line 838
;829:}
;830:
;831:
;832:/*
;833:============
;834:G_RadiusDamage
;835:============
;836:*/
;837:qboolean G_RadiusDamage ( vec3_t origin, gentity_t *attacker, float damage, float radius,
;838:					 gentity_t *ignore, int mod) {
line 847
;839:	float		points, dist;
;840:	gentity_t	*ent;
;841:	int			entityList[MAX_GENTITIES];
;842:	int			numListedEntities;
;843:	vec3_t		mins, maxs;
;844:	vec3_t		v;
;845:	vec3_t		dir;
;846:	int			i, e;
;847:	qboolean	hitClient = qfalse;
ADDRLP4 4168
CNSTI4 0
ASGNI4
line 849
;848:
;849:	if ( radius < 1 ) {
ADDRFP4 12
INDIRF4
CNSTF4 1065353216
GEF4 $403
line 850
;850:		radius = 1;
ADDRFP4 12
CNSTF4 1065353216
ASGNF4
line 851
;851:	}
LABELV $403
line 853
;852:
;853:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $405
line 854
;854:		mins[i] = origin[i] - radius;
ADDRLP4 4172
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4172
INDIRI4
ADDRLP4 4144
ADDP4
ADDRLP4 4172
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ADDRFP4 12
INDIRF4
SUBF4
ASGNF4
line 855
;855:		maxs[i] = origin[i] + radius;
ADDRLP4 4176
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4176
INDIRI4
ADDRLP4 4156
ADDP4
ADDRLP4 4176
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ADDRFP4 12
INDIRF4
ADDF4
ASGNF4
line 856
;856:	}
LABELV $406
line 853
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $405
line 858
;857:
;858:	numListedEntities = trap_EntitiesInBox( mins, maxs, entityList, MAX_GENTITIES );
ADDRLP4 4144
ARGP4
ADDRLP4 4156
ARGP4
ADDRLP4 44
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 4172
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 4140
ADDRLP4 4172
INDIRI4
ASGNI4
line 860
;859:
;860:	for ( e = 0 ; e < numListedEntities ; e++ ) {
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRGP4 $412
JUMPV
LABELV $409
line 861
;861:		ent = &g_entities[entityList[ e ]];
ADDRLP4 4
CNSTI4 792
ADDRLP4 20
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 44
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 863
;862:
;863:		if (ent == ignore)
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRFP4 16
INDIRP4
CVPU4 4
NEU4 $413
line 864
;864:			continue;
ADDRGP4 $410
JUMPV
LABELV $413
line 865
;865:		if (!ent->takedamage)
ADDRLP4 4
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
CNSTI4 0
NEI4 $415
line 866
;866:			continue;
ADDRGP4 $410
JUMPV
LABELV $415
line 869
;867:
;868:		// find the distance from the edge of the bounding box
;869:		for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $417
line 870
;870:			if ( origin[i] < ent->r.absmin[i] ) {
ADDRLP4 4176
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4176
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ADDRLP4 4176
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 452
ADDP4
ADDP4
INDIRF4
GEF4 $421
line 871
;871:				v[i] = ent->r.absmin[i] - origin[i];
ADDRLP4 4180
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4180
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 4180
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 452
ADDP4
ADDP4
INDIRF4
ADDRLP4 4180
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 872
;872:			} else if ( origin[i] > ent->r.absmax[i] ) {
ADDRGP4 $422
JUMPV
LABELV $421
ADDRLP4 4180
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4180
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ADDRLP4 4180
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 464
ADDP4
ADDP4
INDIRF4
LEF4 $423
line 873
;873:				v[i] = origin[i] - ent->r.absmax[i];
ADDRLP4 4184
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4184
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 4184
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ADDRLP4 4184
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 464
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 874
;874:			} else {
ADDRGP4 $424
JUMPV
LABELV $423
line 875
;875:				v[i] = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
CNSTF4 0
ASGNF4
line 876
;876:			}
LABELV $424
LABELV $422
line 877
;877:		}
LABELV $418
line 869
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $417
line 879
;878:
;879:		dist = VectorLength( v );
ADDRLP4 8
ARGP4
ADDRLP4 4176
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 4176
INDIRF4
ASGNF4
line 880
;880:		if ( dist >= radius ) {
ADDRLP4 24
INDIRF4
ADDRFP4 12
INDIRF4
LTF4 $425
line 881
;881:			continue;
ADDRGP4 $410
JUMPV
LABELV $425
line 884
;882:		}
;883:
;884:		points = damage * ( 1.0 - dist / radius );
ADDRLP4 40
ADDRFP4 8
INDIRF4
CNSTF4 1065353216
ADDRLP4 24
INDIRF4
ADDRFP4 12
INDIRF4
DIVF4
SUBF4
MULF4
ASGNF4
line 886
;885:
;886:		if( CanDamage (ent, origin) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4180
ADDRGP4 CanDamage
CALLI4
ASGNI4
ADDRLP4 4180
INDIRI4
CNSTI4 0
EQI4 $427
line 887
;887:			if( LogAccuracyHit( ent, attacker ) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4184
ADDRGP4 LogAccuracyHit
CALLI4
ASGNI4
ADDRLP4 4184
INDIRI4
CNSTI4 0
EQI4 $429
line 888
;888:				hitClient = qtrue;
ADDRLP4 4168
CNSTI4 1
ASGNI4
line 889
;889:			}
LABELV $429
line 890
;890:			VectorSubtract (ent->r.currentOrigin, origin, dir);
ADDRLP4 4192
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
ADDRLP4 4
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
ADDRLP4 4192
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 28+4
ADDRLP4 4
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
ADDRLP4 4192
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 28+8
ADDRLP4 4
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 893
;891:			// push the center of mass higher than the origin so players
;892:			// get knocked into the air more
;893:			dir[2] += 24;
ADDRLP4 28+8
ADDRLP4 28+8
INDIRF4
CNSTF4 1103101952
ADDF4
ASGNF4
line 894
;894:			if(mod == MOD_GRENADE_SPLASH)
ADDRFP4 20
INDIRI4
CNSTI4 5
NEI4 $434
line 895
;895:				G_Damage (ent, NULL, attacker, dir, origin, (int)points, DAMAGE_RADIUS, mod);
ADDRLP4 4
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 28
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 40
INDIRF4
CVFI4 4
ARGI4
CNSTI4 1
ARGI4
ADDRFP4 20
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
ADDRGP4 $435
JUMPV
LABELV $434
line 897
;896:			else
;897:				G_Damage (ent, NULL, attacker, dir, origin, (int)points, DAMAGE_RADIUS | DAMAGE_NO_BLEEDING, mod);
ADDRLP4 4
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 28
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 40
INDIRF4
CVFI4 4
ARGI4
CNSTI4 17
ARGI4
ADDRFP4 20
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
LABELV $435
line 898
;898:		}
LABELV $427
line 899
;899:	}
LABELV $410
line 860
ADDRLP4 20
ADDRLP4 20
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $412
ADDRLP4 20
INDIRI4
ADDRLP4 4140
INDIRI4
LTI4 $409
line 901
;900:
;901:	return hitClient;
ADDRLP4 4168
INDIRI4
RETI4
LABELV $402
endproc G_RadiusDamage 4196 32
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $334
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 37
byte 1 105
byte 1 32
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 116
byte 1 104
byte 1 58
byte 1 37
byte 1 105
byte 1 32
byte 1 100
byte 1 97
byte 1 109
byte 1 97
byte 1 103
byte 1 101
byte 1 58
byte 1 37
byte 1 105
byte 1 32
byte 1 97
byte 1 114
byte 1 109
byte 1 111
byte 1 114
byte 1 58
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $156
byte 1 75
byte 1 105
byte 1 108
byte 1 108
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 98
byte 1 121
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $155
byte 1 60
byte 1 98
byte 1 97
byte 1 100
byte 1 32
byte 1 111
byte 1 98
byte 1 105
byte 1 116
byte 1 117
byte 1 97
byte 1 114
byte 1 121
byte 1 62
byte 1 0
align 1
LABELV $148
byte 1 60
byte 1 119
byte 1 111
byte 1 114
byte 1 108
byte 1 100
byte 1 62
byte 1 0
align 1
LABELV $147
byte 1 60
byte 1 110
byte 1 111
byte 1 110
byte 1 45
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 62
byte 1 0
align 1
LABELV $134
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 71
byte 1 82
byte 1 65
byte 1 80
byte 1 80
byte 1 76
byte 1 69
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 66
byte 1 76
byte 1 79
byte 1 79
byte 1 68
byte 1 0
align 1
LABELV $133
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 84
byte 1 82
byte 1 73
byte 1 71
byte 1 71
byte 1 69
byte 1 82
byte 1 95
byte 1 72
byte 1 85
byte 1 82
byte 1 84
byte 1 0
align 1
LABELV $132
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 84
byte 1 65
byte 1 82
byte 1 71
byte 1 69
byte 1 84
byte 1 95
byte 1 76
byte 1 65
byte 1 83
byte 1 69
byte 1 82
byte 1 0
align 1
LABELV $131
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 83
byte 1 85
byte 1 73
byte 1 67
byte 1 73
byte 1 68
byte 1 69
byte 1 0
align 1
LABELV $130
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 70
byte 1 65
byte 1 76
byte 1 76
byte 1 73
byte 1 78
byte 1 71
byte 1 0
align 1
LABELV $129
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 84
byte 1 69
byte 1 76
byte 1 69
byte 1 70
byte 1 82
byte 1 65
byte 1 71
byte 1 0
align 1
LABELV $128
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 67
byte 1 82
byte 1 85
byte 1 83
byte 1 72
byte 1 0
align 1
LABELV $127
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 76
byte 1 65
byte 1 86
byte 1 65
byte 1 0
align 1
LABELV $126
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 83
byte 1 76
byte 1 73
byte 1 77
byte 1 69
byte 1 0
align 1
LABELV $125
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 87
byte 1 65
byte 1 84
byte 1 69
byte 1 82
byte 1 0
align 1
LABELV $124
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 66
byte 1 70
byte 1 71
byte 1 95
byte 1 83
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 72
byte 1 0
align 1
LABELV $123
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 66
byte 1 70
byte 1 71
byte 1 0
align 1
LABELV $122
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 76
byte 1 73
byte 1 71
byte 1 72
byte 1 84
byte 1 78
byte 1 73
byte 1 78
byte 1 71
byte 1 0
align 1
LABELV $121
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 82
byte 1 65
byte 1 73
byte 1 76
byte 1 71
byte 1 85
byte 1 78
byte 1 0
align 1
LABELV $120
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 77
byte 1 65
byte 1 95
byte 1 83
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 72
byte 1 0
align 1
LABELV $119
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 77
byte 1 65
byte 1 0
align 1
LABELV $118
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 82
byte 1 79
byte 1 67
byte 1 75
byte 1 69
byte 1 84
byte 1 95
byte 1 83
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 72
byte 1 0
align 1
LABELV $117
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 82
byte 1 79
byte 1 67
byte 1 75
byte 1 69
byte 1 84
byte 1 0
align 1
LABELV $116
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 71
byte 1 82
byte 1 69
byte 1 78
byte 1 65
byte 1 68
byte 1 69
byte 1 95
byte 1 83
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 72
byte 1 0
align 1
LABELV $115
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 71
byte 1 82
byte 1 69
byte 1 78
byte 1 65
byte 1 68
byte 1 69
byte 1 0
align 1
LABELV $114
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 77
byte 1 65
byte 1 67
byte 1 72
byte 1 73
byte 1 78
byte 1 69
byte 1 71
byte 1 85
byte 1 78
byte 1 0
align 1
LABELV $113
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 71
byte 1 65
byte 1 85
byte 1 78
byte 1 84
byte 1 76
byte 1 69
byte 1 84
byte 1 0
align 1
LABELV $112
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 83
byte 1 72
byte 1 79
byte 1 84
byte 1 71
byte 1 85
byte 1 78
byte 1 0
align 1
LABELV $111
byte 1 77
byte 1 79
byte 1 68
byte 1 95
byte 1 85
byte 1 78
byte 1 75
byte 1 78
byte 1 79
byte 1 87
byte 1 78
byte 1 0
