export DeathmatchScoreboardMessage
code
proc DeathmatchScoreboardMessage 2464 36
file "..\g_cmds.c"
line 12
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:
;5:
;6:/*
;7:==================
;8:DeathmatchScoreboardMessage
;9:
;10:==================
;11:*/
;12:void DeathmatchScoreboardMessage( gentity_t *ent ) {
line 22
;13:	char		entry[1024];
;14:	char		string[1400];
;15:	int			stringlength;
;16:	int			i, j;
;17:	gclient_t	*cl;
;18:	int			numSorted;
;19:	int			scoreFlags;
;20:
;21:	// send the latest information on all clients
;22:	string[0] = 0;
ADDRLP4 1044
CNSTI1 0
ASGNI1
line 23
;23:	stringlength = 0;
ADDRLP4 1032
CNSTI4 0
ASGNI4
line 24
;24:	scoreFlags = 0;
ADDRLP4 2444
CNSTI4 0
ASGNI4
line 27
;25:
;26:	// don't send more than 32 scores (FIXME?)
;27:	numSorted = level.numConnectedClients;
ADDRLP4 1040
ADDRGP4 level+72
INDIRI4
ASGNI4
line 28
;28:	if ( numSorted > 32 ) {
ADDRLP4 1040
INDIRI4
CNSTI4 32
LEI4 $48
line 29
;29:		numSorted = 32;
ADDRLP4 1040
CNSTI4 32
ASGNI4
line 30
;30:	}
LABELV $48
line 32
;31:
;32:	for (i=0 ; i < numSorted ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $53
JUMPV
LABELV $50
line 35
;33:		int		ping;
;34:
;35:		cl = &level.clients[level.sortedClients[i]];
ADDRLP4 4
CNSTI4 760
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+84
ADDP4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 37
;36:
;37:		if ( cl->pers.connected == CON_CONNECTING ) {
ADDRLP4 4
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 1
NEI4 $55
line 38
;38:			ping = -1;
ADDRLP4 2448
CNSTI4 -1
ASGNI4
line 39
;39:		} else {
ADDRGP4 $56
JUMPV
LABELV $55
line 40
;40:			ping = cl->ps.ping < 999 ? cl->ps.ping : 999;
ADDRLP4 4
INDIRP4
CNSTI4 440
ADDP4
INDIRI4
CNSTI4 999
GEI4 $58
ADDRLP4 2452
ADDRLP4 4
INDIRP4
CNSTI4 440
ADDP4
INDIRI4
ASGNI4
ADDRGP4 $59
JUMPV
LABELV $58
ADDRLP4 2452
CNSTI4 999
ASGNI4
LABELV $59
ADDRLP4 2448
ADDRLP4 2452
INDIRI4
ASGNI4
line 41
;41:		}
LABELV $56
line 42
;42:		Com_sprintf (entry, sizeof(entry),
ADDRLP4 8
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $60
ARGP4
ADDRLP4 2452
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 2452
INDIRI4
ADDRGP4 level+84
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
ARGI4
ADDRLP4 2448
INDIRI4
ARGI4
ADDRGP4 level+32
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
SUBI4
CNSTI4 60000
DIVI4
ARGI4
ADDRLP4 2444
INDIRI4
ARGI4
CNSTI4 792
ADDRLP4 2452
INDIRI4
ADDRGP4 level+84
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+188
ADDP4
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 46
;43:			" %i %i %i %i %i %i", level.sortedClients[i],
;44:			cl->ps.persistant[PERS_SCORE], ping, (level.time - cl->pers.enterTime)/60000,
;45:			scoreFlags, g_entities[level.sortedClients[i]].s.powerups);
;46:		j = strlen(entry);
ADDRLP4 8
ARGP4
ADDRLP4 2460
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1036
ADDRLP4 2460
INDIRU4
CVUI4 4
ASGNI4
line 47
;47:		if (stringlength + j > 1024)
ADDRLP4 1032
INDIRI4
ADDRLP4 1036
INDIRI4
ADDI4
CNSTI4 1024
LEI4 $65
line 48
;48:			break;
ADDRGP4 $52
JUMPV
LABELV $65
line 49
;49:		strcpy (string + stringlength, entry);
ADDRLP4 1032
INDIRI4
ADDRLP4 1044
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 50
;50:		stringlength += j;
ADDRLP4 1032
ADDRLP4 1032
INDIRI4
ADDRLP4 1036
INDIRI4
ADDI4
ASGNI4
line 51
;51:	}
LABELV $51
line 32
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $53
ADDRLP4 0
INDIRI4
ADDRLP4 1040
INDIRI4
LTI4 $50
LABELV $52
line 53
;52:
;53:	trap_SendServerCommand( ent-g_entities, va("scores %i %i %i%s", i, 
ADDRGP4 $67
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 level+44+4
INDIRI4
ARGI4
ADDRGP4 level+44+8
INDIRI4
ARGI4
ADDRLP4 1044
ARGP4
ADDRLP4 2448
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 2448
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 56
;54:		level.teamScores[TEAM_RED], level.teamScores[TEAM_BLUE],
;55:		string ) );
;56:}
LABELV $46
endproc DeathmatchScoreboardMessage 2464 36
export Cmd_Score_f
proc Cmd_Score_f 0 4
line 66
;57:
;58:
;59:/*
;60:==================
;61:Cmd_Score_f
;62:
;63:Request current scoreboard information
;64:==================
;65:*/
;66:void Cmd_Score_f( gentity_t *ent ) {
line 67
;67:	DeathmatchScoreboardMessage( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 DeathmatchScoreboardMessage
CALLV
pop
line 68
;68:}
LABELV $72
endproc Cmd_Score_f 0 4
export CheatsOk
proc CheatsOk 4 8
line 77
;69:
;70:
;71:
;72:/*
;73:==================
;74:CheatsOk
;75:==================
;76:*/
;77:qboolean	CheatsOk( gentity_t *ent ) {
line 78
;78:	if ( !g_cheats.integer ) {
ADDRGP4 g_cheats+12
INDIRI4
CNSTI4 0
NEI4 $74
line 79
;79:		trap_SendServerCommand( ent-g_entities, va("print \"Cheats are not enabled on this server.\n\""));
ADDRGP4 $77
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 80
;80:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $73
JUMPV
LABELV $74
line 82
;81:	}
;82:	if ( ent->health <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 0
GTI4 $78
line 83
;83:		trap_SendServerCommand( ent-g_entities, va("print \"You must be alive to use this command.\n\""));
ADDRGP4 $80
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 84
;84:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $73
JUMPV
LABELV $78
line 86
;85:	}
;86:	return qtrue;
CNSTI4 1
RETI4
LABELV $73
endproc CheatsOk 4 8
bss
align 1
LABELV $82
skip 1024
export ConcatArgs
code
proc ConcatArgs 1048 12
line 95
;87:}
;88:
;89:
;90:/*
;91:==================
;92:ConcatArgs
;93:==================
;94:*/
;95:char	*ConcatArgs( int start ) {
line 101
;96:	int		i, c, tlen;
;97:	static char	line[MAX_STRING_CHARS];
;98:	int		len;
;99:	char	arg[MAX_STRING_CHARS];
;100:
;101:	len = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 102
;102:	c = trap_Argc();
ADDRLP4 1040
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 1036
ADDRLP4 1040
INDIRI4
ASGNI4
line 103
;103:	for ( i = start ; i < c ; i++ ) {
ADDRLP4 4
ADDRFP4 0
INDIRI4
ASGNI4
ADDRGP4 $86
JUMPV
LABELV $83
line 104
;104:		trap_Argv( i, arg, sizeof( arg ) );
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 105
;105:		tlen = strlen( arg );
ADDRLP4 12
ARGP4
ADDRLP4 1044
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 8
ADDRLP4 1044
INDIRU4
CVUI4 4
ASGNI4
line 106
;106:		if ( len + tlen >= MAX_STRING_CHARS - 1 ) {
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
ADDI4
CNSTI4 1023
LTI4 $87
line 107
;107:			break;
ADDRGP4 $85
JUMPV
LABELV $87
line 109
;108:		}
;109:		memcpy( line + len, arg, tlen );
ADDRLP4 0
INDIRI4
ADDRGP4 $82
ADDP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 8
INDIRI4
CVIU4 4
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 110
;110:		len += tlen;
ADDRLP4 0
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
ADDI4
ASGNI4
line 111
;111:		if ( i != c - 1 ) {
ADDRLP4 4
INDIRI4
ADDRLP4 1036
INDIRI4
CNSTI4 1
SUBI4
EQI4 $89
line 112
;112:			line[len] = ' ';
ADDRLP4 0
INDIRI4
ADDRGP4 $82
ADDP4
CNSTI1 32
ASGNI1
line 113
;113:			len++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 114
;114:		}
LABELV $89
line 115
;115:	}
LABELV $84
line 103
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $86
ADDRLP4 4
INDIRI4
ADDRLP4 1036
INDIRI4
LTI4 $83
LABELV $85
line 117
;116:
;117:	line[len] = 0;
ADDRLP4 0
INDIRI4
ADDRGP4 $82
ADDP4
CNSTI1 0
ASGNI1
line 119
;118:
;119:	return line;
ADDRGP4 $82
RETP4
LABELV $81
endproc ConcatArgs 1048 12
export SanitizeString
proc SanitizeString 16 4
line 129
;120:}
;121:
;122:/*
;123:==================
;124:SanitizeString
;125:
;126:Remove case and control characters
;127:==================
;128:*/
;129:void SanitizeString( char *in, char *out ) {
ADDRGP4 $93
JUMPV
LABELV $92
line 130
;130:	while ( *in ) {
line 131
;131:		if ( *in == 27 ) {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 27
NEI4 $95
line 132
;132:			in += 2;		// skip color code
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 2
ADDP4
ASGNP4
line 133
;133:			continue;
ADDRGP4 $93
JUMPV
LABELV $95
line 135
;134:		}
;135:		if ( *in < 32 ) {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 32
GEI4 $97
line 136
;136:			in++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 137
;137:			continue;
ADDRGP4 $93
JUMPV
LABELV $97
line 139
;138:		}
;139:		*out++ = tolower( *in++ );
ADDRLP4 0
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRFP4 4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ASGNP4
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 12
ADDRGP4 tolower
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 12
INDIRI4
CVII1 4
ASGNI1
line 140
;140:	}
LABELV $93
line 130
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $92
line 142
;141:
;142:	*out = 0;
ADDRFP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 143
;143:}
LABELV $91
endproc SanitizeString 16 4
export ClientNumberFromString
proc ClientNumberFromString 2072 8
line 153
;144:
;145:/*
;146:==================
;147:ClientNumberFromString
;148:
;149:Returns a player number for either a number or name string
;150:Returns -1 if invalid
;151:==================
;152:*/
;153:int ClientNumberFromString( gentity_t *to, char *s ) {
line 160
;154:	gclient_t	*cl;
;155:	int			idnum;
;156:	char		s2[MAX_STRING_CHARS];
;157:	char		n2[MAX_STRING_CHARS];
;158:
;159:	// numeric values are just slot numbers
;160:	if (s[0] >= '0' && s[0] <= '9') {
ADDRLP4 2056
ADDRFP4 4
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 2056
INDIRI4
CNSTI4 48
LTI4 $100
ADDRLP4 2056
INDIRI4
CNSTI4 57
GTI4 $100
line 161
;161:		idnum = atoi( s );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 2060
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 2060
INDIRI4
ASGNI4
line 162
;162:		if ( idnum < 0 || idnum >= level.maxclients ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
LTI4 $105
ADDRLP4 4
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $102
LABELV $105
line 163
;163:			trap_SendServerCommand( to-g_entities, va("print \"Bad client slot: %i\n\"", idnum));
ADDRGP4 $106
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 2068
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 2068
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 164
;164:			return -1;
CNSTI4 -1
RETI4
ADDRGP4 $99
JUMPV
LABELV $102
line 167
;165:		}
;166:
;167:		cl = &level.clients[idnum];
ADDRLP4 0
CNSTI4 760
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 168
;168:		if ( cl->pers.connected != CON_CONNECTED ) {
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
EQI4 $107
line 169
;169:			trap_SendServerCommand( to-g_entities, va("print \"Client %i is not active\n\"", idnum));
ADDRGP4 $109
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 2068
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 2068
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 170
;170:			return -1;
CNSTI4 -1
RETI4
ADDRGP4 $99
JUMPV
LABELV $107
line 172
;171:		}
;172:		return idnum;
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $99
JUMPV
LABELV $100
line 176
;173:	}
;174:
;175:	// check for a name match
;176:	SanitizeString( s, s2 );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1032
ARGP4
ADDRGP4 SanitizeString
CALLV
pop
line 177
;177:	for ( idnum=0,cl=level.clients ; idnum < level.maxclients ; idnum++,cl++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
ADDRGP4 level
INDIRP4
ASGNP4
ADDRGP4 $113
JUMPV
LABELV $110
line 178
;178:		if ( cl->pers.connected != CON_CONNECTED ) {
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
EQI4 $115
line 179
;179:			continue;
ADDRGP4 $111
JUMPV
LABELV $115
line 181
;180:		}
;181:		SanitizeString( cl->pers.netname, n2 );
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 SanitizeString
CALLV
pop
line 182
;182:		if ( !strcmp( n2, s2 ) ) {
ADDRLP4 8
ARGP4
ADDRLP4 1032
ARGP4
ADDRLP4 2060
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2060
INDIRI4
CNSTI4 0
NEI4 $117
line 183
;183:			return idnum;
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $99
JUMPV
LABELV $117
line 185
;184:		}
;185:	}
LABELV $111
line 177
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 760
ADDP4
ASGNP4
LABELV $113
ADDRLP4 4
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $110
line 187
;186:
;187:	trap_SendServerCommand( to-g_entities, va("print \"User %s is not on the server\n\"", s));
ADDRGP4 $119
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 2060
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 2060
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 188
;188:	return -1;
CNSTI4 -1
RETI4
LABELV $99
endproc ClientNumberFromString 2072 8
export Cmd_Drop_f
proc Cmd_Drop_f 20 8
line 195
;189:}
;190:
;191:
;192:void TossClientWeapon(gentity_t *self, int w);
;193:
;194:void Cmd_Drop_f (gentity_t *ent)
;195:{	
line 199
;196:	int w;
;197:	
;198:	
;199:	w = atoi(ConcatArgs( 1 ));
CNSTI4 1
ARGI4
ADDRLP4 4
ADDRGP4 ConcatArgs
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
line 200
;200:	if(w > WP_GAUNTLET && (ent->client->ps.stats[STAT_WEAPONS] & (1 << w)))
ADDRLP4 16
CNSTI4 1
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 16
INDIRI4
LEI4 $121
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ADDRLP4 16
INDIRI4
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $121
line 201
;201:	{
line 202
;202:		TossClientWeapon(ent, w);		
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 TossClientWeapon
CALLV
pop
line 203
;203:	}
ADDRGP4 $122
JUMPV
LABELV $121
line 205
;204:	else
;205:	{
line 206
;206:		G_Printf("None to drop!\n");
ADDRGP4 $123
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 207
;207:	}
LABELV $122
line 209
;208:		
;209:}
LABELV $120
endproc Cmd_Drop_f 20 8
export Cmd_Give_f
proc Cmd_Give_f 112 12
line 218
;210:/*
;211:==================
;212:Cmd_Give_f
;213:
;214:Give items to a client
;215:==================
;216:*/
;217:void Cmd_Give_f (gentity_t *ent)
;218:{
line 226
;219:	char		*name;
;220:	gitem_t		*it;
;221:	int			i;
;222:	qboolean	give_all;
;223:	gentity_t		*it_ent;
;224:	trace_t		trace;
;225:
;226:	if ( !CheatsOk( ent ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76
ADDRGP4 CheatsOk
CALLI4
ASGNI4
ADDRLP4 76
INDIRI4
CNSTI4 0
NEI4 $125
line 227
;227:		return;
ADDRGP4 $124
JUMPV
LABELV $125
line 230
;228:	}
;229:
;230:	name = ConcatArgs( 1 );
CNSTI4 1
ARGI4
ADDRLP4 80
ADDRGP4 ConcatArgs
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 80
INDIRP4
ASGNP4
line 232
;231:
;232:	if (Q_stricmp(name, "all") == 0)
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 $129
ARGP4
ADDRLP4 84
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 84
INDIRI4
CNSTI4 0
NEI4 $127
line 233
;233:		give_all = qtrue;
ADDRLP4 4
CNSTI4 1
ASGNI4
ADDRGP4 $128
JUMPV
LABELV $127
line 235
;234:	else
;235:		give_all = qfalse;
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $128
line 237
;236:
;237:	if (give_all || Q_stricmp( name, "health") == 0)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $133
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 $132
ARGP4
ADDRLP4 88
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 88
INDIRI4
CNSTI4 0
NEI4 $130
LABELV $133
line 238
;238:	{
line 239
;239:		ent->health = ent->client->ps.stats[STAT_MAX_HEALTH];
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 92
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
ASGNI4
line 240
;240:		if (!give_all)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $134
line 241
;241:			return;
ADDRGP4 $124
JUMPV
LABELV $134
line 242
;242:	}
LABELV $130
line 244
;243:
;244:	if (give_all || Q_stricmp(name, "weapons") == 0)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $139
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 $138
ARGP4
ADDRLP4 92
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 92
INDIRI4
CNSTI4 0
NEI4 $136
LABELV $139
line 245
;245:	{
line 246
;246:		ent->client->ps.stats[STAT_WEAPONS] = (1 << WP_NUM_WEAPONS) - 1 - 
ADDRLP4 96
CNSTI4 1
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 1023
ADDRLP4 96
INDIRI4
CNSTI4 -1
LSHI4
SUBI4
ADDRLP4 96
INDIRI4
SUBI4
ASGNI4
line 248
;247:			( 1 << WP_GRAPPLING_HOOK ) - ( 1 << WP_NONE );
;248:		if (!give_all)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $140
line 249
;249:			return;
ADDRGP4 $124
JUMPV
LABELV $140
line 250
;250:	}
LABELV $136
line 252
;251:
;252:	if (give_all || Q_stricmp(name, "ammo") == 0)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $145
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 $144
ARGP4
ADDRLP4 96
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 96
INDIRI4
CNSTI4 0
NEI4 $142
LABELV $145
line 253
;253:	{
line 254
;254:		for ( i = 0 ; i < MAX_WEAPONS ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $146
line 255
;255:			ent->client->ps.ammo[i] = 999;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 376
ADDP4
ADDP4
CNSTI4 999
ASGNI4
line 256
;256:		}
LABELV $147
line 254
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $146
line 257
;257:		if (!give_all)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $150
line 258
;258:			return;
ADDRGP4 $124
JUMPV
LABELV $150
line 259
;259:	}
LABELV $142
line 261
;260:
;261:	if (give_all || Q_stricmp(name, "armor") == 0)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $155
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 $154
ARGP4
ADDRLP4 100
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 100
INDIRI4
CNSTI4 0
NEI4 $152
LABELV $155
line 262
;262:	{
line 263
;263:		ent->client->ps.stats[STAT_ARMOR] = 200;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 196
ADDP4
CNSTI4 200
ASGNI4
line 265
;264:
;265:		if (!give_all)
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $156
line 266
;266:			return;
ADDRGP4 $124
JUMPV
LABELV $156
line 267
;267:	}
LABELV $152
line 270
;268:
;269:	// spawn a specific item right on the player
;270:	if ( !give_all ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $158
line 271
;271:		it = BG_FindItem (name);
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 104
ADDRGP4 BG_FindItem
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 104
INDIRP4
ASGNP4
line 272
;272:		if (!it) {
ADDRLP4 16
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $160
line 273
;273:			return;
ADDRGP4 $124
JUMPV
LABELV $160
line 276
;274:		}
;275:
;276:		it_ent = G_Spawn();
ADDRLP4 108
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 108
INDIRP4
ASGNP4
line 277
;277:		VectorCopy( ent->r.currentOrigin, it_ent->s.origin );
ADDRLP4 12
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 278
;278:		it_ent->classname = it->classname;
ADDRLP4 12
INDIRP4
CNSTI4 512
ADDP4
ADDRLP4 16
INDIRP4
INDIRP4
ASGNP4
line 279
;279:		G_SpawnItem (it_ent, it);
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRGP4 G_SpawnItem
CALLV
pop
line 280
;280:		FinishSpawningItem(it_ent );
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 FinishSpawningItem
CALLV
pop
line 281
;281:		memset( &trace, 0, sizeof( trace ) );
ADDRLP4 20
ARGP4
CNSTI4 0
ARGI4
CNSTU4 56
ARGU4
ADDRGP4 memset
CALLP4
pop
line 282
;282:		Touch_Item (it_ent, ent, &trace);
ADDRLP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 Touch_Item
CALLV
pop
line 283
;283:		if (it_ent->inuse) {
ADDRLP4 12
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $162
line 284
;284:			G_FreeEntity( it_ent );
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 285
;285:		}
LABELV $162
line 286
;286:	}
LABELV $158
line 287
;287:}
LABELV $124
endproc Cmd_Give_f 112 12
export Cmd_God_f
proc Cmd_God_f 16 8
line 300
;288:
;289:
;290:/*
;291:==================
;292:Cmd_God_f
;293:
;294:Sets client to godmode
;295:
;296:argv(0) god
;297:==================
;298:*/
;299:void Cmd_God_f (gentity_t *ent)
;300:{
line 303
;301:	char	*msg;
;302:
;303:	if ( !CheatsOk( ent ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 CheatsOk
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $165
line 304
;304:		return;
ADDRGP4 $164
JUMPV
LABELV $165
line 307
;305:	}
;306:
;307:	ent->flags ^= FL_GODMODE;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 16
BXORI4
ASGNI4
line 308
;308:	if (!(ent->flags & FL_GODMODE) )
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
NEI4 $167
line 309
;309:		msg = "godmode OFF\n";
ADDRLP4 0
ADDRGP4 $169
ASGNP4
ADDRGP4 $168
JUMPV
LABELV $167
line 311
;310:	else
;311:		msg = "godmode ON\n";
ADDRLP4 0
ADDRGP4 $170
ASGNP4
LABELV $168
line 313
;312:
;313:	trap_SendServerCommand( ent-g_entities, va("print \"%s\"", msg));
ADDRGP4 $171
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 314
;314:}
LABELV $164
endproc Cmd_God_f 16 8
export Cmd_Notarget_f
proc Cmd_Notarget_f 16 8
line 326
;315:
;316:
;317:/*
;318:==================
;319:Cmd_Notarget_f
;320:
;321:Sets client to notarget
;322:
;323:argv(0) notarget
;324:==================
;325:*/
;326:void Cmd_Notarget_f( gentity_t *ent ) {
line 329
;327:	char	*msg;
;328:
;329:	if ( !CheatsOk( ent ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 CheatsOk
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $173
line 330
;330:		return;
ADDRGP4 $172
JUMPV
LABELV $173
line 333
;331:	}
;332:
;333:	ent->flags ^= FL_NOTARGET;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 32
BXORI4
ASGNI4
line 334
;334:	if (!(ent->flags & FL_NOTARGET) )
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $175
line 335
;335:		msg = "notarget OFF\n";
ADDRLP4 0
ADDRGP4 $177
ASGNP4
ADDRGP4 $176
JUMPV
LABELV $175
line 337
;336:	else
;337:		msg = "notarget ON\n";
ADDRLP4 0
ADDRGP4 $178
ASGNP4
LABELV $176
line 339
;338:
;339:	trap_SendServerCommand( ent-g_entities, va("print \"%s\"", msg));
ADDRGP4 $171
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 340
;340:}
LABELV $172
endproc Cmd_Notarget_f 16 8
export Cmd_Noclip_f
proc Cmd_Noclip_f 20 8
line 350
;341:
;342:
;343:/*
;344:==================
;345:Cmd_Noclip_f
;346:
;347:argv(0) noclip
;348:==================
;349:*/
;350:void Cmd_Noclip_f( gentity_t *ent ) {
line 353
;351:	char	*msg;
;352:
;353:	if ( !CheatsOk( ent ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 CheatsOk
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $180
line 354
;354:		return;
ADDRGP4 $179
JUMPV
LABELV $180
line 357
;355:	}
;356:
;357:	if ( ent->client->noclip ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 620
ADDP4
INDIRI4
CNSTI4 0
EQI4 $182
line 358
;358:		msg = "noclip OFF\n";
ADDRLP4 0
ADDRGP4 $184
ASGNP4
line 359
;359:	} else {
ADDRGP4 $183
JUMPV
LABELV $182
line 360
;360:		msg = "noclip ON\n";
ADDRLP4 0
ADDRGP4 $185
ASGNP4
line 361
;361:	}
LABELV $183
line 362
;362:	ent->client->noclip = !ent->client->noclip;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 620
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $187
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRGP4 $188
JUMPV
LABELV $187
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $188
ADDRLP4 12
INDIRP4
ADDRLP4 8
INDIRI4
ASGNI4
line 364
;363:
;364:	trap_SendServerCommand( ent-g_entities, va("print \"%s\"", msg));
ADDRGP4 $171
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 16
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 365
;365:}
LABELV $179
endproc Cmd_Noclip_f 20 8
export Cmd_LevelShot_f
proc Cmd_LevelShot_f 4 8
line 378
;366:
;367:
;368:/*
;369:==================
;370:Cmd_LevelShot_f
;371:
;372:This is just to help generate the level pictures
;373:for the menus.  It goes to the intermission immediately
;374:and sends over a command to the client to resize the view,
;375:hide the scoreboard, and take a special screenshot
;376:==================
;377:*/
;378:void Cmd_LevelShot_f( gentity_t *ent ) {
line 379
;379:	if ( !CheatsOk( ent ) ) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 CheatsOk
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $190
line 380
;380:		return;
ADDRGP4 $189
JUMPV
LABELV $190
line 384
;381:	}
;382:
;383:	// doesn't work in single player
;384:	if ( g_gametype.integer != 0 ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 0
EQI4 $192
line 385
;385:		trap_SendServerCommand( ent-g_entities, 
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $195
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 387
;386:			"print \"Must be in g_gametype 0 for levelshot\n\"" );
;387:		return;
ADDRGP4 $189
JUMPV
LABELV $192
line 390
;388:	}
;389:
;390:	BeginIntermission();
ADDRGP4 BeginIntermission
CALLV
pop
line 391
;391:	trap_SendServerCommand( ent-g_entities, "clientLevelShot" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $196
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 392
;392:}
LABELV $189
endproc Cmd_LevelShot_f 4 8
export Cmd_Kill_f
proc Cmd_Kill_f 16 20
line 400
;393:
;394:
;395:/*
;396:=================
;397:Cmd_Kill_f
;398:=================
;399:*/
;400:void Cmd_Kill_f( gentity_t *ent ) {
line 401
;401:	if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $198
line 402
;402:		return;
ADDRGP4 $197
JUMPV
LABELV $198
line 404
;403:	}
;404:	ent->flags &= ~FL_GODMODE;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -17
BANDI4
ASGNI4
line 405
;405:	ent->client->ps.stats[STAT_HEALTH] = ent->health = 0;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 406
;406:	player_die (ent, ent, ent, 100000, MOD_SUICIDE);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
CNSTI4 100000
ARGI4
CNSTI4 20
ARGI4
ADDRGP4 player_die
CALLV
pop
line 407
;407:}
LABELV $197
endproc Cmd_Kill_f 16 20
export BroadcastTeamChange
proc BroadcastTeamChange 8 8
line 417
;408:
;409:/*
;410:=================
;411:BroadCastTeamChange
;412:
;413:Let everyone know about a team change
;414:=================
;415:*/
;416:void BroadcastTeamChange( gclient_t *client, int oldTeam )
;417:{
line 418
;418:	if ( client->sess.sessionTeam == TEAM_RED ) {
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 1
NEI4 $201
line 419
;419:		trap_SendServerCommand( -1, va("cp \"%s" S_COLOR_WHITE " joined the red team.\n\"",
ADDRGP4 $203
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 421
;420:			client->pers.netname) );
;421:	} else if ( client->sess.sessionTeam == TEAM_BLUE ) {
ADDRGP4 $202
JUMPV
LABELV $201
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 2
NEI4 $204
line 422
;422:		trap_SendServerCommand( -1, va("cp \"%s" S_COLOR_WHITE " joined the blue team.\n\"",
ADDRGP4 $206
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 424
;423:		client->pers.netname));
;424:	} else if ( client->sess.sessionTeam == TEAM_SPECTATOR && oldTeam != TEAM_SPECTATOR ) {
ADDRGP4 $205
JUMPV
LABELV $204
ADDRLP4 0
CNSTI4 3
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $207
ADDRFP4 4
INDIRI4
ADDRLP4 0
INDIRI4
EQI4 $207
line 425
;425:		trap_SendServerCommand( -1, va("cp \"%s" S_COLOR_WHITE " joined the spectators.\n\"",
ADDRGP4 $209
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 427
;426:		client->pers.netname));
;427:	} else if ( client->sess.sessionTeam == TEAM_FREE ) {
ADDRGP4 $208
JUMPV
LABELV $207
ADDRFP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 0
NEI4 $210
line 428
;428:		trap_SendServerCommand( -1, va("cp \"%s" S_COLOR_WHITE " joined the battle.\n\"",
ADDRGP4 $212
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 430
;429:		client->pers.netname));
;430:	}
LABELV $210
LABELV $208
LABELV $205
LABELV $202
line 431
;431:}
LABELV $200
endproc BroadcastTeamChange 8 8
export SetTeam
proc SetTeam 92 20
line 438
;432:
;433:/*
;434:=================
;435:SetTeam
;436:=================
;437:*/
;438:void SetTeam( gentity_t *ent, char *s ) {
line 448
;439:	int					team, oldTeam;
;440:	gclient_t			*client;
;441:	int					clientNum;
;442:	spectatorState_t	specState;
;443:	int					specClient;
;444:
;445:	//
;446:	// see what change is requested
;447:	//
;448:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 450
;449:
;450:	clientNum = client - level.clients;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 760
DIVI4
ASGNI4
line 451
;451:	specClient = 0;
ADDRLP4 20
CNSTI4 0
ASGNI4
line 453
;452:
;453:	specState = SPECTATOR_NOT;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 454
;454:	if ( !Q_stricmp( s, "scoreboard" ) || !Q_stricmp( s, "score" )  ) {
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $216
ARGP4
ADDRLP4 24
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 0
EQI4 $218
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $217
ARGP4
ADDRLP4 28
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
NEI4 $214
LABELV $218
line 455
;455:		team = TEAM_SPECTATOR;
ADDRLP4 4
CNSTI4 3
ASGNI4
line 456
;456:		specState = SPECTATOR_SCOREBOARD;
ADDRLP4 16
CNSTI4 3
ASGNI4
line 457
;457:	} else if ( !Q_stricmp( s, "follow1" ) ) {
ADDRGP4 $215
JUMPV
LABELV $214
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $221
ARGP4
ADDRLP4 32
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 0
NEI4 $219
line 458
;458:		team = TEAM_SPECTATOR;
ADDRLP4 4
CNSTI4 3
ASGNI4
line 459
;459:		specState = SPECTATOR_FOLLOW;
ADDRLP4 16
CNSTI4 2
ASGNI4
line 460
;460:		specClient = -1;
ADDRLP4 20
CNSTI4 -1
ASGNI4
line 461
;461:	} else if ( !Q_stricmp( s, "follow2" ) ) {
ADDRGP4 $220
JUMPV
LABELV $219
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $224
ARGP4
ADDRLP4 36
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $222
line 462
;462:		team = TEAM_SPECTATOR;
ADDRLP4 4
CNSTI4 3
ASGNI4
line 463
;463:		specState = SPECTATOR_FOLLOW;
ADDRLP4 16
CNSTI4 2
ASGNI4
line 464
;464:		specClient = -2;
ADDRLP4 20
CNSTI4 -2
ASGNI4
line 465
;465:	} else if ( !Q_stricmp( s, "spectator" ) || !Q_stricmp( s, "s" ) ) {
ADDRGP4 $223
JUMPV
LABELV $222
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $227
ARGP4
ADDRLP4 40
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
EQI4 $229
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $228
ARGP4
ADDRLP4 44
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
NEI4 $225
LABELV $229
line 466
;466:		team = TEAM_SPECTATOR;
ADDRLP4 4
CNSTI4 3
ASGNI4
line 467
;467:		specState = SPECTATOR_FREE;
ADDRLP4 16
CNSTI4 1
ASGNI4
line 468
;468:	} else if ( g_gametype.integer >= GT_TEAM ) {
ADDRGP4 $226
JUMPV
LABELV $225
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
LTI4 $230
line 470
;469:		// if running a team game, assign player to one of the teams
;470:		specState = SPECTATOR_NOT;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 471
;471:		if ( !Q_stricmp( s, "red" ) || !Q_stricmp( s, "r" ) ) {
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $235
ARGP4
ADDRLP4 48
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 0
EQI4 $237
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $236
ARGP4
ADDRLP4 52
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $233
LABELV $237
line 472
;472:			team = TEAM_RED;
ADDRLP4 4
CNSTI4 1
ASGNI4
line 473
;473:		} else if ( !Q_stricmp( s, "blue" ) || !Q_stricmp( s, "b" ) ) {
ADDRGP4 $234
JUMPV
LABELV $233
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $240
ARGP4
ADDRLP4 56
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
EQI4 $242
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 $241
ARGP4
ADDRLP4 60
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
NEI4 $238
LABELV $242
line 474
;474:			team = TEAM_BLUE;
ADDRLP4 4
CNSTI4 2
ASGNI4
line 475
;475:		} else {
ADDRGP4 $239
JUMPV
LABELV $238
line 477
;476:			// pick the team with the least number of players
;477:			team = PickTeam( clientNum );
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 PickTeam
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 64
INDIRI4
ASGNI4
line 478
;478:		}
LABELV $239
LABELV $234
line 480
;479:
;480:		if ( g_teamForceBalance.integer ) {
ADDRGP4 g_teamForceBalance+12
INDIRI4
CNSTI4 0
EQI4 $231
line 483
;481:			int		counts[TEAM_NUM_TEAMS];
;482:
;483:			counts[TEAM_BLUE] = TeamCount( ent->client->ps.clientNum, TEAM_BLUE );
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 80
ADDRGP4 TeamCount
CALLI4
ASGNI4
ADDRLP4 64+8
ADDRLP4 80
INDIRI4
ASGNI4
line 484
;484:			counts[TEAM_RED] = TeamCount( ent->client->ps.clientNum, TEAM_RED );
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 84
ADDRGP4 TeamCount
CALLI4
ASGNI4
ADDRLP4 64+4
ADDRLP4 84
INDIRI4
ASGNI4
line 487
;485:
;486:			// We allow a spread of two
;487:			if ( team == TEAM_RED && counts[TEAM_RED] - counts[TEAM_BLUE] > 1 ) {
ADDRLP4 88
CNSTI4 1
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 88
INDIRI4
NEI4 $248
ADDRLP4 64+4
INDIRI4
ADDRLP4 64+8
INDIRI4
SUBI4
ADDRLP4 88
INDIRI4
LEI4 $248
line 488
;488:				trap_SendServerCommand( ent->client->ps.clientNum, 
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRGP4 $252
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 490
;489:					"cp \"Red team has too many players.\n\"" );
;490:				return; // ignore the request
ADDRGP4 $213
JUMPV
LABELV $248
line 492
;491:			}
;492:			if ( team == TEAM_BLUE && counts[TEAM_BLUE] - counts[TEAM_RED] > 1 ) {
ADDRLP4 4
INDIRI4
CNSTI4 2
NEI4 $231
ADDRLP4 64+8
INDIRI4
ADDRLP4 64+4
INDIRI4
SUBI4
CNSTI4 1
LEI4 $231
line 493
;493:				trap_SendServerCommand( ent->client->ps.clientNum, 
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRGP4 $252
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 495
;494:					"cp \"Red team has too many players.\n\"" );
;495:				return; // ignore the request
ADDRGP4 $213
JUMPV
line 499
;496:			}
;497:
;498:			// It's ok, the team we are switching to has less or same number of players
;499:		}
line 501
;500:
;501:	} else {
LABELV $230
line 503
;502:		// force them to spectators if there aren't any spots free
;503:		team = TEAM_FREE;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 504
;504:	}
LABELV $231
LABELV $226
LABELV $223
LABELV $220
LABELV $215
line 507
;505:
;506:	// override decision if limiting the players
;507:	if ( g_gametype.integer == GT_TOURNAMENT
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $257
ADDRGP4 level+76
INDIRI4
CNSTI4 2
LTI4 $257
line 508
;508:		&& level.numNonSpectatorClients >= 2 ) {
line 509
;509:		team = TEAM_SPECTATOR;
ADDRLP4 4
CNSTI4 3
ASGNI4
line 510
;510:	} else if ( g_maxGameClients.integer > 0 && 
ADDRGP4 $258
JUMPV
LABELV $257
ADDRGP4 g_maxGameClients+12
INDIRI4
CNSTI4 0
LEI4 $261
ADDRGP4 level+76
INDIRI4
ADDRGP4 g_maxGameClients+12
INDIRI4
LTI4 $261
line 511
;511:		level.numNonSpectatorClients >= g_maxGameClients.integer ) {
line 512
;512:		team = TEAM_SPECTATOR;
ADDRLP4 4
CNSTI4 3
ASGNI4
line 513
;513:	}
LABELV $261
LABELV $258
line 518
;514:
;515:	//
;516:	// decide if we will allow the change
;517:	//
;518:	oldTeam = client->sess.sessionTeam;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 519
;519:	if ( team == oldTeam && team != TEAM_SPECTATOR ) {
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $266
ADDRLP4 4
INDIRI4
CNSTI4 3
EQI4 $266
line 520
;520:		return;
ADDRGP4 $213
JUMPV
LABELV $266
line 528
;521:	}
;522:
;523:	//
;524:	// execute the team change
;525:	//
;526:
;527:	// he starts at 'base'
;528:	client->pers.teamState.state = TEAM_BEGIN;
ADDRLP4 0
INDIRP4
CNSTI4 528
ADDP4
CNSTI4 0
ASGNI4
line 529
;529:	if ( oldTeam != TEAM_SPECTATOR ) {
ADDRLP4 8
INDIRI4
CNSTI4 3
EQI4 $268
line 531
;530:		// Kill him (makes sure he loses flags, etc)
;531:		ent->flags &= ~FL_GODMODE;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRI4
CNSTI4 -17
BANDI4
ASGNI4
line 532
;532:		ent->client->ps.stats[STAT_HEALTH] = ent->health = 0;
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 60
CNSTI4 0
ASGNI4
ADDRLP4 56
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 60
INDIRI4
ASGNI4
ADDRLP4 56
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 60
INDIRI4
ASGNI4
line 533
;533:		player_die (ent, ent, ent, 100000, MOD_SUICIDE);
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
CNSTI4 100000
ARGI4
CNSTI4 20
ARGI4
ADDRGP4 player_die
CALLV
pop
line 535
;534:
;535:	}
LABELV $268
line 537
;536:	// they go to the end of the line for tournements
;537:	if ( team == TEAM_SPECTATOR ) {
ADDRLP4 4
INDIRI4
CNSTI4 3
NEI4 $270
line 538
;538:		client->sess.spectatorTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 596
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 539
;539:	}
LABELV $270
line 541
;540:
;541:	client->sess.sessionTeam = team;
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
ADDRLP4 4
INDIRI4
ASGNI4
line 542
;542:	client->sess.spectatorState = specState;
ADDRLP4 0
INDIRP4
CNSTI4 600
ADDP4
ADDRLP4 16
INDIRI4
ASGNI4
line 543
;543:	client->sess.spectatorClient = specClient;
ADDRLP4 0
INDIRP4
CNSTI4 604
ADDP4
ADDRLP4 20
INDIRI4
ASGNI4
line 545
;544:
;545:	BroadcastTeamChange( client, oldTeam );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 BroadcastTeamChange
CALLV
pop
line 548
;546:
;547:	// get and distribute relevent paramters
;548:	ClientUserinfoChanged( clientNum );
ADDRLP4 12
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 550
;549:
;550:	ClientBegin( clientNum );
ADDRLP4 12
INDIRI4
ARGI4
ADDRGP4 ClientBegin
CALLV
pop
line 551
;551:}
LABELV $213
endproc SetTeam 92 20
export StopFollowing
proc StopFollowing 8 0
line 561
;552:
;553:/*
;554:=================
;555:StopFollowing
;556:
;557:If the client being followed leaves the game, or you just want to drop
;558:to free floating spectator mode
;559:=================
;560:*/
;561:void StopFollowing( gentity_t *ent ) {
line 562
;562:	ent->client->ps.persistant[ PERS_TEAM ] = TEAM_SPECTATOR;	
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 260
ADDP4
CNSTI4 3
ASGNI4
line 563
;563:	ent->client->sess.sessionTeam = TEAM_SPECTATOR;	
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
CNSTI4 3
ASGNI4
line 564
;564:	ent->client->sess.spectatorState = SPECTATOR_FREE;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
CNSTI4 1
ASGNI4
line 565
;565:	ent->r.svFlags &= ~SVF_BOT;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
line 566
;566:	ent->client->ps.clientNum = ent - g_entities;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 140
ADDP4
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ASGNI4
line 567
;567:}
LABELV $273
endproc StopFollowing 8 0
export Cmd_Team_f
proc Cmd_Team_f 1036 12
line 574
;568:
;569:/*
;570:=================
;571:Cmd_Team_f
;572:=================
;573:*/
;574:void Cmd_Team_f( gentity_t *ent ) {
line 578
;575:	int			oldTeam;
;576:	char		s[MAX_TOKEN_CHARS];
;577:
;578:	if ( trap_Argc() != 2 ) {
ADDRLP4 1028
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 1028
INDIRI4
CNSTI4 2
EQI4 $275
line 579
;579:		oldTeam = ent->client->sess.sessionTeam;
ADDRLP4 1024
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 580
;580:		switch ( oldTeam ) {
ADDRLP4 1032
ADDRLP4 1024
INDIRI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 0
LTI4 $274
ADDRLP4 1032
INDIRI4
CNSTI4 3
GTI4 $274
ADDRLP4 1032
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $287
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $287
address $283
address $281
address $279
address $285
code
LABELV $279
line 582
;581:		case TEAM_BLUE:
;582:			trap_SendServerCommand( ent-g_entities, "print \"Blue team\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $280
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 583
;583:			break;
ADDRGP4 $274
JUMPV
LABELV $281
line 585
;584:		case TEAM_RED:
;585:			trap_SendServerCommand( ent-g_entities, "print \"Red team\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $282
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 586
;586:			break;
ADDRGP4 $274
JUMPV
LABELV $283
line 588
;587:		case TEAM_FREE:
;588:			trap_SendServerCommand( ent-g_entities, "print \"Free team\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $284
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 589
;589:			break;
ADDRGP4 $274
JUMPV
LABELV $285
line 591
;590:		case TEAM_SPECTATOR:
;591:			trap_SendServerCommand( ent-g_entities, "print \"Spectator team\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $286
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 592
;592:			break;
line 594
;593:		}
;594:		return;
ADDRGP4 $274
JUMPV
LABELV $275
line 598
;595:	}
;596:
;597:	// if they are playing a tournement game, count as a loss
;598:	if ( g_gametype.integer == GT_TOURNAMENT && ent->client->sess.sessionTeam == TEAM_FREE ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $288
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 0
NEI4 $288
line 599
;599:		ent->client->sess.losses++;
ADDRLP4 1032
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 612
ADDP4
ASGNP4
ADDRLP4 1032
INDIRP4
ADDRLP4 1032
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 600
;600:	}
LABELV $288
line 602
;601:
;602:	trap_Argv( 1, s, sizeof( s ) );
CNSTI4 1
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 604
;603:
;604:	SetTeam( ent, s );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 SetTeam
CALLV
pop
line 605
;605:}
LABELV $274
endproc Cmd_Team_f 1036 12
export Cmd_Follow_f
proc Cmd_Follow_f 1040 12
line 613
;606:
;607:
;608:/*
;609:=================
;610:Cmd_Follow_f
;611:=================
;612:*/
;613:void Cmd_Follow_f( gentity_t *ent ) {
line 617
;614:	int		i;
;615:	char	arg[MAX_TOKEN_CHARS];
;616:
;617:	if ( trap_Argc() != 2 ) {
ADDRLP4 1028
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 1028
INDIRI4
CNSTI4 2
EQI4 $292
line 618
;618:		if ( ent->client->sess.spectatorState == SPECTATOR_FOLLOW ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 2
NEI4 $291
line 619
;619:			StopFollowing( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 StopFollowing
CALLV
pop
line 620
;620:		}
line 621
;621:		return;
ADDRGP4 $291
JUMPV
LABELV $292
line 624
;622:	}
;623:
;624:	trap_Argv( 1, arg, sizeof( arg ) );
CNSTI4 1
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 625
;625:	i = ClientNumberFromString( ent, arg );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 1032
ADDRGP4 ClientNumberFromString
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 1032
INDIRI4
ASGNI4
line 626
;626:	if ( i == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $296
line 627
;627:		return;
ADDRGP4 $291
JUMPV
LABELV $296
line 631
;628:	}
;629:
;630:	// can't follow self
;631:	if ( &level.clients[ i ] == ent->client ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CVPU4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
NEU4 $298
line 632
;632:		return;
ADDRGP4 $291
JUMPV
LABELV $298
line 636
;633:	}
;634:
;635:	// can't follow another spectator
;636:	if ( level.clients[ i ].sess.sessionTeam == TEAM_SPECTATOR ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $300
line 637
;637:		return;
ADDRGP4 $291
JUMPV
LABELV $300
line 641
;638:	}
;639:
;640:	// if they are playing a tournement game, count as a loss
;641:	if ( g_gametype.integer == GT_TOURNAMENT && ent->client->sess.sessionTeam == TEAM_FREE ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $302
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 0
NEI4 $302
line 642
;642:		ent->client->sess.losses++;
ADDRLP4 1036
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 612
ADDP4
ASGNP4
ADDRLP4 1036
INDIRP4
ADDRLP4 1036
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 643
;643:	}
LABELV $302
line 646
;644:
;645:	// first set them to spectator
;646:	if ( ent->client->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $305
line 647
;647:		SetTeam( ent, "spectator" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $227
ARGP4
ADDRGP4 SetTeam
CALLV
pop
line 648
;648:	}
LABELV $305
line 650
;649:
;650:	ent->client->sess.spectatorState = SPECTATOR_FOLLOW;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
CNSTI4 2
ASGNI4
line 651
;651:	ent->client->sess.spectatorClient = i;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 604
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 652
;652:}
LABELV $291
endproc Cmd_Follow_f 1040 12
export Cmd_FollowCycle_f
proc Cmd_FollowCycle_f 12 8
line 659
;653:
;654:/*
;655:=================
;656:Cmd_FollowCycle_f
;657:=================
;658:*/
;659:void Cmd_FollowCycle_f( gentity_t *ent, int dir ) {
line 664
;660:	int		clientnum;
;661:	int		original;
;662:
;663:	// if they are playing a tournement game, count as a loss
;664:	if ( g_gametype.integer == GT_TOURNAMENT && ent->client->sess.sessionTeam == TEAM_FREE ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $308
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 0
NEI4 $308
line 665
;665:		ent->client->sess.losses++;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 612
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 666
;666:	}
LABELV $308
line 668
;667:	// first set them to spectator
;668:	if ( ent->client->sess.spectatorState == SPECTATOR_NOT ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 0
NEI4 $311
line 669
;669:		SetTeam( ent, "spectator" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $227
ARGP4
ADDRGP4 SetTeam
CALLV
pop
line 670
;670:	}
LABELV $311
line 672
;671:
;672:	if ( dir != 1 && dir != -1 ) {
ADDRLP4 8
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 1
EQI4 $313
ADDRLP4 8
INDIRI4
CNSTI4 -1
EQI4 $313
line 673
;673:		G_Error( "Cmd_FollowCycle_f: bad dir %i", dir );
ADDRGP4 $315
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 G_Error
CALLV
pop
line 674
;674:	}
LABELV $313
line 676
;675:
;676:	clientnum = ent->client->sess.spectatorClient;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
ASGNI4
line 677
;677:	original = clientnum;
ADDRLP4 4
ADDRLP4 0
INDIRI4
ASGNI4
LABELV $316
line 678
;678:	do {
line 679
;679:		clientnum += dir;
ADDRLP4 0
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
ADDI4
ASGNI4
line 680
;680:		if ( clientnum >= level.maxclients ) {
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $319
line 681
;681:			clientnum = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 682
;682:		}
LABELV $319
line 683
;683:		if ( clientnum < 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $322
line 684
;684:			clientnum = level.maxclients - 1;
ADDRLP4 0
ADDRGP4 level+24
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 685
;685:		}
LABELV $322
line 688
;686:
;687:		// can only follow connected clients
;688:		if ( level.clients[ clientnum ].pers.connected != CON_CONNECTED ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
EQI4 $325
line 689
;689:			continue;
ADDRGP4 $317
JUMPV
LABELV $325
line 693
;690:		}
;691:
;692:		// can't follow another spectator
;693:		if ( level.clients[ clientnum ].sess.sessionTeam == TEAM_SPECTATOR ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $327
line 694
;694:			continue;
ADDRGP4 $317
JUMPV
LABELV $327
line 698
;695:		}
;696:
;697:		// this is good, we can use it
;698:		ent->client->sess.spectatorClient = clientnum;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 604
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 699
;699:		ent->client->sess.spectatorState = SPECTATOR_FOLLOW;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
CNSTI4 2
ASGNI4
line 700
;700:		return;
ADDRGP4 $307
JUMPV
LABELV $317
line 701
;701:	} while ( clientnum != original );
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $316
line 704
;702:
;703:	// leave it where it was
;704:}
LABELV $307
endproc Cmd_FollowCycle_f 12 8
proc G_SayTo 24 24
line 718
;705:
;706:
;707:/*
;708:==================
;709:G_Say
;710:==================
;711:*/
;712:#define	MAX_SAY_TEXT	150
;713:
;714:#define SAY_ALL		0
;715:#define SAY_TEAM	1
;716:#define SAY_TELL	2
;717:
;718:static void G_SayTo( gentity_t *ent, gentity_t *other, int mode, int color, const char *name, const char *message ) {
line 719
;719:	if (!other) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $330
line 720
;720:		return;
ADDRGP4 $329
JUMPV
LABELV $330
line 722
;721:	}
;722:	if (!other->inuse) {
ADDRFP4 4
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $332
line 723
;723:		return;
ADDRGP4 $329
JUMPV
LABELV $332
line 725
;724:	}
;725:	if (!other->client) {
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $334
line 726
;726:		return;
ADDRGP4 $329
JUMPV
LABELV $334
line 728
;727:	}
;728:	if ( mode == SAY_TEAM  && !OnSameTeam(ent, other) ) {
ADDRFP4 8
INDIRI4
CNSTI4 1
NEI4 $336
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 OnSameTeam
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $336
line 729
;729:		return;
ADDRGP4 $329
JUMPV
LABELV $336
line 732
;730:	}
;731:	// no chatting to players in tournements
;732:	if ( g_gametype.integer == GT_TOURNAMENT
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $338
ADDRLP4 4
CNSTI4 504
ASGNI4
ADDRLP4 8
CNSTI4 592
ASGNI4
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $338
ADDRFP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $338
line 734
;733:		&& other->client->sess.sessionTeam == TEAM_FREE
;734:		&& ent->client->sess.sessionTeam != TEAM_FREE ) {
line 735
;735:		return;
ADDRGP4 $329
JUMPV
LABELV $338
line 738
;736:	}
;737:
;738:	trap_SendServerCommand( other-g_entities, va("%s \"%s%c%c%s\"", 
ADDRGP4 $341
ARGP4
ADDRFP4 8
INDIRI4
CNSTI4 1
NEI4 $345
ADDRLP4 16
ADDRGP4 $342
ASGNP4
ADDRGP4 $346
JUMPV
LABELV $345
ADDRLP4 16
ADDRGP4 $343
ASGNP4
LABELV $346
ADDRLP4 16
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
CNSTI4 94
ARGI4
ADDRFP4 12
INDIRI4
ARGI4
ADDRFP4 20
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 4
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 741
;739:		mode == SAY_TEAM ? "tchat" : "chat",
;740:		name, Q_COLOR_ESCAPE, color, message));
;741:}
LABELV $329
endproc G_SayTo 24 24
export G_Say
proc G_Say 320 28
line 743
;742:
;743:void G_Say( gentity_t *ent, gentity_t *target, int mode, const char *chatText ) {
line 752
;744:	int			j;
;745:	gentity_t	*other;
;746:	int			color;
;747:	char		name[64];
;748:	// don't let text be too long for malicious reasons
;749:	char		text[MAX_SAY_TEXT];
;750:	char		location[64];
;751:
;752:	if ( g_gametype.integer < GT_TEAM && mode == SAY_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
GEI4 $348
ADDRFP4 8
INDIRI4
CNSTI4 1
NEI4 $348
line 753
;753:		mode = SAY_ALL;
ADDRFP4 8
CNSTI4 0
ASGNI4
line 754
;754:	}
LABELV $348
line 756
;755:
;756:	switch ( mode ) {
ADDRLP4 292
ADDRFP4 8
INDIRI4
ASGNI4
ADDRLP4 292
INDIRI4
CNSTI4 0
EQI4 $353
ADDRLP4 292
INDIRI4
CNSTI4 1
EQI4 $356
ADDRLP4 292
INDIRI4
CNSTI4 2
EQI4 $362
ADDRGP4 $351
JUMPV
LABELV $351
LABELV $353
line 759
;757:	default:
;758:	case SAY_ALL:
;759:		G_LogPrintf( "say: %s: %s\n", ent->client->pers.netname, chatText );
ADDRGP4 $354
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 760
;760:		Com_sprintf (name, sizeof(name), "%s%c%c: ", ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE );
ADDRLP4 158
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $355
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 94
ARGI4
CNSTI4 55
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 761
;761:		color = COLOR_GREEN;
ADDRLP4 224
CNSTI4 50
ASGNI4
line 762
;762:		break;
ADDRGP4 $352
JUMPV
LABELV $356
line 764
;763:	case SAY_TEAM:
;764:		G_LogPrintf( "sayteam: %s: %s\n", ent->client->pers.netname, chatText );
ADDRGP4 $357
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 765
;765:		if (Team_GetLocationMsg(ent, location, sizeof(location)))
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 228
ARGP4
CNSTI4 64
ARGI4
ADDRLP4 296
ADDRGP4 Team_GetLocationMsg
CALLI4
ASGNI4
ADDRLP4 296
INDIRI4
CNSTI4 0
EQI4 $358
line 766
;766:			Com_sprintf (name, sizeof(name), "(%s%c%c) (%s): ", 
ADDRLP4 158
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $360
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 94
ARGI4
CNSTI4 55
ARGI4
ADDRLP4 228
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
ADDRGP4 $359
JUMPV
LABELV $358
line 769
;767:				ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE, location);
;768:		else
;769:			Com_sprintf (name, sizeof(name), "(%s%c%c): ", 
ADDRLP4 158
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $361
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 94
ARGI4
CNSTI4 55
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
LABELV $359
line 771
;770:				ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE );
;771:		color = COLOR_CYAN;
ADDRLP4 224
CNSTI4 53
ASGNI4
line 772
;772:		break;
ADDRGP4 $352
JUMPV
LABELV $362
line 774
;773:	case SAY_TELL:
;774:		if (target && g_gametype.integer >= GT_TEAM &&
ADDRLP4 300
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 300
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $363
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
LTI4 $363
ADDRLP4 304
CNSTI4 504
ASGNI4
ADDRLP4 308
CNSTI4 592
ASGNI4
ADDRLP4 312
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 300
INDIRP4
ADDRLP4 304
INDIRI4
ADDP4
INDIRP4
ADDRLP4 308
INDIRI4
ADDP4
INDIRI4
ADDRLP4 312
INDIRP4
ADDRLP4 304
INDIRI4
ADDP4
INDIRP4
ADDRLP4 308
INDIRI4
ADDP4
INDIRI4
NEI4 $363
ADDRLP4 312
INDIRP4
ARGP4
ADDRLP4 228
ARGP4
CNSTI4 64
ARGI4
ADDRLP4 316
ADDRGP4 Team_GetLocationMsg
CALLI4
ASGNI4
ADDRLP4 316
INDIRI4
CNSTI4 0
EQI4 $363
line 777
;775:			target->client->sess.sessionTeam == ent->client->sess.sessionTeam &&
;776:			Team_GetLocationMsg(ent, location, sizeof(location)))
;777:			Com_sprintf (name, sizeof(name), "[%s%c%c] (%s): ", ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE, location );
ADDRLP4 158
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $366
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 94
ARGI4
CNSTI4 55
ARGI4
ADDRLP4 228
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
ADDRGP4 $364
JUMPV
LABELV $363
line 779
;778:		else
;779:			Com_sprintf (name, sizeof(name), "[%s%c%c]: ", ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE );
ADDRLP4 158
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $367
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 94
ARGI4
CNSTI4 55
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
LABELV $364
line 780
;780:		color = COLOR_MAGENTA;
ADDRLP4 224
CNSTI4 54
ASGNI4
line 781
;781:		break;
LABELV $352
line 784
;782:	}
;783:
;784:	Q_strncpyz( text, chatText, sizeof(text) );
ADDRLP4 8
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
CNSTI4 150
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 786
;785:
;786:	if ( target ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $368
line 787
;787:		G_SayTo( ent, target, mode, color, name, text );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 224
INDIRI4
ARGI4
ADDRLP4 158
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 G_SayTo
CALLV
pop
line 788
;788:		return;
ADDRGP4 $347
JUMPV
LABELV $368
line 792
;789:	}
;790:
;791:	// echo the text to the console
;792:	if ( g_dedicated.integer ) {
ADDRGP4 g_dedicated+12
INDIRI4
CNSTI4 0
EQI4 $370
line 793
;793:		G_Printf( "%s%s\n", name, text);
ADDRGP4 $373
ARGP4
ADDRLP4 158
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 794
;794:	}
LABELV $370
line 797
;795:
;796:	// send it to all the apropriate clients
;797:	for (j = 0; j < level.maxclients; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $377
JUMPV
LABELV $374
line 798
;798:		other = &g_entities[j];
ADDRLP4 4
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 799
;799:		G_SayTo( ent, other, mode, color, name, text );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRLP4 224
INDIRI4
ARGI4
ADDRLP4 158
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 G_SayTo
CALLV
pop
line 800
;800:	}
LABELV $375
line 797
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $377
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $374
line 801
;801:}
LABELV $347
endproc G_Say 320 28
proc Cmd_Say_f 12 16
line 809
;802:
;803:
;804:/*
;805:==================
;806:Cmd_Say_f
;807:==================
;808:*/
;809:static void Cmd_Say_f( gentity_t *ent, int mode, qboolean arg0 ) {
line 812
;810:	char		*p;
;811:
;812:	if ( trap_Argc () < 2 && !arg0 ) {
ADDRLP4 4
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 2
GEI4 $380
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $380
line 813
;813:		return;
ADDRGP4 $379
JUMPV
LABELV $380
line 816
;814:	}
;815:
;816:	if (arg0)
ADDRFP4 8
INDIRI4
CNSTI4 0
EQI4 $382
line 817
;817:	{
line 818
;818:		p = ConcatArgs( 0 );
CNSTI4 0
ARGI4
ADDRLP4 8
ADDRGP4 ConcatArgs
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 819
;819:	}
ADDRGP4 $383
JUMPV
LABELV $382
line 821
;820:	else
;821:	{
line 822
;822:		p = ConcatArgs( 1 );
CNSTI4 1
ARGI4
ADDRLP4 8
ADDRGP4 ConcatArgs
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 823
;823:	}
LABELV $383
line 825
;824:
;825:	G_Say( ent, NULL, mode, p );
ADDRFP4 0
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_Say
CALLV
pop
line 826
;826:}
LABELV $379
endproc Cmd_Say_f 12 16
proc Cmd_Tell_f 1072 16
line 833
;827:
;828:/*
;829:==================
;830:Cmd_Tell_f
;831:==================
;832:*/
;833:static void Cmd_Tell_f( gentity_t *ent ) {
line 839
;834:	int			targetNum;
;835:	gentity_t	*target;
;836:	char		*p;
;837:	char		arg[MAX_TOKEN_CHARS];
;838:
;839:	if ( trap_Argc () < 2 ) {
ADDRLP4 1036
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 1036
INDIRI4
CNSTI4 2
GEI4 $385
line 840
;840:		return;
ADDRGP4 $384
JUMPV
LABELV $385
line 843
;841:	}
;842:
;843:	trap_Argv( 1, arg, sizeof( arg ) );
CNSTI4 1
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 844
;844:	targetNum = atoi( arg );
ADDRLP4 12
ARGP4
ADDRLP4 1040
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 1040
INDIRI4
ASGNI4
line 845
;845:	if ( targetNum < 0 || targetNum >= level.maxclients ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
LTI4 $390
ADDRLP4 4
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $387
LABELV $390
line 846
;846:		return;
ADDRGP4 $384
JUMPV
LABELV $387
line 849
;847:	}
;848:
;849:	target = &g_entities[targetNum];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 850
;850:	if ( !target || !target->inuse || !target->client ) {
ADDRLP4 1052
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 1052
INDIRU4
EQU4 $394
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $394
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 1052
INDIRU4
NEU4 $391
LABELV $394
line 851
;851:		return;
ADDRGP4 $384
JUMPV
LABELV $391
line 854
;852:	}
;853:
;854:	p = ConcatArgs( 2 );
CNSTI4 2
ARGI4
ADDRLP4 1056
ADDRGP4 ConcatArgs
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 1056
INDIRP4
ASGNP4
line 856
;855:
;856:	G_LogPrintf( "tell: %s to %s: %s\n", ent->client->pers.netname, target->client->pers.netname, p );
ADDRGP4 $395
ARGP4
ADDRLP4 1060
CNSTI4 504
ASGNI4
ADDRLP4 1064
CNSTI4 484
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 1060
INDIRI4
ADDP4
INDIRP4
ADDRLP4 1064
INDIRI4
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
ADDRLP4 1060
INDIRI4
ADDP4
INDIRP4
ADDRLP4 1064
INDIRI4
ADDP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 857
;857:	G_Say( ent, target, SAY_TELL, p );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 G_Say
CALLV
pop
line 858
;858:	G_Say( ent, ent, SAY_TELL, p );
ADDRLP4 1068
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1068
INDIRP4
ARGP4
ADDRLP4 1068
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 G_Say
CALLV
pop
line 859
;859:}
LABELV $384
endproc Cmd_Tell_f 1072 16
data
align 4
LABELV gc_orders
address $396
address $397
address $398
address $399
address $400
address $401
address $402
export Cmd_GameCommand_f
code
proc Cmd_GameCommand_f 1060 16
line 872
;860:
;861:
;862:static char	*gc_orders[] = {
;863:	"hold your position",
;864:	"hold this position",
;865:	"come here",
;866:	"cover me",
;867:	"guard location",
;868:	"search and destroy",
;869:	"report"
;870:};
;871:
;872:void Cmd_GameCommand_f( gentity_t *ent ) {
line 877
;873:	int		player;
;874:	int		order;
;875:	char	str[MAX_TOKEN_CHARS];
;876:
;877:	trap_Argv( 1, str, sizeof( str ) );
CNSTI4 1
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 878
;878:	player = atoi( str );
ADDRLP4 0
ARGP4
ADDRLP4 1032
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1028
ADDRLP4 1032
INDIRI4
ASGNI4
line 879
;879:	trap_Argv( 2, str, sizeof( str ) );
CNSTI4 2
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 880
;880:	order = atoi( str );
ADDRLP4 0
ARGP4
ADDRLP4 1036
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1024
ADDRLP4 1036
INDIRI4
ASGNI4
line 882
;881:
;882:	if ( player < 0 || player >= MAX_CLIENTS ) {
ADDRLP4 1028
INDIRI4
CNSTI4 0
LTI4 $406
ADDRLP4 1028
INDIRI4
CNSTI4 128
LTI4 $404
LABELV $406
line 883
;883:		return;
ADDRGP4 $403
JUMPV
LABELV $404
line 885
;884:	}
;885:	if ( order < 0 || order > sizeof(gc_orders)/sizeof(char *) ) {
ADDRLP4 1024
INDIRI4
CNSTI4 0
LTI4 $409
ADDRLP4 1024
INDIRI4
CVIU4 4
CNSTU4 7
LEU4 $407
LABELV $409
line 886
;886:		return;
ADDRGP4 $403
JUMPV
LABELV $407
line 888
;887:	}
;888:	G_Say( ent, &g_entities[player], SAY_TELL, gc_orders[order] );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 792
ADDRLP4 1028
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRLP4 1048
CNSTI4 2
ASGNI4
ADDRLP4 1048
INDIRI4
ARGI4
ADDRLP4 1024
INDIRI4
ADDRLP4 1048
INDIRI4
LSHI4
ADDRGP4 gc_orders
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_Say
CALLV
pop
line 889
;889:	G_Say( ent, ent, SAY_TELL, gc_orders[order] );
ADDRLP4 1052
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1052
INDIRP4
ARGP4
ADDRLP4 1052
INDIRP4
ARGP4
ADDRLP4 1056
CNSTI4 2
ASGNI4
ADDRLP4 1056
INDIRI4
ARGI4
ADDRLP4 1024
INDIRI4
ADDRLP4 1056
INDIRI4
LSHI4
ADDRGP4 gc_orders
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_Say
CALLV
pop
line 890
;890:}
LABELV $403
endproc Cmd_GameCommand_f 1060 16
export Cmd_Where_f
proc Cmd_Where_f 8 8
line 897
;891:
;892:/*
;893:==================
;894:Cmd_Where_f
;895:==================
;896:*/
;897:void Cmd_Where_f( gentity_t *ent ) {
line 898
;898:	trap_SendServerCommand( ent-g_entities, va("print \"%s\n\"", vtos( ent->s.origin ) ) );
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 0
ADDRGP4 vtos
CALLP4
ASGNP4
ADDRGP4 $411
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 899
;899:}
LABELV $410
endproc Cmd_Where_f 8 8
export Cmd_CallVote_f
proc Cmd_CallVote_f 1568 24
line 907
;900:
;901:
;902:/*
;903:==================
;904:Cmd_CallVote_f
;905:==================
;906:*/
;907:void Cmd_CallVote_f( gentity_t *ent ) {
line 912
;908:	int		i;
;909:	char	arg1[MAX_STRING_TOKENS];
;910:	char	arg2[MAX_STRING_TOKENS];
;911:
;912:	if ( !g_allowVote.integer ) {
ADDRGP4 g_allowVote+12
INDIRI4
CNSTI4 0
NEI4 $413
line 913
;913:		trap_SendServerCommand( ent-g_entities, "print \"Voting not allowed here.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $416
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 914
;914:		return;
ADDRGP4 $412
JUMPV
LABELV $413
line 917
;915:	}
;916:
;917:	if ( level.voteTime ) {
ADDRGP4 level+1636
INDIRI4
CNSTI4 0
EQI4 $417
line 918
;918:		trap_SendServerCommand( ent-g_entities, "print \"A vote is already in progress.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $420
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 919
;919:		return;
ADDRGP4 $412
JUMPV
LABELV $417
line 921
;920:	}
;921:	if ( ent->client->pers.voteCount >= MAX_VOTE_COUNT ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
CNSTI4 3
LTI4 $421
line 922
;922:		trap_SendServerCommand( ent-g_entities, "print \"You have called the maximum number of votes.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $423
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 923
;923:		return;
ADDRGP4 $412
JUMPV
LABELV $421
line 927
;924:	}
;925:
;926:	// make sure it is a valid command to vote on
;927:	trap_Argv( 1, arg1, sizeof( arg1 ) );
CNSTI4 1
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 928
;928:	trap_Argv( 2, arg2, sizeof( arg2 ) );
CNSTI4 2
ARGI4
ADDRLP4 260
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 930
;929:
;930:	if ( !Q_stricmp( arg1, "map_restart" ) ) {
ADDRLP4 4
ARGP4
ADDRGP4 $426
ARGP4
ADDRLP4 516
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 516
INDIRI4
CNSTI4 0
NEI4 $424
line 931
;931:	} else if ( !Q_stricmp( arg1, "nextmap" ) ) {
ADDRGP4 $425
JUMPV
LABELV $424
ADDRLP4 4
ARGP4
ADDRGP4 $429
ARGP4
ADDRLP4 520
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 520
INDIRI4
CNSTI4 0
NEI4 $427
line 932
;932:	} else if ( !Q_stricmp( arg1, "map" ) ) {
ADDRGP4 $428
JUMPV
LABELV $427
ADDRLP4 4
ARGP4
ADDRGP4 $432
ARGP4
ADDRLP4 524
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 524
INDIRI4
CNSTI4 0
NEI4 $430
line 933
;933:	} else if ( !Q_stricmp( arg1, "g_gametype" ) ) {
ADDRGP4 $431
JUMPV
LABELV $430
ADDRLP4 4
ARGP4
ADDRGP4 $435
ARGP4
ADDRLP4 528
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 528
INDIRI4
CNSTI4 0
NEI4 $433
line 934
;934:	} else if ( !Q_stricmp( arg1, "kick" ) ) {
ADDRGP4 $434
JUMPV
LABELV $433
ADDRLP4 4
ARGP4
ADDRGP4 $438
ARGP4
ADDRLP4 532
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 532
INDIRI4
CNSTI4 0
NEI4 $436
line 935
;935:	} else if ( !Q_stricmp( arg1, "g_doWarmup" ) ) {
ADDRGP4 $437
JUMPV
LABELV $436
ADDRLP4 4
ARGP4
ADDRGP4 $441
ARGP4
ADDRLP4 536
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 536
INDIRI4
CNSTI4 0
NEI4 $439
line 936
;936:	} else {
ADDRGP4 $440
JUMPV
LABELV $439
line 937
;937:		trap_SendServerCommand( ent-g_entities, "print \"Invalid vote string.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $442
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 938
;938:		trap_SendServerCommand( ent-g_entities, "print \"Vote commands are: map_restart, nextmap, map <mapname>, g_gametype <n> and kick <player>.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $443
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 939
;939:		return;
ADDRGP4 $412
JUMPV
LABELV $440
LABELV $437
LABELV $434
LABELV $431
LABELV $428
LABELV $425
line 942
;940:	}
;941:
;942:	if ( !Q_stricmp( arg1, "map" ) ) {
ADDRLP4 4
ARGP4
ADDRGP4 $432
ARGP4
ADDRLP4 540
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 540
INDIRI4
CNSTI4 0
NEI4 $444
line 947
;943:		// special case for map changes, we want to reset the nextmap setting
;944:		// this allows a player to change maps, but not upset the map rotation
;945:		char	s[MAX_STRING_CHARS];
;946:
;947:		trap_Cvar_VariableStringBuffer( "nextmap", s, sizeof(s) );
ADDRGP4 $429
ARGP4
ADDRLP4 544
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 948
;948:		if (*s) {
ADDRLP4 544
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $446
line 949
;949:			Com_sprintf( level.voteString, sizeof( level.voteString ), "%s %s; set nextmap \"%s\"", arg1, arg2, s );
ADDRGP4 level+612
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $450
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 260
ARGP4
ADDRLP4 544
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 950
;950:		} else {
ADDRGP4 $445
JUMPV
LABELV $446
line 951
;951:			Com_sprintf( level.voteString, sizeof( level.voteString ), "%s %s", arg1, arg2 );
ADDRGP4 level+612
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $453
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 260
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 952
;952:		}
line 954
;953:
;954:	} else {
ADDRGP4 $445
JUMPV
LABELV $444
line 955
;955:		Com_sprintf( level.voteString, sizeof( level.voteString ), "%s %s", arg1, arg2 );
ADDRGP4 level+612
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $453
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 260
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 956
;956:	}
LABELV $445
line 958
;957:
;958:	trap_SendServerCommand( -1, va("print \"%s called a vote.\n\"", ent->client->pers.netname ) );
ADDRGP4 $456
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 544
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 544
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 961
;959:
;960:	// start the voting, the caller autoamtically votes yes
;961:	level.voteTime = level.time;
ADDRGP4 level+1636
ADDRGP4 level+32
INDIRI4
ASGNI4
line 962
;962:	level.voteYes = 1;
ADDRGP4 level+1640
CNSTI4 1
ASGNI4
line 963
;963:	level.voteNo = 0;
ADDRGP4 level+1644
CNSTI4 0
ASGNI4
line 965
;964:
;965:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $464
JUMPV
LABELV $461
line 966
;966:		level.clients[i].ps.eFlags &= ~EF_VOTED;
ADDRLP4 548
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 548
INDIRP4
ADDRLP4 548
INDIRP4
INDIRI4
CNSTI4 -16385
BANDI4
ASGNI4
line 967
;967:	}
LABELV $462
line 965
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $464
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $461
line 968
;968:	ent->client->ps.eFlags |= EF_VOTED;
ADDRLP4 548
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 548
INDIRP4
ADDRLP4 548
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
line 970
;969:
;970:	trap_SetConfigstring( CS_VOTE_TIME, va("%i", level.voteTime ) );
ADDRGP4 $466
ARGP4
ADDRGP4 level+1636
INDIRI4
ARGI4
ADDRLP4 552
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 8
ARGI4
ADDRLP4 552
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 971
;971:	trap_SetConfigstring( CS_VOTE_STRING, level.voteString );	
CNSTI4 9
ARGI4
ADDRGP4 level+612
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 972
;972:	trap_SetConfigstring( CS_VOTE_YES, va("%i", level.voteYes ) );
ADDRGP4 $466
ARGP4
ADDRGP4 level+1640
INDIRI4
ARGI4
ADDRLP4 556
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 10
ARGI4
ADDRLP4 556
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 973
;973:	trap_SetConfigstring( CS_VOTE_NO, va("%i", level.voteNo ) );	
ADDRGP4 $466
ARGP4
ADDRGP4 level+1644
INDIRI4
ARGI4
ADDRLP4 560
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 11
ARGI4
ADDRLP4 560
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 974
;974:}
LABELV $412
endproc Cmd_CallVote_f 1568 24
export Cmd_Vote_f
proc Cmd_Vote_f 76 12
line 981
;975:
;976:/*
;977:==================
;978:Cmd_Vote_f
;979:==================
;980:*/
;981:void Cmd_Vote_f( gentity_t *ent ) {
line 984
;982:	char		msg[64];
;983:
;984:	if ( !level.voteTime ) {
ADDRGP4 level+1636
INDIRI4
CNSTI4 0
NEI4 $472
line 985
;985:		trap_SendServerCommand( ent-g_entities, "print \"No vote in progress.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $475
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 986
;986:		return;
ADDRGP4 $471
JUMPV
LABELV $472
line 988
;987:	}
;988:	if ( ent->client->ps.eFlags & EF_VOTED ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 16384
BANDI4
CNSTI4 0
EQI4 $476
line 989
;989:		trap_SendServerCommand( ent-g_entities, "print \"Vote already cast.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $478
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 990
;990:		return;
ADDRGP4 $471
JUMPV
LABELV $476
line 993
;991:	}
;992:
;993:	trap_SendServerCommand( ent-g_entities, "print \"Vote cast.\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 $479
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 995
;994:
;995:	ent->client->ps.eFlags |= EF_VOTED;
ADDRLP4 64
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
line 997
;996:
;997:	trap_Argv( 1, msg, sizeof( msg ) );
CNSTI4 1
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 999
;998:
;999:	if ( msg[0] == 'y' || msg[1] == 'Y' || msg[1] == '1' ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 121
EQI4 $485
ADDRLP4 0+1
INDIRI1
CVII4 1
CNSTI4 89
EQI4 $485
ADDRLP4 0+1
INDIRI1
CVII4 1
CNSTI4 49
NEI4 $480
LABELV $485
line 1000
;1000:		level.voteYes++;
ADDRLP4 68
ADDRGP4 level+1640
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1001
;1001:		trap_SetConfigstring( CS_VOTE_YES, va("%i", level.voteYes ) );
ADDRGP4 $466
ARGP4
ADDRGP4 level+1640
INDIRI4
ARGI4
ADDRLP4 72
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 10
ARGI4
ADDRLP4 72
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 1002
;1002:	} else {
ADDRGP4 $481
JUMPV
LABELV $480
line 1003
;1003:		level.voteNo++;
ADDRLP4 68
ADDRGP4 level+1644
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1004
;1004:		trap_SetConfigstring( CS_VOTE_NO, va("%i", level.voteNo ) );	
ADDRGP4 $466
ARGP4
ADDRGP4 level+1644
INDIRI4
ARGI4
ADDRLP4 72
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 11
ARGI4
ADDRLP4 72
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 1005
;1005:	}
LABELV $481
line 1009
;1006:
;1007:	// a majority will be determined in G_CheckVote, which will also account
;1008:	// for players entering or leaving
;1009:}
LABELV $471
endproc Cmd_Vote_f 76 12
export Cmd_SetViewpos_f
proc Cmd_SetViewpos_f 1064 12
line 1017
;1010:
;1011:
;1012:/*
;1013:=================
;1014:Cmd_SetViewpos_f
;1015:=================
;1016:*/
;1017:void Cmd_SetViewpos_f( gentity_t *ent ) {
line 1022
;1018:	vec3_t		origin, angles;
;1019:	char		buffer[MAX_TOKEN_CHARS];
;1020:	int			i;
;1021:
;1022:	if ( !g_cheats.integer ) {
ADDRGP4 g_cheats+12
INDIRI4
CNSTI4 0
NEI4 $491
line 1023
;1023:		trap_SendServerCommand( ent-g_entities, va("print \"Cheats are not enabled on this server.\n\""));
ADDRGP4 $77
ARGP4
ADDRLP4 1052
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 1052
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1024
;1024:		return;
ADDRGP4 $490
JUMPV
LABELV $491
line 1026
;1025:	}
;1026:	if ( trap_Argc() != 5 ) {
ADDRLP4 1052
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 5
EQI4 $494
line 1027
;1027:		trap_SendServerCommand( ent-g_entities, va("print \"usage: setviewpos x y z yaw\n\""));
ADDRGP4 $496
ARGP4
ADDRLP4 1056
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRLP4 1056
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1028
;1028:		return;
ADDRGP4 $490
JUMPV
LABELV $494
line 1031
;1029:	}
;1030:
;1031:	VectorClear( angles );
ADDRLP4 1056
CNSTF4 0
ASGNF4
ADDRLP4 1040+8
ADDRLP4 1056
INDIRF4
ASGNF4
ADDRLP4 1040+4
ADDRLP4 1056
INDIRF4
ASGNF4
ADDRLP4 1040
ADDRLP4 1056
INDIRF4
ASGNF4
line 1032
;1032:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $499
line 1033
;1033:		trap_Argv( i + 1, buffer, sizeof( buffer ) );
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 1034
;1034:		origin[i] = atof( buffer );
ADDRLP4 4
ARGP4
ADDRLP4 1060
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1028
ADDP4
ADDRLP4 1060
INDIRF4
ASGNF4
line 1035
;1035:	}
LABELV $500
line 1032
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $499
line 1037
;1036:
;1037:	trap_Argv( 4, buffer, sizeof( buffer ) );
CNSTI4 4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 1038
;1038:	angles[YAW] = atof( buffer );
ADDRLP4 4
ARGP4
ADDRLP4 1060
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 1040+4
ADDRLP4 1060
INDIRF4
ASGNF4
line 1040
;1039:
;1040:	TeleportPlayer( ent, origin, angles );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1028
ARGP4
ADDRLP4 1040
ARGP4
ADDRGP4 TeleportPlayer
CALLV
pop
line 1041
;1041:}
LABELV $490
endproc Cmd_SetViewpos_f 1064 12
export ClientCommand
proc ClientCommand 1112 12
line 1049
;1042:
;1043:
;1044:/*
;1045:=================
;1046:ClientCommand
;1047:=================
;1048:*/
;1049:void ClientCommand( int clientNum ) {
line 1053
;1050:	gentity_t *ent;
;1051:	char	cmd[MAX_TOKEN_CHARS];
;1052:
;1053:	ent = g_entities + clientNum;
ADDRLP4 1024
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1054
;1054:	if ( !ent->client ) {
ADDRLP4 1024
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $505
line 1055
;1055:		return;		// not fully in game yet
ADDRGP4 $504
JUMPV
LABELV $505
line 1059
;1056:	}
;1057:
;1058:
;1059:	trap_Argv( 0, cmd, sizeof( cmd ) );
CNSTI4 0
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 1061
;1060:
;1061:	if (Q_stricmp (cmd, "say") == 0) {
ADDRLP4 0
ARGP4
ADDRGP4 $509
ARGP4
ADDRLP4 1028
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1028
INDIRI4
CNSTI4 0
NEI4 $507
line 1062
;1062:		Cmd_Say_f (ent, SAY_ALL, qfalse);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRLP4 1032
CNSTI4 0
ASGNI4
ADDRLP4 1032
INDIRI4
ARGI4
ADDRLP4 1032
INDIRI4
ARGI4
ADDRGP4 Cmd_Say_f
CALLV
pop
line 1063
;1063:		return;
ADDRGP4 $504
JUMPV
LABELV $507
line 1065
;1064:	}
;1065:	if (Q_stricmp (cmd, "say_team") == 0) {
ADDRLP4 0
ARGP4
ADDRGP4 $512
ARGP4
ADDRLP4 1032
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 0
NEI4 $510
line 1066
;1066:		Cmd_Say_f (ent, SAY_TEAM, qfalse);
ADDRLP4 1024
INDIRP4
ARGP4
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Cmd_Say_f
CALLV
pop
line 1067
;1067:		return;
ADDRGP4 $504
JUMPV
LABELV $510
line 1069
;1068:	}
;1069:	if (Q_stricmp (cmd, "tell") == 0) {
ADDRLP4 0
ARGP4
ADDRGP4 $515
ARGP4
ADDRLP4 1036
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1036
INDIRI4
CNSTI4 0
NEI4 $513
line 1070
;1070:		Cmd_Tell_f ( ent );
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Tell_f
CALLV
pop
line 1071
;1071:		return;
ADDRGP4 $504
JUMPV
LABELV $513
line 1073
;1072:	}
;1073:	if (Q_stricmp (cmd, "score") == 0) {
ADDRLP4 0
ARGP4
ADDRGP4 $217
ARGP4
ADDRLP4 1040
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1040
INDIRI4
CNSTI4 0
NEI4 $516
line 1074
;1074:		Cmd_Score_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Score_f
CALLV
pop
line 1075
;1075:		return;
ADDRGP4 $504
JUMPV
LABELV $516
line 1079
;1076:	}
;1077:
;1078:	// ignore all other commands when at intermission
;1079:	if (level.intermissiontime) {
ADDRGP4 level+4228
INDIRI4
CNSTI4 0
EQI4 $518
line 1080
;1080:		Cmd_Say_f (ent, qfalse, qtrue);
ADDRLP4 1024
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 Cmd_Say_f
CALLV
pop
line 1081
;1081:		return;
ADDRGP4 $504
JUMPV
LABELV $518
line 1084
;1082:	}
;1083:
;1084:	if (Q_stricmp (cmd, "give") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $523
ARGP4
ADDRLP4 1044
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1044
INDIRI4
CNSTI4 0
NEI4 $521
line 1085
;1085:		Cmd_Give_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Give_f
CALLV
pop
LABELV $521
line 1086
;1086:	if (Q_stricmp (cmd, "drop") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $526
ARGP4
ADDRLP4 1048
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1048
INDIRI4
CNSTI4 0
NEI4 $524
line 1087
;1087:		Cmd_Drop_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Drop_f
CALLV
pop
ADDRGP4 $525
JUMPV
LABELV $524
line 1088
;1088:	else if (Q_stricmp (cmd, "god") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $529
ARGP4
ADDRLP4 1052
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 0
NEI4 $527
line 1089
;1089:		Cmd_God_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_God_f
CALLV
pop
ADDRGP4 $528
JUMPV
LABELV $527
line 1090
;1090:	else if (Q_stricmp (cmd, "notarget") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $532
ARGP4
ADDRLP4 1056
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1056
INDIRI4
CNSTI4 0
NEI4 $530
line 1091
;1091:		Cmd_Notarget_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Notarget_f
CALLV
pop
ADDRGP4 $531
JUMPV
LABELV $530
line 1092
;1092:	else if (Q_stricmp (cmd, "noclip") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $535
ARGP4
ADDRLP4 1060
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1060
INDIRI4
CNSTI4 0
NEI4 $533
line 1093
;1093:		Cmd_Noclip_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Noclip_f
CALLV
pop
ADDRGP4 $534
JUMPV
LABELV $533
line 1094
;1094:	else if (Q_stricmp (cmd, "kill") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $538
ARGP4
ADDRLP4 1064
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1064
INDIRI4
CNSTI4 0
NEI4 $536
line 1095
;1095:		Cmd_Kill_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Kill_f
CALLV
pop
ADDRGP4 $537
JUMPV
LABELV $536
line 1096
;1096:	else if (Q_stricmp (cmd, "levelshot") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $541
ARGP4
ADDRLP4 1068
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1068
INDIRI4
CNSTI4 0
NEI4 $539
line 1097
;1097:		Cmd_LevelShot_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_LevelShot_f
CALLV
pop
ADDRGP4 $540
JUMPV
LABELV $539
line 1098
;1098:	else if (Q_stricmp (cmd, "follow") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $544
ARGP4
ADDRLP4 1072
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1072
INDIRI4
CNSTI4 0
NEI4 $542
line 1099
;1099:		Cmd_Follow_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Follow_f
CALLV
pop
ADDRGP4 $543
JUMPV
LABELV $542
line 1100
;1100:	else if (Q_stricmp (cmd, "follownext") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $547
ARGP4
ADDRLP4 1076
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1076
INDIRI4
CNSTI4 0
NEI4 $545
line 1101
;1101:		Cmd_FollowCycle_f (ent, 1);
ADDRLP4 1024
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 Cmd_FollowCycle_f
CALLV
pop
ADDRGP4 $546
JUMPV
LABELV $545
line 1102
;1102:	else if (Q_stricmp (cmd, "followprev") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $550
ARGP4
ADDRLP4 1080
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1080
INDIRI4
CNSTI4 0
NEI4 $548
line 1103
;1103:		Cmd_FollowCycle_f (ent, -1);
ADDRLP4 1024
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRGP4 Cmd_FollowCycle_f
CALLV
pop
ADDRGP4 $549
JUMPV
LABELV $548
line 1104
;1104:	else if (Q_stricmp (cmd, "team") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $553
ARGP4
ADDRLP4 1084
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1084
INDIRI4
CNSTI4 0
NEI4 $551
line 1105
;1105:		Cmd_Team_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Team_f
CALLV
pop
ADDRGP4 $552
JUMPV
LABELV $551
line 1106
;1106:	else if (Q_stricmp (cmd, "where") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $556
ARGP4
ADDRLP4 1088
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1088
INDIRI4
CNSTI4 0
NEI4 $554
line 1107
;1107:		Cmd_Where_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Where_f
CALLV
pop
ADDRGP4 $555
JUMPV
LABELV $554
line 1108
;1108:	else if (Q_stricmp (cmd, "callvote") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $559
ARGP4
ADDRLP4 1092
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1092
INDIRI4
CNSTI4 0
NEI4 $557
line 1109
;1109:		Cmd_CallVote_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_CallVote_f
CALLV
pop
ADDRGP4 $558
JUMPV
LABELV $557
line 1110
;1110:	else if (Q_stricmp (cmd, "vote") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $562
ARGP4
ADDRLP4 1096
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1096
INDIRI4
CNSTI4 0
NEI4 $560
line 1111
;1111:		Cmd_Vote_f (ent);
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_Vote_f
CALLV
pop
ADDRGP4 $561
JUMPV
LABELV $560
line 1112
;1112:	else if (Q_stricmp (cmd, "gc") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $565
ARGP4
ADDRLP4 1100
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1100
INDIRI4
CNSTI4 0
NEI4 $563
line 1113
;1113:		Cmd_GameCommand_f( ent );
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_GameCommand_f
CALLV
pop
ADDRGP4 $564
JUMPV
LABELV $563
line 1114
;1114:	else if (Q_stricmp (cmd, "setviewpos") == 0)
ADDRLP4 0
ARGP4
ADDRGP4 $568
ARGP4
ADDRLP4 1104
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1104
INDIRI4
CNSTI4 0
NEI4 $566
line 1115
;1115:		Cmd_SetViewpos_f( ent );
ADDRLP4 1024
INDIRP4
ARGP4
ADDRGP4 Cmd_SetViewpos_f
CALLV
pop
ADDRGP4 $567
JUMPV
LABELV $566
line 1117
;1116:	else
;1117:		trap_SendServerCommand( clientNum, va("print \"unknown cmd %s\n\"", cmd ) );
ADDRGP4 $569
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 1108
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 1108
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
LABELV $567
LABELV $564
LABELV $561
LABELV $558
LABELV $555
LABELV $552
LABELV $549
LABELV $546
LABELV $543
LABELV $540
LABELV $537
LABELV $534
LABELV $531
LABELV $528
LABELV $525
line 1118
;1118:}
LABELV $504
endproc ClientCommand 1112 12
import TossClientWeapon
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $569
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $568
byte 1 115
byte 1 101
byte 1 116
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 112
byte 1 111
byte 1 115
byte 1 0
align 1
LABELV $565
byte 1 103
byte 1 99
byte 1 0
align 1
LABELV $562
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $559
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $556
byte 1 119
byte 1 104
byte 1 101
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $553
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $550
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 0
align 1
LABELV $547
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 0
align 1
LABELV $544
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 0
align 1
LABELV $541
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $538
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $535
byte 1 110
byte 1 111
byte 1 99
byte 1 108
byte 1 105
byte 1 112
byte 1 0
align 1
LABELV $532
byte 1 110
byte 1 111
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $529
byte 1 103
byte 1 111
byte 1 100
byte 1 0
align 1
LABELV $526
byte 1 100
byte 1 114
byte 1 111
byte 1 112
byte 1 0
align 1
LABELV $523
byte 1 103
byte 1 105
byte 1 118
byte 1 101
byte 1 0
align 1
LABELV $515
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $512
byte 1 115
byte 1 97
byte 1 121
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $509
byte 1 115
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $496
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 117
byte 1 115
byte 1 97
byte 1 103
byte 1 101
byte 1 58
byte 1 32
byte 1 115
byte 1 101
byte 1 116
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 112
byte 1 111
byte 1 115
byte 1 32
byte 1 120
byte 1 32
byte 1 121
byte 1 32
byte 1 122
byte 1 32
byte 1 121
byte 1 97
byte 1 119
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $479
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 86
byte 1 111
byte 1 116
byte 1 101
byte 1 32
byte 1 99
byte 1 97
byte 1 115
byte 1 116
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $478
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 86
byte 1 111
byte 1 116
byte 1 101
byte 1 32
byte 1 97
byte 1 108
byte 1 114
byte 1 101
byte 1 97
byte 1 100
byte 1 121
byte 1 32
byte 1 99
byte 1 97
byte 1 115
byte 1 116
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $475
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 78
byte 1 111
byte 1 32
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 112
byte 1 114
byte 1 111
byte 1 103
byte 1 114
byte 1 101
byte 1 115
byte 1 115
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $466
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $456
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 32
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 97
byte 1 32
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $453
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $450
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 59
byte 1 32
byte 1 115
byte 1 101
byte 1 116
byte 1 32
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 109
byte 1 97
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 0
align 1
LABELV $443
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 86
byte 1 111
byte 1 116
byte 1 101
byte 1 32
byte 1 99
byte 1 111
byte 1 109
byte 1 109
byte 1 97
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 97
byte 1 114
byte 1 101
byte 1 58
byte 1 32
byte 1 109
byte 1 97
byte 1 112
byte 1 95
byte 1 114
byte 1 101
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 44
byte 1 32
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 109
byte 1 97
byte 1 112
byte 1 44
byte 1 32
byte 1 109
byte 1 97
byte 1 112
byte 1 32
byte 1 60
byte 1 109
byte 1 97
byte 1 112
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 62
byte 1 44
byte 1 32
byte 1 103
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 32
byte 1 60
byte 1 110
byte 1 62
byte 1 32
byte 1 97
byte 1 110
byte 1 100
byte 1 32
byte 1 107
byte 1 105
byte 1 99
byte 1 107
byte 1 32
byte 1 60
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 62
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $442
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 73
byte 1 110
byte 1 118
byte 1 97
byte 1 108
byte 1 105
byte 1 100
byte 1 32
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 32
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $441
byte 1 103
byte 1 95
byte 1 100
byte 1 111
byte 1 87
byte 1 97
byte 1 114
byte 1 109
byte 1 117
byte 1 112
byte 1 0
align 1
LABELV $438
byte 1 107
byte 1 105
byte 1 99
byte 1 107
byte 1 0
align 1
LABELV $435
byte 1 103
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 0
align 1
LABELV $432
byte 1 109
byte 1 97
byte 1 112
byte 1 0
align 1
LABELV $429
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 109
byte 1 97
byte 1 112
byte 1 0
align 1
LABELV $426
byte 1 109
byte 1 97
byte 1 112
byte 1 95
byte 1 114
byte 1 101
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $423
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 89
byte 1 111
byte 1 117
byte 1 32
byte 1 104
byte 1 97
byte 1 118
byte 1 101
byte 1 32
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 109
byte 1 97
byte 1 120
byte 1 105
byte 1 109
byte 1 117
byte 1 109
byte 1 32
byte 1 110
byte 1 117
byte 1 109
byte 1 98
byte 1 101
byte 1 114
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 115
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $420
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 65
byte 1 32
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 97
byte 1 108
byte 1 114
byte 1 101
byte 1 97
byte 1 100
byte 1 121
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 112
byte 1 114
byte 1 111
byte 1 103
byte 1 114
byte 1 101
byte 1 115
byte 1 115
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $416
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 86
byte 1 111
byte 1 116
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 97
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 101
byte 1 100
byte 1 32
byte 1 104
byte 1 101
byte 1 114
byte 1 101
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $411
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $402
byte 1 114
byte 1 101
byte 1 112
byte 1 111
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $401
byte 1 115
byte 1 101
byte 1 97
byte 1 114
byte 1 99
byte 1 104
byte 1 32
byte 1 97
byte 1 110
byte 1 100
byte 1 32
byte 1 100
byte 1 101
byte 1 115
byte 1 116
byte 1 114
byte 1 111
byte 1 121
byte 1 0
align 1
LABELV $400
byte 1 103
byte 1 117
byte 1 97
byte 1 114
byte 1 100
byte 1 32
byte 1 108
byte 1 111
byte 1 99
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $399
byte 1 99
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 32
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $398
byte 1 99
byte 1 111
byte 1 109
byte 1 101
byte 1 32
byte 1 104
byte 1 101
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $397
byte 1 104
byte 1 111
byte 1 108
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 105
byte 1 115
byte 1 32
byte 1 112
byte 1 111
byte 1 115
byte 1 105
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $396
byte 1 104
byte 1 111
byte 1 108
byte 1 100
byte 1 32
byte 1 121
byte 1 111
byte 1 117
byte 1 114
byte 1 32
byte 1 112
byte 1 111
byte 1 115
byte 1 105
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $395
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $373
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $367
byte 1 91
byte 1 37
byte 1 115
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 93
byte 1 58
byte 1 32
byte 1 0
align 1
LABELV $366
byte 1 91
byte 1 37
byte 1 115
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 93
byte 1 32
byte 1 40
byte 1 37
byte 1 115
byte 1 41
byte 1 58
byte 1 32
byte 1 0
align 1
LABELV $361
byte 1 40
byte 1 37
byte 1 115
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 41
byte 1 58
byte 1 32
byte 1 0
align 1
LABELV $360
byte 1 40
byte 1 37
byte 1 115
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 41
byte 1 32
byte 1 40
byte 1 37
byte 1 115
byte 1 41
byte 1 58
byte 1 32
byte 1 0
align 1
LABELV $357
byte 1 115
byte 1 97
byte 1 121
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $355
byte 1 37
byte 1 115
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 58
byte 1 32
byte 1 0
align 1
LABELV $354
byte 1 115
byte 1 97
byte 1 121
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $343
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $342
byte 1 116
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $341
byte 1 37
byte 1 115
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 37
byte 1 115
byte 1 34
byte 1 0
align 1
LABELV $315
byte 1 67
byte 1 109
byte 1 100
byte 1 95
byte 1 70
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 67
byte 1 121
byte 1 99
byte 1 108
byte 1 101
byte 1 95
byte 1 102
byte 1 58
byte 1 32
byte 1 98
byte 1 97
byte 1 100
byte 1 32
byte 1 100
byte 1 105
byte 1 114
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $286
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 83
byte 1 112
byte 1 101
byte 1 99
byte 1 116
byte 1 97
byte 1 116
byte 1 111
byte 1 114
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $284
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 70
byte 1 114
byte 1 101
byte 1 101
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $282
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $280
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $252
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 116
byte 1 111
byte 1 111
byte 1 32
byte 1 109
byte 1 97
byte 1 110
byte 1 121
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 115
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $241
byte 1 98
byte 1 0
align 1
LABELV $240
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $236
byte 1 114
byte 1 0
align 1
LABELV $235
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $228
byte 1 115
byte 1 0
align 1
LABELV $227
byte 1 115
byte 1 112
byte 1 101
byte 1 99
byte 1 116
byte 1 97
byte 1 116
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $224
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 50
byte 1 0
align 1
LABELV $221
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 49
byte 1 0
align 1
LABELV $217
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $216
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 98
byte 1 111
byte 1 97
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $212
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 106
byte 1 111
byte 1 105
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 98
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $209
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 106
byte 1 111
byte 1 105
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 115
byte 1 112
byte 1 101
byte 1 99
byte 1 116
byte 1 97
byte 1 116
byte 1 111
byte 1 114
byte 1 115
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $206
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 106
byte 1 111
byte 1 105
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $203
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 106
byte 1 111
byte 1 105
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 114
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $196
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 76
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 83
byte 1 104
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $195
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 77
byte 1 117
byte 1 115
byte 1 116
byte 1 32
byte 1 98
byte 1 101
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 103
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 32
byte 1 48
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $185
byte 1 110
byte 1 111
byte 1 99
byte 1 108
byte 1 105
byte 1 112
byte 1 32
byte 1 79
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $184
byte 1 110
byte 1 111
byte 1 99
byte 1 108
byte 1 105
byte 1 112
byte 1 32
byte 1 79
byte 1 70
byte 1 70
byte 1 10
byte 1 0
align 1
LABELV $178
byte 1 110
byte 1 111
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 79
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $177
byte 1 110
byte 1 111
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 79
byte 1 70
byte 1 70
byte 1 10
byte 1 0
align 1
LABELV $171
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 0
align 1
LABELV $170
byte 1 103
byte 1 111
byte 1 100
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 32
byte 1 79
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $169
byte 1 103
byte 1 111
byte 1 100
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 32
byte 1 79
byte 1 70
byte 1 70
byte 1 10
byte 1 0
align 1
LABELV $154
byte 1 97
byte 1 114
byte 1 109
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $144
byte 1 97
byte 1 109
byte 1 109
byte 1 111
byte 1 0
align 1
LABELV $138
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 0
align 1
LABELV $132
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $129
byte 1 97
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $123
byte 1 78
byte 1 111
byte 1 110
byte 1 101
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 100
byte 1 114
byte 1 111
byte 1 112
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $119
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 85
byte 1 115
byte 1 101
byte 1 114
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 115
byte 1 101
byte 1 114
byte 1 118
byte 1 101
byte 1 114
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $109
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 101
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $106
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 66
byte 1 97
byte 1 100
byte 1 32
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 115
byte 1 108
byte 1 111
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $80
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 89
byte 1 111
byte 1 117
byte 1 32
byte 1 109
byte 1 117
byte 1 115
byte 1 116
byte 1 32
byte 1 98
byte 1 101
byte 1 32
byte 1 97
byte 1 108
byte 1 105
byte 1 118
byte 1 101
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 32
byte 1 116
byte 1 104
byte 1 105
byte 1 115
byte 1 32
byte 1 99
byte 1 111
byte 1 109
byte 1 109
byte 1 97
byte 1 110
byte 1 100
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $77
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 67
byte 1 104
byte 1 101
byte 1 97
byte 1 116
byte 1 115
byte 1 32
byte 1 97
byte 1 114
byte 1 101
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 101
byte 1 110
byte 1 97
byte 1 98
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 116
byte 1 104
byte 1 105
byte 1 115
byte 1 32
byte 1 115
byte 1 101
byte 1 114
byte 1 118
byte 1 101
byte 1 114
byte 1 46
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $67
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $60
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 0
