data
align 4
LABELV playerMins
byte 4 3245342720
byte 4 3245342720
byte 4 3250585600
align 4
LABELV playerMaxs
byte 4 1097859072
byte 4 1097859072
byte 4 1107296256
export SP_info_player_deathmatch
code
proc SP_info_player_deathmatch 20 12
file "..\g_client.c"
line 17
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:
;5:// g_client.c -- client functions that don't happen every frame
;6:
;7:static vec3_t	playerMins = {-15, -15, -24};
;8:static vec3_t	playerMaxs = {15, 15, 32};
;9:
;10:/*QUAKED info_player_deathmatch (1 0 1) (-16 -16 -24) (16 16 32) initial
;11:potential spawning position for deathmatch games.
;12:The first time a player enters the game, they will be at an 'initial' spot.
;13:Targets will be fired when someone spawns in on them.
;14:"nobots" will prevent bots from using this spot.
;15:"nohumans" will prevent non-bots from using this spot.
;16:*/
;17:void SP_info_player_deathmatch( gentity_t *ent ) {
line 20
;18:	int		i;
;19:
;20:	G_SpawnInt( "nobots", "0", &i);
ADDRGP4 $47
ARGP4
ADDRGP4 $48
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 21
;21:	if ( i ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $49
line 22
;22:		ent->flags |= FL_NO_BOTS;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 8192
BORI4
ASGNI4
line 23
;23:	}
LABELV $49
line 24
;24:	G_SpawnInt( "nohumans", "0", &i );
ADDRGP4 $51
ARGP4
ADDRGP4 $48
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 25
;25:	if ( i ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $52
line 26
;26:		ent->flags |= FL_NO_HUMANS;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
line 27
;27:	}
LABELV $52
line 28
;28:	if(g_OneWeaponPerPlayer.integer)
ADDRGP4 g_OneWeaponPerPlayer+12
INDIRI4
CNSTI4 0
EQI4 $54
line 29
;29:	{
line 30
;30:		gentity_t *nent = G_Spawn();
ADDRLP4 8
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 31
;31:		VectorCopy(ent->s.origin, nent->s.origin);
ADDRLP4 12
CNSTI4 92
ASGNI4
ADDRLP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 32
;32:		if(ent->s.number & 1)
ADDRFP4 0
INDIRP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $57
line 33
;33:		{
line 34
;34:			G_SpawnItem(nent, BG_FindItem("Gauntlet"));
ADDRGP4 $59
ARGP4
ADDRLP4 16
ADDRGP4 BG_FindItem
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRGP4 G_SpawnItem
CALLV
pop
line 35
;35:			nent->count = 443556;
ADDRLP4 4
INDIRP4
CNSTI4 740
ADDP4
CNSTI4 443556
ASGNI4
line 36
;36:		}
ADDRGP4 $58
JUMPV
LABELV $57
line 38
;37:		else
;38:			G_SpawnItem(nent, BG_FindItem("Machinegun"));
ADDRGP4 $60
ARGP4
ADDRLP4 16
ADDRGP4 BG_FindItem
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRGP4 G_SpawnItem
CALLV
pop
LABELV $58
line 39
;39:	}
LABELV $54
line 40
;40:}
LABELV $46
endproc SP_info_player_deathmatch 20 12
export SP_info_player_start
proc SP_info_player_start 0 4
line 45
;41:
;42:/*QUAKED info_player_start (1 0 0) (-16 -16 -24) (16 16 32)
;43:equivelant to info_player_deathmatch
;44:*/
;45:void SP_info_player_start(gentity_t *ent) {
line 46
;46:	ent->classname = "info_player_deathmatch";
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $62
ASGNP4
line 47
;47:	SP_info_player_deathmatch( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SP_info_player_deathmatch
CALLV
pop
line 48
;48:}
LABELV $61
endproc SP_info_player_start 0 4
export SP_info_player_intermission
proc SP_info_player_intermission 0 0
line 53
;49:
;50:/*QUAKED info_player_intermission (1 0 1) (-16 -16 -24) (16 16 32)
;51:The intermission will be viewed from this point.  Target an info_notnull for the view direction.
;52:*/
;53:void SP_info_player_intermission( gentity_t *ent ) {
line 55
;54:
;55:}
LABELV $63
endproc SP_info_player_intermission 0 0
export SpotWouldTelefrag
proc SpotWouldTelefrag 4148 16
line 73
;56:
;57:
;58:
;59:/*
;60:=======================================================================
;61:
;62:  SelectSpawnPoint
;63:
;64:=======================================================================
;65:*/
;66:
;67:/*
;68:================
;69:SpotWouldTelefrag
;70:
;71:================
;72:*/
;73:qboolean SpotWouldTelefrag( gentity_t *spot ) {
line 79
;74:	int			i, num;
;75:	int			touch[MAX_GENTITIES];
;76:	gentity_t	*hit;
;77:	vec3_t		mins, maxs;
;78:
;79:	VectorAdd( spot->s.origin, playerMins, mins );
ADDRLP4 4132
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4108
ADDRLP4 4132
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRGP4 playerMins
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4108+4
ADDRLP4 4132
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRGP4 playerMins+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4108+8
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRGP4 playerMins+8
INDIRF4
ADDF4
ASGNF4
line 80
;80:	VectorAdd( spot->s.origin, playerMaxs, maxs );
ADDRLP4 4136
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4120
ADDRLP4 4136
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRGP4 playerMaxs
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4120+4
ADDRLP4 4136
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRGP4 playerMaxs+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4120+8
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRGP4 playerMaxs+8
INDIRF4
ADDF4
ASGNF4
line 81
;81:	num = trap_EntitiesInBox( mins, maxs, touch, MAX_GENTITIES );
ADDRLP4 4108
ARGP4
ADDRLP4 4120
ARGP4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 4140
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 4140
INDIRI4
ASGNI4
line 83
;82:
;83:	for (i=0 ; i<num ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $76
JUMPV
LABELV $73
line 84
;84:		hit = &g_entities[touch[i]];
ADDRLP4 4
CNSTI4 792
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 85
;85:		if ( hit->client && hit->client->ps.stats[STAT_HEALTH] > 0 ) {
ADDRLP4 4144
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 4144
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $77
ADDRLP4 4144
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
LEI4 $77
line 86
;86:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $64
JUMPV
LABELV $77
line 89
;87:		}
;88:
;89:	}
LABELV $74
line 83
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $76
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
LTI4 $73
line 91
;90:
;91:	return qfalse;
CNSTI4 0
RETI4
LABELV $64
endproc SpotWouldTelefrag 4148 16
export SelectNearestDeathmatchSpawnPoint
proc SelectNearestDeathmatchSpawnPoint 40 12
line 102
;92:}
;93:
;94:/*
;95:================
;96:SelectNearestDeathmatchSpawnPoint
;97:
;98:Find the spot that we DON'T want to use
;99:================
;100:*/
;101:#define	MAX_SPAWN_POINTS	128
;102:gentity_t *SelectNearestDeathmatchSpawnPoint( vec3_t from ) {
line 108
;103:	gentity_t	*spot;
;104:	vec3_t		delta;
;105:	float		dist, nearestDist;
;106:	gentity_t	*nearestSpot;
;107:
;108:	nearestDist = 999999;
ADDRLP4 20
CNSTF4 1232348144
ASGNF4
line 109
;109:	nearestSpot = NULL;
ADDRLP4 24
CNSTP4 0
ASGNP4
line 110
;110:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $81
JUMPV
LABELV $80
line 112
;111:
;112:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 114
;113:
;114:		VectorSubtract( spot->s.origin, from, delta );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 115
;115:		dist = VectorLength( delta );
ADDRLP4 4
ARGP4
ADDRLP4 36
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 36
INDIRF4
ASGNF4
line 116
;116:		if ( dist < nearestDist ) {
ADDRLP4 16
INDIRF4
ADDRLP4 20
INDIRF4
GEF4 $85
line 117
;117:			nearestDist = dist;
ADDRLP4 20
ADDRLP4 16
INDIRF4
ASGNF4
line 118
;118:			nearestSpot = spot;
ADDRLP4 24
ADDRLP4 0
INDIRP4
ASGNP4
line 119
;119:		}
LABELV $85
line 120
;120:	}
LABELV $81
line 112
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 $62
ARGP4
ADDRLP4 28
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $80
line 122
;121:
;122:	return nearestSpot;
ADDRLP4 24
INDIRP4
RETP4
LABELV $79
endproc SelectNearestDeathmatchSpawnPoint 40 12
export SelectRandomDeathmatchSpawnPoint
proc SelectRandomDeathmatchSpawnPoint 532 12
line 134
;123:}
;124:
;125:
;126:/*
;127:================
;128:SelectRandomDeathmatchSpawnPoint
;129:
;130:go to a random point that doesn't telefrag
;131:================
;132:*/
;133:#define	MAX_SPAWN_POINTS	128
;134:gentity_t *SelectRandomDeathmatchSpawnPoint( void ) {
line 140
;135:	gentity_t	*spot;
;136:	int			count;
;137:	int			selection;
;138:	gentity_t	*spots[MAX_SPAWN_POINTS];
;139:
;140:	count = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 141
;141:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $89
JUMPV
LABELV $88
line 143
;142:
;143:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 144
;144:		if ( SpotWouldTelefrag( spot ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 524
ADDRGP4 SpotWouldTelefrag
CALLI4
ASGNI4
ADDRLP4 524
INDIRI4
CNSTI4 0
EQI4 $91
line 145
;145:			continue;
ADDRGP4 $89
JUMPV
LABELV $91
line 147
;146:		}
;147:		spots[ count ] = spot;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 148
;148:		count++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 149
;149:	}
LABELV $89
line 143
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 $62
ARGP4
ADDRLP4 524
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 524
INDIRP4
ASGNP4
ADDRLP4 524
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $88
line 151
;150:
;151:	if ( !count ) {	// no spots that won't telefrag
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $93
line 152
;152:		return G_Find( NULL, FOFS(classname), "info_player_deathmatch");
CNSTP4 0
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 $62
ARGP4
ADDRLP4 528
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 528
INDIRP4
RETP4
ADDRGP4 $87
JUMPV
LABELV $93
line 155
;153:	}
;154:
;155:	selection = rand() % count;
ADDRLP4 528
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 520
ADDRLP4 528
INDIRI4
ADDRLP4 4
INDIRI4
MODI4
ASGNI4
line 156
;156:	return spots[ selection ];
ADDRLP4 520
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
RETP4
LABELV $87
endproc SelectRandomDeathmatchSpawnPoint 532 12
export SelectSpawnPoint
proc SelectSpawnPoint 24 4
line 167
;157:}
;158:
;159:
;160:/*
;161:===========
;162:SelectSpawnPoint
;163:
;164:Chooses a player start, deathmatch start, etc
;165:============
;166:*/
;167:gentity_t *SelectSpawnPoint ( vec3_t avoidPoint, vec3_t origin, vec3_t angles ) {
line 171
;168:	gentity_t	*spot;
;169:	gentity_t	*nearestSpot;
;170:
;171:	nearestSpot = SelectNearestDeathmatchSpawnPoint( avoidPoint );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 SelectNearestDeathmatchSpawnPoint
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 173
;172:
;173:	spot = SelectRandomDeathmatchSpawnPoint ( );
ADDRLP4 12
ADDRGP4 SelectRandomDeathmatchSpawnPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRP4
ASGNP4
line 174
;174:	if ( spot == nearestSpot ) {
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRP4
CVPU4 4
NEU4 $96
line 176
;175:		// roll again if it would be real close to point of death
;176:		spot = SelectRandomDeathmatchSpawnPoint ( );
ADDRLP4 16
ADDRGP4 SelectRandomDeathmatchSpawnPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
line 177
;177:		if ( spot == nearestSpot ) {
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRP4
CVPU4 4
NEU4 $98
line 179
;178:			// last try
;179:			spot = SelectRandomDeathmatchSpawnPoint ( );
ADDRLP4 20
ADDRGP4 SelectRandomDeathmatchSpawnPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 20
INDIRP4
ASGNP4
line 180
;180:		}		
LABELV $98
line 181
;181:	}
LABELV $96
line 184
;182:
;183:	// find a single player start spot
;184:	if (!spot) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $100
line 185
;185:		G_Error( "Couldn't find a spawn point" );
ADDRGP4 $102
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 186
;186:	}
LABELV $100
line 188
;187:
;188:	VectorCopy (spot->s.origin, origin);
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 189
;189:	origin[2] += 9;
ADDRLP4 16
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1091567616
ADDF4
ASGNF4
line 190
;190:	VectorCopy (spot->s.angles, angles);
ADDRFP4 8
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 192
;191:
;192:	return spot;
ADDRLP4 0
INDIRP4
RETP4
LABELV $95
endproc SelectSpawnPoint 24 4
export SelectInitialSpawnPoint
proc SelectInitialSpawnPoint 20 12
line 203
;193:}
;194:
;195:/*
;196:===========
;197:SelectInitialSpawnPoint
;198:
;199:Try to find a spawn point marked 'initial', otherwise
;200:use normal spawn selection.
;201:============
;202:*/
;203:gentity_t *SelectInitialSpawnPoint( vec3_t origin, vec3_t angles ) {
line 206
;204:	gentity_t	*spot;
;205:
;206:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $105
JUMPV
LABELV $104
line 207
;207:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 208
;208:		if ( spot->spawnflags & 1 ) {
ADDRLP4 0
INDIRP4
CNSTI4 516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $107
line 209
;209:			break;
ADDRGP4 $106
JUMPV
LABELV $107
line 211
;210:		}
;211:	}
LABELV $105
line 207
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 $62
ARGP4
ADDRLP4 4
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $104
LABELV $106
line 213
;212:
;213:	if ( !spot || SpotWouldTelefrag( spot ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $111
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 SpotWouldTelefrag
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $109
LABELV $111
line 214
;214:		return SelectSpawnPoint( vec3_origin, origin, angles );
ADDRGP4 vec3_origin
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 SelectSpawnPoint
CALLP4
ASGNP4
ADDRLP4 16
INDIRP4
RETP4
ADDRGP4 $103
JUMPV
LABELV $109
line 217
;215:	}
;216:
;217:	VectorCopy (spot->s.origin, origin);
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 218
;218:	origin[2] += 9;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1091567616
ADDF4
ASGNF4
line 219
;219:	VectorCopy (spot->s.angles, angles);
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 221
;220:
;221:	return spot;
ADDRLP4 0
INDIRP4
RETP4
LABELV $103
endproc SelectInitialSpawnPoint 20 12
export SelectSpectatorSpawnPoint
proc SelectSpectatorSpawnPoint 0 0
line 230
;222:}
;223:
;224:/*
;225:===========
;226:SelectSpectatorSpawnPoint
;227:
;228:============
;229:*/
;230:gentity_t *SelectSpectatorSpawnPoint( vec3_t origin, vec3_t angles ) {
line 231
;231:	FindIntermissionPoint();
ADDRGP4 FindIntermissionPoint
CALLV
pop
line 233
;232:
;233:	VectorCopy( level.intermission_origin, origin );
ADDRFP4 0
INDIRP4
ADDRGP4 level+4244
INDIRB
ASGNB 12
line 234
;234:	VectorCopy( level.intermission_angle, angles );
ADDRFP4 4
INDIRP4
ADDRGP4 level+4256
INDIRB
ASGNB 12
line 236
;235:
;236:	return NULL;
CNSTP4 0
RETP4
LABELV $112
endproc SelectSpectatorSpawnPoint 0 0
export InitBodyQue
proc InitBodyQue 12 0
line 252
;237:}
;238:
;239:/*
;240:=======================================================================
;241:
;242:BODYQUE
;243:
;244:=======================================================================
;245:*/
;246:
;247:/*
;248:===============
;249:InitBodyQue
;250:===============
;251:*/
;252:void InitBodyQue (void) {
line 256
;253:	int		i;
;254:	gentity_t	*ent;
;255:
;256:	level.bodyQueIndex = 0;
ADDRGP4 level+4276
CNSTI4 0
ASGNI4
line 257
;257:	for (i=0; i<BODY_QUEUE_SIZE ; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $117
line 258
;258:		ent = G_Spawn();
ADDRLP4 8
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 259
;259:		ent->classname = "bodyque";
ADDRLP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $121
ASGNP4
line 260
;260:		ent->neverFree = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
CNSTI4 1
ASGNI4
line 261
;261:		level.bodyQue[i] = ent;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+4280
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 262
;262:	}
LABELV $118
line 257
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 8
LTI4 $117
line 263
;263:}
LABELV $115
endproc InitBodyQue 12 0
export BodySink
proc BodySink 4 4
line 272
;264:
;265:/*
;266:=============
;267:BodySink
;268:
;269:After sitting around for five seconds, fall into the ground and dissapear
;270:=============
;271:*/
;272:void BodySink( gentity_t *ent ) {
line 273
;273:	if ( level.time - ent->timestamp > 6500 ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
SUBI4
CNSTI4 6500
LEI4 $124
line 275
;274:		// the body ques are never actually freed, they are just unlinked
;275:		trap_UnlinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 276
;276:		ent->physicsObject = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 552
ADDP4
CNSTI4 0
ASGNI4
line 277
;277:		return;	
ADDRGP4 $123
JUMPV
LABELV $124
line 279
;278:	}
;279:	ent->nextthink = level.time + 100;
ADDRFP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 280
;280:	ent->s.pos.trBase[2] -= 1;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRF4
CNSTF4 1065353216
SUBF4
ASGNF4
line 281
;281:}
LABELV $123
endproc BodySink 4 4
export CopyToBodyQue
proc CopyToBodyQue 56 8
line 291
;282:
;283:/*
;284:=============
;285:CopyToBodyQue
;286:
;287:A player is respawning, so make an entity that looks
;288:just like the existing corpse to leave behind.
;289:=============
;290:*/
;291:void CopyToBodyQue( gentity_t *ent ) {
line 295
;292:	gentity_t		*body;
;293:	int			contents;
;294:
;295:	trap_UnlinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 298
;296:
;297:	// if client is in a nodrop area, don't leave the body
;298:	contents = trap_PointContents( ent->s.origin, -1 );
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 8
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 8
INDIRI4
ASGNI4
line 299
;299:	if ( contents & CONTENTS_NODROP ) {
ADDRLP4 4
INDIRI4
CVIU4 4
CNSTU4 2147483648
BANDU4
CNSTU4 0
EQU4 $129
line 300
;300:		return;
ADDRGP4 $128
JUMPV
LABELV $129
line 304
;301:	}
;302:
;303:	// grab a body que and cycle to the next one
;304:	body = level.bodyQue[ level.bodyQueIndex ];
ADDRLP4 0
ADDRGP4 level+4276
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+4280
ADDP4
INDIRP4
ASGNP4
line 305
;305:	level.bodyQueIndex = (level.bodyQueIndex + 1) % BODY_QUEUE_SIZE;
ADDRGP4 level+4276
ADDRGP4 level+4276
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 8
MODI4
ASGNI4
line 307
;306:
;307:	trap_UnlinkEntity (body);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 309
;308:
;309:	body->s = ent->s;
ADDRLP4 0
INDIRP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 204
line 310
;310:	body->s.eFlags = EF_DEAD;		// clear EF_TALK, etc
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 311
;311:	if(ent->client->headhit)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 756
ADDP4
INDIRI4
CNSTI4 0
EQI4 $135
line 312
;312:		body->s.eFlags |= EF_AWARD_IMPRESSIVE;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 32768
BORI4
ASGNI4
LABELV $135
line 322
;313:	/*if(ent->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)
;314:	{
;315:		body->s.eFlags |= EF_AWARD_EXCELLENT;
;316:	}
;317:	else
;318:	{
;319:		body->s.eFlags &= ~EF_AWARD_EXCELLENT;
;320:	}*/
;321:
;322:	body->s.powerups = 0;	// clear powerups
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 0
ASGNI4
line 323
;323:	body->s.loopSound = 0;	// clear lava burning
ADDRLP4 0
INDIRP4
CNSTI4 156
ADDP4
CNSTI4 0
ASGNI4
line 324
;324:	body->s.number = body - g_entities;
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ASGNI4
line 325
;325:	body->timestamp = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 326
;326:	body->physicsObject = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 552
ADDP4
CNSTI4 1
ASGNI4
line 327
;327:	body->physicsBounce = 0;		// don't bounce
ADDRLP4 0
INDIRP4
CNSTI4 556
ADDP4
CNSTF4 0
ASGNF4
line 328
;328:	if ( body->s.groundEntityNum == ENTITYNUM_NONE ) {
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $138
line 329
;329:		body->s.pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 330
;330:		body->s.pos.trTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 331
;331:		VectorCopy( ent->client->ps.velocity, body->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRB
ASGNB 12
line 332
;332:	} else {
ADDRGP4 $139
JUMPV
LABELV $138
line 333
;333:		body->s.pos.trType = TR_STATIONARY;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 334
;334:	}
LABELV $139
line 335
;335:	body->s.event = 0;
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
CNSTI4 0
ASGNI4
line 339
;336:
;337:	// change the animation to the last-frame only, so the sequence
;338:	// doesn't repeat anew for the body
;339:	switch ( body->s.legsAnim & ~ANIM_TOGGLEBIT ) {
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
CNSTI4 -129
BANDI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 0
LTI4 $141
ADDRLP4 20
INDIRI4
CNSTI4 5
GTI4 $141
ADDRLP4 20
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $147
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $147
address $144
address $144
address $145
address $145
address $146
address $146
code
LABELV $144
line 342
;340:	case BOTH_DEATH1:
;341:	case BOTH_DEAD1:
;342:		body->s.torsoAnim = body->s.legsAnim = BOTH_DEAD1;
ADDRLP4 32
CNSTI4 1
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 200
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 343
;343:		break;
ADDRGP4 $142
JUMPV
LABELV $145
line 346
;344:	case BOTH_DEATH2:
;345:	case BOTH_DEAD2:
;346:		body->s.torsoAnim = body->s.legsAnim = BOTH_DEAD2;
ADDRLP4 40
CNSTI4 3
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
ADDRLP4 40
INDIRI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 200
ADDP4
ADDRLP4 40
INDIRI4
ASGNI4
line 347
;347:		break;
ADDRGP4 $142
JUMPV
LABELV $146
LABELV $141
line 351
;348:	case BOTH_DEATH3:
;349:	case BOTH_DEAD3:
;350:	default:
;351:		body->s.torsoAnim = body->s.legsAnim = BOTH_DEAD3;
ADDRLP4 48
CNSTI4 5
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
ADDRLP4 48
INDIRI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 200
ADDP4
ADDRLP4 48
INDIRI4
ASGNI4
line 352
;352:		break;
LABELV $142
line 355
;353:	}
;354:
;355:	body->r.svFlags = ent->r.svFlags;
ADDRLP4 28
CNSTI4 416
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 356
;356:	VectorCopy (ent->r.mins, body->r.mins);
ADDRLP4 32
CNSTI4 424
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 357
;357:	VectorCopy (ent->r.maxs, body->r.maxs);
ADDRLP4 36
CNSTI4 436
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 358
;358:	VectorCopy (ent->r.absmin, body->r.absmin);
ADDRLP4 40
CNSTI4 452
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 359
;359:	VectorCopy (ent->r.absmax, body->r.absmax);
ADDRLP4 44
CNSTI4 464
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 361
;360:
;361:	body->clipmask = CONTENTS_SOLID | CONTENTS_PLAYERCLIP;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 65537
ASGNI4
line 362
;362:	body->r.contents = CONTENTS_CORPSE;
ADDRLP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 67108864
ASGNI4
line 363
;363:	body->r.ownerNum = ent->r.ownerNum;
ADDRLP4 48
CNSTI4 500
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 365
;364:
;365:	body->nextthink = level.time + g_CorpseStayTime.value * 1000;
ADDRLP4 0
INDIRP4
CNSTI4 668
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
CNSTF4 1148846080
ADDRGP4 g_CorpseStayTime+8
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 366
;366:	body->think = BodySink;
ADDRLP4 0
INDIRP4
CNSTI4 672
ADDP4
ADDRGP4 BodySink
ASGNP4
line 368
;367:
;368:	body->die = body_die;
ADDRLP4 0
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 body_die
ASGNP4
line 371
;369:
;370:	// don't take more damage if already gibbed
;371:	if ( ent->health <= GIB_HEALTH )
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 -40
GTI4 $150
line 372
;372:		body->takedamage = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 0
ASGNI4
ADDRGP4 $151
JUMPV
LABELV $150
line 373
;373:	else if(ent->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $152
line 374
;374:		body->takedamage = -1;
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 -1
ASGNI4
ADDRGP4 $153
JUMPV
LABELV $152
line 376
;375:	else
;376:		body->takedamage = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 1
ASGNI4
LABELV $153
LABELV $151
line 380
;377:	
;378:
;379:
;380:	VectorCopy ( body->s.pos.trBase, body->r.currentOrigin );
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 381
;381:	trap_LinkEntity (body);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 382
;382:}
LABELV $128
endproc CopyToBodyQue 56 8
export SetClientViewAngle
proc SetClientViewAngle 16 0
line 393
;383:
;384://======================================================================
;385:
;386:
;387:/*
;388:==================
;389:SetClientViewAngle
;390:
;391:==================
;392:*/
;393:void SetClientViewAngle( gentity_t *ent, vec3_t angle ) {
line 397
;394:	int			i;
;395:
;396:	// set the delta angle
;397:	for (i=0 ; i<3 ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $155
line 400
;398:		int		cmdAngle;
;399:
;400:		cmdAngle = ANGLE2SHORT(angle[i]);
ADDRLP4 4
CNSTF4 1199570944
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 401
;401:		ent->client->ps.delta_angles[i] = cmdAngle - ent->client->pers.cmd.angles[i];
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 8
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 56
ADDP4
ADDP4
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 456
ADDP4
ADDP4
INDIRI4
SUBI4
ASGNI4
line 402
;402:	}
LABELV $156
line 397
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $155
line 403
;403:	VectorCopy( angle, ent->s.angles );
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 404
;404:	VectorCopy (ent->s.angles, ent->client->ps.viewangles);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 152
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 405
;405:}
LABELV $154
endproc SetClientViewAngle 16 0
export respawn
proc respawn 12 8
line 412
;406:
;407:/*
;408:================
;409:respawn
;410:================
;411:*/
;412:void respawn( gentity_t *ent ) {
line 415
;413:	gentity_t	*tent;
;414:
;415:	CopyToBodyQue (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CopyToBodyQue
CALLV
pop
line 416
;416:	ClientSpawn(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ClientSpawn
CALLV
pop
line 419
;417:
;418:	// add a teleportation effect
;419:	tent = G_TempEntity( ent->client->ps.origin, EV_PLAYER_TELEPORT_IN );
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 42
ARGI4
ADDRLP4 4
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 420
;420:	tent->s.clientNum = ent->s.clientNum;
ADDRLP4 8
CNSTI4 168
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 421
;421:}
LABELV $159
endproc respawn 12 8
export TeamCount
proc TeamCount 8 0
line 430
;422:
;423:/*
;424:================
;425:TeamCount
;426:
;427:Returns number of players on a team
;428:================
;429:*/
;430:team_t TeamCount( int ignoreClientNum, int team ) {
line 432
;431:	int		i;
;432:	int		count = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 434
;433:
;434:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $164
JUMPV
LABELV $161
line 435
;435:		if ( i == ignoreClientNum ) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $166
line 436
;436:			continue;
ADDRGP4 $162
JUMPV
LABELV $166
line 438
;437:		}
;438:		if ( level.clients[i].pers.connected == CON_DISCONNECTED ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 0
NEI4 $168
line 439
;439:			continue;
ADDRGP4 $162
JUMPV
LABELV $168
line 441
;440:		}
;441:		if ( level.clients[i].sess.sessionTeam == team ) {
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 592
ADDP4
INDIRI4
ADDRFP4 4
INDIRI4
NEI4 $170
line 442
;442:			count++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 443
;443:		}
LABELV $170
line 444
;444:	}
LABELV $162
line 434
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $164
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $161
line 446
;445:
;446:	return count;
ADDRLP4 4
INDIRI4
RETI4
LABELV $160
endproc TeamCount 8 0
export PickTeam
proc PickTeam 24 8
line 456
;447:}
;448:
;449:
;450:/*
;451:================
;452:PickTeam
;453:
;454:================
;455:*/
;456:team_t PickTeam( int ignoreClientNum ) {
line 459
;457:	int		counts[TEAM_NUM_TEAMS];
;458:
;459:	counts[TEAM_BLUE] = TeamCount( ignoreClientNum, TEAM_BLUE );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 16
ADDRGP4 TeamCount
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRLP4 16
INDIRI4
ASGNI4
line 460
;460:	counts[TEAM_RED] = TeamCount( ignoreClientNum, TEAM_RED );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 20
ADDRGP4 TeamCount
CALLI4
ASGNI4
ADDRLP4 0+4
ADDRLP4 20
INDIRI4
ASGNI4
line 462
;461:
;462:	if ( counts[TEAM_BLUE] > counts[TEAM_RED] ) {
ADDRLP4 0+8
INDIRI4
ADDRLP4 0+4
INDIRI4
LEI4 $175
line 463
;463:		return TEAM_RED;
CNSTI4 1
RETI4
ADDRGP4 $172
JUMPV
LABELV $175
line 465
;464:	}
;465:	if ( counts[TEAM_RED] > counts[TEAM_BLUE] ) {
ADDRLP4 0+4
INDIRI4
ADDRLP4 0+8
INDIRI4
LEI4 $179
line 466
;466:		return TEAM_BLUE;
CNSTI4 2
RETI4
ADDRGP4 $172
JUMPV
LABELV $179
line 469
;467:	}
;468:	// equal team count, so join the team with the lowest score
;469:	if ( level.teamScores[TEAM_BLUE] > level.teamScores[TEAM_RED] ) {
ADDRGP4 level+44+8
INDIRI4
ADDRGP4 level+44+4
INDIRI4
LEI4 $183
line 470
;470:		return TEAM_RED;
CNSTI4 1
RETI4
ADDRGP4 $172
JUMPV
LABELV $183
line 472
;471:	}
;472:	return TEAM_BLUE;
CNSTI4 2
RETI4
LABELV $172
endproc PickTeam 24 8
export ForceClientSkin
proc ForceClientSkin 8 12
line 482
;473:}
;474:
;475:/*
;476:===========
;477:ForceClientSkin
;478:
;479:Forces a client's skin (for teamplay)
;480:===========
;481:*/
;482:void ForceClientSkin( gclient_t *client, char *model, const char *skin ) {
line 485
;483:	char *p;
;484:
;485:	if ((p = strchr(model, '/')) != NULL) {
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 47
ARGI4
ADDRLP4 4
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $190
line 486
;486:		*p = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 487
;487:	}
LABELV $190
line 489
;488:
;489:	Q_strcat(model, MAX_QPATH, "/");
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $192
ARGP4
ADDRGP4 Q_strcat
CALLV
pop
line 490
;490:	Q_strcat(model, MAX_QPATH, skin);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Q_strcat
CALLV
pop
line 491
;491:}
LABELV $189
endproc ForceClientSkin 8 12
proc ClientCleanName 40 12
line 499
;492:
;493:
;494:/*
;495:===========
;496:ClientCheckName
;497:============
;498:*/
;499:static void ClientCleanName( const char *in, char *out, int outSize ) {
line 506
;500:	int		len, colorlessLen;
;501:	char	ch;
;502:	char	*p;
;503:	int		spaces;
;504:
;505:	//save room for trailing null byte
;506:	outSize--;
ADDRFP4 8
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 508
;507:
;508:	len = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 509
;509:	colorlessLen = 0;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 510
;510:	p = out;
ADDRLP4 12
ADDRFP4 4
INDIRP4
ASGNP4
line 511
;511:	*p = 0;
ADDRLP4 12
INDIRP4
CNSTI1 0
ASGNI1
line 512
;512:	spaces = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $195
JUMPV
LABELV $194
line 514
;513:
;514:	while( 1 ) {
line 515
;515:		ch = *in++;
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 20
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 20
INDIRP4
INDIRI1
ASGNI1
line 516
;516:		if( !ch ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $197
line 517
;517:			break;
ADDRGP4 $196
JUMPV
LABELV $197
line 521
;518:		}
;519:
;520:		// don't allow leading spaces
;521:		if( !*p && ch == ' ' ) {
ADDRLP4 12
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $199
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $199
line 522
;522:			continue;
ADDRGP4 $195
JUMPV
LABELV $199
line 526
;523:		}
;524:
;525:		// check colors
;526:		if( ch == Q_COLOR_ESCAPE ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 94
NEI4 $201
line 528
;527:			// solo trailing carat is not a color prefix
;528:			if( !*in ) {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $203
line 529
;529:				break;
ADDRGP4 $196
JUMPV
LABELV $203
line 533
;530:			}
;531:
;532:			// don't allow black in a name, period
;533:			if( ColorIndex(*in) == 0 ) {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
CNSTI4 7
BANDI4
CNSTI4 0
NEI4 $205
line 534
;534:				in++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 535
;535:				continue;
ADDRGP4 $195
JUMPV
LABELV $205
line 539
;536:			}
;537:
;538:			// make sure room in dest for both chars
;539:			if( len > outSize - 2 ) {
ADDRLP4 4
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 2
SUBI4
LEI4 $207
line 540
;540:				break;
ADDRGP4 $196
JUMPV
LABELV $207
line 543
;541:			}
;542:
;543:			*out++ = ch;
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 4
ADDRLP4 24
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 0
INDIRI1
ASGNI1
line 544
;544:			*out++ = *in++;
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
CNSTI4 1
ASGNI4
ADDRFP4 4
ADDRLP4 28
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ASGNP4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 32
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI1
ASGNI1
line 545
;545:			len += 2;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 2
ADDI4
ASGNI4
line 546
;546:			continue;
ADDRGP4 $195
JUMPV
LABELV $201
line 550
;547:		}
;548:
;549:		// don't allow too many consecutive spaces
;550:		if( ch == ' ' ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $209
line 551
;551:			spaces++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 552
;552:			if( spaces > 3 ) {
ADDRLP4 8
INDIRI4
CNSTI4 3
LEI4 $210
line 553
;553:				continue;
ADDRGP4 $195
JUMPV
line 555
;554:			}
;555:		}
LABELV $209
line 556
;556:		else {
line 557
;557:			spaces = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 558
;558:		}
LABELV $210
line 560
;559:
;560:		if( len > outSize - 1 ) {
ADDRLP4 4
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
LEI4 $213
line 561
;561:			break;
ADDRGP4 $196
JUMPV
LABELV $213
line 564
;562:		}
;563:
;564:		*out++ = ch;
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 4
ADDRLP4 24
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 0
INDIRI1
ASGNI1
line 565
;565:		colorlessLen++;
ADDRLP4 16
ADDRLP4 16
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 566
;566:		len++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 567
;567:	}
LABELV $195
line 514
ADDRGP4 $194
JUMPV
LABELV $196
line 568
;568:	*out = 0;
ADDRFP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 571
;569:
;570:	// don't allow empty names
;571:	if( *p == 0 || colorlessLen == 0 ) {
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 12
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 20
INDIRI4
EQI4 $217
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $215
LABELV $217
line 572
;572:		Q_strncpyz( p, "UnnamedPlayer", outSize );
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 $218
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 573
;573:	}
LABELV $215
line 574
;574:}
LABELV $193
endproc ClientCleanName 40 12
export G_PlayerClass
proc G_PlayerClass 68 16
line 578
;575:
;576:
;577:int G_PlayerClass(char *model)
;578:{
line 582
;579:	char test[16], tmodel[32];
;580:	int i, slen;
;581:	
;582:	if(!g_PlayerClasses.integer)
ADDRGP4 g_PlayerClasses+12
INDIRI4
CNSTI4 0
NEI4 $220
line 583
;583:		return -1;
CNSTI4 -1
RETI4
ADDRGP4 $219
JUMPV
LABELV $220
line 584
;584:	test[15] = 0;
ADDRLP4 8+15
CNSTI1 0
ASGNI1
line 585
;585:	tmodel[31] = 0;
ADDRLP4 24+31
CNSTI1 0
ASGNI1
line 586
;586:	for(slen = 0; slen < 15; slen++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $225
line 587
;587:	{
line 588
;588:		if(model[slen] == '/' || model[slen] <= ' ')
ADDRLP4 56
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 47
EQI4 $231
ADDRLP4 56
INDIRI4
CNSTI4 32
GTI4 $229
LABELV $231
line 589
;589:		{
line 590
;590:			test[slen] = 0;
ADDRLP4 0
INDIRI4
ADDRLP4 8
ADDP4
CNSTI1 0
ASGNI1
line 591
;591:			break;
ADDRGP4 $227
JUMPV
LABELV $229
line 593
;592:		}
;593:		test[slen] = toupper(model[slen]);
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 64
ADDRGP4 toupper
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 64
INDIRI4
CVII1 4
ASGNI1
line 595
;594:		
;595:	}
LABELV $226
line 586
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 15
LTI4 $225
LABELV $227
line 596
;596:	for(slen = 0; slen < 31; slen++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $232
line 597
;597:	{
line 598
;598:		if(model[slen] <= ' ')
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
CNSTI4 32
GTI4 $236
line 599
;599:		{
line 600
;600:			tmodel[slen] = 0;
ADDRLP4 0
INDIRI4
ADDRLP4 24
ADDP4
CNSTI1 0
ASGNI1
line 601
;601:			break;
ADDRGP4 $234
JUMPV
LABELV $236
line 603
;602:		}
;603:		tmodel[slen] = toupper(model[slen]);
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 60
ADDRGP4 toupper
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 24
ADDP4
ADDRLP4 60
INDIRI4
CVII1 4
ASGNI1
line 605
;604:		
;605:	}
LABELV $233
line 596
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 31
LTI4 $232
LABELV $234
line 607
;606:	
;607:	for(i = 0; i < p_classes; i++)
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $241
JUMPV
LABELV $238
line 608
;608:	{
line 609
;609:		if(!Q_strncmp(tmodel, p_class[i].name, 32))
ADDRLP4 24
ARGP4
CNSTI4 168
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 p_class
ADDP4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 56
ADDRGP4 Q_strncmp
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
NEI4 $242
line 610
;610:		{ // test specific skins first
line 611
;611:			G_Printf("Model: %s / Class[%d]: %s\n", model, i, p_class[i].name);
ADDRGP4 $244
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 168
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 p_class
ADDP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 612
;612:			return i;
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $219
JUMPV
LABELV $242
line 614
;613:		}
;614:		if(!Q_strncmp(test, p_class[i].name, 16))
ADDRLP4 8
ARGP4
CNSTI4 168
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 p_class
ADDP4
ARGP4
CNSTI4 16
ARGI4
ADDRLP4 60
ADDRGP4 Q_strncmp
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
NEI4 $245
line 615
;615:		{ // then test generic model
line 616
;616:			G_Printf("Model: %s / Class[%d]: %s\n", model, i, p_class[i].name);
ADDRGP4 $244
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 168
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 p_class
ADDP4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 617
;617:			return i;
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $219
JUMPV
LABELV $245
line 619
;618:		}
;619:	}
LABELV $239
line 607
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $241
ADDRLP4 4
INDIRI4
ADDRGP4 p_classes
INDIRI4
LTI4 $238
line 620
;620:	G_Printf("Model: %s / Class[%d]: %s\n", model, i, "DEFAULT");
ADDRGP4 $244
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 $247
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 621
;621:	return -1; // use default
CNSTI4 -1
RETI4
LABELV $219
endproc G_PlayerClass 68 16
export ClientUserinfoChanged
proc ClientUserinfoChanged 2232 36
line 636
;622:}
;623:
;624:
;625:/*
;626:===========
;627:ClientUserInfoChanged
;628:
;629:Called from ClientConnect when the player first connects and
;630:directly by the server system when the player updates a userinfo variable.
;631:
;632:The game can override any of the settings and call trap_SetUserinfo
;633:if desired.
;634:============
;635:*/
;636:void ClientUserinfoChanged( int clientNum ) {
line 646
;637:	int oldclass;
;638:	gentity_t *ent;
;639:	char	*s;
;640:	char	model[MAX_QPATH];
;641:	char	oldname[MAX_STRING_CHARS];
;642:	gclient_t	*client;
;643:	char	*c1;
;644:	char	userinfo[MAX_INFO_STRING];
;645:
;646:	ent = g_entities + clientNum;
ADDRLP4 1096
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 647
;647:	client = ent->client;
ADDRLP4 0
ADDRLP4 1096
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 649
;648:
;649:	trap_GetUserinfo( clientNum, userinfo, sizeof( userinfo ) );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 652
;650:
;651:	// check for malformed or illegal info strings
;652:	if ( !Info_Validate(userinfo) ) {
ADDRLP4 8
ARGP4
ADDRLP4 2132
ADDRGP4 Info_Validate
CALLI4
ASGNI4
ADDRLP4 2132
INDIRI4
CNSTI4 0
NEI4 $249
line 653
;653:		strcpy (userinfo, "\\name\\badinfo");
ADDRLP4 8
ARGP4
ADDRGP4 $251
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 654
;654:	}
LABELV $249
line 657
;655:
;656:	// check for local client
;657:	s = Info_ValueForKey( userinfo, "ip" );
ADDRLP4 8
ARGP4
ADDRGP4 $252
ARGP4
ADDRLP4 2136
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2136
INDIRP4
ASGNP4
line 658
;658:	if ( !strcmp( s, "localhost" ) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 $255
ARGP4
ADDRLP4 2140
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2140
INDIRI4
CNSTI4 0
NEI4 $253
line 659
;659:		client->pers.localClient = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 472
ADDP4
CNSTI4 1
ASGNI4
line 660
;660:	}
LABELV $253
line 663
;661:
;662:	// check the item prediction
;663:	s = Info_ValueForKey( userinfo, "cg_predictItems" );
ADDRLP4 8
ARGP4
ADDRGP4 $256
ARGP4
ADDRLP4 2144
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2144
INDIRP4
ASGNP4
line 664
;664:	if ( !atoi( s ) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 2148
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 2148
INDIRI4
CNSTI4 0
NEI4 $257
line 665
;665:		client->pers.predictItemPickup = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
CNSTI4 0
ASGNI4
line 666
;666:	} else {
ADDRGP4 $258
JUMPV
LABELV $257
line 667
;667:		client->pers.predictItemPickup = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
CNSTI4 1
ASGNI4
line 668
;668:	}
LABELV $258
line 671
;669:
;670:	// check the item prediction
;671:	s = Info_ValueForKey( userinfo, "cl_autoaim" );
ADDRLP4 8
ARGP4
ADDRGP4 $259
ARGP4
ADDRLP4 2152
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2152
INDIRP4
ASGNP4
line 672
;672:	if ( !atoi( s ) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 2156
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 2156
INDIRI4
CNSTI4 0
NEI4 $260
line 673
;673:		client->pers.AutoAim = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
CNSTI4 0
ASGNI4
line 674
;674:	} else {
ADDRGP4 $261
JUMPV
LABELV $260
line 675
;675:		client->pers.AutoAim = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
CNSTI4 1
ASGNI4
line 676
;676:	}
LABELV $261
line 679
;677:
;678:	// set name
;679:	Q_strncpyz ( oldname, client->pers.netname, sizeof( oldname ) );
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 680
;680:	s = Info_ValueForKey (userinfo, "name");
ADDRLP4 8
ARGP4
ADDRGP4 $262
ARGP4
ADDRLP4 2160
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2160
INDIRP4
ASGNP4
line 681
;681:	ClientCleanName( s, client->pers.netname, sizeof(client->pers.netname) );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientCleanName
CALLV
pop
line 683
;682:
;683:	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $263
line 684
;684:		if ( client->sess.spectatorState == SPECTATOR_SCOREBOARD ) {
ADDRLP4 0
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 3
NEI4 $265
line 685
;685:			Q_strncpyz( client->pers.netname, "scoreboard", sizeof(client->pers.netname) );
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRGP4 $267
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 686
;686:		}
LABELV $265
line 687
;687:	}
LABELV $263
line 689
;688:
;689:	if ( client->pers.connected == CON_CONNECTED ) {
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
NEI4 $268
line 690
;690:		if ( strcmp( oldname, client->pers.netname ) ) {
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 2164
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2164
INDIRI4
CNSTI4 0
EQI4 $270
line 691
;691:			trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " renamed to %s\n\"", oldname, 
ADDRGP4 $272
ARGP4
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 2168
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 2168
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 693
;692:				client->pers.netname) );
;693:		}
LABELV $270
line 694
;694:	}
LABELV $268
line 697
;695:
;696:	// set max health
;697:	client->pers.maxHealth = atoi( Info_ValueForKey( userinfo, "handicap" ) );
ADDRLP4 8
ARGP4
ADDRGP4 $273
ARGP4
ADDRLP4 2164
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 2164
INDIRP4
ARGP4
ADDRLP4 2168
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
ADDRLP4 2168
INDIRI4
ASGNI4
line 698
;698:	if ( client->pers.maxHealth < 1 || client->pers.maxHealth > 100 ) {
ADDRLP4 2172
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
ASGNI4
ADDRLP4 2172
INDIRI4
CNSTI4 1
LTI4 $276
ADDRLP4 2172
INDIRI4
CNSTI4 100
LEI4 $274
LABELV $276
line 699
;699:		client->pers.maxHealth = 100;
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
CNSTI4 100
ASGNI4
line 700
;700:	}
LABELV $274
line 704
;701:	
;702:
;703:	// set model
;704:	Q_strncpyz( model, Info_ValueForKey (userinfo, "model"), sizeof( model ) );
ADDRLP4 8
ARGP4
ADDRGP4 $277
ARGP4
ADDRLP4 2176
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1032
ARGP4
ADDRLP4 2176
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 707
;705:
;706:	// team
;707:	switch( client->sess.sessionTeam ) {
ADDRLP4 2180
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
ADDRLP4 2180
INDIRI4
CNSTI4 1
EQI4 $281
ADDRLP4 2180
INDIRI4
CNSTI4 2
EQI4 $283
ADDRGP4 $278
JUMPV
LABELV $281
line 709
;708:	case TEAM_RED:
;709:		ForceClientSkin(client, model, "red");
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 1032
ARGP4
ADDRGP4 $282
ARGP4
ADDRGP4 ForceClientSkin
CALLV
pop
line 710
;710:		break;
ADDRGP4 $279
JUMPV
LABELV $283
line 712
;711:	case TEAM_BLUE:
;712:		ForceClientSkin(client, model, "blue");
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 1032
ARGP4
ADDRGP4 $284
ARGP4
ADDRGP4 ForceClientSkin
CALLV
pop
line 713
;713:		break;
LABELV $278
LABELV $279
line 715
;714:	}
;715:	if ( g_gametype.integer >= GT_TEAM && client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 2188
CNSTI4 3
ASGNI4
ADDRGP4 g_gametype+12
INDIRI4
ADDRLP4 2188
INDIRI4
LTI4 $285
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ADDRLP4 2188
INDIRI4
NEI4 $285
line 717
;716:		// don't ever use a default skin in teamplay, it would just waste memory
;717:		ForceClientSkin(client, model, "red");
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 1032
ARGP4
ADDRGP4 $282
ARGP4
ADDRGP4 ForceClientSkin
CALLV
pop
line 718
;718:	}
LABELV $285
line 720
;719:	
;720:	oldclass = client->pers.playerclass ;
ADDRLP4 2128
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
line 721
;721:	client->pers.playerclass = G_PlayerClass(model);
ADDRLP4 1032
ARGP4
ADDRLP4 2192
ADDRGP4 G_PlayerClass
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
ADDRLP4 2192
INDIRI4
ASGNI4
line 722
;722:	if(client->pers.playerclass >= 0 && client->pers.playerclass < p_classes)
ADDRLP4 2196
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 2196
INDIRI4
CNSTI4 0
LTI4 $288
ADDRLP4 2196
INDIRI4
ADDRGP4 p_classes
INDIRI4
GEI4 $288
line 723
;723:	{
line 724
;724:		client->ps.stats[STAT_MASS] = p_class[client->pers.playerclass].mass;
ADDRLP4 0
INDIRP4
CNSTI4 228
ADDP4
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+72
ADDP4
INDIRI4
ASGNI4
line 725
;725:		client->pers.maxHealth =  p_class[client->pers.playerclass].max_health;
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+68
ADDP4
INDIRI4
ASGNI4
line 726
;726:		if(p_class[client->pers.playerclass].wallclimber)
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+80
ADDP4
INDIRI4
CNSTI4 0
EQI4 $292
line 727
;727:		{
line 729
;728:			//G_AddEvent( ent, EV_CLIMBWALL, 0 );
;729:			client->ps.stats[STAT_EXTENDED_INFO] |= EXT_WALLCLIMBER;
ADDRLP4 2208
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 2208
INDIRP4
ADDRLP4 2208
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 730
;730:		}
ADDRGP4 $293
JUMPV
LABELV $292
line 732
;731:		else
;732:		{
line 734
;733:			//G_AddEvent( ent, EV_ENDCLIMBWALL, 0 );
;734:			client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_WALLCLIMBER;
ADDRLP4 2208
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 2208
INDIRP4
ADDRLP4 2208
INDIRP4
INDIRI4
CNSTI4 -17
BANDI4
ASGNI4
line 735
;735:		}
LABELV $293
line 736
;736:		if(client->pers.playerclass != oldclass && !g_cheats.value)
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ADDRLP4 2128
INDIRI4
EQI4 $289
ADDRGP4 g_cheats+8
INDIRF4
CNSTF4 0
NEF4 $289
line 737
;737:		{
line 738
;738:			if(client->ps.eFlags & EF_DEAD)
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $298
line 739
;739:				CopyToBodyQue(ent);
ADDRLP4 1096
INDIRP4
ARGP4
ADDRGP4 CopyToBodyQue
CALLV
pop
ADDRGP4 $289
JUMPV
LABELV $298
line 741
;740:			else
;741:				G_Damage(ent, ent, ent, NULL, NULL, 40000, DAMAGE_NO_PROTECTION, MOD_TELEFRAG);
ADDRLP4 1096
INDIRP4
ARGP4
ADDRLP4 1096
INDIRP4
ARGP4
ADDRLP4 1096
INDIRP4
ARGP4
ADDRLP4 2212
CNSTP4 0
ASGNP4
ADDRLP4 2212
INDIRP4
ARGP4
ADDRLP4 2212
INDIRP4
ARGP4
CNSTI4 40000
ARGI4
CNSTI4 32
ARGI4
CNSTI4 18
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 742
;742:		}
line 743
;743:		;
line 744
;744:	}
ADDRGP4 $289
JUMPV
LABELV $288
line 745
;745:	else if(g_PlayerClasses.integer == 2) // force classes
ADDRGP4 g_PlayerClasses+12
INDIRI4
CNSTI4 2
NEI4 $300
line 746
;746:	{
line 747
;747:		StopFollowing(ent);
ADDRLP4 1096
INDIRP4
ARGP4
ADDRGP4 StopFollowing
CALLV
pop
line 748
;748:		G_Printf("Server is configured to force player classes.\nThis model has no player class!\n Forcing spectator mode...\n");
ADDRGP4 $303
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 750
;749:
;750:	}
LABELV $300
LABELV $289
line 751
;751:	client->ps.stats[STAT_MAX_HEALTH] = client->pers.maxHealth;
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
ASGNI4
line 753
;752:	// colors
;753:	c1 = Info_ValueForKey( userinfo, "color" );
ADDRLP4 8
ARGP4
ADDRGP4 $304
ARGP4
ADDRLP4 2204
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 2124
ADDRLP4 2204
INDIRP4
ASGNP4
line 756
;754:
;755:	// teamInfo
;756:	s = Info_ValueForKey( userinfo, "teamoverlay" );
ADDRLP4 8
ARGP4
ADDRGP4 $305
ARGP4
ADDRLP4 2208
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2208
INDIRP4
ASGNP4
line 757
;757:	if ( ! *s || atoi( s ) != 0 ) {
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $308
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 2216
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 2216
INDIRI4
CNSTI4 0
EQI4 $306
LABELV $308
line 758
;758:		client->pers.teamInfo = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 580
ADDP4
CNSTI4 1
ASGNI4
line 759
;759:	} else {
ADDRGP4 $307
JUMPV
LABELV $306
line 760
;760:		client->pers.teamInfo = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 580
ADDP4
CNSTI4 0
ASGNI4
line 761
;761:	}
LABELV $307
line 765
;762:
;763:	// send over a subset of the userinfo keys so other clients can
;764:	// print scoreboards, display models, and play custom sounds
;765:	if ( ent->r.svFlags & SVF_BOT ) {
ADDRLP4 1096
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $309
line 766
;766:		s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\hc\\%i\\w\\%i\\l\\%i\\skill\\%s",
ADDRLP4 8
ARGP4
ADDRGP4 $312
ARGP4
ADDRLP4 2220
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRGP4 $311
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 1032
ARGP4
ADDRLP4 2124
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 608
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 612
ADDP4
INDIRI4
ARGI4
ADDRLP4 2220
INDIRP4
ARGP4
ADDRLP4 2228
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2228
INDIRP4
ASGNP4
line 770
;767:			client->pers.netname, client->sess.sessionTeam, model, c1,
;768:			client->pers.maxHealth, client->sess.wins, client->sess.losses,
;769:			Info_ValueForKey( userinfo, "skill" ) );
;770:	} else {
ADDRGP4 $310
JUMPV
LABELV $309
line 771
;771:		s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\hc\\%i\\w\\%i\\l\\%i",
ADDRGP4 $313
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 1032
ARGP4
ADDRLP4 2124
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 608
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 612
ADDP4
INDIRI4
ARGI4
ADDRLP4 2224
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 2224
INDIRP4
ASGNP4
line 774
;772:			client->pers.netname, client->sess.sessionTeam, model, c1,
;773:			client->pers.maxHealth, client->sess.wins, client->sess.losses );
;774:	}
LABELV $310
line 776
;775:
;776:	trap_SetConfigstring( CS_PLAYERS+clientNum, s );
ADDRFP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 778
;777:
;778:	G_LogPrintf( "ClientUserinfoChanged: %i %s\n", clientNum, s );
ADDRGP4 $314
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 779
;779:}
LABELV $248
endproc ClientUserinfoChanged 2232 36
export ClientConnect
proc ClientConnect 1072 12
line 802
;780:
;781:
;782:/*
;783:===========
;784:ClientConnect
;785:
;786:Called when a player begins connecting to the server.
;787:Called again for every map change or tournement restart.
;788:
;789:The session information will be valid after exit.
;790:
;791:Return NULL if the client should be allowed, otherwise return
;792:a string with the reason for denial.
;793:
;794:Otherwise, the client will be sent the current gamestate
;795:and will eventually get to ClientBegin.
;796:
;797:firstTime will be qtrue the very first time a client connects
;798:to the server machine, but qfalse on map changes and tournement
;799:restarts.
;800:============
;801:*/
;802:char *ClientConnect( int clientNum, qboolean firstTime, qboolean isBot ) {
line 808
;803:	char		*value;
;804:	gclient_t	*client;
;805:	char		userinfo[MAX_INFO_STRING];
;806:	gentity_t	*ent;
;807:
;808:	ent = &g_entities[ clientNum ];
ADDRLP4 1032
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 810
;809:
;810:	trap_GetUserinfo( clientNum, userinfo, sizeof( userinfo ) );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 813
;811:
;812:	// check to see if they are on the banned IP list
;813:	value = Info_ValueForKey (userinfo, "ip");
ADDRLP4 4
ARGP4
ADDRGP4 $252
ARGP4
ADDRLP4 1036
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 1036
INDIRP4
ASGNP4
line 814
;814:	if ( G_FilterPacket( value ) ) {
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 1040
ADDRGP4 G_FilterPacket
CALLI4
ASGNI4
ADDRLP4 1040
INDIRI4
CNSTI4 0
EQI4 $316
line 815
;815:		return "Banned.";
ADDRGP4 $318
RETP4
ADDRGP4 $315
JUMPV
LABELV $316
line 819
;816:	}
;817:
;818:	// check for a password
;819:	value = Info_ValueForKey (userinfo, "password");
ADDRLP4 4
ARGP4
ADDRGP4 $319
ARGP4
ADDRLP4 1044
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 1044
INDIRP4
ASGNP4
line 820
;820:	if ( g_password.string[0] && Q_stricmp( g_password.string, "none" ) &&
ADDRGP4 g_password+16
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $320
ADDRGP4 g_password+16
ARGP4
ADDRGP4 $324
ARGP4
ADDRLP4 1048
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1048
INDIRI4
CNSTI4 0
EQI4 $320
ADDRGP4 g_password+16
ARGP4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 1052
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 0
EQI4 $320
line 821
;821:		strcmp( g_password.string, value) != 0) {
line 822
;822:		return "Invalid password";
ADDRGP4 $326
RETP4
ADDRGP4 $315
JUMPV
LABELV $320
line 826
;823:	}
;824:
;825:	// they can connect
;826:	ent->client = level.clients + clientNum;
ADDRLP4 1032
INDIRP4
CNSTI4 504
ADDP4
CNSTI4 760
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 827
;827:	client = ent->client;
ADDRLP4 0
ADDRLP4 1032
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 829
;828:
;829:	memset( client, 0, sizeof(*client) );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 760
ARGU4
ADDRGP4 memset
CALLP4
pop
line 831
;830:
;831:	client->pers.connected = CON_CONNECTING;
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTI4 1
ASGNI4
line 834
;832:
;833:	// read or initialize the session data
;834:	if ( firstTime || level.newSession ) {
ADDRLP4 1056
CNSTI4 0
ASGNI4
ADDRFP4 4
INDIRI4
ADDRLP4 1056
INDIRI4
NEI4 $330
ADDRGP4 level+64
INDIRI4
ADDRLP4 1056
INDIRI4
EQI4 $327
LABELV $330
line 835
;835:		G_InitSessionData( client, userinfo );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_InitSessionData
CALLV
pop
line 836
;836:	}
LABELV $327
line 837
;837:	G_ReadSessionData( client );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_ReadSessionData
CALLV
pop
line 839
;838:
;839:	if( isBot ) {
ADDRFP4 8
INDIRI4
CNSTI4 0
EQI4 $331
line 840
;840:		ent->r.svFlags |= SVF_BOT;
ADDRLP4 1060
ADDRLP4 1032
INDIRP4
CNSTI4 416
ADDP4
ASGNP4
ADDRLP4 1060
INDIRP4
ADDRLP4 1060
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 841
;841:		ent->inuse = qtrue;
ADDRLP4 1032
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 1
ASGNI4
line 842
;842:		if( !G_BotConnect( clientNum, !firstTime ) ) {
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $336
ADDRLP4 1064
CNSTI4 1
ASGNI4
ADDRGP4 $337
JUMPV
LABELV $336
ADDRLP4 1064
CNSTI4 0
ASGNI4
LABELV $337
ADDRLP4 1064
INDIRI4
ARGI4
ADDRLP4 1068
ADDRGP4 G_BotConnect
CALLI4
ASGNI4
ADDRLP4 1068
INDIRI4
CNSTI4 0
NEI4 $333
line 843
;843:			return "BotConnectfailed";
ADDRGP4 $338
RETP4
ADDRGP4 $315
JUMPV
LABELV $333
line 845
;844:		}
;845:	}
LABELV $331
line 848
;846:
;847:	// get and distribute relevent paramters
;848:	G_LogPrintf( "ClientConnect: %i\n", clientNum );
ADDRGP4 $339
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_LogPrintf
CALLV
pop
line 849
;849:	ClientUserinfoChanged( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 852
;850:
;851:	// don't do the "xxx connected" messages if they were caried over from previous level
;852:	if ( firstTime ) {
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $340
line 853
;853:		trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " connected\n\"", client->pers.netname) );
ADDRGP4 $342
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 1060
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 1060
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 854
;854:	}
LABELV $340
line 856
;855:
;856:	if ( g_gametype.integer >= GT_TEAM &&
ADDRLP4 1060
CNSTI4 3
ASGNI4
ADDRGP4 g_gametype+12
INDIRI4
ADDRLP4 1060
INDIRI4
LTI4 $343
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ADDRLP4 1060
INDIRI4
EQI4 $343
line 857
;857:		client->sess.sessionTeam != TEAM_SPECTATOR ) {
line 858
;858:		BroadcastTeamChange( client, -1 );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRGP4 BroadcastTeamChange
CALLV
pop
line 859
;859:	}
LABELV $343
line 862
;860:
;861:	// count current clients and rank for scoreboard
;862:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 864
;863:
;864:	return NULL;
CNSTP4 0
RETP4
LABELV $315
endproc ClientConnect 1072 12
export ClientBegin
proc ClientBegin 28 12
line 876
;865:}
;866:
;867:/*
;868:===========
;869:ClientBegin
;870:
;871:called when a client has finished connecting, and is ready
;872:to be placed into the level.  This will happen every level load,
;873:and on transition between teams, but doesn't happen on respawns
;874:============
;875:*/
;876:void ClientBegin( int clientNum ) {
line 882
;877:	gentity_t	*ent;
;878:	gclient_t	*client;
;879:	gentity_t	*tent;
;880:	int			flags;
;881:
;882:	ent = g_entities + clientNum;
ADDRLP4 4
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 884
;883:
;884:	if( ent->botDelayBegin ) {
ADDRLP4 4
INDIRP4
CNSTI4 788
ADDP4
INDIRI4
CNSTI4 0
EQI4 $347
line 885
;885:		G_QueueBotBegin( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_QueueBotBegin
CALLV
pop
line 886
;886:		ent->botDelayBegin = qfalse;
ADDRLP4 4
INDIRP4
CNSTI4 788
ADDP4
CNSTI4 0
ASGNI4
line 887
;887:		return;
ADDRGP4 $346
JUMPV
LABELV $347
line 890
;888:	}
;889:
;890:	client = level.clients + clientNum;
ADDRLP4 0
CNSTI4 760
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 892
;891:
;892:	if ( ent->r.linked ) {
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRI4
CNSTI4 0
EQI4 $349
line 893
;893:		trap_UnlinkEntity( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 894
;894:	}
LABELV $349
line 895
;895:	G_InitGentity( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 G_InitGentity
CALLV
pop
line 896
;896:	ent->touch = 0;
ADDRLP4 4
INDIRP4
CNSTI4 684
ADDP4
CNSTP4 0
ASGNP4
line 897
;897:	ent->pain = 0;
ADDRLP4 4
INDIRP4
CNSTI4 692
ADDP4
CNSTP4 0
ASGNP4
line 898
;898:	ent->client = client;
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 900
;899:
;900:	client->pers.connected = CON_CONNECTED;
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
CNSTI4 2
ASGNI4
line 901
;901:	client->pers.enterTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 524
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 902
;902:	client->pers.teamState.state = TEAM_BEGIN;
ADDRLP4 0
INDIRP4
CNSTI4 528
ADDP4
CNSTI4 0
ASGNI4
line 909
;903:
;904:	// save eflags around this, because changing teams will
;905:	// cause this to happen with a valid entity, and we
;906:	// want to make sure the teleport bit is set right
;907:	// so the viewpoint doesn't interpolate through the
;908:	// world to the new position
;909:	flags = client->ps.eFlags;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
ASGNI4
line 910
;910:	memset( &client->ps, 0, sizeof( client->ps ) );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 444
ARGU4
ADDRGP4 memset
CALLP4
pop
line 911
;911:	client->ps.eFlags = flags;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 914
;912:
;913:	// locate ent at a spawn point
;914:	ClientSpawn( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 ClientSpawn
CALLV
pop
line 916
;915:
;916:	if ( client->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $352
line 918
;917:		// send event
;918:		tent = G_TempEntity( ent->client->ps.origin, EV_PLAYER_TELEPORT_IN );
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 42
ARGI4
ADDRLP4 16
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 16
INDIRP4
ASGNP4
line 919
;919:		tent->s.clientNum = ent->s.clientNum;
ADDRLP4 20
CNSTI4 168
ASGNI4
ADDRLP4 12
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
ADDRLP4 4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 921
;920:
;921:		if ( g_gametype.integer != GT_TOURNAMENT ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
EQI4 $354
line 922
;922:			trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " entered the game\n\"", client->pers.netname) );
ADDRGP4 $357
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 24
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 923
;923:		}
LABELV $354
line 924
;924:	}
LABELV $352
line 925
;925:	G_LogPrintf( "ClientBegin: %i\n", clientNum );
ADDRGP4 $358
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_LogPrintf
CALLV
pop
line 928
;926:
;927:	// count current clients and rank for scoreboard
;928:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 929
;929:}
LABELV $346
endproc ClientBegin 28 12
export ClientSpawn
proc ClientSpawn 344 16
line 940
;930:
;931:/*
;932:===========
;933:ClientSpawn
;934:
;935:Called every time a client is placed fresh in the world:
;936:after the first ClientBegin, and after each respawn
;937:Initializes all non-persistant parts of playerState
;938:============
;939:*/
;940:void ClientSpawn(gentity_t *ent) {
line 952
;941:	int		index;
;942:	vec3_t	spawn_origin, spawn_angles;
;943:	gclient_t	*client;
;944:	int		i;
;945:	clientPersistant_t	saved;
;946:	clientSession_t		savedSess;
;947:	int		persistant[MAX_PERSISTANT];
;948:	gentity_t	*spawnPoint;
;949:	int		flags;
;950:	int		savedPing;
;951:
;952:	index = ent - g_entities;
ADDRLP4 100
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ASGNI4
line 953
;953:	client = ent->client;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 958
;954:
;955:	// find a spawn point
;956:	// do it before setting health back up, so farthest
;957:	// ranging doesn't count this client
;958:	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $360
line 959
;959:		spawnPoint = SelectSpectatorSpawnPoint ( 
ADDRLP4 76
ARGP4
ADDRLP4 88
ARGP4
ADDRLP4 284
ADDRGP4 SelectSpectatorSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 284
INDIRP4
ASGNP4
line 961
;960:			spawn_origin, spawn_angles);
;961:	} else if (g_gametype.integer == GT_CTF) {
ADDRGP4 $361
JUMPV
LABELV $360
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 4
NEI4 $362
line 962
;962:		spawnPoint = SelectCTFSpawnPoint ( 
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 528
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
ARGP4
ADDRLP4 88
ARGP4
ADDRLP4 288
ADDRGP4 SelectCTFSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 288
INDIRP4
ASGNP4
line 966
;963:			client->sess.sessionTeam, 
;964:			client->pers.teamState.state, 
;965:			spawn_origin, spawn_angles);
;966:	} else {
ADDRGP4 $363
JUMPV
LABELV $362
LABELV $365
line 967
;967:		do {
line 969
;968:			// the first spawn should be at a good looking spot
;969:			if ( !client->pers.initialSpawn && client->pers.localClient ) {
ADDRLP4 288
CNSTI4 0
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 476
ADDP4
INDIRI4
ADDRLP4 288
INDIRI4
NEI4 $368
ADDRLP4 4
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
ADDRLP4 288
INDIRI4
EQI4 $368
line 970
;970:				client->pers.initialSpawn = qtrue;
ADDRLP4 4
INDIRP4
CNSTI4 476
ADDP4
CNSTI4 1
ASGNI4
line 971
;971:				spawnPoint = SelectInitialSpawnPoint( spawn_origin, spawn_angles );
ADDRLP4 76
ARGP4
ADDRLP4 88
ARGP4
ADDRLP4 292
ADDRGP4 SelectInitialSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 292
INDIRP4
ASGNP4
line 972
;972:			} else {
ADDRGP4 $369
JUMPV
LABELV $368
line 974
;973:				// don't spawn near existing origin if possible
;974:				spawnPoint = SelectSpawnPoint ( 
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 76
ARGP4
ADDRLP4 88
ARGP4
ADDRLP4 292
ADDRGP4 SelectSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 292
INDIRP4
ASGNP4
line 977
;975:					client->ps.origin, 
;976:					spawn_origin, spawn_angles);
;977:			}
LABELV $369
line 981
;978:
;979:			// Tim needs to prevent bots from spawning at the initial point
;980:			// on q3dm0...
;981:			if ( ( spawnPoint->flags & FL_NO_BOTS ) && ( ent->r.svFlags & SVF_BOT ) ) {
ADDRLP4 292
CNSTI4 0
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 8192
BANDI4
ADDRLP4 292
INDIRI4
EQI4 $370
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 292
INDIRI4
EQI4 $370
line 982
;982:				continue;	// try again
ADDRGP4 $366
JUMPV
LABELV $370
line 985
;983:			}
;984:			// just to be symetric, we have a nohumans option...
;985:			if ( ( spawnPoint->flags & FL_NO_HUMANS ) && !( ent->r.svFlags & SVF_BOT ) ) {
ADDRLP4 296
CNSTI4 0
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 16384
BANDI4
ADDRLP4 296
INDIRI4
EQI4 $367
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 296
INDIRI4
NEI4 $367
line 986
;986:				continue;	// try again
line 989
;987:			}
;988:
;989:			break;
LABELV $366
line 991
;990:
;991:		} while ( 1 );
ADDRGP4 $365
JUMPV
LABELV $367
line 992
;992:	}
LABELV $363
LABELV $361
line 993
;993:	client->pers.teamState.state = TEAM_ACTIVE;
ADDRLP4 4
INDIRP4
CNSTI4 528
ADDP4
CNSTI4 1
ASGNI4
line 997
;994:
;995:
;996:	// toggle the teleport bit so the client knows to not lerp
;997:	flags = ent->client->ps.eFlags & EF_TELEPORT_BIT;
ADDRLP4 104
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 4
BANDI4
ASGNI4
line 998
;998:	flags ^= EF_TELEPORT_BIT;
ADDRLP4 104
ADDRLP4 104
INDIRI4
CNSTI4 4
BXORI4
ASGNI4
line 1002
;999:
;1000:	// clear everything but the persistant data
;1001:
;1002:	saved = client->pers;
ADDRLP4 108
ADDRLP4 4
INDIRP4
CNSTI4 444
ADDP4
INDIRB
ASGNB 148
line 1003
;1003:	savedSess = client->sess;
ADDRLP4 256
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
INDIRB
ASGNB 24
line 1004
;1004:	savedPing = client->ps.ping;
ADDRLP4 280
ADDRLP4 4
INDIRP4
CNSTI4 440
ADDP4
INDIRI4
ASGNI4
line 1005
;1005:	for ( i = 0 ; i < MAX_PERSISTANT ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $374
line 1006
;1006:		persistant[i] = client->ps.persistant[i];
ADDRLP4 284
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 284
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 284
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 248
ADDP4
ADDP4
INDIRI4
ASGNI4
line 1007
;1007:	}
LABELV $375
line 1005
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $374
line 1008
;1008:	memset (client, 0, sizeof(*client));
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 760
ARGU4
ADDRGP4 memset
CALLP4
pop
line 1011
;1009:
;1010:	//ClientUserinfoChanged( index );
;1011:	client->pers = saved;
ADDRLP4 4
INDIRP4
CNSTI4 444
ADDP4
ADDRLP4 108
INDIRB
ASGNB 148
line 1012
;1012:	client->sess = savedSess;
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
ADDRLP4 256
INDIRB
ASGNB 24
line 1013
;1013:	client->ps.ping = savedPing;
ADDRLP4 4
INDIRP4
CNSTI4 440
ADDP4
ADDRLP4 280
INDIRI4
ASGNI4
line 1014
;1014:	for ( i = 0 ; i < MAX_PERSISTANT ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $378
line 1015
;1015:		client->ps.persistant[i] = persistant[i];
ADDRLP4 284
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 284
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 248
ADDP4
ADDP4
ADDRLP4 284
INDIRI4
ADDRLP4 8
ADDP4
INDIRI4
ASGNI4
line 1016
;1016:	}
LABELV $379
line 1014
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $378
line 1019
;1017:
;1018:	// increment the spawncount so the client will detect the respawn
;1019:	client->ps.persistant[PERS_SPAWN_COUNT]++;
ADDRLP4 284
ADDRLP4 4
INDIRP4
CNSTI4 264
ADDP4
ASGNP4
ADDRLP4 284
INDIRP4
ADDRLP4 284
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1020
;1020:	client->ps.persistant[PERS_TEAM] = client->sess.sessionTeam;
ADDRLP4 4
INDIRP4
CNSTI4 260
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 1021
;1021:	if(g_ResetScoresWhenDead.integer)
ADDRGP4 g_ResetScoresWhenDead+12
INDIRI4
CNSTI4 0
EQI4 $382
line 1022
;1022:		client->ps.persistant[PERS_SCORE] = 0;
ADDRLP4 4
INDIRP4
CNSTI4 248
ADDP4
CNSTI4 0
ASGNI4
LABELV $382
line 1024
;1023:
;1024:	client->airOutTime = level.time + 12000;
ADDRLP4 4
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 12000
ADDI4
ASGNI4
line 1027
;1025:
;1026:	// clear entity values
;1027:	if(client->pers.playerclass >= 0 && client->pers.playerclass < p_classes)
ADDRLP4 292
ADDRLP4 4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 292
INDIRI4
CNSTI4 0
LTI4 $386
ADDRLP4 292
INDIRI4
ADDRGP4 p_classes
INDIRI4
GEI4 $386
line 1028
;1028:	{
line 1029
;1029:		client->ps.stats[STAT_MASS] = p_class[client->pers.playerclass].mass;
ADDRLP4 4
INDIRP4
CNSTI4 228
ADDP4
CNSTI4 168
ADDRLP4 4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+72
ADDP4
INDIRI4
ASGNI4
line 1030
;1030:		if(p_class[client->pers.playerclass].bleeds)
CNSTI4 168
ADDRLP4 4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+76
ADDP4
INDIRI4
CNSTI4 0
EQI4 $389
line 1031
;1031:			client->ps.stats[STAT_EXTENDED_INFO] |= EXT_BLEEDS;
ADDRLP4 300
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 300
INDIRP4
ADDRLP4 300
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
ADDRGP4 $390
JUMPV
LABELV $389
line 1033
;1032:		else
;1033:			client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_BLEEDS;
ADDRLP4 304
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 304
INDIRP4
ADDRLP4 304
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
LABELV $390
line 1034
;1034:		if(p_class[client->pers.playerclass].wallclimber)
CNSTI4 168
ADDRLP4 4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+80
ADDP4
INDIRI4
CNSTI4 0
EQI4 $392
line 1035
;1035:			client->ps.stats[STAT_EXTENDED_INFO] |= EXT_WALLCLIMBER;
ADDRLP4 308
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 308
INDIRP4
ADDRLP4 308
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
ADDRGP4 $393
JUMPV
LABELV $392
line 1037
;1036:		else
;1037:			client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_WALLCLIMBER;
ADDRLP4 312
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 312
INDIRP4
ADDRLP4 312
INDIRP4
INDIRI4
CNSTI4 -17
BANDI4
ASGNI4
LABELV $393
line 1038
;1038:		client->pers.maxHealth = p_class[client->pers.playerclass].max_health;
ADDRLP4 4
INDIRP4
CNSTI4 520
ADDP4
CNSTI4 168
ADDRLP4 4
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+68
ADDP4
INDIRI4
ASGNI4
line 1040
;1039:		
;1040:	}
ADDRGP4 $387
JUMPV
LABELV $386
line 1041
;1041:	else if(g_BleedToDeath.value)
ADDRGP4 g_BleedToDeath+8
INDIRF4
CNSTF4 0
EQF4 $396
line 1042
;1042:	{
line 1043
;1043:		client->ps.stats[STAT_EXTENDED_INFO] |= EXT_BLEEDS;
ADDRLP4 296
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 296
INDIRP4
ADDRLP4 296
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1044
;1044:	}
ADDRGP4 $397
JUMPV
LABELV $396
line 1046
;1045:	else
;1046:	{
line 1047
;1047:		client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_BLEEDS;
ADDRLP4 296
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 296
INDIRP4
ADDRLP4 296
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
line 1048
;1048:	}
LABELV $397
LABELV $387
line 1050
;1049:
;1050:	client->ps.stats[STAT_MAX_HEALTH] = client->pers.maxHealth;
ADDRLP4 4
INDIRP4
CNSTI4 208
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
ASGNI4
line 1051
;1051:	client->ps.stats[STAT_LEG_DAMAGE] = 0;
ADDRLP4 4
INDIRP4
CNSTI4 224
ADDP4
CNSTI4 0
ASGNI4
line 1052
;1052:	client->ps.eFlags = flags;
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 104
INDIRI4
ASGNI4
line 1053
;1053:	client->bleeding = 0;
ADDRLP4 4
INDIRP4
CNSTI4 720
ADDP4
CNSTF4 0
ASGNF4
line 1054
;1054:	client->bleedtime = level.time;
ADDRLP4 4
INDIRP4
CNSTI4 716
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1055
;1055:	client->bleed_damage = 0;
ADDRLP4 4
INDIRP4
CNSTI4 724
ADDP4
CNSTF4 0
ASGNF4
line 1056
;1056:	ent->s.groundEntityNum = ENTITYNUM_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 1023
ASGNI4
line 1057
;1057:	ent->client = &level.clients[index];
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
CNSTI4 760
ADDRLP4 100
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 1058
;1058:	ent->takedamage = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 1
ASGNI4
line 1059
;1059:	ent->inuse = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 1
ASGNI4
line 1060
;1060:	ent->classname = "player";
ADDRFP4 0
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $400
ASGNP4
line 1061
;1061:	ent->r.contents = CONTENTS_BODY;
ADDRFP4 0
INDIRP4
CNSTI4 448
ADDP4
CNSTI4 33554432
ASGNI4
line 1062
;1062:	ent->clipmask = MASK_PLAYERSOLID;
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTI4 33619969
ASGNI4
line 1063
;1063:	ent->die = player_die;
ADDRFP4 0
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 player_die
ASGNP4
line 1064
;1064:	ent->waterlevel = 0;
ADDRFP4 0
INDIRP4
CNSTI4 768
ADDP4
CNSTI4 0
ASGNI4
line 1065
;1065:	ent->watertype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 764
ADDP4
CNSTI4 0
ASGNI4
line 1066
;1066:	ent->flags = 0;
ADDRFP4 0
INDIRP4
CNSTI4 524
ADDP4
CNSTI4 0
ASGNI4
line 1068
;1067:	
;1068:	VectorCopy (playerMins, ent->r.mins);
ADDRFP4 0
INDIRP4
CNSTI4 424
ADDP4
ADDRGP4 playerMins
INDIRB
ASGNB 12
line 1069
;1069:	VectorCopy (playerMaxs, ent->r.maxs);
ADDRFP4 0
INDIRP4
CNSTI4 436
ADDP4
ADDRGP4 playerMaxs
INDIRB
ASGNB 12
line 1071
;1070:
;1071:	client->ps.clientNum = index;
ADDRLP4 4
INDIRP4
CNSTI4 140
ADDP4
ADDRLP4 100
INDIRI4
ASGNI4
line 1073
;1072:
;1073:	if(g_OneWeaponPerPlayer.integer)
ADDRGP4 g_OneWeaponPerPlayer+12
INDIRI4
CNSTI4 0
EQI4 $401
line 1074
;1074:	{
line 1075
;1075:		client->ps.stats[STAT_WEAPONS] = ( 1 << WP_NONE );
ADDRLP4 4
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 1
ASGNI4
line 1076
;1076:		client->ps.ammo[WP_NONE] = -1;
ADDRLP4 4
INDIRP4
CNSTI4 376
ADDP4
CNSTI4 -1
ASGNI4
line 1077
;1077:		client->ps.weapon = WP_NONE;
ADDRLP4 4
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 0
ASGNI4
line 1078
;1078:		client->ps.weaponstate = WEAPON_READY;
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 0
ASGNI4
line 1079
;1079:	}
ADDRGP4 $402
JUMPV
LABELV $401
line 1081
;1080:	else
;1081:	{
line 1082
;1082:		client->ps.stats[STAT_WEAPONS] = ( 1 << WP_MACHINEGUN ) | (1 << WP_GAUNTLET);
ADDRLP4 4
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 6
ASGNI4
line 1083
;1083:		client->ps.ammo[WP_GAUNTLET] = -1;
ADDRLP4 4
INDIRP4
CNSTI4 380
ADDP4
CNSTI4 -1
ASGNI4
line 1084
;1084:		if ( g_gametype.integer == GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $404
line 1085
;1085:			client->ps.ammo[WP_MACHINEGUN] = 50;
ADDRLP4 4
INDIRP4
CNSTI4 384
ADDP4
CNSTI4 50
ASGNI4
line 1086
;1086:		} else {
ADDRGP4 $405
JUMPV
LABELV $404
line 1087
;1087:			client->ps.ammo[WP_MACHINEGUN] = 100;
ADDRLP4 4
INDIRP4
CNSTI4 384
ADDP4
CNSTI4 100
ASGNI4
line 1088
;1088:		}
LABELV $405
line 1089
;1089:		client->ps.weapon = WP_MACHINEGUN;
ADDRLP4 4
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 2
ASGNI4
line 1090
;1090:		client->ps.weaponstate = WEAPON_READY;
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 0
ASGNI4
line 1092
;1091:
;1092:	}
LABELV $402
line 1096
;1093:	
;1094:	
;1095:	// health will count down towards max_health
;1096:	ent->health = client->ps.stats[STAT_HEALTH] = client->ps.stats[STAT_MAX_HEALTH] * (1 + g_SpawnHealthBonus.integer / 100.0);
ADDRLP4 304
ADDRLP4 4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 g_SpawnHealthBonus+12
INDIRI4
CVIF4 4
CNSTF4 1120403456
DIVF4
CNSTF4 1065353216
ADDF4
MULF4
CVFI4 4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 304
INDIRI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 304
INDIRI4
ASGNI4
line 1098
;1097:
;1098:	G_SetOrigin( ent, spawn_origin );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 1099
;1099:	VectorCopy( spawn_origin, client->ps.origin );
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 76
INDIRB
ASGNB 12
line 1102
;1100:	
;1101:	// ## Hentai - don't allow player to pick up multiple weapons if in Action mode
;1102:	if(g_OneWeaponPerPlayer.integer)
ADDRGP4 g_OneWeaponPerPlayer+12
INDIRI4
CNSTI4 0
EQI4 $408
line 1103
;1103:		client->ps.stats[STAT_EXTENDED_INFO] |= EXT_LIMIT_WEAPONS;
ADDRLP4 308
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 308
INDIRP4
ADDRLP4 308
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
ADDRGP4 $409
JUMPV
LABELV $408
line 1105
;1104:	else
;1105:		client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_LIMIT_WEAPONS;
ADDRLP4 312
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 312
INDIRP4
ADDRLP4 312
INDIRP4
INDIRI4
CNSTI4 -3
BANDI4
ASGNI4
LABELV $409
line 1107
;1106:	
;1107:	if(g_weaponRespawn.integer <= 0)
ADDRGP4 g_weaponRespawn+12
INDIRI4
CNSTI4 0
GTI4 $411
line 1108
;1108:		client->ps.stats[STAT_EXTENDED_INFO] |= EXT_LIMIT_PICKUP;
ADDRLP4 316
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 316
INDIRP4
ADDRLP4 316
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
ADDRGP4 $412
JUMPV
LABELV $411
line 1110
;1109:	else
;1110:		client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_LIMIT_PICKUP;
ADDRLP4 320
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 320
INDIRP4
ADDRLP4 320
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
LABELV $412
line 1112
;1111:	
;1112:	if(g_InventoryAmmo.integer <= 0)
ADDRGP4 g_InventoryAmmo+12
INDIRI4
CNSTI4 0
GTI4 $414
line 1113
;1113:		client->ps.stats[STAT_EXTENDED_INFO] |= EXT_INVENTORY_AMMO;
ADDRLP4 324
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 324
INDIRP4
ADDRLP4 324
INDIRP4
INDIRI4
CNSTI4 4
BORI4
ASGNI4
ADDRGP4 $415
JUMPV
LABELV $414
line 1115
;1114:	else
;1115:		client->ps.stats[STAT_EXTENDED_INFO] &= ~EXT_INVENTORY_AMMO;
ADDRLP4 328
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
ASGNP4
ADDRLP4 328
INDIRP4
ADDRLP4 328
INDIRP4
INDIRI4
CNSTI4 -5
BANDI4
ASGNI4
LABELV $415
line 1118
;1116:	
;1117:	// the respawned flag will be cleared after the attack and jump keys come up
;1118:	client->ps.pm_flags |= PMF_RESPAWNED;
ADDRLP4 332
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 332
INDIRP4
ADDRLP4 332
INDIRP4
INDIRI4
CNSTI4 512
BORI4
ASGNI4
line 1121
;1119:
;1120:	
;1121:	trap_GetUsercmd( client - level.clients, &ent->client->pers.cmd );
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 760
DIVI4
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 448
ADDP4
ARGP4
ADDRGP4 trap_GetUsercmd
CALLV
pop
line 1122
;1122:	SetClientViewAngle( ent, spawn_angles );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 88
ARGP4
ADDRGP4 SetClientViewAngle
CALLV
pop
line 1124
;1123:	
;1124:	if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $417
line 1126
;1125:
;1126:	} else {
ADDRGP4 $418
JUMPV
LABELV $417
line 1127
;1127:		G_KillBox( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_KillBox
CALLV
pop
line 1128
;1128:		trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 1132
;1129:
;1130:		// force the base weapon up
;1131:		
;1132:	}
LABELV $418
line 1135
;1133:
;1134:	// don't allow full run speed for a bit
;1135:	client->ps.pm_flags |= PMF_TIME_KNOCKBACK;
ADDRLP4 336
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 336
INDIRP4
ADDRLP4 336
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 1136
;1136:	client->ps.pm_time = 100;
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 100
ASGNI4
line 1138
;1137:
;1138:	client->respawnTime = level.time;
ADDRLP4 4
INDIRP4
CNSTI4 680
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1139
;1139:	client->inactivityTime = level.time + g_inactivity.integer * 1000;
ADDRLP4 4
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDRGP4 g_inactivity+12
INDIRI4
MULI4
ADDI4
ASGNI4
line 1140
;1140:	client->latched_buttons = 0;
ADDRLP4 4
INDIRP4
CNSTI4 636
ADDP4
CNSTI4 0
ASGNI4
line 1143
;1141:
;1142:	// set default animations
;1143:	client->ps.torsoAnim = TORSO_STAND;
ADDRLP4 4
INDIRP4
CNSTI4 84
ADDP4
CNSTI4 11
ASGNI4
line 1144
;1144:	client->ps.legsAnim = LEGS_IDLE;
ADDRLP4 4
INDIRP4
CNSTI4 76
ADDP4
CNSTI4 22
ASGNI4
line 1146
;1145:
;1146:	if ( level.intermissiontime ) {
ADDRGP4 level+4228
INDIRI4
CNSTI4 0
EQI4 $422
line 1147
;1147:		MoveClientToIntermission( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 MoveClientToIntermission
CALLV
pop
line 1148
;1148:	} else {
ADDRGP4 $423
JUMPV
LABELV $422
line 1150
;1149:		// fire the targets of the spawn point
;1150:		G_UseTargets( spawnPoint, ent );
ADDRLP4 72
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 1154
;1151:
;1152:		// select the highest weapon number available, after any
;1153:		// spawn given items have fired
;1154:		client->ps.weapon = !(g_OneWeaponPerPlayer.integer);
ADDRGP4 g_OneWeaponPerPlayer+12
INDIRI4
CNSTI4 0
NEI4 $427
ADDRLP4 340
CNSTI4 1
ASGNI4
ADDRGP4 $428
JUMPV
LABELV $427
ADDRLP4 340
CNSTI4 0
ASGNI4
LABELV $428
ADDRLP4 4
INDIRP4
CNSTI4 144
ADDP4
ADDRLP4 340
INDIRI4
ASGNI4
line 1155
;1155:		for ( i = WP_NUM_WEAPONS - 1 ; i > 0 ; i-- ) {
ADDRLP4 0
CNSTI4 9
ASGNI4
LABELV $429
line 1156
;1156:			if ( client->ps.stats[STAT_WEAPONS] & ( 1 << i ) ) {
ADDRLP4 4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $433
line 1157
;1157:				client->ps.weapon = i;
ADDRLP4 4
INDIRP4
CNSTI4 144
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1158
;1158:				break;
ADDRGP4 $431
JUMPV
LABELV $433
line 1160
;1159:			}
;1160:		}
LABELV $430
line 1155
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
GTI4 $429
LABELV $431
line 1161
;1161:	}
LABELV $423
line 1165
;1162:
;1163:	// run a client frame to drop exactly to the floor,
;1164:	// initialize animations and other things
;1165:	client->ps.commandTime = level.time - 100;
ADDRLP4 4
INDIRP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
SUBI4
ASGNI4
line 1166
;1166:	ent->client->pers.cmd.serverTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 448
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1167
;1167:	ClientThink( ent-g_entities );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ARGI4
ADDRGP4 ClientThink
CALLV
pop
line 1170
;1168:
;1169:	// positively link the client, even if the command times are weird
;1170:	if ( ent->client->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $437
line 1171
;1171:		BG_PlayerStateToEntityState( &client->ps, &ent->s, qtrue );
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 1172
;1172:		VectorCopy( ent->client->ps.origin, ent->r.currentOrigin );
ADDRLP4 340
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 340
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 340
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1173
;1173:		trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 1174
;1174:	}
LABELV $437
line 1177
;1175:
;1176:	// run the presend to set anything else
;1177:	ClientEndFrame( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ClientEndFrame
CALLV
pop
line 1180
;1178:
;1179:	// clear entity state values
;1180:	BG_PlayerStateToEntityState( &client->ps, &ent->s, qtrue );
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 1182
;1181:	
;1182:}
LABELV $359
endproc ClientSpawn 344 16
export ClientDisconnect
proc ClientDisconnect 24 8
line 1197
;1183:
;1184:
;1185:/*
;1186:===========
;1187:ClientDisconnect
;1188:
;1189:Called when a player drops from the server.
;1190:Will not be called between levels.
;1191:
;1192:This should NOT be called directly by any game logic,
;1193:call trap_DropClient(), which will call this and do
;1194:server system housekeeping.
;1195:============
;1196:*/
;1197:void ClientDisconnect( int clientNum ) {
line 1202
;1198:	gentity_t	*ent;
;1199:	gentity_t	*tent;
;1200:	int			i;
;1201:
;1202:	ent = g_entities + clientNum;
ADDRLP4 4
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1203
;1203:	if ( !ent->client ) {
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $440
line 1204
;1204:		return;
ADDRGP4 $439
JUMPV
LABELV $440
line 1208
;1205:	}
;1206:
;1207:	// stop any following clients
;1208:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $445
JUMPV
LABELV $442
line 1209
;1209:		if ( level.clients[i].sess.sessionTeam == TEAM_SPECTATOR
ADDRLP4 12
CNSTI4 760
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $447
ADDRLP4 12
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 2
NEI4 $447
ADDRLP4 12
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $447
line 1211
;1210:			&& level.clients[i].sess.spectatorState == SPECTATOR_FOLLOW
;1211:			&& level.clients[i].sess.spectatorClient == clientNum ) {
line 1212
;1212:			StopFollowing( &g_entities[i] );
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRGP4 StopFollowing
CALLV
pop
line 1213
;1213:		}
LABELV $447
line 1214
;1214:	}
LABELV $443
line 1208
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $445
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $442
line 1217
;1215:
;1216:	// send effect if they were completely connected
;1217:	if ( ent->client->pers.connected == CON_CONNECTED 
ADDRLP4 12
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
NEI4 $449
ADDRLP4 12
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $449
line 1218
;1218:		&& ent->client->sess.sessionTeam != TEAM_SPECTATOR ) {
line 1219
;1219:		tent = G_TempEntity( ent->client->ps.origin, EV_PLAYER_TELEPORT_OUT );
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 43
ARGI4
ADDRLP4 16
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 16
INDIRP4
ASGNP4
line 1220
;1220:		tent->s.clientNum = ent->s.clientNum;
ADDRLP4 20
CNSTI4 168
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
ADDRLP4 4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 1224
;1221:
;1222:		// They don't get to take powerups with them!
;1223:		// Especially important for stuff like CTF flags
;1224:		TossClientItems ( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 TossClientItems
CALLV
pop
line 1225
;1225:	}
LABELV $449
line 1227
;1226:
;1227:	G_LogPrintf( "ClientDisconnect: %i\n", clientNum );
ADDRGP4 $451
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_LogPrintf
CALLV
pop
line 1230
;1228:
;1229:	// if we are playing in tourney mode and losing, give a win to the other player
;1230:	if ( g_gametype.integer == GT_TOURNAMENT && !level.intermissiontime
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $452
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRGP4 level+4228
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $452
ADDRGP4 level+16
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $452
ADDRGP4 level+84+4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $452
line 1231
;1231:		&& !level.warmupTime && level.sortedClients[1] == clientNum ) {
line 1232
;1232:		level.clients[ level.sortedClients[0] ].sess.wins++;
ADDRLP4 20
CNSTI4 760
ADDRGP4 level+84
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 608
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1233
;1233:		ClientUserinfoChanged( level.sortedClients[0] );
ADDRGP4 level+84
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 1234
;1234:	}
LABELV $452
line 1236
;1235:
;1236:	trap_UnlinkEntity (ent);
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 1237
;1237:	ent->s.modelindex = 0;
ADDRLP4 4
INDIRP4
CNSTI4 160
ADDP4
CNSTI4 0
ASGNI4
line 1238
;1238:	ent->inuse = qfalse;
ADDRLP4 4
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 0
ASGNI4
line 1239
;1239:	ent->classname = "disconnected";
ADDRLP4 4
INDIRP4
CNSTI4 512
ADDP4
ADDRGP4 $461
ASGNP4
line 1240
;1240:	ent->client->pers.connected = CON_DISCONNECTED;
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 444
ADDP4
CNSTI4 0
ASGNI4
line 1241
;1241:	ent->client->ps.persistant[PERS_TEAM] = TEAM_FREE;
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 260
ADDP4
CNSTI4 0
ASGNI4
line 1242
;1242:	ent->client->sess.sessionTeam = TEAM_FREE;
ADDRLP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
CNSTI4 0
ASGNI4
line 1244
;1243:
;1244:	trap_SetConfigstring( CS_PLAYERS + clientNum, "");
ADDRFP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRGP4 $462
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 1246
;1245:
;1246:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 1248
;1247:
;1248:	if ( ent->r.svFlags & SVF_BOT ) {
ADDRLP4 4
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $463
line 1249
;1249:		BotAIShutdownClient( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 BotAIShutdownClient
CALLI4
pop
line 1250
;1250:	}
LABELV $463
line 1251
;1251:}
LABELV $439
endproc ClientDisconnect 24 8
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import CalculateRanks
import AddScore
import player_die
import InitClientResp
import InitClientPersistant
import BeginIntermission
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $462
byte 1 0
align 1
LABELV $461
byte 1 100
byte 1 105
byte 1 115
byte 1 99
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $451
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 68
byte 1 105
byte 1 115
byte 1 99
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $400
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $358
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 66
byte 1 101
byte 1 103
byte 1 105
byte 1 110
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $357
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $342
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 99
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 101
byte 1 100
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $339
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 67
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $338
byte 1 66
byte 1 111
byte 1 116
byte 1 67
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 102
byte 1 97
byte 1 105
byte 1 108
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $326
byte 1 73
byte 1 110
byte 1 118
byte 1 97
byte 1 108
byte 1 105
byte 1 100
byte 1 32
byte 1 112
byte 1 97
byte 1 115
byte 1 115
byte 1 119
byte 1 111
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $324
byte 1 110
byte 1 111
byte 1 110
byte 1 101
byte 1 0
align 1
LABELV $319
byte 1 112
byte 1 97
byte 1 115
byte 1 115
byte 1 119
byte 1 111
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $318
byte 1 66
byte 1 97
byte 1 110
byte 1 110
byte 1 101
byte 1 100
byte 1 46
byte 1 0
align 1
LABELV $314
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 85
byte 1 115
byte 1 101
byte 1 114
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 67
byte 1 104
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 100
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $313
byte 1 110
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 116
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 99
byte 1 49
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 104
byte 1 99
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 119
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 108
byte 1 92
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $312
byte 1 115
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $311
byte 1 110
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 116
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 99
byte 1 49
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 104
byte 1 99
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 119
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 108
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 115
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 92
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $305
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 108
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $304
byte 1 99
byte 1 111
byte 1 108
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $303
byte 1 83
byte 1 101
byte 1 114
byte 1 118
byte 1 101
byte 1 114
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 99
byte 1 111
byte 1 110
byte 1 102
byte 1 105
byte 1 103
byte 1 117
byte 1 114
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 32
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 101
byte 1 115
byte 1 46
byte 1 10
byte 1 84
byte 1 104
byte 1 105
byte 1 115
byte 1 32
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 32
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 33
byte 1 10
byte 1 32
byte 1 70
byte 1 111
byte 1 114
byte 1 99
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 115
byte 1 112
byte 1 101
byte 1 99
byte 1 116
byte 1 97
byte 1 116
byte 1 111
byte 1 114
byte 1 32
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 46
byte 1 46
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $284
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $282
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $277
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $273
byte 1 104
byte 1 97
byte 1 110
byte 1 100
byte 1 105
byte 1 99
byte 1 97
byte 1 112
byte 1 0
align 1
LABELV $272
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $267
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 98
byte 1 111
byte 1 97
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $262
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $259
byte 1 99
byte 1 108
byte 1 95
byte 1 97
byte 1 117
byte 1 116
byte 1 111
byte 1 97
byte 1 105
byte 1 109
byte 1 0
align 1
LABELV $256
byte 1 99
byte 1 103
byte 1 95
byte 1 112
byte 1 114
byte 1 101
byte 1 100
byte 1 105
byte 1 99
byte 1 116
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 0
align 1
LABELV $255
byte 1 108
byte 1 111
byte 1 99
byte 1 97
byte 1 108
byte 1 104
byte 1 111
byte 1 115
byte 1 116
byte 1 0
align 1
LABELV $252
byte 1 105
byte 1 112
byte 1 0
align 1
LABELV $251
byte 1 92
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 92
byte 1 98
byte 1 97
byte 1 100
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 0
align 1
LABELV $247
byte 1 68
byte 1 69
byte 1 70
byte 1 65
byte 1 85
byte 1 76
byte 1 84
byte 1 0
align 1
LABELV $244
byte 1 77
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 47
byte 1 32
byte 1 67
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 91
byte 1 37
byte 1 100
byte 1 93
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $218
byte 1 85
byte 1 110
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 100
byte 1 80
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $192
byte 1 47
byte 1 0
align 1
LABELV $121
byte 1 98
byte 1 111
byte 1 100
byte 1 121
byte 1 113
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $102
byte 1 67
byte 1 111
byte 1 117
byte 1 108
byte 1 100
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 102
byte 1 105
byte 1 110
byte 1 100
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 32
byte 1 112
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 0
align 1
LABELV $62
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 95
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 95
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 109
byte 1 97
byte 1 116
byte 1 99
byte 1 104
byte 1 0
align 1
LABELV $60
byte 1 77
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $59
byte 1 71
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 108
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $51
byte 1 110
byte 1 111
byte 1 104
byte 1 117
byte 1 109
byte 1 97
byte 1 110
byte 1 115
byte 1 0
align 1
LABELV $48
byte 1 48
byte 1 0
align 1
LABELV $47
byte 1 110
byte 1 111
byte 1 98
byte 1 111
byte 1 116
byte 1 115
byte 1 0
