export P_DamageFeedback
code
proc P_DamageFeedback 40 12
file "..\g_active.c"
line 17
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:#include "g_local.h"
;5:
;6:
;7:/*
;8:===============
;9:G_DamageFeedback
;10:
;11:Called just before a snapshot is sent to the given player.
;12:Totals up all damage and generates both the player_state_t
;13:damage values to that client for pain blends and kicks, and
;14:global pain sound events for all clients.
;15:===============
;16:*/
;17:void P_DamageFeedback( gentity_t *player ) {
line 22
;18:	gclient_t	*client;
;19:	float	count;
;20:	vec3_t	angles;
;21:
;22:	client = player->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 23
;23:	if ( client->ps.pm_type == PM_DEAD ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $47
line 24
;24:		return;
ADDRGP4 $46
JUMPV
LABELV $47
line 28
;25:	}
;26:
;27:	// total points of damage shot at the player this frame
;28:	count = client->damage_blood + client->damage_armor;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 644
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 29
;29:	if ( count == 0 ) {
ADDRLP4 4
INDIRF4
CNSTF4 0
NEF4 $49
line 30
;30:		return;		// didn't take any damage
ADDRGP4 $46
JUMPV
LABELV $49
line 33
;31:	}
;32:
;33:	if ( count > 255 ) {
ADDRLP4 4
INDIRF4
CNSTF4 1132396544
LEF4 $51
line 34
;34:		count = 255;
ADDRLP4 4
CNSTF4 1132396544
ASGNF4
line 35
;35:	}
LABELV $51
line 41
;36:
;37:	// send the information to the client
;38:
;39:	// world damage (falling, slime, etc) uses a special code
;40:	// to make the blend blob centered instead of positional
;41:	if ( client->damage_fromWorld ) {
ADDRLP4 0
INDIRP4
CNSTI4 664
ADDP4
INDIRI4
CNSTI4 0
EQI4 $53
line 42
;42:		client->ps.damagePitch = 255;
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
CNSTI4 255
ASGNI4
line 43
;43:		client->ps.damageYaw = 255;
ADDRLP4 0
INDIRP4
CNSTI4 172
ADDP4
CNSTI4 255
ASGNI4
line 45
;44:
;45:		client->damage_fromWorld = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 664
ADDP4
CNSTI4 0
ASGNI4
line 46
;46:	} else {
ADDRGP4 $54
JUMPV
LABELV $53
line 47
;47:		vectoangles( client->damage_from, angles );
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 48
;48:		client->ps.damagePitch = angles[PITCH]/360.0 * 256;
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
CNSTF4 1132462080
ADDRLP4 8
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
CVFI4 4
ASGNI4
line 49
;49:		client->ps.damageYaw = angles[YAW]/360.0 * 256;
ADDRLP4 0
INDIRP4
CNSTI4 172
ADDP4
CNSTF4 1132462080
ADDRLP4 8+4
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
CVFI4 4
ASGNI4
line 50
;50:	}
LABELV $54
line 53
;51:
;52:	// play an apropriate pain sound
;53:	if ( (level.time > player->pain_debounce_time) && !(player->flags & FL_GODMODE) ) {
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 level+32
INDIRI4
ADDRLP4 24
INDIRP4
CNSTI4 700
ADDP4
INDIRI4
LEI4 $56
ADDRLP4 24
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
NEI4 $56
line 54
;54:		player->pain_debounce_time = level.time + 700;		
ADDRLP4 28
CNSTI4 700
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
ADDRGP4 level+32
INDIRI4
ADDRLP4 28
INDIRI4
ADDI4
ASGNI4
line 55
;55:		G_AddEvent( player, EV_PAIN, player->health );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
CNSTI4 54
ARGI4
ADDRLP4 32
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 56
;56:		client->ps.damageEvent++;
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 168
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 57
;57:	}
LABELV $56
line 60
;58:
;59:
;60:	client->ps.damageCount = count;
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
ADDRLP4 4
INDIRF4
CVFI4 4
ASGNI4
line 65
;61:
;62:	//
;63:	// clear totals
;64:	//
;65:	client->damage_blood = 0;
ADDRLP4 0
INDIRP4
CNSTI4 644
ADDP4
CNSTI4 0
ASGNI4
line 66
;66:	client->damage_armor = 0;
ADDRLP4 0
INDIRP4
CNSTI4 640
ADDP4
CNSTI4 0
ASGNI4
line 67
;67:	client->damage_knockback = 0;
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
CNSTI4 0
ASGNI4
line 68
;68:}
LABELV $46
endproc P_DamageFeedback 40 12
export P_WorldEffects
proc P_WorldEffects 40 32
line 79
;69:
;70:
;71:
;72:/*
;73:=============
;74:P_WorldEffects
;75:
;76:Check for lava / slime contents and drowning
;77:=============
;78:*/
;79:void P_WorldEffects( gentity_t *ent ) {
line 83
;80:	qboolean	envirosuit;
;81:	int			waterlevel;
;82:
;83:	if ( ent->client->noclip ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 620
ADDP4
INDIRI4
CNSTI4 0
EQI4 $61
line 84
;84:		ent->client->airOutTime = level.time + 12000;	// don't need air
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 12000
ADDI4
ASGNI4
line 85
;85:		return;
ADDRGP4 $60
JUMPV
LABELV $61
line 88
;86:	}
;87:
;88:	waterlevel = ent->waterlevel;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 768
ADDP4
INDIRI4
ASGNI4
line 90
;89:
;90:	envirosuit = ent->client->ps.powerups[PW_BATTLESUIT] > level.time;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 320
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $66
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRGP4 $67
JUMPV
LABELV $66
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $67
ADDRLP4 4
ADDRLP4 8
INDIRI4
ASGNI4
line 95
;91:
;92:	//
;93:	// check for drowning
;94:	//
;95:	if ( waterlevel == 3 ) {
ADDRLP4 0
INDIRI4
CNSTI4 3
NEI4 $68
line 97
;96:		// envirosuit give air
;97:		if ( envirosuit ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $70
line 98
;98:			ent->client->airOutTime = level.time + 10000;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 99
;99:		}
LABELV $70
line 102
;100:
;101:		// if out of air, start drowning
;102:		if ( ent->client->airOutTime < level.time) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 696
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $69
line 104
;103:			// drown!
;104:			ent->client->airOutTime += 1000;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 696
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1000
ADDI4
ASGNI4
line 105
;105:			if ( ent->health > 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 0
LEI4 $69
line 107
;106:				// take more damage the longer underwater
;107:				ent->damage += 2;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 2
ADDI4
ASGNI4
line 108
;108:				if (ent->damage > 15)
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
CNSTI4 15
LEI4 $78
line 109
;109:					ent->damage = 15;
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 15
ASGNI4
LABELV $78
line 112
;110:
;111:				// play a gurp sound instead of a normal pain sound
;112:				if (ent->health <= ent->damage) {
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 20
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
GTI4 $80
line 113
;113:					G_Sound(ent, CHAN_VOICE, G_SoundIndex("*drown.wav"));
ADDRGP4 $82
ARGP4
ADDRLP4 24
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 114
;114:				} else if (rand()&1) {
ADDRGP4 $81
JUMPV
LABELV $80
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $83
line 115
;115:					G_Sound(ent, CHAN_VOICE, G_SoundIndex("sound/player/gurp1.wav"));
ADDRGP4 $85
ARGP4
ADDRLP4 28
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 116
;116:				} else {
ADDRGP4 $84
JUMPV
LABELV $83
line 117
;117:					G_Sound(ent, CHAN_VOICE, G_SoundIndex("sound/player/gurp2.wav"));
ADDRGP4 $86
ARGP4
ADDRLP4 28
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 118
;118:				}
LABELV $84
LABELV $81
line 121
;119:
;120:				// don't play a normal pain sound
;121:				ent->pain_debounce_time = level.time + 200;
ADDRFP4 0
INDIRP4
CNSTI4 700
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 123
;122:
;123:				G_Damage (ent, NULL, NULL, NULL, NULL, 
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
CNSTP4 0
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 36
CNSTP4 0
ASGNP4
ADDRLP4 36
INDIRP4
ARGP4
ADDRLP4 36
INDIRP4
ARGP4
ADDRLP4 28
INDIRP4
CNSTI4 720
ADDP4
INDIRI4
ARGI4
CNSTI4 18
ARGI4
CNSTI4 14
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 125
;124:					ent->damage, DAMAGE_NO_ARMOR | DAMAGE_NO_BLEEDING, MOD_WATER);
;125:			}
line 126
;126:		}
line 127
;127:	} else {
ADDRGP4 $69
JUMPV
LABELV $68
line 128
;128:		ent->client->airOutTime = level.time + 12000;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 696
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 12000
ADDI4
ASGNI4
line 129
;129:		ent->damage = 2;
ADDRFP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTI4 2
ASGNI4
line 130
;130:	}
LABELV $69
line 135
;131:
;132:	//
;133:	// check for sizzle damage (move to pmove?)
;134:	//
;135:	if (waterlevel && 
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $89
ADDRFP4 0
INDIRP4
CNSTI4 764
ADDP4
INDIRI4
CNSTI4 24
BANDI4
ADDRLP4 12
INDIRI4
EQI4 $89
line 136
;136:		(ent->watertype&(CONTENTS_LAVA|CONTENTS_SLIME)) ) {
line 137
;137:		if (ent->health > 0
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 0
LEI4 $91
ADDRLP4 16
INDIRP4
CNSTI4 700
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GTI4 $91
line 138
;138:			&& ent->pain_debounce_time <= level.time	) {
line 140
;139:
;140:			if ( envirosuit ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $94
line 141
;141:				G_AddEvent( ent, EV_POWERUP_BATTLESUIT, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 60
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 142
;142:			} else { // ## Hentai ## - these have been sped up and toned down, damage per second is roughly the same
ADDRGP4 $95
JUMPV
LABELV $94
line 143
;143:				if (ent->watertype & CONTENTS_SLIME) {
ADDRFP4 0
INDIRP4
CNSTI4 764
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $96
line 144
;144:					G_Damage (ent, NULL, NULL, NULL, NULL, 
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
CNSTP4 0
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
CNSTP4 0
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
CNSTI4 3
ADDRLP4 0
INDIRI4
MULI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 15
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 146
;145:						3 * waterlevel, 0, MOD_SLIME);
;146:					ent->pain_debounce_time = level.time + 200;
ADDRFP4 0
INDIRP4
CNSTI4 700
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 147
;147:				}
LABELV $96
line 148
;148:				if (ent->watertype & CONTENTS_LAVA) {
ADDRFP4 0
INDIRP4
CNSTI4 764
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $99
line 149
;149:					G_Damage (ent, NULL, NULL, NULL, NULL, 
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
CNSTP4 0
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
CNSTP4 0
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
CNSTI4 5
ADDRLP4 0
INDIRI4
MULI4
ARGI4
ADDRLP4 28
CNSTI4 16
ASGNI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 151
;150:						5 * waterlevel, DAMAGE_NO_BLEEDING, MOD_LAVA);
;151:					ent->pain_debounce_time = level.time + 100;
ADDRFP4 0
INDIRP4
CNSTI4 700
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 152
;152:				}
LABELV $99
line 156
;153:
;154:				
;155:				
;156:			}
LABELV $95
line 157
;157:		}
LABELV $91
line 158
;158:	}
LABELV $89
line 159
;159:}
LABELV $60
endproc P_WorldEffects 40 32
export G_SetClientSound
proc G_SetClientSound 8 0
line 168
;160:
;161:
;162:
;163:/*
;164:===============
;165:G_SetClientSound
;166:===============
;167:*/
;168:void G_SetClientSound( gentity_t *ent ) {
line 169
;169:	if (ent->waterlevel && (ent->watertype&(CONTENTS_LAVA|CONTENTS_SLIME)) )
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 768
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $103
ADDRLP4 0
INDIRP4
CNSTI4 764
ADDP4
INDIRI4
CNSTI4 24
BANDI4
ADDRLP4 4
INDIRI4
EQI4 $103
line 170
;170:		ent->s.loopSound = level.snd_fry;
ADDRFP4 0
INDIRP4
CNSTI4 156
ADDP4
ADDRGP4 level+604
INDIRI4
ASGNI4
ADDRGP4 $104
JUMPV
LABELV $103
line 172
;171:	else
;172:		ent->s.loopSound = 0;
ADDRFP4 0
INDIRP4
CNSTI4 156
ADDP4
CNSTI4 0
ASGNI4
LABELV $104
line 173
;173:}
LABELV $102
endproc G_SetClientSound 8 0
export ClientImpacts
proc ClientImpacts 76 12
line 184
;174:
;175:
;176:
;177://==============================================================
;178:
;179:/*
;180:==============
;181:ClientImpacts
;182:==============
;183:*/
;184:void ClientImpacts( gentity_t *ent, pmove_t *pm ) {
line 189
;185:	int		i, j;
;186:	trace_t	trace;
;187:	gentity_t	*other;
;188:
;189:	memset( &trace, 0, sizeof( trace ) );
ADDRLP4 12
ARGP4
CNSTI4 0
ARGI4
CNSTU4 56
ARGU4
ADDRGP4 memset
CALLP4
pop
line 190
;190:	for (i=0 ; i<pm->numtouch ; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $110
JUMPV
LABELV $107
line 191
;191:		for (j=0 ; j<i ; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $114
JUMPV
LABELV $111
line 192
;192:			if (pm->touchents[j] == pm->touchents[i] ) {
ADDRLP4 68
CNSTI4 2
ASGNI4
ADDRLP4 72
ADDRFP4 4
INDIRP4
CNSTI4 48
ADDP4
ASGNP4
ADDRLP4 0
INDIRI4
ADDRLP4 68
INDIRI4
LSHI4
ADDRLP4 72
INDIRP4
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDRLP4 68
INDIRI4
LSHI4
ADDRLP4 72
INDIRP4
ADDP4
INDIRI4
NEI4 $115
line 193
;193:				break;
ADDRGP4 $113
JUMPV
LABELV $115
line 195
;194:			}
;195:		}
LABELV $112
line 191
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $114
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $111
LABELV $113
line 196
;196:		if (j != i) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $117
line 197
;197:			continue;	// duplicated
ADDRGP4 $108
JUMPV
LABELV $117
line 199
;198:		}
;199:		other = &g_entities[ pm->touchents[i] ];
ADDRLP4 8
CNSTI4 792
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 48
ADDP4
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 201
;200:
;201:		if ( ( ent->r.svFlags & SVF_BOT ) && ( ent->touch ) ) {
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $119
ADDRLP4 68
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $119
line 202
;202:			ent->touch( ent, other, &trace );
ADDRLP4 72
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 72
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CALLV
pop
line 203
;203:		}
LABELV $119
line 205
;204:
;205:		if ( !other->touch ) {
ADDRLP4 8
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $121
line 206
;206:			continue;
ADDRGP4 $108
JUMPV
LABELV $121
line 209
;207:		}
;208:
;209:		other->touch( other, ent, &trace );
ADDRLP4 8
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CALLV
pop
line 210
;210:	}
LABELV $108
line 190
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $110
ADDRLP4 4
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
LTI4 $107
line 212
;211:
;212:}
LABELV $106
endproc ClientImpacts 76 12
data
align 4
LABELV $124
byte 4 1109393408
byte 4 1109393408
byte 4 1112539136
export G_TouchTriggers
code
proc G_TouchTriggers 4240 16
line 222
;213:
;214:/*
;215:============
;216:G_TouchTriggers
;217:
;218:Find all trigger entities that ent's current position touches.
;219:Spectators will only interact with teleporters.
;220:============
;221:*/
;222:void	G_TouchTriggers( gentity_t *ent ) {
line 230
;223:	int			i, num;
;224:	int			touch[MAX_GENTITIES];
;225:	gentity_t	*hit;
;226:	trace_t		trace;
;227:	vec3_t		mins, maxs;
;228:	static vec3_t	range = { 40, 40, 52 };
;229:
;230:	if ( !ent->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $125
line 231
;231:		return;
ADDRGP4 $123
JUMPV
LABELV $125
line 235
;232:	}
;233:
;234:	// dead clients don't activate triggers!
;235:	if ( ent->client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $127
line 236
;236:		return;
ADDRGP4 $123
JUMPV
LABELV $127
line 239
;237:	}
;238:
;239:	VectorSubtract( ent->client->ps.origin, range, mins );
ADDRLP4 4188
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 64
ADDRLP4 4188
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRGP4 $124
INDIRF4
SUBF4
ASGNF4
ADDRLP4 64+4
ADDRLP4 4188
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRGP4 $124+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 64+8
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRGP4 $124+8
INDIRF4
SUBF4
ASGNF4
line 240
;240:	VectorAdd( ent->client->ps.origin, range, maxs );
ADDRLP4 4192
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 76
ADDRLP4 4192
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRGP4 $124
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+4
ADDRLP4 4192
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRGP4 $124+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+8
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRGP4 $124+8
INDIRF4
ADDF4
ASGNF4
line 242
;241:
;242:	num = trap_EntitiesInBox( mins, maxs, touch, MAX_GENTITIES );
ADDRLP4 64
ARGP4
ADDRLP4 76
ARGP4
ADDRLP4 92
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 4196
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 88
ADDRLP4 4196
INDIRI4
ASGNI4
line 245
;243:
;244:	// can't use ent->absmin, because that has a one unit pad
;245:	VectorAdd( ent->client->ps.origin, ent->r.mins, mins );
ADDRLP4 4200
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4204
ADDRLP4 4200
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 64
ADDRLP4 4204
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 4200
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 64+4
ADDRLP4 4204
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 4200
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4208
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64+8
ADDRLP4 4208
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 4208
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ADDF4
ASGNF4
line 246
;246:	VectorAdd( ent->client->ps.origin, ent->r.maxs, maxs );
ADDRLP4 4212
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4216
ADDRLP4 4212
INDIRP4
CNSTI4 504
ADDP4
ASGNP4
ADDRLP4 76
ADDRLP4 4216
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 4212
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+4
ADDRLP4 4216
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 4212
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4220
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76+8
ADDRLP4 4220
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 4220
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDF4
ASGNF4
line 248
;247:
;248:	for ( i=0 ; i<num ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $144
JUMPV
LABELV $141
line 249
;249:		hit = &g_entities[touch[i]];
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 92
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 251
;250:
;251:		if ( !hit->touch && !ent->touch ) {
ADDRLP4 4224
CNSTI4 684
ASGNI4
ADDRLP4 4228
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
ADDRLP4 4224
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4228
INDIRU4
NEU4 $145
ADDRFP4 0
INDIRP4
ADDRLP4 4224
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4228
INDIRU4
NEU4 $145
line 252
;252:			continue;
ADDRGP4 $142
JUMPV
LABELV $145
line 254
;253:		}
;254:		if ( !( hit->r.contents & CONTENTS_TRIGGER ) ) {
ADDRLP4 0
INDIRP4
CNSTI4 448
ADDP4
INDIRI4
CNSTI4 1073741824
BANDI4
CNSTI4 0
NEI4 $147
line 255
;255:			continue;
ADDRGP4 $142
JUMPV
LABELV $147
line 259
;256:		}
;257:
;258:		// ignore most entities if a spectator
;259:		if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $149
line 260
;260:			if ( hit->s.eType != ET_TELEPORT_TRIGGER &&
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 9
EQI4 $151
ADDRLP4 0
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 Touch_DoorTrigger
CVPU4 4
EQU4 $151
line 263
;261:				// this is ugly but adding a new ET_? type will
;262:				// most likely cause network incompatibilities
;263:				hit->touch != Touch_DoorTrigger) {
line 264
;264:				continue;
ADDRGP4 $142
JUMPV
LABELV $151
line 266
;265:			}
;266:		}
LABELV $149
line 270
;267:
;268:		// use seperate code for determining if an item is picked up
;269:		// so you don't have to actually contact its bounding box
;270:		if ( hit->s.eType == ET_ITEM ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $153
line 271
;271:			if ( !BG_PlayerTouchesItem( &ent->client->ps, &hit->s, level.time ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 4232
ADDRGP4 BG_PlayerTouchesItem
CALLI4
ASGNI4
ADDRLP4 4232
INDIRI4
CNSTI4 0
NEI4 $154
line 272
;272:				continue;
ADDRGP4 $142
JUMPV
line 274
;273:			}
;274:		} else {
LABELV $153
line 275
;275:			if ( !trap_EntityContact( mins, maxs, hit ) ) {
ADDRLP4 64
ARGP4
ADDRLP4 76
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4232
ADDRGP4 trap_EntityContact
CALLI4
ASGNI4
ADDRLP4 4232
INDIRI4
CNSTI4 0
NEI4 $158
line 276
;276:				continue;
ADDRGP4 $142
JUMPV
LABELV $158
line 278
;277:			}
;278:		}
LABELV $154
line 280
;279:
;280:		memset( &trace, 0, sizeof(trace) );
ADDRLP4 8
ARGP4
CNSTI4 0
ARGI4
CNSTU4 56
ARGU4
ADDRGP4 memset
CALLP4
pop
line 282
;281:
;282:		if ( hit->touch ) {
ADDRLP4 0
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $160
line 283
;283:			hit->touch (hit, ent, &trace);
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CALLV
pop
line 284
;284:		}
LABELV $160
line 286
;285:
;286:		if ( ( ent->r.svFlags & SVF_BOT ) && ( ent->touch ) ) {
ADDRLP4 4232
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4232
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $162
ADDRLP4 4232
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $162
line 287
;287:			ent->touch( ent, hit, &trace );
ADDRLP4 4236
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4236
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 4236
INDIRP4
CNSTI4 684
ADDP4
INDIRP4
CALLV
pop
line 288
;288:		}
LABELV $162
line 289
;289:	}
LABELV $142
line 248
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $144
ADDRLP4 4
INDIRI4
ADDRLP4 88
INDIRI4
LTI4 $141
line 290
;290:}
LABELV $123
endproc G_TouchTriggers 4240 16
export SpectatorThink
proc SpectatorThink 240 12
line 297
;291:
;292:/*
;293:=================
;294:SpectatorThink
;295:=================
;296:*/
;297:void SpectatorThink( gentity_t *ent, usercmd_t *ucmd ) {
line 301
;298:	pmove_t	pm;
;299:	gclient_t	*client;
;300:
;301:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 303
;302:
;303:	if ( client->sess.spectatorState != SPECTATOR_FOLLOW ) {
ADDRLP4 0
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 2
EQI4 $165
line 304
;304:		client->ps.pm_type = PM_SPECTATOR;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 2
ASGNI4
line 305
;305:		client->ps.speed = 400;	// faster than normal
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
CNSTI4 400
ASGNI4
line 308
;306:
;307:		// set up for pmove
;308:		memset (&pm, 0, sizeof(pm));
ADDRLP4 4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 220
ARGU4
ADDRGP4 memset
CALLP4
pop
line 309
;309:		pm.ps = &client->ps;
ADDRLP4 4
ADDRLP4 0
INDIRP4
ASGNP4
line 310
;310:		pm.cmd = *ucmd;
ADDRLP4 4+4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 24
line 311
;311:		pm.tracemask = MASK_PLAYERSOLID & ~CONTENTS_BODY;	// spectators can fly through bodies
ADDRLP4 4+28
CNSTI4 65537
ASGNI4
line 312
;312:		pm.trace = trap_Trace;
ADDRLP4 4+212
ADDRGP4 trap_Trace
ASGNP4
line 313
;313:		pm.pointcontents = trap_PointContents;
ADDRLP4 4+216
ADDRGP4 trap_PointContents
ASGNP4
line 316
;314:
;315:		// perform a pmove
;316:		Pmove (&pm);
ADDRLP4 4
ARGP4
ADDRGP4 Pmove
CALLV
pop
line 319
;317:
;318:		// save results of pmove
;319:		VectorCopy( client->ps.origin, ent->s.origin );
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 321
;320:
;321:		G_TouchTriggers( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_TouchTriggers
CALLV
pop
line 322
;322:		trap_UnlinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 323
;323:	}
LABELV $165
line 325
;324:
;325:	client->oldbuttons = client->buttons;
ADDRLP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ASGNI4
line 326
;326:	client->buttons = ucmd->buttons;
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRU1
CVUI4 1
ASGNI4
line 329
;327:
;328:	// attack button cycles through spectators
;329:	if ( ( client->buttons & BUTTON_ATTACK ) && ! ( client->oldbuttons & BUTTON_ATTACK ) ) {
ADDRLP4 232
CNSTI4 1
ASGNI4
ADDRLP4 236
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ADDRLP4 232
INDIRI4
BANDI4
ADDRLP4 236
INDIRI4
EQI4 $171
ADDRLP4 0
INDIRP4
CNSTI4 632
ADDP4
INDIRI4
ADDRLP4 232
INDIRI4
BANDI4
ADDRLP4 236
INDIRI4
NEI4 $171
line 330
;330:		Cmd_FollowCycle_f( ent, 1 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 Cmd_FollowCycle_f
CALLV
pop
line 331
;331:	}
LABELV $171
line 332
;332:}
LABELV $164
endproc SpectatorThink 240 12
export ClientInactivityTimer
proc ClientInactivityTimer 12 8
line 343
;333:
;334:
;335:
;336:/*
;337:=================
;338:ClientInactivityTimer
;339:
;340:Returns qfalse if the client is dropped
;341:=================
;342:*/
;343:qboolean ClientInactivityTimer( gclient_t *client ) {
line 344
;344:	if ( ! g_inactivity.integer ) {
ADDRGP4 g_inactivity+12
INDIRI4
CNSTI4 0
NEI4 $174
line 347
;345:		// give everyone some time, so if the operator sets g_inactivity during
;346:		// gameplay, everyone isn't kicked
;347:		client->inactivityTime = level.time + 60 * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 60000
ADDI4
ASGNI4
line 348
;348:		client->inactivityWarning = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
CNSTI4 0
ASGNI4
line 349
;349:	} else if ( client->pers.cmd.forwardmove || 
ADDRGP4 $175
JUMPV
LABELV $174
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 468
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $182
ADDRLP4 0
INDIRP4
CNSTI4 469
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $182
ADDRLP4 0
INDIRP4
CNSTI4 470
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $182
ADDRLP4 0
INDIRP4
CNSTI4 452
ADDP4
INDIRU1
CVUI4 1
CNSTI4 1
BANDI4
ADDRLP4 4
INDIRI4
EQI4 $178
LABELV $182
line 352
;350:		client->pers.cmd.rightmove || 
;351:		client->pers.cmd.upmove ||
;352:		(client->pers.cmd.buttons & BUTTON_ATTACK) ) {
line 353
;353:		client->inactivityTime = level.time + g_inactivity.integer * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDRGP4 g_inactivity+12
INDIRI4
MULI4
ADDI4
ASGNI4
line 354
;354:		client->inactivityWarning = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
CNSTI4 0
ASGNI4
line 355
;355:	} else if ( !client->pers.localClient ) {
ADDRGP4 $179
JUMPV
LABELV $178
ADDRFP4 0
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
CNSTI4 0
NEI4 $185
line 356
;356:		if ( level.time > client->inactivityTime ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 684
ADDP4
INDIRI4
LEI4 $187
line 357
;357:			trap_DropClient( client - level.clients, "Dropped due to inactivity" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 760
DIVI4
ARGI4
ADDRGP4 $190
ARGP4
ADDRGP4 trap_DropClient
CALLV
pop
line 358
;358:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $173
JUMPV
LABELV $187
line 360
;359:		}
;360:		if ( level.time > client->inactivityTime - 10000 && !client->inactivityWarning ) {
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 level+32
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 684
ADDP4
INDIRI4
CNSTI4 10000
SUBI4
LEI4 $191
ADDRLP4 8
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
CNSTI4 0
NEI4 $191
line 361
;361:			client->inactivityWarning = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
CNSTI4 1
ASGNI4
line 362
;362:			trap_SendServerCommand( client - level.clients, "cp \"Ten seconds until inactivity drop!\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 760
DIVI4
ARGI4
ADDRGP4 $194
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 363
;363:		}
LABELV $191
line 364
;364:	}
LABELV $185
LABELV $179
LABELV $175
line 365
;365:	return qtrue;
CNSTI4 1
RETI4
LABELV $173
endproc ClientInactivityTimer 12 8
export ClientTimerActions
proc ClientTimerActions 20 12
line 375
;366:}
;367:
;368:/*
;369:==================
;370:ClientTimerActions
;371:
;372:Actions that happen once a second
;373:==================
;374:*/
;375:void ClientTimerActions( gentity_t *ent, int msec ) {
line 378
;376:	gclient_t *client;
;377:
;378:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 379
;379:	client->timeResidual += msec;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
ADDRFP4 4
INDIRI4
ADDI4
ASGNI4
ADDRGP4 $197
JUMPV
LABELV $196
line 381
;380:
;381:	while ( client->timeResidual >= 1000 ) {
line 382
;382:		client->timeResidual -= 1000;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1000
SUBI4
ASGNI4
line 385
;383:
;384:		// regenerate
;385:		if ( client->ps.powerups[PW_REGEN] ) {
ADDRLP4 0
INDIRP4
CNSTI4 332
ADDP4
INDIRI4
CNSTI4 0
EQI4 $199
line 386
;386:			if ( ent->health < client->ps.stats[STAT_MAX_HEALTH]) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
GEI4 $201
line 387
;387:				ent->health += 15;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 15
ADDI4
ASGNI4
line 388
;388:				if ( ent->health > client->ps.stats[STAT_MAX_HEALTH] * 1.1 ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1066192077
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CVIF4 4
MULF4
LEF4 $203
line 389
;389:					ent->health = client->ps.stats[STAT_MAX_HEALTH] * 1.1;
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
CNSTF4 1066192077
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 390
;390:				}
LABELV $203
line 391
;391:				G_AddEvent( ent, EV_POWERUP_REGEN, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 61
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 392
;392:			} else if ( ent->health < client->ps.stats[STAT_MAX_HEALTH] * 2) {
ADDRGP4 $200
JUMPV
LABELV $201
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
LSHI4
GEI4 $200
line 393
;393:				ent->health += 5;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 5
ADDI4
ASGNI4
line 394
;394:				if ( ent->health > client->ps.stats[STAT_MAX_HEALTH] * 2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
LSHI4
LEI4 $207
line 395
;395:					ent->health = client->ps.stats[STAT_MAX_HEALTH] * 2;
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ASGNI4
line 396
;396:				}
LABELV $207
line 397
;397:				G_AddEvent( ent, EV_POWERUP_REGEN, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 61
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 398
;398:			}
line 399
;399:		} else {
ADDRGP4 $200
JUMPV
LABELV $199
line 401
;400:			// count down health when over max
;401:			if ( ent->health > client->ps.stats[STAT_MAX_HEALTH] ) {
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
LEI4 $209
line 402
;402:				ent->health--;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 712
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 403
;403:			}
LABELV $209
line 404
;404:		}
LABELV $200
line 407
;405:
;406:		// count down armor when over max
;407:		if ( client->ps.stats[STAT_ARMOR] > client->ps.stats[STAT_MAX_HEALTH] ) {
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
LEI4 $211
line 408
;408:			client->ps.stats[STAT_ARMOR]--;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 409
;409:		}
LABELV $211
line 411
;410:
;411:	}
LABELV $197
line 381
ADDRLP4 0
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
CNSTI4 1000
GEI4 $196
line 412
;412:}
LABELV $195
endproc ClientTimerActions 20 12
export ClientIntermissionThink
proc ClientIntermissionThink 28 0
line 419
;413:
;414:/*
;415:====================
;416:ClientIntermissionThink
;417:====================
;418:*/
;419:void ClientIntermissionThink( gclient_t *client ) {
line 420
;420:	client->ps.eFlags &= ~EF_TALK;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -4097
BANDI4
ASGNI4
line 421
;421:	client->ps.eFlags &= ~EF_FIRING;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -257
BANDI4
ASGNI4
line 426
;422:
;423:	// the level will exit when everyone wants to or after timeouts
;424:
;425:	// swap and latch button actions
;426:	client->oldbuttons = client->buttons;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 632
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ASGNI4
line 427
;427:	client->buttons = client->pers.cmd.buttons;
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 628
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 452
ADDP4
INDIRU1
CVUI4 1
ASGNI4
line 428
;428:	if ( client->buttons & ( BUTTON_ATTACK | BUTTON_USE_HOLDABLE ) & ( client->oldbuttons ^ client->buttons ) ) {
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 5
BANDI4
ADDRLP4 16
INDIRP4
CNSTI4 632
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
BXORI4
BANDI4
CNSTI4 0
EQI4 $214
line 429
;429:		client->readyToExit ^= 1;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 616
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 430
;430:	}
LABELV $214
line 431
;431:}
LABELV $213
endproc ClientIntermissionThink 28 0
export ClientEvents
proc ClientEvents 108 32
line 442
;432:
;433:
;434:/*
;435:================
;436:ClientEvents
;437:
;438:Events will be passed on to the clients for presentation,
;439:but any server game effects are handled here
;440:================
;441:*/
;442:void ClientEvents( gentity_t *ent, int oldEventSequence ) {
line 453
;443:	int		i;
;444:	int		event;
;445:	gclient_t *client;
;446:	int		damage;
;447:	vec3_t	dir;
;448:	vec3_t	origin, angles;
;449://	qboolean	fired;
;450:	gitem_t *item;
;451:	gentity_t *drop;
;452:
;453:	client = ent->client;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 455
;454:
;455:	if ( oldEventSequence < client->ps.eventSequence - MAX_PS_EVENTS ) {
ADDRFP4 4
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 2
SUBI4
GEI4 $217
line 456
;456:		oldEventSequence = client->ps.eventSequence - MAX_PS_EVENTS;
ADDRFP4 4
ADDRLP4 8
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 2
SUBI4
ASGNI4
line 457
;457:	}
LABELV $217
line 458
;458:	for ( i = oldEventSequence ; i < client->ps.eventSequence ; i++ ) {
ADDRLP4 0
ADDRFP4 4
INDIRI4
ASGNI4
ADDRGP4 $222
JUMPV
LABELV $219
line 459
;459:		event = client->ps.events[ i & (MAX_PS_EVENTS-1) ];
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 2
LSHI4
ADDRLP4 8
INDIRP4
CNSTI4 112
ADDP4
ADDP4
INDIRI4
ASGNI4
line 461
;460:
;461:		switch ( event ) {
ADDRLP4 64
CNSTI4 10
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 64
INDIRI4
EQI4 $225
ADDRLP4 4
INDIRI4
CNSTI4 11
EQI4 $228
ADDRLP4 4
INDIRI4
CNSTI4 12
EQI4 $228
ADDRLP4 4
INDIRI4
ADDRLP4 64
INDIRI4
LTI4 $224
LABELV $257
ADDRLP4 4
INDIRI4
CNSTI4 23
EQI4 $244
ADDRLP4 4
INDIRI4
CNSTI4 25
EQI4 $245
ADDRLP4 4
INDIRI4
CNSTI4 26
EQI4 $255
ADDRGP4 $224
JUMPV
LABELV $225
line 463
;462:		case EV_FALL_SHORT:
;463:			if(ent->client->bleeding <= 0 && ent->client->ps.stats[STAT_LEG_DAMAGE] <= 0)
ADDRLP4 72
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 720
ADDP4
INDIRF4
CNSTF4 0
GTF4 $226
ADDRLP4 72
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 0
GTI4 $226
line 464
;464:				break;
ADDRGP4 $224
JUMPV
LABELV $226
LABELV $228
line 467
;465:		case EV_FALL_MEDIUM:
;466:		case EV_FALL_FAR:
;467:			if ( ent->s.eType != ET_PLAYER ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 1
EQI4 $229
line 468
;468:				break;		// not in the player model
ADDRGP4 $224
JUMPV
LABELV $229
line 470
;469:			}
;470:			if ( g_dmflags.integer & DF_NO_FALLING ) {
ADDRGP4 g_dmflags+12
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $231
line 471
;471:				break;
ADDRGP4 $224
JUMPV
LABELV $231
line 473
;472:			}
;473:			if ( event == EV_FALL_FAR ) {
ADDRLP4 4
INDIRI4
CNSTI4 12
NEI4 $234
line 474
;474:				damage = 10;
ADDRLP4 28
CNSTI4 10
ASGNI4
line 475
;475:			} else if ( event == EV_FALL_MEDIUM ) {
ADDRGP4 $235
JUMPV
LABELV $234
ADDRLP4 4
INDIRI4
CNSTI4 11
NEI4 $236
line 476
;476:				damage = 5;
ADDRLP4 28
CNSTI4 5
ASGNI4
line 477
;477:			}
ADDRGP4 $237
JUMPV
LABELV $236
line 479
;478:			else
;479:			{
line 480
;480:				damage = 2;
ADDRLP4 28
CNSTI4 2
ASGNI4
line 481
;481:			}
LABELV $237
LABELV $235
line 482
;482:			VectorSet (dir, 0, 0, 1);
ADDRLP4 76
CNSTF4 0
ASGNF4
ADDRLP4 16
ADDRLP4 76
INDIRF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 76
INDIRF4
ASGNF4
ADDRLP4 16+8
CNSTF4 1065353216
ASGNF4
line 483
;483:			ent->pain_debounce_time = level.time + 200;	// no normal pain sound
ADDRFP4 0
INDIRP4
CNSTI4 700
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 484
;484:			G_Damage (ent, NULL, NULL, NULL, NULL, damage, DAMAGE_NO_BLEEDING, MOD_FALLING);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 80
CNSTP4 0
ASGNP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 84
CNSTP4 0
ASGNP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 28
INDIRI4
ARGI4
CNSTI4 16
ARGI4
CNSTI4 19
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 485
;485:			if(ent->client->bleeding || ent->client->ps.stats[STAT_LEG_DAMAGE])
ADDRLP4 88
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTI4 720
ADDP4
INDIRF4
CNSTF4 0
NEF4 $243
ADDRLP4 88
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 0
EQI4 $224
LABELV $243
line 486
;486:				G_Damage (ent, ent, ent->enemy, NULL, NULL, (int) ((ent->client->bleeding + ent->client->ps.stats[STAT_LEG_DAMAGE] * 1.0 / ent->client->pers.maxHealth) * damage), DAMAGE_NO_ARMOR, MOD_BLEED);
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
ARGP4
ADDRLP4 96
CNSTP4 0
ASGNP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 100
ADDRLP4 92
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 100
INDIRP4
CNSTI4 720
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRLP4 100
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDRLP4 100
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
CVIF4 4
DIVF4
ADDF4
ADDRLP4 28
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ARGI4
CNSTI4 2
ARGI4
CNSTI4 24
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 487
;487:			break;
ADDRGP4 $224
JUMPV
LABELV $244
line 490
;488:
;489:		case EV_FIRE_WEAPON:
;490:			FireWeapon( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 FireWeapon
CALLV
pop
line 491
;491:			break;
ADDRGP4 $224
JUMPV
LABELV $245
line 495
;492:
;493:		case EV_USE_ITEM1:		// teleporter
;494:			// drop flags in CTF
;495:			item = NULL;
ADDRLP4 12
CNSTP4 0
ASGNP4
line 497
;496:
;497:			if ( ent->client->ps.powerups[ PW_REDFLAG ] ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 0
EQI4 $246
line 498
;498:				item = BG_FindItemForPowerup( PW_REDFLAG );
CNSTI4 7
ARGI4
ADDRLP4 104
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 104
INDIRP4
ASGNP4
line 499
;499:				i = PW_REDFLAG;
ADDRLP4 0
CNSTI4 7
ASGNI4
line 500
;500:			} else if ( ent->client->ps.powerups[ PW_BLUEFLAG ] ) {
ADDRGP4 $247
JUMPV
LABELV $246
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 344
ADDP4
INDIRI4
CNSTI4 0
EQI4 $248
line 501
;501:				item = BG_FindItemForPowerup( PW_BLUEFLAG );
CNSTI4 8
ARGI4
ADDRLP4 104
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 104
INDIRP4
ASGNP4
line 502
;502:				i = PW_BLUEFLAG;
ADDRLP4 0
CNSTI4 8
ASGNI4
line 503
;503:			}
LABELV $248
LABELV $247
line 505
;504:
;505:			if ( item ) {
ADDRLP4 12
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $250
line 506
;506:				drop = Drop_Item( ent, item, 0 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
CNSTF4 0
ARGF4
ADDRLP4 104
ADDRGP4 Drop_Item
CALLP4
ASGNP4
ADDRLP4 56
ADDRLP4 104
INDIRP4
ASGNP4
line 508
;507:				// decide how many seconds it has left
;508:				drop->count = ( ent->client->ps.powerups[ i ] - level.time ) / 1000;
ADDRLP4 56
INDIRP4
CNSTI4 740
ADDP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
SUBI4
CNSTI4 1000
DIVI4
ASGNI4
line 509
;509:				if ( drop->count < 1 ) {
ADDRLP4 56
INDIRP4
CNSTI4 740
ADDP4
INDIRI4
CNSTI4 1
GEI4 $253
line 510
;510:					drop->count = 1;
ADDRLP4 56
INDIRP4
CNSTI4 740
ADDP4
CNSTI4 1
ASGNI4
line 511
;511:				}
LABELV $253
line 513
;512:
;513:				ent->client->ps.powerups[ i ] = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
CNSTI4 0
ASGNI4
line 514
;514:			}
LABELV $250
line 516
;515:
;516:			SelectSpawnPoint( ent->client->ps.origin, origin, angles );
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 32
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 SelectSpawnPoint
CALLP4
pop
line 517
;517:			TeleportPlayer( ent, origin, angles );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 32
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 TeleportPlayer
CALLV
pop
line 518
;518:			break;
ADDRGP4 $224
JUMPV
LABELV $255
line 521
;519:
;520:		case EV_USE_ITEM2:		// medkit
;521:			ent->health = ent->client->ps.stats[STAT_MAX_HEALTH];
ADDRLP4 104
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 104
INDIRP4
CNSTI4 712
ADDP4
ADDRLP4 104
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
ASGNI4
line 522
;522:			ent->client->bleeding = 0;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 720
ADDP4
CNSTF4 0
ASGNF4
line 523
;523:			ent->client->bleed_damage = 0;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 724
ADDP4
CNSTF4 0
ASGNF4
line 524
;524:			ent->client->bleedtime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 716
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 525
;525:			break;
line 528
;526:
;527:		default:
;528:			break;
LABELV $224
line 530
;529:		}
;530:	}
LABELV $220
line 458
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $222
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
LTI4 $219
line 532
;531:
;532:}
LABELV $216
endproc ClientEvents 108 32
data
align 4
LABELV $259
byte 4 0
byte 4 22
byte 4 45
byte 4 -22
byte 4 0
byte 4 22
byte 4 -45
byte 4 -22
code
proc G_PlayerAngles 216 16
line 550
;533:
;534:void BotTestSolid(vec3_t origin);
;535:
;536:/*
;537:==============
;538:ClientThink
;539:
;540:This will be called once for each client frame, which will
;541:usually be a couple times for each server frame on fast clients.
;542:
;543:If "g_syncronousClients 1" is set, this will be called exactly
;544:once for each server frame, which makes for smooth demo recording.
;545:==============
;546:*/
;547:void TossClientWeapon(gentity_t *self, int weapon);
;548:
;549:
;550:static float G_PlayerAngles(gclient_t *client, vec3_t muzzle, vec3_t headpoint ) {
line 551
;551:	playerState_t *ps = &client->ps;
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
line 552
;552:	clientPersistant_t *pers = &client->pers;
ADDRLP4 80
ADDRFP4 0
INDIRP4
CNSTI4 444
ADDP4
ASGNP4
line 563
;553:	vec3_t		legsAngles, torsoAngles, headAngles;
;554:	//vec3_t		legs[3], torso[3], head[3];
;555:	vec3_t		waistpoint, neckpoint, gunpoint;
;556:	vec3_t		forward, right, up;
;557:	float		dest, *tempv;
;558:	static	int	movementOffsets[8] = { 0, 22, 45, -22, 0, 22, -45, -22 };
;559:	vec3_t		velocity;
;560:	float		speed;
;561:	int			dir;
;562:	
;563:	if((ps->eFlags & EF_DEAD) || (pers->playerclass < 0) || (pers->playerclass >= p_classes))
ADDRLP4 144
CNSTI4 0
ASGNI4
ADDRLP4 52
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 1
BANDI4
ADDRLP4 144
INDIRI4
NEI4 $263
ADDRLP4 148
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ASGNI4
ADDRLP4 148
INDIRI4
ADDRLP4 144
INDIRI4
LTI4 $263
ADDRLP4 148
INDIRI4
ADDRGP4 p_classes
INDIRI4
LTI4 $260
LABELV $263
line 564
;564:	{
line 565
;565:		muzzle[0] = 443556;
ADDRFP4 4
INDIRP4
CNSTF4 1222153344
ASGNF4
line 566
;566:		return 0; // dead players don't matter.
CNSTF4 0
RETF4
ADDRGP4 $258
JUMPV
LABELV $260
line 571
;567:	}
;568:	
;569:	
;570:
;571:	VectorCopy( ps->viewangles, headAngles );
ADDRLP4 56
ADDRLP4 52
INDIRP4
CNSTI4 152
ADDP4
INDIRB
ASGNB 12
line 572
;572:	headAngles[YAW] = AngleMod( headAngles[YAW] );
ADDRLP4 56+4
INDIRF4
ARGF4
ADDRLP4 152
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 56+4
ADDRLP4 152
INDIRF4
ASGNF4
line 573
;573:	VectorClear( legsAngles );
ADDRLP4 156
CNSTF4 0
ASGNF4
ADDRLP4 68+8
ADDRLP4 156
INDIRF4
ASGNF4
ADDRLP4 68+4
ADDRLP4 156
INDIRF4
ASGNF4
ADDRLP4 68
ADDRLP4 156
INDIRF4
ASGNF4
line 574
;574:	VectorClear( torsoAngles );
ADDRLP4 160
CNSTF4 0
ASGNF4
ADDRLP4 84+8
ADDRLP4 160
INDIRF4
ASGNF4
ADDRLP4 84+4
ADDRLP4 160
INDIRF4
ASGNF4
ADDRLP4 84
ADDRLP4 160
INDIRF4
ASGNF4
line 579
;575:
;576:	// --------- yaw -------------
;577:
;578:	// allow yaw to drift a bit
;579:	if ( ( ps->legsAnim & ~ANIM_TOGGLEBIT ) != LEGS_IDLE 
ADDRLP4 168
CNSTI4 -129
ASGNI4
ADDRLP4 52
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
ADDRLP4 168
INDIRI4
BANDI4
CNSTI4 22
NEI4 $272
ADDRLP4 52
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDRLP4 168
INDIRI4
BANDI4
CNSTI4 11
EQI4 $270
LABELV $272
line 580
;580:		|| ( ps->torsoAnim & ~ANIM_TOGGLEBIT ) != TORSO_STAND  ) {
line 583
;581:		// if not standing still, always point all in the same direction
;582:
;583:	}
LABELV $270
line 586
;584:
;585:	// adjust legs for movement dir
;586:	if ( ps->eFlags & EF_DEAD ) {
ADDRLP4 52
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $273
line 588
;587:		// don't let dead bodies twitch
;588:		dir = 0;
ADDRLP4 136
CNSTI4 0
ASGNI4
line 589
;589:	} 
ADDRGP4 $274
JUMPV
LABELV $273
line 591
;590:	else 
;591:	{
line 592
;592:		dir = ps->movementDir & 7;
ADDRLP4 136
ADDRLP4 52
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
CNSTI4 7
BANDI4
ASGNI4
line 593
;593:	}
LABELV $274
line 594
;594:	legsAngles[YAW] = headAngles[YAW] + movementOffsets[ dir ];
ADDRLP4 68+4
ADDRLP4 56+4
INDIRF4
ADDRLP4 136
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $259
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 595
;595:	torsoAngles[YAW] = headAngles[YAW] + 0.25 * movementOffsets[ dir ];
ADDRLP4 84+4
ADDRLP4 56+4
INDIRF4
CNSTF4 1048576000
ADDRLP4 136
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $259
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 601
;596:
;597:
;598:	// --------- pitch -------------
;599:
;600:	// only show a fraction of the pitch angle in the torso
;601:	if ( headAngles[PITCH] > 180 ) {
ADDRLP4 56
INDIRF4
CNSTF4 1127481344
LEF4 $279
line 602
;602:		dest = (-360 + headAngles[PITCH]) * 0.75;
ADDRLP4 140
CNSTF4 1061158912
ADDRLP4 56
INDIRF4
CNSTF4 3283353600
ADDF4
MULF4
ASGNF4
line 603
;603:	} else {
ADDRGP4 $280
JUMPV
LABELV $279
line 604
;604:		dest = headAngles[PITCH] * 0.75;
ADDRLP4 140
CNSTF4 1061158912
ADDRLP4 56
INDIRF4
MULF4
ASGNF4
line 605
;605:	}
LABELV $280
line 606
;606:	torsoAngles[PITCH] = dest;
ADDRLP4 84
ADDRLP4 140
INDIRF4
ASGNF4
line 613
;607:
;608:	// --------- roll -------------
;609:
;610:
;611:	// lean towards the direction of travel
;612:	
;613:	VectorCopy( ps->velocity, velocity );
ADDRLP4 108
ADDRLP4 52
INDIRP4
CNSTI4 32
ADDP4
INDIRB
ASGNB 12
line 614
;614:	speed = VectorNormalize( velocity );
ADDRLP4 108
ARGP4
ADDRLP4 172
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 132
ADDRLP4 172
INDIRF4
ASGNF4
line 615
;615:	if ( speed ) {
ADDRLP4 132
INDIRF4
CNSTF4 0
EQF4 $281
line 619
;616:		vec3_t	axis[3];
;617:		float	side;
;618:
;619:		speed *= 0.05;
ADDRLP4 132
CNSTF4 1028443341
ADDRLP4 132
INDIRF4
MULF4
ASGNF4
line 621
;620:
;621:		AnglesToAxis( legsAngles, axis );
ADDRLP4 68
ARGP4
ADDRLP4 176
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 622
;622:		side = speed * DotProduct( velocity, axis[1] );
ADDRLP4 212
ADDRLP4 132
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 176+12
INDIRF4
MULF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 176+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 176+12+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
line 623
;623:		legsAngles[ROLL] -= side;
ADDRLP4 68+8
ADDRLP4 68+8
INDIRF4
ADDRLP4 212
INDIRF4
SUBF4
ASGNF4
line 625
;624:
;625:		side = speed * DotProduct( velocity, axis[0] );
ADDRLP4 212
ADDRLP4 132
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 176
INDIRF4
MULF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 176+4
INDIRF4
MULF4
ADDF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 176+8
INDIRF4
MULF4
ADDF4
MULF4
ASGNF4
line 626
;626:		legsAngles[PITCH] += side;
ADDRLP4 68
ADDRLP4 68
INDIRF4
ADDRLP4 212
INDIRF4
ADDF4
ASGNF4
line 627
;627:	}
LABELV $281
line 631
;628:
;629:	
;630:	
;631:	if(ps->pm_flags & PMF_DUCKED)
ADDRLP4 52
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $295
line 632
;632:		tempv = p_class[pers->playerclass].crouch;
ADDRLP4 0
CNSTI4 168
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+84
ADDP4
ASGNP4
ADDRGP4 $296
JUMPV
LABELV $295
line 633
;633:	else if(ps->groundEntityNum == ENTITYNUM_NONE)
ADDRLP4 52
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $298
line 634
;634:		tempv = p_class[pers->playerclass].jump;
ADDRLP4 0
CNSTI4 168
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+132
ADDP4
ASGNP4
ADDRGP4 $299
JUMPV
LABELV $298
line 636
;635:	else
;636:		tempv = p_class[pers->playerclass].stand;
ADDRLP4 0
CNSTI4 168
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+96
ADDP4
ASGNP4
LABELV $299
LABELV $296
line 637
;637:	AngleVectors(legsAngles, forward, right, up);
ADDRLP4 68
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 16
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 639
;638:
;639:	waistpoint[0] = tempv[0] * forward[0] + tempv[1] * right[0] + tempv[2] * up[0];
ADDRLP4 40
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 640
;640:	waistpoint[1] = tempv[0] * forward[1] + tempv[1] * right[1] + tempv[2] * up[1];
ADDRLP4 40+4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 641
;641:	waistpoint[2] = tempv[0] * forward[2] + tempv[1] * right[2] + tempv[2] * up[2];
ADDRLP4 40+8
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28+8
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 643
;642:	
;643:	AngleVectors(torsoAngles, forward, right, up);
ADDRLP4 84
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 16
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 645
;644:
;645:	tempv = p_class[pers->playerclass].head;
ADDRLP4 0
CNSTI4 168
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+144
ADDP4
ASGNP4
line 646
;646:	neckpoint[0] = waistpoint[0] + tempv[0] * forward[0] + tempv[1] * right[0] + tempv[2] * up[0];
ADDRLP4 120
ADDRLP4 40
INDIRF4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 647
;647:	neckpoint[1] = waistpoint[1] + tempv[0] * forward[1] + tempv[1] * right[1] + tempv[2] * up[1];
ADDRLP4 120+4
ADDRLP4 40+4
INDIRF4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 648
;648:	neckpoint[2] = waistpoint[2] + tempv[0] * forward[2] + tempv[1] * right[2] + tempv[2] * up[2];
ADDRLP4 120+8
ADDRLP4 40+8
INDIRF4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28+8
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 650
;649:	
;650:	tempv = p_class[pers->playerclass].gun;
ADDRLP4 0
CNSTI4 168
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+156
ADDP4
ASGNP4
line 651
;651:	gunpoint[0] = waistpoint[0] + tempv[0] * forward[0] + tempv[1] * right[0] + tempv[2] * up[0];
ADDRLP4 96
ADDRLP4 40
INDIRF4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 652
;652:	gunpoint[1] = waistpoint[1] + tempv[0] * forward[1] + tempv[1] * right[1] + tempv[2] * up[1];
ADDRLP4 96+4
ADDRLP4 40+4
INDIRF4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 653
;653:	gunpoint[2] = waistpoint[2] + tempv[0] * forward[2] + tempv[1] * right[2] + tempv[2] * up[2];
ADDRLP4 96+8
ADDRLP4 40+8
INDIRF4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 28+8
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 655
;654:	
;655:	AngleVectors(headAngles, forward, right, up);
ADDRLP4 56
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 16
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 657
;656:	
;657:	if(client->ps.stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER)
ADDRFP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $332
line 658
;658:	{
line 659
;659:	}
ADDRGP4 $333
JUMPV
LABELV $332
line 661
;660:	else
;661:	{
line 662
;662:		headpoint[0] = neckpoint[0] + up[0] * 4;
ADDRFP4 8
INDIRP4
ADDRLP4 120
INDIRF4
CNSTF4 1082130432
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 663
;663:		headpoint[1] = neckpoint[1] + up[1] * 4;
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 120+4
INDIRF4
CNSTF4 1082130432
ADDRLP4 16+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 664
;664:		headpoint[2] = neckpoint[2] + up[2] * 4;
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 120+8
INDIRF4
CNSTF4 1082130432
ADDRLP4 16+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 665
;665:	}
LABELV $333
line 666
;666:	muzzle[0] = gunpoint[0] + forward[0] * 8;
ADDRFP4 4
INDIRP4
ADDRLP4 96
INDIRF4
CNSTF4 1090519040
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ASGNF4
line 667
;667:	muzzle[1] = gunpoint[1] + forward[1] * 8;
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 96+4
INDIRF4
CNSTF4 1090519040
ADDRLP4 4+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 668
;668:	muzzle[2] = gunpoint[2] + forward[2] * 8;
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 96+8
INDIRF4
CNSTF4 1090519040
ADDRLP4 4+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 671
;669:	
;670:	//G_Printf("legyaw: %f torsoyaw: %f headyaw: %f\n", legsAngles[YAW], torsoAngles[YAW], headAngles[YAW]);
;671:	return waistpoint[2];
ADDRLP4 40+8
INDIRF4
RETF4
LABELV $258
endproc G_PlayerAngles 216 16
export ClientThink_real
proc ClientThink_real 372 32
line 676
;672:}
;673:
;674:void G_ExplodeMissile( gentity_t *ent );
;675:
;676:void ClientThink_real( gentity_t *ent ) {
line 683
;677:	gclient_t	*client;
;678:	pmove_t		pm;
;679:	vec3_t		oldOrigin;
;680:	int			oldEventSequence;
;681:	int			msec;
;682:	usercmd_t	*ucmd;
;683:	float jumpheight = 64.0;
ADDRLP4 248
CNSTF4 1115684864
ASGNF4
line 685
;684:
;685:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
line 686
;686:	if(!g_allowArmor.integer)
ADDRGP4 g_allowArmor+12
INDIRI4
CNSTI4 0
NEI4 $344
line 687
;687:		client->ps.stats[STAT_ARMOR] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
CNSTI4 0
ASGNI4
LABELV $344
line 690
;688:	
;689:	// mark the time, so the connection sprite can be removed
;690:	ucmd = &ent->client->pers.cmd;
ADDRLP4 224
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 448
ADDP4
ASGNP4
line 693
;691:
;692:	// sanity check the command time to prevent speedup cheating
;693:	if ( ucmd->serverTime > level.time + 200 ) {
ADDRLP4 224
INDIRP4
INDIRI4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
LEI4 $347
line 694
;694:		ucmd->serverTime = level.time + 200;
ADDRLP4 224
INDIRP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 696
;695://		G_Printf("serverTime <<<<<\n" );
;696:	}
LABELV $347
line 697
;697:	if ( ucmd->serverTime < level.time - 1000 ) {
ADDRLP4 224
INDIRP4
INDIRI4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
SUBI4
GEI4 $351
line 698
;698:		ucmd->serverTime = level.time - 1000;
ADDRLP4 224
INDIRP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
SUBI4
ASGNI4
line 700
;699://		G_Printf("serverTime >>>>>\n" );
;700:	} 
LABELV $351
line 702
;701:
;702:	msec = ucmd->serverTime - client->ps.commandTime;
ADDRLP4 228
ADDRLP4 224
INDIRP4
INDIRI4
ADDRLP4 0
INDIRP4
INDIRI4
SUBI4
ASGNI4
line 705
;703:	// following others may result in bad times, but we still want
;704:	// to check for follow toggles
;705:	if ( msec < 1 && client->sess.spectatorState != SPECTATOR_FOLLOW ) {
ADDRLP4 228
INDIRI4
CNSTI4 1
GEI4 $355
ADDRLP4 0
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 2
EQI4 $355
line 706
;706:		return;
ADDRGP4 $343
JUMPV
LABELV $355
line 708
;707:	}
;708:	if ( msec > 200 ) {
ADDRLP4 228
INDIRI4
CNSTI4 200
LEI4 $357
line 709
;709:		msec = 200;
ADDRLP4 228
CNSTI4 200
ASGNI4
line 710
;710:	}
LABELV $357
line 715
;711:
;712:	//
;713:	// check for exiting intermission
;714:	//
;715:	if ( level.intermissiontime ) {
ADDRGP4 level+4228
INDIRI4
CNSTI4 0
EQI4 $359
line 716
;716:		ClientIntermissionThink( client );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 ClientIntermissionThink
CALLV
pop
line 717
;717:		return;
ADDRGP4 $343
JUMPV
LABELV $359
line 721
;718:	}
;719:
;720:	// spectators don't do much
;721:	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 0
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $362
line 722
;722:		if ( client->sess.spectatorState == SPECTATOR_SCOREBOARD ) {
ADDRLP4 0
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 3
NEI4 $364
line 723
;723:			return;
ADDRGP4 $343
JUMPV
LABELV $364
line 725
;724:		}
;725:		SpectatorThink( ent, ucmd );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 224
INDIRP4
ARGP4
ADDRGP4 SpectatorThink
CALLV
pop
line 726
;726:		return;
ADDRGP4 $343
JUMPV
LABELV $362
line 730
;727:	}
;728:
;729:	// check for inactivity timer, but never drop the local client of a non-dedicated server
;730:	if ( !ClientInactivityTimer( client ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 252
ADDRGP4 ClientInactivityTimer
CALLI4
ASGNI4
ADDRLP4 252
INDIRI4
CNSTI4 0
NEI4 $366
line 731
;731:		return;
ADDRGP4 $343
JUMPV
LABELV $366
line 736
;732:	}
;733:
;734:	// clear the rewards if time
;735:	
;736:	if(ent->s.eFlags & EF_DEAD)
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $368
line 737
;737:	{
line 738
;738:		if(g_LudicrousGibs.integer)
ADDRGP4 g_LudicrousGibs+12
INDIRI4
CNSTI4 0
EQI4 $370
line 739
;739:			G_AddEvent( ent, EV_GIB_PLAYER, ent->enemy->s.number );
ADDRLP4 256
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 256
INDIRP4
ARGP4
CNSTI4 62
ARGI4
ADDRLP4 256
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
LABELV $370
line 741
;740:
;741:		client->ps.eFlags &= ~(EF_AWARD_IMPRESSIVE | EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET );
ADDRLP4 260
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 260
INDIRP4
ADDRLP4 260
INDIRP4
INDIRI4
CNSTI4 -32841
BANDI4
ASGNI4
line 742
;742:		ent->s.eFlags &= ~(EF_AWARD_IMPRESSIVE | EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET );
ADDRLP4 264
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 264
INDIRP4
ADDRLP4 264
INDIRP4
INDIRI4
CNSTI4 -32841
BANDI4
ASGNI4
line 743
;743:		if(client->headhit)
ADDRLP4 0
INDIRP4
CNSTI4 756
ADDP4
INDIRI4
CNSTI4 0
EQI4 $369
line 744
;744:		{
line 745
;745:			client->ps.eFlags |= EF_AWARD_IMPRESSIVE;
ADDRLP4 268
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 268
INDIRP4
ADDRLP4 268
INDIRP4
INDIRI4
CNSTI4 32768
BORI4
ASGNI4
line 746
;746:			ent->s.eFlags |= EF_AWARD_IMPRESSIVE;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 272
INDIRP4
ADDRLP4 272
INDIRP4
INDIRI4
CNSTI4 32768
BORI4
ASGNI4
line 747
;747:		}
line 750
;748:		
;749:		
;750:	}
ADDRGP4 $369
JUMPV
LABELV $368
line 751
;751:	else if ( level.time > client->rewardTime ) {
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 692
ADDP4
INDIRI4
LEI4 $375
line 752
;752:		client->ps.eFlags &= ~(EF_AWARD_IMPRESSIVE | EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET );
ADDRLP4 256
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 256
INDIRP4
ADDRLP4 256
INDIRP4
INDIRI4
CNSTI4 -32841
BANDI4
ASGNI4
line 753
;753:	}
LABELV $375
LABELV $369
line 755
;754:
;755:	if ( client->noclip ) {
ADDRLP4 0
INDIRP4
CNSTI4 620
ADDP4
INDIRI4
CNSTI4 0
EQI4 $378
line 756
;756:		client->ps.pm_type = PM_NOCLIP;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 1
ASGNI4
line 757
;757:	} else if ( client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 $379
JUMPV
LABELV $378
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $380
line 758
;758:		client->ps.pm_type = PM_DEAD;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 759
;759:	} else {
ADDRGP4 $381
JUMPV
LABELV $380
line 760
;760:		client->ps.pm_type = PM_NORMAL;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 761
;761:	}
LABELV $381
LABELV $379
line 763
;762:
;763:	client->ps.gravity = g_gravity.value;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDRGP4 g_gravity+8
INDIRF4
CVFI4 4
ASGNI4
line 764
;764:	if(ucmd->upmove > 0 && client->pers.playerclass >= 0 && client->pers.playerclass < p_classes)
ADDRLP4 256
CNSTI4 0
ASGNI4
ADDRLP4 224
INDIRP4
CNSTI4 22
ADDP4
INDIRI1
CVII4 1
ADDRLP4 256
INDIRI4
LEI4 $383
ADDRLP4 260
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 260
INDIRI4
ADDRLP4 256
INDIRI4
LTI4 $383
ADDRLP4 260
INDIRI4
ADDRGP4 p_classes
INDIRI4
GEI4 $383
line 765
;765:		client->ps.gravity *= p_class[client->pers.playerclass].jumpgravity;
ADDRLP4 268
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ASGNP4
ADDRLP4 268
INDIRP4
ADDRLP4 268
INDIRP4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+52
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
LABELV $383
line 769
;766:
;767:	// set speed
;768:	
;769:	client->ps.stats[STAT_JUMPSCALE] = 270; // to make sure a default gets set
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
CNSTI4 270
ASGNI4
line 770
;770:	client->ps.stats[STAT_JUMP_PAUSE] = 250; // to make sure a default gets set
ADDRLP4 0
INDIRP4
CNSTI4 220
ADDP4
CNSTI4 250
ASGNI4
line 771
;771:	if(client->ps.stats[STAT_LEG_DAMAGE] > 0 && client->ps.stats[STAT_HEALTH] > 0)
ADDRLP4 276
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
ADDRLP4 276
INDIRI4
LEI4 $386
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ADDRLP4 276
INDIRI4
LEI4 $386
line 772
;772:	{		
line 773
;773:		client->ps.speed = g_speed.value * client->ps.stats[STAT_HEALTH] / (client->ps.stats[STAT_HEALTH] + client->ps.stats[STAT_LEG_DAMAGE]);
ADDRLP4 284
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRGP4 g_speed+8
INDIRF4
ADDRLP4 284
INDIRI4
CVIF4 4
MULF4
ADDRLP4 284
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
ADDI4
CVIF4 4
DIVF4
CVFI4 4
ASGNI4
line 774
;774:	}
ADDRGP4 $387
JUMPV
LABELV $386
line 776
;775:	else
;776:		client->ps.speed = g_speed.value;
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRGP4 g_speed+8
INDIRF4
CVFI4 4
ASGNI4
LABELV $387
line 778
;777:
;778:	if(client->pers.playerclass >= 0 && client->pers.playerclass < p_classes)
ADDRLP4 280
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
ADDRLP4 280
INDIRI4
CNSTI4 0
LTI4 $390
ADDRLP4 280
INDIRI4
ADDRGP4 p_classes
INDIRI4
GEI4 $390
line 779
;779:	{
line 780
;780:		int p = client->pers.playerclass;
ADDRLP4 284
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
ASGNI4
line 781
;781:		client->ps.stats[STAT_JUMP_PAUSE] = p_class[p].jumppause * 1000;
ADDRLP4 0
INDIRP4
CNSTI4 220
ADDP4
CNSTF4 1148846080
CNSTI4 168
ADDRLP4 284
INDIRI4
MULI4
ADDRGP4 p_class+44
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 782
;782:		if(client->ps.groundEntityNum == ENTITYNUM_NONE)
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $393
line 783
;783:		{
line 784
;784:			client->ps.speed *= p_class[p].jumpspeed;
ADDRLP4 288
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 288
INDIRP4
ADDRLP4 288
INDIRP4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRLP4 284
INDIRI4
MULI4
ADDRGP4 p_class+40
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 785
;785:		}
ADDRGP4 $394
JUMPV
LABELV $393
line 786
;786:		else if(ucmd->upmove < 0)
ADDRLP4 224
INDIRP4
CNSTI4 22
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
GEI4 $396
line 787
;787:		{
line 788
;788:			client->ps.speed *= p_class[p].crouchspeed;
ADDRLP4 288
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 288
INDIRP4
ADDRLP4 288
INDIRP4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRLP4 284
INDIRI4
MULI4
ADDRGP4 p_class+36
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 789
;789:		}
ADDRGP4 $397
JUMPV
LABELV $396
line 791
;790:		else
;791:		{
line 792
;792:			client->ps.speed *= p_class[p].speed;
ADDRLP4 288
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 288
INDIRP4
ADDRLP4 288
INDIRP4
INDIRI4
CVIF4 4
CNSTI4 168
ADDRLP4 284
INDIRI4
MULI4
ADDRGP4 p_class+32
ADDP4
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 793
;793:		}
LABELV $397
LABELV $394
line 794
;794:		if(client->ps.stats[STAT_LEG_DAMAGE] > 0 && client->ps.stats[STAT_HEALTH] > 0)
ADDRLP4 292
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
ADDRLP4 292
INDIRI4
LEI4 $400
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ADDRLP4 292
INDIRI4
LEI4 $400
line 795
;795:		{			
line 796
;796:			client->ps.stats[STAT_JUMPSCALE] = 270 * sqrt(p_class[client->pers.playerclass].jumpfactor) * client->ps.stats[STAT_HEALTH] / (client->ps.stats[STAT_HEALTH] + client->ps.stats[STAT_LEG_DAMAGE] + 0.01);
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+48
ADDP4
INDIRF4
ARGF4
ADDRLP4 300
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 308
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
CNSTF4 1132920832
ADDRLP4 300
INDIRF4
MULF4
ADDRLP4 308
INDIRI4
CVIF4 4
MULF4
ADDRLP4 308
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
ADDI4
CVIF4 4
CNSTF4 1008981770
ADDF4
DIVF4
CVFI4 4
ASGNI4
line 797
;797:		}
ADDRGP4 $391
JUMPV
LABELV $400
line 799
;798:		else
;799:			client->ps.stats[STAT_JUMPSCALE] = 270 * sqrt(p_class[client->pers.playerclass].jumpfactor);
CNSTI4 168
ADDRLP4 0
INDIRP4
CNSTI4 584
ADDP4
INDIRI4
MULI4
ADDRGP4 p_class+48
ADDP4
INDIRF4
ARGF4
ADDRLP4 300
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
CNSTF4 1132920832
ADDRLP4 300
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 800
;800:	}
ADDRGP4 $391
JUMPV
LABELV $390
line 801
;801:	else if(g_PlayerClasses.integer == 2) // force classes, and this isn't a valid class.
ADDRGP4 g_PlayerClasses+12
INDIRI4
CNSTI4 2
NEI4 $404
line 802
;802:	{	// turn into a spectator
line 803
;803:		StopFollowing(ent); 
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 StopFollowing
CALLV
pop
line 805
;804:		
;805:	}
LABELV $404
LABELV $391
line 807
;806:	
;807:	if(client->ps.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS) 
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $407
line 808
;808:	{ // one weapon mode gives speed bonus/penalty based on weapon 
line 809
;809:		float mass = client->ps.stats[STAT_MASS];
ADDRLP4 284
ADDRLP4 0
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 810
;810:		if(mass != 0)
ADDRLP4 284
INDIRF4
CNSTF4 0
EQF4 $409
line 811
;811:		{		
line 812
;812:			mass += BG_FindItemForWeapon(client->ps.weapon)->mass;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ARGI4
ADDRLP4 288
ADDRGP4 BG_FindItemForWeapon
CALLP4
ASGNP4
ADDRLP4 284
ADDRLP4 284
INDIRF4
ADDRLP4 288
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 815
;813:			//if(client->ps.stats[STAT_HOLDABLE_ITEM])
;814:			//	mass += BG_FindItemForHoldable(client->ps.stats[STAT_HOLDABLE_ITEM])->mass;
;815:			client->ps.speed *= client->ps.stats[STAT_MASS] / mass;			
ADDRLP4 296
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 296
INDIRP4
ADDRLP4 296
INDIRP4
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 284
INDIRF4
DIVF4
MULF4
CVFI4 4
ASGNI4
line 816
;816:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(client->ps.stats[STAT_MASS] / mass);
ADDRLP4 0
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 284
INDIRF4
DIVF4
ARGF4
ADDRLP4 304
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 308
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
ASGNP4
ADDRLP4 308
INDIRP4
ADDRLP4 308
INDIRP4
INDIRI4
CVIF4 4
ADDRLP4 304
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 817
;817:		}
LABELV $409
line 864
;818:
;819:		/*switch(client->ps.weapon)
;820:		{
;821:		case WP_NONE:
;822:			//client->ps.speed *= 1.25;
;823:			//client->ps.stats[STAT_JUMPSCALE] *= 1.1;
;824:			break;
;825:		case WP_GAUNTLET:
;826:			client->ps.speed *= mass / (mass + 10.0);
;827:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 10.0));
;828:			break;
;829:		case WP_MACHINEGUN:
;830:			client->ps.speed *= mass / (mass + 25.0);
;831:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 25.0));
;832:			break;
;833:		case WP_SHOTGUN:
;834:			client->ps.speed *= mass / (mass + 20.0);
;835:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 20.0));
;836:			break;
;837:		case WP_GRENADE_LAUNCHER:
;838:			client->ps.speed *= mass / (mass + 15.0);
;839:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 15.0));
;840:			break;
;841:		case WP_ROCKET_LAUNCHER:
;842:			client->ps.speed *= mass / (mass + 60.0);
;843:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 60.0));
;844:			break;
;845:		case WP_LIGHTNING:
;846:			client->ps.speed *= mass / (mass + 50.0);
;847:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 50.0));
;848:			break;
;849:		case WP_RAILGUN:
;850:			client->ps.speed *= mass / (mass + 30.0);
;851:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 30.0));
;852:			break;
;853:		case WP_PLASMAGUN:
;854:			client->ps.speed *= mass / (mass + 40.0);
;855:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 40.0));
;856:			break;
;857:		case WP_BFG:
;858:			client->ps.speed *= mass / (mass + 100.0);
;859:			client->ps.stats[STAT_JUMPSCALE] *= sqrt(mass / (mass + 100.0));
;860:			break;
;861:		default:
;862:			break;
;863:		}*/
;864:	}
LABELV $407
line 866
;865:
;866:	if ( client->ps.powerups[PW_HASTE] ) {
ADDRLP4 0
INDIRP4
CNSTI4 324
ADDP4
INDIRI4
CNSTI4 0
EQI4 $411
line 867
;867:		client->ps.speed *= 1.3;
ADDRLP4 284
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 284
INDIRP4
CNSTF4 1067869798
ADDRLP4 284
INDIRP4
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 868
;868:	}
LABELV $411
line 871
;869:
;870:	// Let go of the hook if we aren't firing
;871:	if ( client->ps.weapon == WP_GRAPPLING_HOOK &&
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $413
ADDRLP4 0
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $413
ADDRLP4 224
INDIRP4
CNSTI4 4
ADDP4
INDIRU1
CVUI4 1
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $413
line 872
;872:		client->hook && !( ucmd->buttons & BUTTON_ATTACK ) ) {
line 873
;873:		Weapon_HookFree(client->hook);
ADDRLP4 0
INDIRP4
CNSTI4 708
ADDP4
INDIRP4
ARGP4
ADDRGP4 Weapon_HookFree
CALLV
pop
line 874
;874:	}
LABELV $413
line 876
;875:
;876:	if(client->ps.weapon == WP_NONE && client->ps.stats[STAT_WEAPONS] > 1 && client->ps.weaponstate == WEAPON_READY && client->ps.weaponTime == 0)
ADDRLP4 292
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ADDRLP4 292
INDIRI4
NEI4 $415
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
LEI4 $415
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ADDRLP4 292
INDIRI4
NEI4 $415
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
ADDRLP4 292
INDIRI4
NEI4 $415
line 877
;877:	{ // we've got a weapon - use it damnit!
line 879
;878:		int i;
;879:		for(i = 1; i < MAX_WEAPONS; i++)
ADDRLP4 296
CNSTI4 1
ASGNI4
LABELV $417
line 880
;880:		{
line 881
;881:			if(client->ps.stats[STAT_WEAPONS] & (1 << i))
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 296
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $421
line 882
;882:			{
line 883
;883:				client->ps.weapon = i;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
ADDRLP4 296
INDIRI4
ASGNI4
line 884
;884:				client->ps.weaponstate = WEAPON_RAISING;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 1
ASGNI4
line 885
;885:				break;
ADDRGP4 $419
JUMPV
LABELV $421
line 887
;886:			}
;887:		}
LABELV $418
line 879
ADDRLP4 296
ADDRLP4 296
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 296
INDIRI4
CNSTI4 16
LTI4 $417
LABELV $419
line 888
;888:	}
LABELV $415
line 890
;889:	// set up for pmove
;890:	oldEventSequence = client->ps.eventSequence;
ADDRLP4 232
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
ASGNI4
line 892
;891:
;892:	memset (&pm, 0, sizeof(pm));
ADDRLP4 4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 220
ARGU4
ADDRGP4 memset
CALLP4
pop
line 896
;893:
;894:	// check for the hit-scan gauntlet, don't let the action
;895:	// go through as an attack unless it actually hits something
;896:	if ( (client->ps.weapon == WP_GAUNTLET || client->ps.weapon == WP_NONE ) &&
ADDRLP4 296
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
ADDRLP4 296
INDIRI4
CNSTI4 1
EQI4 $425
ADDRLP4 296
INDIRI4
CNSTI4 0
NEI4 $423
LABELV $425
ADDRLP4 300
CNSTI4 0
ASGNI4
ADDRLP4 224
INDIRP4
CNSTI4 4
ADDP4
INDIRU1
CVUI4 1
CNSTI4 1
BANDI4
ADDRLP4 300
INDIRI4
EQI4 $423
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
ADDRLP4 300
INDIRI4
GTI4 $423
line 897
;897:		( ucmd->buttons & BUTTON_ATTACK ) && client->ps.weaponTime <= 0 ) {
line 898
;898:		pm.gauntletHit = CheckMeleeAttack( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 304
ADDRGP4 CheckMeleeAttack
CALLI4
ASGNI4
ADDRLP4 4+40
ADDRLP4 304
INDIRI4
ASGNI4
line 899
;899:	}
LABELV $423
line 901
;900:
;901:	pm.ps = &client->ps;
ADDRLP4 4
ADDRLP4 0
INDIRP4
ASGNP4
line 902
;902:	pm.cmd = *ucmd;
ADDRLP4 4+4
ADDRLP4 224
INDIRP4
INDIRB
ASGNB 24
line 903
;903:	if ( pm.ps->pm_type == PM_DEAD ) {
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $428
line 904
;904:		pm.tracemask = MASK_PLAYERSOLID & ~CONTENTS_BODY;
ADDRLP4 4+28
CNSTI4 65537
ASGNI4
line 905
;905:	}
ADDRGP4 $429
JUMPV
LABELV $428
line 906
;906:	else {
line 907
;907:		pm.tracemask = MASK_PLAYERSOLID;
ADDRLP4 4+28
CNSTI4 33619969
ASGNI4
line 908
;908:	}
LABELV $429
line 909
;909:	pm.trace = trap_Trace;
ADDRLP4 4+212
ADDRGP4 trap_Trace
ASGNP4
line 910
;910:	pm.pointcontents = trap_PointContents;
ADDRLP4 4+216
ADDRGP4 trap_PointContents
ASGNP4
line 911
;911:	pm.debugLevel = g_debugMove.integer;
ADDRLP4 4+32
ADDRGP4 g_debugMove+12
INDIRI4
ASGNI4
line 912
;912:	pm.noFootsteps = ( g_dmflags.integer & DF_NO_FOOTSTEPS ) > 0;
ADDRGP4 g_dmflags+12
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
LEI4 $439
ADDRLP4 304
CNSTI4 1
ASGNI4
ADDRGP4 $440
JUMPV
LABELV $439
ADDRLP4 304
CNSTI4 0
ASGNI4
LABELV $440
ADDRLP4 4+36
ADDRLP4 304
INDIRI4
ASGNI4
line 914
;913:
;914:	VectorCopy( client->ps.origin, oldOrigin );
ADDRLP4 236
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 917
;915:
;916:	// perform a pmove
;917:	Pmove (&pm);
ADDRLP4 4
ARGP4
ADDRGP4 Pmove
CALLV
pop
line 918
;918:	if(g_OneWeaponPerPlayer.integer && ent->client->ps.weapon != WP_NONE && ((ent->client->ps.torsoAnim & ~ANIM_TOGGLEBIT) == TORSO_DROP) )
ADDRLP4 308
CNSTI4 0
ASGNI4
ADDRGP4 g_OneWeaponPerPlayer+12
INDIRI4
ADDRLP4 308
INDIRI4
EQI4 $441
ADDRLP4 312
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ASGNP4
ADDRLP4 312
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ADDRLP4 308
INDIRI4
EQI4 $441
ADDRLP4 312
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
CNSTI4 -129
BANDI4
CNSTI4 9
NEI4 $441
line 919
;919:	{ // ## Hentai - gotta drop da gun
line 920
;920:		TossClientWeapon(ent, ent->s.weapon);		
ADDRLP4 316
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 316
INDIRP4
ARGP4
ADDRLP4 316
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ARGI4
ADDRGP4 TossClientWeapon
CALLV
pop
line 921
;921:	}
LABELV $441
line 923
;922:	// save results of pmove
;923:	if ( ent->client->ps.eventSequence != oldEventSequence ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
ADDRLP4 232
INDIRI4
EQI4 $444
line 924
;924:		ent->eventTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 540
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 925
;925:	}
LABELV $444
line 926
;926:	BG_PlayerStateToEntityState( &ent->client->ps, &ent->s, qtrue );
ADDRLP4 316
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 316
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ARGP4
ADDRLP4 316
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 927
;927:	if ( !( ent->client->ps.eFlags & EF_FIRING ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
NEI4 $447
line 928
;928:		client->fireHeld = qfalse;		// for grapple
ADDRLP4 0
INDIRP4
CNSTI4 704
ADDP4
CNSTI4 0
ASGNI4
line 929
;929:	}
LABELV $447
line 933
;930:
;931:#if 1
;932:	// use the precise origin for linking
;933:	VectorCopy( ent->client->ps.origin, ent->r.currentOrigin );
ADDRLP4 320
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 320
INDIRP4
CNSTI4 476
ADDP4
ADDRLP4 320
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 939
;934:#else
;935:	// use the snapped origin for linking so it matches client predicted versions
;936:	VectorCopy( ent->s.pos.trBase, ent->r.currentOrigin );
;937:#endif
;938:
;939:	VectorCopy (pm.mins, ent->r.mins);
ADDRFP4 0
INDIRP4
CNSTI4 424
ADDP4
ADDRLP4 4+176
INDIRB
ASGNB 12
line 940
;940:	VectorCopy (pm.maxs, ent->r.maxs);
ADDRFP4 0
INDIRP4
CNSTI4 436
ADDP4
ADDRLP4 4+188
INDIRB
ASGNB 12
line 942
;941:
;942:	ent->waterlevel = pm.waterlevel;
ADDRFP4 0
INDIRP4
CNSTI4 768
ADDP4
ADDRLP4 4+204
INDIRI4
ASGNI4
line 943
;943:	ent->watertype = pm.watertype;
ADDRFP4 0
INDIRP4
CNSTI4 764
ADDP4
ADDRLP4 4+200
INDIRI4
ASGNI4
line 946
;944:
;945:	// execute client events
;946:	ClientEvents( ent, oldEventSequence );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 232
INDIRI4
ARGI4
ADDRGP4 ClientEvents
CALLV
pop
line 949
;947:
;948:	// link entity now, after any personal teleporters have been used
;949:	trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 950
;950:	if ( !ent->client->noclip ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 620
ADDP4
INDIRI4
CNSTI4 0
NEI4 $453
line 951
;951:		G_TouchTriggers( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_TouchTriggers
CALLV
pop
line 952
;952:	}
LABELV $453
line 955
;953:
;954:	//test for solid areas in the AAS file
;955:	BotTestSolid(ent->r.currentOrigin);
ADDRFP4 0
INDIRP4
CNSTI4 476
ADDP4
ARGP4
ADDRGP4 BotTestSolid
CALLV
pop
line 958
;956:
;957:	// touch other objects
;958:	ClientImpacts( ent, &pm );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 ClientImpacts
CALLV
pop
line 961
;959:
;960:	// swap and latch button actions
;961:	client->oldbuttons = client->buttons;
ADDRLP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ASGNI4
line 962
;962:	client->buttons = ucmd->buttons;
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
ADDRLP4 224
INDIRP4
CNSTI4 4
ADDP4
INDIRU1
CVUI4 1
ASGNI4
line 963
;963:	client->latched_buttons |= client->buttons & ~client->oldbuttons;
ADDRLP4 332
ADDRLP4 0
INDIRP4
CNSTI4 636
ADDP4
ASGNP4
ADDRLP4 332
INDIRP4
ADDRLP4 332
INDIRP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 632
ADDP4
INDIRI4
BCOMI4
BANDI4
BORI4
ASGNI4
line 966
;964:
;965:	// check for respawning
;966:	if ( client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $455
line 968
;967:		// wait for the attack button to be pressed
;968:		if ( level.time > client->respawnTime ) {
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
LEI4 $343
line 970
;969:			// forcerespawn is to prevent users from waiting out powerups
;970:			if ( g_forcerespawn.integer > 0 && 
ADDRGP4 g_forcerespawn+12
INDIRI4
CNSTI4 0
LEI4 $460
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
SUBI4
CNSTI4 1000
ADDRGP4 g_forcerespawn+12
INDIRI4
MULI4
LEI4 $460
line 971
;971:				( level.time - client->respawnTime ) > g_forcerespawn.integer * 1000 ) {
line 972
;972:				respawn( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 respawn
CALLV
pop
line 973
;973:				return;
ADDRGP4 $343
JUMPV
LABELV $460
line 977
;974:			}
;975:		
;976:			// pressing attack or use is the normal respawn method
;977:			if ( ucmd->buttons & ( BUTTON_ATTACK | BUTTON_USE_HOLDABLE ) ) {
ADDRLP4 224
INDIRP4
CNSTI4 4
ADDP4
INDIRU1
CVUI4 1
CNSTI4 5
BANDI4
CNSTI4 0
EQI4 $343
line 978
;978:				respawn( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 respawn
CALLV
pop
line 979
;979:			}
line 980
;980:		}
line 981
;981:		return;
ADDRGP4 $343
JUMPV
LABELV $455
line 983
;982:	}	
;983:	if(client->bleeding)
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRF4
CNSTF4 0
EQF4 $467
line 984
;984:	{		
line 986
;985:		//client->ps.powerups[PW_BLEEDING] = level.time + 30;
;986:		if((level.time - client->bleedtime) >= 250)
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
SUBI4
CNSTI4 250
LTI4 $469
line 987
;987:		{
line 988
;988:			client->bleed_damage += client->bleeding * (level.time - client->bleedtime) / 1000.0;
ADDRLP4 340
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ASGNP4
ADDRLP4 340
INDIRP4
ADDRLP4 340
INDIRP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
INDIRF4
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1148846080
DIVF4
ADDF4
ASGNF4
line 989
;989:			client->bleedtime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 716
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 990
;990:		}
LABELV $469
line 991
;991:		if(client->bleed_damage >= 1)
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
INDIRF4
CNSTF4 1065353216
LTF4 $474
line 992
;992:		{
line 994
;993:			//ent->pain_debounce_time = level.time + rand() % 5;
;994:			if(client->bleed_damage > client->ps.stats[STAT_HEALTH] + 5)
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 5
ADDI4
CVIF4 4
LEF4 $476
line 995
;995:				client->bleed_damage = client->ps.stats[STAT_HEALTH] + 5;			
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 5
ADDI4
CVIF4 4
ASGNF4
LABELV $476
line 996
;996:			if(client->ps.stats[STAT_HEALTH] > 0)
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
LEI4 $478
line 997
;997:				G_Damage(ent, ent, ent->enemy, NULL, NULL, (int) floor(client->bleed_damage), DAMAGE_NO_ARMOR | DAMAGE_NO_BLEEDING, MOD_BLEED);
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
INDIRF4
ARGF4
ADDRLP4 344
ADDRGP4 floor
CALLF4
ASGNF4
ADDRLP4 348
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 348
INDIRP4
ARGP4
ADDRLP4 348
INDIRP4
ARGP4
ADDRLP4 348
INDIRP4
CNSTI4 748
ADDP4
INDIRP4
ARGP4
ADDRLP4 352
CNSTP4 0
ASGNP4
ADDRLP4 352
INDIRP4
ARGP4
ADDRLP4 352
INDIRP4
ARGP4
ADDRLP4 344
INDIRF4
CVFI4 4
ARGI4
CNSTI4 18
ARGI4
CNSTI4 24
ARGI4
ADDRGP4 G_Damage
CALLV
pop
ADDRGP4 $479
JUMPV
LABELV $478
line 999
;998:			else
;999:				G_AddEvent(ent, EV_BLOOD, 16);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 64
ARGI4
CNSTI4 16
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
LABELV $479
line 1000
;1000:			client->bleed_damage -= floor(client->bleed_damage);
ADDRLP4 356
ADDRLP4 0
INDIRP4
CNSTI4 724
ADDP4
ASGNP4
ADDRLP4 360
ADDRLP4 356
INDIRP4
INDIRF4
ASGNF4
ADDRLP4 360
INDIRF4
ARGF4
ADDRLP4 364
ADDRGP4 floor
CALLF4
ASGNF4
ADDRLP4 356
INDIRP4
ADDRLP4 360
INDIRF4
ADDRLP4 364
INDIRF4
SUBF4
ASGNF4
line 1001
;1001:			if(client->ps.stats[STAT_HEALTH] > client->pers.maxHealth)
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 520
ADDP4
INDIRI4
LEI4 $480
line 1002
;1002:				client->bleeding = 0;
ADDRLP4 0
INDIRP4
CNSTI4 720
ADDP4
CNSTF4 0
ASGNF4
LABELV $480
line 1003
;1003:		}
LABELV $474
line 1004
;1004:	}
LABELV $467
line 1007
;1005:	//else
;1006:		//client->ps.powerups[PW_BLEEDING] = 0;
;1007:	client->waistheight = G_PlayerAngles(client, client->muzzle, client->headpos);
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 740
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
ARGP4
ADDRLP4 340
ADDRGP4 G_PlayerAngles
CALLF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 752
ADDP4
ADDRLP4 340
INDIRF4
ASGNF4
line 1009
;1008:	// perform once-a-second actions
;1009:	ClientTimerActions( ent, msec );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 228
INDIRI4
ARGI4
ADDRGP4 ClientTimerActions
CALLV
pop
line 1010
;1010:}
LABELV $343
endproc ClientThink_real 372 32
export ClientThink
proc ClientThink 4 8
line 1019
;1011:
;1012:/*
;1013:==================
;1014:ClientThink
;1015:
;1016:A new command has arrived from the client
;1017:==================
;1018:*/
;1019:void ClientThink( int clientNum ) {
line 1022
;1020:	gentity_t *ent;
;1021:
;1022:	ent = g_entities + clientNum;
ADDRLP4 0
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1023
;1023:	trap_GetUsercmd( clientNum, &ent->client->pers.cmd );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 448
ADDP4
ARGP4
ADDRGP4 trap_GetUsercmd
CALLV
pop
line 1027
;1024:
;1025:	// mark the time we got info, so we can display the
;1026:	// phone jack if they don't get any for a while
;1027:	ent->client->lastCmdTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 624
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1029
;1028:
;1029:	if ( !g_syncronousClients.integer ) {
ADDRGP4 g_syncronousClients+12
INDIRI4
CNSTI4 0
NEI4 $484
line 1030
;1030:		ClientThink_real( ent );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 ClientThink_real
CALLV
pop
line 1031
;1031:	}
LABELV $484
line 1032
;1032:}
LABELV $482
endproc ClientThink 4 8
export G_RunClient
proc G_RunClient 0 4
line 1035
;1033:
;1034:
;1035:void G_RunClient( gentity_t *ent ) {
line 1036
;1036:	if ( !g_syncronousClients.integer ) {
ADDRGP4 g_syncronousClients+12
INDIRI4
CNSTI4 0
NEI4 $488
line 1037
;1037:		return;
ADDRGP4 $487
JUMPV
LABELV $488
line 1039
;1038:	}
;1039:	ent->client->pers.cmd.serverTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 448
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1040
;1040:	ClientThink_real( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ClientThink_real
CALLV
pop
line 1041
;1041:}
LABELV $487
endproc G_RunClient 0 4
export SpectatorClientEndFrame
proc SpectatorClientEndFrame 16 4
line 1050
;1042:
;1043:
;1044:/*
;1045:==================
;1046:SpectatorClientEndFrame
;1047:
;1048:==================
;1049:*/
;1050:void SpectatorClientEndFrame( gentity_t *ent ) {
line 1054
;1051:	gclient_t	*cl;
;1052:
;1053:	// if we are doing a chase cam or a remote view, grab the latest info
;1054:	if ( ent->client->sess.spectatorState == SPECTATOR_FOLLOW ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 2
NEI4 $493
line 1057
;1055:		int		clientNum;
;1056:
;1057:		clientNum = ent->client->sess.spectatorClient;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
ASGNI4
line 1060
;1058:
;1059:		// team follow1 and team follow2 go to whatever clients are playing
;1060:		if ( clientNum == -1 ) {
ADDRLP4 4
INDIRI4
CNSTI4 -1
NEI4 $495
line 1061
;1061:			clientNum = level.follow1;
ADDRLP4 4
ADDRGP4 level+596
INDIRI4
ASGNI4
line 1062
;1062:		} else if ( clientNum == -2 ) {
ADDRGP4 $496
JUMPV
LABELV $495
ADDRLP4 4
INDIRI4
CNSTI4 -2
NEI4 $498
line 1063
;1063:			clientNum = level.follow2;
ADDRLP4 4
ADDRGP4 level+600
INDIRI4
ASGNI4
line 1064
;1064:		}
LABELV $498
LABELV $496
line 1065
;1065:		if ( clientNum >= 0 ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
LTI4 $501
line 1066
;1066:			cl = &level.clients[ clientNum ];
ADDRLP4 0
CNSTI4 760
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 1067
;1067:			if ( cl->pers.connected == CON_CONNECTED && cl->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRLP4 8
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
NEI4 $503
ADDRLP4 8
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
EQI4 $503
line 1068
;1068:				ent->client->ps = cl->ps;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ADDRLP4 0
INDIRP4
INDIRB
ASGNB 444
line 1069
;1069:				ent->client->ps.pm_flags |= PMF_FOLLOW;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1070
;1070:				return;
ADDRGP4 $492
JUMPV
LABELV $503
line 1071
;1071:			} else {
line 1073
;1072:				// drop them to free spectators unless they are dedicated camera followers
;1073:				if ( ent->client->sess.spectatorClient >= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
CNSTI4 0
LTI4 $505
line 1074
;1074:					ent->client->sess.spectatorState = SPECTATOR_FREE;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
CNSTI4 1
ASGNI4
line 1075
;1075:					ClientBegin( ent->client - level.clients );
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 760
DIVI4
ARGI4
ADDRGP4 ClientBegin
CALLV
pop
line 1076
;1076:				}
LABELV $505
line 1077
;1077:			}
line 1078
;1078:		}
LABELV $501
line 1079
;1079:	}
LABELV $493
line 1081
;1080:
;1081:	if ( ent->client->sess.spectatorState == SPECTATOR_SCOREBOARD ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
CNSTI4 3
NEI4 $507
line 1082
;1082:		ent->client->ps.pm_flags |= PMF_SCOREBOARD;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 8192
BORI4
ASGNI4
line 1083
;1083:	} else {
ADDRGP4 $508
JUMPV
LABELV $507
line 1084
;1084:		ent->client->ps.pm_flags &= ~PMF_SCOREBOARD;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -8193
BANDI4
ASGNI4
line 1085
;1085:	}
LABELV $508
line 1086
;1086:}
LABELV $492
endproc SpectatorClientEndFrame 16 4
export ClientEndFrame
proc ClientEndFrame 16 12
line 1097
;1087:
;1088:/*
;1089:==============
;1090:ClientEndFrame
;1091:
;1092:Called at the end of each server frame for each connected client
;1093:A fast client will have multiple ClientThink for each ClientEdFrame,
;1094:while a slow client may have multiple ClientEndFrame between ClientThink.
;1095:==============
;1096:*/
;1097:void ClientEndFrame( gentity_t *ent ) {
line 1101
;1098:	int			i;
;1099:	clientPersistant_t	*pers;
;1100:
;1101:	if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 3
NEI4 $510
line 1102
;1102:		SpectatorClientEndFrame( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SpectatorClientEndFrame
CALLV
pop
line 1103
;1103:		return;
ADDRGP4 $509
JUMPV
LABELV $510
line 1106
;1104:	}
;1105:
;1106:	pers = &ent->client->pers;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 444
ADDP4
ASGNP4
line 1109
;1107:
;1108:	// turn off any expired powerups
;1109:	for ( i = 0 ; i < MAX_POWERUPS ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $512
line 1110
;1110:		if ( ent->client->ps.powerups[ i ] < level.time ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $516
line 1111
;1111:			ent->client->ps.powerups[ i ] = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
CNSTI4 0
ASGNI4
line 1112
;1112:		}
LABELV $516
line 1113
;1113:	}
LABELV $513
line 1109
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $512
line 1127
;1114:
;1115:	// save network bandwidth
;1116:#if 0
;1117:	if ( !g_syncronousClients->integer && ent->client->ps.pm_type == PM_NORMAL ) {
;1118:		// FIXME: this must change eventually for non-sync demo recording
;1119:		VectorClear( ent->client->ps.viewangles );
;1120:	}
;1121:#endif
;1122:
;1123:	//
;1124:	// If the end of unit layout is displayed, don't give
;1125:	// the player any normal movement attributes
;1126:	//
;1127:	if ( level.intermissiontime ) {
ADDRGP4 level+4228
INDIRI4
CNSTI4 0
EQI4 $519
line 1128
;1128:		return;
ADDRGP4 $509
JUMPV
LABELV $519
line 1132
;1129:	}
;1130:
;1131:	// burn from lava, etc
;1132:	P_WorldEffects (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 P_WorldEffects
CALLV
pop
line 1135
;1133:
;1134:	// apply all the damage taken this frame
;1135:	P_DamageFeedback (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 P_DamageFeedback
CALLV
pop
line 1138
;1136:
;1137:	// add the EF_CONNECTION flag if we haven't gotten commands recently
;1138:	if ( level.time - ent->client->lastCmdTime > 1000 ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 624
ADDP4
INDIRI4
SUBI4
CNSTI4 1000
LEI4 $522
line 1139
;1139:		ent->s.eFlags |= EF_CONNECTION;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 8192
BORI4
ASGNI4
line 1140
;1140:	} else {
ADDRGP4 $523
JUMPV
LABELV $522
line 1141
;1141:		ent->s.eFlags &= ~EF_CONNECTION;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -8193
BANDI4
ASGNI4
line 1142
;1142:	}
LABELV $523
line 1144
;1143:
;1144:	ent->client->ps.stats[STAT_HEALTH] = ent->health;	// FIXME: get rid of ent->health...
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 712
ADDP4
INDIRI4
ASGNI4
line 1146
;1145:
;1146:	G_SetClientSound (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_SetClientSound
CALLV
pop
line 1149
;1147:
;1148:	// set the latest infor
;1149:	BG_PlayerStateToEntityState( &ent->client->ps, &ent->s, qtrue );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 1150
;1150:}
LABELV $509
endproc ClientEndFrame 16 12
import G_ExplodeMissile
import TossClientWeapon
import BotTestSolid
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $194
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 84
byte 1 101
byte 1 110
byte 1 32
byte 1 115
byte 1 101
byte 1 99
byte 1 111
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 117
byte 1 110
byte 1 116
byte 1 105
byte 1 108
byte 1 32
byte 1 105
byte 1 110
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 100
byte 1 114
byte 1 111
byte 1 112
byte 1 33
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $190
byte 1 68
byte 1 114
byte 1 111
byte 1 112
byte 1 112
byte 1 101
byte 1 100
byte 1 32
byte 1 100
byte 1 117
byte 1 101
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 105
byte 1 110
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $86
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 47
byte 1 103
byte 1 117
byte 1 114
byte 1 112
byte 1 50
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $85
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 47
byte 1 103
byte 1 117
byte 1 114
byte 1 112
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $82
byte 1 42
byte 1 100
byte 1 114
byte 1 111
byte 1 119
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
