export BotValidTeamLeader
code
proc BotValidTeamLeader 8 4
file "..\ai_team.c"
line 49
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:/*****************************************************************************
;5: * name:		ai_team.c
;6: *
;7: * desc:		Quake3 bot AI
;8: *
;9: * $Archive: /source/code/game/ai_team.c $
;10: * $Author: Raduffy $ 
;11: * $Revision: 5 $
;12: * $Modtime: 1/14/00 5:28p $
;13: * $Date: 1/14/00 5:35p $
;14: *
;15: *****************************************************************************/
;16:
;17:#include "g_local.h"
;18:#include "botlib.h"
;19:#include "be_aas.h"
;20:#include "be_ea.h"
;21:#include "be_ai_char.h"
;22:#include "be_ai_chat.h"
;23:#include "be_ai_gen.h"
;24:#include "be_ai_goal.h"
;25:#include "be_ai_move.h"
;26:#include "be_ai_weap.h"
;27://
;28:#include "ai_main.h"
;29:#include "ai_dmq3.h"
;30:#include "ai_chat.h"
;31:#include "ai_cmd.h"
;32:#include "ai_dmnet.h"
;33:
;34://ctf task preferences for a client
;35:typedef struct bot_ctftaskpreference_s
;36:{
;37:	char		name[36];
;38:	int			preference;
;39:} bot_ctftaskpreference_t;
;40:
;41:bot_ctftaskpreference_t ctftaskpreferences[MAX_CLIENTS];
;42:
;43:
;44:/*
;45:==================
;46:BotValidTeamLeader
;47:==================
;48:*/
;49:int BotValidTeamLeader(bot_state_t *bs) {
line 50
;50:	if (!strlen(bs->teamleader)) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 0
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 0
INDIRU4
CNSTU4 0
NEU4 $48
CNSTI4 0
RETI4
ADDRGP4 $47
JUMPV
LABELV $48
line 51
;51:	if (ClientFromName(bs->teamleader) == -1) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 4
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 -1
NEI4 $50
CNSTI4 0
RETI4
ADDRGP4 $47
JUMPV
LABELV $50
line 52
;52:	return qtrue;
CNSTI4 1
RETI4
LABELV $47
endproc BotValidTeamLeader 8 4
bss
align 4
LABELV $53
skip 4
export BotNumTeamMates
code
proc BotNumTeamMates 1060 12
line 60
;53:}
;54:
;55:/*
;56:==================
;57:BotNumTeamMates
;58:==================
;59:*/
;60:int BotNumTeamMates(bot_state_t *bs) {
line 65
;61:	int i, numplayers;
;62:	char buf[MAX_INFO_STRING];
;63:	static int maxclients;
;64:
;65:	if (!maxclients)
ADDRGP4 $53
INDIRI4
CNSTI4 0
NEI4 $54
line 66
;66:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $56
ARGP4
ADDRLP4 1032
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $53
ADDRLP4 1032
INDIRI4
ASGNI4
LABELV $54
line 68
;67:
;68:	numplayers = 0;
ADDRLP4 1028
CNSTI4 0
ASGNI4
line 69
;69:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $60
JUMPV
LABELV $57
line 70
;70:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 72
;71:		//if no config string or no name
;72:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1036
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1036
INDIRU4
CNSTU4 0
EQU4 $64
ADDRLP4 4
ARGP4
ADDRGP4 $63
ARGP4
ADDRLP4 1040
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1040
INDIRP4
ARGP4
ADDRLP4 1044
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1044
INDIRU4
CNSTU4 0
NEU4 $61
LABELV $64
ADDRGP4 $58
JUMPV
LABELV $61
line 74
;73:		//skip spectators
;74:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 4
ARGP4
ADDRGP4 $67
ARGP4
ADDRLP4 1048
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1048
INDIRP4
ARGP4
ADDRLP4 1052
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 3
NEI4 $65
ADDRGP4 $58
JUMPV
LABELV $65
line 76
;75:		//
;76:		if (BotSameTeam(bs, i)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1056
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1056
INDIRI4
CNSTI4 0
EQI4 $68
line 77
;77:			numplayers++;
ADDRLP4 1028
ADDRLP4 1028
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 78
;78:		}
LABELV $68
line 79
;79:	}
LABELV $58
line 69
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $60
ADDRLP4 0
INDIRI4
ADDRGP4 $53
INDIRI4
GEI4 $70
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $57
LABELV $70
line 80
;80:	return numplayers;
ADDRLP4 1028
INDIRI4
RETI4
LABELV $52
endproc BotNumTeamMates 1060 12
export BotClientTravelTimeToGoal
proc BotClientTravelTimeToGoal 456 16
line 88
;81:}
;82:
;83:/*
;84:==================
;85:BotClientTravelTimeToGoal
;86:==================
;87:*/
;88:int BotClientTravelTimeToGoal(int client, bot_goal_t *goal) {
line 92
;89:	playerState_t ps;
;90:	int areanum;
;91:
;92:	BotAI_GetClientState(client, &ps);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
line 93
;93:	areanum = BotPointAreaNum(ps.origin);
ADDRLP4 0+20
ARGP4
ADDRLP4 448
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 444
ADDRLP4 448
INDIRI4
ASGNI4
line 94
;94:	if (!areanum) return 1;
ADDRLP4 444
INDIRI4
CNSTI4 0
NEI4 $73
CNSTI4 1
RETI4
ADDRGP4 $71
JUMPV
LABELV $73
line 95
;95:	return trap_AAS_AreaTravelTimeToGoalArea(areanum, ps.origin, goal->areanum, TFL_DEFAULT);
ADDRLP4 444
INDIRI4
ARGI4
ADDRLP4 0+20
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 452
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 452
INDIRI4
RETI4
LABELV $71
endproc BotClientTravelTimeToGoal 456 16
bss
align 4
LABELV $77
skip 4
export BotSortTeamMatesByBaseTravelTime
code
proc BotSortTeamMatesByBaseTravelTime 1608 12
line 103
;96:}
;97:
;98:/*
;99:==================
;100:BotSortTeamMatesByBaseTravelTime
;101:==================
;102:*/
;103:int BotSortTeamMatesByBaseTravelTime(bot_state_t *bs, int *teammates, int maxteammates) {
line 111
;104:
;105:	int i, j, k, numteammates, traveltime;
;106:	char buf[MAX_INFO_STRING];
;107:	static int maxclients;
;108:	int traveltimes[MAX_CLIENTS];
;109:	bot_goal_t *goal;
;110:
;111:	if (BotCTFTeam(bs) == CTF_TEAM_RED) goal = &ctf_redflag;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1560
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 1560
INDIRI4
CNSTI4 1
NEI4 $78
ADDRLP4 1556
ADDRGP4 ctf_redflag
ASGNP4
ADDRGP4 $79
JUMPV
LABELV $78
line 112
;112:	else goal = &ctf_blueflag;
ADDRLP4 1556
ADDRGP4 ctf_blueflag
ASGNP4
LABELV $79
line 114
;113:
;114:	if (!maxclients)
ADDRGP4 $77
INDIRI4
CNSTI4 0
NEI4 $80
line 115
;115:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $56
ARGP4
ADDRLP4 1564
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $77
ADDRLP4 1564
INDIRI4
ASGNI4
LABELV $80
line 117
;116:
;117:	numteammates = 0;
ADDRLP4 520
CNSTI4 0
ASGNI4
line 118
;118:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 524
CNSTI4 0
ASGNI4
ADDRGP4 $85
JUMPV
LABELV $82
line 119
;119:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 524
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 532
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 121
;120:		//if no config string or no name
;121:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 532
ARGP4
ADDRLP4 1568
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1568
INDIRU4
CNSTU4 0
EQU4 $88
ADDRLP4 532
ARGP4
ADDRGP4 $63
ARGP4
ADDRLP4 1572
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1572
INDIRP4
ARGP4
ADDRLP4 1576
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1576
INDIRU4
CNSTU4 0
NEU4 $86
LABELV $88
ADDRGP4 $83
JUMPV
LABELV $86
line 123
;122:		//skip spectators
;123:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 532
ARGP4
ADDRGP4 $67
ARGP4
ADDRLP4 1580
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1580
INDIRP4
ARGP4
ADDRLP4 1584
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1584
INDIRI4
CNSTI4 3
NEI4 $89
ADDRGP4 $83
JUMPV
LABELV $89
line 125
;124:		//
;125:		if (BotSameTeam(bs, i)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 524
INDIRI4
ARGI4
ADDRLP4 1588
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1588
INDIRI4
CNSTI4 0
EQI4 $91
line 127
;126:			//
;127:			traveltime = BotClientTravelTimeToGoal(i, goal);
ADDRLP4 524
INDIRI4
ARGI4
ADDRLP4 1556
INDIRP4
ARGP4
ADDRLP4 1592
ADDRGP4 BotClientTravelTimeToGoal
CALLI4
ASGNI4
ADDRLP4 528
ADDRLP4 1592
INDIRI4
ASGNI4
line 129
;128:			//
;129:			for (j = 0; j < numteammates; j++) {
ADDRLP4 516
CNSTI4 0
ASGNI4
ADDRGP4 $96
JUMPV
LABELV $93
line 130
;130:				if (traveltime < traveltimes[j]) {
ADDRLP4 528
INDIRI4
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
GEI4 $97
line 131
;131:					for (k = numteammates; k > j; k--) {
ADDRLP4 0
ADDRLP4 520
INDIRI4
ASGNI4
ADDRGP4 $102
JUMPV
LABELV $99
line 132
;132:						traveltimes[k] = traveltimes[k-1];
ADDRLP4 1596
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 1596
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 1596
INDIRI4
ADDRLP4 4-4
ADDP4
INDIRI4
ASGNI4
line 133
;133:						teammates[k] = teammates[k-1];
ADDRLP4 1600
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 1604
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 1600
INDIRI4
ADDRLP4 1604
INDIRP4
ADDP4
ADDRLP4 1600
INDIRI4
CNSTI4 4
SUBI4
ADDRLP4 1604
INDIRP4
ADDP4
INDIRI4
ASGNI4
line 134
;134:					}
LABELV $100
line 131
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
LABELV $102
ADDRLP4 0
INDIRI4
ADDRLP4 516
INDIRI4
GTI4 $99
line 135
;135:					traveltimes[j] = traveltime;
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ADDRLP4 528
INDIRI4
ASGNI4
line 136
;136:					teammates[j] = i;
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ADDRLP4 524
INDIRI4
ASGNI4
line 137
;137:					break;
ADDRGP4 $95
JUMPV
LABELV $97
line 139
;138:				}
;139:			}
LABELV $94
line 129
ADDRLP4 516
ADDRLP4 516
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $96
ADDRLP4 516
INDIRI4
ADDRLP4 520
INDIRI4
LTI4 $93
LABELV $95
line 140
;140:			if (j >= numteammates) {
ADDRLP4 516
INDIRI4
ADDRLP4 520
INDIRI4
LTI4 $104
line 141
;141:				traveltimes[j] = traveltime;
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ADDRLP4 528
INDIRI4
ASGNI4
line 142
;142:				teammates[j] = i;
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ADDRLP4 524
INDIRI4
ASGNI4
line 143
;143:			}
LABELV $104
line 144
;144:			numteammates++;
ADDRLP4 520
ADDRLP4 520
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 145
;145:			if (numteammates >= maxteammates) break;
ADDRLP4 520
INDIRI4
ADDRFP4 8
INDIRI4
LTI4 $106
ADDRGP4 $84
JUMPV
LABELV $106
line 146
;146:		}
LABELV $91
line 147
;147:	}
LABELV $83
line 118
ADDRLP4 524
ADDRLP4 524
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $85
ADDRLP4 524
INDIRI4
ADDRGP4 $77
INDIRI4
GEI4 $108
ADDRLP4 524
INDIRI4
CNSTI4 128
LTI4 $82
LABELV $108
LABELV $84
line 148
;148:	return numteammates;
ADDRLP4 520
INDIRI4
RETI4
LABELV $76
endproc BotSortTeamMatesByBaseTravelTime 1608 12
export BotSetTeamMateCTFPreference
proc BotSetTeamMateCTFPreference 36 12
line 156
;149:}
;150:
;151:/*
;152:==================
;153:BotGetTeamMateCTFPreference
;154:==================
;155:*/
;156:void BotSetTeamMateCTFPreference(bot_state_t *bs, int teammate, int preference) {
line 159
;157:	char teammatename[MAX_NETNAME];
;158:
;159:	ctftaskpreferences[teammate].preference = preference;
CNSTI4 40
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 ctftaskpreferences+36
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 160
;160:	ClientName(teammate, teammatename, sizeof(teammatename));
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 161
;161:	strcpy(ctftaskpreferences[teammate].name, teammatename);
CNSTI4 40
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 ctftaskpreferences
ADDP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 162
;162:}
LABELV $109
endproc BotSetTeamMateCTFPreference 36 12
export BotGetTeamMateCTFPreference
proc BotGetTeamMateCTFPreference 40 12
line 169
;163:
;164:/*
;165:==================
;166:BotGetTeamMateCTFPreference
;167:==================
;168:*/
;169:int BotGetTeamMateCTFPreference(bot_state_t *bs, int teammate) {
line 172
;170:	char teammatename[MAX_NETNAME];
;171:
;172:	if (!ctftaskpreferences[teammate].preference) return 0;
CNSTI4 40
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 ctftaskpreferences+36
ADDP4
INDIRI4
CNSTI4 0
NEI4 $112
CNSTI4 0
RETI4
ADDRGP4 $111
JUMPV
LABELV $112
line 173
;173:	ClientName(teammate, teammatename, sizeof(teammatename));
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 174
;174:	if (Q_stricmp(teammatename, ctftaskpreferences[teammate].name)) return 0;
ADDRLP4 0
ARGP4
CNSTI4 40
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 ctftaskpreferences
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $115
CNSTI4 0
RETI4
ADDRGP4 $111
JUMPV
LABELV $115
line 175
;175:	return ctftaskpreferences[teammate].preference;
CNSTI4 40
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 ctftaskpreferences+36
ADDP4
INDIRI4
RETI4
LABELV $111
endproc BotGetTeamMateCTFPreference 40 12
export BotSortTeamMatesByCTFPreference
proc BotSortTeamMatesByCTFPreference 1572 12
line 183
;176:}
;177:
;178:/*
;179:==================
;180:BotSortTeamMatesByCTFPreference
;181:==================
;182:*/
;183:int BotSortTeamMatesByCTFPreference(bot_state_t *bs, int *teammates, int numteammates) {
line 189
;184:	int defenders[MAX_CLIENTS], numdefenders;
;185:	int attackers[MAX_CLIENTS], numattackers;
;186:	int roamers[MAX_CLIENTS], numroamers;
;187:	int i, preference;
;188:
;189:	numdefenders = numattackers = numroamers = 0;
ADDRLP4 1556
CNSTI4 0
ASGNI4
ADDRLP4 528
ADDRLP4 1556
INDIRI4
ASGNI4
ADDRLP4 524
ADDRLP4 1556
INDIRI4
ASGNI4
ADDRLP4 8
ADDRLP4 1556
INDIRI4
ASGNI4
line 190
;190:	for (i = 0; i < numteammates; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $122
JUMPV
LABELV $119
line 191
;191:		preference = BotGetTeamMateCTFPreference(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI4
ARGI4
ADDRLP4 1560
ADDRGP4 BotGetTeamMateCTFPreference
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 1560
INDIRI4
ASGNI4
line 192
;192:		if (preference & CTFTP_DEFENDER) {
ADDRLP4 4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $123
line 193
;193:			defenders[numdefenders++] = teammates[i];
ADDRLP4 1564
ADDRLP4 8
INDIRI4
ASGNI4
ADDRLP4 8
ADDRLP4 1564
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 1568
CNSTI4 2
ASGNI4
ADDRLP4 1564
INDIRI4
ADDRLP4 1568
INDIRI4
LSHI4
ADDRLP4 12
ADDP4
ADDRLP4 0
INDIRI4
ADDRLP4 1568
INDIRI4
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI4
ASGNI4
line 194
;194:		}
ADDRGP4 $124
JUMPV
LABELV $123
line 195
;195:		else if (preference & CTFTP_ATTACKER) {
ADDRLP4 4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $125
line 196
;196:			attackers[numattackers++] = teammates[i];
ADDRLP4 1564
ADDRLP4 524
INDIRI4
ASGNI4
ADDRLP4 524
ADDRLP4 1564
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 1568
CNSTI4 2
ASGNI4
ADDRLP4 1564
INDIRI4
ADDRLP4 1568
INDIRI4
LSHI4
ADDRLP4 532
ADDP4
ADDRLP4 0
INDIRI4
ADDRLP4 1568
INDIRI4
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI4
ASGNI4
line 197
;197:		}
ADDRGP4 $126
JUMPV
LABELV $125
line 198
;198:		else {
line 199
;199:			roamers[numroamers++] = teammates[i];
ADDRLP4 1564
ADDRLP4 528
INDIRI4
ASGNI4
ADDRLP4 528
ADDRLP4 1564
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 1568
CNSTI4 2
ASGNI4
ADDRLP4 1564
INDIRI4
ADDRLP4 1568
INDIRI4
LSHI4
ADDRLP4 1044
ADDP4
ADDRLP4 0
INDIRI4
ADDRLP4 1568
INDIRI4
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI4
ASGNI4
line 200
;200:		}
LABELV $126
LABELV $124
line 201
;201:	}
LABELV $120
line 190
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $122
ADDRLP4 0
INDIRI4
ADDRFP4 8
INDIRI4
LTI4 $119
line 202
;202:	numteammates = 0;
ADDRFP4 8
CNSTI4 0
ASGNI4
line 204
;203:	//defenders at the front of the list
;204:	memcpy(&teammates[numteammates], defenders, numdefenders);
ADDRFP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 8
INDIRI4
CVIU4 4
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 205
;205:	numteammates += numdefenders;
ADDRFP4 8
ADDRFP4 8
INDIRI4
ADDRLP4 8
INDIRI4
ADDI4
ASGNI4
line 207
;206:	//roamers in the middle
;207:	memcpy(&teammates[numteammates], roamers, numroamers);
ADDRFP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ARGP4
ADDRLP4 1044
ARGP4
ADDRLP4 528
INDIRI4
CVIU4 4
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 208
;208:	numteammates += numroamers;
ADDRFP4 8
ADDRFP4 8
INDIRI4
ADDRLP4 528
INDIRI4
ADDI4
ASGNI4
line 210
;209:	//attacker in the back of the list
;210:	memcpy(&teammates[numteammates], attackers, numattackers);
ADDRFP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ARGP4
ADDRLP4 532
ARGP4
ADDRLP4 524
INDIRI4
CVIU4 4
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 211
;211:	numteammates += numattackers;
ADDRFP4 8
ADDRFP4 8
INDIRI4
ADDRLP4 524
INDIRI4
ADDI4
ASGNI4
line 213
;212:
;213:	return numteammates;
ADDRFP4 8
INDIRI4
RETI4
LABELV $118
endproc BotSortTeamMatesByCTFPreference 1572 12
export BotSayTeamOrder
proc BotSayTeamOrder 552 20
line 221
;214:}
;215:
;216:/*
;217:==================
;218:BotSayTeamOrders
;219:==================
;220:*/
;221:void BotSayTeamOrder(bot_state_t *bs, int toclient) {
line 227
;222:	char teamchat[MAX_MESSAGE_SIZE];
;223:	char buf[MAX_MESSAGE_SIZE];
;224:	char name[MAX_NETNAME];
;225:
;226:	//if the bot is talking to itself
;227:	if (bs->client == toclient) {
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ADDRFP4 4
INDIRI4
NEI4 $128
line 229
;228:		//don't show the message just put it in the console message queue
;229:		trap_BotGetChatMessage(bs->cs, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 256
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGetChatMessage
CALLV
pop
line 230
;230:		ClientName(bs->client, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 512
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 231
;231:		Com_sprintf(teamchat, sizeof(teamchat), "(%s): %s", name, buf);
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 $130
ARGP4
ADDRLP4 512
ARGP4
ADDRLP4 256
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 232
;232:		trap_BotQueueConsoleMessage(bs->cs, CMS_CHAT, teamchat);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotQueueConsoleMessage
CALLV
pop
line 233
;233:	}
ADDRGP4 $129
JUMPV
LABELV $128
line 234
;234:	else {
line 235
;235:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 548
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 548
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 548
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 236
;236:	}
LABELV $129
line 237
;237:}
LABELV $127
endproc BotSayTeamOrder 552 20
export BotCTFOrders_BothFlagsNotAtBase
proc BotCTFOrders_BothFlagsNotAtBase 624 20
line 244
;238:
;239:/*
;240:==================
;241:BotCTFOrders
;242:==================
;243:*/
;244:void BotCTFOrders_BothFlagsNotAtBase(bot_state_t *bs) {
line 249
;245:	int numteammates, defenders, attackers, i, other;
;246:	int teammates[MAX_CLIENTS];
;247:	char name[MAX_NETNAME], carriername[MAX_NETNAME];
;248:
;249:	numteammates = BotSortTeamMatesByBaseTravelTime(bs, teammates, sizeof(teammates));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 604
ADDRGP4 BotSortTeamMatesByBaseTravelTime
CALLI4
ASGNI4
ADDRLP4 552
ADDRLP4 604
INDIRI4
ASGNI4
line 250
;250:	BotSortTeamMatesByCTFPreference(bs, teammates, numteammates);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 552
INDIRI4
ARGI4
ADDRGP4 BotSortTeamMatesByCTFPreference
CALLI4
pop
line 252
;251:	//different orders based on the number of team mates
;252:	switch(bs->numteammates) {
ADDRLP4 608
ADDRFP4 0
INDIRP4
CNSTI4 6488
ADDP4
INDIRI4
ASGNI4
ADDRLP4 608
INDIRI4
CNSTI4 1
EQI4 $133
ADDRLP4 608
INDIRI4
CNSTI4 2
EQI4 $136
ADDRLP4 608
INDIRI4
CNSTI4 3
EQI4 $141
ADDRGP4 $132
JUMPV
line 253
;253:		case 1: break;
LABELV $136
line 255
;254:		case 2:
;255:		{
line 257
;256:			//tell the one not carrying the flag to attack the enemy base
;257:			if (teammates[0] != bs->flagcarrier) other = teammates[0];
ADDRLP4 4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
EQI4 $137
ADDRLP4 600
ADDRLP4 4
INDIRI4
ASGNI4
ADDRGP4 $138
JUMPV
LABELV $137
line 258
;258:			else other = teammates[1];
ADDRLP4 600
ADDRLP4 4+4
INDIRI4
ASGNI4
LABELV $138
line 259
;259:			ClientName(other, name, sizeof(name));
ADDRLP4 600
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 260
;260:			BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 261
;261:			BotSayTeamOrder(bs, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 600
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 262
;262:			break;
ADDRGP4 $133
JUMPV
LABELV $141
line 265
;263:		}
;264:		case 3:
;265:		{
line 267
;266:			//tell the one closest to the base not carrying the flag to accompany the flag carrier
;267:			if (teammates[0] != bs->flagcarrier) other = teammates[0];
ADDRLP4 4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
EQI4 $142
ADDRLP4 600
ADDRLP4 4
INDIRI4
ASGNI4
ADDRGP4 $143
JUMPV
LABELV $142
line 268
;268:			else other = teammates[1];
ADDRLP4 600
ADDRLP4 4+4
INDIRI4
ASGNI4
LABELV $143
line 269
;269:			ClientName(other, name, sizeof(name));
ADDRLP4 600
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 270
;270:			ClientName(bs->flagcarrier, carriername, sizeof(carriername));
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ARGI4
ADDRLP4 564
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 271
;271:			if (bs->flagcarrier == bs->client) {
ADDRLP4 616
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 616
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ADDRLP4 616
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $145
line 272
;272:				BotAI_BotInitialChat(bs, "cmd_accompanyme", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $147
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 273
;273:			}
ADDRGP4 $146
JUMPV
LABELV $145
line 274
;274:			else {
line 275
;275:				BotAI_BotInitialChat(bs, "cmd_accompany", name, carriername, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $148
ARGP4
ADDRLP4 516
ARGP4
ADDRLP4 564
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 276
;276:			}
LABELV $146
line 277
;277:			BotSayTeamOrder(bs, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 600
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 279
;278:			//tell the one furthest from the the base not carrying the flag to get the enemy flag
;279:			if (teammates[2] != bs->flagcarrier) other = teammates[2];
ADDRLP4 4+8
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
EQI4 $149
ADDRLP4 600
ADDRLP4 4+8
INDIRI4
ASGNI4
ADDRGP4 $150
JUMPV
LABELV $149
line 280
;280:			else other = teammates[1];
ADDRLP4 600
ADDRLP4 4+4
INDIRI4
ASGNI4
LABELV $150
line 281
;281:			ClientName(other, name, sizeof(name));
ADDRLP4 600
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 282
;282:			BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 283
;283:			BotSayTeamOrder(bs, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 600
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 284
;284:			break;
ADDRGP4 $133
JUMPV
LABELV $132
line 287
;285:		}
;286:		default:
;287:		{
line 288
;288:			defenders = (int) (float) numteammates * 0.4 + 0.5;
ADDRLP4 556
CNSTF4 1053609165
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 289
;289:			if (defenders > 4) defenders = 4;
ADDRLP4 556
INDIRI4
CNSTI4 4
LEI4 $154
ADDRLP4 556
CNSTI4 4
ASGNI4
LABELV $154
line 290
;290:			attackers = (int) (float) numteammates * 0.5 + 0.5;
ADDRLP4 616
CNSTF4 1056964608
ASGNF4
ADDRLP4 560
ADDRLP4 616
INDIRF4
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
ADDRLP4 616
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 291
;291:			if (attackers > 5) attackers = 5;
ADDRLP4 560
INDIRI4
CNSTI4 5
LEI4 $156
ADDRLP4 560
CNSTI4 5
ASGNI4
LABELV $156
line 292
;292:			ClientName(bs->flagcarrier, carriername, sizeof(carriername));
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ARGI4
ADDRLP4 564
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 293
;293:			for (i = 0; i < defenders; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $161
JUMPV
LABELV $158
line 295
;294:				//
;295:				if (teammates[i] == bs->flagcarrier) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
NEI4 $162
line 296
;296:					continue;
ADDRGP4 $159
JUMPV
LABELV $162
line 299
;297:				}
;298:				//
;299:				ClientName(teammates[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 300
;300:				if (bs->flagcarrier == bs->client) {
ADDRLP4 620
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 620
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ADDRLP4 620
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $164
line 301
;301:					BotAI_BotInitialChat(bs, "cmd_accompanyme", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $147
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 302
;302:				}
ADDRGP4 $165
JUMPV
LABELV $164
line 303
;303:				else {
line 304
;304:					BotAI_BotInitialChat(bs, "cmd_accompany", name, carriername, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $148
ARGP4
ADDRLP4 516
ARGP4
ADDRLP4 564
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 305
;305:				}
LABELV $165
line 306
;306:				BotSayTeamOrder(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 307
;307:			}
LABELV $159
line 293
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $161
ADDRLP4 0
INDIRI4
ADDRLP4 556
INDIRI4
LTI4 $158
line 308
;308:			for (i = 0; i < attackers; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $169
JUMPV
LABELV $166
line 310
;309:				//
;310:				if (teammates[numteammates - i - 1] == bs->flagcarrier) {
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
NEI4 $170
line 311
;311:					continue;
ADDRGP4 $167
JUMPV
LABELV $170
line 314
;312:				}
;313:				//
;314:				ClientName(teammates[numteammates - i - 1], name, sizeof(name));
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 315
;315:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 316
;316:				BotSayTeamOrder(bs, teammates[numteammates - i - 1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 317
;317:			}
LABELV $167
line 308
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $169
ADDRLP4 0
INDIRI4
ADDRLP4 560
INDIRI4
LTI4 $166
line 319
;318:			//
;319:			break;
LABELV $133
line 322
;320:		}
;321:	}
;322:}
LABELV $131
endproc BotCTFOrders_BothFlagsNotAtBase 624 20
export BotCTFOrders_FlagNotAtBase
proc BotCTFOrders_FlagNotAtBase 576 16
line 329
;323:
;324:/*
;325:==================
;326:BotCTFOrders
;327:==================
;328:*/
;329:void BotCTFOrders_FlagNotAtBase(bot_state_t *bs) {
line 334
;330:	int numteammates, defenders, attackers, i;
;331:	int teammates[MAX_CLIENTS];
;332:	char name[MAX_NETNAME];
;333:
;334:	numteammates = BotSortTeamMatesByBaseTravelTime(bs, teammates, sizeof(teammates));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 564
ADDRGP4 BotSortTeamMatesByBaseTravelTime
CALLI4
ASGNI4
ADDRLP4 552
ADDRLP4 564
INDIRI4
ASGNI4
line 335
;335:	BotSortTeamMatesByCTFPreference(bs, teammates, numteammates);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 552
INDIRI4
ARGI4
ADDRGP4 BotSortTeamMatesByCTFPreference
CALLI4
pop
line 337
;336:	//passive strategy
;337:	if (bs->ctfstrategy & CTFS_PASSIVE)
ADDRFP4 0
INDIRP4
CNSTI4 6512
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $176
line 338
;338:	{
line 340
;339:		//different orders based on the number of team mates
;340:		switch(bs->numteammates) {
ADDRLP4 568
ADDRFP4 0
INDIRP4
CNSTI4 6488
ADDP4
INDIRI4
ASGNI4
ADDRLP4 568
INDIRI4
CNSTI4 1
EQI4 $177
ADDRLP4 568
INDIRI4
CNSTI4 2
EQI4 $182
ADDRLP4 568
INDIRI4
CNSTI4 3
EQI4 $185
ADDRGP4 $178
JUMPV
line 341
;341:			case 1: break;
LABELV $182
line 343
;342:			case 2:
;343:			{
line 345
;344:				//both will go for the enemy flag
;345:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 346
;346:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 347
;347:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 349
;348:				//
;349:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 350
;350:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 351
;351:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 352
;352:				break;
ADDRGP4 $177
JUMPV
LABELV $185
line 355
;353:			}
;354:			case 3:
;355:			{
line 357
;356:				//keep one near the base for when the flag is returned
;357:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 358
;358:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 359
;359:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 361
;360:				//the other two get the flag
;361:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 362
;362:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 363
;363:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 365
;364:				//
;365:				ClientName(teammates[2], name, sizeof(name));
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 366
;366:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 367
;367:				BotSayTeamOrder(bs, teammates[2]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 368
;368:				break;
ADDRGP4 $177
JUMPV
LABELV $178
line 371
;369:			}
;370:			default:
;371:			{
line 373
;372:				//keep some people near the base for when the flag is returned
;373:				defenders = (int) (float) numteammates * 0.3 + 0.5;
ADDRLP4 556
CNSTF4 1050253722
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 374
;374:				if (defenders > 2) defenders = 2;
ADDRLP4 556
INDIRI4
CNSTI4 2
LEI4 $191
ADDRLP4 556
CNSTI4 2
ASGNI4
LABELV $191
line 375
;375:				attackers = (int) (float) numteammates * 0.7 + 0.5;
ADDRLP4 560
CNSTF4 1060320051
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 376
;376:				if (attackers > 5) attackers = 5;
ADDRLP4 560
INDIRI4
CNSTI4 5
LEI4 $193
ADDRLP4 560
CNSTI4 5
ASGNI4
LABELV $193
line 377
;377:				for (i = 0; i < defenders; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $198
JUMPV
LABELV $195
line 379
;378:					//
;379:					ClientName(teammates[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 380
;380:					BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 381
;381:					BotSayTeamOrder(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 382
;382:				}
LABELV $196
line 377
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $198
ADDRLP4 0
INDIRI4
ADDRLP4 556
INDIRI4
LTI4 $195
line 383
;383:				for (i = 0; i < attackers; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $202
JUMPV
LABELV $199
line 385
;384:					//
;385:					ClientName(teammates[numteammates - i - 1], name, sizeof(name));
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 386
;386:					BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 387
;387:					BotSayTeamOrder(bs, teammates[numteammates - i - 1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 388
;388:				}
LABELV $200
line 383
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $202
ADDRLP4 0
INDIRI4
ADDRLP4 560
INDIRI4
LTI4 $199
line 390
;389:				//
;390:				break;
line 393
;391:			}
;392:		}
;393:	}
ADDRGP4 $177
JUMPV
LABELV $176
line 395
;394:	//agressive
;395:	else {
line 397
;396:		//different orders based on the number of team mates
;397:		switch(bs->numteammates) {
ADDRLP4 568
ADDRFP4 0
INDIRP4
CNSTI4 6488
ADDP4
INDIRI4
ASGNI4
ADDRLP4 568
INDIRI4
CNSTI4 1
EQI4 $206
ADDRLP4 568
INDIRI4
CNSTI4 2
EQI4 $209
ADDRLP4 568
INDIRI4
CNSTI4 3
EQI4 $212
ADDRGP4 $205
JUMPV
line 398
;398:			case 1: break;
LABELV $209
line 400
;399:			case 2:
;400:			{
line 402
;401:				//both will go for the enemy flag
;402:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 403
;403:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 404
;404:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 406
;405:				//
;406:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 407
;407:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 408
;408:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 409
;409:				break;
ADDRGP4 $206
JUMPV
LABELV $212
line 412
;410:			}
;411:			case 3:
;412:			{
line 414
;413:				//everyone go for the flag
;414:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 415
;415:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 416
;416:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 418
;417:				//
;418:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 419
;419:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 420
;420:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 422
;421:				//
;422:				ClientName(teammates[2], name, sizeof(name));
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 423
;423:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 424
;424:				BotSayTeamOrder(bs, teammates[2]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 425
;425:				break;
ADDRGP4 $206
JUMPV
LABELV $205
line 428
;426:			}
;427:			default:
;428:			{
line 430
;429:				//keep some people near the base for when the flag is returned
;430:				defenders = (int) (float) numteammates * 0.2 + 0.5;
ADDRLP4 556
CNSTF4 1045220557
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 431
;431:				if (defenders > 2) defenders = 2;
ADDRLP4 556
INDIRI4
CNSTI4 2
LEI4 $217
ADDRLP4 556
CNSTI4 2
ASGNI4
LABELV $217
line 432
;432:				attackers = (int) (float) numteammates * 0.7 + 0.5;
ADDRLP4 560
CNSTF4 1060320051
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 433
;433:				if (attackers > 5) attackers = 5;
ADDRLP4 560
INDIRI4
CNSTI4 5
LEI4 $219
ADDRLP4 560
CNSTI4 5
ASGNI4
LABELV $219
line 434
;434:				for (i = 0; i < defenders; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $224
JUMPV
LABELV $221
line 436
;435:					//
;436:					ClientName(teammates[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 437
;437:					BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 438
;438:					BotSayTeamOrder(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 439
;439:				}
LABELV $222
line 434
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $224
ADDRLP4 0
INDIRI4
ADDRLP4 556
INDIRI4
LTI4 $221
line 440
;440:				for (i = 0; i < attackers; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $228
JUMPV
LABELV $225
line 442
;441:					//
;442:					ClientName(teammates[numteammates - i - 1], name, sizeof(name));
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 443
;443:					BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 444
;444:					BotSayTeamOrder(bs, teammates[numteammates - i - 1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 445
;445:				}
LABELV $226
line 440
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $228
ADDRLP4 0
INDIRI4
ADDRLP4 560
INDIRI4
LTI4 $225
line 447
;446:				//
;447:				break;
LABELV $206
line 450
;448:			}
;449:		}
;450:	}
LABELV $177
line 451
;451:}
LABELV $175
endproc BotCTFOrders_FlagNotAtBase 576 16
export BotCTFOrders_EnemyFlagNotAtBase
proc BotCTFOrders_EnemyFlagNotAtBase 620 20
line 458
;452:
;453:/*
;454:==================
;455:BotCTFOrders
;456:==================
;457:*/
;458:void BotCTFOrders_EnemyFlagNotAtBase(bot_state_t *bs) {
line 463
;459:	int numteammates, defenders, attackers, i, other;
;460:	int teammates[MAX_CLIENTS];
;461:	char name[MAX_NETNAME], carriername[MAX_NETNAME];
;462:
;463:	numteammates = BotSortTeamMatesByBaseTravelTime(bs, teammates, sizeof(teammates));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 604
ADDRGP4 BotSortTeamMatesByBaseTravelTime
CALLI4
ASGNI4
ADDRLP4 552
ADDRLP4 604
INDIRI4
ASGNI4
line 464
;464:	BotSortTeamMatesByCTFPreference(bs, teammates, numteammates);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 552
INDIRI4
ARGI4
ADDRGP4 BotSortTeamMatesByCTFPreference
CALLI4
pop
line 466
;465:	//different orders based on the number of team mates
;466:	switch(numteammates) {
ADDRLP4 552
INDIRI4
CNSTI4 1
EQI4 $233
ADDRLP4 552
INDIRI4
CNSTI4 2
EQI4 $235
ADDRLP4 552
INDIRI4
CNSTI4 3
EQI4 $239
ADDRGP4 $232
JUMPV
line 467
;467:		case 1: break;
LABELV $235
line 469
;468:		case 2:
;469:		{
line 471
;470:			//tell the one not carrying the flag to defend the base
;471:			if (teammates[0] == bs->flagcarrier) other = teammates[1];
ADDRLP4 4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
NEI4 $236
ADDRLP4 600
ADDRLP4 4+4
INDIRI4
ASGNI4
ADDRGP4 $237
JUMPV
LABELV $236
line 472
;472:			else other = teammates[0];
ADDRLP4 600
ADDRLP4 4
INDIRI4
ASGNI4
LABELV $237
line 473
;473:			ClientName(other, name, sizeof(name));
ADDRLP4 600
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 474
;474:			BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 475
;475:			BotSayTeamOrder(bs, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 600
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 476
;476:			break;
ADDRGP4 $233
JUMPV
LABELV $239
line 479
;477:		}
;478:		case 3:
;479:		{
line 481
;480:			//tell the one closest to the base not carrying the flag to defend the base
;481:			if (teammates[0] != bs->flagcarrier) other = teammates[0];
ADDRLP4 4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
EQI4 $240
ADDRLP4 600
ADDRLP4 4
INDIRI4
ASGNI4
ADDRGP4 $241
JUMPV
LABELV $240
line 482
;482:			else other = teammates[1];
ADDRLP4 600
ADDRLP4 4+4
INDIRI4
ASGNI4
LABELV $241
line 483
;483:			ClientName(other, name, sizeof(name));
ADDRLP4 600
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 484
;484:			BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 485
;485:			BotSayTeamOrder(bs, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 600
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 487
;486:			//tell the one furthest from the base not carrying the flag to accompany the flag carrier
;487:			if (teammates[2] != bs->flagcarrier) other = teammates[2];
ADDRLP4 4+8
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
EQI4 $243
ADDRLP4 600
ADDRLP4 4+8
INDIRI4
ASGNI4
ADDRGP4 $244
JUMPV
LABELV $243
line 488
;488:			else other = teammates[1];
ADDRLP4 600
ADDRLP4 4+4
INDIRI4
ASGNI4
LABELV $244
line 489
;489:			ClientName(other, name, sizeof(name));
ADDRLP4 600
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 490
;490:			ClientName(bs->flagcarrier, carriername, sizeof(carriername));
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ARGI4
ADDRLP4 564
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 491
;491:			if (bs->flagcarrier == bs->client) {
ADDRLP4 612
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 612
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ADDRLP4 612
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $248
line 492
;492:				BotAI_BotInitialChat(bs, "cmd_accompanyme", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $147
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 493
;493:			}
ADDRGP4 $249
JUMPV
LABELV $248
line 494
;494:			else {
line 495
;495:				BotAI_BotInitialChat(bs, "cmd_accompany", name, carriername, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $148
ARGP4
ADDRLP4 516
ARGP4
ADDRLP4 564
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 496
;496:			}
LABELV $249
line 497
;497:			BotSayTeamOrder(bs, other);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 600
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 498
;498:			break;
ADDRGP4 $233
JUMPV
LABELV $232
line 501
;499:		}
;500:		default:
;501:		{
line 503
;502:			//40% will defend the base
;503:			defenders = (int) (float) numteammates * 0.4 + 0.5;
ADDRLP4 556
CNSTF4 1053609165
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 504
;504:			if (defenders > 4) defenders = 4;
ADDRLP4 556
INDIRI4
CNSTI4 4
LEI4 $250
ADDRLP4 556
CNSTI4 4
ASGNI4
LABELV $250
line 506
;505:			//50% accompanies the flag carrier
;506:			attackers = (int) (float) numteammates * 0.5 + 0.5;
ADDRLP4 612
CNSTF4 1056964608
ASGNF4
ADDRLP4 560
ADDRLP4 612
INDIRF4
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
ADDRLP4 612
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 507
;507:			if (attackers > 5) attackers = 5;
ADDRLP4 560
INDIRI4
CNSTI4 5
LEI4 $252
ADDRLP4 560
CNSTI4 5
ASGNI4
LABELV $252
line 508
;508:			for (i = 0; i < defenders; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $257
JUMPV
LABELV $254
line 510
;509:				//
;510:				if (teammates[i] == bs->flagcarrier) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
NEI4 $258
line 511
;511:					continue;
ADDRGP4 $255
JUMPV
LABELV $258
line 513
;512:				}
;513:				ClientName(teammates[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 514
;514:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 515
;515:				BotSayTeamOrder(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 516
;516:			}
LABELV $255
line 508
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $257
ADDRLP4 0
INDIRI4
ADDRLP4 556
INDIRI4
LTI4 $254
line 517
;517:			ClientName(bs->flagcarrier, carriername, sizeof(carriername));
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ARGI4
ADDRLP4 564
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 518
;518:			for (i = 0; i < attackers; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $263
JUMPV
LABELV $260
line 520
;519:				//
;520:				if (teammates[numteammates - i - 1] == bs->flagcarrier) {
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
NEI4 $264
line 521
;521:					continue;
ADDRGP4 $261
JUMPV
LABELV $264
line 524
;522:				}
;523:				//
;524:				ClientName(teammates[numteammates - i - 1], name, sizeof(name));
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 525
;525:				if (bs->flagcarrier == bs->client) {
ADDRLP4 616
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 616
INDIRP4
CNSTI4 6508
ADDP4
INDIRI4
ADDRLP4 616
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $268
line 526
;526:					BotAI_BotInitialChat(bs, "cmd_accompanyme", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $147
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 527
;527:				}
ADDRGP4 $269
JUMPV
LABELV $268
line 528
;528:				else {
line 529
;529:					BotAI_BotInitialChat(bs, "cmd_accompany", name, carriername, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $148
ARGP4
ADDRLP4 516
ARGP4
ADDRLP4 564
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 530
;530:				}
LABELV $269
line 531
;531:				BotSayTeamOrder(bs, teammates[numteammates - i - 1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 532
;532:			}
LABELV $261
line 518
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $263
ADDRLP4 0
INDIRI4
ADDRLP4 560
INDIRI4
LTI4 $260
line 534
;533:			//
;534:			break;
LABELV $233
line 537
;535:		}
;536:	}
;537:}
LABELV $231
endproc BotCTFOrders_EnemyFlagNotAtBase 620 20
export BotCTFOrders_BothFlagsAtBase
proc BotCTFOrders_BothFlagsAtBase 576 16
line 545
;538:
;539:
;540:/*
;541:==================
;542:BotCTFOrders
;543:==================
;544:*/
;545:void BotCTFOrders_BothFlagsAtBase(bot_state_t *bs) {
line 551
;546:	int numteammates, defenders, attackers, i;
;547:	int teammates[MAX_CLIENTS];
;548:	char name[MAX_NETNAME];
;549:
;550:	//sort team mates by travel time to base
;551:	numteammates = BotSortTeamMatesByBaseTravelTime(bs, teammates, sizeof(teammates));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 564
ADDRGP4 BotSortTeamMatesByBaseTravelTime
CALLI4
ASGNI4
ADDRLP4 552
ADDRLP4 564
INDIRI4
ASGNI4
line 553
;552:	//sort team mates by CTF preference
;553:	BotSortTeamMatesByCTFPreference(bs, teammates, numteammates);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 552
INDIRI4
ARGI4
ADDRGP4 BotSortTeamMatesByCTFPreference
CALLI4
pop
line 555
;554:	//passive strategy
;555:	if (bs->ctfstrategy & CTFS_PASSIVE)
ADDRFP4 0
INDIRP4
CNSTI4 6512
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $272
line 556
;556:	{
line 558
;557:		//different orders based on the number of team mates
;558:		switch(numteammates) {
ADDRLP4 552
INDIRI4
CNSTI4 1
EQI4 $273
ADDRLP4 552
INDIRI4
CNSTI4 2
EQI4 $277
ADDRLP4 552
INDIRI4
CNSTI4 3
EQI4 $280
ADDRGP4 $274
JUMPV
line 559
;559:			case 1: break;
LABELV $277
line 561
;560:			case 2:
;561:			{
line 563
;562:				//the one closest to the base will defend the base
;563:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 564
;564:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 565
;565:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 567
;566:				//the other will get the flag
;567:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 568
;568:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 569
;569:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 570
;570:				break;
ADDRGP4 $273
JUMPV
LABELV $280
line 573
;571:			}
;572:			case 3:
;573:			{
line 575
;574:				//the one closest to the base will defend the base
;575:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 576
;576:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 577
;577:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 579
;578:				//the second one closest to the base will defend the base
;579:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 580
;580:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 581
;581:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 583
;582:				//the other will get the flag
;583:				ClientName(teammates[2], name, sizeof(name));
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 584
;584:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 585
;585:				BotSayTeamOrder(bs, teammates[2]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 586
;586:				break;
ADDRGP4 $273
JUMPV
LABELV $274
line 589
;587:			}
;588:			default:
;589:			{
line 590
;590:				defenders = (int) (float) numteammates * 0.5 + 0.5;
ADDRLP4 572
CNSTF4 1056964608
ASGNF4
ADDRLP4 556
ADDRLP4 572
INDIRF4
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
ADDRLP4 572
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 591
;591:				if (defenders > 5) defenders = 5;
ADDRLP4 556
INDIRI4
CNSTI4 5
LEI4 $285
ADDRLP4 556
CNSTI4 5
ASGNI4
LABELV $285
line 592
;592:				attackers = (int) (float) numteammates * 0.4 + 0.5;
ADDRLP4 560
CNSTF4 1053609165
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 593
;593:				if (attackers > 4) attackers = 4;
ADDRLP4 560
INDIRI4
CNSTI4 4
LEI4 $287
ADDRLP4 560
CNSTI4 4
ASGNI4
LABELV $287
line 594
;594:				for (i = 0; i < defenders; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $292
JUMPV
LABELV $289
line 596
;595:					//
;596:					ClientName(teammates[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 597
;597:					BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 598
;598:					BotSayTeamOrder(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 599
;599:				}
LABELV $290
line 594
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $292
ADDRLP4 0
INDIRI4
ADDRLP4 556
INDIRI4
LTI4 $289
line 600
;600:				for (i = 0; i < attackers; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $296
JUMPV
LABELV $293
line 602
;601:					//
;602:					ClientName(teammates[numteammates - i - 1], name, sizeof(name));
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 603
;603:					BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 604
;604:					BotSayTeamOrder(bs, teammates[numteammates - i - 1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 605
;605:				}
LABELV $294
line 600
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $296
ADDRLP4 0
INDIRI4
ADDRLP4 560
INDIRI4
LTI4 $293
line 607
;606:				//
;607:				break;
line 610
;608:			}
;609:		}
;610:	}
ADDRGP4 $273
JUMPV
LABELV $272
line 611
;611:	else { //agressive
line 613
;612:		//different orders based on the number of team mates
;613:		switch(numteammates) {
ADDRLP4 552
INDIRI4
CNSTI4 1
EQI4 $300
ADDRLP4 552
INDIRI4
CNSTI4 2
EQI4 $302
ADDRLP4 552
INDIRI4
CNSTI4 3
EQI4 $305
ADDRGP4 $299
JUMPV
line 614
;614:			case 1: break;
LABELV $302
line 616
;615:			case 2:
;616:			{
line 618
;617:				//the one closest to the base will defend the base
;618:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 619
;619:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 620
;620:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 622
;621:				//the other will get the flag
;622:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 623
;623:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 624
;624:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 625
;625:				break;
ADDRGP4 $300
JUMPV
LABELV $305
line 628
;626:			}
;627:			case 3:
;628:			{
line 630
;629:				//the one closest to the base will defend the base
;630:				ClientName(teammates[0], name, sizeof(name));
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 631
;631:				BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 632
;632:				BotSayTeamOrder(bs, teammates[0]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 634
;633:				//the others should go for the enemy flag
;634:				ClientName(teammates[1], name, sizeof(name));
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 635
;635:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 636
;636:				BotSayTeamOrder(bs, teammates[1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 638
;637:				//
;638:				ClientName(teammates[2], name, sizeof(name));
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 639
;639:				BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 640
;640:				BotSayTeamOrder(bs, teammates[2]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4+8
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 641
;641:				break;
ADDRGP4 $300
JUMPV
LABELV $299
line 644
;642:			}
;643:			default:
;644:			{
line 645
;645:				defenders = (int) (float) numteammates * 0.4 + 0.5;
ADDRLP4 556
CNSTF4 1053609165
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
CVFI4 4
ASGNI4
line 646
;646:				if (defenders > 4) defenders = 4;
ADDRLP4 556
INDIRI4
CNSTI4 4
LEI4 $310
ADDRLP4 556
CNSTI4 4
ASGNI4
LABELV $310
line 647
;647:				attackers = (int) (float) numteammates * 0.5 + 0.5;
ADDRLP4 572
CNSTF4 1056964608
ASGNF4
ADDRLP4 560
ADDRLP4 572
INDIRF4
ADDRLP4 552
INDIRI4
CVIF4 4
CVFI4 4
CVIF4 4
MULF4
ADDRLP4 572
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 648
;648:				if (attackers > 5) attackers = 5;
ADDRLP4 560
INDIRI4
CNSTI4 5
LEI4 $312
ADDRLP4 560
CNSTI4 5
ASGNI4
LABELV $312
line 649
;649:				for (i = 0; i < defenders; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $317
JUMPV
LABELV $314
line 651
;650:					//
;651:					ClientName(teammates[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 652
;652:					BotAI_BotInitialChat(bs, "cmd_defendbase", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $186
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 653
;653:					BotSayTeamOrder(bs, teammates[i]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 654
;654:				}
LABELV $315
line 649
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $317
ADDRLP4 0
INDIRI4
ADDRLP4 556
INDIRI4
LTI4 $314
line 655
;655:				for (i = 0; i < attackers; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $321
JUMPV
LABELV $318
line 657
;656:					//
;657:					ClientName(teammates[numteammates - i - 1], name, sizeof(name));
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 658
;658:					BotAI_BotInitialChat(bs, "cmd_getflag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $140
ARGP4
ADDRLP4 516
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 659
;659:					BotSayTeamOrder(bs, teammates[numteammates - i - 1]);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 552
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 2
LSHI4
ADDRLP4 4-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotSayTeamOrder
CALLV
pop
line 660
;660:				}
LABELV $319
line 655
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $321
ADDRLP4 0
INDIRI4
ADDRLP4 560
INDIRI4
LTI4 $318
line 662
;661:				//
;662:				break;
LABELV $300
line 665
;663:			}
;664:		}
;665:	}
LABELV $273
line 666
;666:}
LABELV $271
endproc BotCTFOrders_BothFlagsAtBase 576 16
export BotTeamOrders
proc BotTeamOrders 0 0
line 674
;667:
;668:
;669:/*
;670:==================
;671:BotTeamOrders
;672:==================
;673:*/
;674:void BotTeamOrders(bot_state_t *bs) {
line 676
;675:	//no teamplay orders at this time
;676:}
LABELV $324
endproc BotTeamOrders 0 0
export BotTeamAI
proc BotTeamAI 100 12
line 684
;677:
;678:
;679:/*
;680:==================
;681:BotTeamAI
;682:==================
;683:*/
;684:void BotTeamAI(bot_state_t *bs) {
line 689
;685:	int numteammates, flagstatus;
;686:	char netname[MAX_NETNAME];
;687:
;688:	//
;689:	if (gametype != GT_TEAM && gametype != GT_CTF) return;
ADDRLP4 44
ADDRGP4 gametype
INDIRI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 3
EQI4 $326
ADDRLP4 44
INDIRI4
CNSTI4 4
EQI4 $326
ADDRGP4 $325
JUMPV
LABELV $326
line 691
;690:	//make sure we've got a valid team leader
;691:	if (!BotValidTeamLeader(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 BotValidTeamLeader
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 0
NEI4 $328
line 693
;692:		//
;693:		if (!bs->askteamleader_time && !bs->becometeamleader_time) {
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
CNSTF4 0
ASGNF4
ADDRLP4 52
INDIRP4
CNSTI4 6472
ADDP4
INDIRF4
ADDRLP4 56
INDIRF4
NEF4 $330
ADDRLP4 52
INDIRP4
CNSTI4 6476
ADDP4
INDIRF4
ADDRLP4 56
INDIRF4
NEF4 $330
line 694
;694:			if (bs->entergame_time + 10 > trap_AAS_Time()) {
ADDRLP4 60
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6036
ADDP4
INDIRF4
CNSTF4 1092616192
ADDF4
ADDRLP4 60
INDIRF4
LEF4 $332
line 695
;695:				bs->askteamleader_time = trap_AAS_Time() + 5 + random() * 10;
ADDRLP4 64
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6472
ADDP4
ADDRLP4 64
INDIRF4
CNSTF4 1084227584
ADDF4
CNSTF4 1092616192
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 696
;696:			}
ADDRGP4 $333
JUMPV
LABELV $332
line 697
;697:			else {
line 698
;698:				bs->becometeamleader_time = trap_AAS_Time() + 5 + random() * 10;
ADDRLP4 64
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6476
ADDP4
ADDRLP4 64
INDIRF4
CNSTF4 1084227584
ADDF4
CNSTF4 1092616192
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 699
;699:			}
LABELV $333
line 700
;700:		}
LABELV $330
line 701
;701:		if (bs->askteamleader_time && bs->askteamleader_time < trap_AAS_Time()) {
ADDRLP4 60
ADDRFP4 0
INDIRP4
CNSTI4 6472
ADDP4
INDIRF4
ASGNF4
ADDRLP4 60
INDIRF4
CNSTF4 0
EQF4 $334
ADDRLP4 64
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 60
INDIRF4
ADDRLP4 64
INDIRF4
GEF4 $334
line 703
;702:			//if asked for a team leader and no repsonse
;703:			BotAI_BotInitialChat(bs, "whoisteamleader", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $336
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 704
;704:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 68
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 705
;705:			bs->askteamleader_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6472
ADDP4
CNSTF4 0
ASGNF4
line 706
;706:			bs->becometeamleader_time = trap_AAS_Time() + 15 + random() * 10;
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6476
ADDP4
ADDRLP4 72
INDIRF4
CNSTF4 1097859072
ADDF4
CNSTF4 1092616192
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 707
;707:		}
LABELV $334
line 708
;708:		if (bs->becometeamleader_time && bs->becometeamleader_time < trap_AAS_Time()) {
ADDRLP4 68
ADDRFP4 0
INDIRP4
CNSTI4 6476
ADDP4
INDIRF4
ASGNF4
ADDRLP4 68
INDIRF4
CNSTF4 0
EQF4 $325
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
GEF4 $325
line 709
;709:			BotAI_BotInitialChat(bs, "iamteamleader", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $339
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 710
;710:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 711
;711:			ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 712
;712:			strncpy(bs->teamleader, netname, sizeof(bs->teamleader));
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 0
ARGP4
CNSTU4 32
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 713
;713:			bs->teamleader[sizeof(bs->teamleader)] = '\0';
ADDRFP4 0
INDIRP4
CNSTI4 6440
CNSTU4 32
ADDI4
ADDP4
CNSTI1 0
ASGNI1
line 714
;714:			bs->becometeamleader_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6476
ADDP4
CNSTF4 0
ASGNF4
line 715
;715:		}
line 716
;716:		return;
ADDRGP4 $325
JUMPV
LABELV $328
line 718
;717:	}
;718:	bs->askteamleader_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6472
ADDP4
CNSTF4 0
ASGNF4
line 719
;719:	bs->becometeamleader_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6476
ADDP4
CNSTF4 0
ASGNF4
line 722
;720:
;721:	//return if this bot is NOT the team leader
;722:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 723
;723:	if (Q_stricmp(netname, bs->teamleader) != 0) return;
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 52
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
EQI4 $340
ADDRGP4 $325
JUMPV
LABELV $340
line 727
;724:	//
;725:	//if the game starts OR a new player comes onto the team OR a player leaves the team
;726:	//
;727:	numteammates = BotNumTeamMates(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 BotNumTeamMates
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 56
INDIRI4
ASGNI4
line 729
;728:	//give orders
;729:	switch(gametype) {
ADDRLP4 60
ADDRGP4 gametype
INDIRI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 3
EQI4 $344
ADDRLP4 60
INDIRI4
CNSTI4 4
EQI4 $350
ADDRGP4 $342
JUMPV
LABELV $344
line 731
;730:		case GT_TEAM:
;731:		{
line 732
;732:			if (bs->numteammates != numteammates || bs->forceorders) {
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 6488
ADDP4
INDIRI4
ADDRLP4 36
INDIRI4
NEI4 $347
ADDRLP4 64
INDIRP4
CNSTI4 6504
ADDP4
INDIRI4
CNSTI4 0
EQI4 $345
LABELV $347
line 733
;733:				bs->teamgiveorders_time = trap_AAS_Time();
ADDRLP4 68
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
ADDRLP4 68
INDIRF4
ASGNF4
line 734
;734:				bs->numteammates = numteammates;
ADDRFP4 0
INDIRP4
CNSTI4 6488
ADDP4
ADDRLP4 36
INDIRI4
ASGNI4
line 735
;735:				bs->forceorders = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6504
ADDP4
CNSTI4 0
ASGNI4
line 736
;736:			}
LABELV $345
line 738
;737:			//if it's time to give orders
;738:			if (bs->teamgiveorders_time < trap_AAS_Time() - 5) {
ADDRLP4 68
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
INDIRF4
ADDRLP4 68
INDIRF4
CNSTF4 1084227584
SUBF4
GEF4 $343
line 739
;739:				BotTeamOrders(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotTeamOrders
CALLV
pop
line 741
;740:				//
;741:				bs->teamgiveorders_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
CNSTF4 0
ASGNF4
line 742
;742:			}
line 743
;743:			break;
ADDRGP4 $343
JUMPV
LABELV $350
line 746
;744:		}
;745:		case GT_CTF:
;746:		{
line 749
;747:			//if the number of team mates changed or the flag status changed
;748:			//or someone wants to know what to do
;749:			if (bs->numteammates != numteammates || bs->flagstatuschanged || bs->forceorders) {
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 6488
ADDP4
INDIRI4
ADDRLP4 36
INDIRI4
NEI4 $354
ADDRLP4 68
CNSTI4 0
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 6500
ADDP4
INDIRI4
ADDRLP4 68
INDIRI4
NEI4 $354
ADDRLP4 64
INDIRP4
CNSTI4 6504
ADDP4
INDIRI4
ADDRLP4 68
INDIRI4
EQI4 $351
LABELV $354
line 750
;750:				bs->teamgiveorders_time = trap_AAS_Time();
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 751
;751:				bs->numteammates = numteammates;
ADDRFP4 0
INDIRP4
CNSTI4 6488
ADDP4
ADDRLP4 36
INDIRI4
ASGNI4
line 752
;752:				bs->flagstatuschanged = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6500
ADDP4
CNSTI4 0
ASGNI4
line 753
;753:				bs->forceorders = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6504
ADDP4
CNSTI4 0
ASGNI4
line 754
;754:			}
LABELV $351
line 756
;755:			//if there were no flag captures the last 3 minutes
;756:			if (bs->lastflagcapture_time < trap_AAS_Time() - 240) {
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6484
ADDP4
INDIRF4
ADDRLP4 72
INDIRF4
CNSTF4 1131413504
SUBF4
GEF4 $355
line 757
;757:				bs->lastflagcapture_time = trap_AAS_Time();
ADDRLP4 76
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6484
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
line 759
;758:				//randomly change the CTF strategy
;759:				if (random() < 0.4) {
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1053609165
GEF4 $357
line 760
;760:					bs->ctfstrategy ^= CTFS_PASSIVE;
ADDRLP4 84
ADDRFP4 0
INDIRP4
CNSTI4 6512
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 761
;761:					bs->teamgiveorders_time = trap_AAS_Time();
ADDRLP4 88
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
ADDRLP4 88
INDIRF4
ASGNF4
line 762
;762:				}
LABELV $357
line 763
;763:			}
LABELV $355
line 765
;764:			//if it's time to give orders
;765:			if (bs->teamgiveorders_time && bs->teamgiveorders_time < trap_AAS_Time() - 3) {
ADDRLP4 76
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
INDIRF4
ASGNF4
ADDRLP4 76
INDIRF4
CNSTF4 0
EQF4 $343
ADDRLP4 80
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 76
INDIRF4
ADDRLP4 80
INDIRF4
CNSTF4 1077936128
SUBF4
GEF4 $343
line 767
;766:				//
;767:				if (BotCTFTeam(bs) == CTF_TEAM_RED) flagstatus = bs->redflagstatus * 2 + bs->blueflagstatus;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 84
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 84
INDIRI4
CNSTI4 1
NEI4 $361
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 88
INDIRP4
CNSTI4 6492
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ADDRLP4 88
INDIRP4
CNSTI4 6496
ADDP4
INDIRI4
ADDI4
ASGNI4
ADDRGP4 $362
JUMPV
LABELV $361
line 768
;768:				else flagstatus = bs->blueflagstatus * 2 + bs->redflagstatus;
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 92
INDIRP4
CNSTI4 6496
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ADDRLP4 92
INDIRP4
CNSTI4 6492
ADDP4
INDIRI4
ADDI4
ASGNI4
LABELV $362
line 770
;769:				//
;770:				switch(flagstatus) {
ADDRLP4 96
ADDRLP4 40
INDIRI4
ASGNI4
ADDRLP4 96
INDIRI4
CNSTI4 0
LTI4 $363
ADDRLP4 96
INDIRI4
CNSTI4 3
GTI4 $363
ADDRLP4 96
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $369
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $369
address $365
address $366
address $367
address $368
code
LABELV $365
line 771
;771:					case 0: BotCTFOrders_BothFlagsAtBase(bs); break;
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCTFOrders_BothFlagsAtBase
CALLV
pop
ADDRGP4 $364
JUMPV
LABELV $366
line 772
;772:					case 1: BotCTFOrders_EnemyFlagNotAtBase(bs); break;
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCTFOrders_EnemyFlagNotAtBase
CALLV
pop
ADDRGP4 $364
JUMPV
LABELV $367
line 773
;773:					case 2: BotCTFOrders_FlagNotAtBase(bs); break;
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCTFOrders_FlagNotAtBase
CALLV
pop
ADDRGP4 $364
JUMPV
LABELV $368
line 774
;774:					case 3: BotCTFOrders_BothFlagsNotAtBase(bs); break;
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCTFOrders_BothFlagsNotAtBase
CALLV
pop
LABELV $363
LABELV $364
line 777
;775:				}
;776:				//
;777:				bs->teamgiveorders_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6480
ADDP4
CNSTF4 0
ASGNF4
line 778
;778:			}
line 779
;779:			break;
LABELV $342
LABELV $343
line 782
;780:		}
;781:	}
;782:}
LABELV $325
endproc BotTeamAI 100 12
bss
export ctftaskpreferences
align 4
LABELV ctftaskpreferences
skip 5120
import BotDumpNodeSwitches
import BotResetNodeSwitches
import AINode_Battle_NBG
import AINode_Battle_Retreat
import AINode_Battle_Chase
import AINode_Battle_Fight
import AINode_Seek_LTG
import AINode_Seek_NBG
import AINode_Seek_ActivateEntity
import AINode_Stand
import AINode_Respawn
import AINode_Observer
import AINode_Intermission
import AIEnter_Battle_NBG
import AIEnter_Battle_Retreat
import AIEnter_Battle_Chase
import AIEnter_Battle_Fight
import AIEnter_Seek_Camp
import AIEnter_Seek_LTG
import AIEnter_Seek_NBG
import AIEnter_Seek_ActivateEntity
import AIEnter_Stand
import AIEnter_Respawn
import AIEnter_Observer
import AIEnter_Intermission
import BotPrintTeamGoal
import BotMatchMessage
import BotChatTest
import BotValidChatPosition
import BotChatTime
import BotChat_Random
import BotChat_EnemySuicide
import BotChat_Kill
import BotChat_Death
import BotChat_HitNoKill
import BotChat_HitNoDeath
import BotChat_HitTalking
import BotChat_EndLevel
import BotChat_StartLevel
import BotChat_ExitGame
import BotChat_EnterGame
import ctf_blueflag
import ctf_redflag
import bot_challenge
import bot_testrchat
import bot_nochat
import bot_fastchat
import bot_rocketjump
import bot_grapple
import maxclients
import gametype
import BotMapScripts
import BotPointAreaNum
import ClientFromName
import stristr
import BotFindWayPoint
import BotCreateWayPoint
import BotCTFRetreatGoals
import BotCTFSeekGoals
import BotCTFCarryingFlag
import BotCTFTeam
import BotAIBlocked
import BotCheckAttack
import BotAimAtEnemy
import BotEntityVisible
import BotRoamGoal
import BotFindEnemy
import BotTeamFlagCarrierVisible
import TeamPlayIsOn
import BotSameTeam
import BotAttackMove
import BotWantsToCamp
import BotCanAndWantsToRocketJump
import BotWantsToHelp
import BotWantsToChase
import BotWantsToRetreat
import BotAggression
import ClientSkin
import EasyClientName
import ClientName
import EntityIsShooting
import EntityIsInvisible
import EntityIsDead
import BotInLavaOrSlime
import BotIntermission
import BotIsObserver
import BotIsDead
import BotBattleUseItems
import BotUpdateBattleInventory
import BotUpdateInventory
import BotSetupForMovement
import BotChooseWeapon
import BotFreeWaypoints
import BotDeathmatchAI
import BotShutdownDeathmatchAI
import BotSetupDeathmatchAI
import BotTeamLeader
import BotAI_GetSnapshotEntity
import BotAI_GetEntityState
import BotAI_GetClientState
import BotAI_Trace
import BotAI_BotInitialChat
import BotAI_Print
import BotEntityInfo
import NumBots
import BotResetState
import BotResetWeaponState
import BotFreeWeaponState
import BotAllocWeaponState
import BotLoadWeaponWeights
import BotGetWeaponInfo
import BotChooseBestFightWeapon
import BotShutdownWeaponAI
import BotSetupWeaponAI
import BotShutdownMoveAI
import BotSetupMoveAI
import BotSetBrushModelTypes
import BotInitMoveState
import BotFreeMoveState
import BotAllocMoveState
import BotPredictVisiblePosition
import BotMovementViewTarget
import BotReachabilityArea
import BotResetLastAvoidReach
import BotResetAvoidReach
import BotMoveInDirection
import BotMoveToGoal
import BotResetMoveState
import BotShutdownGoalAI
import BotSetupGoalAI
import BotFreeGoalState
import BotAllocGoalState
import BotFreeItemWeights
import BotLoadItemWeights
import BotMutateGoalFuzzyLogic
import BotSaveGoalFuzzyLogic
import BotInterbreedGoalFuzzyLogic
import BotUpdateEntityItems
import BotInitLevelItems
import BotAvoidGoalTime
import BotGetMapLocationGoal
import BotGetNextCampSpotGoal
import BotGetLevelItemGoal
import BotItemGoalInVisButNotVisible
import BotTouchingGoal
import BotChooseNBGItem
import BotChooseLTGItem
import BotGetSecondGoal
import BotGetTopGoal
import BotGoalName
import BotDumpGoalStack
import BotDumpAvoidGoals
import BotEmptyGoalStack
import BotPopGoal
import BotPushGoal
import BotRemoveFromAvoidGoals
import BotResetAvoidGoals
import BotResetGoalState
import GeneticParentsAndChildSelection
import BotSetChatName
import BotSetChatGender
import BotLoadChatFile
import BotReplaceSynonyms
import UnifyWhiteSpaces
import BotMatchVariable
import BotFindMatch
import StringContains
import BotGetChatMessage
import BotEnterChat
import BotChatLength
import BotReplyChat
import BotNumInitialChats
import BotInitialChat
import BotNumConsoleMessages
import BotNextConsoleMessage
import BotRemoveConsoleMessage
import BotQueueConsoleMessage
import BotFreeChatState
import BotAllocChatState
import BotShutdownChatAI
import BotSetupChatAI
import BotShutdownCharacters
import Characteristic_String
import Characteristic_BInteger
import Characteristic_Integer
import Characteristic_BFloat
import Characteristic_Float
import BotFreeCharacter
import BotLoadCharacter
import EA_Shutdown
import EA_Setup
import EA_ResetInput
import EA_GetInput
import EA_EndRegular
import EA_View
import EA_Move
import EA_MoveRight
import EA_MoveLeft
import EA_MoveBack
import EA_MoveForward
import EA_MoveDown
import EA_MoveUp
import EA_Walk
import EA_Crouch
import EA_DelayedJump
import EA_Jump
import EA_Use
import EA_Gesture
import EA_Talk
import EA_Respawn
import EA_Attack
import EA_SelectWeapon
import EA_Command
import EA_DropInv
import EA_UseInv
import EA_DropItem
import EA_UseItem
import EA_SayTeam
import EA_Say
import GetBotLibAPI
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $339
byte 1 105
byte 1 97
byte 1 109
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 108
byte 1 101
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $336
byte 1 119
byte 1 104
byte 1 111
byte 1 105
byte 1 115
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 108
byte 1 101
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $186
byte 1 99
byte 1 109
byte 1 100
byte 1 95
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $148
byte 1 99
byte 1 109
byte 1 100
byte 1 95
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 0
align 1
LABELV $147
byte 1 99
byte 1 109
byte 1 100
byte 1 95
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $140
byte 1 99
byte 1 109
byte 1 100
byte 1 95
byte 1 103
byte 1 101
byte 1 116
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $130
byte 1 40
byte 1 37
byte 1 115
byte 1 41
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $67
byte 1 116
byte 1 0
align 1
LABELV $63
byte 1 110
byte 1 0
align 1
LABELV $56
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
