export BotAI_Print
code
proc BotAI_Print 2056 12
file "..\ai_main.c"
line 72
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:/*****************************************************************************
;5: * name:		ai_main.c
;6: *
;7: * desc:		Quake3 bot AI
;8: *
;9: * $Archive: /source/code/game/ai_main.c $
;10: * $Author: Raduffy $ 
;11: * $Revision: 7 $
;12: * $Modtime: 1/14/00 5:28p $
;13: * $Date: 1/14/00 5:35p $
;14: *
;15: *****************************************************************************/
;16:
;17:
;18:#include "g_local.h"
;19:#include "q_shared.h"
;20:#include "botlib.h"		//bot lib interface
;21:#include "be_aas.h"
;22:#include "be_ea.h"
;23:#include "be_ai_char.h"
;24:#include "be_ai_chat.h"
;25:#include "be_ai_gen.h"
;26:#include "be_ai_goal.h"
;27:#include "be_ai_move.h"
;28:#include "be_ai_weap.h"
;29://
;30:#include "ai_main.h"
;31:#include "ai_dmq3.h"
;32:#include "ai_chat.h"
;33:#include "ai_cmd.h"
;34:#include "ai_dmnet.h"
;35://
;36:#include "chars.h"
;37:#include "inv.h"
;38:#include "syn.h"
;39:
;40:#define MAX_PATH		144
;41:
;42:
;43://bot states
;44:bot_state_t	*botstates[MAX_CLIENTS];
;45://number of bots
;46:int numbots;
;47://time to do a regular update
;48:float regularupdate_time;
;49://
;50:int bot_interbreed;
;51:int bot_interbreedmatchcount;
;52://
;53:vmCvar_t bot_thinktime;
;54:vmCvar_t bot_memorydump;
;55:vmCvar_t bot_pause;
;56:vmCvar_t bot_report;
;57:vmCvar_t bot_testsolid;
;58:vmCvar_t bot_interbreedchar;
;59:vmCvar_t bot_interbreedbots;
;60:vmCvar_t bot_interbreedcycle;
;61:vmCvar_t bot_interbreedwrite;
;62:
;63:
;64:void ExitLevel( void );
;65:
;66:
;67:/*
;68:==================
;69:BotAI_Print
;70:==================
;71:*/
;72:void QDECL BotAI_Print(int type, char *fmt, ...) {
line 76
;73:	char str[2048];
;74:	va_list ap;
;75:
;76:	va_start(ap, fmt);
ADDRLP4 0
ADDRFP4 4+4
ASGNP4
line 77
;77:	vsprintf(str, fmt, ap);
ADDRLP4 4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 vsprintf
CALLI4
pop
line 78
;78:	va_end(ap);
ADDRLP4 0
CNSTP4 0
ASGNP4
line 80
;79:
;80:	switch(type) {
ADDRLP4 2052
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 2052
INDIRI4
CNSTI4 1
LTI4 $49
ADDRLP4 2052
INDIRI4
CNSTI4 5
GTI4 $49
ADDRLP4 2052
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $62-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $62
address $51
address $53
address $55
address $57
address $59
code
LABELV $51
line 81
;81:		case PRT_MESSAGE: {
line 82
;82:			G_Printf("%s", str);
ADDRGP4 $52
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 83
;83:			break;
ADDRGP4 $50
JUMPV
LABELV $53
line 85
;84:		}
;85:		case PRT_WARNING: {
line 86
;86:			G_Printf( S_COLOR_YELLOW "Warning: %s", str );
ADDRGP4 $54
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 87
;87:			break;
ADDRGP4 $50
JUMPV
LABELV $55
line 89
;88:		}
;89:		case PRT_ERROR: {
line 90
;90:			G_Printf( S_COLOR_RED "Error: %s", str );
ADDRGP4 $56
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 91
;91:			break;
ADDRGP4 $50
JUMPV
LABELV $57
line 93
;92:		}
;93:		case PRT_FATAL: {
line 94
;94:			G_Printf( S_COLOR_RED "Fatal: %s", str );
ADDRGP4 $58
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 95
;95:			break;
ADDRGP4 $50
JUMPV
LABELV $59
line 97
;96:		}
;97:		case PRT_EXIT: {
line 98
;98:			G_Error( S_COLOR_RED "Exit: %s", str );
ADDRGP4 $60
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 99
;99:			break;
ADDRGP4 $50
JUMPV
LABELV $49
line 101
;100:		}
;101:		default: {
line 102
;102:			G_Printf( "unknown print type\n" );
ADDRGP4 $61
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 103
;103:			break;
LABELV $50
line 106
;104:		}
;105:	}
;106:}
LABELV $47
endproc BotAI_Print 2056 12
export BotAI_Trace
proc BotAI_Trace 56 28
line 114
;107:
;108:
;109:/*
;110:==================
;111:BotAI_Trace
;112:==================
;113:*/
;114:void BotAI_Trace(bsp_trace_t *bsptrace, vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end, int passent, int contentmask) {
line 117
;115:	trace_t trace;
;116:
;117:	trap_Trace(&trace, start, mins, maxs, end, passent, contentmask);
ADDRLP4 0
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRFP4 20
INDIRI4
ARGI4
ADDRFP4 24
INDIRI4
ARGI4
ADDRGP4 trap_Trace
CALLV
pop
line 119
;118:	//copy the trace information
;119:	bsptrace->allsolid = trace.allsolid;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRI4
ASGNI4
line 120
;120:	bsptrace->startsolid = trace.startsolid;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 0+4
INDIRI4
ASGNI4
line 121
;121:	bsptrace->fraction = trace.fraction;
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 0+8
INDIRF4
ASGNF4
line 122
;122:	VectorCopy(trace.endpos, bsptrace->endpos);
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 0+12
INDIRB
ASGNB 12
line 123
;123:	bsptrace->plane.dist = trace.plane.dist;
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 0+24+12
INDIRF4
ASGNF4
line 124
;124:	VectorCopy(trace.plane.normal, bsptrace->plane.normal);
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 0+24
INDIRB
ASGNB 12
line 125
;125:	bsptrace->plane.signbits = trace.plane.signbits;
ADDRFP4 0
INDIRP4
CNSTI4 41
ADDP4
ADDRLP4 0+24+17
INDIRU1
ASGNU1
line 126
;126:	bsptrace->plane.type = trace.plane.type;
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0+24+16
INDIRU1
ASGNU1
line 127
;127:	bsptrace->surface.value = trace.surfaceFlags;
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 0+44
INDIRI4
ASGNI4
line 128
;128:	bsptrace->ent = trace.entityNum;
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 0+52
INDIRI4
ASGNI4
line 129
;129:	bsptrace->exp_dist = 0;
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 0
ASGNF4
line 130
;130:	bsptrace->sidenum = 0;
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 131
;131:	bsptrace->contents = 0;
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTI4 0
ASGNI4
line 132
;132:}
LABELV $64
endproc BotAI_Trace 56 28
export BotAI_GetClientState
proc BotAI_GetClientState 4 12
line 139
;133:
;134:/*
;135:==================
;136:BotAI_GetClientState
;137:==================
;138:*/
;139:int BotAI_GetClientState( int clientNum, playerState_t *state ) {
line 142
;140:	gentity_t	*ent;
;141:
;142:	ent = &g_entities[clientNum];
ADDRLP4 0
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 143
;143:	if ( !ent->inuse ) {
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $78
line 144
;144:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $77
JUMPV
LABELV $78
line 146
;145:	}
;146:	if ( !ent->client ) {
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $80
line 147
;147:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $77
JUMPV
LABELV $80
line 150
;148:	}
;149:
;150:	memcpy( state, &ent->client->ps, sizeof(playerState_t) );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
ARGP4
CNSTU4 444
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 151
;151:	return qtrue;
CNSTI4 1
RETI4
LABELV $77
endproc BotAI_GetClientState 4 12
export BotAI_GetEntityState
proc BotAI_GetEntityState 4 12
line 159
;152:}
;153:
;154:/*
;155:==================
;156:BotAI_GetEntityState
;157:==================
;158:*/
;159:int BotAI_GetEntityState( int entityNum, entityState_t *state ) {
line 162
;160:	gentity_t	*ent;
;161:
;162:	ent = &g_entities[entityNum];
ADDRLP4 0
CNSTI4 792
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 163
;163:	memset( state, 0, sizeof(entityState_t) );
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 204
ARGU4
ADDRGP4 memset
CALLP4
pop
line 164
;164:	if (!ent->inuse) return qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $83
CNSTI4 0
RETI4
ADDRGP4 $82
JUMPV
LABELV $83
line 165
;165:	if (!ent->r.linked) return qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRI4
CNSTI4 0
NEI4 $85
CNSTI4 0
RETI4
ADDRGP4 $82
JUMPV
LABELV $85
line 166
;166:	if (ent->r.svFlags & SVF_NOCLIENT) return qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $87
CNSTI4 0
RETI4
ADDRGP4 $82
JUMPV
LABELV $87
line 167
;167:	memcpy( state, &ent->s, sizeof(entityState_t) );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
CNSTU4 204
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 168
;168:	return qtrue;
CNSTI4 1
RETI4
LABELV $82
endproc BotAI_GetEntityState 4 12
export BotAI_GetSnapshotEntity
proc BotAI_GetSnapshotEntity 8 12
line 176
;169:}
;170:
;171:/*
;172:==================
;173:BotAI_GetSnapshotEntity
;174:==================
;175:*/
;176:int BotAI_GetSnapshotEntity( int clientNum, int sequence, entityState_t *state ) {
line 179
;177:	int		entNum;
;178:
;179:	entNum = trap_BotGetSnapshotEntity( clientNum, sequence );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 trap_BotGetSnapshotEntity
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
ASGNI4
line 180
;180:	if ( entNum == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $90
line 181
;181:		memset(state, 0, sizeof(entityState_t));
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 204
ARGU4
ADDRGP4 memset
CALLP4
pop
line 182
;182:		return -1;
CNSTI4 -1
RETI4
ADDRGP4 $89
JUMPV
LABELV $90
line 185
;183:	}
;184:
;185:	BotAI_GetEntityState( entNum, state );
ADDRLP4 0
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 BotAI_GetEntityState
CALLI4
pop
line 187
;186:
;187:	return sequence + 1;
ADDRFP4 4
INDIRI4
CNSTI4 1
ADDI4
RETI4
LABELV $89
endproc BotAI_GetSnapshotEntity 8 12
export BotAI_BotInitialChat
proc BotAI_BotInitialChat 56 44
line 195
;188:}
;189:
;190:/*
;191:==================
;192:BotAI_BotInitialChat
;193:==================
;194:*/
;195:void QDECL BotAI_BotInitialChat( bot_state_t *bs, char *type, ... ) {
line 201
;196:	int		i, mcontext;
;197:	va_list	ap;
;198:	char	*p;
;199:	char	*vars[MAX_MATCHVARIABLES];
;200:
;201:	memset(vars, 0, sizeof(vars));
ADDRLP4 8
ARGP4
CNSTI4 0
ARGI4
CNSTU4 32
ARGU4
ADDRGP4 memset
CALLP4
pop
line 202
;202:	va_start(ap, type);
ADDRLP4 40
ADDRFP4 4+4
ASGNP4
line 203
;203:	p = va_arg(ap, char *);
ADDRLP4 48
ADDRLP4 40
INDIRP4
CNSTU4 4
ADDP4
ASGNP4
ADDRLP4 40
ADDRLP4 48
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 48
INDIRP4
CNSTI4 -4
ADDP4
INDIRP4
ASGNP4
line 204
;204:	for (i = 0; i < MAX_MATCHVARIABLES; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $94
line 205
;205:		if( !p ) {
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $98
line 206
;206:			break;
ADDRGP4 $96
JUMPV
LABELV $98
line 208
;207:		}
;208:		vars[i] = p;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
ADDRLP4 4
INDIRP4
ASGNP4
line 209
;209:		p = va_arg(ap, char *);
ADDRLP4 52
ADDRLP4 40
INDIRP4
CNSTU4 4
ADDP4
ASGNP4
ADDRLP4 40
ADDRLP4 52
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 52
INDIRP4
CNSTI4 -4
ADDP4
INDIRP4
ASGNP4
line 210
;210:	}
LABELV $95
line 204
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 8
LTI4 $94
LABELV $96
line 211
;211:	va_end(ap);
ADDRLP4 40
CNSTP4 0
ASGNP4
line 213
;212:
;213:	mcontext = CONTEXT_NORMAL|CONTEXT_NEARBYITEM|CONTEXT_NAMES;
ADDRLP4 44
CNSTI4 1027
ASGNI4
line 214
;214:	if (BotCTFTeam(bs) == CTF_TEAM_RED) mcontext |= CONTEXT_CTFREDTEAM;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 1
NEI4 $100
ADDRLP4 44
ADDRLP4 44
INDIRI4
CNSTI4 4
BORI4
ASGNI4
ADDRGP4 $101
JUMPV
LABELV $100
line 215
;215:	else mcontext |= CONTEXT_CTFBLUETEAM;
ADDRLP4 44
ADDRLP4 44
INDIRI4
CNSTI4 8
BORI4
ASGNI4
LABELV $101
line 217
;216:
;217:	trap_BotInitialChat( bs->cs, type, mcontext, vars[0], vars[1], vars[2], vars[3], vars[4], vars[5], vars[6], vars[7] );
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8+4
INDIRP4
ARGP4
ADDRLP4 8+8
INDIRP4
ARGP4
ADDRLP4 8+12
INDIRP4
ARGP4
ADDRLP4 8+16
INDIRP4
ARGP4
ADDRLP4 8+20
INDIRP4
ARGP4
ADDRLP4 8+24
INDIRP4
ARGP4
ADDRLP4 8+28
INDIRP4
ARGP4
ADDRGP4 trap_BotInitialChat
CALLV
pop
line 218
;218:}
LABELV $92
endproc BotAI_BotInitialChat 56 44
export BotTestSolid
proc BotTestSolid 12 8
line 226
;219:
;220:
;221:/*
;222:==================
;223:BotTestSolid
;224:==================
;225:*/
;226:void BotTestSolid(vec3_t origin) {
line 229
;227:	int areanum;
;228:
;229:	trap_Cvar_Update(&bot_testsolid);
ADDRGP4 bot_testsolid
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 230
;230:	if (bot_testsolid.integer) {
ADDRGP4 bot_testsolid+12
INDIRI4
CNSTI4 0
EQI4 $110
line 231
;231:		if (!trap_AAS_Initialized()) return;
ADDRLP4 4
ADDRGP4 trap_AAS_Initialized
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $113
ADDRGP4 $109
JUMPV
LABELV $113
line 232
;232:		areanum = BotPointAreaNum(origin);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
line 233
;233:		if (areanum) BotAI_Print(PRT_MESSAGE, "\remtpy area");
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $115
CNSTI4 1
ARGI4
ADDRGP4 $117
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
ADDRGP4 $116
JUMPV
LABELV $115
line 234
;234:		else BotAI_Print(PRT_MESSAGE, "\r^1SOLID area");
CNSTI4 1
ARGI4
ADDRGP4 $118
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
LABELV $116
line 235
;235:	}
LABELV $110
line 236
;236:}
LABELV $109
endproc BotTestSolid 12 8
export BotReportStatus
proc BotReportStatus 536 24
line 243
;237:
;238:/*
;239:==================
;240:BotReportStatus
;241:==================
;242:*/
;243:void BotReportStatus(bot_state_t *bs) {
line 248
;244:	char goalname[MAX_MESSAGE_SIZE];
;245:	char netname[MAX_MESSAGE_SIZE];
;246:	char *leader, *flagstatus;
;247:	//
;248:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 249
;249:	if (Q_stricmp(netname, bs->teamleader) == 0) leader = "L";
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 520
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 520
INDIRI4
CNSTI4 0
NEI4 $120
ADDRLP4 256
ADDRGP4 $122
ASGNP4
ADDRGP4 $121
JUMPV
LABELV $120
line 250
;250:	else leader = " ";
ADDRLP4 256
ADDRGP4 $123
ASGNP4
LABELV $121
line 251
;251:	if (BotCTFCarryingFlag(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 524
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 524
INDIRI4
CNSTI4 0
EQI4 $124
line 252
;252:		if (BotCTFTeam(bs) == TEAM_RED) flagstatus = S_COLOR_RED"F";
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 528
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 528
INDIRI4
CNSTI4 1
NEI4 $126
ADDRLP4 260
ADDRGP4 $128
ASGNP4
ADDRGP4 $125
JUMPV
LABELV $126
line 253
;253:		else flagstatus = S_COLOR_BLUE"F";
ADDRLP4 260
ADDRGP4 $129
ASGNP4
line 254
;254:	}
ADDRGP4 $125
JUMPV
LABELV $124
line 255
;255:	else {
line 256
;256:		flagstatus = " ";
ADDRLP4 260
ADDRGP4 $123
ASGNP4
line 257
;257:	}
LABELV $125
line 258
;258:	switch(bs->ltgtype) {
ADDRLP4 528
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 528
INDIRI4
CNSTI4 1
LTI4 $130
ADDRLP4 528
INDIRI4
CNSTI4 11
GTI4 $130
ADDRLP4 528
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $154-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $154
address $133
address $135
address $137
address $147
address $149
address $151
address $143
address $143
address $145
address $139
address $141
code
LABELV $133
line 260
;259:		case LTG_TEAMHELP:
;260:		{
line 261
;261:			EasyClientName(bs->teammate, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 264
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 262
;262:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: helping %s\n", netname, leader, flagstatus, goalname);
CNSTI4 1
ARGI4
ADDRGP4 $134
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRLP4 264
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 263
;263:			break;
ADDRGP4 $131
JUMPV
LABELV $135
line 266
;264:		}
;265:		case LTG_TEAMACCOMPANY:
;266:		{
line 267
;267:			EasyClientName(bs->teammate, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 264
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 268
;268:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: accompanying %s\n", netname, leader, flagstatus, goalname);
CNSTI4 1
ARGI4
ADDRGP4 $136
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRLP4 264
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 269
;269:			break;
ADDRGP4 $131
JUMPV
LABELV $137
line 272
;270:		}
;271:		case LTG_DEFENDKEYAREA:
;272:		{
line 273
;273:			trap_BotGoalName(bs->teamgoal.number, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 264
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 274
;274:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: defending %s\n", netname, leader, flagstatus, goalname);
CNSTI4 1
ARGI4
ADDRGP4 $138
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRLP4 264
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 275
;275:			break;
ADDRGP4 $131
JUMPV
LABELV $139
line 278
;276:		}
;277:		case LTG_GETITEM:
;278:		{
line 279
;279:			trap_BotGoalName(bs->teamgoal.number, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 264
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 280
;280:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: getting item %s\n", netname, leader, flagstatus, goalname);
CNSTI4 1
ARGI4
ADDRGP4 $140
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRLP4 264
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 281
;281:			break;
ADDRGP4 $131
JUMPV
LABELV $141
line 284
;282:		}
;283:		case LTG_KILL:
;284:		{
line 285
;285:			ClientName(bs->teamgoal.entitynum, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
ARGI4
ADDRLP4 264
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 286
;286:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: killing %s\n", netname, leader, flagstatus, goalname);
CNSTI4 1
ARGI4
ADDRGP4 $142
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRLP4 264
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 287
;287:			break;
ADDRGP4 $131
JUMPV
LABELV $143
line 291
;288:		}
;289:		case LTG_CAMP:
;290:		case LTG_CAMPORDER:
;291:		{
line 292
;292:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: camping\n", netname, leader, flagstatus);
CNSTI4 1
ARGI4
ADDRGP4 $144
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 293
;293:			break;
ADDRGP4 $131
JUMPV
LABELV $145
line 296
;294:		}
;295:		case LTG_PATROL:
;296:		{
line 297
;297:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: patrolling\n", netname, leader, flagstatus);
CNSTI4 1
ARGI4
ADDRGP4 $146
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 298
;298:			break;
ADDRGP4 $131
JUMPV
LABELV $147
line 301
;299:		}
;300:		case LTG_GETFLAG:
;301:		{
line 302
;302:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: capturing flag\n", netname, leader, flagstatus);
CNSTI4 1
ARGI4
ADDRGP4 $148
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 303
;303:			break;
ADDRGP4 $131
JUMPV
LABELV $149
line 306
;304:		}
;305:		case LTG_RUSHBASE:
;306:		{
line 307
;307:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: rushing base\n", netname, leader, flagstatus);
CNSTI4 1
ARGI4
ADDRGP4 $150
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 308
;308:			break;
ADDRGP4 $131
JUMPV
LABELV $151
line 311
;309:		}
;310:		case LTG_RETURNFLAG:
;311:		{
line 312
;312:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: returning flag\n", netname, leader, flagstatus);
CNSTI4 1
ARGI4
ADDRGP4 $152
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 313
;313:			break;
ADDRGP4 $131
JUMPV
LABELV $130
line 316
;314:		}
;315:		default:
;316:		{
line 317
;317:			BotAI_Print(PRT_MESSAGE, "%-20s%s%s: roaming\n", netname, leader, flagstatus);
CNSTI4 1
ARGI4
ADDRGP4 $153
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 260
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 318
;318:			break;
LABELV $131
line 321
;319:		}
;320:	}
;321:}
LABELV $119
endproc BotReportStatus 536 24
export BotTeamplayReport
proc BotTeamplayReport 1056 12
line 328
;322:
;323:/*
;324:==================
;325:BotTeamplayReport
;326:==================
;327:*/
;328:void BotTeamplayReport(void) {
line 332
;329:	int i;
;330:	char buf[MAX_INFO_STRING];
;331:
;332:	BotAI_Print(PRT_MESSAGE, S_COLOR_RED"RED\n");
CNSTI4 1
ARGI4
ADDRGP4 $157
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 333
;333:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $161
JUMPV
LABELV $158
line 335
;334:		//
;335:		if ( !botstates[i] || !botstates[i]->inuse ) continue;
ADDRLP4 1028
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 1028
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $164
ADDRLP4 1028
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $162
LABELV $164
ADDRGP4 $159
JUMPV
LABELV $162
line 337
;336:		//
;337:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 339
;338:		//if no config string or no name
;339:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1032
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1032
INDIRU4
CNSTU4 0
EQU4 $168
ADDRLP4 4
ARGP4
ADDRGP4 $167
ARGP4
ADDRLP4 1036
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1036
INDIRP4
ARGP4
ADDRLP4 1040
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1040
INDIRU4
CNSTU4 0
NEU4 $165
LABELV $168
ADDRGP4 $159
JUMPV
LABELV $165
line 341
;340:		//skip spectators
;341:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_RED) {
ADDRLP4 4
ARGP4
ADDRGP4 $171
ARGP4
ADDRLP4 1044
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1044
INDIRP4
ARGP4
ADDRLP4 1048
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1048
INDIRI4
CNSTI4 1
NEI4 $169
line 342
;342:			BotReportStatus(botstates[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotReportStatus
CALLV
pop
line 343
;343:		}
LABELV $169
line 344
;344:	}
LABELV $159
line 333
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $161
ADDRLP4 0
INDIRI4
ADDRGP4 maxclients
INDIRI4
GEI4 $172
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $158
LABELV $172
line 345
;345:	BotAI_Print(PRT_MESSAGE, S_COLOR_BLUE"BLUE\n");
CNSTI4 1
ARGI4
ADDRGP4 $173
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 346
;346:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $177
JUMPV
LABELV $174
line 348
;347:		//
;348:		if ( !botstates[i] || !botstates[i]->inuse ) continue;
ADDRLP4 1032
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 1032
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $180
ADDRLP4 1032
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $178
LABELV $180
ADDRGP4 $175
JUMPV
LABELV $178
line 350
;349:		//
;350:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 352
;351:		//if no config string or no name
;352:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1036
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1036
INDIRU4
CNSTU4 0
EQU4 $183
ADDRLP4 4
ARGP4
ADDRGP4 $167
ARGP4
ADDRLP4 1040
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1040
INDIRP4
ARGP4
ADDRLP4 1044
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1044
INDIRU4
CNSTU4 0
NEU4 $181
LABELV $183
ADDRGP4 $175
JUMPV
LABELV $181
line 354
;353:		//skip spectators
;354:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_BLUE) {
ADDRLP4 4
ARGP4
ADDRGP4 $171
ARGP4
ADDRLP4 1048
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1048
INDIRP4
ARGP4
ADDRLP4 1052
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 2
NEI4 $184
line 355
;355:			BotReportStatus(botstates[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotReportStatus
CALLV
pop
line 356
;356:		}
LABELV $184
line 357
;357:	}
LABELV $175
line 346
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $177
ADDRLP4 0
INDIRI4
ADDRGP4 maxclients
INDIRI4
GEI4 $186
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $174
LABELV $186
line 358
;358:}
LABELV $156
endproc BotTeamplayReport 1056 12
export BotInterbreedBots
proc BotInterbreedBots 544 20
line 365
;359:
;360:/*
;361:==============
;362:BotInterbreedBots
;363:==============
;364:*/
;365:void BotInterbreedBots(void) {
line 371
;366:	float ranks[MAX_CLIENTS];
;367:	int parent1, parent2, child;
;368:	int i;
;369:
;370:	// get rankings for all the bots
;371:	for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $188
line 372
;372:		if ( botstates[i] && botstates[i]->inuse ) {
ADDRLP4 528
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 528
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $192
ADDRLP4 528
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $192
line 373
;373:			ranks[i] = botstates[i]->num_kills * 2 - botstates[i]->num_deaths;
ADDRLP4 532
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 536
ADDRLP4 532
INDIRI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 532
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 536
INDIRP4
CNSTI4 6004
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ADDRLP4 536
INDIRP4
CNSTI4 6000
ADDP4
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 374
;374:		}
ADDRGP4 $193
JUMPV
LABELV $192
line 375
;375:		else {
line 376
;376:			ranks[i] = -1;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
CNSTF4 3212836864
ASGNF4
line 377
;377:		}
LABELV $193
line 378
;378:	}
LABELV $189
line 371
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $188
line 380
;379:
;380:	if (trap_GeneticParentsAndChildSelection(MAX_CLIENTS, ranks, &parent1, &parent2, &child)) {
CNSTI4 128
ARGI4
ADDRLP4 4
ARGP4
ADDRLP4 520
ARGP4
ADDRLP4 524
ARGP4
ADDRLP4 516
ARGP4
ADDRLP4 528
ADDRGP4 trap_GeneticParentsAndChildSelection
CALLI4
ASGNI4
ADDRLP4 528
INDIRI4
CNSTI4 0
EQI4 $194
line 381
;381:		trap_BotInterbreedGoalFuzzyLogic(botstates[parent1]->gs, botstates[parent2]->gs, botstates[child]->gs);
ADDRLP4 532
CNSTI4 2
ASGNI4
ADDRLP4 536
ADDRGP4 botstates
ASGNP4
ADDRLP4 540
CNSTI4 6216
ASGNI4
ADDRLP4 520
INDIRI4
ADDRLP4 532
INDIRI4
LSHI4
ADDRLP4 536
INDIRP4
ADDP4
INDIRP4
ADDRLP4 540
INDIRI4
ADDP4
INDIRI4
ARGI4
ADDRLP4 524
INDIRI4
ADDRLP4 532
INDIRI4
LSHI4
ADDRLP4 536
INDIRP4
ADDP4
INDIRP4
ADDRLP4 540
INDIRI4
ADDP4
INDIRI4
ARGI4
ADDRLP4 516
INDIRI4
ADDRLP4 532
INDIRI4
LSHI4
ADDRLP4 536
INDIRP4
ADDP4
INDIRP4
ADDRLP4 540
INDIRI4
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotInterbreedGoalFuzzyLogic
CALLV
pop
line 382
;382:		trap_BotMutateGoalFuzzyLogic(botstates[child]->gs, 1);
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
CNSTF4 1065353216
ARGF4
ADDRGP4 trap_BotMutateGoalFuzzyLogic
CALLV
pop
line 383
;383:	}
LABELV $194
line 385
;384:	// reset the kills and deaths
;385:	for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $196
line 386
;386:		if (botstates[i] && botstates[i]->inuse) {
ADDRLP4 532
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 532
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $200
ADDRLP4 532
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $200
line 387
;387:			botstates[i]->num_kills = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 6004
ADDP4
CNSTI4 0
ASGNI4
line 388
;388:			botstates[i]->num_deaths = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 6000
ADDP4
CNSTI4 0
ASGNI4
line 389
;389:		}
LABELV $200
line 390
;390:	}
LABELV $197
line 385
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $196
line 391
;391:}
LABELV $187
endproc BotInterbreedBots 544 20
export BotWriteInterbreeded
proc BotWriteInterbreeded 24 8
line 398
;392:
;393:/*
;394:==============
;395:BotWriteInterbreeded
;396:==============
;397:*/
;398:void BotWriteInterbreeded(char *filename) {
line 402
;399:	float rank, bestrank;
;400:	int i, bestbot;
;401:
;402:	bestrank = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
line 403
;403:	bestbot = -1;
ADDRLP4 12
CNSTI4 -1
ASGNI4
line 405
;404:	// get the best bot
;405:	for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $203
line 406
;406:		if ( botstates[i] && botstates[i]->inuse ) {
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $207
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $207
line 407
;407:			rank = botstates[i]->num_kills * 2 - botstates[i]->num_deaths;
ADDRLP4 20
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 20
INDIRP4
CNSTI4 6004
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ADDRLP4 20
INDIRP4
CNSTI4 6000
ADDP4
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 408
;408:		}
ADDRGP4 $208
JUMPV
LABELV $207
line 409
;409:		else {
line 410
;410:			rank = -1;
ADDRLP4 4
CNSTF4 3212836864
ASGNF4
line 411
;411:		}
LABELV $208
line 412
;412:		if (rank > bestrank) {
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
LEF4 $209
line 413
;413:			bestrank = rank;
ADDRLP4 8
ADDRLP4 4
INDIRF4
ASGNF4
line 414
;414:			bestbot = i;
ADDRLP4 12
ADDRLP4 0
INDIRI4
ASGNI4
line 415
;415:		}
LABELV $209
line 416
;416:	}
LABELV $204
line 405
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $203
line 417
;417:	if (bestbot >= 0) {
ADDRLP4 12
INDIRI4
CNSTI4 0
LTI4 $211
line 419
;418:		//write out the new goal fuzzy logic
;419:		trap_BotSaveGoalFuzzyLogic(botstates[bestbot]->gs, filename);
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_BotSaveGoalFuzzyLogic
CALLV
pop
line 420
;420:	}
LABELV $211
line 421
;421:}
LABELV $202
endproc BotWriteInterbreeded 24 8
export BotInterbreedEndMatch
proc BotInterbreedEndMatch 8 8
line 430
;422:
;423:/*
;424:==============
;425:BotInterbreedEndMatch
;426:
;427:add link back into ExitLevel?
;428:==============
;429:*/
;430:void BotInterbreedEndMatch(void) {
line 432
;431:
;432:	if (!bot_interbreed) return;
ADDRGP4 bot_interbreed
INDIRI4
CNSTI4 0
NEI4 $214
ADDRGP4 $213
JUMPV
LABELV $214
line 433
;433:	bot_interbreedmatchcount++;
ADDRLP4 0
ADDRGP4 bot_interbreedmatchcount
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 434
;434:	if (bot_interbreedmatchcount >= bot_interbreedcycle.integer) {
ADDRGP4 bot_interbreedmatchcount
INDIRI4
ADDRGP4 bot_interbreedcycle+12
INDIRI4
LTI4 $216
line 435
;435:		bot_interbreedmatchcount = 0;
ADDRGP4 bot_interbreedmatchcount
CNSTI4 0
ASGNI4
line 437
;436:		//
;437:		trap_Cvar_Update(&bot_interbreedwrite);
ADDRGP4 bot_interbreedwrite
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 438
;438:		if (strlen(bot_interbreedwrite.string)) {
ADDRGP4 bot_interbreedwrite+16
ARGP4
ADDRLP4 4
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 4
INDIRU4
CNSTU4 0
EQU4 $219
line 439
;439:			BotWriteInterbreeded(bot_interbreedwrite.string);
ADDRGP4 bot_interbreedwrite+16
ARGP4
ADDRGP4 BotWriteInterbreeded
CALLV
pop
line 440
;440:			trap_Cvar_Set("bot_interbreedwrite", "");
ADDRGP4 $223
ARGP4
ADDRGP4 $224
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 441
;441:		}
LABELV $219
line 442
;442:		BotInterbreedBots();
ADDRGP4 BotInterbreedBots
CALLV
pop
line 443
;443:	}
LABELV $216
line 444
;444:}
LABELV $213
endproc BotInterbreedEndMatch 8 8
export BotInterbreeding
proc BotInterbreeding 16 20
line 451
;445:
;446:/*
;447:==============
;448:BotInterbreeding
;449:==============
;450:*/
;451:void BotInterbreeding(void) {
line 454
;452:	int i;
;453:
;454:	trap_Cvar_Update(&bot_interbreedchar);
ADDRGP4 bot_interbreedchar
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 455
;455:	if (!strlen(bot_interbreedchar.string)) return;
ADDRGP4 bot_interbreedchar+16
ARGP4
ADDRLP4 4
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 4
INDIRU4
CNSTU4 0
NEU4 $226
ADDRGP4 $225
JUMPV
LABELV $226
line 457
;456:	//make sure we are in tournament mode
;457:	if (gametype != GT_TOURNAMENT) {
ADDRGP4 gametype
INDIRI4
CNSTI4 1
EQI4 $229
line 458
;458:		trap_Cvar_Set("g_gametype", va("%d", GT_TOURNAMENT));
ADDRGP4 $232
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $231
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 459
;459:		ExitLevel();
ADDRGP4 ExitLevel
CALLV
pop
line 460
;460:		return;
ADDRGP4 $225
JUMPV
LABELV $229
line 463
;461:	}
;462:	//shutdown all the bots
;463:	for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $233
line 464
;464:		if (botstates[i] && botstates[i]->inuse) {
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $237
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $237
line 465
;465:			BotAIShutdownClient(botstates[i]->client);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotAIShutdownClient
CALLI4
pop
line 466
;466:		}
LABELV $237
line 467
;467:	}
LABELV $234
line 463
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $233
line 469
;468:	//make sure all item weight configs are reloaded and Not shared
;469:	trap_BotLibVarSet("bot_reloadcharacters", "1");
ADDRGP4 $239
ARGP4
ADDRGP4 $240
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 471
;470:	//add a number of bots using the desired bot character
;471:	for (i = 0; i < bot_interbreedbots.integer; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $244
JUMPV
LABELV $241
line 472
;472:		trap_SendConsoleCommand( EXEC_INSERT, va("addbot %s 4 free %i %s%d\n",
ADDRGP4 $246
ARGP4
ADDRGP4 bot_interbreedchar+16
ARGP4
CNSTI4 50
ADDRLP4 0
INDIRI4
MULI4
ARGI4
ADDRGP4 bot_interbreedchar+16
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 1
ARGI4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 474
;473:						bot_interbreedchar.string, i * 50, bot_interbreedchar.string, i) );
;474:	}
LABELV $242
line 471
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $244
ADDRLP4 0
INDIRI4
ADDRGP4 bot_interbreedbots+12
INDIRI4
LTI4 $241
line 476
;475:	//
;476:	trap_Cvar_Set("bot_interbreedchar", "");
ADDRGP4 $249
ARGP4
ADDRGP4 $224
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 477
;477:	bot_interbreed = qtrue;
ADDRGP4 bot_interbreed
CNSTI4 1
ASGNI4
line 478
;478:}
LABELV $225
endproc BotInterbreeding 16 20
export BotEntityInfo
proc BotEntityInfo 0 8
line 485
;479:
;480:/*
;481:==============
;482:BotEntityInfo
;483:==============
;484:*/
;485:void BotEntityInfo(int entnum, aas_entityinfo_t *info) {
line 486
;486:	trap_AAS_EntityInfo(entnum, info);
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 trap_AAS_EntityInfo
CALLV
pop
line 487
;487:}
LABELV $250
endproc BotEntityInfo 0 8
export NumBots
proc NumBots 0 0
line 494
;488:
;489:/*
;490:==============
;491:NumBots
;492:==============
;493:*/
;494:int NumBots(void) {
line 495
;495:	return numbots;
ADDRGP4 numbots
INDIRI4
RETI4
LABELV $251
endproc NumBots 0 0
export BotTeamLeader
proc BotTeamLeader 12 4
line 503
;496:}
;497:
;498:/*
;499:==============
;500:BotTeamLeader
;501:==============
;502:*/
;503:int BotTeamLeader(bot_state_t *bs) {
line 506
;504:	int leader;
;505:
;506:	leader = ClientFromName(bs->teamleader);
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 4
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
ASGNI4
line 507
;507:	if (leader < 0) return qfalse;
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $253
CNSTI4 0
RETI4
ADDRGP4 $252
JUMPV
LABELV $253
line 508
;508:	if (!botstates[leader] || !botstates[leader]->inuse) return qfalse;
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $257
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $255
LABELV $257
CNSTI4 0
RETI4
ADDRGP4 $252
JUMPV
LABELV $255
line 509
;509:	return qtrue;
CNSTI4 1
RETI4
LABELV $252
endproc BotTeamLeader 12 4
export AngleDifference
proc AngleDifference 4 0
line 517
;510:}
;511:
;512:/*
;513:==============
;514:AngleDifference
;515:==============
;516:*/
;517:float AngleDifference(float ang1, float ang2) {
line 520
;518:	float diff;
;519:
;520:	diff = ang1 - ang2;
ADDRLP4 0
ADDRFP4 0
INDIRF4
ADDRFP4 4
INDIRF4
SUBF4
ASGNF4
line 521
;521:	if (ang1 > ang2) {
ADDRFP4 0
INDIRF4
ADDRFP4 4
INDIRF4
LEF4 $259
line 522
;522:		if (diff > 180.0) diff -= 360.0;
ADDRLP4 0
INDIRF4
CNSTF4 1127481344
LEF4 $260
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
line 523
;523:	}
ADDRGP4 $260
JUMPV
LABELV $259
line 524
;524:	else {
line 525
;525:		if (diff < -180.0) diff += 360.0;
ADDRLP4 0
INDIRF4
CNSTF4 3274964992
GEF4 $263
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
ADDF4
ASGNF4
LABELV $263
line 526
;526:	}
LABELV $260
line 527
;527:	return diff;
ADDRLP4 0
INDIRF4
RETF4
LABELV $258
endproc AngleDifference 4 0
export BotChangeViewAngle
proc BotChangeViewAngle 16 4
line 535
;528:}
;529:
;530:/*
;531:==============
;532:BotChangeViewAngle
;533:==============
;534:*/
;535:float BotChangeViewAngle(float angle, float ideal_angle, float speed) {
line 538
;536:	float move;
;537:
;538:	angle = AngleMod(angle);
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRFP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 539
;539:	ideal_angle = AngleMod(ideal_angle);
ADDRFP4 4
INDIRF4
ARGF4
ADDRLP4 8
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRFP4 4
ADDRLP4 8
INDIRF4
ASGNF4
line 540
;540:	if (angle == ideal_angle) return angle;
ADDRFP4 0
INDIRF4
ADDRFP4 4
INDIRF4
NEF4 $266
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $265
JUMPV
LABELV $266
line 541
;541:	move = ideal_angle - angle;
ADDRLP4 0
ADDRFP4 4
INDIRF4
ADDRFP4 0
INDIRF4
SUBF4
ASGNF4
line 542
;542:	if (ideal_angle > angle) {
ADDRFP4 4
INDIRF4
ADDRFP4 0
INDIRF4
LEF4 $268
line 543
;543:		if (move > 180.0) move -= 360.0;
ADDRLP4 0
INDIRF4
CNSTF4 1127481344
LEF4 $269
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
line 544
;544:	}
ADDRGP4 $269
JUMPV
LABELV $268
line 545
;545:	else {
line 546
;546:		if (move < -180.0) move += 360.0;
ADDRLP4 0
INDIRF4
CNSTF4 3274964992
GEF4 $272
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
ADDF4
ASGNF4
LABELV $272
line 547
;547:	}
LABELV $269
line 548
;548:	if (move > 0) {
ADDRLP4 0
INDIRF4
CNSTF4 0
LEF4 $274
line 549
;549:		if (move > speed) move = speed;
ADDRLP4 0
INDIRF4
ADDRFP4 8
INDIRF4
LEF4 $275
ADDRLP4 0
ADDRFP4 8
INDIRF4
ASGNF4
line 550
;550:	}
ADDRGP4 $275
JUMPV
LABELV $274
line 551
;551:	else {
line 552
;552:		if (move < -speed) move = -speed;
ADDRLP4 0
INDIRF4
ADDRFP4 8
INDIRF4
NEGF4
GEF4 $278
ADDRLP4 0
ADDRFP4 8
INDIRF4
NEGF4
ASGNF4
LABELV $278
line 553
;553:	}
LABELV $275
line 554
;554:	return AngleMod(angle + move);
ADDRFP4 0
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ARGF4
ADDRLP4 12
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 12
INDIRF4
RETF4
LABELV $265
endproc BotChangeViewAngle 16 4
export BotChangeViewAngles
proc BotChangeViewAngles 80 16
line 562
;555:}
;556:
;557:/*
;558:==============
;559:BotChangeViewAngles
;560:==============
;561:*/
;562:void BotChangeViewAngles(bot_state_t *bs, float thinktime) {
line 566
;563:	float diff, factor, maxchange, anglespeed, disired_speed;
;564:	int i;
;565:
;566:	if (bs->ideal_viewangles[PITCH] > 180) bs->ideal_viewangles[PITCH] -= 360;
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
INDIRF4
CNSTF4 1127481344
LEF4 $281
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
LABELV $281
line 568
;567:	//
;568:	if (bs->enemy >= 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
LTI4 $283
line 569
;569:		factor = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_VIEW_FACTOR, 0.01, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
CNSTF4 1008981770
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 28
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 28
INDIRF4
ASGNF4
line 570
;570:		maxchange = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_VIEW_MAXCHANGE, 1, 1800);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
CNSTF4 1065353216
ARGF4
CNSTF4 1155596288
ARGF4
ADDRLP4 32
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 8
ADDRLP4 32
INDIRF4
ASGNF4
line 571
;571:	}
ADDRGP4 $284
JUMPV
LABELV $283
line 572
;572:	else {
line 573
;573:		factor = 0.05;
ADDRLP4 16
CNSTF4 1028443341
ASGNF4
line 574
;574:		maxchange = 360;
ADDRLP4 8
CNSTF4 1135869952
ASGNF4
line 575
;575:	}
LABELV $284
line 576
;576:	if (maxchange < 240) maxchange = 240;
ADDRLP4 8
INDIRF4
CNSTF4 1131413504
GEF4 $285
ADDRLP4 8
CNSTF4 1131413504
ASGNF4
LABELV $285
line 577
;577:	maxchange *= thinktime;
ADDRLP4 8
ADDRLP4 8
INDIRF4
ADDRFP4 4
INDIRF4
MULF4
ASGNF4
line 578
;578:	for (i = 0; i < 2; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $287
line 580
;579:		//
;580:		if (bot_challenge.integer) {
ADDRGP4 bot_challenge+12
INDIRI4
CNSTI4 0
EQI4 $291
line 582
;581:			//smooth slowdown view model
;582:			diff = abs(AngleDifference(bs->viewangles[i], bs->ideal_viewangles[i]));
ADDRLP4 28
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRI4
ADDRLP4 32
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 28
INDIRI4
ADDRLP4 32
INDIRP4
CNSTI4 6264
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 36
ADDRGP4 AngleDifference
CALLF4
ASGNF4
ADDRLP4 36
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 40
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 40
INDIRI4
CVIF4 4
ASGNF4
line 583
;583:			anglespeed = diff * factor;
ADDRLP4 4
ADDRLP4 12
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 584
;584:			if (anglespeed > maxchange) anglespeed = maxchange;
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
LEF4 $294
ADDRLP4 4
ADDRLP4 8
INDIRF4
ASGNF4
LABELV $294
line 585
;585:			bs->viewangles[i] = BotChangeViewAngle(bs->viewangles[i],
ADDRLP4 44
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 52
ADDRLP4 44
INDIRI4
ADDRLP4 48
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
INDIRF4
ARGF4
ADDRLP4 44
INDIRI4
ADDRLP4 48
INDIRP4
CNSTI4 6264
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 56
ADDRGP4 BotChangeViewAngle
CALLF4
ASGNF4
ADDRLP4 52
INDIRP4
ADDRLP4 56
INDIRF4
ASGNF4
line 587
;586:											bs->ideal_viewangles[i], anglespeed);
;587:		}
ADDRGP4 $292
JUMPV
LABELV $291
line 588
;588:		else {
line 590
;589:			//over reaction view model
;590:			bs->viewangles[i] = AngleMod(bs->viewangles[i]);
ADDRLP4 28
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
INDIRF4
ARGF4
ADDRLP4 32
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 28
INDIRP4
ADDRLP4 32
INDIRF4
ASGNF4
line 591
;591:			bs->ideal_viewangles[i] = AngleMod(bs->ideal_viewangles[i]);
ADDRLP4 36
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
INDIRF4
ARGF4
ADDRLP4 40
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 36
INDIRP4
ADDRLP4 40
INDIRF4
ASGNF4
line 592
;592:			diff = AngleDifference(bs->viewangles[i], bs->ideal_viewangles[i]);
ADDRLP4 44
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRI4
ADDRLP4 48
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 44
INDIRI4
ADDRLP4 48
INDIRP4
CNSTI4 6264
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 52
ADDRGP4 AngleDifference
CALLF4
ASGNF4
ADDRLP4 12
ADDRLP4 52
INDIRF4
ASGNF4
line 593
;593:			disired_speed = diff * factor;
ADDRLP4 20
ADDRLP4 12
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 594
;594:			bs->viewanglespeed[i] += (bs->viewanglespeed[i] - disired_speed);
ADDRLP4 56
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
ASGNP4
ADDRLP4 60
ADDRLP4 56
INDIRP4
INDIRF4
ASGNF4
ADDRLP4 56
INDIRP4
ADDRLP4 60
INDIRF4
ADDRLP4 60
INDIRF4
ADDRLP4 20
INDIRF4
SUBF4
ADDF4
ASGNF4
line 595
;595:			if (bs->viewanglespeed[i] > 180) bs->viewanglespeed[i] = maxchange;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
INDIRF4
CNSTF4 1127481344
LEF4 $296
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
LABELV $296
line 596
;596:			if (bs->viewanglespeed[i] < -180) bs->viewanglespeed[i] = -maxchange;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
INDIRF4
CNSTF4 3274964992
GEF4 $298
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
ADDRLP4 8
INDIRF4
NEGF4
ASGNF4
LABELV $298
line 597
;597:			anglespeed = bs->viewanglespeed[i];
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
INDIRF4
ASGNF4
line 598
;598:			if (anglespeed > maxchange) anglespeed = maxchange;
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
LEF4 $300
ADDRLP4 4
ADDRLP4 8
INDIRF4
ASGNF4
LABELV $300
line 599
;599:			if (anglespeed < -maxchange) anglespeed = -maxchange;
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
NEGF4
GEF4 $302
ADDRLP4 4
ADDRLP4 8
INDIRF4
NEGF4
ASGNF4
LABELV $302
line 600
;600:			bs->viewangles[i] += anglespeed;
ADDRLP4 64
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDF4
ASGNF4
line 601
;601:			bs->viewangles[i] = AngleMod(bs->viewangles[i]);
ADDRLP4 68
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
INDIRF4
ARGF4
ADDRLP4 72
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 68
INDIRP4
ADDRLP4 72
INDIRF4
ASGNF4
line 603
;602:			//demping
;603:			bs->viewanglespeed[i] *= 0.45 * (1 - factor);
ADDRLP4 76
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 6276
ADDP4
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
CNSTF4 1055286886
CNSTF4 1065353216
ADDRLP4 16
INDIRF4
SUBF4
MULF4
MULF4
ASGNF4
line 604
;604:		}
LABELV $292
line 607
;605:		//BotAI_Print(PRT_MESSAGE, "ideal_angles %f %f\n", bs->ideal_viewangles[0], bs->ideal_viewangles[1], bs->ideal_viewangles[2]);`
;606:		//bs->viewangles[i] = bs->ideal_viewangles[i];
;607:	}
LABELV $288
line 578
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LTI4 $287
line 609
;608:	//bs->viewangles[PITCH] = 0;
;609:	if (bs->viewangles[PITCH] > 180) bs->viewangles[PITCH] -= 360;
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
INDIRF4
CNSTF4 1127481344
LEF4 $304
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
LABELV $304
line 611
;610:	//elementary action: view
;611:	trap_EA_View(bs->client, bs->viewangles);
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 32
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRGP4 trap_EA_View
CALLV
pop
line 612
;612:}
LABELV $280
endproc BotChangeViewAngles 80 16
export BotInputToUserCommand
proc BotInputToUserCommand 116 16
line 619
;613:
;614:/*
;615:==============
;616:BotInputToUserCommand
;617:==============
;618:*/
;619:void BotInputToUserCommand(bot_input_t *bi, usercmd_t *ucmd, int delta_angles[3], int time) {
line 625
;620:	vec3_t angles, forward, right;
;621:	short temp;
;622:	int j;
;623:
;624:	//clear the whole structure
;625:	memset(ucmd, 0, sizeof(usercmd_t));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 24
ARGU4
ADDRGP4 memset
CALLP4
pop
line 629
;626:	//
;627:	//Com_Printf("dir = %f %f %f speed = %f\n", bi->dir[0], bi->dir[1], bi->dir[2], bi->speed);
;628:	//the duration for the user command in milli seconds
;629:	ucmd->serverTime = time;
ADDRFP4 4
INDIRP4
ADDRFP4 12
INDIRI4
ASGNI4
line 631
;630:	//
;631:	if (bi->actionflags & ACTION_DELAYEDJUMP) {
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $307
line 632
;632:		bi->actionflags |= ACTION_JUMP;
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 633
;633:		bi->actionflags &= ~ACTION_DELAYEDJUMP;
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRI4
CNSTI4 -513
BANDI4
ASGNI4
line 634
;634:	}
LABELV $307
line 636
;635:	//set the buttons
;636:	if (bi->actionflags & ACTION_RESPAWN) ucmd->buttons = BUTTON_ATTACK;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $309
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
CNSTU1 1
ASGNU1
LABELV $309
line 637
;637:	if (bi->actionflags & ACTION_ATTACK) ucmd->buttons |= BUTTON_ATTACK;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $311
ADDRLP4 44
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRU1
CVUI4 1
CNSTI4 1
BORI4
CVIU4 4
CVUU1 4
ASGNU1
LABELV $311
line 638
;638:	if (bi->actionflags & ACTION_TALK) ucmd->buttons |= BUTTON_TALK;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
EQI4 $313
ADDRLP4 48
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRU1
CVUI4 1
CNSTI4 2
BORI4
CVIU4 4
CVUU1 4
ASGNU1
LABELV $313
line 639
;639:	if (bi->actionflags & ACTION_GESTURE) ucmd->buttons |= BUTTON_GESTURE;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $315
ADDRLP4 52
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRU1
CVUI4 1
CNSTI4 8
BORI4
CVIU4 4
CVUU1 4
ASGNU1
LABELV $315
line 640
;640:	if (bi->actionflags & ACTION_USE) ucmd->buttons |= BUTTON_USE_HOLDABLE;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $317
ADDRLP4 56
CNSTI4 4
ASGNI4
ADDRLP4 60
ADDRFP4 4
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRU1
CVUI4 1
ADDRLP4 56
INDIRI4
BORI4
CVIU4 4
CVUU1 4
ASGNU1
LABELV $317
line 641
;641:	if (bi->actionflags & ACTION_WALK) ucmd->buttons |= BUTTON_WALKING;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $319
ADDRLP4 64
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRU1
CVUI4 1
CNSTI4 16
BORI4
CVIU4 4
CVUU1 4
ASGNU1
LABELV $319
line 642
;642:	ucmd->weapon = bi->weapon;
ADDRFP4 4
INDIRP4
CNSTI4 5
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CVIU4 4
CVUU1 4
ASGNU1
line 645
;643:	//set the view angles
;644:	//NOTE: the ucmd->angles are the angles WITHOUT the delta angles
;645:	ucmd->angles[PITCH] = ANGLE2SHORT(bi->viewangles[PITCH]);
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTF4 1199570944
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 646
;646:	ucmd->angles[YAW] = ANGLE2SHORT(bi->viewangles[YAW]);
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
CNSTF4 1199570944
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 647
;647:	ucmd->angles[ROLL] = ANGLE2SHORT(bi->viewangles[ROLL]);
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
CNSTF4 1199570944
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 649
;648:	//subtract the delta angles
;649:	for (j = 0; j < 3; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $321
line 650
;650:		temp = ucmd->angles[j] - delta_angles[j];
ADDRLP4 68
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4
ADDRLP4 68
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDP4
INDIRI4
ADDRLP4 68
INDIRI4
ADDRFP4 8
INDIRP4
ADDP4
INDIRI4
SUBI4
CVII2 4
ASGNI2
line 658
;651:		/*NOTE: disabled because temp should be mod first
;652:		if ( j == PITCH ) {
;653:			// don't let the player look up or down more than 90 degrees
;654:			if ( temp > 16000 ) temp = 16000;
;655:			else if ( temp < -16000 ) temp = -16000;
;656:		}
;657:		*/
;658:		ucmd->angles[j] = temp;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDP4
ADDRLP4 4
INDIRI2
CVII4 2
ASGNI4
line 659
;659:	}
LABELV $322
line 649
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $321
line 663
;660:	//NOTE: movement is relative to the REAL view angles
;661:	//get the horizontal forward and right vector
;662:	//get the pitch in the range [-180, 180]
;663:	if (bi->dir[2]) angles[PITCH] = bi->viewangles[PITCH];
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
CNSTF4 0
EQF4 $325
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ASGNF4
ADDRGP4 $326
JUMPV
LABELV $325
line 664
;664:	else angles[PITCH] = 0;
ADDRLP4 20
CNSTF4 0
ASGNF4
LABELV $326
line 665
;665:	angles[YAW] = bi->viewangles[YAW];
ADDRLP4 20+4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ASGNF4
line 666
;666:	angles[ROLL] = 0;
ADDRLP4 20+8
CNSTF4 0
ASGNF4
line 667
;667:	AngleVectors(angles, forward, right, NULL);
ADDRLP4 20
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 32
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 669
;668:	//bot input speed is in the range [0, 400]
;669:	bi->speed = bi->speed * 127 / 400;
ADDRLP4 68
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTF4 1123942400
ADDRLP4 68
INDIRP4
INDIRF4
MULF4
CNSTF4 1137180672
DIVF4
ASGNF4
line 671
;670:	//set the view independent movement
;671:	ucmd->forwardmove = DotProduct(forward, bi->dir) * bi->speed;
ADDRLP4 72
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 8
INDIRF4
ADDRLP4 72
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDRLP4 8+4
INDIRF4
ADDRLP4 72
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 8+8
INDIRF4
ADDRLP4 72
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 72
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
CVFI4 4
CVII1 4
ASGNI1
line 672
;672:	ucmd->rightmove = DotProduct(right, bi->dir) * bi->speed;
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 4
INDIRP4
CNSTI4 21
ADDP4
ADDRLP4 32
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDRLP4 32+4
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 32+8
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 76
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
CVFI4 4
CVII1 4
ASGNI1
line 673
;673:	ucmd->upmove = abs(forward[2]) * bi->dir[2] * bi->speed;
ADDRLP4 8+8
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 80
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 4
INDIRP4
CNSTI4 22
ADDP4
ADDRLP4 80
INDIRI4
CVIF4 4
ADDRLP4 84
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
MULF4
ADDRLP4 84
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
CVFI4 4
CVII1 4
ASGNI1
line 675
;674:	//normal keyboard movement
;675:	if (bi->actionflags & ACTION_MOVEFORWARD) ucmd->forwardmove += 127;
ADDRLP4 88
CNSTI4 32
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 88
INDIRI4
ADDP4
INDIRI4
ADDRLP4 88
INDIRI4
BANDI4
CNSTI4 0
EQI4 $334
ADDRLP4 92
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
ADDI4
CVII1 4
ASGNI1
LABELV $334
line 676
;676:	if (bi->actionflags & ACTION_MOVEBACK) ucmd->forwardmove -= 127;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
EQI4 $336
ADDRLP4 96
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 96
INDIRP4
ADDRLP4 96
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
SUBI4
CVII1 4
ASGNI1
LABELV $336
line 677
;677:	if (bi->actionflags & ACTION_MOVELEFT) ucmd->rightmove -= 127;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $338
ADDRLP4 100
ADDRFP4 4
INDIRP4
CNSTI4 21
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
SUBI4
CVII1 4
ASGNI1
LABELV $338
line 678
;678:	if (bi->actionflags & ACTION_MOVERIGHT) ucmd->rightmove += 127;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $340
ADDRLP4 104
ADDRFP4 4
INDIRP4
CNSTI4 21
ADDP4
ASGNP4
ADDRLP4 104
INDIRP4
ADDRLP4 104
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
ADDI4
CVII1 4
ASGNI1
LABELV $340
line 680
;679:	//jump/moveup
;680:	if (bi->actionflags & ACTION_JUMP) ucmd->upmove += 127;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $342
ADDRLP4 108
ADDRFP4 4
INDIRP4
CNSTI4 22
ADDP4
ASGNP4
ADDRLP4 108
INDIRP4
ADDRLP4 108
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
ADDI4
CVII1 4
ASGNI1
LABELV $342
line 682
;681:	//crouch/movedown
;682:	if (bi->actionflags & ACTION_CROUCH) ucmd->upmove -= 127;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $344
ADDRLP4 112
ADDRFP4 4
INDIRP4
CNSTI4 22
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
SUBI4
CVII1 4
ASGNI1
LABELV $344
line 686
;683:	//
;684:	//Com_Printf("forward = %d right = %d up = %d\n", ucmd.forwardmove, ucmd.rightmove, ucmd.upmove);
;685:	//Com_Printf("ucmd->serverTime = %d\n", ucmd->serverTime);
;686:}
LABELV $306
endproc BotInputToUserCommand 116 16
export BotUpdateInput
proc BotUpdateInput 64 16
line 693
;687:
;688:/*
;689:==============
;690:BotUpdateInput
;691:==============
;692:*/
;693:void BotUpdateInput(bot_state_t *bs, int time, int elapsed_time) {
line 698
;694:	bot_input_t bi;
;695:	int j;
;696:
;697:	//add the delta angles to the bot's current view angles
;698:	for (j = 0; j < 3; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $347
line 699
;699:		bs->viewangles[j] = AngleMod(bs->viewangles[j] + SHORT2ANGLE(bs->cur_ps.delta_angles[j]));
ADDRLP4 44
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 52
ADDRLP4 44
INDIRI4
ADDRLP4 48
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
INDIRF4
CNSTF4 1001652224
ADDRLP4 44
INDIRI4
ADDRLP4 48
INDIRP4
CNSTI4 72
ADDP4
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDF4
ARGF4
ADDRLP4 56
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 52
INDIRP4
ADDRLP4 56
INDIRF4
ASGNF4
line 700
;700:	}
LABELV $348
line 698
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $347
line 702
;701:	//change the bot view angles
;702:	BotChangeViewAngles(bs, (float) elapsed_time / 1000);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ARGF4
ADDRGP4 BotChangeViewAngles
CALLV
pop
line 704
;703:	//retrieve the bot input
;704:	trap_EA_GetInput(bs->client, (float) time / 1000, &bi);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ARGF4
ADDRLP4 4
ARGP4
ADDRGP4 trap_EA_GetInput
CALLV
pop
line 706
;705:	//respawn hack
;706:	if (bi.actionflags & ACTION_RESPAWN) {
ADDRLP4 4+32
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $351
line 707
;707:		if (bs->lastucmd.buttons & BUTTON_ATTACK) bi.actionflags &= ~(ACTION_RESPAWN|ACTION_ATTACK);
ADDRFP4 0
INDIRP4
CNSTI4 468
ADDP4
INDIRU1
CVUI4 1
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $354
ADDRLP4 4+32
ADDRLP4 4+32
INDIRI4
CNSTI4 -6
BANDI4
ASGNI4
LABELV $354
line 708
;708:	}
LABELV $351
line 710
;709:	//convert the bot input to a usercmd
;710:	BotInputToUserCommand(&bi, &bs->lastucmd, bs->cur_ps.delta_angles, time);
ADDRLP4 4
ARGP4
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 464
ADDP4
ARGP4
ADDRLP4 44
INDIRP4
CNSTI4 72
ADDP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 BotInputToUserCommand
CALLV
pop
line 712
;711:	//subtract the delta angles
;712:	for (j = 0; j < 3; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $357
line 713
;713:		bs->viewangles[j] = AngleMod(bs->viewangles[j] - SHORT2ANGLE(bs->cur_ps.delta_angles[j]));
ADDRLP4 48
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
ADDRLP4 48
INDIRI4
ADDRLP4 52
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
INDIRF4
CNSTF4 1001652224
ADDRLP4 48
INDIRI4
ADDRLP4 52
INDIRP4
CNSTI4 72
ADDP4
ADDP4
INDIRI4
CVIF4 4
MULF4
SUBF4
ARGF4
ADDRLP4 60
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 56
INDIRP4
ADDRLP4 60
INDIRF4
ASGNF4
line 714
;714:	}
LABELV $358
line 712
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $357
line 715
;715:}
LABELV $346
endproc BotUpdateInput 64 16
export BotAIRegularUpdate
proc BotAIRegularUpdate 8 0
line 722
;716:
;717:/*
;718:==============
;719:BotAIRegularUpdate
;720:==============
;721:*/
;722:void BotAIRegularUpdate(void) {
line 723
;723:	if (regularupdate_time < trap_AAS_Time()) {
ADDRLP4 0
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRGP4 regularupdate_time
INDIRF4
ADDRLP4 0
INDIRF4
GEF4 $362
line 724
;724:		trap_BotUpdateEntityItems();
ADDRGP4 trap_BotUpdateEntityItems
CALLV
pop
line 725
;725:		regularupdate_time = trap_AAS_Time() + 0.3;
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRGP4 regularupdate_time
ADDRLP4 4
INDIRF4
CNSTF4 1050253722
ADDF4
ASGNF4
line 726
;726:	}
LABELV $362
line 727
;727:}
LABELV $361
endproc BotAIRegularUpdate 8 0
export BotAI
proc BotAI 1092 12
line 734
;728:
;729:/*
;730:==============
;731:BotAI
;732:==============
;733:*/
;734:int BotAI(int client, float thinktime) {
line 739
;735:	bot_state_t *bs;
;736:	char buf[1024], *args;
;737:	int j;
;738:
;739:	trap_EA_ResetInput(client);
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 trap_EA_ResetInput
CALLV
pop
line 741
;740:	//
;741:	bs = botstates[client];
ADDRLP4 4
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
line 742
;742:	if (!bs || !bs->inuse) {
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $367
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $365
LABELV $367
line 743
;743:		BotAI_Print(PRT_FATAL, "BotAI: client %d is not setup\n", client);
CNSTI4 4
ARGI4
ADDRGP4 $368
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 744
;744:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $364
JUMPV
LABELV $365
line 748
;745:	}
;746:
;747:	//retrieve the current client state
;748:	BotAI_GetClientState( client, &bs->cur_ps );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
ADDRGP4 $370
JUMPV
LABELV $369
line 751
;749:
;750:	//retrieve any waiting console messages
;751:	while( trap_BotGetConsoleMessage(client, buf, sizeof(buf)) ) {
line 753
;752:		//have buf point to the command and args to the command arguments
;753:		args = strchr( buf, ' ');
ADDRLP4 12
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 1040
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 1040
INDIRP4
ASGNP4
line 754
;754:		if (!args) continue;
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $372
ADDRGP4 $370
JUMPV
LABELV $372
line 755
;755:		*args++ = '\0';
ADDRLP4 1044
ADDRLP4 8
INDIRP4
ASGNP4
ADDRLP4 8
ADDRLP4 1044
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 1044
INDIRP4
CNSTI1 0
ASGNI1
line 758
;756:
;757:		//remove color espace sequences from the arguments
;758:		Q_CleanStr( args );
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 Q_CleanStr
CALLP4
pop
line 760
;759:
;760:		if (!Q_stricmp(buf, "cp "))
ADDRLP4 12
ARGP4
ADDRGP4 $376
ARGP4
ADDRLP4 1048
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1048
INDIRI4
CNSTI4 0
NEI4 $374
line 761
;761:			{ /*CenterPrintf*/ }
ADDRGP4 $375
JUMPV
LABELV $374
line 762
;762:		else if (!Q_stricmp(buf, "cs"))
ADDRLP4 12
ARGP4
ADDRGP4 $379
ARGP4
ADDRLP4 1052
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 0
NEI4 $377
line 763
;763:			{ /*ConfigStringModified*/ }
ADDRGP4 $378
JUMPV
LABELV $377
line 764
;764:		else if (!Q_stricmp(buf, "print")) {
ADDRLP4 12
ARGP4
ADDRGP4 $382
ARGP4
ADDRLP4 1056
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1056
INDIRI4
CNSTI4 0
NEI4 $380
line 766
;765:			//remove first and last quote from the chat message
;766:			memmove(args, args+1, strlen(args));
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1060
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 1060
INDIRU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
line 767
;767:			args[strlen(args)-1] = '\0';
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1068
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1068
INDIRU4
CNSTU4 1
SUBU4
ADDRLP4 8
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 768
;768:			trap_BotQueueConsoleMessage(bs->cs, CMS_NORMAL, args);
ADDRLP4 4
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 trap_BotQueueConsoleMessage
CALLV
pop
line 769
;769:		}
ADDRGP4 $381
JUMPV
LABELV $380
line 770
;770:		else if (!Q_stricmp(buf, "chat")) {
ADDRLP4 12
ARGP4
ADDRGP4 $385
ARGP4
ADDRLP4 1060
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1060
INDIRI4
CNSTI4 0
NEI4 $383
line 772
;771:			//remove first and last quote from the chat message
;772:			memmove(args, args+1, strlen(args));
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1064
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 1064
INDIRU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
line 773
;773:			args[strlen(args)-1] = '\0';
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1072
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1072
INDIRU4
CNSTU4 1
SUBU4
ADDRLP4 8
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 774
;774:			trap_BotQueueConsoleMessage(bs->cs, CMS_CHAT, args);
ADDRLP4 4
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 trap_BotQueueConsoleMessage
CALLV
pop
line 775
;775:		}
ADDRGP4 $384
JUMPV
LABELV $383
line 776
;776:		else if (!Q_stricmp(buf, "tchat")) {
ADDRLP4 12
ARGP4
ADDRGP4 $388
ARGP4
ADDRLP4 1064
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1064
INDIRI4
CNSTI4 0
NEI4 $386
line 778
;777:			//remove first and last quote from the chat message
;778:			memmove(args, args+1, strlen(args));
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1068
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 1068
INDIRU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
line 779
;779:			args[strlen(args)-1] = '\0';
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1076
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1076
INDIRU4
CNSTU4 1
SUBU4
ADDRLP4 8
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 780
;780:			trap_BotQueueConsoleMessage(bs->cs, CMS_CHAT, args);
ADDRLP4 4
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 trap_BotQueueConsoleMessage
CALLV
pop
line 781
;781:		}
ADDRGP4 $387
JUMPV
LABELV $386
line 782
;782:		else if (!Q_stricmp(buf, "scores"))
ADDRLP4 12
ARGP4
ADDRGP4 $391
ARGP4
ADDRLP4 1068
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1068
INDIRI4
CNSTI4 0
NEI4 $389
line 783
;783:			{ /*FIXME: parse scores?*/ }
ADDRGP4 $390
JUMPV
LABELV $389
line 784
;784:		else if (!Q_stricmp(buf, "clientLevelShot"))
ADDRLP4 12
ARGP4
ADDRGP4 $394
ARGP4
ADDRLP4 1072
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1072
INDIRI4
CNSTI4 0
NEI4 $392
line 785
;785:			{ /*ignore*/ }
LABELV $392
LABELV $390
LABELV $387
LABELV $384
LABELV $381
LABELV $378
LABELV $375
line 786
;786:	}
LABELV $370
line 751
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 1040
ADDRGP4 trap_BotGetConsoleMessage
CALLI4
ASGNI4
ADDRLP4 1040
INDIRI4
CNSTI4 0
NEI4 $369
line 788
;787:	//add the delta angles to the bot's current view angles
;788:	for (j = 0; j < 3; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $395
line 789
;789:		bs->viewangles[j] = AngleMod(bs->viewangles[j] + SHORT2ANGLE(bs->cur_ps.delta_angles[j]));
ADDRLP4 1044
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 1052
ADDRLP4 1044
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 1052
INDIRP4
INDIRF4
CNSTF4 1001652224
ADDRLP4 1044
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 72
ADDP4
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDF4
ARGF4
ADDRLP4 1056
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 1052
INDIRP4
ADDRLP4 1056
INDIRF4
ASGNF4
line 790
;790:	}
LABELV $396
line 788
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $395
line 792
;791:	//increase the local time of the bot
;792:	bs->ltime += thinktime;
ADDRLP4 1044
ADDRLP4 4
INDIRP4
CNSTI4 6032
ADDP4
ASGNP4
ADDRLP4 1044
INDIRP4
ADDRLP4 1044
INDIRP4
INDIRF4
ADDRFP4 4
INDIRF4
ADDF4
ASGNF4
line 794
;793:	//
;794:	bs->thinktime = thinktime;
ADDRLP4 4
INDIRP4
CNSTI4 4880
ADDP4
ADDRFP4 4
INDIRF4
ASGNF4
line 796
;795:	//origin of the bot
;796:	VectorCopy(bs->cur_ps.origin, bs->origin);
ADDRLP4 4
INDIRP4
CNSTI4 4884
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 798
;797:	//eye coordinates of the bot
;798:	VectorCopy(bs->cur_ps.origin, bs->eye);
ADDRLP4 4
INDIRP4
CNSTI4 4912
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 799
;799:	bs->eye[2] += bs->cur_ps.viewheight;
ADDRLP4 1060
ADDRLP4 4
INDIRP4
CNSTI4 4920
ADDP4
ASGNP4
ADDRLP4 1060
INDIRP4
ADDRLP4 1060
INDIRP4
INDIRF4
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 801
;800:	//get the area the bot is in
;801:	bs->areanum = BotPointAreaNum(bs->origin);
ADDRLP4 4
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 1068
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 4924
ADDP4
ADDRLP4 1068
INDIRI4
ASGNI4
line 803
;802:	//the real AI
;803:	BotDeathmatchAI(bs, thinktime);
ADDRLP4 4
INDIRP4
ARGP4
ADDRFP4 4
INDIRF4
ARGF4
ADDRGP4 BotDeathmatchAI
CALLV
pop
line 805
;804:	//set the weapon selection every AI frame
;805:	trap_EA_SelectWeapon(bs->client, bs->weaponnum);
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_SelectWeapon
CALLV
pop
line 807
;806:	//subtract the delta angles
;807:	for (j = 0; j < 3; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $399
line 808
;808:		bs->viewangles[j] = AngleMod(bs->viewangles[j] - SHORT2ANGLE(bs->cur_ps.delta_angles[j]));
ADDRLP4 1076
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 1084
ADDRLP4 1076
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 6252
ADDP4
ADDP4
ASGNP4
ADDRLP4 1084
INDIRP4
INDIRF4
CNSTF4 1001652224
ADDRLP4 1076
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 72
ADDP4
ADDP4
INDIRI4
CVIF4 4
MULF4
SUBF4
ARGF4
ADDRLP4 1088
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 1084
INDIRP4
ADDRLP4 1088
INDIRF4
ASGNF4
line 809
;809:	}
LABELV $400
line 807
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $399
line 811
;810:	//everything was ok
;811:	return qtrue;
CNSTI4 1
RETI4
LABELV $364
endproc BotAI 1092 12
export BotScheduleBotThink
proc BotScheduleBotThink 12 0
line 819
;812:}
;813:
;814:/*
;815:==================
;816:BotScheduleBotThink
;817:==================
;818:*/
;819:void BotScheduleBotThink(void) {
line 822
;820:	int i, botnum;
;821:
;822:	botnum = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 824
;823:
;824:	for( i = 0; i < MAX_CLIENTS; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $404
line 825
;825:		if( !botstates[i] || !botstates[i]->inuse ) {
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $410
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $408
LABELV $410
line 826
;826:			continue;
ADDRGP4 $405
JUMPV
LABELV $408
line 829
;827:		}
;828:		//initialize the bot think residual time
;829:		botstates[i]->botthink_residual = bot_thinktime.integer * botnum / numbots;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 bot_thinktime+12
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 numbots
INDIRI4
DIVI4
ASGNI4
line 830
;830:		botnum++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 831
;831:	}
LABELV $405
line 824
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $404
line 832
;832:}
LABELV $403
endproc BotScheduleBotThink 12 0
export BotAISetupClient
proc BotAISetupClient 516 16
line 839
;833:
;834:/*
;835:==============
;836:BotAISetupClient
;837:==============
;838:*/
;839:int BotAISetupClient(int client, struct bot_settings_s *settings) {
line 844
;840:	char filename[MAX_PATH], name[MAX_PATH], gender[MAX_PATH];
;841:	bot_state_t *bs;
;842:	int errnum;
;843:
;844:	if (!botstates[client]) botstates[client] = G_Alloc(sizeof(bot_state_t));
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $413
CNSTI4 6724
ARGI4
ADDRLP4 440
ADDRGP4 G_Alloc
CALLP4
ASGNP4
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
ADDRLP4 440
INDIRP4
ASGNP4
LABELV $413
line 845
;845:	bs = botstates[client];
ADDRLP4 0
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
line 847
;846:
;847:	if (bs && bs->inuse) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $415
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $415
line 848
;848:		BotAI_Print(PRT_FATAL, "BotAISetupClient: client %d already setup\n", client);
CNSTI4 4
ARGI4
ADDRGP4 $417
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 849
;849:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $412
JUMPV
LABELV $415
line 852
;850:	}
;851:
;852:	if (!trap_AAS_Initialized()) {
ADDRLP4 448
ADDRGP4 trap_AAS_Initialized
CALLI4
ASGNI4
ADDRLP4 448
INDIRI4
CNSTI4 0
NEI4 $418
line 853
;853:		BotAI_Print(PRT_FATAL, "AAS not initialized\n");
CNSTI4 4
ARGI4
ADDRGP4 $420
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 854
;854:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $412
JUMPV
LABELV $418
line 858
;855:	}
;856:
;857:	//load the bot character
;858:	bs->character = trap_BotLoadCharacter(settings->characterfile, settings->skill);
ADDRLP4 452
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 452
INDIRP4
ARGP4
ADDRLP4 452
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ARGI4
ADDRLP4 456
ADDRGP4 trap_BotLoadCharacter
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
ADDRLP4 456
INDIRI4
ASGNI4
line 859
;859:	if (!bs->character) {
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
CNSTI4 0
NEI4 $421
line 860
;860:		BotAI_Print(PRT_FATAL, "couldn't load skill %d from %s\n", settings->skill, settings->characterfile);
CNSTI4 4
ARGI4
ADDRGP4 $423
ARGP4
ADDRLP4 460
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 460
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ARGI4
ADDRLP4 460
INDIRP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 861
;861:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $412
JUMPV
LABELV $421
line 864
;862:	}
;863:	//copy the settings
;864:	memcpy(&bs->settings, settings, sizeof(bot_settings_t));
ADDRLP4 0
INDIRP4
CNSTI4 4584
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
CNSTU4 292
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 866
;865:	//allocate a goal state
;866:	bs->gs = trap_BotAllocGoalState(client);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 460
ADDRGP4 trap_BotAllocGoalState
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
ADDRLP4 460
INDIRI4
ASGNI4
line 868
;867:	//load the item weights
;868:	trap_Characteristic_String(bs->character, CHARACTERISTIC_ITEMWEIGHTS, filename, MAX_PATH);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 40
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Characteristic_String
CALLV
pop
line 869
;869:	errnum = trap_BotLoadItemWeights(bs->gs, filename);
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRLP4 464
ADDRGP4 trap_BotLoadItemWeights
CALLI4
ASGNI4
ADDRLP4 148
ADDRLP4 464
INDIRI4
ASGNI4
line 870
;870:	if (errnum != BLERR_NOERROR) {
ADDRLP4 148
INDIRI4
CNSTI4 0
EQI4 $424
line 871
;871:		trap_BotFreeGoalState(bs->gs);
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeGoalState
CALLV
pop
line 872
;872:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $412
JUMPV
LABELV $424
line 875
;873:	}
;874:	//allocate a weapon state
;875:	bs->ws = trap_BotAllocWeaponState();
ADDRLP4 468
ADDRGP4 trap_BotAllocWeaponState
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 6224
ADDP4
ADDRLP4 468
INDIRI4
ASGNI4
line 877
;876:	//load the weapon weights
;877:	trap_Characteristic_String(bs->character, CHARACTERISTIC_WEAPONWEIGHTS, filename, MAX_PATH);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Characteristic_String
CALLV
pop
line 878
;878:	errnum = trap_BotLoadWeaponWeights(bs->ws, filename);
ADDRLP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRLP4 472
ADDRGP4 trap_BotLoadWeaponWeights
CALLI4
ASGNI4
ADDRLP4 148
ADDRLP4 472
INDIRI4
ASGNI4
line 879
;879:	if (errnum != BLERR_NOERROR) {
ADDRLP4 148
INDIRI4
CNSTI4 0
EQI4 $426
line 880
;880:		trap_BotFreeGoalState(bs->gs);
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeGoalState
CALLV
pop
line 881
;881:		trap_BotFreeWeaponState(bs->ws);
ADDRLP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeWeaponState
CALLV
pop
line 882
;882:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $412
JUMPV
LABELV $426
line 885
;883:	}
;884:	//allocate a chat state
;885:	bs->cs = trap_BotAllocChatState();
ADDRLP4 476
ADDRGP4 trap_BotAllocChatState
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
ADDRLP4 476
INDIRI4
ASGNI4
line 887
;886:	//load the chat file
;887:	trap_Characteristic_String(bs->character, CHARACTERISTIC_CHAT_FILE, filename, MAX_PATH);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 21
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Characteristic_String
CALLV
pop
line 888
;888:	trap_Characteristic_String(bs->character, CHARACTERISTIC_CHAT_NAME, name, MAX_PATH);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 22
ARGI4
ADDRLP4 296
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Characteristic_String
CALLV
pop
line 889
;889:	errnum = trap_BotLoadChatFile(bs->cs, filename, name);
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRLP4 296
ARGP4
ADDRLP4 480
ADDRGP4 trap_BotLoadChatFile
CALLI4
ASGNI4
ADDRLP4 148
ADDRLP4 480
INDIRI4
ASGNI4
line 890
;890:	if (errnum != BLERR_NOERROR) {
ADDRLP4 148
INDIRI4
CNSTI4 0
EQI4 $428
line 891
;891:		trap_BotFreeChatState(bs->cs);
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeChatState
CALLV
pop
line 892
;892:		trap_BotFreeGoalState(bs->gs);
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeGoalState
CALLV
pop
line 893
;893:		trap_BotFreeWeaponState(bs->ws);
ADDRLP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeWeaponState
CALLV
pop
line 894
;894:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $412
JUMPV
LABELV $428
line 897
;895:	}
;896:	//get the gender characteristic
;897:	trap_Characteristic_String(bs->character, CHARACTERISTIC_GENDER, gender, MAX_PATH);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 152
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Characteristic_String
CALLV
pop
line 899
;898:	//set the chat gender
;899:	if (*gender == 'f' || *gender == 'F') trap_BotSetChatGender(bs->cs, CHAT_GENDERFEMALE);
ADDRLP4 484
ADDRLP4 152
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 484
INDIRI4
CNSTI4 102
EQI4 $432
ADDRLP4 484
INDIRI4
CNSTI4 70
NEI4 $430
LABELV $432
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotSetChatGender
CALLV
pop
ADDRGP4 $431
JUMPV
LABELV $430
line 900
;900:	else if (*gender == 'm' || *gender == 'M') trap_BotSetChatGender(bs->cs, CHAT_GENDERMALE);
ADDRLP4 488
ADDRLP4 152
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 488
INDIRI4
CNSTI4 109
EQI4 $435
ADDRLP4 488
INDIRI4
CNSTI4 77
NEI4 $433
LABELV $435
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_BotSetChatGender
CALLV
pop
ADDRGP4 $434
JUMPV
LABELV $433
line 901
;901:	else trap_BotSetChatGender(bs->cs, CHAT_GENDERLESS);
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotSetChatGender
CALLV
pop
LABELV $434
LABELV $431
line 903
;902:
;903:	bs->inuse = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 1
ASGNI4
line 904
;904:	bs->client = client;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 905
;905:	bs->entitynum = client;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 906
;906:	bs->setupcount = 4;
ADDRLP4 0
INDIRP4
CNSTI4 5992
ADDP4
CNSTI4 4
ASGNI4
line 907
;907:	bs->entergame_time = trap_AAS_Time();
ADDRLP4 492
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 6036
ADDP4
ADDRLP4 492
INDIRF4
ASGNF4
line 908
;908:	bs->ms = trap_BotAllocMoveState();
ADDRLP4 496
ADDRGP4 trap_BotAllocMoveState
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 6212
ADDP4
ADDRLP4 496
INDIRI4
ASGNI4
line 909
;909:	bs->walker = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_WALKER, 0, 1);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 48
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 504
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 6028
ADDP4
ADDRLP4 504
INDIRF4
ASGNF4
line 910
;910:	numbots++;
ADDRLP4 508
ADDRGP4 numbots
ASGNP4
ADDRLP4 508
INDIRP4
ADDRLP4 508
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 912
;911:
;912:	if (trap_Cvar_VariableIntegerValue("bot_testichat")) {
ADDRGP4 $438
ARGP4
ADDRLP4 512
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRLP4 512
INDIRI4
CNSTI4 0
EQI4 $436
line 913
;913:		trap_BotLibVarSet("bot_testichat", "1");
ADDRGP4 $438
ARGP4
ADDRGP4 $240
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 914
;914:		BotChatTest(bs);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 BotChatTest
CALLV
pop
line 915
;915:	}
LABELV $436
line 917
;916:	//NOTE: reschedule the bot thinking
;917:	BotScheduleBotThink();
ADDRGP4 BotScheduleBotThink
CALLV
pop
line 919
;918:	//if interbreeding start with a mutation
;919:	if (bot_interbreed) {
ADDRGP4 bot_interbreed
INDIRI4
CNSTI4 0
EQI4 $439
line 920
;920:		trap_BotMutateGoalFuzzyLogic(bs->gs, 1);
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
CNSTF4 1065353216
ARGF4
ADDRGP4 trap_BotMutateGoalFuzzyLogic
CALLV
pop
line 921
;921:	}
LABELV $439
line 923
;922:	//bot has been setup succesfully
;923:	return qtrue;
CNSTI4 1
RETI4
LABELV $412
endproc BotAISetupClient 516 16
export BotAIShutdownClient
proc BotAIShutdownClient 16 12
line 931
;924:}
;925:
;926:/*
;927:==============
;928:BotAIShutdownClient
;929:==============
;930:*/
;931:int BotAIShutdownClient(int client) {
line 934
;932:	bot_state_t *bs;
;933:
;934:	bs = botstates[client];
ADDRLP4 0
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
line 935
;935:	if (!bs || !bs->inuse) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $444
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $442
LABELV $444
line 937
;936:		//BotAI_Print(PRT_ERROR, "BotAIShutdownClient: client %d already shutdown\n", client);
;937:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $441
JUMPV
LABELV $442
line 940
;938:	}
;939:
;940:	if (BotChat_ExitGame(bs)) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 BotChat_ExitGame
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $445
line 941
;941:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 942
;942:	}
LABELV $445
line 944
;943:
;944:	trap_BotFreeMoveState(bs->ms);
ADDRLP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeMoveState
CALLV
pop
line 946
;945:	//free the goal state`			
;946:	trap_BotFreeGoalState(bs->gs);
ADDRLP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeGoalState
CALLV
pop
line 948
;947:	//free the chat file
;948:	trap_BotFreeChatState(bs->cs);
ADDRLP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeChatState
CALLV
pop
line 950
;949:	//free the weapon weights
;950:	trap_BotFreeWeaponState(bs->ws);
ADDRLP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeWeaponState
CALLV
pop
line 952
;951:	//free the bot character
;952:	trap_BotFreeCharacter(bs->character);
ADDRLP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotFreeCharacter
CALLV
pop
line 954
;953:	//
;954:	BotFreeWaypoints(bs->checkpoints);
ADDRLP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 955
;955:	BotFreeWaypoints(bs->patrolpoints);
ADDRLP4 0
INDIRP4
CNSTI4 6712
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 957
;956:	//clear the bot state
;957:	memset(bs, 0, sizeof(bot_state_t));
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 6724
ARGU4
ADDRGP4 memset
CALLP4
pop
line 959
;958:	//set the inuse flag to qfalse
;959:	bs->inuse = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 0
ASGNI4
line 961
;960:	//there's one bot less
;961:	numbots--;
ADDRLP4 12
ADDRGP4 numbots
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 963
;962:	//everything went ok
;963:	return qtrue;
CNSTI4 1
RETI4
LABELV $441
endproc BotAIShutdownClient 16 12
export BotResetState
proc BotResetState 772 12
line 974
;964:}
;965:
;966:/*
;967:==============
;968:BotResetState
;969:
;970:called when a bot enters the intermission or observer mode and
;971:when the level is changed
;972:==============
;973:*/
;974:void BotResetState(bot_state_t *bs) {
line 983
;975:	int client, entitynum, inuse;
;976:	int movestate, goalstate, chatstate, weaponstate;
;977:	bot_settings_t settings;
;978:	int character;
;979:	playerState_t ps;							//current player state
;980:	float entergame_time;
;981:
;982:	//save some things that should not be reset here
;983:	memcpy(&settings, &bs->settings, sizeof(bot_settings_t));
ADDRLP4 28
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 4584
ADDP4
ARGP4
CNSTU4 292
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 984
;984:	memcpy(&ps, &bs->cur_ps, sizeof(playerState_t));
ADDRLP4 324
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ARGP4
CNSTU4 444
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 985
;985:	inuse = bs->inuse;
ADDRLP4 8
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 986
;986:	client = bs->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 987
;987:	entitynum = bs->entitynum;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ASGNI4
line 988
;988:	character = bs->character;
ADDRLP4 320
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ASGNI4
line 989
;989:	movestate = bs->ms;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ASGNI4
line 990
;990:	goalstate = bs->gs;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ASGNI4
line 991
;991:	chatstate = bs->cs;
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ASGNI4
line 992
;992:	weaponstate = bs->ws;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ASGNI4
line 993
;993:	entergame_time = bs->entergame_time;
ADDRLP4 768
ADDRFP4 0
INDIRP4
CNSTI4 6036
ADDP4
INDIRF4
ASGNF4
line 995
;994:	//free checkpoints and patrol points
;995:	BotFreeWaypoints(bs->checkpoints);
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 996
;996:	BotFreeWaypoints(bs->patrolpoints);
ADDRFP4 0
INDIRP4
CNSTI4 6712
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 998
;997:	//reset the whole state
;998:	memset(bs, 0, sizeof(bot_state_t));
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 6724
ARGU4
ADDRGP4 memset
CALLP4
pop
line 1000
;999:	//copy back some state stuff that should not be reset
;1000:	bs->ms = movestate;
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 1001
;1001:	bs->gs = goalstate;
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
ADDRLP4 16
INDIRI4
ASGNI4
line 1002
;1002:	bs->cs = chatstate;
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
ADDRLP4 20
INDIRI4
ASGNI4
line 1003
;1003:	bs->ws = weaponstate;
ADDRFP4 0
INDIRP4
CNSTI4 6224
ADDP4
ADDRLP4 24
INDIRI4
ASGNI4
line 1004
;1004:	memcpy(&bs->cur_ps, &ps, sizeof(playerState_t));
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ARGP4
ADDRLP4 324
ARGP4
CNSTU4 444
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 1005
;1005:	memcpy(&bs->settings, &settings, sizeof(bot_settings_t));
ADDRFP4 0
INDIRP4
CNSTI4 4584
ADDP4
ARGP4
ADDRLP4 28
ARGP4
CNSTU4 292
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 1006
;1006:	bs->inuse = inuse;
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ASGNI4
line 1007
;1007:	bs->client = client;
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1008
;1008:	bs->entitynum = entitynum;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 4
INDIRI4
ASGNI4
line 1009
;1009:	bs->character = character;
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
ADDRLP4 320
INDIRI4
ASGNI4
line 1010
;1010:	bs->entergame_time = entergame_time;
ADDRFP4 0
INDIRP4
CNSTI4 6036
ADDP4
ADDRLP4 768
INDIRF4
ASGNF4
line 1012
;1011:	//reset several states
;1012:	if (bs->ms) trap_BotResetMoveState(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
CNSTI4 0
EQI4 $448
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetMoveState
CALLV
pop
LABELV $448
line 1013
;1013:	if (bs->gs) trap_BotResetGoalState(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
CNSTI4 0
EQI4 $450
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetGoalState
CALLV
pop
LABELV $450
line 1014
;1014:	if (bs->ws) trap_BotResetWeaponState(bs->ws);
ADDRFP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
CNSTI4 0
EQI4 $452
ADDRFP4 0
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetWeaponState
CALLV
pop
LABELV $452
line 1015
;1015:	if (bs->gs) trap_BotResetAvoidGoals(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
CNSTI4 0
EQI4 $454
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidGoals
CALLV
pop
LABELV $454
line 1016
;1016:	if (bs->ms) trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
CNSTI4 0
EQI4 $456
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
LABELV $456
line 1017
;1017:}
LABELV $447
endproc BotResetState 772 12
export BotAILoadMap
proc BotAILoadMap 280 16
line 1024
;1018:
;1019:/*
;1020:==============
;1021:BotAILoadMap
;1022:==============
;1023:*/
;1024:int BotAILoadMap( int restart ) {
line 1028
;1025:	int			i;
;1026:	vmCvar_t	mapname;
;1027:
;1028:	if (!restart) {
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $459
line 1029
;1029:		trap_Cvar_Register( &mapname, "mapname", "", CVAR_SERVERINFO | CVAR_ROM );
ADDRLP4 4
ARGP4
ADDRGP4 $461
ARGP4
ADDRGP4 $224
ARGP4
CNSTI4 68
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1030
;1030:		trap_BotLibLoadMap( mapname.string );
ADDRLP4 4+16
ARGP4
ADDRGP4 trap_BotLibLoadMap
CALLI4
pop
line 1031
;1031:	}
LABELV $459
line 1033
;1032:
;1033:	for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $463
line 1034
;1034:		if (botstates[i] && botstates[i]->inuse) {
ADDRLP4 276
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 276
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $467
ADDRLP4 276
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $467
line 1035
;1035:			BotResetState( botstates[i] );
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotResetState
CALLV
pop
line 1036
;1036:			botstates[i]->setupcount = 4;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 5992
ADDP4
CNSTI4 4
ASGNI4
line 1037
;1037:		}
LABELV $467
line 1038
;1038:	}
LABELV $464
line 1033
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $463
line 1040
;1039:
;1040:	BotSetupDeathmatchAI();
ADDRGP4 BotSetupDeathmatchAI
CALLV
pop
line 1042
;1041:
;1042:	return qtrue;
CNSTI4 1
RETI4
LABELV $458
endproc BotAILoadMap 280 16
bss
align 4
LABELV $470
skip 4
align 4
LABELV $471
skip 4
align 4
LABELV $472
skip 4
export BotAIStartFrame
code
proc BotAIStartFrame 148 12
line 1050
;1043:}
;1044:
;1045:/*
;1046:==================
;1047:BotAIStartFrame
;1048:==================
;1049:*/
;1050:int BotAIStartFrame(int time) {
line 1059
;1051:	int i;
;1052:	gentity_t	*ent;
;1053:	bot_entitystate_t state;
;1054:	int elapsed_time, thinktime;
;1055:	static int local_time;
;1056:	static int botlib_residual;
;1057:	static int lastbotthink_time;
;1058:
;1059:	G_CheckBotSpawn();
ADDRGP4 G_CheckBotSpawn
CALLV
pop
line 1061
;1060:
;1061:	trap_Cvar_Update(&bot_rocketjump);
ADDRGP4 bot_rocketjump
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1062
;1062:	trap_Cvar_Update(&bot_grapple);
ADDRGP4 bot_grapple
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1063
;1063:	trap_Cvar_Update(&bot_fastchat);
ADDRGP4 bot_fastchat
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1064
;1064:	trap_Cvar_Update(&bot_nochat);
ADDRGP4 bot_nochat
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1065
;1065:	trap_Cvar_Update(&bot_testrchat);
ADDRGP4 bot_testrchat
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1066
;1066:	trap_Cvar_Update(&bot_thinktime);
ADDRGP4 bot_thinktime
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1067
;1067:	trap_Cvar_Update(&bot_memorydump);
ADDRGP4 bot_memorydump
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1068
;1068:	trap_Cvar_Update(&bot_pause);
ADDRGP4 bot_pause
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1069
;1069:	trap_Cvar_Update(&bot_report);
ADDRGP4 bot_report
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 1071
;1070:
;1071:	if (bot_report.integer) {
ADDRGP4 bot_report+12
INDIRI4
CNSTI4 0
EQI4 $473
line 1072
;1072:		BotTeamplayReport();
ADDRGP4 BotTeamplayReport
CALLV
pop
line 1073
;1073:		trap_Cvar_Set("bot_report", "0");
ADDRGP4 $476
ARGP4
ADDRGP4 $477
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1074
;1074:	}
LABELV $473
line 1076
;1075:
;1076:	if (bot_pause.integer) {
ADDRGP4 bot_pause+12
INDIRI4
CNSTI4 0
EQI4 $478
line 1078
;1077:		// execute bot user commands every frame
;1078:		for( i = 0; i < MAX_CLIENTS; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $481
line 1079
;1079:			if( !botstates[i] || !botstates[i]->inuse ) {
ADDRLP4 128
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 128
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $487
ADDRLP4 128
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $485
LABELV $487
line 1080
;1080:				continue;
ADDRGP4 $482
JUMPV
LABELV $485
line 1082
;1081:			}
;1082:			if( g_entities[i].client->pers.connected != CON_CONNECTED ) {
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
EQI4 $488
line 1083
;1083:				continue;
ADDRGP4 $482
JUMPV
LABELV $488
line 1085
;1084:			}
;1085:			botstates[i]->lastucmd.forwardmove = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 484
ADDP4
CNSTI1 0
ASGNI1
line 1086
;1086:			botstates[i]->lastucmd.rightmove = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 485
ADDP4
CNSTI1 0
ASGNI1
line 1087
;1087:			botstates[i]->lastucmd.upmove = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 486
ADDP4
CNSTI1 0
ASGNI1
line 1088
;1088:			botstates[i]->lastucmd.buttons = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 468
ADDP4
CNSTU1 0
ASGNU1
line 1089
;1089:			botstates[i]->lastucmd.serverTime = time;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 464
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1090
;1090:			trap_BotUserCommand(botstates[i]->client, &botstates[i]->lastucmd);
ADDRLP4 132
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 132
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 132
INDIRP4
CNSTI4 464
ADDP4
ARGP4
ADDRGP4 trap_BotUserCommand
CALLV
pop
line 1091
;1091:		}
LABELV $482
line 1078
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $481
line 1092
;1092:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $469
JUMPV
LABELV $478
line 1095
;1093:	}
;1094:
;1095:	if (bot_memorydump.integer) {
ADDRGP4 bot_memorydump+12
INDIRI4
CNSTI4 0
EQI4 $491
line 1096
;1096:		trap_BotLibVarSet("memorydump", "1");
ADDRGP4 $494
ARGP4
ADDRGP4 $240
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1097
;1097:		trap_Cvar_Set("bot_memorydump", "0");
ADDRGP4 $495
ARGP4
ADDRGP4 $477
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1098
;1098:	}
LABELV $491
line 1100
;1099:	//check if bot interbreeding is activated
;1100:	BotInterbreeding();
ADDRGP4 BotInterbreeding
CALLV
pop
line 1102
;1101:	//cap the bot think time
;1102:	if (bot_thinktime.integer > 200) {
ADDRGP4 bot_thinktime+12
INDIRI4
CNSTI4 200
LEI4 $496
line 1103
;1103:		trap_Cvar_Set("bot_thinktime", "200");
ADDRGP4 $499
ARGP4
ADDRGP4 $500
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1104
;1104:	}
LABELV $496
line 1106
;1105:	//if the bot think time changed we should reschedule the bots
;1106:	if (bot_thinktime.integer != lastbotthink_time) {
ADDRGP4 bot_thinktime+12
INDIRI4
ADDRGP4 $472
INDIRI4
EQI4 $501
line 1107
;1107:		lastbotthink_time = bot_thinktime.integer;
ADDRGP4 $472
ADDRGP4 bot_thinktime+12
INDIRI4
ASGNI4
line 1108
;1108:		BotScheduleBotThink();
ADDRGP4 BotScheduleBotThink
CALLV
pop
line 1109
;1109:	}
LABELV $501
line 1111
;1110:
;1111:	elapsed_time = time - local_time;
ADDRLP4 120
ADDRFP4 0
INDIRI4
ADDRGP4 $470
INDIRI4
SUBI4
ASGNI4
line 1112
;1112:	local_time = time;
ADDRGP4 $470
ADDRFP4 0
INDIRI4
ASGNI4
line 1114
;1113:
;1114:	botlib_residual += elapsed_time;
ADDRLP4 128
ADDRGP4 $471
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRI4
ADDRLP4 120
INDIRI4
ADDI4
ASGNI4
line 1116
;1115:
;1116:	if (elapsed_time > bot_thinktime.integer) thinktime = elapsed_time;
ADDRLP4 120
INDIRI4
ADDRGP4 bot_thinktime+12
INDIRI4
LEI4 $505
ADDRLP4 124
ADDRLP4 120
INDIRI4
ASGNI4
ADDRGP4 $506
JUMPV
LABELV $505
line 1117
;1117:	else thinktime = bot_thinktime.integer;
ADDRLP4 124
ADDRGP4 bot_thinktime+12
INDIRI4
ASGNI4
LABELV $506
line 1120
;1118:
;1119:	// update the bot library
;1120:	if ( botlib_residual >= thinktime ) {
ADDRGP4 $471
INDIRI4
ADDRLP4 124
INDIRI4
LTI4 $509
line 1121
;1121:		botlib_residual -= thinktime;
ADDRLP4 132
ADDRGP4 $471
ASGNP4
ADDRLP4 132
INDIRP4
ADDRLP4 132
INDIRP4
INDIRI4
ADDRLP4 124
INDIRI4
SUBI4
ASGNI4
line 1123
;1122:
;1123:		trap_BotLibStartFrame((float) time / 1000);
ADDRFP4 0
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ARGF4
ADDRGP4 trap_BotLibStartFrame
CALLI4
pop
line 1125
;1124:
;1125:		if (!trap_AAS_Initialized()) return qfalse;
ADDRLP4 136
ADDRGP4 trap_AAS_Initialized
CALLI4
ASGNI4
ADDRLP4 136
INDIRI4
CNSTI4 0
NEI4 $511
CNSTI4 0
RETI4
ADDRGP4 $469
JUMPV
LABELV $511
line 1128
;1126:
;1127:		//update entities in the botlib
;1128:		for (i = 0; i < MAX_GENTITIES; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $513
line 1129
;1129:			ent = &g_entities[i];
ADDRLP4 4
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1130
;1130:			if (!ent->inuse) continue;
ADDRLP4 4
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $517
ADDRGP4 $514
JUMPV
LABELV $517
line 1131
;1131:			if (!ent->r.linked) continue;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRI4
CNSTI4 0
NEI4 $519
ADDRGP4 $514
JUMPV
LABELV $519
line 1132
;1132:			if (ent->r.svFlags & SVF_NOCLIENT) continue;
ADDRLP4 4
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $521
ADDRGP4 $514
JUMPV
LABELV $521
line 1134
;1133:			//
;1134:			memset(&state, 0, sizeof(bot_entitystate_t));
ADDRLP4 8
ARGP4
CNSTI4 0
ARGI4
CNSTU4 112
ARGU4
ADDRGP4 memset
CALLP4
pop
line 1136
;1135:			//
;1136:			VectorCopy(ent->r.currentOrigin, state.origin);
ADDRLP4 8+8
ADDRLP4 4
INDIRP4
CNSTI4 476
ADDP4
INDIRB
ASGNB 12
line 1137
;1137:			VectorCopy(ent->r.currentAngles, state.angles);
ADDRLP4 8+20
ADDRLP4 4
INDIRP4
CNSTI4 488
ADDP4
INDIRB
ASGNB 12
line 1138
;1138:			VectorCopy(ent->s.origin2, state.old_origin);
ADDRLP4 8+32
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 1139
;1139:			VectorCopy(ent->r.mins, state.mins);
ADDRLP4 8+44
ADDRLP4 4
INDIRP4
CNSTI4 424
ADDP4
INDIRB
ASGNB 12
line 1140
;1140:			VectorCopy(ent->r.maxs, state.maxs);
ADDRLP4 8+56
ADDRLP4 4
INDIRP4
CNSTI4 436
ADDP4
INDIRB
ASGNB 12
line 1141
;1141:			state.type = ent->s.eType;
ADDRLP4 8
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 1142
;1142:			state.flags = ent->s.eFlags;
ADDRLP4 8+4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 1143
;1143:			if (ent->r.bmodel) state.solid = SOLID_BSP;
ADDRLP4 4
INDIRP4
CNSTI4 420
ADDP4
INDIRI4
CNSTI4 0
EQI4 $529
ADDRLP4 8+72
CNSTI4 3
ASGNI4
ADDRGP4 $530
JUMPV
LABELV $529
line 1144
;1144:			else state.solid = SOLID_BBOX;
ADDRLP4 8+72
CNSTI4 2
ASGNI4
LABELV $530
line 1145
;1145:			state.groundent = ent->s.groundEntityNum;
ADDRLP4 8+68
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ASGNI4
line 1146
;1146:			state.modelindex = ent->s.modelindex;
ADDRLP4 8+76
ADDRLP4 4
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ASGNI4
line 1147
;1147:			state.modelindex2 = ent->s.modelindex2;
ADDRLP4 8+80
ADDRLP4 4
INDIRP4
CNSTI4 164
ADDP4
INDIRI4
ASGNI4
line 1148
;1148:			state.frame = ent->s.frame;
ADDRLP4 8+84
ADDRLP4 4
INDIRP4
CNSTI4 172
ADDP4
INDIRI4
ASGNI4
line 1149
;1149:			state.event = ent->s.event;
ADDRLP4 8+88
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
ASGNI4
line 1150
;1150:			state.eventParm = ent->s.eventParm;
ADDRLP4 8+92
ADDRLP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 1151
;1151:			state.powerups = ent->s.powerups;
ADDRLP4 8+96
ADDRLP4 4
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ASGNI4
line 1152
;1152:			state.legsAnim = ent->s.legsAnim;
ADDRLP4 8+104
ADDRLP4 4
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ASGNI4
line 1153
;1153:			state.torsoAnim = ent->s.torsoAnim;
ADDRLP4 8+108
ADDRLP4 4
INDIRP4
CNSTI4 200
ADDP4
INDIRI4
ASGNI4
line 1154
;1154:			state.weapon = ent->s.weapon;
ADDRLP4 8+100
ADDRLP4 4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
line 1156
;1155:			//
;1156:			trap_BotLibUpdateEntity(i, &state);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
ADDRGP4 trap_BotLibUpdateEntity
CALLI4
pop
line 1157
;1157:		}
LABELV $514
line 1128
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 1024
LTI4 $513
line 1159
;1158:
;1159:		BotAIRegularUpdate();
ADDRGP4 BotAIRegularUpdate
CALLV
pop
line 1161
;1160:
;1161:	}
LABELV $509
line 1164
;1162:
;1163:	// execute scheduled bot AI
;1164:	for( i = 0; i < MAX_CLIENTS; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $543
line 1165
;1165:		if( !botstates[i] || !botstates[i]->inuse ) {
ADDRLP4 132
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 132
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $549
ADDRLP4 132
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $547
LABELV $549
line 1166
;1166:			continue;
ADDRGP4 $544
JUMPV
LABELV $547
line 1169
;1167:		}
;1168:		//
;1169:		botstates[i]->botthink_residual += elapsed_time;
ADDRLP4 136
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 136
INDIRP4
INDIRI4
ADDRLP4 120
INDIRI4
ADDI4
ASGNI4
line 1171
;1170:		//
;1171:		if ( botstates[i]->botthink_residual >= thinktime ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ADDRLP4 124
INDIRI4
LTI4 $550
line 1172
;1172:			botstates[i]->botthink_residual -= thinktime;
ADDRLP4 140
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 140
INDIRP4
ADDRLP4 140
INDIRP4
INDIRI4
ADDRLP4 124
INDIRI4
SUBI4
ASGNI4
line 1174
;1173:
;1174:			if (!trap_AAS_Initialized()) return qfalse;
ADDRLP4 144
ADDRGP4 trap_AAS_Initialized
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
NEI4 $552
CNSTI4 0
RETI4
ADDRGP4 $469
JUMPV
LABELV $552
line 1176
;1175:
;1176:			if (g_entities[i].client->pers.connected == CON_CONNECTED) {
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
NEI4 $554
line 1177
;1177:				BotAI(i, (float) thinktime / 1000);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 124
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ARGF4
ADDRGP4 BotAI
CALLI4
pop
line 1178
;1178:			}
LABELV $554
line 1179
;1179:		}
LABELV $550
line 1180
;1180:	}
LABELV $544
line 1164
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $543
line 1184
;1181:
;1182:
;1183:	// execute bot user commands every frame
;1184:	for( i = 0; i < MAX_CLIENTS; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $557
line 1185
;1185:		if( !botstates[i] || !botstates[i]->inuse ) {
ADDRLP4 132
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 132
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $563
ADDRLP4 132
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $561
LABELV $563
line 1186
;1186:			continue;
ADDRGP4 $558
JUMPV
LABELV $561
line 1188
;1187:		}
;1188:		if( g_entities[i].client->pers.connected != CON_CONNECTED ) {
CNSTI4 792
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
CNSTI4 2
EQI4 $564
line 1189
;1189:			continue;
ADDRGP4 $558
JUMPV
LABELV $564
line 1192
;1190:		}
;1191:
;1192:		BotUpdateInput(botstates[i], time, elapsed_time);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 120
INDIRI4
ARGI4
ADDRGP4 BotUpdateInput
CALLV
pop
line 1193
;1193:		trap_BotUserCommand(botstates[i]->client, &botstates[i]->lastucmd);
ADDRLP4 136
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 136
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 136
INDIRP4
CNSTI4 464
ADDP4
ARGP4
ADDRGP4 trap_BotUserCommand
CALLV
pop
line 1194
;1194:	}
LABELV $558
line 1184
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $557
line 1196
;1195:
;1196:	return qtrue;
CNSTI4 1
RETI4
LABELV $469
endproc BotAIStartFrame 148 12
export BotInitLibrary
proc BotInitLibrary 212 16
line 1204
;1197:}
;1198:
;1199:/*
;1200:==============
;1201:BotInitLibrary
;1202:==============
;1203:*/
;1204:int BotInitLibrary(void) {
line 1208
;1205:	char buf[144];
;1206:
;1207:	//set the maxclients and maxentities library variables before calling BotSetupLibrary
;1208:	trap_Cvar_VariableStringBuffer("sv_maxclients", buf, sizeof(buf));
ADDRGP4 $568
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1209
;1209:	if (!strlen(buf)) strcpy(buf, "8");
ADDRLP4 0
ARGP4
ADDRLP4 144
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 144
INDIRU4
CNSTU4 0
NEU4 $569
ADDRLP4 0
ARGP4
ADDRGP4 $571
ARGP4
ADDRGP4 strcpy
CALLP4
pop
LABELV $569
line 1210
;1210:	trap_BotLibVarSet("maxclients", buf);
ADDRGP4 $572
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1211
;1211:	Com_sprintf(buf, sizeof(buf), "%d", MAX_GENTITIES);
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 $232
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 1212
;1212:	trap_BotLibVarSet("maxentities", buf);
ADDRGP4 $573
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1214
;1213:	//bsp checksum
;1214:	trap_Cvar_VariableStringBuffer("sv_mapChecksum", buf, sizeof(buf));
ADDRGP4 $574
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1215
;1215:	if (strlen(buf)) trap_BotLibVarSet("sv_mapChecksum", buf);
ADDRLP4 0
ARGP4
ADDRLP4 148
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 148
INDIRU4
CNSTU4 0
EQU4 $575
ADDRGP4 $574
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $575
line 1217
;1216:	//maximum number of aas links
;1217:	trap_Cvar_VariableStringBuffer("max_aaslinks", buf, sizeof(buf));
ADDRGP4 $577
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1218
;1218:	if (strlen(buf)) trap_BotLibVarSet("max_aaslinks", buf);
ADDRLP4 0
ARGP4
ADDRLP4 152
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 152
INDIRU4
CNSTU4 0
EQU4 $578
ADDRGP4 $577
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $578
line 1220
;1219:	//maximum number of items in a level
;1220:	trap_Cvar_VariableStringBuffer("max_levelitems", buf, sizeof(buf));
ADDRGP4 $580
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1221
;1221:	if (strlen(buf)) trap_BotLibVarSet("max_levelitems", buf);
ADDRLP4 0
ARGP4
ADDRLP4 156
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 156
INDIRU4
CNSTU4 0
EQU4 $581
ADDRGP4 $580
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $581
line 1223
;1222:	//game type
;1223:	trap_Cvar_VariableStringBuffer("g_gametype", buf, sizeof(buf));
ADDRGP4 $231
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1224
;1224:	if (!strlen(buf)) strcpy(buf, "0");
ADDRLP4 0
ARGP4
ADDRLP4 160
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 160
INDIRU4
CNSTU4 0
NEU4 $583
ADDRLP4 0
ARGP4
ADDRGP4 $477
ARGP4
ADDRGP4 strcpy
CALLP4
pop
LABELV $583
line 1225
;1225:	trap_BotLibVarSet("g_gametype", buf);
ADDRGP4 $231
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1227
;1226:	//bot developer mode and log file
;1227:	trap_Cvar_VariableStringBuffer("bot_developer", buf, sizeof(buf));
ADDRGP4 $585
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1228
;1228:	if (!strlen(buf)) strcpy(buf, "0");
ADDRLP4 0
ARGP4
ADDRLP4 164
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 164
INDIRU4
CNSTU4 0
NEU4 $586
ADDRLP4 0
ARGP4
ADDRGP4 $477
ARGP4
ADDRGP4 strcpy
CALLP4
pop
LABELV $586
line 1229
;1229:	trap_BotLibVarSet("bot_developer", buf);
ADDRGP4 $585
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1230
;1230:	trap_BotLibVarSet("log", buf);
ADDRGP4 $588
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1232
;1231:	//no chatting
;1232:	trap_Cvar_VariableStringBuffer("bot_nochat", buf, sizeof(buf));
ADDRGP4 $589
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1233
;1233:	if (strlen(buf)) trap_BotLibVarSet("nochat", "0");
ADDRLP4 0
ARGP4
ADDRLP4 168
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 168
INDIRU4
CNSTU4 0
EQU4 $590
ADDRGP4 $592
ARGP4
ADDRGP4 $477
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $590
line 1235
;1234:	//visualize jump pads
;1235:	trap_Cvar_VariableStringBuffer("bot_visualizejumppads", buf, sizeof(buf));
ADDRGP4 $593
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1236
;1236:	if (strlen(buf)) trap_BotLibVarSet("bot_visualizejumppads", buf);
ADDRLP4 0
ARGP4
ADDRLP4 172
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 172
INDIRU4
CNSTU4 0
EQU4 $594
ADDRGP4 $593
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $594
line 1238
;1237:	//forced clustering calculations
;1238:	trap_Cvar_VariableStringBuffer("bot_forceclustering", buf, sizeof(buf));
ADDRGP4 $596
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1239
;1239:	if (strlen(buf)) trap_BotLibVarSet("forceclustering", buf);
ADDRLP4 0
ARGP4
ADDRLP4 176
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 176
INDIRU4
CNSTU4 0
EQU4 $597
ADDRGP4 $599
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $597
line 1241
;1240:	//forced reachability calculations
;1241:	trap_Cvar_VariableStringBuffer("bot_forcereachability", buf, sizeof(buf));
ADDRGP4 $600
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1242
;1242:	if (strlen(buf)) trap_BotLibVarSet("forcereachability", buf);
ADDRLP4 0
ARGP4
ADDRLP4 180
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 180
INDIRU4
CNSTU4 0
EQU4 $601
ADDRGP4 $603
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $601
line 1244
;1243:	//force writing of AAS to file
;1244:	trap_Cvar_VariableStringBuffer("bot_forcewrite", buf, sizeof(buf));
ADDRGP4 $604
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1245
;1245:	if (strlen(buf)) trap_BotLibVarSet("forcewrite", buf);
ADDRLP4 0
ARGP4
ADDRLP4 184
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 184
INDIRU4
CNSTU4 0
EQU4 $605
ADDRGP4 $607
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $605
line 1247
;1246:	//no AAS optimization
;1247:	trap_Cvar_VariableStringBuffer("bot_aasoptimize", buf, sizeof(buf));
ADDRGP4 $608
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1248
;1248:	if (strlen(buf)) trap_BotLibVarSet("aasoptimize", buf);
ADDRLP4 0
ARGP4
ADDRLP4 188
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 188
INDIRU4
CNSTU4 0
EQU4 $609
ADDRGP4 $611
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $609
line 1250
;1249:	//reload instead of cache bot character files
;1250:	trap_Cvar_VariableStringBuffer("bot_reloadcharacters", buf, sizeof(buf));
ADDRGP4 $239
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1251
;1251:	if (!strlen(buf)) strcpy(buf, "0");
ADDRLP4 0
ARGP4
ADDRLP4 192
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 192
INDIRU4
CNSTU4 0
NEU4 $612
ADDRLP4 0
ARGP4
ADDRGP4 $477
ARGP4
ADDRGP4 strcpy
CALLP4
pop
LABELV $612
line 1252
;1252:	trap_BotLibVarSet("bot_reloadcharacters", buf);
ADDRGP4 $239
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 1254
;1253:	//base directory
;1254:	trap_Cvar_VariableStringBuffer("fs_basepath", buf, sizeof(buf));
ADDRGP4 $614
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1255
;1255:	if (strlen(buf)) trap_BotLibVarSet("basedir", buf);
ADDRLP4 0
ARGP4
ADDRLP4 196
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 196
INDIRU4
CNSTU4 0
EQU4 $615
ADDRGP4 $617
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $615
line 1257
;1256:	//game directory
;1257:	trap_Cvar_VariableStringBuffer("fs_game", buf, sizeof(buf));
ADDRGP4 $618
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1258
;1258:	if (strlen(buf)) trap_BotLibVarSet("gamedir", buf);
ADDRLP4 0
ARGP4
ADDRLP4 200
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 200
INDIRU4
CNSTU4 0
EQU4 $619
ADDRGP4 $621
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $619
line 1260
;1259:	//cd directory
;1260:	trap_Cvar_VariableStringBuffer("fs_cdpath", buf, sizeof(buf));
ADDRGP4 $622
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 1261
;1261:	if (strlen(buf)) trap_BotLibVarSet("cddir", buf);
ADDRLP4 0
ARGP4
ADDRLP4 204
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 204
INDIRU4
CNSTU4 0
EQU4 $623
ADDRGP4 $625
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
LABELV $623
line 1263
;1262:	//setup the bot library
;1263:	return trap_BotLibSetup();
ADDRLP4 208
ADDRGP4 trap_BotLibSetup
CALLI4
ASGNI4
ADDRLP4 208
INDIRI4
RETI4
LABELV $567
endproc BotInitLibrary 212 16
export BotAISetup
proc BotAISetup 8 16
line 1271
;1264:}
;1265:
;1266:/*
;1267:==============
;1268:BotAISetup
;1269:==============
;1270:*/
;1271:int BotAISetup( int restart ) {
line 1279
;1272:	int			errnum;
;1273:
;1274:#ifdef RANDOMIZE
;1275:	srand((unsigned)time(NULL));
;1276:#endif //RANDOMIZE
;1277:
;1278:
;1279:	trap_Cvar_Register(&bot_thinktime, "bot_thinktime", "100", CVAR_CHEAT);
ADDRGP4 bot_thinktime
ARGP4
ADDRGP4 $499
ARGP4
ADDRGP4 $627
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1280
;1280:	trap_Cvar_Register(&bot_memorydump, "bot_memorydump", "0", CVAR_CHEAT);
ADDRGP4 bot_memorydump
ARGP4
ADDRGP4 $495
ARGP4
ADDRGP4 $477
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1281
;1281:	trap_Cvar_Register(&bot_pause, "bot_pause", "0", CVAR_CHEAT);
ADDRGP4 bot_pause
ARGP4
ADDRGP4 $628
ARGP4
ADDRGP4 $477
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1282
;1282:	trap_Cvar_Register(&bot_report, "bot_report", "0", CVAR_CHEAT);
ADDRGP4 bot_report
ARGP4
ADDRGP4 $476
ARGP4
ADDRGP4 $477
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1283
;1283:	trap_Cvar_Register(&bot_testsolid, "bot_testsolid", "0", CVAR_CHEAT);
ADDRGP4 bot_testsolid
ARGP4
ADDRGP4 $629
ARGP4
ADDRGP4 $477
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1284
;1284:	trap_Cvar_Register(&bot_interbreedchar, "bot_interbreedchar", "", 0);
ADDRGP4 bot_interbreedchar
ARGP4
ADDRGP4 $249
ARGP4
ADDRGP4 $224
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1285
;1285:	trap_Cvar_Register(&bot_interbreedbots, "bot_interbreedbots", "10", 0);
ADDRGP4 bot_interbreedbots
ARGP4
ADDRGP4 $630
ARGP4
ADDRGP4 $631
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1286
;1286:	trap_Cvar_Register(&bot_interbreedcycle, "bot_interbreedcycle", "20", 0);
ADDRGP4 bot_interbreedcycle
ARGP4
ADDRGP4 $632
ARGP4
ADDRGP4 $633
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1287
;1287:	trap_Cvar_Register(&bot_interbreedwrite, "bot_interbreedwrite", "", 0);
ADDRGP4 bot_interbreedwrite
ARGP4
ADDRGP4 $223
ARGP4
ADDRGP4 $224
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 1290
;1288:
;1289:	//if the game is restarted for a tournament
;1290:	if (restart) {
ADDRFP4 0
INDIRI4
CNSTI4 0
EQI4 $634
line 1291
;1291:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $626
JUMPV
LABELV $634
line 1295
;1292:	}
;1293:
;1294:	//initialize the bot states
;1295:	memset( botstates, 0, sizeof(botstates) );
ADDRGP4 botstates
ARGP4
CNSTI4 0
ARGI4
CNSTU4 512
ARGU4
ADDRGP4 memset
CALLP4
pop
line 1297
;1296:
;1297:	errnum = BotInitLibrary();
ADDRLP4 4
ADDRGP4 BotInitLibrary
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
ASGNI4
line 1298
;1298:	if (errnum != BLERR_NOERROR) return qfalse;
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $636
CNSTI4 0
RETI4
ADDRGP4 $626
JUMPV
LABELV $636
line 1299
;1299:	return qtrue;
CNSTI4 1
RETI4
LABELV $626
endproc BotAISetup 8 16
export BotAIShutdown
proc BotAIShutdown 8 4
line 1307
;1300:}
;1301:
;1302:/*
;1303:==============
;1304:BotAIShutdown
;1305:==============
;1306:*/
;1307:int BotAIShutdown( int restart ) {
line 1312
;1308:
;1309:	int i;
;1310:
;1311:	//if the game is restarted for a tournament
;1312:	if ( restart ) {
ADDRFP4 0
INDIRI4
CNSTI4 0
EQI4 $639
line 1314
;1313:		//shutdown all the bots in the botlib
;1314:		for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $641
line 1315
;1315:			if (botstates[i] && botstates[i]->inuse) {
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $645
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $645
line 1316
;1316:				BotAIShutdownClient(botstates[i]->client);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 botstates
ADDP4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotAIShutdownClient
CALLI4
pop
line 1317
;1317:			}
LABELV $645
line 1318
;1318:		}
LABELV $642
line 1314
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $641
line 1320
;1319:		//don't shutdown the bot library
;1320:	}
ADDRGP4 $640
JUMPV
LABELV $639
line 1321
;1321:	else {
line 1322
;1322:		trap_BotLibShutdown();
ADDRGP4 trap_BotLibShutdown
CALLI4
pop
line 1323
;1323:	}
LABELV $640
line 1324
;1324:	return qtrue;
CNSTI4 1
RETI4
LABELV $638
endproc BotAIShutdown 8 4
import ExitLevel
bss
export bot_interbreedwrite
align 4
LABELV bot_interbreedwrite
skip 272
export bot_interbreedcycle
align 4
LABELV bot_interbreedcycle
skip 272
export bot_interbreedbots
align 4
LABELV bot_interbreedbots
skip 272
export bot_interbreedchar
align 4
LABELV bot_interbreedchar
skip 272
export bot_testsolid
align 4
LABELV bot_testsolid
skip 272
export bot_report
align 4
LABELV bot_report
skip 272
export bot_pause
align 4
LABELV bot_pause
skip 272
export bot_memorydump
align 4
LABELV bot_memorydump
skip 272
export bot_thinktime
align 4
LABELV bot_thinktime
skip 272
export bot_interbreedmatchcount
align 4
LABELV bot_interbreedmatchcount
skip 4
export bot_interbreed
align 4
LABELV bot_interbreed
skip 4
export regularupdate_time
align 4
LABELV regularupdate_time
skip 4
export numbots
align 4
LABELV numbots
skip 4
export botstates
align 4
LABELV botstates
skip 512
import BotDumpNodeSwitches
import BotResetNodeSwitches
import AINode_Battle_NBG
import AINode_Battle_Retreat
import AINode_Battle_Chase
import AINode_Battle_Fight
import AINode_Seek_LTG
import AINode_Seek_NBG
import AINode_Seek_ActivateEntity
import AINode_Stand
import AINode_Respawn
import AINode_Observer
import AINode_Intermission
import AIEnter_Battle_NBG
import AIEnter_Battle_Retreat
import AIEnter_Battle_Chase
import AIEnter_Battle_Fight
import AIEnter_Seek_Camp
import AIEnter_Seek_LTG
import AIEnter_Seek_NBG
import AIEnter_Seek_ActivateEntity
import AIEnter_Stand
import AIEnter_Respawn
import AIEnter_Observer
import AIEnter_Intermission
import BotPrintTeamGoal
import BotMatchMessage
import BotChatTest
import BotValidChatPosition
import BotChatTime
import BotChat_Random
import BotChat_EnemySuicide
import BotChat_Kill
import BotChat_Death
import BotChat_HitNoKill
import BotChat_HitNoDeath
import BotChat_HitTalking
import BotChat_EndLevel
import BotChat_StartLevel
import BotChat_ExitGame
import BotChat_EnterGame
import ctf_blueflag
import ctf_redflag
import bot_challenge
import bot_testrchat
import bot_nochat
import bot_fastchat
import bot_rocketjump
import bot_grapple
import maxclients
import gametype
import BotMapScripts
import BotPointAreaNum
import ClientFromName
import stristr
import BotFindWayPoint
import BotCreateWayPoint
import BotCTFRetreatGoals
import BotCTFSeekGoals
import BotCTFCarryingFlag
import BotCTFTeam
import BotAIBlocked
import BotCheckAttack
import BotAimAtEnemy
import BotEntityVisible
import BotRoamGoal
import BotFindEnemy
import BotTeamFlagCarrierVisible
import TeamPlayIsOn
import BotSameTeam
import BotAttackMove
import BotWantsToCamp
import BotCanAndWantsToRocketJump
import BotWantsToHelp
import BotWantsToChase
import BotWantsToRetreat
import BotAggression
import ClientSkin
import EasyClientName
import ClientName
import EntityIsShooting
import EntityIsInvisible
import EntityIsDead
import BotInLavaOrSlime
import BotIntermission
import BotIsObserver
import BotIsDead
import BotBattleUseItems
import BotUpdateBattleInventory
import BotUpdateInventory
import BotSetupForMovement
import BotChooseWeapon
import BotFreeWaypoints
import BotDeathmatchAI
import BotShutdownDeathmatchAI
import BotSetupDeathmatchAI
import BotResetWeaponState
import BotFreeWeaponState
import BotAllocWeaponState
import BotLoadWeaponWeights
import BotGetWeaponInfo
import BotChooseBestFightWeapon
import BotShutdownWeaponAI
import BotSetupWeaponAI
import BotShutdownMoveAI
import BotSetupMoveAI
import BotSetBrushModelTypes
import BotInitMoveState
import BotFreeMoveState
import BotAllocMoveState
import BotPredictVisiblePosition
import BotMovementViewTarget
import BotReachabilityArea
import BotResetLastAvoidReach
import BotResetAvoidReach
import BotMoveInDirection
import BotMoveToGoal
import BotResetMoveState
import BotShutdownGoalAI
import BotSetupGoalAI
import BotFreeGoalState
import BotAllocGoalState
import BotFreeItemWeights
import BotLoadItemWeights
import BotMutateGoalFuzzyLogic
import BotSaveGoalFuzzyLogic
import BotInterbreedGoalFuzzyLogic
import BotUpdateEntityItems
import BotInitLevelItems
import BotAvoidGoalTime
import BotGetMapLocationGoal
import BotGetNextCampSpotGoal
import BotGetLevelItemGoal
import BotItemGoalInVisButNotVisible
import BotTouchingGoal
import BotChooseNBGItem
import BotChooseLTGItem
import BotGetSecondGoal
import BotGetTopGoal
import BotGoalName
import BotDumpGoalStack
import BotDumpAvoidGoals
import BotEmptyGoalStack
import BotPopGoal
import BotPushGoal
import BotRemoveFromAvoidGoals
import BotResetAvoidGoals
import BotResetGoalState
import GeneticParentsAndChildSelection
import BotSetChatName
import BotSetChatGender
import BotLoadChatFile
import BotReplaceSynonyms
import UnifyWhiteSpaces
import BotMatchVariable
import BotFindMatch
import StringContains
import BotGetChatMessage
import BotEnterChat
import BotChatLength
import BotReplyChat
import BotNumInitialChats
import BotInitialChat
import BotNumConsoleMessages
import BotNextConsoleMessage
import BotRemoveConsoleMessage
import BotQueueConsoleMessage
import BotFreeChatState
import BotAllocChatState
import BotShutdownChatAI
import BotSetupChatAI
import BotShutdownCharacters
import Characteristic_String
import Characteristic_BInteger
import Characteristic_Integer
import Characteristic_BFloat
import Characteristic_Float
import BotFreeCharacter
import BotLoadCharacter
import EA_Shutdown
import EA_Setup
import EA_ResetInput
import EA_GetInput
import EA_EndRegular
import EA_View
import EA_Move
import EA_MoveRight
import EA_MoveLeft
import EA_MoveBack
import EA_MoveForward
import EA_MoveDown
import EA_MoveUp
import EA_Walk
import EA_Crouch
import EA_DelayedJump
import EA_Jump
import EA_Use
import EA_Gesture
import EA_Talk
import EA_Respawn
import EA_Attack
import EA_SelectWeapon
import EA_Command
import EA_DropInv
import EA_UseInv
import EA_DropItem
import EA_UseItem
import EA_SayTeam
import EA_Say
import GetBotLibAPI
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $633
byte 1 50
byte 1 48
byte 1 0
align 1
LABELV $632
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 105
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 98
byte 1 114
byte 1 101
byte 1 101
byte 1 100
byte 1 99
byte 1 121
byte 1 99
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $631
byte 1 49
byte 1 48
byte 1 0
align 1
LABELV $630
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 105
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 98
byte 1 114
byte 1 101
byte 1 101
byte 1 100
byte 1 98
byte 1 111
byte 1 116
byte 1 115
byte 1 0
align 1
LABELV $629
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 116
byte 1 101
byte 1 115
byte 1 116
byte 1 115
byte 1 111
byte 1 108
byte 1 105
byte 1 100
byte 1 0
align 1
LABELV $628
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 112
byte 1 97
byte 1 117
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $627
byte 1 49
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $625
byte 1 99
byte 1 100
byte 1 100
byte 1 105
byte 1 114
byte 1 0
align 1
LABELV $622
byte 1 102
byte 1 115
byte 1 95
byte 1 99
byte 1 100
byte 1 112
byte 1 97
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $621
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 100
byte 1 105
byte 1 114
byte 1 0
align 1
LABELV $618
byte 1 102
byte 1 115
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $617
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 100
byte 1 105
byte 1 114
byte 1 0
align 1
LABELV $614
byte 1 102
byte 1 115
byte 1 95
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 112
byte 1 97
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $611
byte 1 97
byte 1 97
byte 1 115
byte 1 111
byte 1 112
byte 1 116
byte 1 105
byte 1 109
byte 1 105
byte 1 122
byte 1 101
byte 1 0
align 1
LABELV $608
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 97
byte 1 97
byte 1 115
byte 1 111
byte 1 112
byte 1 116
byte 1 105
byte 1 109
byte 1 105
byte 1 122
byte 1 101
byte 1 0
align 1
LABELV $607
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 119
byte 1 114
byte 1 105
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $604
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 119
byte 1 114
byte 1 105
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $603
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 114
byte 1 101
byte 1 97
byte 1 99
byte 1 104
byte 1 97
byte 1 98
byte 1 105
byte 1 108
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $600
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 114
byte 1 101
byte 1 97
byte 1 99
byte 1 104
byte 1 97
byte 1 98
byte 1 105
byte 1 108
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $599
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 99
byte 1 108
byte 1 117
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $596
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 99
byte 1 108
byte 1 117
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $593
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 118
byte 1 105
byte 1 115
byte 1 117
byte 1 97
byte 1 108
byte 1 105
byte 1 122
byte 1 101
byte 1 106
byte 1 117
byte 1 109
byte 1 112
byte 1 112
byte 1 97
byte 1 100
byte 1 115
byte 1 0
align 1
LABELV $592
byte 1 110
byte 1 111
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $589
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 110
byte 1 111
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $588
byte 1 108
byte 1 111
byte 1 103
byte 1 0
align 1
LABELV $585
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 100
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 111
byte 1 112
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $580
byte 1 109
byte 1 97
byte 1 120
byte 1 95
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 0
align 1
LABELV $577
byte 1 109
byte 1 97
byte 1 120
byte 1 95
byte 1 97
byte 1 97
byte 1 115
byte 1 108
byte 1 105
byte 1 110
byte 1 107
byte 1 115
byte 1 0
align 1
LABELV $574
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 112
byte 1 67
byte 1 104
byte 1 101
byte 1 99
byte 1 107
byte 1 115
byte 1 117
byte 1 109
byte 1 0
align 1
LABELV $573
byte 1 109
byte 1 97
byte 1 120
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 105
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $572
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
align 1
LABELV $571
byte 1 56
byte 1 0
align 1
LABELV $568
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
align 1
LABELV $500
byte 1 50
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $499
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 116
byte 1 104
byte 1 105
byte 1 110
byte 1 107
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $495
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 109
byte 1 101
byte 1 109
byte 1 111
byte 1 114
byte 1 121
byte 1 100
byte 1 117
byte 1 109
byte 1 112
byte 1 0
align 1
LABELV $494
byte 1 109
byte 1 101
byte 1 109
byte 1 111
byte 1 114
byte 1 121
byte 1 100
byte 1 117
byte 1 109
byte 1 112
byte 1 0
align 1
LABELV $477
byte 1 48
byte 1 0
align 1
LABELV $476
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 114
byte 1 101
byte 1 112
byte 1 111
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $461
byte 1 109
byte 1 97
byte 1 112
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $438
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 116
byte 1 101
byte 1 115
byte 1 116
byte 1 105
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $423
byte 1 99
byte 1 111
byte 1 117
byte 1 108
byte 1 100
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 108
byte 1 111
byte 1 97
byte 1 100
byte 1 32
byte 1 115
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 102
byte 1 114
byte 1 111
byte 1 109
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $420
byte 1 65
byte 1 65
byte 1 83
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 105
byte 1 110
byte 1 105
byte 1 116
byte 1 105
byte 1 97
byte 1 108
byte 1 105
byte 1 122
byte 1 101
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $417
byte 1 66
byte 1 111
byte 1 116
byte 1 65
byte 1 73
byte 1 83
byte 1 101
byte 1 116
byte 1 117
byte 1 112
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 32
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 97
byte 1 108
byte 1 114
byte 1 101
byte 1 97
byte 1 100
byte 1 121
byte 1 32
byte 1 115
byte 1 101
byte 1 116
byte 1 117
byte 1 112
byte 1 10
byte 1 0
align 1
LABELV $394
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 76
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 83
byte 1 104
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $391
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $388
byte 1 116
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $385
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $382
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 0
align 1
LABELV $379
byte 1 99
byte 1 115
byte 1 0
align 1
LABELV $376
byte 1 99
byte 1 112
byte 1 32
byte 1 0
align 1
LABELV $368
byte 1 66
byte 1 111
byte 1 116
byte 1 65
byte 1 73
byte 1 58
byte 1 32
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 115
byte 1 101
byte 1 116
byte 1 117
byte 1 112
byte 1 10
byte 1 0
align 1
LABELV $249
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 105
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 98
byte 1 114
byte 1 101
byte 1 101
byte 1 100
byte 1 99
byte 1 104
byte 1 97
byte 1 114
byte 1 0
align 1
LABELV $246
byte 1 97
byte 1 100
byte 1 100
byte 1 98
byte 1 111
byte 1 116
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 52
byte 1 32
byte 1 102
byte 1 114
byte 1 101
byte 1 101
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 37
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $240
byte 1 49
byte 1 0
align 1
LABELV $239
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 114
byte 1 101
byte 1 108
byte 1 111
byte 1 97
byte 1 100
byte 1 99
byte 1 104
byte 1 97
byte 1 114
byte 1 97
byte 1 99
byte 1 116
byte 1 101
byte 1 114
byte 1 115
byte 1 0
align 1
LABELV $232
byte 1 37
byte 1 100
byte 1 0
align 1
LABELV $231
byte 1 103
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 0
align 1
LABELV $224
byte 1 0
align 1
LABELV $223
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 105
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 98
byte 1 114
byte 1 101
byte 1 101
byte 1 100
byte 1 119
byte 1 114
byte 1 105
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $173
byte 1 94
byte 1 52
byte 1 66
byte 1 76
byte 1 85
byte 1 69
byte 1 10
byte 1 0
align 1
LABELV $171
byte 1 116
byte 1 0
align 1
LABELV $167
byte 1 110
byte 1 0
align 1
LABELV $157
byte 1 94
byte 1 49
byte 1 82
byte 1 69
byte 1 68
byte 1 10
byte 1 0
align 1
LABELV $153
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 114
byte 1 111
byte 1 97
byte 1 109
byte 1 105
byte 1 110
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $152
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $150
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 114
byte 1 117
byte 1 115
byte 1 104
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $148
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 99
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $146
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 112
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 105
byte 1 110
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $144
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 99
byte 1 97
byte 1 109
byte 1 112
byte 1 105
byte 1 110
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $142
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $140
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 103
byte 1 101
byte 1 116
byte 1 116
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $138
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $136
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $134
byte 1 37
byte 1 45
byte 1 50
byte 1 48
byte 1 115
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 104
byte 1 101
byte 1 108
byte 1 112
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $129
byte 1 94
byte 1 52
byte 1 70
byte 1 0
align 1
LABELV $128
byte 1 94
byte 1 49
byte 1 70
byte 1 0
align 1
LABELV $123
byte 1 32
byte 1 0
align 1
LABELV $122
byte 1 76
byte 1 0
align 1
LABELV $118
byte 1 13
byte 1 94
byte 1 49
byte 1 83
byte 1 79
byte 1 76
byte 1 73
byte 1 68
byte 1 32
byte 1 97
byte 1 114
byte 1 101
byte 1 97
byte 1 0
align 1
LABELV $117
byte 1 13
byte 1 101
byte 1 109
byte 1 116
byte 1 112
byte 1 121
byte 1 32
byte 1 97
byte 1 114
byte 1 101
byte 1 97
byte 1 0
align 1
LABELV $61
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $60
byte 1 94
byte 1 49
byte 1 69
byte 1 120
byte 1 105
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $58
byte 1 94
byte 1 49
byte 1 70
byte 1 97
byte 1 116
byte 1 97
byte 1 108
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $56
byte 1 94
byte 1 49
byte 1 69
byte 1 114
byte 1 114
byte 1 111
byte 1 114
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $54
byte 1 94
byte 1 51
byte 1 87
byte 1 97
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $52
byte 1 37
byte 1 115
byte 1 0
