export BotCTFCarryingFlag
code
proc BotCTFCarryingFlag 0 0
file "..\ai_dmq3.c"
line 73
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:/*****************************************************************************
;4: * name:		ai_dmq3.c
;5: *
;6: * desc:		Quake3 bot AI
;7: *
;8: * $Archive: /source/code/game/ai_dmq3.c $
;9: * $Author: Raduffy $ 
;10: * $Revision: 7 $
;11: * $Modtime: 1/14/00 5:28p $
;12: * $Date: 1/14/00 5:35p $
;13: *
;14: *****************************************************************************/
;15:
;16:
;17:#include "g_local.h"
;18:#include "botlib.h"
;19:#include "be_aas.h"
;20:#include "be_ea.h"
;21:#include "be_ai_char.h"
;22:#include "be_ai_chat.h"
;23:#include "be_ai_gen.h"
;24:#include "be_ai_goal.h"
;25:#include "be_ai_move.h"
;26:#include "be_ai_weap.h"
;27://
;28:#include "ai_main.h"
;29:#include "ai_dmq3.h"
;30:#include "ai_chat.h"
;31:#include "ai_cmd.h"
;32:#include "ai_dmnet.h"
;33:#include "ai_team.h"
;34://
;35:#include "chars.h"				//characteristics
;36:#include "inv.h"				//indexes into the inventory
;37:#include "syn.h"				//synonyms
;38:#include "match.h"				//string matching types and vars
;39:
;40:#define IDEAL_ATTACKDIST			140
;41:#define WEAPONINDEX_MACHINEGUN		2
;42:
;43:#define MAX_WAYPOINTS		128
;44://
;45:bot_waypoint_t botai_waypoints[MAX_WAYPOINTS];
;46:bot_waypoint_t *botai_freewaypoints;
;47:
;48://NOTE: not using a cvars which can be updated because the game should be reloaded anyway
;49:int gametype;		//game type
;50:int maxclients;		//maximum number of clients
;51:
;52:vmCvar_t bot_grapple;
;53:vmCvar_t bot_rocketjump;
;54:vmCvar_t bot_fastchat;
;55:vmCvar_t bot_nochat;
;56:vmCvar_t bot_testrchat;
;57:vmCvar_t bot_challenge;
;58:
;59:vec3_t lastteleport_origin;		//last teleport event origin
;60:float lastteleport_time;		//last teleport event time
;61:int max_bspmodelindex;			//maximum BSP model index
;62:
;63://CTF flag goals
;64:bot_goal_t ctf_redflag;
;65:bot_goal_t ctf_blueflag;
;66:
;67:#ifdef CTF
;68:/*
;69:==================
;70:BotCTFCarryingFlag
;71:==================
;72:*/
;73:int BotCTFCarryingFlag(bot_state_t *bs) {
line 74
;74:	if (gametype != GT_CTF) return CTF_FLAG_NONE;
ADDRGP4 gametype
INDIRI4
CNSTI4 4
EQI4 $48
CNSTI4 0
RETI4
ADDRGP4 $47
JUMPV
LABELV $48
line 76
;75:
;76:	if (bs->inventory[INVENTORY_REDFLAG] > 0) return CTF_FLAG_RED;
ADDRFP4 0
INDIRP4
CNSTI4 5060
ADDP4
INDIRI4
CNSTI4 0
LEI4 $50
CNSTI4 1
RETI4
ADDRGP4 $47
JUMPV
LABELV $50
line 77
;77:	else if (bs->inventory[INVENTORY_BLUEFLAG] > 0) return CTF_FLAG_BLUE;
ADDRFP4 0
INDIRP4
CNSTI4 5064
ADDP4
INDIRI4
CNSTI4 0
LEI4 $52
CNSTI4 2
RETI4
ADDRGP4 $47
JUMPV
LABELV $52
line 78
;78:	return CTF_FLAG_NONE;
CNSTI4 0
RETI4
LABELV $47
endproc BotCTFCarryingFlag 0 0
export BotCTFTeam
proc BotCTFTeam 1044 12
line 86
;79:}
;80:
;81:/*
;82:==================
;83:BotCTFTeam
;84:==================
;85:*/
;86:int BotCTFTeam(bot_state_t *bs) {
line 89
;87:	char info[1024];
;88:
;89:	if (gametype != GT_CTF) return CTF_TEAM_NONE;
ADDRGP4 gametype
INDIRI4
CNSTI4 4
EQI4 $55
CNSTI4 0
RETI4
ADDRGP4 $54
JUMPV
LABELV $55
line 90
;90:	if (bs->client < 0 || bs->client >= MAX_CLIENTS) {
ADDRLP4 1024
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
ADDRLP4 1024
INDIRI4
CNSTI4 0
LTI4 $59
ADDRLP4 1024
INDIRI4
CNSTI4 128
LTI4 $57
LABELV $59
line 92
;91:		//BotAI_Print(PRT_ERROR, "BotCTFTeam: client out of range\n");
;92:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $54
JUMPV
LABELV $57
line 94
;93:	}
;94:	trap_GetConfigstring(CS_PLAYERS+bs->client, info, sizeof(info));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 96
;95:	//
;96:	if (atoi(Info_ValueForKey(info, "t")) == TEAM_RED) return CTF_TEAM_RED;
ADDRLP4 0
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1028
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 1032
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 1
NEI4 $60
CNSTI4 1
RETI4
ADDRGP4 $54
JUMPV
LABELV $60
line 97
;97:	else if (atoi(Info_ValueForKey(info, "t")) == TEAM_BLUE) return CTF_TEAM_BLUE;
ADDRLP4 0
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1036
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1036
INDIRP4
ARGP4
ADDRLP4 1040
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1040
INDIRI4
CNSTI4 2
NEI4 $63
CNSTI4 2
RETI4
ADDRGP4 $54
JUMPV
LABELV $63
line 98
;98:	return CTF_TEAM_NONE;
CNSTI4 0
RETI4
LABELV $54
endproc BotCTFTeam 1044 12
export BotCTFRetreatGoals
proc BotCTFRetreatGoals 8 4
line 106
;99:}
;100:
;101:/*
;102:==================
;103:BotCTFRetreatGoals
;104:==================
;105:*/
;106:void BotCTFRetreatGoals(bot_state_t *bs) {
line 108
;107:	//when carrying a flag in ctf the bot should rush to the base
;108:	if (BotCTFCarryingFlag(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $66
line 110
;109:		//if not already rushing to the base
;110:		if (bs->ltgtype != LTG_RUSHBASE) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 5
EQI4 $68
line 111
;111:			bs->ltgtype = LTG_RUSHBASE;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 5
ASGNI4
line 112
;112:			bs->teamgoal_time = trap_AAS_Time() + CTF_RUSHBASE_TIME;
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 4
INDIRF4
CNSTF4 1123024896
ADDF4
ASGNF4
line 113
;113:			bs->rushbaseaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
CNSTF4 0
ASGNF4
line 114
;114:		}
LABELV $68
line 115
;115:	}
LABELV $66
line 116
;116:}
LABELV $65
endproc BotCTFRetreatGoals 8 4
export EntityIsDead
proc EntityIsDead 448 8
line 123
;117:
;118:/*
;119:==================
;120:EntityIsDead
;121:==================
;122:*/
;123:qboolean EntityIsDead(aas_entityinfo_t *entinfo) {
line 126
;124:	playerState_t ps;
;125:
;126:	if (entinfo->number >= 0 && entinfo->number < MAX_CLIENTS) {
ADDRLP4 444
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
ADDRLP4 444
INDIRI4
CNSTI4 0
LTI4 $71
ADDRLP4 444
INDIRI4
CNSTI4 128
GEI4 $71
line 128
;127:		//retrieve the current client state
;128:		BotAI_GetClientState( entinfo->number, &ps );
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
line 129
;129:		if (ps.pm_type != PM_NORMAL) return qtrue;
ADDRLP4 0+4
INDIRI4
CNSTI4 0
EQI4 $73
CNSTI4 1
RETI4
ADDRGP4 $70
JUMPV
LABELV $73
line 130
;130:	}
LABELV $71
line 131
;131:	return qfalse;
CNSTI4 0
RETI4
LABELV $70
endproc EntityIsDead 448 8
export EntityIsInvisible
proc EntityIsInvisible 0 0
line 139
;132:}
;133:
;134:/*
;135:==================
;136:EntityIsInvisible
;137:==================
;138:*/
;139:qboolean EntityIsInvisible(aas_entityinfo_t *entinfo) {
line 140
;140:	if (entinfo->powerups & (1 << PW_INVIS)) {
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $77
line 141
;141:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $76
JUMPV
LABELV $77
line 143
;142:	}
;143:	return qfalse;
CNSTI4 0
RETI4
LABELV $76
endproc EntityIsInvisible 0 0
export EntityCarriesFlag
proc EntityCarriesFlag 0 0
line 151
;144:}
;145:
;146:/*
;147:==================
;148:EntityCarriesFlag
;149:==================
;150:*/
;151:qboolean EntityCarriesFlag(aas_entityinfo_t *entinfo) {
line 152
;152:	if ( entinfo->powerups & ( 1 << PW_REDFLAG ) ) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $80
CNSTI4 1
RETI4
ADDRGP4 $79
JUMPV
LABELV $80
line 153
;153:	if ( entinfo->powerups & ( 1 << PW_BLUEFLAG ) ) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $82
CNSTI4 1
RETI4
ADDRGP4 $79
JUMPV
LABELV $82
line 154
;154:	return qfalse;
CNSTI4 0
RETI4
LABELV $79
endproc EntityCarriesFlag 0 0
export EntityIsShooting
proc EntityIsShooting 0 0
line 162
;155:}
;156:
;157:/*
;158:==================
;159:EntityIsShooting
;160:==================
;161:*/
;162:qboolean EntityIsShooting(aas_entityinfo_t *entinfo) {
line 163
;163:	if (entinfo->flags & EF_FIRING) {
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $85
line 164
;164:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $84
JUMPV
LABELV $85
line 166
;165:	}
;166:	return qfalse;
CNSTI4 0
RETI4
LABELV $84
endproc EntityIsShooting 0 0
export EntityIsChatting
proc EntityIsChatting 0 0
line 174
;167:}
;168:
;169:/*
;170:==================
;171:EntityIsChatting
;172:==================
;173:*/
;174:qboolean EntityIsChatting(aas_entityinfo_t *entinfo) {
line 175
;175:	if (entinfo->flags & EF_TALK) {
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $88
line 176
;176:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $87
JUMPV
LABELV $88
line 178
;177:	}
;178:	return qfalse;
CNSTI4 0
RETI4
LABELV $87
endproc EntityIsChatting 0 0
export EntityHasQuad
proc EntityHasQuad 0 0
line 186
;179:}
;180:
;181:/*
;182:==================
;183:EntityHasQuad
;184:==================
;185:*/
;186:qboolean EntityHasQuad(aas_entityinfo_t *entinfo) {
line 187
;187:	if (entinfo->powerups & (1 << PW_QUAD)) {
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $91
line 188
;188:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $90
JUMPV
LABELV $91
line 190
;189:	}
;190:	return qfalse;
CNSTI4 0
RETI4
LABELV $90
endproc EntityHasQuad 0 0
export BotCTFSeekGoals
proc BotCTFSeekGoals 68 12
line 198
;191:}
;192:
;193:/*
;194:==================
;195:BotCTFSeekGoals
;196:==================
;197:*/
;198:void BotCTFSeekGoals(bot_state_t *bs) {
line 203
;199:	float rnd;
;200:	int flagstatus, c;
;201:
;202:	//when carrying a flag in ctf the bot should rush to the base
;203:	if (BotCTFCarryingFlag(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $94
line 205
;204:		//if not already rushing to the base
;205:		if (bs->ltgtype != LTG_RUSHBASE) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 5
EQI4 $96
line 206
;206:			bs->ltgtype = LTG_RUSHBASE;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 5
ASGNI4
line 207
;207:			bs->teamgoal_time = trap_AAS_Time() + CTF_RUSHBASE_TIME;
ADDRLP4 16
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 16
INDIRF4
CNSTF4 1123024896
ADDF4
ASGNF4
line 208
;208:			bs->rushbaseaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
CNSTF4 0
ASGNF4
line 209
;209:		}
ADDRGP4 $93
JUMPV
LABELV $96
line 210
;210:		else if (bs->rushbaseaway_time > trap_AAS_Time()) {
ADDRLP4 16
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
LEF4 $93
line 211
;211:			if (BotCTFTeam(bs) == CTF_TEAM_RED) flagstatus = bs->redflagstatus;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 1
NEI4 $100
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 6492
ADDP4
INDIRI4
ASGNI4
ADDRGP4 $101
JUMPV
LABELV $100
line 212
;212:			else flagstatus = bs->blueflagstatus;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 6496
ADDP4
INDIRI4
ASGNI4
LABELV $101
line 214
;213:			//if the flag is back
;214:			if (flagstatus == 0) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $93
line 215
;215:				bs->rushbaseaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
CNSTF4 0
ASGNF4
line 216
;216:			}
line 217
;217:		}
line 218
;218:		return;
ADDRGP4 $93
JUMPV
LABELV $94
line 221
;219:	}
;220:	//
;221:	if (BotCTFTeam(bs) == CTF_TEAM_RED) flagstatus = bs->redflagstatus * 2 + bs->blueflagstatus;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 1
NEI4 $104
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 20
INDIRP4
CNSTI4 6492
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ADDRLP4 20
INDIRP4
CNSTI4 6496
ADDP4
INDIRI4
ADDI4
ASGNI4
ADDRGP4 $105
JUMPV
LABELV $104
line 222
;222:	else flagstatus = bs->blueflagstatus * 2 + bs->redflagstatus;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 24
INDIRP4
CNSTI4 6496
ADDP4
INDIRI4
CNSTI4 1
LSHI4
ADDRLP4 24
INDIRP4
CNSTI4 6492
ADDP4
INDIRI4
ADDI4
ASGNI4
LABELV $105
line 224
;223:	//if the enemy flag is not at it's base
;224:	if (flagstatus == 1) {
ADDRLP4 0
INDIRI4
CNSTI4 1
NEI4 $106
line 226
;225:		//if Not defending the base
;226:		if (!(bs->ltgtype == LTG_DEFENDKEYAREA &&
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 3
NEI4 $112
ADDRLP4 32
ADDRLP4 28
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ASGNI4
ADDRLP4 32
INDIRI4
ADDRGP4 ctf_redflag+44
INDIRI4
EQI4 $107
ADDRLP4 32
INDIRI4
ADDRGP4 ctf_blueflag+44
INDIRI4
EQI4 $107
LABELV $112
line 228
;227:			(bs->teamgoal.number == ctf_redflag.number ||
;228:			bs->teamgoal.number == ctf_blueflag.number))) {
line 230
;229:			//if not already accompanying someone
;230:			if (bs->ltgtype != LTG_TEAMACCOMPANY) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 2
EQI4 $107
line 232
;231:				//if there is avisible team mate flag carrier
;232:				c = BotTeamFlagCarrierVisible(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 BotTeamFlagCarrierVisible
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 36
INDIRI4
ASGNI4
line 233
;233:				if (c >= 0) {
ADDRLP4 8
INDIRI4
CNSTI4 0
LTI4 $107
line 236
;234:					//follow the flag carrier
;235:					//the team mate
;236:					bs->teammate = c;
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 238
;237:					//last time the team mate was visible
;238:					bs->teammatevisible_time = trap_AAS_Time();
ADDRLP4 40
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6360
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
line 240
;239:					//set the time to send a message to the team mates
;240:					bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 44
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 44
INDIRF4
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 242
;241:					//get the team goal time
;242:					bs->teamgoal_time = trap_AAS_Time() + TEAM_ACCOMPANY_TIME;
ADDRLP4 52
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 52
INDIRF4
CNSTF4 1142292480
ADDF4
ASGNF4
line 243
;243:					bs->ltgtype = LTG_TEAMACCOMPANY;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 2
ASGNI4
line 244
;244:					bs->formation_dist = 3.5 * 32;		//3.5 meter
ADDRFP4 0
INDIRP4
CNSTI4 6548
ADDP4
CNSTF4 1121976320
ASGNF4
line 245
;245:					bs->arrive_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
CNSTF4 0
ASGNF4
line 246
;246:					return;
ADDRGP4 $93
JUMPV
line 248
;247:				}
;248:			}
line 249
;249:		}
line 250
;250:	}
LABELV $106
line 252
;251:	//if the base flag is stolen
;252:	else if (flagstatus == 2) {
ADDRLP4 0
INDIRI4
CNSTI4 2
NEI4 $117
line 254
;253:		//if not already going for the enemy flag
;254:		if (bs->ltgtype != LTG_GETFLAG) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 4
EQI4 $118
line 256
;255:			//if there's no bot team leader
;256:			if (!BotTeamLeader(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 BotTeamLeader
CALLI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
NEI4 $118
line 258
;257:				//go for the enemy flag
;258:				bs->ltgtype = LTG_GETFLAG;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 4
ASGNI4
line 260
;259:				//no team message
;260:				bs->teammessage_time = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 1065353216
ASGNF4
line 262
;261:				//set the time the bot will stop getting the flag
;262:				bs->teamgoal_time = trap_AAS_Time() + CTF_GETFLAG_TIME;
ADDRLP4 32
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 32
INDIRF4
CNSTF4 1133903872
ADDF4
ASGNF4
line 263
;263:				return;
ADDRGP4 $93
JUMPV
line 265
;264:			}
;265:		}
line 266
;266:	}
LABELV $117
line 268
;267:	//if both flags not at their bases
;268:	else if (flagstatus == 3) {
ADDRLP4 0
INDIRI4
CNSTI4 3
NEI4 $123
line 270
;269:		//
;270:		if (bs->ltgtype != LTG_GETFLAG &&
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 4
EQI4 $125
ADDRLP4 28
INDIRI4
CNSTI4 2
EQI4 $125
line 271
;271:			bs->ltgtype != LTG_TEAMACCOMPANY) {
line 273
;272:			//if there is avisible team mate flag carrier
;273:			c = BotTeamFlagCarrierVisible(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 BotTeamFlagCarrierVisible
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 32
INDIRI4
ASGNI4
line 274
;274:			if (c >= 0) {
ADDRLP4 8
INDIRI4
CNSTI4 0
LTI4 $93
line 276
;275:				//follow the flag carrier
;276:				return;
ADDRGP4 $93
JUMPV
line 278
;277:			}
;278:			else {
line 280
;279:				//otherwise attack the enemy base
;280:			}
line 281
;281:			return;
LABELV $125
line 283
;282:		}
;283:	}
LABELV $123
LABELV $118
LABELV $107
line 285
;284:	//if the bot is roaming
;285:	if (bs->ctfroam_time > trap_AAS_Time()) return;
ADDRLP4 28
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6128
ADDP4
INDIRF4
ADDRLP4 28
INDIRF4
LEF4 $129
ADDRGP4 $93
JUMPV
LABELV $129
line 287
;286:	//if already a CTF or team goal
;287:	if (bs->ltgtype == LTG_TEAMHELP ||
ADDRLP4 32
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 1
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 2
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 3
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 4
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 5
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 6
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 8
EQI4 $139
ADDRLP4 32
INDIRI4
CNSTI4 9
NEI4 $131
LABELV $139
line 294
;288:			bs->ltgtype == LTG_TEAMACCOMPANY ||
;289:			bs->ltgtype == LTG_DEFENDKEYAREA ||
;290:			bs->ltgtype == LTG_GETFLAG ||
;291:			bs->ltgtype == LTG_RUSHBASE ||
;292:			bs->ltgtype == LTG_RETURNFLAG ||
;293:			bs->ltgtype == LTG_CAMPORDER ||
;294:			bs->ltgtype == LTG_PATROL) {
line 295
;295:		return;
ADDRGP4 $93
JUMPV
LABELV $131
line 298
;296:	}
;297:	//if the bot has anough aggression to decide what to do
;298:	if (BotAggression(bs) < 50) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 BotAggression
CALLF4
ASGNF4
ADDRLP4 36
INDIRF4
CNSTF4 1112014848
GEF4 $140
ADDRGP4 $93
JUMPV
LABELV $140
line 300
;299:	//set the time to send a message to the team mates
;300:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 40
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 40
INDIRF4
CNSTF4 1073741824
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 302
;301:	//get the flag or defend the base
;302:	rnd = random();
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ASGNF4
line 303
;303:	if (rnd < 0.33 && ctf_redflag.areanum && ctf_blueflag.areanum) {
ADDRLP4 4
INDIRF4
CNSTF4 1051260355
GEF4 $142
ADDRLP4 52
CNSTI4 0
ASGNI4
ADDRGP4 ctf_redflag+12
INDIRI4
ADDRLP4 52
INDIRI4
EQI4 $142
ADDRGP4 ctf_blueflag+12
INDIRI4
ADDRLP4 52
INDIRI4
EQI4 $142
line 304
;304:		bs->ltgtype = LTG_GETFLAG;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 4
ASGNI4
line 306
;305:		//set the time the bot will stop getting the flag
;306:		bs->teamgoal_time = trap_AAS_Time() + CTF_GETFLAG_TIME;
ADDRLP4 56
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 56
INDIRF4
CNSTF4 1133903872
ADDF4
ASGNF4
line 307
;307:	}
ADDRGP4 $143
JUMPV
LABELV $142
line 308
;308:	else if (rnd < 0.66 && ctf_redflag.areanum && ctf_blueflag.areanum) {
ADDRLP4 4
INDIRF4
CNSTF4 1059648963
GEF4 $146
ADDRLP4 56
CNSTI4 0
ASGNI4
ADDRGP4 ctf_redflag+12
INDIRI4
ADDRLP4 56
INDIRI4
EQI4 $146
ADDRGP4 ctf_blueflag+12
INDIRI4
ADDRLP4 56
INDIRI4
EQI4 $146
line 310
;309:		//
;310:		if (BotCTFTeam(bs) == CTF_TEAM_RED) memcpy(&bs->teamgoal, &ctf_redflag, sizeof(bot_goal_t));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 60
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 1
NEI4 $150
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRGP4 ctf_redflag
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
ADDRGP4 $151
JUMPV
LABELV $150
line 311
;311:		else memcpy(&bs->teamgoal, &ctf_blueflag, sizeof(bot_goal_t));
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRGP4 ctf_blueflag
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
LABELV $151
line 313
;312:		//set the ltg type
;313:		bs->ltgtype = LTG_DEFENDKEYAREA;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 3
ASGNI4
line 315
;314:		//set the time the bot stops defending the base
;315:		bs->teamgoal_time = trap_AAS_Time() + TEAM_DEFENDKEYAREA_TIME;
ADDRLP4 64
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 64
INDIRF4
CNSTF4 1133903872
ADDF4
ASGNF4
line 316
;316:		bs->defendaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6116
ADDP4
CNSTF4 0
ASGNF4
line 317
;317:	}
ADDRGP4 $147
JUMPV
LABELV $146
line 318
;318:	else {
line 319
;319:		bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 321
;320:		//set the time the bot will stop roaming
;321:		bs->ctfroam_time = trap_AAS_Time() + CTF_ROAM_TIME;
ADDRLP4 60
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6128
ADDP4
ADDRLP4 60
INDIRF4
CNSTF4 1114636288
ADDF4
ASGNF4
line 322
;322:	}
LABELV $147
LABELV $143
line 326
;323:#ifdef DEBUG
;324:	BotPrintTeamGoal(bs);
;325:#endif //DEBUG
;326:}
LABELV $93
endproc BotCTFSeekGoals 68 12
export BotPointAreaNum
proc BotPointAreaNum 68 20
line 335
;327:
;328:#endif //CTF
;329:
;330:/*
;331:==================
;332:BotPointAreaNum
;333:==================
;334:*/
;335:int BotPointAreaNum(vec3_t origin) {
line 339
;336:	int areanum, numareas, areas[10];
;337:	vec3_t end;
;338:
;339:	areanum = trap_AAS_PointAreaNum(origin);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 60
ADDRGP4 trap_AAS_PointAreaNum
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 60
INDIRI4
ASGNI4
line 340
;340:	if (areanum) return areanum;
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $153
ADDRLP4 12
INDIRI4
RETI4
ADDRGP4 $152
JUMPV
LABELV $153
line 341
;341:	VectorCopy(origin, end);
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 342
;342:	end[2] += 10;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1092616192
ADDF4
ASGNF4
line 343
;343:	numareas = trap_AAS_TraceAreas(origin, end, areas, NULL, 10);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 20
ARGP4
CNSTP4 0
ARGP4
CNSTI4 10
ARGI4
ADDRLP4 64
ADDRGP4 trap_AAS_TraceAreas
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 64
INDIRI4
ASGNI4
line 344
;344:	if (numareas > 0) return areas[0];
ADDRLP4 16
INDIRI4
CNSTI4 0
LEI4 $156
ADDRLP4 20
INDIRI4
RETI4
ADDRGP4 $152
JUMPV
LABELV $156
line 345
;345:	return 0;
CNSTI4 0
RETI4
LABELV $152
endproc BotPointAreaNum 68 20
export ClientName
proc ClientName 1032 12
line 353
;346:}
;347:
;348:/*
;349:==================
;350:ClientName
;351:==================
;352:*/
;353:char *ClientName(int client, char *name, int size) {
line 356
;354:	char buf[MAX_INFO_STRING];
;355:
;356:	if (client < 0 || client >= MAX_CLIENTS) {
ADDRLP4 1024
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 1024
INDIRI4
CNSTI4 0
LTI4 $161
ADDRLP4 1024
INDIRI4
CNSTI4 128
LTI4 $159
LABELV $161
line 357
;357:		BotAI_Print(PRT_ERROR, "ClientName: client out of range\n");
CNSTI4 3
ARGI4
ADDRGP4 $162
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 358
;358:		return "[client out of range]";
ADDRGP4 $163
RETP4
ADDRGP4 $158
JUMPV
LABELV $159
line 360
;359:	}
;360:	trap_GetConfigstring(CS_PLAYERS+client, buf, sizeof(buf));
ADDRFP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 361
;361:	strncpy(name, Info_ValueForKey(buf, "n"), size-1);
ADDRLP4 0
ARGP4
ADDRGP4 $164
ARGP4
ADDRLP4 1028
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
CVIU4 4
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 362
;362:	name[size-1] = '\0';
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
ADDRFP4 4
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 363
;363:	Q_CleanStr( name );
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Q_CleanStr
CALLP4
pop
line 364
;364:	return name;
ADDRFP4 4
INDIRP4
RETP4
LABELV $158
endproc ClientName 1032 12
export ClientSkin
proc ClientSkin 1032 12
line 372
;365:}
;366:
;367:/*
;368:==================
;369:ClientSkin
;370:==================
;371:*/
;372:char *ClientSkin(int client, char *skin, int size) {
line 375
;373:	char buf[MAX_INFO_STRING];
;374:
;375:	if (client < 0 || client >= MAX_CLIENTS) {
ADDRLP4 1024
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 1024
INDIRI4
CNSTI4 0
LTI4 $168
ADDRLP4 1024
INDIRI4
CNSTI4 128
LTI4 $166
LABELV $168
line 376
;376:		BotAI_Print(PRT_ERROR, "ClientSkin: client out of range\n");
CNSTI4 3
ARGI4
ADDRGP4 $169
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 377
;377:		return "[client out of range]";
ADDRGP4 $163
RETP4
ADDRGP4 $165
JUMPV
LABELV $166
line 379
;378:	}
;379:	trap_GetConfigstring(CS_PLAYERS+client, buf, sizeof(buf));
ADDRFP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 380
;380:	strncpy(skin, Info_ValueForKey(buf, "model"), size-1);
ADDRLP4 0
ARGP4
ADDRGP4 $170
ARGP4
ADDRLP4 1028
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
CVIU4 4
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 381
;381:	skin[size-1] = '\0';
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
ADDRFP4 4
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 382
;382:	return skin;
ADDRFP4 4
INDIRP4
RETP4
LABELV $165
endproc ClientSkin 1032 12
bss
align 4
LABELV $172
skip 4
export ClientFromName
code
proc ClientFromName 1040 12
line 390
;383:}
;384:
;385:/*
;386:==================
;387:ClientFromName
;388:==================
;389:*/
;390:int ClientFromName(char *name) {
line 395
;391:	int i;
;392:	char buf[MAX_INFO_STRING];
;393:	static int maxclients;
;394:
;395:	if (!maxclients)
ADDRGP4 $172
INDIRI4
CNSTI4 0
NEI4 $173
line 396
;396:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $175
ARGP4
ADDRLP4 1028
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $172
ADDRLP4 1028
INDIRI4
ASGNI4
LABELV $173
line 397
;397:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $179
JUMPV
LABELV $176
line 398
;398:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 399
;399:		Q_CleanStr( buf );
ADDRLP4 4
ARGP4
ADDRGP4 Q_CleanStr
CALLP4
pop
line 400
;400:		if (!Q_stricmp(Info_ValueForKey(buf, "n"), name)) return i;
ADDRLP4 4
ARGP4
ADDRGP4 $164
ARGP4
ADDRLP4 1032
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1032
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1036
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1036
INDIRI4
CNSTI4 0
NEI4 $180
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $171
JUMPV
LABELV $180
line 401
;401:	}
LABELV $177
line 397
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $179
ADDRLP4 0
INDIRI4
ADDRGP4 $172
INDIRI4
GEI4 $182
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $176
LABELV $182
line 402
;402:	return -1;
CNSTI4 -1
RETI4
LABELV $171
endproc ClientFromName 1040 12
export stristr
proc stristr 12 4
line 410
;403:}
;404:
;405:/*
;406:==================
;407:stristr
;408:==================
;409:*/
;410:char *stristr(char *str, char *charset) {
ADDRGP4 $185
JUMPV
LABELV $184
line 413
;411:	int i;
;412:
;413:	while(*str) {
line 414
;414:		for (i = 0; charset[i] && str[i]; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $190
JUMPV
LABELV $187
line 415
;415:			if (toupper(charset[i]) != toupper(str[i])) break;
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 4
ADDRGP4 toupper
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 8
ADDRGP4 toupper
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRI4
EQI4 $191
ADDRGP4 $189
JUMPV
LABELV $191
line 416
;416:		}
LABELV $188
line 414
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $190
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI1
CVII4 1
ADDRLP4 8
INDIRI4
EQI4 $193
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ADDRLP4 8
INDIRI4
NEI4 $187
LABELV $193
LABELV $189
line 417
;417:		if (!charset[i]) return str;
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $194
ADDRFP4 0
INDIRP4
RETP4
ADDRGP4 $183
JUMPV
LABELV $194
line 418
;418:		str++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 419
;419:	}
LABELV $185
line 413
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $184
line 420
;420:	return NULL;
CNSTP4 0
RETP4
LABELV $183
endproc stristr 12 4
export EasyClientName
proc EasyClientName 200 12
line 428
;421:}
;422:
;423:/*
;424:==================
;425:EasyClientName
;426:==================
;427:*/
;428:char *EasyClientName(int client, char *buf, int size) {
line 433
;429:	int i;
;430:	char *str1, *str2, *ptr, c;
;431:	char name[128];
;432:
;433:	strcpy(name, ClientName(client, name, sizeof(name)));
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 5
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 148
ADDRGP4 ClientName
CALLP4
ASGNP4
ADDRLP4 5
ARGP4
ADDRLP4 148
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 434
;434:	for (i = 0; name[i]; i++) name[i] &= 127;
ADDRLP4 136
CNSTI4 0
ASGNI4
ADDRGP4 $200
JUMPV
LABELV $197
ADDRLP4 152
ADDRLP4 136
INDIRI4
ADDRLP4 5
ADDP4
ASGNP4
ADDRLP4 152
INDIRP4
ADDRLP4 152
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
BANDI4
CVII1 4
ASGNI1
LABELV $198
ADDRLP4 136
ADDRLP4 136
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $200
ADDRLP4 136
INDIRI4
ADDRLP4 5
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $197
line 436
;435:	//remove all spaces
;436:	for (ptr = strstr(name, " "); ptr; ptr = strstr(name, " ")) {
ADDRLP4 5
ARGP4
ADDRGP4 $205
ARGP4
ADDRLP4 156
ADDRGP4 strstr
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 156
INDIRP4
ASGNP4
ADDRGP4 $204
JUMPV
LABELV $201
line 437
;437:		memmove(ptr, ptr+1, strlen(ptr+1)+1);
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 160
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 160
INDIRU4
CNSTU4 1
ADDU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
line 438
;438:	}
LABELV $202
line 436
ADDRLP4 5
ARGP4
ADDRGP4 $205
ARGP4
ADDRLP4 160
ADDRGP4 strstr
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 160
INDIRP4
ASGNP4
LABELV $204
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $201
line 440
;439:	//check for [x] and ]x[ clan names
;440:	str1 = strstr(name, "[");
ADDRLP4 5
ARGP4
ADDRGP4 $206
ARGP4
ADDRLP4 164
ADDRGP4 strstr
CALLP4
ASGNP4
ADDRLP4 140
ADDRLP4 164
INDIRP4
ASGNP4
line 441
;441:	str2 = strstr(name, "]");
ADDRLP4 5
ARGP4
ADDRGP4 $207
ARGP4
ADDRLP4 168
ADDRGP4 strstr
CALLP4
ASGNP4
ADDRLP4 144
ADDRLP4 168
INDIRP4
ASGNP4
line 442
;442:	if (str1 && str2) {
ADDRLP4 172
CNSTU4 0
ASGNU4
ADDRLP4 140
INDIRP4
CVPU4 4
ADDRLP4 172
INDIRU4
EQU4 $208
ADDRLP4 144
INDIRP4
CVPU4 4
ADDRLP4 172
INDIRU4
EQU4 $208
line 443
;443:		if (str2 > str1) memmove(str1, str2+1, strlen(str2+1)+1);
ADDRLP4 144
INDIRP4
CVPU4 4
ADDRLP4 140
INDIRP4
CVPU4 4
LEU4 $210
ADDRLP4 144
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 176
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 140
INDIRP4
ARGP4
ADDRLP4 144
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 176
INDIRU4
CNSTU4 1
ADDU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
ADDRGP4 $211
JUMPV
LABELV $210
line 444
;444:		else memmove(str2, str1+1, strlen(str1+1)+1);
ADDRLP4 140
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 180
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 144
INDIRP4
ARGP4
ADDRLP4 140
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 180
INDIRU4
CNSTU4 1
ADDU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
LABELV $211
line 445
;445:	}
LABELV $208
line 447
;446:	//remove Mr prefix
;447:	if ((name[0] == 'm' || name[0] == 'M') &&
ADDRLP4 176
ADDRLP4 5
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 176
INDIRI4
CNSTI4 109
EQI4 $216
ADDRLP4 176
INDIRI4
CNSTI4 77
NEI4 $212
LABELV $216
ADDRLP4 5+1
INDIRI1
CVII4 1
CNSTI4 114
EQI4 $217
ADDRLP4 5+1
INDIRI1
CVII4 1
CNSTI4 82
NEI4 $212
LABELV $217
line 448
;448:			(name[1] == 'r' || name[1] == 'R')) {
line 449
;449:		memmove(name, name+2, strlen(name+2)+1);
ADDRLP4 5+2
ARGP4
ADDRLP4 180
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 5
ARGP4
ADDRLP4 5+2
ARGP4
ADDRLP4 180
INDIRU4
CNSTU4 1
ADDU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
line 450
;450:	}
LABELV $212
line 452
;451:	//only allow lower case alphabet characters
;452:	ptr = name;
ADDRLP4 0
ADDRLP4 5
ASGNP4
ADDRGP4 $221
JUMPV
LABELV $220
line 453
;453:	while(*ptr) {
line 454
;454:		c = *ptr;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRI1
ASGNI1
line 455
;455:		if ((c >= 'a' && c <= 'z') ||
ADDRLP4 180
ADDRLP4 4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 180
INDIRI4
CNSTI4 97
LTI4 $226
ADDRLP4 180
INDIRI4
CNSTI4 122
LEI4 $227
LABELV $226
ADDRLP4 184
ADDRLP4 4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 184
INDIRI4
CNSTI4 48
LTI4 $228
ADDRLP4 184
INDIRI4
CNSTI4 57
LEI4 $227
LABELV $228
ADDRLP4 4
INDIRI1
CVII4 1
CNSTI4 95
NEI4 $223
LABELV $227
line 456
;456:				(c >= '0' && c <= '9') || c == '_') {
line 457
;457:			ptr++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 458
;458:		}
ADDRGP4 $224
JUMPV
LABELV $223
line 459
;459:		else if (c >= 'A' && c <= 'Z') {
ADDRLP4 188
ADDRLP4 4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 188
INDIRI4
CNSTI4 65
LTI4 $229
ADDRLP4 188
INDIRI4
CNSTI4 90
GTI4 $229
line 460
;460:			*ptr += 'a' - 'A';
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 32
ADDI4
CVII1 4
ASGNI1
line 461
;461:			ptr++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 462
;462:		}
ADDRGP4 $230
JUMPV
LABELV $229
line 463
;463:		else {
line 464
;464:			memmove(ptr, ptr+1, strlen(ptr + 1)+1);
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 192
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ARGP4
ADDRLP4 192
INDIRU4
CNSTU4 1
ADDU4
ARGU4
ADDRGP4 memmove
CALLP4
pop
line 465
;465:		}
LABELV $230
LABELV $224
line 466
;466:	}
LABELV $221
line 453
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $220
line 467
;467:	strncpy(buf, name, size-1);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 5
ARGP4
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
CVIU4 4
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 468
;468:	buf[size-1] = '\0';
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
ADDRFP4 4
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 469
;469:	return buf;
ADDRFP4 4
INDIRP4
RETP4
LABELV $196
endproc EasyClientName 200 12
export BotChooseWeapon
proc BotChooseWeapon 24 8
line 477
;470:}
;471:
;472:/*
;473:==================
;474:BotChooseWeapon
;475:==================
;476:*/
;477:void BotChooseWeapon(bot_state_t *bs) {
line 480
;478:	int newweaponnum;
;479:
;480:	if (bs->cur_ps.weaponstate == WEAPON_RAISING ||
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 164
ADDP4
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 1
EQI4 $234
ADDRLP4 4
INDIRI4
CNSTI4 2
NEI4 $232
LABELV $234
line 481
;481:			bs->cur_ps.weaponstate == WEAPON_DROPPING) {
line 482
;482:		trap_EA_SelectWeapon(bs->client, bs->weaponnum);
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_SelectWeapon
CALLV
pop
line 483
;483:	}
ADDRGP4 $233
JUMPV
LABELV $232
line 484
;484:	else {
line 485
;485:		newweaponnum = trap_BotChooseBestFightWeapon(bs->ws, bs->inventory);
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 4928
ADDP4
ARGP4
ADDRLP4 12
ADDRGP4 trap_BotChooseBestFightWeapon
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ASGNI4
line 486
;486:		if (bs->weaponnum != newweaponnum) bs->weaponchange_time = trap_AAS_Time();
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
EQI4 $235
ADDRLP4 16
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6156
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
LABELV $235
line 487
;487:		bs->weaponnum = newweaponnum;
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 489
;488:		//BotAI_Print(PRT_MESSAGE, "bs->weaponnum = %d\n", bs->weaponnum);
;489:		trap_EA_SelectWeapon(bs->client, bs->weaponnum);
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 20
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_SelectWeapon
CALLV
pop
line 490
;490:	}
LABELV $233
line 491
;491:}
LABELV $231
endproc BotChooseWeapon 24 8
export BotSetupForMovement
proc BotSetupForMovement 84 12
line 498
;492:
;493:/*
;494:==================
;495:BotSetupForMovement
;496:==================
;497:*/
;498:void BotSetupForMovement(bot_state_t *bs) {
line 501
;499:	bot_initmove_t initmove;
;500:
;501:	memset(&initmove, 0, sizeof(bot_initmove_t));
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 68
ARGU4
ADDRGP4 memset
CALLP4
pop
line 502
;502:	VectorCopy(bs->cur_ps.origin, initmove.origin);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 503
;503:	VectorCopy(bs->cur_ps.velocity, initmove.velocity);
ADDRLP4 0+12
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRB
ASGNB 12
line 504
;504:	VectorCopy(bs->cur_ps.origin, initmove.viewoffset);
ADDRLP4 0+24
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 505
;505:	initmove.viewoffset[2] += bs->cur_ps.viewheight;
ADDRLP4 0+24+8
ADDRLP4 0+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 506
;506:	initmove.entitynum = bs->entitynum;
ADDRLP4 0+36
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ASGNI4
line 507
;507:	initmove.client = bs->client;
ADDRLP4 0+40
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 508
;508:	initmove.thinktime = bs->thinktime;
ADDRLP4 0+44
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
ASGNF4
line 510
;509:	//set the onground flag
;510:	if (bs->cur_ps.groundEntityNum != ENTITYNUM_NONE) initmove.or_moveflags |= MFL_ONGROUND;
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
CNSTI4 1023
EQI4 $245
ADDRLP4 0+64
ADDRLP4 0+64
INDIRI4
CNSTI4 2
BORI4
ASGNI4
LABELV $245
line 512
;511:	//set the teleported flag
;512:	if ((bs->cur_ps.pm_flags & PMF_TIME_KNOCKBACK) && (bs->cur_ps.pm_time > 0)) {
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 72
CNSTI4 0
ASGNI4
ADDRLP4 68
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
CNSTI4 64
BANDI4
ADDRLP4 72
INDIRI4
EQI4 $248
ADDRLP4 68
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ADDRLP4 72
INDIRI4
LEI4 $248
line 513
;513:		initmove.or_moveflags |= MFL_TELEPORTED;
ADDRLP4 0+64
ADDRLP4 0+64
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 514
;514:	}
LABELV $248
line 516
;515:	//set the waterjump flag
;516:	if ((bs->cur_ps.pm_flags & PMF_TIME_WATERJUMP) && (bs->cur_ps.pm_time > 0)) {
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
CNSTI4 0
ASGNI4
ADDRLP4 76
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
CNSTI4 256
BANDI4
ADDRLP4 80
INDIRI4
EQI4 $251
ADDRLP4 76
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
ADDRLP4 80
INDIRI4
LEI4 $251
line 517
;517:		initmove.or_moveflags |= MFL_WATERJUMP;
ADDRLP4 0+64
ADDRLP4 0+64
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 518
;518:	}
LABELV $251
line 520
;519:	//set presence type
;520:	if (bs->cur_ps.pm_flags & PMF_DUCKED) initmove.presencetype = PRESENCE_CROUCH;
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $254
ADDRLP4 0+48
CNSTI4 4
ASGNI4
ADDRGP4 $255
JUMPV
LABELV $254
line 521
;521:	else initmove.presencetype = PRESENCE_NORMAL;
ADDRLP4 0+48
CNSTI4 2
ASGNI4
LABELV $255
line 523
;522:	//
;523:	if (bs->walker > 0.5) initmove.or_moveflags |= MFL_WALK;
ADDRFP4 0
INDIRP4
CNSTI4 6028
ADDP4
INDIRF4
CNSTF4 1056964608
LEF4 $258
ADDRLP4 0+64
ADDRLP4 0+64
INDIRI4
CNSTI4 512
BORI4
ASGNI4
LABELV $258
line 525
;524:	//
;525:	VectorCopy(bs->viewangles, initmove.viewangles);
ADDRLP4 0+52
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
INDIRB
ASGNB 12
line 527
;526:	//
;527:	trap_BotInitMoveState(bs->ms, &initmove);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotInitMoveState
CALLV
pop
line 528
;528:}
LABELV $237
endproc BotSetupForMovement 84 12
export BotUpdateInventory
proc BotUpdateInventory 200 0
line 535
;529:
;530:/*
;531:==================
;532:BotUpdateInventory
;533:==================
;534:*/
;535:void BotUpdateInventory(bot_state_t *bs) {
line 537
;536:	//armor
;537:	bs->inventory[INVENTORY_ARMOR] = bs->cur_ps.stats[STAT_ARMOR];
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 4932
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
ASGNI4
line 539
;538:	//weapons
;539:	bs->inventory[INVENTORY_GAUNTLET] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_GAUNTLET)) != 0;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $264
ADDRLP4 4
CNSTI4 1
ASGNI4
ADDRGP4 $265
JUMPV
LABELV $264
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $265
ADDRLP4 8
INDIRP4
CNSTI4 4944
ADDP4
ADDRLP4 4
INDIRI4
ASGNI4
line 540
;540:	bs->inventory[INVENTORY_SHOTGUN] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_SHOTGUN)) != 0;
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $267
ADDRLP4 12
CNSTI4 1
ASGNI4
ADDRGP4 $268
JUMPV
LABELV $267
ADDRLP4 12
CNSTI4 0
ASGNI4
LABELV $268
ADDRLP4 16
INDIRP4
CNSTI4 4948
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 541
;541:	bs->inventory[INVENTORY_MACHINEGUN] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_MACHINEGUN)) != 0;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $270
ADDRLP4 20
CNSTI4 1
ASGNI4
ADDRGP4 $271
JUMPV
LABELV $270
ADDRLP4 20
CNSTI4 0
ASGNI4
LABELV $271
ADDRLP4 24
INDIRP4
CNSTI4 4952
ADDP4
ADDRLP4 20
INDIRI4
ASGNI4
line 542
;542:	bs->inventory[INVENTORY_GRENADELAUNCHER] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_GRENADE_LAUNCHER)) != 0;
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $273
ADDRLP4 28
CNSTI4 1
ASGNI4
ADDRGP4 $274
JUMPV
LABELV $273
ADDRLP4 28
CNSTI4 0
ASGNI4
LABELV $274
ADDRLP4 32
INDIRP4
CNSTI4 4956
ADDP4
ADDRLP4 28
INDIRI4
ASGNI4
line 543
;543:	bs->inventory[INVENTORY_ROCKETLAUNCHER] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_ROCKET_LAUNCHER)) != 0;
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $276
ADDRLP4 36
CNSTI4 1
ASGNI4
ADDRGP4 $277
JUMPV
LABELV $276
ADDRLP4 36
CNSTI4 0
ASGNI4
LABELV $277
ADDRLP4 40
INDIRP4
CNSTI4 4960
ADDP4
ADDRLP4 36
INDIRI4
ASGNI4
line 544
;544:	bs->inventory[INVENTORY_LIGHTNING] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_LIGHTNING)) != 0;
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
EQI4 $279
ADDRLP4 44
CNSTI4 1
ASGNI4
ADDRGP4 $280
JUMPV
LABELV $279
ADDRLP4 44
CNSTI4 0
ASGNI4
LABELV $280
ADDRLP4 48
INDIRP4
CNSTI4 4964
ADDP4
ADDRLP4 44
INDIRI4
ASGNI4
line 545
;545:	bs->inventory[INVENTORY_RAILGUN] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_RAILGUN)) != 0;
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $282
ADDRLP4 52
CNSTI4 1
ASGNI4
ADDRGP4 $283
JUMPV
LABELV $282
ADDRLP4 52
CNSTI4 0
ASGNI4
LABELV $283
ADDRLP4 56
INDIRP4
CNSTI4 4968
ADDP4
ADDRLP4 52
INDIRI4
ASGNI4
line 546
;546:	bs->inventory[INVENTORY_PLASMAGUN] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_PLASMAGUN)) != 0;
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $285
ADDRLP4 60
CNSTI4 1
ASGNI4
ADDRGP4 $286
JUMPV
LABELV $285
ADDRLP4 60
CNSTI4 0
ASGNI4
LABELV $286
ADDRLP4 64
INDIRP4
CNSTI4 4972
ADDP4
ADDRLP4 60
INDIRI4
ASGNI4
line 547
;547:	bs->inventory[INVENTORY_BFG10K] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_BFG)) != 0;
ADDRLP4 72
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $288
ADDRLP4 68
CNSTI4 1
ASGNI4
ADDRGP4 $289
JUMPV
LABELV $288
ADDRLP4 68
CNSTI4 0
ASGNI4
LABELV $289
ADDRLP4 72
INDIRP4
CNSTI4 4980
ADDP4
ADDRLP4 68
INDIRI4
ASGNI4
line 548
;548:	bs->inventory[INVENTORY_GRAPPLINGHOOK] = (bs->cur_ps.stats[STAT_WEAPONS] & (1 << WP_GRAPPLING_HOOK)) != 0;
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
CNSTI4 1
CNSTI4 -1
LSHI4
BANDI4
CNSTI4 0
EQI4 $291
ADDRLP4 76
CNSTI4 1
ASGNI4
ADDRGP4 $292
JUMPV
LABELV $291
ADDRLP4 76
CNSTI4 0
ASGNI4
LABELV $292
ADDRLP4 80
INDIRP4
CNSTI4 4984
ADDP4
ADDRLP4 76
INDIRI4
ASGNI4
line 550
;549:	//ammo
;550:	bs->inventory[INVENTORY_SHELLS] = bs->cur_ps.ammo[WP_SHOTGUN];
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTI4 4988
ADDP4
ADDRLP4 84
INDIRP4
CNSTI4 404
ADDP4
INDIRI4
ASGNI4
line 551
;551:	bs->inventory[INVENTORY_BULLETS] = bs->cur_ps.ammo[WP_MACHINEGUN];
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTI4 4992
ADDP4
ADDRLP4 88
INDIRP4
CNSTI4 400
ADDP4
INDIRI4
ASGNI4
line 552
;552:	bs->inventory[INVENTORY_GRENADES] = bs->cur_ps.ammo[WP_GRENADE_LAUNCHER];
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTI4 4996
ADDP4
ADDRLP4 92
INDIRP4
CNSTI4 408
ADDP4
INDIRI4
ASGNI4
line 553
;553:	bs->inventory[INVENTORY_CELLS] = bs->cur_ps.ammo[WP_PLASMAGUN];
ADDRLP4 96
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
CNSTI4 5000
ADDP4
ADDRLP4 96
INDIRP4
CNSTI4 424
ADDP4
INDIRI4
ASGNI4
line 554
;554:	bs->inventory[INVENTORY_LIGHTNINGAMMO] = bs->cur_ps.ammo[WP_LIGHTNING];
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 100
INDIRP4
CNSTI4 5008
ADDP4
ADDRLP4 100
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
ASGNI4
line 555
;555:	bs->inventory[INVENTORY_ROCKETS] = bs->cur_ps.ammo[WP_ROCKET_LAUNCHER];
ADDRLP4 104
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 104
INDIRP4
CNSTI4 5012
ADDP4
ADDRLP4 104
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
ASGNI4
line 556
;556:	bs->inventory[INVENTORY_SLUGS] = bs->cur_ps.ammo[WP_RAILGUN];
ADDRLP4 108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
INDIRP4
CNSTI4 5016
ADDP4
ADDRLP4 108
INDIRP4
CNSTI4 420
ADDP4
INDIRI4
ASGNI4
line 557
;557:	bs->inventory[INVENTORY_BFGAMMO] = bs->cur_ps.ammo[WP_BFG];
ADDRLP4 112
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 112
INDIRP4
CNSTI4 5020
ADDP4
ADDRLP4 112
INDIRP4
CNSTI4 428
ADDP4
INDIRI4
ASGNI4
line 559
;558:	//powerups
;559:	bs->inventory[INVENTORY_HEALTH] = bs->cur_ps.stats[STAT_HEALTH];
ADDRLP4 116
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 116
INDIRP4
CNSTI4 5024
ADDP4
ADDRLP4 116
INDIRP4
CNSTI4 200
ADDP4
INDIRI4
ASGNI4
line 560
;560:	bs->inventory[INVENTORY_TELEPORTER] = bs->cur_ps.stats[STAT_HOLDABLE_ITEM] == MODELINDEX_TELEPORTER;
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 26
NEI4 $294
ADDRLP4 120
CNSTI4 1
ASGNI4
ADDRGP4 $295
JUMPV
LABELV $294
ADDRLP4 120
CNSTI4 0
ASGNI4
LABELV $295
ADDRLP4 124
INDIRP4
CNSTI4 5028
ADDP4
ADDRLP4 120
INDIRI4
ASGNI4
line 561
;561:	bs->inventory[INVENTORY_MEDKIT] = bs->cur_ps.stats[STAT_HOLDABLE_ITEM] == MODELINDEX_MEDKIT;
ADDRLP4 132
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 132
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 27
NEI4 $297
ADDRLP4 128
CNSTI4 1
ASGNI4
ADDRGP4 $298
JUMPV
LABELV $297
ADDRLP4 128
CNSTI4 0
ASGNI4
LABELV $298
ADDRLP4 132
INDIRP4
CNSTI4 5032
ADDP4
ADDRLP4 128
INDIRI4
ASGNI4
line 562
;562:	bs->inventory[INVENTORY_QUAD] = bs->cur_ps.powerups[PW_QUAD] != 0;
ADDRLP4 140
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 140
INDIRP4
CNSTI4 332
ADDP4
INDIRI4
CNSTI4 0
EQI4 $300
ADDRLP4 136
CNSTI4 1
ASGNI4
ADDRGP4 $301
JUMPV
LABELV $300
ADDRLP4 136
CNSTI4 0
ASGNI4
LABELV $301
ADDRLP4 140
INDIRP4
CNSTI4 5036
ADDP4
ADDRLP4 136
INDIRI4
ASGNI4
line 563
;563:	bs->inventory[INVENTORY_ENVIRONMENTSUIT] = bs->cur_ps.powerups[PW_BATTLESUIT] != 0;
ADDRLP4 148
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 148
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
CNSTI4 0
EQI4 $303
ADDRLP4 144
CNSTI4 1
ASGNI4
ADDRGP4 $304
JUMPV
LABELV $303
ADDRLP4 144
CNSTI4 0
ASGNI4
LABELV $304
ADDRLP4 148
INDIRP4
CNSTI4 5040
ADDP4
ADDRLP4 144
INDIRI4
ASGNI4
line 564
;564:	bs->inventory[INVENTORY_HASTE] = bs->cur_ps.powerups[PW_HASTE] != 0;
ADDRLP4 156
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 156
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 0
EQI4 $306
ADDRLP4 152
CNSTI4 1
ASGNI4
ADDRGP4 $307
JUMPV
LABELV $306
ADDRLP4 152
CNSTI4 0
ASGNI4
LABELV $307
ADDRLP4 156
INDIRP4
CNSTI4 5044
ADDP4
ADDRLP4 152
INDIRI4
ASGNI4
line 565
;565:	bs->inventory[INVENTORY_INVISIBILITY] = bs->cur_ps.powerups[PW_INVIS] != 0;
ADDRLP4 164
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 164
INDIRP4
CNSTI4 344
ADDP4
INDIRI4
CNSTI4 0
EQI4 $309
ADDRLP4 160
CNSTI4 1
ASGNI4
ADDRGP4 $310
JUMPV
LABELV $309
ADDRLP4 160
CNSTI4 0
ASGNI4
LABELV $310
ADDRLP4 164
INDIRP4
CNSTI4 5048
ADDP4
ADDRLP4 160
INDIRI4
ASGNI4
line 566
;566:	bs->inventory[INVENTORY_REGEN] = bs->cur_ps.powerups[PW_REGEN] != 0;
ADDRLP4 172
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 172
INDIRP4
CNSTI4 348
ADDP4
INDIRI4
CNSTI4 0
EQI4 $312
ADDRLP4 168
CNSTI4 1
ASGNI4
ADDRGP4 $313
JUMPV
LABELV $312
ADDRLP4 168
CNSTI4 0
ASGNI4
LABELV $313
ADDRLP4 172
INDIRP4
CNSTI4 5052
ADDP4
ADDRLP4 168
INDIRI4
ASGNI4
line 567
;567:	bs->inventory[INVENTORY_FLIGHT] = bs->cur_ps.powerups[PW_FLIGHT] != 0;
ADDRLP4 180
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 180
INDIRP4
CNSTI4 352
ADDP4
INDIRI4
CNSTI4 0
EQI4 $315
ADDRLP4 176
CNSTI4 1
ASGNI4
ADDRGP4 $316
JUMPV
LABELV $315
ADDRLP4 176
CNSTI4 0
ASGNI4
LABELV $316
ADDRLP4 180
INDIRP4
CNSTI4 5056
ADDP4
ADDRLP4 176
INDIRI4
ASGNI4
line 568
;568:	bs->inventory[INVENTORY_REDFLAG] = bs->cur_ps.powerups[PW_REDFLAG] != 0;
ADDRLP4 188
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 188
INDIRP4
CNSTI4 356
ADDP4
INDIRI4
CNSTI4 0
EQI4 $318
ADDRLP4 184
CNSTI4 1
ASGNI4
ADDRGP4 $319
JUMPV
LABELV $318
ADDRLP4 184
CNSTI4 0
ASGNI4
LABELV $319
ADDRLP4 188
INDIRP4
CNSTI4 5060
ADDP4
ADDRLP4 184
INDIRI4
ASGNI4
line 569
;569:	bs->inventory[INVENTORY_BLUEFLAG] = bs->cur_ps.powerups[PW_BLUEFLAG] != 0;
ADDRLP4 196
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 196
INDIRP4
CNSTI4 360
ADDP4
INDIRI4
CNSTI4 0
EQI4 $321
ADDRLP4 192
CNSTI4 1
ASGNI4
ADDRGP4 $322
JUMPV
LABELV $321
ADDRLP4 192
CNSTI4 0
ASGNI4
LABELV $322
ADDRLP4 196
INDIRP4
CNSTI4 5064
ADDP4
ADDRLP4 192
INDIRI4
ASGNI4
line 571
;570:	//
;571:}
LABELV $262
endproc BotUpdateInventory 200 0
export BotUpdateBattleInventory
proc BotUpdateBattleInventory 160 8
line 578
;572:
;573:/*
;574:==================
;575:BotUpdateBattleInventory
;576:==================
;577:*/
;578:void BotUpdateBattleInventory(bot_state_t *bs, int enemy) {
line 582
;579:	vec3_t dir;
;580:	aas_entityinfo_t entinfo;
;581:
;582:	BotEntityInfo(enemy, &entinfo);
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 583
;583:	VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 152
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 12+24
INDIRF4
ADDRLP4 152
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 12+24+4
INDIRF4
ADDRLP4 152
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 12+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 584
;584:	bs->inventory[ENEMY_HEIGHT] = (int) dir[2];
ADDRFP4 0
INDIRP4
CNSTI4 5732
ADDP4
ADDRLP4 0+8
INDIRF4
CVFI4 4
ASGNI4
line 585
;585:	dir[2] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 586
;586:	bs->inventory[ENEMY_HORIZONTAL_DIST] = (int) VectorLength(dir);
ADDRLP4 0
ARGP4
ADDRLP4 156
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 5728
ADDP4
ADDRLP4 156
INDIRF4
CVFI4 4
ASGNI4
line 588
;587:	//FIXME: add num visible enemies and num visible team mates to the inventory
;588:}
LABELV $323
endproc BotUpdateBattleInventory 160 8
export BotBattleUseItems
proc BotBattleUseItems 4 4
line 595
;589:
;590:/*
;591:==================
;592:BotBattleUseItems
;593:==================
;594:*/
;595:void BotBattleUseItems(bot_state_t *bs) {
line 596
;596:	if (bs->inventory[INVENTORY_HEALTH] < 40) {
ADDRFP4 0
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
CNSTI4 40
GEI4 $334
line 597
;597:		if (bs->inventory[INVENTORY_TELEPORTER] > 0) {
ADDRFP4 0
INDIRP4
CNSTI4 5028
ADDP4
INDIRI4
CNSTI4 0
LEI4 $336
line 598
;598:			if (!BotCTFCarryingFlag(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $338
line 599
;599:				trap_EA_Use(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Use
CALLV
pop
line 600
;600:			}
LABELV $338
line 601
;601:		}
LABELV $336
line 602
;602:		if (bs->inventory[INVENTORY_MEDKIT] > 0) {
ADDRFP4 0
INDIRP4
CNSTI4 5032
ADDP4
INDIRI4
CNSTI4 0
LEI4 $340
line 603
;603:			trap_EA_Use(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Use
CALLV
pop
line 604
;604:		}
LABELV $340
line 605
;605:	}
LABELV $334
line 606
;606:}
LABELV $333
endproc BotBattleUseItems 4 4
export BotSetTeleportTime
proc BotSetTeleportTime 8 0
line 613
;607:
;608:/*
;609:==================
;610:BotSetTeleportTime
;611:==================
;612:*/
;613:void BotSetTeleportTime(bot_state_t *bs) {
line 614
;614:	if ((bs->cur_ps.eFlags ^ bs->last_eFlags) & EF_TELEPORT_BIT) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 460
ADDP4
INDIRI4
BXORI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $343
line 615
;615:		bs->teleport_time = trap_AAS_Time();
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6144
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 616
;616:	}
LABELV $343
line 617
;617:	bs->last_eFlags = bs->cur_ps.eFlags;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 460
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
ASGNI4
line 618
;618:}
LABELV $342
endproc BotSetTeleportTime 8 0
export BotIsDead
proc BotIsDead 4 0
line 625
;619:
;620:/*
;621:==================
;622:BotIsDead
;623:==================
;624:*/
;625:qboolean BotIsDead(bot_state_t *bs) {
line 626
;626:	return (bs->cur_ps.pm_type == PM_DEAD);
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CNSTI4 3
NEI4 $347
ADDRLP4 0
CNSTI4 1
ASGNI4
ADDRGP4 $348
JUMPV
LABELV $347
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $348
ADDRLP4 0
INDIRI4
RETI4
LABELV $345
endproc BotIsDead 4 0
export BotIsObserver
proc BotIsObserver 1032 12
line 634
;627:}
;628:
;629:/*
;630:==================
;631:BotIsObserver
;632:==================
;633:*/
;634:qboolean BotIsObserver(bot_state_t *bs) {
line 636
;635:	char buf[MAX_INFO_STRING];
;636:	if (bs->cur_ps.pm_type == PM_SPECTATOR) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CNSTI4 2
NEI4 $350
CNSTI4 1
RETI4
ADDRGP4 $349
JUMPV
LABELV $350
line 637
;637:	trap_GetConfigstring(CS_PLAYERS+bs->client, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 638
;638:	if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) return qtrue;
ADDRLP4 0
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1024
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1024
INDIRP4
ARGP4
ADDRLP4 1028
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1028
INDIRI4
CNSTI4 3
NEI4 $352
CNSTI4 1
RETI4
ADDRGP4 $349
JUMPV
LABELV $352
line 639
;639:	return qfalse;
CNSTI4 0
RETI4
LABELV $349
endproc BotIsObserver 1032 12
export BotIntermission
proc BotIntermission 8 0
line 647
;640:}
;641:
;642:/*
;643:==================
;644:BotIntermission
;645:==================
;646:*/
;647:qboolean BotIntermission(bot_state_t *bs) {
line 649
;648:	//NOTE: we shouldn't be looking at the game code...
;649:	if (level.intermissiontime) return qtrue;
ADDRGP4 level+4228
INDIRI4
CNSTI4 0
EQI4 $355
CNSTI4 1
RETI4
ADDRGP4 $354
JUMPV
LABELV $355
line 650
;650:	return (bs->cur_ps.pm_type == PM_FREEZE || bs->cur_ps.pm_type == PM_INTERMISSION);
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 4
EQI4 $361
ADDRLP4 4
INDIRI4
CNSTI4 5
NEI4 $359
LABELV $361
ADDRLP4 0
CNSTI4 1
ASGNI4
ADDRGP4 $360
JUMPV
LABELV $359
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $360
ADDRLP4 0
INDIRI4
RETI4
LABELV $354
endproc BotIntermission 8 0
export BotInLavaOrSlime
proc BotInLavaOrSlime 16 4
line 658
;651:}
;652:
;653:/*
;654:==================
;655:BotInLavaOrSlime
;656:==================
;657:*/
;658:qboolean BotInLavaOrSlime(bot_state_t *bs) {
line 661
;659:	vec3_t feet;
;660:
;661:	VectorCopy(bs->origin, feet);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 662
;662:	feet[2] -= 23;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1102577664
SUBF4
ASGNF4
line 663
;663:	return (trap_AAS_PointContents(feet) & (CONTENTS_LAVA|CONTENTS_SLIME));
ADDRLP4 0
ARGP4
ADDRLP4 12
ADDRGP4 trap_AAS_PointContents
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 24
BANDI4
RETI4
LABELV $362
endproc BotInLavaOrSlime 16 4
lit
align 4
LABELV $365
byte 4 3238002688
byte 4 3238002688
byte 4 3238002688
align 4
LABELV $366
byte 4 1090519040
byte 4 1090519040
byte 4 1090519040
export BotCreateWayPoint
code
proc BotCreateWayPoint 32 12
line 671
;664:}
;665:
;666:/*
;667:==================
;668:BotCreateWayPoint
;669:==================
;670:*/
;671:bot_waypoint_t *BotCreateWayPoint(char *name, vec3_t origin, int areanum) {
line 673
;672:	bot_waypoint_t *wp;
;673:	vec3_t waypointmins = {-8, -8, -8}, waypointmaxs = {8, 8, 8};
ADDRLP4 4
ADDRGP4 $365
INDIRB
ASGNB 12
ADDRLP4 16
ADDRGP4 $366
INDIRB
ASGNB 12
line 675
;674:
;675:	wp = botai_freewaypoints;
ADDRLP4 0
ADDRGP4 botai_freewaypoints
INDIRP4
ASGNP4
line 676
;676:	if ( !wp ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $367
line 677
;677:		BotAI_Print( PRT_WARNING, "BotCreateWayPoint: Out of waypoints\n" );
CNSTI4 2
ARGI4
ADDRGP4 $369
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 678
;678:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $364
JUMPV
LABELV $367
line 680
;679:	}
;680:	botai_freewaypoints = botai_freewaypoints->next;
ADDRLP4 28
ADDRGP4 botai_freewaypoints
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
line 682
;681:
;682:	Q_strncpyz( wp->name, name, sizeof(wp->name) );
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 683
;683:	VectorCopy(origin, wp->goal.origin);
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 684
;684:	VectorCopy(waypointmins, wp->goal.mins);
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 685
;685:	VectorCopy(waypointmaxs, wp->goal.maxs);
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
ADDRLP4 16
INDIRB
ASGNB 12
line 686
;686:	wp->goal.areanum = areanum;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 687
;687:	wp->next = NULL;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
CNSTP4 0
ASGNP4
line 688
;688:	wp->prev = NULL;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
CNSTP4 0
ASGNP4
line 689
;689:	return wp;
ADDRLP4 0
INDIRP4
RETP4
LABELV $364
endproc BotCreateWayPoint 32 12
export BotFindWayPoint
proc BotFindWayPoint 8 8
line 697
;690:}
;691:
;692:/*
;693:==================
;694:BotFindWayPoint
;695:==================
;696:*/
;697:bot_waypoint_t *BotFindWayPoint(bot_waypoint_t *waypoints, char *name) {
line 700
;698:	bot_waypoint_t *wp;
;699:
;700:	for (wp = waypoints; wp; wp = wp->next) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 $374
JUMPV
LABELV $371
line 701
;701:		if (!Q_stricmp(wp->name, name)) return wp;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $375
ADDRLP4 0
INDIRP4
RETP4
ADDRGP4 $370
JUMPV
LABELV $375
line 702
;702:	}
LABELV $372
line 700
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
LABELV $374
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $371
line 703
;703:	return NULL;
CNSTP4 0
RETP4
LABELV $370
endproc BotFindWayPoint 8 8
export BotFreeWaypoints
proc BotFreeWaypoints 4 0
line 711
;704:}
;705:
;706:/*
;707:==================
;708:BotFreeWaypoints
;709:==================
;710:*/
;711:void BotFreeWaypoints(bot_waypoint_t *wp) {
line 714
;712:	bot_waypoint_t *nextwp;
;713:
;714:	for (; wp; wp = nextwp) {
ADDRGP4 $381
JUMPV
LABELV $378
line 715
;715:		nextwp = wp->next;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
line 716
;716:		wp->next = botai_freewaypoints;
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRGP4 botai_freewaypoints
INDIRP4
ASGNP4
line 717
;717:		botai_freewaypoints = wp;
ADDRGP4 botai_freewaypoints
ADDRFP4 0
INDIRP4
ASGNP4
line 718
;718:	}
LABELV $379
line 714
ADDRFP4 0
ADDRLP4 0
INDIRP4
ASGNP4
LABELV $381
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $378
line 719
;719:}
LABELV $377
endproc BotFreeWaypoints 4 0
export BotInitWaypoints
proc BotInitWaypoints 4 0
line 726
;720:
;721:/*
;722:==================
;723:BotInitWaypoints
;724:==================
;725:*/
;726:void BotInitWaypoints(void) {
line 729
;727:	int i;
;728:
;729:	botai_freewaypoints = NULL;
ADDRGP4 botai_freewaypoints
CNSTP4 0
ASGNP4
line 730
;730:	for (i = 0; i < MAX_WAYPOINTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $383
line 731
;731:		botai_waypoints[i].next = botai_freewaypoints;
CNSTI4 100
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 botai_waypoints+92
ADDP4
ADDRGP4 botai_freewaypoints
INDIRP4
ASGNP4
line 732
;732:		botai_freewaypoints = &botai_waypoints[i];
ADDRGP4 botai_freewaypoints
CNSTI4 100
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 botai_waypoints
ADDP4
ASGNP4
line 733
;733:	}
LABELV $384
line 730
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $383
line 734
;734:}
LABELV $382
endproc BotInitWaypoints 4 0
export TeamPlayIsOn
proc TeamPlayIsOn 8 0
line 741
;735:
;736:/*
;737:==================
;738:TeamPlayIsOn
;739:==================
;740:*/
;741:int TeamPlayIsOn(void) {
line 742
;742:	return ( gametype == GT_TEAM || gametype == GT_CTF );
ADDRLP4 4
ADDRGP4 gametype
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 3
EQI4 $392
ADDRLP4 4
INDIRI4
CNSTI4 4
NEI4 $390
LABELV $392
ADDRLP4 0
CNSTI4 1
ASGNI4
ADDRGP4 $391
JUMPV
LABELV $390
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $391
ADDRLP4 0
INDIRI4
RETI4
LABELV $388
endproc TeamPlayIsOn 8 0
export BotAggression
proc BotAggression 28 0
line 750
;743:}
;744:
;745:/*
;746:==================
;747:BotAggression
;748:==================
;749:*/
;750:float BotAggression(bot_state_t *bs) {
line 752
;751:	//if the bot has quad
;752:	if (bs->inventory[INVENTORY_QUAD]) {
ADDRFP4 0
INDIRP4
CNSTI4 5036
ADDP4
INDIRI4
CNSTI4 0
EQI4 $394
line 754
;753:		//if the bot is not holding the gauntlet or the enemy is really nearby
;754:		if (bs->weaponnum > WP_GAUNTLET ||
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
CNSTI4 1
GTI4 $398
ADDRLP4 0
INDIRP4
CNSTI4 5728
ADDP4
INDIRI4
CNSTI4 80
GEI4 $396
LABELV $398
line 755
;755:			bs->inventory[ENEMY_HORIZONTAL_DIST] < 80) {
line 756
;756:			return 70;
CNSTF4 1116471296
RETF4
ADDRGP4 $393
JUMPV
LABELV $396
line 758
;757:		}
;758:	}
LABELV $394
line 760
;759:	//if the enemy is located way higher than the bot
;760:	if (bs->inventory[ENEMY_HEIGHT] > 200) return 0;
ADDRFP4 0
INDIRP4
CNSTI4 5732
ADDP4
INDIRI4
CNSTI4 200
LEI4 $399
CNSTF4 0
RETF4
ADDRGP4 $393
JUMPV
LABELV $399
line 762
;761:	//if the bot is very low on health
;762:	if (bs->inventory[INVENTORY_HEALTH] < 60) return 0;
ADDRFP4 0
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
CNSTI4 60
GEI4 $401
CNSTF4 0
RETF4
ADDRGP4 $393
JUMPV
LABELV $401
line 764
;763:	//if the bot is low on health
;764:	if (bs->inventory[INVENTORY_HEALTH] < 80) {
ADDRFP4 0
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
CNSTI4 80
GEI4 $403
line 766
;765:		//if the bot has insufficient armor
;766:		if (bs->inventory[INVENTORY_ARMOR] < 40) return 0;
ADDRFP4 0
INDIRP4
CNSTI4 4932
ADDP4
INDIRI4
CNSTI4 40
GEI4 $405
CNSTF4 0
RETF4
ADDRGP4 $393
JUMPV
LABELV $405
line 767
;767:	}
LABELV $403
line 769
;768:	//if the bot can use the bfg
;769:	if (bs->inventory[INVENTORY_BFG10K] > 0 &&
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 4980
ADDP4
INDIRI4
CNSTI4 0
LEI4 $407
ADDRLP4 0
INDIRP4
CNSTI4 5020
ADDP4
INDIRI4
CNSTI4 7
LEI4 $407
line 770
;770:			bs->inventory[INVENTORY_BFGAMMO] > 7) return 100;
CNSTF4 1120403456
RETF4
ADDRGP4 $393
JUMPV
LABELV $407
line 772
;771:	//if the bot can use the railgun
;772:	if (bs->inventory[INVENTORY_RAILGUN] > 0 &&
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 4968
ADDP4
INDIRI4
CNSTI4 0
LEI4 $409
ADDRLP4 4
INDIRP4
CNSTI4 5016
ADDP4
INDIRI4
CNSTI4 5
LEI4 $409
line 773
;773:			bs->inventory[INVENTORY_SLUGS] > 5) return 95;
CNSTF4 1119748096
RETF4
ADDRGP4 $393
JUMPV
LABELV $409
line 775
;774:	//if the bot can use the lightning gun
;775:	if (bs->inventory[INVENTORY_LIGHTNING] > 0 &&
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 4964
ADDP4
INDIRI4
CNSTI4 0
LEI4 $411
ADDRLP4 8
INDIRP4
CNSTI4 5008
ADDP4
INDIRI4
CNSTI4 50
LEI4 $411
line 776
;776:			bs->inventory[INVENTORY_LIGHTNINGAMMO] > 50) return 90;
CNSTF4 1119092736
RETF4
ADDRGP4 $393
JUMPV
LABELV $411
line 778
;777:	//if the bot can use the rocketlauncher
;778:	if (bs->inventory[INVENTORY_ROCKETLAUNCHER] > 0 &&
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 4960
ADDP4
INDIRI4
CNSTI4 0
LEI4 $413
ADDRLP4 12
INDIRP4
CNSTI4 5012
ADDP4
INDIRI4
CNSTI4 5
LEI4 $413
line 779
;779:			bs->inventory[INVENTORY_ROCKETS] > 5) return 90;
CNSTF4 1119092736
RETF4
ADDRGP4 $393
JUMPV
LABELV $413
line 781
;780:	//if the bot can use the plasmagun
;781:	if (bs->inventory[INVENTORY_PLASMAGUN] > 0 &&
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 4972
ADDP4
INDIRI4
CNSTI4 0
LEI4 $415
ADDRLP4 16
INDIRP4
CNSTI4 5000
ADDP4
INDIRI4
CNSTI4 40
LEI4 $415
line 782
;782:			bs->inventory[INVENTORY_CELLS] > 40) return 85;
CNSTF4 1118437376
RETF4
ADDRGP4 $393
JUMPV
LABELV $415
line 784
;783:	//if the bot can use the grenade launcher
;784:	if (bs->inventory[INVENTORY_GRENADELAUNCHER] > 0 &&
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 4956
ADDP4
INDIRI4
CNSTI4 0
LEI4 $417
ADDRLP4 20
INDIRP4
CNSTI4 4996
ADDP4
INDIRI4
CNSTI4 10
LEI4 $417
line 785
;785:			bs->inventory[INVENTORY_GRENADES] > 10) return 80;
CNSTF4 1117782016
RETF4
ADDRGP4 $393
JUMPV
LABELV $417
line 787
;786:	//if the bot can use the shotgun
;787:	if (bs->inventory[INVENTORY_SHOTGUN] > 0 &&
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 4948
ADDP4
INDIRI4
CNSTI4 0
LEI4 $419
ADDRLP4 24
INDIRP4
CNSTI4 4988
ADDP4
INDIRI4
CNSTI4 10
LEI4 $419
line 788
;788:			bs->inventory[INVENTORY_SHELLS] > 10) return 50;
CNSTF4 1112014848
RETF4
ADDRGP4 $393
JUMPV
LABELV $419
line 790
;789:	//otherwise the bot is not feeling too good
;790:	return 0;
CNSTF4 0
RETF4
LABELV $393
endproc BotAggression 28 0
export BotWantsToRetreat
proc BotWantsToRetreat 148 8
line 798
;791:}
;792:
;793:/*
;794:==================
;795:BotWantsToRetreat
;796:==================
;797:*/
;798:int BotWantsToRetreat(bot_state_t *bs) {
line 802
;799:	aas_entityinfo_t entinfo;
;800:
;801:	//always retreat when carrying a CTF flag
;802:	if (BotCTFCarryingFlag(bs)) return qtrue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 0
EQI4 $422
CNSTI4 1
RETI4
ADDRGP4 $421
JUMPV
LABELV $422
line 804
;803:	//
;804:	if (bs->enemy >= 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
LTI4 $424
line 806
;805:		//if the enemy is carrying a flag
;806:		BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 807
;807:		if (EntityCarriesFlag(&entinfo)) return qfalse;
ADDRLP4 0
ARGP4
ADDRLP4 144
ADDRGP4 EntityCarriesFlag
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
EQI4 $426
CNSTI4 0
RETI4
ADDRGP4 $421
JUMPV
LABELV $426
line 808
;808:	}
LABELV $424
line 810
;809:	//if the bot is getting the flag
;810:	if (bs->ltgtype == LTG_GETFLAG) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 4
NEI4 $428
CNSTI4 1
RETI4
ADDRGP4 $421
JUMPV
LABELV $428
line 812
;811:	//
;812:	if (BotAggression(bs) < 50) return qtrue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 144
ADDRGP4 BotAggression
CALLF4
ASGNF4
ADDRLP4 144
INDIRF4
CNSTF4 1112014848
GEF4 $430
CNSTI4 1
RETI4
ADDRGP4 $421
JUMPV
LABELV $430
line 813
;813:	return qfalse;
CNSTI4 0
RETI4
LABELV $421
endproc BotWantsToRetreat 148 8
export BotWantsToChase
proc BotWantsToChase 152 8
line 821
;814:}
;815:
;816:/*
;817:==================
;818:BotWantsToChase
;819:==================
;820:*/
;821:int BotWantsToChase(bot_state_t *bs) {
line 825
;822:	aas_entityinfo_t entinfo;
;823:
;824:	//always retreat when carrying a CTF flag
;825:	if (BotCTFCarryingFlag(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 0
EQI4 $433
CNSTI4 0
RETI4
ADDRGP4 $432
JUMPV
LABELV $433
line 827
;826:	//if the enemy is carrying a flag
;827:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 828
;828:	if (EntityCarriesFlag(&entinfo)) return qtrue;
ADDRLP4 0
ARGP4
ADDRLP4 144
ADDRGP4 EntityCarriesFlag
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
EQI4 $435
CNSTI4 1
RETI4
ADDRGP4 $432
JUMPV
LABELV $435
line 830
;829:	//if the bot is getting the flag
;830:	if (bs->ltgtype == LTG_GETFLAG) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 4
NEI4 $437
CNSTI4 0
RETI4
ADDRGP4 $432
JUMPV
LABELV $437
line 832
;831:	//
;832:	if (BotAggression(bs) > 50) return qtrue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 148
ADDRGP4 BotAggression
CALLF4
ASGNF4
ADDRLP4 148
INDIRF4
CNSTF4 1112014848
LEF4 $439
CNSTI4 1
RETI4
ADDRGP4 $432
JUMPV
LABELV $439
line 833
;833:	return qfalse;
CNSTI4 0
RETI4
LABELV $432
endproc BotWantsToChase 152 8
export BotWantsToHelp
proc BotWantsToHelp 0 0
line 841
;834:}
;835:
;836:/*
;837:==================
;838:BotWantsToHelp
;839:==================
;840:*/
;841:int BotWantsToHelp(bot_state_t *bs) {
line 842
;842:	return qtrue;
CNSTI4 1
RETI4
LABELV $441
endproc BotWantsToHelp 0 0
export BotCanAndWantsToRocketJump
proc BotCanAndWantsToRocketJump 8 16
line 850
;843:}
;844:
;845:/*
;846:==================
;847:BotCanAndWantsToRocketJump
;848:==================
;849:*/
;850:int BotCanAndWantsToRocketJump(bot_state_t *bs) {
line 854
;851:	float rocketjumper;
;852:
;853:	//if rocket jumping is disabled
;854:	if (!bot_rocketjump.integer) return qfalse;
ADDRGP4 bot_rocketjump+12
INDIRI4
CNSTI4 0
NEI4 $443
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $443
line 856
;855:	//if no rocket launcher
;856:	if (bs->inventory[INVENTORY_ROCKETLAUNCHER] <= 0) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 4960
ADDP4
INDIRI4
CNSTI4 0
GTI4 $446
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $446
line 858
;857:	//if low on rockets
;858:	if (bs->inventory[INVENTORY_ROCKETS] < 3) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 5012
ADDP4
INDIRI4
CNSTI4 3
GEI4 $448
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $448
line 860
;859:	//never rocket jump with the Quad
;860:	if (bs->inventory[INVENTORY_QUAD]) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 5036
ADDP4
INDIRI4
CNSTI4 0
EQI4 $450
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $450
line 862
;861:	//if low on health
;862:	if (bs->inventory[INVENTORY_HEALTH] < 60) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
CNSTI4 60
GEI4 $452
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $452
line 864
;863:	//if not full health
;864:	if (bs->inventory[INVENTORY_HEALTH] < 90) {
ADDRFP4 0
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
CNSTI4 90
GEI4 $454
line 866
;865:		//if the bot has insufficient armor
;866:		if (bs->inventory[INVENTORY_ARMOR] < 40) return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 4932
ADDP4
INDIRI4
CNSTI4 40
GEI4 $456
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $456
line 867
;867:	}
LABELV $454
line 868
;868:	rocketjumper = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_WEAPONJUMPING, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 38
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 4
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 869
;869:	if (rocketjumper < 0.5) return qfalse;
ADDRLP4 0
INDIRF4
CNSTF4 1056964608
GEF4 $458
CNSTI4 0
RETI4
ADDRGP4 $442
JUMPV
LABELV $458
line 870
;870:	return qtrue;
CNSTI4 1
RETI4
LABELV $442
endproc BotCanAndWantsToRocketJump 8 16
export BotGoCamp
proc BotGoCamp 16 16
line 878
;871:}
;872:
;873:/*
;874:==================
;875:BotGoCamp
;876:==================
;877:*/
;878:void BotGoCamp(bot_state_t *bs, bot_goal_t *goal) {
line 882
;879:	float camper;
;880:
;881:	//set message time to zero so bot will NOT show any message
;882:	bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 884
;883:	//set the ltg type
;884:	bs->ltgtype = LTG_CAMP;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 7
ASGNI4
line 886
;885:	//set the team goal
;886:	memcpy(&bs->teamgoal, goal, sizeof(bot_goal_t));
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 888
;887:	//get the team goal time
;888:	camper = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CAMPER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 44
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 4
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 889
;889:	if (camper > 0.99) bs->teamgoal_time = 99999;
ADDRLP4 0
INDIRF4
CNSTF4 1065185444
LEF4 $461
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
CNSTF4 1203982208
ASGNF4
ADDRGP4 $462
JUMPV
LABELV $461
line 890
;890:	else bs->teamgoal_time = 120 + 180 * camper + random() * 15;
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
CNSTF4 1127481344
ADDRLP4 0
INDIRF4
MULF4
CNSTF4 1123024896
ADDF4
CNSTF4 1097859072
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
LABELV $462
line 892
;891:	//set the last time the bot started camping
;892:	bs->camp_time = trap_AAS_Time();
ADDRLP4 12
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6148
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 894
;893:	//the teammate that requested the camping
;894:	bs->teammate = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
CNSTI4 0
ASGNI4
line 896
;895:	//do NOT type arrive message
;896:	bs->arrive_time = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
CNSTF4 1065353216
ASGNF4
line 897
;897:}
LABELV $460
endproc BotGoCamp 16 16
export BotWantsToCamp
proc BotWantsToCamp 180 16
line 904
;898:
;899:/*
;900:==================
;901:BotWantsToCamp
;902:==================
;903:*/
;904:int BotWantsToCamp(bot_state_t *bs) {
line 909
;905:	float camper;
;906:	int cs, traveltime, besttraveltime;
;907:	bot_goal_t goal, bestgoal;
;908:
;909:	camper = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CAMPER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 44
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 128
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 124
ADDRLP4 128
INDIRF4
ASGNF4
line 910
;910:	if (camper < 0.1) return qfalse;
ADDRLP4 124
INDIRF4
CNSTF4 1036831949
GEF4 $464
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $464
line 912
;911:	//if the bot has a team goal
;912:	if (bs->ltgtype == LTG_TEAMHELP ||
ADDRLP4 132
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 132
INDIRI4
CNSTI4 1
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 2
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 3
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 4
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 5
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 7
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 8
EQI4 $474
ADDRLP4 132
INDIRI4
CNSTI4 9
NEI4 $466
LABELV $474
line 919
;913:			bs->ltgtype == LTG_TEAMACCOMPANY ||
;914:			bs->ltgtype == LTG_DEFENDKEYAREA ||
;915:			bs->ltgtype == LTG_GETFLAG ||
;916:			bs->ltgtype == LTG_RUSHBASE ||
;917:			bs->ltgtype == LTG_CAMP ||
;918:			bs->ltgtype == LTG_CAMPORDER ||
;919:			bs->ltgtype == LTG_PATROL) {
line 920
;920:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $466
line 923
;921:	}
;922:	//if camped recently
;923:	if (bs->camp_time > trap_AAS_Time() - 60 + 300 * (1-camper)) return qfalse;
ADDRLP4 136
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6148
ADDP4
INDIRF4
ADDRLP4 136
INDIRF4
CNSTF4 1114636288
SUBF4
CNSTF4 1133903872
CNSTF4 1065353216
ADDRLP4 124
INDIRF4
SUBF4
MULF4
ADDF4
LEF4 $475
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $475
line 925
;924:	//
;925:	if (random() > camper) {
ADDRLP4 140
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 124
INDIRF4
LEF4 $477
line 926
;926:		bs->camp_time = trap_AAS_Time();
ADDRLP4 144
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6148
ADDP4
ADDRLP4 144
INDIRF4
ASGNF4
line 927
;927:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $477
line 930
;928:	}
;929:	//if the bot isn't healthy anough
;930:	if (BotAggression(bs) < 50) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 144
ADDRGP4 BotAggression
CALLF4
ASGNF4
ADDRLP4 144
INDIRF4
CNSTF4 1112014848
GEF4 $479
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $479
line 932
;931:	//the bot should have at least have the rocket launcher, the railgun or the bfg10k with some ammo
;932:	if ((bs->inventory[INVENTORY_ROCKETLAUNCHER] <= 0 || bs->inventory[INVENTORY_ROCKETS < 10]) &&
ADDRLP4 148
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 152
CNSTI4 0
ASGNI4
ADDRLP4 148
INDIRP4
CNSTI4 4960
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
LEI4 $483
ADDRLP4 148
INDIRP4
CNSTI4 4928
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
EQI4 $481
LABELV $483
ADDRLP4 156
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 156
INDIRP4
CNSTI4 4968
ADDP4
INDIRI4
CNSTI4 0
LEI4 $484
ADDRLP4 156
INDIRP4
CNSTI4 5016
ADDP4
INDIRI4
CNSTI4 10
GEI4 $481
LABELV $484
ADDRLP4 160
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 160
INDIRP4
CNSTI4 4980
ADDP4
INDIRI4
CNSTI4 0
LEI4 $485
ADDRLP4 160
INDIRP4
CNSTI4 5020
ADDP4
INDIRI4
CNSTI4 10
GEI4 $481
LABELV $485
line 934
;933:		(bs->inventory[INVENTORY_RAILGUN] <= 0 || bs->inventory[INVENTORY_SLUGS] < 10) &&
;934:		(bs->inventory[INVENTORY_BFG10K] <= 0 || bs->inventory[INVENTORY_BFGAMMO] < 10)) {
line 935
;935:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $481
line 938
;936:	}
;937:	//find the closest camp spot
;938:	besttraveltime = 99999;
ADDRLP4 64
CNSTI4 99999
ASGNI4
line 939
;939:	for (cs = trap_BotGetNextCampSpotGoal(0, &goal); cs; cs = trap_BotGetNextCampSpotGoal(cs, &goal)) {
CNSTI4 0
ARGI4
ADDRLP4 8
ARGP4
ADDRLP4 164
ADDRGP4 trap_BotGetNextCampSpotGoal
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 164
INDIRI4
ASGNI4
ADDRGP4 $489
JUMPV
LABELV $486
line 940
;940:		traveltime = trap_AAS_AreaTravelTimeToGoalArea(bs->areanum, bs->origin, goal.areanum, TFL_DEFAULT);
ADDRLP4 168
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 168
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ARGI4
ADDRLP4 168
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 8+12
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 172
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 172
INDIRI4
ASGNI4
line 941
;941:		if (traveltime && traveltime < besttraveltime) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $491
ADDRLP4 0
INDIRI4
ADDRLP4 64
INDIRI4
GEI4 $491
line 942
;942:			besttraveltime = traveltime;
ADDRLP4 64
ADDRLP4 0
INDIRI4
ASGNI4
line 943
;943:			memcpy(&bestgoal, &goal, sizeof(bot_goal_t));
ADDRLP4 68
ARGP4
ADDRLP4 8
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 944
;944:		}
LABELV $491
line 945
;945:	}
LABELV $487
line 939
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
ADDRLP4 168
ADDRGP4 trap_BotGetNextCampSpotGoal
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 168
INDIRI4
ASGNI4
LABELV $489
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $486
line 946
;946:	if (besttraveltime > 150) return qfalse;
ADDRLP4 64
INDIRI4
CNSTI4 150
LEI4 $493
CNSTI4 0
RETI4
ADDRGP4 $463
JUMPV
LABELV $493
line 948
;947:	//ok found a camp spot, go camp there
;948:	BotGoCamp(bs, &bestgoal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 68
ARGP4
ADDRGP4 BotGoCamp
CALLV
pop
line 950
;949:	//
;950:	return qtrue;
CNSTI4 1
RETI4
LABELV $463
endproc BotWantsToCamp 180 16
export BotDontAvoid
proc BotDontAvoid 68 12
line 958
;951:}
;952:
;953:/*
;954:==================
;955:BotDontAvoid
;956:==================
;957:*/
;958:void BotDontAvoid(bot_state_t *bs, char *itemname) {
line 962
;959:	bot_goal_t goal;
;960:	int num;
;961:
;962:	num = trap_BotGetLevelItemGoal(-1, itemname, &goal);
CNSTI4 -1
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 60
ADDRGP4 trap_BotGetLevelItemGoal
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 60
INDIRI4
ASGNI4
ADDRGP4 $497
JUMPV
LABELV $496
line 963
;963:	while(num >= 0) {
line 964
;964:		trap_BotRemoveFromAvoidGoals(bs->gs, goal.number);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 4+44
INDIRI4
ARGI4
ADDRGP4 trap_BotRemoveFromAvoidGoals
CALLV
pop
line 965
;965:		num = trap_BotGetLevelItemGoal(num, itemname, &goal);
ADDRLP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 64
ADDRGP4 trap_BotGetLevelItemGoal
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 64
INDIRI4
ASGNI4
line 966
;966:	}
LABELV $497
line 963
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $496
line 967
;967:}
LABELV $495
endproc BotDontAvoid 68 12
export BotGoForPowerups
proc BotGoForPowerups 0 8
line 974
;968:
;969:/*
;970:==================
;971:BotGoForPowerups
;972:==================
;973:*/
;974:void BotGoForPowerups(bot_state_t *bs) {
line 977
;975:
;976:	//don't avoid any of the powerups anymore
;977:	BotDontAvoid(bs, "Quad Damage");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $501
ARGP4
ADDRGP4 BotDontAvoid
CALLV
pop
line 978
;978:	BotDontAvoid(bs, "Regeneration");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $502
ARGP4
ADDRGP4 BotDontAvoid
CALLV
pop
line 979
;979:	BotDontAvoid(bs, "Battle Suit");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $503
ARGP4
ADDRGP4 BotDontAvoid
CALLV
pop
line 980
;980:	BotDontAvoid(bs, "Speed");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $504
ARGP4
ADDRGP4 BotDontAvoid
CALLV
pop
line 981
;981:	BotDontAvoid(bs, "Invisibility");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $505
ARGP4
ADDRGP4 BotDontAvoid
CALLV
pop
line 985
;982:	//BotDontAvoid(bs, "Flight");
;983:	//reset the long term goal time so the bot will go for the powerup
;984:	//NOTE: the long term goal type doesn't change
;985:	bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 986
;986:}
LABELV $500
endproc BotGoForPowerups 0 8
export BotRoamGoal
proc BotRoamGoal 180 28
line 993
;987:
;988:/*
;989:==================
;990:BotRoamGoal
;991:==================
;992:*/
;993:void BotRoamGoal(bot_state_t *bs, vec3_t goal) {
line 999
;994:	int pc, i;
;995:	float len, rnd;
;996:	vec3_t dir, bestorg, belowbestorg;
;997:	bsp_trace_t trace;
;998:
;999:	for (i = 0; i < 10; i++) {
ADDRLP4 116
CNSTI4 0
ASGNI4
LABELV $507
line 1001
;1000:		//start at the bot origin
;1001:		VectorCopy(bs->origin, bestorg);
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 1002
;1002:		rnd = random();
ADDRLP4 136
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 112
ADDRLP4 136
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ASGNF4
line 1003
;1003:		if (rnd > 0.25) {
ADDRLP4 112
INDIRF4
CNSTF4 1048576000
LEF4 $511
line 1005
;1004:			//add a random value to the x-coordinate
;1005:			if (random() < 0.5) bestorg[0] -= 800 * random() + 100;
ADDRLP4 140
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
GEF4 $513
ADDRLP4 144
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 12
INDIRF4
CNSTF4 1145569280
ADDRLP4 144
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1120403456
ADDF4
SUBF4
ASGNF4
ADDRGP4 $514
JUMPV
LABELV $513
line 1006
;1006:			else bestorg[0] += 800 * random() + 100;
ADDRLP4 148
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 12
INDIRF4
CNSTF4 1145569280
ADDRLP4 148
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1120403456
ADDF4
ADDF4
ASGNF4
LABELV $514
line 1007
;1007:		}
LABELV $511
line 1008
;1008:		if (rnd < 0.75) {
ADDRLP4 112
INDIRF4
CNSTF4 1061158912
GEF4 $515
line 1010
;1009:			//add a random value to the y-coordinate
;1010:			if (random() < 0.5) bestorg[1] -= 800 * random() + 100;
ADDRLP4 140
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
GEF4 $517
ADDRLP4 144
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
CNSTF4 1145569280
ADDRLP4 144
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1120403456
ADDF4
SUBF4
ASGNF4
ADDRGP4 $518
JUMPV
LABELV $517
line 1011
;1011:			else bestorg[1] += 800 * random() + 100;
ADDRLP4 148
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
CNSTF4 1145569280
ADDRLP4 148
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1120403456
ADDF4
ADDF4
ASGNF4
LABELV $518
line 1012
;1012:		}
LABELV $515
line 1014
;1013:		//add a random value to the z-coordinate (NOTE: 48 = maxjump?)
;1014:		bestorg[2] += 2 * 48 * crandom();
ADDRLP4 140
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 12+8
ADDRLP4 12+8
INDIRF4
CNSTF4 1119879168
CNSTF4 1073741824
ADDRLP4 140
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 1016
;1015:		//trace a line from the origin to the roam target
;1016:		BotAI_Trace(&trace, bs->origin, NULL, NULL, bestorg, bs->entitynum, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRLP4 144
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 144
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 148
CNSTP4 0
ASGNP4
ADDRLP4 148
INDIRP4
ARGP4
ADDRLP4 148
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 144
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1018
;1017:		//direction and length towards the roam target
;1018:		VectorSubtract(trace.endpos, bs->origin, dir);
ADDRLP4 152
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 24+12
INDIRF4
ADDRLP4 152
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 24+12+4
INDIRF4
ADDRLP4 152
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 24+12+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1019
;1019:		len = VectorNormalize(dir);
ADDRLP4 0
ARGP4
ADDRLP4 156
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 108
ADDRLP4 156
INDIRF4
ASGNF4
line 1021
;1020:		//if the roam target is far away anough
;1021:		if (len > 200) {
ADDRLP4 108
INDIRF4
CNSTF4 1128792064
LEF4 $529
line 1023
;1022:			//the roam target is in the given direction before walls
;1023:			VectorScale(dir, len * trace.fraction - 40, dir);
ADDRLP4 164
CNSTF4 1109393408
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 24+8
INDIRF4
MULF4
ADDRLP4 164
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 24+8
INDIRF4
MULF4
ADDRLP4 164
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 24+8
INDIRF4
MULF4
CNSTF4 1109393408
SUBF4
MULF4
ASGNF4
line 1024
;1024:			VectorAdd(bs->origin, dir, bestorg);
ADDRLP4 168
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 168
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 168
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
ADDRLP4 0+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 12+8
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
ADDRLP4 0+8
INDIRF4
ADDF4
ASGNF4
line 1026
;1025:			//get the coordinates of the floor below the roam target
;1026:			belowbestorg[0] = bestorg[0];
ADDRLP4 120
ADDRLP4 12
INDIRF4
ASGNF4
line 1027
;1027:			belowbestorg[1] = bestorg[1];
ADDRLP4 120+4
ADDRLP4 12+4
INDIRF4
ASGNF4
line 1028
;1028:			belowbestorg[2] = bestorg[2] - 800;
ADDRLP4 120+8
ADDRLP4 12+8
INDIRF4
CNSTF4 1145569280
SUBF4
ASGNF4
line 1029
;1029:			BotAI_Trace(&trace, bestorg, NULL, NULL, belowbestorg, bs->entitynum, MASK_SOLID);
ADDRLP4 24
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 172
CNSTP4 0
ASGNP4
ADDRLP4 172
INDIRP4
ARGP4
ADDRLP4 172
INDIRP4
ARGP4
ADDRLP4 120
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1031
;1030:			//
;1031:			if (!trace.startsolid) {
ADDRLP4 24+4
INDIRI4
CNSTI4 0
NEI4 $546
line 1032
;1032:				trace.endpos[2]++;
ADDRLP4 24+12+8
ADDRLP4 24+12+8
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1033
;1033:				pc = trap_PointContents(trace.endpos, bs->entitynum);
ADDRLP4 24+12
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 132
ADDRLP4 176
INDIRI4
ASGNI4
line 1034
;1034:				if (!(pc & (CONTENTS_LAVA | CONTENTS_SLIME))) {
ADDRLP4 132
INDIRI4
CNSTI4 24
BANDI4
CNSTI4 0
NEI4 $552
line 1035
;1035:					VectorCopy(bestorg, goal);
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRB
ASGNB 12
line 1036
;1036:					return;
ADDRGP4 $506
JUMPV
LABELV $552
line 1038
;1037:				}
;1038:			}
LABELV $546
line 1039
;1039:		}
LABELV $529
line 1040
;1040:	}
LABELV $508
line 999
ADDRLP4 116
ADDRLP4 116
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 116
INDIRI4
CNSTI4 10
LTI4 $507
line 1041
;1041:	VectorCopy(bestorg, goal);
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRB
ASGNB 12
line 1042
;1042:}
LABELV $506
endproc BotRoamGoal 180 28
lit
align 4
LABELV $556
byte 4 0
byte 4 0
byte 4 1065353216
export BotAttackMove
code
proc BotAttackMove 400 16
line 1049
;1043:
;1044:/*
;1045:==================
;1046:BotAttackMove
;1047:==================
;1048:*/
;1049:bot_moveresult_t BotAttackMove(bot_state_t *bs, int tfl) {
line 1053
;1050:	int movetype, i;
;1051:	float attack_skill, jumper, croucher, dist, strafechange_time;
;1052:	float attack_dist, attack_range;
;1053:	vec3_t forward, backward, sideward, hordir, up = {0, 0, 1};
ADDRLP4 56
ADDRGP4 $556
INDIRB
ASGNB 12
line 1058
;1054:	aas_entityinfo_t entinfo;
;1055:	bot_moveresult_t moveresult;
;1056:	bot_goal_t goal;
;1057:
;1058:	if (bs->attackchase_time > trap_AAS_Time()) {
ADDRLP4 344
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6088
ADDP4
INDIRF4
ADDRLP4 344
INDIRF4
LEF4 $557
line 1060
;1059:		//create the chase goal
;1060:		goal.entitynum = bs->enemy;
ADDRLP4 136+40
ADDRFP4 4
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ASGNI4
line 1061
;1061:		goal.areanum = bs->lastenemyareanum;
ADDRLP4 136+12
ADDRFP4 4
INDIRP4
CNSTI4 6232
ADDP4
INDIRI4
ASGNI4
line 1062
;1062:		VectorCopy(bs->lastenemyorigin, goal.origin);
ADDRLP4 136
ADDRFP4 4
INDIRP4
CNSTI4 6236
ADDP4
INDIRB
ASGNB 12
line 1063
;1063:		VectorSet(goal.mins, -8, -8, -8);
ADDRLP4 136+16
CNSTF4 3238002688
ASGNF4
ADDRLP4 136+16+4
CNSTF4 3238002688
ASGNF4
ADDRLP4 136+16+8
CNSTF4 3238002688
ASGNF4
line 1064
;1064:		VectorSet(goal.maxs, 8, 8, 8);
ADDRLP4 136+28
CNSTF4 1090519040
ASGNF4
ADDRLP4 136+28+4
CNSTF4 1090519040
ASGNF4
ADDRLP4 136+28+8
CNSTF4 1090519040
ASGNF4
line 1066
;1065:		//initialize the movement state
;1066:		BotSetupForMovement(bs);
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1068
;1067:		//move towards the goal
;1068:		trap_BotMoveToGoal(&moveresult, bs->ms, &goal, tfl);
ADDRLP4 80
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 136
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1069
;1069:		return moveresult;
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
ADDRGP4 $554
JUMPV
LABELV $557
line 1072
;1070:	}
;1071:	//
;1072:	memset(&moveresult, 0, sizeof(bot_moveresult_t));
ADDRLP4 80
ARGP4
CNSTI4 0
ARGI4
CNSTU4 52
ARGU4
ADDRGP4 memset
CALLP4
pop
line 1074
;1073:	//
;1074:	attack_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_ATTACK_SKILL, 0, 1);
ADDRFP4 4
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 348
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 132
ADDRLP4 348
INDIRF4
ASGNF4
line 1075
;1075:	jumper = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_JUMPER, 0, 1);
ADDRFP4 4
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 37
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 352
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 336
ADDRLP4 352
INDIRF4
ASGNF4
line 1076
;1076:	croucher = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CROUCHER, 0, 1);
ADDRFP4 4
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 36
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 356
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 340
ADDRLP4 356
INDIRF4
ASGNF4
line 1078
;1077:	//if the bot is really stupid
;1078:	if (attack_skill < 0.2) return moveresult;
ADDRLP4 132
INDIRF4
CNSTF4 1045220557
GEF4 $571
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
ADDRGP4 $554
JUMPV
LABELV $571
line 1080
;1079:	//initialize the movement state
;1080:	BotSetupForMovement(bs);
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1082
;1081:	//get the enemy entity info
;1082:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 4
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 192
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1084
;1083:	//direction towards the enemy
;1084:	VectorSubtract(entinfo.origin, bs->origin, forward);
ADDRLP4 360
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 24
ADDRLP4 192+24
INDIRF4
ADDRLP4 360
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 24+4
ADDRLP4 192+24+4
INDIRF4
ADDRLP4 360
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 24+8
ADDRLP4 192+24+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1086
;1085:	//the distance towards the enemy
;1086:	dist = VectorNormalize(forward);
ADDRLP4 24
ARGP4
ADDRLP4 364
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 68
ADDRLP4 364
INDIRF4
ASGNF4
line 1087
;1087:	VectorNegate(forward, backward);
ADDRLP4 36
ADDRLP4 24
INDIRF4
NEGF4
ASGNF4
ADDRLP4 36+4
ADDRLP4 24+4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 36+8
ADDRLP4 24+8
INDIRF4
NEGF4
ASGNF4
line 1089
;1088:	//walk, crouch or jump
;1089:	movetype = MOVE_WALK;
ADDRLP4 52
CNSTI4 1
ASGNI4
line 1091
;1090:	//
;1091:	if (bs->attackcrouch_time < trap_AAS_Time() - 1) {
ADDRLP4 368
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 368
INDIRF4
CNSTF4 1065353216
SUBF4
GEF4 $584
line 1092
;1092:		if (random() < jumper) {
ADDRLP4 372
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 372
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 336
INDIRF4
GEF4 $586
line 1093
;1093:			movetype = MOVE_JUMP;
ADDRLP4 52
CNSTI4 4
ASGNI4
line 1094
;1094:		}
ADDRGP4 $587
JUMPV
LABELV $586
line 1096
;1095:		//wait at least one second before crouching again
;1096:		else if (bs->attackcrouch_time < trap_AAS_Time() - 1 && random() < croucher) {
ADDRLP4 376
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 376
INDIRF4
CNSTF4 1065353216
SUBF4
GEF4 $588
ADDRLP4 380
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 380
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 340
INDIRF4
GEF4 $588
line 1097
;1097:			bs->attackcrouch_time = trap_AAS_Time() + croucher * 5;
ADDRLP4 384
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6084
ADDP4
ADDRLP4 384
INDIRF4
CNSTF4 1084227584
ADDRLP4 340
INDIRF4
MULF4
ADDF4
ASGNF4
line 1098
;1098:		}
LABELV $588
LABELV $587
line 1099
;1099:	}
LABELV $584
line 1100
;1100:	if (bs->attackcrouch_time > trap_AAS_Time()) movetype = MOVE_CROUCH;
ADDRLP4 372
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 372
INDIRF4
LEF4 $590
ADDRLP4 52
CNSTI4 2
ASGNI4
LABELV $590
line 1102
;1101:	//if the bot should jump
;1102:	if (movetype == MOVE_JUMP) {
ADDRLP4 52
INDIRI4
CNSTI4 4
NEI4 $592
line 1104
;1103:		//if jumped last frame
;1104:		if (bs->attackjump_time > trap_AAS_Time()) {
ADDRLP4 376
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6092
ADDP4
INDIRF4
ADDRLP4 376
INDIRF4
LEF4 $594
line 1105
;1105:			movetype = MOVE_WALK;
ADDRLP4 52
CNSTI4 1
ASGNI4
line 1106
;1106:		}
ADDRGP4 $595
JUMPV
LABELV $594
line 1107
;1107:		else {
line 1108
;1108:			bs->attackjump_time = trap_AAS_Time() + 1;
ADDRLP4 380
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 6092
ADDP4
ADDRLP4 380
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1109
;1109:		}
LABELV $595
line 1110
;1110:	}
LABELV $592
line 1111
;1111:	if (bs->cur_ps.weapon == WP_GAUNTLET) {
ADDRFP4 4
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
CNSTI4 1
NEI4 $596
line 1112
;1112:		attack_dist = 0;
ADDRLP4 72
CNSTF4 0
ASGNF4
line 1113
;1113:		attack_range = 0;
ADDRLP4 76
CNSTF4 0
ASGNF4
line 1114
;1114:	}
ADDRGP4 $597
JUMPV
LABELV $596
line 1115
;1115:	else {
line 1116
;1116:		attack_dist = IDEAL_ATTACKDIST;
ADDRLP4 72
CNSTF4 1124859904
ASGNF4
line 1117
;1117:		attack_range = 40;
ADDRLP4 76
CNSTF4 1109393408
ASGNF4
line 1118
;1118:	}
LABELV $597
line 1120
;1119:	//if the bot is stupid
;1120:	if (attack_skill <= 0.4) {
ADDRLP4 132
INDIRF4
CNSTF4 1053609165
GTF4 $598
line 1122
;1121:		//just walk to or away from the enemy
;1122:		if (dist > attack_dist + attack_range) {
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
ADDF4
LEF4 $600
line 1123
;1123:			if (trap_BotMoveInDirection(bs->ms, forward, 400, movetype)) return moveresult;
ADDRFP4 4
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 24
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 376
ADDRGP4 trap_BotMoveInDirection
CALLI4
ASGNI4
ADDRLP4 376
INDIRI4
CNSTI4 0
EQI4 $602
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
ADDRGP4 $554
JUMPV
LABELV $602
line 1124
;1124:		}
LABELV $600
line 1125
;1125:		if (dist < attack_dist - attack_range) {
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
GEF4 $604
line 1126
;1126:			if (trap_BotMoveInDirection(bs->ms, backward, 400, movetype)) return moveresult;
ADDRFP4 4
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 36
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 376
ADDRGP4 trap_BotMoveInDirection
CALLI4
ASGNI4
ADDRLP4 376
INDIRI4
CNSTI4 0
EQI4 $606
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
ADDRGP4 $554
JUMPV
LABELV $606
line 1127
;1127:		}
LABELV $604
line 1128
;1128:		return moveresult;
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
ADDRGP4 $554
JUMPV
LABELV $598
line 1131
;1129:	}
;1130:	//increase the strafe time
;1131:	bs->attackstrafe_time += bs->thinktime;
ADDRLP4 376
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 380
ADDRLP4 376
INDIRP4
CNSTI4 6080
ADDP4
ASGNP4
ADDRLP4 380
INDIRP4
ADDRLP4 380
INDIRP4
INDIRF4
ADDRLP4 376
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
ADDF4
ASGNF4
line 1133
;1132:	//get the strafe change time
;1133:	strafechange_time = 0.4 + (1 - attack_skill) * 0.2;
ADDRLP4 332
CNSTF4 1045220557
CNSTF4 1065353216
ADDRLP4 132
INDIRF4
SUBF4
MULF4
CNSTF4 1053609165
ADDF4
ASGNF4
line 1134
;1134:	if (attack_skill > 0.7) strafechange_time += crandom() * 0.2;
ADDRLP4 132
INDIRF4
CNSTF4 1060320051
LEF4 $608
ADDRLP4 384
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 332
ADDRLP4 332
INDIRF4
CNSTF4 1045220557
CNSTF4 1073741824
ADDRLP4 384
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
LABELV $608
line 1136
;1135:	//if the strafe direction should be changed
;1136:	if (bs->attackstrafe_time > strafechange_time) {
ADDRFP4 4
INDIRP4
CNSTI4 6080
ADDP4
INDIRF4
ADDRLP4 332
INDIRF4
LEF4 $610
line 1138
;1137:		//some magic number :)
;1138:		if (random() > 0.935) {
ADDRLP4 388
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 388
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1064262697
LEF4 $612
line 1140
;1139:			//flip the strafe direction
;1140:			bs->flags ^= BFL_STRAFERIGHT;
ADDRLP4 392
ADDRFP4 4
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 392
INDIRP4
ADDRLP4 392
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 1141
;1141:			bs->attackstrafe_time = 0;
ADDRFP4 4
INDIRP4
CNSTI4 6080
ADDP4
CNSTF4 0
ASGNF4
line 1142
;1142:		}
LABELV $612
line 1143
;1143:	}
LABELV $610
line 1145
;1144:	//
;1145:	for (i = 0; i < 2; i++) {
ADDRLP4 48
CNSTI4 0
ASGNI4
LABELV $614
line 1146
;1146:		hordir[0] = forward[0];
ADDRLP4 12
ADDRLP4 24
INDIRF4
ASGNF4
line 1147
;1147:		hordir[1] = forward[1];
ADDRLP4 12+4
ADDRLP4 24+4
INDIRF4
ASGNF4
line 1148
;1148:		hordir[2] = 0;
ADDRLP4 12+8
CNSTF4 0
ASGNF4
line 1149
;1149:		VectorNormalize(hordir);
ADDRLP4 12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1151
;1150:		//get the sideward vector
;1151:		CrossProduct(hordir, up, sideward);
ADDRLP4 12
ARGP4
ADDRLP4 56
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 1153
;1152:		//reverse the vector depending on the strafe direction
;1153:		if (bs->flags & BFL_STRAFERIGHT) VectorNegate(sideward, sideward);
ADDRFP4 4
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $621
ADDRLP4 0
ADDRLP4 0
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
NEGF4
ASGNF4
LABELV $621
line 1155
;1154:		//randomly go back a little
;1155:		if (random() > 0.9) {
ADDRLP4 388
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 388
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1063675494
LEF4 $627
line 1156
;1156:			VectorAdd(sideward, backward, sideward);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 36
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 36+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 36+8
INDIRF4
ADDF4
ASGNF4
line 1157
;1157:		}
ADDRGP4 $628
JUMPV
LABELV $627
line 1158
;1158:		else {
line 1160
;1159:			//walk forward or backward to get at the ideal attack distance
;1160:			if (dist > attack_dist + attack_range) VectorAdd(sideward, forward, sideward);
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
ADDF4
LEF4 $635
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 24
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 24+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 24+8
INDIRF4
ADDF4
ASGNF4
ADDRGP4 $636
JUMPV
LABELV $635
line 1161
;1161:			else if (dist < attack_dist - attack_range) VectorAdd(sideward, backward, sideward);
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
GEF4 $643
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 36
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 36+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 36+8
INDIRF4
ADDF4
ASGNF4
LABELV $643
LABELV $636
line 1162
;1162:		}
LABELV $628
line 1164
;1163:		//perform the movement
;1164:		if (trap_BotMoveInDirection(bs->ms, sideward, 400, movetype)) return moveresult;
ADDRFP4 4
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 392
ADDRGP4 trap_BotMoveInDirection
CALLI4
ASGNI4
ADDRLP4 392
INDIRI4
CNSTI4 0
EQI4 $651
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
ADDRGP4 $554
JUMPV
LABELV $651
line 1166
;1165:		//movement failed, flip the strafe direction
;1166:		bs->flags ^= BFL_STRAFERIGHT;
ADDRLP4 396
ADDRFP4 4
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 396
INDIRP4
ADDRLP4 396
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 1167
;1167:		bs->attackstrafe_time = 0;
ADDRFP4 4
INDIRP4
CNSTI4 6080
ADDP4
CNSTF4 0
ASGNF4
line 1168
;1168:	}
LABELV $615
line 1145
ADDRLP4 48
ADDRLP4 48
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 2
LTI4 $614
line 1171
;1169:	//bot couldn't do any usefull movement
;1170://	bs->attackchase_time = AAS_Time() + 6;
;1171:	return moveresult;
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRB
ASGNB 52
LABELV $554
endproc BotAttackMove 400 16
export BotSameTeam
proc BotSameTeam 2076 12
line 1179
;1172:}
;1173:
;1174:/*
;1175:==================
;1176:BotSameTeam
;1177:==================
;1178:*/
;1179:int BotSameTeam(bot_state_t *bs, int entnum) {
line 1182
;1180:	char info1[1024], info2[1024];
;1181:
;1182:	if (bs->client < 0 || bs->client >= MAX_CLIENTS) {
ADDRLP4 2048
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
ADDRLP4 2048
INDIRI4
CNSTI4 0
LTI4 $656
ADDRLP4 2048
INDIRI4
CNSTI4 128
LTI4 $654
LABELV $656
line 1184
;1183:		//BotAI_Print(PRT_ERROR, "BotSameTeam: client out of range\n");
;1184:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $653
JUMPV
LABELV $654
line 1186
;1185:	}
;1186:	if (entnum < 0 || entnum >= MAX_CLIENTS) {
ADDRLP4 2052
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 2052
INDIRI4
CNSTI4 0
LTI4 $659
ADDRLP4 2052
INDIRI4
CNSTI4 128
LTI4 $657
LABELV $659
line 1188
;1187:		//BotAI_Print(PRT_ERROR, "BotSameTeam: client out of range\n");
;1188:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $653
JUMPV
LABELV $657
line 1190
;1189:	}
;1190:	if (gametype == GT_TEAM || gametype == GT_CTF) {
ADDRLP4 2056
ADDRGP4 gametype
INDIRI4
ASGNI4
ADDRLP4 2056
INDIRI4
CNSTI4 3
EQI4 $662
ADDRLP4 2056
INDIRI4
CNSTI4 4
NEI4 $660
LABELV $662
line 1191
;1191:		trap_GetConfigstring(CS_PLAYERS+bs->client, info1, sizeof(info1));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 1192
;1192:		trap_GetConfigstring(CS_PLAYERS+entnum, info2, sizeof(info2));
ADDRFP4 4
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 1024
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 1194
;1193:		//
;1194:		if (atoi(Info_ValueForKey(info1, "t")) == atoi(Info_ValueForKey(info2, "t"))) return qtrue;
ADDRLP4 0
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 2060
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 2060
INDIRP4
ARGP4
ADDRLP4 2064
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1024
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 2068
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 2068
INDIRP4
ARGP4
ADDRLP4 2072
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 2064
INDIRI4
ADDRLP4 2072
INDIRI4
NEI4 $663
CNSTI4 1
RETI4
ADDRGP4 $653
JUMPV
LABELV $663
line 1195
;1195:	}
LABELV $660
line 1196
;1196:	return qfalse;
CNSTI4 0
RETI4
LABELV $653
endproc BotSameTeam 2076 12
export InFieldOfVision
proc InFieldOfVision 24 4
line 1205
;1197:}
;1198:
;1199:/*
;1200:==================
;1201:InFieldOfVision
;1202:==================
;1203:*/
;1204:qboolean InFieldOfVision(vec3_t viewangles, float fov, vec3_t angles)
;1205:{
line 1209
;1206:	int i;
;1207:	float diff, angle;
;1208:
;1209:	for (i = 0; i < 2; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $666
line 1210
;1210:		angle = AngleMod(viewangles[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 12
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 8
ADDRLP4 12
INDIRF4
ASGNF4
line 1211
;1211:		angles[i] = AngleMod(angles[i]);
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 8
INDIRP4
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
INDIRF4
ARGF4
ADDRLP4 20
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 16
INDIRP4
ADDRLP4 20
INDIRF4
ASGNF4
line 1212
;1212:		diff = angles[i] - angle;
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 8
INDIRP4
ADDP4
INDIRF4
ADDRLP4 8
INDIRF4
SUBF4
ASGNF4
line 1213
;1213:		if (angles[i] > angle) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 8
INDIRP4
ADDP4
INDIRF4
ADDRLP4 8
INDIRF4
LEF4 $670
line 1214
;1214:			if (diff > 180.0) diff -= 360.0;
ADDRLP4 4
INDIRF4
CNSTF4 1127481344
LEF4 $671
ADDRLP4 4
ADDRLP4 4
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
line 1215
;1215:		}
ADDRGP4 $671
JUMPV
LABELV $670
line 1216
;1216:		else {
line 1217
;1217:			if (diff < -180.0) diff += 360.0;
ADDRLP4 4
INDIRF4
CNSTF4 3274964992
GEF4 $674
ADDRLP4 4
ADDRLP4 4
INDIRF4
CNSTF4 1135869952
ADDF4
ASGNF4
LABELV $674
line 1218
;1218:		}
LABELV $671
line 1219
;1219:		if (diff > 0) {
ADDRLP4 4
INDIRF4
CNSTF4 0
LEF4 $676
line 1220
;1220:			if (diff > fov * 0.5) return qfalse;
ADDRLP4 4
INDIRF4
CNSTF4 1056964608
ADDRFP4 4
INDIRF4
MULF4
LEF4 $677
CNSTI4 0
RETI4
ADDRGP4 $665
JUMPV
line 1221
;1221:		}
LABELV $676
line 1222
;1222:		else {
line 1223
;1223:			if (diff < -fov * 0.5) return qfalse;
ADDRLP4 4
INDIRF4
CNSTF4 1056964608
ADDRFP4 4
INDIRF4
NEGF4
MULF4
GEF4 $680
CNSTI4 0
RETI4
ADDRGP4 $665
JUMPV
LABELV $680
line 1224
;1224:		}
LABELV $677
line 1225
;1225:	}
LABELV $667
line 1209
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LTI4 $666
line 1226
;1226:	return qtrue;
CNSTI4 1
RETI4
LABELV $665
endproc InFieldOfVision 24 4
export BotEntityVisible
proc BotEntityVisible 380 28
line 1236
;1227:}
;1228:
;1229:/*
;1230:==================
;1231:BotEntityVisible
;1232:
;1233:returns visibility in the range [0, 1] taking fog and water surfaces into account
;1234:==================
;1235:*/
;1236:float BotEntityVisible(int viewer, vec3_t eye, vec3_t viewangles, float fov, int ent) {
line 1244
;1237:	int i, contents_mask, passent, hitent, infog, inwater, otherinfog, pc;
;1238:	float fogdist, waterfactor, vis, bestvis;
;1239:	bsp_trace_t trace;
;1240:	aas_entityinfo_t entinfo;
;1241:	vec3_t dir, entangles, start, end, middle;
;1242:
;1243:	//calculate middle of bounding box
;1244:	BotEntityInfo(ent, &entinfo);
ADDRFP4 16
INDIRI4
ARGI4
ADDRLP4 152
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1245
;1245:	VectorAdd(entinfo.mins, entinfo.maxs, middle);
ADDRLP4 84
ADDRLP4 152+72
INDIRF4
ADDRLP4 152+84
INDIRF4
ADDF4
ASGNF4
ADDRLP4 84+4
ADDRLP4 152+72+4
INDIRF4
ADDRLP4 152+84+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 84+8
ADDRLP4 152+72+8
INDIRF4
ADDRLP4 152+84+8
INDIRF4
ADDF4
ASGNF4
line 1246
;1246:	VectorScale(middle, 0.5, middle);
ADDRLP4 332
CNSTF4 1056964608
ASGNF4
ADDRLP4 84
ADDRLP4 332
INDIRF4
ADDRLP4 84
INDIRF4
MULF4
ASGNF4
ADDRLP4 84+4
ADDRLP4 332
INDIRF4
ADDRLP4 84+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 84+8
CNSTF4 1056964608
ADDRLP4 84+8
INDIRF4
MULF4
ASGNF4
line 1247
;1247:	VectorAdd(entinfo.origin, middle, middle);
ADDRLP4 84
ADDRLP4 152+24
INDIRF4
ADDRLP4 84
INDIRF4
ADDF4
ASGNF4
ADDRLP4 84+4
ADDRLP4 152+24+4
INDIRF4
ADDRLP4 84+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 84+8
ADDRLP4 152+24+8
INDIRF4
ADDRLP4 84+8
INDIRF4
ADDF4
ASGNF4
line 1249
;1248:	//check if entity is within field of vision
;1249:	VectorSubtract(middle, eye, dir);
ADDRLP4 336
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 140
ADDRLP4 84
INDIRF4
ADDRLP4 336
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+4
ADDRLP4 84+4
INDIRF4
ADDRLP4 336
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+8
ADDRLP4 84+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1250
;1250:	vectoangles(dir, entangles);
ADDRLP4 140
ARGP4
ADDRLP4 320
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1251
;1251:	if (!InFieldOfVision(viewangles, fov, entangles)) return 0;
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 320
ARGP4
ADDRLP4 340
ADDRGP4 InFieldOfVision
CALLI4
ASGNI4
ADDRLP4 340
INDIRI4
CNSTI4 0
NEI4 $712
CNSTF4 0
RETF4
ADDRGP4 $682
JUMPV
LABELV $712
line 1253
;1252:	//
;1253:	pc = trap_AAS_PointContents(eye);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 344
ADDRGP4 trap_AAS_PointContents
CALLI4
ASGNI4
ADDRLP4 316
ADDRLP4 344
INDIRI4
ASGNI4
line 1254
;1254:	infog = (pc & CONTENTS_SOLID);
ADDRLP4 312
ADDRLP4 316
INDIRI4
CNSTI4 1
BANDI4
ASGNI4
line 1255
;1255:	inwater = (pc & (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER));
ADDRLP4 308
ADDRLP4 316
INDIRI4
CNSTI4 56
BANDI4
ASGNI4
line 1257
;1256:	//
;1257:	bestvis = 0;
ADDRLP4 300
CNSTF4 0
ASGNF4
line 1258
;1258:	for (i = 0; i < 3; i++) {
ADDRLP4 100
CNSTI4 0
ASGNI4
LABELV $714
line 1262
;1259:		//if the point is not in potential visible sight
;1260:		//if (!AAS_inPVS(eye, middle)) continue;
;1261:		//
;1262:		contents_mask = CONTENTS_SOLID|CONTENTS_PLAYERCLIP;
ADDRLP4 96
CNSTI4 65537
ASGNI4
line 1263
;1263:		passent = viewer;
ADDRLP4 116
ADDRFP4 0
INDIRI4
ASGNI4
line 1264
;1264:		hitent = ent;
ADDRLP4 136
ADDRFP4 16
INDIRI4
ASGNI4
line 1265
;1265:		VectorCopy(eye, start);
ADDRLP4 124
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1266
;1266:		VectorCopy(middle, end);
ADDRLP4 104
ADDRLP4 84
INDIRB
ASGNB 12
line 1268
;1267:		//if the entity is in water, lava or slime
;1268:		if (trap_AAS_PointContents(middle) & (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER)) {
ADDRLP4 84
ARGP4
ADDRLP4 348
ADDRGP4 trap_AAS_PointContents
CALLI4
ASGNI4
ADDRLP4 348
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $718
line 1269
;1269:			contents_mask |= (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER);
ADDRLP4 96
ADDRLP4 96
INDIRI4
CNSTI4 56
BORI4
ASGNI4
line 1270
;1270:		}
LABELV $718
line 1272
;1271:		//if eye is in water, lava or slime
;1272:		if (inwater) {
ADDRLP4 308
INDIRI4
CNSTI4 0
EQI4 $720
line 1273
;1273:			if (!(contents_mask & (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER))) {
ADDRLP4 96
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
NEI4 $722
line 1274
;1274:				passent = ent;
ADDRLP4 116
ADDRFP4 16
INDIRI4
ASGNI4
line 1275
;1275:				hitent = viewer;
ADDRLP4 136
ADDRFP4 0
INDIRI4
ASGNI4
line 1276
;1276:				VectorCopy(middle, start);
ADDRLP4 124
ADDRLP4 84
INDIRB
ASGNB 12
line 1277
;1277:				VectorCopy(eye, end);
ADDRLP4 104
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1278
;1278:			}
LABELV $722
line 1279
;1279:			contents_mask ^= (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER);
ADDRLP4 96
ADDRLP4 96
INDIRI4
CNSTI4 56
BXORI4
ASGNI4
line 1280
;1280:		}
LABELV $720
line 1282
;1281:		//trace from start to end
;1282:		BotAI_Trace(&trace, start, NULL, NULL, end, passent, contents_mask);
ADDRLP4 0
ARGP4
ADDRLP4 124
ARGP4
ADDRLP4 352
CNSTP4 0
ASGNP4
ADDRLP4 352
INDIRP4
ARGP4
ADDRLP4 352
INDIRP4
ARGP4
ADDRLP4 104
ARGP4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 96
INDIRI4
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1284
;1283:		//if water was hit
;1284:		waterfactor = 1.0;
ADDRLP4 292
CNSTF4 1065353216
ASGNF4
line 1285
;1285:		if (trace.contents & (CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER)) {
ADDRLP4 0+76
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $724
line 1287
;1286:			//if the water surface is translucent
;1287:			if (1) {
line 1289
;1288:				//trace through the water
;1289:				contents_mask &= ~(CONTENTS_LAVA|CONTENTS_SLIME|CONTENTS_WATER);
ADDRLP4 96
ADDRLP4 96
INDIRI4
CNSTI4 -57
BANDI4
ASGNI4
line 1290
;1290:				BotAI_Trace(&trace, trace.endpos, NULL, NULL, end, passent, contents_mask);
ADDRLP4 0
ARGP4
ADDRLP4 0+12
ARGP4
ADDRLP4 356
CNSTP4 0
ASGNP4
ADDRLP4 356
INDIRP4
ARGP4
ADDRLP4 356
INDIRP4
ARGP4
ADDRLP4 104
ARGP4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 96
INDIRI4
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1291
;1291:				waterfactor = 0.5;
ADDRLP4 292
CNSTF4 1056964608
ASGNF4
line 1292
;1292:			}
LABELV $727
line 1293
;1293:		}
LABELV $724
line 1295
;1294:		//if a full trace or the hitent was hit
;1295:		if (trace.fraction >= 1 || trace.ent == hitent) {
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
GEF4 $734
ADDRLP4 0+80
INDIRI4
ADDRLP4 136
INDIRI4
NEI4 $730
LABELV $734
line 1298
;1296:			//check for fog, assuming there's only one fog brush where
;1297:			//either the viewer or the entity is in or both are in
;1298:			otherinfog = (trap_AAS_PointContents(middle) & CONTENTS_FOG);
ADDRLP4 84
ARGP4
ADDRLP4 356
ADDRGP4 trap_AAS_PointContents
CALLI4
ASGNI4
ADDRLP4 304
ADDRLP4 356
INDIRI4
CNSTI4 64
BANDI4
ASGNI4
line 1299
;1299:			if (infog && otherinfog) {
ADDRLP4 360
CNSTI4 0
ASGNI4
ADDRLP4 312
INDIRI4
ADDRLP4 360
INDIRI4
EQI4 $735
ADDRLP4 304
INDIRI4
ADDRLP4 360
INDIRI4
EQI4 $735
line 1300
;1300:				VectorSubtract(trace.endpos, eye, dir);
ADDRLP4 364
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 140
ADDRLP4 0+12
INDIRF4
ADDRLP4 364
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+4
ADDRLP4 0+12+4
INDIRF4
ADDRLP4 364
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+8
ADDRLP4 0+12+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1301
;1301:				fogdist = VectorLength(dir);
ADDRLP4 140
ARGP4
ADDRLP4 368
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 120
ADDRLP4 368
INDIRF4
ASGNF4
line 1302
;1302:			}
ADDRGP4 $736
JUMPV
LABELV $735
line 1303
;1303:			else if (infog) {
ADDRLP4 312
INDIRI4
CNSTI4 0
EQI4 $744
line 1304
;1304:				VectorCopy(trace.endpos, start);
ADDRLP4 124
ADDRLP4 0+12
INDIRB
ASGNB 12
line 1305
;1305:				BotAI_Trace(&trace, start, NULL, NULL, eye, viewer, CONTENTS_FOG);
ADDRLP4 0
ARGP4
ADDRLP4 124
ARGP4
ADDRLP4 364
CNSTP4 0
ASGNP4
ADDRLP4 364
INDIRP4
ARGP4
ADDRLP4 364
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 64
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1306
;1306:				VectorSubtract(eye, trace.endpos, dir);
ADDRLP4 368
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 140
ADDRLP4 368
INDIRP4
INDIRF4
ADDRLP4 0+12
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+4
ADDRLP4 368
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 0+12+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 0+12+8
INDIRF4
SUBF4
ASGNF4
line 1307
;1307:				fogdist = VectorLength(dir);
ADDRLP4 140
ARGP4
ADDRLP4 372
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 120
ADDRLP4 372
INDIRF4
ASGNF4
line 1308
;1308:			}
ADDRGP4 $745
JUMPV
LABELV $744
line 1309
;1309:			else if (otherinfog) {
ADDRLP4 304
INDIRI4
CNSTI4 0
EQI4 $754
line 1310
;1310:				VectorCopy(trace.endpos, end);
ADDRLP4 104
ADDRLP4 0+12
INDIRB
ASGNB 12
line 1311
;1311:				BotAI_Trace(&trace, eye, NULL, NULL, end, viewer, CONTENTS_FOG);
ADDRLP4 0
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 364
CNSTP4 0
ASGNP4
ADDRLP4 364
INDIRP4
ARGP4
ADDRLP4 364
INDIRP4
ARGP4
ADDRLP4 104
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 64
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1312
;1312:				VectorSubtract(end, trace.endpos, dir);
ADDRLP4 140
ADDRLP4 104
INDIRF4
ADDRLP4 0+12
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+4
ADDRLP4 104+4
INDIRF4
ADDRLP4 0+12+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 140+8
ADDRLP4 104+8
INDIRF4
ADDRLP4 0+12+8
INDIRF4
SUBF4
ASGNF4
line 1313
;1313:				fogdist = VectorLength(dir);
ADDRLP4 140
ARGP4
ADDRLP4 368
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 120
ADDRLP4 368
INDIRF4
ASGNF4
line 1314
;1314:			}
ADDRGP4 $755
JUMPV
LABELV $754
line 1315
;1315:			else {
line 1317
;1316:				//if the entity and the viewer are not in fog assume there's no fog in between
;1317:				fogdist = 0;
ADDRLP4 120
CNSTF4 0
ASGNF4
line 1318
;1318:			}
LABELV $755
LABELV $745
LABELV $736
line 1320
;1319:			//decrease visibility with the view distance through fog
;1320:			vis = 1 / ((fogdist * fogdist * 0.001) < 1 ? 1 : (fogdist * fogdist * 0.001));
ADDRLP4 372
CNSTF4 1065353216
ASGNF4
CNSTF4 981668463
ADDRLP4 120
INDIRF4
ADDRLP4 120
INDIRF4
MULF4
MULF4
ADDRLP4 372
INDIRF4
GEF4 $767
ADDRLP4 364
CNSTF4 1065353216
ASGNF4
ADDRGP4 $768
JUMPV
LABELV $767
ADDRLP4 364
CNSTF4 981668463
ADDRLP4 120
INDIRF4
ADDRLP4 120
INDIRF4
MULF4
MULF4
ASGNF4
LABELV $768
ADDRLP4 296
ADDRLP4 372
INDIRF4
ADDRLP4 364
INDIRF4
DIVF4
ASGNF4
line 1322
;1321:			//if entering water visibility is reduced
;1322:			vis *= waterfactor;
ADDRLP4 296
ADDRLP4 296
INDIRF4
ADDRLP4 292
INDIRF4
MULF4
ASGNF4
line 1324
;1323:			//
;1324:			if (vis > bestvis) bestvis = vis;
ADDRLP4 296
INDIRF4
ADDRLP4 300
INDIRF4
LEF4 $769
ADDRLP4 300
ADDRLP4 296
INDIRF4
ASGNF4
LABELV $769
line 1326
;1325:			//if pretty much no fog
;1326:			if (bestvis >= 0.95) return bestvis;
ADDRLP4 300
INDIRF4
CNSTF4 1064514355
LTF4 $771
ADDRLP4 300
INDIRF4
RETF4
ADDRGP4 $682
JUMPV
LABELV $771
line 1327
;1327:		}
LABELV $730
line 1329
;1328:		//check bottom and top of bounding box as well
;1329:		if (i == 0) middle[2] += entinfo.mins[2];
ADDRLP4 100
INDIRI4
CNSTI4 0
NEI4 $773
ADDRLP4 84+8
ADDRLP4 84+8
INDIRF4
ADDRLP4 152+72+8
INDIRF4
ADDF4
ASGNF4
ADDRGP4 $774
JUMPV
LABELV $773
line 1330
;1330:		else if (i == 1) middle[2] += entinfo.maxs[2] - entinfo.mins[2];
ADDRLP4 100
INDIRI4
CNSTI4 1
NEI4 $778
ADDRLP4 84+8
ADDRLP4 84+8
INDIRF4
ADDRLP4 152+84+8
INDIRF4
ADDRLP4 152+72+8
INDIRF4
SUBF4
ADDF4
ASGNF4
LABELV $778
LABELV $774
line 1331
;1331:	}
LABELV $715
line 1258
ADDRLP4 100
ADDRLP4 100
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 100
INDIRI4
CNSTI4 3
LTI4 $714
line 1332
;1332:	return bestvis;
ADDRLP4 300
INDIRF4
RETF4
LABELV $682
endproc BotEntityVisible 380 28
export BotFindEnemy
proc BotFindEnemy 432 20
line 1340
;1333:}
;1334:
;1335:/*
;1336:==================
;1337:BotFindEnemy
;1338:==================
;1339:*/
;1340:int BotFindEnemy(bot_state_t *bs, int curenemy) {
line 1346
;1341:	int i, healthdecrease;
;1342:	float f, dist, curdist, alertness, easyfragger, vis;
;1343:	aas_entityinfo_t entinfo, curenemyinfo;
;1344:	vec3_t dir, angles;
;1345:
;1346:	alertness = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_ALERTNESS, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 46
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 336
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 172
ADDRLP4 336
INDIRF4
ASGNF4
line 1347
;1347:	easyfragger = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_EASY_FRAGGER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 45
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 340
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 176
ADDRLP4 340
INDIRF4
ASGNF4
line 1349
;1348:	//check if the health decreased
;1349:	healthdecrease = bs->lasthealth > bs->inventory[INVENTORY_HEALTH];
ADDRLP4 348
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 348
INDIRP4
CNSTI4 5964
ADDP4
INDIRI4
ADDRLP4 348
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
LEI4 $787
ADDRLP4 344
CNSTI4 1
ASGNI4
ADDRGP4 $788
JUMPV
LABELV $787
ADDRLP4 344
CNSTI4 0
ASGNI4
LABELV $788
ADDRLP4 160
ADDRLP4 344
INDIRI4
ASGNI4
line 1351
;1350:	//remember the current health value
;1351:	bs->lasthealth = bs->inventory[INVENTORY_HEALTH];
ADDRLP4 352
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 352
INDIRP4
CNSTI4 5964
ADDP4
ADDRLP4 352
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
ASGNI4
line 1353
;1352:	//
;1353:	if (curenemy >= 0) {
ADDRFP4 4
INDIRI4
CNSTI4 0
LTI4 $789
line 1354
;1354:		BotEntityInfo(curenemy, &curenemyinfo);
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 196
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1355
;1355:		if (EntityCarriesFlag(&curenemyinfo)) return qfalse;
ADDRLP4 196
ARGP4
ADDRLP4 356
ADDRGP4 EntityCarriesFlag
CALLI4
ASGNI4
ADDRLP4 356
INDIRI4
CNSTI4 0
EQI4 $791
CNSTI4 0
RETI4
ADDRGP4 $785
JUMPV
LABELV $791
line 1356
;1356:		VectorSubtract(curenemyinfo.origin, bs->origin, dir);
ADDRLP4 360
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 144
ADDRLP4 196+24
INDIRF4
ADDRLP4 360
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+4
ADDRLP4 196+24+4
INDIRF4
ADDRLP4 360
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+8
ADDRLP4 196+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1357
;1357:		curdist = VectorLength(dir);
ADDRLP4 144
ARGP4
ADDRLP4 364
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 192
ADDRLP4 364
INDIRF4
ASGNF4
line 1358
;1358:	}
ADDRGP4 $790
JUMPV
LABELV $789
line 1359
;1359:	else {
line 1360
;1360:		curdist = 0;
ADDRLP4 192
CNSTF4 0
ASGNF4
line 1361
;1361:	}
LABELV $790
line 1363
;1362:	//
;1363:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 140
CNSTI4 0
ASGNI4
ADDRGP4 $803
JUMPV
LABELV $800
line 1365
;1364:
;1365:		if (i == bs->client) continue;
ADDRLP4 140
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $804
ADDRGP4 $801
JUMPV
LABELV $804
line 1367
;1366:		//if it's the current enemy
;1367:		if (i == curenemy) continue;
ADDRLP4 140
INDIRI4
ADDRFP4 4
INDIRI4
NEI4 $806
ADDRGP4 $801
JUMPV
LABELV $806
line 1369
;1368:		//
;1369:		BotEntityInfo(i, &entinfo);
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1371
;1370:		//
;1371:		if (!entinfo.valid) continue;
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $808
ADDRGP4 $801
JUMPV
LABELV $808
line 1373
;1372:		//if the enemy isn't dead and the enemy isn't the bot self
;1373:		if (EntityIsDead(&entinfo) || entinfo.number == bs->entitynum) continue;
ADDRLP4 0
ARGP4
ADDRLP4 356
ADDRGP4 EntityIsDead
CALLI4
ASGNI4
ADDRLP4 356
INDIRI4
CNSTI4 0
NEI4 $813
ADDRLP4 0+20
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
NEI4 $810
LABELV $813
ADDRGP4 $801
JUMPV
LABELV $810
line 1375
;1374:		//if the enemy is invisible and not shooting
;1375:		if (EntityIsInvisible(&entinfo) && !EntityIsShooting(&entinfo)) {
ADDRLP4 0
ARGP4
ADDRLP4 360
ADDRGP4 EntityIsInvisible
CALLI4
ASGNI4
ADDRLP4 360
INDIRI4
CNSTI4 0
EQI4 $814
ADDRLP4 0
ARGP4
ADDRLP4 364
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 364
INDIRI4
CNSTI4 0
NEI4 $814
line 1376
;1376:			continue;
ADDRGP4 $801
JUMPV
LABELV $814
line 1379
;1377:		}
;1378:		//if not an easy fragger don't shoot at chatting players
;1379:		if (easyfragger < 0.5 && EntityIsChatting(&entinfo)) continue;
ADDRLP4 176
INDIRF4
CNSTF4 1056964608
GEF4 $816
ADDRLP4 0
ARGP4
ADDRLP4 368
ADDRGP4 EntityIsChatting
CALLI4
ASGNI4
ADDRLP4 368
INDIRI4
CNSTI4 0
EQI4 $816
ADDRGP4 $801
JUMPV
LABELV $816
line 1381
;1380:		//
;1381:		if (lastteleport_time > trap_AAS_Time() - 3) {
ADDRLP4 372
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRGP4 lastteleport_time
INDIRF4
ADDRLP4 372
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $818
line 1382
;1382:			VectorSubtract(entinfo.origin, lastteleport_origin, dir);
ADDRLP4 144
ADDRLP4 0+24
INDIRF4
ADDRGP4 lastteleport_origin
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+4
ADDRLP4 0+24+4
INDIRF4
ADDRGP4 lastteleport_origin+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+8
ADDRLP4 0+24+8
INDIRF4
ADDRGP4 lastteleport_origin+8
INDIRF4
SUBF4
ASGNF4
line 1383
;1383:			if (VectorLength(dir) < 70) continue;
ADDRLP4 144
ARGP4
ADDRLP4 376
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 376
INDIRF4
CNSTF4 1116471296
GEF4 $829
ADDRGP4 $801
JUMPV
LABELV $829
line 1384
;1384:		}
LABELV $818
line 1386
;1385:		//calculate the distance towards the enemy
;1386:		VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 376
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 144
ADDRLP4 0+24
INDIRF4
ADDRLP4 376
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+4
ADDRLP4 0+24+4
INDIRF4
ADDRLP4 376
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+8
ADDRLP4 0+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1387
;1387:		dist = VectorLength(dir);
ADDRLP4 144
ARGP4
ADDRLP4 380
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 156
ADDRLP4 380
INDIRF4
ASGNF4
line 1389
;1388:		//if this entity is not carrying a flag
;1389:		if (!EntityCarriesFlag(&entinfo))
ADDRLP4 0
ARGP4
ADDRLP4 384
ADDRGP4 EntityCarriesFlag
CALLI4
ASGNI4
ADDRLP4 384
INDIRI4
CNSTI4 0
NEI4 $838
line 1390
;1390:		{
line 1392
;1391:			//if this enemy is further away than the current one
;1392:			if (curenemy >= 0 && dist > curdist) continue;
ADDRFP4 4
INDIRI4
CNSTI4 0
LTI4 $840
ADDRLP4 156
INDIRF4
ADDRLP4 192
INDIRF4
LEF4 $840
ADDRGP4 $801
JUMPV
LABELV $840
line 1393
;1393:		} //end if
LABELV $838
line 1395
;1394:		//if the bot has no
;1395:		if (dist > 900 + alertness * 4000) continue;
ADDRLP4 156
INDIRF4
CNSTF4 1165623296
ADDRLP4 172
INDIRF4
MULF4
CNSTF4 1147207680
ADDF4
LEF4 $842
ADDRGP4 $801
JUMPV
LABELV $842
line 1397
;1396:		//if on the same team
;1397:		if (BotSameTeam(bs, i)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 388
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 388
INDIRI4
CNSTI4 0
EQI4 $844
ADDRGP4 $801
JUMPV
LABELV $844
line 1399
;1398:		//if the bot's health decreased or the enemy is shooting
;1399:		if (curenemy < 0 && (healthdecrease || EntityIsShooting(&entinfo))) f = 360;
ADDRLP4 392
CNSTI4 0
ASGNI4
ADDRFP4 4
INDIRI4
ADDRLP4 392
INDIRI4
GEI4 $846
ADDRLP4 160
INDIRI4
ADDRLP4 392
INDIRI4
NEI4 $848
ADDRLP4 0
ARGP4
ADDRLP4 396
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 396
INDIRI4
CNSTI4 0
EQI4 $846
LABELV $848
ADDRLP4 164
CNSTF4 1135869952
ASGNF4
ADDRGP4 $847
JUMPV
LABELV $846
line 1400
;1400:		else f = 90 + 90 - (90 - (dist > 810 ? 810 : dist) / 9);
ADDRLP4 156
INDIRF4
CNSTF4 1145733120
LEF4 $850
ADDRLP4 400
CNSTF4 1145733120
ASGNF4
ADDRGP4 $851
JUMPV
LABELV $850
ADDRLP4 400
ADDRLP4 156
INDIRF4
ASGNF4
LABELV $851
ADDRLP4 164
CNSTF4 1127481344
CNSTF4 1119092736
ADDRLP4 400
INDIRF4
CNSTF4 1091567616
DIVF4
SUBF4
SUBF4
ASGNF4
LABELV $847
line 1402
;1401:		//check if the enemy is visible
;1402:		vis = BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, f, i);
ADDRLP4 404
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 404
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 404
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 404
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRLP4 164
INDIRF4
ARGF4
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 408
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 168
ADDRLP4 408
INDIRF4
ASGNF4
line 1403
;1403:		if (vis <= 0) continue;
ADDRLP4 168
INDIRF4
CNSTF4 0
GTF4 $852
ADDRGP4 $801
JUMPV
LABELV $852
line 1405
;1404:		//if the enemy is quite far away, not shooting and the bot is not damaged
;1405:		if (curenemy < 0 && dist > 200 && !healthdecrease && !EntityIsShooting(&entinfo))
ADDRLP4 412
CNSTI4 0
ASGNI4
ADDRFP4 4
INDIRI4
ADDRLP4 412
INDIRI4
GEI4 $854
ADDRLP4 156
INDIRF4
CNSTF4 1128792064
LEF4 $854
ADDRLP4 160
INDIRI4
ADDRLP4 412
INDIRI4
NEI4 $854
ADDRLP4 0
ARGP4
ADDRLP4 416
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 416
INDIRI4
CNSTI4 0
NEI4 $854
line 1406
;1406:		{
line 1408
;1407:			//check if we can avoid this enemy
;1408:			VectorSubtract(bs->origin, entinfo.origin, dir);
ADDRLP4 420
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 144
ADDRLP4 420
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
ADDRLP4 0+24
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+4
ADDRLP4 420
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
ADDRLP4 0+24+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+8
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
ADDRLP4 0+24+8
INDIRF4
SUBF4
ASGNF4
line 1409
;1409:			vectoangles(dir, angles);
ADDRLP4 144
ARGP4
ADDRLP4 180
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1411
;1410:			//if the bot isn't in the fov of the enemy
;1411:			if (!InFieldOfVision(entinfo.angles, 120, angles)) {
ADDRLP4 0+36
ARGP4
CNSTF4 1123024896
ARGF4
ADDRLP4 180
ARGP4
ADDRLP4 424
ADDRGP4 InFieldOfVision
CALLI4
ASGNI4
ADDRLP4 424
INDIRI4
CNSTI4 0
NEI4 $863
line 1413
;1412:				//update some stuff for this enemy
;1413:				BotUpdateBattleInventory(bs, i);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
INDIRI4
ARGI4
ADDRGP4 BotUpdateBattleInventory
CALLV
pop
line 1415
;1414:				//if the bot doesn't really want to fight
;1415:				if (BotWantsToRetreat(bs)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 428
ADDRGP4 BotWantsToRetreat
CALLI4
ASGNI4
ADDRLP4 428
INDIRI4
CNSTI4 0
EQI4 $866
ADDRGP4 $801
JUMPV
LABELV $866
line 1416
;1416:			}
LABELV $863
line 1417
;1417:		}
LABELV $854
line 1419
;1418:		//found an enemy
;1419:		bs->enemy = entinfo.number;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
ADDRLP4 0+20
INDIRI4
ASGNI4
line 1420
;1420:		if (curenemy >= 0) bs->enemysight_time = trap_AAS_Time() - 2;
ADDRFP4 4
INDIRI4
CNSTI4 0
LTI4 $869
ADDRLP4 420
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6096
ADDP4
ADDRLP4 420
INDIRF4
CNSTF4 1073741824
SUBF4
ASGNF4
ADDRGP4 $870
JUMPV
LABELV $869
line 1421
;1421:		else bs->enemysight_time = trap_AAS_Time();
ADDRLP4 424
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6096
ADDP4
ADDRLP4 424
INDIRF4
ASGNF4
LABELV $870
line 1422
;1422:		bs->enemysuicide = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 5988
ADDP4
CNSTI4 0
ASGNI4
line 1423
;1423:		bs->enemydeath_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6100
ADDP4
CNSTF4 0
ASGNF4
line 1424
;1424:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $785
JUMPV
LABELV $801
line 1363
ADDRLP4 140
ADDRLP4 140
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $803
ADDRLP4 140
INDIRI4
ADDRGP4 maxclients
INDIRI4
GEI4 $871
ADDRLP4 140
INDIRI4
CNSTI4 128
LTI4 $800
LABELV $871
line 1426
;1425:	}
;1426:	return qfalse;
CNSTI4 0
RETI4
LABELV $785
endproc BotFindEnemy 432 20
export BotTeamFlagCarrierVisible
proc BotTeamFlagCarrierVisible 164 20
line 1434
;1427:}
;1428:
;1429:/*
;1430:==================
;1431:BotTeamFlagCarrierVisible
;1432:==================
;1433:*/
;1434:int BotTeamFlagCarrierVisible(bot_state_t *bs) {
line 1439
;1435:	int i;
;1436:	float vis;
;1437:	aas_entityinfo_t entinfo;
;1438:
;1439:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $876
JUMPV
LABELV $873
line 1440
;1440:		if (i == bs->client) continue;
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $877
ADDRGP4 $874
JUMPV
LABELV $877
line 1442
;1441:		//
;1442:		BotEntityInfo(i, &entinfo);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1444
;1443:		//if this player is active
;1444:		if (!entinfo.valid) continue;
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $879
ADDRGP4 $874
JUMPV
LABELV $879
line 1446
;1445:		//if this player is carrying a flag
;1446:		if (!EntityCarriesFlag(&entinfo)) continue;
ADDRLP4 4
ARGP4
ADDRLP4 148
ADDRGP4 EntityCarriesFlag
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
NEI4 $881
ADDRGP4 $874
JUMPV
LABELV $881
line 1448
;1447:		//if the flag carrier is not on the same team
;1448:		if (!BotSameTeam(bs, i)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 152
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 152
INDIRI4
CNSTI4 0
NEI4 $883
ADDRGP4 $874
JUMPV
LABELV $883
line 1450
;1449:		//if the flag carrier is not visible
;1450:		vis = BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, i);
ADDRLP4 156
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 156
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 156
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 156
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 160
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 144
ADDRLP4 160
INDIRF4
ASGNF4
line 1451
;1451:		if (vis <= 0) continue;
ADDRLP4 144
INDIRF4
CNSTF4 0
GTF4 $885
ADDRGP4 $874
JUMPV
LABELV $885
line 1453
;1452:		//
;1453:		return i;
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $872
JUMPV
LABELV $874
line 1439
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $876
ADDRLP4 0
INDIRI4
ADDRGP4 maxclients
INDIRI4
GEI4 $887
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $873
LABELV $887
line 1455
;1454:	}
;1455:	return -1;
CNSTI4 -1
RETI4
LABELV $872
endproc BotTeamFlagCarrierVisible 164 20
lit
align 4
LABELV $889
byte 4 3229614080
byte 4 3229614080
byte 4 3229614080
align 4
LABELV $890
byte 4 1082130432
byte 4 1082130432
byte 4 1082130432
export BotAimAtEnemy
code
proc BotAimAtEnemy 1148 52
line 1463
;1456:}
;1457:
;1458:/*
;1459:==================
;1460:BotAimAtEnemy
;1461:==================
;1462:*/
;1463:void BotAimAtEnemy(bot_state_t *bs) {
line 1467
;1464:	int i, enemyvisible;
;1465:	float dist, f, aim_skill, aim_accuracy, speed, reactiontime;
;1466:	vec3_t dir, bestorigin, end, start, groundtarget, cmdmove, enemyvelocity;
;1467:	vec3_t mins = {-4,-4,-4}, maxs = {4, 4, 4};
ADDRLP4 848
ADDRGP4 $889
INDIRB
ASGNB 12
ADDRLP4 860
ADDRGP4 $890
INDIRB
ASGNB 12
line 1475
;1468:	weaponinfo_t wi;
;1469:	aas_entityinfo_t entinfo;
;1470:	bot_goal_t goal;
;1471:	bsp_trace_t trace;
;1472:	vec3_t target;
;1473:
;1474:	//if the bot has no enemy
;1475:	if (bs->enemy < 0) return;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
GEI4 $891
ADDRGP4 $888
JUMPV
LABELV $891
line 1479
;1476:	//
;1477:	//BotAI_Print(PRT_MESSAGE, "client %d: aiming at client %d\n", bs->entitynum, bs->enemy);
;1478:	//
;1479:	aim_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_SKILL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 16
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 984
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 736
ADDRLP4 984
INDIRF4
ASGNF4
line 1480
;1480:	aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 7
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 988
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 988
INDIRF4
ASGNF4
line 1482
;1481:	//
;1482:	if (aim_skill > 0.95) {
ADDRLP4 736
INDIRF4
CNSTF4 1064514355
LEF4 $893
line 1484
;1483:		//don't aim too early
;1484:		reactiontime = 0.5 * trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_REACTIONTIME, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 6
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 992
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 844
CNSTF4 1056964608
ADDRLP4 992
INDIRF4
MULF4
ASGNF4
line 1485
;1485:		if (bs->enemysight_time > trap_AAS_Time() - reactiontime) return;
ADDRLP4 996
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6096
ADDP4
INDIRF4
ADDRLP4 996
INDIRF4
ADDRLP4 844
INDIRF4
SUBF4
LEF4 $895
ADDRGP4 $888
JUMPV
LABELV $895
line 1486
;1486:		if (bs->teleport_time > trap_AAS_Time() - reactiontime) return;
ADDRLP4 1000
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6144
ADDP4
INDIRF4
ADDRLP4 1000
INDIRF4
ADDRLP4 844
INDIRF4
SUBF4
LEF4 $897
ADDRGP4 $888
JUMPV
LABELV $897
line 1487
;1487:	}
LABELV $893
line 1490
;1488:
;1489:	//get the weapon information
;1490:	trap_BotGetWeaponInfo(bs->ws, bs->weaponnum, &wi);
ADDRLP4 992
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 992
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRLP4 992
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 trap_BotGetWeaponInfo
CALLV
pop
line 1492
;1491:	//get the weapon specific aim accuracy and or aim skill
;1492:	if (wi.number == WP_MACHINEGUN) {
ADDRLP4 4+4
INDIRI4
CNSTI4 2
NEI4 $899
line 1493
;1493:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_MACHINEGUN, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 8
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1494
;1494:	}
LABELV $899
line 1495
;1495:	if (wi.number == WP_SHOTGUN) {
ADDRLP4 4+4
INDIRI4
CNSTI4 3
NEI4 $902
line 1496
;1496:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_SHOTGUN, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 9
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1497
;1497:	}
LABELV $902
line 1498
;1498:	if (wi.number == WP_GRENADE_LAUNCHER) {
ADDRLP4 4+4
INDIRI4
CNSTI4 4
NEI4 $905
line 1499
;1499:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_GRENADELAUNCHER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 11
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1500
;1500:		aim_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_SKILL_GRENADELAUNCHER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 18
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 1000
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 736
ADDRLP4 1000
INDIRF4
ASGNF4
line 1501
;1501:	}
LABELV $905
line 1502
;1502:	if (wi.number == WP_ROCKET_LAUNCHER) {
ADDRLP4 4+4
INDIRI4
CNSTI4 5
NEI4 $908
line 1503
;1503:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_ROCKETLAUNCHER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 10
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1504
;1504:		aim_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_SKILL_ROCKETLAUNCHER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 17
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 1000
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 736
ADDRLP4 1000
INDIRF4
ASGNF4
line 1505
;1505:	}
LABELV $908
line 1506
;1506:	if (wi.number == WP_LIGHTNING) {
ADDRLP4 4+4
INDIRI4
CNSTI4 6
NEI4 $911
line 1507
;1507:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_LIGHTNING, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 12
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1508
;1508:	}
LABELV $911
line 1509
;1509:	if (wi.number == WP_RAILGUN) {
ADDRLP4 4+4
INDIRI4
CNSTI4 7
NEI4 $914
line 1510
;1510:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_RAILGUN, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 14
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1511
;1511:	}
LABELV $914
line 1512
;1512:	if (wi.number == WP_PLASMAGUN) {
ADDRLP4 4+4
INDIRI4
CNSTI4 8
NEI4 $917
line 1513
;1513:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_PLASMAGUN, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 13
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1514
;1514:		aim_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_SKILL_PLASMAGUN, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 19
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 1000
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 736
ADDRLP4 1000
INDIRF4
ASGNF4
line 1515
;1515:	}
LABELV $917
line 1516
;1516:	if (wi.number == WP_BFG) {
ADDRLP4 4+4
INDIRI4
CNSTI4 9
NEI4 $920
line 1517
;1517:		aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY_BFG10K, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 15
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 996
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 996
INDIRF4
ASGNF4
line 1518
;1518:		aim_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_SKILL_BFG10K, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 20
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 1000
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 736
ADDRLP4 1000
INDIRF4
ASGNF4
line 1519
;1519:	}
LABELV $920
line 1521
;1520:	//
;1521:	if (aim_accuracy <= 0) aim_accuracy = 0.0001;
ADDRLP4 0
INDIRF4
CNSTF4 0
GTF4 $923
ADDRLP4 0
CNSTF4 953267991
ASGNF4
LABELV $923
line 1523
;1522:	//get the enemy entity information
;1523:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 556
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1525
;1524:	//if the enemy is invisible then shoot crappy most of the time
;1525:	if (EntityIsInvisible(&entinfo)) {
ADDRLP4 556
ARGP4
ADDRLP4 996
ADDRGP4 EntityIsInvisible
CALLI4
ASGNI4
ADDRLP4 996
INDIRI4
CNSTI4 0
EQI4 $925
line 1526
;1526:		if (random() > 0.1) aim_accuracy *= 0.4;
ADDRLP4 1000
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1000
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1036831949
LEF4 $927
ADDRLP4 0
CNSTF4 1053609165
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
LABELV $927
line 1527
;1527:	}
LABELV $925
line 1529
;1528:	//
;1529:	VectorSubtract(entinfo.origin, entinfo.lastvisorigin, enemyvelocity);
ADDRLP4 712
ADDRLP4 556+24
INDIRF4
ADDRLP4 556+60
INDIRF4
SUBF4
ASGNF4
ADDRLP4 712+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 556+60+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 712+8
ADDRLP4 556+24+8
INDIRF4
ADDRLP4 556+60+8
INDIRF4
SUBF4
ASGNF4
line 1530
;1530:	VectorScale(enemyvelocity, 1 / entinfo.update_time, enemyvelocity);
ADDRLP4 1000
CNSTF4 1065353216
ASGNF4
ADDRLP4 712
ADDRLP4 712
INDIRF4
ADDRLP4 1000
INDIRF4
ADDRLP4 556+16
INDIRF4
DIVF4
MULF4
ASGNF4
ADDRLP4 712+4
ADDRLP4 712+4
INDIRF4
ADDRLP4 1000
INDIRF4
ADDRLP4 556+16
INDIRF4
DIVF4
MULF4
ASGNF4
ADDRLP4 712+8
ADDRLP4 712+8
INDIRF4
CNSTF4 1065353216
ADDRLP4 556+16
INDIRF4
DIVF4
MULF4
ASGNF4
line 1532
;1531:	//enemy origin and velocity is remembered every 0.5 seconds
;1532:	if (bs->enemyposition_time < trap_AAS_Time()) {
ADDRLP4 1004
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6104
ADDP4
INDIRF4
ADDRLP4 1004
INDIRF4
GEF4 $948
line 1534
;1533:		//
;1534:		bs->enemyposition_time = trap_AAS_Time() + 0.5;
ADDRLP4 1008
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6104
ADDP4
ADDRLP4 1008
INDIRF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 1535
;1535:		VectorCopy(enemyvelocity, bs->enemyvelocity);
ADDRFP4 0
INDIRP4
CNSTI4 6184
ADDP4
ADDRLP4 712
INDIRB
ASGNB 12
line 1536
;1536:		VectorCopy(entinfo.origin, bs->enemyorigin);
ADDRFP4 0
INDIRP4
CNSTI4 6196
ADDP4
ADDRLP4 556+24
INDIRB
ASGNB 12
line 1537
;1537:	}
LABELV $948
line 1539
;1538:	//if not extremely skilled
;1539:	if (aim_skill < 0.9) {
ADDRLP4 736
INDIRF4
CNSTF4 1063675494
GEF4 $951
line 1540
;1540:		VectorSubtract(entinfo.origin, bs->enemyorigin, dir);
ADDRLP4 1008
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 556+24
INDIRF4
ADDRLP4 1008
INDIRP4
CNSTI4 6196
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 1008
INDIRP4
CNSTI4 6200
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 556+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 6204
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1542
;1541:		//if the enemy moved a bit
;1542:		if (VectorLength(dir) > 48) {
ADDRLP4 696
ARGP4
ADDRLP4 1012
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 1012
INDIRF4
CNSTF4 1111490560
LEF4 $960
line 1544
;1543:			//if the enemy changed direction
;1544:			if (DotProduct(bs->enemyvelocity, enemyvelocity) < 0) {
ADDRLP4 1016
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1016
INDIRP4
CNSTI4 6184
ADDP4
INDIRF4
ADDRLP4 712
INDIRF4
MULF4
ADDRLP4 1016
INDIRP4
CNSTI4 6188
ADDP4
INDIRF4
ADDRLP4 712+4
INDIRF4
MULF4
ADDF4
ADDRLP4 1016
INDIRP4
CNSTI4 6192
ADDP4
INDIRF4
ADDRLP4 712+8
INDIRF4
MULF4
ADDF4
CNSTF4 0
GEF4 $962
line 1546
;1545:				//aim accuracy should be worse now
;1546:				aim_accuracy *= 0.7;
ADDRLP4 0
CNSTF4 1060320051
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
line 1547
;1547:			}
LABELV $962
line 1548
;1548:		}
LABELV $960
line 1549
;1549:	}
LABELV $951
line 1551
;1550:	//check visibility of enemy
;1551:	enemyvisible = BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->enemy);
ADDRLP4 1008
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1008
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 1008
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 1008
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 1008
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 1012
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 824
ADDRLP4 1012
INDIRF4
CVFI4 4
ASGNI4
line 1553
;1552:	//if the enemy is visible
;1553:	if (enemyvisible) {
ADDRLP4 824
INDIRI4
CNSTI4 0
EQI4 $966
line 1555
;1554:		//
;1555:		VectorCopy(entinfo.origin, bestorigin);
ADDRLP4 724
ADDRLP4 556+24
INDIRB
ASGNB 12
line 1556
;1556:		bestorigin[2] += 8;
ADDRLP4 724+8
ADDRLP4 724+8
INDIRF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 1559
;1557:		//get the start point shooting from
;1558:		//NOTE: the x and y projectile start offsets are ignored
;1559:		VectorCopy(bs->origin, start);
ADDRLP4 832
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 1560
;1560:		start[2] += bs->cur_ps.viewheight;
ADDRLP4 832+8
ADDRLP4 832+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 1561
;1561:		start[2] += wi.offset[2];
ADDRLP4 832+8
ADDRLP4 832+8
INDIRF4
ADDRLP4 4+292+8
INDIRF4
ADDF4
ASGNF4
line 1563
;1562:		//
;1563:		BotAI_Trace(&trace, start, mins, maxs, bestorigin, bs->entitynum, MASK_SHOT);
ADDRLP4 740
ARGP4
ADDRLP4 832
ARGP4
ADDRLP4 848
ARGP4
ADDRLP4 860
ARGP4
ADDRLP4 724
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1565
;1564:		//if the enemy is NOT hit
;1565:		if (trace.fraction <= 1 && trace.ent != entinfo.number) {
ADDRLP4 740+8
INDIRF4
CNSTF4 1065353216
GTF4 $974
ADDRLP4 740+80
INDIRI4
ADDRLP4 556+20
INDIRI4
EQI4 $974
line 1566
;1566:			bestorigin[2] += 16;
ADDRLP4 724+8
ADDRLP4 724+8
INDIRF4
CNSTF4 1098907648
ADDF4
ASGNF4
line 1567
;1567:		}
LABELV $974
line 1569
;1568:		//if it is not an instant hit weapon the bot might want to predict the enemy
;1569:		if (wi.speed) {
ADDRLP4 4+272
INDIRF4
CNSTF4 0
EQF4 $980
line 1571
;1570:			//
;1571:			VectorSubtract(bestorigin, bs->origin, dir);
ADDRLP4 1016
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 724
INDIRF4
ADDRLP4 1016
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 724+4
INDIRF4
ADDRLP4 1016
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 724+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1572
;1572:			dist = VectorLength(dir);
ADDRLP4 696
ARGP4
ADDRLP4 1020
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 828
ADDRLP4 1020
INDIRF4
ASGNF4
line 1573
;1573:			VectorSubtract(entinfo.origin, bs->enemyorigin, dir);
ADDRLP4 1024
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 556+24
INDIRF4
ADDRLP4 1024
INDIRP4
CNSTI4 6196
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 1024
INDIRP4
CNSTI4 6200
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 556+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 6204
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1575
;1574:			//if the enemy is NOT pretty far away and strafing just small steps left and right
;1575:			if (!(dist > 100 && VectorLength(dir) < 32)) {
ADDRLP4 828
INDIRF4
CNSTF4 1120403456
LEF4 $996
ADDRLP4 696
ARGP4
ADDRLP4 1028
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 1028
INDIRF4
CNSTF4 1107296256
LTF4 $994
LABELV $996
line 1577
;1576:				//if skilled anough do exact prediction
;1577:				if (aim_skill > 0.8 &&
ADDRLP4 736
INDIRF4
CNSTF4 1061997773
LEF4 $997
ADDRFP4 0
INDIRP4
CNSTI4 164
ADDP4
INDIRI4
CNSTI4 0
NEI4 $997
line 1579
;1578:						//if the weapon is ready to fire
;1579:						bs->cur_ps.weaponstate == WEAPON_READY) {
line 1583
;1580:					aas_clientmove_t move;
;1581:					vec3_t origin;
;1582:
;1583:					VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 1128
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 556+24
INDIRF4
ADDRLP4 1128
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 1128
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 556+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1585
;1584:					//distance towards the enemy
;1585:					dist = VectorLength(dir);
ADDRLP4 696
ARGP4
ADDRLP4 1132
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 828
ADDRLP4 1132
INDIRF4
ASGNF4
line 1587
;1586:					//direction the enemy is moving in
;1587:					VectorSubtract(entinfo.origin, entinfo.lastvisorigin, dir);
ADDRLP4 696
ADDRLP4 556+24
INDIRF4
ADDRLP4 556+60
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 556+60+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 556+24+8
INDIRF4
ADDRLP4 556+60+8
INDIRF4
SUBF4
ASGNF4
line 1589
;1588:					//
;1589:					VectorScale(dir, 1 / entinfo.update_time, dir);
ADDRLP4 1136
CNSTF4 1065353216
ASGNF4
ADDRLP4 696
ADDRLP4 696
INDIRF4
ADDRLP4 1136
INDIRF4
ADDRLP4 556+16
INDIRF4
DIVF4
MULF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 696+4
INDIRF4
ADDRLP4 1136
INDIRF4
ADDRLP4 556+16
INDIRF4
DIVF4
MULF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 696+8
INDIRF4
CNSTF4 1065353216
ADDRLP4 556+16
INDIRF4
DIVF4
MULF4
ASGNF4
line 1591
;1590:					//
;1591:					VectorCopy(entinfo.origin, origin);
ADDRLP4 1032
ADDRLP4 556+24
INDIRB
ASGNB 12
line 1592
;1592:					origin[2] += 1;
ADDRLP4 1032+8
ADDRLP4 1032+8
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1594
;1593:					//
;1594:					VectorClear(cmdmove);
ADDRLP4 1140
CNSTF4 0
ASGNF4
ADDRLP4 968+8
ADDRLP4 1140
INDIRF4
ASGNF4
ADDRLP4 968+4
ADDRLP4 1140
INDIRF4
ASGNF4
ADDRLP4 968
ADDRLP4 1140
INDIRF4
ASGNF4
line 1596
;1595:					//AAS_ClearShownDebugLines();
;1596:					trap_AAS_PredictClientMovement(&move, bs->enemy, origin,
ADDRLP4 1044
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 1032
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 1144
CNSTI4 0
ASGNI4
ADDRLP4 1144
INDIRI4
ARGI4
ADDRLP4 696
ARGP4
ADDRLP4 968
ARGP4
ADDRLP4 1144
INDIRI4
ARGI4
CNSTF4 1092616192
ADDRLP4 828
INDIRF4
MULF4
ADDRLP4 4+272
INDIRF4
DIVF4
CVFI4 4
ARGI4
CNSTF4 1036831949
ARGF4
ADDRLP4 1144
INDIRI4
ARGI4
ADDRLP4 1144
INDIRI4
ARGI4
ADDRLP4 1144
INDIRI4
ARGI4
ADDRGP4 trap_AAS_PredictClientMovement
CALLI4
pop
line 1600
;1597:														PRESENCE_CROUCH, qfalse,
;1598:														dir, cmdmove, 0,
;1599:														dist * 10 / wi.speed, 0.1, 0, 0, qfalse);
;1600:					VectorCopy(move.endpos, bestorigin);
ADDRLP4 724
ADDRLP4 1044
INDIRB
ASGNB 12
line 1602
;1601:					//BotAI_Print(PRT_MESSAGE, "%1.1f predicted speed = %f, frames = %f\n", trap_AAS_Time(), VectorLength(dir), dist * 10 / wi.speed);
;1602:				}
ADDRGP4 $998
JUMPV
LABELV $997
line 1604
;1603:				//if not that skilled do linear prediction
;1604:				else if (aim_skill > 0.4) {
ADDRLP4 736
INDIRF4
CNSTF4 1053609165
LEF4 $1030
line 1605
;1605:					VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 1032
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 556+24
INDIRF4
ADDRLP4 1032
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 1032
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 556+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1607
;1606:					//distance towards the enemy
;1607:					dist = VectorLength(dir);
ADDRLP4 696
ARGP4
ADDRLP4 1036
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 828
ADDRLP4 1036
INDIRF4
ASGNF4
line 1609
;1608:					//direction the enemy is moving in
;1609:					VectorSubtract(entinfo.origin, entinfo.lastvisorigin, dir);
ADDRLP4 696
ADDRLP4 556+24
INDIRF4
ADDRLP4 556+60
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 556+60+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 556+24+8
INDIRF4
ADDRLP4 556+60+8
INDIRF4
SUBF4
ASGNF4
line 1610
;1610:					dir[2] = 0;
ADDRLP4 696+8
CNSTF4 0
ASGNF4
line 1612
;1611:					//
;1612:					speed = VectorNormalize(dir) / entinfo.update_time;
ADDRLP4 696
ARGP4
ADDRLP4 1040
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 980
ADDRLP4 1040
INDIRF4
ADDRLP4 556+16
INDIRF4
DIVF4
ASGNF4
line 1615
;1613:					//botimport.Print(PRT_MESSAGE, "speed = %f, wi->speed = %f\n", speed, wi->speed);
;1614:					//best spot to aim at
;1615:					VectorMA(entinfo.origin, (dist / wi.speed) * speed, dir, bestorigin);
ADDRLP4 1044
ADDRLP4 828
INDIRF4
ASGNF4
ADDRLP4 1048
ADDRLP4 980
INDIRF4
ASGNF4
ADDRLP4 724
ADDRLP4 556+24
INDIRF4
ADDRLP4 696
INDIRF4
ADDRLP4 1044
INDIRF4
ADDRLP4 4+272
INDIRF4
DIVF4
ADDRLP4 1048
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 724+4
ADDRLP4 556+24+4
INDIRF4
ADDRLP4 696+4
INDIRF4
ADDRLP4 1044
INDIRF4
ADDRLP4 4+272
INDIRF4
DIVF4
ADDRLP4 1048
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 724+8
ADDRLP4 556+24+8
INDIRF4
ADDRLP4 696+8
INDIRF4
ADDRLP4 828
INDIRF4
ADDRLP4 4+272
INDIRF4
DIVF4
ADDRLP4 980
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1616
;1616:				}
LABELV $1030
LABELV $998
line 1617
;1617:			}
LABELV $994
line 1618
;1618:		}
LABELV $980
line 1620
;1619:		//if the projectile does radial damage
;1620:		if (aim_skill > 0.6 && wi.proj.damagetype & DAMAGETYPE_RADIAL) {
ADDRLP4 736
INDIRF4
CNSTF4 1058642330
LEF4 $1065
ADDRLP4 4+344+180
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $1065
line 1622
;1621:			//if the enemy isn't standing significantly higher than the bot
;1622:			if (entinfo.origin[2] < bs->origin[2] + 16) {
ADDRLP4 556+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
CNSTF4 1098907648
ADDF4
GEF4 $1069
line 1624
;1623:				//try to aim at the ground in front of the enemy
;1624:				VectorCopy(entinfo.origin, end);
ADDRLP4 944
ADDRLP4 556+24
INDIRB
ASGNB 12
line 1625
;1625:				end[2] -= 64;
ADDRLP4 944+8
ADDRLP4 944+8
INDIRF4
CNSTF4 1115684864
SUBF4
ASGNF4
line 1626
;1626:				BotAI_Trace(&trace, entinfo.origin, NULL, NULL, end, entinfo.number, MASK_SHOT);
ADDRLP4 740
ARGP4
ADDRLP4 556+24
ARGP4
ADDRLP4 1016
CNSTP4 0
ASGNP4
ADDRLP4 1016
INDIRP4
ARGP4
ADDRLP4 1016
INDIRP4
ARGP4
ADDRLP4 944
ARGP4
ADDRLP4 556+20
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1628
;1627:				//
;1628:				VectorCopy(bestorigin, groundtarget);
ADDRLP4 932
ADDRLP4 724
INDIRB
ASGNB 12
line 1629
;1629:				if (trace.startsolid) groundtarget[2] = entinfo.origin[2] - 16;
ADDRLP4 740+4
INDIRI4
CNSTI4 0
EQI4 $1077
ADDRLP4 932+8
ADDRLP4 556+24+8
INDIRF4
CNSTF4 1098907648
SUBF4
ASGNF4
ADDRGP4 $1078
JUMPV
LABELV $1077
line 1630
;1630:				else groundtarget[2] = trace.endpos[2] - 8;
ADDRLP4 932+8
ADDRLP4 740+12+8
INDIRF4
CNSTF4 1090519040
SUBF4
ASGNF4
LABELV $1078
line 1632
;1631:				//trace a line from projectile start to ground target
;1632:				BotAI_Trace(&trace, start, NULL, NULL, groundtarget, bs->entitynum, MASK_SHOT);
ADDRLP4 740
ARGP4
ADDRLP4 832
ARGP4
ADDRLP4 1020
CNSTP4 0
ASGNP4
ADDRLP4 1020
INDIRP4
ARGP4
ADDRLP4 1020
INDIRP4
ARGP4
ADDRLP4 932
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1634
;1633:				//if hitpoint is not vertically too far from the ground target
;1634:				if (fabs(trace.endpos[2] - groundtarget[2]) < 50) {
ADDRLP4 740+12+8
INDIRF4
ADDRLP4 932+8
INDIRF4
SUBF4
ARGF4
ADDRLP4 1024
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 1024
INDIRF4
CNSTF4 1112014848
GEF4 $1086
line 1635
;1635:					VectorSubtract(trace.endpos, groundtarget, dir);
ADDRLP4 696
ADDRLP4 740+12
INDIRF4
ADDRLP4 932
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 740+12+4
INDIRF4
ADDRLP4 932+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 740+12+8
INDIRF4
ADDRLP4 932+8
INDIRF4
SUBF4
ASGNF4
line 1637
;1636:					//if the hitpoint is near anough the ground target
;1637:					if (VectorLength(dir) < 60) {
ADDRLP4 696
ARGP4
ADDRLP4 1028
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 1028
INDIRF4
CNSTF4 1114636288
GEF4 $1100
line 1638
;1638:						VectorSubtract(trace.endpos, start, dir);
ADDRLP4 696
ADDRLP4 740+12
INDIRF4
ADDRLP4 832
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 740+12+4
INDIRF4
ADDRLP4 832+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 740+12+8
INDIRF4
ADDRLP4 832+8
INDIRF4
SUBF4
ASGNF4
line 1640
;1639:						//if the hitpoint is far anough from the bot
;1640:						if (VectorLength(dir) > 100) {
ADDRLP4 696
ARGP4
ADDRLP4 1032
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 1032
INDIRF4
CNSTF4 1120403456
LEF4 $1111
line 1642
;1641:							//check if the bot is visible from the ground target
;1642:							trace.endpos[2] += 1;
ADDRLP4 740+12+8
ADDRLP4 740+12+8
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1643
;1643:							BotAI_Trace(&trace, trace.endpos, NULL, NULL, entinfo.origin, entinfo.number, MASK_SHOT);
ADDRLP4 740
ARGP4
ADDRLP4 740+12
ARGP4
ADDRLP4 1036
CNSTP4 0
ASGNP4
ADDRLP4 1036
INDIRP4
ARGP4
ADDRLP4 1036
INDIRP4
ARGP4
ADDRLP4 556+24
ARGP4
ADDRLP4 556+20
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1644
;1644:							if (trace.fraction >= 1) {
ADDRLP4 740+8
INDIRF4
CNSTF4 1065353216
LTF4 $1118
line 1646
;1645:								//botimport.Print(PRT_MESSAGE, "%1.1f aiming at ground\n", AAS_Time());
;1646:								VectorCopy(groundtarget, bestorigin);
ADDRLP4 724
ADDRLP4 932
INDIRB
ASGNB 12
line 1647
;1647:							}
LABELV $1118
line 1648
;1648:						}
LABELV $1111
line 1649
;1649:					}
LABELV $1100
line 1650
;1650:				}
LABELV $1086
line 1651
;1651:			}
LABELV $1069
line 1652
;1652:		}
LABELV $1065
line 1653
;1653:		bestorigin[0] += 20 * crandom() * (1 - aim_accuracy);
ADDRLP4 1016
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 724
ADDRLP4 724
INDIRF4
CNSTF4 1101004800
CNSTF4 1073741824
ADDRLP4 1016
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1654
;1654:		bestorigin[1] += 20 * crandom() * (1 - aim_accuracy);
ADDRLP4 1020
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 724+4
ADDRLP4 724+4
INDIRF4
CNSTF4 1101004800
CNSTF4 1073741824
ADDRLP4 1020
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1655
;1655:		bestorigin[2] += 10 * crandom() * (1 - aim_accuracy);
ADDRLP4 1024
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 724+8
ADDRLP4 724+8
INDIRF4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 1024
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1656
;1656:	}
ADDRGP4 $967
JUMPV
LABELV $966
line 1657
;1657:	else {
line 1659
;1658:		//
;1659:		VectorCopy(bs->lastenemyorigin, bestorigin);
ADDRLP4 724
ADDRFP4 0
INDIRP4
CNSTI4 6236
ADDP4
INDIRB
ASGNB 12
line 1660
;1660:		bestorigin[2] += 8;
ADDRLP4 724+8
ADDRLP4 724+8
INDIRF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 1662
;1661:		//if the bot is skilled anough
;1662:		if (aim_skill > 0.5) {
ADDRLP4 736
INDIRF4
CNSTF4 1056964608
LEF4 $1124
line 1664
;1663:			//do prediction shots around corners
;1664:			if (wi.number == WP_BFG ||
ADDRLP4 4+4
INDIRI4
CNSTI4 9
EQI4 $1132
ADDRLP4 4+4
INDIRI4
CNSTI4 5
EQI4 $1132
ADDRLP4 4+4
INDIRI4
CNSTI4 4
NEI4 $1126
LABELV $1132
line 1666
;1665:				wi.number == WP_ROCKET_LAUNCHER ||
;1666:				wi.number == WP_GRENADE_LAUNCHER) {
line 1668
;1667:				//create the chase goal
;1668:				goal.entitynum = bs->client;
ADDRLP4 872+40
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 1669
;1669:				goal.areanum = bs->areanum;
ADDRLP4 872+12
ADDRFP4 0
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ASGNI4
line 1670
;1670:				VectorCopy(bs->eye, goal.origin);
ADDRLP4 872
ADDRFP4 0
INDIRP4
CNSTI4 4912
ADDP4
INDIRB
ASGNB 12
line 1671
;1671:				VectorSet(goal.mins, -8, -8, -8);
ADDRLP4 872+16
CNSTF4 3238002688
ASGNF4
ADDRLP4 872+16+4
CNSTF4 3238002688
ASGNF4
ADDRLP4 872+16+8
CNSTF4 3238002688
ASGNF4
line 1672
;1672:				VectorSet(goal.maxs, 8, 8, 8);
ADDRLP4 872+28
CNSTF4 1090519040
ASGNF4
ADDRLP4 872+28+4
CNSTF4 1090519040
ASGNF4
ADDRLP4 872+28+8
CNSTF4 1090519040
ASGNF4
line 1674
;1673:				//
;1674:				if (trap_BotPredictVisiblePosition(bs->lastenemyorigin, bs->lastenemyareanum, &goal, TFL_DEFAULT, target)) {
ADDRLP4 1016
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1016
INDIRP4
CNSTI4 6236
ADDP4
ARGP4
ADDRLP4 1016
INDIRP4
CNSTI4 6232
ADDP4
INDIRI4
ARGI4
ADDRLP4 872
ARGP4
CNSTI4 18616254
ARGI4
ADDRLP4 956
ARGP4
ADDRLP4 1020
ADDRGP4 trap_BotPredictVisiblePosition
CALLI4
ASGNI4
ADDRLP4 1020
INDIRI4
CNSTI4 0
EQI4 $1145
line 1675
;1675:					VectorSubtract(target, bs->eye, dir);
ADDRLP4 1024
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 956
INDIRF4
ADDRLP4 1024
INDIRP4
CNSTI4 4912
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 956+4
INDIRF4
ADDRLP4 1024
INDIRP4
CNSTI4 4916
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 956+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4920
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1676
;1676:					if (VectorLength(dir) > 80) {
ADDRLP4 696
ARGP4
ADDRLP4 1028
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 1028
INDIRF4
CNSTF4 1117782016
LEF4 $1151
line 1677
;1677:						VectorCopy(target, bestorigin);
ADDRLP4 724
ADDRLP4 956
INDIRB
ASGNB 12
line 1678
;1678:						bestorigin[2] -= 20;
ADDRLP4 724+8
ADDRLP4 724+8
INDIRF4
CNSTF4 1101004800
SUBF4
ASGNF4
line 1679
;1679:					}
LABELV $1151
line 1680
;1680:				}
LABELV $1145
line 1681
;1681:				aim_accuracy = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 1682
;1682:			}
LABELV $1126
line 1683
;1683:		}
LABELV $1124
line 1684
;1684:	}
LABELV $967
line 1686
;1685:	//
;1686:	if (enemyvisible) {
ADDRLP4 824
INDIRI4
CNSTI4 0
EQI4 $1154
line 1687
;1687:		BotAI_Trace(&trace, bs->eye, NULL, NULL, bestorigin, bs->entitynum, MASK_SHOT);
ADDRLP4 740
ARGP4
ADDRLP4 1016
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1016
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 1020
CNSTP4 0
ASGNP4
ADDRLP4 1020
INDIRP4
ARGP4
ADDRLP4 1020
INDIRP4
ARGP4
ADDRLP4 724
ARGP4
ADDRLP4 1016
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1688
;1688:		VectorCopy(trace.endpos, bs->aimtarget);
ADDRFP4 0
INDIRP4
CNSTI4 6172
ADDP4
ADDRLP4 740+12
INDIRB
ASGNB 12
line 1689
;1689:	}
ADDRGP4 $1155
JUMPV
LABELV $1154
line 1690
;1690:	else {
line 1691
;1691:		VectorCopy(bestorigin, bs->aimtarget);
ADDRFP4 0
INDIRP4
CNSTI4 6172
ADDP4
ADDRLP4 724
INDIRB
ASGNB 12
line 1692
;1692:	}
LABELV $1155
line 1694
;1693:	//get aim direction
;1694:	VectorSubtract(bestorigin, bs->eye, dir);
ADDRLP4 1016
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 696
ADDRLP4 724
INDIRF4
ADDRLP4 1016
INDIRP4
CNSTI4 4912
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+4
ADDRLP4 724+4
INDIRF4
ADDRLP4 1016
INDIRP4
CNSTI4 4916
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 696+8
ADDRLP4 724+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4920
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1696
;1695:	//
;1696:	if (wi.number == WP_MACHINEGUN ||
ADDRLP4 4+4
INDIRI4
CNSTI4 2
EQI4 $1169
ADDRLP4 4+4
INDIRI4
CNSTI4 3
EQI4 $1169
ADDRLP4 4+4
INDIRI4
CNSTI4 6
EQI4 $1169
ADDRLP4 4+4
INDIRI4
CNSTI4 7
NEI4 $1161
LABELV $1169
line 1699
;1697:		wi.number == WP_SHOTGUN ||
;1698:		wi.number == WP_LIGHTNING ||
;1699:		wi.number == WP_RAILGUN) {
line 1701
;1700:		//distance towards the enemy
;1701:		dist = VectorLength(dir);
ADDRLP4 696
ARGP4
ADDRLP4 1020
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 828
ADDRLP4 1020
INDIRF4
ASGNF4
line 1702
;1702:		if (dist > 150) dist = 150;
ADDRLP4 828
INDIRF4
CNSTF4 1125515264
LEF4 $1170
ADDRLP4 828
CNSTF4 1125515264
ASGNF4
LABELV $1170
line 1703
;1703:		f = 0.6 + dist / 150 * 0.4;
ADDRLP4 928
CNSTF4 1053609165
ADDRLP4 828
INDIRF4
CNSTF4 1125515264
DIVF4
MULF4
CNSTF4 1058642330
ADDF4
ASGNF4
line 1704
;1704:		aim_accuracy *= f;
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 928
INDIRF4
MULF4
ASGNF4
line 1705
;1705:	}
LABELV $1161
line 1707
;1706:	//add some random stuff to the aim direction depending on the aim accuracy
;1707:	if (aim_accuracy < 0.8) {
ADDRLP4 0
INDIRF4
CNSTF4 1061997773
GEF4 $1172
line 1708
;1708:		VectorNormalize(dir);
ADDRLP4 696
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1709
;1709:		for (i = 0; i < 3; i++) dir[i] += 0.3 * crandom() * (1 - aim_accuracy);
ADDRLP4 708
CNSTI4 0
ASGNI4
LABELV $1174
ADDRLP4 1020
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1024
ADDRLP4 708
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 696
ADDP4
ASGNP4
ADDRLP4 1024
INDIRP4
ADDRLP4 1024
INDIRP4
INDIRF4
CNSTF4 1050253722
CNSTF4 1073741824
ADDRLP4 1020
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
LABELV $1175
ADDRLP4 708
ADDRLP4 708
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 708
INDIRI4
CNSTI4 3
LTI4 $1174
line 1710
;1710:	}
LABELV $1172
line 1712
;1711:	//set the ideal view angles
;1712:	vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 696
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1714
;1713:	//take the weapon spread into account for lower skilled bots
;1714:	bs->ideal_viewangles[PITCH] += 6 * wi.vspread * crandom() * (1 - aim_accuracy);
ADDRLP4 1020
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1024
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ASGNP4
ADDRLP4 1024
INDIRP4
ADDRLP4 1024
INDIRP4
INDIRF4
CNSTF4 1086324736
ADDRLP4 4+268
INDIRF4
MULF4
CNSTF4 1073741824
ADDRLP4 1020
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1715
;1715:	bs->ideal_viewangles[PITCH] = AngleMod(bs->ideal_viewangles[PITCH]);
ADDRLP4 1028
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ASGNP4
ADDRLP4 1028
INDIRP4
INDIRF4
ARGF4
ADDRLP4 1032
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 1028
INDIRP4
ADDRLP4 1032
INDIRF4
ASGNF4
line 1716
;1716:	bs->ideal_viewangles[YAW] += 6 * wi.hspread * crandom() * (1 - aim_accuracy);
ADDRLP4 1036
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1040
ADDRFP4 0
INDIRP4
CNSTI4 6268
ADDP4
ASGNP4
ADDRLP4 1040
INDIRP4
ADDRLP4 1040
INDIRP4
INDIRF4
CNSTF4 1086324736
ADDRLP4 4+264
INDIRF4
MULF4
CNSTF4 1073741824
ADDRLP4 1036
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1717
;1717:	bs->ideal_viewangles[YAW] = AngleMod(bs->ideal_viewangles[YAW]);
ADDRLP4 1044
ADDRFP4 0
INDIRP4
CNSTI4 6268
ADDP4
ASGNP4
ADDRLP4 1044
INDIRP4
INDIRF4
ARGF4
ADDRLP4 1048
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 1044
INDIRP4
ADDRLP4 1048
INDIRF4
ASGNF4
line 1719
;1718:	//if the bots should be really challenging
;1719:	if (bot_challenge.integer) {
ADDRGP4 bot_challenge+12
INDIRI4
CNSTI4 0
EQI4 $1180
line 1721
;1720:		//if the bot is really accurate and has the enemy in view for some time
;1721:		if (aim_accuracy > 0.9 && bs->enemysight_time < trap_AAS_Time() - 1) {
ADDRLP4 0
INDIRF4
CNSTF4 1063675494
LEF4 $1183
ADDRLP4 1052
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6096
ADDP4
INDIRF4
ADDRLP4 1052
INDIRF4
CNSTF4 1065353216
SUBF4
GEF4 $1183
line 1723
;1722:			//set the view angles directly
;1723:			if (bs->ideal_viewangles[PITCH] > 180) bs->ideal_viewangles[PITCH] -= 360;
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
INDIRF4
CNSTF4 1127481344
LEF4 $1185
ADDRLP4 1056
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ASGNP4
ADDRLP4 1056
INDIRP4
ADDRLP4 1056
INDIRP4
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
LABELV $1185
line 1724
;1724:			VectorCopy(bs->ideal_viewangles, bs->viewangles);
ADDRLP4 1060
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1060
INDIRP4
CNSTI4 6252
ADDP4
ADDRLP4 1060
INDIRP4
CNSTI4 6264
ADDP4
INDIRB
ASGNB 12
line 1725
;1725:			trap_EA_View(bs->client, bs->viewangles);
ADDRLP4 1064
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1064
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 1064
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRGP4 trap_EA_View
CALLV
pop
line 1726
;1726:		}
LABELV $1183
line 1727
;1727:	}
LABELV $1180
line 1728
;1728:}
LABELV $888
endproc BotAimAtEnemy 1148 52
lit
align 4
LABELV $1188
byte 4 3238002688
byte 4 3238002688
byte 4 3238002688
align 4
LABELV $1189
byte 4 1090519040
byte 4 1090519040
byte 4 1090519040
export BotCheckAttack
code
proc BotCheckAttack 1036 28
line 1735
;1729:
;1730:/*
;1731:==================
;1732:BotCheckAttack
;1733:==================
;1734:*/
;1735:void BotCheckAttack(bot_state_t *bs) {
line 1743
;1736:	float points, reactiontime, fov, firethrottle;
;1737:	bsp_trace_t bsptrace;
;1738:	//float selfpreservation;
;1739:	vec3_t forward, right, start, end, dir, angles;
;1740:	weaponinfo_t wi;
;1741:	bsp_trace_t trace;
;1742:	aas_entityinfo_t entinfo;
;1743:	vec3_t mins = {-8, -8, -8}, maxs = {8, 8, 8};
ADDRLP4 944
ADDRGP4 $1188
INDIRB
ASGNB 12
ADDRLP4 956
ADDRGP4 $1189
INDIRB
ASGNB 12
line 1745
;1744:
;1745:	if (bs->enemy < 0) return;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
GEI4 $1190
ADDRGP4 $1187
JUMPV
LABELV $1190
line 1747
;1746:	//
;1747:	reactiontime = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_REACTIONTIME, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 6
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 972
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 836
ADDRLP4 972
INDIRF4
ASGNF4
line 1748
;1748:	if (bs->enemysight_time > trap_AAS_Time() - reactiontime) return;
ADDRLP4 976
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6096
ADDP4
INDIRF4
ADDRLP4 976
INDIRF4
ADDRLP4 836
INDIRF4
SUBF4
LEF4 $1192
ADDRGP4 $1187
JUMPV
LABELV $1192
line 1749
;1749:	if (bs->teleport_time > trap_AAS_Time() - reactiontime) return;
ADDRLP4 980
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6144
ADDP4
INDIRF4
ADDRLP4 980
INDIRF4
ADDRLP4 836
INDIRF4
SUBF4
LEF4 $1194
ADDRGP4 $1187
JUMPV
LABELV $1194
line 1751
;1750:	//if changing weapons
;1751:	if (bs->weaponchange_time > trap_AAS_Time() - 0.1) return;
ADDRLP4 984
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6156
ADDP4
INDIRF4
ADDRLP4 984
INDIRF4
CNSTF4 1036831949
SUBF4
LEF4 $1196
ADDRGP4 $1187
JUMPV
LABELV $1196
line 1753
;1752:	//check fire throttle characteristic
;1753:	if (bs->firethrottlewait_time > trap_AAS_Time()) return;
ADDRLP4 988
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6160
ADDP4
INDIRF4
ADDRLP4 988
INDIRF4
LEF4 $1198
ADDRGP4 $1187
JUMPV
LABELV $1198
line 1754
;1754:	firethrottle = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_FIRETHROTTLE, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 47
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 992
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 928
ADDRLP4 992
INDIRF4
ASGNF4
line 1755
;1755:	if (bs->firethrottleshoot_time < trap_AAS_Time()) {
ADDRLP4 996
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6164
ADDP4
INDIRF4
ADDRLP4 996
INDIRF4
GEF4 $1200
line 1756
;1756:		if (random() > firethrottle) {
ADDRLP4 1000
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1000
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 928
INDIRF4
LEF4 $1202
line 1757
;1757:			bs->firethrottlewait_time = trap_AAS_Time() + firethrottle;
ADDRLP4 1004
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6160
ADDP4
ADDRLP4 1004
INDIRF4
ADDRLP4 928
INDIRF4
ADDF4
ASGNF4
line 1758
;1758:			bs->firethrottleshoot_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6164
ADDP4
CNSTF4 0
ASGNF4
line 1759
;1759:		}
ADDRGP4 $1203
JUMPV
LABELV $1202
line 1760
;1760:		else {
line 1761
;1761:			bs->firethrottleshoot_time = trap_AAS_Time() + 1 - firethrottle;
ADDRLP4 1004
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6164
ADDP4
ADDRLP4 1004
INDIRF4
CNSTF4 1065353216
ADDF4
ADDRLP4 928
INDIRF4
SUBF4
ASGNF4
line 1762
;1762:			bs->firethrottlewait_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6160
ADDP4
CNSTF4 0
ASGNF4
line 1763
;1763:		}
LABELV $1203
line 1764
;1764:	}
LABELV $1200
line 1766
;1765:	//
;1766:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 612
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1767
;1767:	VectorSubtract(entinfo.origin, bs->eye, dir);
ADDRLP4 1000
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 576
ADDRLP4 612+24
INDIRF4
ADDRLP4 1000
INDIRP4
CNSTI4 4912
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 576+4
ADDRLP4 612+24+4
INDIRF4
ADDRLP4 1000
INDIRP4
CNSTI4 4916
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 576+8
ADDRLP4 612+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4920
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1769
;1768:	//
;1769:	if (VectorLength(dir) < 100) fov = 120;
ADDRLP4 576
ARGP4
ADDRLP4 1004
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 1004
INDIRF4
CNSTF4 1120403456
GEF4 $1211
ADDRLP4 924
CNSTF4 1123024896
ASGNF4
ADDRGP4 $1212
JUMPV
LABELV $1211
line 1770
;1770:	else fov = 50;
ADDRLP4 924
CNSTF4 1112014848
ASGNF4
LABELV $1212
line 1777
;1771:	/*
;1772:	//if the enemy isn't visible
;1773:	if (!BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, fov, bs->enemy)) {
;1774:		//botimport.Print(PRT_MESSAGE, "enemy not visible\n");
;1775:		return;
;1776:	}*/
;1777:	vectoangles(dir, angles);
ADDRLP4 576
ARGP4
ADDRLP4 932
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1778
;1778:	if (!InFieldOfVision(bs->viewangles, fov, angles)) return;
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRLP4 924
INDIRF4
ARGF4
ADDRLP4 932
ARGP4
ADDRLP4 1008
ADDRGP4 InFieldOfVision
CALLI4
ASGNI4
ADDRLP4 1008
INDIRI4
CNSTI4 0
NEI4 $1213
ADDRGP4 $1187
JUMPV
LABELV $1213
line 1779
;1779:	BotAI_Trace(&bsptrace, bs->eye, NULL, NULL, bs->aimtarget, bs->client, CONTENTS_SOLID|CONTENTS_PLAYERCLIP);
ADDRLP4 840
ARGP4
ADDRLP4 1012
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1012
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 1016
CNSTP4 0
ASGNP4
ADDRLP4 1016
INDIRP4
ARGP4
ADDRLP4 1016
INDIRP4
ARGP4
ADDRLP4 1012
INDIRP4
CNSTI4 6172
ADDP4
ARGP4
ADDRLP4 1012
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 65537
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1780
;1780:	if (bsptrace.fraction < 1 && bsptrace.ent != bs->enemy) return;
ADDRLP4 840+8
INDIRF4
CNSTF4 1065353216
GEF4 $1215
ADDRLP4 840+80
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
EQI4 $1215
ADDRGP4 $1187
JUMPV
LABELV $1215
line 1783
;1781:
;1782:	//get the weapon info
;1783:	trap_BotGetWeaponInfo(bs->ws, bs->weaponnum, &wi);
ADDRLP4 1020
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1020
INDIRP4
CNSTI4 6224
ADDP4
INDIRI4
ARGI4
ADDRLP4 1020
INDIRP4
CNSTI4 6248
ADDP4
INDIRI4
ARGI4
ADDRLP4 24
ARGP4
ADDRGP4 trap_BotGetWeaponInfo
CALLV
pop
line 1785
;1784:	//get the start point shooting from
;1785:	VectorCopy(bs->origin, start);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 1786
;1786:	start[2] += bs->cur_ps.viewheight;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 1787
;1787:	AngleVectors(bs->viewangles, forward, right, NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 588
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 1788
;1788:	start[0] += forward[0] * wi.offset[0] + right[0] * wi.offset[1];
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
ADDRLP4 24+292
INDIRF4
MULF4
ADDRLP4 588
INDIRF4
ADDRLP4 24+292+4
INDIRF4
MULF4
ADDF4
ADDF4
ASGNF4
line 1789
;1789:	start[1] += forward[1] * wi.offset[0] + right[1] * wi.offset[1];
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDRLP4 24+292
INDIRF4
MULF4
ADDRLP4 588+4
INDIRF4
ADDRLP4 24+292+4
INDIRF4
MULF4
ADDF4
ADDF4
ASGNF4
line 1790
;1790:	start[2] += forward[2] * wi.offset[0] + right[2] * wi.offset[1] + wi.offset[2];
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDRLP4 24+292
INDIRF4
MULF4
ADDRLP4 588+8
INDIRF4
ADDRLP4 24+292+4
INDIRF4
MULF4
ADDF4
ADDRLP4 24+292+8
INDIRF4
ADDF4
ADDF4
ASGNF4
line 1792
;1791:	//end point aiming at
;1792:	VectorMA(start, 1000, forward, end);
ADDRLP4 1024
CNSTF4 1148846080
ASGNF4
ADDRLP4 600
ADDRLP4 0
INDIRF4
ADDRLP4 1024
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 600+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 1024
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 600+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1148846080
ADDRLP4 12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1794
;1793:	//a little back to make sure not inside a very close enemy
;1794:	VectorMA(start, -12, forward, start);
ADDRLP4 1028
CNSTF4 3242196992
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 1028
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 1028
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 3242196992
ADDRLP4 12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1795
;1795:	BotAI_Trace(&trace, start, mins, maxs, end, bs->entitynum, MASK_SHOT);
ADDRLP4 752
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 944
ARGP4
ADDRLP4 956
ARGP4
ADDRLP4 600
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1797
;1796:	//if won't hit the enemy
;1797:	if (trace.ent != bs->enemy) {
ADDRLP4 752+80
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
EQI4 $1249
line 1799
;1798:		//if the entity is a client
;1799:		if (trace.ent > 0 && trace.ent <= MAX_CLIENTS) {
ADDRLP4 752+80
INDIRI4
CNSTI4 0
LEI4 $1252
ADDRLP4 752+80
INDIRI4
CNSTI4 128
GTI4 $1252
line 1801
;1800:			//if a teammate is hit
;1801:			if (BotSameTeam(bs, trace.ent)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 752+80
INDIRI4
ARGI4
ADDRLP4 1032
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 0
EQI4 $1256
ADDRGP4 $1187
JUMPV
LABELV $1256
line 1802
;1802:		}
LABELV $1252
line 1804
;1803:		//if the projectile does a radial damage
;1804:		if (wi.proj.damagetype & DAMAGETYPE_RADIAL) {
ADDRLP4 24+344+180
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $1259
line 1805
;1805:			if (trace.fraction * 1000 < wi.proj.radius) {
CNSTF4 1148846080
ADDRLP4 752+8
INDIRF4
MULF4
ADDRLP4 24+344+172
INDIRF4
GEF4 $1263
line 1806
;1806:				points = (wi.proj.damage - 0.5 * trace.fraction * 1000) * 0.5;
ADDRLP4 1032
CNSTF4 1056964608
ASGNF4
ADDRLP4 968
ADDRLP4 1032
INDIRF4
ADDRLP4 24+344+168
INDIRI4
CVIF4 4
CNSTF4 1148846080
ADDRLP4 1032
INDIRF4
ADDRLP4 752+8
INDIRF4
MULF4
MULF4
SUBF4
MULF4
ASGNF4
line 1807
;1807:				if (points > 0) {
ADDRLP4 968
INDIRF4
CNSTF4 0
LEF4 $1271
line 1810
;1808://					selfpreservation = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_SELFPRESERVATION, 0, 1);
;1809://					if (random() < selfpreservation) return;
;1810:					return;
ADDRGP4 $1187
JUMPV
LABELV $1271
line 1812
;1811:				}
;1812:			}
LABELV $1263
line 1814
;1813:			//FIXME: check if a teammate gets radial damage
;1814:		}
LABELV $1259
line 1815
;1815:	}
LABELV $1249
line 1817
;1816:	//if fire has to be release to activate weapon
;1817:	if (wi.flags & WFL_FIRERELEASED) {
ADDRLP4 24+176
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $1273
line 1818
;1818:		if (bs->flags & BFL_ATTACKED) {
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $1274
line 1819
;1819:			trap_EA_Attack(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Attack
CALLV
pop
line 1820
;1820:		}
line 1821
;1821:	}
ADDRGP4 $1274
JUMPV
LABELV $1273
line 1822
;1822:	else {
line 1823
;1823:		trap_EA_Attack(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Attack
CALLV
pop
line 1824
;1824:	}
LABELV $1274
line 1825
;1825:	bs->flags ^= BFL_ATTACKED;
ADDRLP4 1032
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 1032
INDIRP4
ADDRLP4 1032
INDIRP4
INDIRI4
CNSTI4 2
BXORI4
ASGNI4
line 1826
;1826:}
LABELV $1187
endproc BotCheckAttack 1036 28
lit
align 4
LABELV $1284
byte 4 1143930880
byte 4 1129054208
byte 4 1143472128
align 4
LABELV $1285
byte 4 1148256256
byte 4 1139408896
byte 4 1143603200
align 4
LABELV $1286
byte 4 1134034944
byte 4 1135607808
byte 4 1147535360
export BotMapScripts
code
proc BotMapScripts 1424 16
line 1833
;1827:
;1828:/*
;1829:==================
;1830:BotMapScripts
;1831:==================
;1832:*/
;1833:void BotMapScripts(bot_state_t *bs) {
line 1841
;1834:	char info[1024];
;1835:	char mapname[128];
;1836:	int i, shootbutton;
;1837:	float aim_accuracy;
;1838:	aas_entityinfo_t entinfo;
;1839:	vec3_t dir;
;1840:
;1841:	trap_GetServerinfo(info, sizeof(info));
ADDRLP4 272
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetServerinfo
CALLV
pop
line 1843
;1842:
;1843:	strncpy(mapname, Info_ValueForKey( info, "mapname" ), sizeof(mapname)-1);
ADDRLP4 272
ARGP4
ADDRGP4 $1279
ARGP4
ADDRLP4 1316
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 144
ARGP4
ADDRLP4 1316
INDIRP4
ARGP4
CNSTU4 127
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 1844
;1844:	mapname[sizeof(mapname)-1] = '\0';
ADDRLP4 144+127
CNSTI1 0
ASGNI1
line 1846
;1845:
;1846:	if (!Q_stricmp(mapname, "q3tourney6")) {
ADDRLP4 144
ARGP4
ADDRGP4 $1283
ARGP4
ADDRLP4 1320
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1320
INDIRI4
CNSTI4 0
NEI4 $1281
line 1847
;1847:		vec3_t mins = {700, 204, 672}, maxs = {964, 468, 680};
ADDRLP4 1324
ADDRGP4 $1284
INDIRB
ASGNB 12
ADDRLP4 1336
ADDRGP4 $1285
INDIRB
ASGNB 12
line 1848
;1848:		vec3_t buttonorg = {304, 352, 920};
ADDRLP4 1348
ADDRGP4 $1286
INDIRB
ASGNB 12
line 1850
;1849:		//NOTE: NEVER use the func_bobbing in q3tourney6
;1850:		bs->tfl &= ~TFL_FUNCBOB;
ADDRLP4 1360
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 1360
INDIRP4
ADDRLP4 1360
INDIRP4
INDIRI4
CNSTI4 -16777217
BANDI4
ASGNI4
line 1852
;1851:		//if the bot is below the bounding box
;1852:		if (bs->origin[0] > mins[0] && bs->origin[0] < maxs[0]) {
ADDRLP4 1364
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
ASGNF4
ADDRLP4 1364
INDIRF4
ADDRLP4 1324
INDIRF4
LEF4 $1287
ADDRLP4 1364
INDIRF4
ADDRLP4 1336
INDIRF4
GEF4 $1287
line 1853
;1853:			if (bs->origin[1] > mins[1] && bs->origin[1] < maxs[1]) {
ADDRLP4 1368
ADDRFP4 0
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
ASGNF4
ADDRLP4 1368
INDIRF4
ADDRLP4 1324+4
INDIRF4
LEF4 $1289
ADDRLP4 1368
INDIRF4
ADDRLP4 1336+4
INDIRF4
GEF4 $1289
line 1854
;1854:				if (bs->origin[2] < mins[2]) {
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
ADDRLP4 1324+8
INDIRF4
GEF4 $1293
line 1855
;1855:					return;
ADDRGP4 $1278
JUMPV
LABELV $1293
line 1857
;1856:				}
;1857:			}
LABELV $1289
line 1858
;1858:		}
LABELV $1287
line 1859
;1859:		shootbutton = qfalse;
ADDRLP4 1296
CNSTI4 0
ASGNI4
line 1861
;1860:		//if an enemy is below this bounding box then shoot the button
;1861:		for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 140
CNSTI4 0
ASGNI4
ADDRGP4 $1299
JUMPV
LABELV $1296
line 1863
;1862:
;1863:			if (i == bs->client) continue;
ADDRLP4 140
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $1300
ADDRGP4 $1297
JUMPV
LABELV $1300
line 1865
;1864:			//
;1865:			BotEntityInfo(i, &entinfo);
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1867
;1866:			//
;1867:			if (!entinfo.valid) continue;
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $1302
ADDRGP4 $1297
JUMPV
LABELV $1302
line 1869
;1868:			//if the enemy isn't dead and the enemy isn't the bot self
;1869:			if (EntityIsDead(&entinfo) || entinfo.number == bs->entitynum) continue;
ADDRLP4 0
ARGP4
ADDRLP4 1368
ADDRGP4 EntityIsDead
CALLI4
ASGNI4
ADDRLP4 1368
INDIRI4
CNSTI4 0
NEI4 $1307
ADDRLP4 0+20
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
NEI4 $1304
LABELV $1307
ADDRGP4 $1297
JUMPV
LABELV $1304
line 1871
;1870:			//
;1871:			if (entinfo.origin[0] > mins[0] && entinfo.origin[0] < maxs[0]) {
ADDRLP4 0+24
INDIRF4
ADDRLP4 1324
INDIRF4
LEF4 $1308
ADDRLP4 0+24
INDIRF4
ADDRLP4 1336
INDIRF4
GEF4 $1308
line 1872
;1872:				if (entinfo.origin[1] > mins[1] && entinfo.origin[1] < maxs[1]) {
ADDRLP4 0+24+4
INDIRF4
ADDRLP4 1324+4
INDIRF4
LEF4 $1312
ADDRLP4 0+24+4
INDIRF4
ADDRLP4 1336+4
INDIRF4
GEF4 $1312
line 1873
;1873:					if (entinfo.origin[2] < mins[2]) {
ADDRLP4 0+24+8
INDIRF4
ADDRLP4 1324+8
INDIRF4
GEF4 $1320
line 1875
;1874:						//if there's a team mate below the crusher
;1875:						if (BotSameTeam(bs, i)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 1372
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1372
INDIRI4
CNSTI4 0
EQI4 $1325
line 1876
;1876:							shootbutton = qfalse;
ADDRLP4 1296
CNSTI4 0
ASGNI4
line 1877
;1877:							break;
ADDRGP4 $1298
JUMPV
LABELV $1325
line 1879
;1878:						}
;1879:						else {
line 1880
;1880:							shootbutton = qtrue;
ADDRLP4 1296
CNSTI4 1
ASGNI4
line 1881
;1881:						}
line 1882
;1882:					}
LABELV $1320
line 1883
;1883:				}
LABELV $1312
line 1884
;1884:			}
LABELV $1308
line 1885
;1885:		}
LABELV $1297
line 1861
ADDRLP4 140
ADDRLP4 140
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1299
ADDRLP4 140
INDIRI4
ADDRGP4 maxclients
INDIRI4
GEI4 $1327
ADDRLP4 140
INDIRI4
CNSTI4 128
LTI4 $1296
LABELV $1327
LABELV $1298
line 1886
;1886:		if (shootbutton) {
ADDRLP4 1296
INDIRI4
CNSTI4 0
EQI4 $1328
line 1887
;1887:			bs->flags |= BFL_IDEALVIEWSET;
ADDRLP4 1372
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 1372
INDIRP4
ADDRLP4 1372
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 1888
;1888:			VectorSubtract(buttonorg, bs->eye, dir);
ADDRLP4 1376
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1300
ADDRLP4 1348
INDIRF4
ADDRLP4 1376
INDIRP4
CNSTI4 4912
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1300+4
ADDRLP4 1348+4
INDIRF4
ADDRLP4 1376
INDIRP4
CNSTI4 4916
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1300+8
ADDRLP4 1348+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4920
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1889
;1889:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 1300
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1890
;1890:			aim_accuracy = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_AIM_ACCURACY, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 7
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 1380
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 1312
ADDRLP4 1380
INDIRF4
ASGNF4
line 1891
;1891:			bs->ideal_viewangles[PITCH] += 8 * crandom() * (1 - aim_accuracy);
ADDRLP4 1384
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1388
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ASGNP4
ADDRLP4 1388
INDIRP4
ADDRLP4 1388
INDIRP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 1384
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 1312
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1892
;1892:			bs->ideal_viewangles[PITCH] = AngleMod(bs->ideal_viewangles[PITCH]);
ADDRLP4 1392
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ASGNP4
ADDRLP4 1392
INDIRP4
INDIRF4
ARGF4
ADDRLP4 1396
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 1392
INDIRP4
ADDRLP4 1396
INDIRF4
ASGNF4
line 1893
;1893:			bs->ideal_viewangles[YAW] += 8 * crandom() * (1 - aim_accuracy);
ADDRLP4 1400
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1404
ADDRFP4 0
INDIRP4
CNSTI4 6268
ADDP4
ASGNP4
ADDRLP4 1404
INDIRP4
ADDRLP4 1404
INDIRP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 1400
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDRLP4 1312
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1894
;1894:			bs->ideal_viewangles[YAW] = AngleMod(bs->ideal_viewangles[YAW]);
ADDRLP4 1408
ADDRFP4 0
INDIRP4
CNSTI4 6268
ADDP4
ASGNP4
ADDRLP4 1408
INDIRP4
INDIRF4
ARGF4
ADDRLP4 1412
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRLP4 1408
INDIRP4
ADDRLP4 1412
INDIRF4
ASGNF4
line 1896
;1895:			//
;1896:			if (InFieldOfVision(bs->viewangles, 20, bs->ideal_viewangles)) {
ADDRLP4 1416
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1416
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1101004800
ARGF4
ADDRLP4 1416
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRLP4 1420
ADDRGP4 InFieldOfVision
CALLI4
ASGNI4
ADDRLP4 1420
INDIRI4
CNSTI4 0
EQI4 $1334
line 1897
;1897:				trap_EA_Attack(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Attack
CALLV
pop
line 1898
;1898:			}
LABELV $1334
line 1899
;1899:		}
LABELV $1328
line 1900
;1900:	}
LABELV $1281
line 1901
;1901:}
LABELV $1278
endproc BotMapScripts 1424 16
export BotEntityToActivate
proc BotEntityToActivate 2916 16
line 1910
;1902:
;1903:/*
;1904:==================
;1905:BotEntityToActivate
;1906:==================
;1907:*/
;1908://#define OBSTACLEDEBUG
;1909:
;1910:int BotEntityToActivate(int entitynum) {
line 1918
;1911:	int i, ent, cur_entities[10];
;1912:	char model[MAX_INFO_STRING], tmpmodel[128];
;1913:	char target[128], classname[128];
;1914:	float health;
;1915:	char targetname[10][128];
;1916:	aas_entityinfo_t entinfo;
;1917:
;1918:	BotEntityInfo(entitynum, &entinfo);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 2736
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1919
;1919:	Com_sprintf(model, sizeof( model ), "*%d", entinfo.modelindex);
ADDRLP4 1712
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $1337
ARGP4
ADDRLP4 2736+104
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 1920
;1920:	for (ent = trap_AAS_NextBSPEntity(0); ent; ent = trap_AAS_NextBSPEntity(ent)) {
CNSTI4 0
ARGI4
ADDRLP4 2880
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 2880
INDIRI4
ASGNI4
ADDRGP4 $1342
JUMPV
LABELV $1339
line 1921
;1921:		if (!trap_AAS_ValueForBSPEpairKey(ent, "model", tmpmodel, sizeof(tmpmodel))) continue;
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $170
ARGP4
ADDRLP4 1584
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 2884
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
ASGNI4
ADDRLP4 2884
INDIRI4
CNSTI4 0
NEI4 $1343
ADDRGP4 $1340
JUMPV
LABELV $1343
line 1922
;1922:		if (!strcmp(model, tmpmodel)) break;
ADDRLP4 1712
ARGP4
ADDRLP4 1584
ARGP4
ADDRLP4 2888
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2888
INDIRI4
CNSTI4 0
NEI4 $1345
ADDRGP4 $1341
JUMPV
LABELV $1345
line 1923
;1923:	}
LABELV $1340
line 1920
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 2884
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 2884
INDIRI4
ASGNI4
LABELV $1342
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $1339
LABELV $1341
line 1924
;1924:	if (!ent) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $1347
line 1925
;1925:		BotAI_Print(PRT_ERROR, "BotEntityToActivate: no entity found with model %s\n", model);
CNSTI4 3
ARGI4
ADDRGP4 $1349
ARGP4
ADDRLP4 1712
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 1926
;1926:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $1336
JUMPV
LABELV $1347
line 1928
;1927:	}
;1928:	trap_AAS_ValueForBSPEpairKey(ent, "classname", classname, sizeof(classname));
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $1350
ARGP4
ADDRLP4 1456
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
pop
line 1929
;1929:	if (!classname) {
ADDRLP4 1456
CVPU4 4
CNSTU4 0
NEU4 $1351
line 1930
;1930:		BotAI_Print(PRT_ERROR, "BotEntityToActivate: entity with model %s has no classname\n", model);
CNSTI4 3
ARGI4
ADDRGP4 $1353
ARGP4
ADDRLP4 1712
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 1931
;1931:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $1336
JUMPV
LABELV $1351
line 1934
;1932:	}
;1933:	//if it is a door
;1934:	if (!strcmp(classname, "func_door")) {
ADDRLP4 1456
ARGP4
ADDRGP4 $1356
ARGP4
ADDRLP4 2888
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2888
INDIRI4
CNSTI4 0
NEI4 $1354
line 1935
;1935:		if (trap_AAS_FloatForBSPEpairKey(ent, "health", &health)) {
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $1359
ARGP4
ADDRLP4 2876
ARGP4
ADDRLP4 2892
ADDRGP4 trap_AAS_FloatForBSPEpairKey
CALLI4
ASGNI4
ADDRLP4 2892
INDIRI4
CNSTI4 0
EQI4 $1357
line 1937
;1936:			//if health the door must be shot to open
;1937:			if (health) return ent;
ADDRLP4 2876
INDIRF4
CNSTF4 0
EQF4 $1360
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $1336
JUMPV
LABELV $1360
line 1938
;1938:		}
LABELV $1357
line 1939
;1939:	}
LABELV $1354
line 1941
;1940:	//get the targetname so we can find an entity with a matching target
;1941:	if (!trap_AAS_ValueForBSPEpairKey(ent, "targetname", targetname[0], sizeof(targetname[0]))) {
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $1364
ARGP4
ADDRLP4 136
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 2892
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
ASGNI4
ADDRLP4 2892
INDIRI4
CNSTI4 0
NEI4 $1362
line 1945
;1942:#ifdef OBSTACLEDEBUG
;1943:		BotAI_Print(PRT_ERROR, "BotEntityToActivate: entity with model \"%s\" has no targetname\n", model);
;1944:#endif //OBSTACLEDEBUG
;1945:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $1336
JUMPV
LABELV $1362
line 1948
;1946:	}
;1947:	//only allows single activation chains, tree-like activation can be added back in
;1948:	cur_entities[0] = trap_AAS_NextBSPEntity(0);
CNSTI4 0
ARGI4
ADDRLP4 2896
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 1416
ADDRLP4 2896
INDIRI4
ASGNI4
line 1949
;1949:	for (i = 0; i >= 0 && i < 10;) {
ADDRLP4 132
CNSTI4 0
ASGNI4
ADDRGP4 $1368
JUMPV
LABELV $1365
line 1950
;1950:		for (ent = cur_entities[i]; ent; ent = trap_AAS_NextBSPEntity(ent)) {
ADDRLP4 0
ADDRLP4 132
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1416
ADDP4
INDIRI4
ASGNI4
ADDRGP4 $1372
JUMPV
LABELV $1369
line 1951
;1951:			if (!trap_AAS_ValueForBSPEpairKey(ent, "target", target, sizeof(target))) continue;
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $1375
ARGP4
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 2900
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
ASGNI4
ADDRLP4 2900
INDIRI4
CNSTI4 0
NEI4 $1373
ADDRGP4 $1370
JUMPV
LABELV $1373
line 1952
;1952:			if (!strcmp(targetname[i], target)) {
ADDRLP4 132
INDIRI4
CNSTI4 7
LSHI4
ADDRLP4 136
ADDP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 2904
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2904
INDIRI4
CNSTI4 0
NEI4 $1376
line 1953
;1953:				cur_entities[i] = trap_AAS_NextBSPEntity(ent);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 2908
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 132
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1416
ADDP4
ADDRLP4 2908
INDIRI4
ASGNI4
line 1954
;1954:				break;
ADDRGP4 $1371
JUMPV
LABELV $1376
line 1956
;1955:			}
;1956:		}
LABELV $1370
line 1950
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 2900
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 2900
INDIRI4
ASGNI4
LABELV $1372
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $1369
LABELV $1371
line 1957
;1957:		if (!ent) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $1378
line 1958
;1958:			BotAI_Print(PRT_ERROR, "BotEntityToActivate: no entity with target \"%s\"\n", targetname[i]);
CNSTI4 3
ARGI4
ADDRGP4 $1380
ARGP4
ADDRLP4 132
INDIRI4
CNSTI4 7
LSHI4
ADDRLP4 136
ADDP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 1959
;1959:			i--;
ADDRLP4 132
ADDRLP4 132
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1960
;1960:			continue;
ADDRGP4 $1366
JUMPV
LABELV $1378
line 1962
;1961:		}
;1962:		if (!trap_AAS_ValueForBSPEpairKey(ent, "classname", classname, sizeof(classname))) {
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $1350
ARGP4
ADDRLP4 1456
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 2904
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
ASGNI4
ADDRLP4 2904
INDIRI4
CNSTI4 0
NEI4 $1381
line 1963
;1963:			BotAI_Print(PRT_ERROR, "BotEntityToActivate: entity with target \"%s\" has no classname\n", targetname[i]);
CNSTI4 3
ARGI4
ADDRGP4 $1383
ARGP4
ADDRLP4 132
INDIRI4
CNSTI4 7
LSHI4
ADDRLP4 136
ADDP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 1964
;1964:			continue;
ADDRGP4 $1366
JUMPV
LABELV $1381
line 1966
;1965:		}
;1966:		if (!strcmp(classname, "func_button")) {
ADDRLP4 1456
ARGP4
ADDRGP4 $1386
ARGP4
ADDRLP4 2908
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2908
INDIRI4
CNSTI4 0
NEI4 $1384
line 1968
;1967:			//BSP button model
;1968:			return ent;
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $1336
JUMPV
LABELV $1384
line 1970
;1969:		}
;1970:		else if (!strcmp(classname, "trigger_multiple")) {
ADDRLP4 1456
ARGP4
ADDRGP4 $1389
ARGP4
ADDRLP4 2912
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 2912
INDIRI4
CNSTI4 0
NEI4 $1387
line 1972
;1971:			//invisible trigger multiple box
;1972:			return ent;
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $1336
JUMPV
LABELV $1387
line 1974
;1973:		}
;1974:		else {
line 1975
;1975:			i--;
ADDRLP4 132
ADDRLP4 132
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1976
;1976:		}
line 1977
;1977:	}
LABELV $1366
line 1949
LABELV $1368
ADDRLP4 132
INDIRI4
CNSTI4 0
LTI4 $1390
ADDRLP4 132
INDIRI4
CNSTI4 10
LTI4 $1365
LABELV $1390
line 1978
;1978:	BotAI_Print(PRT_ERROR, "BotEntityToActivate: unknown activator with classname \"%s\"\n", classname);
CNSTI4 3
ARGI4
ADDRGP4 $1391
ARGP4
ADDRLP4 1456
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 1979
;1979:	return 0;
CNSTI4 0
RETI4
LABELV $1336
endproc BotEntityToActivate 2916 16
data
export VEC_UP
align 4
LABELV VEC_UP
byte 4 0
byte 4 3212836864
byte 4 0
export MOVEDIR_UP
align 4
LABELV MOVEDIR_UP
byte 4 0
byte 4 0
byte 4 1065353216
export VEC_DOWN
align 4
LABELV VEC_DOWN
byte 4 0
byte 4 3221225472
byte 4 0
export MOVEDIR_DOWN
align 4
LABELV MOVEDIR_DOWN
byte 4 0
byte 4 0
byte 4 3212836864
export BotSetMovedir
code
proc BotSetMovedir 12 16
line 1992
;1980:}
;1981:
;1982:/*
;1983:==================
;1984:BotSetMovedir
;1985:==================
;1986:*/
;1987:vec3_t VEC_UP		= {0, -1,  0};
;1988:vec3_t MOVEDIR_UP	= {0,  0,  1};
;1989:vec3_t VEC_DOWN		= {0, -2,  0};
;1990:vec3_t MOVEDIR_DOWN	= {0,  0, -1};
;1991:
;1992:void BotSetMovedir(vec3_t angles, vec3_t movedir) {
line 1993
;1993:	if (VectorCompare(angles, VEC_UP)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 VEC_UP
ARGP4
ADDRLP4 0
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $1393
line 1994
;1994:		VectorCopy(MOVEDIR_UP, movedir);
ADDRFP4 4
INDIRP4
ADDRGP4 MOVEDIR_UP
INDIRB
ASGNB 12
line 1995
;1995:	}
ADDRGP4 $1394
JUMPV
LABELV $1393
line 1996
;1996:	else if (VectorCompare(angles, VEC_DOWN)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 VEC_DOWN
ARGP4
ADDRLP4 4
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $1395
line 1997
;1997:		VectorCopy(MOVEDIR_DOWN, movedir);
ADDRFP4 4
INDIRP4
ADDRGP4 MOVEDIR_DOWN
INDIRB
ASGNB 12
line 1998
;1998:	}
ADDRGP4 $1396
JUMPV
LABELV $1395
line 1999
;1999:	else {
line 2000
;2000:		AngleVectors(angles, movedir, NULL, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
CNSTP4 0
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2001
;2001:	}
LABELV $1396
LABELV $1394
line 2002
;2002:}
LABELV $1392
endproc BotSetMovedir 12 16
export BotModelMinsMaxs
proc BotModelMinsMaxs 32 0
line 2011
;2003:
;2004:/*
;2005:==================
;2006:BotModelMinsMaxs
;2007:
;2008:this is ugly
;2009:==================
;2010:*/
;2011:void BotModelMinsMaxs(int modelindex, int eType, vec3_t mins, vec3_t maxs) {
line 2015
;2012:	gentity_t *ent;
;2013:	int i;
;2014:
;2015:	ent = &g_entities[0];
ADDRLP4 0
ADDRGP4 g_entities
ASGNP4
line 2016
;2016:	for (i = 0; i < level.num_entities; i++, ent++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $1401
JUMPV
LABELV $1398
line 2017
;2017:		if ( !ent->inuse ) {
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1403
line 2018
;2018:			continue;
ADDRGP4 $1399
JUMPV
LABELV $1403
line 2020
;2019:		}
;2020:		if ( ent->s.eType != eType) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ADDRFP4 4
INDIRI4
EQI4 $1405
line 2021
;2021:			continue;
ADDRGP4 $1399
JUMPV
LABELV $1405
line 2023
;2022:		}
;2023:		if (ent->s.modelindex == modelindex) {
ADDRLP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $1407
line 2024
;2024:			VectorAdd(ent->r.currentOrigin, ent->r.mins, mins);
ADDRFP4 8
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 424
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 428
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 432
ADDP4
INDIRF4
ADDF4
ASGNF4
line 2025
;2025:			VectorAdd(ent->r.currentOrigin, ent->r.maxs, maxs);
ADDRFP4 12
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 476
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRFP4 12
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 480
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRFP4 12
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRF4
ADDF4
ASGNF4
line 2026
;2026:			return;
ADDRGP4 $1397
JUMPV
LABELV $1407
line 2028
;2027:		}
;2028:	}
LABELV $1399
line 2016
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
ASGNP4
LABELV $1401
ADDRLP4 4
INDIRI4
ADDRGP4 level+12
INDIRI4
LTI4 $1398
line 2029
;2029:	VectorClear(mins);
ADDRLP4 8
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
ADDRLP4 12
INDIRF4
ASGNF4
line 2030
;2030:	VectorClear(maxs);
ADDRLP4 16
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 20
CNSTF4 0
ASGNF4
ADDRLP4 16
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 16
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 16
INDIRP4
ADDRLP4 20
INDIRF4
ASGNF4
line 2031
;2031:}
LABELV $1397
endproc BotModelMinsMaxs 32 0
lit
align 4
LABELV $1410
byte 4 0
byte 4 0
byte 4 1065353216
align 4
LABELV $1411
byte 4 1065353216
byte 4 1065353216
byte 4 1065353216
align 4
LABELV $1412
byte 4 3212836864
byte 4 3212836864
byte 4 3212836864
export BotAIBlocked
code
proc BotAIBlocked 740 20
line 2044
;2032:
;2033:/*
;2034:==================
;2035:BotAIBlocked
;2036:
;2037:very basic handling of bots being blocked by other entities
;2038:check what kind of entity is blocking the bot and try to activate
;2039:it otherwise try to walk around the entity
;2040:before the bot ends in this part of the AI it should predict which doors to open,
;2041:which buttons to activate etc.
;2042:==================
;2043:*/
;2044:void BotAIBlocked(bot_state_t *bs, bot_moveresult_t *moveresult, int activate) {
line 2050
;2045:	int movetype, ent, i, areas[10], numareas, modelindex;
;2046:	char classname[128], model[128];
;2047:	float lip, dist, health, angle;
;2048:	vec3_t hordir, size, start, end, mins, maxs, sideward, angles;
;2049:	vec3_t movedir, origin, goalorigin, bboxmins, bboxmaxs;
;2050:	vec3_t up = {0, 0, 1}, extramins = {1, 1, 1}, extramaxs = {-1, -1, -1};
ADDRLP4 264
ADDRGP4 $1410
INDIRB
ASGNB 12
ADDRLP4 460
ADDRGP4 $1411
INDIRB
ASGNB 12
ADDRLP4 472
ADDRGP4 $1412
INDIRB
ASGNB 12
line 2058
;2051:	aas_entityinfo_t entinfo;
;2052:	//bsp_trace_t bsptrace;
;2053:#ifdef OBSTACLEDEBUG
;2054:	char netname[MAX_NETNAME];
;2055:	char buf[128];
;2056:#endif
;2057:
;2058:	if (!moveresult->blocked) {
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1413
line 2059
;2059:		bs->notblocked_time = trap_AAS_Time();
ADDRLP4 664
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6168
ADDP4
ADDRLP4 664
INDIRF4
ASGNF4
line 2060
;2060:		return;
ADDRGP4 $1409
JUMPV
LABELV $1413
line 2063
;2061:	}
;2062:	//
;2063:	BotEntityInfo(moveresult->blockentity, &entinfo);
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 104
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 2069
;2064:#ifdef OBSTACLEDEBUG
;2065:	ClientName(bs->client, netname, sizeof(netname));
;2066:	BotAI_Print(PRT_MESSAGE, "%s: I'm blocked by model %d\n", netname, entinfo.modelindex);
;2067:#endif OBSTACLEDEBUG
;2068:	//if blocked by a bsp model and the bot wants to activate it if possible
;2069:	if (entinfo.modelindex > 0 && entinfo.modelindex <= max_bspmodelindex && activate) {
ADDRLP4 664
CNSTI4 0
ASGNI4
ADDRLP4 104+104
INDIRI4
ADDRLP4 664
INDIRI4
LEI4 $1415
ADDRLP4 104+104
INDIRI4
ADDRGP4 max_bspmodelindex
INDIRI4
GTI4 $1415
ADDRFP4 8
INDIRI4
ADDRLP4 664
INDIRI4
EQI4 $1415
line 2072
;2070:		//find the bsp entity which should be activated in order to remove
;2071:		//the blocking entity
;2072:		ent = BotEntityToActivate(entinfo.number);
ADDRLP4 104+20
INDIRI4
ARGI4
ADDRLP4 668
ADDRGP4 BotEntityToActivate
CALLI4
ASGNI4
ADDRLP4 260
ADDRLP4 668
INDIRI4
ASGNI4
line 2073
;2073:		if (!ent) {
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $1420
line 2074
;2074:			strcpy(classname, "");
ADDRLP4 280
ARGP4
ADDRGP4 $1422
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 2078
;2075:#ifdef OBSTACLEDEBUG
;2076:			BotAI_Print(PRT_MESSAGE, "%s: can't find activator for blocking entity\n", ClientName(bs->client, netname, sizeof(netname)));
;2077:#endif //OBSTACLEDEBUG
;2078:		}
ADDRGP4 $1421
JUMPV
LABELV $1420
line 2079
;2079:		else {
line 2080
;2080:			trap_AAS_ValueForBSPEpairKey(ent, "classname", classname, sizeof(classname));
ADDRLP4 260
INDIRI4
ARGI4
ADDRGP4 $1350
ARGP4
ADDRLP4 280
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
pop
line 2085
;2081:#ifdef OBSTACLEDEBUG
;2082:			ClientName(bs->client, netname, sizeof(netname));
;2083:			BotAI_Print(PRT_MESSAGE, "%s: I should activate %s\n", netname, classname);
;2084:#endif OBSTACLEDEBUG
;2085:		}
LABELV $1421
line 2086
;2086:		if (!strcmp(classname, "func_button")) {
ADDRLP4 280
ARGP4
ADDRGP4 $1386
ARGP4
ADDRLP4 672
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 672
INDIRI4
CNSTI4 0
NEI4 $1423
line 2088
;2087:			//create a bot goal towards the button
;2088:			trap_AAS_ValueForBSPEpairKey(ent, "model", model, sizeof(model));
ADDRLP4 260
INDIRI4
ARGI4
ADDRGP4 $170
ARGP4
ADDRLP4 500
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
pop
line 2089
;2089:			modelindex = atoi(model+1);
ADDRLP4 500+1
ARGP4
ADDRLP4 676
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 496
ADDRLP4 676
INDIRI4
ASGNI4
line 2091
;2090:			//if the model is not loaded
;2091:			if (!modelindex) return;
ADDRLP4 496
INDIRI4
CNSTI4 0
NEI4 $1426
ADDRGP4 $1409
JUMPV
LABELV $1426
line 2092
;2092:			VectorClear(angles);
ADDRLP4 680
CNSTF4 0
ASGNF4
ADDRLP4 88+8
ADDRLP4 680
INDIRF4
ASGNF4
ADDRLP4 88+4
ADDRLP4 680
INDIRF4
ASGNF4
ADDRLP4 88
ADDRLP4 680
INDIRF4
ASGNF4
line 2093
;2093:			BotModelMinsMaxs(modelindex, ET_MOVER, mins, maxs);
ADDRLP4 496
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 64
ARGP4
ADDRGP4 BotModelMinsMaxs
CALLV
pop
line 2095
;2094:			//get the lip of the button
;2095:			trap_AAS_FloatForBSPEpairKey(ent, "lip", &lip);
ADDRLP4 260
INDIRI4
ARGI4
ADDRGP4 $1430
ARGP4
ADDRLP4 652
ARGP4
ADDRGP4 trap_AAS_FloatForBSPEpairKey
CALLI4
pop
line 2096
;2096:			if (!lip) lip = 4;
ADDRLP4 652
INDIRF4
CNSTF4 0
NEF4 $1431
ADDRLP4 652
CNSTF4 1082130432
ASGNF4
LABELV $1431
line 2098
;2097:			//get the move direction from the angle
;2098:			trap_AAS_FloatForBSPEpairKey(ent, "angle", &angle);
ADDRLP4 260
INDIRI4
ARGI4
ADDRGP4 $1433
ARGP4
ADDRLP4 660
ARGP4
ADDRGP4 trap_AAS_FloatForBSPEpairKey
CALLI4
pop
line 2099
;2099:			VectorSet(angles, 0, angle, 0);
ADDRLP4 88
CNSTF4 0
ASGNF4
ADDRLP4 88+4
ADDRLP4 660
INDIRF4
ASGNF4
ADDRLP4 88+8
CNSTF4 0
ASGNF4
line 2100
;2100:			BotSetMovedir(angles, movedir);
ADDRLP4 88
ARGP4
ADDRLP4 16
ARGP4
ADDRGP4 BotSetMovedir
CALLV
pop
line 2102
;2101:			//button size
;2102:			VectorSubtract(maxs, mins, size);
ADDRLP4 408
ADDRLP4 64
INDIRF4
ADDRLP4 52
INDIRF4
SUBF4
ASGNF4
ADDRLP4 408+4
ADDRLP4 64+4
INDIRF4
ADDRLP4 52+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 408+8
ADDRLP4 64+8
INDIRF4
ADDRLP4 52+8
INDIRF4
SUBF4
ASGNF4
line 2104
;2103:			//button origin
;2104:			VectorAdd(mins, maxs, origin);
ADDRLP4 76
ADDRLP4 52
INDIRF4
ADDRLP4 64
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+4
ADDRLP4 52+4
INDIRF4
ADDRLP4 64+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+8
ADDRLP4 52+8
INDIRF4
ADDRLP4 64+8
INDIRF4
ADDF4
ASGNF4
line 2105
;2105:			VectorScale(origin, 0.5, origin);
ADDRLP4 684
CNSTF4 1056964608
ASGNF4
ADDRLP4 76
ADDRLP4 684
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ASGNF4
ADDRLP4 76+4
ADDRLP4 684
INDIRF4
ADDRLP4 76+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 76+8
CNSTF4 1056964608
ADDRLP4 76+8
INDIRF4
MULF4
ASGNF4
line 2107
;2106:			//touch distance of the button
;2107:			dist = fabs(movedir[0]) * size[0] + fabs(movedir[1]) * size[1] + fabs(movedir[2]) * size[2];
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 688
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 16+4
INDIRF4
ARGF4
ADDRLP4 692
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 16+8
INDIRF4
ARGF4
ADDRLP4 696
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 256
ADDRLP4 688
INDIRF4
ADDRLP4 408
INDIRF4
MULF4
ADDRLP4 692
INDIRF4
ADDRLP4 408+4
INDIRF4
MULF4
ADDF4
ADDRLP4 696
INDIRF4
ADDRLP4 408+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 2108
;2108:			dist *= 0.5;
ADDRLP4 256
CNSTF4 1056964608
ADDRLP4 256
INDIRF4
MULF4
ASGNF4
line 2110
;2109:			//
;2110:			trap_AAS_FloatForBSPEpairKey(ent, "health", &health);
ADDRLP4 260
INDIRI4
ARGI4
ADDRGP4 $1359
ARGP4
ADDRLP4 656
ARGP4
ADDRGP4 trap_AAS_FloatForBSPEpairKey
CALLI4
pop
line 2112
;2111:			//if the button is shootable
;2112:			if (health) {
ADDRLP4 656
INDIRF4
CNSTF4 0
EQF4 $1456
line 2115
;2113:				//FIXME: walk to a point where the button is visible and shoot at the button
;2114:				//calculate the goal origin
;2115:				VectorMA(origin, -dist, movedir, goalorigin);
ADDRLP4 700
ADDRLP4 256
INDIRF4
NEGF4
ASGNF4
ADDRLP4 484
ADDRLP4 76
INDIRF4
ADDRLP4 16
INDIRF4
ADDRLP4 700
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 484+4
ADDRLP4 76+4
INDIRF4
ADDRLP4 16+4
INDIRF4
ADDRLP4 700
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 484+8
ADDRLP4 76+8
INDIRF4
ADDRLP4 16+8
INDIRF4
ADDRLP4 256
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 2117
;2116:				//
;2117:				VectorSubtract(goalorigin, bs->origin, movedir);
ADDRLP4 704
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 484
INDIRF4
ADDRLP4 704
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 484+4
INDIRF4
ADDRLP4 704
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+8
ADDRLP4 484+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 2118
;2118:				vectoangles(movedir, moveresult->ideal_viewangles);
ADDRLP4 16
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 2119
;2119:				moveresult->flags |= MOVERESULT_MOVEMENTVIEW;
ADDRLP4 708
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 708
INDIRP4
ADDRLP4 708
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 2120
;2120:				moveresult->flags |= MOVERESULT_MOVEMENTWEAPON;
ADDRLP4 712
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 712
INDIRP4
ADDRLP4 712
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 2122
;2121:				//select the machinegun and shoot
;2122:				trap_EA_SelectWeapon(bs->client, WEAPONINDEX_MACHINEGUN);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_EA_SelectWeapon
CALLV
pop
line 2123
;2123:				if (bs->cur_ps.weapon == WEAPONINDEX_MACHINEGUN) {
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
CNSTI4 2
NEI4 $1409
line 2124
;2124:					trap_EA_Attack(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Attack
CALLV
pop
line 2125
;2125:				}
line 2126
;2126:				return;
ADDRGP4 $1409
JUMPV
LABELV $1456
line 2128
;2127:			}
;2128:			else {
line 2130
;2129:				//add bounding box size to the dist
;2130:				trap_AAS_PresenceTypeBoundingBox(PRESENCE_CROUCH, bboxmins, bboxmaxs);
CNSTI4 4
ARGI4
ADDRLP4 628
ARGP4
ADDRLP4 640
ARGP4
ADDRGP4 trap_AAS_PresenceTypeBoundingBox
CALLV
pop
line 2131
;2131:				for (i = 0; i < 3; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1470
line 2132
;2132:					if (movedir[i] < 0) dist += fabs(movedir[i]) * fabs(bboxmaxs[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
ADDP4
INDIRF4
CNSTF4 0
GEF4 $1474
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
ADDP4
INDIRF4
ARGF4
ADDRLP4 700
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 640
ADDP4
INDIRF4
ARGF4
ADDRLP4 704
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 256
ADDRLP4 256
INDIRF4
ADDRLP4 700
INDIRF4
ADDRLP4 704
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 $1475
JUMPV
LABELV $1474
line 2133
;2133:					else dist += fabs(movedir[i]) * fabs(bboxmins[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
ADDP4
INDIRF4
ARGF4
ADDRLP4 708
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 628
ADDP4
INDIRF4
ARGF4
ADDRLP4 712
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 256
ADDRLP4 256
INDIRF4
ADDRLP4 708
INDIRF4
ADDRLP4 712
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $1475
line 2134
;2134:				}
LABELV $1471
line 2131
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1470
line 2136
;2135:				//calculate the goal origin
;2136:				VectorMA(origin, -dist, movedir, goalorigin);
ADDRLP4 700
ADDRLP4 256
INDIRF4
NEGF4
ASGNF4
ADDRLP4 484
ADDRLP4 76
INDIRF4
ADDRLP4 16
INDIRF4
ADDRLP4 700
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 484+4
ADDRLP4 76+4
INDIRF4
ADDRLP4 16+4
INDIRF4
ADDRLP4 700
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 484+8
ADDRLP4 76+8
INDIRF4
ADDRLP4 16+8
INDIRF4
ADDRLP4 256
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 2138
;2137:				//
;2138:				VectorCopy(goalorigin, start);
ADDRLP4 40
ADDRLP4 484
INDIRB
ASGNB 12
line 2139
;2139:				start[2] += 24;
ADDRLP4 40+8
ADDRLP4 40+8
INDIRF4
CNSTF4 1103101952
ADDF4
ASGNF4
line 2140
;2140:				VectorCopy(start, end);
ADDRLP4 244
ADDRLP4 40
INDIRB
ASGNB 12
line 2141
;2141:				end[2] -= 100;
ADDRLP4 244+8
ADDRLP4 244+8
INDIRF4
CNSTF4 1120403456
SUBF4
ASGNF4
line 2142
;2142:				numareas = trap_AAS_TraceAreas(start, end, areas, NULL, 10);
ADDRLP4 40
ARGP4
ADDRLP4 244
ARGP4
ADDRLP4 420
ARGP4
CNSTP4 0
ARGP4
CNSTI4 10
ARGI4
ADDRLP4 704
ADDRGP4 trap_AAS_TraceAreas
CALLI4
ASGNI4
ADDRLP4 276
ADDRLP4 704
INDIRI4
ASGNI4
line 2144
;2143:				//
;2144:				for (i = 0; i < numareas; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $1487
JUMPV
LABELV $1484
line 2145
;2145:					if (trap_AAS_AreaReachability(areas[i])) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 420
ADDP4
INDIRI4
ARGI4
ADDRLP4 708
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 708
INDIRI4
CNSTI4 0
EQI4 $1488
line 2146
;2146:						break;
ADDRGP4 $1486
JUMPV
LABELV $1488
line 2148
;2147:					}
;2148:				}
LABELV $1485
line 2144
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1487
ADDRLP4 0
INDIRI4
ADDRLP4 276
INDIRI4
LTI4 $1484
LABELV $1486
line 2149
;2149:				if (i < numareas) {
ADDRLP4 0
INDIRI4
ADDRLP4 276
INDIRI4
GEI4 $1490
line 2160
;2150:					//
;2151:#ifdef OBSTACLEDEBUG
;2152:					if (bs->activatemessage_time < trap_AAS_Time()) {
;2153:						Com_sprintf(buf, sizeof(buf), "I have to activate a button at %1.1f %1.1f %1.1f in area %d\n",
;2154:										goalorigin[0], goalorigin[1], goalorigin[2], areas[i]);
;2155:						trap_EA_Say(bs->client, buf);
;2156:						bs->activatemessage_time = trap_AAS_Time() + 5;
;2157:					}
;2158:#endif //OBSTACLEDEBUG
;2159:					//
;2160:					VectorCopy(origin, bs->activategoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6652
ADDP4
ADDRLP4 76
INDIRB
ASGNB 12
line 2161
;2161:					bs->activategoal.areanum = areas[i];
ADDRFP4 0
INDIRP4
CNSTI4 6664
ADDP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 420
ADDP4
INDIRI4
ASGNI4
line 2162
;2162:					VectorSubtract(mins, origin, bs->activategoal.mins);
ADDRFP4 0
INDIRP4
CNSTI4 6668
ADDP4
ADDRLP4 52
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6672
ADDP4
ADDRLP4 52+4
INDIRF4
ADDRLP4 76+4
INDIRF4
SUBF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6676
ADDP4
ADDRLP4 52+8
INDIRF4
ADDRLP4 76+8
INDIRF4
SUBF4
ASGNF4
line 2163
;2163:					VectorSubtract(maxs, origin, bs->activategoal.maxs);
ADDRFP4 0
INDIRP4
CNSTI4 6680
ADDP4
ADDRLP4 64
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6684
ADDP4
ADDRLP4 64+4
INDIRF4
ADDRLP4 76+4
INDIRF4
SUBF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6688
ADDP4
ADDRLP4 64+8
INDIRF4
ADDRLP4 76+8
INDIRF4
SUBF4
ASGNF4
line 2165
;2164:					//
;2165:					for (i = 0; i < 3; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1500
line 2166
;2166:					{
line 2167
;2167:						if (movedir[i] < 0) bs->activategoal.maxs[i] += fabs(movedir[i]) * fabs(extramaxs[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
ADDP4
INDIRF4
CNSTF4 0
GEF4 $1504
ADDRLP4 708
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 708
INDIRI4
ADDRLP4 16
ADDP4
INDIRF4
ARGF4
ADDRLP4 712
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 472
ADDP4
INDIRF4
ARGF4
ADDRLP4 716
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 720
ADDRLP4 708
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6680
ADDP4
ADDP4
ASGNP4
ADDRLP4 720
INDIRP4
ADDRLP4 720
INDIRP4
INDIRF4
ADDRLP4 712
INDIRF4
ADDRLP4 716
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 $1505
JUMPV
LABELV $1504
line 2168
;2168:						else bs->activategoal.mins[i] += fabs(movedir[i]) * fabs(extramins[i]);
ADDRLP4 724
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 724
INDIRI4
ADDRLP4 16
ADDP4
INDIRF4
ARGF4
ADDRLP4 728
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 460
ADDP4
INDIRF4
ARGF4
ADDRLP4 732
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 736
ADDRLP4 724
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6668
ADDP4
ADDP4
ASGNP4
ADDRLP4 736
INDIRP4
ADDRLP4 736
INDIRP4
INDIRF4
ADDRLP4 728
INDIRF4
ADDRLP4 732
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $1505
line 2169
;2169:					} //end for
LABELV $1501
line 2165
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1500
line 2171
;2170:					//
;2171:					bs->activategoal.entitynum = entinfo.number;
ADDRFP4 0
INDIRP4
CNSTI4 6692
ADDP4
ADDRLP4 104+20
INDIRI4
ASGNI4
line 2172
;2172:					bs->activategoal.number = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6696
ADDP4
CNSTI4 0
ASGNI4
line 2173
;2173:					bs->activategoal.flags = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6700
ADDP4
CNSTI4 0
ASGNI4
line 2174
;2174:					bs->activate_time = trap_AAS_Time() + 10;
ADDRLP4 708
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6108
ADDP4
ADDRLP4 708
INDIRF4
CNSTF4 1092616192
ADDF4
ASGNF4
line 2175
;2175:					AIEnter_Seek_ActivateEntity(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_ActivateEntity
CALLV
pop
line 2176
;2176:					return;
ADDRGP4 $1409
JUMPV
LABELV $1490
line 2178
;2177:				}
;2178:				else {
line 2183
;2179:#ifdef OBSTACLEDEBUG
;2180:					if (!numareas) BotAI_Print(PRT_MESSAGE, "button not in an area\n");
;2181:					else BotAI_Print(PRT_MESSAGE, "button area has no reachabilities\n");
;2182:#endif //OBSTACLEDEBUG
;2183:					if (bs->ainode == AINode_Seek_NBG) bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 AINode_Seek_NBG
CVPU4 4
NEU4 $1507
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
ADDRGP4 $1424
JUMPV
LABELV $1507
line 2184
;2184:					else if (bs->ainode == AINode_Seek_LTG) bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 AINode_Seek_LTG
CVPU4 4
NEU4 $1424
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 2185
;2185:				}
line 2186
;2186:			}
line 2187
;2187:		}
ADDRGP4 $1424
JUMPV
LABELV $1423
line 2188
;2188:		else if (!strcmp(classname, "func_door")) {
ADDRLP4 280
ARGP4
ADDRGP4 $1356
ARGP4
ADDRLP4 676
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 676
INDIRI4
CNSTI4 0
NEI4 $1511
line 2190
;2189:			//shoot at the shootable door
;2190:			trap_AAS_ValueForBSPEpairKey(ent, "model", model, sizeof(model));
ADDRLP4 260
INDIRI4
ARGI4
ADDRGP4 $170
ARGP4
ADDRLP4 500
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
pop
line 2191
;2191:			modelindex = atoi(model+1);
ADDRLP4 500+1
ARGP4
ADDRLP4 680
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 496
ADDRLP4 680
INDIRI4
ASGNI4
line 2193
;2192:			//if the model is not loaded
;2193:			if (!modelindex) return;
ADDRLP4 496
INDIRI4
CNSTI4 0
NEI4 $1514
ADDRGP4 $1409
JUMPV
LABELV $1514
line 2194
;2194:			VectorClear(angles);
ADDRLP4 684
CNSTF4 0
ASGNF4
ADDRLP4 88+8
ADDRLP4 684
INDIRF4
ASGNF4
ADDRLP4 88+4
ADDRLP4 684
INDIRF4
ASGNF4
ADDRLP4 88
ADDRLP4 684
INDIRF4
ASGNF4
line 2195
;2195:			BotModelMinsMaxs(modelindex, ET_MOVER, mins, maxs);
ADDRLP4 496
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 64
ARGP4
ADDRGP4 BotModelMinsMaxs
CALLV
pop
line 2197
;2196:			//door origin
;2197:			VectorAdd(mins, maxs, origin);
ADDRLP4 76
ADDRLP4 52
INDIRF4
ADDRLP4 64
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+4
ADDRLP4 52+4
INDIRF4
ADDRLP4 64+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 76+8
ADDRLP4 52+8
INDIRF4
ADDRLP4 64+8
INDIRF4
ADDF4
ASGNF4
line 2198
;2198:			VectorScale(origin, 0.5, origin);
ADDRLP4 688
CNSTF4 1056964608
ASGNF4
ADDRLP4 76
ADDRLP4 688
INDIRF4
ADDRLP4 76
INDIRF4
MULF4
ASGNF4
ADDRLP4 76+4
ADDRLP4 688
INDIRF4
ADDRLP4 76+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 76+8
CNSTF4 1056964608
ADDRLP4 76+8
INDIRF4
MULF4
ASGNF4
line 2200
;2199:			//
;2200:			VectorSubtract(origin, bs->eye, movedir);
ADDRLP4 692
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 76
INDIRF4
ADDRLP4 692
INDIRP4
CNSTI4 4912
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 76+4
INDIRF4
ADDRLP4 692
INDIRP4
CNSTI4 4916
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 16+8
ADDRLP4 76+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4920
ADDP4
INDIRF4
SUBF4
ASGNF4
line 2201
;2201:			vectoangles(movedir, moveresult->ideal_viewangles);
ADDRLP4 16
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 2202
;2202:			moveresult->flags |= MOVERESULT_MOVEMENTVIEW;
ADDRLP4 696
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 696
INDIRP4
ADDRLP4 696
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 2203
;2203:			moveresult->flags |= MOVERESULT_MOVEMENTWEAPON;
ADDRLP4 700
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 700
INDIRP4
ADDRLP4 700
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 2205
;2204:			//select the machinegun and shoot
;2205:			trap_EA_SelectWeapon(bs->client, WEAPONINDEX_MACHINEGUN);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_EA_SelectWeapon
CALLV
pop
line 2206
;2206:			if (bs->cur_ps.weapon == WEAPONINDEX_MACHINEGUN) {
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
CNSTI4 2
NEI4 $1409
line 2207
;2207:				trap_EA_Attack(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Attack
CALLV
pop
line 2208
;2208:			}
line 2209
;2209:			return;
ADDRGP4 $1409
JUMPV
LABELV $1511
LABELV $1424
line 2211
;2210:		}
;2211:	}
LABELV $1415
line 2213
;2212:	//just some basic dynamic obstacle avoidance code
;2213:	hordir[0] = moveresult->movedir[0];
ADDRLP4 4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ASGNF4
line 2214
;2214:	hordir[1] = moveresult->movedir[1];
ADDRLP4 4+4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ASGNF4
line 2215
;2215:	hordir[2] = 0;
ADDRLP4 4+8
CNSTF4 0
ASGNF4
line 2217
;2216:	//if no direction just take a random direction
;2217:	if (VectorNormalize(hordir) < 0.1) {
ADDRLP4 4
ARGP4
ADDRLP4 668
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 668
INDIRF4
CNSTF4 1036831949
GEF4 $1536
line 2218
;2218:		VectorSet(angles, 0, 360 * random(), 0);
ADDRLP4 88
CNSTF4 0
ASGNF4
ADDRLP4 672
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 88+4
CNSTF4 1135869952
ADDRLP4 672
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ASGNF4
ADDRLP4 88+8
CNSTF4 0
ASGNF4
line 2219
;2219:		AngleVectors(angles, hordir, NULL, NULL);
ADDRLP4 88
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 676
CNSTP4 0
ASGNP4
ADDRLP4 676
INDIRP4
ARGP4
ADDRLP4 676
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2220
;2220:	}
LABELV $1536
line 2224
;2221:	//
;2222:	//if (moveresult->flags & MOVERESULT_ONTOPOFOBSTACLE) movetype = MOVE_JUMP;
;2223:	//else
;2224:	movetype = MOVE_WALK;
ADDRLP4 100
CNSTI4 1
ASGNI4
line 2227
;2225:	//if there's an obstacle at the bot's feet and head then
;2226:	//the bot might be able to crouch through
;2227:	VectorCopy(bs->origin, start);
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 2228
;2228:	start[2] += 18;
ADDRLP4 40+8
ADDRLP4 40+8
INDIRF4
CNSTF4 1099956224
ADDF4
ASGNF4
line 2229
;2229:	VectorMA(start, 5, hordir, end);
ADDRLP4 672
CNSTF4 1084227584
ASGNF4
ADDRLP4 244
ADDRLP4 40
INDIRF4
ADDRLP4 672
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 244+4
ADDRLP4 40+4
INDIRF4
ADDRLP4 672
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 244+8
ADDRLP4 40+8
INDIRF4
CNSTF4 1084227584
ADDRLP4 4+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 2230
;2230:	VectorSet(mins, -16, -16, -24);
ADDRLP4 676
CNSTF4 3246391296
ASGNF4
ADDRLP4 52
ADDRLP4 676
INDIRF4
ASGNF4
ADDRLP4 52+4
ADDRLP4 676
INDIRF4
ASGNF4
ADDRLP4 52+8
CNSTF4 3250585600
ASGNF4
line 2231
;2231:	VectorSet(maxs, 16, 16, 4);
ADDRLP4 680
CNSTF4 1098907648
ASGNF4
ADDRLP4 64
ADDRLP4 680
INDIRF4
ASGNF4
ADDRLP4 64+4
ADDRLP4 680
INDIRF4
ASGNF4
ADDRLP4 64+8
CNSTF4 1082130432
ASGNF4
line 2236
;2232:	//
;2233:	//bsptrace = AAS_Trace(start, mins, maxs, end, bs->entitynum, MASK_PLAYERSOLID);
;2234:	//if (bsptrace.fraction >= 1) movetype = MOVE_CROUCH;
;2235:	//get the sideward vector
;2236:	CrossProduct(hordir, up, sideward);
ADDRLP4 4
ARGP4
ADDRLP4 264
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 2238
;2237:	//
;2238:	if (bs->flags & BFL_AVOIDRIGHT) VectorNegate(sideward, sideward);
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $1551
ADDRLP4 28
ADDRLP4 28
INDIRF4
NEGF4
ASGNF4
ADDRLP4 28+4
ADDRLP4 28+4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 28+8
ADDRLP4 28+8
INDIRF4
NEGF4
ASGNF4
LABELV $1551
line 2240
;2239:	//try to crouch straight forward?
;2240:	if (movetype != MOVE_CROUCH || !trap_BotMoveInDirection(bs->ms, hordir, 400, movetype)) {
ADDRLP4 100
INDIRI4
CNSTI4 2
NEI4 $1559
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 100
INDIRI4
ARGI4
ADDRLP4 688
ADDRGP4 trap_BotMoveInDirection
CALLI4
ASGNI4
ADDRLP4 688
INDIRI4
CNSTI4 0
NEI4 $1557
LABELV $1559
line 2242
;2241:		//perform the movement
;2242:		if (!trap_BotMoveInDirection(bs->ms, sideward, 400, movetype)) {
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 28
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 100
INDIRI4
ARGI4
ADDRLP4 692
ADDRGP4 trap_BotMoveInDirection
CALLI4
ASGNI4
ADDRLP4 692
INDIRI4
CNSTI4 0
NEI4 $1560
line 2244
;2243:			//flip the avoid direction flag
;2244:			bs->flags ^= BFL_AVOIDRIGHT;
ADDRLP4 696
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 696
INDIRP4
ADDRLP4 696
INDIRP4
INDIRI4
CNSTI4 16
BXORI4
ASGNI4
line 2246
;2245:			//flip the direction
;2246:			VectorNegate(sideward, sideward);
ADDRLP4 28
ADDRLP4 28
INDIRF4
NEGF4
ASGNF4
ADDRLP4 28+4
ADDRLP4 28+4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 28+8
ADDRLP4 28+8
INDIRF4
NEGF4
ASGNF4
line 2248
;2247:			//move in the other direction
;2248:			trap_BotMoveInDirection(bs->ms, sideward, 400, movetype);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 28
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 100
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveInDirection
CALLI4
pop
line 2249
;2249:		}
LABELV $1560
line 2250
;2250:	}
LABELV $1557
line 2252
;2251:	//
;2252:	if (bs->notblocked_time < trap_AAS_Time() - 0.4) {
ADDRLP4 692
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6168
ADDP4
INDIRF4
ADDRLP4 692
INDIRF4
CNSTF4 1053609165
SUBF4
GEF4 $1566
line 2255
;2253:		//just reset goals and hope the bot will go into another direction
;2254:		//is this still needed??
;2255:		if (bs->ainode == AINode_Seek_NBG) bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 AINode_Seek_NBG
CVPU4 4
NEU4 $1568
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
ADDRGP4 $1569
JUMPV
LABELV $1568
line 2256
;2256:		else if (bs->ainode == AINode_Seek_LTG) bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 AINode_Seek_LTG
CVPU4 4
NEU4 $1570
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
LABELV $1570
LABELV $1569
line 2257
;2257:	}
LABELV $1566
line 2258
;2258:}
LABELV $1409
endproc BotAIBlocked 740 20
export BotCheckConsoleMessages
proc BotCheckConsoleMessages 1008 48
line 2265
;2259:
;2260:/*
;2261:==================
;2262:BotCheckConsoleMessages
;2263:==================
;2264:*/
;2265:void BotCheckConsoleMessages(bot_state_t *bs) {
line 2273
;2266:	char botname[MAX_NETNAME], message[MAX_MESSAGE_SIZE], netname[MAX_NETNAME], *ptr;
;2267:	float chat_reply;
;2268:	int context, handle;
;2269:	bot_consolemessage_t m;
;2270:	bot_match_t match;
;2271:
;2272:	//the name of this bot
;2273:	ClientName(bs->client, botname, sizeof(botname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 908
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
ADDRGP4 $1574
JUMPV
LABELV $1573
line 2275
;2274:	//
;2275:	while((handle = trap_BotNextConsoleMessage(bs->cs, &m)) != 0) {
line 2277
;2276:		//if the chat state is flooded with messages the bot will read them quickly
;2277:		if (trap_BotNumConsoleMessages(bs->cs) < 10) {
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 948
ADDRGP4 trap_BotNumConsoleMessages
CALLI4
ASGNI4
ADDRLP4 948
INDIRI4
CNSTI4 10
GEI4 $1576
line 2279
;2278:			//if it is a chat message the bot needs some time to read it
;2279:			if (m.type == CMS_CHAT && m.time > trap_AAS_Time() - (1 + random())) break;
ADDRLP4 0+8
INDIRI4
CNSTI4 1
NEI4 $1578
ADDRLP4 952
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 956
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
INDIRF4
ADDRLP4 952
INDIRF4
ADDRLP4 956
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1065353216
ADDF4
SUBF4
LEF4 $1578
ADDRGP4 $1575
JUMPV
LABELV $1578
line 2280
;2280:		}
LABELV $1576
line 2282
;2281:		//
;2282:		ptr = m.message;
ADDRLP4 276
ADDRLP4 0+12
ASGNP4
line 2285
;2283:		//if it is a chat message then don't unify white spaces and don't
;2284:		//replace synonyms in the netname
;2285:		if (m.type == CMS_CHAT) {
ADDRLP4 0+8
INDIRI4
CNSTI4 1
NEI4 $1583
line 2287
;2286:			//
;2287:			if (trap_BotFindMatch(m.message, &match, MTCONTEXT_REPLYCHAT)) {
ADDRLP4 0+12
ARGP4
ADDRLP4 288
ARGP4
CNSTU4 128
ARGU4
ADDRLP4 952
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 952
INDIRI4
CNSTI4 0
EQI4 $1586
line 2288
;2288:				ptr = m.message + match.variables[MESSAGE].offset;
ADDRLP4 276
ADDRLP4 288+264+16
INDIRI1
CVII4 1
ADDRLP4 0+12
ADDP4
ASGNP4
line 2289
;2289:			}
LABELV $1586
line 2290
;2290:		}
LABELV $1583
line 2292
;2291:		//unify the white spaces in the message
;2292:		trap_UnifyWhiteSpaces(ptr);
ADDRLP4 276
INDIRP4
ARGP4
ADDRGP4 trap_UnifyWhiteSpaces
CALLV
pop
line 2294
;2293:		//replace synonyms in the right context
;2294:		context = CONTEXT_NORMAL|CONTEXT_NEARBYITEM|CONTEXT_NAMES;
ADDRLP4 280
CNSTI4 1027
ASGNI4
line 2295
;2295:		if (BotCTFTeam(bs) == CTF_TEAM_RED) context |= CONTEXT_CTFREDTEAM;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 952
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 952
INDIRI4
CNSTI4 1
NEI4 $1592
ADDRLP4 280
ADDRLP4 280
INDIRI4
CNSTI4 4
BORI4
ASGNI4
ADDRGP4 $1593
JUMPV
LABELV $1592
line 2296
;2296:		else context |= CONTEXT_CTFBLUETEAM;
ADDRLP4 280
ADDRLP4 280
INDIRI4
CNSTI4 8
BORI4
ASGNI4
LABELV $1593
line 2297
;2297:		trap_BotReplaceSynonyms(ptr, context);
ADDRLP4 276
INDIRP4
ARGP4
ADDRLP4 280
INDIRI4
CVIU4 4
ARGU4
ADDRGP4 trap_BotReplaceSynonyms
CALLV
pop
line 2299
;2298:		//if there's no match
;2299:		if (!BotMatchMessage(bs, m.message)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0+12
ARGP4
ADDRLP4 956
ADDRGP4 BotMatchMessage
CALLI4
ASGNI4
ADDRLP4 956
INDIRI4
CNSTI4 0
NEI4 $1594
line 2301
;2300:			//if it is a chat message
;2301:			if (m.type == CMS_CHAT && !bot_nochat.integer) {
ADDRLP4 0+8
INDIRI4
CNSTI4 1
NEI4 $1597
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
NEI4 $1597
line 2303
;2302:				//
;2303:				if (!trap_BotFindMatch(m.message, &match, MTCONTEXT_REPLYCHAT)) {
ADDRLP4 0+12
ARGP4
ADDRLP4 288
ARGP4
CNSTU4 128
ARGU4
ADDRLP4 960
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 960
INDIRI4
CNSTI4 0
NEI4 $1601
line 2304
;2304:					trap_BotRemoveConsoleMessage(bs->cs, handle);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 284
INDIRI4
ARGI4
ADDRGP4 trap_BotRemoveConsoleMessage
CALLV
pop
line 2305
;2305:					continue;
ADDRGP4 $1574
JUMPV
LABELV $1601
line 2308
;2306:				}
;2307:				//don't use eliza chats with team messages
;2308:				if (match.subtype & ST_TEAM) {
ADDRLP4 288+260
INDIRI4
CNSTI4 32768
BANDI4
CNSTI4 0
EQI4 $1604
line 2309
;2309:					trap_BotRemoveConsoleMessage(bs->cs, handle);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 284
INDIRI4
ARGI4
ADDRGP4 trap_BotRemoveConsoleMessage
CALLV
pop
line 2310
;2310:					continue;
ADDRGP4 $1574
JUMPV
LABELV $1604
line 2313
;2311:				}
;2312:				//
;2313:				trap_BotMatchVariable(&match, NETNAME, netname, sizeof(netname));
ADDRLP4 288
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 872
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 2314
;2314:				trap_BotMatchVariable(&match, MESSAGE, message, sizeof(message));
ADDRLP4 288
ARGP4
CNSTI4 2
ARGI4
ADDRLP4 616
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 2316
;2315:				//if this is a message from the bot self
;2316:				if (!Q_stricmp(netname, botname)) {
ADDRLP4 872
ARGP4
ADDRLP4 908
ARGP4
ADDRLP4 964
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 964
INDIRI4
CNSTI4 0
NEI4 $1607
line 2317
;2317:					trap_BotRemoveConsoleMessage(bs->cs, handle);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 284
INDIRI4
ARGI4
ADDRGP4 trap_BotRemoveConsoleMessage
CALLV
pop
line 2318
;2318:					continue;
ADDRGP4 $1574
JUMPV
LABELV $1607
line 2321
;2319:				}
;2320:				//unify the message
;2321:				trap_UnifyWhiteSpaces(message);
ADDRLP4 616
ARGP4
ADDRGP4 trap_UnifyWhiteSpaces
CALLV
pop
line 2323
;2322:				//
;2323:				trap_Cvar_Update(&bot_testrchat);
ADDRGP4 bot_testrchat
ARGP4
ADDRGP4 trap_Cvar_Update
CALLV
pop
line 2324
;2324:				if (bot_testrchat.integer) {
ADDRGP4 bot_testrchat+12
INDIRI4
CNSTI4 0
EQI4 $1609
line 2326
;2325:					//
;2326:					trap_BotLibVarSet("bot_testrchat", "1");
ADDRGP4 $1612
ARGP4
ADDRGP4 $1613
ARGP4
ADDRGP4 trap_BotLibVarSet
CALLI4
pop
line 2328
;2327:					//if bot replies with a chat message
;2328:					if (trap_BotReplyChat(bs->cs, message, context, CONTEXT_REPLY,
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 616
ARGP4
ADDRLP4 280
INDIRI4
ARGI4
CNSTI4 16
ARGI4
ADDRLP4 968
CNSTP4 0
ASGNP4
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 908
ARGP4
ADDRLP4 872
ARGP4
ADDRLP4 972
ADDRGP4 trap_BotReplyChat
CALLI4
ASGNI4
ADDRLP4 972
INDIRI4
CNSTI4 0
EQI4 $1614
line 2332
;2329:															NULL, NULL,
;2330:															NULL, NULL,
;2331:															NULL, NULL,
;2332:															botname, netname)) {
line 2333
;2333:						BotAI_Print(PRT_MESSAGE, "------------------------\n");
CNSTI4 1
ARGI4
ADDRGP4 $1616
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 2334
;2334:					}
ADDRGP4 $1610
JUMPV
LABELV $1614
line 2335
;2335:					else {
line 2336
;2336:						BotAI_Print(PRT_MESSAGE, "**** no valid reply ****\n");
CNSTI4 1
ARGI4
ADDRGP4 $1617
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 2337
;2337:					}
line 2338
;2338:				}
ADDRGP4 $1610
JUMPV
LABELV $1609
line 2340
;2339:				//if at a valid chat position and not chatting already
;2340:				else if (bs->ainode != AINode_Stand && BotValidChatPosition(bs)) {
ADDRLP4 968
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 968
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 AINode_Stand
CVPU4 4
EQU4 $1618
ADDRLP4 968
INDIRP4
ARGP4
ADDRLP4 972
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 972
INDIRI4
CNSTI4 0
EQI4 $1618
line 2341
;2341:					chat_reply = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_REPLY, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 35
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 976
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 944
ADDRLP4 976
INDIRF4
ASGNF4
line 2342
;2342:					if (random() < 1.5 / (NumBots()+1) && random() < chat_reply) {
ADDRLP4 980
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 984
ADDRGP4 NumBots
CALLI4
ASGNI4
ADDRLP4 980
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1069547520
ADDRLP4 984
INDIRI4
CNSTI4 1
ADDI4
CVIF4 4
DIVF4
GEF4 $1620
ADDRLP4 988
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 988
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 944
INDIRF4
GEF4 $1620
line 2344
;2343:						//if bot replies with a chat message
;2344:						if (trap_BotReplyChat(bs->cs, message, context, CONTEXT_REPLY,
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 616
ARGP4
ADDRLP4 280
INDIRI4
ARGI4
CNSTI4 16
ARGI4
ADDRLP4 992
CNSTP4 0
ASGNP4
ADDRLP4 992
INDIRP4
ARGP4
ADDRLP4 992
INDIRP4
ARGP4
ADDRLP4 992
INDIRP4
ARGP4
ADDRLP4 992
INDIRP4
ARGP4
ADDRLP4 992
INDIRP4
ARGP4
ADDRLP4 992
INDIRP4
ARGP4
ADDRLP4 908
ARGP4
ADDRLP4 872
ARGP4
ADDRLP4 996
ADDRGP4 trap_BotReplyChat
CALLI4
ASGNI4
ADDRLP4 996
INDIRI4
CNSTI4 0
EQI4 $1622
line 2348
;2345:																NULL, NULL,
;2346:																NULL, NULL,
;2347:																NULL, NULL,
;2348:																botname, netname)) {
line 2350
;2349:							//remove the console message
;2350:							trap_BotRemoveConsoleMessage(bs->cs, handle);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 284
INDIRI4
ARGI4
ADDRGP4 trap_BotRemoveConsoleMessage
CALLV
pop
line 2351
;2351:							bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 1000
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1004
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 1000
INDIRF4
ADDRLP4 1004
INDIRF4
ADDF4
ASGNF4
line 2352
;2352:							AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 2354
;2353:							//EA_Say(bs->client, bs->cs.chatmessage);
;2354:							break;
ADDRGP4 $1575
JUMPV
LABELV $1622
line 2356
;2355:						}
;2356:					}
LABELV $1620
line 2357
;2357:				}
LABELV $1618
LABELV $1610
line 2358
;2358:			}
LABELV $1597
line 2359
;2359:		}
LABELV $1594
line 2361
;2360:		//remove the console message
;2361:		trap_BotRemoveConsoleMessage(bs->cs, handle);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 284
INDIRI4
ARGI4
ADDRGP4 trap_BotRemoveConsoleMessage
CALLV
pop
line 2362
;2362:	}
LABELV $1574
line 2275
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 948
ADDRGP4 trap_BotNextConsoleMessage
CALLI4
ASGNI4
ADDRLP4 284
ADDRLP4 948
INDIRI4
ASGNI4
ADDRLP4 948
INDIRI4
CNSTI4 0
NEI4 $1573
LABELV $1575
line 2363
;2363:}
LABELV $1572
endproc BotCheckConsoleMessages 1008 48
export BotCheckEvents
proc BotCheckEvents 168 12
line 2370
;2364:
;2365:/*
;2366:==================
;2367:BotCheckEvents
;2368:==================
;2369:*/
;2370:void BotCheckEvents(bot_state_t *bs, entityState_t *state) {
line 2376
;2371:	int event;
;2372:	char buf[128];
;2373:	//
;2374:	//NOTE: this sucks, we're accessing the gentity_t directly
;2375:	//but there's no other fast way to do it right now
;2376:	if (bs->entityeventTime[state->number] == g_entities[state->number].eventTime) {
ADDRLP4 132
ADDRFP4 4
INDIRP4
INDIRI4
ASGNI4
ADDRLP4 132
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 488
ADDP4
ADDP4
INDIRI4
CNSTI4 792
ADDRLP4 132
INDIRI4
MULI4
ADDRGP4 g_entities+540
ADDP4
INDIRI4
NEI4 $1625
line 2377
;2377:		return;
ADDRGP4 $1624
JUMPV
LABELV $1625
line 2379
;2378:	}
;2379:	bs->entityeventTime[state->number] = g_entities[state->number].eventTime;
ADDRLP4 136
ADDRFP4 4
INDIRP4
INDIRI4
ASGNI4
ADDRLP4 136
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 488
ADDP4
ADDP4
CNSTI4 792
ADDRLP4 136
INDIRI4
MULI4
ADDRGP4 g_entities+540
ADDP4
INDIRI4
ASGNI4
line 2381
;2380:	//if it's an event only entity
;2381:	if (state->eType > ET_EVENTS) {
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 12
LEI4 $1629
line 2382
;2382:		event = (state->eType - ET_EVENTS) & ~EV_EVENT_BITS;
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 12
SUBI4
CNSTI4 -769
BANDI4
ASGNI4
line 2383
;2383:	}
ADDRGP4 $1630
JUMPV
LABELV $1629
line 2384
;2384:	else {
line 2385
;2385:		event = state->event & ~EV_EVENT_BITS;
ADDRLP4 0
ADDRFP4 4
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CNSTI4 -769
BANDI4
ASGNI4
line 2386
;2386:	}
LABELV $1630
line 2388
;2387:	//
;2388:	switch(event) {
ADDRLP4 140
ADDRLP4 0
INDIRI4
ASGNI4
ADDRLP4 144
CNSTI4 42
ASGNI4
ADDRLP4 140
INDIRI4
ADDRLP4 144
INDIRI4
EQI4 $1656
ADDRLP4 140
INDIRI4
CNSTI4 45
EQI4 $1657
ADDRLP4 140
INDIRI4
CNSTI4 46
EQI4 $1642
ADDRLP4 140
INDIRI4
ADDRLP4 144
INDIRI4
LTI4 $1631
LABELV $1669
ADDRLP4 0
INDIRI4
CNSTI4 58
EQI4 $1633
ADDRGP4 $1631
JUMPV
LABELV $1633
line 2391
;2389:		//client obituary event
;2390:		case EV_OBITUARY:
;2391:		{
line 2394
;2392:			int target, attacker, mod;
;2393:
;2394:			target = state->otherEntityNum;
ADDRLP4 148
ADDRFP4 4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ASGNI4
line 2395
;2395:			attacker = state->otherEntityNum2;
ADDRLP4 152
ADDRFP4 4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
line 2396
;2396:			mod = state->eventParm;
ADDRLP4 156
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 2398
;2397:			//
;2398:			if (target == bs->client) {
ADDRLP4 148
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $1634
line 2399
;2399:				bs->botdeathtype = mod;
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
ADDRLP4 156
INDIRI4
ASGNI4
line 2400
;2400:				bs->lastkilledby = attacker;
ADDRFP4 0
INDIRP4
CNSTI4 5972
ADDP4
ADDRLP4 152
INDIRI4
ASGNI4
line 2402
;2401:				//
;2402:				if (target == attacker) bs->botsuicide = qtrue;
ADDRLP4 148
INDIRI4
ADDRLP4 152
INDIRI4
NEI4 $1636
ADDRFP4 0
INDIRP4
CNSTI4 5984
ADDP4
CNSTI4 1
ASGNI4
ADDRGP4 $1637
JUMPV
LABELV $1636
line 2403
;2403:				else bs->botsuicide = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 5984
ADDP4
CNSTI4 0
ASGNI4
LABELV $1637
line 2405
;2404:				//
;2405:				bs->num_deaths++;
ADDRLP4 160
ADDRFP4 0
INDIRP4
CNSTI4 6000
ADDP4
ASGNP4
ADDRLP4 160
INDIRP4
ADDRLP4 160
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2406
;2406:			}
ADDRGP4 $1632
JUMPV
LABELV $1634
line 2408
;2407:			//else if this client was killed by the bot
;2408:			else if (attacker == bs->client) {
ADDRLP4 152
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $1638
line 2409
;2409:				bs->enemydeathtype = mod;
ADDRFP4 0
INDIRP4
CNSTI4 5980
ADDP4
ADDRLP4 156
INDIRI4
ASGNI4
line 2410
;2410:				bs->lastkilledplayer = target;
ADDRFP4 0
INDIRP4
CNSTI4 5968
ADDP4
ADDRLP4 148
INDIRI4
ASGNI4
line 2411
;2411:				bs->killedenemy_time = trap_AAS_Time();
ADDRLP4 160
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6132
ADDP4
ADDRLP4 160
INDIRF4
ASGNF4
line 2413
;2412:				//
;2413:				bs->num_kills++;
ADDRLP4 164
ADDRFP4 0
INDIRP4
CNSTI4 6004
ADDP4
ASGNP4
ADDRLP4 164
INDIRP4
ADDRLP4 164
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2414
;2414:			}
ADDRGP4 $1632
JUMPV
LABELV $1638
line 2415
;2415:			else if (attacker == bs->enemy && target == attacker) {
ADDRLP4 160
ADDRLP4 152
INDIRI4
ASGNI4
ADDRLP4 160
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
NEI4 $1632
ADDRLP4 148
INDIRI4
ADDRLP4 160
INDIRI4
NEI4 $1632
line 2416
;2416:				bs->enemysuicide = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 5988
ADDP4
CNSTI4 1
ASGNI4
line 2417
;2417:			}
line 2418
;2418:			break;
ADDRGP4 $1632
JUMPV
LABELV $1642
line 2421
;2419:		}
;2420:		case EV_GLOBAL_SOUND:
;2421:		{
line 2422
;2422:			if (state->eventParm < 0 || state->eventParm > MAX_SOUNDS) {
ADDRLP4 148
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
LTI4 $1645
ADDRLP4 148
INDIRI4
CNSTI4 256
LEI4 $1643
LABELV $1645
line 2423
;2423:				BotAI_Print(PRT_ERROR, "EV_GLOBAL_SOUND: eventParm (%d) out of range\n", state->eventParm);
CNSTI4 3
ARGI4
ADDRGP4 $1646
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 2424
;2424:				break;
ADDRGP4 $1632
JUMPV
LABELV $1643
line 2426
;2425:			}
;2426:			trap_GetConfigstring(CS_SOUNDS + state->eventParm, buf, sizeof(buf));
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 288
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 2427
;2427:			if (!strcmp(buf, "sound/teamplay/flagret_red.wav")) {
ADDRLP4 4
ARGP4
ADDRGP4 $1649
ARGP4
ADDRLP4 152
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 152
INDIRI4
CNSTI4 0
NEI4 $1647
line 2429
;2428:				//red flag is returned
;2429:				bs->redflagstatus = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6492
ADDP4
CNSTI4 0
ASGNI4
line 2430
;2430:				bs->flagstatuschanged = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 6500
ADDP4
CNSTI4 1
ASGNI4
line 2431
;2431:			}
ADDRGP4 $1632
JUMPV
LABELV $1647
line 2432
;2432:			else if (!strcmp(buf, "sound/teamplay/flagret_blu.wav")) {
ADDRLP4 4
ARGP4
ADDRGP4 $1652
ARGP4
ADDRLP4 156
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 156
INDIRI4
CNSTI4 0
NEI4 $1650
line 2434
;2433:				//blue flag is returned
;2434:				bs->blueflagstatus = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6496
ADDP4
CNSTI4 0
ASGNI4
line 2435
;2435:				bs->flagstatuschanged = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 6500
ADDP4
CNSTI4 1
ASGNI4
line 2436
;2436:			}
ADDRGP4 $1632
JUMPV
LABELV $1650
line 2437
;2437:			else if (!strcmp(buf, "sound/items/poweruprespawn.wav")) {
ADDRLP4 4
ARGP4
ADDRGP4 $1655
ARGP4
ADDRLP4 160
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
NEI4 $1632
line 2439
;2438:				//powerup respawned... go get it
;2439:				BotGoForPowerups(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotGoForPowerups
CALLV
pop
line 2440
;2440:			}
line 2441
;2441:			break;
ADDRGP4 $1632
JUMPV
LABELV $1656
line 2444
;2442:		}
;2443:		case EV_PLAYER_TELEPORT_IN:
;2444:		{
line 2445
;2445:			VectorCopy(state->origin, lastteleport_origin);
ADDRGP4 lastteleport_origin
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 2446
;2446:			lastteleport_time = trap_AAS_Time();
ADDRLP4 148
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRGP4 lastteleport_time
ADDRLP4 148
INDIRF4
ASGNF4
line 2447
;2447:			break;
ADDRGP4 $1632
JUMPV
LABELV $1657
line 2450
;2448:		}
;2449:		case EV_GENERAL_SOUND:
;2450:		{
line 2452
;2451:			//if this sound is played on the bot
;2452:			if (state->number == bs->client) {
ADDRFP4 4
INDIRP4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $1632
line 2453
;2453:				if (state->eventParm < 0 || state->eventParm > MAX_SOUNDS) {
ADDRLP4 148
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
LTI4 $1662
ADDRLP4 148
INDIRI4
CNSTI4 256
LEI4 $1660
LABELV $1662
line 2454
;2454:					BotAI_Print(PRT_ERROR, "EV_GENERAL_SOUND: eventParm (%d) out of range\n", state->eventParm);
CNSTI4 3
ARGI4
ADDRGP4 $1663
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 2455
;2455:					break;
ADDRGP4 $1632
JUMPV
LABELV $1660
line 2458
;2456:				}
;2457:				//check out the sound
;2458:				trap_GetConfigstring(CS_SOUNDS + state->eventParm, buf, sizeof(buf));
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 288
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 2460
;2459:				//if falling into a death pit
;2460:				if (!strcmp(buf, "*falling1.wav")) {
ADDRLP4 4
ARGP4
ADDRGP4 $1666
ARGP4
ADDRLP4 152
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 152
INDIRI4
CNSTI4 0
NEI4 $1632
line 2462
;2461:					//if the bot has a personal teleporter
;2462:					if (bs->inventory[INVENTORY_TELEPORTER] > 0) {
ADDRFP4 0
INDIRP4
CNSTI4 5028
ADDP4
INDIRI4
CNSTI4 0
LEI4 $1632
line 2464
;2463:						//use the holdable item
;2464:						trap_EA_Use(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Use
CALLV
pop
line 2465
;2465:					}
line 2466
;2466:				}
line 2467
;2467:			}
line 2468
;2468:			break;
LABELV $1631
LABELV $1632
line 2471
;2469:		}
;2470:	}
;2471:}
LABELV $1624
endproc BotCheckEvents 168 12
export BotCheckSnapshot
proc BotCheckSnapshot 212 12
line 2478
;2472:
;2473:/*
;2474:==================
;2475:BotCheckSnapshot
;2476:==================
;2477:*/
;2478:void BotCheckSnapshot(bot_state_t *bs) {
line 2483
;2479:	int ent;
;2480:	entityState_t state;
;2481:
;2482:	//
;2483:	ent = 0;
ADDRLP4 204
CNSTI4 0
ASGNI4
ADDRGP4 $1672
JUMPV
LABELV $1671
line 2484
;2484:	while( ( ent = BotAI_GetSnapshotEntity( bs->client, ent, &state ) ) != -1 ) {
line 2486
;2485:		//check the entity state for events
;2486:		BotCheckEvents(bs, &state);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotCheckEvents
CALLV
pop
line 2487
;2487:	}
LABELV $1672
line 2484
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 204
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 208
ADDRGP4 BotAI_GetSnapshotEntity
CALLI4
ASGNI4
ADDRLP4 204
ADDRLP4 208
INDIRI4
ASGNI4
ADDRLP4 208
INDIRI4
CNSTI4 -1
NEI4 $1671
line 2489
;2488:	//check the player state for events
;2489:	BotAI_GetEntityState(bs->client, &state);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotAI_GetEntityState
CALLI4
pop
line 2491
;2490:	//copy the player state events to the entity state
;2491:	state.event = bs->cur_ps.externalEvent;
ADDRLP4 0+180
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
line 2492
;2492:	state.eventParm = bs->cur_ps.externalEventParm;
ADDRLP4 0+184
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ASGNI4
line 2494
;2493:	//
;2494:	BotCheckEvents(bs, &state);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotCheckEvents
CALLV
pop
line 2495
;2495:}
LABELV $1670
endproc BotCheckSnapshot 212 12
export BotCheckAir
proc BotCheckAir 4 4
line 2502
;2496:
;2497:/*
;2498:==================
;2499:BotCheckAir
;2500:==================
;2501:*/
;2502:void BotCheckAir(bot_state_t *bs) {
line 2503
;2503:	if (bs->inventory[INVENTORY_ENVIRONMENTSUIT] <= 0) {
ADDRFP4 0
INDIRP4
CNSTI4 5040
ADDP4
INDIRI4
CNSTI4 0
GTI4 $1677
line 2504
;2504:		if (trap_AAS_PointContents(bs->eye) & (CONTENTS_WATER|CONTENTS_SLIME|CONTENTS_LAVA)) {
ADDRFP4 0
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 0
ADDRGP4 trap_AAS_PointContents
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $1679
line 2505
;2505:			return;
ADDRGP4 $1676
JUMPV
LABELV $1679
line 2507
;2506:		}
;2507:	}
LABELV $1677
line 2508
;2508:	bs->lastair_time = trap_AAS_Time();
ADDRLP4 0
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6140
ADDP4
ADDRLP4 0
INDIRF4
ASGNF4
line 2509
;2509:}
LABELV $1676
endproc BotCheckAir 4 4
export BotDeathmatchAI
proc BotDeathmatchAI 1492 20
line 2516
;2510:
;2511:/*
;2512:==================
;2513:BotDeathmatchAI
;2514:==================
;2515:*/
;2516:void BotDeathmatchAI(bot_state_t *bs, float thinktime) {
line 2522
;2517:	char gender[144], name[144], buf[144];
;2518:	char userinfo[MAX_INFO_STRING];
;2519:	int i;
;2520:
;2521:	//if the bot has just been setup
;2522:	if (bs->setupcount > 0) {
ADDRFP4 0
INDIRP4
CNSTI4 5992
ADDP4
INDIRI4
CNSTI4 0
LEI4 $1682
line 2523
;2523:		bs->setupcount--;
ADDRLP4 1460
ADDRFP4 0
INDIRP4
CNSTI4 5992
ADDP4
ASGNP4
ADDRLP4 1460
INDIRP4
ADDRLP4 1460
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 2524
;2524:		if (bs->setupcount > 0) return;
ADDRFP4 0
INDIRP4
CNSTI4 5992
ADDP4
INDIRI4
CNSTI4 0
LEI4 $1684
ADDRGP4 $1681
JUMPV
LABELV $1684
line 2526
;2525:		//get the gender characteristic
;2526:		trap_Characteristic_String(bs->character, CHARACTERISTIC_GENDER, gender, sizeof(gender));
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 148
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_Characteristic_String
CALLV
pop
line 2528
;2527:		//set the bot gender
;2528:		trap_GetUserinfo(bs->client, userinfo, sizeof(userinfo));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 292
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 2529
;2529:		Info_SetValueForKey(userinfo, "sex", gender);
ADDRLP4 292
ARGP4
ADDRGP4 $1686
ARGP4
ADDRLP4 148
ARGP4
ADDRGP4 Info_SetValueForKey
CALLV
pop
line 2530
;2530:		trap_SetUserinfo(bs->client, userinfo);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 292
ARGP4
ADDRGP4 trap_SetUserinfo
CALLV
pop
line 2532
;2531:		//set the team
;2532:		if ( g_gametype.integer != GT_TOURNAMENT ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
EQI4 $1687
line 2533
;2533:			Com_sprintf(buf, sizeof(buf), "team %s", bs->settings.team);
ADDRLP4 1316
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 $1690
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 4732
ADDP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 2534
;2534:			trap_EA_Command(bs->client, buf);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 1316
ARGP4
ADDRGP4 trap_EA_Command
CALLV
pop
line 2535
;2535:		}
LABELV $1687
line 2537
;2536:		//set the chat gender
;2537:		if (gender[0] == 'm') trap_BotSetChatGender(bs->cs, CHAT_GENDERMALE);
ADDRLP4 148
INDIRI1
CVII4 1
CNSTI4 109
NEI4 $1691
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_BotSetChatGender
CALLV
pop
ADDRGP4 $1692
JUMPV
LABELV $1691
line 2538
;2538:		else if (gender[0] == 'f')  trap_BotSetChatGender(bs->cs, CHAT_GENDERFEMALE);
ADDRLP4 148
INDIRI1
CVII4 1
CNSTI4 102
NEI4 $1693
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotSetChatGender
CALLV
pop
ADDRGP4 $1694
JUMPV
LABELV $1693
line 2539
;2539:		else  trap_BotSetChatGender(bs->cs, CHAT_GENDERLESS);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotSetChatGender
CALLV
pop
LABELV $1694
LABELV $1692
line 2541
;2540:		//set the chat name
;2541:		ClientName(bs->client, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 2542
;2542:		trap_BotSetChatName(bs->cs, name);
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 trap_BotSetChatName
CALLV
pop
line 2544
;2543:		//
;2544:		bs->lastframe_health = bs->inventory[INVENTORY_HEALTH];
ADDRLP4 1464
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1464
INDIRP4
CNSTI4 6016
ADDP4
ADDRLP4 1464
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
ASGNI4
line 2545
;2545:		bs->lasthitcount = bs->cur_ps.persistant[PERS_HITS];
ADDRLP4 1468
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1468
INDIRP4
CNSTI4 6020
ADDP4
ADDRLP4 1468
INDIRP4
CNSTI4 268
ADDP4
INDIRI4
ASGNI4
line 2547
;2546:		//
;2547:		bs->setupcount = 0;
ADDRFP4 0
INDIRP4
CNSTI4 5992
ADDP4
CNSTI4 0
ASGNI4
line 2548
;2548:	}
LABELV $1682
line 2550
;2549:	//no ideal view set
;2550:	bs->flags &= ~BFL_IDEALVIEWSET;
ADDRLP4 1460
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 1460
INDIRP4
ADDRLP4 1460
INDIRP4
INDIRI4
CNSTI4 -33
BANDI4
ASGNI4
line 2552
;2551:	//set the teleport time
;2552:	BotSetTeleportTime(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetTeleportTime
CALLV
pop
line 2554
;2553:	//update some inventory values
;2554:	BotUpdateInventory(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotUpdateInventory
CALLV
pop
line 2556
;2555:	//check the console messages
;2556:	BotCheckConsoleMessages(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCheckConsoleMessages
CALLV
pop
line 2558
;2557:	//check out the snapshot
;2558:	BotCheckSnapshot(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCheckSnapshot
CALLV
pop
line 2560
;2559:	//check for air
;2560:	BotCheckAir(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCheckAir
CALLV
pop
line 2562
;2561:	//if not in the intermission and not in observer mode
;2562:	if (!BotIntermission(bs) && !BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1464
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 1464
INDIRI4
CNSTI4 0
NEI4 $1695
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1468
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 1468
INDIRI4
CNSTI4 0
NEI4 $1695
line 2564
;2563:		//do team AI
;2564:		BotTeamAI(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotTeamAI
CALLV
pop
line 2565
;2565:	}
LABELV $1695
line 2567
;2566:	//if the bot has no ai node
;2567:	if (!bs->ainode) {
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1697
line 2568
;2568:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 2569
;2569:	}
LABELV $1697
line 2571
;2570:	//if the bot entered the game less than 8 seconds ago
;2571:	if (!bs->entergamechat && bs->entergame_time > trap_AAS_Time() - 8) {
ADDRLP4 1472
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1472
INDIRP4
CNSTI4 5996
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1699
ADDRLP4 1476
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 1472
INDIRP4
CNSTI4 6036
ADDP4
INDIRF4
ADDRLP4 1476
INDIRF4
CNSTF4 1090519040
SUBF4
LEF4 $1699
line 2572
;2572:		if (BotChat_EnterGame(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1480
ADDRGP4 BotChat_EnterGame
CALLI4
ASGNI4
ADDRLP4 1480
INDIRI4
CNSTI4 0
EQI4 $1701
line 2573
;2573:			bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 1484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1488
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 1484
INDIRF4
ADDRLP4 1488
INDIRF4
ADDF4
ASGNF4
line 2574
;2574:			AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 2575
;2575:		}
LABELV $1701
line 2576
;2576:		bs->entergamechat = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 5996
ADDP4
CNSTI4 1
ASGNI4
line 2577
;2577:	}
LABELV $1699
line 2579
;2578:	//reset the node switches from the previous frame
;2579:	BotResetNodeSwitches();
ADDRGP4 BotResetNodeSwitches
CALLV
pop
line 2581
;2580:	//execute AI nodes
;2581:	for (i = 0; i < MAX_NODESWITCHES; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1703
line 2582
;2582:		if (bs->ainode(bs)) break;
ADDRLP4 1480
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1480
INDIRP4
ARGP4
ADDRLP4 1484
ADDRLP4 1480
INDIRP4
CNSTI4 4876
ADDP4
INDIRP4
CALLI4
ASGNI4
ADDRLP4 1484
INDIRI4
CNSTI4 0
EQI4 $1707
ADDRGP4 $1705
JUMPV
LABELV $1707
line 2583
;2583:	}
LABELV $1704
line 2581
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 50
LTI4 $1703
LABELV $1705
line 2585
;2584:	//if the bot removed itself :)
;2585:	if (!bs->inuse) return;
ADDRFP4 0
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $1709
ADDRGP4 $1681
JUMPV
LABELV $1709
line 2587
;2586:	//if the bot executed too many AI nodes
;2587:	if (i >= MAX_NODESWITCHES) {
ADDRLP4 0
INDIRI4
CNSTI4 50
LTI4 $1711
line 2588
;2588:		trap_BotDumpGoalStack(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotDumpGoalStack
CALLV
pop
line 2589
;2589:		trap_BotDumpAvoidGoals(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotDumpAvoidGoals
CALLV
pop
line 2590
;2590:		BotDumpNodeSwitches(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotDumpNodeSwitches
CALLV
pop
line 2591
;2591:		ClientName(bs->client, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 2592
;2592:		BotAI_Print(PRT_ERROR, "%s at %1.1f switched more than %d AI nodes\n", name, trap_AAS_Time(), MAX_NODESWITCHES);
ADDRLP4 1480
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
CNSTI4 3
ARGI4
ADDRGP4 $1713
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 1480
INDIRF4
ARGF4
CNSTI4 50
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 2593
;2593:	}
LABELV $1711
line 2595
;2594:	//
;2595:	bs->lastframe_health = bs->inventory[INVENTORY_HEALTH];
ADDRLP4 1480
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1480
INDIRP4
CNSTI4 6016
ADDP4
ADDRLP4 1480
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
ASGNI4
line 2596
;2596:	bs->lasthitcount = bs->cur_ps.persistant[PERS_HITS];
ADDRLP4 1484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1484
INDIRP4
CNSTI4 6020
ADDP4
ADDRLP4 1484
INDIRP4
CNSTI4 268
ADDP4
INDIRI4
ASGNI4
line 2597
;2597:}
LABELV $1681
endproc BotDeathmatchAI 1492 20
export BotSetupDeathmatchAI
proc BotSetupDeathmatchAI 156 16
line 2604
;2598:
;2599:/*
;2600:==================
;2601:BotSetupDeathmatchAI
;2602:==================
;2603:*/
;2604:void BotSetupDeathmatchAI(void) {
line 2608
;2605:	int ent, modelnum;
;2606:	char model[128];
;2607:
;2608:	gametype = trap_Cvar_VariableIntegerValue("g_gametype");
ADDRGP4 $1715
ARGP4
ADDRLP4 136
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 gametype
ADDRLP4 136
INDIRI4
ASGNI4
line 2609
;2609:	maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $175
ARGP4
ADDRLP4 140
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 maxclients
ADDRLP4 140
INDIRI4
ASGNI4
line 2611
;2610:
;2611:	trap_Cvar_Register(&bot_rocketjump, "bot_rocketjump", "1", 0);
ADDRGP4 bot_rocketjump
ARGP4
ADDRGP4 $1716
ARGP4
ADDRGP4 $1613
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 2612
;2612:	trap_Cvar_Register(&bot_grapple, "bot_grapple", "0", 0);
ADDRGP4 bot_grapple
ARGP4
ADDRGP4 $1717
ARGP4
ADDRGP4 $1718
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 2613
;2613:	trap_Cvar_Register(&bot_fastchat, "bot_fastchat", "0", 0);
ADDRGP4 bot_fastchat
ARGP4
ADDRGP4 $1719
ARGP4
ADDRGP4 $1718
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 2614
;2614:	trap_Cvar_Register(&bot_nochat, "bot_nochat", "0", 0);
ADDRGP4 bot_nochat
ARGP4
ADDRGP4 $1720
ARGP4
ADDRGP4 $1718
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 2615
;2615:	trap_Cvar_Register(&bot_testrchat, "bot_testrchat", "0", 0);
ADDRGP4 bot_testrchat
ARGP4
ADDRGP4 $1612
ARGP4
ADDRGP4 $1718
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 2616
;2616:	trap_Cvar_Register(&bot_challenge, "bot_challenge", "0", 0);
ADDRGP4 bot_challenge
ARGP4
ADDRGP4 $1721
ARGP4
ADDRGP4 $1718
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 trap_Cvar_Register
CALLV
pop
line 2618
;2617:	//
;2618:	if (gametype == GT_CTF) {
ADDRGP4 gametype
INDIRI4
CNSTI4 4
NEI4 $1722
line 2619
;2619:		if (trap_BotGetLevelItemGoal(-1, "Red Flag", &ctf_redflag) < 0)
CNSTI4 -1
ARGI4
ADDRGP4 $1726
ARGP4
ADDRGP4 ctf_redflag
ARGP4
ADDRLP4 144
ADDRGP4 trap_BotGetLevelItemGoal
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
GEI4 $1724
line 2620
;2620:			BotAI_Print(PRT_WARNING, "CTF without Red Flag\n");
CNSTI4 2
ARGI4
ADDRGP4 $1727
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
LABELV $1724
line 2621
;2621:		if (trap_BotGetLevelItemGoal(-1, "Blue Flag", &ctf_blueflag) < 0)
CNSTI4 -1
ARGI4
ADDRGP4 $1730
ARGP4
ADDRGP4 ctf_blueflag
ARGP4
ADDRLP4 148
ADDRGP4 trap_BotGetLevelItemGoal
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
GEI4 $1728
line 2622
;2622:			BotAI_Print(PRT_WARNING, "CTF without Blue Flag\n");
CNSTI4 2
ARGI4
ADDRGP4 $1731
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
LABELV $1728
line 2623
;2623:	}
LABELV $1722
line 2625
;2624:
;2625:	max_bspmodelindex = 0;
ADDRGP4 max_bspmodelindex
CNSTI4 0
ASGNI4
line 2626
;2626:	for (ent = trap_AAS_NextBSPEntity(0); ent; ent = trap_AAS_NextBSPEntity(ent)) {
CNSTI4 0
ARGI4
ADDRLP4 144
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 144
INDIRI4
ASGNI4
ADDRGP4 $1735
JUMPV
LABELV $1732
line 2627
;2627:		if (!trap_AAS_ValueForBSPEpairKey(ent, "model", model, sizeof(model))) continue;
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 $170
ARGP4
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 148
ADDRGP4 trap_AAS_ValueForBSPEpairKey
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
NEI4 $1736
ADDRGP4 $1733
JUMPV
LABELV $1736
line 2628
;2628:		if (model[0] == '*') {
ADDRLP4 4
INDIRI1
CVII4 1
CNSTI4 42
NEI4 $1738
line 2629
;2629:			modelnum = atoi(model+1);
ADDRLP4 4+1
ARGP4
ADDRLP4 152
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 132
ADDRLP4 152
INDIRI4
ASGNI4
line 2630
;2630:			if (modelnum > max_bspmodelindex)
ADDRLP4 132
INDIRI4
ADDRGP4 max_bspmodelindex
INDIRI4
LEI4 $1741
line 2631
;2631:				max_bspmodelindex = modelnum;
ADDRGP4 max_bspmodelindex
ADDRLP4 132
INDIRI4
ASGNI4
LABELV $1741
line 2632
;2632:		}
LABELV $1738
line 2633
;2633:	}
LABELV $1733
line 2626
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 148
ADDRGP4 trap_AAS_NextBSPEntity
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 148
INDIRI4
ASGNI4
LABELV $1735
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $1732
line 2635
;2634:	//initialize the waypoint heap
;2635:	BotInitWaypoints();
ADDRGP4 BotInitWaypoints
CALLV
pop
line 2636
;2636:}
LABELV $1714
endproc BotSetupDeathmatchAI 156 16
export BotShutdownDeathmatchAI
proc BotShutdownDeathmatchAI 0 0
line 2643
;2637:
;2638:/*
;2639:==================
;2640:BotShutdownDeathmatchAI
;2641:==================
;2642:*/
;2643:void BotShutdownDeathmatchAI(void) {
line 2644
;2644:}
LABELV $1743
endproc BotShutdownDeathmatchAI 0 0
bss
export max_bspmodelindex
align 4
LABELV max_bspmodelindex
skip 4
export lastteleport_time
align 4
LABELV lastteleport_time
skip 4
export lastteleport_origin
align 4
LABELV lastteleport_origin
skip 12
export botai_freewaypoints
align 4
LABELV botai_freewaypoints
skip 4
export botai_waypoints
align 4
LABELV botai_waypoints
skip 12800
import BotSetTeamMateCTFPreference
import BotGetTeamMateCTFPreference
import BotTeamAI
import BotDumpNodeSwitches
import BotResetNodeSwitches
import AINode_Battle_NBG
import AINode_Battle_Retreat
import AINode_Battle_Chase
import AINode_Battle_Fight
import AINode_Seek_LTG
import AINode_Seek_NBG
import AINode_Seek_ActivateEntity
import AINode_Stand
import AINode_Respawn
import AINode_Observer
import AINode_Intermission
import AIEnter_Battle_NBG
import AIEnter_Battle_Retreat
import AIEnter_Battle_Chase
import AIEnter_Battle_Fight
import AIEnter_Seek_Camp
import AIEnter_Seek_LTG
import AIEnter_Seek_NBG
import AIEnter_Seek_ActivateEntity
import AIEnter_Stand
import AIEnter_Respawn
import AIEnter_Observer
import AIEnter_Intermission
import BotPrintTeamGoal
import BotMatchMessage
import BotChatTest
import BotValidChatPosition
import BotChatTime
import BotChat_Random
import BotChat_EnemySuicide
import BotChat_Kill
import BotChat_Death
import BotChat_HitNoKill
import BotChat_HitNoDeath
import BotChat_HitTalking
import BotChat_EndLevel
import BotChat_StartLevel
import BotChat_ExitGame
import BotChat_EnterGame
export ctf_blueflag
align 4
LABELV ctf_blueflag
skip 56
export ctf_redflag
align 4
LABELV ctf_redflag
skip 56
export bot_challenge
align 4
LABELV bot_challenge
skip 272
export bot_testrchat
align 4
LABELV bot_testrchat
skip 272
export bot_nochat
align 4
LABELV bot_nochat
skip 272
export bot_fastchat
align 4
LABELV bot_fastchat
skip 272
export bot_rocketjump
align 4
LABELV bot_rocketjump
skip 272
export bot_grapple
align 4
LABELV bot_grapple
skip 272
export maxclients
align 4
LABELV maxclients
skip 4
export gametype
align 4
LABELV gametype
skip 4
import BotTeamLeader
import BotAI_GetSnapshotEntity
import BotAI_GetEntityState
import BotAI_GetClientState
import BotAI_Trace
import BotAI_BotInitialChat
import BotAI_Print
import BotEntityInfo
import NumBots
import BotResetState
import BotResetWeaponState
import BotFreeWeaponState
import BotAllocWeaponState
import BotLoadWeaponWeights
import BotGetWeaponInfo
import BotChooseBestFightWeapon
import BotShutdownWeaponAI
import BotSetupWeaponAI
import BotShutdownMoveAI
import BotSetupMoveAI
import BotSetBrushModelTypes
import BotInitMoveState
import BotFreeMoveState
import BotAllocMoveState
import BotPredictVisiblePosition
import BotMovementViewTarget
import BotReachabilityArea
import BotResetLastAvoidReach
import BotResetAvoidReach
import BotMoveInDirection
import BotMoveToGoal
import BotResetMoveState
import BotShutdownGoalAI
import BotSetupGoalAI
import BotFreeGoalState
import BotAllocGoalState
import BotFreeItemWeights
import BotLoadItemWeights
import BotMutateGoalFuzzyLogic
import BotSaveGoalFuzzyLogic
import BotInterbreedGoalFuzzyLogic
import BotUpdateEntityItems
import BotInitLevelItems
import BotAvoidGoalTime
import BotGetMapLocationGoal
import BotGetNextCampSpotGoal
import BotGetLevelItemGoal
import BotItemGoalInVisButNotVisible
import BotTouchingGoal
import BotChooseNBGItem
import BotChooseLTGItem
import BotGetSecondGoal
import BotGetTopGoal
import BotGoalName
import BotDumpGoalStack
import BotDumpAvoidGoals
import BotEmptyGoalStack
import BotPopGoal
import BotPushGoal
import BotRemoveFromAvoidGoals
import BotResetAvoidGoals
import BotResetGoalState
import GeneticParentsAndChildSelection
import BotSetChatName
import BotSetChatGender
import BotLoadChatFile
import BotReplaceSynonyms
import UnifyWhiteSpaces
import BotMatchVariable
import BotFindMatch
import StringContains
import BotGetChatMessage
import BotEnterChat
import BotChatLength
import BotReplyChat
import BotNumInitialChats
import BotInitialChat
import BotNumConsoleMessages
import BotNextConsoleMessage
import BotRemoveConsoleMessage
import BotQueueConsoleMessage
import BotFreeChatState
import BotAllocChatState
import BotShutdownChatAI
import BotSetupChatAI
import BotShutdownCharacters
import Characteristic_String
import Characteristic_BInteger
import Characteristic_Integer
import Characteristic_BFloat
import Characteristic_Float
import BotFreeCharacter
import BotLoadCharacter
import EA_Shutdown
import EA_Setup
import EA_ResetInput
import EA_GetInput
import EA_EndRegular
import EA_View
import EA_Move
import EA_MoveRight
import EA_MoveLeft
import EA_MoveBack
import EA_MoveForward
import EA_MoveDown
import EA_MoveUp
import EA_Walk
import EA_Crouch
import EA_DelayedJump
import EA_Jump
import EA_Use
import EA_Gesture
import EA_Talk
import EA_Respawn
import EA_Attack
import EA_SelectWeapon
import EA_Command
import EA_DropInv
import EA_UseInv
import EA_DropItem
import EA_UseItem
import EA_SayTeam
import EA_Say
import GetBotLibAPI
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $1731
byte 1 67
byte 1 84
byte 1 70
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $1730
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $1727
byte 1 67
byte 1 84
byte 1 70
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 10
byte 1 0
align 1
LABELV $1726
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $1721
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 99
byte 1 104
byte 1 97
byte 1 108
byte 1 108
byte 1 101
byte 1 110
byte 1 103
byte 1 101
byte 1 0
align 1
LABELV $1720
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 110
byte 1 111
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $1719
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 102
byte 1 97
byte 1 115
byte 1 116
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $1718
byte 1 48
byte 1 0
align 1
LABELV $1717
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 103
byte 1 114
byte 1 97
byte 1 112
byte 1 112
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $1716
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 106
byte 1 117
byte 1 109
byte 1 112
byte 1 0
align 1
LABELV $1715
byte 1 103
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 0
align 1
LABELV $1713
byte 1 37
byte 1 115
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 49
byte 1 46
byte 1 49
byte 1 102
byte 1 32
byte 1 115
byte 1 119
byte 1 105
byte 1 116
byte 1 99
byte 1 104
byte 1 101
byte 1 100
byte 1 32
byte 1 109
byte 1 111
byte 1 114
byte 1 101
byte 1 32
byte 1 116
byte 1 104
byte 1 97
byte 1 110
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 65
byte 1 73
byte 1 32
byte 1 110
byte 1 111
byte 1 100
byte 1 101
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $1690
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $1686
byte 1 115
byte 1 101
byte 1 120
byte 1 0
align 1
LABELV $1666
byte 1 42
byte 1 102
byte 1 97
byte 1 108
byte 1 108
byte 1 105
byte 1 110
byte 1 103
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $1663
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 69
byte 1 78
byte 1 69
byte 1 82
byte 1 65
byte 1 76
byte 1 95
byte 1 83
byte 1 79
byte 1 85
byte 1 78
byte 1 68
byte 1 58
byte 1 32
byte 1 101
byte 1 118
byte 1 101
byte 1 110
byte 1 116
byte 1 80
byte 1 97
byte 1 114
byte 1 109
byte 1 32
byte 1 40
byte 1 37
byte 1 100
byte 1 41
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $1655
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 47
byte 1 112
byte 1 111
byte 1 119
byte 1 101
byte 1 114
byte 1 117
byte 1 112
byte 1 114
byte 1 101
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $1652
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 116
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $1649
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 116
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $1646
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 76
byte 1 79
byte 1 66
byte 1 65
byte 1 76
byte 1 95
byte 1 83
byte 1 79
byte 1 85
byte 1 78
byte 1 68
byte 1 58
byte 1 32
byte 1 101
byte 1 118
byte 1 101
byte 1 110
byte 1 116
byte 1 80
byte 1 97
byte 1 114
byte 1 109
byte 1 32
byte 1 40
byte 1 37
byte 1 100
byte 1 41
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $1617
byte 1 42
byte 1 42
byte 1 42
byte 1 42
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 118
byte 1 97
byte 1 108
byte 1 105
byte 1 100
byte 1 32
byte 1 114
byte 1 101
byte 1 112
byte 1 108
byte 1 121
byte 1 32
byte 1 42
byte 1 42
byte 1 42
byte 1 42
byte 1 10
byte 1 0
align 1
LABELV $1616
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 45
byte 1 10
byte 1 0
align 1
LABELV $1613
byte 1 49
byte 1 0
align 1
LABELV $1612
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 116
byte 1 101
byte 1 115
byte 1 116
byte 1 114
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $1433
byte 1 97
byte 1 110
byte 1 103
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $1430
byte 1 108
byte 1 105
byte 1 112
byte 1 0
align 1
LABELV $1422
byte 1 0
align 1
LABELV $1391
byte 1 66
byte 1 111
byte 1 116
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 84
byte 1 111
byte 1 65
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 101
byte 1 58
byte 1 32
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 111
byte 1 114
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 10
byte 1 0
align 1
LABELV $1389
byte 1 116
byte 1 114
byte 1 105
byte 1 103
byte 1 103
byte 1 101
byte 1 114
byte 1 95
byte 1 109
byte 1 117
byte 1 108
byte 1 116
byte 1 105
byte 1 112
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $1386
byte 1 102
byte 1 117
byte 1 110
byte 1 99
byte 1 95
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $1383
byte 1 66
byte 1 111
byte 1 116
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 84
byte 1 111
byte 1 65
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 101
byte 1 58
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $1380
byte 1 66
byte 1 111
byte 1 116
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 84
byte 1 111
byte 1 65
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 101
byte 1 58
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 10
byte 1 0
align 1
LABELV $1375
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $1364
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $1359
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $1356
byte 1 102
byte 1 117
byte 1 110
byte 1 99
byte 1 95
byte 1 100
byte 1 111
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $1353
byte 1 66
byte 1 111
byte 1 116
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 84
byte 1 111
byte 1 65
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 101
byte 1 58
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $1350
byte 1 99
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $1349
byte 1 66
byte 1 111
byte 1 116
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 84
byte 1 111
byte 1 65
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 101
byte 1 58
byte 1 32
byte 1 110
byte 1 111
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 102
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $1337
byte 1 42
byte 1 37
byte 1 100
byte 1 0
align 1
LABELV $1283
byte 1 113
byte 1 51
byte 1 116
byte 1 111
byte 1 117
byte 1 114
byte 1 110
byte 1 101
byte 1 121
byte 1 54
byte 1 0
align 1
LABELV $1279
byte 1 109
byte 1 97
byte 1 112
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $505
byte 1 73
byte 1 110
byte 1 118
byte 1 105
byte 1 115
byte 1 105
byte 1 98
byte 1 105
byte 1 108
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $504
byte 1 83
byte 1 112
byte 1 101
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $503
byte 1 66
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 32
byte 1 83
byte 1 117
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $502
byte 1 82
byte 1 101
byte 1 103
byte 1 101
byte 1 110
byte 1 101
byte 1 114
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $501
byte 1 81
byte 1 117
byte 1 97
byte 1 100
byte 1 32
byte 1 68
byte 1 97
byte 1 109
byte 1 97
byte 1 103
byte 1 101
byte 1 0
align 1
LABELV $369
byte 1 66
byte 1 111
byte 1 116
byte 1 67
byte 1 114
byte 1 101
byte 1 97
byte 1 116
byte 1 101
byte 1 87
byte 1 97
byte 1 121
byte 1 80
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 58
byte 1 32
byte 1 79
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 119
byte 1 97
byte 1 121
byte 1 112
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $207
byte 1 93
byte 1 0
align 1
LABELV $206
byte 1 91
byte 1 0
align 1
LABELV $205
byte 1 32
byte 1 0
align 1
LABELV $175
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
align 1
LABELV $170
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $169
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 83
byte 1 107
byte 1 105
byte 1 110
byte 1 58
byte 1 32
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $164
byte 1 110
byte 1 0
align 1
LABELV $163
byte 1 91
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 93
byte 1 0
align 1
LABELV $162
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 78
byte 1 97
byte 1 109
byte 1 101
byte 1 58
byte 1 32
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $62
byte 1 116
byte 1 0
