export BotResetNodeSwitches
code
proc BotResetNodeSwitches 0 0
file "..\ai_dmnet.c"
line 52
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:/*****************************************************************************
;5: * name:		ai_dmnet.c
;6: *
;7: * desc:		Quake3 bot AI
;8: *
;9: * $Archive: /source/code/game/ai_dmnet.c $
;10: * $Author: Raduffy $ 
;11: * $Revision: 8 $
;12: * $Modtime: 1/14/00 5:27p $
;13: * $Date: 1/14/00 5:35p $
;14: *
;15: *****************************************************************************/
;16:
;17:#include "g_local.h"
;18:#include "botlib.h"
;19:#include "be_aas.h"
;20:#include "be_ea.h"
;21:#include "be_ai_char.h"
;22:#include "be_ai_chat.h"
;23:#include "be_ai_gen.h"
;24:#include "be_ai_goal.h"
;25:#include "be_ai_move.h"
;26:#include "be_ai_weap.h"
;27://
;28:#include "ai_main.h"
;29:#include "ai_dmq3.h"
;30:#include "ai_chat.h"
;31:#include "ai_cmd.h"
;32:#include "ai_dmnet.h"
;33://data file headers
;34:#include "chars.h"			//characteristics
;35:#include "inv.h"			//indexes into the inventory
;36:#include "syn.h"			//synonyms
;37:#include "match.h"			//string matching types and vars
;38:
;39://goal flag, see be_ai_goal.h for the other GFL_*
;40:#define GFL_AIR			128
;41:
;42:int numnodeswitches;
;43:char nodeswitch[MAX_NODESWITCHES+1][144];
;44:
;45:#define LOOKAHEAD_DISTANCE		300
;46:
;47:/*
;48:==================
;49:BotResetNodeSwitches
;50:==================
;51:*/
;52:void BotResetNodeSwitches(void) {
line 53
;53:	numnodeswitches = 0;
ADDRGP4 numnodeswitches
CNSTI4 0
ASGNI4
line 54
;54:}
LABELV $47
endproc BotResetNodeSwitches 0 0
export BotDumpNodeSwitches
proc BotDumpNodeSwitches 44 20
line 61
;55:
;56:/*
;57:==================
;58:BotDumpNodeSwitches
;59:==================
;60:*/
;61:void BotDumpNodeSwitches(bot_state_t *bs) {
line 65
;62:	int i;
;63:	char netname[MAX_NETNAME];
;64:
;65:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 66
;66:	BotAI_Print(PRT_MESSAGE, "%s at %1.1f switched more than %d AI nodes\n", netname, trap_AAS_Time(), MAX_NODESWITCHES);
ADDRLP4 40
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
CNSTI4 1
ARGI4
ADDRGP4 $49
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 40
INDIRF4
ARGF4
CNSTI4 50
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 67
;67:	for (i = 0; i < numnodeswitches; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $53
JUMPV
LABELV $50
line 68
;68:		BotAI_Print(PRT_MESSAGE, nodeswitch[i]);
CNSTI4 1
ARGI4
CNSTI4 144
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 nodeswitch
ADDP4
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 69
;69:	}
LABELV $51
line 67
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $53
ADDRLP4 0
INDIRI4
ADDRGP4 numnodeswitches
INDIRI4
LTI4 $50
line 70
;70:	BotAI_Print(PRT_FATAL, "");
CNSTI4 4
ARGI4
ADDRGP4 $54
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 71
;71:}
LABELV $48
endproc BotDumpNodeSwitches 44 20
export BotRecordNodeSwitch
proc BotRecordNodeSwitch 48 28
line 78
;72:
;73:/*
;74:==================
;75:BotRecordNodeSwitch
;76:==================
;77:*/
;78:void BotRecordNodeSwitch(bot_state_t *bs, char *node, char *str) {
line 81
;79:	char netname[MAX_NETNAME];
;80:
;81:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 82
;82:	Com_sprintf(nodeswitch[numnodeswitches], 144, "%s at %2.1f entered %s: %s\n", netname, trap_AAS_Time(), node, str);
ADDRLP4 36
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 40
CNSTI4 144
ASGNI4
ADDRLP4 40
INDIRI4
ADDRGP4 numnodeswitches
INDIRI4
MULI4
ADDRGP4 nodeswitch
ADDP4
ARGP4
ADDRLP4 40
INDIRI4
ARGI4
ADDRGP4 $56
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 36
INDIRF4
ARGF4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 88
;83:#ifdef DEBUG
;84:	if (0) {
;85:		BotAI_Print(PRT_MESSAGE, nodeswitch[numnodeswitches]);
;86:	}
;87:#endif //DEBUG
;88:	numnodeswitches++;
ADDRLP4 44
ADDRGP4 numnodeswitches
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 89
;89:}
LABELV $55
endproc BotRecordNodeSwitch 48 28
lit
align 4
LABELV $58
byte 4 3245342720
byte 4 3245342720
byte 4 3221225472
align 4
LABELV $59
byte 4 1097859072
byte 4 1097859072
byte 4 1073741824
export BotGetAirGoal
code
proc BotGetAirGoal 140 28
line 96
;90:
;91:/*
;92:==================
;93:BotGetAirGoal
;94:==================
;95:*/
;96:int BotGetAirGoal(bot_state_t *bs, bot_goal_t *goal) {
line 98
;97:	bsp_trace_t bsptrace;
;98:	vec3_t end, mins = {-15, -15, -2}, maxs = {15, 15, 2};
ADDRLP4 96
ADDRGP4 $58
INDIRB
ASGNB 12
ADDRLP4 108
ADDRGP4 $59
INDIRB
ASGNB 12
line 102
;99:	int areanum;
;100:
;101:	//trace up until we hit solid
;102:	VectorCopy(bs->origin, end);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 103
;103:	end[2] += 1000;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1148846080
ADDF4
ASGNF4
line 104
;104:	BotAI_Trace(&bsptrace, bs->origin, mins, maxs, end, bs->entitynum, CONTENTS_SOLID|CONTENTS_PLAYERCLIP);
ADDRLP4 12
ARGP4
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 96
ARGP4
ADDRLP4 108
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 124
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 65537
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 106
;105:	//trace down until we hit water
;106:	VectorCopy(bsptrace.endpos, end);
ADDRLP4 0
ADDRLP4 12+12
INDIRB
ASGNB 12
line 107
;107:	BotAI_Trace(&bsptrace, end, mins, maxs, bs->origin, bs->entitynum, CONTENTS_WATER|CONTENTS_SLIME|CONTENTS_LAVA);
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 96
ARGP4
ADDRLP4 108
ARGP4
ADDRLP4 128
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 128
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 128
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
CNSTI4 56
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 109
;108:	//if we found the water surface
;109:	if (bsptrace.fraction > 0) {
ADDRLP4 12+8
INDIRF4
CNSTF4 0
LEF4 $62
line 110
;110:		areanum = BotPointAreaNum(bsptrace.endpos);
ADDRLP4 12+12
ARGP4
ADDRLP4 132
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 120
ADDRLP4 132
INDIRI4
ASGNI4
line 111
;111:		if (areanum) {
ADDRLP4 120
INDIRI4
CNSTI4 0
EQI4 $66
line 112
;112:			VectorCopy(bsptrace.endpos, goal->origin);
ADDRFP4 4
INDIRP4
ADDRLP4 12+12
INDIRB
ASGNB 12
line 113
;113:			goal->origin[2] -= 2;
ADDRLP4 136
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 136
INDIRP4
INDIRF4
CNSTF4 1073741824
SUBF4
ASGNF4
line 114
;114:			goal->areanum = areanum;
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 120
INDIRI4
ASGNI4
line 115
;115:			goal->mins[0] = -15;
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
CNSTF4 3245342720
ASGNF4
line 116
;116:			goal->mins[1] = -15;
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
CNSTF4 3245342720
ASGNF4
line 117
;117:			goal->mins[2] = -1;
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 3212836864
ASGNF4
line 118
;118:			goal->maxs[0] = 15;
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1097859072
ASGNF4
line 119
;119:			goal->maxs[1] = 15;
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1097859072
ASGNF4
line 120
;120:			goal->maxs[2] = 1;
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1065353216
ASGNF4
line 121
;121:			goal->flags = GFL_AIR;
ADDRFP4 4
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 128
ASGNI4
line 122
;122:			goal->number = 0;
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
CNSTI4 0
ASGNI4
line 123
;123:			goal->iteminfo = 0;
ADDRFP4 4
INDIRP4
CNSTI4 52
ADDP4
CNSTI4 0
ASGNI4
line 124
;124:			goal->entitynum = 0;
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
CNSTI4 0
ASGNI4
line 125
;125:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $57
JUMPV
LABELV $66
line 127
;126:		}
;127:	}
LABELV $62
line 128
;128:	return qfalse;
CNSTI4 0
RETI4
LABELV $57
endproc BotGetAirGoal 140 28
export BotGoForAir
proc BotGoForAir 72 24
line 136
;129:}
;130:
;131:/*
;132:==================
;133:BotGoForAir
;134:==================
;135:*/
;136:int BotGoForAir(bot_state_t *bs, int tfl, bot_goal_t *ltg, float range) {
line 140
;137:	bot_goal_t goal;
;138:
;139:	//if the bot needs air
;140:	if (bs->lastair_time < trap_AAS_Time() - 6) {
ADDRLP4 56
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6140
ADDP4
INDIRF4
ADDRLP4 56
INDIRF4
CNSTF4 1086324736
SUBF4
GEF4 $70
line 146
;141:		//
;142:#ifdef DEBUG
;143:		//BotAI_Print(PRT_MESSAGE, "going for air\n");
;144:#endif //DEBUG
;145:		//if we can find an air goal
;146:		if (BotGetAirGoal(bs, &goal)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 60
ADDRGP4 BotGetAirGoal
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
EQI4 $75
line 147
;147:			trap_BotPushGoal(bs->gs, &goal);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotPushGoal
CALLV
pop
line 148
;148:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $69
JUMPV
line 150
;149:		}
;150:		else {
LABELV $74
line 152
;151:			//get a nearby goal outside the water
;152:			while(trap_BotChooseNBGItem(bs->gs, bs->origin, bs->inventory, tfl, ltg, range)) {
line 153
;153:				trap_BotGetTopGoal(bs->gs, &goal);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_BotGetTopGoal
CALLI4
pop
line 155
;154:				//if the goal is not in water
;155:				if (!(trap_AAS_PointContents(goal.origin) & (CONTENTS_WATER|CONTENTS_SLIME|CONTENTS_LAVA))) {
ADDRLP4 0
ARGP4
ADDRLP4 64
ADDRGP4 trap_AAS_PointContents
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
NEI4 $77
line 156
;156:					return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $69
JUMPV
LABELV $77
line 158
;157:				}
;158:				trap_BotPopGoal(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotPopGoal
CALLV
pop
line 159
;159:			}
LABELV $75
line 152
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 64
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 64
INDIRP4
CNSTI4 4928
ADDP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 68
ADDRGP4 trap_BotChooseNBGItem
CALLI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 0
NEI4 $74
line 160
;160:			trap_BotResetAvoidGoals(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidGoals
CALLV
pop
line 161
;161:		}
line 162
;162:	}
LABELV $70
line 163
;163:	return qfalse;
CNSTI4 0
RETI4
LABELV $69
endproc BotGoForAir 72 24
export BotNearbyGoal
proc BotNearbyGoal 20 24
line 171
;164:}
;165:
;166:/*
;167:==================
;168:BotNearbyGoal
;169:==================
;170:*/
;171:int BotNearbyGoal(bot_state_t *bs, int tfl, bot_goal_t *ltg, float range) {
line 175
;172:	int ret;
;173:
;174:	//check if the bot should go for air
;175:	if (BotGoForAir(bs, tfl, ltg, range)) return qtrue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 BotGoForAir
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $80
CNSTI4 1
RETI4
ADDRGP4 $79
JUMPV
LABELV $80
line 177
;176:	//if the bot is carrying the enemy flag
;177:	if (BotCTFCarryingFlag(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $82
line 179
;178:		//if the bot is just a few secs away from the base 
;179:		if (trap_AAS_AreaTravelTimeToGoalArea(bs->areanum, bs->origin,
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 12
INDIRP4
CNSTI4 6308
ADDP4
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 16
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 300
GEI4 $84
line 180
;180:				bs->teamgoal.areanum, TFL_DEFAULT) < 300) {
line 182
;181:			//make the range really small
;182:			range = 50;
ADDRFP4 12
CNSTF4 1112014848
ASGNF4
line 183
;183:		}
LABELV $84
line 184
;184:	}
LABELV $82
line 186
;185:	//
;186:	ret = trap_BotChooseNBGItem(bs->gs, bs->origin, bs->inventory, tfl, ltg, range);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 12
INDIRP4
CNSTI4 4928
ADDP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 16
ADDRGP4 trap_BotChooseNBGItem
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 16
INDIRI4
ASGNI4
line 197
;187:	/*
;188:	if (ret)
;189:	{
;190:		char buf[128];
;191:		//get the goal at the top of the stack
;192:		trap_BotGetTopGoal(bs->gs, &goal);
;193:		trap_BotGoalName(goal.number, buf, sizeof(buf));
;194:		BotAI_Print(PRT_MESSAGE, "%1.1f: new nearby goal %s\n", trap_AAS_Time(), buf);
;195:	}
;196:	//*/
;197:	return ret;
ADDRLP4 0
INDIRI4
RETI4
LABELV $79
endproc BotNearbyGoal 20 24
export BotReachedGoal
proc BotReachedGoal 40 16
line 205
;198:}
;199:
;200:/*
;201:==================
;202:BotReachedGoal
;203:==================
;204:*/
;205:int BotReachedGoal(bot_state_t *bs, bot_goal_t *goal) {
line 206
;206:	if (goal->flags & GFL_ITEM) {
ADDRFP4 4
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $87
line 208
;207:		//if touching the goal
;208:		if (trap_BotTouchingGoal(bs->origin, goal)) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $89
CNSTI4 1
RETI4
ADDRGP4 $86
JUMPV
LABELV $89
line 210
;209:		//if the goal isn't there
;210:		if (trap_BotItemGoalInVisButNotVisible(bs->entitynum, bs->eye, bs->viewangles, goal)) return qtrue;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 trap_BotItemGoalInVisButNotVisible
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $91
CNSTI4 1
RETI4
ADDRGP4 $86
JUMPV
LABELV $91
line 212
;211:		//if in the goal area and below or above the goal and not swimming
;212:		if (bs->areanum == goal->areanum) {
ADDRFP4 0
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
NEI4 $88
line 213
;213:			if (bs->origin[0] > goal->origin[0] + goal->mins[0] && bs->origin[0] < goal->origin[0] + goal->maxs[0]) {
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
ASGNF4
ADDRLP4 16
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
INDIRF4
ASGNF4
ADDRLP4 12
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 16
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDF4
LEF4 $88
ADDRLP4 12
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 16
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDF4
GEF4 $88
line 214
;214:				if (bs->origin[1] > goal->origin[1] + goal->mins[1] && bs->origin[1] < goal->origin[1] + goal->maxs[1]) {
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
ASGNF4
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 32
ADDRLP4 28
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
ADDRLP4 24
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 28
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDF4
LEF4 $88
ADDRLP4 24
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 28
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDF4
GEF4 $88
line 215
;215:					if (!trap_AAS_Swimming(bs->origin)) {
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 trap_AAS_Swimming
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $88
line 216
;216:						return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $86
JUMPV
line 218
;217:					}
;218:				}
line 219
;219:			}
line 220
;220:		}
line 221
;221:	}
LABELV $87
line 222
;222:	else if (goal->flags & GFL_AIR) {
ADDRFP4 4
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $101
line 224
;223:		//if touching the goal
;224:		if (trap_BotTouchingGoal(bs->origin, goal)) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $103
CNSTI4 1
RETI4
ADDRGP4 $86
JUMPV
LABELV $103
line 226
;225:		//if the bot got air
;226:		if (bs->lastair_time > trap_AAS_Time() - 1) return qtrue;
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6140
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
CNSTF4 1065353216
SUBF4
LEF4 $102
CNSTI4 1
RETI4
ADDRGP4 $86
JUMPV
line 227
;227:	}
LABELV $101
line 228
;228:	else {
line 230
;229:		//if touching the goal
;230:		if (trap_BotTouchingGoal(bs->origin, goal)) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $107
CNSTI4 1
RETI4
ADDRGP4 $86
JUMPV
LABELV $107
line 231
;231:	}
LABELV $102
LABELV $88
line 232
;232:	return qfalse;
CNSTI4 0
RETI4
LABELV $86
endproc BotReachedGoal 40 16
export BotGetItemLongTermGoal
proc BotGetItemLongTermGoal 24 16
line 240
;233:}
;234:
;235:/*
;236:==================
;237:BotGetItemLongTermGoal
;238:==================
;239:*/
;240:int BotGetItemLongTermGoal(bot_state_t *bs, int tfl, bot_goal_t *goal) {
line 242
;241:	//if the bot has no goal
;242:	if (!trap_BotGetTopGoal(bs->gs, goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $110
line 244
;243:		//BotAI_Print(PRT_MESSAGE, "no ltg on stack\n");
;244:		bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 245
;245:	}
ADDRGP4 $111
JUMPV
LABELV $110
line 247
;246:	//if the bot touches the current goal
;247:	else if (BotReachedGoal(bs, goal)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotReachedGoal
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $112
line 248
;248:		BotChooseWeapon(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChooseWeapon
CALLV
pop
line 249
;249:		bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 250
;250:	}
LABELV $112
LABELV $111
line 252
;251:	//if it is time to find a new long term goal
;252:	if (bs->ltg_time < trap_AAS_Time()) {
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
INDIRF4
ADDRLP4 8
INDIRF4
GEF4 $114
line 254
;253:		//pop the current goal from the stack
;254:		trap_BotPopGoal(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotPopGoal
CALLV
pop
line 258
;255:		//BotAI_Print(PRT_MESSAGE, "%s: choosing new ltg\n", ClientName(bs->client, netname, sizeof(netname)));
;256:		//choose a new goal
;257:		//BotAI_Print(PRT_MESSAGE, "%6.1f client %d: BotChooseLTGItem\n", trap_AAS_Time(), bs->client);
;258:		if (trap_BotChooseLTGItem(bs->gs, bs->origin, bs->inventory, tfl)) {
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 12
INDIRP4
CNSTI4 4928
ADDP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRLP4 16
ADDRGP4 trap_BotChooseLTGItem
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $116
line 266
;259:			/*
;260:			char buf[128];
;261:			//get the goal at the top of the stack
;262:			trap_BotGetTopGoal(bs->gs, goal);
;263:			trap_BotGoalName(goal->number, buf, sizeof(buf));
;264:			BotAI_Print(PRT_MESSAGE, "%1.1f: new long term goal %s\n", trap_AAS_Time(), buf);
;265:			//*/
;266:			bs->ltg_time = trap_AAS_Time() + 20;
ADDRLP4 20
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
ADDRLP4 20
INDIRF4
CNSTF4 1101004800
ADDF4
ASGNF4
line 267
;267:		}
ADDRGP4 $117
JUMPV
LABELV $116
line 268
;268:		else {//the bot gets sorta stuck with all the avoid timings, shouldn't happen though
line 277
;269:			//
;270:#ifdef DEBUG
;271:			char netname[128];
;272:
;273:			BotAI_Print(PRT_MESSAGE, "%s: no valid ltg (probably stuck)\n", ClientName(bs->client, netname, sizeof(netname)));
;274:#endif
;275:			//trap_BotDumpAvoidGoals(bs->gs);
;276:			//reset the avoid goals and the avoid reach
;277:			trap_BotResetAvoidGoals(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidGoals
CALLV
pop
line 278
;278:			trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 279
;279:		}
LABELV $117
line 281
;280:		//get the goal at the top of the stack
;281:		return trap_BotGetTopGoal(bs->gs, goal);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
RETI4
ADDRGP4 $109
JUMPV
LABELV $114
line 283
;282:	}
;283:	return qtrue;
CNSTI4 1
RETI4
LABELV $109
endproc BotGetItemLongTermGoal 24 16
export BotGetLongTermGoal
proc BotGetLongTermGoal 536 20
line 294
;284:}
;285:
;286:/*
;287:==================
;288:BotGetLongTermGoal
;289:
;290:we could also create a seperate AI node for every long term goal type
;291:however this saves us a lot of code
;292:==================
;293:*/
;294:int BotGetLongTermGoal(bot_state_t *bs, int tfl, int retreat, bot_goal_t *goal) {
line 303
;295:	vec3_t target, dir;
;296:	char netname[MAX_NETNAME];
;297:	char buf[MAX_MESSAGE_SIZE];
;298:	int areanum;
;299:	float croucher;
;300:	aas_entityinfo_t entinfo;
;301:	bot_waypoint_t *wp;
;302:
;303:	if (bs->ltgtype == LTG_TEAMHELP && !retreat) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 1
NEI4 $119
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $119
line 305
;304:		//check for bot typing status message
;305:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 468
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 468
INDIRF4
CNSTF4 0
EQF4 $121
ADDRLP4 472
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 468
INDIRF4
ADDRLP4 472
INDIRF4
GEF4 $121
line 306
;306:			BotAI_BotInitialChat(bs, "help_start", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 476
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $123
ARGP4
ADDRLP4 476
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 307
;307:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 480
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 480
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 480
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 308
;308:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 309
;309:		}
LABELV $121
line 311
;310:		//if trying to help the team mate for more than a minute
;311:		if (bs->teamgoal_time < trap_AAS_Time())
ADDRLP4 476
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 476
INDIRF4
GEF4 $124
line 312
;312:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
LABELV $124
line 314
;313:		//if the team mate IS visible for quite some time
;314:		if (bs->teammatevisible_time < trap_AAS_Time() - 10) bs->ltgtype = 0;
ADDRLP4 480
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6360
ADDP4
INDIRF4
ADDRLP4 480
INDIRF4
CNSTF4 1092616192
SUBF4
GEF4 $126
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
LABELV $126
line 316
;315:		//get entity information of the companion
;316:		BotEntityInfo(bs->teammate, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 272
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 318
;317:		//if the team mate is visible
;318:		if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->teammate)) {
ADDRLP4 484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 484
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 484
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 484
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 484
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 488
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 488
INDIRF4
CNSTF4 0
EQF4 $128
line 320
;319:			//if close just stand still there
;320:			VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 492
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 272+24
INDIRF4
ADDRLP4 492
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 272+24+4
INDIRF4
ADDRLP4 492
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRLP4 272+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 321
;321:			if (VectorLength(dir) < 100) {
ADDRLP4 260
ARGP4
ADDRLP4 496
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 496
INDIRF4
CNSTF4 1120403456
GEF4 $129
line 322
;322:				trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 323
;323:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
line 325
;324:			}
;325:		}
LABELV $128
line 326
;326:		else {
line 328
;327:			//last time the bot was NOT visible
;328:			bs->teammatevisible_time = trap_AAS_Time();
ADDRLP4 492
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6360
ADDP4
ADDRLP4 492
INDIRF4
ASGNF4
line 329
;329:		}
LABELV $129
line 331
;330:		//if the entity information is valid (entity in PVS)
;331:		if (entinfo.valid) {
ADDRLP4 272
INDIRI4
CNSTI4 0
EQI4 $139
line 332
;332:			areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 272+24
ARGP4
ADDRLP4 492
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 448
ADDRLP4 492
INDIRI4
ASGNI4
line 333
;333:			if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 496
ADDRLP4 448
INDIRI4
ASGNI4
ADDRLP4 496
INDIRI4
CNSTI4 0
EQI4 $142
ADDRLP4 496
INDIRI4
ARGI4
ADDRLP4 500
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 500
INDIRI4
CNSTI4 0
EQI4 $142
line 335
;334:				//update team goal
;335:				bs->teamgoal.entitynum = bs->teammate;
ADDRLP4 504
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 504
INDIRP4
CNSTI4 6336
ADDP4
ADDRLP4 504
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ASGNI4
line 336
;336:				bs->teamgoal.areanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6308
ADDP4
ADDRLP4 448
INDIRI4
ASGNI4
line 337
;337:				VectorCopy(entinfo.origin, bs->teamgoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ADDRLP4 272+24
INDIRB
ASGNB 12
line 338
;338:				VectorSet(bs->teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6312
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6316
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6320
ADDP4
CNSTF4 3238002688
ASGNF4
line 339
;339:				VectorSet(bs->teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6324
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6328
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6332
ADDP4
CNSTF4 1090519040
ASGNF4
line 340
;340:			}
LABELV $142
line 341
;341:		}
LABELV $139
line 342
;342:		memcpy(goal, &bs->teamgoal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 343
;343:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $119
line 346
;344:	}
;345:	//if the bot accompanies someone
;346:	if (bs->ltgtype == LTG_TEAMACCOMPANY && !retreat) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 2
NEI4 $145
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $145
line 348
;347:		//check for bot typing status message
;348:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 468
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 468
INDIRF4
CNSTF4 0
EQF4 $147
ADDRLP4 472
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 468
INDIRF4
ADDRLP4 472
INDIRF4
GEF4 $147
line 349
;349:			BotAI_BotInitialChat(bs, "accompany_start", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 476
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $149
ARGP4
ADDRLP4 476
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 350
;350:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 480
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 480
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 480
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 351
;351:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 352
;352:		}
LABELV $147
line 354
;353:		//if accompanying the companion for 3 minutes
;354:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 476
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 476
INDIRF4
GEF4 $150
line 355
;355:			BotAI_BotInitialChat(bs, "accompany_stop", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 480
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $152
ARGP4
ADDRLP4 480
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 356
;356:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 484
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 484
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 357
;357:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 358
;358:		}
LABELV $150
line 360
;359:		//get entity information of the companion
;360:		BotEntityInfo(bs->teammate, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 272
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 362
;361:		//if the companion is visible
;362:		if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->teammate)) {
ADDRLP4 480
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 480
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 480
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 480
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 480
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 484
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 484
INDIRF4
CNSTF4 0
EQF4 $153
line 364
;363:			//update visible time
;364:			bs->teammatevisible_time = trap_AAS_Time();
ADDRLP4 488
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6360
ADDP4
ADDRLP4 488
INDIRF4
ASGNF4
line 365
;365:			VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 492
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 272+24
INDIRF4
ADDRLP4 492
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 272+24+4
INDIRF4
ADDRLP4 492
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRLP4 272+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 366
;366:			if (VectorLength(dir) < bs->formation_dist) {
ADDRLP4 260
ARGP4
ADDRLP4 496
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 496
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 6548
ADDP4
INDIRF4
GEF4 $162
line 369
;367:				//check if the bot wants to crouch
;368:				//don't crouch if crouched less than 5 seconds ago
;369:				if (bs->attackcrouch_time < trap_AAS_Time() - 5) {
ADDRLP4 500
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 500
INDIRF4
CNSTF4 1084227584
SUBF4
GEF4 $164
line 370
;370:					croucher = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CROUCHER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 36
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 504
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 464
ADDRLP4 504
INDIRF4
ASGNF4
line 371
;371:					if (random() < bs->thinktime * croucher) {
ADDRLP4 508
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 508
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
ADDRLP4 464
INDIRF4
MULF4
GEF4 $166
line 372
;372:						bs->attackcrouch_time = trap_AAS_Time() + 5 + croucher * 15;
ADDRLP4 512
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
ADDRLP4 512
INDIRF4
CNSTF4 1084227584
ADDF4
CNSTF4 1097859072
ADDRLP4 464
INDIRF4
MULF4
ADDF4
ASGNF4
line 373
;373:					}
LABELV $166
line 374
;374:				}
LABELV $164
line 376
;375:				//don't crouch when swimming
;376:				if (trap_AAS_Swimming(bs->origin)) bs->attackcrouch_time = trap_AAS_Time() - 1;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 504
ADDRGP4 trap_AAS_Swimming
CALLI4
ASGNI4
ADDRLP4 504
INDIRI4
CNSTI4 0
EQI4 $168
ADDRLP4 508
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
ADDRLP4 508
INDIRF4
CNSTF4 1065353216
SUBF4
ASGNF4
LABELV $168
line 378
;377:				//if not arrived yet or arived some time ago
;378:				if (bs->arrive_time < trap_AAS_Time() - 2) {
ADDRLP4 512
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
INDIRF4
ADDRLP4 512
INDIRF4
CNSTF4 1073741824
SUBF4
GEF4 $170
line 380
;379:					//if not arrived yet
;380:					if (!bs->arrive_time) {
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
INDIRF4
CNSTF4 0
NEF4 $172
line 381
;381:						trap_EA_Gesture(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Gesture
CALLV
pop
line 382
;382:						BotAI_BotInitialChat(bs, "accompany_arrive", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 516
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $174
ARGP4
ADDRLP4 516
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 383
;383:						trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 520
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 520
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 520
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 384
;384:						bs->arrive_time = trap_AAS_Time();
ADDRLP4 524
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
ADDRLP4 524
INDIRF4
ASGNF4
line 385
;385:					}
ADDRGP4 $173
JUMPV
LABELV $172
line 387
;386:					//if the bot wants to crouch
;387:					else if (bs->attackcrouch_time > trap_AAS_Time()) {
ADDRLP4 516
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 516
INDIRF4
LEF4 $175
line 388
;388:						trap_EA_Crouch(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Crouch
CALLV
pop
line 389
;389:					}
ADDRGP4 $176
JUMPV
LABELV $175
line 391
;390:					//else do some model taunts
;391:					else if (random() < bs->thinktime * 0.3) {
ADDRLP4 520
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 520
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1050253722
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $177
line 393
;392:						//do a gesture :)
;393:						trap_EA_Gesture(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Gesture
CALLV
pop
line 394
;394:					}
LABELV $177
LABELV $176
LABELV $173
line 395
;395:				}
LABELV $170
line 397
;396:				//if just arrived look at the companion
;397:				if (bs->arrive_time > trap_AAS_Time() - 2) {
ADDRLP4 516
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
INDIRF4
ADDRLP4 516
INDIRF4
CNSTF4 1073741824
SUBF4
LEF4 $179
line 398
;398:					VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 520
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 272+24
INDIRF4
ADDRLP4 520
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 272+24+4
INDIRF4
ADDRLP4 520
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRLP4 272+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 399
;399:					vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 260
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 400
;400:					bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 524
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 524
INDIRP4
CNSTF4 1056964608
ADDRLP4 524
INDIRP4
INDIRF4
MULF4
ASGNF4
line 401
;401:				}
ADDRGP4 $180
JUMPV
LABELV $179
line 403
;402:				//else look strategically around for enemies
;403:				else if (random() < bs->thinktime * 0.8) {
ADDRLP4 520
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 520
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1061997773
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $188
line 404
;404:					BotRoamGoal(bs, target);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 452
ARGP4
ADDRGP4 BotRoamGoal
CALLV
pop
line 405
;405:					VectorSubtract(target, bs->origin, dir);
ADDRLP4 524
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 452
INDIRF4
ADDRLP4 524
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 452+4
INDIRF4
ADDRLP4 524
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRLP4 452+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 406
;406:					vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 260
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 407
;407:					bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 528
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 528
INDIRP4
CNSTF4 1056964608
ADDRLP4 528
INDIRP4
INDIRF4
MULF4
ASGNF4
line 408
;408:				}
LABELV $188
LABELV $180
line 410
;409:				//check if the bot wants to go for air
;410:				if (BotGoForAir(bs, bs->tfl, &bs->teamgoal, 400)) {
ADDRLP4 524
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 524
INDIRP4
ARGP4
ADDRLP4 524
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRLP4 524
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
CNSTF4 1137180672
ARGF4
ADDRLP4 528
ADDRGP4 BotGoForAir
CALLI4
ASGNI4
ADDRLP4 528
INDIRI4
CNSTI4 0
EQI4 $194
line 411
;411:					trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 417
;412:					//get the goal at the top of the stack
;413:					//trap_BotGetTopGoal(bs->gs, &tmpgoal);
;414:					//trap_BotGoalName(tmpgoal.number, buf, 144);
;415:					//BotAI_Print(PRT_MESSAGE, "new nearby goal %s\n", buf);
;416:					//time the bot gets to pick up the nearby goal item
;417:					bs->nbg_time = trap_AAS_Time() + 8;
ADDRLP4 532
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
ADDRLP4 532
INDIRF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 418
;418:					AIEnter_Seek_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_NBG
CALLV
pop
line 419
;419:					return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $194
line 422
;420:				}
;421:				//
;422:				trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 423
;423:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $162
line 425
;424:			}
;425:		}
LABELV $153
line 427
;426:		//if the entity information is valid (entity in PVS)
;427:		if (entinfo.valid) {
ADDRLP4 272
INDIRI4
CNSTI4 0
EQI4 $196
line 428
;428:			areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 272+24
ARGP4
ADDRLP4 488
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 448
ADDRLP4 488
INDIRI4
ASGNI4
line 429
;429:			if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 492
ADDRLP4 448
INDIRI4
ASGNI4
ADDRLP4 492
INDIRI4
CNSTI4 0
EQI4 $199
ADDRLP4 492
INDIRI4
ARGI4
ADDRLP4 496
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 496
INDIRI4
CNSTI4 0
EQI4 $199
line 431
;430:				//update team goal so bot will accompany 
;431:				bs->teamgoal.entitynum = bs->teammate;
ADDRLP4 500
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 500
INDIRP4
CNSTI4 6336
ADDP4
ADDRLP4 500
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ASGNI4
line 432
;432:				bs->teamgoal.areanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6308
ADDP4
ADDRLP4 448
INDIRI4
ASGNI4
line 433
;433:				VectorCopy(entinfo.origin, bs->teamgoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ADDRLP4 272+24
INDIRB
ASGNB 12
line 434
;434:				VectorSet(bs->teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6312
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6316
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6320
ADDP4
CNSTF4 3238002688
ASGNF4
line 435
;435:				VectorSet(bs->teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6324
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6328
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6332
ADDP4
CNSTF4 1090519040
ASGNF4
line 436
;436:			}
LABELV $199
line 437
;437:		}
LABELV $196
line 439
;438:		//the goal the bot should go for
;439:		memcpy(goal, &bs->teamgoal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 441
;440:		//if the companion is NOT visible for too long
;441:		if (bs->teammatevisible_time < trap_AAS_Time() - 60) {
ADDRLP4 488
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6360
ADDP4
INDIRF4
ADDRLP4 488
INDIRF4
CNSTF4 1114636288
SUBF4
GEF4 $202
line 442
;442:			BotAI_BotInitialChat(bs, "accompany_cannotfind", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 492
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $204
ARGP4
ADDRLP4 492
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 443
;443:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 496
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 496
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 496
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 444
;444:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 445
;445:		}
LABELV $202
line 446
;446:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $145
line 449
;447:	}
;448:	//
;449:	if (bs->ltgtype == LTG_DEFENDKEYAREA) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 3
NEI4 $205
line 450
;450:		if (trap_AAS_AreaTravelTimeToGoalArea(bs->areanum, bs->origin,
ADDRLP4 468
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 468
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ARGI4
ADDRLP4 468
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 468
INDIRP4
CNSTI4 6308
ADDP4
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 472
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 472
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 6120
ADDP4
INDIRF4
LEF4 $207
line 451
;451:				bs->teamgoal.areanum, TFL_DEFAULT) > bs->defendaway_range) {
line 452
;452:			bs->defendaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6116
ADDP4
CNSTF4 0
ASGNF4
line 453
;453:		}
LABELV $207
line 454
;454:	}
LABELV $205
line 456
;455:	//if defending a key area
;456:	if (bs->ltgtype == LTG_DEFENDKEYAREA && !retreat &&
ADDRLP4 468
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 468
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 3
NEI4 $209
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $209
ADDRLP4 472
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 468
INDIRP4
CNSTI4 6116
ADDP4
INDIRF4
ADDRLP4 472
INDIRF4
GEF4 $209
line 457
;457:				bs->defendaway_time < trap_AAS_Time()) {
line 459
;458:		//check for bot typing status message
;459:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 476
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 476
INDIRF4
CNSTF4 0
EQF4 $211
ADDRLP4 480
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
GEF4 $211
line 460
;460:			trap_BotGoalName(bs->teamgoal.number, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 461
;461:			BotAI_BotInitialChat(bs, "defend_start", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $213
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 462
;462:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 484
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 484
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 463
;463:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 464
;464:		}
LABELV $211
line 466
;465:		//set the bot goal
;466:		memcpy(goal, &bs->teamgoal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 468
;467:		//stop after 2 minutes
;468:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 484
INDIRF4
GEF4 $214
line 469
;469:			trap_BotGoalName(bs->teamgoal.number, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 470
;470:			BotAI_BotInitialChat(bs, "defend_stop", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $216
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 471
;471:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 488
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 488
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 472
;472:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 473
;473:		}
LABELV $214
line 475
;474:		//if very close... go away for some time
;475:		VectorSubtract(goal->origin, bs->origin, dir);
ADDRLP4 488
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 492
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 488
INDIRP4
INDIRF4
ADDRLP4 492
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 488
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 492
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRFP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 476
;476:		if (VectorLength(dir) < 70) {
ADDRLP4 260
ARGP4
ADDRLP4 496
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 496
INDIRF4
CNSTF4 1116471296
GEF4 $219
line 477
;477:			trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 478
;478:			bs->defendaway_time = trap_AAS_Time() + 2 + 5 * random();
ADDRLP4 500
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 504
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6116
ADDP4
ADDRLP4 500
INDIRF4
CNSTF4 1073741824
ADDF4
CNSTF4 1084227584
ADDRLP4 504
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 479
;479:			bs->defendaway_range = 250;
ADDRFP4 0
INDIRP4
CNSTI4 6120
ADDP4
CNSTF4 1132068864
ASGNF4
line 480
;480:		}
LABELV $219
line 481
;481:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $209
line 484
;482:	}
;483:	//going to kill someone
;484:	if (bs->ltgtype == LTG_KILL && !retreat) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 11
NEI4 $221
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $221
line 486
;485:		//check for bot typing status message
;486:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 476
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 476
INDIRF4
CNSTF4 0
EQF4 $223
ADDRLP4 480
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
GEF4 $223
line 487
;487:			EasyClientName(bs->teamgoal.entitynum, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 488
;488:			BotAI_BotInitialChat(bs, "kill_start", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $225
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 489
;489:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 484
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 484
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 490
;490:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 491
;491:		}
LABELV $223
line 493
;492:		//
;493:		if (bs->lastkilledplayer == bs->teamgoal.entitynum) {
ADDRLP4 484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 484
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ADDRLP4 484
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
NEI4 $226
line 494
;494:			EasyClientName(bs->teamgoal.entitynum, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 495
;495:			BotAI_BotInitialChat(bs, "kill_done", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $228
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 496
;496:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 488
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 488
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 497
;497:			bs->lastkilledplayer = -1;
ADDRFP4 0
INDIRP4
CNSTI4 5968
ADDP4
CNSTI4 -1
ASGNI4
line 498
;498:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 499
;499:		}
LABELV $226
line 501
;500:		//
;501:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 488
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 488
INDIRF4
GEF4 $229
line 502
;502:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 503
;503:		}
LABELV $229
line 505
;504:		//just roam around
;505:		return BotGetItemLongTermGoal(bs, tfl, goal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 492
ADDRGP4 BotGetItemLongTermGoal
CALLI4
ASGNI4
ADDRLP4 492
INDIRI4
RETI4
ADDRGP4 $118
JUMPV
LABELV $221
line 508
;506:	}
;507:	//get an item
;508:	if (bs->ltgtype == LTG_GETITEM && !retreat) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 10
NEI4 $231
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $231
line 510
;509:		//check for bot typing status message
;510:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 476
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 476
INDIRF4
CNSTF4 0
EQF4 $233
ADDRLP4 480
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
GEF4 $233
line 511
;511:			trap_BotGoalName(bs->teamgoal.number, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 512
;512:			BotAI_BotInitialChat(bs, "getitem_start", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $235
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 513
;513:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 484
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 484
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 484
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 514
;514:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 515
;515:		}
LABELV $233
line 517
;516:		//set the bot goal
;517:		memcpy(goal, &bs->teamgoal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 519
;518:		//stop after some time
;519:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 484
INDIRF4
GEF4 $236
line 520
;520:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 521
;521:		}
LABELV $236
line 523
;522:		//
;523:		if (trap_BotItemGoalInVisButNotVisible(bs->entitynum, bs->eye, bs->viewangles, goal)) {
ADDRLP4 488
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 488
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 488
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 492
ADDRGP4 trap_BotItemGoalInVisButNotVisible
CALLI4
ASGNI4
ADDRLP4 492
INDIRI4
CNSTI4 0
EQI4 $238
line 524
;524:			trap_BotGoalName(bs->teamgoal.number, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 525
;525:			BotAI_BotInitialChat(bs, "getitem_notthere", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $240
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 526
;526:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 496
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 496
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 496
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 527
;527:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 528
;528:		}
ADDRGP4 $239
JUMPV
LABELV $238
line 529
;529:		else if (BotReachedGoal(bs, goal)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 496
ADDRGP4 BotReachedGoal
CALLI4
ASGNI4
ADDRLP4 496
INDIRI4
CNSTI4 0
EQI4 $241
line 530
;530:			trap_BotGoalName(bs->teamgoal.number, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 531
;531:			BotAI_BotInitialChat(bs, "getitem_gotit", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $243
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 532
;532:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 500
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 500
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 500
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 533
;533:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 534
;534:		}
LABELV $241
LABELV $239
line 535
;535:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $231
line 538
;536:	}
;537:	//if camping somewhere
;538:	if ((bs->ltgtype == LTG_CAMP || bs->ltgtype == LTG_CAMPORDER) && !retreat) {
ADDRLP4 476
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 476
INDIRI4
CNSTI4 7
EQI4 $246
ADDRLP4 476
INDIRI4
CNSTI4 8
NEI4 $244
LABELV $246
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $244
line 540
;539:		//check for bot typing status message
;540:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 480
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 480
INDIRF4
CNSTF4 0
EQF4 $247
ADDRLP4 484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 480
INDIRF4
ADDRLP4 484
INDIRF4
GEF4 $247
line 541
;541:			if (bs->ltgtype == LTG_CAMPORDER) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 8
NEI4 $249
line 542
;542:				BotAI_BotInitialChat(bs, "camp_start", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 488
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $251
ARGP4
ADDRLP4 488
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 543
;543:				trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 492
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 492
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 492
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 544
;544:			}
LABELV $249
line 545
;545:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 546
;546:		}
LABELV $247
line 548
;547:		//set the bot goal
;548:		memcpy(goal, &bs->teamgoal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 550
;549:		//
;550:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 488
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 488
INDIRF4
GEF4 $252
line 551
;551:			if (bs->ltgtype == LTG_CAMPORDER) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 8
NEI4 $254
line 552
;552:				BotAI_BotInitialChat(bs, "camp_stop", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $256
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 553
;553:				trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 492
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 492
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 492
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 554
;554:			}
LABELV $254
line 555
;555:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 556
;556:		}
LABELV $252
line 558
;557:		//if really near the camp spot
;558:		VectorSubtract(goal->origin, bs->origin, dir);
ADDRLP4 492
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 496
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 492
INDIRP4
INDIRF4
ADDRLP4 496
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 492
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 496
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRFP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 559
;559:		if (VectorLength(dir) < 60)
ADDRLP4 260
ARGP4
ADDRLP4 500
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 500
INDIRF4
CNSTF4 1114636288
GEF4 $259
line 560
;560:		{
line 562
;561:			//if not arrived yet
;562:			if (!bs->arrive_time) {
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
INDIRF4
CNSTF4 0
NEF4 $261
line 563
;563:				if (bs->ltgtype == LTG_CAMPORDER) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 8
NEI4 $263
line 564
;564:					BotAI_BotInitialChat(bs, "camp_arrive", EasyClientName(bs->teammate, netname, sizeof(netname)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 412
ARGP4
CNSTI4 36
ARGI4
ADDRLP4 504
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $265
ARGP4
ADDRLP4 504
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 565
;565:					trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 508
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 508
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 508
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 566
;566:				}
LABELV $263
line 567
;567:				bs->arrive_time = trap_AAS_Time();
ADDRLP4 504
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
ADDRLP4 504
INDIRF4
ASGNF4
line 568
;568:			}
LABELV $261
line 570
;569:			//look strategically around for enemies
;570:			if (random() < bs->thinktime * 0.8) {
ADDRLP4 504
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 504
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1061997773
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $266
line 571
;571:				BotRoamGoal(bs, target);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 452
ARGP4
ADDRGP4 BotRoamGoal
CALLV
pop
line 572
;572:				VectorSubtract(target, bs->origin, dir);
ADDRLP4 508
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 260
ADDRLP4 452
INDIRF4
ADDRLP4 508
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+4
ADDRLP4 452+4
INDIRF4
ADDRLP4 508
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 260+8
ADDRLP4 452+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 573
;573:				vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 260
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 574
;574:				bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 512
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 512
INDIRP4
CNSTF4 1056964608
ADDRLP4 512
INDIRP4
INDIRF4
MULF4
ASGNF4
line 575
;575:			}
LABELV $266
line 578
;576:			//check if the bot wants to crouch
;577:			//don't crouch if crouched less than 5 seconds ago
;578:			if (bs->attackcrouch_time < trap_AAS_Time() - 5) {
ADDRLP4 508
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 508
INDIRF4
CNSTF4 1084227584
SUBF4
GEF4 $272
line 579
;579:				croucher = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CROUCHER, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 36
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 512
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 464
ADDRLP4 512
INDIRF4
ASGNF4
line 580
;580:				if (random() < bs->thinktime * croucher) {
ADDRLP4 516
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 516
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
ADDRLP4 464
INDIRF4
MULF4
GEF4 $274
line 581
;581:					bs->attackcrouch_time = trap_AAS_Time() + 5 + croucher * 15;
ADDRLP4 520
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
ADDRLP4 520
INDIRF4
CNSTF4 1084227584
ADDF4
CNSTF4 1097859072
ADDRLP4 464
INDIRF4
MULF4
ADDF4
ASGNF4
line 582
;582:				}
LABELV $274
line 583
;583:			}
LABELV $272
line 585
;584:			//if the bot wants to crouch
;585:			if (bs->attackcrouch_time > trap_AAS_Time()) {
ADDRLP4 512
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
INDIRF4
ADDRLP4 512
INDIRF4
LEF4 $276
line 586
;586:				trap_EA_Crouch(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Crouch
CALLV
pop
line 587
;587:			}
LABELV $276
line 589
;588:			//don't crouch when swimming
;589:			if (trap_AAS_Swimming(bs->origin)) bs->attackcrouch_time = trap_AAS_Time() - 1;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 516
ADDRGP4 trap_AAS_Swimming
CALLI4
ASGNI4
ADDRLP4 516
INDIRI4
CNSTI4 0
EQI4 $278
ADDRLP4 520
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6084
ADDP4
ADDRLP4 520
INDIRF4
CNSTF4 1065353216
SUBF4
ASGNF4
LABELV $278
line 591
;590:			//make sure the bot is not gonna drown
;591:			if (trap_PointContents(bs->eye,bs->entitynum) & (CONTENTS_WATER|CONTENTS_SLIME|CONTENTS_LAVA)) {
ADDRLP4 524
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 524
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 524
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 528
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 528
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $280
line 592
;592:				if (bs->ltgtype == LTG_CAMPORDER) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 8
NEI4 $282
line 593
;593:					BotAI_BotInitialChat(bs, "camp_stop", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $256
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 594
;594:					trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 532
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 532
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 532
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 595
;595:				}
LABELV $282
line 596
;596:				bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 597
;597:			}
LABELV $280
line 599
;598:			//
;599:			if (bs->camp_range > 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6152
ADDP4
INDIRF4
CNSTF4 0
LEF4 $284
line 601
;600:				//FIXME: move around a bit
;601:			}
LABELV $284
line 603
;602:			//
;603:			trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 604
;604:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $259
line 606
;605:		}
;606:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $244
line 609
;607:	}
;608:	//patrolling along several waypoints
;609:	if (bs->ltgtype == LTG_PATROL && !retreat) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 9
NEI4 $286
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $286
line 611
;610:		//check for bot typing status message
;611:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 480
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 480
INDIRF4
CNSTF4 0
EQF4 $288
ADDRLP4 484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 480
INDIRF4
ADDRLP4 484
INDIRF4
GEF4 $288
line 612
;612:			strcpy(buf, "");
ADDRLP4 4
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 613
;613:			for (wp = bs->patrolpoints; wp; wp = wp->next) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 6712
ADDP4
INDIRP4
ASGNP4
ADDRGP4 $293
JUMPV
LABELV $290
line 614
;614:				strcat(buf, wp->name);
ADDRLP4 4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 615
;615:				if (wp->next) strcat(buf, " to ");
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $294
ADDRLP4 4
ARGP4
ADDRGP4 $296
ARGP4
ADDRGP4 strcat
CALLP4
pop
LABELV $294
line 616
;616:			}
LABELV $291
line 613
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
LABELV $293
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $290
line 617
;617:			BotAI_BotInitialChat(bs, "patrol_start", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $297
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 618
;618:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 488
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 488
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 619
;619:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 620
;620:		}
LABELV $288
line 622
;621:		//
;622:		if (!bs->curpatrolpoint) {
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $298
line 623
;623:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 624
;624:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $298
line 627
;625:		}
;626:		//if the bot touches the current goal
;627:		if (trap_BotTouchingGoal(bs->origin, &bs->curpatrolpoint->goal)) {
ADDRLP4 488
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 488
INDIRP4
CNSTI4 6716
ADDP4
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 492
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 492
INDIRI4
CNSTI4 0
EQI4 $300
line 628
;628:			if (bs->patrolflags & PATROL_BACK) {
ADDRFP4 0
INDIRP4
CNSTI4 6720
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $302
line 629
;629:				if (bs->curpatrolpoint->prev) {
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
INDIRP4
CNSTI4 96
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $304
line 630
;630:					bs->curpatrolpoint = bs->curpatrolpoint->prev;
ADDRLP4 496
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
ASGNP4
ADDRLP4 496
INDIRP4
ADDRLP4 496
INDIRP4
INDIRP4
CNSTI4 96
ADDP4
INDIRP4
ASGNP4
line 631
;631:				}
ADDRGP4 $303
JUMPV
LABELV $304
line 632
;632:				else {
line 633
;633:					bs->curpatrolpoint = bs->curpatrolpoint->next;
ADDRLP4 496
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
ASGNP4
ADDRLP4 496
INDIRP4
ADDRLP4 496
INDIRP4
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
line 634
;634:					bs->patrolflags &= ~PATROL_BACK;
ADDRLP4 500
ADDRFP4 0
INDIRP4
CNSTI4 6720
ADDP4
ASGNP4
ADDRLP4 500
INDIRP4
ADDRLP4 500
INDIRP4
INDIRI4
CNSTI4 -5
BANDI4
ASGNI4
line 635
;635:				}
line 636
;636:			}
ADDRGP4 $303
JUMPV
LABELV $302
line 637
;637:			else {
line 638
;638:				if (bs->curpatrolpoint->next) {
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $306
line 639
;639:					bs->curpatrolpoint = bs->curpatrolpoint->next;
ADDRLP4 496
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
ASGNP4
ADDRLP4 496
INDIRP4
ADDRLP4 496
INDIRP4
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
line 640
;640:				}
ADDRGP4 $307
JUMPV
LABELV $306
line 641
;641:				else {
line 642
;642:					bs->curpatrolpoint = bs->curpatrolpoint->prev;
ADDRLP4 496
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
ASGNP4
ADDRLP4 496
INDIRP4
ADDRLP4 496
INDIRP4
INDIRP4
CNSTI4 96
ADDP4
INDIRP4
ASGNP4
line 643
;643:					bs->patrolflags |= PATROL_BACK;
ADDRLP4 500
ADDRFP4 0
INDIRP4
CNSTI4 6720
ADDP4
ASGNP4
ADDRLP4 500
INDIRP4
ADDRLP4 500
INDIRP4
INDIRI4
CNSTI4 4
BORI4
ASGNI4
line 644
;644:				}
LABELV $307
line 645
;645:			}
LABELV $303
line 646
;646:		}
LABELV $300
line 648
;647:		//stop after 5 minutes
;648:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 496
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 496
INDIRF4
GEF4 $308
line 649
;649:			BotAI_BotInitialChat(bs, "patrol_stop", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $310
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 650
;650:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 500
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 500
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 500
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 651
;651:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 652
;652:		}
LABELV $308
line 653
;653:		if (!bs->curpatrolpoint) {
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $311
line 654
;654:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 655
;655:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $311
line 657
;656:		}
;657:		memcpy(goal, &bs->curpatrolpoint->goal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6716
ADDP4
INDIRP4
CNSTI4 36
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 658
;658:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $286
line 662
;659:	}
;660:#ifdef CTF
;661:	//if going for enemy flag
;662:	if (bs->ltgtype == LTG_GETFLAG) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 4
NEI4 $313
line 664
;663:		//check for bot typing status message
;664:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 480
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 480
INDIRF4
CNSTF4 0
EQF4 $315
ADDRLP4 484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 480
INDIRF4
ADDRLP4 484
INDIRF4
GEF4 $315
line 665
;665:			BotAI_BotInitialChat(bs, "captureflag_start", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $317
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 666
;666:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 488
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 488
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 667
;667:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 668
;668:		}
LABELV $315
line 670
;669:		//
;670:		switch(BotCTFTeam(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 492
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 488
ADDRLP4 492
INDIRI4
ASGNI4
ADDRLP4 488
INDIRI4
CNSTI4 1
EQI4 $321
ADDRLP4 488
INDIRI4
CNSTI4 2
EQI4 $322
ADDRGP4 $318
JUMPV
LABELV $321
line 671
;671:			case CTF_TEAM_RED: *goal = ctf_blueflag; break;
ADDRFP4 12
INDIRP4
ADDRGP4 ctf_blueflag
INDIRB
ASGNB 56
ADDRGP4 $319
JUMPV
LABELV $322
line 672
;672:			case CTF_TEAM_BLUE: *goal = ctf_redflag; break;
ADDRFP4 12
INDIRP4
ADDRGP4 ctf_redflag
INDIRB
ASGNB 56
ADDRGP4 $319
JUMPV
LABELV $318
line 673
;673:			default: bs->ltgtype = 0; return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $319
line 676
;674:		}
;675:		//if touching the flag
;676:		if (trap_BotTouchingGoal(bs->origin, goal)) bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 500
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 500
INDIRI4
CNSTI4 0
EQI4 $323
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
LABELV $323
line 678
;677:		//stop after 3 minutes
;678:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 504
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 504
INDIRF4
GEF4 $325
line 682
;679:#ifdef DEBUG
;680:			BotAI_Print(PRT_MESSAGE, "%s: I quit getting the flag\n", ClientName(bs->client, netname, sizeof(netname)));
;681:#endif //DEBUG
;682:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 683
;683:		}
LABELV $325
line 684
;684:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $313
line 687
;685:	}
;686:	//if rushing to the base
;687:	if (bs->ltgtype == LTG_RUSHBASE && bs->rushbaseaway_time < trap_AAS_Time()) {
ADDRLP4 480
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 480
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 5
NEI4 $327
ADDRLP4 484
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 480
INDIRP4
CNSTI4 6124
ADDP4
INDIRF4
ADDRLP4 484
INDIRF4
GEF4 $327
line 688
;688:		switch(BotCTFTeam(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 492
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 488
ADDRLP4 492
INDIRI4
ASGNI4
ADDRLP4 488
INDIRI4
CNSTI4 1
EQI4 $332
ADDRLP4 488
INDIRI4
CNSTI4 2
EQI4 $333
ADDRGP4 $329
JUMPV
LABELV $332
line 689
;689:			case CTF_TEAM_RED: *goal = ctf_redflag; break;
ADDRFP4 12
INDIRP4
ADDRGP4 ctf_redflag
INDIRB
ASGNB 56
ADDRGP4 $330
JUMPV
LABELV $333
line 690
;690:			case CTF_TEAM_BLUE: *goal = ctf_blueflag; break;
ADDRFP4 12
INDIRP4
ADDRGP4 ctf_blueflag
INDIRB
ASGNB 56
ADDRGP4 $330
JUMPV
LABELV $329
line 691
;691:			default: bs->ltgtype = 0; return qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
CNSTI4 0
RETI4
ADDRGP4 $118
JUMPV
LABELV $330
line 694
;692:		}
;693:		//if not carrying the flag anymore
;694:		if (!BotCTFCarryingFlag(bs)) bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 500
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 500
INDIRI4
CNSTI4 0
NEI4 $334
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
LABELV $334
line 696
;695:		//quit rushing after 2 minutes
;696:		if (bs->teamgoal_time < trap_AAS_Time()) bs->ltgtype = 0;
ADDRLP4 504
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 504
INDIRF4
GEF4 $336
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
LABELV $336
line 698
;697:		//if touching the base flag the bot should loose the enemy flag
;698:		if (trap_BotTouchingGoal(bs->origin, goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 508
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 508
INDIRI4
CNSTI4 0
EQI4 $338
line 701
;699:			//if the bot is still carrying the enemy flag then the
;700:			//base flag is gone, now just walk near the base a bit
;701:			if (BotCTFCarryingFlag(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 512
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 512
INDIRI4
CNSTI4 0
EQI4 $340
line 702
;702:				trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 703
;703:				bs->rushbaseaway_time = trap_AAS_Time() + 5 + 10 * random();
ADDRLP4 516
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 520
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
ADDRLP4 516
INDIRF4
CNSTF4 1084227584
ADDF4
CNSTF4 1092616192
ADDRLP4 520
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 705
;704:				//FIXME: add chat to tell the others to get back the flag
;705:			}
ADDRGP4 $341
JUMPV
LABELV $340
line 706
;706:			else {
line 707
;707:				bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 708
;708:			}
LABELV $341
line 709
;709:		}
LABELV $338
line 710
;710:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $118
JUMPV
LABELV $327
line 713
;711:	}
;712:	//returning flag
;713:	if (bs->ltgtype == LTG_RETURNFLAG) {
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 6
NEI4 $342
line 715
;714:		//check for bot typing status message
;715:		if (bs->teammessage_time && bs->teammessage_time < trap_AAS_Time()) {
ADDRLP4 488
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
INDIRF4
ASGNF4
ADDRLP4 488
INDIRF4
CNSTF4 0
EQF4 $344
ADDRLP4 492
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 488
INDIRF4
ADDRLP4 492
INDIRF4
GEF4 $344
line 716
;716:			EasyClientName(bs->teamgoal.entitynum, buf, sizeof(buf));
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 717
;717:			BotAI_BotInitialChat(bs, "returnflag_start", buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $346
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 718
;718:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 496
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 496
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 496
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 719
;719:			bs->teammessage_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
CNSTF4 0
ASGNF4
line 720
;720:		}
LABELV $344
line 722
;721:		//
;722:		if (bs->teamgoal_time < trap_AAS_Time()) {
ADDRLP4 496
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
ADDRLP4 496
INDIRF4
GEF4 $347
line 723
;723:			bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 724
;724:		}
LABELV $347
line 726
;725:		//just roam around
;726:		return BotGetItemLongTermGoal(bs, tfl, goal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 500
ADDRGP4 BotGetItemLongTermGoal
CALLI4
ASGNI4
ADDRLP4 500
INDIRI4
RETI4
ADDRGP4 $118
JUMPV
LABELV $342
line 730
;727:	}
;728:#endif //CTF
;729:	//normal goal stuff
;730:	return BotGetItemLongTermGoal(bs, tfl, goal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 488
ADDRGP4 BotGetItemLongTermGoal
CALLI4
ASGNI4
ADDRLP4 488
INDIRI4
RETI4
LABELV $118
endproc BotGetLongTermGoal 536 20
export BotLongTermGoal
proc BotLongTermGoal 472 20
line 738
;731:}
;732:
;733:/*
;734:==================
;735:BotLongTermGoal
;736:==================
;737:*/
;738:int BotLongTermGoal(bot_state_t *bs, int tfl, int retreat, bot_goal_t *goal) {
line 748
;739:	aas_entityinfo_t entinfo;
;740:	char teammate[MAX_MESSAGE_SIZE];
;741:	float dist;
;742:	int areanum;
;743:	vec3_t dir;
;744:
;745:	//FIXME: also have air long term goals?
;746:	//
;747:	//if the bot is leading someone and not retreating
;748:	if (bs->lead_time > 0 && !retreat) {
ADDRFP4 0
INDIRP4
CNSTI4 6424
ADDP4
INDIRF4
CNSTF4 0
LEF4 $350
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $350
line 749
;749:		if (bs->lead_time < trap_AAS_Time()) {
ADDRLP4 416
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6424
ADDP4
INDIRF4
ADDRLP4 416
INDIRF4
GEF4 $352
line 751
;750:			//FIXME: add chat to tell the team mate that he/she's on his/her own
;751:			bs->lead_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6424
ADDP4
CNSTF4 0
ASGNF4
line 752
;752:			return BotGetLongTermGoal(bs, tfl, retreat, goal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRI4
ARGI4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 420
ADDRGP4 BotGetLongTermGoal
CALLI4
ASGNI4
ADDRLP4 420
INDIRI4
RETI4
ADDRGP4 $349
JUMPV
LABELV $352
line 755
;753:		}
;754:		//
;755:		if (bs->leadmessage_time < 0 && -bs->leadmessage_time < trap_AAS_Time()) {
ADDRLP4 420
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
INDIRF4
ASGNF4
ADDRLP4 420
INDIRF4
CNSTF4 0
GEF4 $354
ADDRLP4 424
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 420
INDIRF4
NEGF4
ADDRLP4 424
INDIRF4
GEF4 $354
line 756
;756:			BotAI_BotInitialChat(bs, "followme", EasyClientName(bs->lead_teammate, teammate, sizeof(teammate)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6364
ADDP4
INDIRI4
ARGI4
ADDRLP4 156
ARGP4
CNSTI4 256
ARGI4
ADDRLP4 428
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $356
ARGP4
ADDRLP4 428
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 757
;757:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 432
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 432
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 432
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 758
;758:			bs->leadmessage_time = trap_AAS_Time();
ADDRLP4 436
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
ADDRLP4 436
INDIRF4
ASGNF4
line 759
;759:		}
LABELV $354
line 761
;760:		//get entity information of the companion
;761:		BotEntityInfo(bs->lead_teammate, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6364
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 763
;762:		//
;763:		if (entinfo.valid) {
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $357
line 764
;764:			areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 12+24
ARGP4
ADDRLP4 428
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 412
ADDRLP4 428
INDIRI4
ASGNI4
line 765
;765:			if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 432
ADDRLP4 412
INDIRI4
ASGNI4
ADDRLP4 432
INDIRI4
CNSTI4 0
EQI4 $360
ADDRLP4 432
INDIRI4
ARGI4
ADDRLP4 436
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 436
INDIRI4
CNSTI4 0
EQI4 $360
line 767
;766:				//update team goal
;767:				bs->lead_teamgoal.entitynum = bs->lead_teammate;
ADDRLP4 440
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 440
INDIRP4
CNSTI4 6408
ADDP4
ADDRLP4 440
INDIRP4
CNSTI4 6364
ADDP4
INDIRI4
ASGNI4
line 768
;768:				bs->lead_teamgoal.areanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6380
ADDP4
ADDRLP4 412
INDIRI4
ASGNI4
line 769
;769:				VectorCopy(entinfo.origin, bs->lead_teamgoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6368
ADDP4
ADDRLP4 12+24
INDIRB
ASGNB 12
line 770
;770:				VectorSet(bs->lead_teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6384
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6388
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6392
ADDP4
CNSTF4 3238002688
ASGNF4
line 771
;771:				VectorSet(bs->lead_teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6396
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6400
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6404
ADDP4
CNSTF4 1090519040
ASGNF4
line 772
;772:			}
LABELV $360
line 773
;773:		}
LABELV $357
line 775
;774:		//if the team mate is visible
;775:		if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->lead_teammate)) {
ADDRLP4 428
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 428
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 428
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 428
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 428
INDIRP4
CNSTI4 6364
ADDP4
INDIRI4
ARGI4
ADDRLP4 432
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 432
INDIRF4
CNSTF4 0
EQF4 $363
line 776
;776:			bs->leadvisible_time = trap_AAS_Time();
ADDRLP4 436
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6428
ADDP4
ADDRLP4 436
INDIRF4
ASGNF4
line 777
;777:		}
LABELV $363
line 779
;778:		//if the team mate is not visible for 1 seconds
;779:		if (bs->leadvisible_time < trap_AAS_Time() - 1) {
ADDRLP4 436
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6428
ADDP4
INDIRF4
ADDRLP4 436
INDIRF4
CNSTF4 1065353216
SUBF4
GEF4 $365
line 780
;780:			bs->leadbackup_time = trap_AAS_Time() + 2;
ADDRLP4 440
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6436
ADDP4
ADDRLP4 440
INDIRF4
CNSTF4 1073741824
ADDF4
ASGNF4
line 781
;781:		}
LABELV $365
line 783
;782:		//distance towards the team mate
;783:		VectorSubtract(bs->origin, bs->lead_teamgoal.origin, dir);
ADDRLP4 440
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 440
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
ADDRLP4 440
INDIRP4
CNSTI4 6368
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 440
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
ADDRLP4 440
INDIRP4
CNSTI4 6372
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 444
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 444
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
ADDRLP4 444
INDIRP4
CNSTI4 6376
ADDP4
INDIRF4
SUBF4
ASGNF4
line 784
;784:		dist = VectorLength(dir);
ADDRLP4 0
ARGP4
ADDRLP4 448
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 152
ADDRLP4 448
INDIRF4
ASGNF4
line 786
;785:		//if backing up towards the team mate
;786:		if (bs->leadbackup_time > trap_AAS_Time()) {
ADDRLP4 452
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6436
ADDP4
INDIRF4
ADDRLP4 452
INDIRF4
LEF4 $369
line 787
;787:			if (bs->leadmessage_time < trap_AAS_Time() - 20) {
ADDRLP4 456
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
INDIRF4
ADDRLP4 456
INDIRF4
CNSTF4 1101004800
SUBF4
GEF4 $371
line 788
;788:				BotAI_BotInitialChat(bs, "followme", EasyClientName(bs->lead_teammate, teammate, sizeof(teammate)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6364
ADDP4
INDIRI4
ARGI4
ADDRLP4 156
ARGP4
CNSTI4 256
ARGI4
ADDRLP4 460
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $356
ARGP4
ADDRLP4 460
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 789
;789:				trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 464
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 464
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 464
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 790
;790:				bs->leadmessage_time = trap_AAS_Time();
ADDRLP4 468
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
ADDRLP4 468
INDIRF4
ASGNF4
line 791
;791:			}
LABELV $371
line 793
;792:			//if very close to the team mate
;793:			if (dist < 100) {
ADDRLP4 152
INDIRF4
CNSTF4 1120403456
GEF4 $373
line 794
;794:				bs->leadbackup_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6436
ADDP4
CNSTF4 0
ASGNF4
line 795
;795:			}
LABELV $373
line 797
;796:			//the bot should go back to the team mate
;797:			memcpy(goal, &bs->lead_teamgoal, sizeof(bot_goal_t));
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6368
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 798
;798:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $349
JUMPV
LABELV $369
line 800
;799:		}
;800:		else {
line 802
;801:			//if quite distant from the team mate
;802:			if (dist > 500) {
ADDRLP4 152
INDIRF4
CNSTF4 1140457472
LEF4 $375
line 803
;803:				if (bs->leadmessage_time < trap_AAS_Time() - 20) {
ADDRLP4 456
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
INDIRF4
ADDRLP4 456
INDIRF4
CNSTF4 1101004800
SUBF4
GEF4 $377
line 804
;804:					BotAI_BotInitialChat(bs, "followme", EasyClientName(bs->lead_teammate, teammate, sizeof(teammate)), NULL);
ADDRFP4 0
INDIRP4
CNSTI4 6364
ADDP4
INDIRI4
ARGI4
ADDRLP4 156
ARGP4
CNSTI4 256
ARGI4
ADDRLP4 460
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $356
ARGP4
ADDRLP4 460
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 805
;805:					trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 464
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 464
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 464
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 806
;806:					bs->leadmessage_time = trap_AAS_Time();
ADDRLP4 468
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
ADDRLP4 468
INDIRF4
ASGNF4
line 807
;807:				}
LABELV $377
line 809
;808:				//look at the team mate
;809:				VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 460
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 12+24
INDIRF4
ADDRLP4 460
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 12+24+4
INDIRF4
ADDRLP4 460
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 12+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 810
;810:				vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 811
;811:				bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 464
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 464
INDIRP4
CNSTF4 1056964608
ADDRLP4 464
INDIRP4
INDIRF4
MULF4
ASGNF4
line 813
;812:				//just wait for the team mate
;813:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $349
JUMPV
LABELV $375
line 815
;814:			}
;815:		}
line 816
;816:	}
LABELV $350
line 817
;817:	return BotGetLongTermGoal(bs, tfl, retreat, goal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRI4
ARGI4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 416
ADDRGP4 BotGetLongTermGoal
CALLI4
ASGNI4
ADDRLP4 416
INDIRI4
RETI4
LABELV $349
endproc BotLongTermGoal 472 20
export AIEnter_Intermission
proc AIEnter_Intermission 8 12
line 825
;818:}
;819:
;820:/*
;821:==================
;822:AIEnter_Intermission
;823:==================
;824:*/
;825:void AIEnter_Intermission(bot_state_t *bs) {
line 826
;826:	BotRecordNodeSwitch(bs, "intermission", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $387
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 828
;827:	//reset the bot state
;828:	BotResetState(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotResetState
CALLV
pop
line 830
;829:	//check for end level chat
;830:	if (BotChat_EndLevel(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotChat_EndLevel
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $388
line 831
;831:		trap_BotEnterChat(bs->cs, bs->client, bs->chatto);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 6024
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 832
;832:	}
LABELV $388
line 833
;833:	bs->ainode = AINode_Intermission;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Intermission
ASGNP4
line 834
;834:}
LABELV $386
endproc AIEnter_Intermission 8 12
export AINode_Intermission
proc AINode_Intermission 16 4
line 841
;835:
;836:/*
;837:==================
;838:AINode_Intermission
;839:==================
;840:*/
;841:int AINode_Intermission(bot_state_t *bs) {
line 843
;842:	//if the intermission ended
;843:	if (!BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $391
line 844
;844:		if (BotChat_StartLevel(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotChat_StartLevel
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $393
line 845
;845:			bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 8
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
line 846
;846:		}
ADDRGP4 $394
JUMPV
LABELV $393
line 847
;847:		else {
line 848
;848:			bs->stand_time = trap_AAS_Time() + 2;
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 8
INDIRF4
CNSTF4 1073741824
ADDF4
ASGNF4
line 849
;849:		}
LABELV $394
line 850
;850:		AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 851
;851:	}
LABELV $391
line 852
;852:	return qtrue;
CNSTI4 1
RETI4
LABELV $390
endproc AINode_Intermission 16 4
export AIEnter_Observer
proc AIEnter_Observer 0 12
line 860
;853:}
;854:
;855:/*
;856:==================
;857:AIEnter_Observer
;858:==================
;859:*/
;860:void AIEnter_Observer(bot_state_t *bs) {
line 861
;861:	BotRecordNodeSwitch(bs, "observer", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $396
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 863
;862:	//reset the bot state
;863:	BotResetState(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotResetState
CALLV
pop
line 864
;864:	bs->ainode = AINode_Observer;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Observer
ASGNP4
line 865
;865:}
LABELV $395
endproc AIEnter_Observer 0 12
export AINode_Observer
proc AINode_Observer 4 4
line 872
;866:
;867:/*
;868:==================
;869:AINode_Observer
;870:==================
;871:*/
;872:int AINode_Observer(bot_state_t *bs) {
line 874
;873:	//if the bot left observer mode
;874:	if (!BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $398
line 875
;875:		AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 876
;876:	}
LABELV $398
line 877
;877:	return qtrue;
CNSTI4 1
RETI4
LABELV $397
endproc AINode_Observer 4 4
export AIEnter_Stand
proc AIEnter_Stand 4 12
line 885
;878:}
;879:
;880:/*
;881:==================
;882:AIEnter_Stand
;883:==================
;884:*/
;885:void AIEnter_Stand(bot_state_t *bs) {
line 886
;886:	BotRecordNodeSwitch(bs, "stand", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $401
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 887
;887:	bs->standfindenemy_time = trap_AAS_Time() + 1;
ADDRLP4 0
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6076
ADDP4
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 888
;888:	bs->ainode = AINode_Stand;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Stand
ASGNP4
line 889
;889:}
LABELV $400
endproc AIEnter_Stand 4 12
export AINode_Stand
proc AINode_Stand 24 12
line 896
;890:
;891:/*
;892:==================
;893:AINode_Stand
;894:==================
;895:*/
;896:int AINode_Stand(bot_state_t *bs) {
line 899
;897:
;898:	//if the bot's health decreased
;899:	if (bs->lastframe_health > bs->inventory[INVENTORY_HEALTH]) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 6016
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
LEI4 $403
line 900
;900:		if (BotChat_HitTalking(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotChat_HitTalking
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $405
line 901
;901:			bs->standfindenemy_time = trap_AAS_Time() + BotChatTime(bs) + 0.1;
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6076
ADDP4
ADDRLP4 8
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
CNSTF4 1036831949
ADDF4
ASGNF4
line 902
;902:			bs->stand_time = trap_AAS_Time() + BotChatTime(bs) + 0.1;
ADDRLP4 16
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 16
INDIRF4
ADDRLP4 20
INDIRF4
ADDF4
CNSTF4 1036831949
ADDF4
ASGNF4
line 903
;903:		}
LABELV $405
line 904
;904:	}
LABELV $403
line 905
;905:	if (bs->standfindenemy_time < trap_AAS_Time()) {
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6076
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
GEF4 $407
line 906
;906:		if (BotFindEnemy(bs, -1)) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 8
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $409
line 907
;907:			AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 908
;908:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $402
JUMPV
LABELV $409
line 910
;909:		}
;910:		bs->standfindenemy_time = trap_AAS_Time() + 1;
ADDRLP4 12
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6076
ADDP4
ADDRLP4 12
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 911
;911:	}
LABELV $407
line 912
;912:	trap_EA_Talk(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Talk
CALLV
pop
line 913
;913:	if (bs->stand_time < trap_AAS_Time()) {
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
INDIRF4
ADDRLP4 8
INDIRF4
GEF4 $411
line 914
;914:		trap_BotEnterChat(bs->cs, bs->client, bs->chatto);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 6024
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 915
;915:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 916
;916:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $402
JUMPV
LABELV $411
line 919
;917:	}
;918:	//
;919:	return qtrue;
CNSTI4 1
RETI4
LABELV $402
endproc AINode_Stand 24 12
export AIEnter_Respawn
proc AIEnter_Respawn 16 12
line 927
;920:}
;921:
;922:/*
;923:==================
;924:AIEnter_Respawn
;925:==================
;926:*/
;927:void AIEnter_Respawn(bot_state_t *bs) {
line 928
;928:	BotRecordNodeSwitch(bs, "respawn", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $414
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 930
;929:	//reset some states
;930:	trap_BotResetMoveState(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetMoveState
CALLV
pop
line 931
;931:	trap_BotResetGoalState(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetGoalState
CALLV
pop
line 932
;932:	trap_BotResetAvoidGoals(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidGoals
CALLV
pop
line 933
;933:	trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 935
;934:	//if the bot wants to chat
;935:	if (BotChat_Death(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotChat_Death
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $415
line 936
;936:		bs->respawn_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6048
ADDP4
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
ADDF4
ASGNF4
line 937
;937:		bs->respawnchat_time = trap_AAS_Time();
ADDRLP4 12
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6052
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 938
;938:	}
ADDRGP4 $416
JUMPV
LABELV $415
line 939
;939:	else {
line 940
;940:		bs->respawn_time = trap_AAS_Time() + 1 + random();
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6048
ADDP4
ADDRLP4 4
INDIRF4
CNSTF4 1065353216
ADDF4
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDF4
ASGNF4
line 941
;941:		bs->respawnchat_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6052
ADDP4
CNSTF4 0
ASGNF4
line 942
;942:	}
LABELV $416
line 944
;943:	//set respawn state
;944:	bs->respawn_wait = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 5960
ADDP4
CNSTI4 0
ASGNI4
line 945
;945:	bs->ainode = AINode_Respawn;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Respawn
ASGNP4
line 946
;946:}
LABELV $413
endproc AIEnter_Respawn 16 12
export AINode_Respawn
proc AINode_Respawn 12 12
line 953
;947:
;948:/*
;949:==================
;950:AINode_Respawn
;951:==================
;952:*/
;953:int AINode_Respawn(bot_state_t *bs) {
line 954
;954:	if (bs->respawn_wait) {
ADDRFP4 0
INDIRP4
CNSTI4 5960
ADDP4
INDIRI4
CNSTI4 0
EQI4 $418
line 955
;955:		if (!BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $420
line 956
;956:			AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 957
;957:		}
ADDRGP4 $419
JUMPV
LABELV $420
line 958
;958:		else {
line 959
;959:			trap_EA_Respawn(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Respawn
CALLV
pop
line 960
;960:		}
line 961
;961:	}
ADDRGP4 $419
JUMPV
LABELV $418
line 962
;962:	else if (bs->respawn_time < trap_AAS_Time()) {
ADDRLP4 0
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6048
ADDP4
INDIRF4
ADDRLP4 0
INDIRF4
GEF4 $422
line 964
;963:		//wait until respawned
;964:		bs->respawn_wait = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 5960
ADDP4
CNSTI4 1
ASGNI4
line 966
;965:		//elementary action respawn
;966:		trap_EA_Respawn(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Respawn
CALLV
pop
line 968
;967:		//
;968:		if (bs->respawnchat_time) {
ADDRFP4 0
INDIRP4
CNSTI4 6052
ADDP4
INDIRF4
CNSTF4 0
EQF4 $424
line 969
;969:			trap_BotEnterChat(bs->cs, bs->client, bs->chatto);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 6024
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 970
;970:			bs->enemy = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
CNSTI4 -1
ASGNI4
line 971
;971:		}
LABELV $424
line 972
;972:	}
LABELV $422
LABELV $419
line 973
;973:	if (bs->respawnchat_time && bs->respawnchat_time < trap_AAS_Time() - 0.5) {
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 6052
ADDP4
INDIRF4
ASGNF4
ADDRLP4 4
INDIRF4
CNSTF4 0
EQF4 $426
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
CNSTF4 1056964608
SUBF4
GEF4 $426
line 974
;974:		trap_EA_Talk(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Talk
CALLV
pop
line 975
;975:	}
LABELV $426
line 977
;976:	//
;977:	return qtrue;
CNSTI4 1
RETI4
LABELV $417
endproc AINode_Respawn 12 12
export AIEnter_Seek_ActivateEntity
proc AIEnter_Seek_ActivateEntity 0 12
line 985
;978:}
;979:
;980:/*
;981:==================
;982:AIEnter_Seek_ActivateEntity
;983:==================
;984:*/
;985:void AIEnter_Seek_ActivateEntity(bot_state_t *bs) {
line 986
;986:	BotRecordNodeSwitch(bs, "activate entity", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $429
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 987
;987:	bs->ainode = AINode_Seek_ActivateEntity;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Seek_ActivateEntity
ASGNP4
line 988
;988:}
LABELV $428
endproc AIEnter_Seek_ActivateEntity 0 12
export AINode_Seek_ActivateEntity
proc AINode_Seek_ActivateEntity 128 20
line 995
;989:
;990:/*
;991:==================
;992:AINode_Seek_Activate_Entity
;993:==================
;994:*/
;995:int AINode_Seek_ActivateEntity(bot_state_t *bs) {
line 1000
;996:	bot_goal_t *goal;
;997:	vec3_t target, dir;
;998:	bot_moveresult_t moveresult;
;999:
;1000:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 80
INDIRI4
CNSTI4 0
EQI4 $431
line 1001
;1001:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1002
;1002:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $430
JUMPV
LABELV $431
line 1005
;1003:	}
;1004:	//if in the intermission
;1005:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 84
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 84
INDIRI4
CNSTI4 0
EQI4 $433
line 1006
;1006:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1007
;1007:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $430
JUMPV
LABELV $433
line 1010
;1008:	}
;1009:	//respawn if dead
;1010:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 88
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 88
INDIRI4
CNSTI4 0
EQI4 $435
line 1011
;1011:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1012
;1012:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $430
JUMPV
LABELV $435
line 1015
;1013:	}
;1014:	//
;1015:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1016
;1016:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $437
ADDRLP4 92
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $437
line 1018
;1017:	//if in lava or slime the bot should be able to get out
;1018:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 96
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 96
INDIRI4
CNSTI4 0
EQI4 $440
ADDRLP4 100
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $440
line 1020
;1019:	//map specific code
;1020:	BotMapScripts(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotMapScripts
CALLV
pop
line 1022
;1021:	//no enemy
;1022:	bs->enemy = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
CNSTI4 -1
ASGNI4
line 1024
;1023:	//
;1024:	goal = &bs->activategoal;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 6652
ADDP4
ASGNP4
line 1026
;1025:	//if the bot has no goal
;1026:	if (!goal) bs->activate_time = 0;
ADDRLP4 52
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $442
ADDRFP4 0
INDIRP4
CNSTI4 6108
ADDP4
CNSTF4 0
ASGNF4
ADDRGP4 $443
JUMPV
LABELV $442
line 1028
;1027:	//if the bot touches the current goal
;1028:	else if (trap_BotTouchingGoal(bs->origin, goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 104
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 104
INDIRI4
CNSTI4 0
EQI4 $444
line 1029
;1029:		BotChooseWeapon(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChooseWeapon
CALLV
pop
line 1033
;1030:#ifdef DEBUG
;1031:		BotAI_Print(PRT_MESSAGE, "touched button or trigger\n");
;1032:#endif //DEBUG
;1033:		bs->activate_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6108
ADDP4
CNSTF4 0
ASGNF4
line 1034
;1034:	}
LABELV $444
LABELV $443
line 1036
;1035:	//
;1036:	if (bs->activate_time < trap_AAS_Time()) {
ADDRLP4 108
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6108
ADDP4
INDIRF4
ADDRLP4 108
INDIRF4
GEF4 $446
line 1037
;1037:		AIEnter_Seek_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_NBG
CALLV
pop
line 1038
;1038:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $430
JUMPV
LABELV $446
line 1041
;1039:	}
;1040:	//initialize the movement state
;1041:	BotSetupForMovement(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1043
;1042:	//move towards the goal
;1043:	trap_BotMoveToGoal(&moveresult, bs->ms, goal, bs->tfl);
ADDRLP4 0
ARGP4
ADDRLP4 112
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 112
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 112
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1045
;1044:	//if the movement failed
;1045:	if (moveresult.failure) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $448
line 1047
;1046:		//reset the avoid reach, otherwise bot is stuck in current area
;1047:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1048
;1048:		bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
line 1049
;1049:	}
LABELV $448
line 1051
;1050:	//check if the bot is blocked
;1051:	BotAIBlocked(bs, &moveresult, qtrue);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1053
;1052:	//
;1053:	if (moveresult.flags & (MOVERESULT_MOVEMENTVIEWSET|MOVERESULT_MOVEMENTVIEW|MOVERESULT_SWIMVIEW)) {
ADDRLP4 0+20
INDIRI4
CNSTI4 11
BANDI4
CNSTI4 0
EQI4 $450
line 1054
;1054:		VectorCopy(moveresult.ideal_viewangles, bs->ideal_viewangles);
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDRLP4 0+40
INDIRB
ASGNB 12
line 1055
;1055:	}
ADDRGP4 $451
JUMPV
LABELV $450
line 1057
;1056:	//if waiting for something
;1057:	else if (moveresult.flags & MOVERESULT_WAITING) {
ADDRLP4 0+20
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $454
line 1058
;1058:		if (random() < bs->thinktime * 0.8) {
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 116
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1061997773
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $455
line 1059
;1059:			BotRoamGoal(bs, target);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ARGP4
ADDRGP4 BotRoamGoal
CALLV
pop
line 1060
;1060:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 120
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
ADDRLP4 56
INDIRF4
ADDRLP4 120
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68+4
ADDRLP4 56+4
INDIRF4
ADDRLP4 120
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68+8
ADDRLP4 56+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1061
;1061:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 68
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1062
;1062:			bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 124
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTF4 1056964608
ADDRLP4 124
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1063
;1063:		}
line 1064
;1064:	}
ADDRGP4 $455
JUMPV
LABELV $454
line 1065
;1065:	else if (!(bs->flags & BFL_IDEALVIEWSET)) {
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $463
line 1066
;1066:		if (trap_BotMovementViewTarget(bs->ms, goal, bs->tfl, 300, target)) {
ADDRLP4 116
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 116
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 116
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTF4 1133903872
ARGF4
ADDRLP4 56
ARGP4
ADDRLP4 120
ADDRGP4 trap_BotMovementViewTarget
CALLI4
ASGNI4
ADDRLP4 120
INDIRI4
CNSTI4 0
EQI4 $465
line 1067
;1067:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
ADDRLP4 56
INDIRF4
ADDRLP4 124
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68+4
ADDRLP4 56+4
INDIRF4
ADDRLP4 124
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68+8
ADDRLP4 56+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1068
;1068:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 68
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1069
;1069:		}
LABELV $465
line 1070
;1070:		else {
line 1072
;1071:			//vectoangles(moveresult.movedir, bs->ideal_viewangles);
;1072:		}
LABELV $466
line 1073
;1073:		bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 124
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTF4 1056964608
ADDRLP4 124
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1074
;1074:	}
LABELV $463
LABELV $455
LABELV $451
line 1076
;1075:	//if the weapon is used for the bot movement
;1076:	if (moveresult.flags & MOVERESULT_MOVEMENTWEAPON) bs->weaponnum = moveresult.weapon;
ADDRLP4 0+20
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $471
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 0+24
INDIRI4
ASGNI4
LABELV $471
line 1078
;1077:	//if there is an enemy
;1078:	if (BotFindEnemy(bs, -1)) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 116
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 116
INDIRI4
CNSTI4 0
EQI4 $475
line 1079
;1079:		if (BotWantsToRetreat(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 120
ADDRGP4 BotWantsToRetreat
CALLI4
ASGNI4
ADDRLP4 120
INDIRI4
CNSTI4 0
EQI4 $477
line 1081
;1080:			//keep the current long term goal and retreat
;1081:			AIEnter_Battle_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_NBG
CALLV
pop
line 1082
;1082:		}
ADDRGP4 $478
JUMPV
LABELV $477
line 1083
;1083:		else {
line 1084
;1084:			trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1086
;1085:			//empty the goal stack
;1086:			trap_BotEmptyGoalStack(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEmptyGoalStack
CALLV
pop
line 1088
;1087:			//go fight
;1088:			AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 1089
;1089:		}
LABELV $478
line 1090
;1090:	}
LABELV $475
line 1091
;1091:	return qtrue;
CNSTI4 1
RETI4
LABELV $430
endproc AINode_Seek_ActivateEntity 128 20
export AIEnter_Seek_NBG
proc AIEnter_Seek_NBG 204 12
line 1099
;1092:}
;1093:
;1094:/*
;1095:==================
;1096:AIEnter_Seek_NBG
;1097:==================
;1098:*/
;1099:void AIEnter_Seek_NBG(bot_state_t *bs) {
line 1103
;1100:	bot_goal_t goal;
;1101:	char buf[144];
;1102:
;1103:	if (trap_BotGetTopGoal(bs->gs, &goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 200
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $480
line 1104
;1104:		trap_BotGoalName(goal.number, buf, 144);
ADDRLP4 0+44
INDIRI4
ARGI4
ADDRLP4 56
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 1105
;1105:		BotRecordNodeSwitch(bs, "seek NBG", buf);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $483
ARGP4
ADDRLP4 56
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1106
;1106:	}
ADDRGP4 $481
JUMPV
LABELV $480
line 1107
;1107:	else {
line 1108
;1108:		BotRecordNodeSwitch(bs, "seek NBG", "no goal");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $483
ARGP4
ADDRGP4 $484
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1109
;1109:	}
LABELV $481
line 1110
;1110:	bs->ainode = AINode_Seek_NBG;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Seek_NBG
ASGNP4
line 1111
;1111:}
LABELV $479
endproc AIEnter_Seek_NBG 204 12
export AINode_Seek_NBG
proc AINode_Seek_NBG 192 20
line 1118
;1112:
;1113:/*
;1114:==================
;1115:AINode_Seek_NBG
;1116:==================
;1117:*/
;1118:int AINode_Seek_NBG(bot_state_t *bs) {
line 1123
;1119:	bot_goal_t goal;
;1120:	vec3_t target, dir;
;1121:	bot_moveresult_t moveresult;
;1122:
;1123:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 132
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 132
INDIRI4
CNSTI4 0
EQI4 $486
line 1124
;1124:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1125
;1125:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $485
JUMPV
LABELV $486
line 1128
;1126:	}
;1127:	//if in the intermission
;1128:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 136
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 136
INDIRI4
CNSTI4 0
EQI4 $488
line 1129
;1129:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1130
;1130:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $485
JUMPV
LABELV $488
line 1133
;1131:	}
;1132:	//respawn if dead
;1133:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 0
EQI4 $490
line 1134
;1134:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1135
;1135:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $485
JUMPV
LABELV $490
line 1138
;1136:	}
;1137:	//
;1138:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1139
;1139:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $492
ADDRLP4 144
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 144
INDIRP4
ADDRLP4 144
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $492
line 1141
;1140:	//if in lava or slime the bot should be able to get out
;1141:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 148
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
EQI4 $495
ADDRLP4 152
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 152
INDIRP4
ADDRLP4 152
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $495
line 1143
;1142:	//
;1143:	if (BotCanAndWantsToRocketJump(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 156
ADDRGP4 BotCanAndWantsToRocketJump
CALLI4
ASGNI4
ADDRLP4 156
INDIRI4
CNSTI4 0
EQI4 $497
line 1144
;1144:		bs->tfl |= TFL_ROCKETJUMP;
ADDRLP4 160
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 160
INDIRP4
ADDRLP4 160
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1145
;1145:	}
LABELV $497
line 1147
;1146:	//map specific code
;1147:	BotMapScripts(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotMapScripts
CALLV
pop
line 1149
;1148:	//no enemy
;1149:	bs->enemy = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
CNSTI4 -1
ASGNI4
line 1151
;1150:	//if the bot has no goal
;1151:	if (!trap_BotGetTopGoal(bs->gs, &goal)) bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 160
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
NEI4 $499
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
ADDRGP4 $500
JUMPV
LABELV $499
line 1153
;1152:	//if the bot touches the current goal
;1153:	else if (BotReachedGoal(bs, &goal)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 52
ARGP4
ADDRLP4 164
ADDRGP4 BotReachedGoal
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
EQI4 $501
line 1154
;1154:		BotChooseWeapon(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChooseWeapon
CALLV
pop
line 1155
;1155:		bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
line 1156
;1156:	}
LABELV $501
LABELV $500
line 1158
;1157:	//
;1158:	if (bs->nbg_time < trap_AAS_Time()) {
ADDRLP4 168
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
INDIRF4
ADDRLP4 168
INDIRF4
GEF4 $503
line 1160
;1159:		//pop the current goal from the stack
;1160:		trap_BotPopGoal(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotPopGoal
CALLV
pop
line 1163
;1161:		//check for new nearby items right away
;1162:		//NOTE: we canNOT reset the check_time to zero because it would create an endless loop of node switches
;1163:		bs->check_time = trap_AAS_Time() + 0.05;
ADDRLP4 172
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
ADDRLP4 172
INDIRF4
CNSTF4 1028443341
ADDF4
ASGNF4
line 1165
;1164:		//go back to seek ltg
;1165:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1166
;1166:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $485
JUMPV
LABELV $503
line 1169
;1167:	}
;1168:	//initialize the movement state
;1169:	BotSetupForMovement(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1171
;1170:	//move towards the goal
;1171:	trap_BotMoveToGoal(&moveresult, bs->ms, &goal, bs->tfl);
ADDRLP4 0
ARGP4
ADDRLP4 172
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 172
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 172
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1173
;1172:	//if the movement failed
;1173:	if (moveresult.failure) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $505
line 1175
;1174:		//reset the avoid reach, otherwise bot is stuck in current area
;1175:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1176
;1176:		bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
line 1177
;1177:	}
LABELV $505
line 1179
;1178:	//check if the bot is blocked
;1179:	BotAIBlocked(bs, &moveresult, qtrue);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1181
;1180:	//if the viewangles are used for the movement
;1181:	if (moveresult.flags & (MOVERESULT_MOVEMENTVIEWSET|MOVERESULT_MOVEMENTVIEW|MOVERESULT_SWIMVIEW)) {
ADDRLP4 0+20
INDIRI4
CNSTI4 11
BANDI4
CNSTI4 0
EQI4 $507
line 1182
;1182:		VectorCopy(moveresult.ideal_viewangles, bs->ideal_viewangles);
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDRLP4 0+40
INDIRB
ASGNB 12
line 1183
;1183:	}
ADDRGP4 $508
JUMPV
LABELV $507
line 1185
;1184:	//if waiting for something
;1185:	else if (moveresult.flags & MOVERESULT_WAITING) {
ADDRLP4 0+20
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $511
line 1186
;1186:		if (random() < bs->thinktime * 0.8) {
ADDRLP4 176
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 176
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1061997773
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $512
line 1187
;1187:			BotRoamGoal(bs, target);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 108
ARGP4
ADDRGP4 BotRoamGoal
CALLV
pop
line 1188
;1188:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 180
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 120
ADDRLP4 108
INDIRF4
ADDRLP4 180
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 120+4
ADDRLP4 108+4
INDIRF4
ADDRLP4 180
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 120+8
ADDRLP4 108+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1189
;1189:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 120
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1190
;1190:			bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 184
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 184
INDIRP4
CNSTF4 1056964608
ADDRLP4 184
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1191
;1191:		}
line 1192
;1192:	}
ADDRGP4 $512
JUMPV
LABELV $511
line 1193
;1193:	else if (!(bs->flags & BFL_IDEALVIEWSET)) {
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $520
line 1194
;1194:		if (!trap_BotGetSecondGoal(bs->gs, &goal)) trap_BotGetTopGoal(bs->gs, &goal);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 176
ADDRGP4 trap_BotGetSecondGoal
CALLI4
ASGNI4
ADDRLP4 176
INDIRI4
CNSTI4 0
NEI4 $522
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRGP4 trap_BotGetTopGoal
CALLI4
pop
LABELV $522
line 1195
;1195:		if (trap_BotMovementViewTarget(bs->ms, &goal, bs->tfl, 300, target)) {
ADDRLP4 180
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 180
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 180
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTF4 1133903872
ARGF4
ADDRLP4 108
ARGP4
ADDRLP4 184
ADDRGP4 trap_BotMovementViewTarget
CALLI4
ASGNI4
ADDRLP4 184
INDIRI4
CNSTI4 0
EQI4 $524
line 1196
;1196:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 188
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 120
ADDRLP4 108
INDIRF4
ADDRLP4 188
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 120+4
ADDRLP4 108+4
INDIRF4
ADDRLP4 188
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 120+8
ADDRLP4 108+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1197
;1197:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 120
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1198
;1198:		}
ADDRGP4 $525
JUMPV
LABELV $524
line 1200
;1199:		//FIXME: look at cluster portals?
;1200:		else vectoangles(moveresult.movedir, bs->ideal_viewangles);
ADDRLP4 0+28
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
LABELV $525
line 1201
;1201:		bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 188
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 188
INDIRP4
CNSTF4 1056964608
ADDRLP4 188
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1202
;1202:	}
LABELV $520
LABELV $512
LABELV $508
line 1204
;1203:	//if the weapon is used for the bot movement
;1204:	if (moveresult.flags & MOVERESULT_MOVEMENTWEAPON) bs->weaponnum = moveresult.weapon;
ADDRLP4 0+20
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $531
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 0+24
INDIRI4
ASGNI4
LABELV $531
line 1206
;1205:	//if there is an enemy
;1206:	if (BotFindEnemy(bs, -1)) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 176
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 176
INDIRI4
CNSTI4 0
EQI4 $535
line 1207
;1207:		if (BotWantsToRetreat(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 180
ADDRGP4 BotWantsToRetreat
CALLI4
ASGNI4
ADDRLP4 180
INDIRI4
CNSTI4 0
EQI4 $537
line 1209
;1208:			//keep the current long term goal and retreat
;1209:			AIEnter_Battle_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_NBG
CALLV
pop
line 1210
;1210:		}
ADDRGP4 $538
JUMPV
LABELV $537
line 1211
;1211:		else {
line 1212
;1212:			trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1214
;1213:			//empty the goal stack
;1214:			trap_BotEmptyGoalStack(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEmptyGoalStack
CALLV
pop
line 1216
;1215:			//go fight
;1216:			AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 1217
;1217:		}
LABELV $538
line 1218
;1218:	}
LABELV $535
line 1219
;1219:	return qtrue;
CNSTI4 1
RETI4
LABELV $485
endproc AINode_Seek_NBG 192 20
export AIEnter_Seek_LTG
proc AIEnter_Seek_LTG 204 12
line 1227
;1220:}
;1221:
;1222:/*
;1223:==================
;1224:AIEnter_Seek_LTG
;1225:==================
;1226:*/
;1227:void AIEnter_Seek_LTG(bot_state_t *bs) {
line 1231
;1228:	bot_goal_t goal;
;1229:	char buf[144];
;1230:
;1231:	if (trap_BotGetTopGoal(bs->gs, &goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 200
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $540
line 1232
;1232:		trap_BotGoalName(goal.number, buf, 144);
ADDRLP4 0+44
INDIRI4
ARGI4
ADDRLP4 56
ARGP4
CNSTI4 144
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 1233
;1233:		BotRecordNodeSwitch(bs, "seek LTG", buf);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $543
ARGP4
ADDRLP4 56
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1234
;1234:	}
ADDRGP4 $541
JUMPV
LABELV $540
line 1235
;1235:	else {
line 1236
;1236:		BotRecordNodeSwitch(bs, "seek LTG", "no goal");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $543
ARGP4
ADDRGP4 $484
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1237
;1237:	}
LABELV $541
line 1238
;1238:	bs->ainode = AINode_Seek_LTG;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Seek_LTG
ASGNP4
line 1239
;1239:}
LABELV $539
endproc AIEnter_Seek_LTG 204 12
export AINode_Seek_LTG
proc AINode_Seek_LTG 216 20
line 1247
;1240:
;1241:/*
;1242:==================
;1243:AINode_Seek_LTG
;1244:==================
;1245:*/
;1246:int AINode_Seek_LTG(bot_state_t *bs)
;1247:{
line 1255
;1248:	bot_goal_t goal;
;1249:	vec3_t target, dir;
;1250:	bot_moveresult_t moveresult;
;1251:	int range;
;1252:	//char buf[128];
;1253:	//bot_goal_t tmpgoal;
;1254:
;1255:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 136
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 136
INDIRI4
CNSTI4 0
EQI4 $545
line 1256
;1256:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1257
;1257:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $545
line 1260
;1258:	}
;1259:	//if in the intermission
;1260:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 0
EQI4 $547
line 1261
;1261:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1262
;1262:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $547
line 1265
;1263:	}
;1264:	//respawn if dead
;1265:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 144
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
EQI4 $549
line 1266
;1266:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1267
;1267:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $549
line 1270
;1268:	}
;1269:	//
;1270:	if (BotChat_Random(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 148
ADDRGP4 BotChat_Random
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
EQI4 $551
line 1271
;1271:		bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 152
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 156
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 152
INDIRF4
ADDRLP4 156
INDIRF4
ADDF4
ASGNF4
line 1272
;1272:		AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 1273
;1273:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $551
line 1276
;1274:	}
;1275:	//
;1276:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1277
;1277:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $553
ADDRLP4 152
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 152
INDIRP4
ADDRLP4 152
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $553
line 1279
;1278:	//if in lava or slime the bot should be able to get out
;1279:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 156
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 156
INDIRI4
CNSTI4 0
EQI4 $556
ADDRLP4 160
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 160
INDIRP4
ADDRLP4 160
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $556
line 1281
;1280:	//
;1281:	if (BotCanAndWantsToRocketJump(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 164
ADDRGP4 BotCanAndWantsToRocketJump
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
EQI4 $558
line 1282
;1282:		bs->tfl |= TFL_ROCKETJUMP;
ADDRLP4 168
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 168
INDIRP4
ADDRLP4 168
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1283
;1283:	}
LABELV $558
line 1285
;1284:	//map specific code
;1285:	BotMapScripts(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotMapScripts
CALLV
pop
line 1287
;1286:	//no enemy
;1287:	bs->enemy = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
CNSTI4 -1
ASGNI4
line 1289
;1288:	//
;1289:	if (bs->killedenemy_time > trap_AAS_Time() - 2) {
ADDRLP4 168
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6132
ADDP4
INDIRF4
ADDRLP4 168
INDIRF4
CNSTF4 1073741824
SUBF4
LEF4 $560
line 1290
;1290:		if (random() < bs->thinktime * 1) {
ADDRLP4 172
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 172
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1065353216
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $562
line 1291
;1291:			trap_EA_Gesture(bs->client);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_EA_Gesture
CALLV
pop
line 1292
;1292:		}
LABELV $562
line 1293
;1293:	}
LABELV $560
line 1295
;1294:	//if there is an enemy
;1295:	if (BotFindEnemy(bs, -1)) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 172
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 172
INDIRI4
CNSTI4 0
EQI4 $564
line 1296
;1296:		if (BotWantsToRetreat(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 176
ADDRGP4 BotWantsToRetreat
CALLI4
ASGNI4
ADDRLP4 176
INDIRI4
CNSTI4 0
EQI4 $566
line 1298
;1297:			//keep the current long term goal and retreat
;1298:			AIEnter_Battle_Retreat(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Retreat
CALLV
pop
line 1299
;1299:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $566
line 1301
;1300:		}
;1301:		else {
line 1302
;1302:			trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1304
;1303:			//empty the goal stack
;1304:			trap_BotEmptyGoalStack(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEmptyGoalStack
CALLV
pop
line 1306
;1305:			//go fight
;1306:			AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 1307
;1307:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $564
line 1311
;1308:		}
;1309:	}
;1310:#ifdef CTF
;1311:	if (gametype == GT_CTF) {
ADDRGP4 gametype
INDIRI4
CNSTI4 4
NEI4 $568
line 1313
;1312:		//decide what to do in CTF mode
;1313:		BotCTFSeekGoals(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCTFSeekGoals
CALLV
pop
line 1314
;1314:	}
LABELV $568
line 1317
;1315:#endif //CTF
;1316:	//get the current long term goal
;1317:	if (!BotLongTermGoal(bs, bs->tfl, qfalse, &goal)) {
ADDRLP4 176
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRLP4 176
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 180
ADDRGP4 BotLongTermGoal
CALLI4
ASGNI4
ADDRLP4 180
INDIRI4
CNSTI4 0
NEI4 $570
line 1318
;1318:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $544
JUMPV
LABELV $570
line 1321
;1319:	}
;1320:	//check for nearby goals periodicly
;1321:	if (bs->check_time < trap_AAS_Time()) {
ADDRLP4 184
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
INDIRF4
ADDRLP4 184
INDIRF4
GEF4 $572
line 1322
;1322:		bs->check_time = trap_AAS_Time() + 0.5;
ADDRLP4 188
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
ADDRLP4 188
INDIRF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 1324
;1323:		//check if the bot wants to camp
;1324:		BotWantsToCamp(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotWantsToCamp
CALLI4
pop
line 1326
;1325:		//
;1326:		if (bs->ltgtype == LTG_DEFENDKEYAREA) range = 400;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
CNSTI4 3
NEI4 $574
ADDRLP4 108
CNSTI4 400
ASGNI4
ADDRGP4 $575
JUMPV
LABELV $574
line 1327
;1327:		else range = 150;
ADDRLP4 108
CNSTI4 150
ASGNI4
LABELV $575
line 1331
;1328:		//
;1329:#ifdef CTF
;1330:		//if carrying a flag the bot shouldn't be distracted too much
;1331:		if (BotCTFCarryingFlag(bs)) range = 50;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 192
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 192
INDIRI4
CNSTI4 0
EQI4 $576
ADDRLP4 108
CNSTI4 50
ASGNI4
LABELV $576
line 1334
;1332:#endif //CTF
;1333:		//
;1334:		if (BotNearbyGoal(bs, bs->tfl, &goal, range)) {
ADDRLP4 196
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 196
INDIRP4
ARGP4
ADDRLP4 196
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 108
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 200
ADDRGP4 BotNearbyGoal
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $578
line 1335
;1335:			trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1341
;1336:			//get the goal at the top of the stack
;1337:			//trap_BotGetTopGoal(bs->gs, &tmpgoal);
;1338:			//trap_BotGoalName(tmpgoal.number, buf, 144);
;1339:			//BotAI_Print(PRT_MESSAGE, "new nearby goal %s\n", buf);
;1340:			//time the bot gets to pick up the nearby goal item
;1341:			bs->nbg_time = trap_AAS_Time() + 4 + range * 0.01;
ADDRLP4 204
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
ADDRLP4 204
INDIRF4
CNSTF4 1082130432
ADDF4
CNSTF4 1008981770
ADDRLP4 108
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 1342
;1342:			AIEnter_Seek_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_NBG
CALLV
pop
line 1343
;1343:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $544
JUMPV
LABELV $578
line 1345
;1344:		}
;1345:	}
LABELV $572
line 1347
;1346:	//initialize the movement state
;1347:	BotSetupForMovement(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1349
;1348:	//move towards the goal
;1349:	trap_BotMoveToGoal(&moveresult, bs->ms, &goal, bs->tfl);
ADDRLP4 0
ARGP4
ADDRLP4 188
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 188
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 188
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1351
;1350:	//if the movement failed
;1351:	if (moveresult.failure) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $580
line 1353
;1352:		//reset the avoid reach, otherwise bot is stuck in current area
;1353:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1355
;1354:		//BotAI_Print(PRT_MESSAGE, "movement failure %d\n", moveresult.traveltype);
;1355:		bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 1356
;1356:	}
LABELV $580
line 1358
;1357:	//
;1358:	BotAIBlocked(bs, &moveresult, qtrue);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1360
;1359:	//if the viewangles are used for the movement
;1360:	if (moveresult.flags & (MOVERESULT_MOVEMENTVIEWSET|MOVERESULT_MOVEMENTVIEW|MOVERESULT_SWIMVIEW)) {
ADDRLP4 0+20
INDIRI4
CNSTI4 11
BANDI4
CNSTI4 0
EQI4 $582
line 1361
;1361:		VectorCopy(moveresult.ideal_viewangles, bs->ideal_viewangles);
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDRLP4 0+40
INDIRB
ASGNB 12
line 1362
;1362:	}
ADDRGP4 $583
JUMPV
LABELV $582
line 1364
;1363:	//if waiting for something
;1364:	else if (moveresult.flags & MOVERESULT_WAITING) {
ADDRLP4 0+20
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $586
line 1365
;1365:		if (random() < bs->thinktime * 0.8) {
ADDRLP4 192
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 192
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1061997773
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $587
line 1366
;1366:			BotRoamGoal(bs, target);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 112
ARGP4
ADDRGP4 BotRoamGoal
CALLV
pop
line 1367
;1367:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 196
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
ADDRLP4 112
INDIRF4
ADDRLP4 196
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+4
ADDRLP4 112+4
INDIRF4
ADDRLP4 196
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+8
ADDRLP4 112+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1368
;1368:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 124
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1369
;1369:			bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 200
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 200
INDIRP4
CNSTF4 1056964608
ADDRLP4 200
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1370
;1370:		}
line 1371
;1371:	}
ADDRGP4 $587
JUMPV
LABELV $586
line 1372
;1372:	else if (!(bs->flags & BFL_IDEALVIEWSET)) {
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $595
line 1373
;1373:		if (trap_BotMovementViewTarget(bs->ms, &goal, bs->tfl, 300, target)) {
ADDRLP4 192
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 192
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 192
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTF4 1133903872
ARGF4
ADDRLP4 112
ARGP4
ADDRLP4 196
ADDRGP4 trap_BotMovementViewTarget
CALLI4
ASGNI4
ADDRLP4 196
INDIRI4
CNSTI4 0
EQI4 $597
line 1374
;1374:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 200
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
ADDRLP4 112
INDIRF4
ADDRLP4 200
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+4
ADDRLP4 112+4
INDIRF4
ADDRLP4 200
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+8
ADDRLP4 112+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1375
;1375:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 124
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1376
;1376:		}
ADDRGP4 $598
JUMPV
LABELV $597
line 1378
;1377:		//FIXME: look at cluster portals?
;1378:		else if (VectorLength(moveresult.movedir)) {
ADDRLP4 0+28
ARGP4
ADDRLP4 200
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 200
INDIRF4
CNSTF4 0
EQF4 $603
line 1379
;1379:			vectoangles(moveresult.movedir, bs->ideal_viewangles);
ADDRLP4 0+28
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1380
;1380:		}
ADDRGP4 $604
JUMPV
LABELV $603
line 1381
;1381:		else if (random() < bs->thinktime * 0.8) {
ADDRLP4 204
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 204
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1061997773
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
GEF4 $607
line 1382
;1382:			BotRoamGoal(bs, target);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 112
ARGP4
ADDRGP4 BotRoamGoal
CALLV
pop
line 1383
;1383:			VectorSubtract(target, bs->origin, dir);
ADDRLP4 208
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
ADDRLP4 112
INDIRF4
ADDRLP4 208
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+4
ADDRLP4 112+4
INDIRF4
ADDRLP4 208
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+8
ADDRLP4 112+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1384
;1384:			vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 124
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1385
;1385:			bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 212
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 212
INDIRP4
CNSTF4 1056964608
ADDRLP4 212
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1386
;1386:		}
LABELV $607
LABELV $604
LABELV $598
line 1387
;1387:		bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 208
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 208
INDIRP4
CNSTF4 1056964608
ADDRLP4 208
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1388
;1388:	}
LABELV $595
LABELV $587
LABELV $583
line 1390
;1389:	//if the weapon is used for the bot movement
;1390:	if (moveresult.flags & MOVERESULT_MOVEMENTWEAPON) bs->weaponnum = moveresult.weapon;
ADDRLP4 0+20
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $613
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 0+24
INDIRI4
ASGNI4
LABELV $613
line 1392
;1391:	//
;1392:	return qtrue;
CNSTI4 1
RETI4
LABELV $544
endproc AINode_Seek_LTG 216 20
export AIEnter_Battle_Fight
proc AIEnter_Battle_Fight 0 12
line 1400
;1393:}
;1394:
;1395:/*
;1396:==================
;1397:AIEnter_Battle_Fight
;1398:==================
;1399:*/
;1400:void AIEnter_Battle_Fight(bot_state_t *bs) {
line 1401
;1401:	BotRecordNodeSwitch(bs, "battle fight", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $618
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1402
;1402:	trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1403
;1403:	bs->ainode = AINode_Battle_Fight;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Battle_Fight
ASGNP4
line 1404
;1404:}
LABELV $617
endproc AIEnter_Battle_Fight 0 12
export AIEnter_Battle_SuicidalFight
proc AIEnter_Battle_SuicidalFight 4 12
line 1411
;1405:
;1406:/*
;1407:==================
;1408:AIEnter_Battle_Fight
;1409:==================
;1410:*/
;1411:void AIEnter_Battle_SuicidalFight(bot_state_t *bs) {
line 1412
;1412:	BotRecordNodeSwitch(bs, "battle fight", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $618
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1413
;1413:	trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1414
;1414:	bs->ainode = AINode_Battle_Fight;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Battle_Fight
ASGNP4
line 1415
;1415:	bs->flags |= BFL_FIGHTSUICIDAL;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 1416
;1416:}
LABELV $619
endproc AIEnter_Battle_SuicidalFight 4 12
export AINode_Battle_Fight
proc AINode_Battle_Fight 280 20
line 1423
;1417:
;1418:/*
;1419:==================
;1420:AINode_Battle_Fight
;1421:==================
;1422:*/
;1423:int AINode_Battle_Fight(bot_state_t *bs) {
line 1428
;1424:	int areanum;
;1425:	aas_entityinfo_t entinfo;
;1426:	bot_moveresult_t moveresult;
;1427:
;1428:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 196
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 196
INDIRI4
CNSTI4 0
EQI4 $621
line 1429
;1429:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1430
;1430:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $621
line 1434
;1431:	}
;1432:
;1433:	//if in the intermission
;1434:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 200
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $623
line 1435
;1435:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1436
;1436:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $623
line 1439
;1437:	}
;1438:	//respawn if dead
;1439:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 204
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 204
INDIRI4
CNSTI4 0
EQI4 $625
line 1440
;1440:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1441
;1441:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $625
line 1444
;1442:	}
;1443:	//if there is another better enemy
;1444:	if (BotFindEnemy(bs, bs->enemy)) {
ADDRLP4 208
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 208
INDIRP4
ARGP4
ADDRLP4 208
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 212
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 212
INDIRI4
CNSTI4 0
EQI4 $627
line 1448
;1445:#ifdef DEBUG
;1446:		BotAI_Print(PRT_MESSAGE, "found new better enemy\n");
;1447:#endif
;1448:	}
LABELV $627
line 1450
;1449:	//if no enemy
;1450:	if (bs->enemy < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
GEI4 $629
line 1451
;1451:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1452
;1452:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $629
line 1455
;1453:	}
;1454:	//
;1455:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1457
;1456:	//if the enemy is dead
;1457:	if (bs->enemydeath_time) {
ADDRFP4 0
INDIRP4
CNSTI4 6100
ADDP4
INDIRF4
CNSTF4 0
EQF4 $631
line 1458
;1458:		if (bs->enemydeath_time < trap_AAS_Time() - 1.0) {
ADDRLP4 216
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6100
ADDP4
INDIRF4
ADDRLP4 216
INDIRF4
CNSTF4 1065353216
SUBF4
GEF4 $632
line 1459
;1459:			bs->enemydeath_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6100
ADDP4
CNSTF4 0
ASGNF4
line 1460
;1460:			if (bs->enemysuicide) {
ADDRFP4 0
INDIRP4
CNSTI4 5988
ADDP4
INDIRI4
CNSTI4 0
EQI4 $635
line 1461
;1461:				BotChat_EnemySuicide(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChat_EnemySuicide
CALLI4
pop
line 1462
;1462:			}
LABELV $635
line 1463
;1463:			if (bs->lastkilledplayer == bs->enemy && BotChat_Kill(bs)) {
ADDRLP4 220
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 220
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ADDRLP4 220
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
NEI4 $637
ADDRLP4 220
INDIRP4
ARGP4
ADDRLP4 224
ADDRGP4 BotChat_Kill
CALLI4
ASGNI4
ADDRLP4 224
INDIRI4
CNSTI4 0
EQI4 $637
line 1464
;1464:				bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 228
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 232
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
ADDF4
ASGNF4
line 1465
;1465:				AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 1466
;1466:			}
ADDRGP4 $638
JUMPV
LABELV $637
line 1467
;1467:			else {
line 1468
;1468:				bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 1469
;1469:				AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1470
;1470:			}
LABELV $638
line 1471
;1471:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
line 1473
;1472:		}
;1473:	}
LABELV $631
line 1474
;1474:	else {
line 1475
;1475:		if (EntityIsDead(&entinfo)) {
ADDRLP4 0
ARGP4
ADDRLP4 216
ADDRGP4 EntityIsDead
CALLI4
ASGNI4
ADDRLP4 216
INDIRI4
CNSTI4 0
EQI4 $639
line 1476
;1476:			bs->enemydeath_time = trap_AAS_Time();
ADDRLP4 220
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6100
ADDP4
ADDRLP4 220
INDIRF4
ASGNF4
line 1477
;1477:		}
LABELV $639
line 1478
;1478:	}
LABELV $632
line 1480
;1479:	//if the enemy is invisible and not shooting the bot looses track easily
;1480:	if (EntityIsInvisible(&entinfo) && !EntityIsShooting(&entinfo)) {
ADDRLP4 0
ARGP4
ADDRLP4 216
ADDRGP4 EntityIsInvisible
CALLI4
ASGNI4
ADDRLP4 216
INDIRI4
CNSTI4 0
EQI4 $641
ADDRLP4 0
ARGP4
ADDRLP4 220
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 220
INDIRI4
CNSTI4 0
NEI4 $641
line 1481
;1481:		if (random() < 0.2) {
ADDRLP4 224
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 224
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1045220557
GEF4 $643
line 1482
;1482:			AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1483
;1483:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $643
line 1485
;1484:		}
;1485:	}
LABELV $641
line 1487
;1486:	//update the reachability area and origin if possible
;1487:	areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 0+24
ARGP4
ADDRLP4 224
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 192
ADDRLP4 224
INDIRI4
ASGNI4
line 1488
;1488:	if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 192
INDIRI4
CNSTI4 0
EQI4 $646
ADDRLP4 192
INDIRI4
ARGI4
ADDRLP4 232
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 232
INDIRI4
CNSTI4 0
EQI4 $646
line 1489
;1489:		VectorCopy(entinfo.origin, bs->lastenemyorigin);
ADDRFP4 0
INDIRP4
CNSTI4 6236
ADDP4
ADDRLP4 0+24
INDIRB
ASGNB 12
line 1490
;1490:		bs->lastenemyareanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6232
ADDP4
ADDRLP4 192
INDIRI4
ASGNI4
line 1491
;1491:	}
LABELV $646
line 1493
;1492:	//update the attack inventory values
;1493:	BotUpdateBattleInventory(bs, bs->enemy);
ADDRLP4 236
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
INDIRP4
ARGP4
ADDRLP4 236
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotUpdateBattleInventory
CALLV
pop
line 1495
;1494:	//if the bot's health decreased
;1495:	if (bs->lastframe_health > bs->inventory[INVENTORY_HEALTH]) {
ADDRLP4 240
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 240
INDIRP4
CNSTI4 6016
ADDP4
INDIRI4
ADDRLP4 240
INDIRP4
CNSTI4 5024
ADDP4
INDIRI4
LEI4 $649
line 1496
;1496:		if (BotChat_HitNoDeath(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 244
ADDRGP4 BotChat_HitNoDeath
CALLI4
ASGNI4
ADDRLP4 244
INDIRI4
CNSTI4 0
EQI4 $651
line 1497
;1497:			bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 248
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 252
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 248
INDIRF4
ADDRLP4 252
INDIRF4
ADDF4
ASGNF4
line 1498
;1498:			AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 1499
;1499:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $651
line 1501
;1500:		}
;1501:	}
LABELV $649
line 1503
;1502:	//if the bot hit someone
;1503:	if (bs->cur_ps.persistant[PERS_HITS] > bs->lasthitcount) {
ADDRLP4 244
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 244
INDIRP4
CNSTI4 268
ADDP4
INDIRI4
ADDRLP4 244
INDIRP4
CNSTI4 6020
ADDP4
INDIRI4
LEI4 $653
line 1504
;1504:		if (BotChat_HitNoKill(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 248
ADDRGP4 BotChat_HitNoKill
CALLI4
ASGNI4
ADDRLP4 248
INDIRI4
CNSTI4 0
EQI4 $655
line 1505
;1505:			bs->stand_time = trap_AAS_Time() + BotChatTime(bs);
ADDRLP4 252
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 256
ADDRGP4 BotChatTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6068
ADDP4
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
ADDF4
ASGNF4
line 1506
;1506:			AIEnter_Stand(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Stand
CALLV
pop
line 1507
;1507:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $655
line 1509
;1508:		}
;1509:	}
LABELV $653
line 1511
;1510:	//if the enemy is not visible
;1511:	if (!BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->enemy)) {
ADDRLP4 248
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 248
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 248
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 248
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 248
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 252
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 252
INDIRF4
CNSTF4 0
NEF4 $657
line 1512
;1512:		if (BotWantsToChase(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 256
ADDRGP4 BotWantsToChase
CALLI4
ASGNI4
ADDRLP4 256
INDIRI4
CNSTI4 0
EQI4 $659
line 1513
;1513:			AIEnter_Battle_Chase(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Chase
CALLV
pop
line 1514
;1514:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $659
line 1516
;1515:		}
;1516:		else {
line 1517
;1517:			AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1518
;1518:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $620
JUMPV
LABELV $657
line 1522
;1519:		}
;1520:	}
;1521:	//use holdable items
;1522:	BotBattleUseItems(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotBattleUseItems
CALLV
pop
line 1524
;1523:	//
;1524:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1525
;1525:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $661
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 256
INDIRP4
ADDRLP4 256
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $661
line 1527
;1526:	//if in lava or slime the bot should be able to get out
;1527:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 260
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
EQI4 $664
ADDRLP4 264
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 264
INDIRP4
ADDRLP4 264
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $664
line 1529
;1528:	//
;1529:	if (BotCanAndWantsToRocketJump(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 268
ADDRGP4 BotCanAndWantsToRocketJump
CALLI4
ASGNI4
ADDRLP4 268
INDIRI4
CNSTI4 0
EQI4 $666
line 1530
;1530:		bs->tfl |= TFL_ROCKETJUMP;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 272
INDIRP4
ADDRLP4 272
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1531
;1531:	}
LABELV $666
line 1533
;1532:	//choose the best weapon to fight with
;1533:	BotChooseWeapon(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChooseWeapon
CALLV
pop
line 1535
;1534:	//do attack movements
;1535:	moveresult = BotAttackMove(bs, bs->tfl);
ADDRLP4 140
ARGP4
ADDRLP4 272
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 272
INDIRP4
ARGP4
ADDRLP4 272
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotAttackMove
CALLV
pop
line 1537
;1536:	//if the movement failed
;1537:	if (moveresult.failure) {
ADDRLP4 140
INDIRI4
CNSTI4 0
EQI4 $668
line 1539
;1538:		//reset the avoid reach, otherwise bot is stuck in current area
;1539:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1541
;1540:		//BotAI_Print(PRT_MESSAGE, "movement failure %d\n", moveresult.traveltype);
;1541:		bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 1542
;1542:	}
LABELV $668
line 1544
;1543:	//
;1544:	BotAIBlocked(bs, &moveresult, qfalse);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1546
;1545:	//aim at the enemy
;1546:	BotAimAtEnemy(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotAimAtEnemy
CALLV
pop
line 1548
;1547:	//attack the enemy if possible
;1548:	BotCheckAttack(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCheckAttack
CALLV
pop
line 1550
;1549:	//if the bot wants to retreat
;1550:	if (!(bs->flags & BFL_FIGHTSUICIDAL)) {
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $670
line 1551
;1551:		if (BotWantsToRetreat(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 276
ADDRGP4 BotWantsToRetreat
CALLI4
ASGNI4
ADDRLP4 276
INDIRI4
CNSTI4 0
EQI4 $672
line 1552
;1552:			AIEnter_Battle_Retreat(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Retreat
CALLV
pop
line 1553
;1553:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $620
JUMPV
LABELV $672
line 1555
;1554:		}
;1555:	}
LABELV $670
line 1556
;1556:	return qtrue;
CNSTI4 1
RETI4
LABELV $620
endproc AINode_Battle_Fight 280 20
export AIEnter_Battle_Chase
proc AIEnter_Battle_Chase 4 12
line 1564
;1557:}
;1558:
;1559:/*
;1560:==================
;1561:AIEnter_Battle_Chase
;1562:==================
;1563:*/
;1564:void AIEnter_Battle_Chase(bot_state_t *bs) {
line 1565
;1565:	BotRecordNodeSwitch(bs, "battle chase", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $675
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1566
;1566:	bs->chase_time = trap_AAS_Time();
ADDRLP4 0
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6056
ADDP4
ADDRLP4 0
INDIRF4
ASGNF4
line 1567
;1567:	bs->ainode = AINode_Battle_Chase;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Battle_Chase
ASGNP4
line 1568
;1568:}
LABELV $674
endproc AIEnter_Battle_Chase 4 12
export AINode_Battle_Chase
proc AINode_Battle_Chase 216 20
line 1576
;1569:
;1570:/*
;1571:==================
;1572:AINode_Battle_Chase
;1573:==================
;1574:*/
;1575:int AINode_Battle_Chase(bot_state_t *bs)
;1576:{
line 1582
;1577:	bot_goal_t goal;
;1578:	vec3_t target, dir;
;1579:	bot_moveresult_t moveresult;
;1580:	float range;
;1581:
;1582:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 136
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 136
INDIRI4
CNSTI4 0
EQI4 $677
line 1583
;1583:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1584
;1584:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $677
line 1587
;1585:	}
;1586:	//if in the intermission
;1587:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 0
EQI4 $679
line 1588
;1588:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1589
;1589:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $679
line 1592
;1590:	}
;1591:	//respawn if dead
;1592:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 144
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
EQI4 $681
line 1593
;1593:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1594
;1594:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $681
line 1597
;1595:	}
;1596:	//if no enemy
;1597:	if (bs->enemy < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
GEI4 $683
line 1598
;1598:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1599
;1599:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $683
line 1602
;1600:	}
;1601:	//if the enemy is visible
;1602:	if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->enemy)) {
ADDRLP4 148
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 148
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 148
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 148
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 148
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 152
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 152
INDIRF4
CNSTF4 0
EQF4 $685
line 1603
;1603:		AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 1604
;1604:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $685
line 1607
;1605:	}
;1606:	//if there is another enemy
;1607:	if (BotFindEnemy(bs, -1)) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 156
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 156
INDIRI4
CNSTI4 0
EQI4 $687
line 1608
;1608:		AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 1609
;1609:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $687
line 1612
;1610:	}
;1611:	//there is no last enemy area
;1612:	if (!bs->lastenemyareanum) {
ADDRFP4 0
INDIRP4
CNSTI4 6232
ADDP4
INDIRI4
CNSTI4 0
NEI4 $689
line 1613
;1613:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1614
;1614:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $689
line 1617
;1615:	}
;1616:	//
;1617:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1618
;1618:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $691
ADDRLP4 160
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 160
INDIRP4
ADDRLP4 160
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $691
line 1620
;1619:	//if in lava or slime the bot should be able to get out
;1620:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 164
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
EQI4 $694
ADDRLP4 168
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 168
INDIRP4
ADDRLP4 168
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $694
line 1622
;1621:	//
;1622:	if (BotCanAndWantsToRocketJump(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 172
ADDRGP4 BotCanAndWantsToRocketJump
CALLI4
ASGNI4
ADDRLP4 172
INDIRI4
CNSTI4 0
EQI4 $696
line 1623
;1623:		bs->tfl |= TFL_ROCKETJUMP;
ADDRLP4 176
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 176
INDIRP4
ADDRLP4 176
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1624
;1624:	}
LABELV $696
line 1626
;1625:	//map specific code
;1626:	BotMapScripts(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotMapScripts
CALLV
pop
line 1628
;1627:	//create the chase goal
;1628:	goal.entitynum = bs->enemy;
ADDRLP4 0+40
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ASGNI4
line 1629
;1629:	goal.areanum = bs->lastenemyareanum;
ADDRLP4 0+12
ADDRFP4 0
INDIRP4
CNSTI4 6232
ADDP4
INDIRI4
ASGNI4
line 1630
;1630:	VectorCopy(bs->lastenemyorigin, goal.origin);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 6236
ADDP4
INDIRB
ASGNB 12
line 1631
;1631:	VectorSet(goal.mins, -8, -8, -8);
ADDRLP4 0+16
CNSTF4 3238002688
ASGNF4
ADDRLP4 0+16+4
CNSTF4 3238002688
ASGNF4
ADDRLP4 0+16+8
CNSTF4 3238002688
ASGNF4
line 1632
;1632:	VectorSet(goal.maxs, 8, 8, 8);
ADDRLP4 0+28
CNSTF4 1090519040
ASGNF4
ADDRLP4 0+28+4
CNSTF4 1090519040
ASGNF4
ADDRLP4 0+28+8
CNSTF4 1090519040
ASGNF4
line 1634
;1633:	//if the last seen enemy spot is reached the enemy could not be found
;1634:	if (trap_BotTouchingGoal(bs->origin, &goal)) bs->chase_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 176
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 176
INDIRI4
CNSTI4 0
EQI4 $710
ADDRFP4 0
INDIRP4
CNSTI4 6056
ADDP4
CNSTF4 0
ASGNF4
LABELV $710
line 1636
;1635:	//if there's no chase time left
;1636:	if (!bs->chase_time || bs->chase_time < trap_AAS_Time() - 10) {
ADDRLP4 180
ADDRFP4 0
INDIRP4
CNSTI4 6056
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
INDIRF4
CNSTF4 0
EQF4 $714
ADDRLP4 184
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 180
INDIRF4
ADDRLP4 184
INDIRF4
CNSTF4 1092616192
SUBF4
GEF4 $712
LABELV $714
line 1637
;1637:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1638
;1638:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $712
line 1641
;1639:	}
;1640:	//check for nearby goals periodicly
;1641:	if (bs->check_time < trap_AAS_Time()) {
ADDRLP4 188
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
INDIRF4
ADDRLP4 188
INDIRF4
GEF4 $715
line 1642
;1642:		bs->check_time = trap_AAS_Time() + 1;
ADDRLP4 192
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
ADDRLP4 192
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1643
;1643:		range = 150;
ADDRLP4 108
CNSTF4 1125515264
ASGNF4
line 1645
;1644:		//
;1645:		if (BotNearbyGoal(bs, bs->tfl, &goal, range)) {
ADDRLP4 196
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 196
INDIRP4
ARGP4
ADDRLP4 196
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 108
INDIRF4
ARGF4
ADDRLP4 200
ADDRGP4 BotNearbyGoal
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $717
line 1647
;1646:			//the bot gets 5 seconds to pick up the nearby goal item
;1647:			bs->nbg_time = trap_AAS_Time() + 0.1 * range + 1;
ADDRLP4 204
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
ADDRLP4 204
INDIRF4
CNSTF4 1036831949
ADDRLP4 108
INDIRF4
MULF4
ADDF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1648
;1648:			trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1649
;1649:			AIEnter_Battle_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_NBG
CALLV
pop
line 1650
;1650:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $676
JUMPV
LABELV $717
line 1652
;1651:		}
;1652:	}
LABELV $715
line 1654
;1653:	//
;1654:	BotUpdateBattleInventory(bs, bs->enemy);
ADDRLP4 192
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 192
INDIRP4
ARGP4
ADDRLP4 192
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotUpdateBattleInventory
CALLV
pop
line 1656
;1655:	//initialize the movement state
;1656:	BotSetupForMovement(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1658
;1657:	//move towards the goal
;1658:	trap_BotMoveToGoal(&moveresult, bs->ms, &goal, bs->tfl);
ADDRLP4 56
ARGP4
ADDRLP4 196
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 196
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 196
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1660
;1659:	//if the movement failed
;1660:	if (moveresult.failure) {
ADDRLP4 56
INDIRI4
CNSTI4 0
EQI4 $719
line 1662
;1661:		//reset the avoid reach, otherwise bot is stuck in current area
;1662:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1664
;1663:		//BotAI_Print(PRT_MESSAGE, "movement failure %d\n", moveresult.traveltype);
;1664:		bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 1665
;1665:	}
LABELV $719
line 1667
;1666:	//
;1667:	BotAIBlocked(bs, &moveresult, qfalse);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1669
;1668:	//
;1669:	if (moveresult.flags & (MOVERESULT_MOVEMENTVIEWSET|MOVERESULT_MOVEMENTVIEW|MOVERESULT_SWIMVIEW)) {
ADDRLP4 56+20
INDIRI4
CNSTI4 11
BANDI4
CNSTI4 0
EQI4 $721
line 1670
;1670:		VectorCopy(moveresult.ideal_viewangles, bs->ideal_viewangles);
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDRLP4 56+40
INDIRB
ASGNB 12
line 1671
;1671:	}
ADDRGP4 $722
JUMPV
LABELV $721
line 1672
;1672:	else if (!(bs->flags & BFL_IDEALVIEWSET)) {
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $725
line 1673
;1673:		if (bs->chase_time > trap_AAS_Time() - 2) {
ADDRLP4 200
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6056
ADDP4
INDIRF4
ADDRLP4 200
INDIRF4
CNSTF4 1073741824
SUBF4
LEF4 $727
line 1674
;1674:			BotAimAtEnemy(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotAimAtEnemy
CALLV
pop
line 1675
;1675:		}
ADDRGP4 $728
JUMPV
LABELV $727
line 1676
;1676:		else {
line 1677
;1677:			if (trap_BotMovementViewTarget(bs->ms, &goal, bs->tfl, 300, target)) {
ADDRLP4 204
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 204
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 204
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTF4 1133903872
ARGF4
ADDRLP4 112
ARGP4
ADDRLP4 208
ADDRGP4 trap_BotMovementViewTarget
CALLI4
ASGNI4
ADDRLP4 208
INDIRI4
CNSTI4 0
EQI4 $729
line 1678
;1678:				VectorSubtract(target, bs->origin, dir);
ADDRLP4 212
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
ADDRLP4 112
INDIRF4
ADDRLP4 212
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+4
ADDRLP4 112+4
INDIRF4
ADDRLP4 212
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 124+8
ADDRLP4 112+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1679
;1679:				vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 124
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1680
;1680:			}
ADDRGP4 $730
JUMPV
LABELV $729
line 1681
;1681:			else {
line 1682
;1682:				vectoangles(moveresult.movedir, bs->ideal_viewangles);
ADDRLP4 56+28
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1683
;1683:			}
LABELV $730
line 1684
;1684:		}
LABELV $728
line 1685
;1685:		bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 204
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 204
INDIRP4
CNSTF4 1056964608
ADDRLP4 204
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1686
;1686:	}
LABELV $725
LABELV $722
line 1688
;1687:	//if the weapon is used for the bot movement
;1688:	if (moveresult.flags & MOVERESULT_MOVEMENTWEAPON) bs->weaponnum = moveresult.weapon;
ADDRLP4 56+20
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $736
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 56+24
INDIRI4
ASGNI4
LABELV $736
line 1690
;1689:	//if the bot is in the area the enemy was last seen in
;1690:	if (bs->areanum == bs->lastenemyareanum) bs->chase_time = 0;
ADDRLP4 200
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 200
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ADDRLP4 200
INDIRP4
CNSTI4 6232
ADDP4
INDIRI4
NEI4 $740
ADDRFP4 0
INDIRP4
CNSTI4 6056
ADDP4
CNSTF4 0
ASGNF4
LABELV $740
line 1692
;1691:	//if the bot wants to retreat (the bot could have been damage during the chase)
;1692:	if (BotWantsToRetreat(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 204
ADDRGP4 BotWantsToRetreat
CALLI4
ASGNI4
ADDRLP4 204
INDIRI4
CNSTI4 0
EQI4 $742
line 1693
;1693:		AIEnter_Battle_Retreat(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Retreat
CALLV
pop
line 1694
;1694:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $676
JUMPV
LABELV $742
line 1696
;1695:	}
;1696:	return qtrue;
CNSTI4 1
RETI4
LABELV $676
endproc AINode_Battle_Chase 216 20
export AIEnter_Battle_Retreat
proc AIEnter_Battle_Retreat 0 12
line 1704
;1697:}
;1698:
;1699:/*
;1700:==================
;1701:AIEnter_Battle_Retreat
;1702:==================
;1703:*/
;1704:void AIEnter_Battle_Retreat(bot_state_t *bs) {
line 1705
;1705:	BotRecordNodeSwitch(bs, "battle retreat", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $745
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1706
;1706:	bs->ainode = AINode_Battle_Retreat;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Battle_Retreat
ASGNP4
line 1707
;1707:}
LABELV $744
endproc AIEnter_Battle_Retreat 0 12
export AINode_Battle_Retreat
proc AINode_Battle_Retreat 372 20
line 1714
;1708:
;1709:/*
;1710:==================
;1711:AINode_Battle_Retreat
;1712:==================
;1713:*/
;1714:int AINode_Battle_Retreat(bot_state_t *bs) {
line 1722
;1715:	bot_goal_t goal;
;1716:	aas_entityinfo_t entinfo;
;1717:	bot_moveresult_t moveresult;
;1718:	vec3_t target, dir;
;1719:	float attack_skill, range;
;1720:	int areanum;
;1721:
;1722:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 284
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 284
INDIRI4
CNSTI4 0
EQI4 $747
line 1723
;1723:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1724
;1724:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $747
line 1727
;1725:	}
;1726:	//if in the intermission
;1727:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 288
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 288
INDIRI4
CNSTI4 0
EQI4 $749
line 1728
;1728:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1729
;1729:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $749
line 1732
;1730:	}
;1731:	//respawn if dead
;1732:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 292
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 292
INDIRI4
CNSTI4 0
EQI4 $751
line 1733
;1733:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1734
;1734:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $751
line 1737
;1735:	}
;1736:	//if no enemy
;1737:	if (bs->enemy < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
GEI4 $753
line 1738
;1738:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1739
;1739:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $753
line 1742
;1740:	}
;1741:	//
;1742:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1743
;1743:	if (EntityIsDead(&entinfo)) {
ADDRLP4 52
ARGP4
ADDRLP4 296
ADDRGP4 EntityIsDead
CALLI4
ASGNI4
ADDRLP4 296
INDIRI4
CNSTI4 0
EQI4 $755
line 1744
;1744:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1745
;1745:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $755
line 1748
;1746:	}
;1747:	//
;1748:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1749
;1749:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $757
ADDRLP4 300
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 300
INDIRP4
ADDRLP4 300
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $757
line 1751
;1750:	//if in lava or slime the bot should be able to get out
;1751:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 304
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 304
INDIRI4
CNSTI4 0
EQI4 $760
ADDRLP4 308
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 308
INDIRP4
ADDRLP4 308
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $760
line 1753
;1752:	//map specific code
;1753:	BotMapScripts(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotMapScripts
CALLV
pop
line 1755
;1754:	//update the attack inventory values
;1755:	BotUpdateBattleInventory(bs, bs->enemy);
ADDRLP4 312
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 312
INDIRP4
ARGP4
ADDRLP4 312
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotUpdateBattleInventory
CALLV
pop
line 1757
;1756:	//if the bot doesn't want to retreat anymore... probably picked up some nice items
;1757:	if (BotWantsToChase(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 316
ADDRGP4 BotWantsToChase
CALLI4
ASGNI4
ADDRLP4 316
INDIRI4
CNSTI4 0
EQI4 $762
line 1759
;1758:		//empty the goal stack, when chasing, only the enemy is the goal
;1759:		trap_BotEmptyGoalStack(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotEmptyGoalStack
CALLV
pop
line 1761
;1760:		//go chase the enemy
;1761:		AIEnter_Battle_Chase(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Chase
CALLV
pop
line 1762
;1762:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $762
line 1765
;1763:	}
;1764:	//update the last time the enemy was visible
;1765:	if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->enemy)) {
ADDRLP4 320
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 320
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 320
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 320
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 320
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 324
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 324
INDIRF4
CNSTF4 0
EQF4 $764
line 1766
;1766:		bs->enemyvisible_time = trap_AAS_Time();
ADDRLP4 328
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6060
ADDP4
ADDRLP4 328
INDIRF4
ASGNF4
line 1768
;1767:		//update the reachability area and origin if possible
;1768:		areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 52+24
ARGP4
ADDRLP4 332
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 248
ADDRLP4 332
INDIRI4
ASGNI4
line 1769
;1769:		if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 336
ADDRLP4 248
INDIRI4
ASGNI4
ADDRLP4 336
INDIRI4
CNSTI4 0
EQI4 $767
ADDRLP4 336
INDIRI4
ARGI4
ADDRLP4 340
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 340
INDIRI4
CNSTI4 0
EQI4 $767
line 1770
;1770:			VectorCopy(entinfo.origin, bs->lastenemyorigin);
ADDRFP4 0
INDIRP4
CNSTI4 6236
ADDP4
ADDRLP4 52+24
INDIRB
ASGNB 12
line 1771
;1771:			bs->lastenemyareanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6232
ADDP4
ADDRLP4 248
INDIRI4
ASGNI4
line 1772
;1772:		}
LABELV $767
line 1773
;1773:	}
LABELV $764
line 1775
;1774:	//if the enemy is NOT visible for 4 seconds
;1775:	if (bs->enemyvisible_time < trap_AAS_Time() - 4) {
ADDRLP4 328
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6060
ADDP4
INDIRF4
ADDRLP4 328
INDIRF4
CNSTF4 1082130432
SUBF4
GEF4 $770
line 1776
;1776:		AIEnter_Seek_LTG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_LTG
CALLV
pop
line 1777
;1777:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $770
line 1780
;1778:	}
;1779:	//else if the enemy is NOT visible
;1780:	else if (bs->enemyvisible_time < trap_AAS_Time()) {
ADDRLP4 332
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6060
ADDP4
INDIRF4
ADDRLP4 332
INDIRF4
GEF4 $772
line 1782
;1781:		//if there is another enemy
;1782:		if (BotFindEnemy(bs, -1)) {
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 336
ADDRGP4 BotFindEnemy
CALLI4
ASGNI4
ADDRLP4 336
INDIRI4
CNSTI4 0
EQI4 $774
line 1783
;1783:			AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
line 1784
;1784:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $774
line 1786
;1785:		}
;1786:	}
LABELV $772
line 1789
;1787:	//
;1788:#ifdef CTF
;1789:	if (gametype == GT_CTF) {
ADDRGP4 gametype
INDIRI4
CNSTI4 4
NEI4 $776
line 1790
;1790:		BotCTFRetreatGoals(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCTFRetreatGoals
CALLV
pop
line 1791
;1791:	}
LABELV $776
line 1794
;1792:#endif //CTF
;1793:	//use holdable items
;1794:	BotBattleUseItems(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotBattleUseItems
CALLV
pop
line 1796
;1795:	//get the current long term goal while retreating
;1796:	if (!BotLongTermGoal(bs, bs->tfl, qtrue, &goal)) {
ADDRLP4 336
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 336
INDIRP4
ARGP4
ADDRLP4 336
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 192
ARGP4
ADDRLP4 340
ADDRGP4 BotLongTermGoal
CALLI4
ASGNI4
ADDRLP4 340
INDIRI4
CNSTI4 0
NEI4 $778
line 1797
;1797:		AIEnter_Battle_SuicidalFight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_SuicidalFight
CALLV
pop
line 1798
;1798:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $778
line 1801
;1799:	}
;1800:	//check for nearby goals periodicly
;1801:	if (bs->check_time < trap_AAS_Time()) {
ADDRLP4 344
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
INDIRF4
ADDRLP4 344
INDIRF4
GEF4 $780
line 1802
;1802:		bs->check_time = trap_AAS_Time() + 1;
ADDRLP4 348
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6064
ADDP4
ADDRLP4 348
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1803
;1803:		range = 150;
ADDRLP4 252
CNSTF4 1125515264
ASGNF4
line 1806
;1804:#ifdef CTF
;1805:		//if carrying a flag the bot shouldn't be distracted too much
;1806:		if (BotCTFCarryingFlag(bs)) range = 100;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 352
ADDRGP4 BotCTFCarryingFlag
CALLI4
ASGNI4
ADDRLP4 352
INDIRI4
CNSTI4 0
EQI4 $782
ADDRLP4 252
CNSTF4 1120403456
ASGNF4
LABELV $782
line 1809
;1807:#endif //CTF
;1808:		//
;1809:		if (BotNearbyGoal(bs, bs->tfl, &goal, range)) {
ADDRLP4 356
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 356
INDIRP4
ARGP4
ADDRLP4 356
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRLP4 192
ARGP4
ADDRLP4 252
INDIRF4
ARGF4
ADDRLP4 360
ADDRGP4 BotNearbyGoal
CALLI4
ASGNI4
ADDRLP4 360
INDIRI4
CNSTI4 0
EQI4 $784
line 1810
;1810:			trap_BotResetLastAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetLastAvoidReach
CALLV
pop
line 1812
;1811:			//time the bot gets to pick up the nearby goal item
;1812:			bs->nbg_time = trap_AAS_Time() + range / 100 + 1;
ADDRLP4 364
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
ADDRLP4 364
INDIRF4
ADDRLP4 252
INDIRF4
CNSTF4 1120403456
DIVF4
ADDF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1813
;1813:			AIEnter_Battle_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_NBG
CALLV
pop
line 1814
;1814:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $746
JUMPV
LABELV $784
line 1816
;1815:		}
;1816:	}
LABELV $780
line 1818
;1817:	//initialize the movement state
;1818:	BotSetupForMovement(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1820
;1819:	//move towards the goal
;1820:	trap_BotMoveToGoal(&moveresult, bs->ms, &goal, bs->tfl);
ADDRLP4 0
ARGP4
ADDRLP4 348
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 348
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 192
ARGP4
ADDRLP4 348
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1822
;1821:	//if the movement failed
;1822:	if (moveresult.failure) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $786
line 1824
;1823:		//reset the avoid reach, otherwise bot is stuck in current area
;1824:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1826
;1825:		//BotAI_Print(PRT_MESSAGE, "movement failure %d\n", moveresult.traveltype);
;1826:		bs->ltg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6040
ADDP4
CNSTF4 0
ASGNF4
line 1827
;1827:	}
LABELV $786
line 1829
;1828:	//
;1829:	BotAIBlocked(bs, &moveresult, qfalse);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1831
;1830:	//choose the best weapon to fight with
;1831:	BotChooseWeapon(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChooseWeapon
CALLV
pop
line 1833
;1832:	//if the view is fixed for the movement
;1833:	if (moveresult.flags & (MOVERESULT_MOVEMENTVIEW|MOVERESULT_SWIMVIEW)) {
ADDRLP4 0+20
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 0
EQI4 $788
line 1834
;1834:		VectorCopy(moveresult.ideal_viewangles, bs->ideal_viewangles);
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDRLP4 0+40
INDIRB
ASGNB 12
line 1835
;1835:	}
ADDRGP4 $789
JUMPV
LABELV $788
line 1836
;1836:	else if (!(moveresult.flags & MOVERESULT_MOVEMENTVIEWSET)
ADDRLP4 352
CNSTI4 0
ASGNI4
ADDRLP4 0+20
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 352
INDIRI4
NEI4 $792
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 32
BANDI4
ADDRLP4 352
INDIRI4
NEI4 $792
line 1837
;1837:				&& !(bs->flags & BFL_IDEALVIEWSET) ) {
line 1838
;1838:		attack_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_ATTACK_SKILL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 356
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 256
ADDRLP4 356
INDIRF4
ASGNF4
line 1840
;1839:		//if the bot is skilled anough
;1840:		if (attack_skill > 0.3) {
ADDRLP4 256
INDIRF4
CNSTF4 1050253722
LEF4 $795
line 1841
;1841:			BotAimAtEnemy(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotAimAtEnemy
CALLV
pop
line 1842
;1842:		}
ADDRGP4 $796
JUMPV
LABELV $795
line 1843
;1843:		else {
line 1844
;1844:			if (trap_BotMovementViewTarget(bs->ms, &goal, bs->tfl, 300, target)) {
ADDRLP4 360
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 360
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 192
ARGP4
ADDRLP4 360
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTF4 1133903872
ARGF4
ADDRLP4 260
ARGP4
ADDRLP4 364
ADDRGP4 trap_BotMovementViewTarget
CALLI4
ASGNI4
ADDRLP4 364
INDIRI4
CNSTI4 0
EQI4 $797
line 1845
;1845:				VectorSubtract(target, bs->origin, dir);
ADDRLP4 368
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 272
ADDRLP4 260
INDIRF4
ADDRLP4 368
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 272+4
ADDRLP4 260+4
INDIRF4
ADDRLP4 368
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 272+8
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1846
;1846:				vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 272
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1847
;1847:			}
ADDRGP4 $798
JUMPV
LABELV $797
line 1848
;1848:			else {
line 1849
;1849:				vectoangles(moveresult.movedir, bs->ideal_viewangles);
ADDRLP4 0+28
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1850
;1850:			}
LABELV $798
line 1851
;1851:			bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 368
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 368
INDIRP4
CNSTF4 1056964608
ADDRLP4 368
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1852
;1852:		}
LABELV $796
line 1853
;1853:	}
LABELV $792
LABELV $789
line 1855
;1854:	//if the weapon is used for the bot movement
;1855:	if (moveresult.flags & MOVERESULT_MOVEMENTWEAPON) bs->weaponnum = moveresult.weapon;
ADDRLP4 0+20
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $804
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 0+24
INDIRI4
ASGNI4
LABELV $804
line 1857
;1856:	//attack the enemy if possible
;1857:	BotCheckAttack(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCheckAttack
CALLV
pop
line 1859
;1858:	//
;1859:	return qtrue;
CNSTI4 1
RETI4
LABELV $746
endproc AINode_Battle_Retreat 372 20
export AIEnter_Battle_NBG
proc AIEnter_Battle_NBG 0 12
line 1867
;1860:}
;1861:
;1862:/*
;1863:==================
;1864:AIEnter_Battle_NBG
;1865:==================
;1866:*/
;1867:void AIEnter_Battle_NBG(bot_state_t *bs) {
line 1868
;1868:	BotRecordNodeSwitch(bs, "battle NBG", "");
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $809
ARGP4
ADDRGP4 $54
ARGP4
ADDRGP4 BotRecordNodeSwitch
CALLV
pop
line 1869
;1869:	bs->ainode = AINode_Battle_NBG;
ADDRFP4 0
INDIRP4
CNSTI4 4876
ADDP4
ADDRGP4 AINode_Battle_NBG
ASGNP4
line 1870
;1870:}
LABELV $808
endproc AIEnter_Battle_NBG 0 12
export AINode_Battle_NBG
proc AINode_Battle_NBG 360 20
line 1877
;1871:
;1872:/*
;1873:==================
;1874:AINode_Battle_NBG
;1875:==================
;1876:*/
;1877:int AINode_Battle_NBG(bot_state_t *bs) {
line 1885
;1878:	int areanum;
;1879:	bot_goal_t goal;
;1880:	aas_entityinfo_t entinfo;
;1881:	bot_moveresult_t moveresult;
;1882:	float attack_skill;
;1883:	vec3_t target, dir;
;1884:
;1885:	if (BotIsObserver(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 280
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 280
INDIRI4
CNSTI4 0
EQI4 $811
line 1886
;1886:		AIEnter_Observer(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Observer
CALLV
pop
line 1887
;1887:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $810
JUMPV
LABELV $811
line 1890
;1888:	}
;1889:	//if in the intermission
;1890:	if (BotIntermission(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 284
ADDRGP4 BotIntermission
CALLI4
ASGNI4
ADDRLP4 284
INDIRI4
CNSTI4 0
EQI4 $813
line 1891
;1891:		AIEnter_Intermission(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Intermission
CALLV
pop
line 1892
;1892:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $810
JUMPV
LABELV $813
line 1895
;1893:	}
;1894:	//respawn if dead
;1895:	if (BotIsDead(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 288
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 288
INDIRI4
CNSTI4 0
EQI4 $815
line 1896
;1896:		AIEnter_Respawn(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Respawn
CALLV
pop
line 1897
;1897:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $810
JUMPV
LABELV $815
line 1900
;1898:	}
;1899:	//if no enemy
;1900:	if (bs->enemy < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
GEI4 $817
line 1901
;1901:		AIEnter_Seek_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_NBG
CALLV
pop
line 1902
;1902:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $810
JUMPV
LABELV $817
line 1905
;1903:	}
;1904:	//
;1905:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 108
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1906
;1906:	if (EntityIsDead(&entinfo)) {
ADDRLP4 108
ARGP4
ADDRLP4 292
ADDRGP4 EntityIsDead
CALLI4
ASGNI4
ADDRLP4 292
INDIRI4
CNSTI4 0
EQI4 $819
line 1907
;1907:		AIEnter_Seek_NBG(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Seek_NBG
CALLV
pop
line 1908
;1908:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $810
JUMPV
LABELV $819
line 1911
;1909:	}
;1910:	//
;1911:	bs->tfl = TFL_DEFAULT;
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
CNSTI4 18616254
ASGNI4
line 1912
;1912:	if (bot_grapple.integer) bs->tfl |= TFL_GRAPPLEHOOK;
ADDRGP4 bot_grapple+12
INDIRI4
CNSTI4 0
EQI4 $821
ADDRLP4 296
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 296
INDIRP4
ADDRLP4 296
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
LABELV $821
line 1914
;1913:	//if in lava or slime the bot should be able to get out
;1914:	if (BotInLavaOrSlime(bs)) bs->tfl |= TFL_LAVA|TFL_SLIME;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 300
ADDRGP4 BotInLavaOrSlime
CALLI4
ASGNI4
ADDRLP4 300
INDIRI4
CNSTI4 0
EQI4 $824
ADDRLP4 304
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 304
INDIRP4
ADDRLP4 304
INDIRP4
INDIRI4
CNSTI4 6291456
BORI4
ASGNI4
LABELV $824
line 1916
;1915:	//
;1916:	if (BotCanAndWantsToRocketJump(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 308
ADDRGP4 BotCanAndWantsToRocketJump
CALLI4
ASGNI4
ADDRLP4 308
INDIRI4
CNSTI4 0
EQI4 $826
line 1917
;1917:		bs->tfl |= TFL_ROCKETJUMP;
ADDRLP4 312
ADDRFP4 0
INDIRP4
CNSTI4 5952
ADDP4
ASGNP4
ADDRLP4 312
INDIRP4
ADDRLP4 312
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1918
;1918:	}
LABELV $826
line 1920
;1919:	//map specific code
;1920:	BotMapScripts(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotMapScripts
CALLV
pop
line 1922
;1921:	//update the last time the enemy was visible
;1922:	if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->enemy)) {
ADDRLP4 312
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 312
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 312
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 312
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 312
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 316
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 316
INDIRF4
CNSTF4 0
EQF4 $828
line 1923
;1923:		bs->enemyvisible_time = trap_AAS_Time();
ADDRLP4 320
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6060
ADDP4
ADDRLP4 320
INDIRF4
ASGNF4
line 1925
;1924:		//update the reachability area and origin if possible
;1925:		areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 108+24
ARGP4
ADDRLP4 324
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 248
ADDRLP4 324
INDIRI4
ASGNI4
line 1926
;1926:		if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 328
ADDRLP4 248
INDIRI4
ASGNI4
ADDRLP4 328
INDIRI4
CNSTI4 0
EQI4 $831
ADDRLP4 328
INDIRI4
ARGI4
ADDRLP4 332
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 332
INDIRI4
CNSTI4 0
EQI4 $831
line 1927
;1927:			VectorCopy(entinfo.origin, bs->lastenemyorigin);
ADDRFP4 0
INDIRP4
CNSTI4 6236
ADDP4
ADDRLP4 108+24
INDIRB
ASGNB 12
line 1928
;1928:			bs->lastenemyareanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6232
ADDP4
ADDRLP4 248
INDIRI4
ASGNI4
line 1929
;1929:		}
LABELV $831
line 1930
;1930:	}
LABELV $828
line 1932
;1931:	//if the bot has no goal or touches the current goal
;1932:	if (!trap_BotGetTopGoal(bs->gs, &goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 320
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 320
INDIRI4
CNSTI4 0
NEI4 $834
line 1933
;1933:		bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
line 1934
;1934:	}
ADDRGP4 $835
JUMPV
LABELV $834
line 1935
;1935:	else if (trap_BotTouchingGoal(bs->origin, &goal)) {
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRLP4 52
ARGP4
ADDRLP4 324
ADDRGP4 trap_BotTouchingGoal
CALLI4
ASGNI4
ADDRLP4 324
INDIRI4
CNSTI4 0
EQI4 $836
line 1936
;1936:		bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
line 1937
;1937:	}
LABELV $836
LABELV $835
line 1939
;1938:	//
;1939:	if (bs->nbg_time < trap_AAS_Time()) {
ADDRLP4 328
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
INDIRF4
ADDRLP4 328
INDIRF4
GEF4 $838
line 1941
;1940:		//pop the current goal from the stack
;1941:		trap_BotPopGoal(bs->gs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotPopGoal
CALLV
pop
line 1943
;1942:		//if the bot still has a goal
;1943:		if (trap_BotGetTopGoal(bs->gs, &goal)) AIEnter_Battle_Retreat(bs);
ADDRFP4 0
INDIRP4
CNSTI4 6216
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 332
ADDRGP4 trap_BotGetTopGoal
CALLI4
ASGNI4
ADDRLP4 332
INDIRI4
CNSTI4 0
EQI4 $840
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Retreat
CALLV
pop
ADDRGP4 $841
JUMPV
LABELV $840
line 1944
;1944:		else AIEnter_Battle_Fight(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 AIEnter_Battle_Fight
CALLV
pop
LABELV $841
line 1946
;1945:		//
;1946:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $810
JUMPV
LABELV $838
line 1949
;1947:	}
;1948:	//initialize the movement state
;1949:	BotSetupForMovement(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotSetupForMovement
CALLV
pop
line 1951
;1950:	//move towards the goal
;1951:	trap_BotMoveToGoal(&moveresult, bs->ms, &goal, bs->tfl);
ADDRLP4 0
ARGP4
ADDRLP4 332
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 332
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 332
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotMoveToGoal
CALLV
pop
line 1953
;1952:	//if the movement failed
;1953:	if (moveresult.failure) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $842
line 1955
;1954:		//reset the avoid reach, otherwise bot is stuck in current area
;1955:		trap_BotResetAvoidReach(bs->ms);
ADDRFP4 0
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_BotResetAvoidReach
CALLV
pop
line 1957
;1956:		//BotAI_Print(PRT_MESSAGE, "movement failure %d\n", moveresult.traveltype);
;1957:		bs->nbg_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6044
ADDP4
CNSTF4 0
ASGNF4
line 1958
;1958:	}
LABELV $842
line 1960
;1959:	//
;1960:	BotAIBlocked(bs, &moveresult, qfalse);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BotAIBlocked
CALLV
pop
line 1962
;1961:	//update the attack inventory values
;1962:	BotUpdateBattleInventory(bs, bs->enemy);
ADDRLP4 336
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 336
INDIRP4
ARGP4
ADDRLP4 336
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRGP4 BotUpdateBattleInventory
CALLV
pop
line 1964
;1963:	//choose the best weapon to fight with
;1964:	BotChooseWeapon(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotChooseWeapon
CALLV
pop
line 1966
;1965:	//if the view is fixed for the movement
;1966:	if (moveresult.flags & (MOVERESULT_MOVEMENTVIEW|MOVERESULT_SWIMVIEW)) {
ADDRLP4 0+20
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 0
EQI4 $844
line 1967
;1967:		VectorCopy(moveresult.ideal_viewangles, bs->ideal_viewangles);
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ADDRLP4 0+40
INDIRB
ASGNB 12
line 1968
;1968:	}
ADDRGP4 $845
JUMPV
LABELV $844
line 1969
;1969:	else if (!(moveresult.flags & MOVERESULT_MOVEMENTVIEWSET)
ADDRLP4 340
CNSTI4 0
ASGNI4
ADDRLP4 0+20
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 340
INDIRI4
NEI4 $848
ADDRFP4 0
INDIRP4
CNSTI4 5956
ADDP4
INDIRI4
CNSTI4 32
BANDI4
ADDRLP4 340
INDIRI4
NEI4 $848
line 1970
;1970:				&& !(bs->flags & BFL_IDEALVIEWSET)) {
line 1971
;1971:		attack_skill = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_ATTACK_SKILL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 344
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 252
ADDRLP4 344
INDIRF4
ASGNF4
line 1973
;1972:		//if the bot is skilled anough and the enemy is visible
;1973:		if (attack_skill > 0.3) {
ADDRLP4 252
INDIRF4
CNSTF4 1050253722
LEF4 $851
line 1975
;1974:			//&& BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, bs->enemy)
;1975:			BotAimAtEnemy(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotAimAtEnemy
CALLV
pop
line 1976
;1976:		}
ADDRGP4 $852
JUMPV
LABELV $851
line 1977
;1977:		else {
line 1978
;1978:			if (trap_BotMovementViewTarget(bs->ms, &goal, bs->tfl, 300, target)) {
ADDRLP4 348
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 348
INDIRP4
CNSTI4 6212
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 348
INDIRP4
CNSTI4 5952
ADDP4
INDIRI4
ARGI4
CNSTF4 1133903872
ARGF4
ADDRLP4 256
ARGP4
ADDRLP4 352
ADDRGP4 trap_BotMovementViewTarget
CALLI4
ASGNI4
ADDRLP4 352
INDIRI4
CNSTI4 0
EQI4 $853
line 1979
;1979:				VectorSubtract(target, bs->origin, dir);
ADDRLP4 356
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 268
ADDRLP4 256
INDIRF4
ADDRLP4 356
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 268+4
ADDRLP4 256+4
INDIRF4
ADDRLP4 356
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 268+8
ADDRLP4 256+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1980
;1980:				vectoangles(dir, bs->ideal_viewangles);
ADDRLP4 268
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1981
;1981:			}
ADDRGP4 $854
JUMPV
LABELV $853
line 1982
;1982:			else {
line 1983
;1983:				vectoangles(moveresult.movedir, bs->ideal_viewangles);
ADDRLP4 0+28
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6264
ADDP4
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1984
;1984:			}
LABELV $854
line 1985
;1985:			bs->ideal_viewangles[2] *= 0.5;
ADDRLP4 356
ADDRFP4 0
INDIRP4
CNSTI4 6272
ADDP4
ASGNP4
ADDRLP4 356
INDIRP4
CNSTF4 1056964608
ADDRLP4 356
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1986
;1986:		}
LABELV $852
line 1987
;1987:	}
LABELV $848
LABELV $845
line 1989
;1988:	//if the weapon is used for the bot movement
;1989:	if (moveresult.flags & MOVERESULT_MOVEMENTWEAPON) bs->weaponnum = moveresult.weapon;
ADDRLP4 0+20
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $860
ADDRFP4 0
INDIRP4
CNSTI4 6248
ADDP4
ADDRLP4 0+24
INDIRI4
ASGNI4
LABELV $860
line 1991
;1990:	//attack the enemy if possible
;1991:	BotCheckAttack(bs);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 BotCheckAttack
CALLV
pop
line 1993
;1992:	//
;1993:	return qtrue;
CNSTI4 1
RETI4
LABELV $810
endproc AINode_Battle_NBG 360 20
bss
export nodeswitch
align 1
LABELV nodeswitch
skip 7344
export numnodeswitches
align 4
LABELV numnodeswitches
skip 4
import AIEnter_Seek_Camp
import BotPrintTeamGoal
import BotMatchMessage
import BotChatTest
import BotValidChatPosition
import BotChatTime
import BotChat_Random
import BotChat_EnemySuicide
import BotChat_Kill
import BotChat_Death
import BotChat_HitNoKill
import BotChat_HitNoDeath
import BotChat_HitTalking
import BotChat_EndLevel
import BotChat_StartLevel
import BotChat_ExitGame
import BotChat_EnterGame
import ctf_blueflag
import ctf_redflag
import bot_challenge
import bot_testrchat
import bot_nochat
import bot_fastchat
import bot_rocketjump
import bot_grapple
import maxclients
import gametype
import BotMapScripts
import BotPointAreaNum
import ClientFromName
import stristr
import BotFindWayPoint
import BotCreateWayPoint
import BotCTFRetreatGoals
import BotCTFSeekGoals
import BotCTFCarryingFlag
import BotCTFTeam
import BotAIBlocked
import BotCheckAttack
import BotAimAtEnemy
import BotEntityVisible
import BotRoamGoal
import BotFindEnemy
import BotTeamFlagCarrierVisible
import TeamPlayIsOn
import BotSameTeam
import BotAttackMove
import BotWantsToCamp
import BotCanAndWantsToRocketJump
import BotWantsToHelp
import BotWantsToChase
import BotWantsToRetreat
import BotAggression
import ClientSkin
import EasyClientName
import ClientName
import EntityIsShooting
import EntityIsInvisible
import EntityIsDead
import BotInLavaOrSlime
import BotIntermission
import BotIsObserver
import BotIsDead
import BotBattleUseItems
import BotUpdateBattleInventory
import BotUpdateInventory
import BotSetupForMovement
import BotChooseWeapon
import BotFreeWaypoints
import BotDeathmatchAI
import BotShutdownDeathmatchAI
import BotSetupDeathmatchAI
import BotTeamLeader
import BotAI_GetSnapshotEntity
import BotAI_GetEntityState
import BotAI_GetClientState
import BotAI_Trace
import BotAI_BotInitialChat
import BotAI_Print
import BotEntityInfo
import NumBots
import BotResetState
import BotResetWeaponState
import BotFreeWeaponState
import BotAllocWeaponState
import BotLoadWeaponWeights
import BotGetWeaponInfo
import BotChooseBestFightWeapon
import BotShutdownWeaponAI
import BotSetupWeaponAI
import BotShutdownMoveAI
import BotSetupMoveAI
import BotSetBrushModelTypes
import BotInitMoveState
import BotFreeMoveState
import BotAllocMoveState
import BotPredictVisiblePosition
import BotMovementViewTarget
import BotReachabilityArea
import BotResetLastAvoidReach
import BotResetAvoidReach
import BotMoveInDirection
import BotMoveToGoal
import BotResetMoveState
import BotShutdownGoalAI
import BotSetupGoalAI
import BotFreeGoalState
import BotAllocGoalState
import BotFreeItemWeights
import BotLoadItemWeights
import BotMutateGoalFuzzyLogic
import BotSaveGoalFuzzyLogic
import BotInterbreedGoalFuzzyLogic
import BotUpdateEntityItems
import BotInitLevelItems
import BotAvoidGoalTime
import BotGetMapLocationGoal
import BotGetNextCampSpotGoal
import BotGetLevelItemGoal
import BotItemGoalInVisButNotVisible
import BotTouchingGoal
import BotChooseNBGItem
import BotChooseLTGItem
import BotGetSecondGoal
import BotGetTopGoal
import BotGoalName
import BotDumpGoalStack
import BotDumpAvoidGoals
import BotEmptyGoalStack
import BotPopGoal
import BotPushGoal
import BotRemoveFromAvoidGoals
import BotResetAvoidGoals
import BotResetGoalState
import GeneticParentsAndChildSelection
import BotSetChatName
import BotSetChatGender
import BotLoadChatFile
import BotReplaceSynonyms
import UnifyWhiteSpaces
import BotMatchVariable
import BotFindMatch
import StringContains
import BotGetChatMessage
import BotEnterChat
import BotChatLength
import BotReplyChat
import BotNumInitialChats
import BotInitialChat
import BotNumConsoleMessages
import BotNextConsoleMessage
import BotRemoveConsoleMessage
import BotQueueConsoleMessage
import BotFreeChatState
import BotAllocChatState
import BotShutdownChatAI
import BotSetupChatAI
import BotShutdownCharacters
import Characteristic_String
import Characteristic_BInteger
import Characteristic_Integer
import Characteristic_BFloat
import Characteristic_Float
import BotFreeCharacter
import BotLoadCharacter
import EA_Shutdown
import EA_Setup
import EA_ResetInput
import EA_GetInput
import EA_EndRegular
import EA_View
import EA_Move
import EA_MoveRight
import EA_MoveLeft
import EA_MoveBack
import EA_MoveForward
import EA_MoveDown
import EA_MoveUp
import EA_Walk
import EA_Crouch
import EA_DelayedJump
import EA_Jump
import EA_Use
import EA_Gesture
import EA_Talk
import EA_Respawn
import EA_Attack
import EA_SelectWeapon
import EA_Command
import EA_DropInv
import EA_UseInv
import EA_DropItem
import EA_UseItem
import EA_SayTeam
import EA_Say
import GetBotLibAPI
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $809
byte 1 98
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 32
byte 1 78
byte 1 66
byte 1 71
byte 1 0
align 1
LABELV $745
byte 1 98
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 114
byte 1 101
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $675
byte 1 98
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 32
byte 1 99
byte 1 104
byte 1 97
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $618
byte 1 98
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 32
byte 1 102
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $543
byte 1 115
byte 1 101
byte 1 101
byte 1 107
byte 1 32
byte 1 76
byte 1 84
byte 1 71
byte 1 0
align 1
LABELV $484
byte 1 110
byte 1 111
byte 1 32
byte 1 103
byte 1 111
byte 1 97
byte 1 108
byte 1 0
align 1
LABELV $483
byte 1 115
byte 1 101
byte 1 101
byte 1 107
byte 1 32
byte 1 78
byte 1 66
byte 1 71
byte 1 0
align 1
LABELV $429
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 97
byte 1 116
byte 1 101
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $414
byte 1 114
byte 1 101
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $401
byte 1 115
byte 1 116
byte 1 97
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $396
byte 1 111
byte 1 98
byte 1 115
byte 1 101
byte 1 114
byte 1 118
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $387
byte 1 105
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 109
byte 1 105
byte 1 115
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $356
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $346
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $317
byte 1 99
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 101
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $310
byte 1 112
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 95
byte 1 115
byte 1 116
byte 1 111
byte 1 112
byte 1 0
align 1
LABELV $297
byte 1 112
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $296
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 0
align 1
LABELV $265
byte 1 99
byte 1 97
byte 1 109
byte 1 112
byte 1 95
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 118
byte 1 101
byte 1 0
align 1
LABELV $256
byte 1 99
byte 1 97
byte 1 109
byte 1 112
byte 1 95
byte 1 115
byte 1 116
byte 1 111
byte 1 112
byte 1 0
align 1
LABELV $251
byte 1 99
byte 1 97
byte 1 109
byte 1 112
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $243
byte 1 103
byte 1 101
byte 1 116
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 95
byte 1 103
byte 1 111
byte 1 116
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $240
byte 1 103
byte 1 101
byte 1 116
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 95
byte 1 110
byte 1 111
byte 1 116
byte 1 116
byte 1 104
byte 1 101
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $235
byte 1 103
byte 1 101
byte 1 116
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $228
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 100
byte 1 111
byte 1 110
byte 1 101
byte 1 0
align 1
LABELV $225
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $216
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 95
byte 1 115
byte 1 116
byte 1 111
byte 1 112
byte 1 0
align 1
LABELV $213
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $204
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 95
byte 1 99
byte 1 97
byte 1 110
byte 1 110
byte 1 111
byte 1 116
byte 1 102
byte 1 105
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $174
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 95
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 118
byte 1 101
byte 1 0
align 1
LABELV $152
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 95
byte 1 115
byte 1 116
byte 1 111
byte 1 112
byte 1 0
align 1
LABELV $149
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $123
byte 1 104
byte 1 101
byte 1 108
byte 1 112
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $56
byte 1 37
byte 1 115
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 50
byte 1 46
byte 1 49
byte 1 102
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $54
byte 1 0
align 1
LABELV $49
byte 1 37
byte 1 115
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 49
byte 1 46
byte 1 49
byte 1 102
byte 1 32
byte 1 115
byte 1 119
byte 1 105
byte 1 116
byte 1 99
byte 1 104
byte 1 101
byte 1 100
byte 1 32
byte 1 109
byte 1 111
byte 1 114
byte 1 101
byte 1 32
byte 1 116
byte 1 104
byte 1 97
byte 1 110
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 65
byte 1 73
byte 1 32
byte 1 110
byte 1 111
byte 1 100
byte 1 101
byte 1 115
byte 1 10
byte 1 0
