export BotGetItemTeamGoal
code
proc BotGetItemTeamGoal 12 12
file "..\ai_cmd.c"
line 127
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:/*****************************************************************************
;5: * name:		ai_cmd.c
;6: *
;7: * desc:		Quake3 bot AI
;8: *
;9: * $Archive: /source/code/game/ai_cmd.c $
;10: * $Author: Raduffy $ 
;11: * $Revision: 5 $
;12: * $Modtime: 1/14/00 5:27p $
;13: * $Date: 1/14/00 5:35p $
;14: *
;15: *****************************************************************************/
;16:
;17:#include "g_local.h"
;18:#include "botlib.h"
;19:#include "be_aas.h"
;20:#include "be_ea.h"
;21:#include "be_ai_char.h"
;22:#include "be_ai_chat.h"
;23:#include "be_ai_gen.h"
;24:#include "be_ai_goal.h"
;25:#include "be_ai_move.h"
;26:#include "be_ai_weap.h"
;27://
;28:#include "ai_main.h"
;29:#include "ai_dmq3.h"
;30:#include "ai_chat.h"
;31:#include "ai_cmd.h"
;32:#include "ai_dmnet.h"
;33:#include "ai_team.h"
;34://
;35:#include "chars.h"				//characteristics
;36:#include "inv.h"				//indexes into the inventory
;37:#include "syn.h"				//synonyms
;38:#include "match.h"				//string matching types and vars
;39:
;40:
;41:#ifdef DEBUG
;42:/*
;43:==================
;44:BotPrintTeamGoal
;45:==================
;46:*/
;47:void BotPrintTeamGoal(bot_state_t *bs) {
;48:	char netname[MAX_NETNAME];
;49:	float t;
;50:
;51:	ClientName(bs->client, netname, sizeof(netname));
;52:	t = bs->teamgoal_time - trap_AAS_Time();
;53:	switch(bs->ltgtype) {
;54:		case LTG_TEAMHELP:
;55:		{
;56:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna help a team mate for %1.0f secs\n", netname, t);
;57:			break;
;58:		}
;59:		case LTG_TEAMACCOMPANY:
;60:		{
;61:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna accompany a team mate for %1.0f secs\n", netname, t);
;62:			break;
;63:		}
;64:		case LTG_GETFLAG:
;65:		{
;66:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna get the flag for %1.0f secs\n", netname, t);
;67:			break;
;68:		}
;69:		case LTG_RUSHBASE:
;70:		{
;71:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna rush to the base for %1.0f secs\n", netname, t);
;72:			break;
;73:		}
;74:		case LTG_RETURNFLAG:
;75:		{
;76:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna try to return the flag for %1.0f secs\n", netname, t);
;77:			break;
;78:		}
;79:		case LTG_DEFENDKEYAREA:
;80:		{
;81:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna defend a key area for %1.0f secs\n", netname, t);
;82:			break;
;83:		}
;84:		case LTG_GETITEM:
;85:		{
;86:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna get an item for %1.0f secs\n", netname, t);
;87:			break;
;88:		}
;89:		case LTG_KILL:
;90:		{
;91:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna kill someone for %1.0f secs\n", netname, t);
;92:			break;
;93:		}
;94:		case LTG_CAMP:
;95:		case LTG_CAMPORDER:
;96:		{
;97:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna camp for %1.0f secs\n", netname, t);
;98:			break;
;99:		}
;100:		case LTG_PATROL:
;101:		{
;102:			BotAI_Print(PRT_MESSAGE, "%s: I'm gonna patrol for %1.0f secs\n", netname, t);
;103:			break;
;104:		}
;105:		default:
;106:		{
;107:			if (bs->ctfroam_time > trap_AAS_Time()) {
;108:				t = bs->ctfroam_time - trap_AAS_Time();
;109:				BotAI_Print(PRT_MESSAGE, "%s: I'm gonna roam for %1.0f secs\n", netname, t);
;110:			}
;111:			else {
;112:				BotAI_Print(PRT_MESSAGE, "%s: I've got a regular goal\n", netname);
;113:			}
;114:		}
;115:	}
;116:}
;117:#endif //DEBUG
;118:
;119:/*
;120:==================
;121:BotGetItemTeamGoal
;122:
;123:FIXME: add stuff like "upper rocket launcher"
;124:"the rl near the railgun", "lower grenade launcher" etc.
;125:==================
;126:*/
;127:int BotGetItemTeamGoal(char *goalname, bot_goal_t *goal) {
line 130
;128:	int i;
;129:
;130:	if (!strlen(goalname)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 4
INDIRU4
CNSTU4 0
NEU4 $48
CNSTI4 0
RETI4
ADDRGP4 $47
JUMPV
LABELV $48
line 131
;131:	i = -1;
ADDRLP4 0
CNSTI4 -1
ASGNI4
LABELV $50
line 132
;132:	do {
line 133
;133:		i = trap_BotGetLevelItemGoal(i, goalname, goal);
ADDRLP4 0
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 trap_BotGetLevelItemGoal
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
line 134
;134:		if (i > 0) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $53
line 136
;135:			//do NOT defend dropped items
;136:			if (goal->flags & GFL_DROPPED)
ADDRFP4 4
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $55
line 137
;137:				continue;
ADDRGP4 $51
JUMPV
LABELV $55
line 138
;138:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $47
JUMPV
LABELV $53
line 140
;139:		}
;140:	} while(i > 0);
LABELV $51
ADDRLP4 0
INDIRI4
CNSTI4 0
GTI4 $50
line 141
;141:	return qfalse;
CNSTI4 0
RETI4
LABELV $47
endproc BotGetItemTeamGoal 12 12
export BotGetMessageTeamGoal
proc BotGetMessageTeamGoal 12 12
line 149
;142:}
;143:
;144:/*
;145:==================
;146:BotGetMessageTeamGoal
;147:==================
;148:*/
;149:int BotGetMessageTeamGoal(bot_state_t *bs, char *goalname, bot_goal_t *goal) {
line 152
;150:	bot_waypoint_t *cp;
;151:
;152:	if (BotGetItemTeamGoal(goalname, goal)) return qtrue;
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotGetItemTeamGoal
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $58
CNSTI4 1
RETI4
ADDRGP4 $57
JUMPV
LABELV $58
line 154
;153:
;154:	cp = BotFindWayPoint(bs->checkpoints, goalname);
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 BotFindWayPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 155
;155:	if (cp) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $60
line 156
;156:		memcpy(goal, &cp->goal, sizeof(bot_goal_t));
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 157
;157:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $57
JUMPV
LABELV $60
line 159
;158:	}
;159:	return qfalse;
CNSTI4 0
RETI4
LABELV $57
endproc BotGetMessageTeamGoal 12 12
export BotGetTime
proc BotGetTime 600 16
line 167
;160:}
;161:
;162:/*
;163:==================
;164:BotGetTime
;165:==================
;166:*/
;167:float BotGetTime(bot_match_t *match) {
line 173
;168:	bot_match_t timematch;
;169:	char timestring[MAX_MESSAGE_SIZE];
;170:	float t;
;171:
;172:	//if the matched string has a time
;173:	if (match->subtype & ST_TIME) {
ADDRFP4 0
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $63
line 175
;174:		//get the time string
;175:		trap_BotMatchVariable(match, TIME, timestring, MAX_MESSAGE_SIZE);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 177
;176:		//match it to find out if the time is in seconds or minutes
;177:		if (trap_BotFindMatch(timestring, &timematch, MTCONTEXT_TIME)) {
ADDRLP4 0
ARGP4
ADDRLP4 256
ARGP4
CNSTU4 8
ARGU4
ADDRLP4 588
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 588
INDIRI4
CNSTI4 0
EQI4 $65
line 178
;178:			if (timematch.type == MSG_FOREVER) {
ADDRLP4 256+256
INDIRI4
CNSTI4 107
NEI4 $67
line 179
;179:				t = 99999999;
ADDRLP4 584
CNSTF4 1287568416
ASGNF4
line 180
;180:			}
ADDRGP4 $68
JUMPV
LABELV $67
line 181
;181:			else {
line 182
;182:				trap_BotMatchVariable(&timematch, TIME, timestring, MAX_MESSAGE_SIZE);
ADDRLP4 256
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 183
;183:				if (timematch.type == MSG_MINUTES) t = atof(timestring) * 60;
ADDRLP4 256+256
INDIRI4
CNSTI4 105
NEI4 $70
ADDRLP4 0
ARGP4
ADDRLP4 592
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 584
CNSTF4 1114636288
ADDRLP4 592
INDIRF4
MULF4
ASGNF4
ADDRGP4 $71
JUMPV
LABELV $70
line 184
;184:				else if (timematch.type == MSG_SECONDS) t = atof(timestring);
ADDRLP4 256+256
INDIRI4
CNSTI4 106
NEI4 $73
ADDRLP4 0
ARGP4
ADDRLP4 596
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 584
ADDRLP4 596
INDIRF4
ASGNF4
ADDRGP4 $74
JUMPV
LABELV $73
line 185
;185:				else t = 0;
ADDRLP4 584
CNSTF4 0
ASGNF4
LABELV $74
LABELV $71
line 186
;186:			}
LABELV $68
line 188
;187:			//if there's a valid time
;188:			if (t > 0) return trap_AAS_Time() + t;
ADDRLP4 584
INDIRF4
CNSTF4 0
LEF4 $76
ADDRLP4 592
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 592
INDIRF4
ADDRLP4 584
INDIRF4
ADDF4
RETF4
ADDRGP4 $62
JUMPV
LABELV $76
line 189
;189:		}
LABELV $65
line 190
;190:	}
LABELV $63
line 191
;191:	return 0;
CNSTF4 0
RETF4
LABELV $62
endproc BotGetTime 600 16
bss
align 4
LABELV $79
skip 4
export FindClientByName
code
proc FindClientByName 1040 12
line 199
;192:}
;193:
;194:/*
;195:==================
;196:FindClientByName
;197:==================
;198:*/
;199:int FindClientByName(char *name) {
line 204
;200:	int i;
;201:	char buf[MAX_INFO_STRING];
;202:	static int maxclients;
;203:
;204:	if (!maxclients)
ADDRGP4 $79
INDIRI4
CNSTI4 0
NEI4 $80
line 205
;205:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $82
ARGP4
ADDRLP4 1028
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $79
ADDRLP4 1028
INDIRI4
ASGNI4
LABELV $80
line 206
;206:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $86
JUMPV
LABELV $83
line 207
;207:		ClientName(i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 208
;208:		if (!Q_stricmp(buf, name)) return i;
ADDRLP4 4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1032
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 0
NEI4 $87
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $78
JUMPV
LABELV $87
line 209
;209:	}
LABELV $84
line 206
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $86
ADDRLP4 0
INDIRI4
ADDRGP4 $79
INDIRI4
GEI4 $89
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $83
LABELV $89
line 210
;210:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $93
JUMPV
LABELV $90
line 211
;211:		ClientName(i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 212
;212:		if (stristr(buf, name)) return i;
ADDRLP4 4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1036
ADDRGP4 stristr
CALLP4
ASGNP4
ADDRLP4 1036
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $94
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $78
JUMPV
LABELV $94
line 213
;213:	}
LABELV $91
line 210
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $93
ADDRLP4 0
INDIRI4
ADDRGP4 $79
INDIRI4
GEI4 $96
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $90
LABELV $96
line 214
;214:	return -1;
CNSTI4 -1
RETI4
LABELV $78
endproc FindClientByName 1040 12
bss
align 4
LABELV $98
skip 4
export FindEnemyByName
code
proc FindEnemyByName 1044 12
line 222
;215:}
;216:
;217:/*
;218:==================
;219:FindEnemyByName
;220:==================
;221:*/
;222:int FindEnemyByName(bot_state_t *bs, char *name) {
line 227
;223:	int i;
;224:	char buf[MAX_INFO_STRING];
;225:	static int maxclients;
;226:
;227:	if (!maxclients)
ADDRGP4 $98
INDIRI4
CNSTI4 0
NEI4 $99
line 228
;228:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $82
ARGP4
ADDRLP4 1028
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $98
ADDRLP4 1028
INDIRI4
ASGNI4
LABELV $99
line 229
;229:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $104
JUMPV
LABELV $101
line 230
;230:		if (BotSameTeam(bs, i)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1032
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CNSTI4 0
EQI4 $105
ADDRGP4 $102
JUMPV
LABELV $105
line 231
;231:		ClientName(i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 232
;232:		if (!Q_stricmp(buf, name)) return i;
ADDRLP4 4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1036
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1036
INDIRI4
CNSTI4 0
NEI4 $107
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $97
JUMPV
LABELV $107
line 233
;233:	}
LABELV $102
line 229
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $104
ADDRLP4 0
INDIRI4
ADDRGP4 $98
INDIRI4
GEI4 $109
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $101
LABELV $109
line 234
;234:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $113
JUMPV
LABELV $110
line 235
;235:		if (BotSameTeam(bs, i)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1036
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1036
INDIRI4
CNSTI4 0
EQI4 $114
ADDRGP4 $111
JUMPV
LABELV $114
line 236
;236:		ClientName(i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 237
;237:		if (stristr(buf, name)) return i;
ADDRLP4 4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1040
ADDRGP4 stristr
CALLP4
ASGNP4
ADDRLP4 1040
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $116
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $97
JUMPV
LABELV $116
line 238
;238:	}
LABELV $111
line 234
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $113
ADDRLP4 0
INDIRI4
ADDRGP4 $98
INDIRI4
GEI4 $118
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $110
LABELV $118
line 239
;239:	return -1;
CNSTI4 -1
RETI4
LABELV $97
endproc FindEnemyByName 1044 12
bss
align 4
LABELV $120
skip 4
export NumPlayersOnSameTeam
code
proc NumPlayersOnSameTeam 1044 12
line 247
;240:}
;241:
;242:/*
;243:==================
;244:NumPlayersOnSameTeam
;245:==================
;246:*/
;247:int NumPlayersOnSameTeam(bot_state_t *bs) {
line 252
;248:	int i, num;
;249:	char buf[MAX_INFO_STRING];
;250:	static int maxclients;
;251:
;252:	if (!maxclients)
ADDRGP4 $120
INDIRI4
CNSTI4 0
NEI4 $121
line 253
;253:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $82
ARGP4
ADDRLP4 1032
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $120
ADDRLP4 1032
INDIRI4
ASGNI4
LABELV $121
line 255
;254:
;255:	num = 0;
ADDRLP4 1028
CNSTI4 0
ASGNI4
line 256
;256:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $126
JUMPV
LABELV $123
line 257
;257:		trap_GetConfigstring(CS_PLAYERS+i, buf, MAX_INFO_STRING);
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 258
;258:		if (strlen(buf)) {
ADDRLP4 4
ARGP4
ADDRLP4 1036
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1036
INDIRU4
CNSTU4 0
EQU4 $127
line 259
;259:			if (BotSameTeam(bs, i+1)) num++;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 1040
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1040
INDIRI4
CNSTI4 0
EQI4 $129
ADDRLP4 1028
ADDRLP4 1028
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $129
line 260
;260:		}
LABELV $127
line 261
;261:	}
LABELV $124
line 256
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $126
ADDRLP4 0
INDIRI4
ADDRGP4 $120
INDIRI4
GEI4 $131
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $123
LABELV $131
line 262
;262:	return num;
ADDRLP4 1028
INDIRI4
RETI4
LABELV $119
endproc NumPlayersOnSameTeam 1044 12
export BotGetPatrolWaypoints
proc BotGetPatrolWaypoints 676 16
line 270
;263:}
;264:
;265:/*
;266:==================
;267:TeamPlayIsOn
;268:==================
;269:*/
;270:int BotGetPatrolWaypoints(bot_state_t *bs, bot_match_t *match) {
line 277
;271:	char keyarea[MAX_MESSAGE_SIZE];
;272:	int patrolflags;
;273:	bot_waypoint_t *wp, *newwp, *newpatrolpoints;
;274:	bot_match_t keyareamatch;
;275:	bot_goal_t goal;
;276:
;277:	newpatrolpoints = NULL;
ADDRLP4 592
CNSTP4 0
ASGNP4
line 278
;278:	patrolflags = 0;
ADDRLP4 652
CNSTI4 0
ASGNI4
line 280
;279:	//
;280:	trap_BotMatchVariable(match, KEYAREA, keyarea, MAX_MESSAGE_SIZE);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
ADDRGP4 $134
JUMPV
LABELV $133
line 282
;281:	//
;282:	while(1) {
line 283
;283:		if (!trap_BotFindMatch(keyarea, &keyareamatch, MTCONTEXT_PATROLKEYAREA)) {
ADDRLP4 4
ARGP4
ADDRLP4 264
ARGP4
CNSTU4 64
ARGU4
ADDRLP4 656
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 656
INDIRI4
CNSTI4 0
NEI4 $136
line 284
;284:			trap_EA_SayTeam(bs->client, "what do you say?");
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $138
ARGP4
ADDRGP4 trap_EA_SayTeam
CALLV
pop
line 285
;285:			BotFreeWaypoints(newpatrolpoints);
ADDRLP4 592
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 286
;286:			bs->patrolpoints = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 6712
ADDP4
CNSTP4 0
ASGNP4
line 287
;287:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $132
JUMPV
LABELV $136
line 289
;288:		}
;289:		trap_BotMatchVariable(&keyareamatch, KEYAREA, keyarea, MAX_MESSAGE_SIZE);
ADDRLP4 264
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 290
;290:		if (!BotGetMessageTeamGoal(bs, keyarea, &goal)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 596
ARGP4
ADDRLP4 660
ADDRGP4 BotGetMessageTeamGoal
CALLI4
ASGNI4
ADDRLP4 660
INDIRI4
CNSTI4 0
NEI4 $139
line 293
;291:			//BotAI_BotInitialChat(bs, "cannotfind", keyarea, NULL);
;292:			//trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
;293:			BotFreeWaypoints(newpatrolpoints);
ADDRLP4 592
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 294
;294:			bs->patrolpoints = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 6712
ADDP4
CNSTP4 0
ASGNP4
line 295
;295:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $132
JUMPV
LABELV $139
line 298
;296:		}
;297:		//create a new waypoint
;298:		newwp = BotCreateWayPoint(keyarea, goal.origin, goal.areanum);
ADDRLP4 4
ARGP4
ADDRLP4 596
ARGP4
ADDRLP4 596+12
INDIRI4
ARGI4
ADDRLP4 664
ADDRGP4 BotCreateWayPoint
CALLP4
ASGNP4
ADDRLP4 260
ADDRLP4 664
INDIRP4
ASGNP4
line 300
;299:		//add the waypoint to the patrol points
;300:		newwp->next = NULL;
ADDRLP4 260
INDIRP4
CNSTI4 92
ADDP4
CNSTP4 0
ASGNP4
line 301
;301:		for (wp = newpatrolpoints; wp && wp->next; wp = wp->next);
ADDRLP4 0
ADDRLP4 592
INDIRP4
ASGNP4
ADDRGP4 $145
JUMPV
LABELV $142
LABELV $143
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
LABELV $145
ADDRLP4 672
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 672
INDIRU4
EQU4 $146
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 672
INDIRU4
NEU4 $142
LABELV $146
line 302
;302:		if (!wp) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $147
line 303
;303:			newpatrolpoints = newwp;
ADDRLP4 592
ADDRLP4 260
INDIRP4
ASGNP4
line 304
;304:			newwp->prev = NULL;
ADDRLP4 260
INDIRP4
CNSTI4 96
ADDP4
CNSTP4 0
ASGNP4
line 305
;305:		}
ADDRGP4 $148
JUMPV
LABELV $147
line 306
;306:		else {
line 307
;307:			wp->next = newwp;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 260
INDIRP4
ASGNP4
line 308
;308:			newwp->prev = wp;
ADDRLP4 260
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 309
;309:		}
LABELV $148
line 311
;310:		//
;311:		if (keyareamatch.subtype & ST_BACK) {
ADDRLP4 264+260
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $149
line 312
;312:			patrolflags = PATROL_LOOP;
ADDRLP4 652
CNSTI4 1
ASGNI4
line 313
;313:			break;
ADDRGP4 $135
JUMPV
LABELV $149
line 315
;314:		}
;315:		else if (keyareamatch.subtype & ST_REVERSE) {
ADDRLP4 264+260
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
EQI4 $152
line 316
;316:			patrolflags = PATROL_REVERSE;
ADDRLP4 652
CNSTI4 2
ASGNI4
line 317
;317:			break;
ADDRGP4 $135
JUMPV
LABELV $152
line 319
;318:		}
;319:		else if (keyareamatch.subtype & ST_MORE) {
ADDRLP4 264+260
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $135
line 320
;320:			trap_BotMatchVariable(&keyareamatch, MORE, keyarea, MAX_MESSAGE_SIZE);
ADDRLP4 264
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 321
;321:		}
line 322
;322:		else {
line 323
;323:			break;
LABELV $156
line 325
;324:		}
;325:	}
LABELV $134
line 282
ADDRGP4 $133
JUMPV
LABELV $135
line 327
;326:	//
;327:	if (!newpatrolpoints || !newpatrolpoints->next) {
ADDRLP4 660
CNSTU4 0
ASGNU4
ADDRLP4 592
INDIRP4
CVPU4 4
ADDRLP4 660
INDIRU4
EQU4 $160
ADDRLP4 592
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 660
INDIRU4
NEU4 $158
LABELV $160
line 328
;328:		trap_EA_SayTeam(bs->client, "I need more key points to patrol\n");
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $161
ARGP4
ADDRGP4 trap_EA_SayTeam
CALLV
pop
line 329
;329:		BotFreeWaypoints(newpatrolpoints);
ADDRLP4 592
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 330
;330:		newpatrolpoints = NULL;
ADDRLP4 592
CNSTP4 0
ASGNP4
line 331
;331:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $132
JUMPV
LABELV $158
line 334
;332:	}
;333:	//
;334:	BotFreeWaypoints(bs->patrolpoints);
ADDRFP4 0
INDIRP4
CNSTI4 6712
ADDP4
INDIRP4
ARGP4
ADDRGP4 BotFreeWaypoints
CALLV
pop
line 335
;335:	bs->patrolpoints = newpatrolpoints;
ADDRFP4 0
INDIRP4
CNSTI4 6712
ADDP4
ADDRLP4 592
INDIRP4
ASGNP4
line 337
;336:	//
;337:	bs->curpatrolpoint = bs->patrolpoints;
ADDRLP4 664
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 664
INDIRP4
CNSTI4 6716
ADDP4
ADDRLP4 664
INDIRP4
CNSTI4 6712
ADDP4
INDIRP4
ASGNP4
line 338
;338:	bs->patrolflags = patrolflags;
ADDRFP4 0
INDIRP4
CNSTI4 6720
ADDP4
ADDRLP4 652
INDIRI4
ASGNI4
line 340
;339:	//
;340:	return qtrue;
CNSTI4 1
RETI4
LABELV $132
endproc BotGetPatrolWaypoints 676 16
export BotAddressedToBot
proc BotAddressedToBot 1248 16
line 348
;341:}
;342:
;343:/*
;344:==================
;345:BotAddressedToBot
;346:==================
;347:*/
;348:int BotAddressedToBot(bot_state_t *bs, bot_match_t *match) {
line 356
;349:	char addressedto[MAX_MESSAGE_SIZE];
;350:	char netname[MAX_MESSAGE_SIZE];
;351:	char name[MAX_MESSAGE_SIZE];
;352:	char botname[128];
;353:	int client;
;354:	bot_match_t addresseematch;
;355:
;356:	trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 840
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 357
;357:	client = ClientFromName(netname);
ADDRLP4 840
ARGP4
ADDRLP4 1228
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRLP4 1096
ADDRLP4 1228
INDIRI4
ASGNI4
line 358
;358:	if (client < 0) return qfalse;
ADDRLP4 1096
INDIRI4
CNSTI4 0
GEI4 $163
CNSTI4 0
RETI4
ADDRGP4 $162
JUMPV
LABELV $163
line 359
;359:	if (!BotSameTeam(bs, client)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1096
INDIRI4
ARGI4
ADDRLP4 1232
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1232
INDIRI4
CNSTI4 0
NEI4 $165
CNSTI4 0
RETI4
ADDRGP4 $162
JUMPV
LABELV $165
line 361
;360:	//if the message is addressed to someone
;361:	if (match->subtype & ST_ADDRESSED) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $167
line 362
;362:		trap_BotMatchVariable(match, ADDRESSEE, addressedto, sizeof(addressedto));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRLP4 584
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 364
;363:		//the name of this bot
;364:		ClientName(bs->client, botname, 128);
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 1100
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 ClientName
CALLP4
pop
ADDRGP4 $170
JUMPV
LABELV $169
line 366
;365:		//
;366:		while(trap_BotFindMatch(addressedto, &addresseematch, MTCONTEXT_ADDRESSEE)) {
line 367
;367:			if (addresseematch.type == MSG_EVERYONE) {
ADDRLP4 0+256
INDIRI4
CNSTI4 101
NEI4 $172
line 368
;368:				return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $162
JUMPV
LABELV $172
line 370
;369:			}
;370:			else if (addresseematch.type == MSG_MULTIPLENAMES) {
ADDRLP4 0+256
INDIRI4
CNSTI4 102
NEI4 $175
line 371
;371:				trap_BotMatchVariable(&addresseematch, TEAMMATE, name, sizeof(name));
ADDRLP4 0
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 328
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 372
;372:				if (strlen(name)) {
ADDRLP4 328
ARGP4
ADDRLP4 1236
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1236
INDIRU4
CNSTU4 0
EQU4 $178
line 373
;373:					if (stristr(botname, name)) return qtrue;
ADDRLP4 1100
ARGP4
ADDRLP4 328
ARGP4
ADDRLP4 1240
ADDRGP4 stristr
CALLP4
ASGNP4
ADDRLP4 1240
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $180
CNSTI4 1
RETI4
ADDRGP4 $162
JUMPV
LABELV $180
line 374
;374:					if (stristr(bs->subteam, name)) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
ADDRLP4 328
ARGP4
ADDRLP4 1244
ADDRGP4 stristr
CALLP4
ASGNP4
ADDRLP4 1244
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $182
CNSTI4 1
RETI4
ADDRGP4 $162
JUMPV
LABELV $182
line 375
;375:				}
LABELV $178
line 376
;376:				trap_BotMatchVariable(&addresseematch, MORE, addressedto, MAX_MESSAGE_SIZE);
ADDRLP4 0
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 584
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 377
;377:			}
ADDRGP4 $176
JUMPV
LABELV $175
line 378
;378:			else {
line 379
;379:				trap_BotMatchVariable(&addresseematch, TEAMMATE, name, MAX_MESSAGE_SIZE);
ADDRLP4 0
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 328
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 380
;380:				if (strlen(name)) {
ADDRLP4 328
ARGP4
ADDRLP4 1236
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1236
INDIRU4
CNSTU4 0
EQU4 $171
line 381
;381:					if (stristr(botname, name)) return qtrue;
ADDRLP4 1100
ARGP4
ADDRLP4 328
ARGP4
ADDRLP4 1240
ADDRGP4 stristr
CALLP4
ASGNP4
ADDRLP4 1240
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $186
CNSTI4 1
RETI4
ADDRGP4 $162
JUMPV
LABELV $186
line 382
;382:					if (stristr(bs->subteam, name)) return qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
ADDRLP4 328
ARGP4
ADDRLP4 1244
ADDRGP4 stristr
CALLP4
ASGNP4
ADDRLP4 1244
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $171
CNSTI4 1
RETI4
ADDRGP4 $162
JUMPV
line 383
;383:				}
line 384
;384:				break;
LABELV $176
line 386
;385:			}
;386:		}
LABELV $170
line 366
ADDRLP4 584
ARGP4
ADDRLP4 0
ARGP4
CNSTU4 32
ARGU4
ADDRLP4 1236
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 1236
INDIRI4
CNSTI4 0
NEI4 $169
LABELV $171
line 389
;387:		//Com_sprintf(buf, sizeof(buf), "not addressed to me but %s", addressedto);
;388:		//trap_EA_Say(bs->client, buf);
;389:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $162
JUMPV
LABELV $167
line 391
;390:	}
;391:	else {
line 393
;392:		//make sure not everyone reacts to this message
;393:		if (random() > (float ) 1.0 / (NumPlayersOnSameTeam(bs)-1)) return qfalse;
ADDRLP4 1236
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 1240
ADDRGP4 NumPlayersOnSameTeam
CALLI4
ASGNI4
ADDRLP4 1236
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1065353216
ADDRLP4 1240
INDIRI4
CNSTI4 1
SUBI4
CVIF4 4
DIVF4
LEF4 $190
CNSTI4 0
RETI4
ADDRGP4 $162
JUMPV
LABELV $190
line 394
;394:	}
line 395
;395:	return qtrue;
CNSTI4 1
RETI4
LABELV $162
endproc BotAddressedToBot 1248 16
export BotGPSToPosition
proc BotGPSToPosition 20 12
line 403
;396:}
;397:
;398:/*
;399:==================
;400:BotGPSToPosition
;401:==================
;402:*/
;403:int BotGPSToPosition(char *buf, vec3_t position) {
line 404
;404:	int i, j = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 407
;405:	int num, sign;
;406:
;407:	for (i = 0; i < 3; i++) {
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $193
line 408
;408:		num = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $198
JUMPV
LABELV $197
line 409
;409:		while(buf[j] == ' ') j++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $198
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
CNSTI4 32
EQI4 $197
line 410
;410:		if (buf[j] == '-') {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
CNSTI4 45
NEI4 $200
line 411
;411:			j++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 412
;412:			sign = -1;
ADDRLP4 12
CNSTI4 -1
ASGNI4
line 413
;413:		}
ADDRGP4 $203
JUMPV
LABELV $200
line 414
;414:		else {
line 415
;415:			sign = 1;
ADDRLP4 12
CNSTI4 1
ASGNI4
line 416
;416:		}
ADDRGP4 $203
JUMPV
LABELV $202
line 417
;417:		while (buf[j]) {
line 418
;418:			if (buf[j] >= '0' && buf[j] <= '9') {
ADDRLP4 16
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 48
LTI4 $205
ADDRLP4 16
INDIRI4
CNSTI4 57
GTI4 $205
line 419
;419:				num = num * 10 + buf[j] - '0';
ADDRLP4 4
CNSTI4 10
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ADDI4
CNSTI4 48
SUBI4
ASGNI4
line 420
;420:				j++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 421
;421:			}
ADDRGP4 $206
JUMPV
LABELV $205
line 422
;422:			else {
line 423
;423:				j++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 424
;424:				break;
ADDRGP4 $204
JUMPV
LABELV $206
line 426
;425:			}
;426:		}
LABELV $203
line 417
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $202
LABELV $204
line 427
;427:		BotAI_Print(PRT_MESSAGE, "%d\n", sign * num);
CNSTI4 1
ARGI4
ADDRGP4 $207
ARGP4
ADDRLP4 12
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ARGI4
ADDRGP4 BotAI_Print
CALLV
pop
line 428
;428:		position[i] = (float) sign * num;
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ADDRLP4 12
INDIRI4
CVIF4 4
ADDRLP4 4
INDIRI4
CVIF4 4
MULF4
ASGNF4
line 429
;429:	}
LABELV $194
line 407
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 3
LTI4 $193
line 430
;430:	return qtrue;
CNSTI4 1
RETI4
LABELV $192
endproc BotGPSToPosition 20 12
export BotMatch_HelpAccompany
proc BotMatch_HelpAccompany 1280 16
line 438
;431:}
;432:
;433:/*
;434:==================
;435:BotMatch_HelpAccompany
;436:==================
;437:*/
;438:void BotMatch_HelpAccompany(bot_state_t *bs, bot_match_t *match) {
line 445
;439:	int client, other, areanum;
;440:	char teammate[MAX_MESSAGE_SIZE], netname[MAX_MESSAGE_SIZE];
;441:	char itemname[MAX_MESSAGE_SIZE];
;442:	bot_match_t teammatematch;
;443:	aas_entityinfo_t entinfo;
;444:
;445:	if (!TeamPlayIsOn()) return;
ADDRLP4 1248
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 1248
INDIRI4
CNSTI4 0
NEI4 $209
ADDRGP4 $208
JUMPV
LABELV $209
line 447
;446:	//if not addressed to this bot
;447:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1252
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 1252
INDIRI4
CNSTI4 0
NEI4 $211
ADDRGP4 $208
JUMPV
LABELV $211
line 449
;448:	//get the team mate name
;449:	trap_BotMatchVariable(match, TEAMMATE, teammate, sizeof(teammate));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 451
;450:	//get the client to help
;451:	if (trap_BotFindMatch(teammate, &teammatematch, MTCONTEXT_TEAMMATE) &&
ADDRLP4 4
ARGP4
ADDRLP4 656
ARGP4
CNSTU4 16
ARGU4
ADDRLP4 1256
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 1256
INDIRI4
CNSTI4 0
EQI4 $213
ADDRLP4 656+256
INDIRI4
CNSTI4 100
NEI4 $213
line 453
;452:			//if someone asks for him or herself
;453:			teammatematch.type == MSG_ME) {
line 455
;454:		//get the netname
;455:		trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 400
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 456
;456:		client = ClientFromName(netname);
ADDRLP4 400
ARGP4
ADDRLP4 1260
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 1260
INDIRI4
ASGNI4
line 457
;457:		other = qfalse;
ADDRLP4 984
CNSTI4 0
ASGNI4
line 458
;458:	}
ADDRGP4 $214
JUMPV
LABELV $213
line 459
;459:	else {
line 461
;460:		//asked for someone else
;461:		client = FindClientByName(teammate);
ADDRLP4 4
ARGP4
ADDRLP4 1260
ADDRGP4 FindClientByName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 1260
INDIRI4
ASGNI4
line 463
;462:		//if this is the bot self
;463:		if (client == bs->client) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $216
line 464
;464:			other = qfalse;
ADDRLP4 984
CNSTI4 0
ASGNI4
line 465
;465:		}
ADDRGP4 $217
JUMPV
LABELV $216
line 466
;466:		else if (!BotSameTeam(bs, client)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1264
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1264
INDIRI4
CNSTI4 0
NEI4 $218
line 468
;467:			//FIXME: say "I don't help the enemy"
;468:			return;
ADDRGP4 $208
JUMPV
LABELV $218
line 470
;469:		}
;470:		else {
line 471
;471:			other = qtrue;
ADDRLP4 984
CNSTI4 1
ASGNI4
line 472
;472:		}
LABELV $217
line 473
;473:	}
LABELV $214
line 475
;474:	//if the bot doesn't know who to help (FindClientByName returned -1)
;475:	if (client < 0) {
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $220
line 476
;476:		if (other) BotAI_BotInitialChat(bs, "whois", teammate, NULL);
ADDRLP4 984
INDIRI4
CNSTI4 0
EQI4 $222
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $224
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $223
JUMPV
LABELV $222
line 477
;477:		else BotAI_BotInitialChat(bs, "whois", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $224
ARGP4
ADDRLP4 400
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
LABELV $223
line 478
;478:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 1260
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1260
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 1260
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 479
;479:		return;
ADDRGP4 $208
JUMPV
LABELV $220
line 482
;480:	}
;481:	//don't help or accompany yourself
;482:	if (client == bs->client) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $225
line 483
;483:		return;
ADDRGP4 $208
JUMPV
LABELV $225
line 486
;484:	}
;485:	//
;486:	bs->teamgoal.entitynum = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
CNSTI4 -1
ASGNI4
line 487
;487:	BotEntityInfo(client, &entinfo);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 260
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 489
;488:	//if info is valid (in PVS)
;489:	if (entinfo.valid) {
ADDRLP4 260
INDIRI4
CNSTI4 0
EQI4 $227
line 490
;490:		areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 260+24
ARGP4
ADDRLP4 1260
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 988
ADDRLP4 1260
INDIRI4
ASGNI4
line 491
;491:		if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 1264
ADDRLP4 988
INDIRI4
ASGNI4
ADDRLP4 1264
INDIRI4
CNSTI4 0
EQI4 $230
ADDRLP4 1264
INDIRI4
ARGI4
ADDRLP4 1268
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 1268
INDIRI4
CNSTI4 0
EQI4 $230
line 492
;492:			bs->teamgoal.entitynum = client;
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 493
;493:			bs->teamgoal.areanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6308
ADDP4
ADDRLP4 988
INDIRI4
ASGNI4
line 494
;494:			VectorCopy(entinfo.origin, bs->teamgoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ADDRLP4 260+24
INDIRB
ASGNB 12
line 495
;495:			VectorSet(bs->teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6312
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6316
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6320
ADDP4
CNSTF4 3238002688
ASGNF4
line 496
;496:			VectorSet(bs->teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6324
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6328
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6332
ADDP4
CNSTF4 1090519040
ASGNF4
line 497
;497:		}
LABELV $230
line 498
;498:	}
LABELV $227
line 500
;499:	//if no teamgoal yet
;500:	if (bs->teamgoal.entitynum < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
CNSTI4 0
GEI4 $233
line 502
;501:		//if near an item
;502:		if (match->subtype & ST_NEARITEM) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $235
line 504
;503:			//get the match variable
;504:			trap_BotMatchVariable(match, ITEM, itemname, sizeof(itemname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 992
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 506
;505:			//
;506:			if (!BotGetMessageTeamGoal(bs, itemname, &bs->teamgoal)) {
ADDRLP4 1260
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1260
INDIRP4
ARGP4
ADDRLP4 992
ARGP4
ADDRLP4 1260
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRLP4 1264
ADDRGP4 BotGetMessageTeamGoal
CALLI4
ASGNI4
ADDRLP4 1264
INDIRI4
CNSTI4 0
NEI4 $237
line 509
;507:				//BotAI_BotInitialChat(bs, "cannotfind", itemname, NULL);
;508:				//trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
;509:				return;
ADDRGP4 $208
JUMPV
LABELV $237
line 511
;510:			}
;511:		}
LABELV $235
line 512
;512:	}
LABELV $233
line 514
;513:	//
;514:	if (bs->teamgoal.entitynum < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
CNSTI4 0
GEI4 $239
line 515
;515:		if (other) BotAI_BotInitialChat(bs, "whereis", teammate, NULL);
ADDRLP4 984
INDIRI4
CNSTI4 0
EQI4 $241
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $243
ARGP4
ADDRLP4 4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $242
JUMPV
LABELV $241
line 516
;516:		else BotAI_BotInitialChat(bs, "whereareyou", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $244
ARGP4
ADDRLP4 400
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
LABELV $242
line 517
;517:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 1260
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1260
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 1260
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 518
;518:		return;
ADDRGP4 $208
JUMPV
LABELV $239
line 521
;519:	}
;520:	//the team mate
;521:	bs->teammate = client;
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 523
;522:	//last time the team mate was assumed visible
;523:	bs->teammatevisible_time = trap_AAS_Time();
ADDRLP4 1260
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6360
ADDP4
ADDRLP4 1260
INDIRF4
ASGNF4
line 525
;524:	//set the time to send a message to the team mates
;525:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 1264
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 1268
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 1264
INDIRF4
CNSTF4 1073741824
ADDRLP4 1268
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 527
;526:	//get the team goal time
;527:	bs->teamgoal_time = BotGetTime(match);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1272
ADDRGP4 BotGetTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 1272
INDIRF4
ASGNF4
line 529
;528:	//set the ltg type
;529:	if (match->type == MSG_HELP) {
ADDRFP4 4
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 3
NEI4 $245
line 530
;530:		bs->ltgtype = LTG_TEAMHELP;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 1
ASGNI4
line 531
;531:		if (!bs->teamgoal_time) bs->teamgoal_time = trap_AAS_Time() + TEAM_HELP_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
CNSTF4 0
NEF4 $246
ADDRLP4 1276
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 1276
INDIRF4
CNSTF4 1114636288
ADDF4
ASGNF4
line 532
;532:	}
ADDRGP4 $246
JUMPV
LABELV $245
line 533
;533:	else {
line 534
;534:		bs->ltgtype = LTG_TEAMACCOMPANY;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 2
ASGNI4
line 535
;535:		if (!bs->teamgoal_time) bs->teamgoal_time = trap_AAS_Time() + TEAM_ACCOMPANY_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
CNSTF4 0
NEF4 $249
ADDRLP4 1276
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 1276
INDIRF4
CNSTF4 1142292480
ADDF4
ASGNF4
LABELV $249
line 536
;536:		bs->formation_dist = 3.5 * 32;		//3.5 meter
ADDRFP4 0
INDIRP4
CNSTI4 6548
ADDP4
CNSTF4 1121976320
ASGNF4
line 537
;537:		bs->arrive_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
CNSTF4 0
ASGNF4
line 538
;538:	}
LABELV $246
line 542
;539:#ifdef DEBUG
;540:	BotPrintTeamGoal(bs);
;541:#endif //DEBUG
;542:}
LABELV $208
endproc BotMatch_HelpAccompany 1280 16
export BotMatch_DefendKeyArea
proc BotMatch_DefendKeyArea 288 16
line 549
;543:
;544:/*
;545:==================
;546:BotMatch_DefendKeyArea
;547:==================
;548:*/
;549:void BotMatch_DefendKeyArea(bot_state_t *bs, bot_match_t *match) {
line 552
;550:	char itemname[MAX_MESSAGE_SIZE];
;551:
;552:	if (!TeamPlayIsOn()) return;
ADDRLP4 256
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 256
INDIRI4
CNSTI4 0
NEI4 $252
ADDRGP4 $251
JUMPV
LABELV $252
line 554
;553:	//if not addressed to this bot
;554:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 260
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $254
ADDRGP4 $251
JUMPV
LABELV $254
line 556
;555:	//get the match variable
;556:	trap_BotMatchVariable(match, KEYAREA, itemname, sizeof(itemname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 558
;557:	//
;558:	if (!BotGetMessageTeamGoal(bs, itemname, &bs->teamgoal)) {
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 264
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 264
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRLP4 268
ADDRGP4 BotGetMessageTeamGoal
CALLI4
ASGNI4
ADDRLP4 268
INDIRI4
CNSTI4 0
NEI4 $256
line 561
;559:		//BotAI_BotInitialChat(bs, "cannotfind", itemname, NULL);
;560:		//trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
;561:		return;
ADDRGP4 $251
JUMPV
LABELV $256
line 564
;562:	}
;563:	//set the time to send a message to the team mates
;564:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 272
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 276
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 272
INDIRF4
CNSTF4 1073741824
ADDRLP4 276
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 566
;565:	//set the ltg type
;566:	bs->ltgtype = LTG_DEFENDKEYAREA;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 3
ASGNI4
line 568
;567:	//get the team goal time
;568:	bs->teamgoal_time = BotGetTime(match);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 280
ADDRGP4 BotGetTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 280
INDIRF4
ASGNF4
line 570
;569:	//set the team goal time
;570:	if (!bs->teamgoal_time) bs->teamgoal_time = trap_AAS_Time() + TEAM_DEFENDKEYAREA_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
CNSTF4 0
NEF4 $258
ADDRLP4 284
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 284
INDIRF4
CNSTF4 1133903872
ADDF4
ASGNF4
LABELV $258
line 572
;571:	//away from defending
;572:	bs->defendaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6116
ADDP4
CNSTF4 0
ASGNF4
line 576
;573:#ifdef DEBUG
;574:	BotPrintTeamGoal(bs);
;575:#endif //DEBUG
;576:}
LABELV $251
endproc BotMatch_DefendKeyArea 288 16
export BotMatch_GetItem
proc BotMatch_GetItem 284 16
line 583
;577:
;578:/*
;579:==================
;580:BotMatch_GetItem
;581:==================
;582:*/
;583:void BotMatch_GetItem(bot_state_t *bs, bot_match_t *match) {
line 586
;584:	char itemname[MAX_MESSAGE_SIZE];
;585:
;586:	if (!TeamPlayIsOn()) return;
ADDRLP4 256
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 256
INDIRI4
CNSTI4 0
NEI4 $261
ADDRGP4 $260
JUMPV
LABELV $261
line 588
;587:	//if not addressed to this bot
;588:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 260
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $263
ADDRGP4 $260
JUMPV
LABELV $263
line 590
;589:	//get the match variable
;590:	trap_BotMatchVariable(match, ITEM, itemname, sizeof(itemname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 592
;591:	//
;592:	if (!BotGetMessageTeamGoal(bs, itemname, &bs->teamgoal)) {
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 264
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 264
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRLP4 268
ADDRGP4 BotGetMessageTeamGoal
CALLI4
ASGNI4
ADDRLP4 268
INDIRI4
CNSTI4 0
NEI4 $265
line 595
;593:		//BotAI_BotInitialChat(bs, "cannotfind", itemname, NULL);
;594:		//trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
;595:		return;
ADDRGP4 $260
JUMPV
LABELV $265
line 598
;596:	}
;597:	//set the time to send a message to the team mates
;598:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 272
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 276
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 272
INDIRF4
CNSTF4 1073741824
ADDRLP4 276
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 600
;599:	//set the ltg type
;600:	bs->ltgtype = LTG_GETITEM;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 10
ASGNI4
line 602
;601:	//set the team goal time
;602:	bs->teamgoal_time = trap_AAS_Time() + TEAM_GETITEM_TIME;
ADDRLP4 280
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 280
INDIRF4
CNSTF4 1114636288
ADDF4
ASGNF4
line 606
;603:#ifdef DEBUG
;604:	BotPrintTeamGoal(bs);
;605:#endif //DEBUG
;606:}
LABELV $260
endproc BotMatch_GetItem 284 16
export BotMatch_Camp
proc BotMatch_Camp 696 16
line 613
;607:
;608:/*
;609:==================
;610:BotMatch_Camp
;611:==================
;612:*/
;613:void BotMatch_Camp(bot_state_t *bs, bot_match_t *match) {
line 619
;614:	int client, areanum;
;615:	char netname[MAX_MESSAGE_SIZE];
;616:	char itemname[MAX_MESSAGE_SIZE];
;617:	aas_entityinfo_t entinfo;
;618:
;619:	if (!TeamPlayIsOn()) return;
ADDRLP4 660
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 660
INDIRI4
CNSTI4 0
NEI4 $268
ADDRGP4 $267
JUMPV
LABELV $268
line 621
;620:	//if not addressed to this bot
;621:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 664
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 664
INDIRI4
CNSTI4 0
NEI4 $270
ADDRGP4 $267
JUMPV
LABELV $270
line 623
;622:	//
;623:	trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 625
;624:	//asked for someone else
;625:	client = FindClientByName(netname);
ADDRLP4 0
ARGP4
ADDRLP4 668
ADDRGP4 FindClientByName
CALLI4
ASGNI4
ADDRLP4 256
ADDRLP4 668
INDIRI4
ASGNI4
line 627
;626:	//if there's no valid client with this name
;627:	if (client < 0) {
ADDRLP4 256
INDIRI4
CNSTI4 0
GEI4 $272
line 628
;628:		BotAI_BotInitialChat(bs, "whois", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $224
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 629
;629:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 672
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 672
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 672
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 630
;630:		return;
ADDRGP4 $267
JUMPV
LABELV $272
line 633
;631:	}
;632:	//get the match variable
;633:	trap_BotMatchVariable(match, KEYAREA, itemname, sizeof(itemname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 260
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 635
;634:	//in CTF it could be the base
;635:	if (match->subtype & ST_THERE) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
EQI4 $274
line 637
;636:		//camp at the spot the bot is currently standing
;637:		bs->teamgoal.entitynum = bs->entitynum;
ADDRLP4 672
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 672
INDIRP4
CNSTI4 6336
ADDP4
ADDRLP4 672
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ASGNI4
line 638
;638:		bs->teamgoal.areanum = bs->areanum;
ADDRLP4 676
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 676
INDIRP4
CNSTI4 6308
ADDP4
ADDRLP4 676
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ASGNI4
line 639
;639:		VectorCopy(bs->origin, bs->teamgoal.origin);
ADDRLP4 680
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 680
INDIRP4
CNSTI4 6296
ADDP4
ADDRLP4 680
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 640
;640:		VectorSet(bs->teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6312
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6316
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6320
ADDP4
CNSTF4 3238002688
ASGNF4
line 641
;641:		VectorSet(bs->teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6324
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6328
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6332
ADDP4
CNSTF4 1090519040
ASGNF4
line 642
;642:	}
ADDRGP4 $275
JUMPV
LABELV $274
line 643
;643:	else if (match->subtype & ST_HERE) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $276
line 645
;644:		//if this is the bot self
;645:		if (client == bs->client) return;
ADDRLP4 256
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $278
ADDRGP4 $267
JUMPV
LABELV $278
line 647
;646:		//
;647:		bs->teamgoal.entitynum = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
CNSTI4 -1
ASGNI4
line 648
;648:		BotEntityInfo(client, &entinfo);
ADDRLP4 256
INDIRI4
ARGI4
ADDRLP4 516
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 650
;649:		//if info is valid (in PVS)
;650:		if (entinfo.valid) {
ADDRLP4 516
INDIRI4
CNSTI4 0
EQI4 $280
line 651
;651:			areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 516+24
ARGP4
ADDRLP4 672
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 656
ADDRLP4 672
INDIRI4
ASGNI4
line 652
;652:			if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 676
ADDRLP4 656
INDIRI4
ASGNI4
ADDRLP4 676
INDIRI4
CNSTI4 0
EQI4 $283
ADDRLP4 676
INDIRI4
ARGI4
ADDRLP4 680
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 680
INDIRI4
CNSTI4 0
EQI4 $283
line 655
;653:				//NOTE: just cheat and assume the bot knows where the person is
;654:				//if (BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, client)) {
;655:					bs->teamgoal.entitynum = client;
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
ADDRLP4 256
INDIRI4
ASGNI4
line 656
;656:					bs->teamgoal.areanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6308
ADDP4
ADDRLP4 656
INDIRI4
ASGNI4
line 657
;657:					VectorCopy(entinfo.origin, bs->teamgoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6296
ADDP4
ADDRLP4 516+24
INDIRB
ASGNB 12
line 658
;658:					VectorSet(bs->teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6312
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6316
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6320
ADDP4
CNSTF4 3238002688
ASGNF4
line 659
;659:					VectorSet(bs->teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6324
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6328
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6332
ADDP4
CNSTF4 1090519040
ASGNF4
line 661
;660:				//}
;661:			}
LABELV $283
line 662
;662:		}
LABELV $280
line 664
;663:		//if the other is not visible
;664:		if (bs->teamgoal.entitynum < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
CNSTI4 0
GEI4 $277
line 665
;665:			BotAI_BotInitialChat(bs, "whereareyou", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $244
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 666
;666:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 672
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 672
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 672
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 667
;667:			return;
ADDRGP4 $267
JUMPV
line 669
;668:		}
;669:	}
LABELV $276
line 670
;670:	else if (!BotGetMessageTeamGoal(bs, itemname, &bs->teamgoal)) {
ADDRLP4 672
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 672
INDIRP4
ARGP4
ADDRLP4 260
ARGP4
ADDRLP4 672
INDIRP4
CNSTI4 6296
ADDP4
ARGP4
ADDRLP4 676
ADDRGP4 BotGetMessageTeamGoal
CALLI4
ASGNI4
ADDRLP4 676
INDIRI4
CNSTI4 0
NEI4 $288
line 673
;671:		//BotAI_BotInitialChat(bs, "cannotfind", itemname, NULL);
;672:		//trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
;673:		return;
ADDRGP4 $267
JUMPV
LABELV $288
LABELV $277
LABELV $275
line 676
;674:	}
;675:	//set the time to send a message to the team mates
;676:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 680
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 684
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 680
INDIRF4
CNSTF4 1073741824
ADDRLP4 684
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 678
;677:	//set the ltg type
;678:	bs->ltgtype = LTG_CAMPORDER;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 8
ASGNI4
line 680
;679:	//get the team goal time
;680:	bs->teamgoal_time = BotGetTime(match);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 688
ADDRGP4 BotGetTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 688
INDIRF4
ASGNF4
line 682
;681:	//set the team goal time
;682:	if (!bs->teamgoal_time) bs->teamgoal_time = trap_AAS_Time() + TEAM_CAMP_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
CNSTF4 0
NEF4 $290
ADDRLP4 692
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 692
INDIRF4
CNSTF4 1142292480
ADDF4
ASGNF4
LABELV $290
line 684
;683:	//the teammate that requested the camping
;684:	bs->teammate = client;
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
ADDRLP4 256
INDIRI4
ASGNI4
line 686
;685:	//not arrived yet
;686:	bs->arrive_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6136
ADDP4
CNSTF4 0
ASGNF4
line 691
;687:	//
;688:#ifdef DEBUG
;689:	BotPrintTeamGoal(bs);
;690:#endif //DEBUG
;691:}
LABELV $267
endproc BotMatch_Camp 696 16
export BotMatch_Patrol
proc BotMatch_Patrol 28 8
line 698
;692:
;693:/*
;694:==================
;695:BotMatch_Patrol
;696:==================
;697:*/
;698:void BotMatch_Patrol(bot_state_t *bs, bot_match_t *match) {
line 699
;699:	if (!TeamPlayIsOn()) return;
ADDRLP4 0
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $293
ADDRGP4 $292
JUMPV
LABELV $293
line 701
;700:	//if not addressed to this bot
;701:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $295
ADDRGP4 $292
JUMPV
LABELV $295
line 703
;702:	//get the patrol waypoints
;703:	if (!BotGetPatrolWaypoints(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 BotGetPatrolWaypoints
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $297
ADDRGP4 $292
JUMPV
LABELV $297
line 705
;704:	//set the time to send a message to the team mates
;705:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 12
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 16
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 12
INDIRF4
CNSTF4 1073741824
ADDRLP4 16
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 707
;706:	//set the ltg type
;707:	bs->ltgtype = LTG_PATROL;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 9
ASGNI4
line 709
;708:	//get the team goal time
;709:	bs->teamgoal_time = BotGetTime(match);
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 BotGetTime
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
line 711
;710:	//set the team goal time if not set already
;711:	if (!bs->teamgoal_time) bs->teamgoal_time = trap_AAS_Time() + TEAM_PATROL_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
INDIRF4
CNSTF4 0
NEF4 $299
ADDRLP4 24
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 24
INDIRF4
CNSTF4 1142292480
ADDF4
ASGNF4
LABELV $299
line 716
;712:	//
;713:#ifdef DEBUG
;714:	BotPrintTeamGoal(bs);
;715:#endif //DEBUG
;716:}
LABELV $292
endproc BotMatch_Patrol 28 8
export BotMatch_GetFlag
proc BotMatch_GetFlag 20 8
line 723
;717:
;718:/*
;719:==================
;720:BotMatch_GetFlag
;721:==================
;722:*/
;723:void BotMatch_GetFlag(bot_state_t *bs, bot_match_t *match) {
line 725
;724:	//if not in CTF mode
;725:	if (gametype != GT_CTF || !ctf_redflag.areanum || !ctf_blueflag.areanum) return;
ADDRGP4 gametype
INDIRI4
CNSTI4 4
NEI4 $307
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 ctf_redflag+12
INDIRI4
ADDRLP4 0
INDIRI4
EQI4 $307
ADDRGP4 ctf_blueflag+12
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $302
LABELV $307
ADDRGP4 $301
JUMPV
LABELV $302
line 727
;726:	//if not addressed to this bot
;727:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $308
ADDRGP4 $301
JUMPV
LABELV $308
line 729
;728:	//set the time to send a message to the team mates
;729:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 8
INDIRF4
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 731
;730:	//set the ltg type
;731:	bs->ltgtype = LTG_GETFLAG;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 4
ASGNI4
line 733
;732:	//set the team goal time
;733:	bs->teamgoal_time = trap_AAS_Time() + CTF_GETFLAG_TIME;
ADDRLP4 16
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 16
INDIRF4
CNSTF4 1133903872
ADDF4
ASGNF4
line 737
;734:#ifdef DEBUG
;735:	BotPrintTeamGoal(bs);
;736:#endif //DEBUG
;737:}
LABELV $301
endproc BotMatch_GetFlag 20 8
export BotMatch_RushBase
proc BotMatch_RushBase 20 8
line 744
;738:
;739:/*
;740:==================
;741:BotMatch_RushBase
;742:==================
;743:*/
;744:void BotMatch_RushBase(bot_state_t *bs, bot_match_t *match) {
line 746
;745:	//if not in CTF mode
;746:	if (gametype != GT_CTF || !ctf_redflag.areanum || !ctf_blueflag.areanum) return;
ADDRGP4 gametype
INDIRI4
CNSTI4 4
NEI4 $316
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 ctf_redflag+12
INDIRI4
ADDRLP4 0
INDIRI4
EQI4 $316
ADDRGP4 ctf_blueflag+12
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $311
LABELV $316
ADDRGP4 $310
JUMPV
LABELV $311
line 748
;747:	//if not addressed to this bot
;748:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $317
ADDRGP4 $310
JUMPV
LABELV $317
line 750
;749:	//set the time to send a message to the team mates
;750:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 8
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 8
INDIRF4
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 752
;751:	//set the ltg type
;752:	bs->ltgtype = LTG_RUSHBASE;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 5
ASGNI4
line 754
;753:	//set the team goal time
;754:	bs->teamgoal_time = trap_AAS_Time() + CTF_RUSHBASE_TIME;
ADDRLP4 16
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 16
INDIRF4
CNSTF4 1123024896
ADDF4
ASGNF4
line 755
;755:	bs->rushbaseaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
CNSTF4 0
ASGNF4
line 759
;756:#ifdef DEBUG
;757:	BotPrintTeamGoal(bs);
;758:#endif //DEBUG
;759:}
LABELV $310
endproc BotMatch_RushBase 20 8
export BotMatch_TaskPreference
proc BotMatch_TaskPreference 324 16
line 766
;760:
;761:/*
;762:==================
;763:BotMatch_TaskPreference
;764:==================
;765:*/
;766:void BotMatch_TaskPreference(bot_state_t *bs, bot_match_t *match) {
line 771
;767:	char netname[MAX_NETNAME];
;768:	char teammatename[MAX_MESSAGE_SIZE];
;769:	int teammate, preference;
;770:
;771:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 260
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 772
;772:	if (Q_stricmp(netname, bs->teamleader) != 0) return;
ADDRLP4 260
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 300
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 300
INDIRI4
CNSTI4 0
EQI4 $320
ADDRGP4 $319
JUMPV
LABELV $320
line 774
;773:
;774:	trap_BotMatchVariable(match, NETNAME, teammatename, sizeof(teammatename));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 775
;775:	teammate = ClientFromName(teammatename);
ADDRLP4 0
ARGP4
ADDRLP4 304
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRLP4 256
ADDRLP4 304
INDIRI4
ASGNI4
line 776
;776:	if (teammate < 0) return;
ADDRLP4 256
INDIRI4
CNSTI4 0
GEI4 $322
ADDRGP4 $319
JUMPV
LABELV $322
line 778
;777:
;778:	preference = BotGetTeamMateCTFPreference(bs, teammate);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 256
INDIRI4
ARGI4
ADDRLP4 308
ADDRGP4 BotGetTeamMateCTFPreference
CALLI4
ASGNI4
ADDRLP4 296
ADDRLP4 308
INDIRI4
ASGNI4
line 779
;779:	switch(match->subtype)
ADDRLP4 312
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
ASGNI4
ADDRLP4 312
INDIRI4
CNSTI4 1
EQI4 $327
ADDRLP4 312
INDIRI4
CNSTI4 2
EQI4 $328
ADDRLP4 312
INDIRI4
CNSTI4 4
EQI4 $329
ADDRGP4 $324
JUMPV
line 780
;780:	{
LABELV $327
line 782
;781:		case ST_DEFENDER:
;782:		{
line 783
;783:			preference &= ~CTFTP_ATTACKER;
ADDRLP4 296
ADDRLP4 296
INDIRI4
CNSTI4 -3
BANDI4
ASGNI4
line 784
;784:			preference |= CTFTP_DEFENDER;
ADDRLP4 296
ADDRLP4 296
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 785
;785:			break;
ADDRGP4 $325
JUMPV
LABELV $328
line 788
;786:		}
;787:		case ST_ATTACKER:
;788:		{
line 789
;789:			preference &= ~CTFTP_DEFENDER;
ADDRLP4 296
ADDRLP4 296
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 790
;790:			preference |= CTFTP_ATTACKER;
ADDRLP4 296
ADDRLP4 296
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 791
;791:			break;
ADDRGP4 $325
JUMPV
LABELV $329
line 794
;792:		}
;793:		case ST_ROAMER:
;794:		{
line 795
;795:			preference &= ~(CTFTP_ATTACKER|CTFTP_DEFENDER);
ADDRLP4 296
ADDRLP4 296
INDIRI4
CNSTI4 -4
BANDI4
ASGNI4
line 796
;796:			break;
LABELV $324
LABELV $325
line 799
;797:		}
;798:	}
;799:	BotSetTeamMateCTFPreference(bs, teammate, preference);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 256
INDIRI4
ARGI4
ADDRLP4 296
INDIRI4
ARGI4
ADDRGP4 BotSetTeamMateCTFPreference
CALLV
pop
line 801
;800:	//
;801:	EasyClientName(teammate, teammatename, sizeof(teammatename));
ADDRLP4 256
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 802
;802:	BotAI_BotInitialChat(bs, "keepinmind", teammatename, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $330
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 803
;803:	trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 320
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 320
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 320
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 804
;804:}
LABELV $319
endproc BotMatch_TaskPreference 324 16
export BotMatch_ReturnFlag
proc BotMatch_ReturnFlag 16 8
line 811
;805:
;806:/*
;807:==================
;808:BotMatch_ReturnFlag
;809:==================
;810:*/
;811:void BotMatch_ReturnFlag(bot_state_t *bs, bot_match_t *match) {
line 813
;812:	//if not in CTF mode
;813:	if (gametype != GT_CTF) return;
ADDRGP4 gametype
INDIRI4
CNSTI4 4
EQI4 $332
ADDRGP4 $331
JUMPV
LABELV $332
line 815
;814:	//if not addressed to this bot
;815:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $334
ADDRGP4 $331
JUMPV
LABELV $334
line 817
;816:	//set the time to send a message to the team mates
;817:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 4
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 4
INDIRF4
CNSTF4 1073741824
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 819
;818:	//set the ltg type
;819:	bs->ltgtype = LTG_RETURNFLAG;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 6
ASGNI4
line 821
;820:	//set the team goal time
;821:	bs->teamgoal_time = trap_AAS_Time() + CTF_RETURNFLAG_TIME;
ADDRLP4 12
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 12
INDIRF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 822
;822:	bs->rushbaseaway_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6124
ADDP4
CNSTF4 0
ASGNF4
line 826
;823:#ifdef DEBUG
;824:	BotPrintTeamGoal(bs);
;825:#endif //DEBUG
;826:}
LABELV $331
endproc BotMatch_ReturnFlag 16 8
export BotMatch_JoinSubteam
proc BotMatch_JoinSubteam 268 16
line 833
;827:
;828:/*
;829:==================
;830:BotMatch_JoinSubteam
;831:==================
;832:*/
;833:void BotMatch_JoinSubteam(bot_state_t *bs, bot_match_t *match) {
line 836
;834:	char teammate[MAX_MESSAGE_SIZE];
;835:
;836:	if (!TeamPlayIsOn()) return;
ADDRLP4 256
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 256
INDIRI4
CNSTI4 0
NEI4 $337
ADDRGP4 $336
JUMPV
LABELV $337
line 838
;837:	//if not addressed to this bot
;838:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 260
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $339
ADDRGP4 $336
JUMPV
LABELV $339
line 840
;839:	//get the sub team name
;840:	trap_BotMatchVariable(match, TEAMNAME, teammate, MAX_MESSAGE_SIZE);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 842
;841:	//set the sub team name
;842:	strncpy(bs->subteam, teammate, 32);
ADDRFP4 0
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
ADDRLP4 0
ARGP4
CNSTU4 32
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 843
;843:	bs->subteam[31] = '\0';
ADDRFP4 0
INDIRP4
CNSTI4 6547
ADDP4
CNSTI1 0
ASGNI1
line 845
;844:	//
;845:	BotAI_BotInitialChat(bs, "joinedteam", teammate, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $341
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 846
;846:	trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 264
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 264
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 847
;847:}
LABELV $336
endproc BotMatch_JoinSubteam 268 16
export BotMatch_LeaveSubteam
proc BotMatch_LeaveSubteam 16 16
line 854
;848:
;849:/*
;850:==================
;851:BotMatch_LeaveSubteam
;852:==================
;853:*/
;854:void BotMatch_LeaveSubteam(bot_state_t *bs, bot_match_t *match) {
line 855
;855:	if (!TeamPlayIsOn()) return;
ADDRLP4 0
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $343
ADDRGP4 $342
JUMPV
LABELV $343
line 857
;856:	//if not addressed to this bot
;857:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $345
ADDRGP4 $342
JUMPV
LABELV $345
line 859
;858:	//
;859:	if (strlen(bs->subteam))
ADDRFP4 0
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
ADDRLP4 8
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 8
INDIRU4
CNSTU4 0
EQU4 $347
line 860
;860:	{
line 861
;861:		BotAI_BotInitialChat(bs, "leftteam", bs->subteam, NULL);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 $349
ARGP4
ADDRLP4 12
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 862
;862:	} //end if
LABELV $347
line 863
;863:	trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 864
;864:	strcpy(bs->subteam, "");
ADDRFP4 0
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
ADDRGP4 $350
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 865
;865:}
LABELV $342
endproc BotMatch_LeaveSubteam 16 16
export BotMatch_WhichTeam
proc BotMatch_WhichTeam 16 16
line 872
;866:
;867:/*
;868:==================
;869:BotMatch_LeaveSubteam
;870:==================
;871:*/
;872:void BotMatch_WhichTeam(bot_state_t *bs, bot_match_t *match) {
line 873
;873:	if (!TeamPlayIsOn()) return;
ADDRLP4 0
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $352
ADDRGP4 $351
JUMPV
LABELV $352
line 875
;874:	//if not addressed to this bot
;875:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $354
ADDRGP4 $351
JUMPV
LABELV $354
line 877
;876:	//
;877:	if (strlen(bs->subteam)) {
ADDRFP4 0
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
ADDRLP4 8
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 8
INDIRU4
CNSTU4 0
EQU4 $356
line 878
;878:		BotAI_BotInitialChat(bs, "inteam", bs->subteam, NULL);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 $358
ARGP4
ADDRLP4 12
INDIRP4
CNSTI4 6516
ADDP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 879
;879:	}
ADDRGP4 $357
JUMPV
LABELV $356
line 880
;880:	else {
line 881
;881:		BotAI_BotInitialChat(bs, "noteam", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $359
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 882
;882:	}
LABELV $357
line 883
;883:	trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 884
;884:}
LABELV $351
endproc BotMatch_WhichTeam 16 16
export BotMatch_CheckPoint
proc BotMatch_CheckPoint 308 24
line 891
;885:
;886:/*
;887:==================
;888:BotMatch_CheckPoint
;889:==================
;890:*/
;891:void BotMatch_CheckPoint(bot_state_t *bs, bot_match_t *match) {
line 897
;892:	int areanum;
;893:	char buf[MAX_MESSAGE_SIZE];
;894:	vec3_t position;
;895:	bot_waypoint_t *cp;
;896:
;897:	if (!TeamPlayIsOn()) return;
ADDRLP4 276
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 276
INDIRI4
CNSTI4 0
NEI4 $361
ADDRGP4 $360
JUMPV
LABELV $361
line 899
;898:	//
;899:	trap_BotMatchVariable(match, POSITION, buf, MAX_MESSAGE_SIZE);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 16
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 900
;900:	VectorClear(position);
ADDRLP4 280
CNSTF4 0
ASGNF4
ADDRLP4 4+8
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 4
ADDRLP4 280
INDIRF4
ASGNF4
line 902
;901:	//BotGPSToPosition(buf, position);
;902:	sscanf(buf, "%f %f %f", &position[0], &position[1], &position[2]);
ADDRLP4 16
ARGP4
ADDRGP4 $365
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 4+4
ARGP4
ADDRLP4 4+8
ARGP4
ADDRGP4 sscanf
CALLI4
pop
line 903
;903:	position[2] += 0.5;
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 904
;904:	areanum = BotPointAreaNum(position);
ADDRLP4 4
ARGP4
ADDRLP4 284
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 272
ADDRLP4 284
INDIRI4
ASGNI4
line 905
;905:	if (!areanum) {
ADDRLP4 272
INDIRI4
CNSTI4 0
NEI4 $369
line 906
;906:		if (BotAddressedToBot(bs, match)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 288
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 288
INDIRI4
CNSTI4 0
EQI4 $360
line 907
;907:			BotAI_BotInitialChat(bs, "checkpoint_invalid", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $373
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 908
;908:			trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 292
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 292
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 292
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 909
;909:		}
line 910
;910:		return;
ADDRGP4 $360
JUMPV
LABELV $369
line 913
;911:	}
;912:	//
;913:	trap_BotMatchVariable(match, NAME, buf, MAX_MESSAGE_SIZE);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 16
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 915
;914:	//check if there already exists a checkpoint with this name
;915:	cp = BotFindWayPoint(bs->checkpoints, buf);
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 288
ADDRGP4 BotFindWayPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 288
INDIRP4
ASGNP4
line 916
;916:	if (cp) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $374
line 917
;917:		if (cp->next) cp->next->prev = cp->prev;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $376
ADDRLP4 296
CNSTI4 96
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ADDRLP4 296
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 296
INDIRI4
ADDP4
INDIRP4
ASGNP4
LABELV $376
line 918
;918:		if (cp->prev) cp->prev->next = cp->next;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $378
ADDRLP4 304
CNSTI4 92
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
INDIRP4
ADDRLP4 304
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 304
INDIRI4
ADDP4
INDIRP4
ASGNP4
ADDRGP4 $379
JUMPV
LABELV $378
line 919
;919:		else bs->checkpoints = cp->next;
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRP4
ASGNP4
LABELV $379
line 920
;920:		cp->inuse = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 0
ASGNI4
line 921
;921:	}
LABELV $374
line 923
;922:	//create a new check point
;923:	cp = BotCreateWayPoint(buf, position, areanum);
ADDRLP4 16
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 272
INDIRI4
ARGI4
ADDRLP4 292
ADDRGP4 BotCreateWayPoint
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 292
INDIRP4
ASGNP4
line 925
;924:	//add the check point to the bot's known chech points
;925:	cp->next = bs->checkpoints;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
ASGNP4
line 926
;926:	if (bs->checkpoints) bs->checkpoints->prev = cp;
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $380
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
LABELV $380
line 927
;927:	bs->checkpoints = cp;
ADDRFP4 0
INDIRP4
CNSTI4 6708
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 929
;928:	//
;929:	if (BotAddressedToBot(bs, match)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 296
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 296
INDIRI4
CNSTI4 0
EQI4 $382
line 930
;930:		Com_sprintf(buf, sizeof(buf), "%1.0f %1.0f %1.0f", cp->goal.origin[0],
ADDRLP4 16
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 $384
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ARGF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ARGF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ARGF4
ADDRGP4 Com_sprintf
CALLV
pop
line 934
;931:													cp->goal.origin[1],
;932:													cp->goal.origin[2]);
;933:
;934:		BotAI_BotInitialChat(bs, "checkpoint_confirm", cp->name, buf, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $385
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 16
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 935
;935:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 304
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 304
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 304
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 936
;936:	}
LABELV $382
line 937
;937:}
LABELV $360
endproc BotMatch_CheckPoint 308 24
export BotMatch_FormationSpace
proc BotMatch_FormationSpace 280 16
line 944
;938:
;939:/*
;940:==================
;941:BotMatch_FormationSpace
;942:==================
;943:*/
;944:void BotMatch_FormationSpace(bot_state_t *bs, bot_match_t *match) {
line 948
;945:	char buf[MAX_MESSAGE_SIZE];
;946:	float space;
;947:
;948:	if (!TeamPlayIsOn()) return;
ADDRLP4 260
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $387
ADDRGP4 $386
JUMPV
LABELV $387
line 950
;949:	//if not addressed to this bot
;950:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 264
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 264
INDIRI4
CNSTI4 0
NEI4 $389
ADDRGP4 $386
JUMPV
LABELV $389
line 952
;951:	//
;952:	trap_BotMatchVariable(match, NUMBER, buf, MAX_MESSAGE_SIZE);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 954
;953:	//if it's the distance in feet
;954:	if (match->subtype & ST_FEET) space = 0.3048 * 32 * atof(buf);
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $391
ADDRLP4 4
ARGP4
ADDRLP4 268
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
CNSTF4 1092357823
ADDRLP4 268
INDIRF4
MULF4
ASGNF4
ADDRGP4 $392
JUMPV
LABELV $391
line 956
;955:	//else it's in meters
;956:	else space = 32 * atof(buf);
ADDRLP4 4
ARGP4
ADDRLP4 272
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
CNSTF4 1107296256
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
LABELV $392
line 958
;957:	//check if the formation intervening space is valid
;958:	if (space < 48 || space > 500) space = 100;
ADDRLP4 0
INDIRF4
CNSTF4 1111490560
LTF4 $395
ADDRLP4 0
INDIRF4
CNSTF4 1140457472
LEF4 $393
LABELV $395
ADDRLP4 0
CNSTF4 1120403456
ASGNF4
LABELV $393
line 959
;959:	bs->formation_dist = space;
ADDRFP4 0
INDIRP4
CNSTI4 6548
ADDP4
ADDRLP4 0
INDIRF4
ASGNF4
line 960
;960:}
LABELV $386
endproc BotMatch_FormationSpace 280 16
export BotMatch_Dismiss
proc BotMatch_Dismiss 12 12
line 967
;961:
;962:/*
;963:==================
;964:BotMatch_Dismiss
;965:==================
;966:*/
;967:void BotMatch_Dismiss(bot_state_t *bs, bot_match_t *match) {
line 968
;968:	if (!TeamPlayIsOn()) return;
ADDRLP4 0
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $397
ADDRGP4 $396
JUMPV
LABELV $397
line 970
;969:	//if not addressed to this bot
;970:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $399
ADDRGP4 $396
JUMPV
LABELV $399
line 972
;971:	//
;972:	bs->ltgtype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 0
ASGNI4
line 973
;973:	bs->lead_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6424
ADDP4
CNSTF4 0
ASGNF4
line 975
;974:	//
;975:	BotAI_BotInitialChat(bs, "dismissed", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $401
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 976
;976:	trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 977
;977:}
LABELV $396
endproc BotMatch_Dismiss 12 12
export BotMatch_StartTeamLeaderShip
proc BotMatch_StartTeamLeaderShip 268 16
line 984
;978:
;979:/*
;980:==================
;981:BotMatch_StartTeamLeaderShip
;982:==================
;983:*/
;984:void BotMatch_StartTeamLeaderShip(bot_state_t *bs, bot_match_t *match) {
line 988
;985:	int client;
;986:	char teammate[MAX_MESSAGE_SIZE];
;987:
;988:	if (!TeamPlayIsOn()) return;
ADDRLP4 260
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $403
ADDRGP4 $402
JUMPV
LABELV $403
line 990
;989:	//if chats for him or herself
;990:	if (match->subtype & ST_I) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $405
line 992
;991:		//get the team mate that will be the team leader
;992:		trap_BotMatchVariable(match, NETNAME, teammate, sizeof(teammate));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 993
;993:		strncpy(bs->teamleader, teammate, sizeof(bs->teamleader));
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 0
ARGP4
CNSTU4 32
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 994
;994:		bs->teamleader[sizeof(bs->teamleader)] = '\0';
ADDRFP4 0
INDIRP4
CNSTI4 6440
CNSTU4 32
ADDI4
ADDP4
CNSTI1 0
ASGNI1
line 995
;995:	}
ADDRGP4 $406
JUMPV
LABELV $405
line 997
;996:	//chats for someone else
;997:	else {
line 999
;998:		//get the team mate that will be the team leader
;999:		trap_BotMatchVariable(match, TEAMMATE, teammate, sizeof(teammate));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1000
;1000:		client = FindClientByName(teammate);
ADDRLP4 0
ARGP4
ADDRLP4 264
ADDRGP4 FindClientByName
CALLI4
ASGNI4
ADDRLP4 256
ADDRLP4 264
INDIRI4
ASGNI4
line 1001
;1001:		if (client >= 0) ClientName(client, bs->teamleader, sizeof(bs->teamleader));
ADDRLP4 256
INDIRI4
CNSTI4 0
LTI4 $407
ADDRLP4 256
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 ClientName
CALLP4
pop
LABELV $407
line 1002
;1002:	}
LABELV $406
line 1003
;1003:}
LABELV $402
endproc BotMatch_StartTeamLeaderShip 268 16
export BotMatch_StopTeamLeaderShip
proc BotMatch_StopTeamLeaderShip 528 16
line 1010
;1004:
;1005:/*
;1006:==================
;1007:BotMatch_StopTeamLeaderShip
;1008:==================
;1009:*/
;1010:void BotMatch_StopTeamLeaderShip(bot_state_t *bs, bot_match_t *match) {
line 1015
;1011:	int client;
;1012:	char teammate[MAX_MESSAGE_SIZE];
;1013:	char netname[MAX_MESSAGE_SIZE];
;1014:
;1015:	if (!TeamPlayIsOn()) return;
ADDRLP4 516
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 516
INDIRI4
CNSTI4 0
NEI4 $410
ADDRGP4 $409
JUMPV
LABELV $410
line 1017
;1016:	//get the team mate that stops being the team leader
;1017:	trap_BotMatchVariable(match, TEAMMATE, teammate, sizeof(teammate));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1019
;1018:	//if chats for him or herself
;1019:	if (match->subtype & ST_I) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $412
line 1020
;1020:		trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 260
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1021
;1021:		client = FindClientByName(netname);
ADDRLP4 260
ARGP4
ADDRLP4 520
ADDRGP4 FindClientByName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 520
INDIRI4
ASGNI4
line 1022
;1022:	}
ADDRGP4 $413
JUMPV
LABELV $412
line 1024
;1023:	//chats for someone else
;1024:	else {
line 1025
;1025:		client = FindClientByName(teammate);
ADDRLP4 4
ARGP4
ADDRLP4 520
ADDRGP4 FindClientByName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 520
INDIRI4
ASGNI4
line 1026
;1026:	} //end else
LABELV $413
line 1027
;1027:	if (client >= 0) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $414
line 1028
;1028:		if (!Q_stricmp(bs->teamleader, ClientName(client, netname, sizeof(netname)))) {
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 260
ARGP4
CNSTI4 256
ARGI4
ADDRLP4 520
ADDRGP4 ClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 520
INDIRP4
ARGP4
ADDRLP4 524
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 524
INDIRI4
CNSTI4 0
NEI4 $416
line 1029
;1029:			bs->teamleader[0] = '\0';
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
CNSTI1 0
ASGNI1
line 1030
;1030:		}
LABELV $416
line 1031
;1031:	}
LABELV $414
line 1032
;1032:}
LABELV $409
endproc BotMatch_StopTeamLeaderShip 528 16
export BotMatch_WhoIsTeamLeader
proc BotMatch_WhoIsTeamLeader 264 12
line 1039
;1033:
;1034:/*
;1035:==================
;1036:BotMatch_WhoIsTeamLeader
;1037:==================
;1038:*/
;1039:void BotMatch_WhoIsTeamLeader(bot_state_t *bs, bot_match_t *match) {
line 1042
;1040:	char netname[MAX_MESSAGE_SIZE];
;1041:
;1042:	if (!TeamPlayIsOn()) return;
ADDRLP4 256
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 256
INDIRI4
CNSTI4 0
NEI4 $419
ADDRGP4 $418
JUMPV
LABELV $419
line 1044
;1043:
;1044:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 1046
;1045:	//if this bot IS the team leader
;1046:	if (!Q_stricmp(netname, bs->teamleader)) {
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 260
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $421
line 1047
;1047:		trap_EA_SayTeam(bs->client, "I'm the team leader\n");
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $423
ARGP4
ADDRGP4 trap_EA_SayTeam
CALLV
pop
line 1048
;1048:	}
LABELV $421
line 1049
;1049:}
LABELV $418
endproc BotMatch_WhoIsTeamLeader 264 12
export BotMatch_WhatAreYouDoing
proc BotMatch_WhatAreYouDoing 528 16
line 1056
;1050:
;1051:/*
;1052:==================
;1053:BotMatch_WhatAreYouDoing
;1054:==================
;1055:*/
;1056:void BotMatch_WhatAreYouDoing(bot_state_t *bs, bot_match_t *match) {
line 1061
;1057:	char netname[MAX_MESSAGE_SIZE];
;1058:	char goalname[MAX_MESSAGE_SIZE];
;1059:
;1060:	//if not addressed to this bot
;1061:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 512
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 512
INDIRI4
CNSTI4 0
NEI4 $425
ADDRGP4 $424
JUMPV
LABELV $425
line 1063
;1062:	//
;1063:	switch(bs->ltgtype) {
ADDRLP4 516
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 516
INDIRI4
CNSTI4 1
LTI4 $427
ADDRLP4 516
INDIRI4
CNSTI4 11
GTI4 $427
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $451-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $451
address $430
address $432
address $434
address $444
address $446
address $448
address $440
address $440
address $442
address $436
address $438
code
LABELV $430
line 1065
;1064:		case LTG_TEAMHELP:
;1065:		{
line 1066
;1066:			EasyClientName(bs->teammate, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 1067
;1067:			BotAI_BotInitialChat(bs, "helping", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $431
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1068
;1068:			break;
ADDRGP4 $428
JUMPV
LABELV $432
line 1071
;1069:		}
;1070:		case LTG_TEAMACCOMPANY:
;1071:		{
line 1072
;1072:			EasyClientName(bs->teammate, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 6292
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 1073
;1073:			BotAI_BotInitialChat(bs, "accompanying", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $433
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1074
;1074:			break;
ADDRGP4 $428
JUMPV
LABELV $434
line 1077
;1075:		}
;1076:		case LTG_DEFENDKEYAREA:
;1077:		{
line 1078
;1078:			trap_BotGoalName(bs->teamgoal.number, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 256
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 1079
;1079:			BotAI_BotInitialChat(bs, "defending", goalname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $435
ARGP4
ADDRLP4 256
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1080
;1080:			break;
ADDRGP4 $428
JUMPV
LABELV $436
line 1083
;1081:		}
;1082:		case LTG_GETITEM:
;1083:		{
line 1084
;1084:			trap_BotGoalName(bs->teamgoal.number, goalname, sizeof(goalname));
ADDRFP4 0
INDIRP4
CNSTI4 6340
ADDP4
INDIRI4
ARGI4
ADDRLP4 256
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 1085
;1085:			BotAI_BotInitialChat(bs, "gettingitem", goalname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $437
ARGP4
ADDRLP4 256
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1086
;1086:			break;
ADDRGP4 $428
JUMPV
LABELV $438
line 1089
;1087:		}
;1088:		case LTG_KILL:
;1089:		{
line 1090
;1090:			ClientName(bs->teamgoal.entitynum, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 1091
;1091:			BotAI_BotInitialChat(bs, "killing", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $439
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1092
;1092:			break;
ADDRGP4 $428
JUMPV
LABELV $440
line 1096
;1093:		}
;1094:		case LTG_CAMP:
;1095:		case LTG_CAMPORDER:
;1096:		{
line 1097
;1097:			BotAI_BotInitialChat(bs, "camping", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $441
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1098
;1098:			break;
ADDRGP4 $428
JUMPV
LABELV $442
line 1101
;1099:		}
;1100:		case LTG_PATROL:
;1101:		{
line 1102
;1102:			BotAI_BotInitialChat(bs, "patrolling", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $443
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1103
;1103:			break;
ADDRGP4 $428
JUMPV
LABELV $444
line 1106
;1104:		}
;1105:		case LTG_GETFLAG:
;1106:		{
line 1107
;1107:			BotAI_BotInitialChat(bs, "capturingflag", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $445
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1108
;1108:			break;
ADDRGP4 $428
JUMPV
LABELV $446
line 1111
;1109:		}
;1110:		case LTG_RUSHBASE:
;1111:		{
line 1112
;1112:			BotAI_BotInitialChat(bs, "rushingbase", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $447
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1113
;1113:			break;
ADDRGP4 $428
JUMPV
LABELV $448
line 1116
;1114:		}
;1115:		case LTG_RETURNFLAG:
;1116:		{
line 1117
;1117:			BotAI_BotInitialChat(bs, "returningflag", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $449
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1118
;1118:			break;
ADDRGP4 $428
JUMPV
LABELV $427
line 1121
;1119:		}
;1120:		default:
;1121:		{
line 1122
;1122:			BotAI_BotInitialChat(bs, "roaming", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $450
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1123
;1123:			break;
LABELV $428
line 1127
;1124:		}
;1125:	}
;1126:	//chat what the bot is doing
;1127:	trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 524
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 524
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 524
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1128
;1128:}
LABELV $424
endproc BotMatch_WhatAreYouDoing 528 16
export BotMatch_WhatIsMyCommand
proc BotMatch_WhatIsMyCommand 40 12
line 1135
;1129:
;1130:/*
;1131:==================
;1132:BotMatch_WhatIsMyCommand
;1133:==================
;1134:*/
;1135:void BotMatch_WhatIsMyCommand(bot_state_t *bs, bot_match_t *match) {
line 1138
;1136:	char netname[MAX_NETNAME];
;1137:
;1138:	ClientName(bs->client, netname, sizeof(netname));
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 1139
;1139:	if (Q_stricmp(netname, bs->teamleader) != 0) return;
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 6440
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $454
ADDRGP4 $453
JUMPV
LABELV $454
line 1140
;1140:	bs->forceorders = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 6504
ADDP4
CNSTI4 1
ASGNI4
line 1141
;1141:}
LABELV $453
endproc BotMatch_WhatIsMyCommand 40 12
export BotNearestVisibleItem
proc BotNearestVisibleItem 252 28
line 1148
;1142:
;1143:/*
;1144:==================
;1145:BotNearestVisibleItem
;1146:==================
;1147:*/
;1148:float BotNearestVisibleItem(bot_state_t *bs, char *itemname, bot_goal_t *goal) {
line 1156
;1149:	int i;
;1150:	char name[64];
;1151:	bot_goal_t tmpgoal;
;1152:	float dist, bestdist;
;1153:	vec3_t dir;
;1154:	bsp_trace_t trace;
;1155:
;1156:	bestdist = 999999;
ADDRLP4 140
CNSTF4 1232348144
ASGNF4
line 1157
;1157:	i = -1;
ADDRLP4 68
CNSTI4 -1
ASGNI4
LABELV $457
line 1158
;1158:	do {
line 1159
;1159:		i = trap_BotGetLevelItemGoal(i, itemname, &tmpgoal);
ADDRLP4 68
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 228
ADDRGP4 trap_BotGetLevelItemGoal
CALLI4
ASGNI4
ADDRLP4 68
ADDRLP4 228
INDIRI4
ASGNI4
line 1160
;1160:		trap_BotGoalName(tmpgoal.number, name, sizeof(name));
ADDRLP4 0+44
INDIRI4
ARGI4
ADDRLP4 72
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 trap_BotGoalName
CALLV
pop
line 1161
;1161:		if (Q_stricmp(itemname, name) != 0) continue;
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 72
ARGP4
ADDRLP4 232
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 232
INDIRI4
CNSTI4 0
EQI4 $461
ADDRGP4 $458
JUMPV
LABELV $461
line 1162
;1162:		VectorSubtract(tmpgoal.origin, bs->origin, dir);
ADDRLP4 236
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
ADDRLP4 0
INDIRF4
ADDRLP4 236
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 56+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 236
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 56+8
ADDRLP4 0+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1163
;1163:		dist = VectorLength(dir);
ADDRLP4 56
ARGP4
ADDRLP4 240
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 136
ADDRLP4 240
INDIRF4
ASGNF4
line 1164
;1164:		if (dist < bestdist) {
ADDRLP4 136
INDIRF4
ADDRLP4 140
INDIRF4
GEF4 $467
line 1166
;1165:			//trace from start to end
;1166:			BotAI_Trace(&trace, bs->eye, NULL, NULL, tmpgoal.origin, bs->client, CONTENTS_SOLID|CONTENTS_PLAYERCLIP);
ADDRLP4 144
ARGP4
ADDRLP4 244
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 244
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 248
CNSTP4 0
ASGNP4
ADDRLP4 248
INDIRP4
ARGP4
ADDRLP4 248
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 244
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 65537
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 1167
;1167:			if (trace.fraction >= 1.0) {
ADDRLP4 144+8
INDIRF4
CNSTF4 1065353216
LTF4 $469
line 1168
;1168:				bestdist = dist;
ADDRLP4 140
ADDRLP4 136
INDIRF4
ASGNF4
line 1169
;1169:				memcpy(goal, &tmpgoal, sizeof(bot_goal_t));
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTU4 56
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 1170
;1170:			}
LABELV $469
line 1171
;1171:		}
LABELV $467
line 1172
;1172:	} while(i > 0);
LABELV $458
ADDRLP4 68
INDIRI4
CNSTI4 0
GTI4 $457
line 1173
;1173:	return bestdist;
ADDRLP4 140
INDIRF4
RETF4
LABELV $456
endproc BotNearestVisibleItem 252 28
lit
align 4
LABELV $473
address $474
address $475
address $476
address $477
address $478
address $479
address $480
address $481
address $482
address $483
address $484
address $485
address $486
address $487
address $488
address $489
address $490
byte 4 0
export BotMatch_WhereAreYou
code
proc BotMatch_WhereAreYou 192 20
line 1181
;1174:}
;1175:
;1176:/*
;1177:==================
;1178:BotMatch_WhereAreYou
;1179:==================
;1180:*/
;1181:void BotMatch_WhereAreYou(bot_state_t *bs, bot_match_t *match) {
line 1185
;1182:	float dist, bestdist;
;1183:	int i, bestitem, redflagtt, blueflagtt, redtobluett;
;1184:	bot_goal_t goal;
;1185:	char *nearbyitems[] = {
ADDRLP4 8
ADDRGP4 $473
INDIRB
ASGNB 72
line 1206
;1186:		"Shotgun",
;1187:		"Grenade Launcher",
;1188:		"Rocket Launcher",
;1189:		"Plasmagun",
;1190:		"Railgun",
;1191:		"Lightning Gun",
;1192:		"BFG10K",
;1193:		"Quad Damage",
;1194:		"Regeneration",
;1195:		"Battle Suit",
;1196:		"Speed",
;1197:		"Invisibility",
;1198:		"Flight",
;1199:		"Armor",
;1200:		"Heavy Armor",
;1201:		"Red Flag",
;1202:		"Blue Flag",
;1203:		NULL
;1204:	};
;1205:	//
;1206:	if (!TeamPlayIsOn()) return;
ADDRLP4 156
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 156
INDIRI4
CNSTI4 0
NEI4 $491
ADDRGP4 $472
JUMPV
LABELV $491
line 1208
;1207:	//if not addressed to this bot
;1208:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 160
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
NEI4 $493
ADDRGP4 $472
JUMPV
LABELV $493
line 1210
;1209:
;1210:	bestitem = -1;
ADDRLP4 140
CNSTI4 -1
ASGNI4
line 1211
;1211:	bestdist = 999999;
ADDRLP4 80
CNSTF4 1232348144
ASGNF4
line 1212
;1212:	for (i = 0; nearbyitems[i]; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $498
JUMPV
LABELV $495
line 1213
;1213:		dist = BotNearestVisibleItem(bs, nearbyitems[i], &goal);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 84
ARGP4
ADDRLP4 164
ADDRGP4 BotNearestVisibleItem
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 164
INDIRF4
ASGNF4
line 1214
;1214:		if (dist < bestdist) {
ADDRLP4 4
INDIRF4
ADDRLP4 80
INDIRF4
GEF4 $499
line 1215
;1215:			bestdist = dist;
ADDRLP4 80
ADDRLP4 4
INDIRF4
ASGNF4
line 1216
;1216:			bestitem = i;
ADDRLP4 140
ADDRLP4 0
INDIRI4
ASGNI4
line 1217
;1217:		}
LABELV $499
line 1218
;1218:	}
LABELV $496
line 1212
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $498
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $495
line 1219
;1219:	if (bestitem != -1) {
ADDRLP4 140
INDIRI4
CNSTI4 -1
EQI4 $501
line 1220
;1220:		if (gametype == GT_CTF) {
ADDRGP4 gametype
INDIRI4
CNSTI4 4
NEI4 $503
line 1221
;1221:			redflagtt = trap_AAS_AreaTravelTimeToGoalArea(bs->areanum, bs->origin, ctf_redflag.areanum, TFL_DEFAULT);
ADDRLP4 164
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 164
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ARGI4
ADDRLP4 164
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRGP4 ctf_redflag+12
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 168
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 144
ADDRLP4 168
INDIRI4
ASGNI4
line 1222
;1222:			blueflagtt = trap_AAS_AreaTravelTimeToGoalArea(bs->areanum, bs->origin, ctf_blueflag.areanum, TFL_DEFAULT);
ADDRLP4 172
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 172
INDIRP4
CNSTI4 4924
ADDP4
INDIRI4
ARGI4
ADDRLP4 172
INDIRP4
CNSTI4 4884
ADDP4
ARGP4
ADDRGP4 ctf_blueflag+12
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 176
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 148
ADDRLP4 176
INDIRI4
ASGNI4
line 1223
;1223:			redtobluett = trap_AAS_AreaTravelTimeToGoalArea(ctf_redflag.areanum, ctf_redflag.origin, ctf_blueflag.areanum, TFL_DEFAULT);
ADDRGP4 ctf_redflag+12
INDIRI4
ARGI4
ADDRGP4 ctf_redflag
ARGP4
ADDRGP4 ctf_blueflag+12
INDIRI4
ARGI4
CNSTI4 18616254
ARGI4
ADDRLP4 180
ADDRGP4 trap_AAS_AreaTravelTimeToGoalArea
CALLI4
ASGNI4
ADDRLP4 152
ADDRLP4 180
INDIRI4
ASGNI4
line 1224
;1224:			if (redflagtt < (redflagtt + blueflagtt) * 0.4) {
ADDRLP4 184
ADDRLP4 144
INDIRI4
ASGNI4
ADDRLP4 184
INDIRI4
CVIF4 4
CNSTF4 1053609165
ADDRLP4 184
INDIRI4
ADDRLP4 148
INDIRI4
ADDI4
CVIF4 4
MULF4
GEF4 $509
line 1225
;1225:				BotAI_BotInitialChat(bs, "ctflocation", nearbyitems[bestitem], "red", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $511
ARGP4
ADDRLP4 140
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
ARGP4
ADDRGP4 $512
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1226
;1226:			}
ADDRGP4 $504
JUMPV
LABELV $509
line 1227
;1227:			else if (blueflagtt < (redflagtt + blueflagtt) * 0.4) {
ADDRLP4 188
ADDRLP4 148
INDIRI4
ASGNI4
ADDRLP4 188
INDIRI4
CVIF4 4
CNSTF4 1053609165
ADDRLP4 144
INDIRI4
ADDRLP4 188
INDIRI4
ADDI4
CVIF4 4
MULF4
GEF4 $513
line 1228
;1228:				BotAI_BotInitialChat(bs, "ctflocation", nearbyitems[bestitem], "blue", NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $511
ARGP4
ADDRLP4 140
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
ARGP4
ADDRGP4 $515
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1229
;1229:			}
ADDRGP4 $504
JUMPV
LABELV $513
line 1230
;1230:			else {
line 1231
;1231:				BotAI_BotInitialChat(bs, "location", nearbyitems[bestitem], NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $516
ARGP4
ADDRLP4 140
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1232
;1232:			}
line 1233
;1233:		}
ADDRGP4 $504
JUMPV
LABELV $503
line 1234
;1234:		else {
line 1235
;1235:			BotAI_BotInitialChat(bs, "location", nearbyitems[bestitem], NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $516
ARGP4
ADDRLP4 140
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1236
;1236:		}
LABELV $504
line 1237
;1237:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 164
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 164
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 164
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1238
;1238:	}
LABELV $501
line 1239
;1239:}
LABELV $472
endproc BotMatch_WhereAreYou 192 20
export BotMatch_LeadTheWay
proc BotMatch_LeadTheWay 684 16
line 1246
;1240:
;1241:/*
;1242:==================
;1243:BotMatch_LeadTheWay
;1244:==================
;1245:*/
;1246:void BotMatch_LeadTheWay(bot_state_t *bs, bot_match_t *match) {
line 1251
;1247:	aas_entityinfo_t entinfo;
;1248:	char netname[MAX_MESSAGE_SIZE], teammate[MAX_MESSAGE_SIZE];
;1249:	int client, areanum, other;
;1250:
;1251:	if (!TeamPlayIsOn()) return;
ADDRLP4 664
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 664
INDIRI4
CNSTI4 0
NEI4 $518
ADDRGP4 $517
JUMPV
LABELV $518
line 1253
;1252:	//if not addressed to this bot
;1253:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 668
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 668
INDIRI4
CNSTI4 0
NEI4 $520
ADDRGP4 $517
JUMPV
LABELV $520
line 1255
;1254:	//if someone asks for someone else
;1255:	if (match->subtype & ST_SOMEONE) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $522
line 1257
;1256:		//get the team mate name
;1257:		trap_BotMatchVariable(match, TEAMMATE, teammate, sizeof(teammate));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 400
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1258
;1258:		client = FindClientByName(teammate);
ADDRLP4 400
ARGP4
ADDRLP4 672
ADDRGP4 FindClientByName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 672
INDIRI4
ASGNI4
line 1260
;1259:		//if this is the bot self
;1260:		if (client == bs->client) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $524
line 1261
;1261:			other = qfalse;
ADDRLP4 660
CNSTI4 0
ASGNI4
line 1262
;1262:		}
ADDRGP4 $523
JUMPV
LABELV $524
line 1263
;1263:		else if (!BotSameTeam(bs, client)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 676
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 676
INDIRI4
CNSTI4 0
NEI4 $526
line 1265
;1264:			//FIXME: say "I don't help the enemy"
;1265:			return;
ADDRGP4 $517
JUMPV
LABELV $526
line 1267
;1266:		}
;1267:		else {
line 1268
;1268:			other = qtrue;
ADDRLP4 660
CNSTI4 1
ASGNI4
line 1269
;1269:		}
line 1270
;1270:	}
ADDRGP4 $523
JUMPV
LABELV $522
line 1271
;1271:	else {
line 1273
;1272:		//get the netname
;1273:		trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 144
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1274
;1274:		client = ClientFromName(netname);
ADDRLP4 144
ARGP4
ADDRLP4 672
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 672
INDIRI4
ASGNI4
line 1275
;1275:		other = qfalse;
ADDRLP4 660
CNSTI4 0
ASGNI4
line 1276
;1276:	}
LABELV $523
line 1278
;1277:	//if the bot doesn't know who to help (FindClientByName returned -1)
;1278:	if (client < 0) {
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $528
line 1279
;1279:		BotAI_BotInitialChat(bs, "whois", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $224
ARGP4
ADDRLP4 144
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1280
;1280:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 672
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 672
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 672
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1281
;1281:		return;
ADDRGP4 $517
JUMPV
LABELV $528
line 1284
;1282:	}
;1283:	//
;1284:	bs->lead_teamgoal.entitynum = -1;
ADDRFP4 0
INDIRP4
CNSTI4 6408
ADDP4
CNSTI4 -1
ASGNI4
line 1285
;1285:	BotEntityInfo(client, &entinfo);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 1287
;1286:	//if info is valid (in PVS)
;1287:	if (entinfo.valid) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $530
line 1288
;1288:		areanum = BotPointAreaNum(entinfo.origin);
ADDRLP4 4+24
ARGP4
ADDRLP4 672
ADDRGP4 BotPointAreaNum
CALLI4
ASGNI4
ADDRLP4 656
ADDRLP4 672
INDIRI4
ASGNI4
line 1289
;1289:		if (areanum && trap_AAS_AreaReachability(areanum)) {
ADDRLP4 676
ADDRLP4 656
INDIRI4
ASGNI4
ADDRLP4 676
INDIRI4
CNSTI4 0
EQI4 $533
ADDRLP4 676
INDIRI4
ARGI4
ADDRLP4 680
ADDRGP4 trap_AAS_AreaReachability
CALLI4
ASGNI4
ADDRLP4 680
INDIRI4
CNSTI4 0
EQI4 $533
line 1290
;1290:			bs->lead_teamgoal.entitynum = client;
ADDRFP4 0
INDIRP4
CNSTI4 6408
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1291
;1291:			bs->lead_teamgoal.areanum = areanum;
ADDRFP4 0
INDIRP4
CNSTI4 6380
ADDP4
ADDRLP4 656
INDIRI4
ASGNI4
line 1292
;1292:			VectorCopy(entinfo.origin, bs->lead_teamgoal.origin);
ADDRFP4 0
INDIRP4
CNSTI4 6368
ADDP4
ADDRLP4 4+24
INDIRB
ASGNB 12
line 1293
;1293:			VectorSet(bs->lead_teamgoal.mins, -8, -8, -8);
ADDRFP4 0
INDIRP4
CNSTI4 6384
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6388
ADDP4
CNSTF4 3238002688
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6392
ADDP4
CNSTF4 3238002688
ASGNF4
line 1294
;1294:			VectorSet(bs->lead_teamgoal.maxs, 8, 8, 8);
ADDRFP4 0
INDIRP4
CNSTI4 6396
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6400
ADDP4
CNSTF4 1090519040
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6404
ADDP4
CNSTF4 1090519040
ASGNF4
line 1295
;1295:		}
LABELV $533
line 1296
;1296:	}
LABELV $530
line 1298
;1297:
;1298:	if (bs->teamgoal.entitynum < 0) {
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
INDIRI4
CNSTI4 0
GEI4 $536
line 1299
;1299:		if (other) BotAI_BotInitialChat(bs, "whereis", teammate, NULL);
ADDRLP4 660
INDIRI4
CNSTI4 0
EQI4 $538
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $243
ARGP4
ADDRLP4 400
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $539
JUMPV
LABELV $538
line 1300
;1300:		else BotAI_BotInitialChat(bs, "whereareyou", netname, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $244
ARGP4
ADDRLP4 144
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
LABELV $539
line 1301
;1301:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 672
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 672
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 672
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1302
;1302:		return;
ADDRGP4 $517
JUMPV
LABELV $536
line 1304
;1303:	}
;1304:	bs->lead_teammate = client;
ADDRFP4 0
INDIRP4
CNSTI4 6364
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1305
;1305:	bs->lead_time = trap_AAS_Time() + TEAM_LEAD_TIME;
ADDRLP4 672
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6424
ADDP4
ADDRLP4 672
INDIRF4
CNSTF4 1142292480
ADDF4
ASGNF4
line 1306
;1306:	bs->leadvisible_time = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6428
ADDP4
CNSTF4 0
ASGNF4
line 1307
;1307:	bs->leadmessage_time = -(trap_AAS_Time() + 2 * random());
ADDRLP4 676
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 680
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6432
ADDP4
ADDRLP4 676
INDIRF4
CNSTF4 1073741824
ADDRLP4 680
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
NEGF4
ASGNF4
line 1308
;1308:}
LABELV $517
endproc BotMatch_LeadTheWay 684 16
export BotMatch_Kill
proc BotMatch_Kill 284 16
line 1315
;1309:
;1310:/*
;1311:==================
;1312:BotMatch_Kill
;1313:==================
;1314:*/
;1315:void BotMatch_Kill(bot_state_t *bs, bot_match_t *match) {
line 1319
;1316:	char enemy[MAX_MESSAGE_SIZE];
;1317:	int client;
;1318:
;1319:	if (!TeamPlayIsOn()) return;
ADDRLP4 260
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 260
INDIRI4
CNSTI4 0
NEI4 $541
ADDRGP4 $540
JUMPV
LABELV $541
line 1321
;1320:	//if not addressed to this bot
;1321:	if (!BotAddressedToBot(bs, match)) return;
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 264
ADDRGP4 BotAddressedToBot
CALLI4
ASGNI4
ADDRLP4 264
INDIRI4
CNSTI4 0
NEI4 $543
ADDRGP4 $540
JUMPV
LABELV $543
line 1323
;1322:
;1323:	trap_BotMatchVariable(match, ENEMY, enemy, sizeof(enemy));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1325
;1324:	//
;1325:	client = FindEnemyByName(bs, enemy);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 268
ADDRGP4 FindEnemyByName
CALLI4
ASGNI4
ADDRLP4 256
ADDRLP4 268
INDIRI4
ASGNI4
line 1326
;1326:	if (client < 0) {
ADDRLP4 256
INDIRI4
CNSTI4 0
GEI4 $545
line 1327
;1327:		BotAI_BotInitialChat(bs, "whois", enemy, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $224
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1328
;1328:		trap_BotEnterChat(bs->cs, bs->client, CHAT_TEAM);
ADDRLP4 272
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 272
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 272
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1329
;1329:		return;
ADDRGP4 $540
JUMPV
LABELV $545
line 1331
;1330:	}
;1331:	bs->teamgoal.entitynum = client;
ADDRFP4 0
INDIRP4
CNSTI4 6336
ADDP4
ADDRLP4 256
INDIRI4
ASGNI4
line 1333
;1332:	//set the time to send a message to the team mates
;1333:	bs->teammessage_time = trap_AAS_Time() + 2 * random();
ADDRLP4 272
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRLP4 276
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6352
ADDP4
ADDRLP4 272
INDIRF4
CNSTF4 1073741824
ADDRLP4 276
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 1335
;1334:	//set the ltg type
;1335:	bs->ltgtype = LTG_KILL;
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
CNSTI4 11
ASGNI4
line 1337
;1336:	//set the team goal time
;1337:	bs->teamgoal_time = trap_AAS_Time() + TEAM_KILL_SOMEONE;
ADDRLP4 280
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6356
ADDP4
ADDRLP4 280
INDIRF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 1341
;1338:#ifdef DEBUG
;1339:	BotPrintTeamGoal(bs);
;1340:#endif //DEBUG
;1341:}
LABELV $540
endproc BotMatch_Kill 284 16
export BotMatch_CTF
proc BotMatch_CTF 176 16
line 1348
;1342:
;1343:/*
;1344:==================
;1345:BotMatch_CTF
;1346:==================
;1347:*/
;1348:void BotMatch_CTF(bot_state_t *bs, bot_match_t *match) {
line 1352
;1349:
;1350:	char flag[128], netname[MAX_NETNAME];
;1351:
;1352:	trap_BotMatchVariable(match, FLAG, flag, sizeof(flag));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1353
;1353:	if (match->subtype & ST_GOTFLAG) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $548
line 1354
;1354:		if (!Q_stricmp(flag, "red")) {
ADDRLP4 0
ARGP4
ADDRGP4 $512
ARGP4
ADDRLP4 164
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
NEI4 $550
line 1355
;1355:			bs->redflagstatus = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6492
ADDP4
CNSTI4 1
ASGNI4
line 1356
;1356:			if (BotCTFTeam(bs) == CTF_TEAM_BLUE) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 168
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 168
INDIRI4
CNSTI4 2
NEI4 $551
line 1357
;1357:				trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 128
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1358
;1358:				bs->flagcarrier = ClientFromName(netname);
ADDRLP4 128
ARGP4
ADDRLP4 172
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
ADDRLP4 172
INDIRI4
ASGNI4
line 1359
;1359:			}
line 1360
;1360:		}
ADDRGP4 $551
JUMPV
LABELV $550
line 1361
;1361:		else {
line 1362
;1362:			bs->blueflagstatus = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6496
ADDP4
CNSTI4 1
ASGNI4
line 1363
;1363:			if (BotCTFTeam(bs) == CTF_TEAM_RED) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 168
ADDRGP4 BotCTFTeam
CALLI4
ASGNI4
ADDRLP4 168
INDIRI4
CNSTI4 1
NEI4 $554
line 1364
;1364:				trap_BotMatchVariable(match, NETNAME, netname, sizeof(netname));
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 128
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 trap_BotMatchVariable
CALLV
pop
line 1365
;1365:				bs->flagcarrier = ClientFromName(netname);
ADDRLP4 128
ARGP4
ADDRLP4 172
ADDRGP4 ClientFromName
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
ADDRLP4 172
INDIRI4
ASGNI4
line 1366
;1366:			}
LABELV $554
line 1367
;1367:		}
LABELV $551
line 1368
;1368:		bs->flagstatuschanged = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6500
ADDP4
CNSTI4 1
ASGNI4
line 1369
;1369:		bs->lastflagcapture_time = trap_AAS_Time();
ADDRLP4 168
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6484
ADDP4
ADDRLP4 168
INDIRF4
ASGNF4
line 1370
;1370:	}
ADDRGP4 $549
JUMPV
LABELV $548
line 1371
;1371:	else if (match->subtype & ST_CAPTUREDFLAG) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 8192
BANDI4
CNSTI4 0
EQI4 $556
line 1372
;1372:		bs->redflagstatus = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6492
ADDP4
CNSTI4 0
ASGNI4
line 1373
;1373:		bs->blueflagstatus = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6496
ADDP4
CNSTI4 0
ASGNI4
line 1374
;1374:		bs->flagcarrier = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6508
ADDP4
CNSTI4 0
ASGNI4
line 1375
;1375:		bs->flagstatuschanged = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6500
ADDP4
CNSTI4 1
ASGNI4
line 1376
;1376:	}
ADDRGP4 $557
JUMPV
LABELV $556
line 1377
;1377:	else if (match->subtype & ST_RETURNEDFLAG) {
ADDRFP4 4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 16384
BANDI4
CNSTI4 0
EQI4 $558
line 1378
;1378:		if (!Q_stricmp(flag, "red")) bs->redflagstatus = 0;
ADDRLP4 0
ARGP4
ADDRGP4 $512
ARGP4
ADDRLP4 164
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
NEI4 $560
ADDRFP4 0
INDIRP4
CNSTI4 6492
ADDP4
CNSTI4 0
ASGNI4
ADDRGP4 $561
JUMPV
LABELV $560
line 1379
;1379:		else bs->blueflagstatus = 0;
ADDRFP4 0
INDIRP4
CNSTI4 6496
ADDP4
CNSTI4 0
ASGNI4
LABELV $561
line 1380
;1380:		bs->flagstatuschanged = 1;
ADDRFP4 0
INDIRP4
CNSTI4 6500
ADDP4
CNSTI4 1
ASGNI4
line 1381
;1381:	}
LABELV $558
LABELV $557
LABELV $549
line 1382
;1382:}
LABELV $547
endproc BotMatch_CTF 176 16
export BotMatchMessage
proc BotMatchMessage 340 12
line 1389
;1383:
;1384:/*
;1385:==================
;1386:BotMatchMessage
;1387:==================
;1388:*/
;1389:int BotMatchMessage(bot_state_t *bs, char *message) {
line 1392
;1390:	bot_match_t match;
;1391:
;1392:	match.type = 0;
ADDRLP4 0+256
CNSTI4 0
ASGNI4
line 1394
;1393:	//if it is an unknown message
;1394:	if (!trap_BotFindMatch(message, &match, MTCONTEXT_ENTERGAME
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
CNSTU4 262
ARGU4
ADDRLP4 328
ADDRGP4 trap_BotFindMatch
CALLI4
ASGNI4
ADDRLP4 328
INDIRI4
CNSTI4 0
NEI4 $564
line 1396
;1395:											|MTCONTEXT_INITIALTEAMCHAT
;1396:											|MTCONTEXT_CTF)) {
line 1397
;1397:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $562
JUMPV
LABELV $564
line 1400
;1398:	}
;1399:	//react to the found message
;1400:	switch(match.type)
ADDRLP4 332
ADDRLP4 0+256
INDIRI4
ASGNI4
ADDRLP4 336
CNSTI4 2
ASGNI4
ADDRLP4 332
INDIRI4
ADDRLP4 336
INDIRI4
LTI4 $566
ADDRLP4 332
INDIRI4
CNSTI4 30
GTI4 $600
ADDRLP4 332
INDIRI4
ADDRLP4 336
INDIRI4
LSHI4
ADDRGP4 $601-8
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $601
address $567
address $569
address $569
address $570
address $574
address $573
address $589
address $590
address $591
address $567
address $592
address $579
address $580
address $583
address $585
address $586
address $567
address $588
address $571
address $582
address $572
address $595
address $578
address $596
address $594
address $575
address $593
address $581
address $576
code
LABELV $600
ADDRLP4 0+256
INDIRI4
CNSTI4 300
EQI4 $577
ADDRGP4 $566
JUMPV
line 1401
;1401:	{
LABELV $569
line 1404
;1402:		case MSG_HELP:					//someone calling for help
;1403:		case MSG_ACCOMPANY:				//someone calling for company
;1404:		{
line 1405
;1405:			BotMatch_HelpAccompany(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_HelpAccompany
CALLV
pop
line 1406
;1406:			break;
ADDRGP4 $567
JUMPV
LABELV $570
line 1409
;1407:		}
;1408:		case MSG_DEFENDKEYAREA:			//teamplay defend a key area
;1409:		{
line 1410
;1410:			BotMatch_DefendKeyArea(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_DefendKeyArea
CALLV
pop
line 1411
;1411:			break;
ADDRGP4 $567
JUMPV
LABELV $571
line 1414
;1412:		}
;1413:		case MSG_CAMP:					//camp somewhere
;1414:		{
line 1415
;1415:			BotMatch_Camp(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_Camp
CALLV
pop
line 1416
;1416:			break;
ADDRGP4 $567
JUMPV
LABELV $572
line 1419
;1417:		}
;1418:		case MSG_PATROL:				//patrol between several key areas
;1419:		{
line 1420
;1420:			BotMatch_Patrol(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_Patrol
CALLV
pop
line 1421
;1421:			break;
ADDRGP4 $567
JUMPV
LABELV $573
line 1425
;1422:		}
;1423:#ifdef CTF
;1424:		case MSG_GETFLAG:				//ctf get the enemy flag
;1425:		{
line 1426
;1426:			BotMatch_GetFlag(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_GetFlag
CALLV
pop
line 1427
;1427:			break;
ADDRGP4 $567
JUMPV
LABELV $574
line 1430
;1428:		}
;1429:		case MSG_RUSHBASE:				//ctf rush to the base
;1430:		{
line 1431
;1431:			BotMatch_RushBase(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_RushBase
CALLV
pop
line 1432
;1432:			break;
ADDRGP4 $567
JUMPV
LABELV $575
line 1435
;1433:		}
;1434:		case MSG_RETURNFLAG:
;1435:		{
line 1436
;1436:			BotMatch_ReturnFlag(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_ReturnFlag
CALLV
pop
line 1437
;1437:			break;
ADDRGP4 $567
JUMPV
LABELV $576
line 1440
;1438:		}
;1439:		case MSG_CTFTASKPREFERENCE:
;1440:		{
line 1441
;1441:			BotMatch_TaskPreference(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_TaskPreference
CALLV
pop
line 1442
;1442:			break;
ADDRGP4 $567
JUMPV
LABELV $577
line 1445
;1443:		}
;1444:		case MSG_CTF:
;1445:		{
line 1446
;1446:			BotMatch_CTF(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_CTF
CALLV
pop
line 1447
;1447:			break;
ADDRGP4 $567
JUMPV
LABELV $578
line 1451
;1448:		}
;1449:#endif //CTF
;1450:		case MSG_GETITEM:
;1451:		{
line 1452
;1452:			BotMatch_GetItem(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_GetItem
CALLV
pop
line 1453
;1453:			break;
ADDRGP4 $567
JUMPV
LABELV $579
line 1456
;1454:		}
;1455:		case MSG_JOINSUBTEAM:			//join a sub team
;1456:		{
line 1457
;1457:			BotMatch_JoinSubteam(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_JoinSubteam
CALLV
pop
line 1458
;1458:			break;
ADDRGP4 $567
JUMPV
LABELV $580
line 1461
;1459:		}
;1460:		case MSG_LEAVESUBTEAM:			//leave a sub team
;1461:		{
line 1462
;1462:			BotMatch_LeaveSubteam(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_LeaveSubteam
CALLV
pop
line 1463
;1463:			break;
ADDRGP4 $567
JUMPV
LABELV $581
line 1466
;1464:		}
;1465:		case MSG_WHICHTEAM:
;1466:		{
line 1467
;1467:			BotMatch_WhichTeam(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_WhichTeam
CALLV
pop
line 1468
;1468:			break;
ADDRGP4 $567
JUMPV
LABELV $582
line 1471
;1469:		}
;1470:		case MSG_CHECKPOINT:			//remember a check point
;1471:		{
line 1472
;1472:			BotMatch_CheckPoint(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_CheckPoint
CALLV
pop
line 1473
;1473:			break;
ADDRGP4 $567
JUMPV
LABELV $583
line 1476
;1474:		}
;1475:		case MSG_CREATENEWFORMATION:	//start the creation of a new formation
;1476:		{
line 1477
;1477:			trap_EA_SayTeam(bs->client, "the part of my brain to create formations has been damaged");
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $584
ARGP4
ADDRGP4 trap_EA_SayTeam
CALLV
pop
line 1478
;1478:			break;
ADDRGP4 $567
JUMPV
LABELV $585
line 1481
;1479:		}
;1480:		case MSG_FORMATIONPOSITION:		//tell someone his/her position in the formation
;1481:		{
line 1482
;1482:			trap_EA_SayTeam(bs->client, "the part of my brain to create formations has been damaged");
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $584
ARGP4
ADDRGP4 trap_EA_SayTeam
CALLV
pop
line 1483
;1483:			break;
ADDRGP4 $567
JUMPV
LABELV $586
line 1486
;1484:		}
;1485:		case MSG_FORMATIONSPACE:		//set the formation space
;1486:		{
line 1487
;1487:			BotMatch_FormationSpace(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_FormationSpace
CALLV
pop
line 1488
;1488:			break;
ADDRGP4 $567
JUMPV
line 1491
;1489:		}
;1490:		case MSG_DOFORMATION:			//form a certain formation
;1491:		{
line 1492
;1492:			break;
LABELV $588
line 1495
;1493:		}
;1494:		case MSG_DISMISS:				//dismiss someone
;1495:		{
line 1496
;1496:			BotMatch_Dismiss(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_Dismiss
CALLV
pop
line 1497
;1497:			break;
ADDRGP4 $567
JUMPV
LABELV $589
line 1500
;1498:		}
;1499:		case MSG_STARTTEAMLEADERSHIP:	//someone will become the team leader
;1500:		{
line 1501
;1501:			BotMatch_StartTeamLeaderShip(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_StartTeamLeaderShip
CALLV
pop
line 1502
;1502:			break;
ADDRGP4 $567
JUMPV
LABELV $590
line 1505
;1503:		}
;1504:		case MSG_STOPTEAMLEADERSHIP:	//someone will stop being the team leader
;1505:		{
line 1506
;1506:			BotMatch_StopTeamLeaderShip(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_StopTeamLeaderShip
CALLV
pop
line 1507
;1507:			break;
ADDRGP4 $567
JUMPV
LABELV $591
line 1510
;1508:		}
;1509:		case MSG_WHOISTEAMLAEDER:
;1510:		{
line 1511
;1511:			BotMatch_WhoIsTeamLeader(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_WhoIsTeamLeader
CALLV
pop
line 1512
;1512:			break;
ADDRGP4 $567
JUMPV
LABELV $592
line 1515
;1513:		}
;1514:		case MSG_WHATAREYOUDOING:		//ask a bot what he/she is doing
;1515:		{
line 1516
;1516:			BotMatch_WhatAreYouDoing(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_WhatAreYouDoing
CALLV
pop
line 1517
;1517:			break;
ADDRGP4 $567
JUMPV
LABELV $593
line 1520
;1518:		}
;1519:		case MSG_WHATISMYCOMMAND:
;1520:		{
line 1521
;1521:			BotMatch_WhatIsMyCommand(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_WhatIsMyCommand
CALLV
pop
line 1522
;1522:			break;
ADDRGP4 $567
JUMPV
LABELV $594
line 1525
;1523:		}
;1524:		case MSG_WHEREAREYOU:
;1525:		{
line 1526
;1526:			BotMatch_WhereAreYou(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_WhereAreYou
CALLV
pop
line 1527
;1527:			break;
ADDRGP4 $567
JUMPV
LABELV $595
line 1530
;1528:		}
;1529:		case MSG_LEADTHEWAY:
;1530:		{
line 1531
;1531:			BotMatch_LeadTheWay(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_LeadTheWay
CALLV
pop
line 1532
;1532:			break;
ADDRGP4 $567
JUMPV
LABELV $596
line 1535
;1533:		}
;1534:		case MSG_KILL:
;1535:		{
line 1536
;1536:			BotMatch_Kill(bs, &match);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 BotMatch_Kill
CALLV
pop
line 1537
;1537:			break;
ADDRGP4 $567
JUMPV
line 1540
;1538:		}
;1539:		case MSG_ENTERGAME:				//someone entered the game
;1540:		{
line 1545
;1541:			//NOTE: eliza chats will catch this
;1542:			//BotMatchVariable(&match, NETNAME, netname);
;1543:			//Com_sprintf(buf, sizeof(buf), "heya %s", netname);
;1544:			//EA_Say(bs->client, buf);
;1545:			break;
line 1548
;1546:		}
;1547:		case MSG_WAIT:
;1548:		{
line 1549
;1549:			break;
LABELV $566
line 1552
;1550:		}
;1551:		default:
;1552:		{
line 1553
;1553:			BotAI_Print(PRT_MESSAGE, "unknown match type\n");
CNSTI4 1
ARGI4
ADDRGP4 $599
ARGP4
ADDRGP4 BotAI_Print
CALLV
pop
line 1554
;1554:			break;
LABELV $567
line 1557
;1555:		}
;1556:	}
;1557:	return qtrue;
CNSTI4 1
RETI4
LABELV $562
endproc BotMatchMessage 340 12
import BotSetTeamMateCTFPreference
import BotGetTeamMateCTFPreference
import BotTeamAI
import BotDumpNodeSwitches
import BotResetNodeSwitches
import AINode_Battle_NBG
import AINode_Battle_Retreat
import AINode_Battle_Chase
import AINode_Battle_Fight
import AINode_Seek_LTG
import AINode_Seek_NBG
import AINode_Seek_ActivateEntity
import AINode_Stand
import AINode_Respawn
import AINode_Observer
import AINode_Intermission
import AIEnter_Battle_NBG
import AIEnter_Battle_Retreat
import AIEnter_Battle_Chase
import AIEnter_Battle_Fight
import AIEnter_Seek_Camp
import AIEnter_Seek_LTG
import AIEnter_Seek_NBG
import AIEnter_Seek_ActivateEntity
import AIEnter_Stand
import AIEnter_Respawn
import AIEnter_Observer
import AIEnter_Intermission
import BotPrintTeamGoal
import BotChatTest
import BotValidChatPosition
import BotChatTime
import BotChat_Random
import BotChat_EnemySuicide
import BotChat_Kill
import BotChat_Death
import BotChat_HitNoKill
import BotChat_HitNoDeath
import BotChat_HitTalking
import BotChat_EndLevel
import BotChat_StartLevel
import BotChat_ExitGame
import BotChat_EnterGame
import ctf_blueflag
import ctf_redflag
import bot_challenge
import bot_testrchat
import bot_nochat
import bot_fastchat
import bot_rocketjump
import bot_grapple
import maxclients
import gametype
import BotMapScripts
import BotPointAreaNum
import ClientFromName
import stristr
import BotFindWayPoint
import BotCreateWayPoint
import BotCTFRetreatGoals
import BotCTFSeekGoals
import BotCTFCarryingFlag
import BotCTFTeam
import BotAIBlocked
import BotCheckAttack
import BotAimAtEnemy
import BotEntityVisible
import BotRoamGoal
import BotFindEnemy
import BotTeamFlagCarrierVisible
import TeamPlayIsOn
import BotSameTeam
import BotAttackMove
import BotWantsToCamp
import BotCanAndWantsToRocketJump
import BotWantsToHelp
import BotWantsToChase
import BotWantsToRetreat
import BotAggression
import ClientSkin
import EasyClientName
import ClientName
import EntityIsShooting
import EntityIsInvisible
import EntityIsDead
import BotInLavaOrSlime
import BotIntermission
import BotIsObserver
import BotIsDead
import BotBattleUseItems
import BotUpdateBattleInventory
import BotUpdateInventory
import BotSetupForMovement
import BotChooseWeapon
import BotFreeWaypoints
import BotDeathmatchAI
import BotShutdownDeathmatchAI
import BotSetupDeathmatchAI
import BotTeamLeader
import BotAI_GetSnapshotEntity
import BotAI_GetEntityState
import BotAI_GetClientState
import BotAI_Trace
import BotAI_BotInitialChat
import BotAI_Print
import BotEntityInfo
import NumBots
import BotResetState
import BotResetWeaponState
import BotFreeWeaponState
import BotAllocWeaponState
import BotLoadWeaponWeights
import BotGetWeaponInfo
import BotChooseBestFightWeapon
import BotShutdownWeaponAI
import BotSetupWeaponAI
import BotShutdownMoveAI
import BotSetupMoveAI
import BotSetBrushModelTypes
import BotInitMoveState
import BotFreeMoveState
import BotAllocMoveState
import BotPredictVisiblePosition
import BotMovementViewTarget
import BotReachabilityArea
import BotResetLastAvoidReach
import BotResetAvoidReach
import BotMoveInDirection
import BotMoveToGoal
import BotResetMoveState
import BotShutdownGoalAI
import BotSetupGoalAI
import BotFreeGoalState
import BotAllocGoalState
import BotFreeItemWeights
import BotLoadItemWeights
import BotMutateGoalFuzzyLogic
import BotSaveGoalFuzzyLogic
import BotInterbreedGoalFuzzyLogic
import BotUpdateEntityItems
import BotInitLevelItems
import BotAvoidGoalTime
import BotGetMapLocationGoal
import BotGetNextCampSpotGoal
import BotGetLevelItemGoal
import BotItemGoalInVisButNotVisible
import BotTouchingGoal
import BotChooseNBGItem
import BotChooseLTGItem
import BotGetSecondGoal
import BotGetTopGoal
import BotGoalName
import BotDumpGoalStack
import BotDumpAvoidGoals
import BotEmptyGoalStack
import BotPopGoal
import BotPushGoal
import BotRemoveFromAvoidGoals
import BotResetAvoidGoals
import BotResetGoalState
import GeneticParentsAndChildSelection
import BotSetChatName
import BotSetChatGender
import BotLoadChatFile
import BotReplaceSynonyms
import UnifyWhiteSpaces
import BotMatchVariable
import BotFindMatch
import StringContains
import BotGetChatMessage
import BotEnterChat
import BotChatLength
import BotReplyChat
import BotNumInitialChats
import BotInitialChat
import BotNumConsoleMessages
import BotNextConsoleMessage
import BotRemoveConsoleMessage
import BotQueueConsoleMessage
import BotFreeChatState
import BotAllocChatState
import BotShutdownChatAI
import BotSetupChatAI
import BotShutdownCharacters
import Characteristic_String
import Characteristic_BInteger
import Characteristic_Integer
import Characteristic_BFloat
import Characteristic_Float
import BotFreeCharacter
import BotLoadCharacter
import EA_Shutdown
import EA_Setup
import EA_ResetInput
import EA_GetInput
import EA_EndRegular
import EA_View
import EA_Move
import EA_MoveRight
import EA_MoveLeft
import EA_MoveBack
import EA_MoveForward
import EA_MoveDown
import EA_MoveUp
import EA_Walk
import EA_Crouch
import EA_DelayedJump
import EA_Jump
import EA_Use
import EA_Gesture
import EA_Talk
import EA_Respawn
import EA_Attack
import EA_SelectWeapon
import EA_Command
import EA_DropInv
import EA_UseInv
import EA_DropItem
import EA_UseItem
import EA_SayTeam
import EA_Say
import GetBotLibAPI
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $599
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 109
byte 1 97
byte 1 116
byte 1 99
byte 1 104
byte 1 32
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $584
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 112
byte 1 97
byte 1 114
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 109
byte 1 121
byte 1 32
byte 1 98
byte 1 114
byte 1 97
byte 1 105
byte 1 110
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 99
byte 1 114
byte 1 101
byte 1 97
byte 1 116
byte 1 101
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 109
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 115
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 98
byte 1 101
byte 1 101
byte 1 110
byte 1 32
byte 1 100
byte 1 97
byte 1 109
byte 1 97
byte 1 103
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $516
byte 1 108
byte 1 111
byte 1 99
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $515
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $512
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $511
byte 1 99
byte 1 116
byte 1 102
byte 1 108
byte 1 111
byte 1 99
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $490
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $489
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $488
byte 1 72
byte 1 101
byte 1 97
byte 1 118
byte 1 121
byte 1 32
byte 1 65
byte 1 114
byte 1 109
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $487
byte 1 65
byte 1 114
byte 1 109
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $486
byte 1 70
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $485
byte 1 73
byte 1 110
byte 1 118
byte 1 105
byte 1 115
byte 1 105
byte 1 98
byte 1 105
byte 1 108
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $484
byte 1 83
byte 1 112
byte 1 101
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $483
byte 1 66
byte 1 97
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 32
byte 1 83
byte 1 117
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $482
byte 1 82
byte 1 101
byte 1 103
byte 1 101
byte 1 110
byte 1 101
byte 1 114
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $481
byte 1 81
byte 1 117
byte 1 97
byte 1 100
byte 1 32
byte 1 68
byte 1 97
byte 1 109
byte 1 97
byte 1 103
byte 1 101
byte 1 0
align 1
LABELV $480
byte 1 66
byte 1 70
byte 1 71
byte 1 49
byte 1 48
byte 1 75
byte 1 0
align 1
LABELV $479
byte 1 76
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 71
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $478
byte 1 82
byte 1 97
byte 1 105
byte 1 108
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $477
byte 1 80
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $476
byte 1 82
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 32
byte 1 76
byte 1 97
byte 1 117
byte 1 110
byte 1 99
byte 1 104
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $475
byte 1 71
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 32
byte 1 76
byte 1 97
byte 1 117
byte 1 110
byte 1 99
byte 1 104
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $474
byte 1 83
byte 1 104
byte 1 111
byte 1 116
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $450
byte 1 114
byte 1 111
byte 1 97
byte 1 109
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $449
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $447
byte 1 114
byte 1 117
byte 1 115
byte 1 104
byte 1 105
byte 1 110
byte 1 103
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $445
byte 1 99
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $443
byte 1 112
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $441
byte 1 99
byte 1 97
byte 1 109
byte 1 112
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $439
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $437
byte 1 103
byte 1 101
byte 1 116
byte 1 116
byte 1 105
byte 1 110
byte 1 103
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 0
align 1
LABELV $435
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $433
byte 1 97
byte 1 99
byte 1 99
byte 1 111
byte 1 109
byte 1 112
byte 1 97
byte 1 110
byte 1 121
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $431
byte 1 104
byte 1 101
byte 1 108
byte 1 112
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $423
byte 1 73
byte 1 39
byte 1 109
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 108
byte 1 101
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 10
byte 1 0
align 1
LABELV $401
byte 1 100
byte 1 105
byte 1 115
byte 1 109
byte 1 105
byte 1 115
byte 1 115
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $385
byte 1 99
byte 1 104
byte 1 101
byte 1 99
byte 1 107
byte 1 112
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 95
byte 1 99
byte 1 111
byte 1 110
byte 1 102
byte 1 105
byte 1 114
byte 1 109
byte 1 0
align 1
LABELV $384
byte 1 37
byte 1 49
byte 1 46
byte 1 48
byte 1 102
byte 1 32
byte 1 37
byte 1 49
byte 1 46
byte 1 48
byte 1 102
byte 1 32
byte 1 37
byte 1 49
byte 1 46
byte 1 48
byte 1 102
byte 1 0
align 1
LABELV $373
byte 1 99
byte 1 104
byte 1 101
byte 1 99
byte 1 107
byte 1 112
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 95
byte 1 105
byte 1 110
byte 1 118
byte 1 97
byte 1 108
byte 1 105
byte 1 100
byte 1 0
align 1
LABELV $365
byte 1 37
byte 1 102
byte 1 32
byte 1 37
byte 1 102
byte 1 32
byte 1 37
byte 1 102
byte 1 0
align 1
LABELV $359
byte 1 110
byte 1 111
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $358
byte 1 105
byte 1 110
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $350
byte 1 0
align 1
LABELV $349
byte 1 108
byte 1 101
byte 1 102
byte 1 116
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $341
byte 1 106
byte 1 111
byte 1 105
byte 1 110
byte 1 101
byte 1 100
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $330
byte 1 107
byte 1 101
byte 1 101
byte 1 112
byte 1 105
byte 1 110
byte 1 109
byte 1 105
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $244
byte 1 119
byte 1 104
byte 1 101
byte 1 114
byte 1 101
byte 1 97
byte 1 114
byte 1 101
byte 1 121
byte 1 111
byte 1 117
byte 1 0
align 1
LABELV $243
byte 1 119
byte 1 104
byte 1 101
byte 1 114
byte 1 101
byte 1 105
byte 1 115
byte 1 0
align 1
LABELV $224
byte 1 119
byte 1 104
byte 1 111
byte 1 105
byte 1 115
byte 1 0
align 1
LABELV $207
byte 1 37
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $161
byte 1 73
byte 1 32
byte 1 110
byte 1 101
byte 1 101
byte 1 100
byte 1 32
byte 1 109
byte 1 111
byte 1 114
byte 1 101
byte 1 32
byte 1 107
byte 1 101
byte 1 121
byte 1 32
byte 1 112
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 115
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 112
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 10
byte 1 0
align 1
LABELV $138
byte 1 119
byte 1 104
byte 1 97
byte 1 116
byte 1 32
byte 1 100
byte 1 111
byte 1 32
byte 1 121
byte 1 111
byte 1 117
byte 1 32
byte 1 115
byte 1 97
byte 1 121
byte 1 63
byte 1 0
align 1
LABELV $82
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
