bss
align 4
LABELV $48
skip 4
export BotNumActivePlayers
code
proc BotNumActivePlayers 1056 12
file "..\ai_chat.c"
line 45
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:/*****************************************************************************
;5: * name:		ai_chat.c
;6: *
;7: * desc:		Quake3 bot AI
;8: *
;9: * $Archive: /source/code/game/ai_chat.c $
;10: * $Author: Raduffy $ 
;11: * $Revision: 5 $
;12: * $Modtime: 1/14/00 5:27p $
;13: * $Date: 1/14/00 5:35p $
;14: *
;15: *****************************************************************************/
;16:
;17:#include "g_local.h"
;18:#include "botlib.h"
;19:#include "be_aas.h"
;20:#include "be_ea.h"
;21:#include "be_ai_char.h"
;22:#include "be_ai_chat.h"
;23:#include "be_ai_gen.h"
;24:#include "be_ai_goal.h"
;25:#include "be_ai_move.h"
;26:#include "be_ai_weap.h"
;27://
;28:#include "ai_main.h"
;29:#include "ai_dmq3.h"
;30:#include "ai_chat.h"
;31:#include "ai_cmd.h"
;32:#include "ai_dmnet.h"
;33://
;34:#include "chars.h"				//characteristics
;35:#include "inv.h"				//indexes into the inventory
;36:#include "syn.h"				//synonyms
;37:#include "match.h"				//string matching types and vars
;38:
;39:
;40:/*
;41:==================
;42:BotNumActivePlayers
;43:==================
;44:*/
;45:int BotNumActivePlayers(void) {
line 50
;46:	int i, num;
;47:	char buf[MAX_INFO_STRING];
;48:	static int maxclients;
;49:
;50:	if (!maxclients)
ADDRGP4 $48
INDIRI4
CNSTI4 0
NEI4 $49
line 51
;51:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $51
ARGP4
ADDRLP4 1032
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $48
ADDRLP4 1032
INDIRI4
ASGNI4
LABELV $49
line 53
;52:
;53:	num = 0;
ADDRLP4 1028
CNSTI4 0
ASGNI4
line 54
;54:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 1024
CNSTI4 0
ASGNI4
ADDRGP4 $55
JUMPV
LABELV $52
line 55
;55:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 1024
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 57
;56:		//if no config string or no name
;57:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 0
ARGP4
ADDRLP4 1036
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1036
INDIRU4
CNSTU4 0
EQU4 $59
ADDRLP4 0
ARGP4
ADDRGP4 $58
ARGP4
ADDRLP4 1040
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1040
INDIRP4
ARGP4
ADDRLP4 1044
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1044
INDIRU4
CNSTU4 0
NEU4 $56
LABELV $59
ADDRGP4 $53
JUMPV
LABELV $56
line 59
;58:		//skip spectators
;59:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 0
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1048
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1048
INDIRP4
ARGP4
ADDRLP4 1052
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 3
NEI4 $60
ADDRGP4 $53
JUMPV
LABELV $60
line 61
;60:		//
;61:		num++;
ADDRLP4 1028
ADDRLP4 1028
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 62
;62:	}
LABELV $53
line 54
ADDRLP4 1024
ADDRLP4 1024
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $55
ADDRLP4 1024
INDIRI4
ADDRGP4 $48
INDIRI4
GEI4 $63
ADDRLP4 1024
INDIRI4
CNSTI4 128
LTI4 $52
LABELV $63
line 63
;63:	return num;
ADDRLP4 1028
INDIRI4
RETI4
LABELV $47
endproc BotNumActivePlayers 1056 12
bss
align 4
LABELV $65
skip 4
export BotIsFirstInRankings
code
proc BotIsFirstInRankings 1500 12
line 71
;64:}
;65:
;66:/*
;67:==================
;68:BotIsFirstInRankings
;69:==================
;70:*/
;71:int BotIsFirstInRankings(bot_state_t *bs) {
line 77
;72:	int i, score;
;73:	char buf[MAX_INFO_STRING];
;74:	static int maxclients;
;75:	playerState_t ps;
;76:
;77:	if (!maxclients)
ADDRGP4 $65
INDIRI4
CNSTI4 0
NEI4 $66
line 78
;78:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $51
ARGP4
ADDRLP4 1476
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $65
ADDRLP4 1476
INDIRI4
ASGNI4
LABELV $66
line 80
;79:
;80:	score = bs->cur_ps.persistant[PERS_SCORE];
ADDRLP4 1472
ADDRFP4 0
INDIRP4
CNSTI4 264
ADDP4
INDIRI4
ASGNI4
line 81
;81:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $71
JUMPV
LABELV $68
line 82
;82:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 84
;83:		//if no config string or no name
;84:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1480
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1480
INDIRU4
CNSTU4 0
EQU4 $74
ADDRLP4 4
ARGP4
ADDRGP4 $58
ARGP4
ADDRLP4 1484
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1484
INDIRP4
ARGP4
ADDRLP4 1488
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1488
INDIRU4
CNSTU4 0
NEU4 $72
LABELV $74
ADDRGP4 $69
JUMPV
LABELV $72
line 86
;85:		//skip spectators
;86:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 4
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1492
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1492
INDIRP4
ARGP4
ADDRLP4 1496
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1496
INDIRI4
CNSTI4 3
NEI4 $75
ADDRGP4 $69
JUMPV
LABELV $75
line 88
;87:		//
;88:		BotAI_GetClientState(i, &ps);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1028
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
line 89
;89:		if (score < ps.persistant[PERS_SCORE]) return qfalse;
ADDRLP4 1472
INDIRI4
ADDRLP4 1028+248
INDIRI4
GEI4 $77
CNSTI4 0
RETI4
ADDRGP4 $64
JUMPV
LABELV $77
line 90
;90:	}
LABELV $69
line 81
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $71
ADDRLP4 0
INDIRI4
ADDRGP4 $65
INDIRI4
GEI4 $80
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $68
LABELV $80
line 91
;91:	return qtrue;
CNSTI4 1
RETI4
LABELV $64
endproc BotIsFirstInRankings 1500 12
bss
align 4
LABELV $82
skip 4
export BotIsLastInRankings
code
proc BotIsLastInRankings 1500 12
line 99
;92:}
;93:
;94:/*
;95:==================
;96:BotIsLastInRankings
;97:==================
;98:*/
;99:int BotIsLastInRankings(bot_state_t *bs) {
line 105
;100:	int i, score;
;101:	char buf[MAX_INFO_STRING];
;102:	static int maxclients;
;103:	playerState_t ps;
;104:
;105:	if (!maxclients)
ADDRGP4 $82
INDIRI4
CNSTI4 0
NEI4 $83
line 106
;106:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $51
ARGP4
ADDRLP4 1476
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $82
ADDRLP4 1476
INDIRI4
ASGNI4
LABELV $83
line 108
;107:
;108:	score = bs->cur_ps.persistant[PERS_SCORE];
ADDRLP4 1472
ADDRFP4 0
INDIRP4
CNSTI4 264
ADDP4
INDIRI4
ASGNI4
line 109
;109:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $88
JUMPV
LABELV $85
line 110
;110:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 112
;111:		//if no config string or no name
;112:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1480
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1480
INDIRU4
CNSTU4 0
EQU4 $91
ADDRLP4 4
ARGP4
ADDRGP4 $58
ARGP4
ADDRLP4 1484
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1484
INDIRP4
ARGP4
ADDRLP4 1488
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1488
INDIRU4
CNSTU4 0
NEU4 $89
LABELV $91
ADDRGP4 $86
JUMPV
LABELV $89
line 114
;113:		//skip spectators
;114:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 4
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1492
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1492
INDIRP4
ARGP4
ADDRLP4 1496
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1496
INDIRI4
CNSTI4 3
NEI4 $92
ADDRGP4 $86
JUMPV
LABELV $92
line 116
;115:		//
;116:		BotAI_GetClientState(i, &ps);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1028
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
line 117
;117:		if (score > ps.persistant[PERS_SCORE]) return qfalse;
ADDRLP4 1472
INDIRI4
ADDRLP4 1028+248
INDIRI4
LEI4 $94
CNSTI4 0
RETI4
ADDRGP4 $81
JUMPV
LABELV $94
line 118
;118:	}
LABELV $86
line 109
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $88
ADDRLP4 0
INDIRI4
ADDRGP4 $82
INDIRI4
GEI4 $97
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $85
LABELV $97
line 119
;119:	return qtrue;
CNSTI4 1
RETI4
LABELV $81
endproc BotIsLastInRankings 1500 12
bss
align 1
LABELV $99
skip 32
align 4
LABELV $100
skip 4
export BotFirstClientInRankings
code
proc BotFirstClientInRankings 1504 12
line 127
;120:}
;121:
;122:/*
;123:==================
;124:BotFirstClientInRankings
;125:==================
;126:*/
;127:char *BotFirstClientInRankings(void) {
line 134
;128:	int i, bestscore, bestclient;
;129:	char buf[MAX_INFO_STRING];
;130:	static char name[32];
;131:	static int maxclients;
;132:	playerState_t ps;
;133:
;134:	if (!maxclients)
ADDRGP4 $100
INDIRI4
CNSTI4 0
NEI4 $101
line 135
;135:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $51
ARGP4
ADDRLP4 1480
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $100
ADDRLP4 1480
INDIRI4
ASGNI4
LABELV $101
line 137
;136:
;137:	bestscore = -999999;
ADDRLP4 1472
CNSTI4 -999999
ASGNI4
line 138
;138:	bestclient = 0;
ADDRLP4 1476
CNSTI4 0
ASGNI4
line 139
;139:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $106
JUMPV
LABELV $103
line 140
;140:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 142
;141:		//if no config string or no name
;142:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1484
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1484
INDIRU4
CNSTU4 0
EQU4 $109
ADDRLP4 4
ARGP4
ADDRGP4 $58
ARGP4
ADDRLP4 1488
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1488
INDIRP4
ARGP4
ADDRLP4 1492
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1492
INDIRU4
CNSTU4 0
NEU4 $107
LABELV $109
ADDRGP4 $104
JUMPV
LABELV $107
line 144
;143:		//skip spectators
;144:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 4
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1496
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1496
INDIRP4
ARGP4
ADDRLP4 1500
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1500
INDIRI4
CNSTI4 3
NEI4 $110
ADDRGP4 $104
JUMPV
LABELV $110
line 146
;145:		//
;146:		BotAI_GetClientState(i, &ps);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1028
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
line 147
;147:		if (ps.persistant[PERS_SCORE] > bestscore) {
ADDRLP4 1028+248
INDIRI4
ADDRLP4 1472
INDIRI4
LEI4 $112
line 148
;148:			bestscore = ps.persistant[PERS_SCORE];
ADDRLP4 1472
ADDRLP4 1028+248
INDIRI4
ASGNI4
line 149
;149:			bestclient = i;
ADDRLP4 1476
ADDRLP4 0
INDIRI4
ASGNI4
line 150
;150:		}
LABELV $112
line 151
;151:	}
LABELV $104
line 139
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $106
ADDRLP4 0
INDIRI4
ADDRGP4 $100
INDIRI4
GEI4 $116
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $103
LABELV $116
line 152
;152:	EasyClientName(bestclient, name, 32);
ADDRLP4 1476
INDIRI4
ARGI4
ADDRGP4 $99
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 153
;153:	return name;
ADDRGP4 $99
RETP4
LABELV $98
endproc BotFirstClientInRankings 1504 12
bss
align 1
LABELV $118
skip 32
align 4
LABELV $119
skip 4
export BotLastClientInRankings
code
proc BotLastClientInRankings 1504 12
line 161
;154:}
;155:
;156:/*
;157:==================
;158:BotLastClientInRankings
;159:==================
;160:*/
;161:char *BotLastClientInRankings(void) {
line 168
;162:	int i, worstscore, bestclient;
;163:	char buf[MAX_INFO_STRING];
;164:	static char name[32];
;165:	static int maxclients;
;166:	playerState_t ps;
;167:
;168:	if (!maxclients)
ADDRGP4 $119
INDIRI4
CNSTI4 0
NEI4 $120
line 169
;169:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $51
ARGP4
ADDRLP4 1480
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $119
ADDRLP4 1480
INDIRI4
ASGNI4
LABELV $120
line 171
;170:
;171:	worstscore = 999999;
ADDRLP4 1472
CNSTI4 999999
ASGNI4
line 172
;172:	bestclient = 0;
ADDRLP4 1476
CNSTI4 0
ASGNI4
line 173
;173:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $125
JUMPV
LABELV $122
line 174
;174:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 176
;175:		//if no config string or no name
;176:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1484
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1484
INDIRU4
CNSTU4 0
EQU4 $128
ADDRLP4 4
ARGP4
ADDRGP4 $58
ARGP4
ADDRLP4 1488
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1488
INDIRP4
ARGP4
ADDRLP4 1492
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1492
INDIRU4
CNSTU4 0
NEU4 $126
LABELV $128
ADDRGP4 $123
JUMPV
LABELV $126
line 178
;177:		//skip spectators
;178:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 4
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1496
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1496
INDIRP4
ARGP4
ADDRLP4 1500
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1500
INDIRI4
CNSTI4 3
NEI4 $129
ADDRGP4 $123
JUMPV
LABELV $129
line 180
;179:		//
;180:		BotAI_GetClientState(i, &ps);
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1028
ARGP4
ADDRGP4 BotAI_GetClientState
CALLI4
pop
line 181
;181:		if (ps.persistant[PERS_SCORE] < worstscore) {
ADDRLP4 1028+248
INDIRI4
ADDRLP4 1472
INDIRI4
GEI4 $131
line 182
;182:			worstscore = ps.persistant[PERS_SCORE];
ADDRLP4 1472
ADDRLP4 1028+248
INDIRI4
ASGNI4
line 183
;183:			bestclient = i;
ADDRLP4 1476
ADDRLP4 0
INDIRI4
ASGNI4
line 184
;184:		}
LABELV $131
line 185
;185:	}
LABELV $123
line 173
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $125
ADDRLP4 0
INDIRI4
ADDRGP4 $119
INDIRI4
GEI4 $135
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $122
LABELV $135
line 186
;186:	EasyClientName(bestclient, name, 32);
ADDRLP4 1476
INDIRI4
ARGI4
ADDRGP4 $118
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 187
;187:	return name;
ADDRGP4 $118
RETP4
LABELV $117
endproc BotLastClientInRankings 1504 12
bss
align 4
LABELV $137
skip 4
align 1
LABELV $138
skip 32
export BotRandomOpponentName
code
proc BotRandomOpponentName 1576 12
line 195
;188:}
;189:
;190:/*
;191:==================
;192:BotRandomOpponentName
;193:==================
;194:*/
;195:char *BotRandomOpponentName(bot_state_t *bs) {
line 202
;196:	int i, count;
;197:	char buf[MAX_INFO_STRING];
;198:	int opponents[MAX_CLIENTS], numopponents;
;199:	static int maxclients;
;200:	static char name[32];
;201:
;202:	if (!maxclients)
ADDRGP4 $137
INDIRI4
CNSTI4 0
NEI4 $139
line 203
;203:		maxclients = trap_Cvar_VariableIntegerValue("sv_maxclients");
ADDRGP4 $51
ARGP4
ADDRLP4 1548
ADDRGP4 trap_Cvar_VariableIntegerValue
CALLI4
ASGNI4
ADDRGP4 $137
ADDRLP4 1548
INDIRI4
ASGNI4
LABELV $139
line 205
;204:
;205:	numopponents = 0;
ADDRLP4 1028
CNSTI4 0
ASGNI4
line 206
;206:	opponents[0] = 0;
ADDRLP4 1036
CNSTI4 0
ASGNI4
line 207
;207:	for (i = 0; i < maxclients && i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $144
JUMPV
LABELV $141
line 208
;208:		if (i == bs->client) continue;
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $145
ADDRGP4 $142
JUMPV
LABELV $145
line 210
;209:		//
;210:		trap_GetConfigstring(CS_PLAYERS+i, buf, sizeof(buf));
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetConfigstring
CALLV
pop
line 212
;211:		//if no config string or no name
;212:		if (!strlen(buf) || !strlen(Info_ValueForKey(buf, "n"))) continue;
ADDRLP4 4
ARGP4
ADDRLP4 1552
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1552
INDIRU4
CNSTU4 0
EQU4 $149
ADDRLP4 4
ARGP4
ADDRGP4 $58
ARGP4
ADDRLP4 1556
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1556
INDIRP4
ARGP4
ADDRLP4 1560
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 1560
INDIRU4
CNSTU4 0
NEU4 $147
LABELV $149
ADDRGP4 $142
JUMPV
LABELV $147
line 214
;213:		//skip spectators
;214:		if (atoi(Info_ValueForKey(buf, "t")) == TEAM_SPECTATOR) continue;
ADDRLP4 4
ARGP4
ADDRGP4 $62
ARGP4
ADDRLP4 1564
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1564
INDIRP4
ARGP4
ADDRLP4 1568
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1568
INDIRI4
CNSTI4 3
NEI4 $150
ADDRGP4 $142
JUMPV
LABELV $150
line 216
;215:		//skip team mates
;216:		if (BotSameTeam(bs, i)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 1572
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 1572
INDIRI4
CNSTI4 0
EQI4 $152
ADDRGP4 $142
JUMPV
LABELV $152
line 218
;217:		//
;218:		opponents[numopponents] = i;
ADDRLP4 1028
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1036
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 219
;219:		numopponents++;
ADDRLP4 1028
ADDRLP4 1028
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 220
;220:	}
LABELV $142
line 207
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $144
ADDRLP4 0
INDIRI4
ADDRGP4 $137
INDIRI4
GEI4 $154
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $141
LABELV $154
line 221
;221:	count = random() * numopponents;
ADDRLP4 1556
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 1032
ADDRLP4 1556
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 1028
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 222
;222:	for (i = 0; i < numopponents; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $158
JUMPV
LABELV $155
line 223
;223:		count--;
ADDRLP4 1032
ADDRLP4 1032
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 224
;224:		if (count <= 0) {
ADDRLP4 1032
INDIRI4
CNSTI4 0
GTI4 $159
line 225
;225:			EasyClientName(opponents[i], name, sizeof(name));
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1036
ADDP4
INDIRI4
ARGI4
ADDRGP4 $138
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 226
;226:			return name;
ADDRGP4 $138
RETP4
ADDRGP4 $136
JUMPV
LABELV $159
line 228
;227:		}
;228:	}
LABELV $156
line 222
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $158
ADDRLP4 0
INDIRI4
ADDRLP4 1028
INDIRI4
LTI4 $155
line 229
;229:	EasyClientName(opponents[0], name, sizeof(name));
ADDRLP4 1036
INDIRI4
ARGI4
ADDRGP4 $138
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 230
;230:	return name;
ADDRGP4 $138
RETP4
LABELV $136
endproc BotRandomOpponentName 1576 12
bss
align 1
LABELV $162
skip 128
export BotMapTitle
code
proc BotMapTitle 1028 12
line 239
;231:}
;232:
;233:/*
;234:==================
;235:BotMapTitle
;236:==================
;237:*/
;238:
;239:char *BotMapTitle(void) {
line 243
;240:	char info[1024];
;241:	static char mapname[128];
;242:
;243:	trap_GetServerinfo(info, sizeof(info));
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetServerinfo
CALLV
pop
line 245
;244:
;245:	strncpy(mapname, Info_ValueForKey( info, "mapname" ), sizeof(mapname)-1);
ADDRLP4 0
ARGP4
ADDRGP4 $163
ARGP4
ADDRLP4 1024
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRGP4 $162
ARGP4
ADDRLP4 1024
INDIRP4
ARGP4
CNSTU4 127
ARGU4
ADDRGP4 strncpy
CALLP4
pop
line 246
;246:	mapname[sizeof(mapname)-1] = '\0';
ADDRGP4 $162+127
CNSTI1 0
ASGNI1
line 248
;247:
;248:	return mapname;
ADDRGP4 $162
RETP4
LABELV $161
endproc BotMapTitle 1028 12
export BotWeaponNameForMeansOfDeath
proc BotWeaponNameForMeansOfDeath 4 0
line 258
;249:}
;250:
;251:
;252:/*
;253:==================
;254:BotWeaponNameForMeansOfDeath
;255:==================
;256:*/
;257:
;258:char *BotWeaponNameForMeansOfDeath(int mod) {
line 259
;259:	switch(mod) {
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 1
LTI4 $166
ADDRLP4 0
INDIRI4
CNSTI4 23
GTI4 $166
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $189-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $189
address $168
address $170
address $172
address $174
address $174
address $176
address $176
address $178
address $178
address $180
address $182
address $184
address $184
address $166
address $166
address $166
address $166
address $166
address $166
address $166
address $166
address $166
address $186
code
LABELV $168
line 260
;260:		case MOD_SHOTGUN: return "Shotgun";
ADDRGP4 $169
RETP4
ADDRGP4 $165
JUMPV
LABELV $170
line 261
;261:		case MOD_GAUNTLET: return "Gauntlet";
ADDRGP4 $171
RETP4
ADDRGP4 $165
JUMPV
LABELV $172
line 262
;262:		case MOD_MACHINEGUN: return "Machinegun";
ADDRGP4 $173
RETP4
ADDRGP4 $165
JUMPV
LABELV $174
line 264
;263:		case MOD_GRENADE:
;264:		case MOD_GRENADE_SPLASH: return "Grenade Launcher";
ADDRGP4 $175
RETP4
ADDRGP4 $165
JUMPV
LABELV $176
line 266
;265:		case MOD_ROCKET:
;266:		case MOD_ROCKET_SPLASH: return "Rocket Launcher";
ADDRGP4 $177
RETP4
ADDRGP4 $165
JUMPV
LABELV $178
line 268
;267:		case MOD_PLASMA:
;268:		case MOD_PLASMA_SPLASH: return "Plasmagun";
ADDRGP4 $179
RETP4
ADDRGP4 $165
JUMPV
LABELV $180
line 269
;269:		case MOD_RAILGUN: return "Railgun";
ADDRGP4 $181
RETP4
ADDRGP4 $165
JUMPV
LABELV $182
line 270
;270:		case MOD_LIGHTNING: return "Lightning Gun";
ADDRGP4 $183
RETP4
ADDRGP4 $165
JUMPV
LABELV $184
line 272
;271:		case MOD_BFG:
;272:		case MOD_BFG_SPLASH: return "BFG10K";
ADDRGP4 $185
RETP4
ADDRGP4 $165
JUMPV
LABELV $186
line 273
;273:		case MOD_GRAPPLE: return "Grapple";
ADDRGP4 $187
RETP4
ADDRGP4 $165
JUMPV
LABELV $166
line 274
;274:		default: return "[unknown weapon]";
ADDRGP4 $188
RETP4
LABELV $165
endproc BotWeaponNameForMeansOfDeath 4 0
export BotRandomWeaponName
proc BotRandomWeaponName 12 0
line 283
;275:	}
;276:}
;277:
;278:/*
;279:==================
;280:BotRandomWeaponName
;281:==================
;282:*/
;283:char *BotRandomWeaponName(void) {
line 286
;284:	int rnd;
;285:
;286:	rnd = random() * 8.9;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1091462758
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CVFI4 4
ASGNI4
line 287
;287:	switch(rnd) {
ADDRLP4 8
ADDRLP4 0
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
LTI4 $192
ADDRLP4 8
INDIRI4
CNSTI4 7
GTI4 $192
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $202
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $202
address $194
address $195
address $196
address $197
address $198
address $199
address $200
address $201
code
LABELV $194
line 288
;288:		case 0: return "Gauntlet";
ADDRGP4 $171
RETP4
ADDRGP4 $191
JUMPV
LABELV $195
line 289
;289:		case 1: return "Shotgun";
ADDRGP4 $169
RETP4
ADDRGP4 $191
JUMPV
LABELV $196
line 290
;290:		case 2: return "Machinegun";
ADDRGP4 $173
RETP4
ADDRGP4 $191
JUMPV
LABELV $197
line 291
;291:		case 3: return "Grenade Launcher";
ADDRGP4 $175
RETP4
ADDRGP4 $191
JUMPV
LABELV $198
line 292
;292:		case 4: return "Rocket Launcher";
ADDRGP4 $177
RETP4
ADDRGP4 $191
JUMPV
LABELV $199
line 293
;293:		case 5: return "Plasmagun";
ADDRGP4 $179
RETP4
ADDRGP4 $191
JUMPV
LABELV $200
line 294
;294:		case 6: return "Railgun";
ADDRGP4 $181
RETP4
ADDRGP4 $191
JUMPV
LABELV $201
line 295
;295:		case 7: return "Lightning Gun";
ADDRGP4 $183
RETP4
ADDRGP4 $191
JUMPV
LABELV $192
line 296
;296:		default: return "BFG10K";
ADDRGP4 $185
RETP4
LABELV $191
endproc BotRandomWeaponName 12 0
export BotVisibleEnemies
proc BotVisibleEnemies 196 20
line 305
;297:	}
;298:}
;299:
;300:/*
;301:==================
;302:BotVisibleEnemies
;303:==================
;304:*/
;305:int BotVisibleEnemies(bot_state_t *bs) {
line 311
;306:	float vis, dist;
;307:	int i;
;308:	vec3_t dir;
;309:	aas_entityinfo_t entinfo;
;310:
;311:	for (i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 140
CNSTI4 0
ASGNI4
LABELV $204
line 313
;312:
;313:		if (i == bs->client) continue;
ADDRLP4 140
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $208
ADDRGP4 $205
JUMPV
LABELV $208
line 315
;314:		//
;315:		BotEntityInfo(i, &entinfo);
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 317
;316:		//
;317:		if (!entinfo.valid) continue;
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $210
ADDRGP4 $205
JUMPV
LABELV $210
line 319
;318:		//if the enemy isn't dead and the enemy isn't the bot self
;319:		if (EntityIsDead(&entinfo) || entinfo.number == bs->entitynum) continue;
ADDRLP4 0
ARGP4
ADDRLP4 164
ADDRGP4 EntityIsDead
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
NEI4 $215
ADDRLP4 0+20
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
NEI4 $212
LABELV $215
ADDRGP4 $205
JUMPV
LABELV $212
line 321
;320:		//if the enemy is invisible and not shooting
;321:		if (EntityIsInvisible(&entinfo) && !EntityIsShooting(&entinfo)) {
ADDRLP4 0
ARGP4
ADDRLP4 168
ADDRGP4 EntityIsInvisible
CALLI4
ASGNI4
ADDRLP4 168
INDIRI4
CNSTI4 0
EQI4 $216
ADDRLP4 0
ARGP4
ADDRLP4 172
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 172
INDIRI4
CNSTI4 0
NEI4 $216
line 322
;322:			continue;
ADDRGP4 $205
JUMPV
LABELV $216
line 325
;323:		}
;324:		//calculate the distance towards the enemy
;325:		VectorSubtract(entinfo.origin, bs->origin, dir);
ADDRLP4 176
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 144
ADDRLP4 0+24
INDIRF4
ADDRLP4 176
INDIRP4
CNSTI4 4884
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+4
ADDRLP4 0+24+4
INDIRF4
ADDRLP4 176
INDIRP4
CNSTI4 4888
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 144+8
ADDRLP4 0+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 4892
ADDP4
INDIRF4
SUBF4
ASGNF4
line 326
;326:		dist = VectorLength(dir);
ADDRLP4 144
ARGP4
ADDRLP4 180
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 160
ADDRLP4 180
INDIRF4
ASGNF4
line 328
;327:		//if on the same team
;328:		if (BotSameTeam(bs, i)) continue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 184
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 184
INDIRI4
CNSTI4 0
EQI4 $225
ADDRGP4 $205
JUMPV
LABELV $225
line 330
;329:		//check if the enemy is visible
;330:		vis = BotEntityVisible(bs->entitynum, bs->eye, bs->viewangles, 360, i);
ADDRLP4 188
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 188
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 188
INDIRP4
CNSTI4 4912
ADDP4
ARGP4
ADDRLP4 188
INDIRP4
CNSTI4 6252
ADDP4
ARGP4
CNSTF4 1135869952
ARGF4
ADDRLP4 140
INDIRI4
ARGI4
ADDRLP4 192
ADDRGP4 BotEntityVisible
CALLF4
ASGNF4
ADDRLP4 156
ADDRLP4 192
INDIRF4
ASGNF4
line 331
;331:		if (vis > 0) return qtrue;
ADDRLP4 156
INDIRF4
CNSTF4 0
LEF4 $227
CNSTI4 1
RETI4
ADDRGP4 $203
JUMPV
LABELV $227
line 332
;332:	}
LABELV $205
line 311
ADDRLP4 140
ADDRLP4 140
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 140
INDIRI4
CNSTI4 128
LTI4 $204
line 333
;333:	return qfalse;
CNSTI4 0
RETI4
LABELV $203
endproc BotVisibleEnemies 196 20
export BotValidChatPosition
proc BotValidChatPosition 164 28
line 341
;334:}
;335:
;336:/*
;337:==================
;338:BotValidChatPosition
;339:==================
;340:*/
;341:int BotValidChatPosition(bot_state_t *bs) {
line 346
;342:	vec3_t point, start, end, mins, maxs;
;343:	bsp_trace_t trace;
;344:
;345:	//if the bot is dead all positions are valid
;346:	if (BotIsDead(bs)) return qtrue;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 144
ADDRGP4 BotIsDead
CALLI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 0
EQI4 $230
CNSTI4 1
RETI4
ADDRGP4 $229
JUMPV
LABELV $230
line 348
;347:	//never start chatting with a powerup
;348:	if (bs->inventory[INVENTORY_QUAD] ||
ADDRLP4 148
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 152
CNSTI4 0
ASGNI4
ADDRLP4 148
INDIRP4
CNSTI4 5036
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
NEI4 $237
ADDRLP4 148
INDIRP4
CNSTI4 5044
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
NEI4 $237
ADDRLP4 148
INDIRP4
CNSTI4 5048
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
NEI4 $237
ADDRLP4 148
INDIRP4
CNSTI4 5052
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
NEI4 $237
ADDRLP4 148
INDIRP4
CNSTI4 5056
ADDP4
INDIRI4
ADDRLP4 152
INDIRI4
EQI4 $232
LABELV $237
line 352
;349:		bs->inventory[INVENTORY_HASTE] ||
;350:		bs->inventory[INVENTORY_INVISIBILITY] ||
;351:		bs->inventory[INVENTORY_REGEN] ||
;352:		bs->inventory[INVENTORY_FLIGHT]) return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $229
JUMPV
LABELV $232
line 356
;353:	//must be on the ground
;354:	//if (bs->cur_ps.groundEntityNum != ENTITYNUM_NONE) return qfalse;
;355:	//do not chat if in lava or slime
;356:	VectorCopy(bs->origin, point);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 357
;357:	point[2] -= 24;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1103101952
SUBF4
ASGNF4
line 358
;358:	if (trap_PointContents(point,bs->entitynum) & (CONTENTS_LAVA|CONTENTS_SLIME)) return qfalse;
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 156
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 156
INDIRI4
CNSTI4 24
BANDI4
CNSTI4 0
EQI4 $239
CNSTI4 0
RETI4
ADDRGP4 $229
JUMPV
LABELV $239
line 360
;359:	//do not chat if under water
;360:	VectorCopy(bs->origin, point);
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 361
;361:	point[2] += 32;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1107296256
ADDF4
ASGNF4
line 362
;362:	if (trap_PointContents(point,bs->entitynum) & MASK_WATER) return qfalse;
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 160
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $242
CNSTI4 0
RETI4
ADDRGP4 $229
JUMPV
LABELV $242
line 364
;363:	//must be standing on the world entity
;364:	VectorCopy(bs->origin, start);
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 365
;365:	VectorCopy(bs->origin, end);
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 4884
ADDP4
INDIRB
ASGNB 12
line 366
;366:	start[2] += 1;
ADDRLP4 12+8
ADDRLP4 12+8
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 367
;367:	end[2] -= 10;
ADDRLP4 24+8
ADDRLP4 24+8
INDIRF4
CNSTF4 1092616192
SUBF4
ASGNF4
line 368
;368:	trap_AAS_PresenceTypeBoundingBox(PRESENCE_CROUCH, mins, maxs);
CNSTI4 4
ARGI4
ADDRLP4 36
ARGP4
ADDRLP4 48
ARGP4
ADDRGP4 trap_AAS_PresenceTypeBoundingBox
CALLV
pop
line 369
;369:	BotAI_Trace(&trace, start, mins, maxs, end, bs->client, MASK_SOLID);
ADDRLP4 60
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 48
ARGP4
ADDRLP4 24
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 BotAI_Trace
CALLV
pop
line 370
;370:	if (trace.ent != ENTITYNUM_WORLD) return qfalse;
ADDRLP4 60+80
INDIRI4
CNSTI4 1022
EQI4 $246
CNSTI4 0
RETI4
ADDRGP4 $229
JUMPV
LABELV $246
line 372
;371:	//the bot is in a position where it can chat
;372:	return qtrue;
CNSTI4 1
RETI4
LABELV $229
endproc BotValidChatPosition 164 28
export BotChat_EnterGame
proc BotChat_EnterGame 76 32
line 380
;373:}
;374:
;375:/*
;376:==================
;377:BotChat_EnterGame
;378:==================
;379:*/
;380:int BotChat_EnterGame(bot_state_t *bs) {
line 384
;381:	char name[32];
;382:	float rnd;
;383:
;384:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $250
CNSTI4 0
RETI4
ADDRGP4 $249
JUMPV
LABELV $250
line 385
;385:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 36
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 36
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $253
CNSTI4 0
RETI4
ADDRGP4 $249
JUMPV
LABELV $253
line 387
;386:	//don't chat in teamplay
;387:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 40
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
EQI4 $255
CNSTI4 0
RETI4
ADDRGP4 $249
JUMPV
LABELV $255
line 388
;388:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_ENTEREXITGAME, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 27
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 44
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 44
INDIRF4
ASGNF4
line 389
;389:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $257
line 390
;390:		if (random() > rnd) return qfalse;
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 0
INDIRF4
LEF4 $260
CNSTI4 0
RETI4
ADDRGP4 $249
JUMPV
LABELV $260
line 391
;391:	}
LABELV $257
line 392
;392:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 48
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 1
GTI4 $262
CNSTI4 0
RETI4
ADDRGP4 $249
JUMPV
LABELV $262
line 393
;393:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $264
CNSTI4 0
RETI4
ADDRGP4 $249
JUMPV
LABELV $264
line 394
;394:	BotAI_BotInitialChat(bs, "game_enter",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 56
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 60
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 64
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $266
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 $267
ASGNP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 401
;395:				EasyClientName(bs->client, name, 32),	// 0
;396:				BotRandomOpponentName(bs),				// 1
;397:				"[invalid var]",						// 2
;398:				"[invalid var]",						// 3
;399:				BotMapTitle(),							// 4
;400:				NULL);
;401:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 402
;402:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 403
;403:	return qtrue;
CNSTI4 1
RETI4
LABELV $249
endproc BotChat_EnterGame 76 32
export BotChat_ExitGame
proc BotChat_ExitGame 72 32
line 411
;404:}
;405:
;406:/*
;407:==================
;408:BotChat_ExitGame
;409:==================
;410:*/
;411:int BotChat_ExitGame(bot_state_t *bs) {
line 415
;412:	char name[32];
;413:	float rnd;
;414:
;415:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $269
CNSTI4 0
RETI4
ADDRGP4 $268
JUMPV
LABELV $269
line 416
;416:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 36
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 36
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $272
CNSTI4 0
RETI4
ADDRGP4 $268
JUMPV
LABELV $272
line 418
;417:	//don't chat in teamplay
;418:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 40
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
EQI4 $274
CNSTI4 0
RETI4
ADDRGP4 $268
JUMPV
LABELV $274
line 419
;419:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_ENTEREXITGAME, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 27
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 44
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 44
INDIRF4
ASGNF4
line 420
;420:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $276
line 421
;421:		if (random() > rnd) return qfalse;
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 0
INDIRF4
LEF4 $279
CNSTI4 0
RETI4
ADDRGP4 $268
JUMPV
LABELV $279
line 422
;422:	}
LABELV $276
line 423
;423:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 48
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 1
GTI4 $281
CNSTI4 0
RETI4
ADDRGP4 $268
JUMPV
LABELV $281
line 425
;424:	//
;425:	BotAI_BotInitialChat(bs, "game_exit",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 52
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 60
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $283
ARGP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 $267
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 432
;426:				EasyClientName(bs->client, name, 32),	// 0
;427:				BotRandomOpponentName(bs),				// 1
;428:				"[invalid var]",						// 2
;429:				"[invalid var]",						// 3
;430:				BotMapTitle(),							// 4
;431:				NULL);
;432:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 68
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 68
INDIRF4
ASGNF4
line 433
;433:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 434
;434:	return qtrue;
CNSTI4 1
RETI4
LABELV $268
endproc BotChat_ExitGame 72 32
export BotChat_StartLevel
proc BotChat_StartLevel 64 16
line 442
;435:}
;436:
;437:/*
;438:==================
;439:BotChat_StartLevel
;440:==================
;441:*/
;442:int BotChat_StartLevel(bot_state_t *bs) {
line 446
;443:	char name[32];
;444:	float rnd;
;445:
;446:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $285
CNSTI4 0
RETI4
ADDRGP4 $284
JUMPV
LABELV $285
line 447
;447:	if (BotIsObserver(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $288
CNSTI4 0
RETI4
ADDRGP4 $284
JUMPV
LABELV $288
line 448
;448:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 40
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 40
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $290
CNSTI4 0
RETI4
ADDRGP4 $284
JUMPV
LABELV $290
line 450
;449:	//don't chat in teamplay
;450:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 44
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
EQI4 $292
CNSTI4 0
RETI4
ADDRGP4 $284
JUMPV
LABELV $292
line 451
;451:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_STARTENDLEVEL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 26
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 48
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 48
INDIRF4
ASGNF4
line 452
;452:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $294
line 453
;453:		if (random() > rnd) return qfalse;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 0
INDIRF4
LEF4 $297
CNSTI4 0
RETI4
ADDRGP4 $284
JUMPV
LABELV $297
line 454
;454:	}
LABELV $294
line 455
;455:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 52
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 1
GTI4 $299
CNSTI4 0
RETI4
ADDRGP4 $284
JUMPV
LABELV $299
line 456
;456:	BotAI_BotInitialChat(bs, "level_start",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 56
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $301
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 459
;457:				EasyClientName(bs->client, name, 32),	// 0
;458:				NULL);
;459:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 60
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 60
INDIRF4
ASGNF4
line 460
;460:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 461
;461:	return qtrue;
CNSTI4 1
RETI4
LABELV $284
endproc BotChat_StartLevel 64 16
export BotChat_EndLevel
proc BotChat_EndLevel 84 32
line 469
;462:}
;463:
;464:/*
;465:==================
;466:BotChat_EndLevel
;467:==================
;468:*/
;469:int BotChat_EndLevel(bot_state_t *bs) {
line 473
;470:	char name[32];
;471:	float rnd;
;472:
;473:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $303
CNSTI4 0
RETI4
ADDRGP4 $302
JUMPV
LABELV $303
line 474
;474:	if (BotIsObserver(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $306
CNSTI4 0
RETI4
ADDRGP4 $302
JUMPV
LABELV $306
line 475
;475:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 40
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 40
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $308
CNSTI4 0
RETI4
ADDRGP4 $302
JUMPV
LABELV $308
line 477
;476:	//don't chat in teamplay
;477:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 44
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
EQI4 $310
CNSTI4 0
RETI4
ADDRGP4 $302
JUMPV
LABELV $310
line 478
;478:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_STARTENDLEVEL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 26
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 48
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 48
INDIRF4
ASGNF4
line 479
;479:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $312
line 480
;480:		if (random() > rnd) return qfalse;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 0
INDIRF4
LEF4 $315
CNSTI4 0
RETI4
ADDRGP4 $302
JUMPV
LABELV $315
line 481
;481:	}
LABELV $312
line 482
;482:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 52
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 1
GTI4 $317
CNSTI4 0
RETI4
ADDRGP4 $302
JUMPV
LABELV $317
line 484
;483:	//
;484:	if (BotIsFirstInRankings(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 BotIsFirstInRankings
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
EQI4 $319
line 485
;485:		BotAI_BotInitialChat(bs, "level_end_victory",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 60
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 68
ADDRGP4 BotLastClientInRankings
CALLP4
ASGNP4
ADDRLP4 72
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $321
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRGP4 $267
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 492
;486:				EasyClientName(bs->client, name, 32),	// 0
;487:				BotRandomOpponentName(bs),				// 1
;488:				"[invalid var]",						// 2
;489:				BotLastClientInRankings(),				// 3
;490:				BotMapTitle(),							// 4
;491:				NULL);
;492:	}
ADDRGP4 $320
JUMPV
LABELV $319
line 493
;493:	else if (BotIsLastInRankings(bs)) {
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 60
ADDRGP4 BotIsLastInRankings
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
EQI4 $322
line 494
;494:		BotAI_BotInitialChat(bs, "level_end_lose",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 64
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 72
ADDRGP4 BotFirstClientInRankings
CALLP4
ASGNP4
ADDRLP4 76
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $324
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRGP4 $267
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 501
;495:				EasyClientName(bs->client, name, 32),	// 0
;496:				BotRandomOpponentName(bs),				// 1
;497:				BotFirstClientInRankings(),				// 2
;498:				"[invalid var]",						// 3
;499:				BotMapTitle(),							// 4
;500:				NULL);
;501:	}
ADDRGP4 $323
JUMPV
LABELV $322
line 502
;502:	else {
line 503
;503:		BotAI_BotInitialChat(bs, "level_end",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 64
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 72
ADDRGP4 BotFirstClientInRankings
CALLP4
ASGNP4
ADDRLP4 76
ADDRGP4 BotLastClientInRankings
CALLP4
ASGNP4
ADDRLP4 80
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $325
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 510
;504:				EasyClientName(bs->client, name, 32),	// 0
;505:				BotRandomOpponentName(bs),				// 1
;506:				BotFirstClientInRankings(),				// 2
;507:				BotLastClientInRankings(),				// 3
;508:				BotMapTitle(),							// 4
;509:				NULL);
;510:	}
LABELV $323
LABELV $320
line 511
;511:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 64
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 64
INDIRF4
ASGNF4
line 512
;512:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 513
;513:	return qtrue;
CNSTI4 1
RETI4
LABELV $302
endproc BotChat_EndLevel 84 32
export BotChat_Death
proc BotChat_Death 120 20
line 521
;514:}
;515:
;516:/*
;517:==================
;518:BotChat_Death
;519:==================
;520:*/
;521:int BotChat_Death(bot_state_t *bs) {
line 525
;522:	char name[32];
;523:	float rnd;
;524:
;525:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $327
CNSTI4 0
RETI4
ADDRGP4 $326
JUMPV
LABELV $327
line 526
;526:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 36
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 36
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $330
CNSTI4 0
RETI4
ADDRGP4 $326
JUMPV
LABELV $330
line 527
;527:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_DEATH, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 29
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 40
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 40
INDIRF4
ASGNF4
line 529
;528:	//if fast chatting is off
;529:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $332
line 530
;530:		if (random() > rnd) return qfalse;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 32
INDIRF4
LEF4 $335
CNSTI4 0
RETI4
ADDRGP4 $326
JUMPV
LABELV $335
line 531
;531:	}
LABELV $332
line 532
;532:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 44
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 1
GTI4 $337
CNSTI4 0
RETI4
ADDRGP4 $326
JUMPV
LABELV $337
line 534
;533:	//
;534:	if (bs->lastkilledby >= 0 && bs->lastkilledby < MAX_CLIENTS)
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 5972
ADDP4
INDIRI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 0
LTI4 $339
ADDRLP4 48
INDIRI4
CNSTI4 128
GEI4 $339
line 535
;535:		EasyClientName(bs->lastkilledby, name, 32);
ADDRFP4 0
INDIRP4
CNSTI4 5972
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
ADDRGP4 $340
JUMPV
LABELV $339
line 537
;536:	else
;537:		strcpy(name, "[world]");
ADDRLP4 0
ARGP4
ADDRGP4 $341
ARGP4
ADDRGP4 strcpy
CALLP4
pop
LABELV $340
line 539
;538:	//
;539:	if (TeamPlayIsOn() && BotSameTeam(bs, bs->lastkilledby)) {
ADDRLP4 52
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
EQI4 $342
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
CNSTI4 5972
ADDP4
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
EQI4 $342
line 540
;540:		if (bs->lastkilledby == bs->client) return qfalse;
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 5972
ADDP4
INDIRI4
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $344
CNSTI4 0
RETI4
ADDRGP4 $326
JUMPV
LABELV $344
line 541
;541:		BotAI_BotInitialChat(bs, "death_teammate", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $346
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 542
;542:		bs->chatto = CHAT_TEAM;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 1
ASGNI4
line 543
;543:	}
ADDRGP4 $343
JUMPV
LABELV $342
line 545
;544:	else
;545:	{
line 547
;546:		//don't chat in teamplay
;547:		if (TeamPlayIsOn()) return qfalse;
ADDRLP4 64
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
EQI4 $347
CNSTI4 0
RETI4
ADDRGP4 $326
JUMPV
LABELV $347
line 549
;548:		//
;549:		if (bs->botdeathtype == MOD_WATER)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 14
NEI4 $349
line 550
;550:			BotAI_BotInitialChat(bs, "death_drown", BotRandomOpponentName(bs), NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $351
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $350
JUMPV
LABELV $349
line 551
;551:		else if (bs->botdeathtype == MOD_SLIME)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 15
NEI4 $352
line 552
;552:			BotAI_BotInitialChat(bs, "death_slime", BotRandomOpponentName(bs), NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $354
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $353
JUMPV
LABELV $352
line 553
;553:		else if (bs->botdeathtype == MOD_LAVA)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 16
NEI4 $355
line 554
;554:			BotAI_BotInitialChat(bs, "death_lava", BotRandomOpponentName(bs), NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $357
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $356
JUMPV
LABELV $355
line 555
;555:		else if (bs->botdeathtype == MOD_FALLING)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 19
NEI4 $358
line 556
;556:			BotAI_BotInitialChat(bs, "death_cratered", BotRandomOpponentName(bs), NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $360
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $359
JUMPV
LABELV $358
line 557
;557:		else if (bs->botsuicide || //all other suicides by own weapon
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
CNSTI4 0
ASGNI4
ADDRLP4 84
INDIRP4
CNSTI4 5984
ADDP4
INDIRI4
ADDRLP4 88
INDIRI4
NEI4 $367
ADDRLP4 92
ADDRLP4 84
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ASGNI4
ADDRLP4 92
INDIRI4
CNSTI4 17
EQI4 $367
ADDRLP4 92
INDIRI4
CNSTI4 20
EQI4 $367
ADDRLP4 92
INDIRI4
CNSTI4 21
EQI4 $367
ADDRLP4 92
INDIRI4
CNSTI4 22
EQI4 $367
ADDRLP4 92
INDIRI4
ADDRLP4 88
INDIRI4
NEI4 $361
LABELV $367
line 563
;558:				bs->botdeathtype == MOD_CRUSH ||
;559:				bs->botdeathtype == MOD_SUICIDE ||
;560:				bs->botdeathtype == MOD_TARGET_LASER ||
;561:				bs->botdeathtype == MOD_TRIGGER_HURT ||
;562:				bs->botdeathtype == MOD_UNKNOWN)
;563:			BotAI_BotInitialChat(bs, "death_suicide", BotRandomOpponentName(bs), NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 96
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $368
ARGP4
ADDRLP4 96
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $362
JUMPV
LABELV $361
line 564
;564:		else if (bs->botdeathtype == MOD_TELEFRAG)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 18
NEI4 $369
line 565
;565:			BotAI_BotInitialChat(bs, "death_telefrag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $371
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $370
JUMPV
LABELV $369
line 566
;566:		else {
line 567
;567:			if ((bs->botdeathtype == MOD_GAUNTLET ||
ADDRLP4 100
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ASGNI4
ADDRLP4 100
INDIRI4
CNSTI4 2
EQI4 $376
ADDRLP4 100
INDIRI4
CNSTI4 10
EQI4 $376
ADDRLP4 100
INDIRI4
CNSTI4 12
EQI4 $376
ADDRLP4 100
INDIRI4
CNSTI4 13
NEI4 $372
LABELV $376
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
GEF4 $372
line 570
;568:				bs->botdeathtype == MOD_RAILGUN ||
;569:				bs->botdeathtype == MOD_BFG ||
;570:				bs->botdeathtype == MOD_BFG_SPLASH) && random() < 0.5) {
line 572
;571:
;572:				if (bs->botdeathtype == MOD_GAUNTLET)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 2
NEI4 $377
line 573
;573:					BotAI_BotInitialChat(bs, "death_gauntlet",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 108
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $379
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 108
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $373
JUMPV
LABELV $377
line 577
;574:							name,												// 0
;575:							BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;576:							NULL);
;577:				else if (bs->botdeathtype == MOD_RAILGUN)
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
CNSTI4 10
NEI4 $380
line 578
;578:					BotAI_BotInitialChat(bs, "death_rail",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 112
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $382
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 112
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
ADDRGP4 $373
JUMPV
LABELV $380
line 583
;579:							name,												// 0
;580:							BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;581:							NULL);
;582:				else
;583:					BotAI_BotInitialChat(bs, "death_bfg",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 116
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $383
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 116
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 587
;584:							name,												// 0
;585:							BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;586:							NULL);
;587:			}
ADDRGP4 $373
JUMPV
LABELV $372
line 589
;588:			//choose between insult and praise
;589:			else if (random() < trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_INSULT, 0, 1)) {
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 24
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 112
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 112
INDIRF4
GEF4 $384
line 590
;590:				BotAI_BotInitialChat(bs, "death_insult",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 116
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $386
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 116
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 594
;591:							name,												// 0
;592:							BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;593:							NULL);
;594:			}
ADDRGP4 $385
JUMPV
LABELV $384
line 595
;595:			else {
line 596
;596:				BotAI_BotInitialChat(bs, "death_praise",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 116
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $387
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 116
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 600
;597:							name,												// 0
;598:							BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;599:							NULL);
;600:			}
LABELV $385
LABELV $373
line 601
;601:		}
LABELV $370
LABELV $362
LABELV $359
LABELV $356
LABELV $353
LABELV $350
line 602
;602:		bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 603
;603:	}
LABELV $343
line 604
;604:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 64
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 64
INDIRF4
ASGNF4
line 605
;605:	return qtrue;
CNSTI4 1
RETI4
LABELV $326
endproc BotChat_Death 120 20
export BotChat_Kill
proc BotChat_Kill 84 16
line 613
;606:}
;607:
;608:/*
;609:==================
;610:BotChat_Kill
;611:==================
;612:*/
;613:int BotChat_Kill(bot_state_t *bs) {
line 617
;614:	char name[32];
;615:	float rnd;
;616:
;617:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $389
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $389
line 618
;618:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 36
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 36
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $392
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $392
line 619
;619:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_KILL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 28
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 40
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 40
INDIRF4
ASGNF4
line 621
;620:	//if fast chat is off
;621:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $394
line 622
;622:		if (random() > rnd) return qfalse;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 32
INDIRF4
LEF4 $397
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $397
line 623
;623:	}
LABELV $394
line 624
;624:	if (bs->lastkilledplayer == bs->client) return qfalse;
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ADDRLP4 44
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $399
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $399
line 625
;625:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 48
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 1
GTI4 $401
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $401
line 626
;626:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $403
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $403
line 628
;627:	//
;628:	if (BotVisibleEnemies(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 BotVisibleEnemies
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
EQI4 $405
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $405
line 630
;629:	//
;630:	EasyClientName(bs->lastkilledplayer, name, 32);
ADDRFP4 0
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 632
;631:	//
;632:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 633
;633:	if (TeamPlayIsOn() && BotSameTeam(bs, bs->lastkilledplayer)) {
ADDRLP4 60
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
EQI4 $407
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ARGI4
ADDRLP4 68
ADDRGP4 BotSameTeam
CALLI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 0
EQI4 $407
line 634
;634:		BotAI_BotInitialChat(bs, "kill_teammate", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $409
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 635
;635:		bs->chatto = CHAT_TEAM;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 1
ASGNI4
line 636
;636:	}
ADDRGP4 $408
JUMPV
LABELV $407
line 638
;637:	else
;638:	{
line 640
;639:		//don't chat in teamplay
;640:		if (TeamPlayIsOn()) return qfalse;
ADDRLP4 72
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 72
INDIRI4
CNSTI4 0
EQI4 $410
CNSTI4 0
RETI4
ADDRGP4 $388
JUMPV
LABELV $410
line 642
;641:		//
;642:		if (bs->enemydeathtype == MOD_GAUNTLET) {
ADDRFP4 0
INDIRP4
CNSTI4 5980
ADDP4
INDIRI4
CNSTI4 2
NEI4 $412
line 643
;643:			BotAI_BotInitialChat(bs, "kill_gauntlet", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $414
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 644
;644:		}
ADDRGP4 $413
JUMPV
LABELV $412
line 645
;645:		else if (bs->enemydeathtype == MOD_RAILGUN) {
ADDRFP4 0
INDIRP4
CNSTI4 5980
ADDP4
INDIRI4
CNSTI4 10
NEI4 $415
line 646
;646:			BotAI_BotInitialChat(bs, "kill_rail", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $417
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 647
;647:		}
ADDRGP4 $416
JUMPV
LABELV $415
line 648
;648:		else if (bs->enemydeathtype == MOD_TELEFRAG) {
ADDRFP4 0
INDIRP4
CNSTI4 5980
ADDP4
INDIRI4
CNSTI4 18
NEI4 $418
line 649
;649:			BotAI_BotInitialChat(bs, "kill_telefrag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $420
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 650
;650:		}
ADDRGP4 $419
JUMPV
LABELV $418
line 652
;651:		//choose between insult and praise
;652:		else if (random() < trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_INSULT, 0, 1)) {
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 24
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 80
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 80
INDIRF4
GEF4 $421
line 653
;653:			BotAI_BotInitialChat(bs, "kill_insult", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $423
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 654
;654:		}
ADDRGP4 $422
JUMPV
LABELV $421
line 655
;655:		else {
line 656
;656:			BotAI_BotInitialChat(bs, "kill_praise", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $424
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 657
;657:		}
LABELV $422
LABELV $419
LABELV $416
LABELV $413
line 658
;658:	}
LABELV $408
line 659
;659:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 660
;660:	return qtrue;
CNSTI4 1
RETI4
LABELV $388
endproc BotChat_Kill 84 16
export BotChat_EnemySuicide
proc BotChat_EnemySuicide 64 16
line 668
;661:}
;662:
;663:/*
;664:==================
;665:BotChat_EnemySuicide
;666:==================
;667:*/
;668:int BotChat_EnemySuicide(bot_state_t *bs) {
line 672
;669:	char name[32];
;670:	float rnd;
;671:
;672:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $426
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $426
line 673
;673:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 36
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 36
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $429
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $429
line 674
;674:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 40
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 1
GTI4 $431
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $431
line 676
;675:	//
;676:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_KILL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 28
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 44
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 44
INDIRF4
ASGNF4
line 678
;677:	//don't chat in teamplay
;678:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 48
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 0
EQI4 $433
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $433
line 680
;679:	//if fast chat is off
;680:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $435
line 681
;681:		if (random() > rnd) return qfalse;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 32
INDIRF4
LEF4 $438
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $438
line 682
;682:	}
LABELV $435
line 683
;683:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $440
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $440
line 685
;684:	//
;685:	if (BotVisibleEnemies(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 BotVisibleEnemies
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
EQI4 $442
CNSTI4 0
RETI4
ADDRGP4 $425
JUMPV
LABELV $442
line 687
;686:	//
;687:	if (bs->enemy >= 0) EasyClientName(bs->enemy, name, 32);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
CNSTI4 0
LTI4 $444
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
ADDRGP4 $445
JUMPV
LABELV $444
line 688
;688:	else strcpy(name, "");
ADDRLP4 0
ARGP4
ADDRGP4 $446
ARGP4
ADDRGP4 strcpy
CALLP4
pop
LABELV $445
line 689
;689:	BotAI_BotInitialChat(bs, "enemy_suicide", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $447
ARGP4
ADDRLP4 0
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 690
;690:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 60
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 60
INDIRF4
ASGNF4
line 691
;691:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 692
;692:	return qtrue;
CNSTI4 1
RETI4
LABELV $425
endproc BotChat_EnemySuicide 64 16
export BotChat_HitTalking
proc BotChat_HitTalking 76 20
line 700
;693:}
;694:
;695:/*
;696:==================
;697:BotChat_HitTalking
;698:==================
;699:*/
;700:int BotChat_HitTalking(bot_state_t *bs) {
line 705
;701:	char name[32], *weap;
;702:	int lasthurt_client;
;703:	float rnd;
;704:
;705:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $449
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $449
line 706
;706:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 44
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 44
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $452
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $452
line 707
;707:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 48
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 1
GTI4 $454
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $454
line 708
;708:	lasthurt_client = g_entities[bs->client].client->lasthurt_client;
ADDRLP4 0
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
INDIRI4
ASGNI4
line 709
;709:	if (!lasthurt_client) return qfalse;
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $457
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $457
line 710
;710:	if (lasthurt_client == bs->client) return qfalse;
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $459
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $459
line 712
;711:	//
;712:	if (lasthurt_client < 0 || lasthurt_client >= MAX_CLIENTS) return qfalse;
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $463
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $461
LABELV $463
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $461
line 714
;713:	//
;714:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_HITTALKING, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 31
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 56
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 40
ADDRLP4 56
INDIRF4
ASGNF4
line 716
;715:	//don't chat in teamplay
;716:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 60
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
EQI4 $464
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $464
line 718
;717:	//if fast chat is off
;718:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $466
line 719
;719:		if (random() > rnd * 0.5) return qfalse;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
ADDRLP4 40
INDIRF4
MULF4
LEF4 $469
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $469
line 720
;720:	}
LABELV $466
line 721
;721:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
NEI4 $471
CNSTI4 0
RETI4
ADDRGP4 $448
JUMPV
LABELV $471
line 723
;722:	//
;723:	ClientName(g_entities[bs->client].client->lasthurt_client, name, sizeof(name));
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 724
;724:	weap = BotWeaponNameForMeansOfDeath(g_entities[bs->client].client->lasthurt_client);
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
INDIRI4
ARGI4
ADDRLP4 68
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRLP4 36
ADDRLP4 68
INDIRP4
ASGNP4
line 726
;725:	//
;726:	BotAI_BotInitialChat(bs, "hit_talking", name, weap, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $475
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 36
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 727
;727:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 72
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 728
;728:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 729
;729:	return qtrue;
CNSTI4 1
RETI4
LABELV $448
endproc BotChat_HitTalking 76 20
export BotChat_HitNoDeath
proc BotChat_HitNoDeath 224 20
line 737
;730:}
;731:
;732:/*
;733:==================
;734:BotChat_HitNoDeath
;735:==================
;736:*/
;737:int BotChat_HitNoDeath(bot_state_t *bs) {
line 743
;738:	char name[32], *weap;
;739:	float rnd;
;740:	int lasthurt_client;
;741:	aas_entityinfo_t entinfo;
;742:
;743:	lasthurt_client = g_entities[bs->client].client->lasthurt_client;
ADDRLP4 0
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
INDIRI4
ASGNI4
line 744
;744:	if (!lasthurt_client) return qfalse;
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $478
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $478
line 745
;745:	if (lasthurt_client == bs->client) return qfalse;
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $480
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $480
line 747
;746:	//
;747:	if (lasthurt_client < 0 || lasthurt_client >= MAX_CLIENTS) return qfalse;
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $484
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $482
LABELV $484
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $482
line 749
;748:	//
;749:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $485
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $485
line 750
;750:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 188
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 188
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $488
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $488
line 751
;751:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 192
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 192
INDIRI4
CNSTI4 1
GTI4 $490
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $490
line 752
;752:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_HITNODEATH, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 196
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 180
ADDRLP4 196
INDIRF4
ASGNF4
line 754
;753:	//don't chat in teamplay
;754:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 200
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $492
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $492
line 756
;755:	//if fast chat is off
;756:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $494
line 757
;757:		if (random() > rnd * 0.5) return qfalse;
ADDRLP4 204
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 204
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
ADDRLP4 180
INDIRF4
MULF4
LEF4 $497
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $497
line 758
;758:	}
LABELV $494
line 759
;759:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 204
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 204
INDIRI4
CNSTI4 0
NEI4 $499
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $499
line 761
;760:	//
;761:	if (BotVisibleEnemies(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 208
ADDRGP4 BotVisibleEnemies
CALLI4
ASGNI4
ADDRLP4 208
INDIRI4
CNSTI4 0
EQI4 $501
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $501
line 763
;762:	//
;763:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 40
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 764
;764:	if (EntityIsShooting(&entinfo)) return qfalse;
ADDRLP4 40
ARGP4
ADDRLP4 212
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 212
INDIRI4
CNSTI4 0
EQI4 $503
CNSTI4 0
RETI4
ADDRGP4 $476
JUMPV
LABELV $503
line 766
;765:	//
;766:	ClientName(lasthurt_client, name, sizeof(name));
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 767
;767:	weap = BotWeaponNameForMeansOfDeath(g_entities[bs->client].client->lasthurt_mod);
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ARGI4
ADDRLP4 216
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRLP4 36
ADDRLP4 216
INDIRP4
ASGNP4
line 769
;768:	//
;769:	BotAI_BotInitialChat(bs, "hit_nodeath", name, weap, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $506
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 36
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 770
;770:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 220
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 220
INDIRF4
ASGNF4
line 771
;771:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 772
;772:	return qtrue;
CNSTI4 1
RETI4
LABELV $476
endproc BotChat_HitNoDeath 224 20
export BotChat_HitNoKill
proc BotChat_HitNoKill 216 20
line 780
;773:}
;774:
;775:/*
;776:==================
;777:BotChat_HitNoKill
;778:==================
;779:*/
;780:int BotChat_HitNoKill(bot_state_t *bs) {
line 785
;781:	char name[32], *weap;
;782:	float rnd;
;783:	aas_entityinfo_t entinfo;
;784:
;785:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $508
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $508
line 786
;786:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 180
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 180
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $511
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $511
line 787
;787:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 184
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 184
INDIRI4
CNSTI4 1
GTI4 $513
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $513
line 788
;788:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_HITNOKILL, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 33
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 188
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 176
ADDRLP4 188
INDIRF4
ASGNF4
line 790
;789:	//don't chat in teamplay
;790:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 192
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 192
INDIRI4
CNSTI4 0
EQI4 $515
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $515
line 792
;791:	//if fast chat is off
;792:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $517
line 793
;793:		if (random() > rnd * 0.5) return qfalse;
ADDRLP4 196
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 196
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
ADDRLP4 176
INDIRF4
MULF4
LEF4 $520
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $520
line 794
;794:	}
LABELV $517
line 795
;795:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 196
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 196
INDIRI4
CNSTI4 0
NEI4 $522
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $522
line 797
;796:	//
;797:	if (BotVisibleEnemies(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 200
ADDRGP4 BotVisibleEnemies
CALLI4
ASGNI4
ADDRLP4 200
INDIRI4
CNSTI4 0
EQI4 $524
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $524
line 799
;798:	//
;799:	BotEntityInfo(bs->enemy, &entinfo);
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 36
ARGP4
ADDRGP4 BotEntityInfo
CALLV
pop
line 800
;800:	if (EntityIsShooting(&entinfo)) return qfalse;
ADDRLP4 36
ARGP4
ADDRLP4 204
ADDRGP4 EntityIsShooting
CALLI4
ASGNI4
ADDRLP4 204
INDIRI4
CNSTI4 0
EQI4 $526
CNSTI4 0
RETI4
ADDRGP4 $507
JUMPV
LABELV $526
line 802
;801:	//
;802:	ClientName(bs->enemy, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 803
;803:	weap = BotWeaponNameForMeansOfDeath(g_entities[bs->enemy].client->lasthurt_mod);
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 6228
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ARGI4
ADDRLP4 208
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRLP4 32
ADDRLP4 208
INDIRP4
ASGNP4
line 805
;804:	//
;805:	BotAI_BotInitialChat(bs, "hit_nokill", name, weap, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $529
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 32
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 806
;806:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 212
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 212
INDIRF4
ASGNF4
line 807
;807:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 808
;808:	return qtrue;
CNSTI4 1
RETI4
LABELV $507
endproc BotChat_HitNoKill 216 20
export BotChat_Random
proc BotChat_Random 96 36
line 816
;809:}
;810:
;811:/*
;812:==================
;813:BotChat_Random
;814:==================
;815:*/
;816:int BotChat_Random(bot_state_t *bs) {
line 820
;817:	float rnd;
;818:	char name[32];
;819:
;820:	if (bot_nochat.integer) return qfalse;
ADDRGP4 bot_nochat+12
INDIRI4
CNSTI4 0
EQI4 $531
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $531
line 821
;821:	if (BotIsObserver(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 BotIsObserver
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $534
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $534
line 822
;822:	if (bs->lastchat_time > trap_AAS_Time() - 3) return qfalse;
ADDRLP4 40
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
INDIRF4
ADDRLP4 40
INDIRF4
CNSTF4 1077936128
SUBF4
LEF4 $536
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $536
line 824
;823:	//don't chat in teamplay
;824:	if (TeamPlayIsOn()) return qfalse;
ADDRLP4 44
ADDRGP4 TeamPlayIsOn
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
EQI4 $538
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $538
line 826
;825:	//don't chat when doing something important :)
;826:	if (bs->ltgtype == LTG_TEAMHELP ||
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 6288
ADDP4
INDIRI4
ASGNI4
ADDRLP4 48
INDIRI4
CNSTI4 1
EQI4 $543
ADDRLP4 48
INDIRI4
CNSTI4 2
EQI4 $543
ADDRLP4 48
INDIRI4
CNSTI4 5
NEI4 $540
LABELV $543
line 828
;827:		bs->ltgtype == LTG_TEAMACCOMPANY ||
;828:		bs->ltgtype == LTG_RUSHBASE) return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $540
line 830
;829:	//
;830:	rnd = trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_RANDOM, 0, 1);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 34
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 52
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 52
INDIRF4
ASGNF4
line 831
;831:	if (random() > bs->thinktime * 0.1) return qfalse;
ADDRLP4 56
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1036831949
ADDRFP4 0
INDIRP4
CNSTI4 4880
ADDP4
INDIRF4
MULF4
LEF4 $544
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $544
line 832
;832:	if (!bot_fastchat.integer) {
ADDRGP4 bot_fastchat+12
INDIRI4
CNSTI4 0
NEI4 $546
line 833
;833:		if (random() > rnd) return qfalse;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 32
INDIRF4
LEF4 $549
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $549
line 834
;834:		if (random() > 0.25) return qfalse;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1048576000
LEF4 $551
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $551
line 835
;835:	}
LABELV $546
line 836
;836:	if (BotNumActivePlayers() <= 1) return qfalse;
ADDRLP4 60
ADDRGP4 BotNumActivePlayers
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 1
GTI4 $553
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $553
line 837
;837:	if (!BotValidChatPosition(bs)) return qfalse;
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 BotValidChatPosition
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
NEI4 $555
CNSTI4 0
RETI4
ADDRGP4 $530
JUMPV
LABELV $555
line 839
;838:	//
;839:	if (bs->lastkilledplayer == bs->client) {
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ADDRLP4 68
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $557
line 840
;840:		strcpy(name, BotRandomOpponentName(bs));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 0
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 841
;841:	}
ADDRGP4 $558
JUMPV
LABELV $557
line 842
;842:	else {
line 843
;843:		EasyClientName(bs->lastkilledplayer, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 844
;844:	}
LABELV $558
line 846
;845:	//
;846:	if (random() < trap_Characteristic_BFloat(bs->character, CHARACTERISTIC_CHAT_MISC, 0, 1)) {
ADDRLP4 72
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 25
ARGI4
CNSTF4 0
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 76
ADDRGP4 trap_Characteristic_BFloat
CALLF4
ASGNF4
ADDRLP4 72
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 76
INDIRF4
GEF4 $559
line 847
;847:		BotAI_BotInitialChat(bs, "random_misc",
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 84
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRLP4 88
ADDRGP4 BotRandomWeaponName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $561
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 92
ADDRGP4 $267
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 88
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 855
;848:					BotRandomOpponentName(bs),	// 0
;849:					name,						// 1
;850:					"[invalid var]",			// 2
;851:					"[invalid var]",			// 3
;852:					BotMapTitle(),				// 4
;853:					BotRandomWeaponName(),		// 5
;854:					NULL);
;855:	}
ADDRGP4 $560
JUMPV
LABELV $559
line 856
;856:	else {
line 857
;857:		BotAI_BotInitialChat(bs, "random_insult",
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 84
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRLP4 88
ADDRGP4 BotRandomWeaponName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $562
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 92
ADDRGP4 $267
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 88
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 865
;858:					BotRandomOpponentName(bs),	// 0
;859:					name,						// 1
;860:					"[invalid var]",			// 2
;861:					"[invalid var]",			// 3
;862:					BotMapTitle(),				// 4
;863:					BotRandomWeaponName(),		// 5
;864:					NULL);
;865:	}
LABELV $560
line 866
;866:	bs->lastchat_time = trap_AAS_Time();
ADDRLP4 80
ADDRGP4 trap_AAS_Time
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 6072
ADDP4
ADDRLP4 80
INDIRF4
ASGNF4
line 867
;867:	bs->chatto = CHAT_ALL;
ADDRFP4 0
INDIRP4
CNSTI4 6024
ADDP4
CNSTI4 0
ASGNI4
line 868
;868:	return qtrue;
CNSTI4 1
RETI4
LABELV $530
endproc BotChat_Random 96 36
export BotChatTime
proc BotChatTime 8 16
line 876
;869:}
;870:
;871:/*
;872:==================
;873:BotChatTime
;874:==================
;875:*/
;876:float BotChatTime(bot_state_t *bs) {
line 879
;877:	int cpm;
;878:
;879:	cpm = trap_Characteristic_BInteger(bs->character, CHARACTERISTIC_CHAT_CPM, 1, 4000);
ADDRFP4 0
INDIRP4
CNSTI4 6208
ADDP4
INDIRI4
ARGI4
CNSTI4 23
ARGI4
CNSTI4 1
ARGI4
CNSTI4 4000
ARGI4
ADDRLP4 4
ADDRGP4 trap_Characteristic_BInteger
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
ASGNI4
line 881
;880:
;881:	return 2.0;	//(float) trap_BotChatLength(bs->cs) * 30 / cpm;
CNSTF4 1073741824
RETF4
LABELV $563
endproc BotChatTime 8 16
export BotChatTest
proc BotChatTest 184 36
line 889
;882:}
;883:
;884:/*
;885:==================
;886:BotChatTest
;887:==================
;888:*/
;889:void BotChatTest(bot_state_t *bs) {
line 895
;890:
;891:	char name[32];
;892:	char *weap;
;893:	int num, i;
;894:
;895:	num = trap_BotNumInitialChats(bs->cs, "game_enter");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $266
ARGP4
ADDRLP4 44
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 44
INDIRI4
ASGNI4
line 896
;896:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $568
JUMPV
LABELV $565
line 897
;897:	{
line 898
;898:		BotAI_BotInitialChat(bs, "game_enter",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 48
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 56
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $266
ARGP4
ADDRLP4 48
INDIRP4
ARGP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 60
ADDRGP4 $267
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 905
;899:					EasyClientName(bs->client, name, 32),	// 0
;900:					BotRandomOpponentName(bs),				// 1
;901:					"[invalid var]",						// 2
;902:					"[invalid var]",						// 3
;903:					BotMapTitle(),							// 4
;904:					NULL);
;905:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 906
;906:	}
LABELV $566
line 896
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $568
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $565
line 907
;907:	num = trap_BotNumInitialChats(bs->cs, "game_exit");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $283
ARGP4
ADDRLP4 48
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 48
INDIRI4
ASGNI4
line 908
;908:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $572
JUMPV
LABELV $569
line 909
;909:	{
line 910
;910:		BotAI_BotInitialChat(bs, "game_exit",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 52
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 60
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $283
ARGP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 $267
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 917
;911:					EasyClientName(bs->client, name, 32),	// 0
;912:					BotRandomOpponentName(bs),				// 1
;913:					"[invalid var]",						// 2
;914:					"[invalid var]",						// 3
;915:					BotMapTitle(),							// 4
;916:					NULL);
;917:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 68
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 68
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 918
;918:	}
LABELV $570
line 908
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $572
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $569
line 919
;919:	num = trap_BotNumInitialChats(bs->cs, "level_start");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $301
ARGP4
ADDRLP4 52
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 52
INDIRI4
ASGNI4
line 920
;920:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $576
JUMPV
LABELV $573
line 921
;921:	{
line 922
;922:		BotAI_BotInitialChat(bs, "level_start",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 56
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $301
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 925
;923:					EasyClientName(bs->client, name, 32),	// 0
;924:					NULL);
;925:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 60
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 60
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 926
;926:	}
LABELV $574
line 920
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $576
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $573
line 927
;927:	num = trap_BotNumInitialChats(bs->cs, "level_end_victory");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $321
ARGP4
ADDRLP4 56
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 56
INDIRI4
ASGNI4
line 928
;928:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $580
JUMPV
LABELV $577
line 929
;929:	{
line 930
;930:		BotAI_BotInitialChat(bs, "level_end_victory",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 60
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 68
ADDRGP4 BotFirstClientInRankings
CALLP4
ASGNP4
ADDRLP4 72
ADDRGP4 BotLastClientInRankings
CALLP4
ASGNP4
ADDRLP4 76
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $321
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 937
;931:				EasyClientName(bs->client, name, 32),	// 0
;932:				BotRandomOpponentName(bs),				// 1
;933:				BotFirstClientInRankings(),				// 2
;934:				BotLastClientInRankings(),				// 3
;935:				BotMapTitle(),							// 4
;936:				NULL);
;937:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 80
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 938
;938:	}
LABELV $578
line 928
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $580
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $577
line 939
;939:	num = trap_BotNumInitialChats(bs->cs, "level_end_lose");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $324
ARGP4
ADDRLP4 60
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 60
INDIRI4
ASGNI4
line 940
;940:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $584
JUMPV
LABELV $581
line 941
;941:	{
line 942
;942:		BotAI_BotInitialChat(bs, "level_end_lose",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 64
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 72
ADDRGP4 BotFirstClientInRankings
CALLP4
ASGNP4
ADDRLP4 76
ADDRGP4 BotLastClientInRankings
CALLP4
ASGNP4
ADDRLP4 80
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $324
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 949
;943:				EasyClientName(bs->client, name, 32),	// 0
;944:				BotRandomOpponentName(bs),				// 1
;945:				BotFirstClientInRankings(),				// 2
;946:				BotLastClientInRankings(),				// 3
;947:				BotMapTitle(),							// 4
;948:				NULL);
;949:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 84
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 950
;950:	}
LABELV $582
line 940
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $584
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $581
line 951
;951:	num = trap_BotNumInitialChats(bs->cs, "level_end");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $325
ARGP4
ADDRLP4 64
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 64
INDIRI4
ASGNI4
line 952
;952:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $588
JUMPV
LABELV $585
line 953
;953:	{
line 954
;954:		BotAI_BotInitialChat(bs, "level_end",
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRLP4 68
ADDRGP4 EasyClientName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 76
ADDRGP4 BotFirstClientInRankings
CALLP4
ASGNP4
ADDRLP4 80
ADDRGP4 BotLastClientInRankings
CALLP4
ASGNP4
ADDRLP4 84
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $325
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 961
;955:				EasyClientName(bs->client, name, 32),	// 0
;956:				BotRandomOpponentName(bs),				// 1
;957:				BotFirstClientInRankings(),				// 2
;958:				BotLastClientInRankings(),				// 3
;959:				BotMapTitle(),							// 4
;960:				NULL);
;961:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 88
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 962
;962:	}
LABELV $586
line 952
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $588
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $585
line 963
;963:	EasyClientName(bs->lastkilledby, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 5972
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 964
;964:	num = trap_BotNumInitialChats(bs->cs, "death_drown");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $351
ARGP4
ADDRLP4 68
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 68
INDIRI4
ASGNI4
line 965
;965:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $592
JUMPV
LABELV $589
line 966
;966:	{
line 968
;967:		//
;968:		BotAI_BotInitialChat(bs, "death_drown", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $351
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 969
;969:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 72
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 72
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 970
;970:	}
LABELV $590
line 965
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $592
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $589
line 971
;971:	num = trap_BotNumInitialChats(bs->cs, "death_slime");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $354
ARGP4
ADDRLP4 72
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 72
INDIRI4
ASGNI4
line 972
;972:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $596
JUMPV
LABELV $593
line 973
;973:	{
line 974
;974:		BotAI_BotInitialChat(bs, "death_slime", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $354
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 975
;975:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 976
;976:	}
LABELV $594
line 972
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $596
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $593
line 977
;977:	num = trap_BotNumInitialChats(bs->cs, "death_lava");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $357
ARGP4
ADDRLP4 76
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 76
INDIRI4
ASGNI4
line 978
;978:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $600
JUMPV
LABELV $597
line 979
;979:	{
line 980
;980:		BotAI_BotInitialChat(bs, "death_lava", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $357
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 981
;981:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 80
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 982
;982:	}
LABELV $598
line 978
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $600
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $597
line 983
;983:	num = trap_BotNumInitialChats(bs->cs, "death_cratered");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $360
ARGP4
ADDRLP4 80
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 80
INDIRI4
ASGNI4
line 984
;984:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $604
JUMPV
LABELV $601
line 985
;985:	{
line 986
;986:		BotAI_BotInitialChat(bs, "death_cratered", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $360
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 987
;987:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 84
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 988
;988:	}
LABELV $602
line 984
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $604
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $601
line 989
;989:	num = trap_BotNumInitialChats(bs->cs, "death_suicide");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $368
ARGP4
ADDRLP4 84
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 84
INDIRI4
ASGNI4
line 990
;990:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $608
JUMPV
LABELV $605
line 991
;991:	{
line 992
;992:		BotAI_BotInitialChat(bs, "death_suicide", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $368
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 993
;993:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 88
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 994
;994:	}
LABELV $606
line 990
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $608
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $605
line 995
;995:	num = trap_BotNumInitialChats(bs->cs, "death_telefrag");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $371
ARGP4
ADDRLP4 88
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 88
INDIRI4
ASGNI4
line 996
;996:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $612
JUMPV
LABELV $609
line 997
;997:	{
line 998
;998:		BotAI_BotInitialChat(bs, "death_telefrag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $371
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 999
;999:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 92
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1000
;1000:	}
LABELV $610
line 996
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $612
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $609
line 1001
;1001:	num = trap_BotNumInitialChats(bs->cs, "death_gauntlet");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $379
ARGP4
ADDRLP4 92
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 92
INDIRI4
ASGNI4
line 1002
;1002:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $616
JUMPV
LABELV $613
line 1003
;1003:	{
line 1004
;1004:		BotAI_BotInitialChat(bs, "death_gauntlet",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 96
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $379
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 96
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1008
;1005:				name,												// 0
;1006:				BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;1007:				NULL);
;1008:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 100
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 100
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1009
;1009:	}
LABELV $614
line 1002
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $616
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $613
line 1010
;1010:	num = trap_BotNumInitialChats(bs->cs, "death_rail");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $382
ARGP4
ADDRLP4 96
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 96
INDIRI4
ASGNI4
line 1011
;1011:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $620
JUMPV
LABELV $617
line 1012
;1012:	{
line 1013
;1013:		BotAI_BotInitialChat(bs, "death_rail",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 100
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $382
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 100
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1017
;1014:				name,												// 0
;1015:				BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;1016:				NULL);
;1017:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 104
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 104
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 104
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1018
;1018:	}
LABELV $618
line 1011
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $620
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $617
line 1019
;1019:	num = trap_BotNumInitialChats(bs->cs, "death_bfg");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $383
ARGP4
ADDRLP4 100
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 100
INDIRI4
ASGNI4
line 1020
;1020:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $624
JUMPV
LABELV $621
line 1021
;1021:	{
line 1022
;1022:		BotAI_BotInitialChat(bs, "death_bfg",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 104
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $383
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 104
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1026
;1023:				name,												// 0
;1024:				BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;1025:				NULL);
;1026:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 108
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1027
;1027:	}
LABELV $622
line 1020
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $624
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $621
line 1028
;1028:	num = trap_BotNumInitialChats(bs->cs, "death_insult");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $386
ARGP4
ADDRLP4 104
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 104
INDIRI4
ASGNI4
line 1029
;1029:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $628
JUMPV
LABELV $625
line 1030
;1030:	{
line 1031
;1031:		BotAI_BotInitialChat(bs, "death_insult",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 108
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $386
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 108
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1035
;1032:					name,												// 0
;1033:					BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;1034:					NULL);
;1035:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 112
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 112
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 112
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1036
;1036:	}
LABELV $626
line 1029
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $628
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $625
line 1037
;1037:	num = trap_BotNumInitialChats(bs->cs, "death_praise");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $387
ARGP4
ADDRLP4 108
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 108
INDIRI4
ASGNI4
line 1038
;1038:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $632
JUMPV
LABELV $629
line 1039
;1039:	{
line 1040
;1040:		BotAI_BotInitialChat(bs, "death_praise",
ADDRFP4 0
INDIRP4
CNSTI4 5976
ADDP4
INDIRI4
ARGI4
ADDRLP4 112
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $387
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 112
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1044
;1041:					name,												// 0
;1042:					BotWeaponNameForMeansOfDeath(bs->botdeathtype),		// 1
;1043:					NULL);
;1044:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 116
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 116
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 116
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1045
;1045:	}
LABELV $630
line 1038
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $632
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $629
line 1047
;1046:	//
;1047:	EasyClientName(bs->lastkilledplayer, name, 32);
ADDRFP4 0
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 1049
;1048:	//
;1049:	num = trap_BotNumInitialChats(bs->cs, "kill_gauntlet");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $414
ARGP4
ADDRLP4 112
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 112
INDIRI4
ASGNI4
line 1050
;1050:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $636
JUMPV
LABELV $633
line 1051
;1051:	{
line 1053
;1052:		//
;1053:		BotAI_BotInitialChat(bs, "kill_gauntlet", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $414
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1054
;1054:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 116
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 116
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 116
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1055
;1055:	}
LABELV $634
line 1050
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $636
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $633
line 1056
;1056:	num = trap_BotNumInitialChats(bs->cs, "kill_rail");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $417
ARGP4
ADDRLP4 116
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 116
INDIRI4
ASGNI4
line 1057
;1057:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $640
JUMPV
LABELV $637
line 1058
;1058:	{
line 1059
;1059:		BotAI_BotInitialChat(bs, "kill_rail", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $417
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1060
;1060:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 120
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 120
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 120
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1061
;1061:	}
LABELV $638
line 1057
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $640
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $637
line 1062
;1062:	num = trap_BotNumInitialChats(bs->cs, "kill_telefrag");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $420
ARGP4
ADDRLP4 120
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 120
INDIRI4
ASGNI4
line 1063
;1063:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $644
JUMPV
LABELV $641
line 1064
;1064:	{
line 1065
;1065:		BotAI_BotInitialChat(bs, "kill_telefrag", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $420
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1066
;1066:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 124
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1067
;1067:	}
LABELV $642
line 1063
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $644
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $641
line 1068
;1068:	num = trap_BotNumInitialChats(bs->cs, "kill_insult");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $423
ARGP4
ADDRLP4 124
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 124
INDIRI4
ASGNI4
line 1069
;1069:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $648
JUMPV
LABELV $645
line 1070
;1070:	{
line 1071
;1071:		BotAI_BotInitialChat(bs, "kill_insult", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $423
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1072
;1072:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 128
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 128
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 128
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1073
;1073:	}
LABELV $646
line 1069
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $648
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $645
line 1074
;1074:	num = trap_BotNumInitialChats(bs->cs, "kill_praise");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $424
ARGP4
ADDRLP4 128
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 128
INDIRI4
ASGNI4
line 1075
;1075:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $652
JUMPV
LABELV $649
line 1076
;1076:	{
line 1077
;1077:		BotAI_BotInitialChat(bs, "kill_praise", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $424
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1078
;1078:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 132
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 132
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 132
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1079
;1079:	}
LABELV $650
line 1075
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $652
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $649
line 1080
;1080:	num = trap_BotNumInitialChats(bs->cs, "enemy_suicide");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $447
ARGP4
ADDRLP4 132
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 132
INDIRI4
ASGNI4
line 1081
;1081:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $656
JUMPV
LABELV $653
line 1082
;1082:	{
line 1083
;1083:		BotAI_BotInitialChat(bs, "enemy_suicide", name, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $447
ARGP4
ADDRLP4 8
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1084
;1084:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 136
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 136
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 136
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1085
;1085:	}
LABELV $654
line 1081
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $656
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $653
line 1086
;1086:	ClientName(g_entities[bs->client].client->lasthurt_client, name, sizeof(name));
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 ClientName
CALLP4
pop
line 1087
;1087:	weap = BotWeaponNameForMeansOfDeath(g_entities[bs->client].client->lasthurt_client);
CNSTI4 792
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities+504
ADDP4
INDIRP4
CNSTI4 672
ADDP4
INDIRI4
ARGI4
ADDRLP4 136
ADDRGP4 BotWeaponNameForMeansOfDeath
CALLP4
ASGNP4
ADDRLP4 40
ADDRLP4 136
INDIRP4
ASGNP4
line 1088
;1088:	num = trap_BotNumInitialChats(bs->cs, "hit_talking");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $475
ARGP4
ADDRLP4 140
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 140
INDIRI4
ASGNI4
line 1089
;1089:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $662
JUMPV
LABELV $659
line 1090
;1090:	{
line 1091
;1091:		BotAI_BotInitialChat(bs, "hit_talking", name, weap, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $475
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 40
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1092
;1092:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 144
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 144
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 144
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1093
;1093:	}
LABELV $660
line 1089
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $662
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $659
line 1094
;1094:	num = trap_BotNumInitialChats(bs->cs, "hit_nodeath");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $506
ARGP4
ADDRLP4 144
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 144
INDIRI4
ASGNI4
line 1095
;1095:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $666
JUMPV
LABELV $663
line 1096
;1096:	{
line 1097
;1097:		BotAI_BotInitialChat(bs, "hit_nodeath", name, weap, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $506
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 40
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1098
;1098:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 148
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 148
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 148
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1099
;1099:	}
LABELV $664
line 1095
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $666
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $663
line 1100
;1100:	num = trap_BotNumInitialChats(bs->cs, "hit_nokill");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $529
ARGP4
ADDRLP4 148
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 148
INDIRI4
ASGNI4
line 1101
;1101:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $670
JUMPV
LABELV $667
line 1102
;1102:	{
line 1103
;1103:		BotAI_BotInitialChat(bs, "hit_nokill", name, weap, NULL);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $529
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 40
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1104
;1104:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 152
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 152
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 152
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1105
;1105:	}
LABELV $668
line 1101
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $670
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $667
line 1107
;1106:	//
;1107:	if (bs->lastkilledplayer == bs->client) {
ADDRLP4 152
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 152
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ADDRLP4 152
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
NEI4 $671
line 1108
;1108:		strcpy(name, BotRandomOpponentName(bs));
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 156
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 8
ARGP4
ADDRLP4 156
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1109
;1109:	}
ADDRGP4 $672
JUMPV
LABELV $671
line 1110
;1110:	else {
line 1111
;1111:		EasyClientName(bs->lastkilledplayer, name, sizeof(name));
ADDRFP4 0
INDIRP4
CNSTI4 5968
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 EasyClientName
CALLP4
pop
line 1112
;1112:	}
LABELV $672
line 1114
;1113:	//
;1114:	num = trap_BotNumInitialChats(bs->cs, "random_misc");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $561
ARGP4
ADDRLP4 156
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 156
INDIRI4
ASGNI4
line 1115
;1115:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $676
JUMPV
LABELV $673
line 1116
;1116:	{
line 1118
;1117:		//
;1118:		BotAI_BotInitialChat(bs, "random_misc",
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 160
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 164
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRLP4 168
ADDRGP4 BotRandomWeaponName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $561
ARGP4
ADDRLP4 160
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 172
ADDRGP4 $267
ASGNP4
ADDRLP4 172
INDIRP4
ARGP4
ADDRLP4 172
INDIRP4
ARGP4
ADDRLP4 164
INDIRP4
ARGP4
ADDRLP4 168
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1126
;1119:					BotRandomOpponentName(bs),	// 0
;1120:					name,						// 1
;1121:					"[invalid var]",			// 2
;1122:					"[invalid var]",			// 3
;1123:					BotMapTitle(),				// 4
;1124:					BotRandomWeaponName(),		// 5
;1125:					NULL);
;1126:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 176
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 176
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1127
;1127:	}
LABELV $674
line 1115
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $676
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $673
line 1128
;1128:	num = trap_BotNumInitialChats(bs->cs, "random_insult");
ADDRFP4 0
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRGP4 $562
ARGP4
ADDRLP4 160
ADDRGP4 trap_BotNumInitialChats
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 160
INDIRI4
ASGNI4
line 1129
;1129:	for (i = 0; i < num; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $680
JUMPV
LABELV $677
line 1130
;1130:	{
line 1131
;1131:		BotAI_BotInitialChat(bs, "random_insult",
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 164
ADDRGP4 BotRandomOpponentName
CALLP4
ASGNP4
ADDRLP4 168
ADDRGP4 BotMapTitle
CALLP4
ASGNP4
ADDRLP4 172
ADDRGP4 BotRandomWeaponName
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $562
ARGP4
ADDRLP4 164
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 176
ADDRGP4 $267
ASGNP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRLP4 168
INDIRP4
ARGP4
ADDRLP4 172
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 BotAI_BotInitialChat
CALLV
pop
line 1139
;1132:					BotRandomOpponentName(bs),	// 0
;1133:					name,						// 1
;1134:					"[invalid var]",			// 2
;1135:					"[invalid var]",			// 3
;1136:					BotMapTitle(),				// 4
;1137:					BotRandomWeaponName(),		// 5
;1138:					NULL);
;1139:		trap_BotEnterChat(bs->cs, bs->client, CHAT_ALL);
ADDRLP4 180
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 180
INDIRP4
CNSTI4 6220
ADDP4
INDIRI4
ARGI4
ADDRLP4 180
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 trap_BotEnterChat
CALLV
pop
line 1140
;1140:	}
LABELV $678
line 1129
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $680
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $677
line 1141
;1141:}
LABELV $564
endproc BotChatTest 184 36
import BotDumpNodeSwitches
import BotResetNodeSwitches
import AINode_Battle_NBG
import AINode_Battle_Retreat
import AINode_Battle_Chase
import AINode_Battle_Fight
import AINode_Seek_LTG
import AINode_Seek_NBG
import AINode_Seek_ActivateEntity
import AINode_Stand
import AINode_Respawn
import AINode_Observer
import AINode_Intermission
import AIEnter_Battle_NBG
import AIEnter_Battle_Retreat
import AIEnter_Battle_Chase
import AIEnter_Battle_Fight
import AIEnter_Seek_Camp
import AIEnter_Seek_LTG
import AIEnter_Seek_NBG
import AIEnter_Seek_ActivateEntity
import AIEnter_Stand
import AIEnter_Respawn
import AIEnter_Observer
import AIEnter_Intermission
import BotPrintTeamGoal
import BotMatchMessage
import ctf_blueflag
import ctf_redflag
import bot_challenge
import bot_testrchat
import bot_nochat
import bot_fastchat
import bot_rocketjump
import bot_grapple
import maxclients
import gametype
import BotMapScripts
import BotPointAreaNum
import ClientFromName
import stristr
import BotFindWayPoint
import BotCreateWayPoint
import BotCTFRetreatGoals
import BotCTFSeekGoals
import BotCTFCarryingFlag
import BotCTFTeam
import BotAIBlocked
import BotCheckAttack
import BotAimAtEnemy
import BotEntityVisible
import BotRoamGoal
import BotFindEnemy
import BotTeamFlagCarrierVisible
import TeamPlayIsOn
import BotSameTeam
import BotAttackMove
import BotWantsToCamp
import BotCanAndWantsToRocketJump
import BotWantsToHelp
import BotWantsToChase
import BotWantsToRetreat
import BotAggression
import ClientSkin
import EasyClientName
import ClientName
import EntityIsShooting
import EntityIsInvisible
import EntityIsDead
import BotInLavaOrSlime
import BotIntermission
import BotIsObserver
import BotIsDead
import BotBattleUseItems
import BotUpdateBattleInventory
import BotUpdateInventory
import BotSetupForMovement
import BotChooseWeapon
import BotFreeWaypoints
import BotDeathmatchAI
import BotShutdownDeathmatchAI
import BotSetupDeathmatchAI
import BotTeamLeader
import BotAI_GetSnapshotEntity
import BotAI_GetEntityState
import BotAI_GetClientState
import BotAI_Trace
import BotAI_BotInitialChat
import BotAI_Print
import BotEntityInfo
import NumBots
import BotResetState
import BotResetWeaponState
import BotFreeWeaponState
import BotAllocWeaponState
import BotLoadWeaponWeights
import BotGetWeaponInfo
import BotChooseBestFightWeapon
import BotShutdownWeaponAI
import BotSetupWeaponAI
import BotShutdownMoveAI
import BotSetupMoveAI
import BotSetBrushModelTypes
import BotInitMoveState
import BotFreeMoveState
import BotAllocMoveState
import BotPredictVisiblePosition
import BotMovementViewTarget
import BotReachabilityArea
import BotResetLastAvoidReach
import BotResetAvoidReach
import BotMoveInDirection
import BotMoveToGoal
import BotResetMoveState
import BotShutdownGoalAI
import BotSetupGoalAI
import BotFreeGoalState
import BotAllocGoalState
import BotFreeItemWeights
import BotLoadItemWeights
import BotMutateGoalFuzzyLogic
import BotSaveGoalFuzzyLogic
import BotInterbreedGoalFuzzyLogic
import BotUpdateEntityItems
import BotInitLevelItems
import BotAvoidGoalTime
import BotGetMapLocationGoal
import BotGetNextCampSpotGoal
import BotGetLevelItemGoal
import BotItemGoalInVisButNotVisible
import BotTouchingGoal
import BotChooseNBGItem
import BotChooseLTGItem
import BotGetSecondGoal
import BotGetTopGoal
import BotGoalName
import BotDumpGoalStack
import BotDumpAvoidGoals
import BotEmptyGoalStack
import BotPopGoal
import BotPushGoal
import BotRemoveFromAvoidGoals
import BotResetAvoidGoals
import BotResetGoalState
import GeneticParentsAndChildSelection
import BotSetChatName
import BotSetChatGender
import BotLoadChatFile
import BotReplaceSynonyms
import UnifyWhiteSpaces
import BotMatchVariable
import BotFindMatch
import StringContains
import BotGetChatMessage
import BotEnterChat
import BotChatLength
import BotReplyChat
import BotNumInitialChats
import BotInitialChat
import BotNumConsoleMessages
import BotNextConsoleMessage
import BotRemoveConsoleMessage
import BotQueueConsoleMessage
import BotFreeChatState
import BotAllocChatState
import BotShutdownChatAI
import BotSetupChatAI
import BotShutdownCharacters
import Characteristic_String
import Characteristic_BInteger
import Characteristic_Integer
import Characteristic_BFloat
import Characteristic_Float
import BotFreeCharacter
import BotLoadCharacter
import EA_Shutdown
import EA_Setup
import EA_ResetInput
import EA_GetInput
import EA_EndRegular
import EA_View
import EA_Move
import EA_MoveRight
import EA_MoveLeft
import EA_MoveBack
import EA_MoveForward
import EA_MoveDown
import EA_MoveUp
import EA_Walk
import EA_Crouch
import EA_DelayedJump
import EA_Jump
import EA_Use
import EA_Gesture
import EA_Talk
import EA_Respawn
import EA_Attack
import EA_SelectWeapon
import EA_Command
import EA_DropInv
import EA_UseInv
import EA_DropItem
import EA_UseItem
import EA_SayTeam
import EA_Say
import GetBotLibAPI
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $562
byte 1 114
byte 1 97
byte 1 110
byte 1 100
byte 1 111
byte 1 109
byte 1 95
byte 1 105
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $561
byte 1 114
byte 1 97
byte 1 110
byte 1 100
byte 1 111
byte 1 109
byte 1 95
byte 1 109
byte 1 105
byte 1 115
byte 1 99
byte 1 0
align 1
LABELV $529
byte 1 104
byte 1 105
byte 1 116
byte 1 95
byte 1 110
byte 1 111
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $506
byte 1 104
byte 1 105
byte 1 116
byte 1 95
byte 1 110
byte 1 111
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $475
byte 1 104
byte 1 105
byte 1 116
byte 1 95
byte 1 116
byte 1 97
byte 1 108
byte 1 107
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $447
byte 1 101
byte 1 110
byte 1 101
byte 1 109
byte 1 121
byte 1 95
byte 1 115
byte 1 117
byte 1 105
byte 1 99
byte 1 105
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $446
byte 1 0
align 1
LABELV $424
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 112
byte 1 114
byte 1 97
byte 1 105
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $423
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 105
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $420
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 116
byte 1 101
byte 1 108
byte 1 101
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $417
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 0
align 1
LABELV $414
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 103
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 108
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $409
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 109
byte 1 97
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $387
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 112
byte 1 114
byte 1 97
byte 1 105
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $386
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 105
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $383
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 98
byte 1 102
byte 1 103
byte 1 0
align 1
LABELV $382
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 0
align 1
LABELV $379
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 103
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 108
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $371
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 116
byte 1 101
byte 1 108
byte 1 101
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $368
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 115
byte 1 117
byte 1 105
byte 1 99
byte 1 105
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $360
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $357
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 108
byte 1 97
byte 1 118
byte 1 97
byte 1 0
align 1
LABELV $354
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 115
byte 1 108
byte 1 105
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $351
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 100
byte 1 114
byte 1 111
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $346
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 109
byte 1 97
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $341
byte 1 91
byte 1 119
byte 1 111
byte 1 114
byte 1 108
byte 1 100
byte 1 93
byte 1 0
align 1
LABELV $325
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 95
byte 1 101
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $324
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 95
byte 1 101
byte 1 110
byte 1 100
byte 1 95
byte 1 108
byte 1 111
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $321
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 95
byte 1 101
byte 1 110
byte 1 100
byte 1 95
byte 1 118
byte 1 105
byte 1 99
byte 1 116
byte 1 111
byte 1 114
byte 1 121
byte 1 0
align 1
LABELV $301
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 95
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $283
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 95
byte 1 101
byte 1 120
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $267
byte 1 91
byte 1 105
byte 1 110
byte 1 118
byte 1 97
byte 1 108
byte 1 105
byte 1 100
byte 1 32
byte 1 118
byte 1 97
byte 1 114
byte 1 93
byte 1 0
align 1
LABELV $266
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 95
byte 1 101
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $188
byte 1 91
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 93
byte 1 0
align 1
LABELV $187
byte 1 71
byte 1 114
byte 1 97
byte 1 112
byte 1 112
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $185
byte 1 66
byte 1 70
byte 1 71
byte 1 49
byte 1 48
byte 1 75
byte 1 0
align 1
LABELV $183
byte 1 76
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 71
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $181
byte 1 82
byte 1 97
byte 1 105
byte 1 108
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $179
byte 1 80
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $177
byte 1 82
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 32
byte 1 76
byte 1 97
byte 1 117
byte 1 110
byte 1 99
byte 1 104
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $175
byte 1 71
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 32
byte 1 76
byte 1 97
byte 1 117
byte 1 110
byte 1 99
byte 1 104
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $173
byte 1 77
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $171
byte 1 71
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 108
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $169
byte 1 83
byte 1 104
byte 1 111
byte 1 116
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $163
byte 1 109
byte 1 97
byte 1 112
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $62
byte 1 116
byte 1 0
align 1
LABELV $58
byte 1 110
byte 1 0
align 1
LABELV $51
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
