// Copyright (C) 1999-2000 Id Software, Inc.
//
#include "g_local.h"

#define	MISSILE_PRESTEP_TIME	0;//50

/*
================
G_BounceMissile

================
*/
void G_BounceMissile( gentity_t *ent, trace_t *trace ) {
	vec3_t	velocity;
	float	dot;
	int		hitTime;

	// reflect the velocity on the trace plane
	hitTime = level.previousTime + ( level.time - level.previousTime ) * trace->fraction;
	BG_EvaluateTrajectoryDelta( &ent->s.pos, hitTime, velocity );
	dot = DotProduct( velocity, trace->plane.normal );
	VectorMA( trace->endpos, 2, trace->plane.normal, ent->r.currentOrigin);
	VectorCopy(trace->endpos, ent->s.pos.trBase);
	ent->s.pos.trTime = hitTime;
		
	VectorMA( velocity, -2*dot, trace->plane.normal, ent->s.pos.trDelta );
	if ( ent->s.eFlags & EF_BOUNCE_HALF ) {
		VectorScale( ent->s.pos.trDelta, 0.65, ent->s.pos.trDelta );
		// check for stop
		if ( trace->plane.normal[2] > 0.2 && VectorLength( ent->s.pos.trDelta ) < 40 ) 
		{
			G_SetOrigin( ent, trace->endpos );
			//## Hentai ## - set it gently on the ground
			if(ent->s.eType == ET_ITEM)
			{
				int dt = level.time - ent->s.pos.trTime;
				//CG_Printf("rest?\n");
				if(ent->s.angles[PITCH] > dt / 10)
					ent->s.angles[PITCH] -= dt / 10;
				else if(ent->s.angles[PITCH] < -dt / 10)
					ent->s.angles[PITCH] += dt / 10;
				else
				{
					ent->s.angles[PITCH] = 0;
					if(ent->s.angles[ROLL] == 0)
					{
						ent->s.angles[ROLL] = ((rand() & 1) * 2) - 1; // 1 or -1
					}
					else if(ent->s.angles[ROLL] > 0)
					{
						ent->s.angles[ROLL] += dt / 10;
						if(ent->s.angles[ROLL] > 75)
							ent->s.angles[ROLL] = 75;
					}
					else 
					{
						ent->s.angles[ROLL] -= dt / 10;
						if(ent->s.angles[ROLL] < -75)
							ent->s.angles[ROLL] = -75;
					}
				}
				
			}
			else
			//## Hentai ##
				return;
		}
	}

	//VectorAdd( ent->r.currentOrigin, trace->plane.normal, ent->r.currentOrigin);
	
	
}


/*
================
G_MissileImpact

================
*/
void G_MissileImpact( gentity_t *ent, trace_t *trace ) {
	gentity_t		*other;
	qboolean		hitClient = qfalse;

	other = &g_entities[trace->entityNum];		
	
	// check for bounce
	if ( !(other->takedamage && (g_ImpactGrenades.integer)) &&
		( ent->s.eFlags & ( EF_BOUNCE | EF_BOUNCE_HALF ) ) ) {
		G_BounceMissile( ent, trace );
		if(other->takedamage && other->client)		
		{
			vec3_t velocity;
			VectorCopy(ent->s.pos.trDelta, velocity);
			VectorNormalize(velocity);
			VectorCopy(other->s.pos.trDelta, ent->s.pos.trDelta);
			/*
			ent->s.pos.trDelta[0] = (ent->s.pos.trDelta[0] + other->s.pos.trDelta[0]) / 2;
			ent->s.pos.trDelta[1] = (ent->s.pos.trDelta[1] + other->s.pos.trDelta[1]) / 2;
			ent->s.pos.trDelta[2] = (ent->s.pos.trDelta[2] + other->s.pos.trDelta[2]) / 2;
			*/
			G_Damage (other, ent, &g_entities[ent->r.ownerNum], velocity,
				trace->endpos, 2, DAMAGE_NO_BLEEDING, ent->methodOfDeath);
		}
		else
			G_AddEvent( ent, EV_GRENADE_BOUNCE, 0 );
		return;
	}

	// impact damage
	if (other->takedamage) {
		// FIXME: wrong damage direction?
		if ( ent->damage ) {
			vec3_t	velocity;
			int dflags = 0;

			if( LogAccuracyHit( other, &g_entities[ent->r.ownerNum] ) ) {
				g_entities[ent->r.ownerNum].client->ps.persistant[PERS_ACCURACY_HITS]++;
				hitClient = qtrue;
			}
			BG_EvaluateTrajectoryDelta( &ent->s.pos, level.time, velocity );
			if ( VectorLength( velocity ) == 0 ) {
				velocity[2] = 1;	// stepped on a grenade
			}
			if(ent->s.eFlags & (EF_BOUNCE | EF_BOUNCE_HALF))
				dflags = 0; // grenades have shrapnel				
			else
				dflags = DAMAGE_NO_BLEEDING; 

				G_Damage (other, ent, &g_entities[ent->r.ownerNum], velocity, 
				trace->endpos, ent->damage, dflags, ent->methodOfDeath);
		}
	}

	if (!strcmp(ent->classname, "hook")) {
		gentity_t *nent;
		vec3_t v;

		nent = G_Spawn();
		if ( other->takedamage && other->client ) {

			if(other->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
				G_AddEvent( nent, EV_MISSILE_HIT, DirToByte( trace->plane.normal ) );
			else
				G_AddEvent( nent, EV_MISSILE_HIT_ROBOT, DirToByte( trace->plane.normal ) );
		
			
			nent->s.otherEntityNum = other->s.number;

			ent->enemy = other;

			v[0] = other->r.currentOrigin[0] + (other->r.mins[0] + other->r.maxs[0]) * 0.5;
			v[1] = other->r.currentOrigin[1] + (other->r.mins[1] + other->r.maxs[1]) * 0.5;
			v[2] = other->r.currentOrigin[2] + (other->r.mins[2] + other->r.maxs[2]) * 0.5;

			SnapVectorTowards( v, ent->s.pos.trBase );	// save net bandwidth
		} else {
			//VectorCopy(trace->endpos, v);
			VectorMA( trace->endpos, 2, trace->plane.normal, v );
			
			G_AddEvent( nent, EV_MISSILE_MISS, DirToByte( trace->plane.normal ) );
			ent->enemy = NULL;
			

		}

		SnapVectorTowards( v, ent->s.pos.trBase );	// save net bandwidth

		nent->freeAfterEvent = qtrue;
		// change over to a normal entity right at the point of impact
		nent->s.eType = ET_GENERAL;
		ent->s.eType = ET_GRAPPLE;

		G_SetOrigin( ent, v );
		G_SetOrigin( nent, v );

		ent->think = Weapon_HookThink;
		ent->nextthink = level.time + FRAMETIME;

		ent->parent->client->ps.pm_flags |= PMF_GRAPPLE_PULL;
		VectorCopy( ent->r.currentOrigin, ent->parent->client->ps.grapplePoint);

		trap_LinkEntity( ent );
		trap_LinkEntity( nent );

		return;
	}

	// is it cheaper in bandwidth to just remove this ent and create a new
	// one, rather than changing the missile into the explosion?

	if ( other->takedamage && other->client ) {
			
		if(other->client->ps.stats[STAT_EXTENDED_INFO] & EXT_BLEEDS)		
			G_AddEvent( ent, EV_MISSILE_HIT, DirToByte( trace->plane.normal ) );
		else
			G_AddEvent( ent, EV_MISSILE_HIT_ROBOT, DirToByte( trace->plane.normal ) );
		
		ent->s.otherEntityNum = other->s.number;
	} else {
		VectorMA( trace->endpos, 2, trace->plane.normal, ent->s.pos.trBase);
		ent->s.pos.trTime = level.time;
		
		G_AddEvent( ent, EV_MISSILE_MISS, DirToByte( trace->plane.normal ) );
	}

	ent->freeAfterEvent = qtrue;

	// change over to a normal entity right at the point of impact
	ent->s.eType = ET_GENERAL;

	SnapVectorTowards( trace->endpos, ent->s.pos.trBase );	// save net bandwidth

	G_SetOrigin( ent, trace->endpos );

	// splash damage (doesn't apply to person directly hit)
	if ( ent->splashDamage ) {
		if( G_RadiusDamage( trace->endpos, ent->parent, ent->splashDamage, ent->splashRadius, 
			other, ent->splashMethodOfDeath ) ) {
			if( !hitClient ) {
				g_entities[ent->r.ownerNum].client->ps.persistant[PERS_ACCURACY_HITS]++;
			}
		}
	}

	trap_LinkEntity( ent );
}

/*
================
G_ExplodeMissile

Explode a missile without an impact
================
*/
void G_ExplodeMissile( gentity_t *ent ) {
	vec3_t		dir;
	vec3_t		origin;

	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
	SnapVector( origin );
	G_SetOrigin( ent, origin );

	// we don't have a valid direction, so just point straight up
	dir[0] = dir[1] = 0;
	dir[2] = 1;

	ent->s.eType = ET_GENERAL;
	G_AddEvent( ent, EV_MISSILE_MISS, DirToByte( dir ) );

	ent->freeAfterEvent = qtrue;

	// splash damage
	if ( ent->splashDamage ) {
		if( G_RadiusDamage( ent->r.currentOrigin, ent->parent, ent->splashDamage, ent->splashRadius, NULL
			, ent->splashMethodOfDeath ) ) {
			g_entities[ent->r.ownerNum].client->ps.persistant[PERS_ACCURACY_HITS]++;
		}
	}

	trap_LinkEntity( ent );
}


/*
================
G_RunMissile

================
*/
void G_RunMissile( gentity_t *ent ) {
	vec3_t		origin, velocity;
	trace_t		tr;
	float dt = (level.time - ent->s.pos.trTime) * 0.001;
	vec3_t forward;
	
	if((ent->methodOfDeath == MOD_ROCKET) && (g_RocketAccel.value || g_RocketVeer.value))
	{
		ent->s.angles[0] += crandom() * g_RocketVeer.value * dt;
		ent->s.angles[1] += crandom() * g_RocketVeer.value * dt;
		ent->s.angles[2] += crandom() * g_RocketVeer.value * dt;
		AngleVectors(ent->s.angles, forward, NULL, NULL);		
		VectorMA(ent->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, ent->s.pos.trDelta);
	}
	// get current position

	BG_EvaluateTrajectory( &ent->s.pos, level.time, origin );
	BG_EvaluateTrajectoryDelta( &ent->s.pos, level.time, velocity );
	// trace a line from the previous position to the current position,
	// ignoring interactions with the missile owner
	trap_Trace( &tr, ent->r.currentOrigin, ent->r.mins, ent->r.maxs, origin, 
		ent->r.ownerNum, ent->clipmask );



	if ( tr.startsolid ) {
		//G_Printf("???");
		tr.fraction = 0;
	}

	trap_LinkEntity( ent );
	VectorCopy(tr.endpos, ent->r.currentOrigin);
	if ( tr.fraction != 1.0 ) {
		// never explode or bounce on sky
		if ( tr.surfaceFlags & SURF_NOIMPACT ) {
			// If grapple, reset owner
			if (ent->parent && ent->parent->client->hook == ent)
				ent->parent->client->hook = NULL;
			G_FreeEntity( ent );
			return;
		}
		if((ent->methodOfDeath == MOD_ROCKET) && (tr.plane.normal[0] == -1 || tr.plane.normal[1] == -1 || tr.plane.normal[2] == -1))
		{ // for some reason these specific angles don't show up
			tr.plane.normal[0] += crandom() * 0.125;
			tr.plane.normal[1] += crandom() * 0.125;
			tr.plane.normal[2] += crandom() * 0.125;
			VectorNormalize(tr.plane.normal);
		}
	
		G_MissileImpact( ent, &tr );
		if ( ent->s.eType != ET_MISSILE ) {
			return;		// exploded
		}
	}

	else 
	{
		
		if((ent->methodOfDeath == MOD_ROCKET) && (g_RocketAccel.value || g_RocketVeer.value))
		{
			VectorMA(ent->s.pos.trBase, dt, ent->s.pos.trDelta, ent->s.pos.trBase);
			VectorMA(ent->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, ent->s.pos.trDelta);
			ent->s.pos.trType = TR_INTERPOLATE;
			ent->s.pos.trTime = level.time;
		}
	}
	// check think function after bouncing
	G_RunThink( ent );
}


//=============================================================================

/*
=================
fire_plasma

=================
*/
gentity_t *fire_plasma (gentity_t *self, vec3_t start, vec3_t dir) {
	gentity_t	*bolt;

	VectorNormalize (dir);

	bolt = G_Spawn();
	bolt->classname = "plasma";
	bolt->nextthink = level.time + 10000;
	bolt->think = G_ExplodeMissile;
	bolt->s.eType = ET_MISSILE;
	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
	bolt->s.weapon = WP_PLASMAGUN;
	bolt->r.ownerNum = self->s.number;
	bolt->parent = self;
	bolt->damage = 20;
	bolt->splashDamage = 15;
	bolt->splashRadius = 20;
	bolt->methodOfDeath = MOD_PLASMA;
	bolt->splashMethodOfDeath = MOD_PLASMA_SPLASH;
	bolt->clipmask = MASK_SHOT;
	bolt->r.mins[0] = -4;
	bolt->r.mins[1] = -4;
	bolt->r.mins[2] = -4;
	bolt->r.maxs[0] = 4;
	bolt->r.maxs[1] = 4;
	bolt->r.maxs[2] = 4;
	bolt->s.pos.trType = TR_LINEAR;
	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
	VectorCopy( start, bolt->s.pos.trBase );
	VectorScale( dir, 2000, bolt->s.pos.trDelta );
	if(g_MissilesAddVelocity.value)
		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
	
	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth

	VectorCopy (start, bolt->r.currentOrigin);

	return bolt;
}	

//=============================================================================


/*
=================
fire_grenade
=================
*/
gentity_t *fire_grenade (gentity_t *self, vec3_t start, vec3_t dir) {
	gentity_t	*bolt;

	VectorNormalize (dir);

	bolt = G_Spawn();
	bolt->classname = "grenade";
	bolt->nextthink = level.time + 2500;
	bolt->think = G_ExplodeMissile;
	bolt->s.eType = ET_MISSILE;
	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
	bolt->s.weapon = WP_GRENADE_LAUNCHER;
	bolt->s.eFlags = EF_BOUNCE_HALF;
	bolt->r.ownerNum = self->s.number;
	bolt->parent = self;
	bolt->damage = 100;
	bolt->splashDamage = 100;
	bolt->splashRadius = 200;
	bolt->methodOfDeath = MOD_GRENADE;
	bolt->splashMethodOfDeath = MOD_GRENADE_SPLASH;
	bolt->clipmask = MASK_SHOT;
	bolt->r.mins[0] = -1;
	bolt->r.mins[1] = -1;
	bolt->r.mins[2] = -1;
	bolt->r.maxs[0] = 1;
	bolt->r.maxs[1] = 1;
	bolt->r.maxs[2] = 1;
	
	bolt->s.pos.trType = TR_GRAVITY;
	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
	VectorCopy( start, bolt->s.pos.trBase );
	VectorScale( dir, 700, bolt->s.pos.trDelta );
	if(g_MissilesAddVelocity.value)
		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
	
	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth

	VectorCopy (start, bolt->r.currentOrigin);

	return bolt;
}

//=============================================================================


/*
=================
fire_bfg
=================
*/
gentity_t *fire_bfg (gentity_t *self, vec3_t start, vec3_t dir) {
	gentity_t	*bolt;

	VectorNormalize (dir);

	bolt = G_Spawn();
	bolt->classname = "bfg";
	bolt->nextthink = level.time + 10000;
	bolt->think = G_ExplodeMissile;
	bolt->s.eType = ET_MISSILE;
	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
	bolt->s.weapon = WP_BFG;
	bolt->r.ownerNum = self->s.number;
	bolt->parent = self;
	bolt->damage = 100;
	bolt->splashDamage = 100;
	bolt->splashRadius = 120;
	bolt->methodOfDeath = MOD_BFG;
	bolt->splashMethodOfDeath = MOD_BFG_SPLASH;
	bolt->clipmask = MASK_SHOT;

	bolt->s.pos.trType = TR_LINEAR;
	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
	VectorCopy( start, bolt->s.pos.trBase );
	VectorScale( dir, 2000, bolt->s.pos.trDelta );
	if(g_MissilesAddVelocity.value)
		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth
	VectorCopy (start, bolt->r.currentOrigin);

	return bolt;
}

//=============================================================================


/*void RocketThink( gentity_t *self )
{
	vec3_t forward;
	
	self->nextthink +=10;
	
	self->count++;
	if(self->count >= 100)
	{
		G_ExplodeMissile(self);
		return;
	}
	if(g_RocketAccel.value || g_RocketVeer.value)
	{
		float dt = (level.time - self->s.pos.trTime) * 0.001;
		self->s.angles[0] += crandom() * g_RocketVeer.value * dt;
		self->s.angles[1] += crandom() * g_RocketVeer.value * dt;
		self->s.angles[2] += crandom() * g_RocketVeer.value * dt;
		AngleVectors(self->s.angles, forward, NULL, NULL);		
		//VectorScale(self->s.pos.trDelta, 0.9, self->s.pos.trDelta );
		VectorMA(self->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, self->s.pos.trDelta);
		VectorMA(self->s.pos.trBase, dt, self->s.pos.trDelta, self->s.pos.trBase);
		VectorMA(self->s.pos.trDelta, g_RocketAccel.value * dt * 0.5, forward, self->s.pos.trDelta);
		self->s.pos.trType = TR_INTERPOLATE;
		self->s.pos.trTime = level.time;
	}
	
}*/
/*
=================
fire_rocket
=================
*/
gentity_t *fire_rocket (gentity_t *self, vec3_t start, vec3_t dir) {
	gentity_t	*bolt;

	VectorNormalize (dir);

	bolt = G_Spawn();
	bolt->classname = "rocket";
	bolt->nextthink = level.time + 10000;
	bolt->think = G_ExplodeMissile;
	bolt->s.eType = ET_MISSILE;
	bolt->r.svFlags = SVF_USE_CURRENT_ORIGIN;
	bolt->s.weapon = WP_ROCKET_LAUNCHER;
	bolt->r.ownerNum = self->s.number;
	bolt->parent = self;
	bolt->damage = 150;
	bolt->splashDamage = 100;
	bolt->splashRadius = 150;
	bolt->methodOfDeath = MOD_ROCKET;
	bolt->splashMethodOfDeath = MOD_ROCKET_SPLASH;
	bolt->clipmask = MASK_SHOT;
	bolt->count = 0;
	bolt->s.pos.trType = TR_LINEAR;
	bolt->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
	VectorCopy( start, bolt->s.pos.trBase );
	bolt->r.mins[0] = -2;
	bolt->r.mins[1] = -2;
	bolt->r.mins[2] = -2;
	bolt->r.maxs[0] = 2;
	bolt->r.maxs[1] = 2;
	bolt->r.maxs[2] = 2;
		
	vectoangles(dir, bolt->s.angles);
	VectorScale( dir, g_RocketSpeed.value, bolt->s.pos.trDelta );	
	if(g_MissilesAddVelocity.value)
		VectorMA(bolt->s.pos.trDelta, g_MissilesAddVelocity.value, self->client->ps.velocity, bolt->s.pos.trDelta );						
	SnapVector( bolt->s.pos.trDelta );			// save net bandwidth
	VectorCopy (start, bolt->r.currentOrigin);
	return bolt;
}

/*
=================
fire_grapple
=================
*/
gentity_t *fire_grapple (gentity_t *self, vec3_t start, vec3_t dir) {
	gentity_t	*hook;

	VectorNormalize (dir);

	hook = G_Spawn();
	hook->classname = "hook";
	hook->nextthink = level.time + 10000;
	hook->think = Weapon_HookFree;
	hook->s.eType = ET_MISSILE;
	hook->r.svFlags = SVF_USE_CURRENT_ORIGIN;
	hook->s.weapon = WP_GRAPPLING_HOOK;
	hook->r.ownerNum = self->s.number;
	hook->methodOfDeath = MOD_GRAPPLE;
	hook->clipmask = MASK_SHOT;
	hook->parent = self;

	hook->s.pos.trType = TR_LINEAR;
	hook->s.pos.trTime = level.time - MISSILE_PRESTEP_TIME;		// move a bit on the very first frame
	hook->s.otherEntityNum = self->s.number; // use to match beam in client
	VectorCopy( start, hook->s.pos.trBase );
	VectorScale( dir, 800, hook->s.pos.trDelta );
	
	SnapVector( hook->s.pos.trDelta );			// save net bandwidth
	VectorCopy (start, hook->r.currentOrigin);

	self->client->hook = hook;

	return hook;
}



