code
proc CG_MachineGunEjectBrass 136 8
file "..\cg_weapons.c"
line 11
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_weapons.c -- events and effects dealing with weapons
;4:#include "cg_local.h"
;5:
;6:/*
;7:==========================
;8:CG_MachineGunEjectBrass
;9:==========================
;10:*/
;11:static void CG_MachineGunEjectBrass( centity_t *cent ) {
line 16
;12:	localEntity_t	*le;
;13:	refEntity_t		*re;
;14:	vec3_t			velocity, xvelocity;
;15:	vec3_t			offset, xoffset;
;16:	float			waterScale = 1.0f;
ADDRLP4 92
CNSTF4 1065353216
ASGNF4
line 19
;17:	vec3_t			v[3];
;18:
;19:	if ( cg_brassTime.integer <= 0 ) {
ADDRGP4 cg_brassTime+12
INDIRI4
CNSTI4 0
GTI4 $61
line 20
;20:		return;
ADDRGP4 $60
JUMPV
LABELV $61
line 23
;21:	}
;22:
;23:	le = CG_AllocLocalEntity();
ADDRLP4 96
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 96
INDIRP4
ASGNP4
line 24
;24:	re = &le->refEntity;
ADDRLP4 64
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 26
;25:
;26:	velocity[0] = 0;
ADDRLP4 40
CNSTF4 0
ASGNF4
line 27
;27:	velocity[1] = -50 + 40 * crandom();
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+4
CNSTF4 1109393408
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 3259498496
ADDF4
ASGNF4
line 28
;28:	velocity[2] = 100 + 50 * crandom();
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+8
CNSTF4 1112014848
CNSTF4 1073741824
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1120403456
ADDF4
ASGNF4
line 30
;29:
;30:	le->leType = LE_FRAGMENT;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 3
ASGNI4
line 31
;31:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 32
;32:	le->endTime = le->startTime + cg_brassTime.integer + ( cg_brassTime.integer / 4 ) * random();
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ADDRGP4 cg_brassTime+12
INDIRI4
ADDI4
CVIF4 4
ADDRGP4 cg_brassTime+12
INDIRI4
CNSTI4 4
DIVI4
CVIF4 4
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 34
;33:
;34:	le->pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 5
ASGNI4
line 35
;35:	le->pos.trTime = cg.time - (rand()&15);
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 116
INDIRI4
CNSTI4 15
BANDI4
SUBI4
ASGNI4
line 37
;36:
;37:	AnglesToAxis( cent->lerpAngles, v );
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 39
;38:
;39:	offset[0] = 8;
ADDRLP4 52
CNSTF4 1090519040
ASGNF4
line 40
;40:	offset[1] = -4;
ADDRLP4 52+4
CNSTF4 3229614080
ASGNF4
line 41
;41:	offset[2] = 24;
ADDRLP4 52+8
CNSTF4 1103101952
ASGNF4
line 43
;42:
;43:	xoffset[0] = offset[0] * v[0][0] + offset[1] * v[1][0] + offset[2] * v[2][0];
ADDRLP4 80
ADDRLP4 52
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 4+12
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 4+24
INDIRF4
MULF4
ADDF4
ASGNF4
line 44
;44:	xoffset[1] = offset[0] * v[0][1] + offset[1] * v[1][1] + offset[2] * v[2][1];
ADDRLP4 80+4
ADDRLP4 52
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 4+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 4+24+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 45
;45:	xoffset[2] = offset[0] * v[0][2] + offset[1] * v[1][2] + offset[2] * v[2][2];
ADDRLP4 80+8
ADDRLP4 52
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 4+12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 4+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 46
;46:	VectorAdd( cent->lerpOrigin, xoffset, re->origin );
ADDRLP4 64
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ADDRLP4 80
INDIRF4
ADDF4
ASGNF4
ADDRLP4 64
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
ADDRLP4 80+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 64
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
ADDRLP4 80+8
INDIRF4
ADDF4
ASGNF4
line 48
;47:
;48:	VectorCopy( re->origin, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 64
INDIRP4
CNSTI4 68
ADDP4
INDIRB
ASGNB 12
line 50
;49:
;50:	if ( CG_PointContents( re->origin, -1 ) & CONTENTS_WATER ) {
ADDRLP4 64
INDIRP4
CNSTI4 68
ADDP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 120
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 120
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $94
line 51
;51:		waterScale = 0.10;
ADDRLP4 92
CNSTF4 1036831949
ASGNF4
line 52
;52:	}
LABELV $94
line 54
;53:
;54:	xvelocity[0] = velocity[0] * v[0][0] + velocity[1] * v[1][0] + velocity[2] * v[2][0];
ADDRLP4 68
ADDRLP4 40
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDRLP4 40+4
INDIRF4
ADDRLP4 4+12
INDIRF4
MULF4
ADDF4
ADDRLP4 40+8
INDIRF4
ADDRLP4 4+24
INDIRF4
MULF4
ADDF4
ASGNF4
line 55
;55:	xvelocity[1] = velocity[0] * v[0][1] + velocity[1] * v[1][1] + velocity[2] * v[2][1];
ADDRLP4 68+4
ADDRLP4 40
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDRLP4 40+4
INDIRF4
ADDRLP4 4+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 40+8
INDIRF4
ADDRLP4 4+24+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 56
;56:	xvelocity[2] = velocity[0] * v[0][2] + velocity[1] * v[1][2] + velocity[2] * v[2][2];
ADDRLP4 68+8
ADDRLP4 40
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDRLP4 40+4
INDIRF4
ADDRLP4 4+12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 40+8
INDIRF4
ADDRLP4 4+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 57
;57:	VectorScale( xvelocity, waterScale, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 68
INDIRF4
ADDRLP4 92
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDRLP4 68+4
INDIRF4
ADDRLP4 92
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 68+8
INDIRF4
ADDRLP4 92
INDIRF4
MULF4
ASGNF4
line 59
;58:
;59:	AxisCopy( axisDefault, re->axis );
ADDRGP4 axisDefault
ARGP4
ADDRLP4 64
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisCopy
CALLV
pop
line 60
;60:	re->hModel = cgs.media.machinegunBrassModel;
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cgs+170516+108
INDIRI4
ASGNI4
line 62
;61:
;62:	le->bounceFactor = 0.4 * waterScale;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTF4 1053609165
ADDRLP4 92
INDIRF4
MULF4
ASGNF4
line 64
;63:
;64:	le->angles.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 2
ASGNI4
line 65
;65:	le->angles.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 66
;66:	le->angles.trBase[0] = rand()&31;
ADDRLP4 124
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 124
INDIRI4
CNSTI4 31
BANDI4
CVIF4 4
ASGNF4
line 67
;67:	le->angles.trBase[1] = rand()&31;
ADDRLP4 128
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 128
INDIRI4
CNSTI4 31
BANDI4
CVIF4 4
ASGNF4
line 68
;68:	le->angles.trBase[2] = rand()&31;
ADDRLP4 132
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 132
INDIRI4
CNSTI4 31
BANDI4
CVIF4 4
ASGNF4
line 69
;69:	le->angles.trDelta[0] = 2;
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
CNSTF4 1073741824
ASGNF4
line 70
;70:	le->angles.trDelta[1] = 1;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1065353216
ASGNF4
line 71
;71:	le->angles.trDelta[2] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
CNSTF4 0
ASGNF4
line 73
;72:
;73:	le->leFlags = LEF_TUMBLE;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 74
;74:	le->leBounceSoundType = LEBS_BRASS;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 2
ASGNI4
line 75
;75:	le->leMarkType = LEMT_NONE;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
CNSTI4 0
ASGNI4
line 76
;76:}
LABELV $60
endproc CG_MachineGunEjectBrass 136 8
proc CG_ShotgunEjectBrass 136 8
line 83
;77:
;78:/*
;79:==========================
;80:CG_ShotgunEjectBrass
;81:==========================
;82:*/
;83:static void CG_ShotgunEjectBrass( centity_t *cent ) {
line 91
;84:	localEntity_t	*le;
;85:	refEntity_t		*re;
;86:	vec3_t			velocity, xvelocity;
;87:	vec3_t			offset, xoffset;
;88:	vec3_t			v[3];
;89:	int				i;
;90:
;91:	if ( cg_brassTime.integer <= 0 ) {
ADDRGP4 cg_brassTime+12
INDIRI4
CNSTI4 0
GTI4 $122
line 92
;92:		return;
ADDRGP4 $121
JUMPV
LABELV $122
line 95
;93:	}
;94:
;95:	for ( i = 0; i < 2; i++ ) {
ADDRLP4 92
CNSTI4 0
ASGNI4
LABELV $125
line 96
;96:		float	waterScale = 1.0f;
ADDRLP4 96
CNSTF4 1065353216
ASGNF4
line 98
;97:
;98:		le = CG_AllocLocalEntity();
ADDRLP4 100
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 100
INDIRP4
ASGNP4
line 99
;99:		re = &le->refEntity;
ADDRLP4 64
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 101
;100:
;101:		velocity[0] = 60 + 60 * crandom();
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40
CNSTF4 1114636288
CNSTF4 1073741824
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1114636288
ADDF4
ASGNF4
line 102
;102:		if ( i == 0 ) {
ADDRLP4 92
INDIRI4
CNSTI4 0
NEI4 $129
line 103
;103:			velocity[1] = 40 + 10 * crandom();
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1109393408
ADDF4
ASGNF4
line 104
;104:		} else {
ADDRGP4 $130
JUMPV
LABELV $129
line 105
;105:			velocity[1] = -40 + 10 * crandom();
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 3256877056
ADDF4
ASGNF4
line 106
;106:		}
LABELV $130
line 107
;107:		velocity[2] = 100 + 50 * crandom();
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+8
CNSTF4 1112014848
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1120403456
ADDF4
ASGNF4
line 109
;108:
;109:		le->leType = LE_FRAGMENT;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 3
ASGNI4
line 110
;110:		le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 111
;111:		le->endTime = le->startTime + cg_brassTime.integer*3 + cg_brassTime.integer * random();
ADDRLP4 112
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 3
ADDRGP4 cg_brassTime+12
INDIRI4
MULI4
ADDI4
CVIF4 4
ADDRGP4 cg_brassTime+12
INDIRI4
CVIF4 4
ADDRLP4 112
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 113
;112:
;113:		le->pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 5
ASGNI4
line 114
;114:		le->pos.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 116
;115:
;116:		AnglesToAxis( cent->lerpAngles, v );
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 118
;117:
;118:		offset[0] = 8;
ADDRLP4 52
CNSTF4 1090519040
ASGNF4
line 119
;119:		offset[1] = 0;
ADDRLP4 52+4
CNSTF4 0
ASGNF4
line 120
;120:		offset[2] = 24;
ADDRLP4 52+8
CNSTF4 1103101952
ASGNF4
line 122
;121:
;122:		xoffset[0] = offset[0] * v[0][0] + offset[1] * v[1][0] + offset[2] * v[2][0];
ADDRLP4 80
ADDRLP4 52
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 4+12
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 4+24
INDIRF4
MULF4
ADDF4
ASGNF4
line 123
;123:		xoffset[1] = offset[0] * v[0][1] + offset[1] * v[1][1] + offset[2] * v[2][1];
ADDRLP4 80+4
ADDRLP4 52
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 4+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 4+24+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 124
;124:		xoffset[2] = offset[0] * v[0][2] + offset[1] * v[1][2] + offset[2] * v[2][2];
ADDRLP4 80+8
ADDRLP4 52
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 4+12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 4+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 125
;125:		VectorAdd( cent->lerpOrigin, xoffset, re->origin );
ADDRLP4 64
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
ADDRLP4 80
INDIRF4
ADDF4
ASGNF4
ADDRLP4 64
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
ADDRLP4 80+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 64
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
ADDRLP4 80+8
INDIRF4
ADDF4
ASGNF4
line 126
;126:		VectorCopy( re->origin, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 64
INDIRP4
CNSTI4 68
ADDP4
INDIRB
ASGNB 12
line 127
;127:		if ( CG_PointContents( re->origin, -1 ) & CONTENTS_WATER ) {
ADDRLP4 64
INDIRP4
CNSTI4 68
ADDP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 120
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 120
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $162
line 128
;128:			waterScale = 0.10;
ADDRLP4 96
CNSTF4 1036831949
ASGNF4
line 129
;129:		}
LABELV $162
line 131
;130:
;131:		xvelocity[0] = velocity[0] * v[0][0] + velocity[1] * v[1][0] + velocity[2] * v[2][0];
ADDRLP4 68
ADDRLP4 40
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDRLP4 40+4
INDIRF4
ADDRLP4 4+12
INDIRF4
MULF4
ADDF4
ADDRLP4 40+8
INDIRF4
ADDRLP4 4+24
INDIRF4
MULF4
ADDF4
ASGNF4
line 132
;132:		xvelocity[1] = velocity[0] * v[0][1] + velocity[1] * v[1][1] + velocity[2] * v[2][1];
ADDRLP4 68+4
ADDRLP4 40
INDIRF4
ADDRLP4 4+4
INDIRF4
MULF4
ADDRLP4 40+4
INDIRF4
ADDRLP4 4+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 40+8
INDIRF4
ADDRLP4 4+24+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 133
;133:		xvelocity[2] = velocity[0] * v[0][2] + velocity[1] * v[1][2] + velocity[2] * v[2][2];
ADDRLP4 68+8
ADDRLP4 40
INDIRF4
ADDRLP4 4+8
INDIRF4
MULF4
ADDRLP4 40+4
INDIRF4
ADDRLP4 4+12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 40+8
INDIRF4
ADDRLP4 4+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 134
;134:		VectorScale( xvelocity, waterScale, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 68
INDIRF4
ADDRLP4 96
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDRLP4 68+4
INDIRF4
ADDRLP4 96
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 68+8
INDIRF4
ADDRLP4 96
INDIRF4
MULF4
ASGNF4
line 136
;135:
;136:		AxisCopy( axisDefault, re->axis );
ADDRGP4 axisDefault
ARGP4
ADDRLP4 64
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisCopy
CALLV
pop
line 137
;137:		re->hModel = cgs.media.shotgunBrassModel;
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cgs+170516+112
INDIRI4
ASGNI4
line 138
;138:		le->bounceFactor = 0.3;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTF4 1050253722
ASGNF4
line 140
;139:
;140:		le->angles.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 2
ASGNI4
line 141
;141:		le->angles.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 142
;142:		le->angles.trBase[0] = rand()&31;
ADDRLP4 124
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 124
INDIRI4
CNSTI4 31
BANDI4
CVIF4 4
ASGNF4
line 143
;143:		le->angles.trBase[1] = rand()&31;
ADDRLP4 128
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 128
INDIRI4
CNSTI4 31
BANDI4
CVIF4 4
ASGNF4
line 144
;144:		le->angles.trBase[2] = rand()&31;
ADDRLP4 132
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 132
INDIRI4
CNSTI4 31
BANDI4
CVIF4 4
ASGNF4
line 145
;145:		le->angles.trDelta[0] = 1;
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
CNSTF4 1065353216
ASGNF4
line 146
;146:		le->angles.trDelta[1] = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1056964608
ASGNF4
line 147
;147:		le->angles.trDelta[2] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
CNSTF4 0
ASGNF4
line 149
;148:
;149:		le->leFlags = LEF_TUMBLE;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 150
;150:		le->leBounceSoundType = LEBS_BRASS;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 2
ASGNI4
line 151
;151:		le->leMarkType = LEMT_NONE;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
CNSTI4 0
ASGNI4
line 152
;152:	}
LABELV $126
line 95
ADDRLP4 92
ADDRLP4 92
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 92
INDIRI4
CNSTI4 2
LTI4 $125
line 153
;153:}
LABELV $121
endproc CG_ShotgunEjectBrass 136 8
export CG_RailTrail
proc CG_RailTrail 112 12
line 161
;154:
;155:
;156:/*
;157:==========================
;158:CG_RailTrail
;159:==========================
;160:*/
;161:void CG_RailTrail( clientInfo_t *ci, vec3_t start, vec3_t end ) {
line 165
;162:	localEntity_t	*le;
;163:	refEntity_t		*re;
;164:
;165:	if(cg_CoolRailGun.integer)
ADDRGP4 cg_CoolRailGun+12
INDIRI4
CNSTI4 0
EQI4 $190
line 166
;166:	{
line 171
;167:		vec3_t n0, n1, n2;
;168:		float dis, rlength;
;169:		int i, r;
;170:	
;171:		VectorSubtract(end, start, n0);
ADDRLP4 60
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 64
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 24
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 64
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 68
CNSTI4 4
ASGNI4
ADDRLP4 24+4
ADDRLP4 60
INDIRP4
ADDRLP4 68
INDIRI4
ADDP4
INDIRF4
ADDRLP4 64
INDIRP4
ADDRLP4 68
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 72
CNSTI4 8
ASGNI4
ADDRLP4 24+8
ADDRFP4 8
INDIRP4
ADDRLP4 72
INDIRI4
ADDP4
INDIRF4
ADDRFP4 4
INDIRP4
ADDRLP4 72
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 172
;172:		dis = VectorNormalize(n0);
ADDRLP4 24
ARGP4
ADDRLP4 76
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 76
INDIRF4
ASGNF4
line 173
;173:		rlength = cg_railLength.value;
ADDRLP4 12
ADDRGP4 cg_railLength+8
INDIRF4
ASGNF4
line 174
;174:		if(rlength == 0)
ADDRLP4 12
INDIRF4
CNSTF4 0
NEF4 $196
line 175
;175:		{
line 176
;176:			rlength = 32;
ADDRLP4 12
CNSTF4 1107296256
ASGNF4
line 177
;177:			CG_Printf("Error: zero r_railSegmentLength\n");
ADDRGP4 $198
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 178
;178:		}
LABELV $196
line 179
;179:		PerpendicularVector(n1, n0);
ADDRLP4 36
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 PerpendicularVector
CALLV
pop
line 180
;180:		CrossProduct(n0, n1, n2);
ADDRLP4 24
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 48
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 182
;181:		
;182:		for(r = 0; r < dis / rlength; r++)
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRGP4 $202
JUMPV
LABELV $199
line 183
;183:		{
line 184
;184:			le = CG_AllocLocalEntity();
ADDRLP4 80
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 80
INDIRP4
ASGNP4
line 185
;185:			re = &le->refEntity;
ADDRLP4 0
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 187
;186:	
;187:			le->leType = LE_EXPAND_FADE;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 9
ASGNI4
line 188
;188:			le->startTime = cg.time;
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 189
;189:			le->endTime = cg.time + cg_railTrailTime.value;
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg_railTrailTime+8
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 190
;190:			le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1065353216
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 192
;191:	
;192:			re->shaderTime = cg.time / 1000.0f;
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 193
;193:			VectorMA( start, r * rlength, n0, re->origin );
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 4
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
ADDRLP4 20
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 24+4
INDIRF4
ADDRLP4 20
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 24+8
INDIRF4
ADDRLP4 20
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 195
;194:	
;195:			re->reType = RT_MODEL;
ADDRLP4 0
INDIRP4
CNSTI4 0
ASGNI4
line 196
;196:			re->renderfx |= RF_NOSHADOW;
ADDRLP4 88
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 197
;197:			re->hModel = cgs.media.teleportEffectModel;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cgs+170516+404
INDIRI4
ASGNI4
line 199
;198:			//re->hModel = cg_weapons[WP_RAILGUN].missileModel;
;199:			re->customShader = cgs.media.teleportEffectShader;
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+408
INDIRI4
ASGNI4
line 203
;200:			
;201:			//vectoangles(dir, a);
;202:			//AnglesToAxis(a, re->axis);
;203:			for(i = 0; i < 3; i++)
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $213
line 204
;204:			{
line 205
;205:				re->axis[0][i] = n2[i];
ADDRLP4 92
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 92
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDP4
ADDRLP4 92
INDIRI4
ADDRLP4 48
ADDP4
INDIRF4
ASGNF4
line 206
;206:				re->axis[1][i] = n1[i];
ADDRLP4 96
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 96
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDP4
ADDRLP4 96
INDIRI4
ADDRLP4 36
ADDP4
INDIRF4
ASGNF4
line 207
;207:				re->axis[2][i] = n0[i] * rlength / 62.125;
ADDRLP4 100
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 100
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDP4
ADDRLP4 100
INDIRI4
ADDRLP4 24
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
CNSTF4 1115193344
DIVF4
ASGNF4
line 208
;208:				if(r == (int) dis / rlength)
ADDRLP4 20
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
CVFI4 4
CVIF4 4
ADDRLP4 12
INDIRF4
DIVF4
NEF4 $217
line 209
;209:					re->axis[2][i] *= (((int) dis) % ((int) rlength)) / rlength;
ADDRLP4 104
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDP4
ASGNP4
ADDRLP4 104
INDIRP4
ADDRLP4 104
INDIRP4
INDIRF4
ADDRLP4 16
INDIRF4
CVFI4 4
ADDRLP4 12
INDIRF4
CVFI4 4
MODI4
CVIF4 4
ADDRLP4 12
INDIRF4
DIVF4
MULF4
ASGNF4
LABELV $217
line 211
;210:				
;211:			}
LABELV $214
line 203
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 3
LTI4 $213
line 214
;212:			//VectorCopy( end, re->oldorigin );
;213:	
;214:			le->color[0] = ci->color[0] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ASGNF4
line 215
;215:			le->color[1] = ci->color[1] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 108
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
MULF4
ASGNF4
line 216
;216:			le->color[2] = ci->color[2] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
MULF4
ASGNF4
line 217
;217:			le->color[3] = 0.15f;
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1041865114
ASGNF4
line 218
;218:		}
LABELV $200
line 182
ADDRLP4 20
ADDRLP4 20
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $202
ADDRLP4 20
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
ADDRLP4 12
INDIRF4
DIVF4
LTF4 $199
line 219
;219:	}
ADDRGP4 $191
JUMPV
LABELV $190
line 221
;220:	else
;221:	{
line 225
;222:		//
;223:		// rings
;224:		//
;225:		le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 226
;226:		re = &le->refEntity;
ADDRLP4 0
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 228
;227:	
;228:		le->leType = LE_FADE_RGB;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 6
ASGNI4
line 229
;229:		le->startTime = cg.time;
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 230
;230:		le->endTime = cg.time + cg_railTrailTime.value;
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg_railTrailTime+8
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 231
;231:		le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1065353216
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 233
;232:	
;233:		re->shaderTime = cg.time / 1000.0f;
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 234
;234:		re->reType = RT_RAIL_RINGS;
ADDRLP4 0
INDIRP4
CNSTI4 5
ASGNI4
line 235
;235:		re->customShader = cgs.media.railRingsShader;
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+116
INDIRI4
ASGNI4
line 237
;236:		
;237:		VectorCopy( start, re->origin );
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 238
;238:		VectorCopy( end, re->oldorigin );
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 8
INDIRP4
INDIRB
ASGNB 12
line 245
;239:	
;240:		
;241:		// nudge down a bit so it isn't exactly in center
;242:		//re->origin[2] -= 8;
;243:		//re->oldorigin[2] -= 8;
;244:		
;245:		le->color[0] = ci->color[0] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ASGNF4
line 246
;246:		le->color[1] = ci->color[1] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 108
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
MULF4
ASGNF4
line 247
;247:		le->color[2] = ci->color[2] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
MULF4
ASGNF4
line 248
;248:		le->color[3] = 1.0f;
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1065353216
ASGNF4
line 250
;249:	
;250:		AxisClear( re->axis );
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 251
;251:	}
LABELV $191
line 259
;252:	
;253:	// nudge down a bit so it isn't exactly in center
;254:	//re->origin[2] -= 8;
;255:	//re->oldorigin[2] -= 8;
;256:	//
;257:	// core
;258:	//
;259:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 260
;260:	re = &le->refEntity;
ADDRLP4 0
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 262
;261:
;262:	le->leType = LE_FADE_RGB;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 6
ASGNI4
line 263
;263:	le->startTime = cg.time;
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 264
;264:	le->endTime = cg.time + cg_railTrailTime.value;
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg_railTrailTime+8
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 265
;265:	le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1065353216
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 267
;266:
;267:	re->shaderTime = cg.time / 1000.0f;
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 268
;268:	VectorCopy( start, re->origin );
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 271
;269:		
;270:
;271:	re->reType = RT_RAIL_CORE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ASGNI4
line 272
;272:	re->customShader = cgs.media.railCoreShader;	
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+120
INDIRI4
ASGNI4
line 273
;273:	VectorCopy( end, re->oldorigin );
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 8
INDIRP4
INDIRB
ASGNB 12
line 274
;274:	AxisClear( re->axis );
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 276
;275:
;276:	le->color[0] = ci->color[0] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ASGNF4
line 277
;277:	le->color[1] = ci->color[1] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 108
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
MULF4
ASGNF4
line 278
;278:	le->color[2] = ci->color[2] * 0.75;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
CNSTF4 1061158912
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
MULF4
ASGNF4
line 279
;279:	le->color[3] = 1.0f;
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1065353216
ASGNF4
line 282
;280:
;281:	
;282:}
LABELV $189
endproc CG_RailTrail 112 12
proc CG_RocketTrail 88 44
line 289
;283:
;284:/*
;285:==========================
;286:CG_RocketTrail
;287:==========================
;288:*/
;289:static void CG_RocketTrail( centity_t *ent, const weaponInfo_t *wi ) {
line 299
;290:	int		step;
;291:	vec3_t	origin, lastPos;
;292:	int		t;
;293:	int		startTime, contents;
;294:	int		lastContents;
;295:	entityState_t	*es;
;296:	vec3_t	up;
;297:	localEntity_t	*smoke;
;298:
;299:	up[0] = 0;
ADDRLP4 28
CNSTF4 0
ASGNF4
line 300
;300:	up[1] = 0;
ADDRLP4 28+4
CNSTF4 0
ASGNF4
line 301
;301:	up[2] = 0;
ADDRLP4 28+8
CNSTF4 0
ASGNF4
line 303
;302:
;303:	step = 50;
ADDRLP4 20
CNSTI4 50
ASGNI4
line 305
;304:
;305:	es = &ent->currentState;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
line 306
;306:	startTime = ent->trailTime;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
INDIRI4
ASGNI4
line 307
;307:	t = step * ( (startTime + step) / step );
ADDRLP4 0
ADDRLP4 20
INDIRI4
ADDRLP4 56
INDIRI4
ADDRLP4 20
INDIRI4
ADDI4
ADDRLP4 20
INDIRI4
DIVI4
MULI4
ASGNI4
line 309
;308:
;309:	BG_EvaluateTrajectory( &es->pos, cg.time, origin );
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRLP4 44
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 310
;310:	contents = CG_PointContents( origin, -1 );
ADDRLP4 44
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 68
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 68
INDIRI4
ASGNI4
line 313
;311:
;312:	// if object (e.g. grenade) is stationary, don't toss up smoke
;313:	if ( es->pos.trType == TR_STATIONARY ) {
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 0
NEI4 $235
line 314
;314:		ent->trailTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 315
;315:		return;
ADDRGP4 $231
JUMPV
LABELV $235
line 318
;316:	}
;317:
;318:	BG_EvaluateTrajectory( &es->pos, ent->trailTime, lastPos );
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 319
;319:	lastContents = CG_PointContents( lastPos, -1 );
ADDRLP4 4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 72
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 60
ADDRLP4 72
INDIRI4
ASGNI4
line 321
;320:
;321:	ent->trailTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 323
;322:
;323:	if ( contents & ( CONTENTS_WATER | CONTENTS_SLIME | CONTENTS_LAVA ) ) {
ADDRLP4 40
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $246
line 324
;324:		if ( contents & lastContents & CONTENTS_WATER ) {
ADDRLP4 40
INDIRI4
ADDRLP4 60
INDIRI4
BANDI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $231
line 325
;325:			CG_BubbleTrail( lastPos, origin, 8 );
ADDRLP4 4
ARGP4
ADDRLP4 44
ARGP4
CNSTF4 1090519040
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 326
;326:		}
line 327
;327:		return;
ADDRGP4 $231
JUMPV
line 330
;328:	}
;329:
;330:	for ( ; t <= ent->trailTime ; t += step ) {
LABELV $243
line 331
;331:		BG_EvaluateTrajectory( &es->pos, t, lastPos );
ADDRLP4 24
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 333
;332:
;333:		smoke = CG_SmokePuff( lastPos, up, 
ADDRLP4 4
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 76
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
ARGF4
ADDRLP4 80
CNSTF4 1065353216
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
CNSTF4 1051260355
ARGF4
ADDRLP4 76
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
ARGF4
ADDRLP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+204
INDIRI4
ARGI4
ADDRLP4 84
ADDRGP4 CG_SmokePuff
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 84
INDIRP4
ASGNP4
line 341
;334:					  wi->trailRadius, 
;335:					  1, 1, 1, 0.33,
;336:					  wi->wiTrailTime, 
;337:					  t,
;338:					  0, 
;339:					  cgs.media.smokePuffShader );
;340:		// use the optimized local entity add
;341:		smoke->leType = LE_SCALE_FADE;
ADDRLP4 16
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 7
ASGNI4
line 342
;342:	}
LABELV $244
line 330
ADDRLP4 0
ADDRLP4 0
INDIRI4
ADDRLP4 20
INDIRI4
ADDI4
ASGNI4
LABELV $246
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
INDIRI4
LEI4 $243
line 344
;343:
;344:}
LABELV $231
endproc CG_RocketTrail 88 44
export CG_GrappleTrail
proc CG_GrappleTrail 184 16
line 351
;345:
;346:/*
;347:==========================
;348:CG_GrappleTrail
;349:==========================
;350:*/
;351:void CG_GrappleTrail( centity_t *ent, const weaponInfo_t *wi ) {
line 357
;352:	vec3_t	origin;
;353:	entityState_t	*es;
;354:	vec3_t			forward, up;
;355:	refEntity_t		beam;
;356:
;357:	es = &ent->currentState;
ADDRLP4 164
ADDRFP4 0
INDIRP4
ASGNP4
line 359
;358:
;359:	BG_EvaluateTrajectory( &es->pos, cg.time, origin );
ADDRLP4 164
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRLP4 152
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 360
;360:	ent->trailTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 362
;361:
;362:	memset( &beam, 0, sizeof( beam ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 364
;363:	//FIXME adjust for muzzle position
;364:	VectorCopy ( cg_entities[ ent->currentState.otherEntityNum ].lerpOrigin, beam.origin );
ADDRLP4 0+68
CNSTI4 680
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities+652
ADDP4
INDIRB
ASGNB 12
line 365
;365:	beam.origin[2] += 26;
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
CNSTF4 1104150528
ADDF4
ASGNF4
line 366
;366:	AngleVectors( cg_entities[ ent->currentState.otherEntityNum ].lerpAngles, forward, NULL, up );
CNSTI4 680
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities+664
ADDP4
ARGP4
ADDRLP4 168
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 140
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 367
;367:	VectorMA( beam.origin, -6, up, beam.origin );
ADDRLP4 0+68
ADDRLP4 0+68
INDIRF4
CNSTF4 3233808384
ADDRLP4 140
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 0+68+4
INDIRF4
CNSTF4 3233808384
ADDRLP4 140+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
CNSTF4 3233808384
ADDRLP4 140+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 368
;368:	VectorCopy( origin, beam.oldorigin );
ADDRLP4 0+84
ADDRLP4 152
INDIRB
ASGNB 12
line 370
;369:
;370:	if (Distance( beam.origin, beam.oldorigin ) < 64 )
ADDRLP4 0+68
ARGP4
ADDRLP4 0+84
ARGP4
ADDRLP4 180
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 180
INDIRF4
CNSTF4 1115684864
GEF4 $270
line 371
;371:		return; // Don't draw if close
ADDRGP4 $249
JUMPV
LABELV $270
line 373
;372:
;373:	beam.reType = RT_LIGHTNING;
ADDRLP4 0
CNSTI4 6
ASGNI4
line 374
;374:	beam.customShader = cgs.media.lightningShader;
ADDRLP4 0+112
ADDRGP4 cgs+170516+124
INDIRI4
ASGNI4
line 376
;375:
;376:	AxisClear( beam.axis );
ADDRLP4 0+28
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 377
;377:	beam.shaderRGBA[0] = 0xff;
ADDRLP4 0+116
CNSTU1 255
ASGNU1
line 378
;378:	beam.shaderRGBA[1] = 0xff;
ADDRLP4 0+116+1
CNSTU1 255
ASGNU1
line 379
;379:	beam.shaderRGBA[2] = 0xff;
ADDRLP4 0+116+2
CNSTU1 255
ASGNU1
line 380
;380:	beam.shaderRGBA[3] = 0xff;
ADDRLP4 0+116+3
CNSTU1 255
ASGNU1
line 381
;381:	trap_R_AddRefEntityToScene( &beam );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 382
;382:}
LABELV $249
endproc CG_GrappleTrail 184 16
proc CG_GrenadeTrail 0 8
line 389
;383:
;384:/*
;385:==========================
;386:CG_GrenadeTrail
;387:==========================
;388:*/
;389:static void CG_GrenadeTrail( centity_t *ent, const weaponInfo_t *wi ) {
line 390
;390:	CG_RocketTrail( ent, wi );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 CG_RocketTrail
CALLV
pop
line 391
;391:}
LABELV $285
endproc CG_GrenadeTrail 0 8
export CG_RegisterWeapon
proc CG_RegisterWeapon 300 12
line 401
;392:
;393:
;394:/*
;395:=================
;396:CG_RegisterWeapon
;397:
;398:The server says this item is used on this level
;399:=================
;400:*/
;401:void CG_RegisterWeapon( int weaponNum ) {
line 408
;402:	weaponInfo_t	*weaponInfo;
;403:	gitem_t			*item, *ammo;
;404:	char			path[MAX_QPATH];
;405:	vec3_t			mins, maxs;
;406:	int				i;
;407:
;408:	weaponInfo = &cg_weapons[weaponNum];
ADDRLP4 12
CNSTI4 132
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 410
;409:
;410:	if ( weaponNum == 0 ) {
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $287
line 411
;411:		return;
ADDRGP4 $286
JUMPV
LABELV $287
line 414
;412:	}
;413:
;414:	if ( weaponInfo->registered ) {
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $289
line 415
;415:		return;
ADDRGP4 $286
JUMPV
LABELV $289
line 418
;416:	}
;417:
;418:	memset( weaponInfo, 0, sizeof( *weaponInfo ) );
ADDRLP4 12
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 132
ARGU4
ADDRGP4 memset
CALLP4
pop
line 419
;419:	weaponInfo->registered = qtrue;
ADDRLP4 12
INDIRP4
CNSTI4 1
ASGNI4
line 421
;420:
;421:	for ( item = bg_itemlist + 1 ; item->classname ; item++ ) {
ADDRLP4 4
ADDRGP4 bg_itemlist+56
ASGNP4
ADDRGP4 $294
JUMPV
LABELV $291
line 422
;422:		if ( item->giType == IT_WEAPON && item->giTag == weaponNum ) {
ADDRLP4 4
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $296
ADDRLP4 4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $296
line 423
;423:			weaponInfo->item = item;
ADDRLP4 12
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 4
INDIRP4
ASGNP4
line 424
;424:			break;
ADDRGP4 $293
JUMPV
LABELV $296
line 426
;425:		}
;426:	}
LABELV $292
line 421
ADDRLP4 4
ADDRLP4 4
INDIRP4
CNSTI4 56
ADDP4
ASGNP4
LABELV $294
ADDRLP4 4
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $291
LABELV $293
line 427
;427:	if ( !item->classname ) {
ADDRLP4 4
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $298
line 428
;428:		CG_Error( "Couldn't find weapon %i", weaponNum );
ADDRGP4 $300
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 429
;429:	}
LABELV $298
line 430
;430:	CG_RegisterItemVisuals( item - bg_itemlist );
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
ARGI4
ADDRGP4 CG_RegisterItemVisuals
CALLV
pop
line 433
;431:
;432:	// load cmodel before model so filecache works
;433:	weaponInfo->weaponModel = trap_R_RegisterModel( item->world_model[0] );
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 104
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 104
INDIRI4
ASGNI4
line 436
;434:
;435:	// calc midpoint for rotation
;436:	trap_R_ModelBounds( weaponInfo->weaponModel, mins, maxs );
ADDRLP4 12
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 16
ARGP4
ADDRLP4 92
ARGP4
ADDRGP4 trap_R_ModelBounds
CALLV
pop
line 437
;437:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $301
line 438
;438:		weaponInfo->weaponMidpoint[i] = mins[i] + 0.5 * ( maxs[i] - mins[i] );
ADDRLP4 108
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 112
ADDRLP4 108
INDIRI4
ADDRLP4 16
ADDP4
INDIRF4
ASGNF4
ADDRLP4 108
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 24
ADDP4
ADDP4
ADDRLP4 112
INDIRF4
CNSTF4 1056964608
ADDRLP4 108
INDIRI4
ADDRLP4 92
ADDP4
INDIRF4
ADDRLP4 112
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 439
;439:	}
LABELV $302
line 437
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $301
line 441
;440:
;441:	weaponInfo->weaponIcon = trap_R_RegisterShader( item->icon );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRP4
ARGP4
ADDRLP4 108
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 68
ADDP4
ADDRLP4 108
INDIRI4
ASGNI4
line 442
;442:	weaponInfo->ammoIcon = trap_R_RegisterShader( item->icon );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRP4
ARGP4
ADDRLP4 112
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 112
INDIRI4
ASGNI4
line 444
;443:
;444:	for ( ammo = bg_itemlist + 1 ; ammo->classname ; ammo++ ) {
ADDRLP4 8
ADDRGP4 bg_itemlist+56
ASGNP4
ADDRGP4 $308
JUMPV
LABELV $305
line 445
;445:		if ( ammo->giType == IT_AMMO && ammo->giTag == weaponNum ) {
ADDRLP4 8
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 2
NEI4 $310
ADDRLP4 8
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $310
line 446
;446:			break;
ADDRGP4 $307
JUMPV
LABELV $310
line 448
;447:		}
;448:	}
LABELV $306
line 444
ADDRLP4 8
ADDRLP4 8
INDIRP4
CNSTI4 56
ADDP4
ASGNP4
LABELV $308
ADDRLP4 8
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $305
LABELV $307
line 449
;449:	if ( ammo->classname && ammo->world_model[0] ) {
ADDRLP4 120
CNSTU4 0
ASGNU4
ADDRLP4 8
INDIRP4
INDIRP4
CVPU4 4
ADDRLP4 120
INDIRU4
EQU4 $312
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 120
INDIRU4
EQU4 $312
line 450
;450:		weaponInfo->ammoModel = trap_R_RegisterModel( ammo->world_model[0] );
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 124
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 124
INDIRI4
ASGNI4
line 451
;451:	}
LABELV $312
line 453
;452:
;453:	strcpy( path, item->world_model[0] );
ADDRLP4 28
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 454
;454:	COM_StripExtension( path, path );
ADDRLP4 28
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 COM_StripExtension
CALLV
pop
line 455
;455:	strcat( path, "_flash.md3" );
ADDRLP4 28
ARGP4
ADDRGP4 $314
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 456
;456:	weaponInfo->flashModel = trap_R_RegisterModel( path );
ADDRLP4 28
ARGP4
ADDRLP4 124
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 124
INDIRI4
ASGNI4
line 458
;457:
;458:	if ( weaponNum == WP_MACHINEGUN || weaponNum == WP_GAUNTLET || weaponNum == WP_BFG ) {
ADDRLP4 128
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 128
INDIRI4
CNSTI4 2
EQI4 $318
ADDRLP4 128
INDIRI4
CNSTI4 1
EQI4 $318
ADDRLP4 128
INDIRI4
CNSTI4 9
NEI4 $315
LABELV $318
line 459
;459:		strcpy( path, item->world_model[0] );
ADDRLP4 28
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 460
;460:		COM_StripExtension( path, path );
ADDRLP4 28
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 COM_StripExtension
CALLV
pop
line 461
;461:		strcat( path, "_barrel.md3" );
ADDRLP4 28
ARGP4
ADDRGP4 $319
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 462
;462:		weaponInfo->barrelModel = trap_R_RegisterModel( path );
ADDRLP4 28
ARGP4
ADDRLP4 132
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 132
INDIRI4
ASGNI4
line 463
;463:	}
LABELV $315
line 465
;464:
;465:	strcpy( path, item->world_model[0] );
ADDRLP4 28
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 466
;466:	COM_StripExtension( path, path );
ADDRLP4 28
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 COM_StripExtension
CALLV
pop
line 467
;467:	strcat( path, "_hand.md3" );
ADDRLP4 28
ARGP4
ADDRGP4 $320
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 468
;468:	weaponInfo->handsModel = trap_R_RegisterModel( path );
ADDRLP4 28
ARGP4
ADDRLP4 132
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 132
INDIRI4
ASGNI4
line 470
;469:
;470:	if ( !weaponInfo->handsModel ) {
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 0
NEI4 $321
line 471
;471:		weaponInfo->handsModel = trap_R_RegisterModel( "models/weapons2/shotgun/shotgun_hand.md3" );
ADDRGP4 $323
ARGP4
ADDRLP4 136
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 136
INDIRI4
ASGNI4
line 472
;472:	}
LABELV $321
line 474
;473:
;474:	switch ( weaponNum ) {
ADDRLP4 136
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 136
INDIRI4
CNSTI4 -1
LTI4 $324
ADDRLP4 136
INDIRI4
CNSTI4 9
GTI4 $324
ADDRLP4 136
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $397+4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $397
address $348
address $324
address $326
address $350
address $358
address $366
address $360
address $329
address $378
address $372
address $390
code
LABELV $326
line 476
;475:	case WP_GAUNTLET:
;476:		MAKERGB( weaponInfo->flashDlightColor, 0.6, 0.6, 1 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1065353216
ASGNF4
line 477
;477:		weaponInfo->firingSound = trap_S_RegisterSound( "sound/weapons/melee/fstrun.wav" );
ADDRGP4 $327
ARGP4
ADDRLP4 140
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 128
ADDP4
ADDRLP4 140
INDIRI4
ASGNI4
line 478
;478:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/melee/fstatck.wav" );
ADDRGP4 $328
ARGP4
ADDRLP4 144
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 144
INDIRI4
ASGNI4
line 479
;479:		break;
ADDRGP4 $325
JUMPV
LABELV $329
line 482
;480:
;481:	case WP_LIGHTNING:
;482:		MAKERGB( weaponInfo->flashDlightColor, 0.6, 0.6, 1 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1065353216
ASGNF4
line 483
;483:		weaponInfo->readySound = trap_S_RegisterSound( "sound/weapons/melee/fsthum.wav" );
ADDRGP4 $330
ARGP4
ADDRLP4 148
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 148
INDIRI4
ASGNI4
line 484
;484:		weaponInfo->firingSound = trap_S_RegisterSound( "sound/weapons/lightning/lg_hum.wav" );
ADDRGP4 $331
ARGP4
ADDRLP4 152
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 128
ADDP4
ADDRLP4 152
INDIRI4
ASGNI4
line 486
;485:
;486:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/lightning/lg_fire.wav" );
ADDRGP4 $332
ARGP4
ADDRLP4 156
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 156
INDIRI4
ASGNI4
line 487
;487:		cgs.media.lightningShader = trap_R_RegisterShader( "lightningBolt" );
ADDRGP4 $335
ARGP4
ADDRLP4 160
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+124
ADDRLP4 160
INDIRI4
ASGNI4
line 488
;488:		cgs.media.lightningExplosionModel = trap_R_RegisterModel( "models/weaphits/crackle.md3" );
ADDRGP4 $338
ARGP4
ADDRLP4 164
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 cgs+170516+372
ADDRLP4 164
INDIRI4
ASGNI4
line 489
;489:		cgs.media.sfx_lghit1 = trap_S_RegisterSound( "sound/weapons/lightning/lg_hit.wav" );
ADDRGP4 $341
ARGP4
ADDRLP4 168
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRGP4 cgs+170516+572
ADDRLP4 168
INDIRI4
ASGNI4
line 490
;490:		cgs.media.sfx_lghit2 = trap_S_RegisterSound( "sound/weapons/lightning/lg_hit2.wav" );
ADDRGP4 $344
ARGP4
ADDRLP4 172
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRGP4 cgs+170516+576
ADDRLP4 172
INDIRI4
ASGNI4
line 491
;491:		cgs.media.sfx_lghit3 = trap_S_RegisterSound( "sound/weapons/lightning/lg_hit3.wav" );
ADDRGP4 $347
ARGP4
ADDRLP4 176
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRGP4 cgs+170516+580
ADDRLP4 176
INDIRI4
ASGNI4
line 493
;492:
;493:		break;
ADDRGP4 $325
JUMPV
LABELV $348
line 496
;494:
;495:	case WP_GRAPPLING_HOOK:
;496:		MAKERGB( weaponInfo->flashDlightColor, 0.6, 0.6, 1 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1065353216
ASGNF4
line 497
;497:		weaponInfo->missileModel = trap_R_RegisterModel( "models/ammo/rocket/rocket.md3" );
ADDRGP4 $349
ARGP4
ADDRLP4 180
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 180
INDIRI4
ASGNI4
line 498
;498:		weaponInfo->missileTrailFunc = CG_GrappleTrail;
ADDRLP4 12
INDIRP4
CNSTI4 88
ADDP4
ADDRGP4 CG_GrappleTrail
ASGNP4
line 499
;499:		weaponInfo->missileDlight = 200;
ADDRLP4 12
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1128792064
ASGNF4
line 500
;500:		weaponInfo->wiTrailTime = 2000;
ADDRLP4 12
INDIRP4
CNSTI4 120
ADDP4
CNSTF4 1157234688
ASGNF4
line 501
;501:		weaponInfo->trailRadius = 64;
ADDRLP4 12
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1115684864
ASGNF4
line 502
;502:		MAKERGB( weaponInfo->missileDlightColor, 1, 1, 0.5 );
ADDRLP4 12
INDIRP4
CNSTI4 96
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 100
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1056964608
ASGNF4
line 503
;503:		MAKERGB( weaponInfo->flashDlightColor, 0.6, 0.6, 0.5 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1056964608
ASGNF4
line 504
;504:		weaponInfo->readySound = trap_S_RegisterSound( "sound/weapons/melee/fsthum.wav" );
ADDRGP4 $330
ARGP4
ADDRLP4 184
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 184
INDIRI4
ASGNI4
line 505
;505:		weaponInfo->firingSound = trap_S_RegisterSound( "sound/weapons/melee/fstrun.wav" );
ADDRGP4 $327
ARGP4
ADDRLP4 188
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 128
ADDP4
ADDRLP4 188
INDIRI4
ASGNI4
line 506
;506:		break;
ADDRGP4 $325
JUMPV
LABELV $350
line 509
;507:
;508:	case WP_MACHINEGUN:
;509:		MAKERGB( weaponInfo->flashDlightColor, 1, 1, 0 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 0
ASGNF4
line 510
;510:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/machinegun/machgf1b.wav" );
ADDRGP4 $351
ARGP4
ADDRLP4 192
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 192
INDIRI4
ASGNI4
line 511
;511:		weaponInfo->flashSound[1] = trap_S_RegisterSound( "sound/weapons/machinegun/machgf2b.wav" );
ADDRGP4 $352
ARGP4
ADDRLP4 196
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 56
ADDP4
ADDRLP4 196
INDIRI4
ASGNI4
line 512
;512:		weaponInfo->flashSound[2] = trap_S_RegisterSound( "sound/weapons/machinegun/machgf3b.wav" );
ADDRGP4 $353
ARGP4
ADDRLP4 200
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 200
INDIRI4
ASGNI4
line 513
;513:		weaponInfo->flashSound[3] = trap_S_RegisterSound( "sound/weapons/machinegun/machgf4b.wav" );
ADDRGP4 $354
ARGP4
ADDRLP4 204
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 64
ADDP4
ADDRLP4 204
INDIRI4
ASGNI4
line 514
;514:		weaponInfo->ejectBrassFunc = CG_MachineGunEjectBrass;
ADDRLP4 12
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 CG_MachineGunEjectBrass
ASGNP4
line 515
;515:		cgs.media.bulletExplosionShader = trap_R_RegisterShader( "bulletExplosion" );
ADDRGP4 $357
ARGP4
ADDRLP4 208
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+384
ADDRLP4 208
INDIRI4
ASGNI4
line 516
;516:		break;
ADDRGP4 $325
JUMPV
LABELV $358
line 519
;517:
;518:	case WP_SHOTGUN:
;519:		MAKERGB( weaponInfo->flashDlightColor, 1, 1, 0 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 0
ASGNF4
line 520
;520:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/shotgun/sshotf1b.wav" );
ADDRGP4 $359
ARGP4
ADDRLP4 212
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 212
INDIRI4
ASGNI4
line 521
;521:		weaponInfo->ejectBrassFunc = CG_ShotgunEjectBrass;
ADDRLP4 12
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 CG_ShotgunEjectBrass
ASGNP4
line 522
;522:		break;
ADDRGP4 $325
JUMPV
LABELV $360
line 525
;523:
;524:	case WP_ROCKET_LAUNCHER:
;525:		weaponInfo->missileModel = trap_R_RegisterModel( "models/ammo/rocket/rocket.md3" );
ADDRGP4 $349
ARGP4
ADDRLP4 216
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 216
INDIRI4
ASGNI4
line 526
;526:		weaponInfo->missileSound = trap_S_RegisterSound( "sound/weapons/rocket/rockfly.wav" );
ADDRGP4 $361
ARGP4
ADDRLP4 220
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 220
INDIRI4
ASGNI4
line 527
;527:		weaponInfo->missileTrailFunc = CG_RocketTrail;
ADDRLP4 12
INDIRP4
CNSTI4 88
ADDP4
ADDRGP4 CG_RocketTrail
ASGNP4
line 528
;528:		weaponInfo->missileDlight = 200;
ADDRLP4 12
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1128792064
ASGNF4
line 529
;529:		weaponInfo->wiTrailTime = 2000;
ADDRLP4 12
INDIRP4
CNSTI4 120
ADDP4
CNSTF4 1157234688
ASGNF4
line 530
;530:		weaponInfo->trailRadius = 64;
ADDRLP4 12
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1115684864
ASGNF4
line 531
;531:		MAKERGB( weaponInfo->missileDlightColor, 1, 0.75, 0 );
ADDRLP4 12
INDIRP4
CNSTI4 96
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 100
ADDP4
CNSTF4 1061158912
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 0
ASGNF4
line 532
;532:		MAKERGB( weaponInfo->flashDlightColor, 1, 0.75, 0 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1061158912
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 0
ASGNF4
line 533
;533:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/rocket/rocklf1a.wav" );
ADDRGP4 $362
ARGP4
ADDRLP4 224
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 224
INDIRI4
ASGNI4
line 534
;534:		cgs.media.rocketExplosionShader = trap_R_RegisterShader( "rocketExplosion" );
ADDRGP4 $365
ARGP4
ADDRLP4 228
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+388
ADDRLP4 228
INDIRI4
ASGNI4
line 535
;535:		break;
ADDRGP4 $325
JUMPV
LABELV $366
line 538
;536:
;537:	case WP_GRENADE_LAUNCHER:
;538:		weaponInfo->missileModel = trap_R_RegisterModel( "models/ammo/grenade1.md3" );
ADDRGP4 $367
ARGP4
ADDRLP4 232
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 232
INDIRI4
ASGNI4
line 539
;539:		weaponInfo->missileTrailFunc = CG_GrenadeTrail;
ADDRLP4 12
INDIRP4
CNSTI4 88
ADDP4
ADDRGP4 CG_GrenadeTrail
ASGNP4
line 540
;540:		weaponInfo->wiTrailTime = 700;
ADDRLP4 12
INDIRP4
CNSTI4 120
ADDP4
CNSTF4 1143930880
ASGNF4
line 541
;541:		weaponInfo->trailRadius = 32;
ADDRLP4 12
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1107296256
ASGNF4
line 542
;542:		MAKERGB( weaponInfo->flashDlightColor, 1, 0.7, 0.5 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1060320051
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1056964608
ASGNF4
line 543
;543:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/grenade/grenlf1a.wav" );
ADDRGP4 $368
ARGP4
ADDRLP4 236
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 236
INDIRI4
ASGNI4
line 544
;544:		cgs.media.grenadeExplosionShader = trap_R_RegisterShader( "grenadeExplosion" );
ADDRGP4 $371
ARGP4
ADDRLP4 240
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+392
ADDRLP4 240
INDIRI4
ASGNI4
line 545
;545:		break;
ADDRGP4 $325
JUMPV
LABELV $372
line 548
;546:
;547:	case WP_PLASMAGUN:
;548:		weaponInfo->missileSound = trap_S_RegisterSound( "sound/weapons/plasma/lasfly.wav" );
ADDRGP4 $373
ARGP4
ADDRLP4 244
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 244
INDIRI4
ASGNI4
line 549
;549:		MAKERGB( weaponInfo->flashDlightColor, 0.6, 0.6, 1 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1058642330
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1065353216
ASGNF4
line 550
;550:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/plasma/hyprbf1a.wav" );
ADDRGP4 $374
ARGP4
ADDRLP4 248
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 248
INDIRI4
ASGNI4
line 551
;551:		cgs.media.plasmaExplosionShader = trap_R_RegisterShader( "plasmaExplosion" );
ADDRGP4 $377
ARGP4
ADDRLP4 252
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+380
ADDRLP4 252
INDIRI4
ASGNI4
line 552
;552:		break;
ADDRGP4 $325
JUMPV
LABELV $378
line 555
;553:
;554:	case WP_RAILGUN:
;555:		weaponInfo->readySound = trap_S_RegisterSound( "sound/weapons/railgun/rg_hum.wav" );
ADDRGP4 $379
ARGP4
ADDRLP4 256
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 256
INDIRI4
ASGNI4
line 556
;556:		MAKERGB( weaponInfo->flashDlightColor, 1, 0.5, 0 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1056964608
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 0
ASGNF4
line 557
;557:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/railgun/railgf1a.wav" );
ADDRGP4 $380
ARGP4
ADDRLP4 260
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 260
INDIRI4
ASGNI4
line 558
;558:		cgs.media.railExplosionShader = trap_R_RegisterShader( "railExplosion" );
ADDRGP4 $383
ARGP4
ADDRLP4 264
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+376
ADDRLP4 264
INDIRI4
ASGNI4
line 559
;559:		cgs.media.railRingsShader = trap_R_RegisterShader( "railDisc" );
ADDRGP4 $386
ARGP4
ADDRLP4 268
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+116
ADDRLP4 268
INDIRI4
ASGNI4
line 560
;560:		cgs.media.railCoreShader = trap_R_RegisterShader( "railCore" );
ADDRGP4 $389
ARGP4
ADDRLP4 272
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+120
ADDRLP4 272
INDIRI4
ASGNI4
line 562
;561:		//weaponInfo->missileModel = trap_R_RegisterModel( "models/weaphits/bfg.md3" );
;562:		break;
ADDRGP4 $325
JUMPV
LABELV $390
line 565
;563:
;564:	case WP_BFG:
;565:		weaponInfo->readySound = trap_S_RegisterSound( "sound/weapons/bfg/bfg_hum.wav" );
ADDRGP4 $391
ARGP4
ADDRLP4 276
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 276
INDIRI4
ASGNI4
line 566
;566:		MAKERGB( weaponInfo->flashDlightColor, 1, 0.7, 1 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1060320051
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1065353216
ASGNF4
line 567
;567:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/bfg/bfg_fire.wav" );
ADDRGP4 $392
ARGP4
ADDRLP4 280
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 280
INDIRI4
ASGNI4
line 568
;568:		cgs.media.bfgExplosionShader = trap_R_RegisterShader( "bfgExplosion" );
ADDRGP4 $395
ARGP4
ADDRLP4 284
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRGP4 cgs+170516+396
ADDRLP4 284
INDIRI4
ASGNI4
line 569
;569:		weaponInfo->missileModel = trap_R_RegisterModel( "models/weaphits/bfg.md3" );
ADDRGP4 $396
ARGP4
ADDRLP4 288
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 288
INDIRI4
ASGNI4
line 570
;570:		weaponInfo->missileSound = trap_S_RegisterSound( "sound/weapons/rocket/rockfly.wav" );
ADDRGP4 $361
ARGP4
ADDRLP4 292
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 292
INDIRI4
ASGNI4
line 571
;571:		break;
ADDRGP4 $325
JUMPV
LABELV $324
line 574
;572:
;573:	 default:
;574:		MAKERGB( weaponInfo->flashDlightColor, 1, 1, 1 );
ADDRLP4 12
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1065353216
ASGNF4
ADDRLP4 12
INDIRP4
CNSTI4 48
ADDP4
CNSTF4 1065353216
ASGNF4
line 575
;575:		weaponInfo->flashSound[0] = trap_S_RegisterSound( "sound/weapons/rocket/rocklf1a.wav" );
ADDRGP4 $362
ARGP4
ADDRLP4 296
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 296
INDIRI4
ASGNI4
line 576
;576:		break;
LABELV $325
line 578
;577:	}
;578:}
LABELV $286
endproc CG_RegisterWeapon 300 12
export CG_RegisterItemVisuals
proc CG_RegisterItemVisuals 24 12
line 587
;579:
;580:/*
;581:=================
;582:CG_RegisterItemVisuals
;583:
;584:The server says this item is used on this level
;585:=================
;586:*/
;587:void CG_RegisterItemVisuals( int itemNum ) {
line 591
;588:	itemInfo_t		*itemInfo;
;589:	gitem_t			*item;
;590:
;591:	itemInfo = &cg_items[ itemNum ];
ADDRLP4 4
CNSTI4 24
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_items
ADDP4
ASGNP4
line 592
;592:	if ( itemInfo->registered ) {
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $400
line 593
;593:		return;
ADDRGP4 $399
JUMPV
LABELV $400
line 596
;594:	}
;595:
;596:	item = &bg_itemlist[ itemNum ];
ADDRLP4 0
CNSTI4 56
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 bg_itemlist
ADDP4
ASGNP4
line 598
;597:
;598:	memset( itemInfo, 0, sizeof( &itemInfo ) );
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 4
ARGU4
ADDRGP4 memset
CALLP4
pop
line 599
;599:	itemInfo->registered = qtrue;
ADDRLP4 4
INDIRP4
CNSTI4 1
ASGNI4
line 601
;600:
;601:	itemInfo->models[0] = trap_R_RegisterModel( item->world_model[0] );
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 603
;602:
;603:	itemInfo->icon = trap_R_RegisterShader( item->icon );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 605
;604:
;605:	if ( item->giType == IT_WEAPON ) {
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $402
line 606
;606:		CG_RegisterWeapon( item->giTag );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 607
;607:	}
LABELV $402
line 612
;608:
;609:	//
;610:	// powerups have an accompanying ring or sphere
;611:	//
;612:	if ( item->giType == IT_POWERUP || item->giType == IT_HEALTH || 
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 5
EQI4 $408
ADDRLP4 16
INDIRI4
CNSTI4 4
EQI4 $408
ADDRLP4 16
INDIRI4
CNSTI4 3
EQI4 $408
ADDRLP4 16
INDIRI4
CNSTI4 6
NEI4 $404
LABELV $408
line 613
;613:		item->giType == IT_ARMOR || item->giType == IT_HOLDABLE ) {
line 614
;614:		if ( item->world_model[1] ) {
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $409
line 615
;615:			itemInfo->models[1] = trap_R_RegisterModel( item->world_model[1] );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 20
INDIRI4
ASGNI4
line 616
;616:		}
LABELV $409
line 617
;617:	}
LABELV $404
line 618
;618:}
LABELV $399
endproc CG_RegisterItemVisuals 24 12
proc CG_MapTorsoToWeaponFrame 24 0
line 635
;619:
;620:
;621:/*
;622:========================================================================================
;623:
;624:VIEW WEAPON
;625:
;626:========================================================================================
;627:*/
;628:
;629:/*
;630:=================
;631:CG_MapTorsoToWeaponFrame
;632:
;633:=================
;634:*/
;635:static int CG_MapTorsoToWeaponFrame( clientInfo_t *ci, int frame ) {
line 638
;636:
;637:	// change weapon
;638:	if ( frame >= ci->animations[TORSO_DROP].firstFrame 
ADDRLP4 0
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $412
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
CNSTI4 9
ADDI4
GEI4 $412
line 639
;639:		&& frame < ci->animations[TORSO_DROP].firstFrame + 9 ) {
line 640
;640:		return frame - ci->animations[TORSO_DROP].firstFrame + 6;
ADDRFP4 4
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 628
ADDP4
INDIRI4
SUBI4
CNSTI4 6
ADDI4
RETI4
ADDRGP4 $411
JUMPV
LABELV $412
line 644
;641:	}
;642:
;643:	// stand attack
;644:	if ( frame >= ci->animations[TORSO_ATTACK].firstFrame 
ADDRLP4 8
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
ADDRLP4 12
INDIRI4
LTI4 $414
ADDRLP4 8
INDIRI4
ADDRLP4 12
INDIRI4
CNSTI4 6
ADDI4
GEI4 $414
line 645
;645:		&& frame < ci->animations[TORSO_ATTACK].firstFrame + 6 ) {
line 646
;646:		return 1 + frame - ci->animations[TORSO_ATTACK].firstFrame;
ADDRFP4 4
INDIRI4
CNSTI4 1
ADDI4
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRI4
SUBI4
RETI4
ADDRGP4 $411
JUMPV
LABELV $414
line 650
;647:	}
;648:
;649:	// stand attack 2
;650:	if ( frame >= ci->animations[TORSO_ATTACK2].firstFrame 
ADDRLP4 16
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 608
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
LTI4 $416
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
CNSTI4 6
ADDI4
GEI4 $416
line 651
;651:		&& frame < ci->animations[TORSO_ATTACK2].firstFrame + 6 ) {
line 652
;652:		return 1 + frame - ci->animations[TORSO_ATTACK].firstFrame;
ADDRFP4 4
INDIRI4
CNSTI4 1
ADDI4
ADDRFP4 0
INDIRP4
CNSTI4 588
ADDP4
INDIRI4
SUBI4
RETI4
ADDRGP4 $411
JUMPV
LABELV $416
line 655
;653:	}
;654:	
;655:	return 0;
CNSTI4 0
RETI4
LABELV $411
endproc CG_MapTorsoToWeaponFrame 24 0
proc CG_CalculateWeaponPosition 40 4
line 664
;656:}
;657:
;658:
;659:/*
;660:==============
;661:CG_CalculateWeaponPosition
;662:==============
;663:*/
;664:static void CG_CalculateWeaponPosition( vec3_t origin, vec3_t angles ) {
line 669
;665:	float	scale;
;666:	int		delta;
;667:	float	fracsin;
;668:
;669:	VectorCopy( cg.refdef.vieworg, origin );
ADDRFP4 0
INDIRP4
ADDRGP4 cg+106800+24
INDIRB
ASGNB 12
line 670
;670:	VectorCopy( cg.refdefViewAngles, angles );
ADDRFP4 4
INDIRP4
ADDRGP4 cg+107168
INDIRB
ASGNB 12
line 673
;671:
;672:	// on odd legs, invert some angles
;673:	if ( cg.bobcycle & 1 ) {
ADDRGP4 cg+112028
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $422
line 674
;674:		scale = -cg.xyspeed;
ADDRLP4 0
ADDRGP4 cg+112032
INDIRF4
NEGF4
ASGNF4
line 675
;675:	} else {
ADDRGP4 $423
JUMPV
LABELV $422
line 676
;676:		scale = cg.xyspeed;
ADDRLP4 0
ADDRGP4 cg+112032
INDIRF4
ASGNF4
line 677
;677:	}
LABELV $423
line 680
;678:
;679:	// gun angles from bobbing
;680:	angles[ROLL] += scale * cg.bobfracsin * 0.005;
ADDRLP4 12
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CNSTF4 1000593162
ADDRLP4 0
INDIRF4
ADDRGP4 cg+112024
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 681
;681:	angles[YAW] += scale * cg.bobfracsin * 0.01;
ADDRLP4 16
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRGP4 cg+112024
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 682
;682:	angles[PITCH] += cg.xyspeed * cg.bobfracsin * 0.005;
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1000593162
ADDRGP4 cg+112032
INDIRF4
ADDRGP4 cg+112024
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 685
;683:
;684:	// drop the weapon when landing
;685:	delta = cg.time - cg.landTime;
ADDRLP4 8
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106696
INDIRI4
SUBI4
ASGNI4
line 686
;686:	if ( delta < LAND_DEFLECT_TIME ) {
ADDRLP4 8
INDIRI4
CNSTI4 150
GEI4 $433
line 687
;687:		origin[2] += cg.landChange*0.25 * delta / LAND_DEFLECT_TIME;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1048576000
ADDRGP4 cg+106692
INDIRF4
MULF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
CNSTF4 1125515264
DIVF4
ADDF4
ASGNF4
line 688
;688:	} else if ( delta < LAND_DEFLECT_TIME + LAND_RETURN_TIME ) {
ADDRGP4 $434
JUMPV
LABELV $433
ADDRLP4 8
INDIRI4
CNSTI4 450
GEI4 $436
line 689
;689:		origin[2] += cg.landChange*0.25 * 
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1048576000
ADDRGP4 cg+106692
INDIRF4
MULF4
CNSTI4 450
ADDRLP4 8
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1133903872
DIVF4
ADDF4
ASGNF4
line 691
;690:			(LAND_DEFLECT_TIME + LAND_RETURN_TIME - delta) / LAND_RETURN_TIME;
;691:	}
LABELV $436
LABELV $434
line 704
;692:
;693:#if 0
;694:	// drop the weapon when stair climbing
;695:	delta = cg.time - cg.stepTime;
;696:	if ( delta < STEP_TIME/2 ) {
;697:		origin[2] -= cg.stepChange*0.25 * delta / (STEP_TIME/2);
;698:	} else if ( delta < STEP_TIME ) {
;699:		origin[2] -= cg.stepChange*0.25 * (STEP_TIME - delta) / (STEP_TIME/2);
;700:	}
;701:#endif
;702:
;703:	// idle drift
;704:	scale = cg.xyspeed + 40;
ADDRLP4 0
ADDRGP4 cg+112032
INDIRF4
CNSTF4 1109393408
ADDF4
ASGNF4
line 705
;705:	fracsin = sin( cg.time * 0.001 );
CNSTF4 981668463
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
MULF4
ARGF4
ADDRLP4 24
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 24
INDIRF4
ASGNF4
line 706
;706:	angles[ROLL] += scale * fracsin * 0.01;
ADDRLP4 28
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 707
;707:	angles[YAW] += scale * fracsin * 0.01;
ADDRLP4 32
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 708
;708:	angles[PITCH] += scale * fracsin * 0.01;
ADDRLP4 36
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 709
;709:}
LABELV $418
endproc CG_CalculateWeaponPosition 40 4
proc CG_LightningBolt 284 28
line 723
;710:
;711:
;712:/*
;713:===============
;714:CG_LightningBolt
;715:
;716:Origin will be the exact tag point, which is slightly
;717:different than the muzzle point used for determining hits.
;718:The cent should be the non-predicted cent if it is from the player,
;719:so the endpoint will reflect the simulated strike (lagging the predicted
;720:angle)
;721:===============
;722:*/
;723:static void CG_LightningBolt( centity_t *cent, vec3_t origin ) {
line 729
;724:	trace_t		trace;
;725:	refEntity_t		beam;
;726:	vec3_t			forward;
;727:	vec3_t			muzzlePoint, endPoint;
;728:
;729:	if ( cent->currentState.weapon != WP_LIGHTNING ) {
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 6
EQI4 $442
line 730
;730:		return;
ADDRGP4 $441
JUMPV
LABELV $442
line 733
;731:	}
;732:
;733:	memset( &beam, 0, sizeof( beam ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 736
;734:
;735:	// find muzzle point for this frame
;736:	VectorCopy( cent->lerpOrigin, muzzlePoint );
ADDRLP4 140
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRB
ASGNB 12
line 737
;737:	AngleVectors( cent->lerpAngles, forward, NULL, NULL );
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
ARGP4
ADDRLP4 152
ARGP4
ADDRLP4 232
CNSTP4 0
ASGNP4
ADDRLP4 232
INDIRP4
ARGP4
ADDRLP4 232
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 739
;738:	// FIXME: crouch
;739:	muzzlePoint[2] += DEFAULT_VIEWHEIGHT;
ADDRLP4 140+8
ADDRLP4 140+8
INDIRF4
CNSTF4 1104150528
ADDF4
ASGNF4
line 741
;740:
;741:	VectorMA( muzzlePoint, 14, forward, muzzlePoint );
ADDRLP4 236
CNSTF4 1096810496
ASGNF4
ADDRLP4 140
ADDRLP4 140
INDIRF4
ADDRLP4 236
INDIRF4
ADDRLP4 152
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 140+4
ADDRLP4 140+4
INDIRF4
ADDRLP4 236
INDIRF4
ADDRLP4 152+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 140+8
ADDRLP4 140+8
INDIRF4
CNSTF4 1096810496
ADDRLP4 152+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 744
;742:
;743:	// project forward by the lightning range
;744:	VectorMA( muzzlePoint, LIGHTNING_RANGE, forward, endPoint );
ADDRLP4 240
CNSTF4 1145044992
ASGNF4
ADDRLP4 220
ADDRLP4 140
INDIRF4
ADDRLP4 240
INDIRF4
ADDRLP4 152
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 220+4
ADDRLP4 140+4
INDIRF4
ADDRLP4 240
INDIRF4
ADDRLP4 152+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 220+8
ADDRLP4 140+8
INDIRF4
CNSTF4 1145044992
ADDRLP4 152+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 747
;745:
;746:	// see if it hit a wall
;747:	CG_Trace( &trace, muzzlePoint, vec3_origin, vec3_origin, endPoint, 
ADDRLP4 164
ARGP4
ADDRLP4 140
ARGP4
ADDRLP4 244
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 244
INDIRP4
ARGP4
ADDRLP4 244
INDIRP4
ARGP4
ADDRLP4 220
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 751
;748:		cent->currentState.number, MASK_SHOT );
;749:
;750:	// this is the endpoint
;751:	VectorCopy( trace.endpos, beam.oldorigin );
ADDRLP4 0+84
ADDRLP4 164+12
INDIRB
ASGNB 12
line 755
;752:
;753:	// use the provided origin, even though it may be slightly
;754:	// different than the muzzle origin
;755:	VectorCopy( origin, beam.origin );
ADDRLP4 0+68
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 757
;756:
;757:	beam.reType = RT_LIGHTNING;
ADDRLP4 0
CNSTI4 6
ASGNI4
line 758
;758:	beam.customShader = cgs.media.lightningShader;
ADDRLP4 0+112
ADDRGP4 cgs+170516+124
INDIRI4
ASGNI4
line 759
;759:	trap_R_AddRefEntityToScene( &beam );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 762
;760:
;761:	// add the impact flare if it hit something
;762:	if ( trace.fraction < 1.0 ) {
ADDRLP4 164+8
INDIRF4
CNSTF4 1065353216
GEF4 $463
line 766
;763:		vec3_t	angles;
;764:		vec3_t	dir;
;765:
;766:		VectorSubtract( beam.oldorigin, beam.origin, dir );
ADDRLP4 248
ADDRLP4 0+84
INDIRF4
ADDRLP4 0+68
INDIRF4
SUBF4
ASGNF4
ADDRLP4 248+4
ADDRLP4 0+84+4
INDIRF4
ADDRLP4 0+68+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 248+8
ADDRLP4 0+84+8
INDIRF4
ADDRLP4 0+68+8
INDIRF4
SUBF4
ASGNF4
line 767
;767:		VectorNormalize( dir );
ADDRLP4 248
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 769
;768:
;769:		memset( &beam, 0, sizeof( beam ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 770
;770:		beam.hModel = cgs.media.lightningExplosionModel;
ADDRLP4 0+8
ADDRGP4 cgs+170516+372
INDIRI4
ASGNI4
line 772
;771:
;772:		VectorMA( trace.endpos, -16, dir, beam.origin );
ADDRLP4 0+68
ADDRLP4 164+12
INDIRF4
CNSTF4 3246391296
ADDRLP4 248
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 164+12+4
INDIRF4
CNSTF4 3246391296
ADDRLP4 248+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 164+12+8
INDIRF4
CNSTF4 3246391296
ADDRLP4 248+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 775
;773:
;774:		// make a random orientation
;775:		angles[0] = rand() % 360;
ADDRLP4 272
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 260
ADDRLP4 272
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 776
;776:		angles[1] = rand() % 360;
ADDRLP4 276
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 260+4
ADDRLP4 276
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 777
;777:		angles[2] = rand() % 360;
ADDRLP4 280
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 260+8
ADDRLP4 280
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 778
;778:		AnglesToAxis( angles, beam.axis );
ADDRLP4 260
ARGP4
ADDRLP4 0+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 779
;779:		trap_R_AddRefEntityToScene( &beam );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 780
;780:	}
LABELV $463
line 781
;781:}
LABELV $441
endproc CG_LightningBolt 284 28
proc CG_SpawnRailTrail 4 12
line 792
;782:
;783:
;784:/*
;785:===============
;786:CG_SpawnRailTrail
;787:
;788:Origin will be the exact tag point, which is slightly
;789:different than the muzzle point used for determining hits.
;790:===============
;791:*/
;792:static void CG_SpawnRailTrail( centity_t *cent, vec3_t origin ) {
line 795
;793:	clientInfo_t	*ci;
;794:
;795:	if ( cent->currentState.weapon != WP_RAILGUN ) {
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 7
EQI4 $497
line 796
;796:		return;
ADDRGP4 $496
JUMPV
LABELV $497
line 798
;797:	}
;798:	if ( !cent->pe.railgunFlash ) {
ADDRFP4 0
INDIRP4
CNSTI4 568
ADDP4
INDIRI4
CNSTI4 0
NEI4 $499
line 799
;799:		return;
ADDRGP4 $496
JUMPV
LABELV $499
line 801
;800:	}
;801:	cent->pe.railgunFlash = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 568
ADDP4
CNSTI4 1
ASGNI4
line 802
;802:	ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 0
CNSTI4 1076
ADDRFP4 0
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 803
;803:	CG_RailTrail( ci, origin, cent->pe.railgunImpact );
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 556
ADDP4
ARGP4
ADDRGP4 CG_RailTrail
CALLV
pop
line 804
;804:}
LABELV $496
endproc CG_SpawnRailTrail 4 12
proc CG_MachinegunSpinAngle 32 4
line 814
;805:
;806:
;807:/*
;808:======================
;809:CG_MachinegunSpinAngle
;810:======================
;811:*/
;812:#define		SPIN_SPEED	0.9
;813:#define		COAST_TIME	1000
;814:static float	CG_MachinegunSpinAngle( centity_t *cent ) {
line 819
;815:	int		delta;
;816:	float	angle;
;817:	float	speed;
;818:
;819:	delta = cg.time - cent->pe.barrelTime;
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
SUBI4
ASGNI4
line 820
;820:	if ( cent->pe.barrelSpinning ) {
ADDRFP4 0
INDIRP4
CNSTI4 580
ADDP4
INDIRI4
CNSTI4 0
EQI4 $504
line 821
;821:		angle = cent->pe.barrelAngle + delta * SPIN_SPEED;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 572
ADDP4
INDIRF4
CNSTF4 1063675494
ADDRLP4 0
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 822
;822:	} else {
ADDRGP4 $505
JUMPV
LABELV $504
line 823
;823:		if ( delta > COAST_TIME ) {
ADDRLP4 0
INDIRI4
CNSTI4 1000
LEI4 $506
line 824
;824:			delta = COAST_TIME;
ADDRLP4 0
CNSTI4 1000
ASGNI4
line 825
;825:		}
LABELV $506
line 827
;826:
;827:		speed = 0.5 * ( SPIN_SPEED + (float)( COAST_TIME - delta ) / COAST_TIME );
ADDRLP4 8
CNSTF4 1056964608
CNSTI4 1000
ADDRLP4 0
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1148846080
DIVF4
CNSTF4 1063675494
ADDF4
MULF4
ASGNF4
line 828
;828:		angle = cent->pe.barrelAngle + delta * speed;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 572
ADDP4
INDIRF4
ADDRLP4 0
INDIRI4
CVIF4 4
ADDRLP4 8
INDIRF4
MULF4
ADDF4
ASGNF4
line 829
;829:	}
LABELV $505
line 831
;830:
;831:	if ( cent->pe.barrelSpinning == !(cent->currentState.eFlags & EF_FIRING) ) {
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
NEI4 $511
ADDRLP4 12
CNSTI4 1
ASGNI4
ADDRGP4 $512
JUMPV
LABELV $511
ADDRLP4 12
CNSTI4 0
ASGNI4
LABELV $512
ADDRLP4 16
INDIRP4
CNSTI4 580
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $508
line 832
;832:		cent->pe.barrelTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 576
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 833
;833:		cent->pe.barrelAngle = AngleMod( angle );
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 20
ADDRGP4 AngleMod
CALLF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 572
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
line 834
;834:		cent->pe.barrelSpinning = !!(cent->currentState.eFlags & EF_FIRING);
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $515
ADDRLP4 24
CNSTI4 1
ASGNI4
ADDRGP4 $516
JUMPV
LABELV $515
ADDRLP4 24
CNSTI4 0
ASGNI4
LABELV $516
ADDRLP4 28
INDIRP4
CNSTI4 580
ADDP4
ADDRLP4 24
INDIRI4
ASGNI4
line 835
;835:	}
LABELV $508
line 837
;836:
;837:	return angle;
ADDRLP4 4
INDIRF4
RETF4
LABELV $502
endproc CG_MachinegunSpinAngle 32 4
proc CG_AddWeaponWithPowerups 0 4
line 846
;838:}
;839:
;840:
;841:/*
;842:========================
;843:CG_AddWeaponWithPowerups
;844:========================
;845:*/
;846:static void CG_AddWeaponWithPowerups( refEntity_t *gun, int powerups ) {
line 848
;847:	// add powerup effects
;848:	if ( powerups & ( 1 << PW_INVIS ) ) {
ADDRFP4 4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $518
line 849
;849:		gun->customShader = cgs.media.invisShader;
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+332
INDIRI4
ASGNI4
line 850
;850:		trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 851
;851:	} else {
ADDRGP4 $519
JUMPV
LABELV $518
line 852
;852:		trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 854
;853:
;854:		if ( powerups & ( 1 << PW_BATTLESUIT ) ) {
ADDRFP4 4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $522
line 855
;855:			gun->customShader = cgs.media.battleWeaponShader;
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+344
INDIRI4
ASGNI4
line 856
;856:			trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 857
;857:		}
LABELV $522
line 858
;858:		if ( powerups & ( 1 << PW_QUAD ) ) {
ADDRFP4 4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $526
line 859
;859:			gun->customShader = cgs.media.quadWeaponShader;
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+328
INDIRI4
ASGNI4
line 860
;860:			trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 861
;861:		}
LABELV $526
line 862
;862:	}
LABELV $519
line 863
;863:}
LABELV $517
endproc CG_AddWeaponWithPowerups 0 4
export CG_AddPlayerWeapon
proc CG_AddPlayerWeapon 496 20
line 875
;864:
;865:
;866:/*
;867:=============
;868:CG_AddPlayerWeapon
;869:
;870:Used for both the view weapon (ps is valid) and the world modelother character models (ps is NULL)
;871:The main player will have this called for BOTH cases, so effects like light and
;872:sound should only be done on the world model case.
;873:=============
;874:*/
;875:void CG_AddPlayerWeapon( refEntity_t *parent, playerState_t *ps, centity_t *cent ) {
line 884
;876:	refEntity_t	gun;
;877:	refEntity_t	barrel;
;878:	refEntity_t	flash;
;879:	vec3_t		angles;
;880:	weapon_t	weaponNum;
;881:	weaponInfo_t	*weapon;
;882:	centity_t	*nonPredictedCent;
;883:
;884:	weaponNum = cent->currentState.weapon;
ADDRLP4 280
ADDRFP4 8
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
line 885
;885:	if(weaponNum == WP_NONE)
ADDRLP4 280
INDIRI4
CNSTI4 0
NEI4 $531
line 886
;886:		return;
ADDRGP4 $530
JUMPV
LABELV $531
line 887
;887:	CG_RegisterWeapon( weaponNum );
ADDRLP4 280
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 888
;888:	weapon = &cg_weapons[weaponNum];
ADDRLP4 284
CNSTI4 132
ADDRLP4 280
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 891
;889:
;890:	// add the weapon
;891:	memset( &gun, 0, sizeof( gun ) );
ADDRLP4 140
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 892
;892:	VectorCopy( parent->lightingOrigin, gun.lightingOrigin );
ADDRLP4 140+12
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 893
;893:	gun.shadowPlane = parent->shadowPlane;
ADDRLP4 140+24
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ASGNF4
line 894
;894:	gun.renderfx = parent->renderfx;
ADDRLP4 140+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 897
;895:
;896:	// set custom shading for railgun refire rate
;897:	if ( ps ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $536
line 898
;898:		if ( cg.predictedPlayerState.weapon == WP_RAILGUN 
ADDRGP4 cg+105532+144
INDIRI4
CNSTI4 7
NEI4 $538
ADDRGP4 cg+105532+148
INDIRI4
CNSTI4 3
NEI4 $538
line 899
;899:			&& cg.predictedPlayerState.weaponstate == WEAPON_FIRING ) {
line 902
;900:			float	f;
;901:
;902:			f = (float)cg.predictedPlayerState.weaponTime / 1500;
ADDRLP4 444
ADDRGP4 cg+105532+44
INDIRI4
CVIF4 4
CNSTF4 1153138688
DIVF4
ASGNF4
line 904
;903:			
;904:			gun.shaderRGBA[0] = cgs.clientinfo[cent->currentState.clientNum].color[0] * 255 * ( 1.0 - f );
ADDRLP4 452
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76
ADDP4
INDIRF4
MULF4
CNSTF4 1065353216
ADDRLP4 444
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 456
CNSTF4 1325400064
ASGNF4
ADDRLP4 452
INDIRF4
ADDRLP4 456
INDIRF4
LTF4 $550
ADDRLP4 448
ADDRLP4 452
INDIRF4
ADDRLP4 456
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $551
JUMPV
LABELV $550
ADDRLP4 448
ADDRLP4 452
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $551
ADDRLP4 140+116
ADDRLP4 448
INDIRU4
CVUU1 4
ASGNU1
line 905
;905:			gun.shaderRGBA[1] = cgs.clientinfo[cent->currentState.clientNum].color[1] * 255 * ( 1.0 - f );
ADDRLP4 464
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76+4
ADDP4
INDIRF4
MULF4
CNSTF4 1065353216
ADDRLP4 444
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 468
CNSTF4 1325400064
ASGNF4
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
LTF4 $558
ADDRLP4 460
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $559
JUMPV
LABELV $558
ADDRLP4 460
ADDRLP4 464
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $559
ADDRLP4 140+116+1
ADDRLP4 460
INDIRU4
CVUU1 4
ASGNU1
line 906
;906:			gun.shaderRGBA[2] = cgs.clientinfo[cent->currentState.clientNum].color[2] * 255 * ( 1.0 - f );
ADDRLP4 476
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76+8
ADDP4
INDIRF4
MULF4
CNSTF4 1065353216
ADDRLP4 444
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 480
CNSTF4 1325400064
ASGNF4
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
LTF4 $566
ADDRLP4 472
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $567
JUMPV
LABELV $566
ADDRLP4 472
ADDRLP4 476
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $567
ADDRLP4 140+116+2
ADDRLP4 472
INDIRU4
CVUU1 4
ASGNU1
line 907
;907:			gun.shaderRGBA[3] = 128 + 127 * ( 1.0 - f );
ADDRLP4 488
CNSTF4 1123942400
CNSTF4 1065353216
ADDRLP4 444
INDIRF4
SUBF4
MULF4
CNSTF4 1124073472
ADDF4
ASGNF4
ADDRLP4 492
CNSTF4 1325400064
ASGNF4
ADDRLP4 488
INDIRF4
ADDRLP4 492
INDIRF4
LTF4 $571
ADDRLP4 484
ADDRLP4 488
INDIRF4
ADDRLP4 492
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $572
JUMPV
LABELV $571
ADDRLP4 484
ADDRLP4 488
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $572
ADDRLP4 140+116+3
ADDRLP4 484
INDIRU4
CVUU1 4
ASGNU1
line 909
;908:			
;909:		} else {
ADDRGP4 $537
JUMPV
LABELV $538
line 910
;910:			gun.shaderRGBA[0] = cgs.clientinfo[cent->currentState.clientNum].color[0] * 255;
ADDRLP4 448
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 452
CNSTF4 1325400064
ASGNF4
ADDRLP4 448
INDIRF4
ADDRLP4 452
INDIRF4
LTF4 $577
ADDRLP4 444
ADDRLP4 448
INDIRF4
ADDRLP4 452
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $578
JUMPV
LABELV $577
ADDRLP4 444
ADDRLP4 448
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $578
ADDRLP4 140+116
ADDRLP4 444
INDIRU4
CVUU1 4
ASGNU1
line 911
;911:			gun.shaderRGBA[1] = cgs.clientinfo[cent->currentState.clientNum].color[1] * 255;
ADDRLP4 460
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76+4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 464
CNSTF4 1325400064
ASGNF4
ADDRLP4 460
INDIRF4
ADDRLP4 464
INDIRF4
LTF4 $585
ADDRLP4 456
ADDRLP4 460
INDIRF4
ADDRLP4 464
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $586
JUMPV
LABELV $585
ADDRLP4 456
ADDRLP4 460
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $586
ADDRLP4 140+116+1
ADDRLP4 456
INDIRU4
CVUU1 4
ASGNU1
line 912
;912:			gun.shaderRGBA[2] = cgs.clientinfo[cent->currentState.clientNum].color[2] * 255;
ADDRLP4 472
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76+8
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 476
CNSTF4 1325400064
ASGNF4
ADDRLP4 472
INDIRF4
ADDRLP4 476
INDIRF4
LTF4 $593
ADDRLP4 468
ADDRLP4 472
INDIRF4
ADDRLP4 476
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $594
JUMPV
LABELV $593
ADDRLP4 468
ADDRLP4 472
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $594
ADDRLP4 140+116+2
ADDRLP4 468
INDIRU4
CVUU1 4
ASGNU1
line 913
;913:			gun.shaderRGBA[3] = 255;
ADDRLP4 140+116+3
CNSTU1 255
ASGNU1
line 914
;914:		}
line 915
;915:	}
ADDRGP4 $537
JUMPV
LABELV $536
line 916
;916:	else if(weaponNum == WP_RAILGUN)
ADDRLP4 280
INDIRI4
CNSTI4 7
NEI4 $597
line 917
;917:	{
line 918
;918:		gun.shaderRGBA[0] = cgs.clientinfo[cent->currentState.clientNum].color[0] * 255;
ADDRLP4 448
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 452
CNSTF4 1325400064
ASGNF4
ADDRLP4 448
INDIRF4
ADDRLP4 452
INDIRF4
LTF4 $603
ADDRLP4 444
ADDRLP4 448
INDIRF4
ADDRLP4 452
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $604
JUMPV
LABELV $603
ADDRLP4 444
ADDRLP4 448
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $604
ADDRLP4 140+116
ADDRLP4 444
INDIRU4
CVUU1 4
ASGNU1
line 919
;919:		gun.shaderRGBA[1] = cgs.clientinfo[cent->currentState.clientNum].color[1] * 255;
ADDRLP4 460
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76+4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 464
CNSTF4 1325400064
ASGNF4
ADDRLP4 460
INDIRF4
ADDRLP4 464
INDIRF4
LTF4 $611
ADDRLP4 456
ADDRLP4 460
INDIRF4
ADDRLP4 464
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $612
JUMPV
LABELV $611
ADDRLP4 456
ADDRLP4 460
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $612
ADDRLP4 140+116+1
ADDRLP4 456
INDIRU4
CVUU1 4
ASGNU1
line 920
;920:		gun.shaderRGBA[2] = cgs.clientinfo[cent->currentState.clientNum].color[2] * 255;
ADDRLP4 472
CNSTF4 1132396544
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76+8
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 476
CNSTF4 1325400064
ASGNF4
ADDRLP4 472
INDIRF4
ADDRLP4 476
INDIRF4
LTF4 $619
ADDRLP4 468
ADDRLP4 472
INDIRF4
ADDRLP4 476
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $620
JUMPV
LABELV $619
ADDRLP4 468
ADDRLP4 472
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $620
ADDRLP4 140+116+2
ADDRLP4 468
INDIRU4
CVUU1 4
ASGNU1
line 921
;921:		gun.shaderRGBA[3] = 255;
ADDRLP4 140+116+3
CNSTU1 255
ASGNU1
line 923
;922:		
;923:	}
LABELV $597
LABELV $537
line 925
;924:
;925:	gun.hModel = weapon->weaponModel;
ADDRLP4 140+8
ADDRLP4 284
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ASGNI4
line 926
;926:	if (!gun.hModel) {
ADDRLP4 140+8
INDIRI4
CNSTI4 0
NEI4 $624
line 927
;927:		return;
ADDRGP4 $530
JUMPV
LABELV $624
line 930
;928:	}
;929:
;930:	if ( !ps ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $627
line 932
;931:		// add weapon ready sound
;932:		cent->pe.lightningFiring = qfalse;
ADDRFP4 8
INDIRP4
CNSTI4 540
ADDP4
CNSTI4 0
ASGNI4
line 933
;933:		if ( ( cent->currentState.eFlags & EF_FIRING ) && weapon->firingSound ) {
ADDRLP4 444
CNSTI4 0
ASGNI4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 256
BANDI4
ADDRLP4 444
INDIRI4
EQI4 $629
ADDRLP4 284
INDIRP4
CNSTI4 128
ADDP4
INDIRI4
ADDRLP4 444
INDIRI4
EQI4 $629
line 935
;934:			// lightning gun and guantlet make a different sound when fire is held down
;935:			trap_S_AddLoopingSound( cent->currentState.number, cent->lerpOrigin, vec3_origin, weapon->firingSound );
ADDRLP4 448
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 448
INDIRP4
INDIRI4
ARGI4
ADDRLP4 448
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 284
INDIRP4
CNSTI4 128
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_AddLoopingSound
CALLV
pop
line 936
;936:			cent->pe.lightningFiring = qtrue;
ADDRFP4 8
INDIRP4
CNSTI4 540
ADDP4
CNSTI4 1
ASGNI4
line 937
;937:		} else if ( weapon->readySound ) {
ADDRGP4 $630
JUMPV
LABELV $629
ADDRLP4 284
INDIRP4
CNSTI4 124
ADDP4
INDIRI4
CNSTI4 0
EQI4 $631
line 938
;938:			trap_S_AddLoopingSound( cent->currentState.number, cent->lerpOrigin, vec3_origin, weapon->readySound );
ADDRLP4 448
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 448
INDIRP4
INDIRI4
ARGI4
ADDRLP4 448
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 284
INDIRP4
CNSTI4 124
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_AddLoopingSound
CALLV
pop
line 939
;939:		}
LABELV $631
LABELV $630
line 940
;940:	}
LABELV $627
line 941
;941:	CG_PositionEntityOnTag( &gun, parent, parent->hModel, "tag_weapon");
ADDRLP4 140
ARGP4
ADDRLP4 444
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 444
INDIRP4
ARGP4
ADDRLP4 444
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $633
ARGP4
ADDRGP4 CG_PositionEntityOnTag
CALLV
pop
line 942
;942:	if((cent->pe.legs.animationNumber & ~ANIM_TOGGLEBIT) == LEGS_SWIM)
ADDRFP4 8
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
CNSTI4 -129
BANDI4
CNSTI4 17
NEI4 $634
line 943
;943:	{
line 948
;944:	//	vec3_t u1[3], u2[3];
;945:	//	CG_Printf("is this working?\n");
;946:		//CG_PlayerAngles(cent, u1, u2, gun.axis);
;947:	//	CG_PositionRotatedEntityOnTag( &gun, parent, parent->hModel, "tag_weapon");
;948:		AnglesToAxis(cent->lerpAngles, gun.axis);
ADDRFP4 8
INDIRP4
CNSTI4 664
ADDP4
ARGP4
ADDRLP4 140+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 949
;949:	}
LABELV $634
line 950
;950:	CG_AddWeaponWithPowerups( &gun, cent->currentState.powerups );
ADDRLP4 140
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_AddWeaponWithPowerups
CALLV
pop
line 953
;951:
;952:	// add the spinning barrel
;953:	if ( weaponNum == WP_MACHINEGUN || weaponNum == WP_GAUNTLET || weaponNum == WP_BFG ) {
ADDRLP4 280
INDIRI4
CNSTI4 2
EQI4 $640
ADDRLP4 280
INDIRI4
CNSTI4 1
EQI4 $640
ADDRLP4 280
INDIRI4
CNSTI4 9
NEI4 $637
LABELV $640
line 954
;954:		memset( &barrel, 0, sizeof( barrel ) );
ADDRLP4 300
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 955
;955:		VectorCopy( parent->lightingOrigin, barrel.lightingOrigin );
ADDRLP4 300+12
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 956
;956:		barrel.shadowPlane = parent->shadowPlane;
ADDRLP4 300+24
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ASGNF4
line 957
;957:		barrel.renderfx = parent->renderfx;
ADDRLP4 300+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 959
;958:
;959:		barrel.hModel = weapon->barrelModel;
ADDRLP4 300+8
ADDRLP4 284
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
line 960
;960:		angles[YAW] = 0;
ADDRLP4 288+4
CNSTF4 0
ASGNF4
line 961
;961:		angles[PITCH] = 0;
ADDRLP4 288
CNSTF4 0
ASGNF4
line 962
;962:		angles[ROLL] = CG_MachinegunSpinAngle( cent );
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 452
ADDRGP4 CG_MachinegunSpinAngle
CALLF4
ASGNF4
ADDRLP4 288+8
ADDRLP4 452
INDIRF4
ASGNF4
line 963
;963:		AnglesToAxis( angles, barrel.axis );
ADDRLP4 288
ARGP4
ADDRLP4 300+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 965
;964:
;965:		CG_PositionRotatedEntityOnTag( &barrel, &gun, weapon->weaponModel, "tag_barrel" );
ADDRLP4 300
ARGP4
ADDRLP4 140
ARGP4
ADDRLP4 284
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRGP4 $648
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 967
;966:
;967:		CG_AddWeaponWithPowerups( &barrel, cent->currentState.powerups );
ADDRLP4 300
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_AddWeaponWithPowerups
CALLV
pop
line 968
;968:	}
LABELV $637
line 971
;969:
;970:	// make sure we aren't looking at cg.predictedPlayerEntity for LG
;971:	nonPredictedCent = &cg_entities[cent->currentState.clientNum];
ADDRLP4 440
CNSTI4 680
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 976
;972:
;973:	// if the index of the nonPredictedCent is not the same as the clientNum
;974:	// then this is a fake player (like on teh single player podiums), so
;975:	// go ahead and use the cent
;976:	if( ( nonPredictedCent - cg_entities ) != cent->currentState.clientNum ) {
ADDRLP4 440
INDIRP4
CVPU4 4
ADDRGP4 cg_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 680
DIVI4
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
EQI4 $649
line 977
;977:		nonPredictedCent = cent;
ADDRLP4 440
ADDRFP4 8
INDIRP4
ASGNP4
line 978
;978:	}
LABELV $649
line 982
;979:
;980:	// add the flash
;981:	
;982:	memset( &flash, 0, sizeof( flash ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 983
;983:	VectorCopy( parent->lightingOrigin, flash.lightingOrigin );
ADDRLP4 0+12
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 984
;984:	flash.shadowPlane = parent->shadowPlane;
ADDRLP4 0+24
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ASGNF4
line 985
;985:	flash.renderfx = parent->renderfx;
ADDRLP4 0+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 987
;986:
;987:	flash.hModel = weapon->flashModel;
ADDRLP4 0+8
ADDRLP4 284
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
line 988
;988:	if (!flash.hModel) {
ADDRLP4 0+8
INDIRI4
CNSTI4 0
NEI4 $655
line 989
;989:		return;
ADDRGP4 $530
JUMPV
LABELV $655
line 991
;990:	}
;991:	angles[YAW] = 0;
ADDRLP4 288+4
CNSTF4 0
ASGNF4
line 992
;992:	angles[PITCH] = 0;
ADDRLP4 288
CNSTF4 0
ASGNF4
line 993
;993:	angles[ROLL] = crandom() * 10;
ADDRLP4 452
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 288+8
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 452
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 994
;994:	AnglesToAxis( angles, flash.axis );
ADDRLP4 288
ARGP4
ADDRLP4 0+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 997
;995:
;996:	// colorize the railgun blast
;997:	if ( weaponNum == WP_RAILGUN ) {
ADDRLP4 280
INDIRI4
CNSTI4 7
NEI4 $661
line 1000
;998:		clientInfo_t	*ci;
;999:
;1000:		ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 456
CNSTI4 1076
ADDRFP4 8
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 1001
;1001:		flash.shaderRGBA[0] = 255 * ci->color[0];
ADDRLP4 464
CNSTF4 1132396544
ADDRLP4 456
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 468
CNSTF4 1325400064
ASGNF4
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
LTF4 $666
ADDRLP4 460
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $667
JUMPV
LABELV $666
ADDRLP4 460
ADDRLP4 464
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $667
ADDRLP4 0+116
ADDRLP4 460
INDIRU4
CVUU1 4
ASGNU1
line 1002
;1002:		flash.shaderRGBA[1] = 255 * ci->color[1];
ADDRLP4 476
CNSTF4 1132396544
ADDRLP4 456
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 480
CNSTF4 1325400064
ASGNF4
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
LTF4 $671
ADDRLP4 472
ADDRLP4 476
INDIRF4
ADDRLP4 480
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $672
JUMPV
LABELV $671
ADDRLP4 472
ADDRLP4 476
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $672
ADDRLP4 0+116+1
ADDRLP4 472
INDIRU4
CVUU1 4
ASGNU1
line 1003
;1003:		flash.shaderRGBA[2] = 255 * ci->color[2];
ADDRLP4 488
CNSTF4 1132396544
ADDRLP4 456
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 492
CNSTF4 1325400064
ASGNF4
ADDRLP4 488
INDIRF4
ADDRLP4 492
INDIRF4
LTF4 $676
ADDRLP4 484
ADDRLP4 488
INDIRF4
ADDRLP4 492
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $677
JUMPV
LABELV $676
ADDRLP4 484
ADDRLP4 488
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $677
ADDRLP4 0+116+2
ADDRLP4 484
INDIRU4
CVUU1 4
ASGNU1
line 1004
;1004:	}
LABELV $661
line 1006
;1005:
;1006:	CG_PositionRotatedEntityOnTag( &flash, &gun, weapon->weaponModel, "tag_flash");
ADDRLP4 0
ARGP4
ADDRLP4 140
ARGP4
ADDRLP4 284
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRGP4 $678
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 1007
;1007:	VectorCopy(flash.origin, cent->pe.railgunOrigin); 
ADDRFP4 8
INDIRP4
CNSTI4 544
ADDP4
ADDRLP4 0+68
INDIRB
ASGNB 12
line 1008
;1008:	VectorCopy(flash.origin, cent->currentState.origin2); 
ADDRFP4 8
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 0+68
INDIRB
ASGNB 12
line 1040
;1009:#if 0 // laser sight
;1010:	{
;1011:		vec3_t			forward, start, end;
;1012:		localEntity_t	*le;
;1013:		refEntity_t		*re;
;1014:		trace_t			tr;
;1015:		le = CG_AllocLocalEntity();
;1016:		re = &le->refEntity;
;1017:
;1018:		le->leType = LE_FADE_RGB;
;1019:		le->startTime = cg.time;
;1020:		le->endTime = cg.time + 1;
;1021:		le->lifeRate = 1;
;1022:
;1023:		re->shaderTime = cg.time / 1000.0f;
;1024:		re->reType = RT_RAIL_CORE;
;1025:		re->customShader = cgs.media.railCoreShader;
;1026:		
;1027:		VectorCopy( flash.origin, re->origin );
;1028:		AngleVectors(cent->lerpAngles, forward, NULL, NULL);
;1029:		VectorMA( re->origin, 8192, forward, end);
;1030:		CG_Trace(&tr, re->origin, vec3_origin, vec3_origin, end, cent->currentState.number, CONTENTS_SOLID | CONTENTS_PLAYERCLIP);
;1031:		VectorCopy(tr.endpos, re->oldorigin);
;1032:		le->color[0] = 1.0;
;1033:		le->color[1] = 0.0;
;1034:		le->color[2] = 0.0;
;1035:		le->color[3] = 0.025;
;1036:
;1037:		AxisClear( re->axis );
;1038:	}
;1039:#endif
;1040:	if ( ( weaponNum == WP_LIGHTNING || weaponNum == WP_GAUNTLET || weaponNum == WP_GRAPPLING_HOOK )
ADDRLP4 280
INDIRI4
CNSTI4 6
EQI4 $684
ADDRLP4 280
INDIRI4
CNSTI4 1
EQI4 $684
ADDRLP4 280
INDIRI4
CNSTI4 -1
NEI4 $681
LABELV $684
ADDRLP4 440
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $681
line 1042
;1041:		&& ( nonPredictedCent->currentState.eFlags & EF_FIRING ) ) 
;1042:	{
line 1044
;1043:		// continuous flash
;1044:	} else {
ADDRGP4 $682
JUMPV
LABELV $681
line 1046
;1045:		// impulse flash
;1046:		if ( cg.time - cent->muzzleFlashTime > MUZZLE_FLASH_TIME && !cent->pe.railgunFlash ) {
ADDRLP4 460
ADDRFP4 8
INDIRP4
ASGNP4
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 460
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
SUBI4
CNSTI4 20
LEI4 $685
ADDRLP4 460
INDIRP4
CNSTI4 568
ADDP4
INDIRI4
CNSTI4 0
NEI4 $685
line 1047
;1047:			return;
ADDRGP4 $530
JUMPV
LABELV $685
line 1049
;1048:		}
;1049:	}
LABELV $682
line 1051
;1050:	
;1051:	trap_R_AddRefEntityToScene( &flash );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 1053
;1052:	
;1053:	if ( ps || cg.renderingThirdPerson || cg_thirdPerson.value ||
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $696
ADDRGP4 cg+105524
INDIRI4
CNSTI4 0
NEI4 $696
ADDRGP4 cg_thirdPerson+8
INDIRF4
CNSTF4 0
NEF4 $696
ADDRFP4 8
INDIRP4
INDIRI4
ADDRGP4 cg+105532+140
INDIRI4
EQI4 $688
LABELV $696
line 1054
;1054:		cent->currentState.number != cg.predictedPlayerState.clientNum ) {
line 1056
;1055:		// add lightning bolt
;1056:		CG_LightningBolt( nonPredictedCent, flash.origin );
ADDRLP4 440
INDIRP4
ARGP4
ADDRLP4 0+68
ARGP4
ADDRGP4 CG_LightningBolt
CALLV
pop
line 1059
;1057:
;1058:		// add rail trail
;1059:		CG_SpawnRailTrail( nonPredictedCent, flash.origin );
ADDRLP4 440
INDIRP4
ARGP4
ADDRLP4 0+68
ARGP4
ADDRGP4 CG_SpawnRailTrail
CALLV
pop
line 1062
;1060:
;1061:		// make a dlight for the flash
;1062:		if ( weapon->flashDlightColor[0] || weapon->flashDlightColor[1] || weapon->flashDlightColor[2] ) {
ADDRLP4 464
CNSTF4 0
ASGNF4
ADDRLP4 284
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 464
INDIRF4
NEF4 $702
ADDRLP4 284
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 464
INDIRF4
NEF4 $702
ADDRLP4 284
INDIRP4
CNSTI4 48
ADDP4
INDIRF4
ADDRLP4 464
INDIRF4
EQF4 $699
LABELV $702
line 1063
;1063:			trap_R_AddLightToScene( flash.origin, 200 + (rand()&31), weapon->flashDlightColor[0],
ADDRLP4 468
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+68
ARGP4
ADDRLP4 468
INDIRI4
CNSTI4 31
BANDI4
CNSTI4 200
ADDI4
CVIF4 4
ARGF4
ADDRLP4 284
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ARGF4
ADDRLP4 284
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ARGF4
ADDRLP4 284
INDIRP4
CNSTI4 48
ADDP4
INDIRF4
ARGF4
ADDRGP4 trap_R_AddLightToScene
CALLV
pop
line 1065
;1064:				weapon->flashDlightColor[1], weapon->flashDlightColor[2] );
;1065:		}
LABELV $699
line 1066
;1066:	}
LABELV $688
line 1068
;1067:	
;1068:}
LABELV $530
endproc CG_AddPlayerWeapon 496 20
export CG_AddViewWeapon
proc CG_AddViewWeapon 188 12
line 1077
;1069:
;1070:/*
;1071:==============
;1072:CG_AddViewWeapon
;1073:
;1074:Add the weapon, and flash for the player's view
;1075:==============
;1076:*/
;1077:void CG_AddViewWeapon( playerState_t *ps ) {
line 1085
;1078:	refEntity_t	hand;
;1079:	centity_t	*cent;
;1080:	clientInfo_t	*ci;
;1081:	float		fovOffset;
;1082:	vec3_t		angles;
;1083:	weaponInfo_t	*weapon;
;1084:
;1085:	if ( ps->persistant[PERS_TEAM] == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 3
NEI4 $705
line 1086
;1086:		return;
ADDRGP4 $704
JUMPV
LABELV $705
line 1089
;1087:	}
;1088:
;1089:	if ( ps->pm_type == PM_INTERMISSION ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 5
NEI4 $707
line 1090
;1090:		return;
ADDRGP4 $704
JUMPV
LABELV $707
line 1094
;1091:	}
;1092:
;1093:	// no gun if in third person view
;1094:	if ( cg.renderingThirdPerson || cg_thirdPerson.integer) {
ADDRLP4 168
CNSTI4 0
ASGNI4
ADDRGP4 cg+105524
INDIRI4
ADDRLP4 168
INDIRI4
NEI4 $713
ADDRGP4 cg_thirdPerson+12
INDIRI4
ADDRLP4 168
INDIRI4
EQI4 $709
LABELV $713
line 1095
;1095:		return;
ADDRGP4 $704
JUMPV
LABELV $709
line 1099
;1096:	}
;1097:
;1098:	// allow the gun to be completely removed
;1099:	if ( !cg_drawGun.integer ) {
ADDRGP4 cg_drawGun+12
INDIRI4
CNSTI4 0
NEI4 $714
line 1102
;1100:		vec3_t		origin;
;1101:
;1102:		if ( cg.predictedPlayerState.eFlags & EF_FIRING ) {
ADDRGP4 cg+105532+104
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $704
line 1104
;1103:			// special hack for lightning gun...
;1104:			VectorCopy( cg.refdef.vieworg, origin );
ADDRLP4 172
ADDRGP4 cg+106800+24
INDIRB
ASGNB 12
line 1105
;1105:			VectorMA( origin, -8, cg.refdef.viewaxis[2], origin );
ADDRLP4 184
CNSTF4 3238002688
ASGNF4
ADDRLP4 172
ADDRLP4 172
INDIRF4
ADDRLP4 184
INDIRF4
ADDRGP4 cg+106800+36+24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 172+4
ADDRLP4 172+4
INDIRF4
ADDRLP4 184
INDIRF4
ADDRGP4 cg+106800+36+24+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 172+8
ADDRLP4 172+8
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+106800+36+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1106
;1106:			CG_LightningBolt( &cg_entities[ps->clientNum], origin );
CNSTI4 680
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ARGP4
ADDRLP4 172
ARGP4
ADDRGP4 CG_LightningBolt
CALLV
pop
line 1107
;1107:		}
line 1108
;1108:		return;
ADDRGP4 $704
JUMPV
LABELV $714
line 1112
;1109:	}
;1110:
;1111:	// don't draw if testing a gun model
;1112:	if ( cg.testGun ) {
ADDRGP4 cg+112240
INDIRI4
CNSTI4 0
EQI4 $738
line 1113
;1113:		return;
ADDRGP4 $704
JUMPV
LABELV $738
line 1117
;1114:	}
;1115:
;1116:	// drop gun lower at higher fov
;1117:	if ( cg_fov.integer > 90 ) {
ADDRGP4 cg_fov+12
INDIRI4
CNSTI4 90
LEI4 $741
line 1118
;1118:		fovOffset = -0.2 * ( cg_fov.integer - 90 );
ADDRLP4 140
CNSTF4 3192704205
ADDRGP4 cg_fov+12
INDIRI4
CNSTI4 90
SUBI4
CVIF4 4
MULF4
ASGNF4
line 1119
;1119:	} else {
ADDRGP4 $742
JUMPV
LABELV $741
line 1120
;1120:		fovOffset = 0;
ADDRLP4 140
CNSTF4 0
ASGNF4
line 1121
;1121:	}
LABELV $742
line 1123
;1122:
;1123:	cent = &cg.predictedPlayerEntity;	// &cg_entities[cg.snap->ps.clientNum];
ADDRLP4 144
ADDRGP4 cg+105976
ASGNP4
line 1124
;1124:	CG_RegisterWeapon( ps->weapon );
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 1125
;1125:	weapon = &cg_weapons[ ps->weapon ];
ADDRLP4 160
CNSTI4 132
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 1127
;1126:
;1127:	memset (&hand, 0, sizeof(hand));
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 1130
;1128:
;1129:	// set up gun position
;1130:	CG_CalculateWeaponPosition( hand.origin, angles );
ADDRLP4 0+68
ARGP4
ADDRLP4 148
ARGP4
ADDRGP4 CG_CalculateWeaponPosition
CALLV
pop
line 1132
;1131:
;1132:	VectorMA( hand.origin, cg_gun_x.value, cg.refdef.viewaxis[0], hand.origin );
ADDRLP4 0+68
ADDRLP4 0+68
INDIRF4
ADDRGP4 cg+106800+36
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 0+68+4
INDIRF4
ADDRGP4 cg+106800+36+4
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
ADDRGP4 cg+106800+36+8
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1133
;1133:	VectorMA( hand.origin, cg_gun_y.value, cg.refdef.viewaxis[1], hand.origin );
ADDRLP4 0+68
ADDRLP4 0+68
INDIRF4
ADDRGP4 cg+106800+36+12
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 0+68+4
INDIRF4
ADDRGP4 cg+106800+36+12+4
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
ADDRGP4 cg+106800+36+12+8
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1134
;1134:	VectorMA( hand.origin, (cg_gun_z.value+fovOffset), cg.refdef.viewaxis[2], hand.origin );
ADDRLP4 0+68
ADDRLP4 0+68
INDIRF4
ADDRGP4 cg+106800+36+24
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
ADDRLP4 140
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 0+68+4
INDIRF4
ADDRGP4 cg+106800+36+24+4
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
ADDRLP4 140
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
ADDRGP4 cg+106800+36+24+8
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
ADDRLP4 140
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 1136
;1135:
;1136:	AnglesToAxis( angles, hand.axis );
ADDRLP4 148
ARGP4
ADDRLP4 0+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 1139
;1137:
;1138:	// map torso animations to weapon animations
;1139:	if ( cg_gun_frame.integer ) {
ADDRGP4 cg_gun_frame+12
INDIRI4
CNSTI4 0
EQI4 $817
line 1141
;1140:		// development tool
;1141:		hand.frame = hand.oldframe = cg_gun_frame.integer;
ADDRLP4 172
ADDRGP4 cg_gun_frame+12
INDIRI4
ASGNI4
ADDRLP4 0+96
ADDRLP4 172
INDIRI4
ASGNI4
ADDRLP4 0+80
ADDRLP4 172
INDIRI4
ASGNI4
line 1142
;1142:		hand.backlerp = 0;
ADDRLP4 0+100
CNSTF4 0
ASGNF4
line 1143
;1143:	} else {
ADDRGP4 $818
JUMPV
LABELV $817
line 1145
;1144:		// get clientinfo for animation map
;1145:		ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 164
CNSTI4 1076
ADDRLP4 144
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 1146
;1146:		hand.frame = CG_MapTorsoToWeaponFrame( ci, cent->pe.torso.frame );
ADDRLP4 164
INDIRP4
ARGP4
ADDRLP4 144
INDIRP4
CNSTI4 492
ADDP4
INDIRI4
ARGI4
ADDRLP4 172
ADDRGP4 CG_MapTorsoToWeaponFrame
CALLI4
ASGNI4
ADDRLP4 0+80
ADDRLP4 172
INDIRI4
ASGNI4
line 1147
;1147:		hand.oldframe = CG_MapTorsoToWeaponFrame( ci, cent->pe.torso.oldFrame );
ADDRLP4 164
INDIRP4
ARGP4
ADDRLP4 144
INDIRP4
CNSTI4 484
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
ADDRGP4 CG_MapTorsoToWeaponFrame
CALLI4
ASGNI4
ADDRLP4 0+96
ADDRLP4 176
INDIRI4
ASGNI4
line 1148
;1148:		hand.backlerp = cent->pe.torso.backlerp;
ADDRLP4 0+100
ADDRLP4 144
INDIRP4
CNSTI4 500
ADDP4
INDIRF4
ASGNF4
line 1149
;1149:	}
LABELV $818
line 1151
;1150:
;1151:	hand.hModel = weapon->handsModel;
ADDRLP4 0+8
ADDRLP4 160
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 1152
;1152:	hand.renderfx = RF_DEPTHHACK | RF_FIRST_PERSON | RF_MINLIGHT;
ADDRLP4 0+4
CNSTI4 13
ASGNI4
line 1155
;1153:
;1154:	// add everything onto the hand
;1155:	CG_AddPlayerWeapon( &hand, ps, &cg.predictedPlayerEntity );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 cg+105976
ARGP4
ADDRGP4 CG_AddPlayerWeapon
CALLV
pop
line 1156
;1156:}
LABELV $704
endproc CG_AddViewWeapon 188 12
export CG_DrawWeaponSelect
proc CG_DrawWeaponSelect 168 20
line 1171
;1157:
;1158:/*
;1159:==============================================================================
;1160:
;1161:WEAPON SELECTION
;1162:
;1163:==============================================================================
;1164:*/
;1165:
;1166:/*
;1167:===================
;1168:CG_DrawWeaponSelect
;1169:===================
;1170:*/
;1171:void CG_DrawWeaponSelect( void ) {
line 1179
;1172:	int		i;
;1173:	int		bits;
;1174:	int		count;
;1175:	int		x, y, w;
;1176:	float	*color;
;1177:
;1178:	// don't display if dead
;1179:	if ( cg.predictedPlayerState.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+105532+184
INDIRI4
CNSTI4 0
GTI4 $832
line 1180
;1180:		return;
ADDRGP4 $831
JUMPV
LABELV $832
line 1183
;1181:	}
;1182:
;1183:	color = CG_FadeColor( cg.weaponSelectTime, WEAPON_SELECT_TIME );
ADDRGP4 cg+111932
INDIRI4
ARGI4
CNSTI4 1400
ARGI4
ADDRLP4 28
ADDRGP4 CG_FadeColor
CALLP4
ASGNP4
ADDRLP4 20
ADDRLP4 28
INDIRP4
ASGNP4
line 1184
;1184:	if ( !color ) {
ADDRLP4 20
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $837
line 1185
;1185:		return;
ADDRGP4 $831
JUMPV
LABELV $837
line 1187
;1186:	}
;1187:	trap_R_SetColor( color );
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1190
;1188:
;1189:	// showing weapon select clears pickup item display, but not the blend blob
;1190:	cg.itemPickupTime = 0;
ADDRGP4 cg+111924
CNSTI4 0
ASGNI4
line 1193
;1191:
;1192:	// count the number of weapons owned
;1193:	bits = cg.snap->ps.stats[ STAT_WEAPONS ];
ADDRLP4 12
ADDRGP4 cg+32
INDIRP4
CNSTI4 236
ADDP4
INDIRI4
ASGNI4
line 1194
;1194:	count = 0; // ALWAYS at least have a fist/gauntlet
ADDRLP4 16
CNSTI4 0
ASGNI4
line 1195
;1195:	for ( i = 1 ; i < 16 ; i++ ) {
ADDRLP4 0
CNSTI4 1
ASGNI4
LABELV $841
line 1196
;1196:		if ( bits & ( 2 << i ) ) {
ADDRLP4 12
INDIRI4
CNSTI4 2
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $845
line 1197
;1197:			count++;
ADDRLP4 16
ADDRLP4 16
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1198
;1198:		}
LABELV $845
line 1199
;1199:	}
LABELV $842
line 1195
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $841
line 1200
;1200:	x = 320 - count * 20;
ADDRLP4 4
CNSTI4 320
CNSTI4 20
ADDRLP4 16
INDIRI4
MULI4
SUBI4
ASGNI4
line 1201
;1201:	y = 380;
ADDRLP4 8
CNSTI4 380
ASGNI4
line 1203
;1202:
;1203:	for ( i = 1 ; i < 16 ; i++ ) {
ADDRLP4 0
CNSTI4 1
ASGNI4
LABELV $847
line 1204
;1204:		if (!( bits & ( 1 << i ) ) ) {
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $851
line 1205
;1205:			continue;
ADDRGP4 $848
JUMPV
LABELV $851
line 1208
;1206:		}
;1207:
;1208:		CG_RegisterWeapon( i );
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 1211
;1209:
;1210:		// draw weapon icon
;1211:		CG_DrawPic( x, y, 32, 32, cg_weapons[i].weaponIcon );
ADDRLP4 4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 32
CNSTF4 1107296256
ASGNF4
ADDRLP4 32
INDIRF4
ARGF4
ADDRLP4 32
INDIRF4
ARGF4
CNSTI4 132
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg_weapons+68
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1214
;1212:
;1213:		// draw selection marker
;1214:		if ( i == cg.weaponSelect ) {
ADDRLP4 0
INDIRI4
ADDRGP4 cg+106700
INDIRI4
NEI4 $854
line 1215
;1215:			CG_DrawPic( x-4, y-4, 40, 40, cgs.media.selectShader );
ADDRLP4 36
CNSTI4 4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 36
INDIRI4
SUBI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
ADDRLP4 36
INDIRI4
SUBI4
CVIF4 4
ARGF4
ADDRLP4 40
CNSTF4 1109393408
ASGNF4
ADDRLP4 40
INDIRF4
ARGF4
ADDRLP4 40
INDIRF4
ARGF4
ADDRGP4 cgs+170516+140
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1216
;1216:		}
LABELV $854
line 1219
;1217:
;1218:		// no ammo cross on top
;1219:		if ( !cg.snap->ps.ammo[ i ] ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 420
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $859
line 1220
;1220:			CG_DrawPic( x, y, 32, 32, cgs.media.noammoShader );
ADDRLP4 4
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 36
CNSTF4 1107296256
ASGNF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRGP4 cgs+170516+200
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1221
;1221:		}
LABELV $859
line 1223
;1222:
;1223:		x += 40;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 40
ADDI4
ASGNI4
line 1224
;1224:	}
LABELV $848
line 1203
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $847
line 1227
;1225:
;1226:	// draw the selected name
;1227:	if ( cg_weapons[ cg.weaponSelect ].item ) {
CNSTI4 132
ADDRGP4 cg+106700
INDIRI4
MULI4
ADDRGP4 cg_weapons+4
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $864
line 1229
;1228:		char name[128];
;1229:		name[0] = '\0';
ADDRLP4 32
CNSTI1 0
ASGNI1
line 1230
;1230:		if(!cg.predictedPlayerState.stats[STAT_WEAPONS] & (1 << cg.weaponSelect))
ADDRGP4 cg+105532+184+8
INDIRI4
CNSTI4 0
NEI4 $875
ADDRLP4 160
CNSTI4 1
ASGNI4
ADDRGP4 $876
JUMPV
LABELV $875
ADDRLP4 160
CNSTI4 0
ASGNI4
LABELV $876
ADDRLP4 160
INDIRI4
CNSTI4 1
ADDRGP4 cg+106700
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $868
line 1231
;1231:		{
line 1232
;1232:			strcpy(name, "Dropped: ");
ADDRLP4 32
ARGP4
ADDRGP4 $877
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1233
;1233:		}
LABELV $868
line 1234
;1234:		strcat(name, cg_weapons[ cg.weaponSelect ].item->pickup_name);
ADDRLP4 32
ARGP4
CNSTI4 132
ADDRGP4 cg+106700
INDIRI4
MULI4
ADDRGP4 cg_weapons+4
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRP4
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 1235
;1235:		if ( name ) {
ADDRLP4 32
CVPU4 4
CNSTU4 0
EQU4 $880
line 1236
;1236:			w = CG_DrawStrlen( name ) * BIGCHAR_WIDTH;
ADDRLP4 32
ARGP4
ADDRLP4 164
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 164
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 1237
;1237:			x = ( SCREEN_WIDTH - w ) / 2;
ADDRLP4 4
CNSTI4 640
ADDRLP4 24
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 1238
;1238:			CG_DrawBigStringColor(x, y - 22, name, color);
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
CNSTI4 22
SUBI4
ARGI4
ADDRLP4 32
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 CG_DrawBigStringColor
CALLV
pop
line 1239
;1239:		}
LABELV $880
line 1240
;1240:	}
LABELV $864
line 1242
;1241:
;1242:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1243
;1243:}
LABELV $831
endproc CG_DrawWeaponSelect 168 20
proc CG_WeaponSelectable 0 0
line 1251
;1244:
;1245:
;1246:/*
;1247:===============
;1248:CG_WeaponSelectable
;1249:===============
;1250:*/
;1251:static qboolean CG_WeaponSelectable( int i ) {
line 1252
;1252:	if(cg.snap->ps.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS)
ADDRGP4 cg+32
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $883
line 1253
;1253:	{
line 1255
;1254:		
;1255:	}
ADDRGP4 $884
JUMPV
LABELV $883
line 1256
;1256:	else if ( !cg.snap->ps.ammo[i] ) {
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 420
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $886
line 1257
;1257:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $882
JUMPV
LABELV $886
LABELV $884
line 1259
;1258:	}
;1259:	if ( ! (cg.snap->ps.stats[ STAT_WEAPONS ] & ( 1 << i ) ) ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 236
ADDP4
INDIRI4
CNSTI4 1
ADDRFP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $889
line 1260
;1260:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $882
JUMPV
LABELV $889
line 1263
;1261:	}
;1262:
;1263:	return qtrue;
CNSTI4 1
RETI4
LABELV $882
endproc CG_WeaponSelectable 0 0
export CG_NextWeapon_f
proc CG_NextWeapon_f 16 4
line 1271
;1264:}
;1265:
;1266:/*
;1267:===============
;1268:CG_NextWeapon_f
;1269:===============
;1270:*/
;1271:void CG_NextWeapon_f( void ) {
line 1275
;1272:	int		i;
;1273:	int		original;
;1274:
;1275:	if ( !cg.snap ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $893
line 1276
;1276:		return;
ADDRGP4 $892
JUMPV
LABELV $893
line 1278
;1277:	}
;1278:	if ( cg.snap->ps.pm_flags & PMF_FOLLOW ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $896
line 1279
;1279:		return;
ADDRGP4 $892
JUMPV
LABELV $896
line 1282
;1280:	}
;1281:
;1282:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1283
;1283:	original = cg.weaponSelect;
ADDRLP4 4
ADDRGP4 cg+106700
INDIRI4
ASGNI4
line 1285
;1284:
;1285:	for ( i = 0 ; i < 16 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $902
line 1286
;1286:		cg.weaponSelect++;
ADDRLP4 8
ADDRGP4 cg+106700
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1287
;1287:		if ( cg.weaponSelect == 16 ) {
ADDRGP4 cg+106700
INDIRI4
CNSTI4 16
NEI4 $907
line 1288
;1288:			cg.weaponSelect = 0;
ADDRGP4 cg+106700
CNSTI4 0
ASGNI4
line 1289
;1289:		}
LABELV $907
line 1293
;1290:		//if ( cg.weaponSelect == WP_GAUNTLET ) {
;1291:		//	continue;		// never cycle to gauntlet
;1292:		//}
;1293:		if ( CG_WeaponSelectable( cg.weaponSelect ) ) {
ADDRGP4 cg+106700
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $911
line 1294
;1294:			break;
ADDRGP4 $904
JUMPV
LABELV $911
line 1296
;1295:		}
;1296:	}
LABELV $903
line 1285
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $902
LABELV $904
line 1297
;1297:	if ( i == 16 ) {
ADDRLP4 0
INDIRI4
CNSTI4 16
NEI4 $914
line 1298
;1298:		cg.weaponSelect = original;
ADDRGP4 cg+106700
ADDRLP4 4
INDIRI4
ASGNI4
line 1299
;1299:	}
LABELV $914
line 1300
;1300:}
LABELV $892
endproc CG_NextWeapon_f 16 4
export CG_PrevWeapon_f
proc CG_PrevWeapon_f 16 4
line 1307
;1301:
;1302:/*
;1303:===============
;1304:CG_PrevWeapon_f
;1305:===============
;1306:*/
;1307:void CG_PrevWeapon_f( void ) {
line 1311
;1308:	int		i;
;1309:	int		original;
;1310:
;1311:	if ( !cg.snap ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $918
line 1312
;1312:		return;
ADDRGP4 $917
JUMPV
LABELV $918
line 1314
;1313:	}
;1314:	if ( cg.snap->ps.pm_flags & PMF_FOLLOW ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $921
line 1315
;1315:		return;
ADDRGP4 $917
JUMPV
LABELV $921
line 1318
;1316:	}
;1317:
;1318:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1319
;1319:	original = cg.weaponSelect;
ADDRLP4 4
ADDRGP4 cg+106700
INDIRI4
ASGNI4
line 1321
;1320:
;1321:	for ( i = 0 ; i < 16 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $927
line 1322
;1322:		cg.weaponSelect--;
ADDRLP4 8
ADDRGP4 cg+106700
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1323
;1323:		if ( cg.weaponSelect == -1 ) {
ADDRGP4 cg+106700
INDIRI4
CNSTI4 -1
NEI4 $932
line 1324
;1324:			cg.weaponSelect = 15;
ADDRGP4 cg+106700
CNSTI4 15
ASGNI4
line 1325
;1325:		}
LABELV $932
line 1329
;1326:		//if ( cg.weaponSelect == WP_GAUNTLET ) {
;1327:		//	continue;		// never cycle to gauntlet
;1328:		//}
;1329:		if ( CG_WeaponSelectable( cg.weaponSelect ) ) {
ADDRGP4 cg+106700
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $936
line 1330
;1330:			break;
ADDRGP4 $929
JUMPV
LABELV $936
line 1332
;1331:		}
;1332:	}
LABELV $928
line 1321
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $927
LABELV $929
line 1333
;1333:	if ( i == 16 ) {
ADDRLP4 0
INDIRI4
CNSTI4 16
NEI4 $939
line 1334
;1334:		cg.weaponSelect = original;
ADDRGP4 cg+106700
ADDRLP4 4
INDIRI4
ASGNI4
line 1335
;1335:	}
LABELV $939
line 1336
;1336:}
LABELV $917
endproc CG_PrevWeapon_f 16 4
export CG_Weapon_f
proc CG_Weapon_f 16 4
line 1343
;1337:
;1338:/*
;1339:===============
;1340:CG_Weapon_f
;1341:===============
;1342:*/
;1343:void CG_Weapon_f( void ) {
line 1346
;1344:	int		num;
;1345:
;1346:	if ( !cg.snap ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $943
line 1347
;1347:		return;
ADDRGP4 $942
JUMPV
LABELV $943
line 1349
;1348:	}
;1349:	if ( cg.snap->ps.pm_flags & PMF_FOLLOW ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $946
line 1350
;1350:		return;
ADDRGP4 $942
JUMPV
LABELV $946
line 1353
;1351:	}
;1352:
;1353:	num = atoi( CG_Argv( 1 ) );
CNSTI4 1
ARGI4
ADDRLP4 4
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
line 1355
;1354:
;1355:	if ( num < 0 || num > 15 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $951
ADDRLP4 0
INDIRI4
CNSTI4 15
LEI4 $949
LABELV $951
line 1356
;1356:		return;
ADDRGP4 $942
JUMPV
LABELV $949
line 1359
;1357:	}
;1358:
;1359:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1361
;1360:
;1361:	if ( ! ( cg.snap->ps.stats[STAT_WEAPONS] & ( 1 << num ) ) ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 236
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $954
line 1362
;1362:		return;		// don't have the weapon
ADDRGP4 $942
JUMPV
LABELV $954
line 1365
;1363:	}
;1364:
;1365:	cg.weaponSelect = num;
ADDRGP4 cg+106700
ADDRLP4 0
INDIRI4
ASGNI4
line 1366
;1366:}
LABELV $942
endproc CG_Weapon_f 16 4
export CG_OutOfAmmoChange
proc CG_OutOfAmmoChange 8 4
line 1375
;1367:
;1368:/*
;1369:===================
;1370:CG_OutOfAmmoChange
;1371:
;1372:The current weapon has just run out of ammo
;1373:===================
;1374:*/
;1375:void CG_OutOfAmmoChange( void ) {
line 1378
;1376:	int		i;
;1377:
;1378:	if(cg.snap->ps.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS)
ADDRGP4 cg+32
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $959
line 1379
;1379:		return;
ADDRGP4 $958
JUMPV
LABELV $959
line 1380
;1380:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1382
;1381:
;1382:	for ( i = 15 ; i >= 0 ; i-- ) {
ADDRLP4 0
CNSTI4 15
ASGNI4
LABELV $964
line 1383
;1383:		if ( CG_WeaponSelectable( i ) ) {
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $968
line 1384
;1384:			cg.weaponSelect = i;
ADDRGP4 cg+106700
ADDRLP4 0
INDIRI4
ASGNI4
line 1385
;1385:			break;
ADDRGP4 $966
JUMPV
LABELV $968
line 1387
;1386:		}
;1387:	}
LABELV $965
line 1382
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $964
LABELV $966
line 1388
;1388:}
LABELV $958
endproc CG_OutOfAmmoChange 8 4
export CG_FireWeapon
proc CG_FireWeapon 20 16
line 1407
;1389:
;1390:
;1391:
;1392:/*
;1393:===================================================================================================
;1394:
;1395:WEAPON EVENTS
;1396:
;1397:===================================================================================================
;1398:*/
;1399:
;1400:/*
;1401:================
;1402:CG_FireWeapon
;1403:
;1404:Caused by an EV_FIRE_WEAPON event
;1405:================
;1406:*/
;1407:void CG_FireWeapon( centity_t *cent ) {
line 1412
;1408:	entityState_t *ent;
;1409:	int				c;
;1410:	weaponInfo_t	*weap;
;1411:
;1412:	ent = &cent->currentState;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
line 1413
;1413:	if ( ent->weapon == WP_NONE ) {
ADDRLP4 8
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 0
NEI4 $972
line 1414
;1414:		return;
ADDRGP4 $971
JUMPV
LABELV $972
line 1416
;1415:	}
;1416:	if ( ent->weapon >= WP_NUM_WEAPONS ) {
ADDRLP4 8
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 10
LTI4 $974
line 1417
;1417:		CG_Error( "CG_FireWeapon: ent->weapon >= WP_NUM_WEAPONS" );
ADDRGP4 $976
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 1418
;1418:		return;
ADDRGP4 $971
JUMPV
LABELV $974
line 1420
;1419:	}
;1420:	weap = &cg_weapons[ ent->weapon ];
ADDRLP4 4
CNSTI4 132
ADDRLP4 8
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 1424
;1421:
;1422:	// mark the entity as muzzle flashing, so when it is added it will
;1423:	// append the flash to the weapon model
;1424:	cent->muzzleFlashTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1427
;1425:
;1426:	// lightning gun only does this this on initial press
;1427:	if ( ent->weapon == WP_LIGHTNING ) {
ADDRLP4 8
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 6
NEI4 $978
line 1428
;1428:		if ( cent->pe.lightningFiring ) {
ADDRFP4 0
INDIRP4
CNSTI4 540
ADDP4
INDIRI4
CNSTI4 0
EQI4 $980
line 1429
;1429:			return;
ADDRGP4 $971
JUMPV
LABELV $980
line 1431
;1430:		}
;1431:	}
LABELV $978
line 1434
;1432:
;1433:	// play quad sound if needed
;1434:	if ( cent->currentState.powerups & ( 1 << PW_QUAD ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $982
line 1435
;1435:		trap_S_StartSound (NULL, cent->currentState.number, CHAN_ITEM, cgs.media.quadSound );
CNSTP4 0
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRGP4 cgs+170516+440
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1436
;1436:	}
LABELV $982
line 1439
;1437:
;1438:	// play a sound
;1439:	for ( c = 0 ; c < 4 ; c++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $986
line 1440
;1440:		if ( !weap->flashSound[c] ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $990
line 1441
;1441:			break;
ADDRGP4 $988
JUMPV
LABELV $990
line 1443
;1442:		}
;1443:	}
LABELV $987
line 1439
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 4
LTI4 $986
LABELV $988
line 1444
;1444:	if ( c > 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $992
line 1445
;1445:		c = rand() % c;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ADDRLP4 0
INDIRI4
MODI4
ASGNI4
line 1446
;1446:		if ( weap->flashSound[c] )
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $994
line 1447
;1447:		{
line 1448
;1448:			trap_S_StartSound( NULL, ent->number, CHAN_WEAPON, weap->flashSound[c] );
CNSTP4 0
ARGP4
ADDRLP4 8
INDIRP4
INDIRI4
ARGI4
ADDRLP4 16
CNSTI4 2
ASGNI4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ADDRLP4 16
INDIRI4
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1449
;1449:		}
LABELV $994
line 1450
;1450:	}
LABELV $992
line 1453
;1451:
;1452:	// do brass ejection
;1453:	if ( weap->ejectBrassFunc && cg_brassTime.integer > 0 ) {
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $996
ADDRGP4 cg_brassTime+12
INDIRI4
CNSTI4 0
LEI4 $996
line 1454
;1454:		weap->ejectBrassFunc( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRP4
CALLV
pop
line 1455
;1455:	}
LABELV $996
line 1456
;1456:}
LABELV $971
endproc CG_FireWeapon 20 16
export CG_MissileHitWall
proc CG_MissileHitWall 108 44
line 1466
;1457:
;1458:
;1459:/*
;1460:=================
;1461:CG_MissileHitWall
;1462:
;1463:Caused by an EV_MISSILE_MISS event, or directly by local bullet tracing
;1464:=================
;1465:*/
;1466:void CG_MissileHitWall( int weapon, int clientNum, vec3_t origin, vec3_t dir ) {
line 1480
;1467:	qhandle_t		mod;
;1468:	qhandle_t		mark;
;1469:	qhandle_t		shader;
;1470:	sfxHandle_t		sfx;
;1471:	float			radius;
;1472:	float			light;
;1473:	vec3_t			lightColor;
;1474:	localEntity_t	*le;
;1475:	int				r;
;1476:	qboolean		alphaFade;
;1477:	qboolean		isSprite;
;1478:	int				duration;
;1479:	
;1480:	mark = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 1481
;1481:	radius = 32;
ADDRLP4 28
CNSTF4 1107296256
ASGNF4
line 1482
;1482:	sfx = 0;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 1483
;1483:	mod = 0;
ADDRLP4 20
CNSTI4 0
ASGNI4
line 1484
;1484:	shader = 0;
ADDRLP4 32
CNSTI4 0
ASGNI4
line 1485
;1485:	light = 0;
ADDRLP4 44
CNSTF4 0
ASGNF4
line 1486
;1486:	lightColor[0] = 1;
ADDRLP4 4
CNSTF4 1065353216
ASGNF4
line 1487
;1487:	lightColor[1] = 1;
ADDRLP4 4+4
CNSTF4 1065353216
ASGNF4
line 1488
;1488:	lightColor[2] = 0;
ADDRLP4 4+8
CNSTF4 0
ASGNF4
line 1491
;1489:
;1490:	// set defaults
;1491:	isSprite = qfalse;
ADDRLP4 40
CNSTI4 0
ASGNI4
line 1492
;1492:	duration = 600;
ADDRLP4 48
CNSTI4 600
ASGNI4
line 1494
;1493:
;1494:	switch ( weapon ) {
ADDRLP4 56
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 60
CNSTI4 2
ASGNI4
ADDRLP4 56
INDIRI4
ADDRLP4 60
INDIRI4
LTI4 $1002
ADDRLP4 56
INDIRI4
CNSTI4 9
GTI4 $1002
ADDRLP4 56
INDIRI4
ADDRLP4 60
INDIRI4
LSHI4
ADDRGP4 $1100-8
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $1100
address $1083
address $1076
address $1017
address $1030
address $1004
address $1045
address $1054
address $1063
code
LABELV $1002
LABELV $1004
line 1498
;1495:	default:
;1496:	case WP_LIGHTNING:
;1497:		// no explosion at LG impact, it is added with the beam
;1498:		r = rand() & 3;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
ADDRLP4 64
INDIRI4
CNSTI4 3
BANDI4
ASGNI4
line 1499
;1499:		if ( r < 2 ) {
ADDRLP4 52
INDIRI4
CNSTI4 2
GEI4 $1005
line 1500
;1500:			sfx = cgs.media.sfx_lghit2;
ADDRLP4 16
ADDRGP4 cgs+170516+576
INDIRI4
ASGNI4
line 1501
;1501:		} else if ( r == 2 ) {
ADDRGP4 $1006
JUMPV
LABELV $1005
ADDRLP4 52
INDIRI4
CNSTI4 2
NEI4 $1009
line 1502
;1502:			sfx = cgs.media.sfx_lghit1;
ADDRLP4 16
ADDRGP4 cgs+170516+572
INDIRI4
ASGNI4
line 1503
;1503:		} else {
ADDRGP4 $1010
JUMPV
LABELV $1009
line 1504
;1504:			sfx = cgs.media.sfx_lghit3;
ADDRLP4 16
ADDRGP4 cgs+170516+580
INDIRI4
ASGNI4
line 1505
;1505:		}
LABELV $1010
LABELV $1006
line 1506
;1506:		mark = cgs.media.holeMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+312
INDIRI4
ASGNI4
line 1507
;1507:		radius = 12;
ADDRLP4 28
CNSTF4 1094713344
ASGNF4
line 1508
;1508:		break;
ADDRGP4 $1003
JUMPV
LABELV $1017
line 1510
;1509:	case WP_GRENADE_LAUNCHER:
;1510:		mod = cgs.media.dishFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+368
INDIRI4
ASGNI4
line 1511
;1511:		shader = cgs.media.grenadeExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+392
INDIRI4
ASGNI4
line 1512
;1512:		sfx = cgs.media.sfx_rockexp;
ADDRLP4 16
ADDRGP4 cgs+170516+600
INDIRI4
ASGNI4
line 1513
;1513:		mark = cgs.media.burnMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+308
INDIRI4
ASGNI4
line 1514
;1514:		radius = 64;
ADDRLP4 28
CNSTF4 1115684864
ASGNF4
line 1515
;1515:		light = 300;
ADDRLP4 44
CNSTF4 1133903872
ASGNF4
line 1516
;1516:		isSprite = !cg_SphericalExplosions.integer;
ADDRGP4 cg_SphericalExplosions+12
INDIRI4
CNSTI4 0
NEI4 $1028
ADDRLP4 68
CNSTI4 1
ASGNI4
ADDRGP4 $1029
JUMPV
LABELV $1028
ADDRLP4 68
CNSTI4 0
ASGNI4
LABELV $1029
ADDRLP4 40
ADDRLP4 68
INDIRI4
ASGNI4
line 1517
;1517:		break;
ADDRGP4 $1003
JUMPV
LABELV $1030
line 1519
;1518:	case WP_ROCKET_LAUNCHER:
;1519:		mod = cgs.media.dishFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+368
INDIRI4
ASGNI4
line 1520
;1520:		shader = cgs.media.rocketExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+388
INDIRI4
ASGNI4
line 1521
;1521:		sfx = cgs.media.sfx_rockexp;
ADDRLP4 16
ADDRGP4 cgs+170516+600
INDIRI4
ASGNI4
line 1522
;1522:		mark = cgs.media.burnMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+308
INDIRI4
ASGNI4
line 1523
;1523:		radius = 64;
ADDRLP4 28
CNSTF4 1115684864
ASGNF4
line 1524
;1524:		light = 300;
ADDRLP4 44
CNSTF4 1133903872
ASGNF4
line 1525
;1525:		isSprite = !cg_SphericalExplosions.integer;
ADDRGP4 cg_SphericalExplosions+12
INDIRI4
CNSTI4 0
NEI4 $1041
ADDRLP4 72
CNSTI4 1
ASGNI4
ADDRGP4 $1042
JUMPV
LABELV $1041
ADDRLP4 72
CNSTI4 0
ASGNI4
LABELV $1042
ADDRLP4 40
ADDRLP4 72
INDIRI4
ASGNI4
line 1526
;1526:		duration = 1000;
ADDRLP4 48
CNSTI4 1000
ASGNI4
line 1527
;1527:		lightColor[0] = 1;
ADDRLP4 4
CNSTF4 1065353216
ASGNF4
line 1528
;1528:		lightColor[1] = 0.75;
ADDRLP4 4+4
CNSTF4 1061158912
ASGNF4
line 1529
;1529:		lightColor[2] = 0.0;
ADDRLP4 4+8
CNSTF4 0
ASGNF4
line 1530
;1530:		break;
ADDRGP4 $1003
JUMPV
LABELV $1045
line 1532
;1531:	case WP_RAILGUN:
;1532:		mod = cgs.media.ringFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+364
INDIRI4
ASGNI4
line 1533
;1533:		shader = cgs.media.railExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+376
INDIRI4
ASGNI4
line 1534
;1534:		sfx = cgs.media.sfx_plasmaexp;
ADDRLP4 16
ADDRGP4 cgs+170516+604
INDIRI4
ASGNI4
line 1535
;1535:		mark = cgs.media.energyMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+316
INDIRI4
ASGNI4
line 1536
;1536:		radius = 24;
ADDRLP4 28
CNSTF4 1103101952
ASGNF4
line 1537
;1537:		break;
ADDRGP4 $1003
JUMPV
LABELV $1054
line 1539
;1538:	case WP_PLASMAGUN:
;1539:		mod = cgs.media.ringFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+364
INDIRI4
ASGNI4
line 1540
;1540:		shader = cgs.media.plasmaExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+380
INDIRI4
ASGNI4
line 1541
;1541:		sfx = cgs.media.sfx_plasmaexp;
ADDRLP4 16
ADDRGP4 cgs+170516+604
INDIRI4
ASGNI4
line 1542
;1542:		mark = cgs.media.energyMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+316
INDIRI4
ASGNI4
line 1543
;1543:		radius = 16;
ADDRLP4 28
CNSTF4 1098907648
ASGNF4
line 1544
;1544:		break;
ADDRGP4 $1003
JUMPV
LABELV $1063
line 1546
;1545:	case WP_BFG:
;1546:		mod = cgs.media.dishFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+368
INDIRI4
ASGNI4
line 1547
;1547:		shader = cgs.media.bfgExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+396
INDIRI4
ASGNI4
line 1548
;1548:		sfx = cgs.media.sfx_rockexp;
ADDRLP4 16
ADDRGP4 cgs+170516+600
INDIRI4
ASGNI4
line 1549
;1549:		mark = cgs.media.burnMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+308
INDIRI4
ASGNI4
line 1550
;1550:		radius = 32;
ADDRLP4 28
CNSTF4 1107296256
ASGNF4
line 1551
;1551:		isSprite = !cg_SphericalExplosions.integer;//qtrue;
ADDRGP4 cg_SphericalExplosions+12
INDIRI4
CNSTI4 0
NEI4 $1074
ADDRLP4 76
CNSTI4 1
ASGNI4
ADDRGP4 $1075
JUMPV
LABELV $1074
ADDRLP4 76
CNSTI4 0
ASGNI4
LABELV $1075
ADDRLP4 40
ADDRLP4 76
INDIRI4
ASGNI4
line 1552
;1552:		break;
ADDRGP4 $1003
JUMPV
LABELV $1076
line 1554
;1553:	case WP_SHOTGUN:
;1554:		mod = cgs.media.bulletFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+360
INDIRI4
ASGNI4
line 1555
;1555:		shader = cgs.media.bulletExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+384
INDIRI4
ASGNI4
line 1556
;1556:		mark = cgs.media.bulletMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+304
INDIRI4
ASGNI4
line 1557
;1557:		sfx = 0;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 1558
;1558:		radius = 1;//4
ADDRLP4 28
CNSTF4 1065353216
ASGNF4
line 1559
;1559:		break;
ADDRGP4 $1003
JUMPV
LABELV $1083
line 1562
;1560:
;1561:	case WP_MACHINEGUN:
;1562:		mod = cgs.media.bulletFlashModel;
ADDRLP4 20
ADDRGP4 cgs+170516+360
INDIRI4
ASGNI4
line 1563
;1563:		shader = cgs.media.bulletExplosionShader;
ADDRLP4 32
ADDRGP4 cgs+170516+384
INDIRI4
ASGNI4
line 1564
;1564:		mark = cgs.media.bulletMarkShader;
ADDRLP4 0
ADDRGP4 cgs+170516+304
INDIRI4
ASGNI4
line 1566
;1565:
;1566:		r = rand() & 3;
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
ADDRLP4 80
INDIRI4
CNSTI4 3
BANDI4
ASGNI4
line 1567
;1567:		if ( r < 2 ) {
ADDRLP4 52
INDIRI4
CNSTI4 2
GEI4 $1090
line 1568
;1568:			sfx = cgs.media.sfx_ric1;
ADDRLP4 16
ADDRGP4 cgs+170516+584
INDIRI4
ASGNI4
line 1569
;1569:		} else if ( r == 2 ) {
ADDRGP4 $1091
JUMPV
LABELV $1090
ADDRLP4 52
INDIRI4
CNSTI4 2
NEI4 $1094
line 1570
;1570:			sfx = cgs.media.sfx_ric2;
ADDRLP4 16
ADDRGP4 cgs+170516+588
INDIRI4
ASGNI4
line 1571
;1571:		} else {
ADDRGP4 $1095
JUMPV
LABELV $1094
line 1572
;1572:			sfx = cgs.media.sfx_ric3;
ADDRLP4 16
ADDRGP4 cgs+170516+592
INDIRI4
ASGNI4
line 1573
;1573:		}
LABELV $1095
LABELV $1091
line 1575
;1574:
;1575:		radius = 8;
ADDRLP4 28
CNSTF4 1090519040
ASGNF4
line 1576
;1576:		break;
LABELV $1003
line 1579
;1577:	}
;1578:
;1579:	if ( sfx ) {
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $1102
line 1580
;1580:		trap_S_StartSound( origin, ENTITYNUM_WORLD, CHAN_AUTO, sfx );
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 1022
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 16
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1581
;1581:	}
LABELV $1102
line 1586
;1582:
;1583:	//
;1584:	// create the explosion
;1585:	//
;1586:	if ( mod ) {
ADDRLP4 20
INDIRI4
CNSTI4 0
EQI4 $1104
line 1587
;1587:		le = CG_MakeExplosion( origin, dir, 
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 20
INDIRI4
ARGI4
ADDRLP4 32
INDIRI4
ARGI4
ADDRLP4 48
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 CG_MakeExplosion
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 64
INDIRP4
ASGNP4
line 1590
;1588:							   mod,	shader,
;1589:							   duration, isSprite );		
;1590:		le->light = light;
ADDRLP4 24
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
line 1592
;1591:		
;1592:		VectorCopy( lightColor, le->lightColor );
ADDRLP4 24
INDIRP4
CNSTI4 128
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 1593
;1593:		if ( weapon == WP_RAILGUN ) {
ADDRFP4 0
INDIRI4
CNSTI4 7
NEI4 $1106
line 1595
;1594:			// colorize with client color
;1595:			VectorCopy( cgs.clientinfo[clientNum].color, le->color );
ADDRLP4 24
INDIRP4
CNSTI4 104
ADDP4
CNSTI4 1076
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76
ADDP4
INDIRB
ASGNB 12
line 1596
;1596:		}
ADDRGP4 $1107
JUMPV
LABELV $1106
line 1597
;1597:		else if(weapon == WP_ROCKET_LAUNCHER || weapon == WP_GRENADE_LAUNCHER || weapon == WP_BFG)
ADDRLP4 68
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 5
EQI4 $1113
ADDRLP4 68
INDIRI4
CNSTI4 4
EQI4 $1113
ADDRLP4 68
INDIRI4
CNSTI4 9
NEI4 $1110
LABELV $1113
line 1598
;1598:		{
line 1600
;1599:			//le->refEntity.customShader = ;//cgs.media.plasmaBallShader;
;1600:			le->refEntity.renderfx |= RF_EXPANDING;			
ADDRLP4 72
ADDRLP4 24
INDIRP4
CNSTI4 152
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRI4
CNSTI4 32768
BORI4
ASGNI4
line 1601
;1601:			le->refEntity.oldorigin[0] = crandom() * 180;
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
INDIRP4
CNSTI4 232
ADDP4
CNSTF4 1127481344
CNSTF4 1073741824
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1602
;1602:			le->refEntity.oldorigin[1] = crandom() * 180;
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
INDIRP4
CNSTI4 236
ADDP4
CNSTF4 1127481344
CNSTF4 1073741824
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1603
;1603:			le->refEntity.oldorigin[2] = crandom() * 180;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
INDIRP4
CNSTI4 240
ADDP4
CNSTF4 1127481344
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1609
;1604:			/*le = CG_MakeExplosion( origin, dir, 
;1605:							   mod,	shader,
;1606:							   duration, qtrue);		*/
;1607:
;1608:			
;1609:		}
ADDRGP4 $1111
JUMPV
LABELV $1110
line 1610
;1610:		else if(weapon == WP_SHOTGUN)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $1114
line 1611
;1611:		{ // smaller damnit
line 1612
;1612:			le->refEntity.axis[0][0] *= 0.2;
ADDRLP4 72
ADDRLP4 24
INDIRP4
CNSTI4 176
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTF4 1045220557
ADDRLP4 72
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1613
;1613:			le->refEntity.axis[1][0] *= 0.2;
ADDRLP4 76
ADDRLP4 24
INDIRP4
CNSTI4 188
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTF4 1045220557
ADDRLP4 76
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1614
;1614:			le->refEntity.axis[2][0] *= 0.2;
ADDRLP4 80
ADDRLP4 24
INDIRP4
CNSTI4 200
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTF4 1045220557
ADDRLP4 80
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1615
;1615:			le->refEntity.axis[0][1] *= 0.2;
ADDRLP4 84
ADDRLP4 24
INDIRP4
CNSTI4 180
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
CNSTF4 1045220557
ADDRLP4 84
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1616
;1616:			le->refEntity.axis[1][1] *= 0.2;
ADDRLP4 88
ADDRLP4 24
INDIRP4
CNSTI4 192
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTF4 1045220557
ADDRLP4 88
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1617
;1617:			le->refEntity.axis[2][1] *= 0.2;
ADDRLP4 92
ADDRLP4 24
INDIRP4
CNSTI4 204
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTF4 1045220557
ADDRLP4 92
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1618
;1618:			le->refEntity.axis[0][2] *= 0.2;
ADDRLP4 96
ADDRLP4 24
INDIRP4
CNSTI4 184
ADDP4
ASGNP4
ADDRLP4 96
INDIRP4
CNSTF4 1045220557
ADDRLP4 96
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1619
;1619:			le->refEntity.axis[1][2] *= 0.2;
ADDRLP4 100
ADDRLP4 24
INDIRP4
CNSTI4 196
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
CNSTF4 1045220557
ADDRLP4 100
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1620
;1620:			le->refEntity.axis[2][2] *= 0.2;
ADDRLP4 104
ADDRLP4 24
INDIRP4
CNSTI4 208
ADDP4
ASGNP4
ADDRLP4 104
INDIRP4
CNSTF4 1045220557
ADDRLP4 104
INDIRP4
INDIRF4
MULF4
ASGNF4
line 1622
;1621:			
;1622:		}
LABELV $1114
LABELV $1111
LABELV $1107
line 1623
;1623:	}
LABELV $1104
line 1628
;1624:
;1625:	//
;1626:	// impact mark
;1627:	//
;1628:	alphaFade = (mark == cgs.media.energyMarkShader);	// plasma fades alpha, all others fade color
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+170516+316
INDIRI4
NEI4 $1119
ADDRLP4 64
CNSTI4 1
ASGNI4
ADDRGP4 $1120
JUMPV
LABELV $1119
ADDRLP4 64
CNSTI4 0
ASGNI4
LABELV $1120
ADDRLP4 36
ADDRLP4 64
INDIRI4
ASGNI4
line 1629
;1629:	if ( weapon == WP_RAILGUN ) {
ADDRFP4 0
INDIRI4
CNSTI4 7
NEI4 $1121
line 1633
;1630:		float	*color;
;1631:
;1632:		// colorize with client color
;1633:		color = cgs.clientinfo[clientNum].color;
ADDRLP4 68
CNSTI4 1076
ADDRFP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+76
ADDP4
ASGNP4
line 1634
;1634:		CG_ImpactMark( mark, origin, dir, random()*360, color[0],color[1], color[2],1, alphaFade, radius, qfalse );
ADDRLP4 72
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
CNSTF4 1135869952
ADDRLP4 72
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ARGF4
ADDRLP4 76
ADDRLP4 68
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
INDIRF4
ARGF4
ADDRLP4 76
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ARGF4
ADDRLP4 76
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 28
INDIRF4
ARGF4
CNSTI4 0
ARGI4
ADDRGP4 CG_ImpactMark
CALLV
pop
line 1635
;1635:	} else {
ADDRGP4 $1122
JUMPV
LABELV $1121
line 1636
;1636:		CG_ImpactMark( mark, origin, dir, random()*360, 1,1,1,1, alphaFade, radius, qfalse );
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
CNSTF4 1135869952
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ARGF4
ADDRLP4 72
CNSTF4 1065353216
ASGNF4
ADDRLP4 72
INDIRF4
ARGF4
ADDRLP4 72
INDIRF4
ARGF4
ADDRLP4 72
INDIRF4
ARGF4
ADDRLP4 72
INDIRF4
ARGF4
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 28
INDIRF4
ARGF4
CNSTI4 0
ARGI4
ADDRGP4 CG_ImpactMark
CALLV
pop
line 1637
;1637:	}
LABELV $1122
line 1638
;1638:}
LABELV $999
endproc CG_MissileHitWall 108 44
export CG_MissileHitPlayer
proc CG_MissileHitPlayer 4 16
line 1646
;1639:
;1640:
;1641:/*
;1642:=================
;1643:CG_MissileHitPlayer
;1644:=================
;1645:*/
;1646:void CG_MissileHitPlayer( int weapon, vec3_t origin, vec3_t dir, int entityNum ) {
line 1648
;1647:	
;1648:	CG_Bleed( origin, entityNum );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 12
INDIRI4
ARGI4
ADDRGP4 CG_Bleed
CALLV
pop
line 1652
;1649:
;1650:	// some weapons will make an explosion with the blood, while
;1651:	// others will just make the blood
;1652:	switch ( weapon ) {
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 4
EQI4 $1128
ADDRLP4 0
INDIRI4
CNSTI4 5
EQI4 $1128
ADDRGP4 $1127
JUMPV
LABELV $1128
line 1655
;1653:	case WP_GRENADE_LAUNCHER:
;1654:	case WP_ROCKET_LAUNCHER:
;1655:		CG_MissileHitWall( weapon, 0, origin, dir );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_MissileHitWall
CALLV
pop
line 1656
;1656:		break;
line 1658
;1657:	default:
;1658:		break;
LABELV $1127
line 1660
;1659:	}
;1660:}
LABELV $1125
endproc CG_MissileHitPlayer 4 16
export CG_MissileHitRPlayer
proc CG_MissileHitRPlayer 4 16
line 1667
;1661:
;1662:/*
;1663:=================
;1664:CG_MissileHitPlayer
;1665:=================
;1666:*/
;1667:void CG_MissileHitRPlayer( int weapon, vec3_t origin, vec3_t dir, int entityNum ) {
line 1668
;1668:	CG_RBleed( origin, entityNum );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 12
INDIRI4
ARGI4
ADDRGP4 CG_RBleed
CALLI4
pop
line 1672
;1669:
;1670:	// some weapons will make an explosion with the blood, while
;1671:	// others will just make the blood
;1672:	switch ( weapon ) {
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 4
EQI4 $1132
ADDRLP4 0
INDIRI4
CNSTI4 5
EQI4 $1132
ADDRGP4 $1131
JUMPV
LABELV $1132
line 1675
;1673:	case WP_GRENADE_LAUNCHER:
;1674:	case WP_ROCKET_LAUNCHER:
;1675:		CG_MissileHitWall( weapon, 0, origin, dir );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_MissileHitWall
CALLV
pop
line 1676
;1676:		break;
line 1678
;1677:	default:
;1678:		break;
LABELV $1131
line 1680
;1679:	}
;1680:}
LABELV $1129
endproc CG_MissileHitRPlayer 4 16
proc CG_ShotgunPellet 136 28
line 1696
;1681:
;1682:
;1683:/*
;1684:============================================================================
;1685:
;1686:SHOTGUN TRACING
;1687:
;1688:============================================================================
;1689:*/
;1690:
;1691:/*
;1692:================
;1693:CG_ShotgunPellet
;1694:================
;1695:*/
;1696:static void CG_ShotgunPellet( vec3_t start, vec3_t end, int skipNum ) {
line 1700
;1697:	trace_t		tr;
;1698:	int sourceContentType, destContentType;
;1699:
;1700:	CG_Trace( &tr, start, NULL, NULL, end, skipNum, MASK_SHOT );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 64
CNSTP4 0
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
CNSTI4 100663297
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 1702
;1701:	
;1702:	sourceContentType = trap_CM_PointContents( start, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 68
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 56
ADDRLP4 68
INDIRI4
ASGNI4
line 1703
;1703:	destContentType = trap_CM_PointContents( tr.endpos, 0 );
ADDRLP4 0+12
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 72
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 60
ADDRLP4 72
INDIRI4
ASGNI4
line 1706
;1704:
;1705:	// FIXME: should probably move this cruft into CG_BubbleTrail
;1706:	if ( sourceContentType == destContentType ) {
ADDRLP4 56
INDIRI4
ADDRLP4 60
INDIRI4
NEI4 $1135
line 1707
;1707:		if ( sourceContentType & CONTENTS_WATER ) {
ADDRLP4 56
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1136
line 1708
;1708:			CG_BubbleTrail( start, tr.endpos, 32 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0+12
ARGP4
CNSTF4 1107296256
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 1709
;1709:		}
line 1710
;1710:	} else if ( sourceContentType & CONTENTS_WATER ) {
ADDRGP4 $1136
JUMPV
LABELV $1135
ADDRLP4 56
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1140
line 1713
;1711:		trace_t trace;
;1712:
;1713:		trap_CM_BoxTrace( &trace, end, start, NULL, NULL, 0, CONTENTS_WATER );
ADDRLP4 76
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 132
CNSTP4 0
ASGNP4
ADDRLP4 132
INDIRP4
ARGP4
ADDRLP4 132
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 32
ARGI4
ADDRGP4 trap_CM_BoxTrace
CALLV
pop
line 1714
;1714:		CG_BubbleTrail( start, trace.endpos, 32 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76+12
ARGP4
CNSTF4 1107296256
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 1715
;1715:	} else if ( destContentType & CONTENTS_WATER ) {
ADDRGP4 $1141
JUMPV
LABELV $1140
ADDRLP4 60
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1143
line 1718
;1716:		trace_t trace;
;1717:
;1718:		trap_CM_BoxTrace( &trace, start, end, NULL, NULL, 0, CONTENTS_WATER );
ADDRLP4 76
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 132
CNSTP4 0
ASGNP4
ADDRLP4 132
INDIRP4
ARGP4
ADDRLP4 132
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 32
ARGI4
ADDRGP4 trap_CM_BoxTrace
CALLV
pop
line 1719
;1719:		CG_BubbleTrail( tr.endpos, trace.endpos, 32 );
ADDRLP4 0+12
ARGP4
ADDRLP4 76+12
ARGP4
CNSTF4 1107296256
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 1720
;1720:	}
LABELV $1143
LABELV $1141
LABELV $1136
line 1722
;1721:
;1722:	if (  tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 0+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $1147
line 1723
;1723:		return;
ADDRGP4 $1133
JUMPV
LABELV $1147
line 1726
;1724:	}
;1725:	
;1726:	if ( cg_entities[tr.entityNum].currentState.eType == ET_PLAYER ) {
CNSTI4 680
ADDRLP4 0+52
INDIRI4
MULI4
ADDRGP4 cg_entities+4
ADDP4
INDIRI4
CNSTI4 1
NEI4 $1150
line 1727
;1727:		CG_MissileHitPlayer( WP_SHOTGUN, tr.endpos, tr.plane.normal, tr.entityNum );
CNSTI4 3
ARGI4
ADDRLP4 0+12
ARGP4
ADDRLP4 0+24
ARGP4
ADDRLP4 0+52
INDIRI4
ARGI4
ADDRGP4 CG_MissileHitPlayer
CALLV
pop
line 1728
;1728:	} else {
ADDRGP4 $1151
JUMPV
LABELV $1150
line 1729
;1729:		if ( tr.surfaceFlags & SURF_NOIMPACT ) {
ADDRLP4 0+44
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $1157
line 1731
;1730:			// SURF_NOIMPACT will not make a flame puff or a mark
;1731:			return;
ADDRGP4 $1133
JUMPV
LABELV $1157
line 1733
;1732:		}
;1733:		CG_MissileHitWall( WP_SHOTGUN, 0, tr.endpos, tr.plane.normal );
CNSTI4 3
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 0+12
ARGP4
ADDRLP4 0+24
ARGP4
ADDRGP4 CG_MissileHitWall
CALLV
pop
line 1734
;1734:	}
LABELV $1151
line 1735
;1735:}
LABELV $1133
endproc CG_ShotgunPellet 136 28
proc CG_ShotgunPattern 84 12
line 1745
;1736:
;1737:/*
;1738:================
;1739:CG_ShotgunPattern
;1740:
;1741:Perform the same traces the server did to locate the
;1742:hit splashes (FIXME: ranom seed isn't synce anymore)
;1743:================
;1744:*/
;1745:static void CG_ShotgunPattern( vec3_t origin, vec3_t origin2, int otherEntNum ) {
line 1753
;1746:	int			i;
;1747:	float		r, u;
;1748:	vec3_t		end;
;1749:	vec3_t		forward, right, up;
;1750:
;1751:	// derive the right and up vectors from the forward vector, because
;1752:	// the client won't have any other information
;1753:	VectorNormalize2( origin2, forward );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 VectorNormalize2
CALLF4
pop
line 1754
;1754:	PerpendicularVector( right, forward );
ADDRLP4 32
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 PerpendicularVector
CALLV
pop
line 1755
;1755:	CrossProduct( forward, right, up );
ADDRLP4 20
ARGP4
ADDRLP4 32
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 1758
;1756:
;1757:	// generate the "random" spread pattern
;1758:	for ( i = 0 ; i < DEFAULT_SHOTGUN_COUNT ; i++ ) {		
ADDRLP4 56
CNSTI4 0
ASGNI4
LABELV $1163
line 1759
;1759:		r = crandom() * DEFAULT_SHOTGUN_SPREAD;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 12
CNSTF4 1145569280
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1760
;1760:		u = crandom() * DEFAULT_SHOTGUN_SPREAD;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 16
CNSTF4 1145569280
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1761
;1761:		VectorMA( origin, 8192, forward, end);
ADDRLP4 68
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 72
CNSTF4 1174405120
ASGNF4
ADDRLP4 0
ADDRLP4 68
INDIRP4
INDIRF4
ADDRLP4 72
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 68
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 72
INDIRF4
ADDRLP4 20+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1174405120
ADDRLP4 20+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1762
;1762:		VectorMA (end, r, right, end);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 32+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 32+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1763
;1763:		VectorMA (end, u, up, end);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 44
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 44+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 44+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1765
;1764:
;1765:		CG_ShotgunPellet( origin, end, otherEntNum );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 CG_ShotgunPellet
CALLV
pop
line 1766
;1766:	}
LABELV $1164
line 1758
ADDRLP4 56
ADDRLP4 56
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 32
LTI4 $1163
line 1767
;1767:}
LABELV $1162
endproc CG_ShotgunPattern 84 12
export CG_ShotgunFire
proc CG_ShotgunFire 56 44
line 1774
;1768:
;1769:/*
;1770:==============
;1771:CG_ShotgunFire
;1772:==============
;1773:*/
;1774:void CG_ShotgunFire( entityState_t *es ) {
line 1778
;1775:	vec3_t	v;
;1776:	int		contents;
;1777:
;1778:	VectorSubtract( es->origin2, es->pos.trBase, v );
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
ADDRLP4 16
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 16
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
ADDRLP4 16
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 20
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1779
;1779:	VectorNormalize( v );
ADDRLP4 0
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1780
;1780:	VectorScale( v, 32, v );
ADDRLP4 24
CNSTF4 1107296256
ASGNF4
ADDRLP4 0
ADDRLP4 24
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 24
INDIRF4
ADDRLP4 0+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+8
CNSTF4 1107296256
ADDRLP4 0+8
INDIRF4
MULF4
ASGNF4
line 1781
;1781:	VectorAdd( es->pos.trBase, v, v );
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 28
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 0+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 0+8
INDIRF4
ADDF4
ASGNF4
line 1782
;1782:	if ( cgs.glconfig.hardwareType != GLHW_RAGEPRO ) {
ADDRGP4 cgs+20100+4120
INDIRI4
CNSTI4 3
EQI4 $1194
line 1786
;1783:		// ragepro can't alpha fade, so don't even bother with smoke
;1784:		vec3_t			up;
;1785:
;1786:		contents = trap_CM_PointContents( es->pos.trBase, 0 );
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 44
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 44
INDIRI4
ASGNI4
line 1787
;1787:		if ( !( contents & CONTENTS_WATER ) ) {
ADDRLP4 12
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
NEI4 $1198
line 1788
;1788:			VectorSet( up, 0, 0, 8 );
ADDRLP4 48
CNSTF4 0
ASGNF4
ADDRLP4 32
ADDRLP4 48
INDIRF4
ASGNF4
ADDRLP4 32+4
ADDRLP4 48
INDIRF4
ASGNF4
ADDRLP4 32+8
CNSTF4 1090519040
ASGNF4
line 1789
;1789:			CG_SmokePuff( v, up, 32, 1, 1, 1, 0.33, 900, cg.time, LEF_PUFF_DONT_SCALE, cgs.media.shotgunSmokePuffShader );
ADDRLP4 0
ARGP4
ADDRLP4 32
ARGP4
CNSTF4 1107296256
ARGF4
ADDRLP4 52
CNSTF4 1065353216
ASGNF4
ADDRLP4 52
INDIRF4
ARGF4
ADDRLP4 52
INDIRF4
ARGF4
ADDRLP4 52
INDIRF4
ARGF4
CNSTF4 1051260355
ARGF4
CNSTF4 1147207680
ARGF4
ADDRGP4 cg+105504
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 cgs+170516+212
INDIRI4
ARGI4
ADDRGP4 CG_SmokePuff
CALLP4
pop
line 1790
;1790:		}
LABELV $1198
line 1791
;1791:	}
LABELV $1194
line 1792
;1792:	CG_ShotgunPattern( es->pos.trBase, es->origin2, es->otherEntityNum );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_ShotgunPattern
CALLV
pop
line 1793
;1793:}
LABELV $1183
endproc CG_ShotgunFire 56 44
export CG_Tracer
proc CG_Tracer 224 16
line 1809
;1794:
;1795:/*
;1796:============================================================================
;1797:
;1798:BULLETS
;1799:
;1800:============================================================================
;1801:*/
;1802:
;1803:
;1804:/*
;1805:===============
;1806:CG_Tracer
;1807:===============
;1808:*/
;1809:void CG_Tracer( vec3_t source, vec3_t dest ) {
line 1818
;1810:	vec3_t		forward, right;
;1811:	polyVert_t	verts[4];
;1812:	vec3_t		line;
;1813:	float		len, begin, end;
;1814:	vec3_t		start, finish;
;1815:	vec3_t		midpoint;
;1816:
;1817:	// tracer
;1818:	VectorSubtract( dest, source, forward );
ADDRLP4 180
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 184
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
ADDRLP4 180
INDIRP4
INDIRF4
ADDRLP4 184
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 188
CNSTI4 4
ASGNI4
ADDRLP4 108+4
ADDRLP4 180
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
ADDRLP4 184
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 192
CNSTI4 8
ASGNI4
ADDRLP4 108+8
ADDRFP4 4
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1819
;1819:	len = VectorNormalize( forward );
ADDRLP4 108
ARGP4
ADDRLP4 196
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 164
ADDRLP4 196
INDIRF4
ASGNF4
line 1822
;1820:
;1821:	// start at least a little ways from the muzzle
;1822:	if ( len < 100 ) {
ADDRLP4 164
INDIRF4
CNSTF4 1120403456
GEF4 $1208
line 1823
;1823:		return;
ADDRGP4 $1205
JUMPV
LABELV $1208
line 1825
;1824:	}
;1825:	begin = 50 + random() * (len - 60);
ADDRLP4 200
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 160
ADDRLP4 200
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 164
INDIRF4
CNSTF4 1114636288
SUBF4
MULF4
CNSTF4 1112014848
ADDF4
ASGNF4
line 1826
;1826:	end = begin + cg_tracerLength.value;
ADDRLP4 156
ADDRLP4 160
INDIRF4
ADDRGP4 cg_tracerLength+8
INDIRF4
ADDF4
ASGNF4
line 1827
;1827:	if ( end > len ) {
ADDRLP4 156
INDIRF4
ADDRLP4 164
INDIRF4
LEF4 $1211
line 1828
;1828:		end = len;
ADDRLP4 156
ADDRLP4 164
INDIRF4
ASGNF4
line 1829
;1829:	}
LABELV $1211
line 1830
;1830:	VectorMA( source, begin, forward, start );
ADDRLP4 204
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 120
ADDRLP4 204
INDIRP4
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 120+4
ADDRLP4 204
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 120+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDF4
ASGNF4
line 1831
;1831:	VectorMA( source, end, forward, finish );
ADDRLP4 212
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 132
ADDRLP4 212
INDIRP4
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132+4
ADDRLP4 212
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
ASGNF4
line 1833
;1832:
;1833:	line[0] = DotProduct( forward, cg.refdef.viewaxis[1] );
ADDRLP4 144
ADDRLP4 108
INDIRF4
ADDRGP4 cg+106800+36+12
INDIRF4
MULF4
ADDRLP4 108+4
INDIRF4
ADDRGP4 cg+106800+36+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 108+8
INDIRF4
ADDRGP4 cg+106800+36+12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1834
;1834:	line[1] = DotProduct( forward, cg.refdef.viewaxis[2] );
ADDRLP4 144+4
ADDRLP4 108
INDIRF4
ADDRGP4 cg+106800+36+24
INDIRF4
MULF4
ADDRLP4 108+4
INDIRF4
ADDRGP4 cg+106800+36+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 108+8
INDIRF4
ADDRGP4 cg+106800+36+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1836
;1835:
;1836:	VectorScale( cg.refdef.viewaxis[1], line[1], right );
ADDRLP4 96
ADDRGP4 cg+106800+36+12
INDIRF4
ADDRLP4 144+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 96+4
ADDRGP4 cg+106800+36+12+4
INDIRF4
ADDRLP4 144+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 96+8
ADDRGP4 cg+106800+36+12+8
INDIRF4
ADDRLP4 144+4
INDIRF4
MULF4
ASGNF4
line 1837
;1837:	VectorMA( right, -line[0], cg.refdef.viewaxis[2], right );
ADDRLP4 220
ADDRLP4 144
INDIRF4
NEGF4
ASGNF4
ADDRLP4 96
ADDRLP4 96
INDIRF4
ADDRGP4 cg+106800+36+24
INDIRF4
ADDRLP4 220
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96+4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg+106800+36+24+4
INDIRF4
ADDRLP4 220
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96+8
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg+106800+36+24+8
INDIRF4
ADDRLP4 144
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 1838
;1838:	VectorNormalize( right );
ADDRLP4 96
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1840
;1839:
;1840:	VectorMA( finish, cg_tracerWidth.value, right, verts[0].xyz );
ADDRLP4 0
ADDRLP4 132
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 132+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 132+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1841
;1841:	verts[0].st[0] = 0;
ADDRLP4 0+12
CNSTF4 0
ASGNF4
line 1842
;1842:	verts[0].st[1] = 1;
ADDRLP4 0+12+4
CNSTF4 1065353216
ASGNF4
line 1843
;1843:	verts[0].modulate[0] = 255;
ADDRLP4 0+20
CNSTU1 255
ASGNU1
line 1844
;1844:	verts[0].modulate[1] = 255;
ADDRLP4 0+20+1
CNSTU1 255
ASGNU1
line 1845
;1845:	verts[0].modulate[2] = 255;
ADDRLP4 0+20+2
CNSTU1 255
ASGNU1
line 1846
;1846:	verts[0].modulate[3] = 255;
ADDRLP4 0+20+3
CNSTU1 255
ASGNU1
line 1848
;1847:
;1848:	VectorMA( finish, -cg_tracerWidth.value, right, verts[1].xyz );
ADDRLP4 0+24
ADDRLP4 132
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+24+4
ADDRLP4 132+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+24+8
ADDRLP4 132+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 1849
;1849:	verts[1].st[0] = 1;
ADDRLP4 0+24+12
CNSTF4 1065353216
ASGNF4
line 1850
;1850:	verts[1].st[1] = 0;
ADDRLP4 0+24+12+4
CNSTF4 0
ASGNF4
line 1851
;1851:	verts[1].modulate[0] = 255;
ADDRLP4 0+24+20
CNSTU1 255
ASGNU1
line 1852
;1852:	verts[1].modulate[1] = 255;
ADDRLP4 0+24+20+1
CNSTU1 255
ASGNU1
line 1853
;1853:	verts[1].modulate[2] = 255;
ADDRLP4 0+24+20+2
CNSTU1 255
ASGNU1
line 1854
;1854:	verts[1].modulate[3] = 255;
ADDRLP4 0+24+20+3
CNSTU1 255
ASGNU1
line 1856
;1855:
;1856:	VectorMA( start, -cg_tracerWidth.value, right, verts[2].xyz );
ADDRLP4 0+48
ADDRLP4 120
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+48+4
ADDRLP4 120+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+48+8
ADDRLP4 120+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 1857
;1857:	verts[2].st[0] = 1;
ADDRLP4 0+48+12
CNSTF4 1065353216
ASGNF4
line 1858
;1858:	verts[2].st[1] = 1;
ADDRLP4 0+48+12+4
CNSTF4 1065353216
ASGNF4
line 1859
;1859:	verts[2].modulate[0] = 255;
ADDRLP4 0+48+20
CNSTU1 255
ASGNU1
line 1860
;1860:	verts[2].modulate[1] = 255;
ADDRLP4 0+48+20+1
CNSTU1 255
ASGNU1
line 1861
;1861:	verts[2].modulate[2] = 255;
ADDRLP4 0+48+20+2
CNSTU1 255
ASGNU1
line 1862
;1862:	verts[2].modulate[3] = 255;
ADDRLP4 0+48+20+3
CNSTU1 255
ASGNU1
line 1864
;1863:
;1864:	VectorMA( start, cg_tracerWidth.value, right, verts[3].xyz );
ADDRLP4 0+72
ADDRLP4 120
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+72+4
ADDRLP4 120+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+72+8
ADDRLP4 120+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1865
;1865:	verts[3].st[0] = 0;
ADDRLP4 0+72+12
CNSTF4 0
ASGNF4
line 1866
;1866:	verts[3].st[1] = 0;
ADDRLP4 0+72+12+4
CNSTF4 0
ASGNF4
line 1867
;1867:	verts[3].modulate[0] = 255;
ADDRLP4 0+72+20
CNSTU1 255
ASGNU1
line 1868
;1868:	verts[3].modulate[1] = 255;
ADDRLP4 0+72+20+1
CNSTU1 255
ASGNU1
line 1869
;1869:	verts[3].modulate[2] = 255;
ADDRLP4 0+72+20+2
CNSTU1 255
ASGNU1
line 1870
;1870:	verts[3].modulate[3] = 255;
ADDRLP4 0+72+20+3
CNSTU1 255
ASGNU1
line 1872
;1871:
;1872:	trap_R_AddPolyToScene( cgs.media.tracerShader, 4, verts );
ADDRGP4 cgs+170516+148
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
line 1874
;1873:
;1874:	midpoint[0] = ( start[0] + finish[0] ) * 0.5;
ADDRLP4 168
CNSTF4 1056964608
ADDRLP4 120
INDIRF4
ADDRLP4 132
INDIRF4
ADDF4
MULF4
ASGNF4
line 1875
;1875:	midpoint[1] = ( start[1] + finish[1] ) * 0.5;
ADDRLP4 168+4
CNSTF4 1056964608
ADDRLP4 120+4
INDIRF4
ADDRLP4 132+4
INDIRF4
ADDF4
MULF4
ASGNF4
line 1876
;1876:	midpoint[2] = ( start[2] + finish[2] ) * 0.5;
ADDRLP4 168+8
CNSTF4 1056964608
ADDRLP4 120+8
INDIRF4
ADDRLP4 132+8
INDIRF4
ADDF4
MULF4
ASGNF4
line 1879
;1877:
;1878:	// add the tracer sound
;1879:	trap_S_StartSound( midpoint, ENTITYNUM_WORLD, CHAN_AUTO, cgs.media.tracerSound );
ADDRLP4 168
ARGP4
CNSTI4 1022
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+444
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1881
;1880:
;1881:}
LABELV $1205
endproc CG_Tracer 224 16
proc CG_CalcMuzzlePoint 20 0
line 1889
;1882:
;1883:
;1884:/*
;1885:======================
;1886:CG_CalcMuzzlePoint
;1887:======================
;1888:*/
;1889:static qboolean	CG_CalcMuzzlePoint( int entityNum, vec3_t muzzle ) {
line 1894
;1890:	vec3_t		forward;
;1891:	centity_t	*cent;
;1892:	int			anim;
;1893:	// ## Hentai ##
;1894:	cent = &cg_entities[entityNum];
ADDRLP4 0
CNSTI4 680
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 1899
;1895:	//if ( !cent->currentValid ) {
;1896://		CG_Printf("ent %d not valid\n", entityNum);
;1897:	//	return qfalse;
;1898:	//}
;1899:	VectorCopy(cent->lerpOrigin, muzzle);
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRB
ASGNB 12
line 1927
;1900:	//VectorCopy(cent->pe.railgunOrigin, muzzle);
;1901:	/*
;1902:	if ( entityNum == cg.snap->ps.clientNum ) {
;1903:		VectorCopy( cg.snap->ps.origin, muzzle );
;1904:		muzzle[2] += cg.snap->ps.viewheight;
;1905:		AngleVectors( cg.snap->ps.viewangles, forward, NULL, NULL );
;1906:		VectorMA( muzzle, 14, forward, muzzle );
;1907:		return qtrue;
;1908:	}
;1909:
;1910:	cent = &cg_entities[entityNum];	
;1911:	if ( !cent->currentValid ) {
;1912:		return qfalse;
;1913:	}
;1914:
;1915:	VectorCopy( cent->currentState.pos.trBase, muzzle );
;1916:
;1917:	AngleVectors( cent->currentState.apos.trBase, forward, NULL, NULL );
;1918:	anim = cent->currentState.legsAnim & ~ANIM_TOGGLEBIT;
;1919:	if ( anim == LEGS_WALKCR || anim == LEGS_IDLECR ) {
;1920:		muzzle[2] += CROUCH_VIEWHEIGHT;
;1921:	} else {
;1922:		muzzle[2] += DEFAULT_VIEWHEIGHT;
;1923:	}
;1924:
;1925:	VectorMA( muzzle, 14, forward, muzzle );
;1926:	*/
;1927:	return qtrue;
CNSTI4 1
RETI4
LABELV $1392
endproc CG_CalcMuzzlePoint 20 0
export CG_Bullet
proc CG_Bullet 80 28
line 1938
;1928:
;1929:}
;1930:
;1931:/*
;1932:======================
;1933:CG_Bullet
;1934:
;1935:Renders bullet effects.
;1936:======================
;1937:*/
;1938:void CG_Bullet( vec3_t start, vec3_t end, int sourceEntityNum, vec3_t normal, qboolean flesh, int fleshEntityNum ) {
line 1945
;1939:	trace_t trace;
;1940:	int sourceContentType, destContentType;
;1941:	//vec3_t		start;
;1942:
;1943:	// if the shooter is currently valid, calc a source point and possibly
;1944:	// do trail effects
;1945:	if ( sourceEntityNum >= 0 && cg_tracerChance.value > 0 ) {
ADDRFP4 8
INDIRI4
CNSTI4 0
LTI4 $1394
ADDRGP4 cg_tracerChance+8
INDIRF4
CNSTF4 0
LEF4 $1394
line 1947
;1946:		//if ( CG_CalcMuzzlePoint( sourceEntityNum, start ) ) {
;1947:			sourceContentType = trap_CM_PointContents( start, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 64
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 64
INDIRI4
ASGNI4
line 1948
;1948:			destContentType = trap_CM_PointContents( end, 0 );
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 68
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 68
INDIRI4
ASGNI4
line 1951
;1949:
;1950:			// do a complete bubble trail if necessary
;1951:			if ( ( sourceContentType == destContentType ) && ( sourceContentType & CONTENTS_WATER ) ) {
ADDRLP4 72
ADDRLP4 0
INDIRI4
ASGNI4
ADDRLP4 72
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $1397
ADDRLP4 72
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1397
line 1952
;1952:				CG_BubbleTrail( start, end, 32 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
CNSTF4 1107296256
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 1953
;1953:			}
ADDRGP4 $1398
JUMPV
LABELV $1397
line 1955
;1954:			// bubble trail from water into air
;1955:			else if ( ( sourceContentType & CONTENTS_WATER ) ) {
ADDRLP4 0
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1399
line 1956
;1956:				trap_CM_BoxTrace( &trace, end, start, NULL, NULL, 0, CONTENTS_WATER );
ADDRLP4 8
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 76
CNSTP4 0
ASGNP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 32
ARGI4
ADDRGP4 trap_CM_BoxTrace
CALLV
pop
line 1957
;1957:				CG_BubbleTrail( start, trace.endpos, 32 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8+12
ARGP4
CNSTF4 1107296256
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 1958
;1958:			}
ADDRGP4 $1400
JUMPV
LABELV $1399
line 1960
;1959:			// bubble trail from air into water
;1960:			else if ( ( destContentType & CONTENTS_WATER ) ) {
ADDRLP4 4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1402
line 1961
;1961:				trap_CM_BoxTrace( &trace, start, end, NULL, NULL, 0, CONTENTS_WATER );
ADDRLP4 8
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 76
CNSTP4 0
ASGNP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 32
ARGI4
ADDRGP4 trap_CM_BoxTrace
CALLV
pop
line 1962
;1962:				CG_BubbleTrail( end, trace.endpos, 32 );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 8+12
ARGP4
CNSTF4 1107296256
ARGF4
ADDRGP4 CG_BubbleTrail
CALLV
pop
line 1963
;1963:			}
LABELV $1402
LABELV $1400
LABELV $1398
line 1966
;1964:
;1965:			// draw a tracer
;1966:			if ( 1 ) {//random() < cg_tracerChance.value ) {
line 1967
;1967:				CG_Tracer( start, end );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 CG_Tracer
CALLV
pop
line 1968
;1968:			}
LABELV $1405
line 1970
;1969:		//}
;1970:	}
LABELV $1394
line 1974
;1971:
;1972:	// impact splash and mark
;1973:	
;1974:	if(flesh == -1)
ADDRFP4 16
INDIRI4
CNSTI4 -1
NEI4 $1407
line 1975
;1975:	{
line 1976
;1976:		CG_RBleed( end, fleshEntityNum );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 20
INDIRI4
ARGI4
ADDRGP4 CG_RBleed
CALLI4
pop
line 1977
;1977:	}
ADDRGP4 $1408
JUMPV
LABELV $1407
line 1978
;1978:	else if ( flesh ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $1409
line 1979
;1979:		CG_Bleed( end, fleshEntityNum );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 20
INDIRI4
ARGI4
ADDRGP4 CG_Bleed
CALLV
pop
line 1980
;1980:	} else {
ADDRGP4 $1410
JUMPV
LABELV $1409
line 1981
;1981:		CG_MissileHitWall( WP_MACHINEGUN, 0, end, normal );
CNSTI4 2
ARGI4
CNSTI4 0
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 CG_MissileHitWall
CALLV
pop
line 1982
;1982:	}
LABELV $1410
LABELV $1408
line 1984
;1983:
;1984:}
LABELV $1393
endproc CG_Bullet 80 28
import CG_RBleed
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $976
byte 1 67
byte 1 71
byte 1 95
byte 1 70
byte 1 105
byte 1 114
byte 1 101
byte 1 87
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 58
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 45
byte 1 62
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 32
byte 1 62
byte 1 61
byte 1 32
byte 1 87
byte 1 80
byte 1 95
byte 1 78
byte 1 85
byte 1 77
byte 1 95
byte 1 87
byte 1 69
byte 1 65
byte 1 80
byte 1 79
byte 1 78
byte 1 83
byte 1 0
align 1
LABELV $877
byte 1 68
byte 1 114
byte 1 111
byte 1 112
byte 1 112
byte 1 101
byte 1 100
byte 1 58
byte 1 32
byte 1 0
align 1
LABELV $678
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 102
byte 1 108
byte 1 97
byte 1 115
byte 1 104
byte 1 0
align 1
LABELV $648
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $633
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $396
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 104
byte 1 105
byte 1 116
byte 1 115
byte 1 47
byte 1 98
byte 1 102
byte 1 103
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $395
byte 1 98
byte 1 102
byte 1 103
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $392
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 98
byte 1 102
byte 1 103
byte 1 47
byte 1 98
byte 1 102
byte 1 103
byte 1 95
byte 1 102
byte 1 105
byte 1 114
byte 1 101
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $391
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 98
byte 1 102
byte 1 103
byte 1 47
byte 1 98
byte 1 102
byte 1 103
byte 1 95
byte 1 104
byte 1 117
byte 1 109
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $389
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 67
byte 1 111
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $386
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 68
byte 1 105
byte 1 115
byte 1 99
byte 1 0
align 1
LABELV $383
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $380
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 103
byte 1 102
byte 1 49
byte 1 97
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $379
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 114
byte 1 103
byte 1 95
byte 1 104
byte 1 117
byte 1 109
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $377
byte 1 112
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $374
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 47
byte 1 104
byte 1 121
byte 1 112
byte 1 114
byte 1 98
byte 1 102
byte 1 49
byte 1 97
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $373
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 47
byte 1 108
byte 1 97
byte 1 115
byte 1 102
byte 1 108
byte 1 121
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $371
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $368
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 47
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 108
byte 1 102
byte 1 49
byte 1 97
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $367
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 97
byte 1 109
byte 1 109
byte 1 111
byte 1 47
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $365
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $362
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 108
byte 1 102
byte 1 49
byte 1 97
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $361
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 102
byte 1 108
byte 1 121
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $359
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 115
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 102
byte 1 49
byte 1 98
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $357
byte 1 98
byte 1 117
byte 1 108
byte 1 108
byte 1 101
byte 1 116
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $354
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 103
byte 1 102
byte 1 52
byte 1 98
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $353
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 103
byte 1 102
byte 1 51
byte 1 98
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $352
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 103
byte 1 102
byte 1 50
byte 1 98
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $351
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 103
byte 1 102
byte 1 49
byte 1 98
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $349
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 97
byte 1 109
byte 1 109
byte 1 111
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $347
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 47
byte 1 108
byte 1 103
byte 1 95
byte 1 104
byte 1 105
byte 1 116
byte 1 51
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $344
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 47
byte 1 108
byte 1 103
byte 1 95
byte 1 104
byte 1 105
byte 1 116
byte 1 50
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $341
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 47
byte 1 108
byte 1 103
byte 1 95
byte 1 104
byte 1 105
byte 1 116
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $338
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 104
byte 1 105
byte 1 116
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 99
byte 1 107
byte 1 108
byte 1 101
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $335
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 66
byte 1 111
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $332
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 47
byte 1 108
byte 1 103
byte 1 95
byte 1 102
byte 1 105
byte 1 114
byte 1 101
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $331
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 47
byte 1 108
byte 1 103
byte 1 95
byte 1 104
byte 1 117
byte 1 109
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $330
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 108
byte 1 101
byte 1 101
byte 1 47
byte 1 102
byte 1 115
byte 1 116
byte 1 104
byte 1 117
byte 1 109
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $328
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 108
byte 1 101
byte 1 101
byte 1 47
byte 1 102
byte 1 115
byte 1 116
byte 1 97
byte 1 116
byte 1 99
byte 1 107
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $327
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 108
byte 1 101
byte 1 101
byte 1 47
byte 1 102
byte 1 115
byte 1 116
byte 1 114
byte 1 117
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $323
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 50
byte 1 47
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 103
byte 1 117
byte 1 110
byte 1 47
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 103
byte 1 117
byte 1 110
byte 1 95
byte 1 104
byte 1 97
byte 1 110
byte 1 100
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $320
byte 1 95
byte 1 104
byte 1 97
byte 1 110
byte 1 100
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $319
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $314
byte 1 95
byte 1 102
byte 1 108
byte 1 97
byte 1 115
byte 1 104
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $300
byte 1 67
byte 1 111
byte 1 117
byte 1 108
byte 1 100
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 102
byte 1 105
byte 1 110
byte 1 100
byte 1 32
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $198
byte 1 69
byte 1 114
byte 1 114
byte 1 111
byte 1 114
byte 1 58
byte 1 32
byte 1 122
byte 1 101
byte 1 114
byte 1 111
byte 1 32
byte 1 114
byte 1 95
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 83
byte 1 101
byte 1 103
byte 1 109
byte 1 101
byte 1 110
byte 1 116
byte 1 76
byte 1 101
byte 1 110
byte 1 103
byte 1 116
byte 1 104
byte 1 10
byte 1 0
