export CG_TestModel_f
code
proc CG_TestModel_f 36 12
file "..\cg_view.c"
line 51
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_view.c -- setup all the parameters (position, angle, etc)
;4:// for a 3D rendering
;5:#include "cg_local.h"
;6:
;7:
;8:/*
;9:=============================================================================
;10:
;11:  MODEL TESTING
;12:
;13:The viewthing and gun positioning tools from Q2 have been integrated and
;14:enhanced into a single model testing facility.
;15:
;16:Model viewing can begin with either "testmodel <modelname>" or "testgun <modelname>".
;17:
;18:The names must be the full pathname after the basedir, like 
;19:"models/weapons/v_launch/tris.md3" or "players/male/tris.md3"
;20:
;21:Testmodel will create a fake entity 100 units in front of the current view
;22:position, directly facing the viewer.  It will remain immobile, so you can
;23:move around it to view it from different angles.
;24:
;25:Testgun will cause the model to follow the player around and supress the real
;26:view weapon model.  The default frame 0 of most guns is completely off screen,
;27:so you will probably have to cycle a couple frames to see it.
;28:
;29:"nextframe", "prevframe", "nextskin", and "prevskin" commands will change the
;30:frame or skin of the testmodel.  These are bound to F5, F6, F7, and F8 in
;31:q3default.cfg.
;32:
;33:If a gun is being tested, the "gun_x", "gun_y", and "gun_z" variables will let
;34:you adjust the positioning.
;35:
;36:Note that none of the model testing features update while the game is paused, so
;37:it may be convenient to test with deathmatch set to 1 so that bringing down the
;38:console doesn't pause the game.
;39:
;40:=============================================================================
;41:*/
;42:
;43:/*
;44:=================
;45:CG_TestModel_f
;46:
;47:Creates an entity in front of the current position, which
;48:can then be moved around
;49:=================
;50:*/
;51:void CG_TestModel_f (void) {
line 54
;52:	vec3_t		angles;
;53:
;54:	memset( &cg.testModelEntity, 0, sizeof(cg.testModelEntity) );
ADDRGP4 cg+112036
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 55
;55:	if ( trap_Argc() < 2 ) {
ADDRLP4 12
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 2
GEI4 $63
line 56
;56:		return;
ADDRGP4 $60
JUMPV
LABELV $63
line 59
;57:	}
;58:
;59:	Q_strncpyz (cg.testModelName, CG_Argv( 1 ), MAX_QPATH );
CNSTI4 1
ARGI4
ADDRLP4 16
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRGP4 cg+112176
ARGP4
ADDRLP4 16
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 60
;60:	cg.testModelEntity.hModel = trap_R_RegisterModel( cg.testModelName );
ADDRGP4 cg+112176
ARGP4
ADDRLP4 20
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 cg+112036+8
ADDRLP4 20
INDIRI4
ASGNI4
line 62
;61:
;62:	if ( trap_Argc() == 3 ) {
ADDRLP4 24
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 3
NEI4 $69
line 63
;63:		cg.testModelEntity.backlerp = atof( CG_Argv( 2 ) );
CNSTI4 2
ARGI4
ADDRLP4 28
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 atof
CALLF4
ASGNF4
ADDRGP4 cg+112036+100
ADDRLP4 32
INDIRF4
ASGNF4
line 64
;64:		cg.testModelEntity.frame = 1;
ADDRGP4 cg+112036+80
CNSTI4 1
ASGNI4
line 65
;65:		cg.testModelEntity.oldframe = 0;
ADDRGP4 cg+112036+96
CNSTI4 0
ASGNI4
line 66
;66:	}
LABELV $69
line 67
;67:	if (! cg.testModelEntity.hModel ) {
ADDRGP4 cg+112036+8
INDIRI4
CNSTI4 0
NEI4 $77
line 68
;68:		CG_Printf( "Can't register model\n" );
ADDRGP4 $81
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 69
;69:		return;
ADDRGP4 $60
JUMPV
LABELV $77
line 72
;70:	}
;71:
;72:	VectorMA( cg.refdef.vieworg, 100, cg.refdef.viewaxis[0], cg.testModelEntity.origin );
ADDRGP4 cg+112036+68
ADDRGP4 cg+106800+24
INDIRF4
CNSTF4 1120403456
ADDRGP4 cg+106800+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+112036+68+4
ADDRGP4 cg+106800+24+4
INDIRF4
CNSTF4 1120403456
ADDRGP4 cg+106800+36+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+112036+68+8
ADDRGP4 cg+106800+24+8
INDIRF4
CNSTF4 1120403456
ADDRGP4 cg+106800+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 74
;73:
;74:	angles[PITCH] = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 75
;75:	angles[YAW] = 180 + cg.refdefViewAngles[1];
ADDRLP4 0+4
ADDRGP4 cg+107168+4
INDIRF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 76
;76:	angles[ROLL] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 78
;77:
;78:	AnglesToAxis( angles, cg.testModelEntity.axis );
ADDRLP4 0
ARGP4
ADDRGP4 cg+112036+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 79
;79:	cg.testGun = qfalse;
ADDRGP4 cg+112240
CNSTI4 0
ASGNI4
line 80
;80:}
LABELV $60
endproc CG_TestModel_f 36 12
export CG_TestGun_f
proc CG_TestGun_f 0 0
line 89
;81:
;82:/*
;83:=================
;84:CG_TestGun_f
;85:
;86:Replaces the current view weapon with the given model
;87:=================
;88:*/
;89:void CG_TestGun_f (void) {
line 90
;90:	CG_TestModel_f();
ADDRGP4 CG_TestModel_f
CALLV
pop
line 91
;91:	cg.testGun = qtrue;
ADDRGP4 cg+112240
CNSTI4 1
ASGNI4
line 92
;92:	cg.testModelEntity.renderfx = RF_MINLIGHT | RF_DEPTHHACK | RF_FIRST_PERSON;
ADDRGP4 cg+112036+4
CNSTI4 13
ASGNI4
line 93
;93:}
LABELV $113
endproc CG_TestGun_f 0 0
export CG_TestModelNextFrame_f
proc CG_TestModelNextFrame_f 4 8
line 96
;94:
;95:
;96:void CG_TestModelNextFrame_f (void) {
line 97
;97:	cg.testModelEntity.frame++;
ADDRLP4 0
ADDRGP4 cg+112036+80
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 98
;98:	CG_Printf( "frame %i\n", cg.testModelEntity.frame );
ADDRGP4 $120
ARGP4
ADDRGP4 cg+112036+80
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 99
;99:}
LABELV $117
endproc CG_TestModelNextFrame_f 4 8
export CG_TestModelPrevFrame_f
proc CG_TestModelPrevFrame_f 4 8
line 101
;100:
;101:void CG_TestModelPrevFrame_f (void) {
line 102
;102:	cg.testModelEntity.frame--;
ADDRLP4 0
ADDRGP4 cg+112036+80
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 103
;103:	if ( cg.testModelEntity.frame < 0 ) {
ADDRGP4 cg+112036+80
INDIRI4
CNSTI4 0
GEI4 $126
line 104
;104:		cg.testModelEntity.frame = 0;
ADDRGP4 cg+112036+80
CNSTI4 0
ASGNI4
line 105
;105:	}
LABELV $126
line 106
;106:	CG_Printf( "frame %i\n", cg.testModelEntity.frame );
ADDRGP4 $120
ARGP4
ADDRGP4 cg+112036+80
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 107
;107:}
LABELV $123
endproc CG_TestModelPrevFrame_f 4 8
export CG_TestModelNextSkin_f
proc CG_TestModelNextSkin_f 4 8
line 109
;108:
;109:void CG_TestModelNextSkin_f (void) {
line 110
;110:	cg.testModelEntity.skinNum++;
ADDRLP4 0
ADDRGP4 cg+112036+104
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 111
;111:	CG_Printf( "skin %i\n", cg.testModelEntity.skinNum );
ADDRGP4 $137
ARGP4
ADDRGP4 cg+112036+104
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 112
;112:}
LABELV $134
endproc CG_TestModelNextSkin_f 4 8
export CG_TestModelPrevSkin_f
proc CG_TestModelPrevSkin_f 4 8
line 114
;113:
;114:void CG_TestModelPrevSkin_f (void) {
line 115
;115:	cg.testModelEntity.skinNum--;
ADDRLP4 0
ADDRGP4 cg+112036+104
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 116
;116:	if ( cg.testModelEntity.skinNum < 0 ) {
ADDRGP4 cg+112036+104
INDIRI4
CNSTI4 0
GEI4 $143
line 117
;117:		cg.testModelEntity.skinNum = 0;
ADDRGP4 cg+112036+104
CNSTI4 0
ASGNI4
line 118
;118:	}
LABELV $143
line 119
;119:	CG_Printf( "skin %i\n", cg.testModelEntity.skinNum );
ADDRGP4 $137
ARGP4
ADDRGP4 cg+112036+104
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 120
;120:}
LABELV $140
endproc CG_TestModelPrevSkin_f 4 8
proc CG_AddTestModel 32 4
line 122
;121:
;122:static void CG_AddTestModel (void) {
line 126
;123:	int		i;
;124:
;125:	// re-register the model, because the level may have changed
;126:	cg.testModelEntity.hModel = trap_R_RegisterModel( cg.testModelName );
ADDRGP4 cg+112176
ARGP4
ADDRLP4 4
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 cg+112036+8
ADDRLP4 4
INDIRI4
ASGNI4
line 127
;127:	if (! cg.testModelEntity.hModel ) {
ADDRGP4 cg+112036+8
INDIRI4
CNSTI4 0
NEI4 $155
line 128
;128:		CG_Printf ("Can't register model\n");
ADDRGP4 $81
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 129
;129:		return;
ADDRGP4 $151
JUMPV
LABELV $155
line 133
;130:	}
;131:
;132:	// if testing a gun, set the origin reletive to the view origin
;133:	if ( cg.testGun ) {
ADDRGP4 cg+112240
INDIRI4
CNSTI4 0
EQI4 $159
line 134
;134:		VectorCopy( cg.refdef.vieworg, cg.testModelEntity.origin );
ADDRGP4 cg+112036+68
ADDRGP4 cg+106800+24
INDIRB
ASGNB 12
line 135
;135:		VectorCopy( cg.refdef.viewaxis[0], cg.testModelEntity.axis[0] );
ADDRGP4 cg+112036+28
ADDRGP4 cg+106800+36
INDIRB
ASGNB 12
line 136
;136:		VectorCopy( cg.refdef.viewaxis[1], cg.testModelEntity.axis[1] );
ADDRGP4 cg+112036+28+12
ADDRGP4 cg+106800+36+12
INDIRB
ASGNB 12
line 137
;137:		VectorCopy( cg.refdef.viewaxis[2], cg.testModelEntity.axis[2] );
ADDRGP4 cg+112036+28+24
ADDRGP4 cg+106800+36+24
INDIRB
ASGNB 12
line 140
;138:
;139:		// allow the position to be adjusted
;140:		for (i=0 ; i<3 ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $182
line 141
;141:			cg.testModelEntity.origin[i] += cg.refdef.viewaxis[0][i] * cg_gun_x.value;
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 12
ADDRLP4 8
INDIRI4
ADDRGP4 cg+112036+68
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRLP4 8
INDIRI4
ADDRGP4 cg+106800+36
ADDP4
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 142
;142:			cg.testModelEntity.origin[i] += cg.refdef.viewaxis[1][i] * cg_gun_y.value;
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 20
ADDRLP4 16
INDIRI4
ADDRGP4 cg+112036+68
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ADDRLP4 16
INDIRI4
ADDRGP4 cg+106800+36+12
ADDP4
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 143
;143:			cg.testModelEntity.origin[i] += cg.refdef.viewaxis[2][i] * cg_gun_z.value;
ADDRLP4 24
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 28
ADDRLP4 24
INDIRI4
ADDRGP4 cg+112036+68
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 24
INDIRI4
ADDRGP4 cg+106800+36+24
ADDP4
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 144
;144:		}
LABELV $183
line 140
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $182
line 145
;145:	}
LABELV $159
line 147
;146:
;147:	trap_R_AddRefEntityToScene( &cg.testModelEntity );
ADDRGP4 cg+112036
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 148
;148:}
LABELV $151
endproc CG_AddTestModel 32 4
proc CG_CalcVrect 12 8
line 162
;149:
;150:
;151:
;152://============================================================================
;153:
;154:
;155:/*
;156:=================
;157:CG_CalcVrect
;158:
;159:Sets the coordinates of the rendered window
;160:=================
;161:*/
;162:static void CG_CalcVrect (void) {
line 166
;163:	int		size;
;164:
;165:	// the intermission should allways be full screen
;166:	if ( cg.snap->ps.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 5
NEI4 $205
line 167
;167:		size = 100;
ADDRLP4 0
CNSTI4 100
ASGNI4
line 168
;168:	} else {
ADDRGP4 $206
JUMPV
LABELV $205
line 170
;169:		// bound normal viewsize
;170:		if (cg_viewsize.integer < 30) {
ADDRGP4 cg_viewsize+12
INDIRI4
CNSTI4 30
GEI4 $208
line 171
;171:			trap_Cvar_Set ("cg_viewsize","30");
ADDRGP4 $211
ARGP4
ADDRGP4 $212
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 172
;172:			size = 30;
ADDRLP4 0
CNSTI4 30
ASGNI4
line 173
;173:		} else if (cg_viewsize.integer > 100) {
ADDRGP4 $209
JUMPV
LABELV $208
ADDRGP4 cg_viewsize+12
INDIRI4
CNSTI4 100
LEI4 $213
line 174
;174:			trap_Cvar_Set ("cg_viewsize","100");
ADDRGP4 $211
ARGP4
ADDRGP4 $216
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 175
;175:			size = 100;
ADDRLP4 0
CNSTI4 100
ASGNI4
line 176
;176:		} else {
ADDRGP4 $214
JUMPV
LABELV $213
line 177
;177:			size = cg_viewsize.integer;
ADDRLP4 0
ADDRGP4 cg_viewsize+12
INDIRI4
ASGNI4
line 178
;178:		}
LABELV $214
LABELV $209
line 180
;179:
;180:	}
LABELV $206
line 181
;181:	cg.refdef.width = cgs.glconfig.vidWidth*size/100;
ADDRGP4 cg+106800+8
ADDRGP4 cgs+20100+4136
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 100
DIVI4
ASGNI4
line 182
;182:	cg.refdef.width &= ~1;
ADDRLP4 4
ADDRGP4 cg+106800+8
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 184
;183:
;184:	cg.refdef.height = cgs.glconfig.vidHeight*size/100;
ADDRGP4 cg+106800+12
ADDRGP4 cgs+20100+4140
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 100
DIVI4
ASGNI4
line 185
;185:	cg.refdef.height &= ~1;
ADDRLP4 8
ADDRGP4 cg+106800+12
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 187
;186:
;187:	cg.refdef.x = (cgs.glconfig.vidWidth - cg.refdef.width)/2;
ADDRGP4 cg+106800
ADDRGP4 cgs+20100+4136
INDIRI4
ADDRGP4 cg+106800+8
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 188
;188:	cg.refdef.y = (cgs.glconfig.vidHeight - cg.refdef.height)/2;
ADDRGP4 cg+106800+4
ADDRGP4 cgs+20100+4140
INDIRI4
ADDRGP4 cg+106800+12
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 189
;189:}
LABELV $204
endproc CG_CalcVrect 12 8
data
align 4
LABELV $242
byte 4 3229614080
byte 4 3229614080
byte 4 3229614080
align 4
LABELV $243
byte 4 1082130432
byte 4 1082130432
byte 4 1082130432
code
proc CG_OffsetThirdPersonView 188 28
line 201
;190:
;191://==============================================================================
;192:
;193:
;194:/*
;195:===============
;196:CG_OffsetThirdPersonView
;197:
;198:===============
;199:*/
;200:#define	FOCUS_DISTANCE	512
;201:static void CG_OffsetThirdPersonView( void ) {
line 212
;202:	vec3_t		forward, right, up;
;203:	vec3_t		view;
;204:	vec3_t		focusAngles;
;205:	trace_t		trace;
;206:	static vec3_t	mins = { -4, -4, -4 };
;207:	static vec3_t	maxs = { 4, 4, 4 };
;208:	vec3_t		focusPoint;
;209:	float		focusDist;
;210:	float		forwardScale, sideScale;
;211:
;212:	cg.refdef.vieworg[2] += cg.predictedPlayerState.viewheight;
ADDRLP4 140
ADDRGP4 cg+106800+24+8
ASGNP4
ADDRLP4 140
INDIRP4
ADDRLP4 140
INDIRP4
INDIRF4
ADDRGP4 cg+105532+164
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 214
;213:
;214:	VectorCopy( cg.refdefViewAngles, focusAngles );
ADDRLP4 48
ADDRGP4 cg+107168
INDIRB
ASGNB 12
line 217
;215:
;216:	// if dead, look at killer
;217:	if ( cg.predictedPlayerState.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+105532+184
INDIRI4
CNSTI4 0
GTI4 $250
line 218
;218:		focusAngles[YAW] = cg.predictedPlayerState.stats[STAT_DEAD_YAW];
ADDRLP4 48+4
ADDRGP4 cg+105532+184+16
INDIRI4
CVIF4 4
ASGNF4
line 219
;219:		cg.refdefViewAngles[YAW] = cg.predictedPlayerState.stats[STAT_DEAD_YAW];
ADDRGP4 cg+107168+4
ADDRGP4 cg+105532+184+16
INDIRI4
CVIF4 4
ASGNF4
line 220
;220:	}
LABELV $250
line 222
;221:
;222:	if ( focusAngles[PITCH] > 45 ) {
ADDRLP4 48
INDIRF4
CNSTF4 1110704128
LEF4 $263
line 223
;223:		focusAngles[PITCH] = 45;		// don't go too far overhead
ADDRLP4 48
CNSTF4 1110704128
ASGNF4
line 224
;224:	}
LABELV $263
line 225
;225:	AngleVectors( focusAngles, forward, NULL, NULL );
ADDRLP4 48
ARGP4
ADDRLP4 24
ARGP4
ADDRLP4 144
CNSTP4 0
ASGNP4
ADDRLP4 144
INDIRP4
ARGP4
ADDRLP4 144
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 227
;226:
;227:	VectorMA( cg.refdef.vieworg, FOCUS_DISTANCE, forward, focusPoint );
ADDRLP4 148
CNSTF4 1140850688
ASGNF4
ADDRLP4 12
ADDRGP4 cg+106800+24
INDIRF4
ADDRLP4 148
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12+4
ADDRGP4 cg+106800+24+4
INDIRF4
ADDRLP4 148
INDIRF4
ADDRLP4 24+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 12+8
ADDRGP4 cg+106800+24+8
INDIRF4
CNSTF4 1140850688
ADDRLP4 24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 229
;228:
;229:	VectorCopy( cg.refdef.vieworg, view );
ADDRLP4 0
ADDRGP4 cg+106800+24
INDIRB
ASGNB 12
line 231
;230:
;231:	view[2] += 8;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 233
;232:
;233:	cg.refdefViewAngles[PITCH] *= 0.5;
ADDRLP4 152
ADDRGP4 cg+107168
ASGNP4
ADDRLP4 152
INDIRP4
CNSTF4 1056964608
ADDRLP4 152
INDIRP4
INDIRF4
MULF4
ASGNF4
line 235
;234:
;235:	AngleVectors( cg.refdefViewAngles, forward, right, up );
ADDRGP4 cg+107168
ARGP4
ADDRLP4 24
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 128
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 237
;236:
;237:	forwardScale = cos( cg_thirdPersonAngle.value / 180 * M_PI );
CNSTF4 1078530011
ADDRGP4 cg_thirdPersonAngle+8
INDIRF4
CNSTF4 1127481344
DIVF4
MULF4
ARGF4
ADDRLP4 156
ADDRGP4 cos
CALLF4
ASGNF4
ADDRLP4 116
ADDRLP4 156
INDIRF4
ASGNF4
line 238
;238:	sideScale = sin( cg_thirdPersonAngle.value / 180 * M_PI );
CNSTF4 1078530011
ADDRGP4 cg_thirdPersonAngle+8
INDIRF4
CNSTF4 1127481344
DIVF4
MULF4
ARGF4
ADDRLP4 160
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 120
ADDRLP4 160
INDIRF4
ASGNF4
line 239
;239:	VectorMA( view, -cg_thirdPersonRange.value * forwardScale, forward, view );
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 24
INDIRF4
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
NEGF4
ADDRLP4 116
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 24+4
INDIRF4
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
NEGF4
ADDRLP4 116
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 24+8
INDIRF4
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
NEGF4
ADDRLP4 116
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 240
;240:	VectorMA( view, -cg_thirdPersonRange.value * sideScale, right, view );
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 36
INDIRF4
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
NEGF4
ADDRLP4 120
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 36+4
INDIRF4
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
NEGF4
ADDRLP4 120
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 36+8
INDIRF4
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
NEGF4
ADDRLP4 120
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 245
;241:
;242:	// trace a ray from the origin to the viewpoint to make sure the view isn't
;243:	// in a solid block.  Use an 8 by 8 block to prevent the view from near clipping anything
;244:
;245:	CG_Trace( &trace, cg.refdef.vieworg, mins, maxs, view, cg.predictedPlayerState.clientNum, MASK_SOLID );
ADDRLP4 60
ARGP4
ADDRGP4 cg+106800+24
ARGP4
ADDRGP4 $242
ARGP4
ADDRGP4 $243
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cg+105532+140
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 247
;246:
;247:	if ( trace.fraction != 1.0 ) {
ADDRLP4 60+8
INDIRF4
CNSTF4 1065353216
EQF4 $306
line 248
;248:		VectorCopy( trace.endpos, view );
ADDRLP4 0
ADDRLP4 60+12
INDIRB
ASGNB 12
line 249
;249:		view[2] += (1.0 - trace.fraction) * 32;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1107296256
CNSTF4 1065353216
ADDRLP4 60+8
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 253
;250:		// try another trace to this position, because a tunnel may have the ceiling
;251:		// close enogh that this is poking out
;252:
;253:		CG_Trace( &trace, cg.refdef.vieworg, mins, maxs, view, cg.predictedPlayerState.clientNum, MASK_SOLID );
ADDRLP4 60
ARGP4
ADDRGP4 cg+106800+24
ARGP4
ADDRGP4 $242
ARGP4
ADDRGP4 $243
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cg+105532+140
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 254
;254:		VectorCopy( trace.endpos, view );
ADDRLP4 0
ADDRLP4 60+12
INDIRB
ASGNB 12
line 255
;255:	}
LABELV $306
line 258
;256:
;257:
;258:	VectorCopy( view, cg.refdef.vieworg );
ADDRGP4 cg+106800+24
ADDRLP4 0
INDIRB
ASGNB 12
line 261
;259:
;260:	// select pitch to look at focus point from vieword
;261:	VectorSubtract( focusPoint, cg.refdef.vieworg, focusPoint );
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRGP4 cg+106800+24
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRGP4 cg+106800+24+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+8
ADDRLP4 12+8
INDIRF4
ADDRGP4 cg+106800+24+8
INDIRF4
SUBF4
ASGNF4
line 262
;262:	focusDist = sqrt( focusPoint[0] * focusPoint[0] + focusPoint[1] * focusPoint[1] );
ADDRLP4 172
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 172
INDIRF4
ADDRLP4 172
INDIRF4
MULF4
ADDRLP4 12+4
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ARGF4
ADDRLP4 176
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 124
ADDRLP4 176
INDIRF4
ASGNF4
line 263
;263:	if ( focusDist < 1 ) {
ADDRLP4 124
INDIRF4
CNSTF4 1065353216
GEF4 $333
line 264
;264:		focusDist = 1;	// should never happen
ADDRLP4 124
CNSTF4 1065353216
ASGNF4
line 265
;265:	}
LABELV $333
line 266
;266:	cg.refdefViewAngles[PITCH] = -180 / M_PI * atan2( focusPoint[2], focusDist );
ADDRLP4 12+8
INDIRF4
ARGF4
ADDRLP4 124
INDIRF4
ARGF4
ADDRLP4 180
ADDRGP4 atan2
CALLF4
ASGNF4
ADDRGP4 cg+107168
CNSTF4 3261411041
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
line 267
;267:	cg.refdefViewAngles[YAW] -= cg_thirdPersonAngle.value;
ADDRLP4 184
ADDRGP4 cg+107168+4
ASGNP4
ADDRLP4 184
INDIRP4
ADDRLP4 184
INDIRP4
INDIRF4
ADDRGP4 cg_thirdPersonAngle+8
INDIRF4
SUBF4
ASGNF4
line 268
;268:}
LABELV $241
endproc CG_OffsetThirdPersonView 188 28
proc CG_StepOffset 8 0
line 272
;269:
;270:
;271:// this causes a compiler bug on mac MrC compiler
;272:static void CG_StepOffset( void ) {
line 276
;273:	int		timeDelta;
;274:	
;275:	// smooth out stair climbing
;276:	timeDelta = cg.time - cg.stepTime;
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106680
INDIRI4
SUBI4
ASGNI4
line 277
;277:	if ( timeDelta < STEP_TIME ) {
ADDRLP4 0
INDIRI4
CNSTI4 200
GEI4 $343
line 278
;278:		cg.refdef.vieworg[2] -= cg.stepChange 
ADDRLP4 4
ADDRGP4 cg+106800+24+8
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cg+106676
INDIRF4
CNSTI4 200
ADDRLP4 0
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1128792064
DIVF4
SUBF4
ASGNF4
line 280
;279:			* (STEP_TIME - timeDelta) / STEP_TIME;
;280:	}
LABELV $343
line 281
;281:}
LABELV $340
endproc CG_StepOffset 8 0
proc CG_OffsetFirstPersonView 100 4
line 291
;282:
;283:/*
;284:===============
;285:CG_OffsetFirstPersonView
;286:
;287:===============
;288:*/
;289:
;290:void CG_Player3rd( centity_t *cent ) ;
;291:static void CG_OffsetFirstPersonView( void ) {
line 302
;292:	float			*origin;
;293:	float			*angles;
;294:	float			bob;
;295:	float			ratio;
;296:	float			delta;
;297:	float			speed;
;298:	float			f;
;299:	vec3_t			predictedVelocity;
;300:	int				timeDelta;
;301:	
;302:	if ( cg.snap->ps.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 5
NEI4 $350
line 303
;303:		return;
ADDRGP4 $349
JUMPV
LABELV $350
line 306
;304:	}
;305:
;306:	origin = cg.refdef.vieworg;
ADDRLP4 8
ADDRGP4 cg+106800+24
ASGNP4
line 307
;307:	angles = cg.refdefViewAngles;
ADDRLP4 4
ADDRGP4 cg+107168
ASGNP4
line 310
;308:
;309:	// if dead, fix the angle and don't add any kick
;310:	if ( cg.snap->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
GTI4 $356
line 311
;311:		angles[ROLL] = 40;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTF4 1109393408
ASGNF4
line 312
;312:		angles[PITCH] = -15;
ADDRLP4 4
INDIRP4
CNSTF4 3245342720
ASGNF4
line 313
;313:		angles[YAW] = cg.snap->ps.stats[STAT_DEAD_YAW];
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 244
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 314
;314:		origin[2] += cg.predictedPlayerState.viewheight;
ADDRLP4 44
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRGP4 cg+105532+164
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 315
;315:		return;
ADDRGP4 $349
JUMPV
LABELV $356
line 319
;316:	}
;317:
;318:	// add angles based on weapon kick
;319:	VectorAdd (angles, cg.kick_angles, angles);
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cg+112000
INDIRF4
ADDF4
ASGNF4
ADDRLP4 48
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRGP4 cg+112000+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 52
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRGP4 cg+112000+8
INDIRF4
ADDF4
ASGNF4
line 322
;320:
;321:	// add angles based on damage kick
;322:	if ( cg.damageTime ) {
ADDRGP4 cg+111944
INDIRF4
CNSTF4 0
EQF4 $367
line 323
;323:		ratio = cg.time - cg.damageTime;
ADDRLP4 32
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg+111944
INDIRF4
SUBF4
ASGNF4
line 324
;324:		if ( ratio < DAMAGE_DEFLECT_TIME ) {
ADDRLP4 32
INDIRF4
CNSTF4 1120403456
GEF4 $372
line 325
;325:			ratio /= DAMAGE_DEFLECT_TIME;
ADDRLP4 32
ADDRLP4 32
INDIRF4
CNSTF4 1120403456
DIVF4
ASGNF4
line 326
;326:			angles[PITCH] += ratio * cg.v_dmg_pitch;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+111992
INDIRF4
MULF4
ADDF4
ASGNF4
line 327
;327:			angles[ROLL] += ratio * cg.v_dmg_roll;
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+111996
INDIRF4
MULF4
ADDF4
ASGNF4
line 328
;328:		} else {
ADDRGP4 $373
JUMPV
LABELV $372
line 329
;329:			ratio = 1.0 - ( ratio - DAMAGE_DEFLECT_TIME ) / DAMAGE_RETURN_TIME;
ADDRLP4 32
CNSTF4 1065353216
ADDRLP4 32
INDIRF4
CNSTF4 1120403456
SUBF4
CNSTF4 1137180672
DIVF4
SUBF4
ASGNF4
line 330
;330:			if ( ratio > 0 ) {
ADDRLP4 32
INDIRF4
CNSTF4 0
LEF4 $376
line 331
;331:				angles[PITCH] += ratio * cg.v_dmg_pitch;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+111992
INDIRF4
MULF4
ADDF4
ASGNF4
line 332
;332:				angles[ROLL] += ratio * cg.v_dmg_roll;
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+111996
INDIRF4
MULF4
ADDF4
ASGNF4
line 333
;333:			}
LABELV $376
line 334
;334:		}
LABELV $373
line 335
;335:	}
LABELV $367
line 346
;336:
;337:	// add pitch based on fall kick
;338:#if 0
;339:	ratio = ( cg.time - cg.landTime) / FALL_TIME;
;340:	if (ratio < 0)
;341:		ratio = 0;
;342:	angles[PITCH] += ratio * cg.fall_value;
;343:#endif
;344:
;345:	// add angles based on velocity
;346:	VectorCopy( cg.predictedPlayerState.velocity, predictedVelocity );
ADDRLP4 12
ADDRGP4 cg+105532+32
INDIRB
ASGNB 12
line 348
;347:
;348:	delta = DotProduct ( predictedVelocity, cg.refdef.viewaxis[0]);
ADDRLP4 0
ADDRLP4 12
INDIRF4
ADDRGP4 cg+106800+36
INDIRF4
MULF4
ADDRLP4 12+4
INDIRF4
ADDRGP4 cg+106800+36+4
INDIRF4
MULF4
ADDF4
ADDRLP4 12+8
INDIRF4
ADDRGP4 cg+106800+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 349
;349:	angles[PITCH] += delta * cg_runpitch.value;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDRGP4 cg_runpitch+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 351
;350:	
;351:	delta = DotProduct ( predictedVelocity, cg.refdef.viewaxis[1]);
ADDRLP4 0
ADDRLP4 12
INDIRF4
ADDRGP4 cg+106800+36+12
INDIRF4
MULF4
ADDRLP4 12+4
INDIRF4
ADDRGP4 cg+106800+36+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 12+8
INDIRF4
ADDRGP4 cg+106800+36+12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 352
;352:	angles[ROLL] -= delta * cg_runroll.value;
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDRGP4 cg_runroll+8
INDIRF4
MULF4
SUBF4
ASGNF4
line 357
;353:
;354:	// add angles based on bob
;355:
;356:	// make sure the bob is visible even at low speeds
;357:	speed = cg.xyspeed > 200 ? cg.xyspeed : 200;
ADDRGP4 cg+112032
INDIRF4
CNSTF4 1128792064
LEF4 $410
ADDRLP4 64
ADDRGP4 cg+112032
INDIRF4
ASGNF4
ADDRGP4 $411
JUMPV
LABELV $410
ADDRLP4 64
CNSTF4 1128792064
ASGNF4
LABELV $411
ADDRLP4 28
ADDRLP4 64
INDIRF4
ASGNF4
line 359
;358:
;359:	delta = cg.bobfracsin * cg_bobpitch.value * speed;
ADDRLP4 0
ADDRGP4 cg+112024
INDIRF4
ADDRGP4 cg_bobpitch+8
INDIRF4
MULF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 360
;360:	if (cg.predictedPlayerState.pm_flags & PMF_DUCKED)
ADDRGP4 cg+105532+12
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $414
line 361
;361:		delta *= 3;		// crouching
ADDRLP4 0
CNSTF4 1077936128
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
LABELV $414
line 362
;362:	angles[PITCH] += delta;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
line 363
;363:	delta = cg.bobfracsin * cg_bobroll.value * speed;
ADDRLP4 0
ADDRGP4 cg+112024
INDIRF4
ADDRGP4 cg_bobroll+8
INDIRF4
MULF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 364
;364:	if (cg.predictedPlayerState.pm_flags & PMF_DUCKED)
ADDRGP4 cg+105532+12
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $420
line 365
;365:		delta *= 3;		// crouching accentuates roll
ADDRLP4 0
CNSTF4 1077936128
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
LABELV $420
line 366
;366:	if (cg.bobcycle & 1)
ADDRGP4 cg+112028
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $424
line 367
;367:		delta = -delta;
ADDRLP4 0
ADDRLP4 0
INDIRF4
NEGF4
ASGNF4
LABELV $424
line 368
;368:	angles[ROLL] += delta;
ADDRLP4 72
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
line 373
;369:
;370://===================================
;371:
;372:	// add view height
;373:	origin[2] += cg.predictedPlayerState.viewheight;
ADDRLP4 76
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
ADDRGP4 cg+105532+164
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 376
;374:
;375:	// smooth out duck height changes
;376:	timeDelta = cg.time - cg.duckTime;
ADDRLP4 36
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106688
INDIRI4
SUBI4
ASGNI4
line 377
;377:	if ( timeDelta < DUCK_TIME) {
ADDRLP4 36
INDIRI4
CNSTI4 100
GEI4 $431
line 378
;378:		cg.refdef.vieworg[2] -= cg.duckChange 
ADDRLP4 80
ADDRGP4 cg+106800+24+8
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRGP4 cg+106684
INDIRF4
CNSTI4 100
ADDRLP4 36
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1120403456
DIVF4
SUBF4
ASGNF4
line 380
;379:			* (DUCK_TIME - timeDelta) / DUCK_TIME;
;380:	}
LABELV $431
line 383
;381:
;382:	// add bob height
;383:	bob = cg.bobfracsin * cg.xyspeed * cg_bobup.value;
ADDRLP4 24
ADDRGP4 cg+112024
INDIRF4
ADDRGP4 cg+112032
INDIRF4
MULF4
ADDRGP4 cg_bobup+8
INDIRF4
MULF4
ASGNF4
line 384
;384:	if (bob > 6) {
ADDRLP4 24
INDIRF4
CNSTF4 1086324736
LEF4 $440
line 385
;385:		bob = 6;
ADDRLP4 24
CNSTF4 1086324736
ASGNF4
line 386
;386:	}
LABELV $440
line 388
;387:
;388:	origin[2] += bob;
ADDRLP4 80
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
ADDF4
ASGNF4
line 392
;389:
;390:
;391:	// add fall height
;392:	delta = cg.time - cg.landTime;
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106696
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 393
;393:	if ( delta < LAND_DEFLECT_TIME ) {
ADDRLP4 0
INDIRF4
CNSTF4 1125515264
GEF4 $444
line 394
;394:		f = delta / LAND_DEFLECT_TIME;
ADDRLP4 40
ADDRLP4 0
INDIRF4
CNSTF4 1125515264
DIVF4
ASGNF4
line 395
;395:		cg.refdef.vieworg[2] += cg.landChange * f;
ADDRLP4 84
ADDRGP4 cg+106800+24+8
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRGP4 cg+106692
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDF4
ASGNF4
line 396
;396:	} else if ( delta < LAND_DEFLECT_TIME + LAND_RETURN_TIME ) {
ADDRGP4 $445
JUMPV
LABELV $444
ADDRLP4 0
INDIRF4
CNSTF4 1138819072
GEF4 $450
line 397
;397:		delta -= LAND_DEFLECT_TIME;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1125515264
SUBF4
ASGNF4
line 398
;398:		f = 1.0 - ( delta / LAND_RETURN_TIME );
ADDRLP4 40
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
CNSTF4 1133903872
DIVF4
SUBF4
ASGNF4
line 399
;399:		cg.refdef.vieworg[2] += cg.landChange * f;
ADDRLP4 84
ADDRGP4 cg+106800+24+8
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRGP4 cg+106692
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDF4
ASGNF4
line 400
;400:	}
LABELV $450
LABELV $445
line 403
;401:
;402:	// add step offset
;403:	CG_StepOffset();
ADDRGP4 CG_StepOffset
CALLV
pop
line 407
;404:
;405:	// add kick offset
;406:
;407:	VectorAdd (origin, cg.kick_origin, origin);
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRGP4 cg+112012
INDIRF4
ADDF4
ASGNF4
ADDRLP4 88
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRGP4 cg+112012+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 92
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRF4
ADDRGP4 cg+112012+8
INDIRF4
ADDF4
ASGNF4
line 412
;408:
;409:	// pivot the eye based on a neck length
;410:	// ## Hentai ## - I can do this better!
;411:
;412:	if(cg_thirdPerson.integer == -1) // render first person with body
ADDRGP4 cg_thirdPerson+12
INDIRI4
CNSTI4 -1
NEI4 $461
line 413
;413:	{ // put the view origin at the center of the head ;)
line 414
;414:		clientInfo_t *ci = &cgs.clientinfo[cg.snap->ps.clientNum];
ADDRLP4 96
CNSTI4 1076
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 415
;415:		if(cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR)
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
NEI4 $466
line 416
;416:		{
line 418
;417:			//VectorCopy(ci->CurrentEntity->lerpOrigin, origin);
;418:		}
ADDRGP4 $467
JUMPV
LABELV $466
line 419
;419:		else if(ci->CurrentEntity)
ADDRLP4 96
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $469
line 420
;420:		{
line 421
;421:			CG_Player3rd(ci->CurrentEntity);		
ADDRLP4 96
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRGP4 CG_Player3rd
CALLV
pop
line 422
;422:			VectorCopy(ci->viewpoint, origin);
ADDRLP4 8
INDIRP4
ADDRLP4 96
INDIRP4
CNSTI4 396
ADDP4
INDIRB
ASGNB 12
line 423
;423:		}		
LABELV $469
LABELV $467
line 424
;424:	}
LABELV $461
line 426
;425:	// ## Hentai ##
;426:}
LABELV $349
endproc CG_OffsetFirstPersonView 100 4
export CG_ZoomDown_f
proc CG_ZoomDown_f 0 0
line 430
;427:
;428://======================================================================
;429:
;430:void CG_ZoomDown_f( void ) { 
line 431
;431:	if ( cg.zoomed ) {
ADDRGP4 cg+107180
INDIRI4
CNSTI4 0
EQI4 $472
line 432
;432:		return;
ADDRGP4 $471
JUMPV
LABELV $472
line 434
;433:	}
;434:	cg.zoomed = qtrue;
ADDRGP4 cg+107180
CNSTI4 1
ASGNI4
line 435
;435:	cg.zoomTime = cg.time;
ADDRGP4 cg+107184
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 436
;436:}
LABELV $471
endproc CG_ZoomDown_f 0 0
export CG_ZoomUp_f
proc CG_ZoomUp_f 0 0
line 438
;437:
;438:void CG_ZoomUp_f( void ) { 
line 439
;439:	if ( !cg.zoomed ) {
ADDRGP4 cg+107180
INDIRI4
CNSTI4 0
NEI4 $479
line 440
;440:		return;
ADDRGP4 $478
JUMPV
LABELV $479
line 442
;441:	}
;442:	cg.zoomed = qfalse;
ADDRGP4 cg+107180
CNSTI4 0
ASGNI4
line 443
;443:	cg.zoomTime = cg.time;
ADDRGP4 cg+107184
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 444
;444:}
LABELV $478
endproc CG_ZoomUp_f 0 0
proc CG_CalcFov 52 8
line 457
;445:
;446:
;447:/*
;448:====================
;449:CG_CalcFov
;450:
;451:Fixed fov at intermissions, otherwise account for fov variable and zooms.
;452:====================
;453:*/
;454:#define	WAVE_AMPLITUDE	1	//## Hentai ## - was 1
;455:#define	WAVE_FREQUENCY	0.8
;456:
;457:static int CG_CalcFov( void ) {
line 467
;458:	float	x;
;459:	float	phase;
;460:	float	v;
;461:	int		contents;
;462:	float	fov_x, fov_y;
;463:	float	zoomFov;
;464:	float	f;
;465:	int		inwater;
;466:
;467:	if ( cg.predictedPlayerState.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+105532+4
INDIRI4
CNSTI4 5
NEI4 $486
line 469
;468:		// if in intermission, use a fixed value
;469:		fov_x = 90;
ADDRLP4 0
CNSTF4 1119092736
ASGNF4
line 470
;470:	} else {
ADDRGP4 $487
JUMPV
LABELV $486
line 472
;471:		// user selectable
;472:		if ( cgs.dmflags & DF_FIXED_FOV ) {
ADDRGP4 cgs+24292
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $490
line 474
;473:			// dmflag to prevent wide fov for all clients
;474:			fov_x = 90;
ADDRLP4 0
CNSTF4 1119092736
ASGNF4
line 475
;475:		} else {
ADDRGP4 $491
JUMPV
LABELV $490
line 476
;476:			fov_x = cg_fov.value;
ADDRLP4 0
ADDRGP4 cg_fov+8
INDIRF4
ASGNF4
line 477
;477:			if ( fov_x < 1 ) {
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
GEF4 $494
line 478
;478:				fov_x = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 479
;479:			} else if ( fov_x > 160 ) {
ADDRGP4 $495
JUMPV
LABELV $494
ADDRLP4 0
INDIRF4
CNSTF4 1126170624
LEF4 $496
line 480
;480:				fov_x = 160;
ADDRLP4 0
CNSTF4 1126170624
ASGNF4
line 481
;481:			}
LABELV $496
LABELV $495
line 482
;482:		}
LABELV $491
line 485
;483:
;484:		// account for zooms
;485:		zoomFov = cg_zoomFov.value;
ADDRLP4 8
ADDRGP4 cg_zoomFov+8
INDIRF4
ASGNF4
line 486
;486:		if ( zoomFov < 1 ) {
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
GEF4 $499
line 487
;487:			zoomFov = 1;
ADDRLP4 8
CNSTF4 1065353216
ASGNF4
line 488
;488:		} else if ( zoomFov > 160 ) {
ADDRGP4 $500
JUMPV
LABELV $499
ADDRLP4 8
INDIRF4
CNSTF4 1126170624
LEF4 $501
line 489
;489:			zoomFov = 160;
ADDRLP4 8
CNSTF4 1126170624
ASGNF4
line 490
;490:		}
LABELV $501
LABELV $500
line 492
;491:
;492:		if ( cg.zoomed ) {
ADDRGP4 cg+107180
INDIRI4
CNSTI4 0
EQI4 $503
line 493
;493:			f = ( cg.time - cg.zoomTime ) / (float)ZOOM_TIME;
ADDRLP4 28
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+107184
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1125515264
DIVF4
ASGNF4
line 494
;494:			if ( f > 1.0 ) {
ADDRLP4 28
INDIRF4
CNSTF4 1065353216
LEF4 $508
line 495
;495:				fov_x = zoomFov;
ADDRLP4 0
ADDRLP4 8
INDIRF4
ASGNF4
line 496
;496:			} else {
ADDRGP4 $504
JUMPV
LABELV $508
line 497
;497:				fov_x = fov_x + f * ( zoomFov - fov_x );
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 28
INDIRF4
ADDRLP4 8
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 498
;498:			}
line 499
;499:		} else {
ADDRGP4 $504
JUMPV
LABELV $503
line 500
;500:			f = ( cg.time - cg.zoomTime ) / (float)ZOOM_TIME;
ADDRLP4 28
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+107184
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1125515264
DIVF4
ASGNF4
line 501
;501:			if ( f > 1.0 ) {
ADDRLP4 28
INDIRF4
CNSTF4 1065353216
LEF4 $512
line 502
;502:				fov_x = fov_x;
ADDRLP4 0
ADDRLP4 0
INDIRF4
ASGNF4
line 503
;503:			} else {
ADDRGP4 $513
JUMPV
LABELV $512
line 504
;504:				fov_x = zoomFov + f * ( fov_x - zoomFov );
ADDRLP4 36
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 36
INDIRF4
ADDRLP4 28
INDIRF4
ADDRLP4 0
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 505
;505:			}
LABELV $513
line 506
;506:		}
LABELV $504
line 507
;507:	}
LABELV $487
line 509
;508:
;509:	x = cg.refdef.width / tan( fov_x / 360 * M_PI );
CNSTF4 1078530011
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
ARGF4
ADDRLP4 36
ADDRGP4 tan
CALLF4
ASGNF4
ADDRLP4 12
ADDRGP4 cg+106800+8
INDIRI4
CVIF4 4
ADDRLP4 36
INDIRF4
DIVF4
ASGNF4
line 510
;510:	fov_y = atan2( cg.refdef.height, x );
ADDRGP4 cg+106800+12
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 40
ADDRGP4 atan2
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 40
INDIRF4
ASGNF4
line 511
;511:	fov_y = fov_y * 360 / M_PI;
ADDRLP4 4
CNSTF4 1135869952
ADDRLP4 4
INDIRF4
MULF4
CNSTF4 1078530011
DIVF4
ASGNF4
line 514
;512:
;513:	// warp if underwater
;514:	contents = CG_PointContents( cg.refdef.vieworg, -1 );
ADDRGP4 cg+106800+24
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 44
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 44
INDIRI4
ASGNI4
line 515
;515:	if ( contents & ( CONTENTS_WATER | CONTENTS_SLIME | CONTENTS_LAVA ) ){
ADDRLP4 16
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $520
line 516
;516:		phase = cg.time / 1000.0 * WAVE_FREQUENCY * M_PI * 2;
ADDRLP4 32
CNSTF4 1073741824
CNSTF4 1078530011
CNSTF4 1061997773
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
MULF4
MULF4
MULF4
ASGNF4
line 517
;517:		v = WAVE_AMPLITUDE * sin( phase );
ADDRLP4 32
INDIRF4
ARGF4
ADDRLP4 48
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 24
CNSTF4 1065353216
ADDRLP4 48
INDIRF4
MULF4
ASGNF4
line 518
;518:		fov_x += v;
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 24
INDIRF4
ADDF4
ASGNF4
line 519
;519:		fov_y -= v;
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 24
INDIRF4
SUBF4
ASGNF4
line 520
;520:		inwater = qtrue;
ADDRLP4 20
CNSTI4 1
ASGNI4
line 521
;521:	}
ADDRGP4 $521
JUMPV
LABELV $520
line 522
;522:	else {
line 523
;523:		inwater = qfalse;
ADDRLP4 20
CNSTI4 0
ASGNI4
line 524
;524:	}
LABELV $521
line 528
;525:
;526:
;527:	// set it
;528:	cg.refdef.fov_x = fov_x;
ADDRGP4 cg+106800+16
ADDRLP4 0
INDIRF4
ASGNF4
line 529
;529:	cg.refdef.fov_y = fov_y;
ADDRGP4 cg+106800+20
ADDRLP4 4
INDIRF4
ASGNF4
line 531
;530:
;531:	if ( !cg.zoomed ) {
ADDRGP4 cg+107180
INDIRI4
CNSTI4 0
NEI4 $527
line 532
;532:		cg.zoomSensitivity = 1;
ADDRGP4 cg+107188
CNSTF4 1065353216
ASGNF4
line 533
;533:	} else {
ADDRGP4 $528
JUMPV
LABELV $527
line 534
;534:		cg.zoomSensitivity = cg.refdef.fov_y / 75.0;
ADDRGP4 cg+107188
ADDRGP4 cg+106800+20
INDIRF4
CNSTF4 1117126656
DIVF4
ASGNF4
line 535
;535:	}
LABELV $528
line 537
;536:
;537:	return inwater;
ADDRLP4 20
INDIRI4
RETI4
LABELV $485
endproc CG_CalcFov 52 8
proc CG_DamageBlendBlob 164 12
line 548
;538:}
;539:
;540:
;541:
;542:/*
;543:===============
;544:CG_DamageBlendBlob
;545:
;546:===============
;547:*/
;548:static void CG_DamageBlendBlob( void ) {
line 553
;549:	int			t;
;550:	int			maxTime;
;551:	refEntity_t		ent;
;552:
;553:	if ( !cg.damageValue ) {
ADDRGP4 cg+111956
INDIRF4
CNSTF4 0
NEF4 $535
line 554
;554:		return;
ADDRGP4 $534
JUMPV
LABELV $535
line 558
;555:	}
;556:
;557:	// ragePro systems can't fade blends, so don't obscure the screen
;558:	if ( cgs.glconfig.hardwareType == GLHW_RAGEPRO ) {
ADDRGP4 cgs+20100+4120
INDIRI4
CNSTI4 3
NEI4 $538
line 559
;559:		return;
ADDRGP4 $534
JUMPV
LABELV $538
line 562
;560:	}
;561:
;562:	maxTime = DAMAGE_TIME;
ADDRLP4 144
CNSTI4 500
ASGNI4
line 563
;563:	t = cg.time - cg.damageTime;
ADDRLP4 140
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg+111944
INDIRF4
SUBF4
CVFI4 4
ASGNI4
line 564
;564:	if ( t <= 0 || t >= maxTime ) {
ADDRLP4 140
INDIRI4
CNSTI4 0
LEI4 $546
ADDRLP4 140
INDIRI4
ADDRLP4 144
INDIRI4
LTI4 $544
LABELV $546
line 565
;565:		return;
ADDRGP4 $534
JUMPV
LABELV $544
line 569
;566:	}
;567:
;568:
;569:	memset( &ent, 0, sizeof( ent ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 570
;570:	ent.reType = RT_SPRITE;
ADDRLP4 0
CNSTI4 2
ASGNI4
line 571
;571:	ent.renderfx = RF_FIRST_PERSON;
ADDRLP4 0+4
CNSTI4 4
ASGNI4
line 573
;572:
;573:	VectorMA( cg.refdef.vieworg, 8, cg.refdef.viewaxis[0], ent.origin );
ADDRLP4 0+68
ADDRGP4 cg+106800+24
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+106800+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRGP4 cg+106800+24+4
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+106800+36+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRGP4 cg+106800+24+8
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+106800+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 574
;574:	VectorMA( ent.origin, cg.damageX * -8, cg.refdef.viewaxis[1], ent.origin );
ADDRLP4 0+68
ADDRLP4 0+68
INDIRF4
ADDRGP4 cg+106800+36+12
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+111948
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 0+68+4
INDIRF4
ADDRGP4 cg+106800+36+12+4
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+111948
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
ADDRGP4 cg+106800+36+12+8
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+111948
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 575
;575:	VectorMA( ent.origin, cg.damageY * 8, cg.refdef.viewaxis[2], ent.origin );
ADDRLP4 0+68
ADDRLP4 0+68
INDIRF4
ADDRGP4 cg+106800+36+24
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+111952
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+4
ADDRLP4 0+68+4
INDIRF4
ADDRGP4 cg+106800+36+24+4
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+111952
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+68+8
ADDRLP4 0+68+8
INDIRF4
ADDRGP4 cg+106800+36+24+8
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+111952
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 577
;576:
;577:	ent.radius = cg.damageValue * 3;
ADDRLP4 0+132
CNSTF4 1077936128
ADDRGP4 cg+111956
INDIRF4
MULF4
ASGNF4
line 578
;578:	ent.customShader = cgs.media.viewBloodShader;
ADDRLP4 0+112
ADDRGP4 cgs+170516+144
INDIRI4
ASGNI4
line 579
;579:	ent.shaderRGBA[0] = 255;
ADDRLP4 0+116
CNSTU1 255
ASGNU1
line 580
;580:	ent.shaderRGBA[1] = 255;
ADDRLP4 0+116+1
CNSTU1 255
ASGNU1
line 581
;581:	ent.shaderRGBA[2] = 255;
ADDRLP4 0+116+2
CNSTU1 255
ASGNU1
line 582
;582:	ent.shaderRGBA[3] = 200 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 156
CNSTF4 1128792064
CNSTF4 1065353216
ADDRLP4 140
INDIRI4
CVIF4 4
ADDRLP4 144
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 160
CNSTF4 1325400064
ASGNF4
ADDRLP4 156
INDIRF4
ADDRLP4 160
INDIRF4
LTF4 $630
ADDRLP4 152
ADDRLP4 156
INDIRF4
ADDRLP4 160
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $631
JUMPV
LABELV $630
ADDRLP4 152
ADDRLP4 156
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $631
ADDRLP4 0+116+3
ADDRLP4 152
INDIRU4
CVUU1 4
ASGNU1
line 583
;583:	trap_R_AddRefEntityToScene( &ent );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 584
;584:}
LABELV $534
endproc CG_DamageBlendBlob 164 12
proc CG_CalcViewValues 40 12
line 594
;585:
;586:
;587:/*
;588:===============
;589:CG_CalcViewValues
;590:
;591:Sets cg.refdef view values
;592:===============
;593:*/
;594:static int CG_CalcViewValues( void ) {
line 597
;595:	playerState_t	*ps;
;596:
;597:	memset( &cg.refdef, 0, sizeof( cg.refdef ) );
ADDRGP4 cg+106800
ARGP4
CNSTI4 0
ARGI4
CNSTU4 368
ARGU4
ADDRGP4 memset
CALLP4
pop
line 604
;598:
;599:	// strings for in game rendering
;600:	// Q_strncpyz( cg.refdef.text[0], "Park Ranger", sizeof(cg.refdef.text[0]) );
;601:	// Q_strncpyz( cg.refdef.text[1], "19", sizeof(cg.refdef.text[1]) );
;602:
;603:	// calculate size of 3D view
;604:	CG_CalcVrect();
ADDRGP4 CG_CalcVrect
CALLV
pop
line 606
;605:
;606:	ps = &cg.predictedPlayerState;
ADDRLP4 0
ADDRGP4 cg+105532
ASGNP4
line 609
;607:
;608:	// intermission view
;609:	if ( ps->pm_type == PM_INTERMISSION ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 5
NEI4 $636
line 610
;610:		VectorCopy( ps->origin, cg.refdef.vieworg );
ADDRGP4 cg+106800+24
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 611
;611:		VectorCopy( ps->viewangles, cg.refdefViewAngles );
ADDRGP4 cg+107168
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
INDIRB
ASGNB 12
line 612
;612:		AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
ADDRGP4 cg+107168
ARGP4
ADDRGP4 cg+106800+36
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 613
;613:		return CG_CalcFov();
ADDRLP4 4
ADDRGP4 CG_CalcFov
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $632
JUMPV
LABELV $636
line 616
;614:	}
;615:
;616:	cg.bobcycle = ( ps->bobCycle & 128 ) >> 7;
ADDRGP4 cg+112028
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 7
RSHI4
ASGNI4
line 617
;617:	cg.bobfracsin = fabs( sin( ( ps->bobCycle & 127 ) / 127.0 * M_PI ) );
CNSTF4 1078530011
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 127
BANDI4
CVIF4 4
CNSTF4 1123942400
DIVF4
MULF4
ARGF4
ADDRLP4 4
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 8
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRGP4 cg+112024
ADDRLP4 8
INDIRF4
ASGNF4
line 618
;618:	cg.xyspeed = sqrt( ps->velocity[0] * ps->velocity[0] +
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ASGNF4
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ASGNF4
ADDRLP4 16
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 20
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ARGF4
ADDRLP4 24
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRGP4 cg+112032
ADDRLP4 24
INDIRF4
ASGNF4
line 622
;619:		ps->velocity[1] * ps->velocity[1] );
;620:
;621:
;622:	VectorCopy( ps->origin, cg.refdef.vieworg );
ADDRGP4 cg+106800+24
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 623
;623:	VectorCopy( ps->viewangles, cg.refdefViewAngles );
ADDRGP4 cg+107168
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
INDIRB
ASGNB 12
line 626
;624:
;625:	// add error decay
;626:	if ( cg_errorDecay.value > 0 ) {
ADDRGP4 cg_errorDecay+8
INDIRF4
CNSTF4 0
LEF4 $650
line 630
;627:		int		t;
;628:		float	f;
;629:
;630:		t = cg.time - cg.predictedErrorTime;
ADDRLP4 32
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106660
INDIRI4
SUBI4
ASGNI4
line 631
;631:		f = ( cg_errorDecay.value - t ) / cg_errorDecay.value;
ADDRLP4 28
ADDRGP4 cg_errorDecay+8
INDIRF4
ADDRLP4 32
INDIRI4
CVIF4 4
SUBF4
ADDRGP4 cg_errorDecay+8
INDIRF4
DIVF4
ASGNF4
line 632
;632:		if ( f > 0 && f < 1 ) {
ADDRLP4 36
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 36
INDIRF4
CNSTF4 0
LEF4 $657
ADDRLP4 36
INDIRF4
CNSTF4 1065353216
GEF4 $657
line 633
;633:			VectorMA( cg.refdef.vieworg, f, cg.predictedError, cg.refdef.vieworg );
ADDRGP4 cg+106800+24
ADDRGP4 cg+106800+24
INDIRF4
ADDRGP4 cg+106664
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+106800+24+4
ADDRGP4 cg+106800+24+4
INDIRF4
ADDRGP4 cg+106664+4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+106800+24+8
ADDRGP4 cg+106800+24+8
INDIRF4
ADDRGP4 cg+106664+8
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ASGNF4
line 634
;634:		} else {
ADDRGP4 $658
JUMPV
LABELV $657
line 635
;635:			cg.predictedErrorTime = 0;
ADDRGP4 cg+106660
CNSTI4 0
ASGNI4
line 636
;636:		}
LABELV $658
line 637
;637:	}
LABELV $650
line 639
;638:
;639:	if ( cg.renderingThirdPerson ) {
ADDRGP4 cg+105524
INDIRI4
CNSTI4 0
EQI4 $681
line 641
;640:		// back away from character
;641:		CG_OffsetThirdPersonView();
ADDRGP4 CG_OffsetThirdPersonView
CALLV
pop
line 642
;642:	} else {
ADDRGP4 $682
JUMPV
LABELV $681
line 644
;643:		// offset for local bobbing and kicks
;644:		CG_OffsetFirstPersonView();
ADDRGP4 CG_OffsetFirstPersonView
CALLV
pop
line 645
;645:	}
LABELV $682
line 648
;646:
;647:	// position eye reletive to origin
;648:	AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
ADDRGP4 cg+107168
ARGP4
ADDRGP4 cg+106800+36
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 650
;649:
;650:	if ( cg.hyperspace ) {
ADDRGP4 cg+105528
INDIRI4
CNSTI4 0
EQI4 $687
line 651
;651:		cg.refdef.rdflags |= RDF_NOWORLDMODEL | RDF_HYPERSPACE;
ADDRLP4 28
ADDRGP4 cg+106800+76
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 5
BORI4
ASGNI4
line 652
;652:	}
LABELV $687
line 655
;653:
;654:	// field of view
;655:	return CG_CalcFov();
ADDRLP4 28
ADDRGP4 CG_CalcFov
CALLI4
ASGNI4
ADDRLP4 28
INDIRI4
RETI4
LABELV $632
endproc CG_CalcViewValues 40 12
proc CG_PowerupTimerSounds 16 16
line 664
;656:}
;657:
;658:
;659:/*
;660:=====================
;661:CG_PowerupTimerSounds
;662:=====================
;663:*/
;664:static void CG_PowerupTimerSounds( void ) {
line 669
;665:	int		i;
;666:	int		t;
;667:
;668:	// powerup timers going away
;669:	for ( i = 0 ; i < MAX_POWERUPS ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $693
line 670
;670:		t = cg.snap->ps.powerups[i];
ADDRLP4 0
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 356
ADDP4
ADDP4
INDIRI4
ASGNI4
line 671
;671:		if ( t <= cg.time ) {
ADDRLP4 0
INDIRI4
ADDRGP4 cg+105504
INDIRI4
GTI4 $698
line 672
;672:			continue;
ADDRGP4 $694
JUMPV
LABELV $698
line 674
;673:		}
;674:		if ( t - cg.time >= POWERUP_BLINKS * POWERUP_BLINK_TIME ) {
ADDRLP4 0
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CNSTI4 5000
LTI4 $701
line 675
;675:			continue;
ADDRGP4 $694
JUMPV
LABELV $701
line 677
;676:		}
;677:		if ( ( t - cg.time ) / POWERUP_BLINK_TIME != ( t - cg.oldTime ) / POWERUP_BLINK_TIME ) {
ADDRLP4 12
CNSTI4 1000
ASGNI4
ADDRLP4 0
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
ADDRLP4 12
INDIRI4
DIVI4
ADDRLP4 0
INDIRI4
ADDRGP4 cg+105508
INDIRI4
SUBI4
ADDRLP4 12
INDIRI4
DIVI4
EQI4 $704
line 678
;678:			trap_S_StartSound( NULL, cg.snap->ps.clientNum, CHAN_ITEM, cgs.media.wearOffSound );
CNSTP4 0
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRGP4 cgs+170516+456
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 679
;679:		}
LABELV $704
line 680
;680:	}
LABELV $694
line 669
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 16
LTI4 $693
line 681
;681:}
LABELV $692
endproc CG_PowerupTimerSounds 16 16
export CG_DrawActiveFrame
proc CG_DrawActiveFrame 16 16
line 692
;682:
;683://=========================================================================
;684:
;685:/*
;686:=================
;687:CG_DrawActiveFrame
;688:
;689:Generates and draws a game scene and status information at the given time.
;690:=================
;691:*/
;692:void CG_DrawActiveFrame( int serverTime, stereoFrame_t stereoView, qboolean demoPlayback ) {
line 695
;693:	int		inwater;
;694:
;695:	cg.time = serverTime;
ADDRGP4 cg+105504
ADDRFP4 0
INDIRI4
ASGNI4
line 696
;696:	cg.demoPlayback = demoPlayback;
ADDRGP4 cg+4
ADDRFP4 8
INDIRI4
ASGNI4
line 699
;697:
;698:	// update cvars
;699:	CG_UpdateCvars();
ADDRGP4 CG_UpdateCvars
CALLV
pop
line 703
;700:
;701:	// if we are only updating the screen as a loading
;702:	// pacifier, don't even try to read snapshots
;703:	if ( cg.infoScreenText[0] != 0 ) {
ADDRGP4 cg+107192
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $714
line 704
;704:		CG_DrawInformation();
ADDRGP4 CG_DrawInformation
CALLV
pop
line 705
;705:		return;
ADDRGP4 $711
JUMPV
LABELV $714
line 710
;706:	}
;707:
;708:	// any looped sounds will be respecified as entities
;709:	// are added to the render list
;710:	trap_S_ClearLoopingSounds();
ADDRGP4 trap_S_ClearLoopingSounds
CALLV
pop
line 713
;711:
;712:	// clear all the render lists
;713:	trap_R_ClearScene();
ADDRGP4 trap_R_ClearScene
CALLV
pop
line 716
;714:
;715:	// set up cg.snap and possibly cg.nextSnap
;716:	CG_ProcessSnapshots();
ADDRGP4 CG_ProcessSnapshots
CALLV
pop
line 720
;717:
;718:	// if we haven't received any snapshots yet, all
;719:	// we can draw is the information screen
;720:	if ( !cg.snap || ( cg.snap->snapFlags & SNAPFLAG_NOT_ACTIVE ) ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $721
ADDRGP4 cg+32
INDIRP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $717
LABELV $721
line 721
;721:		CG_DrawInformation();
ADDRGP4 CG_DrawInformation
CALLV
pop
line 722
;722:		return;
ADDRGP4 $711
JUMPV
LABELV $717
line 726
;723:	}
;724:
;725:	// let the client system know what our weapon and zoom settings are
;726:	trap_SetUserCmdValue( cg.weaponSelect, cg.zoomSensitivity );
ADDRGP4 cg+106700
INDIRI4
ARGI4
ADDRGP4 cg+107188
INDIRF4
ARGF4
ADDRGP4 trap_SetUserCmdValue
CALLV
pop
line 729
;727:
;728:	// this counter will be bumped for every valid scene we generate
;729:	cg.clientFrame++;
ADDRLP4 4
ADDRGP4 cg
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 732
;730:
;731:	// update cg.predictedPlayerState
;732:	CG_PredictPlayerState();
ADDRGP4 CG_PredictPlayerState
CALLV
pop
line 735
;733:
;734:	// decide on third person view
;735:	cg.renderingThirdPerson = (cg_thirdPerson.integer == 1) || (cg.snap->ps.stats[STAT_HEALTH] <= 0);
ADDRGP4 cg_thirdPerson+12
INDIRI4
CNSTI4 1
EQI4 $730
ADDRGP4 cg+32
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
GTI4 $728
LABELV $730
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRGP4 $729
JUMPV
LABELV $728
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $729
ADDRGP4 cg+105524
ADDRLP4 8
INDIRI4
ASGNI4
line 738
;736:
;737:	// build cg.refdef
;738:	inwater = CG_CalcViewValues();
ADDRLP4 12
ADDRGP4 CG_CalcViewValues
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ASGNI4
line 741
;739:
;740:	// first person blend blobs, done after AnglesToAxis
;741:	if ( !cg.renderingThirdPerson ) {
ADDRGP4 cg+105524
INDIRI4
CNSTI4 0
NEI4 $731
line 742
;742:		CG_DamageBlendBlob();
ADDRGP4 CG_DamageBlendBlob
CALLV
pop
line 743
;743:	}
LABELV $731
line 746
;744:
;745:	// build the render lists
;746:	if ( !cg.hyperspace ) {
ADDRGP4 cg+105528
INDIRI4
CNSTI4 0
NEI4 $734
line 747
;747:		CG_AddPacketEntities();			// adter calcViewValues, so predicted player state is correct
ADDRGP4 CG_AddPacketEntities
CALLV
pop
line 748
;748:		CG_AddMarks();
ADDRGP4 CG_AddMarks
CALLV
pop
line 749
;749:		CG_AddLocalEntities();
ADDRGP4 CG_AddLocalEntities
CALLV
pop
line 750
;750:	}
LABELV $734
line 751
;751:	if(cg.predictedPlayerState.weapon <= WP_GAUNTLET && cg.predictedPlayerState.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS && cg.predictedPlayerState.stats[STAT_WEAPONS] >= (1 << WP_MACHINEGUN))
ADDRGP4 cg+105532+144
INDIRI4
CNSTI4 1
GTI4 $737
ADDRGP4 cg+105532+184+28
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $737
ADDRGP4 cg+105532+184+8
INDIRI4
CNSTI4 4
LTI4 $737
line 752
;752:	{
line 753
;753:	}
LABELV $737
line 754
;754:	CG_AddViewWeapon( &cg.predictedPlayerState );
ADDRGP4 cg+105532
ARGP4
ADDRGP4 CG_AddViewWeapon
CALLV
pop
line 757
;755:
;756:	// finish up the rest of the refdef
;757:	if ( cg.testModelEntity.hModel ) {
ADDRGP4 cg+112036+8
INDIRI4
CNSTI4 0
EQI4 $748
line 758
;758:		CG_AddTestModel();
ADDRGP4 CG_AddTestModel
CALLV
pop
line 759
;759:	}
LABELV $748
line 760
;760:	cg.refdef.time = cg.time;
ADDRGP4 cg+106800+72
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 761
;761:	memcpy( cg.refdef.areamask, cg.snap->areamask, sizeof( cg.refdef.areamask ) );
ADDRGP4 cg+106800+80
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 12
ADDP4
ARGP4
CNSTU4 32
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 764
;762:
;763:	// update audio positions
;764:	trap_S_Respatialize( cg.snap->ps.clientNum, cg.refdef.vieworg, cg.refdef.viewaxis, inwater );
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 cg+106800+24
ARGP4
ADDRGP4 cg+106800+36
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 trap_S_Respatialize
CALLV
pop
line 767
;765:
;766:	// warning sounds when powerup is wearing off
;767:	CG_PowerupTimerSounds();
ADDRGP4 CG_PowerupTimerSounds
CALLV
pop
line 770
;768:
;769:	// make sure the lagometerSample and frame timing isn't done twice when in stereo
;770:	if ( stereoView != STEREO_RIGHT ) {
ADDRFP4 4
INDIRI4
CNSTI4 2
EQI4 $765
line 771
;771:		cg.frametime = cg.time - cg.oldTime;
ADDRGP4 cg+105500
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+105508
INDIRI4
SUBI4
ASGNI4
line 772
;772:		if ( cg.frametime < 0 ) {
ADDRGP4 cg+105500
INDIRI4
CNSTI4 0
GEI4 $770
line 773
;773:			cg.frametime = 0;
ADDRGP4 cg+105500
CNSTI4 0
ASGNI4
line 774
;774:		}
LABELV $770
line 775
;775:		cg.oldTime = cg.time;
ADDRGP4 cg+105508
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 776
;776:		CG_AddLagometerFrameInfo();
ADDRGP4 CG_AddLagometerFrameInfo
CALLV
pop
line 777
;777:	}
LABELV $765
line 780
;778:
;779:	// actually issue the rendering calls
;780:	CG_DrawActive( stereoView );
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 CG_DrawActive
CALLV
pop
line 782
;781:
;782:	if ( cg_stats.integer ) {
ADDRGP4 cg_stats+12
INDIRI4
CNSTI4 0
EQI4 $776
line 783
;783:		CG_Printf( "cg.clientFrame:%i\n", cg.clientFrame );
ADDRGP4 $779
ARGP4
ADDRGP4 cg
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 784
;784:	}
LABELV $776
line 785
;785:}
LABELV $711
endproc CG_DrawActiveFrame 16 16
import CG_Player3rd
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $779
byte 1 99
byte 1 103
byte 1 46
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 70
byte 1 114
byte 1 97
byte 1 109
byte 1 101
byte 1 58
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $216
byte 1 49
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $212
byte 1 51
byte 1 48
byte 1 0
align 1
LABELV $211
byte 1 99
byte 1 103
byte 1 95
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 0
align 1
LABELV $137
byte 1 115
byte 1 107
byte 1 105
byte 1 110
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $120
byte 1 102
byte 1 114
byte 1 97
byte 1 109
byte 1 101
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $81
byte 1 67
byte 1 97
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 114
byte 1 101
byte 1 103
byte 1 105
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 32
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 10
byte 1 0
