code
proc CG_ResetEntity 8 4
file "..\cg_snapshot.c"
line 15
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_snapshot.c -- things that happen on snapshot transition,
;4:// not necessarily every single rendered frame
;5:
;6:#include "cg_local.h"
;7:
;8:
;9:
;10:/*
;11:==================
;12:CG_ResetEntity
;13:==================
;14:*/
;15:static void CG_ResetEntity( centity_t *cent ) {
line 18
;16:	// if an event is set, assume it is new enough to use
;17:	// if the event had timed out, it would have been cleared
;18:	cent->previousEvent = 0;
ADDRFP4 0
INDIRP4
CNSTI4 420
ADDP4
CNSTI4 0
ASGNI4
line 20
;19:
;20:	cent->trailTime = cg.snap->serverTime;
ADDRFP4 0
INDIRP4
CNSTI4 428
ADDP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 22
;21:
;22:	VectorCopy (cent->currentState.origin, cent->lerpOrigin);
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 23
;23:	VectorCopy (cent->currentState.angles, cent->lerpAngles);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 664
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 24
;24:	if ( cent->currentState.eType == ET_PLAYER ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 1
NEI4 $62
line 25
;25:		CG_ResetPlayerEntity( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_ResetPlayerEntity
CALLV
pop
line 26
;26:	}
LABELV $62
line 27
;27:}
LABELV $60
endproc CG_ResetEntity 8 4
proc CG_TransitionEntity 4 4
line 36
;28:
;29:/*
;30:===============
;31:CG_TransitionEntity
;32:
;33:cent->nextState is moved to cent->currentState and events are fired
;34:===============
;35:*/
;36:static void CG_TransitionEntity( centity_t *cent ) {
line 37
;37:	cent->currentState = cent->nextState;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 204
ADDP4
INDIRB
ASGNB 204
line 38
;38:	cent->currentValid = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 412
ADDP4
CNSTI4 1
ASGNI4
line 41
;39:
;40:	// reset if the entity wasn't in the last frame or was teleported
;41:	if ( !cent->interpolate ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRI4
CNSTI4 0
NEI4 $65
line 42
;42:		CG_ResetEntity( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_ResetEntity
CALLV
pop
line 43
;43:	}
LABELV $65
line 46
;44:
;45:	// clear the next state.  if will be set by the next CG_SetNextSnap
;46:	cent->interpolate = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
CNSTI4 0
ASGNI4
line 49
;47:
;48:	// check for events
;49:	CG_CheckEvents( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_CheckEvents
CALLV
pop
line 50
;50:}
LABELV $64
endproc CG_TransitionEntity 4 4
export CG_SetInitialSnapshot
proc CG_SetInitialSnapshot 16 12
line 64
;51:
;52:
;53:/*
;54:==================
;55:CG_SetInitialSnapshot
;56:
;57:This will only happen on the very first snapshot, or
;58:on tourney restarts.  All other times will use 
;59:CG_TransitionSnapshot instead.
;60:
;61:FIXME: Also called by map_restart?
;62:==================
;63:*/
;64:void CG_SetInitialSnapshot( snapshot_t *snap ) {
line 69
;65:	int				i;
;66:	centity_t		*cent;
;67:	entityState_t	*state;
;68:
;69:	cg.snap = snap;
ADDRGP4 cg+32
ADDRFP4 0
INDIRP4
ASGNP4
line 71
;70:
;71:	BG_PlayerStateToEntityState( &snap->ps, &cg_entities[ snap->ps.clientNum ].currentState, qfalse );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
ARGP4
CNSTI4 680
ADDRLP4 12
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 74
;72:
;73:	// sort out solid entities
;74:	CG_BuildSolidList();
ADDRGP4 CG_BuildSolidList
CALLV
pop
line 76
;75:
;76:	CG_ExecuteNewServerCommands( snap->serverCommandSequence );
ADDRFP4 0
INDIRP4
CNSTI4 52720
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_ExecuteNewServerCommands
CALLV
pop
line 80
;77:
;78:	// set our local weapon selection pointer to
;79:	// what the server has indicated the current weapon is
;80:	CG_Respawn();
ADDRGP4 CG_Respawn
CALLV
pop
line 82
;81:
;82:	for ( i = 0 ; i < cg.snap->numEntities ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $72
JUMPV
LABELV $69
line 83
;83:		state = &cg.snap->entities[ i ];
ADDRLP4 8
CNSTI4 204
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 492
ADDP4
ADDP4
ASGNP4
line 84
;84:		cent = &cg_entities[ state->number ];
ADDRLP4 0
CNSTI4 680
ADDRLP4 8
INDIRP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 86
;85:
;86:		cent->currentState = *state;
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRP4
INDIRB
ASGNB 204
line 87
;87:		cent->interpolate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
CNSTI4 0
ASGNI4
line 88
;88:		cent->currentValid = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 412
ADDP4
CNSTI4 1
ASGNI4
line 90
;89:
;90:		CG_ResetEntity( cent );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_ResetEntity
CALLV
pop
line 93
;91:
;92:		// check for events
;93:		CG_CheckEvents( cent );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_CheckEvents
CALLV
pop
line 94
;94:	}
LABELV $70
line 82
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $72
ADDRLP4 4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 488
ADDP4
INDIRI4
LTI4 $69
line 95
;95:}
LABELV $67
endproc CG_SetInitialSnapshot 16 12
proc CG_TransitionSnapshot 28 12
line 105
;96:
;97:
;98:/*
;99:===================
;100:CG_TransitionSnapshot
;101:
;102:The transition point from snap to nextSnap has passed
;103:===================
;104:*/
;105:static void CG_TransitionSnapshot( void ) {
line 110
;106:	centity_t			*cent;
;107:	snapshot_t			*oldFrame;
;108:	int					i;
;109:
;110:	if ( !cg.snap ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $76
line 111
;111:		CG_Error( "CG_TransitionSnapshot: NULL cg.snap" );
ADDRGP4 $79
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 112
;112:	}
LABELV $76
line 113
;113:	if ( !cg.nextSnap ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $80
line 114
;114:		CG_Error( "CG_TransitionSnapshot: NULL cg.nextSnap" );
ADDRGP4 $83
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 115
;115:	}
LABELV $80
line 118
;116:
;117:	// execute any server string commands before transitioning entities
;118:	CG_ExecuteNewServerCommands( cg.nextSnap->serverCommandSequence );
ADDRGP4 cg+36
INDIRP4
CNSTI4 52720
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_ExecuteNewServerCommands
CALLV
pop
line 121
;119:
;120:	// if we had a map_restart, set everthing with initial
;121:	if ( !cg.snap ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $85
line 122
;122:	}
LABELV $85
line 125
;123:
;124:	// clear the currentValid flag for all entities in the existing snapshot
;125:	for ( i = 0 ; i < cg.snap->numEntities ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $91
JUMPV
LABELV $88
line 126
;126:		cent = &cg_entities[ cg.snap->entities[ i ].number ];
ADDRLP4 4
CNSTI4 680
CNSTI4 204
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 492
ADDP4
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 127
;127:		cent->currentValid = qfalse;
ADDRLP4 4
INDIRP4
CNSTI4 412
ADDP4
CNSTI4 0
ASGNI4
line 128
;128:	}
LABELV $89
line 125
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $91
ADDRLP4 0
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 488
ADDP4
INDIRI4
LTI4 $88
line 131
;129:
;130:	// move nextSnap to snap and do the transitions
;131:	oldFrame = cg.snap;
ADDRLP4 8
ADDRGP4 cg+32
INDIRP4
ASGNP4
line 132
;132:	cg.snap = cg.nextSnap;
ADDRGP4 cg+32
ADDRGP4 cg+36
INDIRP4
ASGNP4
line 134
;133:
;134:	BG_PlayerStateToEntityState( &cg.snap->ps, &cg_entities[ cg.snap->ps.clientNum ].currentState, qfalse );
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
ARGP4
CNSTI4 680
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 135
;135:	cg_entities[ cg.snap->ps.clientNum ].interpolate = qfalse;
CNSTI4 680
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities+408
ADDP4
CNSTI4 0
ASGNI4
line 137
;136:
;137:	for ( i = 0 ; i < cg.snap->numEntities ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $104
JUMPV
LABELV $101
line 138
;138:		cent = &cg_entities[ cg.snap->entities[ i ].number ];
ADDRLP4 4
CNSTI4 680
CNSTI4 204
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 492
ADDP4
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 139
;139:		CG_TransitionEntity( cent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 CG_TransitionEntity
CALLV
pop
line 140
;140:	}
LABELV $102
line 137
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $104
ADDRLP4 0
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 488
ADDP4
INDIRI4
LTI4 $101
line 142
;141:
;142:	cg.nextSnap = NULL;
ADDRGP4 cg+36
CNSTP4 0
ASGNP4
line 145
;143:
;144:	// check for playerstate transition events
;145:	if ( oldFrame ) {
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $108
line 148
;146:		playerState_t	*ops, *ps;
;147:
;148:		ops = &oldFrame->ps;
ADDRLP4 12
ADDRLP4 8
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
line 149
;149:		ps = &cg.snap->ps;
ADDRLP4 16
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
line 151
;150:		// teleporting checks are irrespective of prediction
;151:		if ( ( ps->eFlags ^ ops->eFlags ) & EF_TELEPORT_BIT ) {
ADDRLP4 20
CNSTI4 104
ASGNI4
ADDRLP4 16
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRLP4 12
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
BXORI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $111
line 152
;152:			cg.thisFrameTeleport = qtrue;	// will be cleared by prediction code
ADDRGP4 cg+105492
CNSTI4 1
ASGNI4
line 153
;153:		}
LABELV $111
line 157
;154:
;155:		// if we are not doing client side movement prediction for any
;156:		// reason, then the client events and view changes will be issued now
;157:		if ( cg.demoPlayback || (cg.snap->ps.pm_flags & PMF_FOLLOW)
ADDRLP4 24
CNSTI4 0
ASGNI4
ADDRGP4 cg+4
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $122
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
ADDRLP4 24
INDIRI4
NEI4 $122
ADDRGP4 cg_nopredict+12
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $122
ADDRGP4 cg_syncronousClients+12
INDIRI4
ADDRLP4 24
INDIRI4
EQI4 $114
LABELV $122
line 158
;158:			|| cg_nopredict.integer || cg_syncronousClients.integer ) {
line 159
;159:			CG_TransitionPlayerState( ps, ops );
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 CG_TransitionPlayerState
CALLV
pop
line 160
;160:		}
LABELV $114
line 162
;161:
;162:	}
LABELV $108
line 164
;163:
;164:}
LABELV $75
endproc CG_TransitionSnapshot 28 12
proc CG_SetNextSnap 28 12
line 174
;165:
;166:
;167:/*
;168:===================
;169:CG_SetNextSnap
;170:
;171:A new snapshot has just been read in from the client system.
;172:===================
;173:*/
;174:static void CG_SetNextSnap( snapshot_t *snap ) {
line 179
;175:	int					num;
;176:	entityState_t		*es;
;177:	centity_t			*cent;
;178:
;179:	cg.nextSnap = snap;
ADDRGP4 cg+36
ADDRFP4 0
INDIRP4
ASGNP4
line 181
;180:
;181:	BG_PlayerStateToEntityState( &snap->ps, &cg_entities[ snap->ps.clientNum ].nextState, qfalse );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 44
ADDP4
ARGP4
CNSTI4 680
ADDRLP4 12
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities+204
ADDP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 182
;182:	cg_entities[ cg.snap->ps.clientNum ].interpolate = qtrue;
CNSTI4 680
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities+408
ADDP4
CNSTI4 1
ASGNI4
line 185
;183:
;184:	// check for extrapolation errors
;185:	for ( num = 0 ; num < snap->numEntities ; num++ ) {
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $131
JUMPV
LABELV $128
line 186
;186:		es = &snap->entities[num];
ADDRLP4 4
CNSTI4 204
ADDRLP4 8
INDIRI4
MULI4
ADDRFP4 0
INDIRP4
CNSTI4 492
ADDP4
ADDP4
ASGNP4
line 187
;187:		cent = &cg_entities[ es->number ];
ADDRLP4 0
CNSTI4 680
ADDRLP4 4
INDIRP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 189
;188:
;189:		cent->nextState = *es;
ADDRLP4 0
INDIRP4
CNSTI4 204
ADDP4
ADDRLP4 4
INDIRP4
INDIRB
ASGNB 204
line 193
;190:
;191:		// if this frame is a teleport, or the entity wasn't in the
;192:		// previous frame, don't interpolate
;193:		if ( !cent->currentValid || ( ( cent->currentState.eFlags ^ es->eFlags ) & EF_TELEPORT_BIT )  ) {
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
EQI4 $134
ADDRLP4 24
CNSTI4 8
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRI4
BXORI4
CNSTI4 4
BANDI4
ADDRLP4 20
INDIRI4
EQI4 $132
LABELV $134
line 194
;194:			cent->interpolate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
CNSTI4 0
ASGNI4
line 195
;195:		} else {
ADDRGP4 $133
JUMPV
LABELV $132
line 196
;196:			cent->interpolate = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
CNSTI4 1
ASGNI4
line 197
;197:		}
LABELV $133
line 198
;198:	}
LABELV $129
line 185
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $131
ADDRLP4 8
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 488
ADDP4
INDIRI4
LTI4 $128
line 202
;199:
;200:	// if the next frame is a teleport for the playerstate, we
;201:	// can't interpolate during demos
;202:	if ( cg.snap && ( ( snap->ps.eFlags ^ cg.snap->ps.eFlags ) & EF_TELEPORT_BIT ) ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $135
ADDRLP4 16
CNSTI4 148
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
BXORI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $135
line 203
;203:		cg.nextFrameTeleport = qtrue;
ADDRGP4 cg+105496
CNSTI4 1
ASGNI4
line 204
;204:	} else {
ADDRGP4 $136
JUMPV
LABELV $135
line 205
;205:		cg.nextFrameTeleport = qfalse;
ADDRGP4 cg+105496
CNSTI4 0
ASGNI4
line 206
;206:	}
LABELV $136
line 209
;207:
;208:	// if changing follow mode, don't interpolate
;209:	if ( cg.nextSnap->ps.clientNum != cg.snap->ps.clientNum ) {
ADDRLP4 20
CNSTI4 184
ASGNI4
ADDRGP4 cg+36
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
EQI4 $141
line 210
;210:		cg.nextFrameTeleport = qtrue;
ADDRGP4 cg+105496
CNSTI4 1
ASGNI4
line 211
;211:	}
LABELV $141
line 214
;212:
;213:	// if changing server restarts, don't interpolate
;214:	if ( ( cg.nextSnap->snapFlags ^ cg.snap->snapFlags ) & SNAPFLAG_SERVERCOUNT ) {
ADDRGP4 cg+36
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
INDIRI4
BXORI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $146
line 215
;215:		cg.nextFrameTeleport = qtrue;
ADDRGP4 cg+105496
CNSTI4 1
ASGNI4
line 216
;216:	}
LABELV $146
line 219
;217:
;218:	// sort out solid entities
;219:	CG_BuildSolidList();
ADDRGP4 CG_BuildSolidList
CALLV
pop
line 220
;220:}
LABELV $123
endproc CG_SetNextSnap 28 12
proc CG_ReadNextSnapshot 16 12
line 233
;221:
;222:
;223:/*
;224:========================
;225:CG_ReadNextSnapshot
;226:
;227:This is the only place new snapshots are requested
;228:This may increment cgs.processedSnapshotNum multiple
;229:times if the client system fails to return a
;230:valid snapshot.
;231:========================
;232:*/
;233:static snapshot_t *CG_ReadNextSnapshot( void ) {
line 237
;234:	qboolean	r;
;235:	snapshot_t	*dest;
;236:
;237:	if ( cg.latestSnapshotNum > cgs.processedSnapshotNum + 1000 ) {
ADDRGP4 cg+24
INDIRI4
ADDRGP4 cgs+24280
INDIRI4
CNSTI4 1000
ADDI4
LEI4 $160
line 238
;238:		CG_Error( "CG_ReadNextSnapshot: way out of range, %i > %i", 
ADDRGP4 $156
ARGP4
ADDRGP4 cg+24
INDIRI4
ARGI4
ADDRGP4 cgs+24280
INDIRI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 240
;239:			cg.latestSnapshotNum, cgs.processedSnapshotNum );
;240:	}
ADDRGP4 $160
JUMPV
LABELV $159
line 242
;241:
;242:	while ( cgs.processedSnapshotNum < cg.latestSnapshotNum ) {
line 244
;243:		// decide which of the two slots to load it into
;244:		if ( cg.snap == &cg.activeSnapshots[0] ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
ADDRGP4 cg+40
CVPU4 4
NEU4 $164
line 245
;245:			dest = &cg.activeSnapshots[1];
ADDRLP4 0
ADDRGP4 cg+40+52724
ASGNP4
line 246
;246:		} else {
ADDRGP4 $165
JUMPV
LABELV $164
line 247
;247:			dest = &cg.activeSnapshots[0];
ADDRLP4 0
ADDRGP4 cg+40
ASGNP4
line 248
;248:		}
LABELV $165
line 251
;249:
;250:		// try to read the snapshot from the client system
;251:		cgs.processedSnapshotNum++;
ADDRLP4 8
ADDRGP4 cgs+24280
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 252
;252:		r = trap_GetSnapshot( cgs.processedSnapshotNum, dest );
ADDRGP4 cgs+24280
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 trap_GetSnapshot
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 12
INDIRI4
ASGNI4
line 255
;253:
;254:		// if it succeeded, return
;255:		if ( r ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $173
line 256
;256:			CG_AddLagometerSnapshotInfo( dest );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddLagometerSnapshotInfo
CALLV
pop
line 257
;257:			return dest;
ADDRLP4 0
INDIRP4
RETP4
ADDRGP4 $151
JUMPV
LABELV $173
line 266
;258:		}
;259:
;260:		// a GetSnapshot will return failure if the snapshot
;261:		// never arrived, or  is so old that its entities
;262:		// have been shoved off the end of the circular
;263:		// buffer in the client system.
;264:
;265:		// record as a dropped packet
;266:		CG_AddLagometerSnapshotInfo( NULL );
CNSTP4 0
ARGP4
ADDRGP4 CG_AddLagometerSnapshotInfo
CALLV
pop
line 270
;267:
;268:		// If there are additional snapshots, continue trying to
;269:		// read them.
;270:	}
LABELV $160
line 242
ADDRGP4 cgs+24280
INDIRI4
ADDRGP4 cg+24
INDIRI4
LTI4 $159
line 273
;271:
;272:	// nothing left to read
;273:	return NULL;
CNSTP4 0
RETP4
LABELV $151
endproc CG_ReadNextSnapshot 16 12
export CG_ProcessSnapshots
proc CG_ProcessSnapshots 16 8
line 296
;274:}
;275:
;276:
;277:/*
;278:============
;279:CG_ProcessSnapshots
;280:
;281:We are trying to set up a renderable view, so determine
;282:what the simulated time is, and try to get snapshots
;283:both before and after that time if available.
;284:
;285:If we don't have a valid cg.snap after exiting this function,
;286:then a 3D game view cannot be rendered.  This should only happen
;287:right after the initial connection.  After cg.snap has been valid
;288:once, it will never turn invalid.
;289:
;290:Even if cg.snap is valid, cg.nextSnap may not be, if the snapshot
;291:hasn't arrived yet (it becomes an extrapolating situation instead
;292:of an interpolating one)
;293:
;294:============
;295:*/
;296:void CG_ProcessSnapshots( void ) {
line 301
;297:	snapshot_t		*snap;
;298:	int				n;
;299:
;300:	// see what the latest snapshot the client system has is
;301:	trap_GetCurrentSnapshotNumber( &n, &cg.latestSnapshotTime );
ADDRLP4 4
ARGP4
ADDRGP4 cg+28
ARGP4
ADDRGP4 trap_GetCurrentSnapshotNumber
CALLV
pop
line 302
;302:	if ( n != cg.latestSnapshotNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+24
INDIRI4
EQI4 $186
line 303
;303:		if ( n < cg.latestSnapshotNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+24
INDIRI4
GEI4 $180
line 305
;304:			// this should never happen
;305:			CG_Error( "CG_ProcessSnapshots: n < cg.latestSnapshotNum" );
ADDRGP4 $183
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 306
;306:		}
LABELV $180
line 307
;307:		cg.latestSnapshotNum = n;
ADDRGP4 cg+24
ADDRLP4 4
INDIRI4
ASGNI4
line 308
;308:	}
ADDRGP4 $186
JUMPV
LABELV $185
line 313
;309:
;310:	// If we have yet to receive a snapshot, check for it.
;311:	// Once we have gotten the first snapshot, cg.snap will
;312:	// always have valid data for the rest of the game
;313:	while ( !cg.snap ) {
line 314
;314:		snap = CG_ReadNextSnapshot();
ADDRLP4 8
ADDRGP4 CG_ReadNextSnapshot
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 315
;315:		if ( !snap ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $189
line 317
;316:			// we can't continue until we get a snapshot
;317:			return;
ADDRGP4 $175
JUMPV
LABELV $189
line 322
;318:		}
;319:
;320:		// set our weapon selection to what
;321:		// the playerstate is currently using
;322:		if ( !( snap->snapFlags & SNAPFLAG_NOT_ACTIVE ) ) {
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
NEI4 $191
line 323
;323:			CG_SetInitialSnapshot( snap );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_SetInitialSnapshot
CALLV
pop
line 324
;324:		}
LABELV $191
line 325
;325:	}
LABELV $186
line 313
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $185
LABELV $193
line 330
;326:
;327:	// loop until we either have a valid nextSnap with a serverTime
;328:	// greater than cg.time to interpolate towards, or we run
;329:	// out of available snapshots
;330:	do {
line 332
;331:		// if we don't have a nextframe, try and read a new one in
;332:		if ( !cg.nextSnap ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $196
line 333
;333:			snap = CG_ReadNextSnapshot();
ADDRLP4 8
ADDRGP4 CG_ReadNextSnapshot
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 337
;334:
;335:			// if we still don't have a nextframe, we will just have to
;336:			// extrapolate
;337:			if ( !snap ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $199
line 338
;338:				break;
ADDRGP4 $195
JUMPV
LABELV $199
line 341
;339:			}
;340:
;341:			CG_SetNextSnap( snap );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_SetNextSnap
CALLV
pop
line 344
;342:
;343:			// if time went backwards, we have a level restart
;344:			if ( cg.nextSnap->serverTime < cg.snap->serverTime ) {
ADDRLP4 12
CNSTI4 8
ASGNI4
ADDRGP4 cg+36
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
GEI4 $201
line 345
;345:				CG_Error( "CG_ProcessSnapshots: Server time went backwards" );
ADDRGP4 $205
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 346
;346:			}
LABELV $201
line 347
;347:		}
LABELV $196
line 350
;348:
;349:		// if our time is < nextFrame's, we have a nice interpolating state
;350:		if ( cg.time >= cg.snap->serverTime && cg.time < cg.nextSnap->serverTime ) {
ADDRLP4 8
CNSTI4 8
ASGNI4
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+32
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
LTI4 $206
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+36
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
GEI4 $206
line 351
;351:			break;
ADDRGP4 $195
JUMPV
LABELV $206
line 355
;352:		}
;353:
;354:		// we have passed the transition from nextFrame to frame
;355:		CG_TransitionSnapshot();
ADDRGP4 CG_TransitionSnapshot
CALLV
pop
line 356
;356:	} while ( 1 );
LABELV $194
ADDRGP4 $193
JUMPV
LABELV $195
line 359
;357:
;358:	// assert our valid conditions upon exiting
;359:	if ( cg.snap == NULL ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $212
line 360
;360:		CG_Error( "CG_ProcessSnapshots: cg.snap == NULL" );
ADDRGP4 $215
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 361
;361:	}
LABELV $212
line 362
;362:	if ( cg.time < cg.snap->serverTime ) {
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
GEI4 $216
line 364
;363:		// this can happen right after a vid_restart
;364:		cg.time = cg.snap->serverTime;
ADDRGP4 cg+105504
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 365
;365:	}
LABELV $216
line 366
;366:	if ( cg.nextSnap != NULL && cg.nextSnap->serverTime <= cg.time ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $222
ADDRGP4 cg+36
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
GTI4 $222
line 367
;367:		CG_Error( "CG_ProcessSnapshots: cg.nextSnap->serverTime <= cg.time" );
ADDRGP4 $227
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 368
;368:	}
LABELV $222
line 370
;369:
;370:}
LABELV $175
endproc CG_ProcessSnapshots 16 8
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $227
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 114
byte 1 111
byte 1 99
byte 1 101
byte 1 115
byte 1 115
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 115
byte 1 58
byte 1 32
byte 1 99
byte 1 103
byte 1 46
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 45
byte 1 62
byte 1 115
byte 1 101
byte 1 114
byte 1 118
byte 1 101
byte 1 114
byte 1 84
byte 1 105
byte 1 109
byte 1 101
byte 1 32
byte 1 60
byte 1 61
byte 1 32
byte 1 99
byte 1 103
byte 1 46
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $215
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 114
byte 1 111
byte 1 99
byte 1 101
byte 1 115
byte 1 115
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 115
byte 1 58
byte 1 32
byte 1 99
byte 1 103
byte 1 46
byte 1 115
byte 1 110
byte 1 97
byte 1 112
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 0
align 1
LABELV $205
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 114
byte 1 111
byte 1 99
byte 1 101
byte 1 115
byte 1 115
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 115
byte 1 58
byte 1 32
byte 1 83
byte 1 101
byte 1 114
byte 1 118
byte 1 101
byte 1 114
byte 1 32
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 32
byte 1 119
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 98
byte 1 97
byte 1 99
byte 1 107
byte 1 119
byte 1 97
byte 1 114
byte 1 100
byte 1 115
byte 1 0
align 1
LABELV $183
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 114
byte 1 111
byte 1 99
byte 1 101
byte 1 115
byte 1 115
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 115
byte 1 58
byte 1 32
byte 1 110
byte 1 32
byte 1 60
byte 1 32
byte 1 99
byte 1 103
byte 1 46
byte 1 108
byte 1 97
byte 1 116
byte 1 101
byte 1 115
byte 1 116
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 78
byte 1 117
byte 1 109
byte 1 0
align 1
LABELV $156
byte 1 67
byte 1 71
byte 1 95
byte 1 82
byte 1 101
byte 1 97
byte 1 100
byte 1 78
byte 1 101
byte 1 120
byte 1 116
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 58
byte 1 32
byte 1 119
byte 1 97
byte 1 121
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 44
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 62
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $83
byte 1 67
byte 1 71
byte 1 95
byte 1 84
byte 1 114
byte 1 97
byte 1 110
byte 1 115
byte 1 105
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 58
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 99
byte 1 103
byte 1 46
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 0
align 1
LABELV $79
byte 1 67
byte 1 71
byte 1 95
byte 1 84
byte 1 114
byte 1 97
byte 1 110
byte 1 115
byte 1 105
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 83
byte 1 110
byte 1 97
byte 1 112
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 58
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 99
byte 1 103
byte 1 46
byte 1 115
byte 1 110
byte 1 97
byte 1 112
byte 1 0
