code
proc CG_ParseScores 112 12
file "..\cg_servercmds.c"
line 16
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_servercmds.c -- reliably sequenced text commands sent by the server
;4:// these are processed at snapshot transition time, so there will definately
;5:// be a valid snapshot this frame
;6:
;7:#include "cg_local.h"
;8:
;9:
;10:/*
;11:=================
;12:CG_ParseScores
;13:
;14:=================
;15:*/
;16:static void CG_ParseScores( void ) {
line 19
;17:	int		i, powerups;
;18:
;19:	cg.numScores = atoi( CG_Argv( 1 ) );
CNSTI4 1
ARGI4
ADDRLP4 8
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cg+108220
ADDRLP4 12
INDIRI4
ASGNI4
line 20
;20:	if ( cg.numScores > MAX_CLIENTS ) {
ADDRGP4 cg+108220
INDIRI4
CNSTI4 128
LEI4 $62
line 21
;21:		cg.numScores = MAX_CLIENTS;
ADDRGP4 cg+108220
CNSTI4 128
ASGNI4
line 22
;22:	}
LABELV $62
line 24
;23:
;24:	cg.teamScores[0] = atoi( CG_Argv( 2 ) );
CNSTI4 2
ARGI4
ADDRLP4 16
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cg+108224
ADDRLP4 20
INDIRI4
ASGNI4
line 25
;25:	cg.teamScores[1] = atoi( CG_Argv( 3 ) );
CNSTI4 3
ARGI4
ADDRLP4 24
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cg+108224+4
ADDRLP4 28
INDIRI4
ASGNI4
line 27
;26:
;27:	memset( cg.scores, 0, sizeof( cg.scores ) );
ADDRGP4 cg+108232
ARGP4
CNSTI4 0
ARGI4
CNSTU4 2560
ARGU4
ADDRGP4 memset
CALLP4
pop
line 28
;28:	for ( i = 0 ; i < cg.numScores ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $74
JUMPV
LABELV $71
line 29
;29:		cg.scores[i].client = atoi( CG_Argv( i * 6 + 4 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 4
ADDI4
ARGI4
ADDRLP4 36
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 36
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232
ADDP4
ADDRLP4 40
INDIRI4
ASGNI4
line 30
;30:		cg.scores[i].score = atoi( CG_Argv( i * 6 + 5 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 5
ADDI4
ARGI4
ADDRLP4 48
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 48
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232+4
ADDP4
ADDRLP4 52
INDIRI4
ASGNI4
line 31
;31:		cg.scores[i].ping = atoi( CG_Argv( i * 6 + 6 ) );
ADDRLP4 56
CNSTI4 6
ASGNI4
ADDRLP4 56
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
ADDRLP4 56
INDIRI4
ADDI4
ARGI4
ADDRLP4 64
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232+8
ADDP4
ADDRLP4 68
INDIRI4
ASGNI4
line 32
;32:		cg.scores[i].time = atoi( CG_Argv( i * 6 + 7 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 7
ADDI4
ARGI4
ADDRLP4 76
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232+12
ADDP4
ADDRLP4 80
INDIRI4
ASGNI4
line 33
;33:		cg.scores[i].scoreFlags = atoi( CG_Argv( i * 6 + 8 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 8
ADDI4
ARGI4
ADDRLP4 88
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 88
INDIRP4
ARGP4
ADDRLP4 92
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232+16
ADDP4
ADDRLP4 92
INDIRI4
ASGNI4
line 34
;34:		powerups = atoi( CG_Argv( i * 6 + 9 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 9
ADDI4
ARGI4
ADDRLP4 96
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 100
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 100
INDIRI4
ASGNI4
line 36
;35:
;36:		if ( cg.scores[i].client < 0 || cg.scores[i].client >= MAX_CLIENTS ) {
ADDRLP4 104
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 104
INDIRI4
ADDRGP4 cg+108232
ADDP4
INDIRI4
CNSTI4 0
LTI4 $89
ADDRLP4 104
INDIRI4
ADDRGP4 cg+108232
ADDP4
INDIRI4
CNSTI4 128
LTI4 $85
LABELV $89
line 37
;37:			cg.scores[i].client = 0;
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232
ADDP4
CNSTI4 0
ASGNI4
line 38
;38:		}
LABELV $85
line 39
;39:		cgs.clientinfo[ cg.scores[i].client ].score = cg.scores[i].score;
ADDRLP4 108
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
CNSTI4 1076
ADDRLP4 108
INDIRI4
ADDRGP4 cg+108232
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+88
ADDP4
ADDRLP4 108
INDIRI4
ADDRGP4 cg+108232+4
ADDP4
INDIRI4
ASGNI4
line 40
;40:		cgs.clientinfo[ cg.scores[i].client ].powerups = powerups;
CNSTI4 1076
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+120
ADDP4
ADDRLP4 4
INDIRI4
ASGNI4
line 41
;41:	}
LABELV $72
line 28
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $74
ADDRLP4 0
INDIRI4
ADDRGP4 cg+108220
INDIRI4
LTI4 $71
line 43
;42:
;43:}
LABELV $60
endproc CG_ParseScores 112 12
proc CG_ParseTeamInfo 68 4
line 51
;44:
;45:/*
;46:=================
;47:CG_ParseTeamInfo
;48:
;49:=================
;50:*/
;51:static void CG_ParseTeamInfo( void ) {
line 55
;52:	int		i;
;53:	int		client;
;54:
;55:	numSortedTeamPlayers = atoi( CG_Argv( 1 ) );
CNSTI4 1
ARGI4
ADDRLP4 8
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 numSortedTeamPlayers
ADDRLP4 12
INDIRI4
ASGNI4
line 57
;56:
;57:	for ( i = 0 ; i < numSortedTeamPlayers ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $103
JUMPV
LABELV $100
line 58
;58:		client = atoi( CG_Argv( i * 6 + 2 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 2
ADDI4
ARGI4
ADDRLP4 16
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 20
INDIRI4
ASGNI4
line 60
;59:
;60:		sortedTeamPlayers[i] = client;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 sortedTeamPlayers
ADDP4
ADDRLP4 4
INDIRI4
ASGNI4
line 62
;61:
;62:		cgs.clientinfo[ client ].location = atoi( CG_Argv( i * 6 + 3 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 3
ADDI4
ARGI4
ADDRLP4 24
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+92
ADDP4
ADDRLP4 28
INDIRI4
ASGNI4
line 63
;63:		cgs.clientinfo[ client ].health = atoi( CG_Argv( i * 6 + 4 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 4
ADDI4
ARGI4
ADDRLP4 32
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+96
ADDP4
ADDRLP4 36
INDIRI4
ASGNI4
line 64
;64:		cgs.clientinfo[ client ].armor = atoi( CG_Argv( i * 6 + 5 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 5
ADDI4
ARGI4
ADDRLP4 40
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 40
INDIRP4
ARGP4
ADDRLP4 44
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+100
ADDP4
ADDRLP4 44
INDIRI4
ASGNI4
line 65
;65:		cgs.clientinfo[ client ].curWeapon = atoi( CG_Argv( i * 6 + 6 ) );
ADDRLP4 48
CNSTI4 6
ASGNI4
ADDRLP4 48
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
ADDRLP4 48
INDIRI4
ADDI4
ARGI4
ADDRLP4 52
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+104
ADDP4
ADDRLP4 56
INDIRI4
ASGNI4
line 66
;66:		cgs.clientinfo[ client ].powerups = atoi( CG_Argv( i * 6 + 7 ) );
CNSTI4 6
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 7
ADDI4
ARGI4
ADDRLP4 60
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 atoi
CALLI4
ASGNI4
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820+120
ADDP4
ADDRLP4 64
INDIRI4
ASGNI4
line 67
;67:	}
LABELV $101
line 57
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $103
ADDRLP4 0
INDIRI4
ADDRGP4 numSortedTeamPlayers
INDIRI4
LTI4 $100
line 68
;68:}
LABELV $99
endproc CG_ParseTeamInfo 68 4
export CG_ParseServerinfo
proc CG_ParseServerinfo 72 16
line 79
;69:
;70:
;71:/*
;72:================
;73:CG_ParseServerinfo
;74:
;75:This is called explicitly when the gamestate is first received,
;76:and whenever the server updates any serverinfo flagged cvars
;77:================
;78:*/
;79:void CG_ParseServerinfo( void ) {
line 83
;80:	const char	*info;
;81:	char	*mapname;
;82:
;83:	info = CG_ConfigString( CS_SERVERINFO );
CNSTI4 0
ARGI4
ADDRLP4 8
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 84
;84:	cgs.gametype = atoi( Info_ValueForKey( info, "g_gametype" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $116
ARGP4
ADDRLP4 12
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24288
ADDRLP4 16
INDIRI4
ASGNI4
line 85
;85:	cgs.dmflags = atoi( Info_ValueForKey( info, "dmflags" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $118
ARGP4
ADDRLP4 20
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24292
ADDRLP4 24
INDIRI4
ASGNI4
line 86
;86:	cgs.teamflags = atoi( Info_ValueForKey( info, "teamflags" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $120
ARGP4
ADDRLP4 28
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24296
ADDRLP4 32
INDIRI4
ASGNI4
line 87
;87:	cgs.fraglimit = atoi( Info_ValueForKey( info, "fraglimit" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $122
ARGP4
ADDRLP4 36
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 36
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24300
ADDRLP4 40
INDIRI4
ASGNI4
line 88
;88:	cgs.capturelimit = atoi( Info_ValueForKey( info, "capturelimit" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $124
ARGP4
ADDRLP4 44
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 44
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24304
ADDRLP4 48
INDIRI4
ASGNI4
line 89
;89:	cgs.timelimit = atoi( Info_ValueForKey( info, "timelimit" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $126
ARGP4
ADDRLP4 52
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24308
ADDRLP4 56
INDIRI4
ASGNI4
line 90
;90:	cgs.maxclients = atoi( Info_ValueForKey( info, "sv_maxclients" ) );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $128
ARGP4
ADDRLP4 60
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24312
ADDRLP4 64
INDIRI4
ASGNI4
line 91
;91:	mapname = Info_ValueForKey( info, "mapname" );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $129
ARGP4
ADDRLP4 68
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 92
;92:	Com_sprintf( cgs.mapname, sizeof( cgs.mapname ), "maps/%s.bsp", mapname );
ADDRGP4 cgs+24316
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $132
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 93
;93:}
LABELV $114
endproc CG_ParseServerinfo 72 16
proc CG_ParseWarmup 24 8
line 100
;94:
;95:/*
;96:==================
;97:CG_ParseWarmup
;98:==================
;99:*/
;100:static void CG_ParseWarmup( void ) {
line 104
;101:	const char	*info;
;102:	int			warmup;
;103:
;104:	info = CG_ConfigString( CS_WARMUP );
CNSTI4 5
ARGI4
ADDRLP4 8
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 106
;105:
;106:	warmup = atoi( info );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ASGNI4
line 107
;107:	cg.warmupCount = -1;
ADDRGP4 cg+111916
CNSTI4 -1
ASGNI4
line 109
;108:
;109:	if ( warmup == 0 && cg.warmup ) {
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $135
ADDRGP4 cg+111912
INDIRI4
ADDRLP4 16
INDIRI4
EQI4 $135
line 111
;110:
;111:	} else if ( warmup > 0 && cg.warmup <= 0 ) {
ADDRGP4 $136
JUMPV
LABELV $135
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 20
INDIRI4
LEI4 $138
ADDRGP4 cg+111912
INDIRI4
ADDRLP4 20
INDIRI4
GTI4 $138
line 112
;112:		trap_S_StartLocalSound( cgs.media.countPrepareSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+764
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 113
;113:	}
LABELV $138
LABELV $136
line 115
;114:
;115:	cg.warmup = warmup;
ADDRGP4 cg+111912
ADDRLP4 0
INDIRI4
ASGNI4
line 116
;116:}
LABELV $133
endproc CG_ParseWarmup 24 8
export CG_SetConfigValues
proc CG_SetConfigValues 40 4
line 125
;117:
;118:/*
;119:================
;120:CG_SetConfigValues
;121:
;122:Called on load to set the initial values from configure strings
;123:================
;124:*/
;125:void CG_SetConfigValues( void ) {
line 128
;126:	const char *s;
;127:
;128:	cgs.scores1 = atoi( CG_ConfigString( CS_SCORES1 ) );
CNSTI4 6
ARGI4
ADDRLP4 4
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24656
ADDRLP4 8
INDIRI4
ASGNI4
line 129
;129:	cgs.scores2 = atoi( CG_ConfigString( CS_SCORES2 ) );
CNSTI4 7
ARGI4
ADDRLP4 12
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24660
ADDRLP4 16
INDIRI4
ASGNI4
line 130
;130:	cgs.levelStartTime = atoi( CG_ConfigString( CS_LEVEL_START_TIME ) );
CNSTI4 13
ARGI4
ADDRLP4 20
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24652
ADDRLP4 24
INDIRI4
ASGNI4
line 131
;131:	s = CG_ConfigString( CS_FLAGSTATUS );
CNSTI4 15
ARGI4
ADDRLP4 28
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
ASGNP4
line 132
;132:	cgs.redflag = s[0] - '0';
ADDRGP4 cgs+24664
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
ASGNI4
line 133
;133:	cgs.blueflag = s[1] - '0';
ADDRGP4 cgs+24668
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
ASGNI4
line 134
;134:	cg.warmup = atoi( CG_ConfigString( CS_WARMUP ) );
CNSTI4 5
ARGI4
ADDRLP4 32
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cg+111912
ADDRLP4 36
INDIRI4
ASGNI4
line 135
;135:}
LABELV $144
endproc CG_SetConfigValues 40 4
proc CG_ConfigStringModified 32 12
line 143
;136:
;137:/*
;138:================
;139:CG_ConfigStringModified
;140:
;141:================
;142:*/
;143:static void CG_ConfigStringModified( void ) {
line 147
;144:	const char	*str;
;145:	int		num;
;146:
;147:	num = atoi( CG_Argv( 1 ) );
CNSTI4 1
ARGI4
ADDRLP4 8
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ASGNI4
line 151
;148:
;149:	// get the gamestate from the client system, which will have the
;150:	// new configstring already integrated
;151:	trap_GetGameState( &cgs.gameState );
ADDRGP4 cgs
ARGP4
ADDRGP4 trap_GetGameState
CALLV
pop
line 154
;152:
;153:	// look up the individual string that was modified
;154:	str = CG_ConfigString( num );
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 16
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 16
INDIRP4
ASGNP4
line 157
;155:
;156:	// do something with it if necessary
;157:	if ( num == CS_MUSIC ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
NEI4 $152
line 158
;158:		CG_StartMusic();
ADDRGP4 CG_StartMusic
CALLV
pop
line 159
;159:	} else if ( num == CS_SERVERINFO ) {
ADDRGP4 $153
JUMPV
LABELV $152
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $154
line 160
;160:		CG_ParseServerinfo();
ADDRGP4 CG_ParseServerinfo
CALLV
pop
line 161
;161:	} else if ( num == CS_WARMUP ) {
ADDRGP4 $155
JUMPV
LABELV $154
ADDRLP4 0
INDIRI4
CNSTI4 5
NEI4 $156
line 162
;162:		CG_ParseWarmup();
ADDRGP4 CG_ParseWarmup
CALLV
pop
line 163
;163:	} else if ( num == CS_SCORES1 ) {
ADDRGP4 $157
JUMPV
LABELV $156
ADDRLP4 0
INDIRI4
CNSTI4 6
NEI4 $158
line 164
;164:		cgs.scores1 = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24656
ADDRLP4 20
INDIRI4
ASGNI4
line 165
;165:	} else if ( num == CS_SCORES2 ) {
ADDRGP4 $159
JUMPV
LABELV $158
ADDRLP4 0
INDIRI4
CNSTI4 7
NEI4 $161
line 166
;166:		cgs.scores2 = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24660
ADDRLP4 20
INDIRI4
ASGNI4
line 167
;167:	} else if ( num == CS_WARMUP ) {
ADDRGP4 $162
JUMPV
LABELV $161
ADDRLP4 0
INDIRI4
CNSTI4 5
NEI4 $164
line 168
;168:		CG_ParseWarmup();
ADDRGP4 CG_ParseWarmup
CALLV
pop
line 169
;169:	} else if ( num == CS_LEVEL_START_TIME ) {
ADDRGP4 $165
JUMPV
LABELV $164
ADDRLP4 0
INDIRI4
CNSTI4 13
NEI4 $166
line 170
;170:		cgs.levelStartTime = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24652
ADDRLP4 20
INDIRI4
ASGNI4
line 171
;171:	} else if ( num == CS_VOTE_TIME ) {
ADDRGP4 $167
JUMPV
LABELV $166
ADDRLP4 0
INDIRI4
CNSTI4 8
NEI4 $169
line 172
;172:		cgs.voteTime = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24380
ADDRLP4 20
INDIRI4
ASGNI4
line 173
;173:		cgs.voteModified = qtrue;
ADDRGP4 cgs+24392
CNSTI4 1
ASGNI4
line 174
;174:	} else if ( num == CS_VOTE_YES ) {
ADDRGP4 $170
JUMPV
LABELV $169
ADDRLP4 0
INDIRI4
CNSTI4 10
NEI4 $173
line 175
;175:		cgs.voteYes = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24384
ADDRLP4 20
INDIRI4
ASGNI4
line 176
;176:		cgs.voteModified = qtrue;
ADDRGP4 cgs+24392
CNSTI4 1
ASGNI4
line 177
;177:	} else if ( num == CS_VOTE_NO ) {
ADDRGP4 $174
JUMPV
LABELV $173
ADDRLP4 0
INDIRI4
CNSTI4 11
NEI4 $177
line 178
;178:		cgs.voteNo = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cgs+24388
ADDRLP4 20
INDIRI4
ASGNI4
line 179
;179:		cgs.voteModified = qtrue;
ADDRGP4 cgs+24392
CNSTI4 1
ASGNI4
line 180
;180:	} else if ( num == CS_VOTE_STRING ) {
ADDRGP4 $178
JUMPV
LABELV $177
ADDRLP4 0
INDIRI4
CNSTI4 9
NEI4 $181
line 181
;181:		Q_strncpyz( cgs.voteString, str, sizeof( cgs.voteString ) );
ADDRGP4 cgs+24396
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 182
;182:	} else if ( num == CS_INTERMISSION ) {
ADDRGP4 $182
JUMPV
LABELV $181
ADDRLP4 0
INDIRI4
CNSTI4 14
NEI4 $185
line 183
;183:		cg.intermissionStarted = atoi( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 cg+20
ADDRLP4 20
INDIRI4
ASGNI4
line 184
;184:	} else if ( num >= CS_MODELS && num < CS_MODELS+MAX_MODELS ) {
ADDRGP4 $186
JUMPV
LABELV $185
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $188
ADDRLP4 0
INDIRI4
CNSTI4 288
GEI4 $188
line 185
;185:		cgs.gameModels[ num-CS_MODELS ] = trap_R_RegisterModel( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+24672-128
ADDP4
ADDRLP4 24
INDIRI4
ASGNI4
line 186
;186:	} else if ( num >= CS_SOUNDS && num < CS_SOUNDS+MAX_MODELS ) {
ADDRGP4 $189
JUMPV
LABELV $188
ADDRLP4 0
INDIRI4
CNSTI4 288
LTI4 $192
ADDRLP4 0
INDIRI4
CNSTI4 544
GEI4 $192
line 187
;187:		if ( str[0] != '*' ) {	// player specific sounds don't register here
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 42
EQI4 $193
line 188
;188:			cgs.gameSounds[ num-CS_SOUNDS] = trap_S_RegisterSound( str );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+25696-1152
ADDP4
ADDRLP4 28
INDIRI4
ASGNI4
line 189
;189:		}
line 190
;190:	} else if ( num >= CS_PLAYERS && num < CS_PLAYERS+MAX_CLIENTS ) {
ADDRGP4 $193
JUMPV
LABELV $192
ADDRLP4 0
INDIRI4
CNSTI4 544
LTI4 $198
ADDRLP4 0
INDIRI4
CNSTI4 672
GEI4 $198
line 191
;191:		CG_NewClientInfo( num - CS_PLAYERS );
ADDRLP4 0
INDIRI4
CNSTI4 544
SUBI4
ARGI4
ADDRGP4 CG_NewClientInfo
CALLV
pop
line 192
;192:	} else if ( num == CS_FLAGSTATUS ) {
ADDRGP4 $199
JUMPV
LABELV $198
ADDRLP4 0
INDIRI4
CNSTI4 15
NEI4 $200
line 194
;193:		// format is rb where its red/blue, 0 is at base, 1 is taken, 2 is dropped
;194:		cgs.redflag = str[0] - '0';
ADDRGP4 cgs+24664
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
ASGNI4
line 195
;195:		cgs.blueflag = str[1] - '0';
ADDRGP4 cgs+24668
ADDRLP4 4
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
ASGNI4
line 196
;196:	}
LABELV $200
LABELV $199
LABELV $193
LABELV $189
LABELV $186
LABELV $182
LABELV $178
LABELV $174
LABELV $170
LABELV $167
LABELV $165
LABELV $162
LABELV $159
LABELV $157
LABELV $155
LABELV $153
line 198
;197:		
;198:}
LABELV $151
endproc CG_ConfigStringModified 32 12
proc CG_AddToTeamChat 60 0
line 207
;199:
;200:
;201:/*
;202:=======================
;203:CG_AddToTeamChat
;204:
;205:=======================
;206:*/
;207:static void CG_AddToTeamChat( const char *str ) {
line 213
;208:	int len;
;209:	char *p, *ls;
;210:	int lastcolor;
;211:	int chatHeight;
;212:
;213:	if (cg_teamChatHeight.integer < TEAMCHAT_HEIGHT) {
ADDRGP4 cg_teamChatHeight+12
INDIRI4
CNSTI4 8
GEI4 $205
line 214
;214:		chatHeight = cg_teamChatHeight.integer;
ADDRLP4 12
ADDRGP4 cg_teamChatHeight+12
INDIRI4
ASGNI4
line 215
;215:	} else {
ADDRGP4 $206
JUMPV
LABELV $205
line 216
;216:		chatHeight = TEAMCHAT_HEIGHT;
ADDRLP4 12
CNSTI4 8
ASGNI4
line 217
;217:	}
LABELV $206
line 219
;218:
;219:	if (chatHeight <= 0 || cg_teamChatTime.integer <= 0) {
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 12
INDIRI4
ADDRLP4 20
INDIRI4
LEI4 $212
ADDRGP4 cg_teamChatTime+12
INDIRI4
ADDRLP4 20
INDIRI4
GTI4 $209
LABELV $212
line 221
;220:		// team chat disabled, dump into normal chat
;221:		cgs.teamChatPos = cgs.teamLastChatPos = 0;
ADDRLP4 24
CNSTI4 0
ASGNI4
ADDRGP4 cgs+170512
ADDRLP4 24
INDIRI4
ASGNI4
ADDRGP4 cgs+170508
ADDRLP4 24
INDIRI4
ASGNI4
line 222
;222:		return;
ADDRGP4 $204
JUMPV
LABELV $209
line 225
;223:	}
;224:
;225:	len = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 227
;226:
;227:	p = cgs.teamChatMsgs[cgs.teamChatPos % chatHeight];
ADDRLP4 0
CNSTI4 241
ADDRGP4 cgs+170508
INDIRI4
ADDRLP4 12
INDIRI4
MODI4
MULI4
ADDRGP4 cgs+168548
ADDP4
ASGNP4
line 228
;228:	*p = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 230
;229:
;230:	lastcolor = '7';
ADDRLP4 16
CNSTI4 55
ASGNI4
line 232
;231:
;232:	ls = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
ADDRGP4 $218
JUMPV
LABELV $217
line 233
;233:	while (*str) {
line 234
;234:		if (len > TEAMCHAT_WIDTH - 1) {
ADDRLP4 4
INDIRI4
CNSTI4 79
LEI4 $220
line 235
;235:			if (ls) {
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $222
line 236
;236:				str -= (p - ls);
ADDRFP4 0
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
SUBP4
ASGNP4
line 237
;237:				str++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 238
;238:				p -= (p - ls);
ADDRLP4 0
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
SUBP4
ASGNP4
line 239
;239:			}
LABELV $222
line 240
;240:			*p = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 242
;241:
;242:			cgs.teamChatMsgTimes[cgs.teamChatPos % chatHeight] = cg.time;
ADDRGP4 cgs+170508
INDIRI4
ADDRLP4 12
INDIRI4
MODI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170476
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 244
;243:
;244:			cgs.teamChatPos++;
ADDRLP4 24
ADDRGP4 cgs+170508
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 245
;245:			p = cgs.teamChatMsgs[cgs.teamChatPos % chatHeight];
ADDRLP4 0
CNSTI4 241
ADDRGP4 cgs+170508
INDIRI4
ADDRLP4 12
INDIRI4
MODI4
MULI4
ADDRGP4 cgs+168548
ADDP4
ASGNP4
line 246
;246:			*p = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 247
;247:			*p++ = Q_COLOR_ESCAPE;
ADDRLP4 28
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI1 94
ASGNI1
line 248
;248:			*p++ = lastcolor;
ADDRLP4 32
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 32
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 16
INDIRI4
CVII1 4
ASGNI1
line 249
;249:			len = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 250
;250:			ls = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
line 251
;251:		}
LABELV $220
line 253
;252:
;253:		if ( Q_IsColorString( str ) ) {
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $230
ADDRLP4 28
CNSTI4 94
ASGNI4
ADDRLP4 24
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 28
INDIRI4
NEI4 $230
ADDRLP4 32
ADDRLP4 24
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 0
EQI4 $230
ADDRLP4 32
INDIRI4
ADDRLP4 28
INDIRI4
EQI4 $230
line 254
;254:			*p++ = *str++;
ADDRLP4 36
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 44
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 36
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ASGNP4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 40
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI1
ASGNI1
line 255
;255:			lastcolor = *str;
ADDRLP4 16
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 256
;256:			*p++ = *str++;
ADDRLP4 48
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 56
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 48
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ASGNP4
ADDRLP4 52
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 52
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 52
INDIRP4
INDIRI1
ASGNI1
line 257
;257:			continue;
ADDRGP4 $218
JUMPV
LABELV $230
line 259
;258:		}
;259:		if (*str == ' ') {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $232
line 260
;260:			ls = p;
ADDRLP4 8
ADDRLP4 0
INDIRP4
ASGNP4
line 261
;261:		}
LABELV $232
line 262
;262:		*p++ = *str++;
ADDRLP4 36
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 44
CNSTI4 1
ASGNI4
ADDRLP4 0
ADDRLP4 36
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ASGNP4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 40
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI1
ASGNI1
line 263
;263:		len++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 264
;264:	}
LABELV $218
line 233
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $217
line 265
;265:	*p = 0;
ADDRLP4 0
INDIRP4
CNSTI1 0
ASGNI1
line 267
;266:
;267:	cgs.teamChatMsgTimes[cgs.teamChatPos % chatHeight] = cg.time;
ADDRGP4 cgs+170508
INDIRI4
ADDRLP4 12
INDIRI4
MODI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170476
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 268
;268:	cgs.teamChatPos++;
ADDRLP4 24
ADDRGP4 cgs+170508
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 270
;269:
;270:	if (cgs.teamChatPos - cgs.teamLastChatPos > chatHeight)
ADDRGP4 cgs+170508
INDIRI4
ADDRGP4 cgs+170512
INDIRI4
SUBI4
ADDRLP4 12
INDIRI4
LEI4 $238
line 271
;271:		cgs.teamLastChatPos = cgs.teamChatPos - chatHeight;
ADDRGP4 cgs+170512
ADDRGP4 cgs+170508
INDIRI4
ADDRLP4 12
INDIRI4
SUBI4
ASGNI4
LABELV $238
line 272
;272:}
LABELV $204
endproc CG_AddToTeamChat 60 0
proc CG_MapRestart 0 12
line 287
;273:
;274:
;275:
;276:/*
;277:===============
;278:CG_MapRestart
;279:
;280:The server has issued a map_restart, so the next snapshot
;281:is completely new and should not be interpolated to.
;282:
;283:A tournement restart will clear everything, but doesn't
;284:require a reload of all the media
;285:===============
;286:*/
;287:static void CG_MapRestart( void ) {
line 288
;288:	if ( cg_showmiss.integer ) {
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 0
EQI4 $245
line 289
;289:		CG_Printf( "CG_MapRestart\n" );
ADDRGP4 $248
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 290
;290:	}
LABELV $245
line 292
;291:
;292:	CG_InitLocalEntities();
ADDRGP4 CG_InitLocalEntities
CALLV
pop
line 293
;293:	CG_InitMarkPolys();
ADDRGP4 CG_InitMarkPolys
CALLV
pop
line 296
;294:
;295:	// make sure the "3 frags left" warnings play again
;296:	cg.fraglimitWarnings = 0;
ADDRGP4 cg+105520
CNSTI4 0
ASGNI4
line 298
;297:
;298:	cg.timelimitWarnings = 0;
ADDRGP4 cg+105516
CNSTI4 0
ASGNI4
line 300
;299:
;300:	cg.intermissionStarted = qfalse;
ADDRGP4 cg+20
CNSTI4 0
ASGNI4
line 302
;301:
;302:	cgs.voteTime = 0;
ADDRGP4 cgs+24380
CNSTI4 0
ASGNI4
line 304
;303:
;304:	CG_StartMusic();
ADDRGP4 CG_StartMusic
CALLV
pop
line 309
;305:
;306:	// we really should clear more parts of cg here and stop sounds
;307:
;308:	// play the "fight" sound if this is a restart without warmup
;309:	if ( cg.warmup == 0 /* && cgs.gametype == GT_TOURNAMENT */) {
ADDRGP4 cg+111912
INDIRI4
CNSTI4 0
NEI4 $253
line 310
;310:		trap_S_StartLocalSound( cgs.media.countFightSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+760
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 311
;311:		CG_CenterPrint( "FIGHT!", 20, GIANTCHAR_WIDTH*2 );
ADDRGP4 $258
ARGP4
CNSTI4 20
ARGI4
CNSTI4 64
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 312
;312:	}
LABELV $253
line 313
;313:}
LABELV $244
endproc CG_MapRestart 0 12
proc CG_ServerCommand 48 12
line 324
;314:
;315:
;316:/*
;317:=================
;318:CG_ServerCommand
;319:
;320:The string has been tokenized and can be retrieved with
;321:Cmd_Argc() / Cmd_Argv()
;322:=================
;323:*/
;324:static void CG_ServerCommand( void ) {
line 327
;325:	const char	*cmd;
;326:
;327:	cmd = CG_Argv(0);
CNSTI4 0
ARGI4
ADDRLP4 4
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 329
;328:
;329:	if ( !cmd[0] ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $260
line 331
;330:		// server claimed the command
;331:		return;
ADDRGP4 $259
JUMPV
LABELV $260
line 334
;332:	}
;333:
;334:	if ( !strcmp( cmd, "cp" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $264
ARGP4
ADDRLP4 8
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $262
line 335
;335:		CG_CenterPrint( CG_Argv(1), SCREEN_HEIGHT * 0.25, BIGCHAR_WIDTH );
CNSTI4 1
ARGI4
ADDRLP4 12
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 12
INDIRP4
ARGP4
CNSTI4 120
ARGI4
CNSTI4 16
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 336
;336:		return;
ADDRGP4 $259
JUMPV
LABELV $262
line 339
;337:	}
;338:
;339:	if ( !strcmp( cmd, "cs" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $267
ARGP4
ADDRLP4 12
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $265
line 340
;340:		CG_ConfigStringModified();
ADDRGP4 CG_ConfigStringModified
CALLV
pop
line 341
;341:		return;
ADDRGP4 $259
JUMPV
LABELV $265
line 344
;342:	}
;343:
;344:	if ( !strcmp( cmd, "print" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $270
ARGP4
ADDRLP4 16
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
NEI4 $268
line 345
;345:		CG_Printf( "%s", CG_Argv(1) );
CNSTI4 1
ARGI4
ADDRLP4 20
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRGP4 $271
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 346
;346:		return;
ADDRGP4 $259
JUMPV
LABELV $268
line 349
;347:	}
;348:
;349:	if ( !strcmp( cmd, "chat" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $274
ARGP4
ADDRLP4 20
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 0
NEI4 $272
line 350
;350:		trap_S_StartLocalSound( cgs.media.talkSound, CHAN_LOCAL_SOUND );
ADDRGP4 cgs+170516+640
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 351
;351:		CG_Printf( "%s\n", CG_Argv(1) );
CNSTI4 1
ARGI4
ADDRLP4 24
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRGP4 $277
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 352
;352:		return;
ADDRGP4 $259
JUMPV
LABELV $272
line 355
;353:	}
;354:
;355:	if ( !strcmp( cmd, "tchat" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $280
ARGP4
ADDRLP4 24
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 0
NEI4 $278
line 356
;356:		trap_S_StartLocalSound( cgs.media.talkSound, CHAN_LOCAL_SOUND );
ADDRGP4 cgs+170516+640
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 357
;357:		CG_AddToTeamChat( CG_Argv(1) );
CNSTI4 1
ARGI4
ADDRLP4 28
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRGP4 CG_AddToTeamChat
CALLV
pop
line 358
;358:		CG_Printf( "%s\n", CG_Argv(1) );
CNSTI4 1
ARGI4
ADDRLP4 32
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRGP4 $277
ARGP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 359
;359:		return;
ADDRGP4 $259
JUMPV
LABELV $278
line 362
;360:	}
;361:
;362:	if ( !strcmp( cmd, "scores" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $285
ARGP4
ADDRLP4 28
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
NEI4 $283
line 363
;363:		CG_ParseScores();
ADDRGP4 CG_ParseScores
CALLV
pop
line 364
;364:		return;
ADDRGP4 $259
JUMPV
LABELV $283
line 367
;365:	}
;366:
;367:	if ( !strcmp( cmd, "tinfo" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $288
ARGP4
ADDRLP4 32
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 0
NEI4 $286
line 368
;368:		CG_ParseTeamInfo();
ADDRGP4 CG_ParseTeamInfo
CALLV
pop
line 369
;369:		return;
ADDRGP4 $259
JUMPV
LABELV $286
line 372
;370:	}
;371:
;372:	if ( !strcmp( cmd, "map_restart" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $291
ARGP4
ADDRLP4 36
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $289
line 373
;373:		CG_MapRestart();
ADDRGP4 CG_MapRestart
CALLV
pop
line 374
;374:		return;
ADDRGP4 $259
JUMPV
LABELV $289
line 378
;375:	}
;376:
;377:	// loaddeferred can be both a servercmd and a consolecmd
;378:	if ( !strcmp( cmd, "loaddefered" ) ) {	// FIXME: spelled wrong, but not changing for demo
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $294
ARGP4
ADDRLP4 40
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
NEI4 $292
line 379
;379:		CG_LoadDeferredPlayers();
ADDRGP4 CG_LoadDeferredPlayers
CALLV
pop
line 380
;380:		return;
ADDRGP4 $259
JUMPV
LABELV $292
line 385
;381:	}
;382:
;383:	// clientLevelShot is sent before taking a special screenshot for
;384:	// the menu system during development
;385:	if ( !strcmp( cmd, "clientLevelShot" ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 $297
ARGP4
ADDRLP4 44
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 0
NEI4 $295
line 386
;386:		cg.levelShot = qtrue;
ADDRGP4 cg+8
CNSTI4 1
ASGNI4
line 387
;387:		return;
ADDRGP4 $259
JUMPV
LABELV $295
line 390
;388:	}
;389:
;390:	CG_Printf( "Unknown client game command: %s\n", cmd );
ADDRGP4 $299
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 391
;391:}
LABELV $259
endproc CG_ServerCommand 48 12
export CG_ExecuteNewServerCommands
proc CG_ExecuteNewServerCommands 12 4
line 402
;392:
;393:
;394:/*
;395:====================
;396:CG_ExecuteNewServerCommands
;397:
;398:Execute all of the server commands that were received along
;399:with this this snapshot.
;400:====================
;401:*/
;402:void CG_ExecuteNewServerCommands( int latestSequence ) {
ADDRGP4 $302
JUMPV
LABELV $301
line 403
;403:	while ( cgs.serverCommandSequence < latestSequence ) {
line 404
;404:		if ( trap_GetServerCommand( ++cgs.serverCommandSequence ) ) {
ADDRLP4 0
ADDRGP4 cgs+24276
ASGNP4
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 trap_GetServerCommand
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
EQI4 $305
line 405
;405:			CG_ServerCommand();
ADDRGP4 CG_ServerCommand
CALLV
pop
line 406
;406:		}
LABELV $305
line 407
;407:	}
LABELV $302
line 403
ADDRGP4 cgs+24276
INDIRI4
ADDRFP4 0
INDIRI4
LTI4 $301
line 408
;408:}
LABELV $300
endproc CG_ExecuteNewServerCommands 12 4
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $299
byte 1 85
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 32
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 32
byte 1 99
byte 1 111
byte 1 109
byte 1 109
byte 1 97
byte 1 110
byte 1 100
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $297
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 76
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 83
byte 1 104
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $294
byte 1 108
byte 1 111
byte 1 97
byte 1 100
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $291
byte 1 109
byte 1 97
byte 1 112
byte 1 95
byte 1 114
byte 1 101
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $288
byte 1 116
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 0
align 1
LABELV $285
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $280
byte 1 116
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $277
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $274
byte 1 99
byte 1 104
byte 1 97
byte 1 116
byte 1 0
align 1
LABELV $271
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $270
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 0
align 1
LABELV $267
byte 1 99
byte 1 115
byte 1 0
align 1
LABELV $264
byte 1 99
byte 1 112
byte 1 0
align 1
LABELV $258
byte 1 70
byte 1 73
byte 1 71
byte 1 72
byte 1 84
byte 1 33
byte 1 0
align 1
LABELV $248
byte 1 67
byte 1 71
byte 1 95
byte 1 77
byte 1 97
byte 1 112
byte 1 82
byte 1 101
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $132
byte 1 109
byte 1 97
byte 1 112
byte 1 115
byte 1 47
byte 1 37
byte 1 115
byte 1 46
byte 1 98
byte 1 115
byte 1 112
byte 1 0
align 1
LABELV $129
byte 1 109
byte 1 97
byte 1 112
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $128
byte 1 115
byte 1 118
byte 1 95
byte 1 109
byte 1 97
byte 1 120
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 115
byte 1 0
align 1
LABELV $126
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 108
byte 1 105
byte 1 109
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $124
byte 1 99
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 101
byte 1 108
byte 1 105
byte 1 109
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $122
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 108
byte 1 105
byte 1 109
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $120
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 115
byte 1 0
align 1
LABELV $118
byte 1 100
byte 1 109
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 115
byte 1 0
align 1
LABELV $116
byte 1 103
byte 1 95
byte 1 103
byte 1 97
byte 1 109
byte 1 101
byte 1 116
byte 1 121
byte 1 112
byte 1 101
byte 1 0
