code
proc CG_DrawClientScore 1080 28
file "..\cg_scoreboard.c"
line 59
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_scoreboard -- draw the scoreboard on top of the game screen
;4:#include "cg_local.h"
;5:
;6:
;7:#define	SCOREBOARD_X		(16)
;8:
;9:#define SB_HEADER			86
;10:#define SB_TOP				(SB_HEADER+32)
;11:
;12:// Where the status bar starts, so we don't overwrite it
;13:#define SB_STATUSBAR		420
;14:
;15:#define SB_NORMAL_HEIGHT	40
;16:#define SB_INTER_HEIGHT		16 // interleaved height
;17:
;18:#define SB_MAXCLIENTS_NORMAL  ((SB_STATUSBAR - SB_TOP) / SB_NORMAL_HEIGHT)
;19:#define SB_MAXCLIENTS_INTER   ((SB_STATUSBAR - SB_TOP) / SB_INTER_HEIGHT - 1)
;20:
;21:// Used when interleaved
;22:
;23:
;24:
;25:#define SB_LEFT_BOTICON_X	(SCOREBOARD_X+0)
;26:#define SB_LEFT_HEAD_X		(SCOREBOARD_X+32)
;27:#define SB_RIGHT_BOTICON_X	(SCOREBOARD_X+64)
;28:#define SB_RIGHT_HEAD_X		(SCOREBOARD_X+96)
;29:// Normal
;30:#define SB_BOTICON_X		(SCOREBOARD_X+32)
;31:#define SB_HEAD_X			(SCOREBOARD_X+64)
;32:
;33:#define SB_SCORELINE_X		128
;34:
;35:#define SB_SCORE_X			(SB_SCORELINE_X + BIGCHAR_WIDTH) // width 6
;36:#define SB_PING_X			(SB_SCORELINE_X + 6 * BIGCHAR_WIDTH + 8) // width 5
;37:#define SB_TIME_X			(SB_SCORELINE_X + 11 * BIGCHAR_WIDTH + 8) // width 5
;38:#define SB_NAME_X			(SB_SCORELINE_X + 16 * BIGCHAR_WIDTH) // width 15
;39:
;40:// The new and improved score board
;41://
;42:// In cases where the number of clients is high, the score board heads are interleaved
;43:// here's the layout
;44:
;45://
;46://	0   32   80  112  144   240  320  400   <-- pixel position
;47://  bot head bot head score ping time name
;48://  
;49://  wins/losses are drawn on bot icon now
;50:
;51:static qboolean localClient; // true if local client has been displayed
;52:
;53:
;54:							 /*
;55:=================
;56:CG_DrawScoreboard
;57:=================
;58:*/
;59:static void CG_DrawClientScore( int y, score_t *score, float *color, float fade, qboolean largeFormat ) {
line 65
;60:	char	string[1024];
;61:	vec3_t	headAngles;
;62:	clientInfo_t	*ci;
;63:	int iconx, headx;
;64:
;65:	if ( score->client < 0 || score->client >= cgs.maxclients ) {
ADDRLP4 1048
ADDRFP4 4
INDIRP4
INDIRI4
ASGNI4
ADDRLP4 1048
INDIRI4
CNSTI4 0
LTI4 $64
ADDRLP4 1048
INDIRI4
ADDRGP4 cgs+24312
INDIRI4
LTI4 $61
LABELV $64
line 66
;66:		Com_Printf( "Bad score->client: %i\n", score->client );
ADDRGP4 $65
ARGP4
ADDRFP4 4
INDIRP4
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 67
;67:		return;
ADDRGP4 $60
JUMPV
LABELV $61
line 70
;68:	}
;69:	
;70:	ci = &cgs.clientinfo[score->client];
ADDRLP4 0
CNSTI4 1076
ADDRFP4 4
INDIRP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 72
;71:
;72:	iconx = SB_BOTICON_X;
ADDRLP4 1040
CNSTI4 48
ASGNI4
line 73
;73:	headx = SB_HEAD_X;
ADDRLP4 1044
CNSTI4 80
ASGNI4
line 76
;74:
;75:	// draw the handicap or bot skill marker (unless player has flag)
;76:	if ( ci->powerups & ( 1 << PW_REDFLAG ) ) {
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $67
line 77
;77:		if( largeFormat ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $69
line 78
;78:			CG_DrawFlagModel( iconx, y - ( 32 - BIGCHAR_HEIGHT ) / 2, 32, 32, TEAM_RED );
ADDRLP4 1040
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CNSTI4 8
SUBI4
CVIF4 4
ARGF4
ADDRLP4 1052
CNSTF4 1107296256
ASGNF4
ADDRLP4 1052
INDIRF4
ARGF4
ADDRLP4 1052
INDIRF4
ARGF4
CNSTI4 1
ARGI4
ADDRGP4 CG_DrawFlagModel
CALLV
pop
line 79
;79:		}
ADDRGP4 $68
JUMPV
LABELV $69
line 80
;80:		else {
line 81
;81:			CG_DrawFlagModel( iconx, y, 16, 16, TEAM_RED );
ADDRLP4 1040
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 1052
CNSTF4 1098907648
ASGNF4
ADDRLP4 1052
INDIRF4
ARGF4
ADDRLP4 1052
INDIRF4
ARGF4
CNSTI4 1
ARGI4
ADDRGP4 CG_DrawFlagModel
CALLV
pop
line 82
;82:		}
line 83
;83:	} else if ( ci->powerups & ( 1 << PW_BLUEFLAG ) ) {
ADDRGP4 $68
JUMPV
LABELV $67
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $71
line 84
;84:		if( largeFormat ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $73
line 85
;85:			CG_DrawFlagModel( iconx, y - ( 32 - BIGCHAR_HEIGHT ) / 2, 32, 32, TEAM_BLUE );
ADDRLP4 1040
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CNSTI4 8
SUBI4
CVIF4 4
ARGF4
ADDRLP4 1052
CNSTF4 1107296256
ASGNF4
ADDRLP4 1052
INDIRF4
ARGF4
ADDRLP4 1052
INDIRF4
ARGF4
CNSTI4 2
ARGI4
ADDRGP4 CG_DrawFlagModel
CALLV
pop
line 86
;86:		}
ADDRGP4 $72
JUMPV
LABELV $73
line 87
;87:		else {
line 88
;88:			CG_DrawFlagModel( iconx, y, 16, 16, TEAM_BLUE );
ADDRLP4 1040
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 1052
CNSTF4 1098907648
ASGNF4
ADDRLP4 1052
INDIRF4
ARGF4
ADDRLP4 1052
INDIRF4
ARGF4
CNSTI4 2
ARGI4
ADDRGP4 CG_DrawFlagModel
CALLV
pop
line 89
;89:		}
line 90
;90:	} else {
ADDRGP4 $72
JUMPV
LABELV $71
line 91
;91:		if ( ci->botSkill > 0 && ci->botSkill <= 5 ) {
ADDRLP4 1052
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 0
LEI4 $75
ADDRLP4 1052
INDIRI4
CNSTI4 5
GTI4 $75
line 92
;92:			if ( cg_drawIcons.integer ) {
ADDRGP4 cg_drawIcons+12
INDIRI4
CNSTI4 0
EQI4 $76
line 93
;93:				if( largeFormat ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $80
line 94
;94:					CG_DrawPic( iconx, y - ( 32 - BIGCHAR_HEIGHT ) / 2, 32, 32, cgs.media.botSkillShaders[ ci->botSkill - 1 ] );
ADDRLP4 1040
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CNSTI4 8
SUBI4
CVIF4 4
ARGF4
ADDRLP4 1056
CNSTF4 1107296256
ASGNF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+276-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 95
;95:				}
ADDRGP4 $76
JUMPV
LABELV $80
line 96
;96:				else {
line 97
;97:					CG_DrawPic( iconx, y, 16, 16, cgs.media.botSkillShaders[ ci->botSkill - 1 ] );
ADDRLP4 1040
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 1056
CNSTF4 1098907648
ASGNF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+276-4
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 98
;98:				}
line 99
;99:			}
line 100
;100:		} else if ( ci->handicap < 100 ) {
ADDRGP4 $76
JUMPV
LABELV $75
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 100
GEI4 $88
line 101
;101:			Com_sprintf( string, sizeof( string ), "%i", ci->handicap );
ADDRLP4 16
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $90
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 102
;102:			if ( cgs.gametype == GT_TOURNAMENT )
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 1
NEI4 $91
line 103
;103:				CG_DrawSmallStringColor( iconx, y - SMALLCHAR_HEIGHT/2, string, color );
ADDRLP4 1040
INDIRI4
ARGI4
ADDRFP4 0
INDIRI4
CNSTI4 8
SUBI4
ARGI4
ADDRLP4 16
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_DrawSmallStringColor
CALLV
pop
ADDRGP4 $92
JUMPV
LABELV $91
line 105
;104:			else
;105:				CG_DrawSmallStringColor( iconx, y, string, color );
ADDRLP4 1040
INDIRI4
ARGI4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 16
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_DrawSmallStringColor
CALLV
pop
LABELV $92
line 106
;106:		}
LABELV $88
LABELV $76
line 109
;107:
;108:		// draw the wins / losses
;109:		if ( cgs.gametype == GT_TOURNAMENT ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 1
NEI4 $94
line 110
;110:			Com_sprintf( string, sizeof( string ), "%i/%i", ci->wins, ci->losses );
ADDRLP4 16
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $97
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 111
;111:			if( ci->handicap < 100 && !ci->botSkill ) {
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 100
GEI4 $98
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 0
NEI4 $98
line 112
;112:				CG_DrawSmallStringColor( iconx, y + SMALLCHAR_HEIGHT/2, string, color );
ADDRLP4 1040
INDIRI4
ARGI4
ADDRFP4 0
INDIRI4
CNSTI4 8
ADDI4
ARGI4
ADDRLP4 16
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_DrawSmallStringColor
CALLV
pop
line 113
;113:			}
ADDRGP4 $99
JUMPV
LABELV $98
line 114
;114:			else {
line 115
;115:				CG_DrawSmallStringColor( iconx, y, string, color );
ADDRLP4 1040
INDIRI4
ARGI4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 16
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_DrawSmallStringColor
CALLV
pop
line 116
;116:			}
LABELV $99
line 117
;117:		}
LABELV $94
line 118
;118:	}
LABELV $72
LABELV $68
line 121
;119:
;120:	// draw the face
;121:	VectorClear( headAngles );
ADDRLP4 1052
CNSTF4 0
ASGNF4
ADDRLP4 4+8
ADDRLP4 1052
INDIRF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 1052
INDIRF4
ASGNF4
ADDRLP4 4
ADDRLP4 1052
INDIRF4
ASGNF4
line 122
;122:	headAngles[YAW] = 180;
ADDRLP4 4+4
CNSTF4 1127481344
ASGNF4
line 123
;123:	if( largeFormat ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $103
line 124
;124:		CG_DrawHead( headx, y - ( ICON_SIZE - BIGCHAR_HEIGHT ) / 2, ICON_SIZE, ICON_SIZE, 
ADDRLP4 1044
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CNSTI4 16
SUBI4
CVIF4 4
ARGF4
ADDRLP4 1056
CNSTF4 1111490560
ASGNF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRFP4 4
INDIRP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 CG_DrawHead
CALLV
pop
line 126
;125:			score->client, headAngles );
;126:	}
ADDRGP4 $104
JUMPV
LABELV $103
line 127
;127:	else {
line 128
;128:		CG_DrawHead( headx, y, 16, 16, score->client, headAngles );
ADDRLP4 1044
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 1056
CNSTF4 1098907648
ASGNF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRLP4 1056
INDIRF4
ARGF4
ADDRFP4 4
INDIRP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 CG_DrawHead
CALLV
pop
line 129
;129:	}
LABELV $104
line 132
;130:
;131:	// draw the score line
;132:	if ( score->ping == -1 ) {
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $105
line 133
;133:		Com_sprintf(string, sizeof(string),
ADDRLP4 16
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $107
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 135
;134:			" connecting    %s", ci->name);
;135:	} else if ( ci->team == TEAM_SPECTATOR ) {
ADDRGP4 $106
JUMPV
LABELV $105
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 3
NEI4 $108
line 136
;136:		Com_sprintf(string, sizeof(string),
ADDRLP4 16
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $110
ARGP4
ADDRLP4 1056
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 1056
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 1056
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 138
;137:			" SPECT %3i %4i %s", score->ping, score->time, ci->name);
;138:	} else {
ADDRGP4 $109
JUMPV
LABELV $108
line 139
;139:		Com_sprintf(string, sizeof(string),
ADDRLP4 16
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 $111
ARGP4
ADDRLP4 1056
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 1060
CNSTI4 4
ASGNI4
ADDRLP4 1056
INDIRP4
ADDRLP4 1060
INDIRI4
ADDP4
INDIRI4
ARGI4
ADDRLP4 1056
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 1056
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
ADDRLP4 1060
INDIRI4
ADDP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 141
;140:			"%5i %4i %4i %s", score->score, score->ping, score->time, ci->name);
;141:	}
LABELV $109
LABELV $106
line 144
;142:
;143:	// highlight your position
;144:	if ( score->client == cg.snap->ps.clientNum ) {
ADDRFP4 4
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $112
line 148
;145:		float	hcolor[4];
;146:		int		rank;
;147:
;148:		localClient = qtrue;
ADDRGP4 localClient
CNSTI4 1
ASGNI4
line 150
;149:
;150:		if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR 
ADDRLP4 1076
CNSTI4 3
ASGNI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
ADDRLP4 1076
INDIRI4
EQI4 $119
ADDRGP4 cgs+24288
INDIRI4
ADDRLP4 1076
INDIRI4
LTI4 $115
LABELV $119
line 151
;151:			|| cgs.gametype >= GT_TEAM ) {
line 152
;152:			rank = -1;
ADDRLP4 1072
CNSTI4 -1
ASGNI4
line 153
;153:		} else {
ADDRGP4 $116
JUMPV
LABELV $115
line 154
;154:			rank = cg.snap->ps.persistant[PERS_RANK] & ~RANK_TIED_FLAG;
ADDRLP4 1072
ADDRGP4 cg+32
INDIRP4
CNSTI4 300
ADDP4
INDIRI4
CNSTI4 -16385
BANDI4
ASGNI4
line 155
;155:		}
LABELV $116
line 156
;156:		if ( rank == 0 ) {
ADDRLP4 1072
INDIRI4
CNSTI4 0
NEI4 $121
line 157
;157:			hcolor[0] = 0;
ADDRLP4 1056
CNSTF4 0
ASGNF4
line 158
;158:			hcolor[1] = 0;
ADDRLP4 1056+4
CNSTF4 0
ASGNF4
line 159
;159:			hcolor[2] = 0.7;
ADDRLP4 1056+8
CNSTF4 1060320051
ASGNF4
line 160
;160:		} else if ( rank == 1 ) {
ADDRGP4 $122
JUMPV
LABELV $121
ADDRLP4 1072
INDIRI4
CNSTI4 1
NEI4 $125
line 161
;161:			hcolor[0] = 0.7;
ADDRLP4 1056
CNSTF4 1060320051
ASGNF4
line 162
;162:			hcolor[1] = 0;
ADDRLP4 1056+4
CNSTF4 0
ASGNF4
line 163
;163:			hcolor[2] = 0;
ADDRLP4 1056+8
CNSTF4 0
ASGNF4
line 164
;164:		} else if ( rank == 2 ) {
ADDRGP4 $126
JUMPV
LABELV $125
ADDRLP4 1072
INDIRI4
CNSTI4 2
NEI4 $129
line 165
;165:			hcolor[0] = 0.7;
ADDRLP4 1056
CNSTF4 1060320051
ASGNF4
line 166
;166:			hcolor[1] = 0.7;
ADDRLP4 1056+4
CNSTF4 1060320051
ASGNF4
line 167
;167:			hcolor[2] = 0;
ADDRLP4 1056+8
CNSTF4 0
ASGNF4
line 168
;168:		} else {
ADDRGP4 $130
JUMPV
LABELV $129
line 169
;169:			hcolor[0] = 0.7;
ADDRLP4 1056
CNSTF4 1060320051
ASGNF4
line 170
;170:			hcolor[1] = 0.7;
ADDRLP4 1056+4
CNSTF4 1060320051
ASGNF4
line 171
;171:			hcolor[2] = 0.7;
ADDRLP4 1056+8
CNSTF4 1060320051
ASGNF4
line 172
;172:		}
LABELV $130
LABELV $126
LABELV $122
line 174
;173:
;174:		hcolor[3] = fade * 0.7;
ADDRLP4 1056+12
CNSTF4 1060320051
ADDRFP4 12
INDIRF4
MULF4
ASGNF4
line 175
;175:		CG_FillRect( SB_SCORELINE_X + BIGCHAR_WIDTH, y, 
CNSTF4 1125122048
ARGF4
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1140326400
ARGF4
CNSTF4 1099431936
ARGF4
ADDRLP4 1056
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 177
;176:			640 - SB_SCORELINE_X - BIGCHAR_WIDTH, BIGCHAR_HEIGHT+1, hcolor );
;177:	}
LABELV $112
line 179
;178:
;179:	CG_DrawBigString( SB_SCORELINE_X, y, string, fade );
CNSTI4 128
ARGI4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 16
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 182
;180:
;181:	// add the "ready" marker for intermission exiting
;182:	if ( cg.snap->ps.stats[ STAT_CLIENTS_READY ] & ( 1 << score->client ) ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
CNSTI4 1
ADDRFP4 4
INDIRP4
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $136
line 183
;183:		CG_DrawBigStringColor( iconx, y, "READY", color );
ADDRLP4 1040
INDIRI4
ARGI4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 $139
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 CG_DrawBigStringColor
CALLV
pop
line 184
;184:	}
LABELV $136
line 185
;185:}
LABELV $60
endproc CG_DrawClientScore 1080 28
proc CG_TeamScoreboard 44 20
line 192
;186:
;187:/*
;188:=================
;189:CG_TeamScoreboard
;190:=================
;191:*/
;192:static int CG_TeamScoreboard( int y, team_t team, float fade, int maxClients, int lineHeight ) {
line 199
;193:	int		i;
;194:	score_t	*score;
;195:	float	color[4];
;196:	int		count;
;197:	clientInfo_t	*ci;
;198:
;199:	color[0] = color[1] = color[2] = 1.0;
ADDRLP4 32
CNSTF4 1065353216
ASGNF4
ADDRLP4 16+8
ADDRLP4 32
INDIRF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 32
INDIRF4
ASGNF4
ADDRLP4 16
ADDRLP4 32
INDIRF4
ASGNF4
line 200
;200:	color[3] = fade;
ADDRLP4 16+12
ADDRFP4 8
INDIRF4
ASGNF4
line 202
;201:
;202:	count = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 204
;203:
;204:	for ( i = 0 ; i < cg.numScores && count < maxClients ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $147
JUMPV
LABELV $144
line 205
;205:		score = &cg.scores[i];
ADDRLP4 8
CNSTI4 20
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cg+108232
ADDP4
ASGNP4
line 206
;206:		ci = &cgs.clientinfo[ score->client ];
ADDRLP4 12
CNSTI4 1076
ADDRLP4 8
INDIRP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 208
;207:
;208:		if ( team != ci->team ) {
ADDRFP4 4
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
EQI4 $151
line 209
;209:			continue;
ADDRGP4 $145
JUMPV
LABELV $151
line 212
;210:		}
;211:
;212:		CG_DrawClientScore( y + lineHeight * count, score, color, fade, lineHeight == SB_NORMAL_HEIGHT );
ADDRLP4 40
ADDRFP4 16
INDIRI4
ASGNI4
ADDRFP4 0
INDIRI4
ADDRLP4 40
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
ADDI4
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 16
ARGP4
ADDRFP4 8
INDIRF4
ARGF4
ADDRLP4 40
INDIRI4
CNSTI4 40
NEI4 $154
ADDRLP4 36
CNSTI4 1
ASGNI4
ADDRGP4 $155
JUMPV
LABELV $154
ADDRLP4 36
CNSTI4 0
ASGNI4
LABELV $155
ADDRLP4 36
INDIRI4
ARGI4
ADDRGP4 CG_DrawClientScore
CALLV
pop
line 214
;213:
;214:		count++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 215
;215:	}
LABELV $145
line 204
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $147
ADDRLP4 4
INDIRI4
ADDRGP4 cg+108220
INDIRI4
GEI4 $156
ADDRLP4 0
INDIRI4
ADDRFP4 12
INDIRI4
LTI4 $144
LABELV $156
line 217
;216:
;217:	return count;
ADDRLP4 0
INDIRI4
RETI4
LABELV $140
endproc CG_TeamScoreboard 44 20
export CG_DrawScoreboard
proc CG_DrawScoreboard 68 24
line 227
;218:}
;219:
;220:/*
;221:=================
;222:CG_DrawScoreboard
;223:
;224:Draw the normal in-game scoreboard
;225:=================
;226:*/
;227:qboolean CG_DrawScoreboard( void ) {
line 237
;228:	int		x, y, w, i, n1, n2;
;229:	float	fade;
;230:	float	*fadeColor;
;231:	char	*s;
;232:	int maxClients;
;233:	int lineHeight;
;234:	int topBorderSize, bottomBorderSize;
;235:
;236:	// don't draw amuthing if the menu or console is up
;237:	if ( cg_paused.integer ) {
ADDRGP4 cg_paused+12
INDIRI4
CNSTI4 0
EQI4 $158
line 238
;238:		cg.deferredPlayerLoading = 0;
ADDRGP4 cg+12
CNSTI4 0
ASGNI4
line 239
;239:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $157
JUMPV
LABELV $158
line 242
;240:	}
;241:
;242:	if ( cgs.gametype == GT_SINGLE_PLAYER && cg.predictedPlayerState.pm_type == PM_INTERMISSION ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 2
NEI4 $162
ADDRGP4 cg+105532+4
INDIRI4
CNSTI4 5
NEI4 $162
line 243
;243:		cg.deferredPlayerLoading = 0;
ADDRGP4 cg+12
CNSTI4 0
ASGNI4
line 244
;244:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $157
JUMPV
LABELV $162
line 248
;245:	}
;246:
;247:	// don't draw scoreboard during death while warmup up
;248:	if ( cg.warmup && !cg.showScores ) {
ADDRLP4 52
CNSTI4 0
ASGNI4
ADDRGP4 cg+111912
INDIRI4
ADDRLP4 52
INDIRI4
EQI4 $168
ADDRGP4 cg+110792
INDIRI4
ADDRLP4 52
INDIRI4
NEI4 $168
line 249
;249:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $157
JUMPV
LABELV $168
line 252
;250:	}
;251:
;252:	if ( cg.showScores || cg.predictedPlayerState.pm_type == PM_DEAD ||
ADDRGP4 cg+110792
INDIRI4
CNSTI4 0
NEI4 $180
ADDRGP4 cg+105532+4
INDIRI4
CNSTI4 3
EQI4 $180
ADDRGP4 cg+105532+4
INDIRI4
CNSTI4 5
NEI4 $172
LABELV $180
line 253
;253:		 cg.predictedPlayerState.pm_type == PM_INTERMISSION ) {
line 254
;254:		fade = 1.0;
ADDRLP4 12
CNSTF4 1065353216
ASGNF4
line 255
;255:		fadeColor = colorWhite;
ADDRLP4 20
ADDRGP4 colorWhite
ASGNP4
line 256
;256:	} else {
ADDRGP4 $173
JUMPV
LABELV $172
line 257
;257:		fadeColor = CG_FadeColor( cg.scoreFadeTime, FADE_TIME );
ADDRGP4 cg+110796
INDIRI4
ARGI4
CNSTI4 200
ARGI4
ADDRLP4 56
ADDRGP4 CG_FadeColor
CALLP4
ASGNP4
ADDRLP4 20
ADDRLP4 56
INDIRP4
ASGNP4
line 259
;258:		
;259:		if ( !fadeColor ) {
ADDRLP4 20
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $182
line 261
;260:			// next time scoreboard comes up, don't print killer
;261:			cg.deferredPlayerLoading = 0;
ADDRGP4 cg+12
CNSTI4 0
ASGNI4
line 262
;262:			cg.killerName[0] = 0;
ADDRGP4 cg+110800
CNSTI1 0
ASGNI1
line 263
;263:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $157
JUMPV
LABELV $182
line 265
;264:		}
;265:		fade = *fadeColor;
ADDRLP4 12
ADDRLP4 20
INDIRP4
INDIRF4
ASGNF4
line 266
;266:	}
LABELV $173
line 270
;267:
;268:
;269:	// fragged by ... line
;270:	if ( cg.killerName[0] ) {
ADDRGP4 cg+110800
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $186
line 271
;271:		s = va("Fragged by %s", cg.killerName );
ADDRGP4 $189
ARGP4
ADDRGP4 cg+110800
ARGP4
ADDRLP4 56
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 56
INDIRP4
ASGNP4
line 272
;272:		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 60
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 60
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 273
;273:		x = ( SCREEN_WIDTH - w ) / 2;
ADDRLP4 36
CNSTI4 640
ADDRLP4 40
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 274
;274:		y = 40;
ADDRLP4 4
CNSTI4 40
ASGNI4
line 275
;275:		CG_DrawBigString( x, y, s, fade );
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 12
INDIRF4
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 276
;276:	}
LABELV $186
line 279
;277:
;278:	// current rank
;279:	if ( cgs.gametype < GT_TEAM) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
GEI4 $191
line 280
;280:		if (cg.snap->ps.persistant[PERS_TEAM] != TEAM_SPECTATOR ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
EQI4 $192
line 281
;281:			s = va("%s place with %i",
ADDRGP4 cg+32
INDIRP4
CNSTI4 300
ADDP4
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_PlaceString
CALLP4
ASGNP4
ADDRGP4 $197
ARGP4
ADDRLP4 56
INDIRP4
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 292
ADDP4
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 60
INDIRP4
ASGNP4
line 284
;282:				CG_PlaceString( cg.snap->ps.persistant[PERS_RANK] + 1 ),
;283:				cg.snap->ps.persistant[PERS_SCORE] );
;284:			w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 64
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 285
;285:			x = ( SCREEN_WIDTH - w ) / 2;
ADDRLP4 36
CNSTI4 640
ADDRLP4 40
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 286
;286:			y = 60;
ADDRLP4 4
CNSTI4 60
ASGNI4
line 287
;287:			CG_DrawBigString( x, y, s, fade );
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 12
INDIRF4
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 288
;288:		}
line 289
;289:	} else {
ADDRGP4 $192
JUMPV
LABELV $191
line 290
;290:		if ( cg.teamScores[0] == cg.teamScores[1] ) {
ADDRGP4 cg+108224
INDIRI4
ADDRGP4 cg+108224+4
INDIRI4
NEI4 $200
line 291
;291:			s = va("Teams are tied at %i", cg.teamScores[0] );
ADDRGP4 $205
ARGP4
ADDRGP4 cg+108224
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 56
INDIRP4
ASGNP4
line 292
;292:		} else if ( cg.teamScores[0] >= cg.teamScores[1] ) {
ADDRGP4 $201
JUMPV
LABELV $200
ADDRGP4 cg+108224
INDIRI4
ADDRGP4 cg+108224+4
INDIRI4
LTI4 $207
line 293
;293:			s = va("Red leads %i to %i",cg.teamScores[0], cg.teamScores[1] );
ADDRGP4 $212
ARGP4
ADDRGP4 cg+108224
INDIRI4
ARGI4
ADDRGP4 cg+108224+4
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 56
INDIRP4
ASGNP4
line 294
;294:		} else {
ADDRGP4 $208
JUMPV
LABELV $207
line 295
;295:			s = va("Blue leads %i to %i",cg.teamScores[1], cg.teamScores[0] );
ADDRGP4 $216
ARGP4
ADDRGP4 cg+108224+4
INDIRI4
ARGI4
ADDRGP4 cg+108224
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 56
INDIRP4
ASGNP4
line 296
;296:		}
LABELV $208
LABELV $201
line 298
;297:
;298:		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 56
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 299
;299:		x = ( SCREEN_WIDTH - w ) / 2;
ADDRLP4 36
CNSTI4 640
ADDRLP4 40
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 300
;300:		y = 60;
ADDRLP4 4
CNSTI4 60
ASGNI4
line 301
;301:		CG_DrawBigString( x, y, s, fade );
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 12
INDIRF4
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 302
;302:	}
LABELV $192
line 305
;303:
;304:	// scoreboard
;305:	y = SB_HEADER;
ADDRLP4 4
CNSTI4 86
ASGNI4
line 307
;306:
;307:	CG_DrawPic( SB_SCORE_X, y, 64, 32, cgs.media.scoreboardScore );
CNSTF4 1125122048
ARGF4
ADDRLP4 4
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1115684864
ARGF4
CNSTF4 1107296256
ARGF4
ADDRGP4 cgs+170516+420
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 308
;308:	CG_DrawPic( SB_PING_X, y, 64, 32, cgs.media.scoreboardPing );
CNSTF4 1130889216
ARGF4
ADDRLP4 4
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1115684864
ARGF4
CNSTF4 1107296256
ARGF4
ADDRGP4 cgs+170516+416
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 309
;309:	CG_DrawPic( SB_TIME_X, y, 64, 32, cgs.media.scoreboardTime );
CNSTF4 1134297088
ARGF4
ADDRLP4 4
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1115684864
ARGF4
CNSTF4 1107296256
ARGF4
ADDRGP4 cgs+170516+424
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 310
;310:	CG_DrawPic( SB_NAME_X, y, 64, 32, cgs.media.scoreboardName );
CNSTF4 1136656384
ARGF4
ADDRLP4 4
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1115684864
ARGF4
CNSTF4 1107296256
ARGF4
ADDRGP4 cgs+170516+412
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 313
;311:
;312:
;313:	y = SB_TOP;
ADDRLP4 4
CNSTI4 118
ASGNI4
line 316
;314:
;315:	// If there are more than SB_MAXCLIENTS_NORMAL, use the interleaved scores
;316:	if ( cg.numScores > SB_MAXCLIENTS_NORMAL ) {
ADDRGP4 cg+108220
INDIRI4
CNSTI4 7
LEI4 $228
line 317
;317:		maxClients = SB_MAXCLIENTS_INTER;
ADDRLP4 24
CNSTI4 17
ASGNI4
line 318
;318:		lineHeight = SB_INTER_HEIGHT;
ADDRLP4 8
CNSTI4 16
ASGNI4
line 319
;319:		topBorderSize = 8;
ADDRLP4 44
CNSTI4 8
ASGNI4
line 320
;320:		bottomBorderSize = 16;
ADDRLP4 48
CNSTI4 16
ASGNI4
line 321
;321:	} else {
ADDRGP4 $229
JUMPV
LABELV $228
line 322
;322:		maxClients = SB_MAXCLIENTS_NORMAL;
ADDRLP4 24
CNSTI4 7
ASGNI4
line 323
;323:		lineHeight = SB_NORMAL_HEIGHT;
ADDRLP4 8
CNSTI4 40
ASGNI4
line 324
;324:		topBorderSize = 16;
ADDRLP4 44
CNSTI4 16
ASGNI4
line 325
;325:		bottomBorderSize = 16;
ADDRLP4 48
CNSTI4 16
ASGNI4
line 326
;326:	}
LABELV $229
line 328
;327:
;328:	localClient = qfalse;
ADDRGP4 localClient
CNSTI4 0
ASGNI4
line 330
;329:
;330:	if ( cgs.gametype >= GT_TEAM ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $231
line 334
;331:		//
;332:		// teamplay scoreboard
;333:		//
;334:		y += lineHeight/2;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRI4
CNSTI4 2
DIVI4
ADDI4
ASGNI4
line 336
;335:
;336:		if ( cg.teamScores[0] >= cg.teamScores[1] ) {
ADDRGP4 cg+108224
INDIRI4
ADDRGP4 cg+108224+4
INDIRI4
LTI4 $234
line 337
;337:			n1 = CG_TeamScoreboard( y, TEAM_RED, fade, maxClients, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 56
INDIRI4
ASGNI4
line 338
;338:			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n1 * lineHeight + bottomBorderSize, 0.33, TEAM_RED );
CNSTI4 0
ARGI4
ADDRLP4 4
INDIRI4
ADDRLP4 44
INDIRI4
SUBI4
ARGI4
CNSTI4 640
ARGI4
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
ADDRLP4 48
INDIRI4
ADDI4
ARGI4
CNSTF4 1051260355
ARGF4
CNSTI4 1
ARGI4
ADDRGP4 CG_DrawTeamBackground
CALLV
pop
line 339
;339:			y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 340
;340:			maxClients -= n1;
ADDRLP4 24
ADDRLP4 24
INDIRI4
ADDRLP4 16
INDIRI4
SUBI4
ASGNI4
line 341
;341:			n2 = CG_TeamScoreboard( y, TEAM_BLUE, fade, maxClients, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 60
INDIRI4
ASGNI4
line 342
;342:			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n2 * lineHeight + bottomBorderSize, 0.33, TEAM_BLUE );
CNSTI4 0
ARGI4
ADDRLP4 4
INDIRI4
ADDRLP4 44
INDIRI4
SUBI4
ARGI4
CNSTI4 640
ARGI4
ADDRLP4 32
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
ADDRLP4 48
INDIRI4
ADDI4
ARGI4
CNSTF4 1051260355
ARGF4
CNSTI4 2
ARGI4
ADDRGP4 CG_DrawTeamBackground
CALLV
pop
line 343
;343:			y += (n2 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 32
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 344
;344:			maxClients -= n2;
ADDRLP4 24
ADDRLP4 24
INDIRI4
ADDRLP4 32
INDIRI4
SUBI4
ASGNI4
line 345
;345:		} else {
ADDRGP4 $235
JUMPV
LABELV $234
line 346
;346:			n1 = CG_TeamScoreboard( y, TEAM_BLUE, fade, maxClients, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 56
INDIRI4
ASGNI4
line 347
;347:			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n1 * lineHeight + bottomBorderSize, 0.33, TEAM_BLUE );
CNSTI4 0
ARGI4
ADDRLP4 4
INDIRI4
ADDRLP4 44
INDIRI4
SUBI4
ARGI4
CNSTI4 640
ARGI4
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
ADDRLP4 48
INDIRI4
ADDI4
ARGI4
CNSTF4 1051260355
ARGF4
CNSTI4 2
ARGI4
ADDRGP4 CG_DrawTeamBackground
CALLV
pop
line 348
;348:			y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 349
;349:			maxClients -= n1;
ADDRLP4 24
ADDRLP4 24
INDIRI4
ADDRLP4 16
INDIRI4
SUBI4
ASGNI4
line 350
;350:			n2 = CG_TeamScoreboard( y, TEAM_RED, fade, maxClients, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 60
INDIRI4
ASGNI4
line 351
;351:			CG_DrawTeamBackground( 0, y - topBorderSize, 640, n2 * lineHeight + bottomBorderSize, 0.33, TEAM_RED );
CNSTI4 0
ARGI4
ADDRLP4 4
INDIRI4
ADDRLP4 44
INDIRI4
SUBI4
ARGI4
CNSTI4 640
ARGI4
ADDRLP4 32
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
ADDRLP4 48
INDIRI4
ADDI4
ARGI4
CNSTF4 1051260355
ARGF4
CNSTI4 1
ARGI4
ADDRGP4 CG_DrawTeamBackground
CALLV
pop
line 352
;352:			y += (n2 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 32
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 353
;353:			maxClients -= n2;
ADDRLP4 24
ADDRLP4 24
INDIRI4
ADDRLP4 32
INDIRI4
SUBI4
ASGNI4
line 354
;354:		}
LABELV $235
line 355
;355:		n1 = CG_TeamScoreboard( y, TEAM_SPECTATOR, fade, maxClients, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 56
INDIRI4
ASGNI4
line 356
;356:		y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 358
;357:
;358:	} else {
ADDRGP4 $232
JUMPV
LABELV $231
line 362
;359:		//
;360:		// free for all scoreboard
;361:		//
;362:		n1 = CG_TeamScoreboard( y, TEAM_FREE, fade, maxClients, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 56
INDIRI4
ASGNI4
line 363
;363:		y += (n1 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 364
;364:		n2 = CG_TeamScoreboard( y, TEAM_SPECTATOR, fade, maxClients - n1, lineHeight );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRI4
ADDRLP4 16
INDIRI4
SUBI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 CG_TeamScoreboard
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 60
INDIRI4
ASGNI4
line 365
;365:		y += (n2 * lineHeight) + BIGCHAR_HEIGHT;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 32
INDIRI4
ADDRLP4 8
INDIRI4
MULI4
CNSTI4 16
ADDI4
ADDI4
ASGNI4
line 366
;366:	}
LABELV $232
line 368
;367:
;368:	if (!localClient) {
ADDRGP4 localClient
INDIRI4
CNSTI4 0
NEI4 $239
line 370
;369:		// draw local client at the bottom
;370:		for ( i = 0 ; i < cg.numScores ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $244
JUMPV
LABELV $241
line 371
;371:			if ( cg.scores[i].client == cg.snap->ps.clientNum ) {
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232
ADDP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $246
line 372
;372:				CG_DrawClientScore( y, &cg.scores[i], fadeColor, fade, lineHeight == SB_NORMAL_HEIGHT );
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 20
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg+108232
ADDP4
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 8
INDIRI4
CNSTI4 40
NEI4 $252
ADDRLP4 56
CNSTI4 1
ASGNI4
ADDRGP4 $253
JUMPV
LABELV $252
ADDRLP4 56
CNSTI4 0
ASGNI4
LABELV $253
ADDRLP4 56
INDIRI4
ARGI4
ADDRGP4 CG_DrawClientScore
CALLV
pop
line 373
;373:				break;
ADDRGP4 $243
JUMPV
LABELV $246
line 375
;374:			}
;375:		}
LABELV $242
line 370
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $244
ADDRLP4 0
INDIRI4
ADDRGP4 cg+108220
INDIRI4
LTI4 $241
LABELV $243
line 376
;376:	}
LABELV $239
line 379
;377:
;378:	// load any models that have been deferred
;379:	if ( ++cg.deferredPlayerLoading > 10 ) {
ADDRLP4 56
ADDRGP4 cg+12
ASGNP4
ADDRLP4 60
ADDRLP4 56
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 56
INDIRP4
ADDRLP4 60
INDIRI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 10
LEI4 $254
line 380
;380:		CG_LoadDeferredPlayers();
ADDRGP4 CG_LoadDeferredPlayers
CALLV
pop
line 381
;381:	}
LABELV $254
line 383
;382:
;383:	return qtrue;
CNSTI4 1
RETI4
LABELV $157
endproc CG_DrawScoreboard 68 24
proc CG_CenterGiantLine 28 36
line 393
;384:}
;385:
;386://================================================================================
;387:
;388:/*
;389:================
;390:CG_CenterGiantLine
;391:================
;392:*/
;393:static void CG_CenterGiantLine( float y, const char *string ) {
line 397
;394:	float		x;
;395:	vec4_t		color;
;396:
;397:	color[0] = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 398
;398:	color[1] = 1;
ADDRLP4 0+4
CNSTF4 1065353216
ASGNF4
line 399
;399:	color[2] = 1;
ADDRLP4 0+8
CNSTF4 1065353216
ASGNF4
line 400
;400:	color[3] = 1;
ADDRLP4 0+12
CNSTF4 1065353216
ASGNF4
line 402
;401:
;402:	x = 0.5 * ( 640 - GIANT_WIDTH * CG_DrawStrlen( string ) );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
CNSTF4 1056964608
CNSTI4 640
ADDRLP4 20
INDIRI4
CNSTI4 5
LSHI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 404
;403:
;404:	CG_DrawStringExt( x, y, string, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
ADDRLP4 16
INDIRF4
CVFI4 4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 24
CNSTI4 1
ASGNI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 405
;405:}
LABELV $257
endproc CG_CenterGiantLine 28 36
export CG_DrawTourneyScoreboard
proc CG_DrawTourneyScoreboard 92 36
line 414
;406:
;407:/*
;408:=================
;409:CG_DrawTourneyScoreboard
;410:
;411:Draw the oversize scoreboard for tournements
;412:=================
;413:*/
;414:void CG_DrawTourneyScoreboard( void ) {
line 423
;415:	const char		*s;
;416:	vec4_t			color;
;417:	int				min, tens, ones;
;418:	clientInfo_t	*ci;
;419:	int				y;
;420:	int				i;
;421:
;422:	// request more scores regularly
;423:	if ( cg.scoresRequestTime + 2000 < cg.time ) {
ADDRGP4 cg+108216
INDIRI4
CNSTI4 2000
ADDI4
ADDRGP4 cg+105504
INDIRI4
GEI4 $262
line 424
;424:		cg.scoresRequestTime = cg.time;
ADDRGP4 cg+108216
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 425
;425:		trap_SendClientCommand( "score" );
ADDRGP4 $268
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 426
;426:	}
LABELV $262
line 428
;427:
;428:	color[0] = 1;
ADDRLP4 8
CNSTF4 1065353216
ASGNF4
line 429
;429:	color[1] = 1;
ADDRLP4 8+4
CNSTF4 1065353216
ASGNF4
line 430
;430:	color[2] = 1;
ADDRLP4 8+8
CNSTF4 1065353216
ASGNF4
line 431
;431:	color[3] = 1;
ADDRLP4 8+12
CNSTF4 1065353216
ASGNF4
line 434
;432:
;433:	// draw the dialog background
;434:	color[0] = color[1] = color[2] = 0;
ADDRLP4 44
CNSTF4 0
ASGNF4
ADDRLP4 8+8
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 8+4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 8
ADDRLP4 44
INDIRF4
ASGNF4
line 435
;435:	color[3] = 1;
ADDRLP4 8+12
CNSTF4 1065353216
ASGNF4
line 436
;436:	CG_FillRect( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, color );
ADDRLP4 48
CNSTF4 0
ASGNF4
ADDRLP4 48
INDIRF4
ARGF4
ADDRLP4 48
INDIRF4
ARGF4
CNSTF4 1142947840
ARGF4
CNSTF4 1139802112
ARGF4
ADDRLP4 8
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 439
;437:
;438:	// print the mesage of the day
;439:	s = CG_ConfigString( CS_MOTD );
CNSTI4 4
ARGI4
ADDRLP4 52
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 52
INDIRP4
ASGNP4
line 440
;440:	if ( !s[0] ) {
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $275
line 441
;441:		s = "Scoreboard";
ADDRLP4 4
ADDRGP4 $277
ASGNP4
line 442
;442:	}
LABELV $275
line 445
;443:
;444:	// print optional title
;445:	CG_CenterGiantLine( 8, s );
CNSTF4 1090519040
ARGF4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 CG_CenterGiantLine
CALLV
pop
line 448
;446:
;447:	// print server time
;448:	ones = cg.time / 1000;
ADDRLP4 32
ADDRGP4 cg+105504
INDIRI4
CNSTI4 1000
DIVI4
ASGNI4
line 449
;449:	min = ones / 60;
ADDRLP4 36
ADDRLP4 32
INDIRI4
CNSTI4 60
DIVI4
ASGNI4
line 450
;450:	ones %= 60;
ADDRLP4 32
ADDRLP4 32
INDIRI4
CNSTI4 60
MODI4
ASGNI4
line 451
;451:	tens = ones / 10;
ADDRLP4 40
ADDRLP4 32
INDIRI4
CNSTI4 10
DIVI4
ASGNI4
line 452
;452:	ones %= 10;
ADDRLP4 32
ADDRLP4 32
INDIRI4
CNSTI4 10
MODI4
ASGNI4
line 453
;453:	s = va("%i:%i%i", min, tens, ones );
ADDRGP4 $279
ARGP4
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 32
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 56
INDIRP4
ASGNP4
line 455
;454:
;455:	CG_CenterGiantLine( 64, s );
CNSTF4 1115684864
ARGF4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 CG_CenterGiantLine
CALLV
pop
line 460
;456:
;457:
;458:	// print the two scores
;459:
;460:	y = 160;
ADDRLP4 24
CNSTI4 160
ASGNI4
line 461
;461:	if ( cgs.gametype >= GT_TEAM ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $280
line 465
;462:		//
;463:		// teamplay scoreboard
;464:		//
;465:		CG_DrawStringExt( 8, y, "Red Team", color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
CNSTI4 8
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRGP4 $283
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 60
CNSTI4 1
ASGNI4
ADDRLP4 60
INDIRI4
ARGI4
ADDRLP4 60
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 466
;466:		s = va("%i", cg.teamScores[0] );
ADDRGP4 $90
ARGP4
ADDRGP4 cg+108224
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 64
INDIRP4
ASGNP4
line 467
;467:		CG_DrawStringExt( 632 - GIANT_WIDTH * strlen(s), y, s, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 strlen
CALLU4
ASGNU4
CNSTU4 632
ADDRLP4 68
INDIRU4
CNSTI4 5
LSHU4
SUBU4
CVUI4 4
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 72
CNSTI4 1
ASGNI4
ADDRLP4 72
INDIRI4
ARGI4
ADDRLP4 72
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 469
;468:		
;469:		y += 64;
ADDRLP4 24
ADDRLP4 24
INDIRI4
CNSTI4 64
ADDI4
ASGNI4
line 471
;470:
;471:		CG_DrawStringExt( 8, y, "Blue Team", color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
CNSTI4 8
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRGP4 $285
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 76
CNSTI4 1
ASGNI4
ADDRLP4 76
INDIRI4
ARGI4
ADDRLP4 76
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 472
;472:		s = va("%i", cg.teamScores[1] );
ADDRGP4 $90
ARGP4
ADDRGP4 cg+108224+4
INDIRI4
ARGI4
ADDRLP4 80
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 80
INDIRP4
ASGNP4
line 473
;473:		CG_DrawStringExt( 632 - GIANT_WIDTH * strlen(s), y, s, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 84
ADDRGP4 strlen
CALLU4
ASGNU4
CNSTU4 632
ADDRLP4 84
INDIRU4
CNSTI4 5
LSHU4
SUBU4
CVUI4 4
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 88
CNSTI4 1
ASGNI4
ADDRLP4 88
INDIRI4
ARGI4
ADDRLP4 88
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 474
;474:	} else {
ADDRGP4 $281
JUMPV
LABELV $280
line 478
;475:		//
;476:		// free for all scoreboard
;477:		//
;478:		for ( i = 0 ; i < MAX_CLIENTS ; i++ ) {
ADDRLP4 28
CNSTI4 0
ASGNI4
LABELV $288
line 479
;479:			ci = &cgs.clientinfo[i];
ADDRLP4 0
CNSTI4 1076
ADDRLP4 28
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 480
;480:			if ( !ci->infoValid ) {
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $293
line 481
;481:				continue;
ADDRGP4 $289
JUMPV
LABELV $293
line 483
;482:			}
;483:			if ( ci->team != TEAM_FREE ) {
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 0
EQI4 $295
line 484
;484:				continue;
ADDRGP4 $289
JUMPV
LABELV $295
line 487
;485:			}
;486:
;487:			CG_DrawStringExt( 8, y, ci->name, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
CNSTI4 8
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 60
CNSTI4 1
ASGNI4
ADDRLP4 60
INDIRI4
ARGI4
ADDRLP4 60
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 488
;488:			s = va("%i", ci->score );
ADDRGP4 $90
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 64
INDIRP4
ASGNP4
line 489
;489:			CG_DrawStringExt( 632 - GIANT_WIDTH * strlen(s), y, s, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 strlen
CALLU4
ASGNU4
CNSTU4 632
ADDRLP4 68
INDIRU4
CNSTI4 5
LSHU4
SUBU4
CVUI4 4
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 72
CNSTI4 1
ASGNI4
ADDRLP4 72
INDIRI4
ARGI4
ADDRLP4 72
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 490
;490:			y += 64;
ADDRLP4 24
ADDRLP4 24
INDIRI4
CNSTI4 64
ADDI4
ASGNI4
line 491
;491:		}
LABELV $289
line 478
ADDRLP4 28
ADDRLP4 28
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 128
LTI4 $288
line 492
;492:	}
LABELV $281
line 495
;493:
;494:
;495:}
LABELV $261
endproc CG_DrawTourneyScoreboard 92 36
bss
align 4
LABELV localClient
skip 4
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $285
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $283
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $279
byte 1 37
byte 1 105
byte 1 58
byte 1 37
byte 1 105
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $277
byte 1 83
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 98
byte 1 111
byte 1 97
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $268
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $216
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 32
byte 1 108
byte 1 101
byte 1 97
byte 1 100
byte 1 115
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $212
byte 1 82
byte 1 101
byte 1 100
byte 1 32
byte 1 108
byte 1 101
byte 1 97
byte 1 100
byte 1 115
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $205
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 115
byte 1 32
byte 1 97
byte 1 114
byte 1 101
byte 1 32
byte 1 116
byte 1 105
byte 1 101
byte 1 100
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $197
byte 1 37
byte 1 115
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 99
byte 1 101
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $189
byte 1 70
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $139
byte 1 82
byte 1 69
byte 1 65
byte 1 68
byte 1 89
byte 1 0
align 1
LABELV $111
byte 1 37
byte 1 53
byte 1 105
byte 1 32
byte 1 37
byte 1 52
byte 1 105
byte 1 32
byte 1 37
byte 1 52
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $110
byte 1 32
byte 1 83
byte 1 80
byte 1 69
byte 1 67
byte 1 84
byte 1 32
byte 1 37
byte 1 51
byte 1 105
byte 1 32
byte 1 37
byte 1 52
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $107
byte 1 32
byte 1 99
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 32
byte 1 32
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $97
byte 1 37
byte 1 105
byte 1 47
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $90
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $65
byte 1 66
byte 1 97
byte 1 100
byte 1 32
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 45
byte 1 62
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
