export CG_BuildSolidList
code
proc CG_BuildSolidList 28 0
file "..\cg_predict.c"
line 26
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_predict.c -- this file generates cg.predictedPlayerState by either
;4:// interpolating between snapshots from the server or locally predicting
;5:// ahead the client's movement.
;6:// It also handles local physics interaction, like fragments bouncing off walls
;7:
;8:#include "cg_local.h"
;9:
;10:static	pmove_t		cg_pmove;
;11:
;12:static	int			cg_numSolidEntities;
;13:static	centity_t	*cg_solidEntities[MAX_ENTITIES_IN_SNAPSHOT];
;14:static	int			cg_numTriggerEntities;
;15:static	centity_t	*cg_triggerEntities[MAX_ENTITIES_IN_SNAPSHOT];
;16:
;17:/*
;18:====================
;19:CG_BuildSolidList
;20:
;21:When a new cg.snap has been set, this function builds a sublist
;22:of the entities that are actually solid, to make for more
;23:efficient collision detection
;24:====================
;25:*/
;26:void CG_BuildSolidList( void ) {
line 32
;27:	int			i;
;28:	centity_t	*cent;
;29:	snapshot_t	*snap;
;30:	entityState_t	*ent;
;31:
;32:	cg_numSolidEntities = 0;
ADDRGP4 cg_numSolidEntities
CNSTI4 0
ASGNI4
line 33
;33:	cg_numTriggerEntities = 0;
ADDRGP4 cg_numTriggerEntities
CNSTI4 0
ASGNI4
line 35
;34:
;35:	if ( cg.nextSnap && !cg.nextFrameTeleport && !cg.thisFrameTeleport ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $61
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRGP4 cg+105496
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $61
ADDRGP4 cg+105492
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $61
line 36
;36:		snap = cg.nextSnap;
ADDRLP4 12
ADDRGP4 cg+36
INDIRP4
ASGNP4
line 37
;37:	} else {
ADDRGP4 $62
JUMPV
LABELV $61
line 38
;38:		snap = cg.snap;
ADDRLP4 12
ADDRGP4 cg+32
INDIRP4
ASGNP4
line 39
;39:	}
LABELV $62
line 41
;40:
;41:	for ( i = 0 ; i < snap->numEntities ; i++ ) {
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $71
JUMPV
LABELV $68
line 42
;42:		cent = &cg_entities[ snap->entities[ i ].number ];
ADDRLP4 0
CNSTI4 680
CNSTI4 204
ADDRLP4 8
INDIRI4
MULI4
ADDRLP4 12
INDIRP4
CNSTI4 492
ADDP4
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 43
;43:		ent = &cent->currentState;
ADDRLP4 4
ADDRLP4 0
INDIRP4
ASGNP4
line 45
;44:
;45:		if ( ent->eType == ET_ITEM || ent->eType == ET_PUSH_TRIGGER || ent->eType == ET_TELEPORT_TRIGGER ) {
ADDRLP4 20
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 2
EQI4 $75
ADDRLP4 20
INDIRI4
CNSTI4 8
EQI4 $75
ADDRLP4 20
INDIRI4
CNSTI4 9
NEI4 $72
LABELV $75
line 46
;46:			cg_triggerEntities[cg_numTriggerEntities] = cent;
ADDRGP4 cg_numTriggerEntities
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg_triggerEntities
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 47
;47:			cg_numTriggerEntities++;
ADDRLP4 24
ADDRGP4 cg_numTriggerEntities
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 48
;48:			continue;
ADDRGP4 $69
JUMPV
LABELV $72
line 51
;49:		}
;50:
;51:		if ( cent->nextState.solid ) {
ADDRLP4 0
INDIRP4
CNSTI4 380
ADDP4
INDIRI4
CNSTI4 0
EQI4 $76
line 52
;52:			cg_solidEntities[cg_numSolidEntities] = cent;
ADDRGP4 cg_numSolidEntities
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg_solidEntities
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 53
;53:			cg_numSolidEntities++;
ADDRLP4 24
ADDRGP4 cg_numSolidEntities
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 54
;54:			continue;
LABELV $76
line 56
;55:		}
;56:	}
LABELV $69
line 41
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $71
ADDRLP4 8
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 488
ADDP4
INDIRI4
LTI4 $68
line 57
;57:}
LABELV $60
endproc CG_BuildSolidList 28 0
proc CG_ClipMoveToEntities 144 36
line 66
;58:
;59:/*
;60:====================
;61:CG_ClipMoveToEntities
;62:
;63:====================
;64:*/
;65:static void CG_ClipMoveToEntities ( const vec3_t start, const vec3_t mins, const vec3_t maxs, const vec3_t end,
;66:							int skipNumber, int mask, trace_t *tr ) {
line 75
;67:	int			i, x, zd, zu;
;68:	trace_t		trace;
;69:	entityState_t	*ent;
;70:	clipHandle_t 	cmodel;
;71:	vec3_t		bmins, bmaxs;
;72:	vec3_t		origin, angles;
;73:	centity_t	*cent;
;74:
;75:	for ( i = 0 ; i < cg_numSolidEntities ; i++ ) {
ADDRLP4 64
CNSTI4 0
ASGNI4
ADDRGP4 $82
JUMPV
LABELV $79
line 76
;76:		cent = cg_solidEntities[ i ];
ADDRLP4 60
ADDRLP4 64
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg_solidEntities
ADDP4
INDIRP4
ASGNP4
line 77
;77:		ent = &cent->currentState;
ADDRLP4 0
ADDRLP4 60
INDIRP4
ASGNP4
line 79
;78:
;79:		if ( ent->number == skipNumber ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRFP4 16
INDIRI4
NEI4 $83
line 80
;80:			continue;
ADDRGP4 $80
JUMPV
LABELV $83
line 83
;81:		}
;82:
;83:		if ( ent->solid == SOLID_BMODEL ) {
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
CNSTI4 16777215
NEI4 $85
line 85
;84:			// special value for bmodel
;85:			cmodel = trap_CM_InlineModel( ent->modelindex );
ADDRLP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRLP4 132
ADDRGP4 trap_CM_InlineModel
CALLI4
ASGNI4
ADDRLP4 68
ADDRLP4 132
INDIRI4
ASGNI4
line 86
;86:			VectorCopy( cent->lerpAngles, angles );
ADDRLP4 108
ADDRLP4 60
INDIRP4
CNSTI4 664
ADDP4
INDIRB
ASGNB 12
line 87
;87:			BG_EvaluateTrajectory( &cent->currentState.pos, cg.physicsTime, origin );
ADDRLP4 60
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 cg+105512
INDIRI4
ARGI4
ADDRLP4 96
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 88
;88:		} else {
ADDRGP4 $86
JUMPV
LABELV $85
line 90
;89:			// encoded bbox
;90:			x = (ent->solid & 255);
ADDRLP4 120
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
CNSTI4 255
BANDI4
ASGNI4
line 91
;91:			zd = ((ent->solid>>8) & 255);
ADDRLP4 124
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
CNSTI4 8
RSHI4
CNSTI4 255
BANDI4
ASGNI4
line 92
;92:			zu = ((ent->solid>>16) & 255) - 32;
ADDRLP4 128
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
CNSTI4 16
RSHI4
CNSTI4 255
BANDI4
CNSTI4 32
SUBI4
ASGNI4
line 94
;93:
;94:			bmins[0] = bmins[1] = -x;
ADDRLP4 132
ADDRLP4 120
INDIRI4
NEGI4
CVIF4 4
ASGNF4
ADDRLP4 72+4
ADDRLP4 132
INDIRF4
ASGNF4
ADDRLP4 72
ADDRLP4 132
INDIRF4
ASGNF4
line 95
;95:			bmaxs[0] = bmaxs[1] = x;
ADDRLP4 136
ADDRLP4 120
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 84+4
ADDRLP4 136
INDIRF4
ASGNF4
ADDRLP4 84
ADDRLP4 136
INDIRF4
ASGNF4
line 96
;96:			bmins[2] = -zd;
ADDRLP4 72+8
ADDRLP4 124
INDIRI4
NEGI4
CVIF4 4
ASGNF4
line 97
;97:			bmaxs[2] = zu;
ADDRLP4 84+8
ADDRLP4 128
INDIRI4
CVIF4 4
ASGNF4
line 99
;98:
;99:			cmodel = trap_CM_TempBoxModel( bmins, bmaxs );
ADDRLP4 72
ARGP4
ADDRLP4 84
ARGP4
ADDRLP4 140
ADDRGP4 trap_CM_TempBoxModel
CALLI4
ASGNI4
ADDRLP4 68
ADDRLP4 140
INDIRI4
ASGNI4
line 100
;100:			VectorCopy( vec3_origin, angles );
ADDRLP4 108
ADDRGP4 vec3_origin
INDIRB
ASGNB 12
line 101
;101:			VectorCopy( cent->lerpOrigin, origin );
ADDRLP4 96
ADDRLP4 60
INDIRP4
CNSTI4 652
ADDP4
INDIRB
ASGNB 12
line 102
;102:		}
LABELV $86
line 105
;103:
;104:
;105:		trap_CM_TransformedBoxTrace ( &trace, start, end,
ADDRLP4 4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 68
INDIRI4
ARGI4
ADDRFP4 20
INDIRI4
ARGI4
ADDRLP4 96
ARGP4
ADDRLP4 108
ARGP4
ADDRGP4 trap_CM_TransformedBoxTrace
CALLV
pop
line 108
;106:			mins, maxs, cmodel,  mask, origin, angles);
;107:
;108:		if (trace.allsolid || trace.fraction < tr->fraction) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $95
ADDRLP4 4+8
INDIRF4
ADDRFP4 24
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
GEF4 $92
LABELV $95
line 109
;109:			trace.entityNum = ent->number;
ADDRLP4 4+52
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 110
;110:			*tr = trace;
ADDRFP4 24
INDIRP4
ADDRLP4 4
INDIRB
ASGNB 56
line 111
;111:		} else if (trace.startsolid) {
ADDRGP4 $93
JUMPV
LABELV $92
ADDRLP4 4+4
INDIRI4
CNSTI4 0
EQI4 $97
line 112
;112:			tr->startsolid = qtrue;
ADDRFP4 24
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 1
ASGNI4
line 113
;113:		}
LABELV $97
LABELV $93
line 114
;114:		if ( tr->allsolid ) {
ADDRFP4 24
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $100
line 115
;115:			return;
ADDRGP4 $78
JUMPV
LABELV $100
line 117
;116:		}
;117:	}
LABELV $80
line 75
ADDRLP4 64
ADDRLP4 64
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $82
ADDRLP4 64
INDIRI4
ADDRGP4 cg_numSolidEntities
INDIRI4
LTI4 $79
line 118
;118:}
LABELV $78
endproc CG_ClipMoveToEntities 144 36
export CG_Trace
proc CG_Trace 60 28
line 126
;119:
;120:/*
;121:================
;122:CG_Trace
;123:================
;124:*/
;125:void	CG_Trace( trace_t *result, const vec3_t start, const vec3_t mins, const vec3_t maxs, const vec3_t end, 
;126:					 int skipNumber, int mask ) {
line 129
;127:	trace_t	t;
;128:
;129:	trap_CM_BoxTrace ( &t, start, end, mins, maxs, 0, mask);
ADDRLP4 0
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRFP4 24
INDIRI4
ARGI4
ADDRGP4 trap_CM_BoxTrace
CALLV
pop
line 130
;130:	t.entityNum = t.fraction != 1.0 ? ENTITYNUM_WORLD : ENTITYNUM_NONE;
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
EQF4 $106
ADDRLP4 56
CNSTI4 1022
ASGNI4
ADDRGP4 $107
JUMPV
LABELV $106
ADDRLP4 56
CNSTI4 1023
ASGNI4
LABELV $107
ADDRLP4 0+52
ADDRLP4 56
INDIRI4
ASGNI4
line 132
;131:	// check all other solid models
;132:	CG_ClipMoveToEntities (start, mins, maxs, end, skipNumber, mask, &t);
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRFP4 20
INDIRI4
ARGI4
ADDRFP4 24
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 CG_ClipMoveToEntities
CALLV
pop
line 134
;133:
;134:	*result = t;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRB
ASGNB 56
line 135
;135:}
LABELV $102
endproc CG_Trace 60 28
export CG_PointContents
proc CG_PointContents 36 16
line 142
;136:
;137:/*
;138:================
;139:CG_PointContents
;140:================
;141:*/
;142:int		CG_PointContents( const vec3_t point, int passEntityNum ) {
line 149
;143:	int			i;
;144:	entityState_t	*ent;
;145:	centity_t	*cent;
;146:	clipHandle_t cmodel;
;147:	int			contents;
;148:
;149:	contents = trap_CM_PointContents (point, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 20
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 20
INDIRI4
ASGNI4
line 151
;150:
;151:	for ( i = 0 ; i < cg_numSolidEntities ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $112
JUMPV
LABELV $109
line 152
;152:		cent = cg_solidEntities[ i ];
ADDRLP4 12
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg_solidEntities
ADDP4
INDIRP4
ASGNP4
line 154
;153:
;154:		ent = &cent->currentState;
ADDRLP4 0
ADDRLP4 12
INDIRP4
ASGNP4
line 156
;155:
;156:		if ( ent->number == passEntityNum ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRFP4 4
INDIRI4
NEI4 $113
line 157
;157:			continue;
ADDRGP4 $110
JUMPV
LABELV $113
line 160
;158:		}
;159:
;160:		if (ent->solid != SOLID_BMODEL) { // special value for bmodel
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
CNSTI4 16777215
EQI4 $115
line 161
;161:			continue;
ADDRGP4 $110
JUMPV
LABELV $115
line 164
;162:		}
;163:
;164:		cmodel = trap_CM_InlineModel( ent->modelindex );
ADDRLP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRLP4 24
ADDRGP4 trap_CM_InlineModel
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 24
INDIRI4
ASGNI4
line 165
;165:		if ( !cmodel ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $117
line 166
;166:			continue;
ADDRGP4 $110
JUMPV
LABELV $117
line 169
;167:		}
;168:
;169:		contents |= trap_CM_TransformedPointContents( point, cmodel, ent->origin, ent->angles );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 32
ADDRGP4 trap_CM_TransformedPointContents
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 32
INDIRI4
BORI4
ASGNI4
line 170
;170:	}
LABELV $110
line 151
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $112
ADDRLP4 4
INDIRI4
ADDRGP4 cg_numSolidEntities
INDIRI4
LTI4 $109
line 172
;171:
;172:	return contents;
ADDRLP4 16
INDIRI4
RETI4
LABELV $108
endproc CG_PointContents 36 16
proc CG_InterpolatePlayerState 64 12
line 184
;173:}
;174:
;175:
;176:/*
;177:========================
;178:CG_InterpolatePlayerState
;179:
;180:Generates cg.predictedPlayerState by interpolating between
;181:cg.snap->player_state and cg.nextFrame->player_state
;182:========================
;183:*/
;184:static void CG_InterpolatePlayerState( qboolean grabAngles ) {
line 190
;185:	float			f;
;186:	int				i;
;187:	playerState_t	*out;
;188:	snapshot_t		*prev, *next;
;189:
;190:	out = &cg.predictedPlayerState;
ADDRLP4 12
ADDRGP4 cg+105532
ASGNP4
line 191
;191:	prev = cg.snap;
ADDRLP4 4
ADDRGP4 cg+32
INDIRP4
ASGNP4
line 192
;192:	next = cg.nextSnap;
ADDRLP4 8
ADDRGP4 cg+36
INDIRP4
ASGNP4
line 194
;193:
;194:	*out = cg.snap->ps;
ADDRLP4 12
INDIRP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
INDIRB
ASGNB 444
line 197
;195:
;196:	// if we are still allowing local input, short circuit the view angles
;197:	if ( grabAngles ) {
ADDRFP4 0
INDIRI4
CNSTI4 0
EQI4 $124
line 201
;198:		usercmd_t	cmd;
;199:		int			cmdNum;
;200:
;201:		cmdNum = trap_GetCurrentCmdNumber();
ADDRLP4 48
ADDRGP4 trap_GetCurrentCmdNumber
CALLI4
ASGNI4
ADDRLP4 44
ADDRLP4 48
INDIRI4
ASGNI4
line 202
;202:		trap_GetUserCmd( cmdNum, &cmd );
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 20
ARGP4
ADDRGP4 trap_GetUserCmd
CALLI4
pop
line 204
;203:
;204:		PM_UpdateViewAngles( out, &cmd );
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 PM_UpdateViewAngles
CALLV
pop
line 205
;205:	}
LABELV $124
line 208
;206:
;207:	// if the next frame is a teleport, we can't lerp to it
;208:	if ( cg.nextFrameTeleport ) {
ADDRGP4 cg+105496
INDIRI4
CNSTI4 0
EQI4 $126
line 209
;209:		return;
ADDRGP4 $119
JUMPV
LABELV $126
line 212
;210:	}
;211:
;212:	if ( !next || next->serverTime <= prev->serverTime ) {
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $131
ADDRLP4 24
CNSTI4 8
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRI4
GTI4 $129
LABELV $131
line 213
;213:		return;
ADDRGP4 $119
JUMPV
LABELV $129
line 216
;214:	}
;215:
;216:	f = (float)( cg.time - prev->serverTime ) / ( next->serverTime - prev->serverTime );
ADDRLP4 28
CNSTI4 8
ASGNI4
ADDRLP4 32
ADDRLP4 4
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 32
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 8
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRI4
ADDRLP4 32
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 218
;217:
;218:	i = next->ps.bobCycle;
ADDRLP4 0
ADDRLP4 8
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
ASGNI4
line 219
;219:	if ( i < prev->ps.bobCycle ) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
GEI4 $133
line 220
;220:		i += 256;		// handle wraparound
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 256
ADDI4
ASGNI4
line 221
;221:	}
LABELV $133
line 222
;222:	out->bobCycle = prev->ps.bobCycle + f * ( i - prev->ps.bobCycle );
ADDRLP4 36
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 36
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
ADDRLP4 0
INDIRI4
ADDRLP4 36
INDIRI4
SUBI4
CVIF4 4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 224
;223:
;224:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $135
line 225
;225:		out->origin[i] = prev->ps.origin[i] + f * (next->ps.origin[i] - prev->ps.origin[i] );
ADDRLP4 40
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 44
CNSTI4 64
ASGNI4
ADDRLP4 48
ADDRLP4 40
INDIRI4
ADDRLP4 4
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ADDP4
INDIRF4
ASGNF4
ADDRLP4 40
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 20
ADDP4
ADDP4
ADDRLP4 48
INDIRF4
ADDRLP4 16
INDIRF4
ADDRLP4 40
INDIRI4
ADDRLP4 8
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ADDP4
INDIRF4
ADDRLP4 48
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 226
;226:		if ( !grabAngles ) {
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $139
line 227
;227:			out->viewangles[i] = LerpAngle( 
ADDRLP4 52
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 56
CNSTI4 196
ASGNI4
ADDRLP4 52
INDIRI4
ADDRLP4 4
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 52
INDIRI4
ADDRLP4 8
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ADDP4
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 60
ADDRGP4 LerpAngle
CALLF4
ASGNF4
ADDRLP4 52
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 152
ADDP4
ADDP4
ADDRLP4 60
INDIRF4
ASGNF4
line 229
;228:				prev->ps.viewangles[i], next->ps.viewangles[i], f );
;229:		}
LABELV $139
line 230
;230:		out->velocity[i] = prev->ps.velocity[i] + 
ADDRLP4 52
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 56
CNSTI4 76
ASGNI4
ADDRLP4 60
ADDRLP4 52
INDIRI4
ADDRLP4 4
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ADDP4
INDIRF4
ASGNF4
ADDRLP4 52
INDIRI4
ADDRLP4 12
INDIRP4
CNSTI4 32
ADDP4
ADDP4
ADDRLP4 60
INDIRF4
ADDRLP4 16
INDIRF4
ADDRLP4 52
INDIRI4
ADDRLP4 8
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ADDP4
INDIRF4
ADDRLP4 60
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 232
;231:			f * (next->ps.velocity[i] - prev->ps.velocity[i] );
;232:	}
LABELV $136
line 224
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $135
line 234
;233:
;234:}
LABELV $119
endproc CG_InterpolatePlayerState 64 12
proc CG_TouchItem 20 12
line 241
;235:
;236:/*
;237:===================
;238:CG_TouchItem
;239:===================
;240:*/
;241:static void CG_TouchItem( centity_t *cent ) {
line 244
;242:	gitem_t		*item;
;243:
;244:	if ( !cg_predictItems.integer ) {
ADDRGP4 cg_predictItems+12
INDIRI4
CNSTI4 0
NEI4 $142
line 245
;245:		return;
ADDRGP4 $141
JUMPV
LABELV $142
line 247
;246:	}
;247:	if ( !BG_PlayerTouchesItem( &cg.predictedPlayerState, &cent->currentState, cg.time ) ) {
ADDRGP4 cg+105532
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 BG_PlayerTouchesItem
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $145
line 248
;248:		return;
ADDRGP4 $141
JUMPV
LABELV $145
line 252
;249:	}
;250:
;251:	// never pick an item up twice in a prediction
;252:	if ( cent->miscTime == cg.time ) {
ADDRFP4 0
INDIRP4
CNSTI4 432
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
NEI4 $149
line 253
;253:		return;
ADDRGP4 $141
JUMPV
LABELV $149
line 255
;254:	}
;255:	item = &bg_itemlist[ cent->currentState.modelindex ];
ADDRLP4 0
CNSTI4 56
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
MULI4
ADDRGP4 bg_itemlist
ADDP4
ASGNP4
line 256
;256:	if ( !BG_CanItemBeGrabbed( &cent->currentState, &cg.predictedPlayerState ) ) 
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 cg+105532
ARGP4
ADDRLP4 8
ADDRGP4 BG_CanItemBeGrabbed
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $152
line 257
;257:	{
line 259
;258:		// there's one reason why we can't grab a gun, and that's limits 
;259:		if ( cg_autoswitch.integer && item->giType == IT_WEAPON)
ADDRGP4 cg_autoswitch+12
INDIRI4
CNSTI4 0
EQI4 $141
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $141
line 260
;260:		{ // so we put this gun away in the hopes we can pick up another one.
line 262
;261:			
;262:		}
line 263
;263:		return;		// can't hold it
ADDRGP4 $141
JUMPV
LABELV $152
line 269
;264:	}
;265:
;266:	
;267:	// Special case for flags.  
;268:	// We don't predict touching our own flag
;269:	if (cg.predictedPlayerState.persistant[PERS_TEAM] == TEAM_RED &&
ADDRGP4 cg+105532+248+12
INDIRI4
CNSTI4 1
NEI4 $158
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 7
NEI4 $158
line 271
;270:		item->giTag == PW_REDFLAG)
;271:		return;
ADDRGP4 $141
JUMPV
LABELV $158
line 272
;272:	if (cg.predictedPlayerState.persistant[PERS_TEAM] == TEAM_BLUE &&
ADDRGP4 cg+105532+248+12
INDIRI4
CNSTI4 2
NEI4 $163
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 8
NEI4 $163
line 274
;273:		item->giTag == PW_BLUEFLAG)
;274:		return;
ADDRGP4 $141
JUMPV
LABELV $163
line 277
;275:
;276:	// grab it
;277:	BG_AddPredictableEventToPlayerstate( EV_ITEM_PICKUP, cent->currentState.modelindex , &cg.predictedPlayerState);
CNSTI4 19
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRGP4 cg+105532
ARGP4
ADDRGP4 BG_AddPredictableEventToPlayerstate
CALLV
pop
line 280
;278:
;279:	// remove it from the frame so it won't be drawn
;280:	cent->currentState.eFlags |= EF_NODRAW;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 283
;281:
;282:	// don't touch it again this prediction
;283:	cent->miscTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 432
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 286
;284:
;285:	// if its a weapon, give them some predicted ammo so the autoswitch will work
;286:	if ( item->giType == IT_WEAPON ) {		
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $170
line 287
;287:		cg.predictedPlayerState.stats[ STAT_WEAPONS ] |= 1 << item->giTag;
ADDRLP4 16
ADDRGP4 cg+105532+184+8
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LSHI4
BORI4
ASGNI4
line 288
;288:		if ( !cg.predictedPlayerState.ammo[ item->giTag ] ) {
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+105532+376
ADDP4
INDIRI4
CNSTI4 0
NEI4 $175
line 289
;289:			cg.predictedPlayerState.ammo[ item->giTag ] = 1;
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+105532+376
ADDP4
CNSTI4 1
ASGNI4
line 290
;290:		}
LABELV $175
line 291
;291:		if(cg.predictedPlayerState.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS)
ADDRGP4 cg+105532+184+28
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $181
line 292
;292:		{
line 293
;293:			cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 294
;294:			cg.weaponSelect = item->giTag;
ADDRGP4 cg+106700
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ASGNI4
line 295
;295:		}
LABELV $181
line 297
;296:		
;297:	}
LABELV $170
line 298
;298:}
LABELV $141
endproc CG_TouchItem 20 12
proc CG_TouchTriggerPrediction 104 28
line 308
;299:
;300:
;301:/*
;302:=========================
;303:CG_TouchTriggerPrediction
;304:
;305:Predict push triggers and items
;306:=========================
;307:*/
;308:static void CG_TouchTriggerPrediction( void ) {
line 317
;309:	int			i;
;310:	trace_t		trace;
;311:	entityState_t	*ent;
;312:	clipHandle_t cmodel;
;313:	centity_t	*cent;
;314:	qboolean	spectator;
;315:
;316:	// dead clients don't activate triggers
;317:	if ( cg.predictedPlayerState.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+105532+184
INDIRI4
CNSTI4 0
GTI4 $190
line 318
;318:		return;
ADDRGP4 $189
JUMPV
LABELV $190
line 321
;319:	}
;320:
;321:	spectator = ( cg.predictedPlayerState.pm_type == PM_SPECTATOR );
ADDRGP4 cg+105532+4
INDIRI4
CNSTI4 2
NEI4 $197
ADDRLP4 76
CNSTI4 1
ASGNI4
ADDRGP4 $198
JUMPV
LABELV $197
ADDRLP4 76
CNSTI4 0
ASGNI4
LABELV $198
ADDRLP4 72
ADDRLP4 76
INDIRI4
ASGNI4
line 323
;322:
;323:	if ( cg.predictedPlayerState.pm_type != PM_NORMAL && !spectator ) {
ADDRLP4 80
CNSTI4 0
ASGNI4
ADDRGP4 cg+105532+4
INDIRI4
ADDRLP4 80
INDIRI4
EQI4 $199
ADDRLP4 72
INDIRI4
ADDRLP4 80
INDIRI4
NEI4 $199
line 324
;324:		return;
ADDRGP4 $189
JUMPV
LABELV $199
line 327
;325:	}
;326:
;327:	for ( i = 0 ; i < cg_numTriggerEntities ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $206
JUMPV
LABELV $203
line 328
;328:		cent = cg_triggerEntities[ i ];
ADDRLP4 12
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg_triggerEntities
ADDP4
INDIRP4
ASGNP4
line 329
;329:		ent = &cent->currentState;
ADDRLP4 0
ADDRLP4 12
INDIRP4
ASGNP4
line 331
;330:
;331:		if ( ent->eType == ET_ITEM && !spectator ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $207
ADDRLP4 72
INDIRI4
CNSTI4 0
NEI4 $207
line 332
;332:			CG_TouchItem( cent );
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 CG_TouchItem
CALLV
pop
line 333
;333:			continue;
ADDRGP4 $204
JUMPV
LABELV $207
line 336
;334:		}
;335:
;336:		if ( ent->solid != SOLID_BMODEL ) {
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
CNSTI4 16777215
EQI4 $209
line 337
;337:			continue;
ADDRGP4 $204
JUMPV
LABELV $209
line 340
;338:		}
;339:
;340:		cmodel = trap_CM_InlineModel( ent->modelindex );
ADDRLP4 0
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRLP4 84
ADDRGP4 trap_CM_InlineModel
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 84
INDIRI4
ASGNI4
line 341
;341:		if ( !cmodel ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $211
line 342
;342:			continue;
ADDRGP4 $204
JUMPV
LABELV $211
line 345
;343:		}
;344:
;345:		trap_CM_BoxTrace( &trace, cg.predictedPlayerState.origin, cg.predictedPlayerState.origin, 
ADDRLP4 16
ARGP4
ADDRGP4 cg+105532+20
ARGP4
ADDRGP4 cg+105532+20
ARGP4
ADDRGP4 cg_pmove+176
ARGP4
ADDRGP4 cg_pmove+188
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
CNSTI4 -1
ARGI4
ADDRGP4 trap_CM_BoxTrace
CALLV
pop
line 348
;346:			cg_pmove.mins, cg_pmove.maxs, cmodel, -1 );
;347:
;348:		if ( !trace.startsolid ) {
ADDRLP4 16+4
INDIRI4
CNSTI4 0
NEI4 $219
line 349
;349:			continue;
ADDRGP4 $204
JUMPV
LABELV $219
line 352
;350:		}
;351:
;352:		if ( ent->eType == ET_TELEPORT_TRIGGER ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 9
NEI4 $222
line 353
;353:			cg.hyperspace = qtrue;
ADDRGP4 cg+105528
CNSTI4 1
ASGNI4
line 354
;354:		} else {
ADDRGP4 $223
JUMPV
LABELV $222
line 359
;355:			float	s;
;356:			vec3_t	dir;
;357:
;358:			// we hit this push trigger
;359:			if ( spectator ) {
ADDRLP4 72
INDIRI4
CNSTI4 0
EQI4 $225
line 360
;360:				continue;
ADDRGP4 $204
JUMPV
LABELV $225
line 364
;361:			}
;362:
;363:			// flying characters don't hit bounce pads
;364:			if ( cg.predictedPlayerState.powerups[PW_FLIGHT] ) {
ADDRGP4 cg+105532+312+24
INDIRI4
CNSTI4 0
EQI4 $227
line 365
;365:				continue;
ADDRGP4 $204
JUMPV
LABELV $227
line 369
;366:			}
;367:
;368:			// if we are already flying along the bounce direction, don't play sound again
;369:			VectorNormalize2( ent->origin2, dir );
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 88
ARGP4
ADDRGP4 VectorNormalize2
CALLF4
pop
line 370
;370:			s = DotProduct( cg.predictedPlayerState.velocity, dir );
ADDRLP4 100
ADDRGP4 cg+105532+32
INDIRF4
ADDRLP4 88
INDIRF4
MULF4
ADDRGP4 cg+105532+32+4
INDIRF4
ADDRLP4 88+4
INDIRF4
MULF4
ADDF4
ADDRGP4 cg+105532+32+8
INDIRF4
ADDRLP4 88+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 371
;371:			if ( s < 500 ) {
ADDRLP4 100
INDIRF4
CNSTF4 1140457472
GEF4 $242
line 373
;372:				// don't play the event sound again if we are in a fat trigger
;373:				BG_AddPredictableEventToPlayerstate( EV_JUMP_PAD, 0, &cg.predictedPlayerState );
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cg+105532
ARGP4
ADDRGP4 BG_AddPredictableEventToPlayerstate
CALLV
pop
line 374
;374:			}
LABELV $242
line 375
;375:			VectorCopy( ent->origin2, cg.predictedPlayerState.velocity );
ADDRGP4 cg+105532+32
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 376
;376:		}
LABELV $223
line 377
;377:	}
LABELV $204
line 327
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $206
ADDRLP4 4
INDIRI4
ADDRGP4 cg_numTriggerEntities
INDIRI4
LTI4 $203
line 378
;378:}
LABELV $189
endproc CG_TouchTriggerPrediction 104 28
export CG_PredictPlayerState
proc CG_PredictPlayerState 568 20
line 408
;379:
;380:
;381:
;382:/*
;383:=================
;384:CG_PredictPlayerState
;385:
;386:Generates cg.predictedPlayerState for the current cg.time
;387:cg.predictedPlayerState is guaranteed to be valid after exiting.
;388:
;389:For demo playback, this will be an interpolation between two valid
;390:playerState_t.
;391:
;392:For normal gameplay, it will be the result of predicted usercmd_t on
;393:top of the most recent playerState_t received from the server.
;394:
;395:Each new snapshot will usually have one or more new usercmd over the last,
;396:but we simulate all unacknowledged commands each time, not just the new ones.
;397:This means that on an internet connection, quite a few pmoves may be issued
;398:each frame.
;399:
;400:OPTIMIZE: don't re-simulate unless the newly arrived snapshot playerState_t
;401:differs from the predicted one.  Would require saving all intermediate
;402:playerState_t during prediction.
;403:
;404:We detect prediction errors and allow them to be decayed off over several frames
;405:to ease the jerk.
;406:=================
;407:*/
;408:void CG_PredictPlayerState( void ) {
line 415
;409:	int			cmdNum, current;
;410:	playerState_t	oldPlayerState;
;411:	qboolean	moved;
;412:	usercmd_t	oldestCmd;
;413:	usercmd_t	latestCmd;
;414:
;415:	cg.hyperspace = qfalse;	// will be set if touching a trigger_teleport
ADDRGP4 cg+105528
CNSTI4 0
ASGNI4
line 420
;416:
;417:	// if this is the first frame we must guarantee
;418:	// predictedPlayerState is valid even if there is some
;419:	// other error condition
;420:	if ( !cg.validPPS ) {
ADDRGP4 cg+106656
INDIRI4
CNSTI4 0
NEI4 $249
line 421
;421:		cg.validPPS = qtrue;
ADDRGP4 cg+106656
CNSTI4 1
ASGNI4
line 422
;422:		cg.predictedPlayerState = cg.snap->ps;
ADDRGP4 cg+105532
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
INDIRB
ASGNB 444
line 423
;423:	}
LABELV $249
line 427
;424:
;425:
;426:	// demo playback just copies the moves
;427:	if ( cg.demoPlayback || (cg.snap->ps.pm_flags & PMF_FOLLOW) ) {
ADDRLP4 504
CNSTI4 0
ASGNI4
ADDRGP4 cg+4
INDIRI4
ADDRLP4 504
INDIRI4
NEI4 $259
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
ADDRLP4 504
INDIRI4
EQI4 $255
LABELV $259
line 428
;428:		CG_InterpolatePlayerState( qfalse );
CNSTI4 0
ARGI4
ADDRGP4 CG_InterpolatePlayerState
CALLV
pop
line 429
;429:		return;
ADDRGP4 $247
JUMPV
LABELV $255
line 433
;430:	}
;431:
;432:	// non-predicting local movement will grab the latest angles
;433:	if ( cg_nopredict.integer || cg_syncronousClients.integer ) {
ADDRLP4 508
CNSTI4 0
ASGNI4
ADDRGP4 cg_nopredict+12
INDIRI4
ADDRLP4 508
INDIRI4
NEI4 $264
ADDRGP4 cg_syncronousClients+12
INDIRI4
ADDRLP4 508
INDIRI4
EQI4 $260
LABELV $264
line 434
;434:		CG_InterpolatePlayerState( qtrue );
CNSTI4 1
ARGI4
ADDRGP4 CG_InterpolatePlayerState
CALLV
pop
line 435
;435:		return;
ADDRGP4 $247
JUMPV
LABELV $260
line 439
;436:	}
;437:
;438:	// prepare for pmove
;439:	cg_pmove.ps = &cg.predictedPlayerState;
ADDRGP4 cg_pmove
ADDRGP4 cg+105532
ASGNP4
line 440
;440:	cg_pmove.trace = CG_Trace;
ADDRGP4 cg_pmove+212
ADDRGP4 CG_Trace
ASGNP4
line 441
;441:	cg_pmove.pointcontents = CG_PointContents;
ADDRGP4 cg_pmove+216
ADDRGP4 CG_PointContents
ASGNP4
line 442
;442:	if ( cg_pmove.ps->pm_type == PM_DEAD ) {
ADDRGP4 cg_pmove
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $268
line 443
;443:		cg_pmove.tracemask = MASK_PLAYERSOLID & ~CONTENTS_BODY;
ADDRGP4 cg_pmove+28
CNSTI4 65537
ASGNI4
line 444
;444:	}
ADDRGP4 $269
JUMPV
LABELV $268
line 445
;445:	else {
line 446
;446:		cg_pmove.tracemask = MASK_PLAYERSOLID;
ADDRGP4 cg_pmove+28
CNSTI4 33619969
ASGNI4
line 447
;447:	}
LABELV $269
line 448
;448:	if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
NEI4 $272
line 449
;449:		cg_pmove.tracemask &= ~CONTENTS_BODY;	// spectators can fly through bodies
ADDRLP4 512
ADDRGP4 cg_pmove+28
ASGNP4
ADDRLP4 512
INDIRP4
ADDRLP4 512
INDIRP4
INDIRI4
CNSTI4 -33554433
BANDI4
ASGNI4
line 450
;450:	}
LABELV $272
line 451
;451:	cg_pmove.noFootsteps = ( cgs.dmflags & DF_NO_FOOTSTEPS ) > 0;
ADDRGP4 cgs+24292
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
LEI4 $279
ADDRLP4 512
CNSTI4 1
ASGNI4
ADDRGP4 $280
JUMPV
LABELV $279
ADDRLP4 512
CNSTI4 0
ASGNI4
LABELV $280
ADDRGP4 cg_pmove+36
ADDRLP4 512
INDIRI4
ASGNI4
line 454
;452:
;453:	// save the state before the pmove so we can detect transitions
;454:	oldPlayerState = cg.predictedPlayerState;
ADDRLP4 4
ADDRGP4 cg+105532
INDIRB
ASGNB 444
line 456
;455:
;456:	current = trap_GetCurrentCmdNumber();
ADDRLP4 516
ADDRGP4 trap_GetCurrentCmdNumber
CALLI4
ASGNI4
ADDRLP4 448
ADDRLP4 516
INDIRI4
ASGNI4
line 461
;457:
;458:	// if we don't have the commands right after the snapshot, we
;459:	// can't accurately predict a current position, so just freeze at
;460:	// the last good position we had
;461:	cmdNum = current - CMD_BACKUP + 1;
ADDRLP4 0
ADDRLP4 448
INDIRI4
CNSTI4 64
SUBI4
CNSTI4 1
ADDI4
ASGNI4
line 462
;462:	trap_GetUserCmd( cmdNum, &oldestCmd );
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 480
ARGP4
ADDRGP4 trap_GetUserCmd
CALLI4
pop
line 463
;463:	if ( oldestCmd.serverTime > cg.snap->ps.commandTime 
ADDRLP4 520
ADDRLP4 480
INDIRI4
ASGNI4
ADDRLP4 520
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
LEI4 $282
ADDRLP4 520
INDIRI4
ADDRGP4 cg+105504
INDIRI4
GEI4 $282
line 464
;464:		&& oldestCmd.serverTime < cg.time ) {	// special check for map_restart
line 465
;465:		if ( cg_showmiss.integer ) {
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 0
EQI4 $247
line 466
;466:			CG_Printf ("exceeded PACKET_BACKUP on commands\n");
ADDRGP4 $289
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 467
;467:		}
line 468
;468:		return;
ADDRGP4 $247
JUMPV
LABELV $282
line 472
;469:	}
;470:
;471:	// get the latest command so we can know which commands are from previous map_restarts
;472:	trap_GetUserCmd( current, &latestCmd );
ADDRLP4 448
INDIRI4
ARGI4
ADDRLP4 456
ARGP4
ADDRGP4 trap_GetUserCmd
CALLI4
pop
line 478
;473:
;474:	// get the most recent information we have, even if
;475:	// the server time is beyond our current cg.time,
;476:	// because predicted player positions are going to 
;477:	// be ahead of everything else anyway
;478:	if ( cg.nextSnap && !cg.nextFrameTeleport && !cg.thisFrameTeleport ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $290
ADDRLP4 524
CNSTI4 0
ASGNI4
ADDRGP4 cg+105496
INDIRI4
ADDRLP4 524
INDIRI4
NEI4 $290
ADDRGP4 cg+105492
INDIRI4
ADDRLP4 524
INDIRI4
NEI4 $290
line 479
;479:		cg.predictedPlayerState = cg.nextSnap->ps;
ADDRGP4 cg+105532
ADDRGP4 cg+36
INDIRP4
CNSTI4 44
ADDP4
INDIRB
ASGNB 444
line 480
;480:		cg.physicsTime = cg.nextSnap->serverTime;
ADDRGP4 cg+105512
ADDRGP4 cg+36
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 481
;481:	} else {
ADDRGP4 $291
JUMPV
LABELV $290
line 482
;482:		cg.predictedPlayerState = cg.snap->ps;
ADDRGP4 cg+105532
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
INDIRB
ASGNB 444
line 483
;483:		cg.physicsTime = cg.snap->serverTime;
ADDRGP4 cg+105512
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 484
;484:	}
LABELV $291
line 487
;485:
;486:	// run cmds
;487:	moved = qfalse;
ADDRLP4 452
CNSTI4 0
ASGNI4
line 488
;488:	for ( cmdNum = current - CMD_BACKUP + 1 ; cmdNum <= current ; cmdNum++ ) {
ADDRLP4 0
ADDRLP4 448
INDIRI4
CNSTI4 64
SUBI4
CNSTI4 1
ADDI4
ASGNI4
ADDRGP4 $306
JUMPV
LABELV $303
line 490
;489:		// get the command
;490:		trap_GetUserCmd( cmdNum, &cg_pmove.cmd );
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 cg_pmove+4
ARGP4
ADDRGP4 trap_GetUserCmd
CALLI4
pop
line 493
;491:
;492:		// don't do anything if the time is before the snapshot player time
;493:		if ( cg_pmove.cmd.serverTime <= cg.predictedPlayerState.commandTime ) {
ADDRGP4 cg_pmove+4
INDIRI4
ADDRGP4 cg+105532
INDIRI4
GTI4 $308
line 494
;494:			continue;
ADDRGP4 $304
JUMPV
LABELV $308
line 498
;495:		}
;496:
;497:		// don't do anything if the command was from a previous map_restart
;498:		if ( cg_pmove.cmd.serverTime > latestCmd.serverTime ) {
ADDRGP4 cg_pmove+4
INDIRI4
ADDRLP4 456
INDIRI4
LEI4 $312
line 499
;499:			continue;
ADDRGP4 $304
JUMPV
LABELV $312
line 507
;500:		}
;501:
;502:		// check for a prediction error from last frame
;503:		// on a lan, this will often be the exact value
;504:		// from the snapshot, but on a wan we will have
;505:		// to predict several commands to get to the point
;506:		// we want to compare
;507:		if ( cg.predictedPlayerState.commandTime == oldPlayerState.commandTime ) {
ADDRGP4 cg+105532
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $315
line 511
;508:			vec3_t	delta;
;509:			float	len;
;510:
;511:			if ( cg.thisFrameTeleport ) {
ADDRGP4 cg+105492
INDIRI4
CNSTI4 0
EQI4 $318
line 513
;512:				// a teleport will not cause an error decay
;513:				VectorClear( cg.predictedError );
ADDRLP4 544
CNSTF4 0
ASGNF4
ADDRGP4 cg+106664+8
ADDRLP4 544
INDIRF4
ASGNF4
ADDRGP4 cg+106664+4
ADDRLP4 544
INDIRF4
ASGNF4
ADDRGP4 cg+106664
ADDRLP4 544
INDIRF4
ASGNF4
line 514
;514:				if ( cg_showmiss.integer ) {
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 0
EQI4 $326
line 515
;515:					CG_Printf( "PredictionTeleport\n" );
ADDRGP4 $329
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 516
;516:				}
LABELV $326
line 517
;517:				cg.thisFrameTeleport = qfalse;
ADDRGP4 cg+105492
CNSTI4 0
ASGNI4
line 518
;518:			} else {
ADDRGP4 $319
JUMPV
LABELV $318
line 520
;519:				vec3_t	adjusted;
;520:				CG_AdjustPositionForMover( cg.predictedPlayerState.origin, 
ADDRGP4 cg+105532+20
ARGP4
ADDRGP4 cg+105532+68
INDIRI4
ARGI4
ADDRGP4 cg+105512
INDIRI4
ARGI4
ADDRGP4 cg+105508
INDIRI4
ARGI4
ADDRLP4 544
ARGP4
ADDRGP4 CG_AdjustPositionForMover
CALLV
pop
line 523
;521:					cg.predictedPlayerState.groundEntityNum, cg.physicsTime, cg.oldTime, adjusted );
;522:
;523:				VectorSubtract( oldPlayerState.origin, adjusted, delta );
ADDRLP4 528
ADDRLP4 4+20
INDIRF4
ADDRLP4 544
INDIRF4
SUBF4
ASGNF4
ADDRLP4 528+4
ADDRLP4 4+20+4
INDIRF4
ADDRLP4 544+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 528+8
ADDRLP4 4+20+8
INDIRF4
ADDRLP4 544+8
INDIRF4
SUBF4
ASGNF4
line 524
;524:				len = VectorLength( delta );
ADDRLP4 528
ARGP4
ADDRLP4 556
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 540
ADDRLP4 556
INDIRF4
ASGNF4
line 525
;525:				if ( len > 0.1 ) {
ADDRLP4 540
INDIRF4
CNSTF4 1036831949
LEF4 $346
line 526
;526:					if ( cg_showmiss.integer ) {
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 0
EQI4 $348
line 527
;527:						CG_Printf("Prediction miss: %f\n", len);
ADDRGP4 $351
ARGP4
ADDRLP4 540
INDIRF4
ARGF4
ADDRGP4 CG_Printf
CALLV
pop
line 528
;528:					}
LABELV $348
line 529
;529:					if ( cg_errorDecay.integer ) {
ADDRGP4 cg_errorDecay+12
INDIRI4
CNSTI4 0
EQI4 $352
line 533
;530:						int		t;
;531:						float	f;
;532:
;533:						t = cg.time - cg.predictedErrorTime;
ADDRLP4 564
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106660
INDIRI4
SUBI4
ASGNI4
line 534
;534:						f = ( cg_errorDecay.value - t ) / cg_errorDecay.value;
ADDRLP4 560
ADDRGP4 cg_errorDecay+8
INDIRF4
ADDRLP4 564
INDIRI4
CVIF4 4
SUBF4
ADDRGP4 cg_errorDecay+8
INDIRF4
DIVF4
ASGNF4
line 535
;535:						if ( f < 0 ) {
ADDRLP4 560
INDIRF4
CNSTF4 0
GEF4 $359
line 536
;536:							f = 0;
ADDRLP4 560
CNSTF4 0
ASGNF4
line 537
;537:						}
LABELV $359
line 538
;538:						if ( f > 0 && cg_showmiss.integer ) {
ADDRLP4 560
INDIRF4
CNSTF4 0
LEF4 $361
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 0
EQI4 $361
line 539
;539:							CG_Printf("Double prediction decay: %f\n", f);
ADDRGP4 $364
ARGP4
ADDRLP4 560
INDIRF4
ARGF4
ADDRGP4 CG_Printf
CALLV
pop
line 540
;540:						}
LABELV $361
line 541
;541:						VectorScale( cg.predictedError, f, cg.predictedError );
ADDRGP4 cg+106664
ADDRGP4 cg+106664
INDIRF4
ADDRLP4 560
INDIRF4
MULF4
ASGNF4
ADDRGP4 cg+106664+4
ADDRGP4 cg+106664+4
INDIRF4
ADDRLP4 560
INDIRF4
MULF4
ASGNF4
ADDRGP4 cg+106664+8
ADDRGP4 cg+106664+8
INDIRF4
ADDRLP4 560
INDIRF4
MULF4
ASGNF4
line 542
;542:					} else {
ADDRGP4 $353
JUMPV
LABELV $352
line 543
;543:						VectorClear( cg.predictedError );
ADDRLP4 560
CNSTF4 0
ASGNF4
ADDRGP4 cg+106664+8
ADDRLP4 560
INDIRF4
ASGNF4
ADDRGP4 cg+106664+4
ADDRLP4 560
INDIRF4
ASGNF4
ADDRGP4 cg+106664
ADDRLP4 560
INDIRF4
ASGNF4
line 544
;544:					}
LABELV $353
line 545
;545:					VectorAdd( delta, cg.predictedError, cg.predictedError );
ADDRGP4 cg+106664
ADDRLP4 528
INDIRF4
ADDRGP4 cg+106664
INDIRF4
ADDF4
ASGNF4
ADDRGP4 cg+106664+4
ADDRLP4 528+4
INDIRF4
ADDRGP4 cg+106664+4
INDIRF4
ADDF4
ASGNF4
ADDRGP4 cg+106664+8
ADDRLP4 528+8
INDIRF4
ADDRGP4 cg+106664+8
INDIRF4
ADDF4
ASGNF4
line 546
;546:					cg.predictedErrorTime = cg.oldTime;
ADDRGP4 cg+106660
ADDRGP4 cg+105508
INDIRI4
ASGNI4
line 547
;547:				}
LABELV $346
line 548
;548:			}
LABELV $319
line 549
;549:		}
LABELV $315
line 553
;550:
;551:		// don't predict gauntlet firing, which is only supposed to happen
;552:		// when it actually inflicts damage
;553:		cg_pmove.gauntletHit = qfalse;
ADDRGP4 cg_pmove+40
CNSTI4 0
ASGNI4
line 555
;554:
;555:		Pmove (&cg_pmove);
ADDRGP4 cg_pmove
ARGP4
ADDRGP4 Pmove
CALLV
pop
line 557
;556:
;557:		moved = qtrue;
ADDRLP4 452
CNSTI4 1
ASGNI4
line 560
;558:
;559:		// add push trigger movement effects
;560:		CG_TouchTriggerPrediction();
ADDRGP4 CG_TouchTriggerPrediction
CALLV
pop
line 561
;561:	}
LABELV $304
line 488
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $306
ADDRLP4 0
INDIRI4
ADDRLP4 448
INDIRI4
LEI4 $303
line 563
;562:
;563:	if ( cg_showmiss.integer > 1 ) {
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 1
LEI4 $395
line 564
;564:		CG_Printf( "[%i : %i] ", cg_pmove.cmd.serverTime, cg.time );
ADDRGP4 $398
ARGP4
ADDRGP4 cg_pmove+4
INDIRI4
ARGI4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 565
;565:	}
LABELV $395
line 567
;566:
;567:	if ( !moved ) {
ADDRLP4 452
INDIRI4
CNSTI4 0
NEI4 $401
line 568
;568:		if ( cg_showmiss.integer ) {
ADDRGP4 cg_showmiss+12
INDIRI4
CNSTI4 0
EQI4 $247
line 569
;569:			CG_Printf( "not moved\n" );
ADDRGP4 $406
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 570
;570:		}
line 571
;571:		return;
ADDRGP4 $247
JUMPV
LABELV $401
line 575
;572:	}
;573:
;574:	// adjust for the movement of the groundentity
;575:	CG_AdjustPositionForMover( cg.predictedPlayerState.origin, 
ADDRGP4 cg+105532+20
ARGP4
ADDRGP4 cg+105532+68
INDIRI4
ARGI4
ADDRGP4 cg+105512
INDIRI4
ARGI4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRGP4 cg+105532+20
ARGP4
ADDRGP4 CG_AdjustPositionForMover
CALLV
pop
line 580
;576:		cg.predictedPlayerState.groundEntityNum, 
;577:		cg.physicsTime, cg.time, cg.predictedPlayerState.origin );
;578:
;579:	// fire events and other transition triggered things
;580:	CG_TransitionPlayerState( &cg.predictedPlayerState, &oldPlayerState );
ADDRGP4 cg+105532
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 CG_TransitionPlayerState
CALLV
pop
line 581
;581:}
LABELV $247
endproc CG_PredictPlayerState 568 20
bss
align 4
LABELV cg_triggerEntities
skip 1024
align 4
LABELV cg_numTriggerEntities
skip 4
align 4
LABELV cg_solidEntities
skip 1024
align 4
LABELV cg_numSolidEntities
skip 4
align 4
LABELV cg_pmove
skip 220
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $406
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $398
byte 1 91
byte 1 37
byte 1 105
byte 1 32
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 93
byte 1 32
byte 1 0
align 1
LABELV $364
byte 1 68
byte 1 111
byte 1 117
byte 1 98
byte 1 108
byte 1 101
byte 1 32
byte 1 112
byte 1 114
byte 1 101
byte 1 100
byte 1 105
byte 1 99
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 32
byte 1 100
byte 1 101
byte 1 99
byte 1 97
byte 1 121
byte 1 58
byte 1 32
byte 1 37
byte 1 102
byte 1 10
byte 1 0
align 1
LABELV $351
byte 1 80
byte 1 114
byte 1 101
byte 1 100
byte 1 105
byte 1 99
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 32
byte 1 109
byte 1 105
byte 1 115
byte 1 115
byte 1 58
byte 1 32
byte 1 37
byte 1 102
byte 1 10
byte 1 0
align 1
LABELV $329
byte 1 80
byte 1 114
byte 1 101
byte 1 100
byte 1 105
byte 1 99
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 84
byte 1 101
byte 1 108
byte 1 101
byte 1 112
byte 1 111
byte 1 114
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $289
byte 1 101
byte 1 120
byte 1 99
byte 1 101
byte 1 101
byte 1 100
byte 1 101
byte 1 100
byte 1 32
byte 1 80
byte 1 65
byte 1 67
byte 1 75
byte 1 69
byte 1 84
byte 1 95
byte 1 66
byte 1 65
byte 1 67
byte 1 75
byte 1 85
byte 1 80
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 99
byte 1 111
byte 1 109
byte 1 109
byte 1 97
byte 1 110
byte 1 100
byte 1 115
byte 1 10
byte 1 0
