export CG_CheckAmmo
code
proc CG_CheckAmmo 20 8
file "..\cg_playerstate.c"
line 17
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_playerstate.c -- this file acts on changes in a new playerState_t
;4:// With normal play, this will be done after local prediction, but when
;5:// following another player or playing back a demo, it will be checked
;6:// when the snapshot transitions like all the other entities
;7:
;8:#include "cg_local.h"
;9:
;10:/*
;11:==============
;12:CG_CheckAmmo
;13:
;14:If the ammo has gone low enough to generate the warning, play a sound
;15:==============
;16:*/
;17:void CG_CheckAmmo( void ) {
line 24
;18:	int		i;
;19:	int		total;
;20:	int		previous;
;21:	int		weapons;
;22:
;23:	// see about how many seconds of ammo we have remaining
;24:	weapons = cg.snap->ps.stats[ STAT_WEAPONS ];
ADDRLP4 8
ADDRGP4 cg+32
INDIRP4
CNSTI4 236
ADDP4
INDIRI4
ASGNI4
line 25
;25:	total = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 26
;26:	if(cg.predictedPlayerState.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS)
ADDRGP4 cg+105532+184+28
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $62
line 27
;27:	{
line 28
;28:		switch ( cg.predictedPlayerState.weapon ) {
ADDRLP4 16
ADDRGP4 cg+105532+144
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
LTI4 $67
ADDRLP4 16
INDIRI4
CNSTI4 7
GTI4 $67
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $79
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $79
address $71
address $72
address $67
address $72
address $72
address $72
address $67
address $72
code
LABELV $71
line 30
;29:		case WP_NONE:
;30:			total = 5000;
ADDRLP4 4
CNSTI4 5000
ASGNI4
line 31
;31:			break;
ADDRGP4 $68
JUMPV
LABELV $72
line 37
;32:		case WP_GAUNTLET:
;33:		case WP_ROCKET_LAUNCHER:
;34:		case WP_GRENADE_LAUNCHER:
;35:		case WP_RAILGUN:
;36:		case WP_SHOTGUN:
;37:			total += cg.snap->ps.ammo[cg.predictedPlayerState.weapon] * 1000;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1000
ADDRGP4 cg+105532+144
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 420
ADDP4
ADDP4
INDIRI4
MULI4
ADDI4
ASGNI4
line 38
;38:			break;
ADDRGP4 $68
JUMPV
LABELV $67
line 40
;39:		default:
;40:			total += cg.snap->ps.ammo[cg.predictedPlayerState.weapon] * 200;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 200
ADDRGP4 cg+105532+144
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 420
ADDP4
ADDP4
INDIRI4
MULI4
ADDI4
ASGNI4
line 41
;41:			break;
LABELV $68
line 43
;42:		}
;43:		if ( total >= 5000 ) {
ADDRLP4 4
INDIRI4
CNSTI4 5000
LTI4 $80
line 44
;44:			cg.lowAmmoWarning = 0;
ADDRGP4 cg+111872
CNSTI4 0
ASGNI4
line 45
;45:			return;
ADDRGP4 $60
JUMPV
LABELV $80
line 48
;46:		}
;47:
;48:	}
LABELV $62
line 49
;49:	for ( i = WP_MACHINEGUN ; i < WP_NUM_WEAPONS ; i++ ) {
ADDRLP4 0
CNSTI4 2
ASGNI4
LABELV $83
line 50
;50:		if ( ! ( weapons & ( 1 << i ) ) ) {
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $87
line 51
;51:			continue;
ADDRGP4 $84
JUMPV
LABELV $87
line 53
;52:		}
;53:		switch ( i ) {
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $89
ADDRLP4 0
INDIRI4
CNSTI4 7
GTI4 $89
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $94-12
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $94
address $91
address $91
address $91
address $89
address $91
code
LABELV $91
line 58
;54:		case WP_ROCKET_LAUNCHER:
;55:		case WP_GRENADE_LAUNCHER:
;56:		case WP_RAILGUN:
;57:		case WP_SHOTGUN:
;58:			total += cg.snap->ps.ammo[i] * 1000;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1000
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 420
ADDP4
ADDP4
INDIRI4
MULI4
ADDI4
ASGNI4
line 59
;59:			break;
ADDRGP4 $90
JUMPV
LABELV $89
line 61
;60:		default:
;61:			total += cg.snap->ps.ammo[i] * 200;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 200
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 420
ADDP4
ADDP4
INDIRI4
MULI4
ADDI4
ASGNI4
line 62
;62:			break;
LABELV $90
line 64
;63:		}
;64:		if ( total >= 5000 ) {
ADDRLP4 4
INDIRI4
CNSTI4 5000
LTI4 $96
line 65
;65:			cg.lowAmmoWarning = 0;
ADDRGP4 cg+111872
CNSTI4 0
ASGNI4
line 66
;66:			return;
ADDRGP4 $60
JUMPV
LABELV $96
line 68
;67:		}
;68:	}
LABELV $84
line 49
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 10
LTI4 $83
line 70
;69:
;70:	previous = cg.lowAmmoWarning;
ADDRLP4 12
ADDRGP4 cg+111872
INDIRI4
ASGNI4
line 72
;71:
;72:	if ( total == 0 ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $100
line 73
;73:		cg.lowAmmoWarning = 2;
ADDRGP4 cg+111872
CNSTI4 2
ASGNI4
line 74
;74:	} else {
ADDRGP4 $101
JUMPV
LABELV $100
line 75
;75:		cg.lowAmmoWarning = 1;
ADDRGP4 cg+111872
CNSTI4 1
ASGNI4
line 76
;76:	}
LABELV $101
line 79
;77:
;78:	// play a sound on transitions
;79:	if ( cg.lowAmmoWarning != previous ) {
ADDRGP4 cg+111872
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $104
line 80
;80:		trap_S_StartLocalSound( cgs.media.noAmmoSound, CHAN_LOCAL_SOUND );
ADDRGP4 cgs+170516+632
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 81
;81:	}
LABELV $104
line 82
;82:}
LABELV $60
endproc CG_CheckAmmo 20 8
export CG_DamageFeedback
proc CG_DamageFeedback 72 16
line 89
;83:
;84:/*
;85:==============
;86:CG_DamageFeedback
;87:==============
;88:*/
;89:void CG_DamageFeedback( int yawByte, int pitchByte, int damage ) {
line 100
;90:	float		left, front, up;
;91:	float		kick;
;92:	int			health;
;93:	float		scale;
;94:	vec3_t		dir;
;95:	vec3_t		angles;
;96:	float		dist;
;97:	float		yaw, pitch;
;98:
;99:	// show the attacking player's head and name in corner
;100:	cg.attackerTime = cg.time;
ADDRGP4 cg+111896
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 103
;101:
;102:	// the lower on health you are, the greater the view kick will be
;103:	health = cg.snap->ps.stats[STAT_HEALTH];
ADDRLP4 20
ADDRGP4 cg+32
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
ASGNI4
line 104
;104:	if ( health < 40 ) {
ADDRLP4 20
INDIRI4
CNSTI4 40
GEI4 $113
line 105
;105:		scale = 1;
ADDRLP4 28
CNSTF4 1065353216
ASGNF4
line 106
;106:	} else {
ADDRGP4 $114
JUMPV
LABELV $113
line 107
;107:		scale = 40.0 / health;
ADDRLP4 28
CNSTF4 1109393408
ADDRLP4 20
INDIRI4
CVIF4 4
DIVF4
ASGNF4
line 108
;108:	}
LABELV $114
line 109
;109:	kick = damage * scale;
ADDRLP4 12
ADDRFP4 8
INDIRI4
CVIF4 4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 111
;110:
;111:	if (kick < 5)
ADDRLP4 12
INDIRF4
CNSTF4 1084227584
GEF4 $115
line 112
;112:		kick = 5;
ADDRLP4 12
CNSTF4 1084227584
ASGNF4
LABELV $115
line 113
;113:	if (kick > 10)
ADDRLP4 12
INDIRF4
CNSTF4 1092616192
LEF4 $117
line 114
;114:		kick = 10;
ADDRLP4 12
CNSTF4 1092616192
ASGNF4
LABELV $117
line 117
;115:
;116:	// if yaw and pitch are both 255, make the damage always centered (falling, etc)
;117:	if ( yawByte == 255 && pitchByte == 255 ) {
ADDRLP4 60
CNSTI4 255
ASGNI4
ADDRFP4 0
INDIRI4
ADDRLP4 60
INDIRI4
NEI4 $119
ADDRFP4 4
INDIRI4
ADDRLP4 60
INDIRI4
NEI4 $119
line 118
;118:		cg.damageX = 0;
ADDRGP4 cg+111948
CNSTF4 0
ASGNF4
line 119
;119:		cg.damageY = 0;
ADDRGP4 cg+111952
CNSTF4 0
ASGNF4
line 120
;120:		cg.v_dmg_roll = 0;
ADDRGP4 cg+111996
CNSTF4 0
ASGNF4
line 121
;121:		cg.v_dmg_pitch = -kick;
ADDRGP4 cg+111992
ADDRLP4 12
INDIRF4
NEGF4
ASGNF4
line 122
;122:	} else {
ADDRGP4 $120
JUMPV
LABELV $119
line 124
;123:		// positional
;124:		pitch = pitchByte / 255.0 * 360;
ADDRLP4 56
CNSTF4 1135869952
ADDRFP4 4
INDIRI4
CVIF4 4
CNSTF4 1132396544
DIVF4
MULF4
ASGNF4
line 125
;125:		yaw = yawByte / 255.0 * 360;
ADDRLP4 52
CNSTF4 1135869952
ADDRFP4 0
INDIRI4
CVIF4 4
CNSTF4 1132396544
DIVF4
MULF4
ASGNF4
line 127
;126:
;127:		angles[PITCH] = pitch;
ADDRLP4 32
ADDRLP4 56
INDIRF4
ASGNF4
line 128
;128:		angles[YAW] = yaw;
ADDRLP4 32+4
ADDRLP4 52
INDIRF4
ASGNF4
line 129
;129:		angles[ROLL] = 0;
ADDRLP4 32+8
CNSTF4 0
ASGNF4
line 131
;130:
;131:		AngleVectors( angles, dir, NULL, NULL );
ADDRLP4 32
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 64
CNSTP4 0
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 132
;132:		VectorSubtract( vec3_origin, dir, dir );
ADDRLP4 0
ADDRGP4 vec3_origin
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRGP4 vec3_origin+4
INDIRF4
ADDRLP4 0+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRGP4 vec3_origin+8
INDIRF4
ADDRLP4 0+8
INDIRF4
SUBF4
ASGNF4
line 134
;133:
;134:		front = DotProduct (dir, cg.refdef.viewaxis[0] );
ADDRLP4 16
ADDRLP4 0
INDIRF4
ADDRGP4 cg+106800+36
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRGP4 cg+106800+36+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRGP4 cg+106800+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 135
;135:		left = DotProduct (dir, cg.refdef.viewaxis[1] );
ADDRLP4 24
ADDRLP4 0
INDIRF4
ADDRGP4 cg+106800+36+12
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRGP4 cg+106800+36+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRGP4 cg+106800+36+12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 136
;136:		up = DotProduct (dir, cg.refdef.viewaxis[2] );
ADDRLP4 48
ADDRLP4 0
INDIRF4
ADDRGP4 cg+106800+36+24
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRGP4 cg+106800+36+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRGP4 cg+106800+36+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 138
;137:
;138:		dir[0] = front;
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 139
;139:		dir[1] = left;
ADDRLP4 0+4
ADDRLP4 24
INDIRF4
ASGNF4
line 140
;140:		dir[2] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 141
;141:		dist = VectorLength( dir );
ADDRLP4 0
ARGP4
ADDRLP4 68
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 44
ADDRLP4 68
INDIRF4
ASGNF4
line 142
;142:		if ( dist < 0.1 ) {
ADDRLP4 44
INDIRF4
CNSTF4 1036831949
GEF4 $171
line 143
;143:			dist = 0.1;
ADDRLP4 44
CNSTF4 1036831949
ASGNF4
line 144
;144:		}
LABELV $171
line 146
;145:
;146:		cg.v_dmg_roll = kick * left;
ADDRGP4 cg+111996
ADDRLP4 12
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
line 148
;147:		
;148:		cg.v_dmg_pitch = -kick * front;
ADDRGP4 cg+111992
ADDRLP4 12
INDIRF4
NEGF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 150
;149:
;150:		if ( front <= 0.1 ) {
ADDRLP4 16
INDIRF4
CNSTF4 1036831949
GTF4 $175
line 151
;151:			front = 0.1;
ADDRLP4 16
CNSTF4 1036831949
ASGNF4
line 152
;152:		}
LABELV $175
line 153
;153:		cg.damageX = -left / front;
ADDRGP4 cg+111948
ADDRLP4 24
INDIRF4
NEGF4
ADDRLP4 16
INDIRF4
DIVF4
ASGNF4
line 154
;154:		cg.damageY = up / dist;
ADDRGP4 cg+111952
ADDRLP4 48
INDIRF4
ADDRLP4 44
INDIRF4
DIVF4
ASGNF4
line 155
;155:	}
LABELV $120
line 158
;156:
;157:	// clamp the position
;158:	if ( cg.damageX > 1.0 ) {
ADDRGP4 cg+111948
INDIRF4
CNSTF4 1065353216
LEF4 $179
line 159
;159:		cg.damageX = 1.0;
ADDRGP4 cg+111948
CNSTF4 1065353216
ASGNF4
line 160
;160:	}
LABELV $179
line 161
;161:	if ( cg.damageX < - 1.0 ) {
ADDRGP4 cg+111948
INDIRF4
CNSTF4 3212836864
GEF4 $183
line 162
;162:		cg.damageX = -1.0;
ADDRGP4 cg+111948
CNSTF4 3212836864
ASGNF4
line 163
;163:	}
LABELV $183
line 165
;164:
;165:	if ( cg.damageY > 1.0 ) {
ADDRGP4 cg+111952
INDIRF4
CNSTF4 1065353216
LEF4 $187
line 166
;166:		cg.damageY = 1.0;
ADDRGP4 cg+111952
CNSTF4 1065353216
ASGNF4
line 167
;167:	}
LABELV $187
line 168
;168:	if ( cg.damageY < - 1.0 ) {
ADDRGP4 cg+111952
INDIRF4
CNSTF4 3212836864
GEF4 $191
line 169
;169:		cg.damageY = -1.0;
ADDRGP4 cg+111952
CNSTF4 3212836864
ASGNF4
line 170
;170:	}
LABELV $191
line 173
;171:
;172:	// don't let the screen flashes vary as much
;173:	if ( kick > 10 ) {
ADDRLP4 12
INDIRF4
CNSTF4 1092616192
LEF4 $195
line 174
;174:		kick = 10;
ADDRLP4 12
CNSTF4 1092616192
ASGNF4
line 175
;175:	}
LABELV $195
line 176
;176:	cg.damageValue = kick;
ADDRGP4 cg+111956
ADDRLP4 12
INDIRF4
ASGNF4
line 177
;177:	cg.v_dmg_time = cg.time + DAMAGE_TIME;
ADDRGP4 cg+111988
ADDRGP4 cg+105504
INDIRI4
CNSTI4 500
ADDI4
CVIF4 4
ASGNF4
line 178
;178:	cg.damageTime = cg.snap->serverTime;
ADDRGP4 cg+111944
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 179
;179:}
LABELV $109
endproc CG_DamageFeedback 72 16
export CG_Respawn
proc CG_Respawn 0 0
line 191
;180:
;181:
;182:
;183:
;184:/*
;185:================
;186:CG_Respawn
;187:
;188:A respawn happened this snapshot
;189:================
;190:*/
;191:void CG_Respawn( void ) {
line 193
;192:	// no error decay on player movement
;193:	cg.thisFrameTeleport = qtrue;
ADDRGP4 cg+105492
CNSTI4 1
ASGNI4
line 196
;194:
;195:	// display weapons available
;196:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 199
;197:
;198:	// select the weapon the server says we are using
;199:	cg.weaponSelect = cg.snap->ps.weapon;
ADDRGP4 cg+106700
ADDRGP4 cg+32
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ASGNI4
line 200
;200:}
LABELV $202
endproc CG_Respawn 0 0
export CG_CheckPlayerstateEvents
proc CG_CheckPlayerstateEvents 40 8
line 209
;201:
;202:
;203:/*
;204:==============
;205:CG_CheckPlayerstateEvents
;206:
;207:==============
;208:*/
;209:void CG_CheckPlayerstateEvents( playerState_t *ps, playerState_t *ops ) {
line 214
;210:	int			i;
;211:	int			event;
;212:	centity_t	*cent;
;213:
;214:	if ( ps->externalEvent && ps->externalEvent != ops->externalEvent ) {
ADDRLP4 12
CNSTI4 128
ASGNI4
ADDRLP4 16
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $209
ADDRLP4 16
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
EQI4 $209
line 215
;215:		cent = &cg_entities[ ps->clientNum ];
ADDRLP4 4
CNSTI4 680
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 216
;216:		cent->currentState.event = ps->externalEvent;
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 128
ADDP4
INDIRI4
ASGNI4
line 217
;217:		cent->currentState.eventParm = ps->externalEventParm;
ADDRLP4 4
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 132
ADDP4
INDIRI4
ASGNI4
line 218
;218:		CG_EntityEvent( cent, cent->lerpOrigin );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 CG_EntityEvent
CALLV
pop
line 219
;219:	}
LABELV $209
line 221
;220:
;221:	cent = &cg.predictedPlayerEntity; // cg_entities[ ps->clientNum ];
ADDRLP4 4
ADDRGP4 cg+105976
ASGNP4
line 223
;222:
;223:	for ( i = ps->eventSequence - MAX_PS_EVENTS ; i < ps->eventSequence ; i++ ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 2
SUBI4
ASGNI4
ADDRGP4 $215
JUMPV
LABELV $212
line 224
;224:		if ( ps->events[i & (MAX_PS_EVENTS-1)] != ops->events[i & (MAX_PS_EVENTS-1)]
ADDRLP4 24
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 28
CNSTI4 112
ASGNI4
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 24
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
ADDP4
INDIRI4
ADDRLP4 24
INDIRI4
ADDRLP4 32
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
ADDP4
INDIRI4
NEI4 $218
ADDRLP4 0
INDIRI4
ADDRLP4 32
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
LTI4 $216
LABELV $218
line 225
;225:			|| i >= ops->eventSequence ) {
line 226
;226:			event = ps->events[ i & (MAX_PS_EVENTS-1) ];
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDP4
INDIRI4
ASGNI4
line 228
;227:
;228:			cent->currentState.event = event;
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 229
;229:			cent->currentState.eventParm = ps->eventParms[ i & (MAX_PS_EVENTS-1) ];
ADDRLP4 4
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
ADDP4
INDIRI4
ASGNI4
line 230
;230:			CG_EntityEvent( cent, cent->lerpOrigin );
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 CG_EntityEvent
CALLV
pop
line 231
;231:		}
LABELV $216
line 232
;232:	}
LABELV $213
line 223
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $215
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
LTI4 $212
line 233
;233:}
LABELV $208
endproc CG_CheckPlayerstateEvents 40 8
export CG_CheckLocalSounds
proc CG_CheckLocalSounds 32 8
line 240
;234:
;235:/*
;236:==================
;237:CG_CheckLocalSounds
;238:==================
;239:*/
;240:void CG_CheckLocalSounds( playerState_t *ps, playerState_t *ops ) {
line 244
;241:	int			highScore;
;242:
;243:	// hit changes
;244:	if ( ps->persistant[PERS_HITS] > ops->persistant[PERS_HITS] ) {
ADDRLP4 4
CNSTI4 252
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRI4
LEI4 $220
line 245
;245:		trap_S_StartLocalSound( cgs.media.hitSound, CHAN_LOCAL_SOUND );
ADDRGP4 cgs+170516+680
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 246
;246:	} else if ( ps->persistant[PERS_HITS] < ops->persistant[PERS_HITS] ) {
ADDRGP4 $221
JUMPV
LABELV $220
ADDRLP4 8
CNSTI4 252
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
GEI4 $224
line 247
;247:		trap_S_StartLocalSound( cgs.media.hitTeamSound, CHAN_LOCAL_SOUND );
ADDRGP4 cgs+170516+684
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 248
;248:	}
LABELV $224
LABELV $221
line 251
;249:
;250:	// health changes of more than -1 should make pain sounds
;251:	if ( ps->stats[STAT_HEALTH] < ops->stats[STAT_HEALTH] - 1 ) {
ADDRLP4 12
CNSTI4 184
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
CNSTI4 1
SUBI4
GEI4 $228
line 252
;252:		if ( ps->stats[STAT_HEALTH] > 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
LEI4 $230
line 253
;253:			CG_PainEvent( &cg.predictedPlayerEntity, ps->stats[STAT_HEALTH] );
ADDRGP4 cg+105976
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_PainEvent
CALLV
pop
line 254
;254:		}
LABELV $230
line 255
;255:	}
LABELV $228
line 259
;256:
;257:
;258:	// if we are going into the intermission, don't start any voices
;259:	if ( cg.intermissionStarted ) {
ADDRGP4 cg+20
INDIRI4
CNSTI4 0
EQI4 $233
line 260
;260:		return;
ADDRGP4 $219
JUMPV
LABELV $233
line 264
;261:	}
;262:
;263:	// reward sounds
;264:	if ( ps->persistant[PERS_REWARD_COUNT] > ops->persistant[PERS_REWARD_COUNT] ) {
ADDRLP4 16
CNSTI4 268
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
LEI4 $236
line 265
;265:		switch ( ps->persistant[PERS_REWARD] ) {
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 272
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 1
LTI4 $238
ADDRLP4 20
INDIRI4
CNSTI4 4
GTI4 $238
ADDRLP4 20
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $274-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $274
address $241
address $250
address $259
address $262
code
LABELV $241
line 267
;266:		case REWARD_IMPRESSIVE:
;267:			trap_S_StartLocalSound( cgs.media.impressiveSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+688
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 268
;268:			cg.rewardTime = cg.time;
ADDRGP4 cg+111900
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 269
;269:			cg.rewardShader = cgs.media.medalImpressive;
ADDRGP4 cg+111908
ADDRGP4 cgs+170516+428
INDIRI4
ASGNI4
line 270
;270:			cg.rewardCount = ps->persistant[PERS_IMPRESSIVE_COUNT];
ADDRGP4 cg+111904
ADDRFP4 0
INDIRP4
CNSTI4 284
ADDP4
INDIRI4
ASGNI4
line 271
;271:			break;
ADDRGP4 $237
JUMPV
LABELV $250
line 273
;272:		case REWARD_EXCELLENT:
;273:			trap_S_StartLocalSound( cgs.media.excellentSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+692
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 274
;274:			cg.rewardTime = cg.time;
ADDRGP4 cg+111900
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 275
;275:			cg.rewardShader = cgs.media.medalExcellent;
ADDRGP4 cg+111908
ADDRGP4 cgs+170516+432
INDIRI4
ASGNI4
line 276
;276:			cg.rewardCount = ps->persistant[PERS_EXCELLENT_COUNT];
ADDRGP4 cg+111904
ADDRFP4 0
INDIRP4
CNSTI4 288
ADDP4
INDIRI4
ASGNI4
line 277
;277:			break;
ADDRGP4 $237
JUMPV
LABELV $259
line 279
;278:		case REWARD_DENIED:
;279:			trap_S_StartLocalSound( cgs.media.deniedSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+696
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 280
;280:			break;
ADDRGP4 $237
JUMPV
LABELV $262
line 282
;281:		case REWARD_GAUNTLET:
;282:			trap_S_StartLocalSound( cgs.media.humiliationSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+700
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 284
;283:			// if we are the killer and not the killee, show the award
;284:			if ( ps->stats[STAT_HEALTH] ) {
ADDRFP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
EQI4 $237
line 285
;285:				cg.rewardTime = cg.time;
ADDRGP4 cg+111900
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 286
;286:				cg.rewardShader = cgs.media.medalGauntlet;
ADDRGP4 cg+111908
ADDRGP4 cgs+170516+436
INDIRI4
ASGNI4
line 287
;287:				cg.rewardCount = ps->persistant[PERS_GAUNTLET_FRAG_COUNT];
ADDRGP4 cg+111904
ADDRFP4 0
INDIRP4
CNSTI4 292
ADDP4
INDIRI4
ASGNI4
line 288
;288:			}
line 289
;289:			break;
ADDRGP4 $237
JUMPV
LABELV $238
line 291
;290:		default:
;291:			CG_Error( "Bad reward_t" );
ADDRGP4 $273
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 292
;292:		}
line 293
;293:	} else {
ADDRGP4 $237
JUMPV
LABELV $236
line 295
;294:		// lead changes (only if no reward)
;295:		if ( !cg.warmup ) {
ADDRGP4 cg+111912
INDIRI4
CNSTI4 0
NEI4 $276
line 297
;296:			// never play lead changes during warmup
;297:			if ( ps->persistant[PERS_RANK] != ops->persistant[PERS_RANK] ) {
ADDRLP4 20
CNSTI4 256
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
EQI4 $279
line 298
;298:				if ( cgs.gametype >= GT_TEAM ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $281
line 299
;299:					if ( ps->persistant[PERS_RANK] == 2 ) {
ADDRFP4 0
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 2
NEI4 $284
line 300
;300:						trap_S_StartLocalSound( cgs.media.teamsTiedSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+744
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 301
;301:					} else if (  ps->persistant[PERS_RANK] == 0 ) {
ADDRGP4 $282
JUMPV
LABELV $284
ADDRFP4 0
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 0
NEI4 $288
line 302
;302:						trap_S_StartLocalSound( cgs.media.redLeadsSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+736
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 303
;303:					} else if ( ps->persistant[PERS_RANK] == 1 ) {
ADDRGP4 $282
JUMPV
LABELV $288
ADDRFP4 0
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 1
NEI4 $282
line 304
;304:						trap_S_StartLocalSound( cgs.media.blueLeadsSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+740
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 305
;305:					}
line 306
;306:				} else {
ADDRGP4 $282
JUMPV
LABELV $281
line 307
;307:					if (  ps->persistant[PERS_RANK] == 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 0
NEI4 $296
line 308
;308:						trap_S_StartLocalSound( cgs.media.takenLeadSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+704
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 309
;309:					} else if ( ps->persistant[PERS_RANK] == RANK_TIED_FLAG ) {
ADDRGP4 $297
JUMPV
LABELV $296
ADDRFP4 0
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 16384
NEI4 $300
line 310
;310:						trap_S_StartLocalSound( cgs.media.tiedLeadSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+708
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 311
;311:					} else if ( ( ops->persistant[PERS_RANK] & ~RANK_TIED_FLAG ) == 0 ) {
ADDRGP4 $301
JUMPV
LABELV $300
ADDRFP4 4
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 -16385
BANDI4
CNSTI4 0
NEI4 $304
line 312
;312:						trap_S_StartLocalSound( cgs.media.lostLeadSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+712
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 313
;313:					}
LABELV $304
LABELV $301
LABELV $297
line 314
;314:				}
LABELV $282
line 315
;315:			}
LABELV $279
line 316
;316:		}
LABELV $276
line 317
;317:	}
LABELV $237
line 320
;318:
;319:	// timelimit warnings
;320:	if ( cgs.timelimit > 0 ) {
ADDRGP4 cgs+24308
INDIRI4
CNSTI4 0
LEI4 $308
line 323
;321:		int		msec;
;322:
;323:		msec = cg.time - cgs.levelStartTime;
ADDRLP4 20
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cgs+24652
INDIRI4
SUBI4
ASGNI4
line 325
;324:
;325:		if ( cgs.timelimit > 5 && !( cg.timelimitWarnings & 1 ) && msec > (cgs.timelimit - 5) * 60 * 1000 ) {
ADDRGP4 cgs+24308
INDIRI4
CNSTI4 5
LEI4 $313
ADDRGP4 cg+105516
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $313
ADDRLP4 20
INDIRI4
CNSTI4 1000
CNSTI4 60
ADDRGP4 cgs+24308
INDIRI4
MULI4
MULI4
CNSTI4 300000
SUBI4
LEI4 $313
line 326
;326:			cg.timelimitWarnings |= 1;
ADDRLP4 24
ADDRGP4 cg+105516
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 327
;327:			trap_S_StartLocalSound( cgs.media.fiveMinuteSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+660
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 328
;328:		}
LABELV $313
line 329
;329:		if ( !( cg.timelimitWarnings & 2 ) && msec > (cgs.timelimit - 1) * 60 * 1000 ) {
ADDRGP4 cg+105516
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
NEI4 $321
ADDRLP4 20
INDIRI4
CNSTI4 1000
CNSTI4 60
ADDRGP4 cgs+24308
INDIRI4
MULI4
MULI4
CNSTI4 60000
SUBI4
LEI4 $321
line 330
;330:			cg.timelimitWarnings |= 2;
ADDRLP4 24
ADDRGP4 cg+105516
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 331
;331:			trap_S_StartLocalSound( cgs.media.oneMinuteSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+656
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 332
;332:		}
LABELV $321
line 333
;333:		if ( !( cg.timelimitWarnings & 4 ) && msec > ( cgs.timelimit * 60 + 2 ) * 1000 ) {
ADDRGP4 cg+105516
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
NEI4 $328
ADDRLP4 20
INDIRI4
CNSTI4 1000
CNSTI4 60
ADDRGP4 cgs+24308
INDIRI4
MULI4
MULI4
CNSTI4 2000
ADDI4
LEI4 $328
line 334
;334:			cg.timelimitWarnings |= 4;
ADDRLP4 24
ADDRGP4 cg+105516
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 4
BORI4
ASGNI4
line 335
;335:			trap_S_StartLocalSound( cgs.media.suddenDeathSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+664
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 336
;336:		}
LABELV $328
line 337
;337:	}
LABELV $308
line 340
;338:
;339:	// fraglimit warnings
;340:	if ( cgs.fraglimit > 0 && cgs.gametype != GT_CTF ) {
ADDRGP4 cgs+24300
INDIRI4
CNSTI4 0
LEI4 $335
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 4
EQI4 $335
line 341
;341:		highScore = cgs.scores1;
ADDRLP4 0
ADDRGP4 cgs+24656
INDIRI4
ASGNI4
line 342
;342:		if ( cgs.fraglimit > 3 && !( cg.fraglimitWarnings & 1 ) && highScore == (cgs.fraglimit - 3) ) {
ADDRLP4 20
CNSTI4 3
ASGNI4
ADDRGP4 cgs+24300
INDIRI4
ADDRLP4 20
INDIRI4
LEI4 $340
ADDRGP4 cg+105520
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $340
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+24300
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
NEI4 $340
line 343
;343:			cg.fraglimitWarnings |= 1;
ADDRLP4 24
ADDRGP4 cg+105520
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 344
;344:			trap_S_StartLocalSound( cgs.media.threeFragSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+668
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 345
;345:		}
LABELV $340
line 346
;346:		if ( cgs.fraglimit > 2 && !( cg.fraglimitWarnings & 2 ) && highScore == (cgs.fraglimit - 2) ) {
ADDRLP4 24
CNSTI4 2
ASGNI4
ADDRGP4 cgs+24300
INDIRI4
ADDRLP4 24
INDIRI4
LEI4 $348
ADDRGP4 cg+105520
INDIRI4
ADDRLP4 24
INDIRI4
BANDI4
CNSTI4 0
NEI4 $348
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+24300
INDIRI4
ADDRLP4 24
INDIRI4
SUBI4
NEI4 $348
line 347
;347:			cg.fraglimitWarnings |= 2;
ADDRLP4 28
ADDRGP4 cg+105520
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 348
;348:			trap_S_StartLocalSound( cgs.media.twoFragSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+672
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 349
;349:		}
LABELV $348
line 350
;350:		if ( !( cg.fraglimitWarnings & 4 ) && highScore == (cgs.fraglimit - 1) ) {
ADDRGP4 cg+105520
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
NEI4 $356
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+24300
INDIRI4
CNSTI4 1
SUBI4
NEI4 $356
line 351
;351:			cg.fraglimitWarnings |= 4;
ADDRLP4 28
ADDRGP4 cg+105520
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 4
BORI4
ASGNI4
line 352
;352:			trap_S_StartLocalSound( cgs.media.oneFragSound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+676
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 353
;353:		}
LABELV $356
line 354
;354:	}
LABELV $335
line 355
;355:}
LABELV $219
endproc CG_CheckLocalSounds 32 8
export CG_TransitionPlayerState
proc CG_TransitionPlayerState 24 12
line 363
;356:
;357:/*
;358:===============
;359:CG_TransitionPlayerState
;360:
;361:===============
;362:*/
;363:void CG_TransitionPlayerState( playerState_t *ps, playerState_t *ops ) {
line 365
;364:	// check for changing follow mode
;365:	if ( ps->clientNum != ops->clientNum ) {
ADDRLP4 0
CNSTI4 140
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRI4
EQI4 $364
line 366
;366:		cg.thisFrameTeleport = qtrue;
ADDRGP4 cg+105492
CNSTI4 1
ASGNI4
line 368
;367:		// make sure we don't get any unwanted transition effects
;368:		*ops = *ps;
ADDRFP4 4
INDIRP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 444
line 369
;369:	}
LABELV $364
line 372
;370:
;371:	// damage events (player is getting wounded)
;372:	if ( ps->damageEvent != ops->damageEvent && ps->damageCount ) {
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
CNSTI4 168
ASGNI4
ADDRLP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
EQI4 $367
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CNSTI4 0
EQI4 $367
line 373
;373:		CG_DamageFeedback( ps->damageYaw, ps->damagePitch, ps->damageCount );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 172
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 176
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DamageFeedback
CALLV
pop
line 374
;374:	}
LABELV $367
line 377
;375:
;376:	// respawning
;377:	if ( ps->persistant[PERS_SPAWN_COUNT] != ops->persistant[PERS_SPAWN_COUNT] ) {
ADDRLP4 12
CNSTI4 264
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
EQI4 $369
line 378
;378:		CG_Respawn();
ADDRGP4 CG_Respawn
CALLV
pop
line 379
;379:	}
LABELV $369
line 381
;380:
;381:	if ( cg.snap->ps.pm_type != PM_INTERMISSION 
ADDRGP4 cg+32
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 5
EQI4 $371
ADDRFP4 0
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 3
EQI4 $371
line 382
;382:		&& ps->persistant[PERS_TEAM] != TEAM_SPECTATOR ) {
line 383
;383:		CG_CheckLocalSounds( ps, ops );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 CG_CheckLocalSounds
CALLV
pop
line 384
;384:	}
LABELV $371
line 387
;385:
;386:	// check for going low on ammo
;387:	CG_CheckAmmo();
ADDRGP4 CG_CheckAmmo
CALLV
pop
line 390
;388:
;389:	// run events
;390:	CG_CheckPlayerstateEvents( ps, ops );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 CG_CheckPlayerstateEvents
CALLV
pop
line 393
;391:
;392:	// smooth the ducking viewheight change
;393:	if ( ps->viewheight != ops->viewheight ) {
ADDRLP4 16
CNSTI4 164
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
EQI4 $374
line 394
;394:		cg.duckChange = ps->viewheight - ops->viewheight;
ADDRLP4 20
CNSTI4 164
ASGNI4
ADDRGP4 cg+106684
ADDRFP4 0
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 395
;395:		cg.duckTime = cg.time;
ADDRGP4 cg+106688
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 396
;396:	}
LABELV $374
line 397
;397:}
LABELV $363
endproc CG_TransitionPlayerState 24 12
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $273
byte 1 66
byte 1 97
byte 1 100
byte 1 32
byte 1 114
byte 1 101
byte 1 119
byte 1 97
byte 1 114
byte 1 100
byte 1 95
byte 1 116
byte 1 0
