export CG_InitLocalEntities
code
proc CG_InitLocalEntities 12 12
file "..\cg_localents.c"
line 21
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:// cg_localents.c -- every frame, generate renderer commands for locally
;5:// processed entities, like smoke puffs, gibs, shells, etc.
;6:
;7:#include "cg_local.h"
;8:
;9:#define	MAX_LOCAL_ENTITIES	512
;10:localEntity_t	cg_localEntities[MAX_LOCAL_ENTITIES];
;11:localEntity_t	cg_activeLocalEntities;		// double linked list
;12:localEntity_t	*cg_freeLocalEntities;		// single linked list
;13:
;14:/*
;15:===================
;16:CG_InitLocalEntities
;17:
;18:This is called at startup and for tournement restarts
;19:===================
;20:*/
;21:void	CG_InitLocalEntities( void ) {
line 24
;22:	int		i;
;23:
;24:	memset( cg_localEntities, 0, sizeof( cg_localEntities ) );
ADDRGP4 cg_localEntities
ARGP4
CNSTI4 0
ARGI4
CNSTU4 147456
ARGU4
ADDRGP4 memset
CALLP4
pop
line 25
;25:	cg_activeLocalEntities.next = &cg_activeLocalEntities;
ADDRGP4 cg_activeLocalEntities+4
ADDRGP4 cg_activeLocalEntities
ASGNP4
line 26
;26:	cg_activeLocalEntities.prev = &cg_activeLocalEntities;
ADDRLP4 4
ADDRGP4 cg_activeLocalEntities
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
ASGNP4
line 27
;27:	cg_freeLocalEntities = cg_localEntities;
ADDRGP4 cg_freeLocalEntities
ADDRGP4 cg_localEntities
ASGNP4
line 28
;28:	for ( i = 0 ; i < MAX_LOCAL_ENTITIES - 1 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $62
line 29
;29:		cg_localEntities[i].next = &cg_localEntities[i+1];
ADDRLP4 8
CNSTI4 288
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 8
INDIRI4
ADDRGP4 cg_localEntities+4
ADDP4
ADDRLP4 8
INDIRI4
ADDRGP4 cg_localEntities+288
ADDP4
ASGNP4
line 30
;30:	}
LABELV $63
line 28
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 511
LTI4 $62
line 31
;31:}
LABELV $60
endproc CG_InitLocalEntities 12 12
export CG_FreeLocalEntity
proc CG_FreeLocalEntity 12 4
line 39
;32:
;33:
;34:/*
;35:==================
;36:CG_FreeLocalEntity
;37:==================
;38:*/
;39:void CG_FreeLocalEntity( localEntity_t *le ) {
line 40
;40:	if ( !le->prev ) {
ADDRFP4 0
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $69
line 41
;41:		CG_Error( "CG_FreeLocalEntity: not active" );
ADDRGP4 $71
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 42
;42:	}
LABELV $69
line 45
;43:
;44:	// remove from the doubly linked active list
;45:	le->prev->next = le->next;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 4
ASGNI4
ADDRLP4 0
INDIRP4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
ASGNP4
line 46
;46:	le->next->prev = le->prev;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ADDRLP4 8
INDIRP4
INDIRP4
ASGNP4
line 49
;47:
;48:	// the free list is only singly linked
;49:	le->next = cg_freeLocalEntities;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg_freeLocalEntities
INDIRP4
ASGNP4
line 50
;50:	cg_freeLocalEntities = le;
ADDRGP4 cg_freeLocalEntities
ADDRFP4 0
INDIRP4
ASGNP4
line 51
;51:}
LABELV $68
endproc CG_FreeLocalEntity 12 4
export CG_AllocLocalEntity
proc CG_AllocLocalEntity 8 12
line 60
;52:
;53:/*
;54:===================
;55:CG_AllocLocalEntity
;56:
;57:Will allways succeed, even if it requires freeing an old active entity
;58:===================
;59:*/
;60:localEntity_t	*CG_AllocLocalEntity( void ) {
line 63
;61:	localEntity_t	*le;
;62:
;63:	if ( !cg_freeLocalEntities ) {
ADDRGP4 cg_freeLocalEntities
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $73
line 66
;64:		// no free entities, so free the one at the end of the chain
;65:		// remove the oldest active entity
;66:		CG_FreeLocalEntity( cg_activeLocalEntities.prev );
ADDRGP4 cg_activeLocalEntities
INDIRP4
ARGP4
ADDRGP4 CG_FreeLocalEntity
CALLV
pop
line 67
;67:	}
LABELV $73
line 69
;68:
;69:	le = cg_freeLocalEntities;
ADDRLP4 0
ADDRGP4 cg_freeLocalEntities
INDIRP4
ASGNP4
line 70
;70:	cg_freeLocalEntities = cg_freeLocalEntities->next;
ADDRLP4 4
ADDRGP4 cg_freeLocalEntities
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ASGNP4
line 72
;71:
;72:	memset( le, 0, sizeof( *le ) );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTU4 288
ARGU4
ADDRGP4 memset
CALLP4
pop
line 75
;73:
;74:	// link into the active list
;75:	le->next = cg_activeLocalEntities.next;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg_activeLocalEntities+4
INDIRP4
ASGNP4
line 76
;76:	le->prev = &cg_activeLocalEntities;
ADDRLP4 0
INDIRP4
ADDRGP4 cg_activeLocalEntities
ASGNP4
line 77
;77:	cg_activeLocalEntities.next->prev = le;
ADDRGP4 cg_activeLocalEntities+4
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 78
;78:	cg_activeLocalEntities.next = le;
ADDRGP4 cg_activeLocalEntities+4
ADDRLP4 0
INDIRP4
ASGNP4
line 79
;79:	return le;
ADDRLP4 0
INDIRP4
RETP4
LABELV $72
endproc CG_AllocLocalEntity 8 12
export CG_BloodTrail
proc CG_BloodTrail 44 44
line 101
;80:}
;81:
;82:
;83:/*
;84:====================================================================================
;85:
;86:FRAGMENT PROCESSING
;87:
;88:A fragment localentity interacts with the environment in some way (hitting walls),
;89:or generates more localentities along a trail.
;90:
;91:====================================================================================
;92:*/
;93:
;94:/*
;95:================
;96:CG_BloodTrail
;97:
;98:Leave expanding blood puffs behind gibs
;99:================
;100:*/
;101:void CG_BloodTrail( localEntity_t *le ) {
line 108
;102:	int		t;
;103:	int		t2;
;104:	int		step;
;105:	vec3_t	newOrigin;
;106:	localEntity_t	*blood;
;107:
;108:	step = 150;
ADDRLP4 20
CNSTI4 150
ASGNI4
line 109
;109:	t = step * ( (cg.time - cg.frametime + step ) / step );
ADDRLP4 0
ADDRLP4 20
INDIRI4
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+105500
INDIRI4
SUBI4
ADDRLP4 20
INDIRI4
ADDI4
ADDRLP4 20
INDIRI4
DIVI4
MULI4
ASGNI4
line 110
;110:	t2 = step * ( cg.time / step );
ADDRLP4 24
ADDRLP4 20
INDIRI4
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 20
INDIRI4
DIVI4
MULI4
ASGNI4
line 112
;111:
;112:	for ( ; t <= t2; t += step ) {
ADDRGP4 $85
JUMPV
LABELV $82
line 113
;113:		BG_EvaluateTrajectory( &le->pos, t, newOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 115
;114:
;115:		blood = CG_SmokePuff( newOrigin, vec3_origin, 
ADDRLP4 8
ARGP4
ADDRGP4 vec3_origin
ARGP4
CNSTF4 1101004800
ARGF4
ADDRLP4 36
CNSTF4 1065353216
ASGNF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
CNSTF4 1157234688
ARGF4
ADDRLP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+224
INDIRI4
ARGI4
ADDRLP4 40
ADDRGP4 CG_SmokePuff
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 40
INDIRP4
ASGNP4
line 123
;116:					  20,		// radius
;117:					  1, 1, 1, 1,	// color
;118:					  2000,		// trailTime
;119:					  t,		// startTime
;120:					  0,		// flags
;121:					  cgs.media.bloodTrailShader );
;122:		// use the optimized version
;123:		blood->leType = LE_FALL_SCALE_FADE;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 5
ASGNI4
line 125
;124:		// drop a total of 40 units over its lifetime
;125:		blood->pos.trDelta[2] = 40;
ADDRLP4 4
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 1109393408
ASGNF4
line 126
;126:	}
LABELV $83
line 112
ADDRLP4 0
ADDRLP4 0
INDIRI4
ADDRLP4 20
INDIRI4
ADDI4
ASGNI4
LABELV $85
ADDRLP4 0
INDIRI4
ADDRLP4 24
INDIRI4
LEI4 $82
line 127
;127:}
LABELV $78
endproc CG_BloodTrail 44 44
export CG_FragmentBounceMark
proc CG_FragmentBounceMark 20 44
line 135
;128:
;129:
;130:/*
;131:================
;132:CG_FragmentBounceMark
;133:================
;134:*/
;135:void CG_FragmentBounceMark( localEntity_t *le, trace_t *trace ) {
line 138
;136:	int			radius;
;137:
;138:	if ( le->leMarkType == LEMT_BLOOD ) {
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
CNSTI4 1
NEI4 $89
line 140
;139:
;140:		radius = 16 + (rand()&31);
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
CNSTI4 31
BANDI4
CNSTI4 16
ADDI4
ASGNI4
line 141
;141:		CG_ImpactMark( cgs.media.bloodMarkShader, trace->endpos, trace->plane.normal, random()*360,
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRGP4 cgs+170516+300
INDIRI4
ARGI4
ADDRLP4 12
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 12
INDIRP4
CNSTI4 24
ADDP4
ARGP4
CNSTF4 1135869952
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ARGF4
ADDRLP4 16
CNSTF4 1065353216
ASGNF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
CNSTI4 1
ARGI4
ADDRLP4 0
INDIRI4
CVIF4 4
ARGF4
CNSTI4 0
ARGI4
ADDRGP4 CG_ImpactMark
CALLV
pop
line 143
;142:			1,1,1,1, qtrue, radius, qfalse );
;143:	}
LABELV $89
line 147
;144:
;145:	// don't allow a fragment to make multiple marks, or they
;146:	// pile up while settling
;147:	le->leMarkType = LEMT_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
CNSTI4 0
ASGNI4
line 148
;148:}
LABELV $88
endproc CG_FragmentBounceMark 20 44
export CG_FragmentBounceSound
proc CG_FragmentBounceSound 16 16
line 155
;149:
;150:/*
;151:================
;152:CG_FragmentBounceSound
;153:================
;154:*/
;155:void CG_FragmentBounceSound( localEntity_t *le, trace_t *trace ) {
line 156
;156:	if ( le->leBounceSoundType == LEBS_BLOOD ) {
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1
NEI4 $94
line 158
;157:		// half the gibs will make splat sounds
;158:		if ( rand() & 1 ) {
ADDRLP4 0
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $95
line 159
;159:			int r = rand()&3;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 12
INDIRI4
CNSTI4 3
BANDI4
ASGNI4
line 162
;160:			sfxHandle_t	s;
;161:
;162:			if ( r < 2 ) {
ADDRLP4 4
INDIRI4
CNSTI4 2
GEI4 $98
line 163
;163:				s = cgs.media.gibBounce1Sound;
ADDRLP4 8
ADDRGP4 cgs+170516+612
INDIRI4
ASGNI4
line 164
;164:			} else if ( r == 2 ) {
ADDRGP4 $99
JUMPV
LABELV $98
ADDRLP4 4
INDIRI4
CNSTI4 2
NEI4 $102
line 165
;165:				s = cgs.media.gibBounce2Sound;
ADDRLP4 8
ADDRGP4 cgs+170516+616
INDIRI4
ASGNI4
line 166
;166:			} else {
ADDRGP4 $103
JUMPV
LABELV $102
line 167
;167:				s = cgs.media.gibBounce3Sound;
ADDRLP4 8
ADDRGP4 cgs+170516+620
INDIRI4
ASGNI4
line 168
;168:			}
LABELV $103
LABELV $99
line 169
;169:			trap_S_StartSound( trace->endpos, ENTITYNUM_WORLD, CHAN_AUTO, s );
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
CNSTI4 1022
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 170
;170:		}
line 171
;171:	} else if ( le->leBounceSoundType == LEBS_BRASS ) {
ADDRGP4 $95
JUMPV
LABELV $94
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 2
NEI4 $108
line 173
;172:
;173:	}
LABELV $108
LABELV $95
line 177
;174:
;175:	// don't allow a fragment to make multiple bounce sounds,
;176:	// or it gets too noisy as they settle
;177:	le->leBounceSoundType = LEBS_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 0
ASGNI4
line 178
;178:}
LABELV $93
endproc CG_FragmentBounceSound 16 16
export CG_ReflectVelocity
proc CG_ReflectVelocity 56 12
line 186
;179:
;180:
;181:/*
;182:================
;183:CG_ReflectVelocity
;184:================
;185:*/
;186:void CG_ReflectVelocity( localEntity_t *le, trace_t *trace ) {
line 192
;187:	vec3_t	velocity;
;188:	float	dot;
;189:	int		hitTime;
;190:
;191:	// reflect the velocity on the trace plane
;192:	hitTime = cg.time - cg.frametime + cg.frametime * trace->fraction;
ADDRLP4 16
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+105500
INDIRI4
SUBI4
CVIF4 4
ADDRGP4 cg+105500
INDIRI4
CVIF4 4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 193
;193:	BG_EvaluateTrajectoryDelta( &le->pos, hitTime, velocity );
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 BG_EvaluateTrajectoryDelta
CALLV
pop
line 194
;194:	dot = DotProduct( velocity, trace->plane.normal );
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 0
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 195
;195:	VectorMA( velocity, -2*dot, trace->plane.normal, le->pos.trDelta );
ADDRFP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRLP4 0
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDRLP4 0+4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 0+8
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 3221225472
ADDRLP4 12
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 197
;196:
;197:	VectorScale( le->pos.trDelta, le->bounceFactor, le->pos.trDelta );
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
ADDRLP4 24
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 24
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 36
ADDRLP4 32
INDIRP4
CNSTI4 56
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
ADDRLP4 32
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
ADDRLP4 40
INDIRP4
CNSTI4 60
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
MULF4
ASGNF4
line 199
;198:
;199:	VectorCopy( trace->endpos, le->pos.trBase );
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 200
;200:	le->pos.trTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 204
;201:
;202:
;203:	// check for stop, making sure that even on low FPS systems it doesn't bobble
;204:	if ( trace->allsolid || 
ADDRLP4 48
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $123
ADDRLP4 48
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 0
LEF4 $119
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 60
ADDP4
INDIRF4
ASGNF4
ADDRLP4 52
INDIRF4
CNSTF4 1109393408
LTF4 $123
ADDRLP4 52
INDIRF4
ADDRGP4 cg+105500
INDIRI4
NEGI4
CVIF4 4
ADDRLP4 52
INDIRF4
MULF4
GEF4 $119
LABELV $123
line 206
;205:		( trace->plane.normal[2] > 0 && 
;206:		( le->pos.trDelta[2] < 40 || le->pos.trDelta[2] < -cg.frametime * le->pos.trDelta[2] ) ) ) {
line 207
;207:		le->pos.trType = TR_STATIONARY;
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 0
ASGNI4
line 208
;208:	} else {
LABELV $119
line 210
;209:
;210:	}
LABELV $120
line 211
;211:}
LABELV $110
endproc CG_ReflectVelocity 56 12
export CG_AddFragment
proc CG_AddFragment 88 28
line 218
;212:
;213:/*
;214:================
;215:CG_AddFragment
;216:================
;217:*/
;218:void CG_AddFragment( localEntity_t *le ) {
line 222
;219:	vec3_t	newOrigin;
;220:	trace_t	trace;
;221:
;222:	if ( le->pos.trType == TR_STATIONARY ) {
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
CNSTI4 0
NEI4 $125
line 227
;223:		// sink into the ground if near the removal time
;224:		int		t;
;225:		float	oldZ;
;226:		
;227:		t = le->endTime - cg.time;
ADDRLP4 68
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
ASGNI4
line 228
;228:		if ( t < SINK_TIME ) {
ADDRLP4 68
INDIRI4
CNSTI4 1000
GEI4 $128
line 232
;229:			// we must use an explicit lighting origin, otherwise the
;230:			// lighting would be lost as soon as the origin went
;231:			// into the ground
;232:			VectorCopy( le->refEntity.origin, le->refEntity.lightingOrigin );
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 160
ADDP4
ADDRLP4 76
INDIRP4
CNSTI4 216
ADDP4
INDIRB
ASGNB 12
line 233
;233:			le->refEntity.renderfx |= RF_LIGHTING_ORIGIN;
ADDRLP4 80
ADDRFP4 0
INDIRP4
CNSTI4 152
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 234
;234:			oldZ = le->refEntity.origin[2];
ADDRLP4 72
ADDRFP4 0
INDIRP4
CNSTI4 224
ADDP4
INDIRF4
ASGNF4
line 235
;235:			le->refEntity.origin[2] -= 16 * ( 1.0 - (float)t / SINK_TIME );
ADDRLP4 84
ADDRFP4 0
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
CNSTF4 1098907648
CNSTF4 1065353216
ADDRLP4 68
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
SUBF4
MULF4
SUBF4
ASGNF4
line 236
;236:			trap_R_AddRefEntityToScene( &le->refEntity );
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 237
;237:			le->refEntity.origin[2] = oldZ;
ADDRFP4 0
INDIRP4
CNSTI4 224
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 238
;238:		} else {
ADDRGP4 $124
JUMPV
LABELV $128
line 239
;239:			trap_R_AddRefEntityToScene( &le->refEntity );
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 240
;240:		}
line 242
;241:
;242:		return;
ADDRGP4 $124
JUMPV
LABELV $125
line 246
;243:	}
;244:
;245:	// calculate new position
;246:	BG_EvaluateTrajectory( &le->pos, cg.time, newOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRLP4 56
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 249
;247:
;248:	// trace a line from previous position to new position
;249:	CG_Trace( &trace, le->refEntity.origin, NULL, NULL, newOrigin, -1, CONTENTS_SOLID );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 216
ADDP4
ARGP4
ADDRLP4 68
CNSTP4 0
ASGNP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 68
INDIRP4
ARGP4
ADDRLP4 56
ARGP4
CNSTI4 -1
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 250
;250:	if ( trace.fraction == 1.0 ) {
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
NEF4 $131
line 252
;251:		// still in free fall
;252:		VectorCopy( newOrigin, le->refEntity.origin );
ADDRFP4 0
INDIRP4
CNSTI4 216
ADDP4
ADDRLP4 56
INDIRB
ASGNB 12
line 254
;253:
;254:		if ( le->leFlags & LEF_TUMBLE ) {
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $134
line 257
;255:			vec3_t angles;
;256:
;257:			BG_EvaluateTrajectory( &le->angles, cg.time, angles );
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRLP4 72
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 258
;258:			AnglesToAxis( angles, le->refEntity.axis );
ADDRLP4 72
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 259
;259:		}
LABELV $134
line 261
;260:
;261:		trap_R_AddRefEntityToScene( &le->refEntity );
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 264
;262:
;263:		// add a blood trail
;264:		if ( le->leBounceSoundType == LEBS_BLOOD ) {
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1
NEI4 $124
line 265
;265:			CG_BloodTrail( le );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_BloodTrail
CALLV
pop
line 266
;266:		}
line 268
;267:
;268:		return;
ADDRGP4 $124
JUMPV
LABELV $131
line 274
;269:	}
;270:
;271:	// if it is in a nodrop zone, remove it
;272:	// this keeps gibs from waiting at the bottom of pits of death
;273:	// and floating levels
;274:	if ( trap_CM_PointContents( trace.endpos, 0 ) & CONTENTS_NODROP ) {
ADDRLP4 0+12
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 72
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 72
INDIRI4
CVIU4 4
CNSTU4 2147483648
BANDU4
CNSTU4 0
EQU4 $139
line 275
;275:		CG_FreeLocalEntity( le );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeLocalEntity
CALLV
pop
line 276
;276:		return;
ADDRGP4 $124
JUMPV
LABELV $139
line 280
;277:	}
;278:
;279:	// leave a mark
;280:	CG_FragmentBounceMark( le, &trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FragmentBounceMark
CALLV
pop
line 283
;281:
;282:	// do a bouncy sound
;283:	CG_FragmentBounceSound( le, &trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FragmentBounceSound
CALLV
pop
line 286
;284:
;285:	// reflect the velocity on the trace plane
;286:	CG_ReflectVelocity( le, &trace );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 CG_ReflectVelocity
CALLV
pop
line 288
;287:
;288:	trap_R_AddRefEntityToScene( &le->refEntity );
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 289
;289:}
LABELV $124
endproc CG_AddFragment 88 28
export CG_AddExpandingFade
proc CG_AddExpandingFade 88 4
line 306
;290:
;291:/*
;292:=====================================================================
;293:
;294:TRIVIAL LOCAL ENTITIES
;295:
;296:These only do simple scaling or modulation before passing to the renderer
;297:=====================================================================
;298:*/
;299:
;300:
;301:/*
;302:====================
;303:CG_AddFadeRGB
;304:====================
;305:*/
;306:void CG_AddExpandingFade( localEntity_t *le ) {
line 310
;307:	refEntity_t *re;
;308:	float c, reScale;
;309:
;310:	re = &le->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 312
;311:
;312:	c = ( le->endTime - cg.time ) * le->lifeRate;
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 12
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 12
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ASGNF4
line 315
;313:	
;314:			
;315:	reScale = cg_railWidth.value * 0.0075 / (c + 0.2);
ADDRLP4 8
CNSTF4 1005961871
ADDRGP4 cg_railWidth+8
INDIRF4
MULF4
ADDRLP4 4
INDIRF4
CNSTF4 1045220557
ADDF4
DIVF4
ASGNF4
line 316
;316:	VectorNormalize(re->axis[0]);
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 317
;317:	VectorNormalize(re->axis[1]);
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 318
;318:	re->axis[0][0] *= reScale;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 319
;319:	re->axis[0][1] *= reScale;
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 320
;320:	re->axis[0][2] *= reScale;
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 322
;321:
;322:	re->axis[1][0] *= reScale;
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 323
;323:	re->axis[1][1] *= reScale;
ADDRLP4 32
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 324
;324:	re->axis[1][2] *= reScale;
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 326
;325:	
;326:	c *= 0xff;
ADDRLP4 4
CNSTF4 1132396544
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 328
;327:	
;328:	re->shaderRGBA[0] = le->color[0] * c;
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 48
CNSTF4 1325400064
ASGNF4
ADDRLP4 44
INDIRF4
ADDRLP4 48
INDIRF4
LTF4 $146
ADDRLP4 40
ADDRLP4 44
INDIRF4
ADDRLP4 48
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $147
JUMPV
LABELV $146
ADDRLP4 40
ADDRLP4 44
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $147
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 40
INDIRU4
CVUU1 4
ASGNU1
line 329
;329:	re->shaderRGBA[1] = le->color[1] * c;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 60
CNSTF4 1325400064
ASGNF4
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
LTF4 $149
ADDRLP4 52
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $150
JUMPV
LABELV $149
ADDRLP4 52
ADDRLP4 56
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $150
ADDRLP4 0
INDIRP4
CNSTI4 117
ADDP4
ADDRLP4 52
INDIRU4
CVUU1 4
ASGNU1
line 330
;330:	re->shaderRGBA[2] = le->color[2] * c;
ADDRLP4 68
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 72
CNSTF4 1325400064
ASGNF4
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
LTF4 $152
ADDRLP4 64
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $153
JUMPV
LABELV $152
ADDRLP4 64
ADDRLP4 68
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $153
ADDRLP4 0
INDIRP4
CNSTI4 118
ADDP4
ADDRLP4 64
INDIRU4
CVUU1 4
ASGNU1
line 331
;331:	re->shaderRGBA[3] = le->color[3] * c;
ADDRLP4 80
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 84
CNSTF4 1325400064
ASGNF4
ADDRLP4 80
INDIRF4
ADDRLP4 84
INDIRF4
LTF4 $155
ADDRLP4 76
ADDRLP4 80
INDIRF4
ADDRLP4 84
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $156
JUMPV
LABELV $155
ADDRLP4 76
ADDRLP4 80
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $156
ADDRLP4 0
INDIRP4
CNSTI4 119
ADDP4
ADDRLP4 76
INDIRU4
CVUU1 4
ASGNU1
line 333
;332:
;333:	trap_R_AddRefEntityToScene( re );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 334
;334:}
LABELV $142
endproc CG_AddExpandingFade 88 4
export CG_AddFadeRGB
proc CG_AddFadeRGB 60 4
line 341
;335:
;336:/*
;337:====================
;338:CG_AddFadeRGB
;339:====================
;340:*/
;341:void CG_AddFadeRGB( localEntity_t *le ) {
line 345
;342:	refEntity_t *re;
;343:	float c;
;344:
;345:	re = &le->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 347
;346:
;347:	c = ( le->endTime - cg.time ) * le->lifeRate;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ASGNF4
line 348
;348:	c *= 0xff;
ADDRLP4 4
CNSTF4 1132396544
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 350
;349:
;350:	re->shaderRGBA[0] = le->color[0] * c;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 20
CNSTF4 1325400064
ASGNF4
ADDRLP4 16
INDIRF4
ADDRLP4 20
INDIRF4
LTF4 $160
ADDRLP4 12
ADDRLP4 16
INDIRF4
ADDRLP4 20
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $161
JUMPV
LABELV $160
ADDRLP4 12
ADDRLP4 16
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $161
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 12
INDIRU4
CVUU1 4
ASGNU1
line 351
;351:	re->shaderRGBA[1] = le->color[1] * c;
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 32
CNSTF4 1325400064
ASGNF4
ADDRLP4 28
INDIRF4
ADDRLP4 32
INDIRF4
LTF4 $163
ADDRLP4 24
ADDRLP4 28
INDIRF4
ADDRLP4 32
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $164
JUMPV
LABELV $163
ADDRLP4 24
ADDRLP4 28
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $164
ADDRLP4 0
INDIRP4
CNSTI4 117
ADDP4
ADDRLP4 24
INDIRU4
CVUU1 4
ASGNU1
line 352
;352:	re->shaderRGBA[2] = le->color[2] * c;
ADDRLP4 40
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 44
CNSTF4 1325400064
ASGNF4
ADDRLP4 40
INDIRF4
ADDRLP4 44
INDIRF4
LTF4 $166
ADDRLP4 36
ADDRLP4 40
INDIRF4
ADDRLP4 44
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $167
JUMPV
LABELV $166
ADDRLP4 36
ADDRLP4 40
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $167
ADDRLP4 0
INDIRP4
CNSTI4 118
ADDP4
ADDRLP4 36
INDIRU4
CVUU1 4
ASGNU1
line 353
;353:	re->shaderRGBA[3] = le->color[3] * c;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
ADDRLP4 56
CNSTF4 1325400064
ASGNF4
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
LTF4 $169
ADDRLP4 48
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $170
JUMPV
LABELV $169
ADDRLP4 48
ADDRLP4 52
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $170
ADDRLP4 0
INDIRP4
CNSTI4 119
ADDP4
ADDRLP4 48
INDIRU4
CVUU1 4
ASGNU1
line 355
;354:
;355:	trap_R_AddRefEntityToScene( re );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 356
;356:}
LABELV $157
endproc CG_AddFadeRGB 60 4
proc CG_AddMoveScaleFade 48 12
line 363
;357:
;358:/*
;359:==================
;360:CG_AddMoveScaleFade
;361:==================
;362:*/
;363:static void CG_AddMoveScaleFade( localEntity_t *le ) {
line 369
;364:	refEntity_t	*re;
;365:	float		c;
;366:	vec3_t		delta;
;367:	float		len;
;368:
;369:	re = &le->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 372
;370:
;371:	// fade / grow time
;372:	c = ( le->endTime - cg.time ) * le->lifeRate;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 24
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 24
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ASGNF4
line 374
;373:
;374:	re->shaderRGBA[3] = 0xff * c * le->color[3];
ADDRLP4 32
CNSTF4 1132396544
ADDRLP4 16
INDIRF4
MULF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 36
CNSTF4 1325400064
ASGNF4
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LTF4 $174
ADDRLP4 28
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $175
JUMPV
LABELV $174
ADDRLP4 28
ADDRLP4 32
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $175
ADDRLP4 0
INDIRP4
CNSTI4 119
ADDP4
ADDRLP4 28
INDIRU4
CVUU1 4
ASGNU1
line 376
;375:
;376:	if ( !( le->leFlags & LEF_PUFF_DONT_SCALE ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $176
line 377
;377:		re->radius = le->radius * ( 1.0 - c ) + 8;
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRLP4 16
INDIRF4
SUBF4
MULF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 378
;378:	}
LABELV $176
line 380
;379:
;380:	BG_EvaluateTrajectory( &le->pos, cg.time, re->origin );
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 cg+105504
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 384
;381:
;382:	// if the view would be "inside" the sprite, kill the sprite
;383:	// so it doesn't add too much overdraw
;384:	VectorSubtract( re->origin, cg.refdef.vieworg, delta );
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRF4
ADDRGP4 cg+106800+24
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDRGP4 cg+106800+24+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDRGP4 cg+106800+24+8
INDIRF4
SUBF4
ASGNF4
line 385
;385:	len = VectorLength( delta );
ADDRLP4 4
ARGP4
ADDRLP4 44
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 44
INDIRF4
ASGNF4
line 386
;386:	if ( len < le->radius ) {
ADDRLP4 20
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
GEF4 $189
line 387
;387:		CG_FreeLocalEntity( le );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeLocalEntity
CALLV
pop
line 388
;388:		return;
ADDRGP4 $171
JUMPV
LABELV $189
line 391
;389:	}
;390:
;391:	trap_R_AddRefEntityToScene( re );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 392
;392:}
LABELV $171
endproc CG_AddMoveScaleFade 48 12
proc CG_AddScaleFade 48 4
line 404
;393:
;394:
;395:/*
;396:===================
;397:CG_AddScaleFade
;398:
;399:For rocket smokes that hang in place, fade out, and are
;400:removed if the view passes through them.
;401:There are often many of these, so it needs to be simple.
;402:===================
;403:*/
;404:static void CG_AddScaleFade( localEntity_t *le ) {
line 410
;405:	refEntity_t	*re;
;406:	float		c;
;407:	vec3_t		delta;
;408:	float		len;
;409:
;410:	re = &le->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 413
;411:
;412:	// fade / grow time
;413:	c = ( le->endTime - cg.time ) * le->lifeRate;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 24
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 24
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ASGNF4
line 415
;414:
;415:	re->shaderRGBA[3] = 0xff * c * le->color[3];
ADDRLP4 32
CNSTF4 1132396544
ADDRLP4 16
INDIRF4
MULF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 36
CNSTF4 1325400064
ASGNF4
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LTF4 $194
ADDRLP4 28
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $195
JUMPV
LABELV $194
ADDRLP4 28
ADDRLP4 32
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $195
ADDRLP4 0
INDIRP4
CNSTI4 119
ADDP4
ADDRLP4 28
INDIRU4
CVUU1 4
ASGNU1
line 416
;416:	re->radius = le->radius * ( 1.0 - c ) + 8;
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRLP4 16
INDIRF4
SUBF4
MULF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 420
;417:
;418:	// if the view would be "inside" the sprite, kill the sprite
;419:	// so it doesn't add too much overdraw
;420:	VectorSubtract( re->origin, cg.refdef.vieworg, delta );
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRF4
ADDRGP4 cg+106800+24
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDRGP4 cg+106800+24+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDRGP4 cg+106800+24+8
INDIRF4
SUBF4
ASGNF4
line 421
;421:	len = VectorLength( delta );
ADDRLP4 4
ARGP4
ADDRLP4 44
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 44
INDIRF4
ASGNF4
line 422
;422:	if ( len < le->radius ) {
ADDRLP4 20
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
GEF4 $206
line 423
;423:		CG_FreeLocalEntity( le );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeLocalEntity
CALLV
pop
line 424
;424:		return;
ADDRGP4 $191
JUMPV
LABELV $206
line 427
;425:	}
;426:
;427:	trap_R_AddRefEntityToScene( re );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 428
;428:}
LABELV $191
endproc CG_AddScaleFade 48 4
proc CG_AddFallScaleFade 52 4
line 441
;429:
;430:
;431:/*
;432:=================
;433:CG_AddFallScaleFade
;434:
;435:This is just an optimized CG_AddMoveScaleFade
;436:For blood mists that drift down, fade out, and are
;437:removed if the view passes through them.
;438:There are often 100+ of these, so it needs to be simple.
;439:=================
;440:*/
;441:static void CG_AddFallScaleFade( localEntity_t *le ) {
line 447
;442:	refEntity_t	*re;
;443:	float		c;
;444:	vec3_t		delta;
;445:	float		len;
;446:
;447:	re = &le->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 450
;448:
;449:	// fade time
;450:	c = ( le->endTime - cg.time ) * le->lifeRate;
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 24
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 24
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ASGNF4
line 452
;451:
;452:	re->shaderRGBA[3] = 0xff * c * le->color[3];
ADDRLP4 32
CNSTF4 1132396544
ADDRLP4 4
INDIRF4
MULF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 36
CNSTF4 1325400064
ASGNF4
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LTF4 $211
ADDRLP4 28
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $212
JUMPV
LABELV $211
ADDRLP4 28
ADDRLP4 32
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $212
ADDRLP4 0
INDIRP4
CNSTI4 119
ADDP4
ADDRLP4 28
INDIRU4
CVUU1 4
ASGNU1
line 454
;453:
;454:	re->origin[2] = le->pos.trBase[2] - ( 1.0 - c ) * le->pos.trDelta[2];
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 48
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRLP4 4
INDIRF4
SUBF4
ADDRLP4 40
INDIRP4
CNSTI4 60
ADDP4
INDIRF4
MULF4
SUBF4
ASGNF4
line 456
;455:
;456:	re->radius = le->radius * ( 1.0 - c ) + 16;
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRLP4 4
INDIRF4
SUBF4
MULF4
CNSTF4 1098907648
ADDF4
ASGNF4
line 460
;457:
;458:	// if the view would be "inside" the sprite, kill the sprite
;459:	// so it doesn't add too much overdraw
;460:	VectorSubtract( re->origin, cg.refdef.vieworg, delta );
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRF4
ADDRGP4 cg+106800+24
INDIRF4
SUBF4
ASGNF4
ADDRLP4 8+4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDRGP4 cg+106800+24+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 8+8
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDRGP4 cg+106800+24+8
INDIRF4
SUBF4
ASGNF4
line 461
;461:	len = VectorLength( delta );
ADDRLP4 8
ARGP4
ADDRLP4 48
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 48
INDIRF4
ASGNF4
line 462
;462:	if ( len < le->radius ) {
ADDRLP4 20
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
GEF4 $223
line 463
;463:		CG_FreeLocalEntity( le );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeLocalEntity
CALLV
pop
line 464
;464:		return;
ADDRGP4 $208
JUMPV
LABELV $223
line 467
;465:	}
;466:
;467:	trap_R_AddRefEntityToScene( re );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 468
;468:}
LABELV $208
endproc CG_AddFallScaleFade 52 4
proc CG_AddExplosion 76 20
line 477
;469:
;470:
;471:
;472:/*
;473:================
;474:CG_AddExplosion
;475:================
;476:*/
;477:static void CG_AddExplosion( localEntity_t *ex ) {
line 480
;478:	refEntity_t	*ent;
;479:	int r;
;480:	ent = &ex->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 481
;481:	r = ent->renderfx & RF_EXPANDING;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 32768
BANDI4
ASGNI4
line 482
;482:	ent->renderfx &= ~RF_EXPANDING;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -32769
BANDI4
ASGNI4
line 484
;483:	// add the entity
;484:	if(r)
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $226
line 485
;485:	{
line 487
;486:		int i, j;
;487:		float dt = ((float) (cg.time - ex->startTime)) / ((float) ( ex->endTime - ex->startTime ));
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 36
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 40
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 36
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 40
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 489
;488:		vec3_t r;
;489:		r[0] = ent->oldorigin[0] * dt;
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
line 490
;490:		r[1] = ent->oldorigin[1] * dt;
ADDRLP4 24+4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
line 491
;491:		r[2] = ent->oldorigin[2] * dt;
ADDRLP4 24+8
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
line 492
;492:		AnglesToAxis(r, ent->axis);		
ADDRLP4 24
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 493
;493:		for(i = 0; i < 3; i++)
ADDRLP4 16
CNSTI4 0
ASGNI4
LABELV $231
line 494
;494:			for(j = 0; j < 3; j++)
ADDRLP4 12
CNSTI4 0
ASGNI4
LABELV $235
line 495
;495:				ent->axis[i][j] *= 8.0 * sqrt(dt);
ADDRLP4 20
INDIRF4
ARGF4
ADDRLP4 44
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 48
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 12
ADDRLP4 16
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDP4
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
CNSTF4 1090519040
ADDRLP4 44
INDIRF4
MULF4
MULF4
ASGNF4
LABELV $236
line 494
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 3
LTI4 $235
LABELV $232
line 493
ADDRLP4 16
ADDRLP4 16
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 3
LTI4 $231
line 496
;496:		ent->shaderRGBA[3] = 255 * dt;
ADDRLP4 56
CNSTF4 1132396544
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 60
CNSTF4 1325400064
ASGNF4
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
LTF4 $240
ADDRLP4 52
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $241
JUMPV
LABELV $240
ADDRLP4 52
ADDRLP4 56
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $241
ADDRLP4 0
INDIRP4
CNSTI4 119
ADDP4
ADDRLP4 52
INDIRU4
CVUU1 4
ASGNU1
line 497
;497:		VectorMA(ex->pos.trBase, -4, ent->axis[2], ent->origin);
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 3229614080
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 3229614080
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRF4
CNSTF4 3229614080
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 498
;498:	}
LABELV $226
line 500
;499:	
;500:	trap_R_AddRefEntityToScene(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 501
;501:	ent->renderfx |= r;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
BORI4
ASGNI4
line 503
;502:	// add the dlight
;503:	if ( ex->light ) {
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
CNSTF4 0
EQF4 $242
line 506
;504:		float		light;
;505:
;506:		light = (float)( cg.time - ex->startTime ) / ( ex->endTime - ex->startTime );
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
ADDRLP4 20
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 24
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 20
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 24
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 507
;507:		if ( light < 0.5 ) {
ADDRLP4 16
INDIRF4
CNSTF4 1056964608
GEF4 $245
line 508
;508:			light = 1.0;
ADDRLP4 16
CNSTF4 1065353216
ASGNF4
line 509
;509:		} else {
ADDRGP4 $246
JUMPV
LABELV $245
line 510
;510:			light = 1.0 - ( light - 0.5 ) * 2;
ADDRLP4 16
CNSTF4 1065353216
CNSTF4 1073741824
ADDRLP4 16
INDIRF4
CNSTF4 1056964608
SUBF4
MULF4
SUBF4
ASGNF4
line 511
;511:		}
LABELV $246
line 512
;512:		light = ex->light * light;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 513
;513:		trap_R_AddLightToScene(ent->origin, light, ex->lightColor[0], ex->lightColor[1], ex->lightColor[2] );
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ARGP4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ARGF4
ADDRLP4 28
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ARGF4
ADDRLP4 28
INDIRP4
CNSTI4 136
ADDP4
INDIRF4
ARGF4
ADDRGP4 trap_R_AddLightToScene
CALLV
pop
line 514
;514:	}
LABELV $242
line 515
;515:}
LABELV $225
endproc CG_AddExplosion 76 20
proc CG_AddFalling 28 4
line 517
;516:
;517:static void CG_AddFalling( localEntity_t *ex ) {
line 520
;518:	refEntity_t	*ent;
;519:
;520:	ex->refEntity.origin[2] -= cg.frametime / 20.0;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cg+105500
INDIRI4
CVIF4 4
CNSTF4 1101004800
DIVF4
SUBF4
ASGNF4
line 521
;521:	ex->refEntity.shaderRGBA[3] *= ((rand() % 10 + 90) / 100.0);
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 267
ADDP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
INDIRU1
CVUI4 1
CVIF4 4
ADDRLP4 12
INDIRI4
CNSTI4 10
MODI4
CNSTI4 90
ADDI4
CVIF4 4
CNSTF4 1120403456
DIVF4
MULF4
ASGNF4
ADDRLP4 24
CNSTF4 1325400064
ASGNF4
ADDRLP4 20
INDIRF4
ADDRLP4 24
INDIRF4
LTF4 $250
ADDRLP4 8
ADDRLP4 20
INDIRF4
ADDRLP4 24
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $251
JUMPV
LABELV $250
ADDRLP4 8
ADDRLP4 20
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $251
ADDRLP4 16
INDIRP4
ADDRLP4 8
INDIRU4
CVUU1 4
ASGNU1
line 522
;522:	ent = &ex->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 525
;523:	
;524:	// add the entity
;525:	trap_R_AddRefEntityToScene(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 526
;526:}
LABELV $247
endproc CG_AddFalling 28 4
proc CG_AddSpriteExplosion 180 20
line 532
;527:/*
;528:================
;529:CG_AddSpriteExplosion
;530:================
;531:*/
;532:static void CG_AddSpriteExplosion( localEntity_t *le ) {
line 536
;533:	refEntity_t	re;
;534:	float c;
;535:
;536:	re = le->refEntity;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRB
ASGNB 140
line 538
;537:
;538:	c = ( le->endTime - cg.time ) / ( float ) ( le->endTime - le->startTime );
ADDRLP4 144
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 148
ADDRLP4 144
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
ADDRLP4 140
ADDRLP4 148
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 148
INDIRI4
ADDRLP4 144
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 539
;539:	if ( c > 1 ) {
ADDRLP4 140
INDIRF4
CNSTF4 1065353216
LEF4 $254
line 540
;540:		c = 1.0;	// can happen during connection problems
ADDRLP4 140
CNSTF4 1065353216
ASGNF4
line 541
;541:	}
LABELV $254
line 543
;542:
;543:	re.shaderRGBA[0] = 0xff;
ADDRLP4 0+116
CNSTU1 255
ASGNU1
line 544
;544:	re.shaderRGBA[1] = 0xff;
ADDRLP4 0+116+1
CNSTU1 255
ASGNU1
line 545
;545:	re.shaderRGBA[2] = 0xff;
ADDRLP4 0+116+2
CNSTU1 255
ASGNU1
line 546
;546:	re.shaderRGBA[3] = 0xff * c * 0.33;
ADDRLP4 156
CNSTF4 1051260355
CNSTF4 1132396544
ADDRLP4 140
INDIRF4
MULF4
MULF4
ASGNF4
ADDRLP4 160
CNSTF4 1325400064
ASGNF4
ADDRLP4 156
INDIRF4
ADDRLP4 160
INDIRF4
LTF4 $264
ADDRLP4 152
ADDRLP4 156
INDIRF4
ADDRLP4 160
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $265
JUMPV
LABELV $264
ADDRLP4 152
ADDRLP4 156
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $265
ADDRLP4 0+116+3
ADDRLP4 152
INDIRU4
CVUU1 4
ASGNU1
line 548
;547:
;548:	re.reType = RT_SPRITE;
ADDRLP4 0
CNSTI4 2
ASGNI4
line 549
;549:	re.radius = 42 * ( 1.0 - c ) + 30;
ADDRLP4 0+132
CNSTF4 1109917696
CNSTF4 1065353216
ADDRLP4 140
INDIRF4
SUBF4
MULF4
CNSTF4 1106247680
ADDF4
ASGNF4
line 551
;550:
;551:	trap_R_AddRefEntityToScene( &re );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 554
;552:
;553:	// add the dlight
;554:	if ( le->light ) {
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
CNSTF4 0
EQF4 $267
line 557
;555:		float		light;
;556:
;557:		light = (float)( cg.time - le->startTime ) / ( le->endTime - le->startTime );
ADDRLP4 168
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 172
ADDRLP4 168
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
ADDRLP4 164
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 172
INDIRI4
SUBI4
CVIF4 4
ADDRLP4 168
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 172
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 558
;558:		if ( light < 0.5 ) {
ADDRLP4 164
INDIRF4
CNSTF4 1056964608
GEF4 $270
line 559
;559:			light = 1.0;
ADDRLP4 164
CNSTF4 1065353216
ASGNF4
line 560
;560:		} else {
ADDRGP4 $271
JUMPV
LABELV $270
line 561
;561:			light = 1.0 - ( light - 0.5 ) * 2;
ADDRLP4 164
CNSTF4 1065353216
CNSTF4 1073741824
ADDRLP4 164
INDIRF4
CNSTF4 1056964608
SUBF4
MULF4
SUBF4
ASGNF4
line 562
;562:		}
LABELV $271
line 563
;563:		light = le->light * light;
ADDRLP4 164
ADDRFP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
ADDRLP4 164
INDIRF4
MULF4
ASGNF4
line 564
;564:		trap_R_AddLightToScene(re.origin, light, le->lightColor[0], le->lightColor[1], le->lightColor[2] );
ADDRLP4 0+68
ARGP4
ADDRLP4 164
INDIRF4
ARGF4
ADDRLP4 176
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 176
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ARGF4
ADDRLP4 176
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ARGF4
ADDRLP4 176
INDIRP4
CNSTI4 136
ADDP4
INDIRF4
ARGF4
ADDRGP4 trap_R_AddLightToScene
CALLV
pop
line 565
;565:	}
LABELV $267
line 566
;566:}
LABELV $252
endproc CG_AddSpriteExplosion 180 20
export CG_AddLocalEntities
proc CG_AddLocalEntities 16 8
line 577
;567:
;568:
;569://==============================================================================
;570:
;571:/*
;572:===================
;573:CG_AddLocalEntities
;574:
;575:===================
;576:*/
;577:void CG_AddLocalEntities( void ) {
line 582
;578:	localEntity_t	*le, *next;
;579:
;580:	// walk the list backwards, so any new local entities generated
;581:	// (trails, marks, etc) will be present this frame
;582:	le = cg_activeLocalEntities.prev;
ADDRLP4 0
ADDRGP4 cg_activeLocalEntities
INDIRP4
ASGNP4
line 583
;583:	for ( ; le != &cg_activeLocalEntities ; le = next ) {
ADDRGP4 $277
JUMPV
LABELV $274
line 586
;584:		// grab next now, so if the local entity is freed we
;585:		// still have it
;586:		next = le->prev;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 588
;587:
;588:		if ( cg.time >= le->endTime ) {
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
LTI4 $278
line 589
;589:			CG_FreeLocalEntity( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeLocalEntity
CALLV
pop
line 590
;590:			continue;
ADDRGP4 $275
JUMPV
LABELV $278
line 592
;591:		}
;592:		switch ( le->leType ) {
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
LTI4 $281
ADDRLP4 8
INDIRI4
CNSTI4 9
GTI4 $281
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $295
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $295
address $282
address $287
address $286
address $288
address $289
address $292
address $290
address $293
address $294
address $291
code
LABELV $281
line 594
;593:		default:
;594:			CG_Error( "Bad leType: %i", le->leType );
ADDRGP4 $284
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 595
;595:			break;
ADDRGP4 $282
JUMPV
line 598
;596:
;597:		case LE_MARK:
;598:			break;
LABELV $286
line 601
;599:
;600:		case LE_SPRITE_EXPLOSION:
;601:			CG_AddSpriteExplosion( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddSpriteExplosion
CALLV
pop
line 602
;602:			break;
ADDRGP4 $282
JUMPV
LABELV $287
line 605
;603:
;604:		case LE_EXPLOSION:
;605:			CG_AddExplosion( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddExplosion
CALLV
pop
line 606
;606:			break;
ADDRGP4 $282
JUMPV
LABELV $288
line 609
;607:
;608:		case LE_FRAGMENT:			// gibs and brass
;609:			CG_AddFragment( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddFragment
CALLV
pop
line 610
;610:			break;
ADDRGP4 $282
JUMPV
LABELV $289
line 613
;611:
;612:		case LE_MOVE_SCALE_FADE:		// water bubbles
;613:			CG_AddMoveScaleFade( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddMoveScaleFade
CALLV
pop
line 614
;614:			break;
ADDRGP4 $282
JUMPV
LABELV $290
line 617
;615:
;616:		case LE_FADE_RGB:				// teleporters, railtrails
;617:			CG_AddFadeRGB( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddFadeRGB
CALLV
pop
line 618
;618:			break;
ADDRGP4 $282
JUMPV
LABELV $291
line 621
;619:
;620:		case LE_EXPAND_FADE:				// teleporters, railtrails
;621:			CG_AddExpandingFade( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddExpandingFade
CALLV
pop
line 622
;622:			break;
ADDRGP4 $282
JUMPV
LABELV $292
line 625
;623:
;624:		case LE_FALL_SCALE_FADE: // gib blood trails
;625:			CG_AddFallScaleFade( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddFallScaleFade
CALLV
pop
line 626
;626:			break;
ADDRGP4 $282
JUMPV
LABELV $293
line 629
;627:
;628:		case LE_SCALE_FADE:		// rocket trails
;629:			CG_AddScaleFade( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddScaleFade
CALLV
pop
line 630
;630:			break;
ADDRGP4 $282
JUMPV
LABELV $294
line 633
;631:
;632:		case LE_FALLFAST:
;633:			CG_AddFalling( le );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_AddFalling
CALLV
pop
line 634
;634:			break;
LABELV $282
line 637
;635:
;636:		}
;637:	}
LABELV $275
line 583
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
LABELV $277
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 cg_activeLocalEntities
CVPU4 4
NEU4 $274
line 638
;638:}
LABELV $273
endproc CG_AddLocalEntities 16 8
bss
export cg_freeLocalEntities
align 4
LABELV cg_freeLocalEntities
skip 4
export cg_activeLocalEntities
align 4
LABELV cg_activeLocalEntities
skip 288
export cg_localEntities
align 4
LABELV cg_localEntities
skip 147456
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $284
byte 1 66
byte 1 97
byte 1 100
byte 1 32
byte 1 108
byte 1 101
byte 1 84
byte 1 121
byte 1 112
byte 1 101
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $71
byte 1 67
byte 1 71
byte 1 95
byte 1 70
byte 1 114
byte 1 101
byte 1 101
byte 1 76
byte 1 111
byte 1 99
byte 1 97
byte 1 108
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 58
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 101
byte 1 0
