bss
align 1
LABELV $61
skip 64
export CG_PlaceString
code
proc CG_PlaceString 12 20
file "..\cg_event.c"
line 16
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_event.c -- handle entity events at snapshot or playerstate transitions
;4:
;5:#include "cg_local.h"
;6:
;7://==========================================================================
;8:
;9:/*
;10:===================
;11:CG_PlaceString
;12:
;13:Also called by scoreboard drawing
;14:===================
;15:*/
;16:const char	*CG_PlaceString( int rank ) {
line 20
;17:	static char	str[64];
;18:	char	*s, *t;
;19:
;20:	if ( rank & RANK_TIED_FLAG ) {
ADDRFP4 0
INDIRI4
CNSTI4 16384
BANDI4
CNSTI4 0
EQI4 $62
line 21
;21:		rank &= ~RANK_TIED_FLAG;
ADDRFP4 0
ADDRFP4 0
INDIRI4
CNSTI4 -16385
BANDI4
ASGNI4
line 22
;22:		t = "Tied for ";
ADDRLP4 4
ADDRGP4 $64
ASGNP4
line 23
;23:	} else {
ADDRGP4 $63
JUMPV
LABELV $62
line 24
;24:		t = "";
ADDRLP4 4
ADDRGP4 $65
ASGNP4
line 25
;25:	}
LABELV $63
line 27
;26:
;27:	if ( rank == 1 ) {
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $66
line 28
;28:		s = S_COLOR_BLUE "1st" S_COLOR_WHITE;		// draw in blue
ADDRLP4 0
ADDRGP4 $68
ASGNP4
line 29
;29:	} else if ( rank == 2 ) {
ADDRGP4 $67
JUMPV
LABELV $66
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $69
line 30
;30:		s = S_COLOR_RED "2nd" S_COLOR_WHITE;		// draw in red
ADDRLP4 0
ADDRGP4 $71
ASGNP4
line 31
;31:	} else if ( rank == 3 ) {
ADDRGP4 $70
JUMPV
LABELV $69
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $72
line 32
;32:		s = S_COLOR_YELLOW "3rd" S_COLOR_WHITE;		// draw in yellow
ADDRLP4 0
ADDRGP4 $74
ASGNP4
line 33
;33:	} else if ( rank == 11 ) {
ADDRGP4 $73
JUMPV
LABELV $72
ADDRFP4 0
INDIRI4
CNSTI4 11
NEI4 $75
line 34
;34:		s = "11th";
ADDRLP4 0
ADDRGP4 $77
ASGNP4
line 35
;35:	} else if ( rank == 12 ) {
ADDRGP4 $76
JUMPV
LABELV $75
ADDRFP4 0
INDIRI4
CNSTI4 12
NEI4 $78
line 36
;36:		s = "12th";
ADDRLP4 0
ADDRGP4 $80
ASGNP4
line 37
;37:	} else if ( rank == 13 ) {
ADDRGP4 $79
JUMPV
LABELV $78
ADDRFP4 0
INDIRI4
CNSTI4 13
NEI4 $81
line 38
;38:		s = "13th";
ADDRLP4 0
ADDRGP4 $83
ASGNP4
line 39
;39:	} else if ( rank % 10 == 1 ) {
ADDRGP4 $82
JUMPV
LABELV $81
ADDRFP4 0
INDIRI4
CNSTI4 10
MODI4
CNSTI4 1
NEI4 $84
line 40
;40:		s = va("%ist", rank);
ADDRGP4 $86
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 41
;41:	} else if ( rank % 10 == 2 ) {
ADDRGP4 $85
JUMPV
LABELV $84
ADDRFP4 0
INDIRI4
CNSTI4 10
MODI4
CNSTI4 2
NEI4 $87
line 42
;42:		s = va("%ind", rank);
ADDRGP4 $89
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 43
;43:	} else if ( rank % 10 == 3 ) {
ADDRGP4 $88
JUMPV
LABELV $87
ADDRFP4 0
INDIRI4
CNSTI4 10
MODI4
CNSTI4 3
NEI4 $90
line 44
;44:		s = va("%ird", rank);
ADDRGP4 $92
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 45
;45:	} else {
ADDRGP4 $91
JUMPV
LABELV $90
line 46
;46:		s = va("%ith", rank);
ADDRGP4 $93
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 47
;47:	}
LABELV $91
LABELV $88
LABELV $85
LABELV $82
LABELV $79
LABELV $76
LABELV $73
LABELV $70
LABELV $67
line 49
;48:
;49:	Com_sprintf( str, sizeof( str ), "%s%s", t, s );
ADDRGP4 $61
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $94
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 50
;50:	return str;
ADDRGP4 $61
RETP4
LABELV $60
endproc CG_PlaceString 12 20
proc CG_Obituary 132 20
line 58
;51:}
;52:
;53:/*
;54:=============
;55:CG_Obituary
;56:=============
;57:*/
;58:static void CG_Obituary( entityState_t *ent ) {
line 70
;59:	int			mod;
;60:	int			target, attacker;
;61:	char		*message;
;62:	char		*message2;
;63:	const char	*targetInfo;
;64:	const char	*attackerInfo;
;65:	char		targetName[32];
;66:	char		attackerName[32];
;67:	gender_t	gender;
;68:	clientInfo_t	*ci;
;69:
;70:	target = ent->otherEntityNum;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ASGNI4
line 71
;71:	attacker = ent->otherEntityNum2;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
line 72
;72:	mod = ent->eventParm;
ADDRLP4 44
ADDRFP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 74
;73:
;74:	if ( target < 0 || target >= MAX_CLIENTS ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
LTI4 $98
ADDRLP4 4
INDIRI4
CNSTI4 128
LTI4 $96
LABELV $98
line 75
;75:		CG_Error( "CG_Obituary: target out of range" );
ADDRGP4 $99
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 76
;76:	}
LABELV $96
line 77
;77:	ci = &cgs.clientinfo[target];
ADDRLP4 92
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 79
;78:
;79:	if ( attacker < 0 || attacker >= MAX_CLIENTS ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $103
ADDRLP4 0
INDIRI4
CNSTI4 128
LTI4 $101
LABELV $103
line 80
;80:		attacker = ENTITYNUM_WORLD;
ADDRLP4 0
CNSTI4 1022
ASGNI4
line 81
;81:		attackerInfo = NULL;
ADDRLP4 52
CNSTP4 0
ASGNP4
line 82
;82:	} else {
ADDRGP4 $102
JUMPV
LABELV $101
line 83
;83:		attackerInfo = CG_ConfigString( CS_PLAYERS + attacker );
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 108
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 52
ADDRLP4 108
INDIRP4
ASGNP4
line 84
;84:	}
LABELV $102
line 86
;85:
;86:	targetInfo = CG_ConfigString( CS_PLAYERS + target );
ADDRLP4 4
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 108
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 48
ADDRLP4 108
INDIRP4
ASGNP4
line 87
;87:	if ( !targetInfo ) {
ADDRLP4 48
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $104
line 88
;88:		return;
ADDRGP4 $95
JUMPV
LABELV $104
line 90
;89:	}
;90:	Q_strncpyz( targetName, Info_ValueForKey( targetInfo, "n" ), sizeof(targetName) - 2);
ADDRLP4 48
INDIRP4
ARGP4
ADDRGP4 $106
ARGP4
ADDRLP4 112
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 8
ARGP4
ADDRLP4 112
INDIRP4
ARGP4
CNSTI4 30
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 91
;91:	strcat( targetName, S_COLOR_WHITE );
ADDRLP4 8
ARGP4
ADDRGP4 $107
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 93
;92:
;93:	message2 = "";
ADDRLP4 88
ADDRGP4 $65
ASGNP4
line 97
;94:
;95:	// check for single client messages
;96:
;97:	switch( mod ) {
ADDRLP4 44
INDIRI4
CNSTI4 14
LTI4 $108
ADDRLP4 44
INDIRI4
CNSTI4 24
GTI4 $108
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $128-56
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $128
address $116
address $118
address $120
address $114
address $108
address $112
address $110
address $122
address $124
address $108
address $126
code
LABELV $110
line 99
;98:	case MOD_SUICIDE:
;99:		message = "suicides";
ADDRLP4 40
ADDRGP4 $111
ASGNP4
line 100
;100:		break;
ADDRGP4 $109
JUMPV
LABELV $112
line 102
;101:	case MOD_FALLING:
;102:		message = "cratered";
ADDRLP4 40
ADDRGP4 $113
ASGNP4
line 103
;103:		break;
ADDRGP4 $109
JUMPV
LABELV $114
line 105
;104:	case MOD_CRUSH:
;105:		message = "was squished";
ADDRLP4 40
ADDRGP4 $115
ASGNP4
line 106
;106:		break;
ADDRGP4 $109
JUMPV
LABELV $116
line 108
;107:	case MOD_WATER:
;108:		message = "sank like a rock";
ADDRLP4 40
ADDRGP4 $117
ASGNP4
line 109
;109:		break;
ADDRGP4 $109
JUMPV
LABELV $118
line 111
;110:	case MOD_SLIME:
;111:		message = "melted";
ADDRLP4 40
ADDRGP4 $119
ASGNP4
line 112
;112:		break;
ADDRGP4 $109
JUMPV
LABELV $120
line 114
;113:	case MOD_LAVA:
;114:		message = "does a back flip into the lava";
ADDRLP4 40
ADDRGP4 $121
ASGNP4
line 115
;115:		break;
ADDRGP4 $109
JUMPV
LABELV $122
line 117
;116:	case MOD_TARGET_LASER:
;117:		message = "saw the light";
ADDRLP4 40
ADDRGP4 $123
ASGNP4
line 118
;118:		break;
ADDRGP4 $109
JUMPV
LABELV $124
line 120
;119:	case MOD_TRIGGER_HURT:
;120:		message = "was in the wrong place";
ADDRLP4 40
ADDRGP4 $125
ASGNP4
line 121
;121:		break;
ADDRGP4 $109
JUMPV
LABELV $126
line 123
;122:	case MOD_BLEED:
;123:		message = "died of a sucking chest wound";
ADDRLP4 40
ADDRGP4 $127
ASGNP4
LABELV $108
line 125
;124:	default:
;125:		message = NULL;
ADDRLP4 40
CNSTP4 0
ASGNP4
line 126
;126:		break;
LABELV $109
line 129
;127:	}
;128:
;129:	if (attacker == target) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $130
line 130
;130:		gender = ci->gender;
ADDRLP4 96
ADDRLP4 92
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
ASGNI4
line 131
;131:		switch (mod) {
ADDRLP4 124
CNSTI4 13
ASGNI4
ADDRLP4 44
INDIRI4
ADDRLP4 124
INDIRI4
EQI4 $158
ADDRLP4 44
INDIRI4
ADDRLP4 124
INDIRI4
GTI4 $170
LABELV $169
ADDRLP4 44
INDIRI4
CNSTI4 5
EQI4 $134
ADDRLP4 44
INDIRI4
CNSTI4 7
EQI4 $142
ADDRLP4 44
INDIRI4
CNSTI4 9
EQI4 $150
ADDRGP4 $132
JUMPV
LABELV $170
ADDRLP4 44
INDIRI4
CNSTI4 24
EQI4 $160
ADDRGP4 $132
JUMPV
LABELV $134
line 133
;132:		case MOD_GRENADE_SPLASH:
;133:			if ( gender == GENDER_FEMALE )
ADDRLP4 96
INDIRI4
CNSTI4 1
NEI4 $135
line 134
;134:				message = "tripped on her own grenade";
ADDRLP4 40
ADDRGP4 $137
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $135
line 135
;135:			else if ( gender == GENDER_NEUTER )
ADDRLP4 96
INDIRI4
CNSTI4 2
NEI4 $138
line 136
;136:				message = "tripped on its own grenade";
ADDRLP4 40
ADDRGP4 $140
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $138
line 138
;137:			else
;138:				message = "tripped on his own grenade";
ADDRLP4 40
ADDRGP4 $141
ASGNP4
line 139
;139:			break;
ADDRGP4 $133
JUMPV
LABELV $142
line 141
;140:		case MOD_ROCKET_SPLASH:
;141:			if ( gender == GENDER_FEMALE )
ADDRLP4 96
INDIRI4
CNSTI4 1
NEI4 $143
line 142
;142:				message = "blew herself up";
ADDRLP4 40
ADDRGP4 $145
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $143
line 143
;143:			else if ( gender == GENDER_NEUTER )
ADDRLP4 96
INDIRI4
CNSTI4 2
NEI4 $146
line 144
;144:				message = "blew itself up";
ADDRLP4 40
ADDRGP4 $148
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $146
line 146
;145:			else
;146:				message = "blew himself up";
ADDRLP4 40
ADDRGP4 $149
ASGNP4
line 147
;147:			break;
ADDRGP4 $133
JUMPV
LABELV $150
line 149
;148:		case MOD_PLASMA_SPLASH:
;149:			if ( gender == GENDER_FEMALE )
ADDRLP4 96
INDIRI4
CNSTI4 1
NEI4 $151
line 150
;150:				message = "melted herself";
ADDRLP4 40
ADDRGP4 $153
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $151
line 151
;151:			else if ( gender == GENDER_NEUTER )
ADDRLP4 96
INDIRI4
CNSTI4 2
NEI4 $154
line 152
;152:				message = "melted itself";
ADDRLP4 40
ADDRGP4 $156
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $154
line 154
;153:			else
;154:				message = "melted himself";
ADDRLP4 40
ADDRGP4 $157
ASGNP4
line 155
;155:			break;
ADDRGP4 $133
JUMPV
LABELV $158
line 157
;156:		case MOD_BFG_SPLASH:
;157:			message = "should have used a smaller gun";
ADDRLP4 40
ADDRGP4 $159
ASGNP4
line 158
;158:			break;
ADDRGP4 $133
JUMPV
LABELV $160
line 160
;159:		case MOD_BLEED:
;160:			message = "died of a sucking chest wound.";
ADDRLP4 40
ADDRGP4 $161
ASGNP4
LABELV $132
line 163
;161:			
;162:		default:
;163:			if ( gender == GENDER_FEMALE )
ADDRLP4 96
INDIRI4
CNSTI4 1
NEI4 $162
line 164
;164:				message = "killed herself";
ADDRLP4 40
ADDRGP4 $164
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $162
line 165
;165:			else if ( gender == GENDER_NEUTER )
ADDRLP4 96
INDIRI4
CNSTI4 2
NEI4 $165
line 166
;166:				message = "killed itself";
ADDRLP4 40
ADDRGP4 $167
ASGNP4
ADDRGP4 $133
JUMPV
LABELV $165
line 168
;167:			else
;168:				message = "killed himself";
ADDRLP4 40
ADDRGP4 $168
ASGNP4
line 169
;169:			break;
LABELV $133
line 171
;170:		}
;171:	}
LABELV $130
line 173
;172:
;173:	if (message) {
ADDRLP4 40
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $171
line 174
;174:		CG_Printf( "%s %s.\n", targetName, message);
ADDRGP4 $173
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 40
INDIRP4
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 175
;175:		return;
ADDRGP4 $95
JUMPV
LABELV $171
line 179
;176:	}
;177:
;178:	// check for kill messages from the current clientNum
;179:	if ( attacker == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $174
line 182
;180:		char	*s;
;181:
;182:		if ( cgs.gametype < GT_TEAM ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
GEI4 $177
line 183
;183:			s = va("You fragged %s\n%s place with %i", targetName, 
ADDRGP4 cg+32
INDIRP4
CNSTI4 300
ADDP4
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 124
ADDRGP4 CG_PlaceString
CALLP4
ASGNP4
ADDRGP4 $180
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 124
INDIRP4
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 292
ADDP4
INDIRI4
ARGI4
ADDRLP4 128
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 120
ADDRLP4 128
INDIRP4
ASGNP4
line 186
;184:				CG_PlaceString( cg.snap->ps.persistant[PERS_RANK] + 1 ),
;185:				cg.snap->ps.persistant[PERS_SCORE] );
;186:		} else {
ADDRGP4 $178
JUMPV
LABELV $177
line 187
;187:			s = va("You fragged %s", targetName );
ADDRGP4 $183
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 124
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 120
ADDRLP4 124
INDIRP4
ASGNP4
line 188
;188:		}
LABELV $178
line 189
;189:		CG_CenterPrint( s, SCREEN_HEIGHT * 0.25, BIGCHAR_WIDTH );
ADDRLP4 120
INDIRP4
ARGP4
CNSTI4 120
ARGI4
CNSTI4 16
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 192
;190:
;191:		// print the text message as well
;192:	}
LABELV $174
line 195
;193:
;194:	// check for double client messages
;195:	if ( !attackerInfo ) {
ADDRLP4 52
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $184
line 196
;196:		attacker = ENTITYNUM_WORLD;
ADDRLP4 0
CNSTI4 1022
ASGNI4
line 197
;197:		strcpy( attackerName, "noname" );
ADDRLP4 56
ARGP4
ADDRGP4 $186
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 198
;198:	} else {
ADDRGP4 $185
JUMPV
LABELV $184
line 199
;199:		Q_strncpyz( attackerName, Info_ValueForKey( attackerInfo, "n" ), sizeof(attackerName) - 2);
ADDRLP4 52
INDIRP4
ARGP4
ADDRGP4 $106
ARGP4
ADDRLP4 120
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 56
ARGP4
ADDRLP4 120
INDIRP4
ARGP4
CNSTI4 30
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 200
;200:		strcat( attackerName, S_COLOR_WHITE );
ADDRLP4 56
ARGP4
ADDRGP4 $107
ARGP4
ADDRGP4 strcat
CALLP4
pop
line 202
;201:		// check for kill messages about the current clientNum
;202:		if ( target == cg.snap->ps.clientNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $187
line 203
;203:			Q_strncpyz( cg.killerName, attackerName, sizeof( cg.killerName ) );
ADDRGP4 cg+110800
ARGP4
ADDRLP4 56
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 204
;204:		}
LABELV $187
line 205
;205:	}
LABELV $185
line 207
;206:
;207:	if ( attacker != ENTITYNUM_WORLD ) {
ADDRLP4 0
INDIRI4
CNSTI4 1022
EQI4 $192
line 208
;208:		switch (mod) {
ADDRLP4 44
INDIRI4
CNSTI4 1
LTI4 $194
ADDRLP4 44
INDIRI4
CNSTI4 24
GTI4 $194
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $232-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $232
address $202
address $198
address $200
address $204
address $207
address $210
address $212
address $214
address $217
address $218
address $220
address $222
address $222
address $194
address $194
address $194
address $194
address $225
address $194
address $194
address $194
address $194
address $196
address $228
code
LABELV $196
line 210
;209:		case MOD_GRAPPLE:
;210:			message = "was caught by";
ADDRLP4 40
ADDRGP4 $197
ASGNP4
line 211
;211:			break;
ADDRGP4 $195
JUMPV
LABELV $198
line 213
;212:		case MOD_GAUNTLET:
;213:			message = "was pummeled by";
ADDRLP4 40
ADDRGP4 $199
ASGNP4
line 214
;214:			break;
ADDRGP4 $195
JUMPV
LABELV $200
line 216
;215:		case MOD_MACHINEGUN:
;216:			message = "was machinegunned by";
ADDRLP4 40
ADDRGP4 $201
ASGNP4
line 217
;217:			break;
ADDRGP4 $195
JUMPV
LABELV $202
line 219
;218:		case MOD_SHOTGUN:
;219:			message = "was gunned down by";
ADDRLP4 40
ADDRGP4 $203
ASGNP4
line 220
;220:			break;
ADDRGP4 $195
JUMPV
LABELV $204
line 222
;221:		case MOD_GRENADE:
;222:			message = "ate";
ADDRLP4 40
ADDRGP4 $205
ASGNP4
line 223
;223:			message2 = "'s grenade";
ADDRLP4 88
ADDRGP4 $206
ASGNP4
line 224
;224:			break;
ADDRGP4 $195
JUMPV
LABELV $207
line 226
;225:		case MOD_GRENADE_SPLASH:
;226:			message = "was shredded by";
ADDRLP4 40
ADDRGP4 $208
ASGNP4
line 227
;227:			message2 = "'s shrapnel";
ADDRLP4 88
ADDRGP4 $209
ASGNP4
line 228
;228:			break;
ADDRGP4 $195
JUMPV
LABELV $210
line 230
;229:		case MOD_ROCKET:
;230:			message = "ate";
ADDRLP4 40
ADDRGP4 $205
ASGNP4
line 231
;231:			message2 = "'s rocket";
ADDRLP4 88
ADDRGP4 $211
ASGNP4
line 232
;232:			break;
ADDRGP4 $195
JUMPV
LABELV $212
line 234
;233:		case MOD_ROCKET_SPLASH:
;234:			message = "almost dodged";
ADDRLP4 40
ADDRGP4 $213
ASGNP4
line 235
;235:			message2 = "'s rocket";
ADDRLP4 88
ADDRGP4 $211
ASGNP4
line 236
;236:			break;
ADDRGP4 $195
JUMPV
LABELV $214
line 238
;237:		case MOD_PLASMA:
;238:			message = "was melted by";
ADDRLP4 40
ADDRGP4 $215
ASGNP4
line 239
;239:			message2 = "'s plasmagun";
ADDRLP4 88
ADDRGP4 $216
ASGNP4
line 240
;240:			break;
ADDRGP4 $195
JUMPV
LABELV $217
line 242
;241:		case MOD_PLASMA_SPLASH:
;242:			message = "was melted by";
ADDRLP4 40
ADDRGP4 $215
ASGNP4
line 243
;243:			message2 = "'s plasmagun";
ADDRLP4 88
ADDRGP4 $216
ASGNP4
line 244
;244:			break;
ADDRGP4 $195
JUMPV
LABELV $218
line 246
;245:		case MOD_RAILGUN:
;246:			message = "was railed by";
ADDRLP4 40
ADDRGP4 $219
ASGNP4
line 247
;247:			break;
ADDRGP4 $195
JUMPV
LABELV $220
line 249
;248:		case MOD_LIGHTNING:
;249:			message = "was electrocuted by";
ADDRLP4 40
ADDRGP4 $221
ASGNP4
line 250
;250:			break;
ADDRGP4 $195
JUMPV
LABELV $222
line 253
;251:		case MOD_BFG:
;252:		case MOD_BFG_SPLASH:
;253:			message = "was blasted by";
ADDRLP4 40
ADDRGP4 $223
ASGNP4
line 254
;254:			message2 = "'s BFG";
ADDRLP4 88
ADDRGP4 $224
ASGNP4
line 255
;255:			break;
ADDRGP4 $195
JUMPV
LABELV $225
line 257
;256:		case MOD_TELEFRAG:
;257:			message = "tried to invade";
ADDRLP4 40
ADDRGP4 $226
ASGNP4
line 258
;258:			message2 = "'s personal space";
ADDRLP4 88
ADDRGP4 $227
ASGNP4
line 259
;259:			break;
ADDRGP4 $195
JUMPV
LABELV $228
line 261
;260:		case MOD_BLEED:
;261:			message = "finally bled to death from";
ADDRLP4 40
ADDRGP4 $229
ASGNP4
line 262
;262:			message2 = "'s attack";
ADDRLP4 88
ADDRGP4 $230
ASGNP4
line 263
;263:			break;
ADDRGP4 $195
JUMPV
LABELV $194
line 265
;264:		default:
;265:			message = "was killed by";
ADDRLP4 40
ADDRGP4 $231
ASGNP4
line 266
;266:			break;
LABELV $195
line 269
;267:		}
;268:
;269:		if (message) {
ADDRLP4 40
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $234
line 270
;270:			CG_Printf( "%s %s %s%s\n", 
ADDRGP4 $236
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 40
INDIRP4
ARGP4
ADDRLP4 56
ARGP4
ADDRLP4 88
INDIRP4
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 272
;271:				targetName, message, attackerName, message2);
;272:			return;
ADDRGP4 $95
JUMPV
LABELV $234
line 274
;273:		}
;274:	}
LABELV $192
line 277
;275:
;276:	// we don't know what it was
;277:	CG_Printf( "%s died.\n", targetName );
ADDRGP4 $237
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 278
;278:}
LABELV $95
endproc CG_Obituary 132 20
proc CG_UseItem 24 16
line 287
;279:
;280://==========================================================================
;281:
;282:/*
;283:===============
;284:CG_UseItem
;285:===============
;286:*/
;287:static void CG_UseItem( centity_t *cent ) {
line 292
;288:	int			itemNum;
;289:	gitem_t		*item;
;290:	entityState_t *es;
;291:
;292:	es = &cent->currentState;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
line 294
;293:	
;294:	itemNum = es->event - EV_USE_ITEM0;
ADDRLP4 0
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CNSTI4 24
SUBI4
ASGNI4
line 295
;295:	if ( itemNum < 0 || itemNum > HI_NUM_HOLDABLE ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $241
ADDRLP4 0
INDIRI4
CNSTI4 3
LEI4 $239
LABELV $241
line 296
;296:		itemNum = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 297
;297:	}
LABELV $239
line 300
;298:
;299:	// print a message if the local player
;300:	if ( es->number == cg.snap->ps.clientNum ) {
ADDRLP4 4
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $242
line 301
;301:		if ( !itemNum ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $245
line 302
;302:			CG_CenterPrint( "No item to use", SCREEN_HEIGHT * 0.25, BIGCHAR_WIDTH );
ADDRGP4 $247
ARGP4
CNSTI4 120
ARGI4
CNSTI4 16
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 303
;303:		} else {
ADDRGP4 $246
JUMPV
LABELV $245
line 304
;304:			item = BG_FindItemForHoldable( itemNum );
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 16
ADDRGP4 BG_FindItemForHoldable
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 16
INDIRP4
ASGNP4
line 305
;305:			CG_CenterPrint( va("Use %s", item->pickup_name), SCREEN_HEIGHT * 0.25, BIGCHAR_WIDTH );
ADDRGP4 $248
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 28
ADDP4
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
CNSTI4 120
ARGI4
CNSTI4 16
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 306
;306:		}
LABELV $246
line 307
;307:	}
LABELV $242
line 309
;308:
;309:	switch ( itemNum ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $251
ADDRLP4 0
INDIRI4
CNSTI4 1
EQI4 $250
ADDRLP4 0
INDIRI4
CNSTI4 2
EQI4 $255
ADDRGP4 $249
JUMPV
LABELV $249
LABELV $251
line 312
;310:	default:
;311:	case HI_NONE:
;312:		trap_S_StartSound (NULL, es->number, CHAN_BODY, cgs.media.useNothingSound );
CNSTP4 0
ARGP4
ADDRLP4 4
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRGP4 cgs+170516+452
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 313
;313:		break;
ADDRGP4 $250
JUMPV
line 316
;314:
;315:	case HI_TELEPORTER:
;316:		break;
LABELV $255
line 319
;317:
;318:	case HI_MEDKIT:
;319:		trap_S_StartSound (NULL, es->number, CHAN_BODY, cgs.media.medkitSound );
CNSTP4 0
ARGP4
ADDRLP4 4
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRGP4 cgs+170516+732
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 320
;320:		break;
LABELV $250
line 323
;321:	}
;322:
;323:}
LABELV $238
endproc CG_UseItem 24 16
proc CG_ItemPickup 4 0
line 332
;324:
;325:/*
;326:================
;327:CG_ItemPickup
;328:
;329:A new item was picked up this frame
;330:================
;331:*/
;332:static void CG_ItemPickup( int itemNum ) {
line 333
;333:	cg.itemPickup = itemNum;
ADDRGP4 cg+111920
ADDRFP4 0
INDIRI4
ASGNI4
line 334
;334:	cg.itemPickupTime = cg.time;
ADDRGP4 cg+111924
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 335
;335:	cg.itemPickupBlendTime = cg.time;
ADDRGP4 cg+111928
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 337
;336:	// see if it should be the grabbed weapon
;337:	if ( bg_itemlist[itemNum].giType == IT_WEAPON ) {
CNSTI4 56
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 bg_itemlist+36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $264
line 339
;338:		// select it immediately
;339:		if ( cg_autoswitch.integer || cg.predictedPlayerState.stats[STAT_EXTENDED_INFO] & EXT_LIMIT_WEAPONS) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 cg_autoswitch+12
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $273
ADDRGP4 cg+105532+184+28
INDIRI4
CNSTI4 2
BANDI4
ADDRLP4 0
INDIRI4
EQI4 $267
LABELV $273
line 340
;340:			cg.weaponSelectTime = cg.time;
ADDRGP4 cg+111932
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 341
;341:			cg.weaponSelect = bg_itemlist[itemNum].giTag;
ADDRGP4 cg+106700
CNSTI4 56
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 bg_itemlist+40
ADDP4
INDIRI4
ASGNI4
line 342
;342:		}
LABELV $267
line 343
;343:	}
LABELV $264
line 345
;344:
;345:}
LABELV $258
endproc CG_ItemPickup 4 0
export CG_PainEvent
proc CG_PainEvent 12 16
line 355
;346:
;347:
;348:/*
;349:================
;350:CG_PainEvent
;351:
;352:Also called by playerstate transition
;353:================
;354:*/
;355:void CG_PainEvent( centity_t *cent, int health ) {
line 359
;356:	char	*snd;
;357:
;358:	// don't do more than two pain sounds a second
;359:	if ( cg.time - cent->pe.painTime < 500 ) {
ADDRGP4 cg+105504
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 532
ADDP4
INDIRI4
SUBI4
CNSTI4 500
GEI4 $279
line 360
;360:		return;
ADDRGP4 $278
JUMPV
LABELV $279
line 363
;361:	}
;362:
;363:	if ( health < 25 ) {
ADDRFP4 4
INDIRI4
CNSTI4 25
GEI4 $282
line 364
;364:		snd = "*pain25_1.wav";
ADDRLP4 0
ADDRGP4 $284
ASGNP4
line 365
;365:	} else if ( health < 50 ) {
ADDRGP4 $283
JUMPV
LABELV $282
ADDRFP4 4
INDIRI4
CNSTI4 50
GEI4 $285
line 366
;366:		snd = "*pain50_1.wav";
ADDRLP4 0
ADDRGP4 $287
ASGNP4
line 367
;367:	} else if ( health < 75 ) {
ADDRGP4 $286
JUMPV
LABELV $285
ADDRFP4 4
INDIRI4
CNSTI4 75
GEI4 $288
line 368
;368:		snd = "*pain75_1.wav";
ADDRLP4 0
ADDRGP4 $290
ASGNP4
line 369
;369:	} else {
ADDRGP4 $289
JUMPV
LABELV $288
line 370
;370:		snd = "*pain100_1.wav";
ADDRLP4 0
ADDRGP4 $291
ASGNP4
line 371
;371:	}
LABELV $289
LABELV $286
LABELV $283
line 372
;372:	trap_S_StartSound( NULL, cent->currentState.number, CHAN_VOICE, 
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 376
;373:		CG_CustomSound( cent->currentState.number, snd ) );
;374:
;375:	// save pain time for programitic twitch animation
;376:	cent->pe.painTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 532
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 377
;377:	cent->pe.painDirection ^= 1;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 536
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 378
;378:}
LABELV $278
endproc CG_PainEvent 12 16
export CG_EntityEvent
proc CG_EntityEvent 252 44
line 389
;379:
;380:/*
;381:==============
;382:CG_EntityEvent
;383:
;384:An entity has an event value
;385:also called by CG_CheckPlayerstateEvents
;386:==============
;387:*/
;388:#define	DEBUGNAME(x) if(cg_debugEvents.integer){CG_Printf(x"\n");}
;389:void CG_EntityEvent( centity_t *cent, vec3_t position ) {
line 397
;390:	entityState_t	*es;
;391:	int				event;
;392:	vec3_t			dir;
;393:	const char		*s;
;394:	int				clientNum;
;395:	clientInfo_t	*ci;
;396:
;397:	es = &cent->currentState;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
line 398
;398:	event = es->event & ~EV_EVENT_BITS;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CNSTI4 -769
BANDI4
ASGNI4
line 400
;399:
;400:	if ( cg_debugEvents.integer ) {
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $294
line 401
;401:		CG_Printf( "ent:%3i  event:%3i ", es->number, event );
ADDRGP4 $297
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 402
;402:	}
LABELV $294
line 404
;403:
;404:	if ( !event ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $298
line 405
;405:		DEBUGNAME("ZEROEVENT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $293
ADDRGP4 $303
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 406
;406:		return;
ADDRGP4 $293
JUMPV
LABELV $298
line 409
;407:	}
;408:
;409:	clientNum = es->clientNum;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
ASGNI4
line 410
;410:	if ( clientNum < 0 || clientNum >= MAX_CLIENTS ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
LTI4 $306
ADDRLP4 4
INDIRI4
CNSTI4 128
LTI4 $304
LABELV $306
line 411
;411:		clientNum = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 412
;412:	}
LABELV $304
line 413
;413:	ci = &cgs.clientinfo[ clientNum ];
ADDRLP4 24
CNSTI4 1076
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 415
;414:
;415:	switch ( event ) {
ADDRLP4 8
INDIRI4
CNSTI4 1
LTI4 $308
ADDRLP4 8
INDIRI4
CNSTI4 71
GTI4 $308
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $833-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $833
address $310
address $320
address $331
address $342
address $353
address $404
address $404
address $404
address $404
address $364
address $378
address $390
address $434
address $442
address $453
address $460
address $467
address $474
address $480
address $495
address $507
address $516
address $523
address $528
address $533
address $538
address $543
address $548
address $553
address $558
address $563
address $568
address $573
address $578
address $583
address $588
address $593
address $598
address $308
address $624
address $617
address $603
address $610
address $632
address $687
address $698
address $672
address $667
address $641
address $650
address $655
address $682
address $308
address $738
address $746
address $746
address $746
address $765
address $770
address $783
address $795
address $808
address $823
address $709
address $447
address $816
address $815
address $807
address $677
address $662
address $646
code
LABELV $310
line 420
;416:	//
;417:	// movement generated events
;418:	//
;419:	case EV_FOOTSTEP:
;420:		DEBUGNAME("EV_FOOTSTEP");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $311
ADDRGP4 $314
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $311
line 421
;421:		if (cg_footsteps.integer) {
ADDRGP4 cg_footsteps+12
INDIRI4
CNSTI4 0
EQI4 $309
line 422
;422:			trap_S_StartSound (NULL, es->number, CHAN_BODY, 
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRLP4 40
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 2
LSHI4
ADDRLP4 24
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
CNSTI4 4
LSHI4
ADDRGP4 cgs+170516+460
ADDP4
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 424
;423:				cgs.media.footsteps[ ci->footsteps ][rand()&3] );
;424:		}
line 425
;425:		break;
ADDRGP4 $309
JUMPV
LABELV $320
line 427
;426:	case EV_FOOTSTEP_METAL:
;427:		DEBUGNAME("EV_FOOTSTEP_METAL");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $321
ADDRGP4 $324
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $321
line 428
;428:		if (cg_footsteps.integer) {
ADDRGP4 cg_footsteps+12
INDIRI4
CNSTI4 0
EQI4 $309
line 429
;429:			trap_S_StartSound (NULL, es->number, CHAN_BODY, 
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRLP4 40
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+460+80
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 431
;430:				cgs.media.footsteps[ FOOTSTEP_METAL ][rand()&3] );
;431:		}
line 432
;432:		break;
ADDRGP4 $309
JUMPV
LABELV $331
line 434
;433:	case EV_FOOTSPLASH:
;434:		DEBUGNAME("EV_FOOTSPLASH");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $332
ADDRGP4 $335
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $332
line 435
;435:		if (cg_footsteps.integer) {
ADDRGP4 cg_footsteps+12
INDIRI4
CNSTI4 0
EQI4 $309
line 436
;436:			trap_S_StartSound (NULL, es->number, CHAN_BODY, 
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRLP4 40
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+460+96
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 438
;437:				cgs.media.footsteps[ FOOTSTEP_SPLASH ][rand()&3] );
;438:		}
line 439
;439:		break;
ADDRGP4 $309
JUMPV
LABELV $342
line 441
;440:	case EV_FOOTWADE:
;441:		DEBUGNAME("EV_FOOTWADE");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $343
ADDRGP4 $346
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $343
line 442
;442:		if (cg_footsteps.integer) {
ADDRGP4 cg_footsteps+12
INDIRI4
CNSTI4 0
EQI4 $309
line 443
;443:			trap_S_StartSound (NULL, es->number, CHAN_BODY, 
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRLP4 40
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+460+96
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 445
;444:				cgs.media.footsteps[ FOOTSTEP_SPLASH ][rand()&3] );
;445:		}
line 446
;446:		break;
ADDRGP4 $309
JUMPV
LABELV $353
line 448
;447:	case EV_SWIM:
;448:		DEBUGNAME("EV_SWIM");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $354
ADDRGP4 $357
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $354
line 449
;449:		if (cg_footsteps.integer) {
ADDRGP4 cg_footsteps+12
INDIRI4
CNSTI4 0
EQI4 $309
line 450
;450:			trap_S_StartSound (NULL, es->number, CHAN_BODY, 
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRLP4 40
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+460+96
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 452
;451:				cgs.media.footsteps[ FOOTSTEP_SPLASH ][rand()&3] );
;452:		}
line 453
;453:		break;
ADDRGP4 $309
JUMPV
LABELV $364
line 457
;454:
;455:
;456:	case EV_FALL_SHORT:
;457:		DEBUGNAME("EV_FALL_SHORT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $365
ADDRGP4 $368
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $365
line 458
;458:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.landSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+644
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 459
;459:		if ( clientNum == cg.predictedPlayerState.clientNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+105532+140
INDIRI4
NEI4 $309
line 461
;460:			// smooth landing z changes
;461:			cg.landChange = -8;
ADDRGP4 cg+106692
CNSTF4 3238002688
ASGNF4
line 462
;462:			cg.landTime = cg.time;
ADDRGP4 cg+106696
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 463
;463:		}
line 464
;464:		break;
ADDRGP4 $309
JUMPV
LABELV $378
line 466
;465:	case EV_FALL_MEDIUM:
;466:		DEBUGNAME("EV_FALL_MEDIUM");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $379
ADDRGP4 $382
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $379
line 468
;467:		// use normal pain sound trap_S_StartSound( NULL, es->number, CHAN_VOICE, CG_CustomSound( es->number, "*pain100_1.wav" ) );
;468:		if ( clientNum == cg.predictedPlayerState.clientNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+105532+140
INDIRI4
NEI4 $309
line 470
;469:			// smooth landing z changes
;470:			cg.landChange = -16;
ADDRGP4 cg+106692
CNSTF4 3246391296
ASGNF4
line 471
;471:			cg.landTime = cg.time;
ADDRGP4 cg+106696
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 472
;472:		}
line 473
;473:		break;
ADDRGP4 $309
JUMPV
LABELV $390
line 475
;474:	case EV_FALL_FAR:
;475:		DEBUGNAME("EV_FALL_FAR");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $391
ADDRGP4 $394
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $391
line 476
;476:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, CG_CustomSound( es->number, "*fall1.wav" ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 $395
ARGP4
ADDRLP4 40
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 477
;477:		cent->pe.painTime = cg.time;	// don't play a pain sound right after this
ADDRFP4 0
INDIRP4
CNSTI4 532
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 478
;478:		if ( clientNum == cg.predictedPlayerState.clientNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+105532+140
INDIRI4
NEI4 $309
line 480
;479:			// smooth landing z changes
;480:			cg.landChange = -24;
ADDRGP4 cg+106692
CNSTF4 3250585600
ASGNF4
line 481
;481:			cg.landTime = cg.time;
ADDRGP4 cg+106696
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 482
;482:		}
line 483
;483:		break;
ADDRGP4 $309
JUMPV
LABELV $404
line 489
;484:
;485:	case EV_STEP_4:
;486:	case EV_STEP_8:
;487:	case EV_STEP_12:
;488:	case EV_STEP_16:		// smooth out step up transitions
;489:		DEBUGNAME("EV_STEP");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $405
ADDRGP4 $408
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $405
line 490
;490:	{
line 495
;491:		float	oldStep;
;492:		int		delta;
;493:		int		step;
;494:
;495:		if ( clientNum != cg.predictedPlayerState.clientNum ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+105532+140
INDIRI4
EQI4 $409
line 496
;496:			break;
ADDRGP4 $309
JUMPV
LABELV $409
line 499
;497:		}
;498:		// if we are interpolating, we don't need to smooth steps
;499:		if ( cg.demoPlayback || (cg.snap->ps.pm_flags & PMF_FOLLOW) ||
ADDRLP4 56
CNSTI4 0
ASGNI4
ADDRGP4 cg+4
INDIRI4
ADDRLP4 56
INDIRI4
NEI4 $421
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
ADDRLP4 56
INDIRI4
NEI4 $421
ADDRGP4 cg_nopredict+12
INDIRI4
ADDRLP4 56
INDIRI4
NEI4 $421
ADDRGP4 cg_syncronousClients+12
INDIRI4
ADDRLP4 56
INDIRI4
EQI4 $413
LABELV $421
line 500
;500:			cg_nopredict.integer || cg_syncronousClients.integer ) {
line 501
;501:			break;
ADDRGP4 $309
JUMPV
LABELV $413
line 504
;502:		}
;503:		// check for stepping up before a previous step is completed
;504:		delta = cg.time - cg.stepTime;
ADDRLP4 44
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+106680
INDIRI4
SUBI4
ASGNI4
line 505
;505:		if (delta < STEP_TIME) {
ADDRLP4 44
INDIRI4
CNSTI4 200
GEI4 $424
line 506
;506:			oldStep = cg.stepChange * (STEP_TIME - delta) / STEP_TIME;
ADDRLP4 48
ADDRGP4 cg+106676
INDIRF4
CNSTI4 200
ADDRLP4 44
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1128792064
DIVF4
ASGNF4
line 507
;507:		} else {
ADDRGP4 $425
JUMPV
LABELV $424
line 508
;508:			oldStep = 0;
ADDRLP4 48
CNSTF4 0
ASGNF4
line 509
;509:		}
LABELV $425
line 512
;510:
;511:		// add this amount
;512:		step = 4 * (event - EV_STEP_4 + 1 );
ADDRLP4 52
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 24
SUBI4
CNSTI4 4
ADDI4
ASGNI4
line 513
;513:		cg.stepChange = oldStep + step;
ADDRGP4 cg+106676
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 514
;514:		if ( cg.stepChange > MAX_STEP_CHANGE ) {
ADDRGP4 cg+106676
INDIRF4
CNSTF4 1107296256
LEF4 $428
line 515
;515:			cg.stepChange = MAX_STEP_CHANGE;
ADDRGP4 cg+106676
CNSTF4 1107296256
ASGNF4
line 516
;516:		}
LABELV $428
line 517
;517:		cg.stepTime = cg.time;
ADDRGP4 cg+106680
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 518
;518:		break;
ADDRGP4 $309
JUMPV
LABELV $434
line 522
;519:	}
;520:
;521:	case EV_JUMP_PAD:
;522:		DEBUGNAME("EV_JUMP_PAD");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $435
ADDRGP4 $438
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $435
line 524
;523:		// boing sound at origin, jump sound on player
;524:		trap_S_StartSound ( cent->lerpOrigin, -1, CHAN_VOICE, cgs.media.jumpPadSound );
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
CNSTI4 -1
ARGI4
CNSTI4 3
ARGI4
ADDRGP4 cgs+170516+652
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 525
;525:		trap_S_StartSound (NULL, es->number, CHAN_VOICE, CG_CustomSound( es->number, "*jump1.wav" ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 $441
ARGP4
ADDRLP4 44
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 44
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 526
;526:		break;
ADDRGP4 $309
JUMPV
LABELV $442
line 529
;527:
;528:	case EV_JUMP:
;529:		DEBUGNAME("EV_JUMP");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $443
ADDRGP4 $446
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $443
line 530
;530:		trap_S_StartSound (NULL, es->number, CHAN_VOICE, CG_CustomSound( es->number, "*jump1.wav" ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 $441
ARGP4
ADDRLP4 48
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 48
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 531
;531:		break;
ADDRGP4 $309
JUMPV
LABELV $447
line 533
;532:	case EV_TAUNT:
;533:		DEBUGNAME("EV_TAUNT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $448
ADDRGP4 $451
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $448
line 534
;534:		trap_S_StartSound (NULL, es->number, CHAN_VOICE, CG_CustomSound( es->number, "*taunt.wav" ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 $452
ARGP4
ADDRLP4 52
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 535
;535:		break;
ADDRGP4 $309
JUMPV
LABELV $453
line 537
;536:	case EV_WATER_TOUCH:
;537:		DEBUGNAME("EV_WATER_TOUCH");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $454
ADDRGP4 $457
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $454
line 538
;538:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.watrInSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+716
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 539
;539:		break;
ADDRGP4 $309
JUMPV
LABELV $460
line 541
;540:	case EV_WATER_LEAVE:
;541:		DEBUGNAME("EV_WATER_LEAVE");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $461
ADDRGP4 $464
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $461
line 542
;542:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.watrOutSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+720
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 543
;543:		break;
ADDRGP4 $309
JUMPV
LABELV $467
line 545
;544:	case EV_WATER_UNDER:
;545:		DEBUGNAME("EV_WATER_UNDER");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $468
ADDRGP4 $471
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $468
line 546
;546:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.watrUnSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+724
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 547
;547:		break;
ADDRGP4 $309
JUMPV
LABELV $474
line 549
;548:	case EV_WATER_CLEAR:
;549:		DEBUGNAME("EV_WATER_CLEAR");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $475
ADDRGP4 $478
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $475
line 550
;550:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, CG_CustomSound( es->number, "*gasp.wav" ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 $479
ARGP4
ADDRLP4 56
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 56
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 551
;551:		break;
ADDRGP4 $309
JUMPV
LABELV $480
line 554
;552:
;553:	case EV_ITEM_PICKUP:
;554:		DEBUGNAME("EV_ITEM_PICKUP");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $481
ADDRGP4 $484
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $481
line 555
;555:		{
line 559
;556:			gitem_t	*item;
;557:			int		index;
;558:
;559:			index = es->eventParm;		// player predicted
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 561
;560:
;561:			if ( index < 1 || index >= bg_numItems ) {
ADDRLP4 68
ADDRLP4 60
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 1
LTI4 $487
ADDRLP4 68
INDIRI4
ADDRGP4 bg_numItems
INDIRI4
LTI4 $485
LABELV $487
line 562
;562:				break;
ADDRGP4 $309
JUMPV
LABELV $485
line 564
;563:			}
;564:			item = &bg_itemlist[ index ];
ADDRLP4 64
CNSTI4 56
ADDRLP4 60
INDIRI4
MULI4
ADDRGP4 bg_itemlist
ADDP4
ASGNP4
line 568
;565:
;566:			// powerups and team items will have a separate global sound, this one
;567:			// will be played at prediction time
;568:			if ( item->giType == IT_POWERUP || item->giType == IT_TEAM) {
ADDRLP4 72
ADDRLP4 64
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
ASGNI4
ADDRLP4 72
INDIRI4
CNSTI4 5
EQI4 $490
ADDRLP4 72
INDIRI4
CNSTI4 7
NEI4 $488
LABELV $490
line 569
;569:				trap_S_StartSound (NULL, es->number, CHAN_AUTO,	trap_S_RegisterSound( "sound/items/n_health.wav" ) );
ADDRGP4 $491
ARGP4
ADDRLP4 76
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 76
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 570
;570:			} else {
ADDRGP4 $489
JUMPV
LABELV $488
line 571
;571:				trap_S_StartSound (NULL, es->number, CHAN_AUTO,	trap_S_RegisterSound( item->pickup_sound ) );
ADDRLP4 64
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ARGP4
ADDRLP4 76
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 76
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 572
;572:			}
LABELV $489
line 575
;573:
;574:			// show icon and name on status bar
;575:			if ( es->number == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $309
line 576
;576:				CG_ItemPickup( index );
ADDRLP4 60
INDIRI4
ARGI4
ADDRGP4 CG_ItemPickup
CALLV
pop
line 577
;577:			}
line 578
;578:		}
line 579
;579:		break;
ADDRGP4 $309
JUMPV
LABELV $495
line 582
;580:
;581:	case EV_GLOBAL_ITEM_PICKUP:
;582:		DEBUGNAME("EV_GLOBAL_ITEM_PICKUP");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $496
ADDRGP4 $499
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $496
line 583
;583:		{
line 587
;584:			gitem_t	*item;
;585:			int		index;
;586:
;587:			index = es->eventParm;		// player predicted
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 589
;588:
;589:			if ( index < 1 || index >= bg_numItems ) {
ADDRLP4 68
ADDRLP4 60
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 1
LTI4 $502
ADDRLP4 68
INDIRI4
ADDRGP4 bg_numItems
INDIRI4
LTI4 $500
LABELV $502
line 590
;590:				break;
ADDRGP4 $309
JUMPV
LABELV $500
line 592
;591:			}
;592:			item = &bg_itemlist[ index ];
ADDRLP4 64
CNSTI4 56
ADDRLP4 60
INDIRI4
MULI4
ADDRGP4 bg_itemlist
ADDP4
ASGNP4
line 594
;593:			// powerup pickups are global
;594:			trap_S_StartSound (NULL, cg.snap->ps.clientNum, CHAN_AUTO, trap_S_RegisterSound( item->pickup_sound ) );
ADDRLP4 64
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 72
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 597
;595:
;596:			// show icon and name on status bar
;597:			if ( es->number == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $309
line 598
;598:				CG_ItemPickup( index );
ADDRLP4 60
INDIRI4
ARGI4
ADDRGP4 CG_ItemPickup
CALLV
pop
line 599
;599:			}
line 600
;600:		}
line 601
;601:		break;
ADDRGP4 $309
JUMPV
LABELV $507
line 607
;602:
;603:	//
;604:	// weapon events
;605:	//
;606:	case EV_NOAMMO:
;607:		DEBUGNAME("EV_NOAMMO");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $508
ADDRGP4 $511
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $508
line 609
;608://		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.noAmmoSound );
;609:		if ( es->number == cg.snap->ps.clientNum && !(cg.snap->ps.stats[STAT_EXTENDED_INFO] &EXT_LIMIT_WEAPONS)) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $309
ADDRGP4 cg+32
INDIRP4
CNSTI4 256
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
NEI4 $309
line 610
;610:			CG_OutOfAmmoChange();
ADDRGP4 CG_OutOfAmmoChange
CALLV
pop
line 611
;611:		}
line 612
;612:		break;
ADDRGP4 $309
JUMPV
LABELV $516
line 614
;613:	case EV_CHANGE_WEAPON:
;614:		DEBUGNAME("EV_CHANGE_WEAPON");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $517
ADDRGP4 $520
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $517
line 615
;615:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.selectSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+448
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 616
;616:		break;
ADDRGP4 $309
JUMPV
LABELV $523
line 618
;617:	case EV_FIRE_WEAPON:
;618:		DEBUGNAME("EV_FIRE_WEAPON");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $524
ADDRGP4 $527
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $524
line 619
;619:		CG_FireWeapon( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FireWeapon
CALLV
pop
line 620
;620:		break;
ADDRGP4 $309
JUMPV
LABELV $528
line 623
;621:
;622:	case EV_USE_ITEM0:
;623:		DEBUGNAME("EV_USE_ITEM0");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $529
ADDRGP4 $532
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $529
line 624
;624:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 625
;625:		break;
ADDRGP4 $309
JUMPV
LABELV $533
line 627
;626:	case EV_USE_ITEM1:
;627:		DEBUGNAME("EV_USE_ITEM1");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $534
ADDRGP4 $537
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $534
line 628
;628:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 629
;629:		break;
ADDRGP4 $309
JUMPV
LABELV $538
line 631
;630:	case EV_USE_ITEM2:
;631:		DEBUGNAME("EV_USE_ITEM2");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $539
ADDRGP4 $542
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $539
line 632
;632:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 633
;633:		break;
ADDRGP4 $309
JUMPV
LABELV $543
line 635
;634:	case EV_USE_ITEM3:
;635:		DEBUGNAME("EV_USE_ITEM3");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $544
ADDRGP4 $547
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $544
line 636
;636:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 637
;637:		break;
ADDRGP4 $309
JUMPV
LABELV $548
line 639
;638:	case EV_USE_ITEM4:
;639:		DEBUGNAME("EV_USE_ITEM4");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $549
ADDRGP4 $552
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $549
line 640
;640:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 641
;641:		break;
ADDRGP4 $309
JUMPV
LABELV $553
line 643
;642:	case EV_USE_ITEM5:
;643:		DEBUGNAME("EV_USE_ITEM5");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $554
ADDRGP4 $557
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $554
line 644
;644:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 645
;645:		break;
ADDRGP4 $309
JUMPV
LABELV $558
line 647
;646:	case EV_USE_ITEM6:
;647:		DEBUGNAME("EV_USE_ITEM6");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $559
ADDRGP4 $562
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $559
line 648
;648:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 649
;649:		break;
ADDRGP4 $309
JUMPV
LABELV $563
line 651
;650:	case EV_USE_ITEM7:
;651:		DEBUGNAME("EV_USE_ITEM7");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $564
ADDRGP4 $567
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $564
line 652
;652:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 653
;653:		break;
ADDRGP4 $309
JUMPV
LABELV $568
line 655
;654:	case EV_USE_ITEM8:
;655:		DEBUGNAME("EV_USE_ITEM8");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $569
ADDRGP4 $572
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $569
line 656
;656:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 657
;657:		break;
ADDRGP4 $309
JUMPV
LABELV $573
line 659
;658:	case EV_USE_ITEM9:
;659:		DEBUGNAME("EV_USE_ITEM9");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $574
ADDRGP4 $577
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $574
line 660
;660:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 661
;661:		break;
ADDRGP4 $309
JUMPV
LABELV $578
line 663
;662:	case EV_USE_ITEM10:
;663:		DEBUGNAME("EV_USE_ITEM10");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $579
ADDRGP4 $582
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $579
line 664
;664:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 665
;665:		break;
ADDRGP4 $309
JUMPV
LABELV $583
line 667
;666:	case EV_USE_ITEM11:
;667:		DEBUGNAME("EV_USE_ITEM11");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $584
ADDRGP4 $587
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $584
line 668
;668:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 669
;669:		break;
ADDRGP4 $309
JUMPV
LABELV $588
line 671
;670:	case EV_USE_ITEM12:
;671:		DEBUGNAME("EV_USE_ITEM12");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $589
ADDRGP4 $592
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $589
line 672
;672:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 673
;673:		break;
ADDRGP4 $309
JUMPV
LABELV $593
line 675
;674:	case EV_USE_ITEM13:
;675:		DEBUGNAME("EV_USE_ITEM13");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $594
ADDRGP4 $597
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $594
line 676
;676:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 677
;677:		break;
ADDRGP4 $309
JUMPV
LABELV $598
line 679
;678:	case EV_USE_ITEM14:
;679:		DEBUGNAME("EV_USE_ITEM14");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $599
ADDRGP4 $602
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $599
line 680
;680:		CG_UseItem( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_UseItem
CALLV
pop
line 681
;681:		break;
ADDRGP4 $309
JUMPV
LABELV $603
line 689
;682:
;683:	//=================================================================
;684:
;685:	//
;686:	// other events
;687:	//
;688:	case EV_PLAYER_TELEPORT_IN:
;689:		DEBUGNAME("EV_PLAYER_TELEPORT_IN");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $604
ADDRGP4 $607
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $604
line 690
;690:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.teleInSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+624
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 691
;691:		CG_SpawnEffect( position);
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 CG_SpawnEffect
CALLV
pop
line 692
;692:		break;
ADDRGP4 $309
JUMPV
LABELV $610
line 695
;693:
;694:	case EV_PLAYER_TELEPORT_OUT:
;695:		DEBUGNAME("EV_PLAYER_TELEPORT_OUT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $611
ADDRGP4 $614
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $611
line 696
;696:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.teleOutSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+628
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 697
;697:		CG_SpawnEffect(  position);
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 CG_SpawnEffect
CALLV
pop
line 698
;698:		break;
ADDRGP4 $309
JUMPV
LABELV $617
line 701
;699:
;700:	case EV_ITEM_POP:
;701:		DEBUGNAME("EV_ITEM_POP");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $618
ADDRGP4 $621
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $618
line 702
;702:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.respawnSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+636
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 703
;703:		break;
ADDRGP4 $309
JUMPV
LABELV $624
line 705
;704:	case EV_ITEM_RESPAWN:
;705:		DEBUGNAME("EV_ITEM_RESPAWN");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $625
ADDRGP4 $628
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $625
line 706
;706:		cent->miscTime = cg.time;	// scale up from this
ADDRFP4 0
INDIRP4
CNSTI4 432
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 707
;707:		trap_S_StartSound (NULL, es->number, CHAN_AUTO, cgs.media.respawnSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+636
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 708
;708:		break;
ADDRGP4 $309
JUMPV
LABELV $632
line 711
;709:
;710:	case EV_GRENADE_BOUNCE:
;711:		DEBUGNAME("EV_GRENADE_BOUNCE");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $633
ADDRGP4 $636
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $633
line 712
;712:		if ( rand() & 1 ) {
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $637
line 713
;713:			trap_S_StartSound (NULL, es->number, CHAN_AUTO, trap_S_RegisterSound("sound/weapons/grenade/hgrenb1a.wav") );
ADDRGP4 $639
ARGP4
ADDRLP4 64
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 64
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 714
;714:		} else {
ADDRGP4 $309
JUMPV
LABELV $637
line 715
;715:			trap_S_StartSound (NULL, es->number, CHAN_AUTO, trap_S_RegisterSound("sound/weapons/grenade/hgrenb2a.wav") );
ADDRGP4 $640
ARGP4
ADDRLP4 64
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 64
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 716
;716:		}
line 717
;717:		break;
ADDRGP4 $309
JUMPV
LABELV $641
line 723
;718:
;719:	//
;720:	// missile impacts
;721:	//
;722:	case EV_MISSILE_HIT:
;723:		DEBUGNAME("EV_MISSILE_HIT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $642
ADDRGP4 $645
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $642
line 724
;724:		ByteToDir( es->eventParm, dir );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 ByteToDir
CALLV
pop
line 725
;725:		CG_MissileHitPlayer( es->weapon, position, dir, es->otherEntityNum );
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_MissileHitPlayer
CALLV
pop
line 726
;726:		break;
ADDRGP4 $309
JUMPV
LABELV $646
line 729
;727:
;728:	case EV_MISSILE_HIT_ROBOT:
;729:		DEBUGNAME("EV_MISSILE_HIT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $647
ADDRGP4 $645
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $647
line 730
;730:		ByteToDir( es->eventParm, dir );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 ByteToDir
CALLV
pop
line 731
;731:		CG_MissileHitRPlayer( es->weapon, position, dir, es->otherEntityNum );
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_MissileHitRPlayer
CALLI4
pop
line 732
;732:		break;
ADDRGP4 $309
JUMPV
LABELV $650
line 735
;733:
;734:	case EV_MISSILE_MISS:
;735:		DEBUGNAME("EV_MISSILE_MISS");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $651
ADDRGP4 $654
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $651
line 736
;736:		ByteToDir( es->eventParm, dir );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 ByteToDir
CALLV
pop
line 737
;737:		CG_MissileHitWall( es->weapon, 0, position, dir );
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRGP4 CG_MissileHitWall
CALLV
pop
line 738
;738:		break;
ADDRGP4 $309
JUMPV
LABELV $655
line 741
;739:
;740:	case EV_RAILTRAIL:
;741:		DEBUGNAME("EV_RAILTRAIL");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $656
ADDRGP4 $659
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $656
line 742
;742:		cent->currentState.weapon = WP_RAILGUN;
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 7
ASGNI4
line 744
;743:		// if the end was on a nomark surface, don't make an explosion
;744:		if ( es->eventParm != 255 ) {
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 255
EQI4 $660
line 745
;745:			ByteToDir( es->eventParm, dir );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 ByteToDir
CALLV
pop
line 746
;746:			CG_MissileHitWall( es->weapon, es->clientNum, position, dir );
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRGP4 CG_MissileHitWall
CALLV
pop
line 747
;747:		}
LABELV $660
line 749
;748:#if 1
;749:		CG_RailTrail( ci, es->origin2, es->pos.trBase );
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRGP4 CG_RailTrail
CALLV
pop
line 755
;750:#else
;751:		// the railtrail temp entity will be spawned when this player is added
;752:		VectorCopy( es->pos.trBase, cg_entities[clientNum].pe.railgunImpact );
;753:		cg_entities[clientNum].pe.railgunFlash = qtrue;
;754:#endif
;755:		break;
ADDRGP4 $309
JUMPV
LABELV $662
line 758
;756:
;757:	case EV_BULLET_HIT_ROBOT:
;758:		DEBUGNAME("EV_BULLET_HIT_ROBOT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $663
ADDRGP4 $666
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $663
line 759
;759:		ByteToDir( es->eventParm, dir );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 ByteToDir
CALLV
pop
line 760
;760:		CG_Bullet( es->origin2, es->pos.trBase, es->otherEntityNum, dir, -1, es->eventParm  );
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_Bullet
CALLV
pop
line 761
;761:		break;
ADDRGP4 $309
JUMPV
LABELV $667
line 764
;762:
;763:	case EV_BULLET_HIT_WALL:
;764:		DEBUGNAME("EV_BULLET_HIT_WALL");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $668
ADDRGP4 $671
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $668
line 765
;765:		ByteToDir( es->eventParm, dir );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 ByteToDir
CALLV
pop
line 766
;766:		CG_Bullet( es->origin2, es->pos.trBase, es->otherEntityNum, dir, qfalse, ENTITYNUM_WORLD );
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1022
ARGI4
ADDRGP4 CG_Bullet
CALLV
pop
line 767
;767:		break;
ADDRGP4 $309
JUMPV
LABELV $672
line 770
;768:
;769:	case EV_BULLET_HIT_FLESH:
;770:		DEBUGNAME("EV_BULLET_HIT_FLESH");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $673
ADDRGP4 $676
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $673
line 771
;771:		CG_Bullet( es->origin2, es->pos.trBase, es->otherEntityNum, dir, qtrue, es->eventParm );
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_Bullet
CALLV
pop
line 772
;772:		break;
ADDRGP4 $309
JUMPV
LABELV $677
line 775
;773:
;774:	case EV_BULLET_HIT_CORPSE:
;775:		DEBUGNAME("EV_BULLET_HIT_CORPSE");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $678
ADDRGP4 $681
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $678
line 776
;776:		CG_Bullet( es->origin2, es->pos.trBase, es->otherEntityNum, dir, qtrue, ENTITYNUM_WORLD);
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1
ARGI4
CNSTI4 1022
ARGI4
ADDRGP4 CG_Bullet
CALLV
pop
line 777
;777:		break;
ADDRGP4 $309
JUMPV
LABELV $682
line 780
;778:
;779:	case EV_SHOTGUN:
;780:		DEBUGNAME("EV_SHOTGUN");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $683
ADDRGP4 $686
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $683
line 781
;781:		CG_ShotgunFire( es );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_ShotgunFire
CALLV
pop
line 782
;782:		break;
ADDRGP4 $309
JUMPV
LABELV $687
line 785
;783:
;784:	case EV_GENERAL_SOUND:
;785:		if(es->eventParm == 8 && es->legsAnim == MAX_ANIMATIONS) // "*fallingi.wav" - wallclimbers aren't actually falling
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 8
NEI4 $688
ADDRLP4 0
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
CNSTI4 25
NEI4 $688
line 786
;786:		{
line 787
;787:			break;
ADDRGP4 $309
JUMPV
LABELV $688
line 789
;788:		}
;789:		DEBUGNAME("EV_GENERAL_SOUND");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $690
ADDRGP4 $693
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $690
line 790
;790:		if ( cgs.gameSounds[ es->eventParm ] ) {
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+25696
ADDP4
INDIRI4
CNSTI4 0
EQI4 $694
line 791
;791:			trap_S_StartSound (NULL, es->number, CHAN_VOICE, cgs.gameSounds[ es->eventParm ] );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+25696
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 792
;792:		} else {
ADDRGP4 $309
JUMPV
LABELV $694
line 793
;793:			s = CG_ConfigString( CS_SOUNDS + es->eventParm );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 288
ADDI4
ARGI4
ADDRLP4 96
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 96
INDIRP4
ASGNP4
line 794
;794:			trap_S_StartSound (NULL, es->number, CHAN_VOICE, CG_CustomSound( es->number, s ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 100
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 100
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 795
;795:		}
line 796
;796:		break;
ADDRGP4 $309
JUMPV
LABELV $698
line 799
;797:
;798:	case EV_GLOBAL_SOUND:	// play from the player's head so it never diminishes
;799:		DEBUGNAME("EV_GLOBAL_SOUND");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $699
ADDRGP4 $702
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $699
line 800
;800:		if ( cgs.gameSounds[ es->eventParm ] ) {
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+25696
ADDP4
INDIRI4
CNSTI4 0
EQI4 $703
line 801
;801:			trap_S_StartSound (NULL, cg.snap->ps.clientNum, CHAN_AUTO, cgs.gameSounds[ es->eventParm ] );
CNSTP4 0
ARGP4
ADDRLP4 96
CNSTI4 184
ASGNI4
ADDRGP4 cg+32
INDIRP4
ADDRLP4 96
INDIRI4
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 0
INDIRP4
ADDRLP4 96
INDIRI4
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+25696
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 802
;802:		} else {
ADDRGP4 $309
JUMPV
LABELV $703
line 803
;803:			s = CG_ConfigString( CS_SOUNDS + es->eventParm );
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 288
ADDI4
ARGI4
ADDRLP4 96
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 96
INDIRP4
ASGNP4
line 804
;804:			trap_S_StartSound (NULL, cg.snap->ps.clientNum, CHAN_AUTO, CG_CustomSound( es->number, s ) );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 100
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 100
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 805
;805:		}
line 806
;806:		break;
ADDRGP4 $309
JUMPV
LABELV $709
line 809
;807:
;808:	case EV_BLOOD:			
;809:	{
line 814
;810:		vec3_t pos, end;
;811:		int radius;
;812:		trace_t trace;
;813:		
;814:		pos[0] = cent->lerpOrigin[0] + crandom() * 8;
ADDRLP4 180
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 96
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 180
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 815
;815:		pos[1] = cent->lerpOrigin[1] + crandom() * 8;
ADDRLP4 184
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 96+4
ADDRFP4 0
INDIRP4
CNSTI4 656
ADDP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 184
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 816
;816:		pos[2] = cent->lerpOrigin[2] + crandom() * 8;
ADDRLP4 188
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 96+8
ADDRFP4 0
INDIRP4
CNSTI4 660
ADDP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 188
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 817
;817:		end[0] = pos[0];
ADDRLP4 108
ADDRLP4 96
INDIRF4
ASGNF4
line 818
;818:		end[1] = pos[1];
ADDRLP4 108+4
ADDRLP4 96+4
INDIRF4
ASGNF4
line 819
;819:		end[2] = pos[2] - 128; 
ADDRLP4 108+8
ADDRLP4 96+8
INDIRF4
CNSTF4 1124073472
SUBF4
ASGNF4
line 820
;820:		radius = es->eventParm + (rand()&4) + 2;
ADDRLP4 192
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 176
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ADDRLP4 192
INDIRI4
CNSTI4 4
BANDI4
ADDI4
CNSTI4 2
ADDI4
ASGNI4
line 821
;821:		CG_Trace(&trace, pos, vec3_origin, vec3_origin, end, cent->currentState.number, MASK_SOLID);
ADDRLP4 120
ARGP4
ADDRLP4 96
ARGP4
ADDRLP4 196
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 196
INDIRP4
ARGP4
ADDRLP4 196
INDIRP4
ARGP4
ADDRLP4 108
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 822
;822:		if(trace.fraction < 1)
ADDRLP4 120+8
INDIRF4
CNSTF4 1065353216
GEF4 $716
line 823
;823:			CG_ImpactMark( cgs.media.bloodMarkShader, trace.endpos, trace.plane.normal, random()*360,
ADDRLP4 200
ADDRGP4 rand
CALLI4
ASGNI4
ADDRGP4 cgs+170516+300
INDIRI4
ARGI4
ADDRLP4 120+12
ARGP4
ADDRLP4 120+24
ARGP4
CNSTF4 1135869952
ADDRLP4 200
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ARGF4
ADDRLP4 204
CNSTF4 1065353216
ASGNF4
ADDRLP4 204
INDIRF4
ARGF4
ADDRLP4 204
INDIRF4
ARGF4
ADDRLP4 204
INDIRF4
ARGF4
ADDRLP4 204
INDIRF4
ARGF4
CNSTI4 1
ARGI4
ADDRLP4 176
INDIRI4
CVIF4 4
ARGF4
CNSTI4 0
ARGI4
ADDRGP4 CG_ImpactMark
CALLV
pop
LABELV $716
line 826
;824:				1,1,1,1, qtrue, radius, qfalse );
;825:		
;826:		if(es->eventParm > 1)
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 1
LEI4 $723
line 827
;827:		{			
line 834
;828:			int		t;
;829:			int		t2;
;830:			int		step;
;831:			vec3_t	newOrigin;
;832:			localEntity_t	*blood;
;833:
;834:			step = 150;
ADDRLP4 228
CNSTI4 150
ASGNI4
line 835
;835:			t = step * ( (cg.time - cg.frametime + step ) / step );
ADDRLP4 236
ADDRLP4 228
INDIRI4
ASGNI4
ADDRLP4 208
ADDRLP4 236
INDIRI4
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+105500
INDIRI4
SUBI4
ADDRLP4 236
INDIRI4
ADDI4
ADDRLP4 236
INDIRI4
DIVI4
MULI4
ASGNI4
line 836
;836:			t2 = step * ( cg.time / step );
ADDRLP4 240
ADDRLP4 228
INDIRI4
ASGNI4
ADDRLP4 232
ADDRLP4 240
INDIRI4
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 240
INDIRI4
DIVI4
MULI4
ASGNI4
line 838
;837:
;838:			for ( ; t <= t2; t += step ) {
ADDRGP4 $731
JUMPV
LABELV $728
line 839
;839:				BG_EvaluateTrajectory( &cent->currentState.pos, t, newOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 208
INDIRI4
ARGI4
ADDRLP4 216
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 841
;840:
;841:				blood = CG_SmokePuff( newOrigin, vec3_origin, 
ADDRLP4 216
ARGP4
ADDRGP4 vec3_origin
ARGP4
CNSTF4 1101004800
ARGF4
ADDRLP4 244
CNSTF4 1065353216
ASGNF4
ADDRLP4 244
INDIRF4
ARGF4
ADDRLP4 244
INDIRF4
ARGF4
ADDRLP4 244
INDIRF4
ARGF4
ADDRLP4 244
INDIRF4
ARGF4
CNSTF4 1157234688
ARGF4
ADDRLP4 208
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 cgs+170516+224
INDIRI4
ARGI4
ADDRLP4 248
ADDRGP4 CG_SmokePuff
CALLP4
ASGNP4
ADDRLP4 212
ADDRLP4 248
INDIRP4
ASGNP4
line 849
;842:							20,		// radius
;843:							1, 1, 1, 1,	// color
;844:							2000,		// trailTime
;845:							t,		// startTime
;846:							0,		// flags
;847:							  cgs.media.bloodTrailShader );
;848:				// use the optimized version
;849:				blood->leType = LE_FALL_SCALE_FADE;
ADDRLP4 212
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 5
ASGNI4
line 851
;850:				// drop a total of 40 units over its lifetime
;851:				blood->pos.trDelta[2] = 40;
ADDRLP4 212
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 1109393408
ASGNF4
line 852
;852:			}
LABELV $729
line 838
ADDRLP4 208
ADDRLP4 208
INDIRI4
ADDRLP4 228
INDIRI4
ADDI4
ASGNI4
LABELV $731
ADDRLP4 208
INDIRI4
ADDRLP4 232
INDIRI4
LEI4 $728
line 854
;853:
;854:		}
ADDRGP4 $309
JUMPV
LABELV $723
line 855
;855:		else if(!(cent->currentState.eFlags & EF_DEAD))
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $309
line 856
;856:		{
line 858
;857:			vec3_t not_out_her_ass;
;858:			not_out_her_ass[0] = position[0] + rand() % 25 - 12;
ADDRLP4 220
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 208
ADDRFP4 4
INDIRP4
INDIRF4
ADDRLP4 220
INDIRI4
CNSTI4 25
MODI4
CVIF4 4
ADDF4
CNSTF4 1094713344
SUBF4
ASGNF4
line 859
;859:			not_out_her_ass[1] = position[1] + rand() % 25 - 12;
ADDRLP4 224
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 208+4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 224
INDIRI4
CNSTI4 25
MODI4
CVIF4 4
ADDF4
CNSTF4 1094713344
SUBF4
ASGNF4
line 860
;860:			not_out_her_ass[2] = position[2] + rand() % 25;
ADDRLP4 228
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 208+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 228
INDIRI4
CNSTI4 25
MODI4
CVIF4 4
ADDF4
ASGNF4
line 861
;861:			CG_Bleed2(not_out_her_ass, es->number);
ADDRLP4 208
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 CG_Bleed2
CALLV
pop
line 862
;862:		}
line 864
;863:
;864:		break;
ADDRGP4 $309
JUMPV
LABELV $738
line 870
;865:	}
;866:	
;867:	case EV_PAIN:
;868:		// local player sounds are triggered in CG_CheckLocalSounds,
;869:		// so ignore events on the player
;870:		DEBUGNAME("EV_PAIN");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $739
ADDRGP4 $742
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $739
line 871
;871:		if ( cent->currentState.number != cg.snap->ps.clientNum ) {
ADDRFP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
EQI4 $309
line 872
;872:			CG_PainEvent( cent, es->eventParm );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_PainEvent
CALLV
pop
line 873
;873:		}
line 874
;874:		break;
ADDRGP4 $309
JUMPV
LABELV $746
line 879
;875:
;876:	case EV_DEATH1:
;877:	case EV_DEATH2: 
;878:	case EV_DEATH3:
;879:		DEBUGNAME("EV_DEATHx");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $747
ADDRGP4 $750
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $747
line 880
;880:		trap_S_StartSound( NULL, es->number, CHAN_VOICE, 
ADDRGP4 $751
ARGP4
ADDRLP4 8
INDIRI4
CNSTI4 55
SUBI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 96
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRLP4 96
INDIRP4
ARGP4
ADDRLP4 100
ADDRGP4 CG_CustomSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 100
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 883
;881:				CG_CustomSound( es->number, va("*death%i.wav", event - EV_DEATH1 + 1) ) );
;882:		
;883:		{
line 887
;884:			vec3_t end;
;885:			int radius;
;886:			trace_t trace;
;887:			end[0] = position[0];
ADDRLP4 104
ADDRFP4 4
INDIRP4
INDIRF4
ASGNF4
line 888
;888:			end[1] = position[1];
ADDRLP4 104+4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
line 889
;889:			end[2] = position[2] - 128; 
ADDRLP4 104+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1124073472
SUBF4
ASGNF4
line 890
;890:			radius = 16 + (rand()&31);
ADDRLP4 176
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 172
ADDRLP4 176
INDIRI4
CNSTI4 31
BANDI4
CNSTI4 16
ADDI4
ASGNI4
line 891
;891:			CG_Trace(&trace, position, vec3_origin, vec3_origin, end, cent->currentState.number, MASK_SOLID);
ADDRLP4 116
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 180
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 180
INDIRP4
ARGP4
ADDRLP4 180
INDIRP4
ARGP4
ADDRLP4 104
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 892
;892:			if(trace.fraction < 1)
ADDRLP4 116+8
INDIRF4
CNSTF4 1065353216
GEF4 $754
line 893
;893:				CG_ImpactMark( cgs.media.bloodMarkShader, trace.endpos, trace.plane.normal, random()*360,
ADDRLP4 184
ADDRGP4 rand
CALLI4
ASGNI4
ADDRGP4 cgs+170516+300
INDIRI4
ARGI4
ADDRLP4 116+12
ARGP4
ADDRLP4 116+24
ARGP4
CNSTF4 1135869952
ADDRLP4 184
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ARGF4
ADDRLP4 188
CNSTF4 1065353216
ASGNF4
ADDRLP4 188
INDIRF4
ARGF4
ADDRLP4 188
INDIRF4
ARGF4
ADDRLP4 188
INDIRF4
ARGF4
ADDRLP4 188
INDIRF4
ARGF4
CNSTI4 1
ARGI4
ADDRLP4 172
INDIRI4
CVIF4 4
ARGF4
CNSTI4 0
ARGI4
ADDRGP4 CG_ImpactMark
CALLV
pop
LABELV $754
line 895
;894:					1,1,1,1, qtrue, radius, qfalse );
;895:		}
line 896
;896:		if(es->eFlags & EF_AWARD_IMPRESSIVE) // head blown off
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 32768
BANDI4
CNSTI4 0
EQI4 $309
line 897
;897:		{
line 898
;898:			CG_LaunchGib( es->origin, es->pos.trDelta, cgs.clientinfo[ es->clientNum ].headModel);
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ARGP4
CNSTI4 1076
ADDRLP4 0
INDIRP4
CNSTI4 168
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+436
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLI4
pop
line 899
;899:		}
line 900
;900:		break;
ADDRGP4 $309
JUMPV
LABELV $765
line 903
;901:		
;902:	case EV_OBITUARY:
;903:		DEBUGNAME("EV_OBITUARY");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $766
ADDRGP4 $769
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $766
line 904
;904:		CG_Obituary( es );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_Obituary
CALLV
pop
line 905
;905:		break;
ADDRGP4 $309
JUMPV
LABELV $770
line 911
;906:
;907:	//
;908:	// powerup events
;909:	//
;910:	case EV_POWERUP_QUAD:
;911:		DEBUGNAME("EV_POWERUP_QUAD");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $771
ADDRGP4 $774
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $771
line 912
;912:		if ( es->number == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $775
line 913
;913:			cg.powerupActive = PW_QUAD;
ADDRGP4 cg+111888
CNSTI4 1
ASGNI4
line 914
;914:			cg.powerupTime = cg.time;
ADDRGP4 cg+111892
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 915
;915:		}
LABELV $775
line 916
;916:		trap_S_StartSound (NULL, es->number, CHAN_ITEM, cgs.media.quadSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRGP4 cgs+170516+440
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 917
;917:		break;
ADDRGP4 $309
JUMPV
LABELV $783
line 919
;918:	case EV_POWERUP_BATTLESUIT:
;919:		DEBUGNAME("EV_POWERUP_BATTLESUIT");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $784
ADDRGP4 $787
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $784
line 920
;920:		if ( es->number == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $788
line 921
;921:			cg.powerupActive = PW_BATTLESUIT;
ADDRGP4 cg+111888
CNSTI4 2
ASGNI4
line 922
;922:			cg.powerupTime = cg.time;
ADDRGP4 cg+111892
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 923
;923:		}
LABELV $788
line 924
;924:		trap_S_StartSound (NULL, es->number, CHAN_ITEM, trap_S_RegisterSound("sound/items/protect3.wav") );
ADDRGP4 $794
ARGP4
ADDRLP4 104
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 104
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 925
;925:		break;
ADDRGP4 $309
JUMPV
LABELV $795
line 927
;926:	case EV_POWERUP_REGEN:
;927:		DEBUGNAME("EV_POWERUP_REGEN");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $796
ADDRGP4 $799
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $796
line 928
;928:		if ( es->number == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $800
line 929
;929:			cg.powerupActive = PW_REGEN;
ADDRGP4 cg+111888
CNSTI4 5
ASGNI4
line 930
;930:			cg.powerupTime = cg.time;
ADDRGP4 cg+111892
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 931
;931:		}
LABELV $800
line 932
;932:		trap_S_StartSound (NULL, es->number, CHAN_ITEM, trap_S_RegisterSound("sound/items/regen.wav") );
ADDRGP4 $806
ARGP4
ADDRLP4 108
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 108
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 933
;933:		break;
ADDRGP4 $309
JUMPV
LABELV $807
line 936
;934:
;935:	case EV_ENDCLIMBWALL:
;936:		cent->wallclimber = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
CNSTI4 0
ASGNI4
line 937
;937:		break;
ADDRGP4 $309
JUMPV
LABELV $808
line 939
;938:	case EV_GIB_PLAYER:
;939:		DEBUGNAME("EV_GIB_PLAYER");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $809
ADDRGP4 $812
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $809
line 940
;940:		trap_S_StartSound( NULL, es->number, CHAN_BODY, cgs.media.gibSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRGP4 cgs+170516+608
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 941
;941:		CG_GibPlayer( cent->lerpOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 CG_GibPlayer
CALLV
pop
line 943
;942:		
;943:		break;
ADDRGP4 $309
JUMPV
LABELV $815
line 945
;944:	case EV_CLIMBWALL:
;945:		cent->wallclimber = qtrue;		
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
CNSTI4 1
ASGNI4
line 946
;946:		break;
ADDRGP4 $309
JUMPV
LABELV $816
line 948
;947:	case EV_GIB_NOBLOOD:
;948:		DEBUGNAME("EV_GIB_NOBLOOD");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $817
ADDRGP4 $820
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $817
line 950
;949:		//CG_Printf("Noblood?\n");
;950:		trap_S_StartSound( NULL, es->number, CHAN_BODY, cgs.media.gibSound );
CNSTP4 0
ARGP4
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRGP4 cgs+170516+608
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 951
;951:		CG_GibNoBlood( cent->lerpOrigin );
ADDRFP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 CG_GibNoBlood
CALLI4
pop
line 952
;952:		break;
ADDRGP4 $309
JUMPV
LABELV $823
line 955
;953:
;954:	case EV_DEBUG_LINE:
;955:		DEBUGNAME("EV_DEBUG_LINE");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $824
ADDRGP4 $827
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $824
line 956
;956:		CG_Beam( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_Beam
CALLV
pop
line 957
;957:		break;
ADDRGP4 $309
JUMPV
LABELV $308
line 960
;958:
;959:	default:
;960:		DEBUGNAME("UNKNOWN");
ADDRGP4 cg_debugEvents+12
INDIRI4
CNSTI4 0
EQI4 $828
ADDRGP4 $831
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $828
line 961
;961:		CG_Error( "Unknown event: %i", event );
ADDRGP4 $832
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 962
;962:		break;
LABELV $309
line 965
;963:	}
;964:
;965:}
LABELV $293
endproc CG_EntityEvent 252 44
export CG_CheckEvents
proc CG_CheckEvents 8 12
line 974
;966:
;967:
;968:/*
;969:==============
;970:CG_CheckEvents
;971:
;972:==============
;973:*/
;974:void CG_CheckEvents( centity_t *cent ) {
line 976
;975:	// check for event-only entities
;976:	if ( cent->currentState.eType > ET_EVENTS ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 12
LEI4 $836
line 977
;977:		if ( cent->previousEvent ) {
ADDRFP4 0
INDIRP4
CNSTI4 420
ADDP4
INDIRI4
CNSTI4 0
EQI4 $838
line 978
;978:			return;	// already fired
ADDRGP4 $835
JUMPV
LABELV $838
line 980
;979:		}
;980:		cent->previousEvent = 1;
ADDRFP4 0
INDIRP4
CNSTI4 420
ADDP4
CNSTI4 1
ASGNI4
line 982
;981:
;982:		cent->currentState.event = cent->currentState.eType - ET_EVENTS;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 12
SUBI4
ASGNI4
line 983
;983:	} else {
ADDRGP4 $837
JUMPV
LABELV $836
line 985
;984:		// check for events riding with another entity
;985:		if ( cent->currentState.event == cent->previousEvent ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 420
ADDP4
INDIRI4
NEI4 $840
line 986
;986:			return;
ADDRGP4 $835
JUMPV
LABELV $840
line 988
;987:		}
;988:		cent->previousEvent = cent->currentState.event;
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 420
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
ASGNI4
line 989
;989:		if ( ( cent->currentState.event & ~EV_EVENT_BITS ) == 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 180
ADDP4
INDIRI4
CNSTI4 -769
BANDI4
CNSTI4 0
NEI4 $842
line 990
;990:			return;
ADDRGP4 $835
JUMPV
LABELV $842
line 992
;991:		}
;992:	}
LABELV $837
line 995
;993:
;994:	// calculate the position at exactly the frame time
;995:	BG_EvaluateTrajectory( &cent->currentState.pos, cg.snap->serverTime, cent->lerpOrigin );
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 BG_EvaluateTrajectory
CALLV
pop
line 996
;996:	CG_SetEntitySoundPosition( cent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_SetEntitySoundPosition
CALLV
pop
line 998
;997:
;998:	CG_EntityEvent( cent, cent->lerpOrigin );
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 652
ADDP4
ARGP4
ADDRGP4 CG_EntityEvent
CALLV
pop
line 999
;999:}
LABELV $835
endproc CG_CheckEvents 8 12
import CG_GibNoBlood
import CG_LaunchGib
import CG_MissileHitRPlayer
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $832
byte 1 85
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 101
byte 1 118
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $831
byte 1 85
byte 1 78
byte 1 75
byte 1 78
byte 1 79
byte 1 87
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $827
byte 1 69
byte 1 86
byte 1 95
byte 1 68
byte 1 69
byte 1 66
byte 1 85
byte 1 71
byte 1 95
byte 1 76
byte 1 73
byte 1 78
byte 1 69
byte 1 10
byte 1 0
align 1
LABELV $820
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 73
byte 1 66
byte 1 95
byte 1 78
byte 1 79
byte 1 66
byte 1 76
byte 1 79
byte 1 79
byte 1 68
byte 1 10
byte 1 0
align 1
LABELV $812
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 73
byte 1 66
byte 1 95
byte 1 80
byte 1 76
byte 1 65
byte 1 89
byte 1 69
byte 1 82
byte 1 10
byte 1 0
align 1
LABELV $806
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 47
byte 1 114
byte 1 101
byte 1 103
byte 1 101
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $799
byte 1 69
byte 1 86
byte 1 95
byte 1 80
byte 1 79
byte 1 87
byte 1 69
byte 1 82
byte 1 85
byte 1 80
byte 1 95
byte 1 82
byte 1 69
byte 1 71
byte 1 69
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $794
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 47
byte 1 112
byte 1 114
byte 1 111
byte 1 116
byte 1 101
byte 1 99
byte 1 116
byte 1 51
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $787
byte 1 69
byte 1 86
byte 1 95
byte 1 80
byte 1 79
byte 1 87
byte 1 69
byte 1 82
byte 1 85
byte 1 80
byte 1 95
byte 1 66
byte 1 65
byte 1 84
byte 1 84
byte 1 76
byte 1 69
byte 1 83
byte 1 85
byte 1 73
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $774
byte 1 69
byte 1 86
byte 1 95
byte 1 80
byte 1 79
byte 1 87
byte 1 69
byte 1 82
byte 1 85
byte 1 80
byte 1 95
byte 1 81
byte 1 85
byte 1 65
byte 1 68
byte 1 10
byte 1 0
align 1
LABELV $769
byte 1 69
byte 1 86
byte 1 95
byte 1 79
byte 1 66
byte 1 73
byte 1 84
byte 1 85
byte 1 65
byte 1 82
byte 1 89
byte 1 10
byte 1 0
align 1
LABELV $751
byte 1 42
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 37
byte 1 105
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $750
byte 1 69
byte 1 86
byte 1 95
byte 1 68
byte 1 69
byte 1 65
byte 1 84
byte 1 72
byte 1 120
byte 1 10
byte 1 0
align 1
LABELV $742
byte 1 69
byte 1 86
byte 1 95
byte 1 80
byte 1 65
byte 1 73
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $702
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 76
byte 1 79
byte 1 66
byte 1 65
byte 1 76
byte 1 95
byte 1 83
byte 1 79
byte 1 85
byte 1 78
byte 1 68
byte 1 10
byte 1 0
align 1
LABELV $693
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 69
byte 1 78
byte 1 69
byte 1 82
byte 1 65
byte 1 76
byte 1 95
byte 1 83
byte 1 79
byte 1 85
byte 1 78
byte 1 68
byte 1 10
byte 1 0
align 1
LABELV $686
byte 1 69
byte 1 86
byte 1 95
byte 1 83
byte 1 72
byte 1 79
byte 1 84
byte 1 71
byte 1 85
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $681
byte 1 69
byte 1 86
byte 1 95
byte 1 66
byte 1 85
byte 1 76
byte 1 76
byte 1 69
byte 1 84
byte 1 95
byte 1 72
byte 1 73
byte 1 84
byte 1 95
byte 1 67
byte 1 79
byte 1 82
byte 1 80
byte 1 83
byte 1 69
byte 1 10
byte 1 0
align 1
LABELV $676
byte 1 69
byte 1 86
byte 1 95
byte 1 66
byte 1 85
byte 1 76
byte 1 76
byte 1 69
byte 1 84
byte 1 95
byte 1 72
byte 1 73
byte 1 84
byte 1 95
byte 1 70
byte 1 76
byte 1 69
byte 1 83
byte 1 72
byte 1 10
byte 1 0
align 1
LABELV $671
byte 1 69
byte 1 86
byte 1 95
byte 1 66
byte 1 85
byte 1 76
byte 1 76
byte 1 69
byte 1 84
byte 1 95
byte 1 72
byte 1 73
byte 1 84
byte 1 95
byte 1 87
byte 1 65
byte 1 76
byte 1 76
byte 1 10
byte 1 0
align 1
LABELV $666
byte 1 69
byte 1 86
byte 1 95
byte 1 66
byte 1 85
byte 1 76
byte 1 76
byte 1 69
byte 1 84
byte 1 95
byte 1 72
byte 1 73
byte 1 84
byte 1 95
byte 1 82
byte 1 79
byte 1 66
byte 1 79
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $659
byte 1 69
byte 1 86
byte 1 95
byte 1 82
byte 1 65
byte 1 73
byte 1 76
byte 1 84
byte 1 82
byte 1 65
byte 1 73
byte 1 76
byte 1 10
byte 1 0
align 1
LABELV $654
byte 1 69
byte 1 86
byte 1 95
byte 1 77
byte 1 73
byte 1 83
byte 1 83
byte 1 73
byte 1 76
byte 1 69
byte 1 95
byte 1 77
byte 1 73
byte 1 83
byte 1 83
byte 1 10
byte 1 0
align 1
LABELV $645
byte 1 69
byte 1 86
byte 1 95
byte 1 77
byte 1 73
byte 1 83
byte 1 83
byte 1 73
byte 1 76
byte 1 69
byte 1 95
byte 1 72
byte 1 73
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $640
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 47
byte 1 104
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 98
byte 1 50
byte 1 97
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $639
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 47
byte 1 104
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 98
byte 1 49
byte 1 97
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $636
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 82
byte 1 69
byte 1 78
byte 1 65
byte 1 68
byte 1 69
byte 1 95
byte 1 66
byte 1 79
byte 1 85
byte 1 78
byte 1 67
byte 1 69
byte 1 10
byte 1 0
align 1
LABELV $628
byte 1 69
byte 1 86
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 95
byte 1 82
byte 1 69
byte 1 83
byte 1 80
byte 1 65
byte 1 87
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $621
byte 1 69
byte 1 86
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 95
byte 1 80
byte 1 79
byte 1 80
byte 1 10
byte 1 0
align 1
LABELV $614
byte 1 69
byte 1 86
byte 1 95
byte 1 80
byte 1 76
byte 1 65
byte 1 89
byte 1 69
byte 1 82
byte 1 95
byte 1 84
byte 1 69
byte 1 76
byte 1 69
byte 1 80
byte 1 79
byte 1 82
byte 1 84
byte 1 95
byte 1 79
byte 1 85
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $607
byte 1 69
byte 1 86
byte 1 95
byte 1 80
byte 1 76
byte 1 65
byte 1 89
byte 1 69
byte 1 82
byte 1 95
byte 1 84
byte 1 69
byte 1 76
byte 1 69
byte 1 80
byte 1 79
byte 1 82
byte 1 84
byte 1 95
byte 1 73
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $602
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 49
byte 1 52
byte 1 10
byte 1 0
align 1
LABELV $597
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 49
byte 1 51
byte 1 10
byte 1 0
align 1
LABELV $592
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 49
byte 1 50
byte 1 10
byte 1 0
align 1
LABELV $587
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 49
byte 1 49
byte 1 10
byte 1 0
align 1
LABELV $582
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 49
byte 1 48
byte 1 10
byte 1 0
align 1
LABELV $577
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 57
byte 1 10
byte 1 0
align 1
LABELV $572
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 56
byte 1 10
byte 1 0
align 1
LABELV $567
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 55
byte 1 10
byte 1 0
align 1
LABELV $562
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 54
byte 1 10
byte 1 0
align 1
LABELV $557
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 53
byte 1 10
byte 1 0
align 1
LABELV $552
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 52
byte 1 10
byte 1 0
align 1
LABELV $547
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 51
byte 1 10
byte 1 0
align 1
LABELV $542
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 50
byte 1 10
byte 1 0
align 1
LABELV $537
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 49
byte 1 10
byte 1 0
align 1
LABELV $532
byte 1 69
byte 1 86
byte 1 95
byte 1 85
byte 1 83
byte 1 69
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 48
byte 1 10
byte 1 0
align 1
LABELV $527
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 73
byte 1 82
byte 1 69
byte 1 95
byte 1 87
byte 1 69
byte 1 65
byte 1 80
byte 1 79
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $520
byte 1 69
byte 1 86
byte 1 95
byte 1 67
byte 1 72
byte 1 65
byte 1 78
byte 1 71
byte 1 69
byte 1 95
byte 1 87
byte 1 69
byte 1 65
byte 1 80
byte 1 79
byte 1 78
byte 1 10
byte 1 0
align 1
LABELV $511
byte 1 69
byte 1 86
byte 1 95
byte 1 78
byte 1 79
byte 1 65
byte 1 77
byte 1 77
byte 1 79
byte 1 10
byte 1 0
align 1
LABELV $499
byte 1 69
byte 1 86
byte 1 95
byte 1 71
byte 1 76
byte 1 79
byte 1 66
byte 1 65
byte 1 76
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 95
byte 1 80
byte 1 73
byte 1 67
byte 1 75
byte 1 85
byte 1 80
byte 1 10
byte 1 0
align 1
LABELV $491
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 47
byte 1 110
byte 1 95
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 116
byte 1 104
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $484
byte 1 69
byte 1 86
byte 1 95
byte 1 73
byte 1 84
byte 1 69
byte 1 77
byte 1 95
byte 1 80
byte 1 73
byte 1 67
byte 1 75
byte 1 85
byte 1 80
byte 1 10
byte 1 0
align 1
LABELV $479
byte 1 42
byte 1 103
byte 1 97
byte 1 115
byte 1 112
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $478
byte 1 69
byte 1 86
byte 1 95
byte 1 87
byte 1 65
byte 1 84
byte 1 69
byte 1 82
byte 1 95
byte 1 67
byte 1 76
byte 1 69
byte 1 65
byte 1 82
byte 1 10
byte 1 0
align 1
LABELV $471
byte 1 69
byte 1 86
byte 1 95
byte 1 87
byte 1 65
byte 1 84
byte 1 69
byte 1 82
byte 1 95
byte 1 85
byte 1 78
byte 1 68
byte 1 69
byte 1 82
byte 1 10
byte 1 0
align 1
LABELV $464
byte 1 69
byte 1 86
byte 1 95
byte 1 87
byte 1 65
byte 1 84
byte 1 69
byte 1 82
byte 1 95
byte 1 76
byte 1 69
byte 1 65
byte 1 86
byte 1 69
byte 1 10
byte 1 0
align 1
LABELV $457
byte 1 69
byte 1 86
byte 1 95
byte 1 87
byte 1 65
byte 1 84
byte 1 69
byte 1 82
byte 1 95
byte 1 84
byte 1 79
byte 1 85
byte 1 67
byte 1 72
byte 1 10
byte 1 0
align 1
LABELV $452
byte 1 42
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $451
byte 1 69
byte 1 86
byte 1 95
byte 1 84
byte 1 65
byte 1 85
byte 1 78
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $446
byte 1 69
byte 1 86
byte 1 95
byte 1 74
byte 1 85
byte 1 77
byte 1 80
byte 1 10
byte 1 0
align 1
LABELV $441
byte 1 42
byte 1 106
byte 1 117
byte 1 109
byte 1 112
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $438
byte 1 69
byte 1 86
byte 1 95
byte 1 74
byte 1 85
byte 1 77
byte 1 80
byte 1 95
byte 1 80
byte 1 65
byte 1 68
byte 1 10
byte 1 0
align 1
LABELV $408
byte 1 69
byte 1 86
byte 1 95
byte 1 83
byte 1 84
byte 1 69
byte 1 80
byte 1 10
byte 1 0
align 1
LABELV $395
byte 1 42
byte 1 102
byte 1 97
byte 1 108
byte 1 108
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $394
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 65
byte 1 76
byte 1 76
byte 1 95
byte 1 70
byte 1 65
byte 1 82
byte 1 10
byte 1 0
align 1
LABELV $382
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 65
byte 1 76
byte 1 76
byte 1 95
byte 1 77
byte 1 69
byte 1 68
byte 1 73
byte 1 85
byte 1 77
byte 1 10
byte 1 0
align 1
LABELV $368
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 65
byte 1 76
byte 1 76
byte 1 95
byte 1 83
byte 1 72
byte 1 79
byte 1 82
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $357
byte 1 69
byte 1 86
byte 1 95
byte 1 83
byte 1 87
byte 1 73
byte 1 77
byte 1 10
byte 1 0
align 1
LABELV $346
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 79
byte 1 79
byte 1 84
byte 1 87
byte 1 65
byte 1 68
byte 1 69
byte 1 10
byte 1 0
align 1
LABELV $335
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 79
byte 1 79
byte 1 84
byte 1 83
byte 1 80
byte 1 76
byte 1 65
byte 1 83
byte 1 72
byte 1 10
byte 1 0
align 1
LABELV $324
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 79
byte 1 79
byte 1 84
byte 1 83
byte 1 84
byte 1 69
byte 1 80
byte 1 95
byte 1 77
byte 1 69
byte 1 84
byte 1 65
byte 1 76
byte 1 10
byte 1 0
align 1
LABELV $314
byte 1 69
byte 1 86
byte 1 95
byte 1 70
byte 1 79
byte 1 79
byte 1 84
byte 1 83
byte 1 84
byte 1 69
byte 1 80
byte 1 10
byte 1 0
align 1
LABELV $303
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 69
byte 1 86
byte 1 69
byte 1 78
byte 1 84
byte 1 10
byte 1 0
align 1
LABELV $297
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 37
byte 1 51
byte 1 105
byte 1 32
byte 1 32
byte 1 101
byte 1 118
byte 1 101
byte 1 110
byte 1 116
byte 1 58
byte 1 37
byte 1 51
byte 1 105
byte 1 32
byte 1 0
align 1
LABELV $291
byte 1 42
byte 1 112
byte 1 97
byte 1 105
byte 1 110
byte 1 49
byte 1 48
byte 1 48
byte 1 95
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $290
byte 1 42
byte 1 112
byte 1 97
byte 1 105
byte 1 110
byte 1 55
byte 1 53
byte 1 95
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $287
byte 1 42
byte 1 112
byte 1 97
byte 1 105
byte 1 110
byte 1 53
byte 1 48
byte 1 95
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $284
byte 1 42
byte 1 112
byte 1 97
byte 1 105
byte 1 110
byte 1 50
byte 1 53
byte 1 95
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $248
byte 1 85
byte 1 115
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $247
byte 1 78
byte 1 111
byte 1 32
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $237
byte 1 37
byte 1 115
byte 1 32
byte 1 100
byte 1 105
byte 1 101
byte 1 100
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $236
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $231
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $230
byte 1 39
byte 1 115
byte 1 32
byte 1 97
byte 1 116
byte 1 116
byte 1 97
byte 1 99
byte 1 107
byte 1 0
align 1
LABELV $229
byte 1 102
byte 1 105
byte 1 110
byte 1 97
byte 1 108
byte 1 108
byte 1 121
byte 1 32
byte 1 98
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 32
byte 1 102
byte 1 114
byte 1 111
byte 1 109
byte 1 0
align 1
LABELV $227
byte 1 39
byte 1 115
byte 1 32
byte 1 112
byte 1 101
byte 1 114
byte 1 115
byte 1 111
byte 1 110
byte 1 97
byte 1 108
byte 1 32
byte 1 115
byte 1 112
byte 1 97
byte 1 99
byte 1 101
byte 1 0
align 1
LABELV $226
byte 1 116
byte 1 114
byte 1 105
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 105
byte 1 110
byte 1 118
byte 1 97
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $224
byte 1 39
byte 1 115
byte 1 32
byte 1 66
byte 1 70
byte 1 71
byte 1 0
align 1
LABELV $223
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 98
byte 1 108
byte 1 97
byte 1 115
byte 1 116
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $221
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 101
byte 1 108
byte 1 101
byte 1 99
byte 1 116
byte 1 114
byte 1 111
byte 1 99
byte 1 117
byte 1 116
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $219
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 114
byte 1 97
byte 1 105
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $216
byte 1 39
byte 1 115
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 115
byte 1 109
byte 1 97
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $215
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 109
byte 1 101
byte 1 108
byte 1 116
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $213
byte 1 97
byte 1 108
byte 1 109
byte 1 111
byte 1 115
byte 1 116
byte 1 32
byte 1 100
byte 1 111
byte 1 100
byte 1 103
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $211
byte 1 39
byte 1 115
byte 1 32
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $209
byte 1 39
byte 1 115
byte 1 32
byte 1 115
byte 1 104
byte 1 114
byte 1 97
byte 1 112
byte 1 110
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $208
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 115
byte 1 104
byte 1 114
byte 1 101
byte 1 100
byte 1 100
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $206
byte 1 39
byte 1 115
byte 1 32
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $205
byte 1 97
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $203
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 103
byte 1 117
byte 1 110
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 100
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $201
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 109
byte 1 97
byte 1 99
byte 1 104
byte 1 105
byte 1 110
byte 1 101
byte 1 103
byte 1 117
byte 1 110
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $199
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 112
byte 1 117
byte 1 109
byte 1 109
byte 1 101
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $197
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 99
byte 1 97
byte 1 117
byte 1 103
byte 1 104
byte 1 116
byte 1 32
byte 1 98
byte 1 121
byte 1 0
align 1
LABELV $186
byte 1 110
byte 1 111
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $183
byte 1 89
byte 1 111
byte 1 117
byte 1 32
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 101
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $180
byte 1 89
byte 1 111
byte 1 117
byte 1 32
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 101
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 37
byte 1 115
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 99
byte 1 101
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $173
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $168
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 104
byte 1 105
byte 1 109
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 0
align 1
LABELV $167
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 105
byte 1 116
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 0
align 1
LABELV $164
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 104
byte 1 101
byte 1 114
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 0
align 1
LABELV $161
byte 1 100
byte 1 105
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 117
byte 1 99
byte 1 107
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 99
byte 1 104
byte 1 101
byte 1 115
byte 1 116
byte 1 32
byte 1 119
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 46
byte 1 0
align 1
LABELV $159
byte 1 115
byte 1 104
byte 1 111
byte 1 117
byte 1 108
byte 1 100
byte 1 32
byte 1 104
byte 1 97
byte 1 118
byte 1 101
byte 1 32
byte 1 117
byte 1 115
byte 1 101
byte 1 100
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 109
byte 1 97
byte 1 108
byte 1 108
byte 1 101
byte 1 114
byte 1 32
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $157
byte 1 109
byte 1 101
byte 1 108
byte 1 116
byte 1 101
byte 1 100
byte 1 32
byte 1 104
byte 1 105
byte 1 109
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 0
align 1
LABELV $156
byte 1 109
byte 1 101
byte 1 108
byte 1 116
byte 1 101
byte 1 100
byte 1 32
byte 1 105
byte 1 116
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 0
align 1
LABELV $153
byte 1 109
byte 1 101
byte 1 108
byte 1 116
byte 1 101
byte 1 100
byte 1 32
byte 1 104
byte 1 101
byte 1 114
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 0
align 1
LABELV $149
byte 1 98
byte 1 108
byte 1 101
byte 1 119
byte 1 32
byte 1 104
byte 1 105
byte 1 109
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 32
byte 1 117
byte 1 112
byte 1 0
align 1
LABELV $148
byte 1 98
byte 1 108
byte 1 101
byte 1 119
byte 1 32
byte 1 105
byte 1 116
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 32
byte 1 117
byte 1 112
byte 1 0
align 1
LABELV $145
byte 1 98
byte 1 108
byte 1 101
byte 1 119
byte 1 32
byte 1 104
byte 1 101
byte 1 114
byte 1 115
byte 1 101
byte 1 108
byte 1 102
byte 1 32
byte 1 117
byte 1 112
byte 1 0
align 1
LABELV $141
byte 1 116
byte 1 114
byte 1 105
byte 1 112
byte 1 112
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 104
byte 1 105
byte 1 115
byte 1 32
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $140
byte 1 116
byte 1 114
byte 1 105
byte 1 112
byte 1 112
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 105
byte 1 116
byte 1 115
byte 1 32
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $137
byte 1 116
byte 1 114
byte 1 105
byte 1 112
byte 1 112
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 110
byte 1 32
byte 1 104
byte 1 101
byte 1 114
byte 1 32
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 103
byte 1 114
byte 1 101
byte 1 110
byte 1 97
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $127
byte 1 100
byte 1 105
byte 1 101
byte 1 100
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 117
byte 1 99
byte 1 107
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 99
byte 1 104
byte 1 101
byte 1 115
byte 1 116
byte 1 32
byte 1 119
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $125
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 105
byte 1 110
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 119
byte 1 114
byte 1 111
byte 1 110
byte 1 103
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 99
byte 1 101
byte 1 0
align 1
LABELV $123
byte 1 115
byte 1 97
byte 1 119
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 108
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $121
byte 1 100
byte 1 111
byte 1 101
byte 1 115
byte 1 32
byte 1 97
byte 1 32
byte 1 98
byte 1 97
byte 1 99
byte 1 107
byte 1 32
byte 1 102
byte 1 108
byte 1 105
byte 1 112
byte 1 32
byte 1 105
byte 1 110
byte 1 116
byte 1 111
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 108
byte 1 97
byte 1 118
byte 1 97
byte 1 0
align 1
LABELV $119
byte 1 109
byte 1 101
byte 1 108
byte 1 116
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $117
byte 1 115
byte 1 97
byte 1 110
byte 1 107
byte 1 32
byte 1 108
byte 1 105
byte 1 107
byte 1 101
byte 1 32
byte 1 97
byte 1 32
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 0
align 1
LABELV $115
byte 1 119
byte 1 97
byte 1 115
byte 1 32
byte 1 115
byte 1 113
byte 1 117
byte 1 105
byte 1 115
byte 1 104
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $113
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $111
byte 1 115
byte 1 117
byte 1 105
byte 1 99
byte 1 105
byte 1 100
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $107
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $106
byte 1 110
byte 1 0
align 1
LABELV $99
byte 1 67
byte 1 71
byte 1 95
byte 1 79
byte 1 98
byte 1 105
byte 1 116
byte 1 117
byte 1 97
byte 1 114
byte 1 121
byte 1 58
byte 1 32
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 0
align 1
LABELV $94
byte 1 37
byte 1 115
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $93
byte 1 37
byte 1 105
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $92
byte 1 37
byte 1 105
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $89
byte 1 37
byte 1 105
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $86
byte 1 37
byte 1 105
byte 1 115
byte 1 116
byte 1 0
align 1
LABELV $83
byte 1 49
byte 1 51
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $80
byte 1 49
byte 1 50
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $77
byte 1 49
byte 1 49
byte 1 116
byte 1 104
byte 1 0
align 1
LABELV $74
byte 1 94
byte 1 51
byte 1 51
byte 1 114
byte 1 100
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $71
byte 1 94
byte 1 49
byte 1 50
byte 1 110
byte 1 100
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $68
byte 1 94
byte 1 52
byte 1 49
byte 1 115
byte 1 116
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $65
byte 1 0
align 1
LABELV $64
byte 1 84
byte 1 105
byte 1 101
byte 1 100
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 0
