export CG_BubbleTrail
code
proc CG_BubbleTrail 96 4
file "..\cg_effects.c"
line 16
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_effects.c -- these functions generate localentities, usually as a result
;4:// of event processing
;5:
;6:#include "cg_local.h"
;7:
;8:
;9:/*
;10:==================
;11:CG_BubbleTrail
;12:
;13:Bullets shot underwater
;14:==================
;15:*/
;16:void CG_BubbleTrail( vec3_t start, vec3_t end, float spacing ) {
line 22
;17:	vec3_t		move;
;18:	vec3_t		vec;
;19:	float		len;
;20:	int			i;
;21:
;22:	VectorCopy (start, move);
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 23
;23:	VectorSubtract (end, start, vec);
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 32
INDIRP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
CNSTI4 4
ASGNI4
ADDRLP4 12+4
ADDRLP4 32
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 44
CNSTI4 8
ASGNI4
ADDRLP4 12+8
ADDRFP4 4
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 24
;24:	len = VectorNormalize (vec);
ADDRLP4 12
ARGP4
ADDRLP4 48
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 28
ADDRLP4 48
INDIRF4
ASGNF4
line 27
;25:
;26:	// advance a random amount first
;27:	i = rand() % (int)spacing;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 52
INDIRI4
ADDRFP4 8
INDIRF4
CVFI4 4
MODI4
ASGNI4
line 28
;28:	VectorMA( move, i, vec, move );
ADDRLP4 56
ADDRLP4 24
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDRLP4 24
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 30
;29:
;30:	VectorScale (vec, spacing, vec);
ADDRLP4 60
ADDRFP4 8
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 60
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRLP4 60
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+8
ADDRLP4 12+8
INDIRF4
ADDRFP4 8
INDIRF4
MULF4
ASGNF4
line 32
;31:
;32:	for ( ; i < len; i += spacing ) {
ADDRGP4 $76
JUMPV
LABELV $73
line 36
;33:		localEntity_t	*le;
;34:		refEntity_t		*re;
;35:
;36:		le = CG_AllocLocalEntity();
ADDRLP4 72
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 64
ADDRLP4 72
INDIRP4
ASGNP4
line 37
;37:		le->leFlags = LEF_PUFF_DONT_SCALE;
ADDRLP4 64
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 1
ASGNI4
line 38
;38:		le->leType = LE_MOVE_SCALE_FADE;
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 4
ASGNI4
line 39
;39:		le->startTime = cg.time;
ADDRLP4 64
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 40
;40:		le->endTime = cg.time + 1000 + random() * 250;
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+105504
INDIRI4
CNSTI4 1000
ADDI4
CVIF4 4
CNSTF4 1132068864
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 41
;41:		le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 64
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1065353216
ADDRLP4 64
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 64
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 43
;42:
;43:		re = &le->refEntity;
ADDRLP4 68
ADDRLP4 64
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 44
;44:		re->shaderTime = cg.time / 1000.0f;
ADDRLP4 68
INDIRP4
CNSTI4 128
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 46
;45:
;46:		re->reType = RT_SPRITE;
ADDRLP4 68
INDIRP4
CNSTI4 2
ASGNI4
line 47
;47:		re->rotation = 0;
ADDRLP4 68
INDIRP4
CNSTI4 136
ADDP4
CNSTF4 0
ASGNF4
line 48
;48:		re->radius = 3;
ADDRLP4 68
INDIRP4
CNSTI4 132
ADDP4
CNSTF4 1077936128
ASGNF4
line 49
;49:		re->customShader = cgs.media.waterBubbleShader;
ADDRLP4 68
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+220
INDIRI4
ASGNI4
line 50
;50:		re->shaderRGBA[0] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 116
ADDP4
CNSTU1 255
ASGNU1
line 51
;51:		re->shaderRGBA[1] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 117
ADDP4
CNSTU1 255
ASGNU1
line 52
;52:		re->shaderRGBA[2] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 118
ADDP4
CNSTU1 255
ASGNU1
line 53
;53:		re->shaderRGBA[3] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 119
ADDP4
CNSTU1 255
ASGNU1
line 55
;54:		
;55:		le->color[3] = 1.0;
ADDRLP4 64
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1065353216
ASGNF4
line 57
;56:
;57:		le->pos.trType = TR_LINEAR;
ADDRLP4 64
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 2
ASGNI4
line 58
;58:		le->pos.trTime = cg.time;
ADDRLP4 64
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 59
;59:		VectorCopy( move, le->pos.trBase );
ADDRLP4 64
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 0
INDIRB
ASGNB 12
line 60
;60:		le->pos.trDelta[0] = crandom()*5;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 52
ADDP4
CNSTF4 1084227584
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 61
;61:		le->pos.trDelta[1] = crandom()*5;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1084227584
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 62
;62:		le->pos.trDelta[2] = crandom()*5 + 6;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 1084227584
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1086324736
ADDF4
ASGNF4
line 64
;63:
;64:		VectorAdd (move, vec, move);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDF4
ASGNF4
line 65
;65:	}
LABELV $74
line 32
ADDRLP4 24
ADDRLP4 24
INDIRI4
CVIF4 4
ADDRFP4 8
INDIRF4
ADDF4
CVFI4 4
ASGNI4
LABELV $76
ADDRLP4 24
INDIRI4
CVIF4 4
ADDRLP4 28
INDIRF4
LTF4 $73
line 66
;66:}
LABELV $60
endproc CG_BubbleTrail 96 4
data
align 4
LABELV $90
byte 4 146
export CG_SmokePuff
code
proc CG_SmokePuff 56 4
line 81
;67:
;68:/*
;69:=====================
;70:CG_SmokePuff
;71:
;72:Adds a smoke puff or blood trail localEntity.
;73:=====================
;74:*/
;75:localEntity_t *CG_SmokePuff( const vec3_t p, const vec3_t vel, 
;76:				   float radius,
;77:				   float r, float g, float b, float a,
;78:				   float duration,
;79:				   int startTime,
;80:				   int leFlags,
;81:				   qhandle_t hShader ) {
line 86
;82:	static int	seed = 0x92;
;83:	localEntity_t	*le;
;84:	refEntity_t		*re;
;85:
;86:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 87
;87:	le->leFlags = leFlags;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 36
INDIRI4
ASGNI4
line 88
;88:	le->radius = radius;
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
ADDRFP4 8
INDIRF4
ASGNF4
line 90
;89:
;90:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 91
;91:	re->rotation = Q_random( &seed ) * 360;
ADDRGP4 $90
ARGP4
ADDRLP4 12
ADDRGP4 Q_random
CALLF4
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 136
ADDP4
CNSTF4 1135869952
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
line 92
;92:	re->radius = radius;
ADDRLP4 4
INDIRP4
CNSTI4 132
ADDP4
ADDRFP4 8
INDIRF4
ASGNF4
line 93
;93:	re->shaderTime = startTime / 1000.0f;
ADDRLP4 4
INDIRP4
CNSTI4 128
ADDP4
ADDRFP4 32
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 95
;94:
;95:	le->leType = LE_MOVE_SCALE_FADE;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 4
ASGNI4
line 96
;96:	le->startTime = startTime;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 97
;97:	le->endTime = startTime + duration;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRFP4 32
INDIRI4
CVIF4 4
ADDRFP4 28
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 98
;98:	le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1065353216
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 99
;99:	le->color[0] = r;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRFP4 12
INDIRF4
ASGNF4
line 100
;100:	le->color[1] = g; 
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ADDRFP4 16
INDIRF4
ASGNF4
line 101
;101:	le->color[2] = b;
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRFP4 20
INDIRF4
ASGNF4
line 102
;102:	le->color[3] = a;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRFP4 24
INDIRF4
ASGNF4
line 105
;103:
;104:
;105:	le->pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 2
ASGNI4
line 106
;106:	le->pos.trTime = startTime;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 107
;107:	VectorCopy( vel, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 108
;108:	VectorCopy( p, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 110
;109:
;110:	VectorCopy( p, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 111
;111:	re->customShader = hShader;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
ADDRFP4 40
INDIRI4
ASGNI4
line 114
;112:
;113:	// rage pro can't alpha fade, so use a different shader
;114:	if ( cgs.glconfig.hardwareType == GLHW_RAGEPRO ) {
ADDRGP4 cgs+20100+4120
INDIRI4
CNSTI4 3
NEI4 $91
line 115
;115:		re->customShader = cgs.media.smokePuffRageProShader;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+208
INDIRI4
ASGNI4
line 116
;116:		re->shaderRGBA[0] = 0xff;
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTU1 255
ASGNU1
line 117
;117:		re->shaderRGBA[1] = 0xff;
ADDRLP4 4
INDIRP4
CNSTI4 117
ADDP4
CNSTU1 255
ASGNU1
line 118
;118:		re->shaderRGBA[2] = 0xff;
ADDRLP4 4
INDIRP4
CNSTI4 118
ADDP4
CNSTU1 255
ASGNU1
line 119
;119:		re->shaderRGBA[3] = 0xff;
ADDRLP4 4
INDIRP4
CNSTI4 119
ADDP4
CNSTU1 255
ASGNU1
line 120
;120:	} else {
ADDRGP4 $92
JUMPV
LABELV $91
line 121
;121:		re->shaderRGBA[0] = le->color[0] * 0xff;
ADDRLP4 24
CNSTF4 1132396544
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 28
CNSTF4 1325400064
ASGNF4
ADDRLP4 24
INDIRF4
ADDRLP4 28
INDIRF4
LTF4 $98
ADDRLP4 20
ADDRLP4 24
INDIRF4
ADDRLP4 28
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $99
JUMPV
LABELV $98
ADDRLP4 20
ADDRLP4 24
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $99
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 20
INDIRU4
CVUU1 4
ASGNU1
line 122
;122:		re->shaderRGBA[1] = le->color[1] * 0xff;
ADDRLP4 36
CNSTF4 1132396544
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 40
CNSTF4 1325400064
ASGNF4
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
LTF4 $101
ADDRLP4 32
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $102
JUMPV
LABELV $101
ADDRLP4 32
ADDRLP4 36
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $102
ADDRLP4 4
INDIRP4
CNSTI4 117
ADDP4
ADDRLP4 32
INDIRU4
CVUU1 4
ASGNU1
line 123
;123:		re->shaderRGBA[2] = le->color[2] * 0xff;
ADDRLP4 48
CNSTF4 1132396544
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 52
CNSTF4 1325400064
ASGNF4
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRF4
LTF4 $104
ADDRLP4 44
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $105
JUMPV
LABELV $104
ADDRLP4 44
ADDRLP4 48
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $105
ADDRLP4 4
INDIRP4
CNSTI4 118
ADDP4
ADDRLP4 44
INDIRU4
CVUU1 4
ASGNU1
line 124
;124:		re->shaderRGBA[3] = 0xff;
ADDRLP4 4
INDIRP4
CNSTI4 119
ADDP4
CNSTU1 255
ASGNU1
line 125
;125:	}
LABELV $92
line 127
;126:
;127:	re->reType = RT_SPRITE;
ADDRLP4 4
INDIRP4
CNSTI4 2
ASGNI4
line 128
;128:	re->radius = le->radius;
ADDRLP4 4
INDIRP4
CNSTI4 132
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
ASGNF4
line 130
;129:
;130:	return le;
ADDRLP4 0
INDIRP4
RETP4
LABELV $89
endproc CG_SmokePuff 56 4
export CG_SpawnEffect
proc CG_SpawnEffect 28 4
line 140
;131:}
;132:
;133:/*
;134:==================
;135:CG_SpawnEffect
;136:
;137:Player teleporting in or out
;138:==================
;139:*/
;140:void CG_SpawnEffect( vec3_t org ) {
line 144
;141:	localEntity_t	*le;
;142:	refEntity_t		*re;
;143:
;144:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 145
;145:	le->leFlags = 0;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 146
;146:	le->leType = LE_FADE_RGB;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 6
ASGNI4
line 147
;147:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 148
;148:	le->endTime = cg.time + 500;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+105504
INDIRI4
CNSTI4 500
ADDI4
ASGNI4
line 149
;149:	le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1065353216
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 151
;150:
;151:	le->color[0] = le->color[1] = le->color[2] = le->color[3] = 1.0;
ADDRLP4 20
CNSTF4 1065353216
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
line 153
;152:
;153:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 155
;154:
;155:	re->reType = RT_MODEL;
ADDRLP4 4
INDIRP4
CNSTI4 0
ASGNI4
line 156
;156:	re->shaderTime = cg.time / 1000.0f;
ADDRLP4 4
INDIRP4
CNSTI4 128
ADDP4
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 158
;157:
;158:	re->customShader = cgs.media.teleportEffectShader;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
ADDRGP4 cgs+170516+408
INDIRI4
ASGNI4
line 159
;159:	re->hModel = cgs.media.teleportEffectModel;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cgs+170516+404
INDIRI4
ASGNI4
line 160
;160:	AxisClear( re->axis );
ADDRLP4 4
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 162
;161:
;162:	VectorCopy( org, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 163
;163:	re->origin[2] -= 24;
ADDRLP4 24
ADDRLP4 4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1103101952
SUBF4
ASGNF4
line 164
;164:}
LABELV $106
endproc CG_SpawnEffect 28 4
export CG_MakeExplosion
proc CG_MakeExplosion 60 8
line 176
;165:
;166:
;167:
;168:
;169:/*
;170:====================
;171:CG_MakeExplosion
;172:====================
;173:*/
;174:localEntity_t *CG_MakeExplosion( vec3_t origin, vec3_t dir, 
;175:								qhandle_t hModel, qhandle_t shader,
;176:								int msec, qboolean isSprite ) {
line 182
;177:	float			ang;
;178:	localEntity_t	*ex;
;179:	int				offset;
;180:	vec3_t			tmpVec, newOrigin;
;181:
;182:	if ( msec <= 0 ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
GTI4 $115
line 183
;183:		CG_Error( "CG_MakeExplosion: msec = %i", msec );
ADDRGP4 $117
ARGP4
ADDRFP4 16
INDIRI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 184
;184:	}
LABELV $115
line 187
;185:
;186:	// skew the time a bit so they aren't all in sync
;187:	offset = rand() & 63;
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28
ADDRLP4 36
INDIRI4
CNSTI4 63
BANDI4
ASGNI4
line 189
;188:
;189:	ex = CG_AllocLocalEntity();
ADDRLP4 40
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 40
INDIRP4
ASGNP4
line 190
;190:	if ( isSprite ) {
ADDRFP4 20
INDIRI4
CNSTI4 0
EQI4 $118
line 191
;191:		ex->leType = LE_SPRITE_EXPLOSION;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 2
ASGNI4
line 194
;192:
;193:		// randomly rotate sprite orientation
;194:		ex->refEntity.rotation = rand() % 360;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 284
ADDP4
ADDRLP4 44
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 195
;195:		VectorScale( dir, 16, tmpVec );
ADDRLP4 48
CNSTF4 1098907648
ASGNF4
ADDRLP4 52
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 16+8
CNSTF4 1098907648
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 196
;196:		VectorAdd( tmpVec, origin, newOrigin );
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 16
INDIRF4
ADDRLP4 56
INDIRP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 16+4
INDIRF4
ADDRLP4 56
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 16+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDF4
ASGNF4
line 197
;197:	} else {
ADDRGP4 $119
JUMPV
LABELV $118
line 198
;198:		ex->leType = LE_EXPLOSION;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 199
;199:		VectorCopy( origin, newOrigin );
ADDRLP4 4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 202
;200:
;201:		// set axis with random rotate
;202:		if ( !dir ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $126
line 203
;203:			AxisClear( ex->refEntity.axis );
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 204
;204:		} else {
ADDRGP4 $127
JUMPV
LABELV $126
line 205
;205:			ang = rand() % 360;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 44
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 206
;206:			VectorCopy( dir, ex->refEntity.axis[0] );
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 207
;207:			RotateAroundDirection( ex->refEntity.axis, ang );
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRLP4 32
INDIRF4
ARGF4
ADDRGP4 RotateAroundDirection
CALLV
pop
line 208
;208:		}
LABELV $127
line 209
;209:	}
LABELV $119
line 210
;210:	ex->startTime = cg.time - offset;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ADDRLP4 28
INDIRI4
SUBI4
ASGNI4
line 211
;211:	ex->endTime = ex->startTime + msec;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ADDRFP4 16
INDIRI4
ADDI4
ASGNI4
line 214
;212:
;213:	// bias the time so all shader effects start correctly
;214:	ex->refEntity.shaderTime = ex->startTime / 1000.0f;
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 216
;215:
;216:	ex->refEntity.hModel = hModel;
ADDRLP4 0
INDIRP4
CNSTI4 156
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 217
;217:	ex->refEntity.customShader = shader;
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ADDRFP4 12
INDIRI4
ASGNI4
line 220
;218:
;219:	// set origin
;220:	VectorCopy( newOrigin, ex->refEntity.origin );
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 221
;221:	VectorCopy( newOrigin, ex->refEntity.oldorigin );
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 222
;222:	VectorCopy( newOrigin, ex->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 224
;223:
;224:	ex->color[0] = ex->color[1] = ex->color[2] = 1.0;
ADDRLP4 56
CNSTF4 1065353216
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
line 226
;225:
;226:	return ex;
ADDRLP4 0
INDIRP4
RETP4
LABELV $114
endproc CG_MakeExplosion 60 8
export CG_Bleed
proc CG_Bleed 20 0
line 237
;227:}
;228:
;229:
;230:/*
;231:=================
;232:CG_Bleed
;233:
;234:This is the spurt of blood when a character gets hit
;235:=================
;236:*/
;237:void CG_Bleed( vec3_t origin, int entityNum ) {
line 240
;238:	localEntity_t	*ex;
;239:
;240:	if ( !cg_blood.integer ) {
ADDRGP4 cg_blood+12
INDIRI4
CNSTI4 0
NEI4 $130
line 241
;241:		return;
ADDRGP4 $129
JUMPV
LABELV $130
line 244
;242:	}
;243:
;244:	ex = CG_AllocLocalEntity();
ADDRLP4 4
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 245
;245:	ex->leType = LE_EXPLOSION;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 247
;246:
;247:	ex->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 248
;248:	ex->endTime = ex->startTime + 500;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 500
ADDI4
ASGNI4
line 250
;249:	
;250:	VectorCopy ( origin, ex->refEntity.origin);
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 251
;251:	ex->refEntity.reType = RT_SPRITE;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 252
;252:	ex->refEntity.rotation = rand() % 360;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 284
ADDP4
ADDRLP4 12
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 253
;253:	ex->refEntity.radius = 16;
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
CNSTF4 1098907648
ASGNF4
line 255
;254:
;255:	ex->refEntity.customShader = cgs.media.bloodExplosionShader;
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ADDRGP4 cgs+170516+400
INDIRI4
ASGNI4
line 258
;256:
;257:	// don't show player's own blood in view
;258:	if ( entityNum == cg.snap->ps.clientNum ) {
ADDRFP4 4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $136
line 259
;259:		ex->refEntity.renderfx |= RF_THIRD_PERSON;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 260
;260:	}
LABELV $136
line 261
;261:}
LABELV $129
endproc CG_Bleed 20 0
export CG_RBleed
proc CG_RBleed 28 0
line 270
;262:
;263:/*
;264:=================
;265:CG_Bleed
;266:
;267:This is the spurt of blood when a character gets hit
;268:=================
;269:*/
;270:void CG_RBleed( vec3_t origin, int entityNum ) {
line 273
;271:	localEntity_t	*ex;
;272:
;273:	if ( !cg_blood.integer ) {
ADDRGP4 cg_blood+12
INDIRI4
CNSTI4 0
NEI4 $140
line 274
;274:		return;
ADDRGP4 $139
JUMPV
LABELV $140
line 277
;275:	}
;276:
;277:	ex = CG_AllocLocalEntity();
ADDRLP4 4
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 278
;278:	ex->leType = LE_EXPLOSION;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 280
;279:
;280:	ex->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 281
;281:	ex->endTime = ex->startTime + 500;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 500
ADDI4
ASGNI4
line 283
;282:	
;283:	VectorCopy ( origin, ex->refEntity.origin);
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 284
;284:	ex->refEntity.reType = RT_SPRITE;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 285
;285:	ex->refEntity.rotation = rand() % 360;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 284
ADDP4
ADDRLP4 12
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 286
;286:	ex->refEntity.radius = 4 + rand() % 4;
ADDRLP4 16
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 20
CNSTI4 4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
MODI4
ADDRLP4 20
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 288
;287:
;288:	ex->refEntity.customShader = cgs.media.bulletExplosionShader;
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ADDRGP4 cgs+170516+384
INDIRI4
ASGNI4
line 291
;289:
;290:	// don't show player's own blood in view
;291:	if ( entityNum == cg.snap->ps.clientNum ) {
ADDRFP4 4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $146
line 292
;292:		ex->refEntity.renderfx |= RF_THIRD_PERSON;
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 293
;293:	}
LABELV $146
line 294
;294:}
LABELV $139
endproc CG_RBleed 28 0
export CG_Bleed2
proc CG_Bleed2 32 0
line 303
;295:
;296:/*
;297:=================
;298:CG_Bleed
;299:
;300:This is the spurt of blood when a character gets hit
;301:=================
;302:*/
;303:void CG_Bleed2( vec3_t origin, int entityNum ) {
line 306
;304:	localEntity_t	*ex;
;305:
;306:	if ( !cg_blood.integer ) {
ADDRGP4 cg_blood+12
INDIRI4
CNSTI4 0
NEI4 $150
line 307
;307:		return;
ADDRGP4 $149
JUMPV
LABELV $150
line 310
;308:	}
;309:
;310:	ex = CG_AllocLocalEntity();
ADDRLP4 4
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 311
;311:	ex->leType = LE_FALLFAST;//LE_EXPLOSION;
ADDRLP4 8
CNSTI4 8
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 313
;312:
;313:	ex->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 314
;314:	ex->endTime = ex->startTime + 500 + rand() % 500;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 500
ADDI4
ADDRLP4 12
INDIRI4
CNSTI4 500
MODI4
ADDI4
ASGNI4
line 316
;315:	
;316:	VectorCopy ( origin, ex->refEntity.origin);
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 317
;317:	ex->refEntity.reType = RT_SPRITE;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 318
;318:	ex->refEntity.rotation = rand() % 360;
ADDRLP4 20
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 284
ADDP4
ADDRLP4 20
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 319
;319:	ex->refEntity.radius = (rand() % 16) + 1;
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
ADDRLP4 24
INDIRI4
CNSTI4 16
MODI4
CNSTI4 1
ADDI4
CVIF4 4
ASGNF4
line 320
;320:	ex->refEntity.customShader = cgs.media.bloodExplosionShader;
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ADDRGP4 cgs+170516+400
INDIRI4
ASGNI4
line 323
;321:
;322:	// don't show player's own blood in view
;323:	if ( entityNum == cg.snap->ps.clientNum ) {
ADDRFP4 4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $156
line 324
;324:		ex->refEntity.renderfx |= RF_THIRD_PERSON;
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 325
;325:	}
LABELV $156
line 326
;326:	ex->pos.trDelta[2] = 64;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 1115684864
ASGNF4
line 327
;327:}
LABELV $149
endproc CG_Bleed2 32 0
export CG_LaunchGib
proc CG_LaunchGib 20 8
line 336
;328:
;329:
;330:
;331:/*
;332:==================
;333:CG_LaunchGib
;334:==================
;335:*/
;336:void CG_LaunchGib( vec3_t origin, vec3_t velocity, qhandle_t hModel ) {
line 340
;337:	localEntity_t	*le;
;338:	refEntity_t		*re;
;339:
;340:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 341
;341:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 343
;342:
;343:	le->leType = LE_FRAGMENT;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 3
ASGNI4
line 344
;344:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 345
;345:	le->endTime = le->startTime + 5000 + random() * 3000;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 5000
ADDI4
CVIF4 4
CNSTF4 1161527296
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 347
;346:
;347:	VectorCopy( origin, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 348
;348:	AxisCopy( axisDefault, re->axis );
ADDRGP4 axisDefault
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisCopy
CALLV
pop
line 349
;349:	re->hModel = hModel;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 351
;350:
;351:	le->pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 5
ASGNI4
line 352
;352:	VectorCopy( origin, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 353
;353:	VectorCopy( velocity, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 354
;354:	le->pos.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 356
;355:
;356:	le->bounceFactor = 0.3;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTF4 1050253722
ASGNF4
line 358
;357:
;358:	le->leBounceSoundType = LEBS_BLOOD;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 1
ASGNI4
line 359
;359:	le->leMarkType = LEMT_BLOOD;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
CNSTI4 1
ASGNI4
line 360
;360:}
LABELV $159
endproc CG_LaunchGib 20 8
export CG_GibPlayer
proc CG_GibPlayer 136 12
line 371
;361:
;362:/*
;363:===================
;364:CG_GibPlayer
;365:
;366:Generated a bunch of gibs launching out from the bodies location
;367:===================
;368:*/
;369:#define	GIB_VELOCITY	250
;370:#define	GIB_JUMP		250
;371:void CG_GibPlayer( vec3_t playerOrigin ) {
line 374
;372:	vec3_t	origin, velocity;
;373:
;374:	if ( !cg_blood.integer ) {
ADDRGP4 cg_blood+12
INDIRI4
CNSTI4 0
NEI4 $163
line 375
;375:		return;
ADDRGP4 $162
JUMPV
LABELV $163
line 378
;376:	}
;377:
;378:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 379
;379:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 380
;380:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 28
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 381
;381:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 382
;382:	if ( rand() & 1 ) {
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $168
line 383
;383:		CG_LaunchGib( origin, velocity, cgs.media.gibSkull );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+100
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 384
;384:	} else {
ADDRGP4 $169
JUMPV
LABELV $168
line 385
;385:		CG_LaunchGib( origin, velocity, cgs.media.gibBrain );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+104
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 386
;386:	}
LABELV $169
line 389
;387:
;388:	// allow gibs to be turned off for speed
;389:	if ( !cg_gibs.integer ) {
ADDRGP4 cg_gibs+12
INDIRI4
CNSTI4 0
NEI4 $174
line 390
;390:		return;
ADDRGP4 $162
JUMPV
LABELV $174
line 393
;391:	}
;392:
;393:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 394
;394:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 40
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 395
;395:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 396
;396:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 397
;397:	CG_LaunchGib( origin, velocity, cgs.media.gibAbdomen );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+68
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 399
;398:
;399:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 400
;400:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 401
;401:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 56
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 56
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 402
;402:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 403
;403:	CG_LaunchGib( origin, velocity, cgs.media.gibArm );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+72
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 405
;404:
;405:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 406
;406:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 407
;407:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 408
;408:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 72
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 72
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 409
;409:	CG_LaunchGib( origin, velocity, cgs.media.gibChest );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+76
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 411
;410:
;411:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 412
;412:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 413
;413:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 414
;414:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 415
;415:	CG_LaunchGib( origin, velocity, cgs.media.gibFist );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+80
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 417
;416:
;417:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 418
;418:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 419
;419:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 420
;420:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 96
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 96
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 421
;421:	CG_LaunchGib( origin, velocity, cgs.media.gibFoot );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+84
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 423
;422:
;423:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 424
;424:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 425
;425:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 426
;426:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 427
;427:	CG_LaunchGib( origin, velocity, cgs.media.gibForearm );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+88
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 429
;428:
;429:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 430
;430:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 112
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 112
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 431
;431:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 116
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 432
;432:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 120
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 120
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 433
;433:	CG_LaunchGib( origin, velocity, cgs.media.gibIntestine );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+92
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 435
;434:
;435:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 436
;436:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 124
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 124
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 437
;437:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 128
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 128
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 438
;438:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 132
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 132
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 439
;439:	CG_LaunchGib( origin, velocity, cgs.media.gibLeg );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+96
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGib
CALLV
pop
line 441
;440:
;441:}
LABELV $162
endproc CG_GibPlayer 136 12
export CG_LaunchGibNoBlood
proc CG_LaunchGibNoBlood 20 8
line 448
;442:
;443:/*
;444:==================
;445:CG_LaunchGib
;446:==================
;447:*/
;448:void CG_LaunchGibNoBlood( vec3_t origin, vec3_t velocity, qhandle_t hModel ) {
line 452
;449:	localEntity_t	*le;
;450:	refEntity_t		*re;
;451:
;452:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 453
;453:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ASGNP4
line 455
;454:
;455:	le->leType = LE_FRAGMENT;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 3
ASGNI4
line 456
;456:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 457
;457:	le->endTime = le->startTime + 5000 + random() * 3000;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 5000
ADDI4
CVIF4 4
CNSTF4 1161527296
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 459
;458:
;459:	VectorCopy( origin, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 460
;460:	AxisCopy( axisDefault, re->axis );
ADDRGP4 axisDefault
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 28
ADDP4
ARGP4
ADDRGP4 AxisCopy
CALLV
pop
line 461
;461:	re->hModel = hModel;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 463
;462:
;463:	le->pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTI4 5
ASGNI4
line 464
;464:	VectorCopy( origin, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 465
;465:	VectorCopy( velocity, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 466
;466:	le->pos.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 468
;467:
;468:	le->bounceFactor = 0.3;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTF4 1050253722
ASGNF4
line 470
;469:
;470:	le->leBounceSoundType = 0;//LEBS_BLOOD;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 0
ASGNI4
line 471
;471:	le->leMarkType = 0;//LEMT_BLOOD;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
CNSTI4 0
ASGNI4
line 472
;472:}
LABELV $209
endproc CG_LaunchGibNoBlood 20 8
export CG_GibNoBlood
proc CG_GibNoBlood 136 12
line 483
;473:
;474:/*
;475:===================
;476:CG_GibPlayer
;477:
;478:Generated a bunch of gibs launching out from the bodies location
;479:===================
;480:*/
;481:#define	GIB_VELOCITY	250
;482:#define	GIB_JUMP		250
;483:void CG_GibNoBlood( vec3_t playerOrigin ) {
line 486
;484:	vec3_t	origin, velocity;
;485:
;486:	if ( !cg_blood.integer ) {
ADDRGP4 cg_blood+12
INDIRI4
CNSTI4 0
NEI4 $213
line 487
;487:		return;
ADDRGP4 $212
JUMPV
LABELV $213
line 490
;488:	}
;489:
;490:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 491
;491:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 492
;492:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 28
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 493
;493:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 494
;494:	if ( rand() & 1 ) {
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $218
line 495
;495:		CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibSkull );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+100
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 496
;496:	} else {
ADDRGP4 $219
JUMPV
LABELV $218
line 497
;497:		CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibBrain );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+104
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 498
;498:	}
LABELV $219
line 501
;499:
;500:	// allow gibs to be turned off for speed
;501:	if ( !cg_gibs.integer ) {
ADDRGP4 cg_gibs+12
INDIRI4
CNSTI4 0
NEI4 $224
line 502
;502:		return;
ADDRGP4 $212
JUMPV
LABELV $224
line 505
;503:	}
;504:
;505:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 506
;506:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 40
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 507
;507:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 508
;508:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 509
;509:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibAbdomen );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+68
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 511
;510:
;511:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 512
;512:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 513
;513:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 56
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 56
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 514
;514:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 515
;515:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibArm );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+72
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 517
;516:
;517:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 518
;518:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 519
;519:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 520
;520:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 72
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 72
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 521
;521:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibChest );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+76
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 523
;522:
;523:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 524
;524:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 525
;525:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 526
;526:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 527
;527:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibFist );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+80
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 529
;528:
;529:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 530
;530:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 531
;531:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 532
;532:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 96
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 96
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 533
;533:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibFoot );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+84
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 535
;534:
;535:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 536
;536:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 537
;537:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 538
;538:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 539
;539:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibForearm );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+88
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 541
;540:
;541:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 542
;542:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 112
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 112
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 543
;543:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 116
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 544
;544:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 120
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 120
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 545
;545:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibIntestine );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+92
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 547
;546:
;547:	VectorCopy( playerOrigin, origin );
ADDRLP4 12
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 548
;548:	velocity[0] = crandom()*GIB_VELOCITY;
ADDRLP4 124
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 124
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 549
;549:	velocity[1] = crandom()*GIB_VELOCITY;
ADDRLP4 128
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 128
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 550
;550:	velocity[2] = GIB_JUMP + crandom()*GIB_VELOCITY;
ADDRLP4 132
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
CNSTF4 1132068864
CNSTF4 1073741824
ADDRLP4 132
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1132068864
ADDF4
ASGNF4
line 551
;551:	CG_LaunchGibNoBlood( origin, velocity, cgs.media.gibLeg );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 cgs+170516+96
INDIRI4
ARGI4
ADDRGP4 CG_LaunchGibNoBlood
CALLV
pop
line 553
;552:
;553:}
LABELV $212
endproc CG_GibNoBlood 136 12
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $117
byte 1 67
byte 1 71
byte 1 95
byte 1 77
byte 1 97
byte 1 107
byte 1 101
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 58
byte 1 32
byte 1 109
byte 1 115
byte 1 101
byte 1 99
byte 1 32
byte 1 61
byte 1 32
byte 1 37
byte 1 105
byte 1 0
