export CG_AdjustFrom640
code
proc CG_AdjustFrom640 16 0
file "..\cg_drawtools.c"
line 13
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_drawtools.c -- helper functions called by cg_draw, cg_scoreboard, cg_info, etc
;4:#include "cg_local.h"
;5:
;6:/*
;7:================
;8:CG_AdjustFrom640
;9:
;10:Adjusted for resolution and screen aspect ratio
;11:================
;12:*/
;13:void CG_AdjustFrom640( float *x, float *y, float *w, float *h ) {
line 21
;14:#if 0
;15:	// adjust for wide screens
;16:	if ( cgs.glconfig.vidWidth * 480 > cgs.glconfig.vidHeight * 640 ) {
;17:		*x += 0.5 * ( cgs.glconfig.vidWidth - ( cgs.glconfig.vidHeight * 640 / 480 ) );
;18:	}
;19:#endif
;20:	// scale for screen sizes
;21:	*x *= cgs.screenXScale;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ASGNF4
line 22
;22:	*y *= cgs.screenYScale;
ADDRLP4 4
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cgs+24268
INDIRF4
MULF4
ASGNF4
line 23
;23:	*w *= cgs.screenXScale;
ADDRLP4 8
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ASGNF4
line 24
;24:	*h *= cgs.screenYScale;
ADDRLP4 12
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRGP4 cgs+24268
INDIRF4
MULF4
ASGNF4
line 25
;25:}
LABELV $60
endproc CG_AdjustFrom640 16 0
export CG_FillRect
proc CG_FillRect 4 36
line 34
;26:
;27:/*
;28:================
;29:CG_FillRect
;30:
;31:Coordinates are 640*480 virtual values
;32:=================
;33:*/
;34:void CG_FillRect( float x, float y, float width, float height, const float *color ) {
line 35
;35:	trap_R_SetColor( color );
ADDRFP4 16
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 37
;36:
;37:	CG_AdjustFrom640( &x, &y, &width, &height );
ADDRFP4 0
ARGP4
ADDRFP4 4
ARGP4
ADDRFP4 8
ARGP4
ADDRFP4 12
ARGP4
ADDRGP4 CG_AdjustFrom640
CALLV
pop
line 38
;38:	trap_R_DrawStretchPic( x, y, width, height, 0, 0, 0, 0, cgs.media.whiteShader );
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 0
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRGP4 cgs+170516+16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 40
;39:
;40:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 41
;41:}
LABELV $65
endproc CG_FillRect 4 36
export CG_DrawPic
proc CG_DrawPic 8 36
line 52
;42:
;43:
;44:
;45:/*
;46:================
;47:CG_DrawPic
;48:
;49:Coordinates are 640*480 virtual values
;50:=================
;51:*/
;52:void CG_DrawPic( float x, float y, float width, float height, qhandle_t hShader ) {
line 53
;53:	CG_AdjustFrom640( &x, &y, &width, &height );
ADDRFP4 0
ARGP4
ADDRFP4 4
ARGP4
ADDRFP4 8
ARGP4
ADDRFP4 12
ARGP4
ADDRGP4 CG_AdjustFrom640
CALLV
pop
line 54
;54:	trap_R_DrawStretchPic( x, y, width, height, 0, 0, 1, 1, hShader );
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 0
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
CNSTF4 1065353216
ASGNF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRFP4 16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 55
;55:}
LABELV $68
endproc CG_DrawPic 8 36
export CG_DrawChar
proc CG_DrawChar 48 36
line 66
;56:
;57:
;58:
;59:/*
;60:===============
;61:CG_DrawChar
;62:
;63:Coordinates and size in 640*480 virtual screen size
;64:===============
;65:*/
;66:void CG_DrawChar( int x, int y, int width, int height, int ch ) {
line 72
;67:	int row, col;
;68:	float frow, fcol;
;69:	float size;
;70:	float	ax, ay, aw, ah;
;71:
;72:	ch &= 255;
ADDRFP4 16
ADDRFP4 16
INDIRI4
CNSTI4 255
BANDI4
ASGNI4
line 74
;73:
;74:	if ( ch == ' ' ) {
ADDRFP4 16
INDIRI4
CNSTI4 32
NEI4 $70
line 75
;75:		return;
ADDRGP4 $69
JUMPV
LABELV $70
line 78
;76:	}
;77:
;78:	ax = x;
ADDRLP4 12
ADDRFP4 0
INDIRI4
CVIF4 4
ASGNF4
line 79
;79:	ay = y;
ADDRLP4 16
ADDRFP4 4
INDIRI4
CVIF4 4
ASGNF4
line 80
;80:	aw = width;
ADDRLP4 20
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 81
;81:	ah = height;
ADDRLP4 24
ADDRFP4 12
INDIRI4
CVIF4 4
ASGNF4
line 82
;82:	CG_AdjustFrom640( &ax, &ay, &aw, &ah );
ADDRLP4 12
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 CG_AdjustFrom640
CALLV
pop
line 84
;83:
;84:	row = ch>>4;
ADDRLP4 28
ADDRFP4 16
INDIRI4
CNSTI4 4
RSHI4
ASGNI4
line 85
;85:	col = ch&15;
ADDRLP4 32
ADDRFP4 16
INDIRI4
CNSTI4 15
BANDI4
ASGNI4
line 87
;86:
;87:	frow = row*0.0625;
ADDRLP4 0
CNSTF4 1031798784
ADDRLP4 28
INDIRI4
CVIF4 4
MULF4
ASGNF4
line 88
;88:	fcol = col*0.0625;
ADDRLP4 4
CNSTF4 1031798784
ADDRLP4 32
INDIRI4
CVIF4 4
MULF4
ASGNF4
line 89
;89:	size = 0.0625;
ADDRLP4 8
CNSTF4 1031798784
ASGNF4
line 91
;90:
;91:	trap_R_DrawStretchPic( ax, ay, aw, ah,
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 20
INDIRF4
ARGF4
ADDRLP4 24
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
ADDF4
ARGF4
ADDRLP4 0
INDIRF4
ADDRLP4 8
INDIRF4
ADDF4
ARGF4
ADDRGP4 cgs+170516
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 95
;92:					   fcol, frow, 
;93:					   fcol + size, frow + size, 
;94:					   cgs.media.charsetShader );
;95:}
LABELV $69
endproc CG_DrawChar 48 36
export CG_DrawStringExt
proc CG_DrawStringExt 48 20
line 109
;96:
;97:
;98:/*
;99:==================
;100:CG_DrawStringExt
;101:
;102:Draws a multi-colored string with a drop shadow, optionally forcing
;103:to a fixed color.
;104:
;105:Coordinates are at 640 by 480 virtual resolution
;106:==================
;107:*/
;108:void CG_DrawStringExt( int x, int y, const char *string, const float *setColor, 
;109:		qboolean forceColor, qboolean shadow, int charWidth, int charHeight, int maxChars ) {
line 115
;110:	vec4_t		color;
;111:	const char	*s;
;112:	int			xx;
;113:	int			cnt;
;114:
;115:	if (maxChars <= 0)
ADDRFP4 32
INDIRI4
CNSTI4 0
GTI4 $74
line 116
;116:		maxChars = 32767; // do them all!
ADDRFP4 32
CNSTI4 32767
ASGNI4
LABELV $74
line 119
;117:
;118:	// draw the drop shadow
;119:	if (shadow) {
ADDRFP4 20
INDIRI4
CNSTI4 0
EQI4 $76
line 120
;120:		color[0] = color[1] = color[2] = 0;
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 12+8
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 28
INDIRF4
ASGNF4
line 121
;121:		color[3] = setColor[3];
ADDRLP4 12+12
ADDRFP4 12
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ASGNF4
line 122
;122:		trap_R_SetColor( color );
ADDRLP4 12
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 123
;123:		s = string;
ADDRLP4 0
ADDRFP4 8
INDIRP4
ASGNP4
line 124
;124:		xx = x;
ADDRLP4 4
ADDRFP4 0
INDIRI4
ASGNI4
line 125
;125:		cnt = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $82
JUMPV
LABELV $81
line 126
;126:		while ( *s && cnt < maxChars) {
line 127
;127:			if ( Q_IsColorString( s ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $84
ADDRLP4 36
CNSTI4 94
ASGNI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 36
INDIRI4
NEI4 $84
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
EQI4 $84
ADDRLP4 40
INDIRI4
ADDRLP4 36
INDIRI4
EQI4 $84
line 128
;128:				s += 2;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 2
ADDP4
ASGNP4
line 129
;129:				continue;
ADDRGP4 $82
JUMPV
LABELV $84
line 131
;130:			}
;131:			CG_DrawChar( xx + 2, y + 2, charWidth, charHeight, *s );
ADDRLP4 44
CNSTI4 2
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 44
INDIRI4
ADDI4
ARGI4
ADDRFP4 4
INDIRI4
ADDRLP4 44
INDIRI4
ADDI4
ARGI4
ADDRFP4 24
INDIRI4
ARGI4
ADDRFP4 28
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ARGI4
ADDRGP4 CG_DrawChar
CALLV
pop
line 132
;132:			cnt++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 133
;133:			xx += charWidth;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRFP4 24
INDIRI4
ADDI4
ASGNI4
line 134
;134:			s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 135
;135:		}
LABELV $82
line 126
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $86
ADDRLP4 8
INDIRI4
ADDRFP4 32
INDIRI4
LTI4 $81
LABELV $86
line 136
;136:	}
LABELV $76
line 139
;137:
;138:	// draw the colored text
;139:	s = string;
ADDRLP4 0
ADDRFP4 8
INDIRP4
ASGNP4
line 140
;140:	xx = x;
ADDRLP4 4
ADDRFP4 0
INDIRI4
ASGNI4
line 141
;141:	cnt = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 142
;142:	trap_R_SetColor( setColor );
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
ADDRGP4 $88
JUMPV
LABELV $87
line 143
;143:	while ( *s && cnt < maxChars) {
line 144
;144:		if ( Q_IsColorString( s ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $90
ADDRLP4 32
CNSTI4 94
ASGNI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 32
INDIRI4
NEI4 $90
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
EQI4 $90
ADDRLP4 36
INDIRI4
ADDRLP4 32
INDIRI4
EQI4 $90
line 145
;145:			if ( !forceColor ) {
ADDRFP4 16
INDIRI4
CNSTI4 0
NEI4 $92
line 146
;146:				memcpy( color, g_color_table[ColorIndex(*(s+1))], sizeof( color ) );
ADDRLP4 12
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
CNSTI4 7
BANDI4
CNSTI4 4
LSHI4
ADDRGP4 g_color_table
ADDP4
ARGP4
CNSTU4 16
ARGU4
ADDRGP4 memcpy
CALLP4
pop
line 147
;147:				color[3] = setColor[3];
ADDRLP4 12+12
ADDRFP4 12
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ASGNF4
line 148
;148:				trap_R_SetColor( color );
ADDRLP4 12
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 149
;149:			}
LABELV $92
line 150
;150:			s += 2;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 2
ADDP4
ASGNP4
line 151
;151:			continue;
ADDRGP4 $88
JUMPV
LABELV $90
line 153
;152:		}
;153:		CG_DrawChar( xx, y, charWidth, charHeight, *s );
ADDRLP4 4
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 24
INDIRI4
ARGI4
ADDRFP4 28
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ARGI4
ADDRGP4 CG_DrawChar
CALLV
pop
line 154
;154:		xx += charWidth;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRFP4 24
INDIRI4
ADDI4
ASGNI4
line 155
;155:		cnt++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 156
;156:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 157
;157:	}
LABELV $88
line 143
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $95
ADDRLP4 8
INDIRI4
ADDRFP4 32
INDIRI4
LTI4 $87
LABELV $95
line 158
;158:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 159
;159:}
LABELV $73
endproc CG_DrawStringExt 48 20
export CG_DrawBigString
proc CG_DrawBigString 28 36
line 161
;160:
;161:void CG_DrawBigString( int x, int y, const char *s, float alpha ) {
line 164
;162:	float	color[4];
;163:
;164:	color[0] = color[1] = color[2] = 1.0;
ADDRLP4 16
CNSTF4 1065353216
ASGNF4
ADDRLP4 0+8
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 165
;165:	color[3] = alpha;
ADDRLP4 0+12
ADDRFP4 12
INDIRF4
ASGNF4
line 166
;166:	CG_DrawStringExt( x, y, s, color, qfalse, qtrue, BIGCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 20
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 24
CNSTI4 16
ASGNI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 167
;167:}
LABELV $96
endproc CG_DrawBigString 28 36
export CG_DrawBigStringColor
proc CG_DrawBigStringColor 8 36
line 169
;168:
;169:void CG_DrawBigStringColor( int x, int y, const char *s, vec4_t color ) {
line 170
;170:	CG_DrawStringExt( x, y, s, color, qtrue, qtrue, BIGCHAR_WIDTH, BIGCHAR_HEIGHT, 0 );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 0
CNSTI4 1
ASGNI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
CNSTI4 16
ASGNI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 171
;171:}
LABELV $100
endproc CG_DrawBigStringColor 8 36
export CG_DrawSmallString
proc CG_DrawSmallString 24 36
line 173
;172:
;173:void CG_DrawSmallString( int x, int y, const char *s, float alpha ) {
line 176
;174:	float	color[4];
;175:
;176:	color[0] = color[1] = color[2] = 1.0;
ADDRLP4 16
CNSTF4 1065353216
ASGNF4
ADDRLP4 0+8
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 177
;177:	color[3] = alpha;
ADDRLP4 0+12
ADDRFP4 12
INDIRF4
ASGNF4
line 178
;178:	CG_DrawStringExt( x, y, s, color, qfalse, qfalse, SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, 0 );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRLP4 20
INDIRI4
ARGI4
CNSTI4 8
ARGI4
CNSTI4 16
ARGI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 179
;179:}
LABELV $101
endproc CG_DrawSmallString 24 36
export CG_DrawSmallStringColor
proc CG_DrawSmallStringColor 4 36
line 181
;180:
;181:void CG_DrawSmallStringColor( int x, int y, const char *s, vec4_t color ) {
line 182
;182:	CG_DrawStringExt( x, y, s, color, qtrue, qfalse, SMALLCHAR_WIDTH, SMALLCHAR_HEIGHT, 0 );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRI4
ARGI4
CNSTI4 8
ARGI4
CNSTI4 16
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 183
;183:}
LABELV $105
endproc CG_DrawSmallStringColor 4 36
export CG_DrawStrlen
proc CG_DrawStrlen 20 0
line 192
;184:
;185:/*
;186:=================
;187:CG_DrawStrlen
;188:
;189:Returns character count, skiping color escape codes
;190:=================
;191:*/
;192:int CG_DrawStrlen( const char *str ) {
line 193
;193:	const char *s = str;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
line 194
;194:	int count = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $108
JUMPV
LABELV $107
line 196
;195:
;196:	while ( *s ) {
line 197
;197:		if ( Q_IsColorString( s ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $110
ADDRLP4 12
CNSTI4 94
ASGNI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 12
INDIRI4
NEI4 $110
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $110
ADDRLP4 16
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $110
line 198
;198:			s += 2;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 2
ADDP4
ASGNP4
line 199
;199:		} else {
ADDRGP4 $111
JUMPV
LABELV $110
line 200
;200:			count++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 201
;201:			s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 202
;202:		}
LABELV $111
line 203
;203:	}
LABELV $108
line 196
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $107
line 205
;204:
;205:	return count;
ADDRLP4 4
INDIRI4
RETI4
LABELV $106
endproc CG_DrawStrlen 20 0
proc CG_TileClearBox 16 36
line 216
;206:}
;207:
;208:/*
;209:=============
;210:CG_TileClearBox
;211:
;212:This repeats a 64*64 tile graphic to fill the screen around a sized down
;213:refresh window.
;214:=============
;215:*/
;216:static void CG_TileClearBox( int x, int y, int w, int h, qhandle_t hShader ) {
line 219
;217:	float	s1, t1, s2, t2;
;218:
;219:	s1 = x/64.0;
ADDRLP4 0
ADDRFP4 0
INDIRI4
CVIF4 4
CNSTF4 1115684864
DIVF4
ASGNF4
line 220
;220:	t1 = y/64.0;
ADDRLP4 4
ADDRFP4 4
INDIRI4
CVIF4 4
CNSTF4 1115684864
DIVF4
ASGNF4
line 221
;221:	s2 = (x+w)/64.0;
ADDRLP4 8
ADDRFP4 0
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
CVIF4 4
CNSTF4 1115684864
DIVF4
ASGNF4
line 222
;222:	t2 = (y+h)/64.0;
ADDRLP4 12
ADDRFP4 4
INDIRI4
ADDRFP4 12
INDIRI4
ADDI4
CVIF4 4
CNSTF4 1115684864
DIVF4
ASGNF4
line 223
;223:	trap_R_DrawStretchPic( x, y, w, h, s1, t1, s2, t2, hShader );
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 4
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 8
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 8
INDIRF4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRFP4 16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 224
;224:}
LABELV $112
endproc CG_TileClearBox 16 36
export CG_TileClear
proc CG_TileClear 48 20
line 235
;225:
;226:
;227:
;228:/*
;229:==============
;230:CG_TileClear
;231:
;232:Clear around a sized down screen
;233:==============
;234:*/
;235:void CG_TileClear( void ) {
line 239
;236:	int		top, bottom, left, right;
;237:	int		w, h;
;238:
;239:	w = cgs.glconfig.vidWidth;
ADDRLP4 8
ADDRGP4 cgs+20100+4136
INDIRI4
ASGNI4
line 240
;240:	h = cgs.glconfig.vidHeight;
ADDRLP4 20
ADDRGP4 cgs+20100+4140
INDIRI4
ASGNI4
line 242
;241:
;242:	if ( cg.refdef.x == 0 && cg.refdef.y == 0 && 
ADDRLP4 24
CNSTI4 0
ASGNI4
ADDRGP4 cg+106800
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $118
ADDRGP4 cg+106800+4
INDIRI4
ADDRLP4 24
INDIRI4
NEI4 $118
ADDRGP4 cg+106800+8
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $118
ADDRGP4 cg+106800+12
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $118
line 243
;243:		cg.refdef.width == w && cg.refdef.height == h ) {
line 244
;244:		return;		// full screen rendering
ADDRGP4 $113
JUMPV
LABELV $118
line 247
;245:	}
;246:
;247:	top = cg.refdef.y;
ADDRLP4 0
ADDRGP4 cg+106800+4
INDIRI4
ASGNI4
line 248
;248:	bottom = top + cg.refdef.height-1;
ADDRLP4 4
ADDRLP4 0
INDIRI4
ADDRGP4 cg+106800+12
INDIRI4
ADDI4
CNSTI4 1
SUBI4
ASGNI4
line 249
;249:	left = cg.refdef.x;
ADDRLP4 12
ADDRGP4 cg+106800
INDIRI4
ASGNI4
line 250
;250:	right = left + cg.refdef.width-1;
ADDRLP4 16
ADDRLP4 12
INDIRI4
ADDRGP4 cg+106800+8
INDIRI4
ADDI4
CNSTI4 1
SUBI4
ASGNI4
line 253
;251:
;252:	// clear above view screen
;253:	CG_TileClearBox( 0, 0, w, top, cgs.media.backTileShader );
ADDRLP4 28
CNSTI4 0
ASGNI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 cgs+170516+196
INDIRI4
ARGI4
ADDRGP4 CG_TileClearBox
CALLV
pop
line 256
;254:
;255:	// clear below view screen
;256:	CG_TileClearBox( 0, bottom, w, h - bottom, cgs.media.backTileShader );
CNSTI4 0
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 20
INDIRI4
ADDRLP4 4
INDIRI4
SUBI4
ARGI4
ADDRGP4 cgs+170516+196
INDIRI4
ARGI4
ADDRGP4 CG_TileClearBox
CALLV
pop
line 259
;257:
;258:	// clear left of view screen
;259:	CG_TileClearBox( 0, top, left, bottom - top + 1, cgs.media.backTileShader );
CNSTI4 0
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 1
ADDI4
ARGI4
ADDRGP4 cgs+170516+196
INDIRI4
ARGI4
ADDRGP4 CG_TileClearBox
CALLV
pop
line 262
;260:
;261:	// clear right of view screen
;262:	CG_TileClearBox( right, top, w - right, bottom - top + 1, cgs.media.backTileShader );
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ADDRLP4 16
INDIRI4
SUBI4
ARGI4
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 1
ADDI4
ARGI4
ADDRGP4 cgs+170516+196
INDIRI4
ARGI4
ADDRGP4 CG_TileClearBox
CALLV
pop
line 263
;263:}
LABELV $113
endproc CG_TileClear 48 20
bss
align 4
LABELV $143
skip 16
export CG_FadeColor
code
proc CG_FadeColor 8 0
line 272
;264:
;265:
;266:
;267:/*
;268:================
;269:CG_FadeColor
;270:================
;271:*/
;272:float *CG_FadeColor( int startMsec, int totalMsec ) {
line 276
;273:	static vec4_t		color;
;274:	int			t;
;275:
;276:	if ( startMsec == 0 ) {
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $144
line 277
;277:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $142
JUMPV
LABELV $144
line 280
;278:	}
;279:
;280:	t = cg.time - startMsec;
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
ADDRFP4 0
INDIRI4
SUBI4
ASGNI4
line 282
;281:
;282:	if ( t >= totalMsec ) {
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $147
line 283
;283:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $142
JUMPV
LABELV $147
line 287
;284:	}
;285:
;286:	// fade out
;287:	if ( totalMsec - t < FADE_TIME ) {
ADDRFP4 4
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 200
GEI4 $149
line 288
;288:		color[3] = ( totalMsec - t ) * 1.0/FADE_TIME;
ADDRGP4 $143+12
CNSTF4 1065353216
ADDRFP4 4
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1128792064
DIVF4
ASGNF4
line 289
;289:	} else {
ADDRGP4 $150
JUMPV
LABELV $149
line 290
;290:		color[3] = 1.0;
ADDRGP4 $143+12
CNSTF4 1065353216
ASGNF4
line 291
;291:	}
LABELV $150
line 292
;292:	color[0] = color[1] = color[2] = 1;
ADDRLP4 4
CNSTF4 1065353216
ASGNF4
ADDRGP4 $143+8
ADDRLP4 4
INDIRF4
ASGNF4
ADDRGP4 $143+4
ADDRLP4 4
INDIRF4
ASGNF4
ADDRGP4 $143
ADDRLP4 4
INDIRF4
ASGNF4
line 294
;293:
;294:	return color;
ADDRGP4 $143
RETP4
LABELV $142
endproc CG_FadeColor 8 0
data
align 4
LABELV $156
byte 4 1065353216
byte 4 1045220557
byte 4 1045220557
byte 4 1065353216
align 4
LABELV $157
byte 4 1045220557
byte 4 1045220557
byte 4 1065353216
byte 4 1065353216
align 4
LABELV $158
byte 4 1065353216
byte 4 1065353216
byte 4 1065353216
byte 4 1065353216
align 4
LABELV $159
byte 4 1060320051
byte 4 1060320051
byte 4 1060320051
byte 4 1065353216
export CG_TeamColor
code
proc CG_TeamColor 4 0
line 303
;295:}
;296:
;297:
;298:/*
;299:================
;300:CG_TeamColor
;301:================
;302:*/
;303:float *CG_TeamColor( int team ) {
line 309
;304:	static vec4_t	red = {1, 0.2, 0.2, 1};
;305:	static vec4_t	blue = {0.2, 0.2, 1, 1};
;306:	static vec4_t	other = {1, 1, 1, 1};
;307:	static vec4_t	spectator = {0.7, 0.7, 0.7, 1};
;308:
;309:	switch ( team ) {
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 1
EQI4 $162
ADDRLP4 0
INDIRI4
CNSTI4 2
EQI4 $163
ADDRLP4 0
INDIRI4
CNSTI4 3
EQI4 $164
ADDRGP4 $160
JUMPV
LABELV $162
line 311
;310:	case TEAM_RED:
;311:		return red;
ADDRGP4 $156
RETP4
ADDRGP4 $155
JUMPV
LABELV $163
line 313
;312:	case TEAM_BLUE:
;313:		return blue;
ADDRGP4 $157
RETP4
ADDRGP4 $155
JUMPV
LABELV $164
line 315
;314:	case TEAM_SPECTATOR:
;315:		return spectator;
ADDRGP4 $159
RETP4
ADDRGP4 $155
JUMPV
LABELV $160
line 317
;316:	default:
;317:		return other;
ADDRGP4 $158
RETP4
LABELV $155
endproc CG_TeamColor 4 0
export CG_GetColorForHealth
proc CG_GetColorForHealth 16 0
line 328
;318:	}
;319:}
;320:
;321:
;322:
;323:/*
;324:=================
;325:CG_GetColorForHealth
;326:=================
;327:*/
;328:void CG_GetColorForHealth( int health, int armor, vec4_t hcolor ) {
line 334
;329:	int		count;
;330:	int		max;
;331:
;332:	// calculate the total points of damage that can
;333:	// be sustained at the current health / armor level
;334:	if ( health <= 0 ) {
ADDRFP4 0
INDIRI4
CNSTI4 0
GTI4 $166
line 335
;335:		VectorClear( hcolor );	// black
ADDRLP4 8
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
ADDRLP4 12
INDIRF4
ASGNF4
line 336
;336:		hcolor[3] = 1;
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
CNSTF4 1065353216
ASGNF4
line 337
;337:		return;
ADDRGP4 $165
JUMPV
LABELV $166
line 339
;338:	}
;339:	count = armor;
ADDRLP4 0
ADDRFP4 4
INDIRI4
ASGNI4
line 340
;340:	max = health * ARMOR_PROTECTION / ( 1.0 - ARMOR_PROTECTION );
ADDRLP4 4
CNSTF4 1059648963
ADDRFP4 0
INDIRI4
CVIF4 4
MULF4
CNSTF4 1051595899
DIVF4
CVFI4 4
ASGNI4
line 341
;341:	if ( max < count ) {
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
GEI4 $168
line 342
;342:		count = max;
ADDRLP4 0
ADDRLP4 4
INDIRI4
ASGNI4
line 343
;343:	}
LABELV $168
line 344
;344:	health += count;
ADDRFP4 0
ADDRFP4 0
INDIRI4
ADDRLP4 0
INDIRI4
ADDI4
ASGNI4
line 347
;345:
;346:	// set the color based on health
;347:	hcolor[0] = 1.0;
ADDRFP4 8
INDIRP4
CNSTF4 1065353216
ASGNF4
line 348
;348:	hcolor[3] = 1.0;
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
CNSTF4 1065353216
ASGNF4
line 349
;349:	if ( health >= 100 ) {
ADDRFP4 0
INDIRI4
CNSTI4 100
LTI4 $170
line 350
;350:		hcolor[2] = 1.0;
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
CNSTF4 1065353216
ASGNF4
line 351
;351:	} else if ( health < 66 ) {
ADDRGP4 $171
JUMPV
LABELV $170
ADDRFP4 0
INDIRI4
CNSTI4 66
GEI4 $172
line 352
;352:		hcolor[2] = 0;
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
CNSTF4 0
ASGNF4
line 353
;353:	} else {
ADDRGP4 $173
JUMPV
LABELV $172
line 354
;354:		hcolor[2] = ( health - 66 ) / 33.0;
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 0
INDIRI4
CNSTI4 66
SUBI4
CVIF4 4
CNSTF4 1107558400
DIVF4
ASGNF4
line 355
;355:	}
LABELV $173
LABELV $171
line 357
;356:
;357:	if ( health > 60 ) {
ADDRFP4 0
INDIRI4
CNSTI4 60
LEI4 $174
line 358
;358:		hcolor[1] = 1.0;
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
CNSTF4 1065353216
ASGNF4
line 359
;359:	} else if ( health < 30 ) {
ADDRGP4 $175
JUMPV
LABELV $174
ADDRFP4 0
INDIRI4
CNSTI4 30
GEI4 $176
line 360
;360:		hcolor[1] = 0;
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
CNSTF4 0
ASGNF4
line 361
;361:	} else {
ADDRGP4 $177
JUMPV
LABELV $176
line 362
;362:		hcolor[1] = ( health - 30 ) / 30.0;
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 0
INDIRI4
CNSTI4 30
SUBI4
CVIF4 4
CNSTF4 1106247680
DIVF4
ASGNF4
line 363
;363:	}
LABELV $177
LABELV $175
line 364
;364:}
LABELV $165
endproc CG_GetColorForHealth 16 0
export CG_ColorForHealth
proc CG_ColorForHealth 0 12
line 371
;365:
;366:/*
;367:=================
;368:CG_ColorForHealth
;369:=================
;370:*/
;371:void CG_ColorForHealth( vec4_t hcolor ) {
line 373
;372:
;373:	CG_GetColorForHealth( cg.snap->ps.stats[STAT_HEALTH], 
ADDRGP4 cg+32
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
ARGI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 240
ADDP4
INDIRI4
ARGI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_GetColorForHealth
CALLV
pop
line 375
;374:		cg.snap->ps.stats[STAT_ARMOR], hcolor );
;375:}
LABELV $178
endproc CG_ColorForHealth 0 12
data
align 4
LABELV propMap
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 -1
byte 4 0
byte 4 0
byte 4 8
byte 4 11
byte 4 122
byte 4 7
byte 4 154
byte 4 181
byte 4 14
byte 4 55
byte 4 122
byte 4 17
byte 4 79
byte 4 122
byte 4 18
byte 4 101
byte 4 122
byte 4 23
byte 4 153
byte 4 122
byte 4 18
byte 4 9
byte 4 93
byte 4 7
byte 4 207
byte 4 122
byte 4 8
byte 4 230
byte 4 122
byte 4 9
byte 4 177
byte 4 122
byte 4 18
byte 4 30
byte 4 152
byte 4 18
byte 4 85
byte 4 181
byte 4 7
byte 4 34
byte 4 93
byte 4 11
byte 4 110
byte 4 181
byte 4 6
byte 4 130
byte 4 152
byte 4 14
byte 4 22
byte 4 64
byte 4 17
byte 4 41
byte 4 64
byte 4 12
byte 4 58
byte 4 64
byte 4 17
byte 4 78
byte 4 64
byte 4 18
byte 4 98
byte 4 64
byte 4 19
byte 4 120
byte 4 64
byte 4 18
byte 4 141
byte 4 64
byte 4 18
byte 4 204
byte 4 64
byte 4 16
byte 4 162
byte 4 64
byte 4 17
byte 4 182
byte 4 64
byte 4 18
byte 4 59
byte 4 181
byte 4 7
byte 4 35
byte 4 181
byte 4 7
byte 4 203
byte 4 152
byte 4 14
byte 4 56
byte 4 93
byte 4 14
byte 4 228
byte 4 152
byte 4 14
byte 4 177
byte 4 181
byte 4 18
byte 4 28
byte 4 122
byte 4 22
byte 4 5
byte 4 4
byte 4 18
byte 4 27
byte 4 4
byte 4 18
byte 4 48
byte 4 4
byte 4 18
byte 4 69
byte 4 4
byte 4 17
byte 4 90
byte 4 4
byte 4 13
byte 4 106
byte 4 4
byte 4 13
byte 4 121
byte 4 4
byte 4 18
byte 4 143
byte 4 4
byte 4 17
byte 4 164
byte 4 4
byte 4 8
byte 4 175
byte 4 4
byte 4 16
byte 4 195
byte 4 4
byte 4 18
byte 4 216
byte 4 4
byte 4 12
byte 4 230
byte 4 4
byte 4 23
byte 4 6
byte 4 34
byte 4 18
byte 4 27
byte 4 34
byte 4 18
byte 4 48
byte 4 34
byte 4 18
byte 4 68
byte 4 34
byte 4 18
byte 4 90
byte 4 34
byte 4 17
byte 4 110
byte 4 34
byte 4 18
byte 4 130
byte 4 34
byte 4 14
byte 4 146
byte 4 34
byte 4 18
byte 4 166
byte 4 34
byte 4 19
byte 4 185
byte 4 34
byte 4 29
byte 4 215
byte 4 34
byte 4 18
byte 4 234
byte 4 34
byte 4 18
byte 4 5
byte 4 64
byte 4 14
byte 4 60
byte 4 152
byte 4 7
byte 4 106
byte 4 151
byte 4 13
byte 4 83
byte 4 152
byte 4 7
byte 4 128
byte 4 122
byte 4 17
byte 4 4
byte 4 152
byte 4 21
byte 4 134
byte 4 181
byte 4 5
byte 4 5
byte 4 4
byte 4 18
byte 4 27
byte 4 4
byte 4 18
byte 4 48
byte 4 4
byte 4 18
byte 4 69
byte 4 4
byte 4 17
byte 4 90
byte 4 4
byte 4 13
byte 4 106
byte 4 4
byte 4 13
byte 4 121
byte 4 4
byte 4 18
byte 4 143
byte 4 4
byte 4 17
byte 4 164
byte 4 4
byte 4 8
byte 4 175
byte 4 4
byte 4 16
byte 4 195
byte 4 4
byte 4 18
byte 4 216
byte 4 4
byte 4 12
byte 4 230
byte 4 4
byte 4 23
byte 4 6
byte 4 34
byte 4 18
byte 4 27
byte 4 34
byte 4 18
byte 4 48
byte 4 34
byte 4 18
byte 4 68
byte 4 34
byte 4 18
byte 4 90
byte 4 34
byte 4 17
byte 4 110
byte 4 34
byte 4 18
byte 4 130
byte 4 34
byte 4 14
byte 4 146
byte 4 34
byte 4 18
byte 4 166
byte 4 34
byte 4 19
byte 4 185
byte 4 34
byte 4 29
byte 4 215
byte 4 34
byte 4 18
byte 4 234
byte 4 34
byte 4 18
byte 4 5
byte 4 64
byte 4 14
byte 4 153
byte 4 152
byte 4 13
byte 4 11
byte 4 181
byte 4 5
byte 4 180
byte 4 152
byte 4 13
byte 4 79
byte 4 93
byte 4 17
byte 4 0
byte 4 0
byte 4 -1
align 4
LABELV propMapB
byte 4 11
byte 4 12
byte 4 33
byte 4 49
byte 4 12
byte 4 31
byte 4 85
byte 4 12
byte 4 31
byte 4 120
byte 4 12
byte 4 30
byte 4 156
byte 4 12
byte 4 21
byte 4 183
byte 4 12
byte 4 21
byte 4 207
byte 4 12
byte 4 32
byte 4 13
byte 4 55
byte 4 30
byte 4 49
byte 4 55
byte 4 13
byte 4 66
byte 4 55
byte 4 29
byte 4 101
byte 4 55
byte 4 31
byte 4 135
byte 4 55
byte 4 21
byte 4 158
byte 4 55
byte 4 40
byte 4 204
byte 4 55
byte 4 32
byte 4 12
byte 4 97
byte 4 31
byte 4 48
byte 4 97
byte 4 31
byte 4 82
byte 4 97
byte 4 30
byte 4 118
byte 4 97
byte 4 30
byte 4 153
byte 4 97
byte 4 30
byte 4 185
byte 4 97
byte 4 25
byte 4 213
byte 4 97
byte 4 30
byte 4 11
byte 4 139
byte 4 32
byte 4 42
byte 4 139
byte 4 51
byte 4 93
byte 4 139
byte 4 32
byte 4 126
byte 4 139
byte 4 31
byte 4 158
byte 4 139
byte 4 25
code
proc UI_DrawBannerString2 52 36
line 537
;376:
;377:
;378:
;379:
;380:/*
;381:=================
;382:UI_DrawProportionalString2
;383:=================
;384:*/
;385:static int	propMap[128][3] = {
;386:{0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1},
;387:{0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1},
;388:
;389:{0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1},
;390:{0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1}, {0, 0, -1},
;391:
;392:{0, 0, PROP_SPACE_WIDTH},		// SPACE
;393:{11, 122, 7},	// !
;394:{154, 181, 14},	// "
;395:{55, 122, 17},	// #
;396:{79, 122, 18},	// $
;397:{101, 122, 23},	// %
;398:{153, 122, 18},	// &
;399:{9, 93, 7},		// '
;400:{207, 122, 8},	// (
;401:{230, 122, 9},	// )
;402:{177, 122, 18},	// *
;403:{30, 152, 18},	// +
;404:{85, 181, 7},	// ,
;405:{34, 93, 11},	// -
;406:{110, 181, 6},	// .
;407:{130, 152, 14},	// /
;408:
;409:{22, 64, 17},	// 0
;410:{41, 64, 12},	// 1
;411:{58, 64, 17},	// 2
;412:{78, 64, 18},	// 3
;413:{98, 64, 19},	// 4
;414:{120, 64, 18},	// 5
;415:{141, 64, 18},	// 6
;416:{204, 64, 16},	// 7
;417:{162, 64, 17},	// 8
;418:{182, 64, 18},	// 9
;419:{59, 181, 7},	// :
;420:{35,181, 7},	// ;
;421:{203, 152, 14},	// <
;422:{56, 93, 14},	// =
;423:{228, 152, 14},	// >
;424:{177, 181, 18},	// ?
;425:
;426:{28, 122, 22},	// @
;427:{5, 4, 18},		// A
;428:{27, 4, 18},	// B
;429:{48, 4, 18},	// C
;430:{69, 4, 17},	// D
;431:{90, 4, 13},	// E
;432:{106, 4, 13},	// F
;433:{121, 4, 18},	// G
;434:{143, 4, 17},	// H
;435:{164, 4, 8},	// I
;436:{175, 4, 16},	// J
;437:{195, 4, 18},	// K
;438:{216, 4, 12},	// L
;439:{230, 4, 23},	// M
;440:{6, 34, 18},	// N
;441:{27, 34, 18},	// O
;442:
;443:{48, 34, 18},	// P
;444:{68, 34, 18},	// Q
;445:{90, 34, 17},	// R
;446:{110, 34, 18},	// S
;447:{130, 34, 14},	// T
;448:{146, 34, 18},	// U
;449:{166, 34, 19},	// V
;450:{185, 34, 29},	// W
;451:{215, 34, 18},	// X
;452:{234, 34, 18},	// Y
;453:{5, 64, 14},	// Z
;454:{60, 152, 7},	// [
;455:{106, 151, 13},	// '\'
;456:{83, 152, 7},	// ]
;457:{128, 122, 17},	// ^
;458:{4, 152, 21},	// _
;459:
;460:{134, 181, 5},	// '
;461:{5, 4, 18},		// A
;462:{27, 4, 18},	// B
;463:{48, 4, 18},	// C
;464:{69, 4, 17},	// D
;465:{90, 4, 13},	// E
;466:{106, 4, 13},	// F
;467:{121, 4, 18},	// G
;468:{143, 4, 17},	// H
;469:{164, 4, 8},	// I
;470:{175, 4, 16},	// J
;471:{195, 4, 18},	// K
;472:{216, 4, 12},	// L
;473:{230, 4, 23},	// M
;474:{6, 34, 18},	// N
;475:{27, 34, 18},	// O
;476:
;477:{48, 34, 18},	// P
;478:{68, 34, 18},	// Q
;479:{90, 34, 17},	// R
;480:{110, 34, 18},	// S
;481:{130, 34, 14},	// T
;482:{146, 34, 18},	// U
;483:{166, 34, 19},	// V
;484:{185, 34, 29},	// W
;485:{215, 34, 18},	// X
;486:{234, 34, 18},	// Y
;487:{5, 64, 14},	// Z
;488:{153, 152, 13},	// {
;489:{11, 181, 5},	// |
;490:{180, 152, 13},	// }
;491:{79, 93, 17},	// ~
;492:{0, 0, -1}		// DEL
;493:};
;494:
;495:static int propMapB[26][3] = {
;496:{11, 12, 33},
;497:{49, 12, 31},
;498:{85, 12, 31},
;499:{120, 12, 30},
;500:{156, 12, 21},
;501:{183, 12, 21},
;502:{207, 12, 32},
;503:
;504:{13, 55, 30},
;505:{49, 55, 13},
;506:{66, 55, 29},
;507:{101, 55, 31},
;508:{135, 55, 21},
;509:{158, 55, 40},
;510:{204, 55, 32},
;511:
;512:{12, 97, 31},
;513:{48, 97, 31},
;514:{82, 97, 30},
;515:{118, 97, 30},
;516:{153, 97, 30},
;517:{185, 97, 25},
;518:{213, 97, 30},
;519:
;520:{11, 139, 32},
;521:{42, 139, 51},
;522:{93, 139, 32},
;523:{126, 139, 31},
;524:{158, 139, 25},
;525:};
;526:
;527:#define PROPB_GAP_WIDTH		4
;528:#define PROPB_SPACE_WIDTH	12
;529:#define PROPB_HEIGHT		36
;530:
;531:/*
;532:=================
;533:UI_DrawBannerString
;534:=================
;535:*/
;536:static void UI_DrawBannerString2( int x, int y, const char* str, vec4_t color )
;537:{
line 550
;538:	const char* s;
;539:	char	ch;
;540:	float	ax;
;541:	float	ay;
;542:	float	aw;
;543:	float	ah;
;544:	float	frow;
;545:	float	fcol;
;546:	float	fwidth;
;547:	float	fheight;
;548:
;549:	// draw the colored text
;550:	trap_R_SetColor( color );
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 552
;551:	
;552:	ax = x * cgs.screenXScale + cgs.screenXBias;
ADDRLP4 8
ADDRFP4 0
INDIRI4
CVIF4 4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDRGP4 cgs+24272
INDIRF4
ADDF4
ASGNF4
line 553
;553:	ay = y * cgs.screenXScale;
ADDRLP4 36
ADDRFP4 4
INDIRI4
CVIF4 4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ASGNF4
line 555
;554:
;555:	s = str;
ADDRLP4 4
ADDRFP4 8
INDIRP4
ASGNP4
ADDRGP4 $186
JUMPV
LABELV $185
line 557
;556:	while ( *s )
;557:	{
line 558
;558:		ch = *s & 127;
ADDRLP4 0
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
BANDI4
CVII1 4
ASGNI1
line 559
;559:		if ( ch == ' ' ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $188
line 560
;560:			ax += ((float)PROPB_SPACE_WIDTH + (float)PROPB_GAP_WIDTH)* cgs.screenXScale;
ADDRLP4 8
ADDRLP4 8
INDIRF4
CNSTF4 1098907648
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDF4
ASGNF4
line 561
;561:		}
ADDRGP4 $189
JUMPV
LABELV $188
line 562
;562:		else if ( ch >= 'A' && ch <= 'Z' ) {
ADDRLP4 40
ADDRLP4 0
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 65
LTI4 $191
ADDRLP4 40
INDIRI4
CNSTI4 90
GTI4 $191
line 563
;563:			ch -= 'A';
ADDRLP4 0
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 65
SUBI4
CVII1 4
ASGNI1
line 564
;564:			fcol = (float)propMapB[ch][0] / 256.0f;
ADDRLP4 20
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMapB
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1132462080
DIVF4
ASGNF4
line 565
;565:			frow = (float)propMapB[ch][1] / 256.0f;
ADDRLP4 16
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMapB+4
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1132462080
DIVF4
ASGNF4
line 566
;566:			fwidth = (float)propMapB[ch][2] / 256.0f;
ADDRLP4 28
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMapB+8
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1132462080
DIVF4
ASGNF4
line 567
;567:			fheight = (float)PROPB_HEIGHT / 256.0f;
ADDRLP4 32
CNSTF4 1041235968
ASGNF4
line 568
;568:			aw = (float)propMapB[ch][2] * cgs.screenXScale;
ADDRLP4 12
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMapB+8
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ASGNF4
line 569
;569:			ah = (float)PROPB_HEIGHT * cgs.screenXScale;
ADDRLP4 24
CNSTF4 1108344832
ADDRGP4 cgs+24264
INDIRF4
MULF4
ASGNF4
line 570
;570:			trap_R_DrawStretchPic( ax, ay, aw, ah, fcol, frow, fcol+fwidth, frow+fheight, cgs.media.charsetPropB );
ADDRLP4 8
INDIRF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 24
INDIRF4
ARGF4
ADDRLP4 20
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 20
INDIRF4
ADDRLP4 28
INDIRF4
ADDF4
ARGF4
ADDRLP4 16
INDIRF4
ADDRLP4 32
INDIRF4
ADDF4
ARGF4
ADDRGP4 cgs+170516+12
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 571
;571:			ax += (aw + (float)PROPB_GAP_WIDTH * cgs.screenXScale);
ADDRLP4 8
ADDRLP4 8
INDIRF4
ADDRLP4 12
INDIRF4
CNSTF4 1082130432
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDF4
ADDF4
ASGNF4
line 572
;572:		}
LABELV $191
LABELV $189
line 573
;573:		s++;
ADDRLP4 4
ADDRLP4 4
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 574
;574:	}
LABELV $186
line 556
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $185
line 576
;575:
;576:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 577
;577:}
LABELV $181
endproc UI_DrawBannerString2 52 36
export UI_DrawBannerString
proc UI_DrawBannerString 44 16
line 579
;578:
;579:void UI_DrawBannerString( int x, int y, const char* str, int style, vec4_t color ) {
line 586
;580:	const char *	s;
;581:	int				ch;
;582:	int				width;
;583:	vec4_t			drawcolor;
;584:
;585:	// find the width of the drawn text
;586:	s = str;
ADDRLP4 4
ADDRFP4 8
INDIRP4
ASGNP4
line 587
;587:	width = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $203
JUMPV
LABELV $202
line 588
;588:	while ( *s ) {
line 589
;589:		ch = *s;
ADDRLP4 0
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
ASGNI4
line 590
;590:		if ( ch == ' ' ) {
ADDRLP4 0
INDIRI4
CNSTI4 32
NEI4 $205
line 591
;591:			width += PROPB_SPACE_WIDTH;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 12
ADDI4
ASGNI4
line 592
;592:		}
ADDRGP4 $206
JUMPV
LABELV $205
line 593
;593:		else if ( ch >= 'A' && ch <= 'Z' ) {
ADDRLP4 0
INDIRI4
CNSTI4 65
LTI4 $207
ADDRLP4 0
INDIRI4
CNSTI4 90
GTI4 $207
line 594
;594:			width += propMapB[ch - 'A'][2] + PROPB_GAP_WIDTH;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 12
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 propMapB-780+8
ADDP4
INDIRI4
CNSTI4 4
ADDI4
ADDI4
ASGNI4
line 595
;595:		}
LABELV $207
LABELV $206
line 596
;596:		s++;
ADDRLP4 4
ADDRLP4 4
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 597
;597:	}
LABELV $203
line 588
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $202
line 598
;598:	width -= PROPB_GAP_WIDTH;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 4
SUBI4
ASGNI4
line 600
;599:
;600:	switch( style & UI_FORMATMASK ) {
ADDRLP4 28
ADDRFP4 12
INDIRI4
CNSTI4 7
BANDI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
EQI4 $212
ADDRLP4 28
INDIRI4
CNSTI4 1
EQI4 $214
ADDRLP4 28
INDIRI4
CNSTI4 2
EQI4 $215
ADDRGP4 $212
JUMPV
LABELV $214
line 602
;601:		case UI_CENTER:
;602:			x -= width / 2;
ADDRFP4 0
ADDRFP4 0
INDIRI4
ADDRLP4 8
INDIRI4
CNSTI4 2
DIVI4
SUBI4
ASGNI4
line 603
;603:			break;
ADDRGP4 $212
JUMPV
LABELV $215
line 606
;604:
;605:		case UI_RIGHT:
;606:			x -= width;
ADDRFP4 0
ADDRFP4 0
INDIRI4
ADDRLP4 8
INDIRI4
SUBI4
ASGNI4
line 607
;607:			break;
line 611
;608:
;609:		case UI_LEFT:
;610:		default:
;611:			break;
LABELV $212
line 614
;612:	}
;613:
;614:	if ( style & UI_DROPSHADOW ) {
ADDRFP4 12
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $217
line 615
;615:		drawcolor[0] = drawcolor[1] = drawcolor[2] = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
ADDRLP4 12+8
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 36
INDIRF4
ASGNF4
line 616
;616:		drawcolor[3] = color[3];
ADDRLP4 12+12
ADDRFP4 16
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ASGNF4
line 617
;617:		UI_DrawBannerString2( x+2, y+2, str, drawcolor );
ADDRLP4 40
CNSTI4 2
ASGNI4
ADDRFP4 0
INDIRI4
ADDRLP4 40
INDIRI4
ADDI4
ARGI4
ADDRFP4 4
INDIRI4
ADDRLP4 40
INDIRI4
ADDI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRGP4 UI_DrawBannerString2
CALLV
pop
line 618
;618:	}
LABELV $217
line 620
;619:
;620:	UI_DrawBannerString2( x, y, str, color );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRGP4 UI_DrawBannerString2
CALLV
pop
line 621
;621:}
LABELV $201
endproc UI_DrawBannerString 44 16
export UI_ProportionalStringWidth
proc UI_ProportionalStringWidth 16 0
line 624
;622:
;623:
;624:int UI_ProportionalStringWidth( const char* str ) {
line 630
;625:	const char *	s;
;626:	int				ch;
;627:	int				charWidth;
;628:	int				width;
;629:
;630:	s = str;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
line 631
;631:	width = 0;
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 $224
JUMPV
LABELV $223
line 632
;632:	while ( *s ) {
line 633
;633:		ch = *s & 127;
ADDRLP4 8
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
BANDI4
ASGNI4
line 634
;634:		charWidth = propMap[ch][2];
ADDRLP4 4
CNSTI4 12
ADDRLP4 8
INDIRI4
MULI4
ADDRGP4 propMap+8
ADDP4
INDIRI4
ASGNI4
line 635
;635:		if ( charWidth != -1 ) {
ADDRLP4 4
INDIRI4
CNSTI4 -1
EQI4 $227
line 636
;636:			width += charWidth;
ADDRLP4 12
ADDRLP4 12
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 637
;637:			width += PROP_GAP_WIDTH;
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 3
ADDI4
ASGNI4
line 638
;638:		}
LABELV $227
line 639
;639:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 640
;640:	}
LABELV $224
line 632
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $223
line 642
;641:
;642:	width -= PROP_GAP_WIDTH;
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 3
SUBI4
ASGNI4
line 643
;643:	return width;
ADDRLP4 12
INDIRI4
RETI4
LABELV $222
endproc UI_ProportionalStringWidth 16 0
proc UI_DrawProportionalString2 48 36
line 647
;644:}
;645:
;646:static void UI_DrawProportionalString2( int x, int y, const char* str, vec4_t color, float sizeScale, qhandle_t charset )
;647:{
line 660
;648:	const char* s;
;649:	char	ch;
;650:	float	ax;
;651:	float	ay;
;652:	float	aw;
;653:	float	ah;
;654:	float	frow;
;655:	float	fcol;
;656:	float	fwidth;
;657:	float	fheight;
;658:
;659:	// draw the colored text
;660:	trap_R_SetColor( color );
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 662
;661:	
;662:	ax = x * cgs.screenXScale + cgs.screenXBias;
ADDRLP4 12
ADDRFP4 0
INDIRI4
CVIF4 4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDRGP4 cgs+24272
INDIRF4
ADDF4
ASGNF4
line 663
;663:	ay = y * cgs.screenXScale;
ADDRLP4 36
ADDRFP4 4
INDIRI4
CVIF4 4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ASGNF4
line 665
;664:
;665:	s = str;
ADDRLP4 4
ADDRFP4 8
INDIRP4
ASGNP4
ADDRGP4 $234
JUMPV
LABELV $233
line 667
;666:	while ( *s )
;667:	{
line 668
;668:		ch = *s & 127;
ADDRLP4 0
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 127
BANDI4
CVII1 4
ASGNI1
line 669
;669:		if ( ch == ' ' ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $236
line 670
;670:			aw = (float)PROP_SPACE_WIDTH * cgs.screenXScale * sizeScale;
ADDRLP4 8
CNSTF4 1090519040
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ASGNF4
line 671
;671:		} else if ( propMap[ch][2] != -1 ) {
ADDRGP4 $237
JUMPV
LABELV $236
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMap+8
ADDP4
INDIRI4
CNSTI4 -1
EQI4 $239
line 672
;672:			fcol = (float)propMap[ch][0] / 256.0f;
ADDRLP4 20
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMap
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1132462080
DIVF4
ASGNF4
line 673
;673:			frow = (float)propMap[ch][1] / 256.0f;
ADDRLP4 16
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMap+4
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1132462080
DIVF4
ASGNF4
line 674
;674:			fwidth = (float)propMap[ch][2] / 256.0f;
ADDRLP4 28
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMap+8
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1132462080
DIVF4
ASGNF4
line 675
;675:			fheight = (float)PROP_HEIGHT / 256.0f;
ADDRLP4 32
CNSTF4 1037565952
ASGNF4
line 676
;676:			aw = (float)propMap[ch][2] * cgs.screenXScale * sizeScale;
ADDRLP4 8
CNSTI4 12
ADDRLP4 0
INDIRI1
CVII4 1
MULI4
ADDRGP4 propMap+8
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ASGNF4
line 677
;677:			ah = (float)PROP_HEIGHT * cgs.screenXScale * sizeScale;
ADDRLP4 24
CNSTF4 1104674816
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ASGNF4
line 678
;678:			trap_R_DrawStretchPic( ax, ay, aw, ah, fcol, frow, fcol+fwidth, frow+fheight, charset );
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 8
INDIRF4
ARGF4
ADDRLP4 24
INDIRF4
ARGF4
ADDRLP4 20
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 20
INDIRF4
ADDRLP4 28
INDIRF4
ADDF4
ARGF4
ADDRLP4 16
INDIRF4
ADDRLP4 32
INDIRF4
ADDF4
ARGF4
ADDRFP4 20
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 679
;679:		} else {
ADDRGP4 $240
JUMPV
LABELV $239
line 680
;680:			aw = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
line 681
;681:		}
LABELV $240
LABELV $237
line 683
;682:
;683:		ax += (aw + (float)PROP_GAP_WIDTH * cgs.screenXScale * sizeScale);
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 8
INDIRF4
CNSTF4 1077936128
ADDRGP4 cgs+24264
INDIRF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ADDF4
ASGNF4
line 684
;684:		s++;
ADDRLP4 4
ADDRLP4 4
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 685
;685:	}
LABELV $234
line 666
ADDRLP4 4
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $233
line 687
;686:
;687:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 688
;688:}
LABELV $229
endproc UI_DrawProportionalString2 48 36
export UI_ProportionalSizeScale
proc UI_ProportionalSizeScale 0 0
line 695
;689:
;690:/*
;691:=================
;692:UI_ProportionalSizeScale
;693:=================
;694:*/
;695:float UI_ProportionalSizeScale( int style ) {
line 696
;696:	if(  style & UI_SMALLFONT ) {
ADDRFP4 0
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $249
line 697
;697:		return 0.75;
CNSTF4 1061158912
RETF4
ADDRGP4 $248
JUMPV
LABELV $249
line 700
;698:	}
;699:
;700:	return 1.00;
CNSTF4 1065353216
RETF4
LABELV $248
endproc UI_ProportionalSizeScale 0 0
export UI_DrawProportionalString
proc UI_DrawProportionalString 44 24
line 709
;701:}
;702:
;703:
;704:/*
;705:=================
;706:UI_DrawProportionalString
;707:=================
;708:*/
;709:void UI_DrawProportionalString( int x, int y, const char* str, int style, vec4_t color ) {
line 714
;710:	vec4_t	drawcolor;
;711:	int		width;
;712:	float	sizeScale;
;713:
;714:	sizeScale = UI_ProportionalSizeScale( style );
ADDRFP4 12
INDIRI4
ARGI4
ADDRLP4 24
ADDRGP4 UI_ProportionalSizeScale
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 24
INDIRF4
ASGNF4
line 716
;715:
;716:	switch( style & UI_FORMATMASK ) {
ADDRLP4 28
ADDRFP4 12
INDIRI4
CNSTI4 7
BANDI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
EQI4 $253
ADDRLP4 28
INDIRI4
CNSTI4 1
EQI4 $255
ADDRLP4 28
INDIRI4
CNSTI4 2
EQI4 $256
ADDRGP4 $253
JUMPV
LABELV $255
line 718
;717:		case UI_CENTER:
;718:			width = UI_ProportionalStringWidth( str ) * sizeScale;
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 UI_ProportionalStringWidth
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 36
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 719
;719:			x -= width / 2;
ADDRFP4 0
ADDRFP4 0
INDIRI4
ADDRLP4 20
INDIRI4
CNSTI4 2
DIVI4
SUBI4
ASGNI4
line 720
;720:			break;
ADDRGP4 $253
JUMPV
LABELV $256
line 723
;721:
;722:		case UI_RIGHT:
;723:			width = UI_ProportionalStringWidth( str ) * sizeScale;
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 UI_ProportionalStringWidth
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 40
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 724
;724:			x -= width;
ADDRFP4 0
ADDRFP4 0
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 725
;725:			break;
line 729
;726:
;727:		case UI_LEFT:
;728:		default:
;729:			break;
LABELV $253
line 732
;730:	}
;731:
;732:	if ( style & UI_DROPSHADOW ) {
ADDRFP4 12
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $258
line 733
;733:		drawcolor[0] = drawcolor[1] = drawcolor[2] = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
ADDRLP4 0+8
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 36
INDIRF4
ASGNF4
line 734
;734:		drawcolor[3] = color[3];
ADDRLP4 0+12
ADDRFP4 16
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ASGNF4
line 735
;735:		UI_DrawProportionalString2( x+2, y+2, str, drawcolor, sizeScale, cgs.media.charsetProp );
ADDRLP4 40
CNSTI4 2
ASGNI4
ADDRFP4 0
INDIRI4
ADDRLP4 40
INDIRI4
ADDI4
ARGI4
ADDRFP4 4
INDIRI4
ADDRLP4 40
INDIRI4
ADDI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 16
INDIRF4
ARGF4
ADDRGP4 cgs+170516+4
INDIRI4
ARGI4
ADDRGP4 UI_DrawProportionalString2
CALLV
pop
line 736
;736:	}
LABELV $258
line 738
;737:
;738:	if ( style & UI_INVERSE ) {
ADDRFP4 12
INDIRI4
CNSTI4 8192
BANDI4
CNSTI4 0
EQI4 $265
line 739
;739:		drawcolor[0] = color[0] * 0.8;
ADDRLP4 0
CNSTF4 1061997773
ADDRFP4 16
INDIRP4
INDIRF4
MULF4
ASGNF4
line 740
;740:		drawcolor[1] = color[1] * 0.8;
ADDRLP4 0+4
CNSTF4 1061997773
ADDRFP4 16
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
line 741
;741:		drawcolor[2] = color[2] * 0.8;
ADDRLP4 0+8
CNSTF4 1061997773
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 742
;742:		drawcolor[3] = color[3];
ADDRLP4 0+12
ADDRFP4 16
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ASGNF4
line 743
;743:		UI_DrawProportionalString2( x, y, str, drawcolor, sizeScale, cgs.media.charsetProp );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 16
INDIRF4
ARGF4
ADDRGP4 cgs+170516+4
INDIRI4
ARGI4
ADDRGP4 UI_DrawProportionalString2
CALLV
pop
line 744
;744:		return;
ADDRGP4 $251
JUMPV
LABELV $265
line 747
;745:	}
;746:
;747:	if ( style & UI_PULSE ) {
ADDRFP4 12
INDIRI4
CNSTI4 16384
BANDI4
CNSTI4 0
EQI4 $272
line 748
;748:		drawcolor[0] = color[0] * 0.8;
ADDRLP4 0
CNSTF4 1061997773
ADDRFP4 16
INDIRP4
INDIRF4
MULF4
ASGNF4
line 749
;749:		drawcolor[1] = color[1] * 0.8;
ADDRLP4 0+4
CNSTF4 1061997773
ADDRFP4 16
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
line 750
;750:		drawcolor[2] = color[2] * 0.8;
ADDRLP4 0+8
CNSTF4 1061997773
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 751
;751:		drawcolor[3] = color[3];
ADDRLP4 0+12
ADDRFP4 16
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ASGNF4
line 752
;752:		UI_DrawProportionalString2( x, y, str, color, sizeScale, cgs.media.charsetProp );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRLP4 16
INDIRF4
ARGF4
ADDRGP4 cgs+170516+4
INDIRI4
ARGI4
ADDRGP4 UI_DrawProportionalString2
CALLV
pop
line 754
;753:
;754:		drawcolor[0] = color[0];
ADDRLP4 0
ADDRFP4 16
INDIRP4
INDIRF4
ASGNF4
line 755
;755:		drawcolor[1] = color[1];
ADDRLP4 0+4
ADDRFP4 16
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
line 756
;756:		drawcolor[2] = color[2];
ADDRLP4 0+8
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 757
;757:		drawcolor[3] = 0.5 + 0.5 * sin( cg.time / PULSE_DIVISOR );
ADDRGP4 cg+105504
INDIRI4
CNSTI4 75
DIVI4
CVIF4 4
ARGF4
ADDRLP4 36
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 0+12
CNSTF4 1056964608
ADDRLP4 36
INDIRF4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 758
;758:		UI_DrawProportionalString2( x, y, str, drawcolor, sizeScale, cgs.media.charsetPropGlow );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 16
INDIRF4
ARGF4
ADDRGP4 cgs+170516+8
INDIRI4
ARGI4
ADDRGP4 UI_DrawProportionalString2
CALLV
pop
line 759
;759:		return;
ADDRGP4 $251
JUMPV
LABELV $272
line 762
;760:	}
;761:
;762:	UI_DrawProportionalString2( x, y, str, color, sizeScale, cgs.media.charsetProp );
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRLP4 16
INDIRF4
ARGF4
ADDRGP4 cgs+170516+4
INDIRI4
ARGI4
ADDRGP4 UI_DrawProportionalString2
CALLV
pop
line 763
;763:}
LABELV $251
endproc UI_DrawProportionalString 44 24
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawString
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
