data
export drawTeamOverlayModificationCount
align 4
LABELV drawTeamOverlayModificationCount
byte 4 -1
code
proc CG_DrawField 64 20
file "..\cg_draw.c"
line 20
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_draw.c -- draw all of the graphical elements during
;4:// active (after loading) gameplay
;5:
;6:#include "cg_local.h"
;7:
;8:// set in CG_ParseTeamInfo
;9:int sortedTeamPlayers[TEAM_MAXOVERLAY];
;10:int	numSortedTeamPlayers;
;11:int drawTeamOverlayModificationCount = -1;
;12:
;13:/*
;14:==============
;15:CG_DrawField
;16:
;17:Draws large numbers for status bar and powerups
;18:==============
;19:*/
;20:static void CG_DrawField (int x, int y, int width, int value) {
line 25
;21:	char	num[16], *ptr;
;22:	int		l;
;23:	int		frame;
;24:
;25:	if ( width < 1 ) {
ADDRFP4 8
INDIRI4
CNSTI4 1
GEI4 $61
line 26
;26:		return;
ADDRGP4 $60
JUMPV
LABELV $61
line 30
;27:	}
;28:
;29:	// draw number string
;30:	if ( width > 5 ) {
ADDRFP4 8
INDIRI4
CNSTI4 5
LEI4 $63
line 31
;31:		width = 5;
ADDRFP4 8
CNSTI4 5
ASGNI4
line 32
;32:	}
LABELV $63
line 34
;33:
;34:	switch ( width ) {
ADDRLP4 28
ADDRFP4 8
INDIRI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 1
LTI4 $65
ADDRLP4 28
INDIRI4
CNSTI4 4
GTI4 $65
ADDRLP4 28
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $95-4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $95
address $67
address $74
address $81
address $88
code
LABELV $67
line 36
;35:	case 1:
;36:		value = value > 9 ? 9 : value;
ADDRFP4 12
INDIRI4
CNSTI4 9
LEI4 $69
ADDRLP4 32
CNSTI4 9
ASGNI4
ADDRGP4 $70
JUMPV
LABELV $69
ADDRLP4 32
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $70
ADDRFP4 12
ADDRLP4 32
INDIRI4
ASGNI4
line 37
;37:		value = value < 0 ? 0 : value;
ADDRFP4 12
INDIRI4
CNSTI4 0
GEI4 $72
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRGP4 $73
JUMPV
LABELV $72
ADDRLP4 36
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $73
ADDRFP4 12
ADDRLP4 36
INDIRI4
ASGNI4
line 38
;38:		break;
ADDRGP4 $66
JUMPV
LABELV $74
line 40
;39:	case 2:
;40:		value = value > 99 ? 99 : value;
ADDRFP4 12
INDIRI4
CNSTI4 99
LEI4 $76
ADDRLP4 40
CNSTI4 99
ASGNI4
ADDRGP4 $77
JUMPV
LABELV $76
ADDRLP4 40
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $77
ADDRFP4 12
ADDRLP4 40
INDIRI4
ASGNI4
line 41
;41:		value = value < -9 ? -9 : value;
ADDRFP4 12
INDIRI4
CNSTI4 -9
GEI4 $79
ADDRLP4 44
CNSTI4 -9
ASGNI4
ADDRGP4 $80
JUMPV
LABELV $79
ADDRLP4 44
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $80
ADDRFP4 12
ADDRLP4 44
INDIRI4
ASGNI4
line 42
;42:		break;
ADDRGP4 $66
JUMPV
LABELV $81
line 44
;43:	case 3:
;44:		value = value > 999 ? 999 : value;
ADDRFP4 12
INDIRI4
CNSTI4 999
LEI4 $83
ADDRLP4 48
CNSTI4 999
ASGNI4
ADDRGP4 $84
JUMPV
LABELV $83
ADDRLP4 48
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $84
ADDRFP4 12
ADDRLP4 48
INDIRI4
ASGNI4
line 45
;45:		value = value < -99 ? -99 : value;
ADDRFP4 12
INDIRI4
CNSTI4 -99
GEI4 $86
ADDRLP4 52
CNSTI4 -99
ASGNI4
ADDRGP4 $87
JUMPV
LABELV $86
ADDRLP4 52
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $87
ADDRFP4 12
ADDRLP4 52
INDIRI4
ASGNI4
line 46
;46:		break;
ADDRGP4 $66
JUMPV
LABELV $88
line 48
;47:	case 4:
;48:		value = value > 9999 ? 9999 : value;
ADDRFP4 12
INDIRI4
CNSTI4 9999
LEI4 $90
ADDRLP4 56
CNSTI4 9999
ASGNI4
ADDRGP4 $91
JUMPV
LABELV $90
ADDRLP4 56
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $91
ADDRFP4 12
ADDRLP4 56
INDIRI4
ASGNI4
line 49
;49:		value = value < -999 ? -999 : value;
ADDRFP4 12
INDIRI4
CNSTI4 -999
GEI4 $93
ADDRLP4 60
CNSTI4 -999
ASGNI4
ADDRGP4 $94
JUMPV
LABELV $93
ADDRLP4 60
ADDRFP4 12
INDIRI4
ASGNI4
LABELV $94
ADDRFP4 12
ADDRLP4 60
INDIRI4
ASGNI4
line 50
;50:		break;
LABELV $65
LABELV $66
line 53
;51:	}
;52:
;53:	Com_sprintf (num, sizeof(num), "%i", value);
ADDRLP4 12
ARGP4
CNSTI4 16
ARGI4
ADDRGP4 $97
ARGP4
ADDRFP4 12
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 54
;54:	l = strlen(num);
ADDRLP4 12
ARGP4
ADDRLP4 32
ADDRGP4 strlen
CALLU4
ASGNU4
ADDRLP4 4
ADDRLP4 32
INDIRU4
CVUI4 4
ASGNI4
line 55
;55:	if (l > width)
ADDRLP4 4
INDIRI4
ADDRFP4 8
INDIRI4
LEI4 $98
line 56
;56:		l = width;
ADDRLP4 4
ADDRFP4 8
INDIRI4
ASGNI4
LABELV $98
line 57
;57:	x += 2 + CHAR_WIDTH*(width - l);
ADDRFP4 0
ADDRFP4 0
INDIRI4
ADDRFP4 8
INDIRI4
ADDRLP4 4
INDIRI4
SUBI4
CNSTI4 5
LSHI4
CNSTI4 2
ADDI4
ADDI4
ASGNI4
line 59
;58:
;59:	ptr = num;
ADDRLP4 0
ADDRLP4 12
ASGNP4
ADDRGP4 $101
JUMPV
LABELV $100
line 61
;60:	while (*ptr && l)
;61:	{
line 62
;62:		if (*ptr == '-')
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 45
NEI4 $103
line 63
;63:			frame = STAT_MINUS;
ADDRLP4 8
CNSTI4 10
ASGNI4
ADDRGP4 $104
JUMPV
LABELV $103
line 65
;64:		else
;65:			frame = *ptr -'0';
ADDRLP4 8
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
ASGNI4
LABELV $104
line 67
;66:
;67:		CG_DrawPic( x,y, CHAR_WIDTH, CHAR_HEIGHT, cgs.media.numberShaders[frame] );
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 4
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1107296256
ARGF4
CNSTF4 1111490560
ARGF4
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+228
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 68
;68:		x += CHAR_WIDTH;
ADDRFP4 0
ADDRFP4 0
INDIRI4
CNSTI4 32
ADDI4
ASGNI4
line 69
;69:		ptr++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 70
;70:		l--;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 71
;71:	}
LABELV $101
line 60
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 36
INDIRI4
EQI4 $107
ADDRLP4 4
INDIRI4
ADDRLP4 36
INDIRI4
NEI4 $100
LABELV $107
line 72
;72:}
LABELV $60
endproc CG_DrawField 64 20
proc CG_Draw3DModel 652 16
line 81
;73:
;74:
;75:/*
;76:================
;77:CG_Draw3DModel
;78:
;79:================
;80:*/
;81:static void CG_Draw3DModel( float x, float y, float w, float h, qhandle_t model, qhandle_t skin, vec3_t origin, vec3_t angles ) {
line 85
;82:	refdef_t		refdef;
;83:	refEntity_t		ent;
;84:
;85:	if ( !cg_draw3dIcons.integer || !cg_drawIcons.integer ) {
ADDRLP4 508
CNSTI4 0
ASGNI4
ADDRGP4 cg_draw3dIcons+12
INDIRI4
ADDRLP4 508
INDIRI4
EQI4 $113
ADDRGP4 cg_drawIcons+12
INDIRI4
ADDRLP4 508
INDIRI4
NEI4 $109
LABELV $113
line 86
;86:		return;
ADDRGP4 $108
JUMPV
LABELV $109
line 89
;87:	}
;88:
;89:	CG_AdjustFrom640( &x, &y, &w, &h );
ADDRFP4 0
ARGP4
ADDRFP4 4
ARGP4
ADDRFP4 8
ARGP4
ADDRFP4 12
ARGP4
ADDRGP4 CG_AdjustFrom640
CALLV
pop
line 91
;90:
;91:	memset( &refdef, 0, sizeof( refdef ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTU4 368
ARGU4
ADDRGP4 memset
CALLP4
pop
line 93
;92:
;93:	memset( &ent, 0, sizeof( ent ) );
ADDRLP4 368
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 94
;94:	AnglesToAxis( angles, ent.axis );
ADDRFP4 28
INDIRP4
ARGP4
ADDRLP4 368+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 95
;95:	VectorCopy( origin, ent.origin );
ADDRLP4 368+68
ADDRFP4 24
INDIRP4
INDIRB
ASGNB 12
line 96
;96:	ent.hModel = model;
ADDRLP4 368+8
ADDRFP4 16
INDIRI4
ASGNI4
line 97
;97:	ent.customSkin = skin;
ADDRLP4 368+108
ADDRFP4 20
INDIRI4
ASGNI4
line 98
;98:	ent.renderfx = RF_NOSHADOW;		// no stencil shadows
ADDRLP4 368+4
CNSTI4 64
ASGNI4
line 100
;99:
;100:	refdef.rdflags = RDF_NOWORLDMODEL;
ADDRLP4 0+76
CNSTI4 1
ASGNI4
line 102
;101:
;102:	AxisClear( refdef.viewaxis );
ADDRLP4 0+36
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 104
;103:
;104:	refdef.fov_x = 30;
ADDRLP4 0+16
CNSTF4 1106247680
ASGNF4
line 105
;105:	refdef.fov_y = 30;
ADDRLP4 0+20
CNSTF4 1106247680
ASGNF4
line 107
;106:
;107:	refdef.x = x;
ADDRLP4 0
ADDRFP4 0
INDIRF4
CVFI4 4
ASGNI4
line 108
;108:	refdef.y = y;
ADDRLP4 0+4
ADDRFP4 4
INDIRF4
CVFI4 4
ASGNI4
line 109
;109:	refdef.width = w;
ADDRLP4 0+8
ADDRFP4 8
INDIRF4
CVFI4 4
ASGNI4
line 110
;110:	refdef.height = h;
ADDRLP4 0+12
ADDRFP4 12
INDIRF4
CVFI4 4
ASGNI4
line 112
;111:
;112:	refdef.time = cg.time;
ADDRLP4 0+72
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 114
;113:
;114:	trap_R_ClearScene();
ADDRGP4 trap_R_ClearScene
CALLV
pop
line 115
;115:	trap_R_AddRefEntityToScene( &ent );
ADDRLP4 368
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 116
;116:	if(model == cg_weapons[WP_MACHINEGUN].weaponModel)
ADDRFP4 16
INDIRI4
ADDRGP4 cg_weapons+264+12
INDIRI4
NEI4 $128
line 117
;117:	{
line 119
;118:		refEntity_t		barrel;
;119:		memset( &barrel, 0, sizeof( barrel ) );
ADDRLP4 512
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 120
;120:		VectorCopy( ent.lightingOrigin, barrel.lightingOrigin );
ADDRLP4 512+12
ADDRLP4 368+12
INDIRB
ASGNB 12
line 121
;121:		barrel.renderfx = ent.renderfx;
ADDRLP4 512+4
ADDRLP4 368+4
INDIRI4
ASGNI4
line 123
;122:
;123:		barrel.hModel = cg_weapons[WP_MACHINEGUN].barrelModel;
ADDRLP4 512+8
ADDRGP4 cg_weapons+264+16
INDIRI4
ASGNI4
line 124
;124:		angles[YAW] = 0;
ADDRFP4 28
INDIRP4
CNSTI4 4
ADDP4
CNSTF4 0
ASGNF4
line 125
;125:		angles[PITCH] = 0;
ADDRFP4 28
INDIRP4
CNSTF4 0
ASGNF4
line 126
;126:		angles[ROLL] = 0;// make spin?
ADDRFP4 28
INDIRP4
CNSTI4 8
ADDP4
CNSTF4 0
ASGNF4
line 127
;127:		AnglesToAxis( angles, barrel.axis );
ADDRFP4 28
INDIRP4
ARGP4
ADDRLP4 512+28
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 129
;128:
;129:		CG_PositionRotatedEntityOnTag( &barrel, &ent, cg_weapons[WP_MACHINEGUN].weaponModel, "tag_barrel" );
ADDRLP4 512
ARGP4
ADDRLP4 368
ARGP4
ADDRGP4 cg_weapons+264+12
INDIRI4
ARGI4
ADDRGP4 $142
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 130
;130:		trap_R_AddRefEntityToScene( &barrel );
ADDRLP4 512
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 132
;131:
;132:	}
LABELV $128
line 133
;133:	trap_R_RenderScene( &refdef );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_RenderScene
CALLV
pop
line 134
;134:}
LABELV $108
endproc CG_Draw3DModel 652 16
export CG_DrawHead
proc CG_DrawHead 56 32
line 143
;135:
;136:/*
;137:================
;138:CG_DrawHead
;139:
;140:Used for both the status bar and the scoreboard
;141:================
;142:*/
;143:void CG_DrawHead( float x, float y, float w, float h, int clientNum, vec3_t headAngles ) {
line 150
;144:	clipHandle_t	cm;
;145:	clientInfo_t	*ci;
;146:	float			len;
;147:	vec3_t			origin;
;148:	vec3_t			mins, maxs;
;149:
;150:	ci = &cgs.clientinfo[ clientNum ];
ADDRLP4 0
CNSTI4 1076
ADDRFP4 16
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 152
;151:
;152:	if ( cg_draw3dIcons.integer ) {
ADDRGP4 cg_draw3dIcons+12
INDIRI4
CNSTI4 0
EQI4 $145
line 153
;153:		cm = ci->headModel;
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
INDIRI4
ASGNI4
line 154
;154:		if ( !cm ) {
ADDRLP4 40
INDIRI4
CNSTI4 0
NEI4 $148
line 155
;155:			return;
ADDRGP4 $143
JUMPV
LABELV $148
line 159
;156:		}
;157:
;158:		// offset the origin y and z to center the head
;159:		trap_R_ModelBounds( cm, mins, maxs );
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 16
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 trap_R_ModelBounds
CALLV
pop
line 161
;160:
;161:		origin[2] = -0.5 * ( mins[2] + maxs[2] );
ADDRLP4 4+8
CNSTF4 3204448256
ADDRLP4 16+8
INDIRF4
ADDRLP4 28+8
INDIRF4
ADDF4
MULF4
ASGNF4
line 162
;162:		origin[1] = 0.5 * ( mins[1] + maxs[1] );
ADDRLP4 4+4
CNSTF4 1056964608
ADDRLP4 16+4
INDIRF4
ADDRLP4 28+4
INDIRF4
ADDF4
MULF4
ASGNF4
line 166
;163:
;164:		// calculate distance so the head nearly fills the box
;165:		// assume heads are taller than wide
;166:		len = 0.7 * ( maxs[2] - mins[2] );		
ADDRLP4 44
CNSTF4 1060320051
ADDRLP4 28+8
INDIRF4
ADDRLP4 16+8
INDIRF4
SUBF4
MULF4
ASGNF4
line 167
;167:		origin[0] = len / 0.268;	// len / tan( fov/2 )
ADDRLP4 4
ADDRLP4 44
INDIRF4
CNSTF4 1049179980
DIVF4
ASGNF4
line 170
;168:
;169:		// allow per-model tweaking
;170:		VectorAdd( origin, ci->headOffset, origin );
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 384
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 388
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 392
ADDP4
INDIRF4
ADDF4
ASGNF4
line 172
;171:
;172:		CG_Draw3DModel( x, y, w, h, ci->headModel, ci->headSkin, origin, headAngles );
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 0
INDIRP4
CNSTI4 436
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 440
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRFP4 20
INDIRP4
ARGP4
ADDRGP4 CG_Draw3DModel
CALLV
pop
line 173
;173:	} else if ( cg_drawIcons.integer ) {
ADDRGP4 $146
JUMPV
LABELV $145
ADDRGP4 cg_drawIcons+12
INDIRI4
CNSTI4 0
EQI4 $162
line 174
;174:		CG_DrawPic( x, y, w, h, ci->modelIcon );
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
ADDRLP4 0
INDIRP4
CNSTI4 444
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 175
;175:	}
LABELV $162
LABELV $146
line 178
;176:
;177:	// if they are deferred, draw a cross out
;178:	if ( ci->deferred ) {
ADDRLP4 0
INDIRP4
CNSTI4 380
ADDP4
INDIRI4
CNSTI4 0
EQI4 $165
line 179
;179:		CG_DrawPic( x, y, w, h, cgs.media.deferShader );
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
ADDRGP4 cgs+170516+64
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 180
;180:	}
LABELV $165
line 181
;181:}
LABELV $143
endproc CG_DrawHead 56 32
export CG_DrawFlagModel
proc CG_DrawFlagModel 68 32
line 190
;182:
;183:/*
;184:================
;185:CG_DrawFlagModel
;186:
;187:Used for both the status bar and the scoreboard
;188:================
;189:*/
;190:void CG_DrawFlagModel( float x, float y, float w, float h, int team ) {
line 196
;191:	qhandle_t		cm;
;192:	float			len;
;193:	vec3_t			origin, angles;
;194:	vec3_t			mins, maxs;
;195:
;196:	if ( cg_draw3dIcons.integer ) {
ADDRGP4 cg_draw3dIcons+12
INDIRI4
CNSTI4 0
EQI4 $170
line 198
;197:
;198:		VectorClear( angles );
ADDRLP4 56
CNSTF4 0
ASGNF4
ADDRLP4 0+8
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 56
INDIRF4
ASGNF4
line 200
;199:
;200:		cm = cgs.media.redFlagModel;
ADDRLP4 48
ADDRGP4 cgs+170516+20
INDIRI4
ASGNI4
line 203
;201:
;202:		// offset the origin y and z to center the flag
;203:		trap_R_ModelBounds( cm, mins, maxs );
ADDRLP4 48
INDIRI4
ARGI4
ADDRLP4 24
ARGP4
ADDRLP4 36
ARGP4
ADDRGP4 trap_R_ModelBounds
CALLV
pop
line 205
;204:
;205:		origin[2] = -0.5 * ( mins[2] + maxs[2] );
ADDRLP4 12+8
CNSTF4 3204448256
ADDRLP4 24+8
INDIRF4
ADDRLP4 36+8
INDIRF4
ADDF4
MULF4
ASGNF4
line 206
;206:		origin[1] = 0.5 * ( mins[1] + maxs[1] );
ADDRLP4 12+4
CNSTF4 1056964608
ADDRLP4 24+4
INDIRF4
ADDRLP4 36+4
INDIRF4
ADDF4
MULF4
ASGNF4
line 210
;207:
;208:		// calculate distance so the flag nearly fills the box
;209:		// assume heads are taller than wide
;210:		len = 0.5 * ( maxs[2] - mins[2] );		
ADDRLP4 52
CNSTF4 1056964608
ADDRLP4 36+8
INDIRF4
ADDRLP4 24+8
INDIRF4
SUBF4
MULF4
ASGNF4
line 211
;211:		origin[0] = len / 0.268;	// len / tan( fov/2 )
ADDRLP4 12
ADDRLP4 52
INDIRF4
CNSTF4 1049179980
DIVF4
ASGNF4
line 213
;212:
;213:		angles[YAW] = 60 * sin( cg.time / 2000.0 );;
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1157234688
DIVF4
ARGF4
ADDRLP4 60
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 0+4
CNSTF4 1114636288
ADDRLP4 60
INDIRF4
MULF4
ASGNF4
line 215
;214:
;215:		CG_Draw3DModel( x, y, w, h, 
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
ADDRFP4 16
INDIRI4
CNSTI4 1
NEI4 $192
ADDRLP4 64
ADDRGP4 cgs+170516+20
INDIRI4
ASGNI4
ADDRGP4 $193
JUMPV
LABELV $192
ADDRLP4 64
ADDRGP4 cgs+170516+24
INDIRI4
ASGNI4
LABELV $193
ADDRLP4 64
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 CG_Draw3DModel
CALLV
pop
line 218
;216:			team == TEAM_RED ? cgs.media.redFlagModel : cgs.media.blueFlagModel, 
;217:			0, origin, angles );
;218:	} else if ( cg_drawIcons.integer ) {
ADDRGP4 $171
JUMPV
LABELV $170
ADDRGP4 cg_drawIcons+12
INDIRI4
CNSTI4 0
EQI4 $194
line 219
;219:		gitem_t *item = BG_FindItemForPowerup( team == TEAM_RED ? PW_REDFLAG : PW_BLUEFLAG );
ADDRFP4 16
INDIRI4
CNSTI4 1
NEI4 $198
ADDRLP4 60
CNSTI4 7
ASGNI4
ADDRGP4 $199
JUMPV
LABELV $198
ADDRLP4 60
CNSTI4 8
ASGNI4
LABELV $199
ADDRLP4 60
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 56
ADDRLP4 64
INDIRP4
ASGNP4
line 221
;220:
;221:		CG_DrawPic( x, y, w, h, cg_items[ ITEM_INDEX(item) ].icon );
ADDRFP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRF4
ARGF4
ADDRFP4 8
INDIRF4
ARGF4
ADDRFP4 12
INDIRF4
ARGF4
CNSTI4 24
ADDRLP4 56
INDIRP4
CVPU4 4
ADDRGP4 bg_itemlist
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 56
DIVI4
MULI4
ADDRGP4 cg_items+20
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 222
;222:	}
LABELV $194
LABELV $171
line 223
;223:}
LABELV $169
endproc CG_DrawFlagModel 68 32
proc CG_DrawStatusBarHead 56 24
line 231
;224:
;225:/*
;226:================
;227:CG_DrawStatusBarHead
;228:
;229:================
;230:*/
;231:static void CG_DrawStatusBarHead( float x ) {
line 236
;232:	vec3_t		angles;
;233:	float		size, stretch;
;234:	float		frac;
;235:
;236:	VectorClear( angles );
ADDRLP4 24
CNSTF4 0
ASGNF4
ADDRLP4 4+8
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 4
ADDRLP4 24
INDIRF4
ASGNF4
line 238
;237:
;238:	if ( cg.damageTime && cg.time - cg.damageTime < DAMAGE_TIME ) {
ADDRGP4 cg+111944
INDIRF4
CNSTF4 0
EQF4 $204
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg+111944
INDIRF4
SUBF4
CNSTF4 1140457472
GEF4 $204
line 239
;239:		frac = (float)(cg.time - cg.damageTime ) / DAMAGE_TIME;
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg+111944
INDIRF4
SUBF4
CNSTF4 1140457472
DIVF4
ASGNF4
line 240
;240:		size = ICON_SIZE * 1.25 * ( 1.5 - frac * 0.5 );
ADDRLP4 16
CNSTF4 1114636288
CNSTF4 1069547520
CNSTF4 1056964608
ADDRLP4 0
INDIRF4
MULF4
SUBF4
MULF4
ASGNF4
line 242
;241:
;242:		stretch = size - ICON_SIZE * 1.25;
ADDRLP4 20
ADDRLP4 16
INDIRF4
CNSTF4 1114636288
SUBF4
ASGNF4
line 244
;243:		// kick in the direction of damage
;244:		x -= stretch * 0.5 + cg.damageX * stretch * 0.5;
ADDRLP4 28
CNSTF4 1056964608
ASGNF4
ADDRLP4 32
ADDRLP4 20
INDIRF4
ASGNF4
ADDRFP4 0
ADDRFP4 0
INDIRF4
ADDRLP4 28
INDIRF4
ADDRLP4 32
INDIRF4
MULF4
ADDRLP4 28
INDIRF4
ADDRGP4 cg+111948
INDIRF4
ADDRLP4 32
INDIRF4
MULF4
MULF4
ADDF4
SUBF4
ASGNF4
line 246
;245:
;246:		cg.headStartYaw = 180 + cg.damageX * 45;
ADDRGP4 cg+111980
CNSTF4 1110704128
ADDRGP4 cg+111948
INDIRF4
MULF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 248
;247:
;248:		cg.headEndYaw = 180 + 20 * cos( crandom()*M_PI );
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
CNSTF4 1078530011
CNSTF4 1073741824
ADDRLP4 36
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ARGF4
ADDRLP4 40
ADDRGP4 cos
CALLF4
ASGNF4
ADDRGP4 cg+111968
CNSTF4 1101004800
ADDRLP4 40
INDIRF4
MULF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 249
;249:		cg.headEndPitch = 5 * cos( crandom()*M_PI );
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
CNSTF4 1078530011
CNSTF4 1073741824
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ARGF4
ADDRLP4 48
ADDRGP4 cos
CALLF4
ASGNF4
ADDRGP4 cg+111964
CNSTF4 1084227584
ADDRLP4 48
INDIRF4
MULF4
ASGNF4
line 251
;250:
;251:		cg.headStartTime = cg.time;
ADDRGP4 cg+111984
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 252
;252:		cg.headEndTime = cg.time + 100 + random() * 2000;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRGP4 cg+111972
ADDRGP4 cg+105504
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
CNSTF4 1157234688
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 253
;253:	} else {
ADDRGP4 $205
JUMPV
LABELV $204
line 254
;254:		if ( cg.time >= cg.headEndTime ) {
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+111972
INDIRI4
LTI4 $220
line 256
;255:			// select a new head angle
;256:			cg.headStartYaw = cg.headEndYaw;
ADDRGP4 cg+111980
ADDRGP4 cg+111968
INDIRF4
ASGNF4
line 257
;257:			cg.headStartPitch = cg.headEndPitch;
ADDRGP4 cg+111976
ADDRGP4 cg+111964
INDIRF4
ASGNF4
line 258
;258:			cg.headStartTime = cg.headEndTime;
ADDRGP4 cg+111984
ADDRGP4 cg+111972
INDIRI4
ASGNI4
line 259
;259:			cg.headEndTime = cg.time + 100 + random() * 2000;
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRGP4 cg+111972
ADDRGP4 cg+105504
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
CNSTF4 1157234688
ADDRLP4 28
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 261
;260:
;261:			cg.headEndYaw = 180 + 20 * cos( crandom()*M_PI );
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
CNSTF4 1078530011
CNSTF4 1073741824
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ARGF4
ADDRLP4 36
ADDRGP4 cos
CALLF4
ASGNF4
ADDRGP4 cg+111968
CNSTF4 1101004800
ADDRLP4 36
INDIRF4
MULF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 262
;262:			cg.headEndPitch = 5 * cos( crandom()*M_PI );
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
CNSTF4 1078530011
CNSTF4 1073741824
ADDRLP4 40
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ARGF4
ADDRLP4 44
ADDRGP4 cos
CALLF4
ASGNF4
ADDRGP4 cg+111964
CNSTF4 1084227584
ADDRLP4 44
INDIRF4
MULF4
ASGNF4
line 263
;263:		}
LABELV $220
line 265
;264:
;265:		size = ICON_SIZE * 1.25;
ADDRLP4 16
CNSTF4 1114636288
ASGNF4
line 266
;266:	}
LABELV $205
line 269
;267:
;268:	// if the server was frozen for a while we may have a bad head start time
;269:	if ( cg.headStartTime > cg.time ) {
ADDRGP4 cg+111984
INDIRI4
ADDRGP4 cg+105504
INDIRI4
LEI4 $234
line 270
;270:		cg.headStartTime = cg.time;
ADDRGP4 cg+111984
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 271
;271:	}
LABELV $234
line 273
;272:
;273:	frac = ( cg.time - cg.headStartTime ) / (float)( cg.headEndTime - cg.headStartTime );
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+111984
INDIRI4
SUBI4
CVIF4 4
ADDRGP4 cg+111972
INDIRI4
ADDRGP4 cg+111984
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 274
;274:	frac = frac * frac * ( 3 - 2 * frac );
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
CNSTF4 1077936128
CNSTF4 1073741824
ADDRLP4 0
INDIRF4
MULF4
SUBF4
MULF4
ASGNF4
line 275
;275:	angles[YAW] = cg.headStartYaw + ( cg.headEndYaw - cg.headStartYaw ) * frac;
ADDRLP4 4+4
ADDRGP4 cg+111980
INDIRF4
ADDRGP4 cg+111968
INDIRF4
ADDRGP4 cg+111980
INDIRF4
SUBF4
ADDRLP4 0
INDIRF4
MULF4
ADDF4
ASGNF4
line 276
;276:	angles[PITCH] = cg.headStartPitch + ( cg.headEndPitch - cg.headStartPitch ) * frac;
ADDRLP4 4
ADDRGP4 cg+111976
INDIRF4
ADDRGP4 cg+111964
INDIRF4
ADDRGP4 cg+111976
INDIRF4
SUBF4
ADDRLP4 0
INDIRF4
MULF4
ADDF4
ASGNF4
line 278
;277:
;278:	CG_DrawHead( x, 480 - size, size, size, 
ADDRFP4 0
INDIRF4
ARGF4
CNSTF4 1139802112
ADDRLP4 16
INDIRF4
SUBF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
ADDRGP4 CG_DrawHead
CALLV
pop
line 280
;279:				cg.snap->ps.clientNum, angles );
;280:}
LABELV $201
endproc CG_DrawStatusBarHead 56 24
proc CG_DrawStatusBarFlag 4 20
line 288
;281:
;282:/*
;283:================
;284:CG_DrawStatusBarFlag
;285:
;286:================
;287:*/
;288:static void CG_DrawStatusBarFlag( float x, int team ) {
line 289
;289:	CG_DrawFlagModel( x, 480 - ICON_SIZE, ICON_SIZE, ICON_SIZE, team );
ADDRFP4 0
INDIRF4
ARGF4
CNSTF4 1138229248
ARGF4
ADDRLP4 0
CNSTF4 1111490560
ASGNF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 CG_DrawFlagModel
CALLV
pop
line 290
;290:}
LABELV $252
endproc CG_DrawStatusBarFlag 4 20
export CG_DrawTeamBackground
proc CG_DrawTeamBackground 16 20
line 300
;291:
;292:
;293:/*
;294:================
;295:CG_DrawTeamBackground
;296:
;297:================
;298:*/
;299:void CG_DrawTeamBackground( int x, int y, int w, int h, float alpha, int team )
;300:{
line 303
;301:	vec4_t		hcolor;
;302:
;303:	hcolor[3] = alpha;
ADDRLP4 0+12
ADDRFP4 16
INDIRF4
ASGNF4
line 304
;304:	if ( team == TEAM_RED ) {
ADDRFP4 20
INDIRI4
CNSTI4 1
NEI4 $255
line 305
;305:		hcolor[0] = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 306
;306:		hcolor[1] = 0;
ADDRLP4 0+4
CNSTF4 0
ASGNF4
line 307
;307:		hcolor[2] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 308
;308:	} else if ( team == TEAM_BLUE ) {
ADDRGP4 $256
JUMPV
LABELV $255
ADDRFP4 20
INDIRI4
CNSTI4 2
NEI4 $253
line 309
;309:		hcolor[0] = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 310
;310:		hcolor[1] = 0;
ADDRLP4 0+4
CNSTF4 0
ASGNF4
line 311
;311:		hcolor[2] = 1;
ADDRLP4 0+8
CNSTF4 1065353216
ASGNF4
line 312
;312:	} else {
line 313
;313:		return; // no team
LABELV $260
LABELV $256
line 315
;314:	}
;315:	trap_R_SetColor( hcolor );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 316
;316:	CG_DrawPic( x, y, w, h, cgs.media.teamStatusBar );
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 4
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 8
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRGP4 cgs+170516+60
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 317
;317:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 318
;318:}
LABELV $253
endproc CG_DrawTeamBackground 16 20
data
align 4
LABELV $266
byte 4 1065353216
byte 4 1060152279
byte 4 0
byte 4 1065353216
byte 4 1065353216
byte 4 1045220557
byte 4 1045220557
byte 4 1065353216
byte 4 1056964608
byte 4 1056964608
byte 4 1056964608
byte 4 1065353216
byte 4 1065353216
byte 4 1065353216
byte 4 1065353216
byte 4 1065353216
code
proc CG_DrawStatusBar 72 32
line 326
;319:
;320:/*
;321:================
;322:CG_DrawStatusBar
;323:
;324:================
;325:*/
;326:static void CG_DrawStatusBar( void ) {
line 341
;327:	int			color;
;328:	centity_t	*cent;
;329:	playerState_t	*ps;
;330:	int			value;
;331:	vec4_t		hcolor;
;332:	vec3_t		angles;
;333:	vec3_t		origin;
;334:	static float colors[4][4] = { 
;335://		{ 0.2, 1.0, 0.2, 1.0 } , { 1.0, 0.2, 0.2, 1.0 }, {0.5, 0.5, 0.5, 1} };
;336:		{ 1, 0.69, 0, 1.0 } ,		// normal
;337:		{ 1.0, 0.2, 0.2, 1.0 },		// low health
;338:		{0.5, 0.5, 0.5, 1},			// weapon firing
;339:		{ 1, 1, 1, 1 } };			// health > 100
;340:
;341:	if ( cg_drawStatus.integer == 0 ) {
ADDRGP4 cg_drawStatus+12
INDIRI4
CNSTI4 0
NEI4 $267
line 342
;342:		return;
ADDRGP4 $265
JUMPV
LABELV $267
line 346
;343:	}
;344:
;345:	// draw the team background
;346:	CG_DrawTeamBackground( 0, 420, 640, 60, 0.33, cg.snap->ps.persistant[PERS_TEAM] );
CNSTI4 0
ARGI4
CNSTI4 420
ARGI4
CNSTI4 640
ARGI4
CNSTI4 60
ARGI4
CNSTF4 1051260355
ARGF4
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawTeamBackground
CALLV
pop
line 348
;347:
;348:	cent = &cg_entities[cg.snap->ps.clientNum];
ADDRLP4 20
CNSTI4 680
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 349
;349:	ps = &cg.snap->ps;
ADDRLP4 16
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
line 351
;350:
;351:	VectorClear( angles );
ADDRLP4 56
CNSTF4 0
ASGNF4
ADDRLP4 4+8
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 4
ADDRLP4 56
INDIRF4
ASGNF4
line 354
;352:
;353:	// draw any 3D icons first, so the changes back to 2D are minimized
;354:	if ( cent->currentState.weapon ) {//&& cg_weapons[ cent->currentState.weapon ].ammoModel ) {
ADDRLP4 20
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 0
EQI4 $275
line 355
;355:		origin[0] = 70; // was 70
ADDRLP4 24
CNSTF4 1116471296
ASGNF4
line 356
;356:		origin[1] = 0;
ADDRLP4 24+4
CNSTF4 0
ASGNF4
line 357
;357:		origin[2] = 0;
ADDRLP4 24+8
CNSTF4 0
ASGNF4
line 358
;358:		angles[YAW] = 270 + 20 * sin( cg.time / 1000.0 ); // was 90, now 270
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ARGF4
ADDRLP4 60
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 4+4
CNSTF4 1101004800
ADDRLP4 60
INDIRF4
MULF4
CNSTF4 1132920832
ADDF4
ASGNF4
line 359
;359:		CG_Draw3DModel( CHAR_WIDTH*3 + TEXT_ICON_SPACE - 16, 432 - 16, ICON_SIZE * 1.5, ICON_SIZE * 1.5,
CNSTF4 1118306304
ARGF4
CNSTF4 1137704960
ARGF4
ADDRLP4 64
CNSTF4 1116733440
ASGNF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
CNSTI4 132
ADDRLP4 20
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons+12
ADDP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 24
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 CG_Draw3DModel
CALLV
pop
line 361
;360:					   cg_weapons[ cent->currentState.weapon ].weaponModel, 0, origin, angles ); // was .ammoModel, now .weaponModel
;361:	}
LABELV $275
line 363
;362:
;363:	CG_DrawStatusBarHead( 185 + CHAR_WIDTH*3 + TEXT_ICON_SPACE );
CNSTF4 1133412352
ARGF4
ADDRGP4 CG_DrawStatusBarHead
CALLV
pop
line 365
;364:
;365:	if (cg.predictedPlayerState.powerups[PW_REDFLAG])
ADDRGP4 cg+105532+312+28
INDIRI4
CNSTI4 0
EQI4 $282
line 366
;366:		CG_DrawStatusBarFlag( 185 + CHAR_WIDTH*3 + TEXT_ICON_SPACE + ICON_SIZE, TEAM_RED);
CNSTF4 1134985216
ARGF4
CNSTI4 1
ARGI4
ADDRGP4 CG_DrawStatusBarFlag
CALLV
pop
ADDRGP4 $283
JUMPV
LABELV $282
line 367
;367:	else if (cg.predictedPlayerState.powerups[PW_BLUEFLAG])
ADDRGP4 cg+105532+312+32
INDIRI4
CNSTI4 0
EQI4 $287
line 368
;368:		CG_DrawStatusBarFlag( 185 + CHAR_WIDTH*3 + TEXT_ICON_SPACE + ICON_SIZE, TEAM_BLUE);
CNSTF4 1134985216
ARGF4
CNSTI4 2
ARGI4
ADDRGP4 CG_DrawStatusBarFlag
CALLV
pop
LABELV $287
LABELV $283
line 370
;369:
;370:	if ( ps->stats[ STAT_ARMOR ] ) {
ADDRLP4 16
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
CNSTI4 0
EQI4 $292
line 371
;371:		origin[0] = 90;
ADDRLP4 24
CNSTF4 1119092736
ASGNF4
line 372
;372:		origin[1] = 0;
ADDRLP4 24+4
CNSTF4 0
ASGNF4
line 373
;373:		origin[2] = -10;
ADDRLP4 24+8
CNSTF4 3240099840
ASGNF4
line 374
;374:		angles[YAW] = ( cg.time & 2047 ) * 360 / 2048.0;
ADDRLP4 4+4
CNSTI4 360
ADDRGP4 cg+105504
INDIRI4
CNSTI4 2047
BANDI4
MULI4
CVIF4 4
CNSTF4 1157627904
DIVF4
ASGNF4
line 375
;375:		CG_Draw3DModel( 370 + CHAR_WIDTH*3 + TEXT_ICON_SPACE, 432, ICON_SIZE, ICON_SIZE,
CNSTF4 1139474432
ARGF4
CNSTF4 1138229248
ARGF4
ADDRLP4 60
CNSTF4 1111490560
ASGNF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRGP4 cgs+170516+52
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 24
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 CG_Draw3DModel
CALLV
pop
line 377
;376:					   cgs.media.armorModel, 0, origin, angles );
;377:	}
LABELV $292
line 382
;378:
;379:	//
;380:	// ammo
;381:	//
;382:	if ( cent->currentState.weapon ) {
ADDRLP4 20
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 0
EQI4 $300
line 383
;383:		value = ps->ammo[cent->currentState.weapon];
ADDRLP4 0
ADDRLP4 20
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
ASGNI4
line 384
;384:		if ( value > -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
LEI4 $302
line 385
;385:			if ( cg.predictedPlayerState.weaponstate == WEAPON_FIRING
ADDRGP4 cg+105532+148
INDIRI4
CNSTI4 3
NEI4 $304
ADDRGP4 cg+105532+44
INDIRI4
CNSTI4 100
LEI4 $304
line 386
;386:				&& cg.predictedPlayerState.weaponTime > 100 ) {
line 388
;387:				// draw as dark grey when reloading
;388:				color = 2;	// dark grey
ADDRLP4 52
CNSTI4 2
ASGNI4
line 389
;389:			} else {
ADDRGP4 $305
JUMPV
LABELV $304
line 390
;390:				if ( value >= 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $310
line 391
;391:					color = 0;	// green
ADDRLP4 52
CNSTI4 0
ASGNI4
line 392
;392:				} else {
ADDRGP4 $311
JUMPV
LABELV $310
line 393
;393:					color = 1;	// red
ADDRLP4 52
CNSTI4 1
ASGNI4
line 394
;394:				}
LABELV $311
line 395
;395:			}
LABELV $305
line 396
;396:			trap_R_SetColor( colors[color] );
ADDRLP4 52
INDIRI4
CNSTI4 4
LSHI4
ADDRGP4 $266
ADDP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 398
;397:			
;398:			CG_DrawField (0, 432, 3, value);
CNSTI4 0
ARGI4
CNSTI4 432
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_DrawField
CALLV
pop
line 399
;399:			trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 402
;400:
;401:			// if we didn't draw a 3D icon, draw a 2D icon for ammo
;402:			if ( !cg_draw3dIcons.integer && cg_drawIcons.integer ) {
ADDRLP4 60
CNSTI4 0
ASGNI4
ADDRGP4 cg_draw3dIcons+12
INDIRI4
ADDRLP4 60
INDIRI4
NEI4 $312
ADDRGP4 cg_drawIcons+12
INDIRI4
ADDRLP4 60
INDIRI4
EQI4 $312
line 405
;403:				qhandle_t	icon;
;404:
;405:				icon = cg_weapons[ cg.predictedPlayerState.weapon ].ammoIcon;
ADDRLP4 64
CNSTI4 132
ADDRGP4 cg+105532+144
INDIRI4
MULI4
ADDRGP4 cg_weapons+72
ADDP4
INDIRI4
ASGNI4
line 406
;406:				if ( icon ) {
ADDRLP4 64
INDIRI4
CNSTI4 0
EQI4 $319
line 407
;407:					CG_DrawPic( CHAR_WIDTH*3 + TEXT_ICON_SPACE, 432, ICON_SIZE, ICON_SIZE, icon );
CNSTF4 1120403456
ARGF4
CNSTF4 1138229248
ARGF4
ADDRLP4 68
CNSTF4 1111490560
ASGNF4
ADDRLP4 68
INDIRF4
ARGF4
ADDRLP4 68
INDIRF4
ARGF4
ADDRLP4 64
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 408
;408:				}
LABELV $319
line 409
;409:			}
LABELV $312
line 410
;410:		}
LABELV $302
line 411
;411:	}
LABELV $300
line 416
;412:
;413:	//
;414:	// health
;415:	//
;416:	value = ps->stats[STAT_HEALTH];
ADDRLP4 0
ADDRLP4 16
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ASGNI4
line 417
;417:	if ( value > 100 ) {
ADDRLP4 0
INDIRI4
CNSTI4 100
LEI4 $321
line 418
;418:		trap_R_SetColor( colors[3] );		// white
ADDRGP4 $266+48
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 419
;419:	} else if (value > 25) {
ADDRGP4 $322
JUMPV
LABELV $321
ADDRLP4 0
INDIRI4
CNSTI4 25
LEI4 $324
line 420
;420:		trap_R_SetColor( colors[0] );	// green
ADDRGP4 $266
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 421
;421:	} else if (value > 0) {
ADDRGP4 $325
JUMPV
LABELV $324
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $326
line 422
;422:		color = (cg.time >> 8) & 1;	// flash
ADDRLP4 52
ADDRGP4 cg+105504
INDIRI4
CNSTI4 8
RSHI4
CNSTI4 1
BANDI4
ASGNI4
line 423
;423:		trap_R_SetColor( colors[color] );
ADDRLP4 52
INDIRI4
CNSTI4 4
LSHI4
ADDRGP4 $266
ADDP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 424
;424:	} else {
ADDRGP4 $327
JUMPV
LABELV $326
line 425
;425:		trap_R_SetColor( colors[1] );	// red
ADDRGP4 $266+16
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 426
;426:	}
LABELV $327
LABELV $325
LABELV $322
line 429
;427:
;428:	// stretch the health up when taking damage
;429:	CG_DrawField ( 185, 432, 3, value);
CNSTI4 185
ARGI4
CNSTI4 432
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_DrawField
CALLV
pop
line 430
;430:	CG_ColorForHealth( hcolor );
ADDRLP4 36
ARGP4
ADDRGP4 CG_ColorForHealth
CALLV
pop
line 431
;431:	trap_R_SetColor( hcolor );
ADDRLP4 36
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 437
;432:
;433:
;434:	//
;435:	// armor
;436:	//
;437:	value = ps->stats[STAT_ARMOR];
ADDRLP4 0
ADDRLP4 16
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ASGNI4
line 438
;438:	if (value > 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $330
line 439
;439:		trap_R_SetColor( colors[0] );
ADDRGP4 $266
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 440
;440:		CG_DrawField (370, 432, 3, value);
CNSTI4 370
ARGI4
CNSTI4 432
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_DrawField
CALLV
pop
line 441
;441:		trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 443
;442:		// if we didn't draw a 3D icon, draw a 2D icon for armor
;443:		if ( !cg_draw3dIcons.integer && cg_drawIcons.integer ) {
ADDRLP4 60
CNSTI4 0
ASGNI4
ADDRGP4 cg_draw3dIcons+12
INDIRI4
ADDRLP4 60
INDIRI4
NEI4 $332
ADDRGP4 cg_drawIcons+12
INDIRI4
ADDRLP4 60
INDIRI4
EQI4 $332
line 444
;444:			CG_DrawPic( 370 + CHAR_WIDTH*3 + TEXT_ICON_SPACE, 432, ICON_SIZE, ICON_SIZE, cgs.media.armorIcon );
CNSTF4 1139474432
ARGF4
CNSTF4 1138229248
ARGF4
ADDRLP4 64
CNSTF4 1111490560
ASGNF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRGP4 cgs+170516+56
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 445
;445:		}
LABELV $332
line 447
;446:
;447:	}
LABELV $330
line 448
;448:}
LABELV $265
endproc CG_DrawStatusBar 72 32
proc CG_DrawAttacker 52 24
line 464
;449:
;450:/*
;451:===========================================================================================
;452:
;453:  UPPER RIGHT CORNER
;454:
;455:===========================================================================================
;456:*/
;457:
;458:/*
;459:================
;460:CG_DrawAttacker
;461:
;462:================
;463:*/
;464:static float CG_DrawAttacker( float y ) {
line 472
;465:	int			t;
;466:	float		size;
;467:	vec3_t		angles;
;468:	const char	*info;
;469:	const char	*name;
;470:	int			clientNum;
;471:
;472:	if ( cg.predictedPlayerState.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+105532+184
INDIRI4
CNSTI4 0
GTI4 $339
line 473
;473:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $338
JUMPV
LABELV $339
line 476
;474:	}
;475:
;476:	if ( !cg.attackerTime ) {
ADDRGP4 cg+111896
INDIRI4
CNSTI4 0
NEI4 $343
line 477
;477:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $338
JUMPV
LABELV $343
line 480
;478:	}
;479:
;480:	clientNum = cg.predictedPlayerState.persistant[PERS_ATTACKER];
ADDRLP4 0
ADDRGP4 cg+105532+248+28
INDIRI4
ASGNI4
line 481
;481:	if ( clientNum < 0 || clientNum >= MAX_CLIENTS || clientNum == cg.snap->ps.clientNum ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $353
ADDRLP4 0
INDIRI4
CNSTI4 128
GEI4 $353
ADDRLP4 0
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
NEI4 $349
LABELV $353
line 482
;482:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $338
JUMPV
LABELV $349
line 485
;483:	}
;484:
;485:	t = cg.time - cg.attackerTime;
ADDRLP4 24
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+111896
INDIRI4
SUBI4
ASGNI4
line 486
;486:	if ( t > ATTACKER_HEAD_TIME ) {
ADDRLP4 24
INDIRI4
CNSTI4 10000
LEI4 $356
line 487
;487:		cg.attackerTime = 0;
ADDRGP4 cg+111896
CNSTI4 0
ASGNI4
line 488
;488:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $338
JUMPV
LABELV $356
line 491
;489:	}
;490:
;491:	size = ICON_SIZE * 1.25;
ADDRLP4 4
CNSTF4 1114636288
ASGNF4
line 493
;492:
;493:	angles[PITCH] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
line 494
;494:	angles[YAW] = 180;
ADDRLP4 8+4
CNSTF4 1127481344
ASGNF4
line 495
;495:	angles[ROLL] = 0;
ADDRLP4 8+8
CNSTF4 0
ASGNF4
line 496
;496:	CG_DrawHead( 640 - size, y, size, size, clientNum, angles );
CNSTF4 1142947840
ADDRLP4 4
INDIRF4
SUBF4
ARGF4
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
ADDRGP4 CG_DrawHead
CALLV
pop
line 498
;497:
;498:	info = CG_ConfigString( CS_PLAYERS + clientNum );
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 40
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 28
ADDRLP4 40
INDIRP4
ASGNP4
line 499
;499:	name = Info_ValueForKey(  info, "n" );
ADDRLP4 28
INDIRP4
ARGP4
ADDRGP4 $361
ARGP4
ADDRLP4 44
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 20
ADDRLP4 44
INDIRP4
ASGNP4
line 500
;500:	y += size;
ADDRFP4 0
ADDRFP4 0
INDIRF4
ADDRLP4 4
INDIRF4
ADDF4
ASGNF4
line 501
;501:	CG_DrawBigString( 640 - ( Q_PrintStrlen( name ) * BIGCHAR_WIDTH), y, name, 0.5 );
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 48
ADDRGP4 Q_PrintStrlen
CALLI4
ASGNI4
CNSTI4 640
ADDRLP4 48
INDIRI4
CNSTI4 4
LSHI4
SUBI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 20
INDIRP4
ARGP4
CNSTF4 1056964608
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 503
;502:
;503:	return y + BIGCHAR_HEIGHT + 2;
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
ADDF4
CNSTF4 1073741824
ADDF4
RETF4
LABELV $338
endproc CG_DrawAttacker 52 24
proc CG_DrawSnapshot 16 16
line 511
;504:}
;505:
;506:/*
;507:==================
;508:CG_DrawSnapshot
;509:==================
;510:*/
;511:static float CG_DrawSnapshot( float y ) {
line 515
;512:	char		*s;
;513:	int			w;
;514:
;515:	s = va( "time:%i snap:%i cmd:%i", cg.snap->serverTime, 
ADDRGP4 $363
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 cg+24
INDIRI4
ARGI4
ADDRGP4 cgs+24276
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 517
;516:		cg.latestSnapshotNum, cgs.serverCommandSequence );
;517:	w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 12
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 519
;518:
;519:	CG_DrawBigString( 635 - w, y + 2, s, 1.0F);
CNSTI4 635
ADDRLP4 4
INDIRI4
SUBI4
ARGI4
ADDRFP4 0
INDIRF4
CNSTF4 1073741824
ADDF4
CVFI4 4
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 521
;520:
;521:	return y + BIGCHAR_HEIGHT + 4;
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
ADDF4
CNSTF4 1082130432
ADDF4
RETF4
LABELV $362
endproc CG_DrawSnapshot 16 16
bss
align 4
LABELV $368
skip 16
align 4
LABELV $369
skip 4
align 4
LABELV $370
skip 4
code
proc CG_DrawFPS 44 16
line 530
;522:}
;523:
;524:/*
;525:==================
;526:CG_DrawFPS
;527:==================
;528:*/
;529:#define	FPS_FRAMES	4
;530:static float CG_DrawFPS( float y ) {
line 542
;531:	char		*s;
;532:	int			w;
;533:	static int	previousTimes[FPS_FRAMES];
;534:	static int	index;
;535:	int		i, total;
;536:	int		fps;
;537:	static	int	previous;
;538:	int		t, frameTime;
;539:
;540:	// don't use serverTime, because that will be drifting to
;541:	// correct for internet lag changes, timescales, timedemos, etc
;542:	t = trap_Milliseconds();
ADDRLP4 28
ADDRGP4 trap_Milliseconds
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 28
INDIRI4
ASGNI4
line 543
;543:	frameTime = t - previous;
ADDRLP4 12
ADDRLP4 8
INDIRI4
ADDRGP4 $370
INDIRI4
SUBI4
ASGNI4
line 544
;544:	previous = t;
ADDRGP4 $370
ADDRLP4 8
INDIRI4
ASGNI4
line 546
;545:
;546:	previousTimes[index % FPS_FRAMES] = frameTime;
ADDRGP4 $369
INDIRI4
CNSTI4 4
MODI4
CNSTI4 2
LSHI4
ADDRGP4 $368
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 547
;547:	index++;
ADDRLP4 32
ADDRGP4 $369
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 548
;548:	if ( index > FPS_FRAMES ) {
ADDRGP4 $369
INDIRI4
CNSTI4 4
LEI4 $371
line 550
;549:		// average multiple frames together to smooth changes out a bit
;550:		total = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 551
;551:		for ( i = 0 ; i < FPS_FRAMES ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $373
line 552
;552:			total += previousTimes[i];
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $368
ADDP4
INDIRI4
ADDI4
ASGNI4
line 553
;553:		}
LABELV $374
line 551
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 4
LTI4 $373
line 554
;554:		if ( !total ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $377
line 555
;555:			total = 1;
ADDRLP4 4
CNSTI4 1
ASGNI4
line 556
;556:		}
LABELV $377
line 557
;557:		fps = 1000 * FPS_FRAMES / total;
ADDRLP4 24
CNSTI4 4000
ADDRLP4 4
INDIRI4
DIVI4
ASGNI4
line 559
;558:
;559:		s = va( "%ifps", fps );
ADDRGP4 $379
ARGP4
ADDRLP4 24
INDIRI4
ARGI4
ADDRLP4 36
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 36
INDIRP4
ASGNP4
line 560
;560:		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 40
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 562
;561:
;562:		CG_DrawBigString( 635 - w, y + 2, s, 1.0F);
CNSTI4 635
ADDRLP4 20
INDIRI4
SUBI4
ARGI4
ADDRFP4 0
INDIRF4
CNSTF4 1073741824
ADDF4
CVFI4 4
ARGI4
ADDRLP4 16
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 563
;563:	}
LABELV $371
line 565
;564:
;565:	return y + BIGCHAR_HEIGHT + 4;
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
ADDF4
CNSTF4 1082130432
ADDF4
RETF4
LABELV $367
endproc CG_DrawFPS 44 16
proc CG_DrawTimer 32 16
line 573
;566:}
;567:
;568:/*
;569:=================
;570:CG_DrawTimer
;571:=================
;572:*/
;573:static float CG_DrawTimer( float y ) {
line 579
;574:	char		*s;
;575:	int			w;
;576:	int			mins, seconds, tens;
;577:	int			msec;
;578:
;579:	msec = cg.time - cgs.levelStartTime;
ADDRLP4 20
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cgs+24652
INDIRI4
SUBI4
ASGNI4
line 581
;580:
;581:	seconds = msec / 1000;
ADDRLP4 0
ADDRLP4 20
INDIRI4
CNSTI4 1000
DIVI4
ASGNI4
line 582
;582:	mins = seconds / 60;
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 60
DIVI4
ASGNI4
line 583
;583:	seconds -= mins * 60;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 60
ADDRLP4 8
INDIRI4
MULI4
SUBI4
ASGNI4
line 584
;584:	tens = seconds / 10;
ADDRLP4 12
ADDRLP4 0
INDIRI4
CNSTI4 10
DIVI4
ASGNI4
line 585
;585:	seconds -= tens * 10;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 10
ADDRLP4 12
INDIRI4
MULI4
SUBI4
ASGNI4
line 587
;586:
;587:	s = va( "%i:%i%i", mins, tens, seconds );
ADDRGP4 $383
ARGP4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 24
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 24
INDIRP4
ASGNP4
line 588
;588:	w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 28
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 590
;589:
;590:	CG_DrawBigString( 635 - w, y + 2, s, 1.0F);
CNSTI4 635
ADDRLP4 16
INDIRI4
SUBI4
ARGI4
ADDRFP4 0
INDIRF4
CNSTF4 1073741824
ADDF4
CVFI4 4
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 592
;591:
;592:	return y + BIGCHAR_HEIGHT + 4;
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
ADDF4
CNSTF4 1082130432
ADDF4
RETF4
LABELV $380
endproc CG_DrawTimer 32 16
proc CG_DrawTeamOverlay 140 36
line 605
;593:}
;594:
;595:
;596:/*
;597:=================
;598:CG_DrawTeamOverlay
;599:=================
;600:*/
;601:
;602:#define TEAM_OVERLAY_MAXNAME_WIDTH	12
;603:#define TEAM_OVERLAY_MAXLOCATION_WIDTH	16
;604:
;605:static float CG_DrawTeamOverlay( float y, qboolean right, qboolean upper ) {
line 616
;606:	int x, w, h, xx;
;607:	int i, j, len;
;608:	const char *p;
;609:	vec4_t		hcolor;
;610:	int pwidth, lwidth;
;611:	int plyrs;
;612:	char st[16];
;613:	clientInfo_t *ci;
;614:	int ret_y;
;615:
;616:	if ( !cg_drawTeamOverlay.integer ) {
ADDRGP4 cg_drawTeamOverlay+12
INDIRI4
CNSTI4 0
NEI4 $385
line 617
;617:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $384
JUMPV
LABELV $385
line 620
;618:	}
;619:
;620:	if ( cg.snap->ps.persistant[PERS_TEAM] != TEAM_RED &&
ADDRLP4 84
CNSTI4 304
ASGNI4
ADDRGP4 cg+32
INDIRP4
ADDRLP4 84
INDIRI4
ADDP4
INDIRI4
CNSTI4 1
EQI4 $388
ADDRGP4 cg+32
INDIRP4
ADDRLP4 84
INDIRI4
ADDP4
INDIRI4
CNSTI4 2
EQI4 $388
line 622
;621:		cg.snap->ps.persistant[PERS_TEAM] != TEAM_BLUE )
;622:		return y; // Not on any team
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $384
JUMPV
LABELV $388
line 624
;623:
;624:	plyrs = 0;
ADDRLP4 68
CNSTI4 0
ASGNI4
line 627
;625:
;626:	// max player name width
;627:	pwidth = 0;
ADDRLP4 48
CNSTI4 0
ASGNI4
line 628
;628:	for (i = 0; i < numSortedTeamPlayers; i++) {
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $395
JUMPV
LABELV $392
line 629
;629:		ci = cgs.clientinfo + sortedTeamPlayers[i];
ADDRLP4 4
CNSTI4 1076
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 sortedTeamPlayers
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 630
;630:		if ( ci->infoValid && ci->team == cg.snap->ps.persistant[PERS_TEAM]) {
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $397
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
NEI4 $397
line 631
;631:			plyrs++;
ADDRLP4 68
ADDRLP4 68
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 632
;632:			len = CG_DrawStrlen(ci->name);
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 92
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 92
INDIRI4
ASGNI4
line 633
;633:			if (len > pwidth)
ADDRLP4 36
INDIRI4
ADDRLP4 48
INDIRI4
LEI4 $400
line 634
;634:				pwidth = len;
ADDRLP4 48
ADDRLP4 36
INDIRI4
ASGNI4
LABELV $400
line 635
;635:		}
LABELV $397
line 636
;636:	}
LABELV $393
line 628
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $395
ADDRLP4 8
INDIRI4
ADDRGP4 numSortedTeamPlayers
INDIRI4
LTI4 $392
line 638
;637:
;638:	if (!plyrs)
ADDRLP4 68
INDIRI4
CNSTI4 0
NEI4 $402
line 639
;639:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $384
JUMPV
LABELV $402
line 641
;640:
;641:	if (pwidth > TEAM_OVERLAY_MAXNAME_WIDTH)
ADDRLP4 48
INDIRI4
CNSTI4 12
LEI4 $404
line 642
;642:		pwidth = TEAM_OVERLAY_MAXNAME_WIDTH;
ADDRLP4 48
CNSTI4 12
ASGNI4
LABELV $404
line 645
;643:
;644:	// max location name width
;645:	lwidth = 0;
ADDRLP4 40
CNSTI4 0
ASGNI4
line 646
;646:	for (i = 1; i < MAX_LOCATIONS; i++) {
ADDRLP4 8
CNSTI4 1
ASGNI4
LABELV $406
line 647
;647:		p = CG_ConfigString(CS_LOCATIONS + i);
ADDRLP4 8
INDIRI4
CNSTI4 672
ADDI4
ARGI4
ADDRLP4 88
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 88
INDIRP4
ASGNP4
line 648
;648:		if (p && *p) {
ADDRLP4 16
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $410
ADDRLP4 16
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $410
line 649
;649:			len = CG_DrawStrlen(p);
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 96
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 96
INDIRI4
ASGNI4
line 650
;650:			if (len > lwidth)
ADDRLP4 36
INDIRI4
ADDRLP4 40
INDIRI4
LEI4 $412
line 651
;651:				lwidth = len;
ADDRLP4 40
ADDRLP4 36
INDIRI4
ASGNI4
LABELV $412
line 652
;652:		}
LABELV $410
line 653
;653:	}
LABELV $407
line 646
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 64
LTI4 $406
line 655
;654:
;655:	if (lwidth > TEAM_OVERLAY_MAXLOCATION_WIDTH)
ADDRLP4 40
INDIRI4
CNSTI4 16
LEI4 $414
line 656
;656:		lwidth = TEAM_OVERLAY_MAXLOCATION_WIDTH;
ADDRLP4 40
CNSTI4 16
ASGNI4
LABELV $414
line 658
;657:
;658:	w = (pwidth + lwidth + 4 + 7) * TINYCHAR_WIDTH;
ADDRLP4 72
ADDRLP4 48
INDIRI4
ADDRLP4 40
INDIRI4
ADDI4
CNSTI4 3
LSHI4
CNSTI4 32
ADDI4
CNSTI4 56
ADDI4
ASGNI4
line 660
;659:
;660:	if ( right )
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $416
line 661
;661:		x = 640 - w;
ADDRLP4 44
CNSTI4 640
ADDRLP4 72
INDIRI4
SUBI4
ASGNI4
ADDRGP4 $417
JUMPV
LABELV $416
line 663
;662:	else
;663:		x = 0;
ADDRLP4 44
CNSTI4 0
ASGNI4
LABELV $417
line 665
;664:
;665:	h = plyrs * TINYCHAR_HEIGHT;
ADDRLP4 76
ADDRLP4 68
INDIRI4
CNSTI4 3
LSHI4
ASGNI4
line 667
;666:
;667:	if ( upper ) {
ADDRFP4 8
INDIRI4
CNSTI4 0
EQI4 $418
line 668
;668:		ret_y = y + h;
ADDRLP4 80
ADDRFP4 0
INDIRF4
ADDRLP4 76
INDIRI4
CVIF4 4
ADDF4
CVFI4 4
ASGNI4
line 669
;669:	} else {
ADDRGP4 $419
JUMPV
LABELV $418
line 670
;670:		y -= h;
ADDRFP4 0
ADDRFP4 0
INDIRF4
ADDRLP4 76
INDIRI4
CVIF4 4
SUBF4
ASGNF4
line 671
;671:		ret_y = y;
ADDRLP4 80
ADDRFP4 0
INDIRF4
CVFI4 4
ASGNI4
line 672
;672:	}
LABELV $419
line 674
;673:
;674:	if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_RED ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 1
NEI4 $420
line 675
;675:		hcolor[0] = 1;
ADDRLP4 20
CNSTF4 1065353216
ASGNF4
line 676
;676:		hcolor[1] = 0;
ADDRLP4 20+4
CNSTF4 0
ASGNF4
line 677
;677:		hcolor[2] = 0;
ADDRLP4 20+8
CNSTF4 0
ASGNF4
line 678
;678:		hcolor[3] = 0.33;
ADDRLP4 20+12
CNSTF4 1051260355
ASGNF4
line 679
;679:	} else { // if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_BLUE )
ADDRGP4 $421
JUMPV
LABELV $420
line 680
;680:		hcolor[0] = 0;
ADDRLP4 20
CNSTF4 0
ASGNF4
line 681
;681:		hcolor[1] = 0;
ADDRLP4 20+4
CNSTF4 0
ASGNF4
line 682
;682:		hcolor[2] = 1;
ADDRLP4 20+8
CNSTF4 1065353216
ASGNF4
line 683
;683:		hcolor[3] = 0.33;
ADDRLP4 20+12
CNSTF4 1051260355
ASGNF4
line 684
;684:	}
LABELV $421
line 685
;685:	trap_R_SetColor( hcolor );
ADDRLP4 20
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 686
;686:	CG_DrawPic( x, y, w, h, cgs.media.teamStatusBar );
ADDRLP4 44
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 72
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 76
INDIRI4
CVIF4 4
ARGF4
ADDRGP4 cgs+170516+60
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 687
;687:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 689
;688:
;689:	for (i = 0; i < numSortedTeamPlayers; i++) {
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $434
JUMPV
LABELV $431
line 690
;690:		ci = cgs.clientinfo + sortedTeamPlayers[i];
ADDRLP4 4
CNSTI4 1076
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 sortedTeamPlayers
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 691
;691:		if ( ci->infoValid && ci->team == cg.snap->ps.persistant[PERS_TEAM]) {
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $436
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
NEI4 $436
line 693
;692:
;693:			hcolor[0] = hcolor[1] = hcolor[2] = hcolor[3] = 1.0;
ADDRLP4 92
CNSTF4 1065353216
ASGNF4
ADDRLP4 20+12
ADDRLP4 92
INDIRF4
ASGNF4
ADDRLP4 20+8
ADDRLP4 92
INDIRF4
ASGNF4
ADDRLP4 20+4
ADDRLP4 92
INDIRF4
ASGNF4
ADDRLP4 20
ADDRLP4 92
INDIRF4
ASGNF4
line 695
;694:
;695:			xx = x + TINYCHAR_WIDTH;
ADDRLP4 12
ADDRLP4 44
INDIRI4
CNSTI4 8
ADDI4
ASGNI4
line 697
;696:
;697:			CG_DrawStringExt( xx, y,
ADDRLP4 12
INDIRI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 96
CNSTI4 0
ASGNI4
ADDRLP4 96
INDIRI4
ARGI4
ADDRLP4 96
INDIRI4
ARGI4
ADDRLP4 100
CNSTI4 8
ASGNI4
ADDRLP4 100
INDIRI4
ARGI4
ADDRLP4 100
INDIRI4
ARGI4
CNSTI4 12
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 701
;698:				ci->name, hcolor, qfalse, qfalse,
;699:				TINYCHAR_WIDTH, TINYCHAR_HEIGHT, TEAM_OVERLAY_MAXNAME_WIDTH);
;700:
;701:			if (lwidth) {
ADDRLP4 40
INDIRI4
CNSTI4 0
EQI4 $442
line 702
;702:				p = CG_ConfigString(CS_LOCATIONS + ci->location);
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRI4
CNSTI4 672
ADDI4
ARGI4
ADDRLP4 104
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 16
ADDRLP4 104
INDIRP4
ASGNP4
line 703
;703:				if (!p || !*p)
ADDRLP4 16
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $446
ADDRLP4 16
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $444
LABELV $446
line 704
;704:					p = "unknown";
ADDRLP4 16
ADDRGP4 $447
ASGNP4
LABELV $444
line 705
;705:				len = CG_DrawStrlen(p);
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 112
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 112
INDIRI4
ASGNI4
line 706
;706:				if (len > lwidth)
ADDRLP4 36
INDIRI4
ADDRLP4 40
INDIRI4
LEI4 $448
line 707
;707:					len = lwidth;
ADDRLP4 36
ADDRLP4 40
INDIRI4
ASGNI4
LABELV $448
line 711
;708:
;709://				xx = x + TINYCHAR_WIDTH * 2 + TINYCHAR_WIDTH * pwidth + 
;710://					((lwidth/2 - len/2) * TINYCHAR_WIDTH);
;711:				xx = x + TINYCHAR_WIDTH * 2 + TINYCHAR_WIDTH * pwidth;
ADDRLP4 12
ADDRLP4 44
INDIRI4
CNSTI4 16
ADDI4
ADDRLP4 48
INDIRI4
CNSTI4 3
LSHI4
ADDI4
ASGNI4
line 712
;712:				CG_DrawStringExt( xx, y,
ADDRLP4 12
INDIRI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 116
CNSTI4 0
ASGNI4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 120
CNSTI4 8
ASGNI4
ADDRLP4 120
INDIRI4
ARGI4
ADDRLP4 120
INDIRI4
ARGI4
CNSTI4 16
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 715
;713:					p, hcolor, qfalse, qfalse, TINYCHAR_WIDTH, TINYCHAR_HEIGHT,
;714:					TEAM_OVERLAY_MAXLOCATION_WIDTH);
;715:			}
LABELV $442
line 717
;716:
;717:			CG_GetColorForHealth( ci->health, ci->armor, hcolor );
ADDRLP4 4
INDIRP4
CNSTI4 96
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
ARGI4
ADDRLP4 20
ARGP4
ADDRGP4 CG_GetColorForHealth
CALLV
pop
line 719
;718:
;719:			Com_sprintf (st, sizeof(st), "%3i %3i", ci->health,	ci->armor);
ADDRLP4 52
ARGP4
CNSTI4 16
ARGI4
ADDRGP4 $450
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 96
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 721
;720:
;721:			xx = x + TINYCHAR_WIDTH * 3 + 
ADDRLP4 112
CNSTI4 3
ASGNI4
ADDRLP4 12
ADDRLP4 44
INDIRI4
CNSTI4 24
ADDI4
ADDRLP4 48
INDIRI4
ADDRLP4 112
INDIRI4
LSHI4
ADDI4
ADDRLP4 40
INDIRI4
ADDRLP4 112
INDIRI4
LSHI4
ADDI4
ASGNI4
line 724
;722:				TINYCHAR_WIDTH * pwidth + TINYCHAR_WIDTH * lwidth;
;723:
;724:			CG_DrawStringExt( xx, y,
ADDRLP4 12
INDIRI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 52
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 116
CNSTI4 0
ASGNI4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 120
CNSTI4 8
ASGNI4
ADDRLP4 120
INDIRI4
ARGI4
ADDRLP4 120
INDIRI4
ARGI4
ADDRLP4 116
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 729
;725:				st, hcolor, qfalse, qfalse,
;726:				TINYCHAR_WIDTH, TINYCHAR_HEIGHT, 0 );
;727:
;728:			// draw weapon icon
;729:			xx += TINYCHAR_WIDTH * 3;
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 24
ADDI4
ASGNI4
line 731
;730:
;731:			if ( cg_weapons[ci->curWeapon].weaponIcon ) {
CNSTI4 132
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons+68
ADDP4
INDIRI4
CNSTI4 0
EQI4 $451
line 732
;732:				CG_DrawPic( xx, y, TINYCHAR_WIDTH, TINYCHAR_HEIGHT, 
ADDRLP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 124
CNSTF4 1090519040
ASGNF4
ADDRLP4 124
INDIRF4
ARGF4
ADDRLP4 124
INDIRF4
ARGF4
CNSTI4 132
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons+68
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 734
;733:					cg_weapons[ci->curWeapon].weaponIcon );
;734:			} else {
ADDRGP4 $452
JUMPV
LABELV $451
line 735
;735:				CG_DrawPic( xx, y, TINYCHAR_WIDTH, TINYCHAR_HEIGHT, 
ADDRLP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 124
CNSTF4 1090519040
ASGNF4
ADDRLP4 124
INDIRF4
ARGF4
ADDRLP4 124
INDIRF4
ARGF4
ADDRGP4 cgs+170516+64
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 737
;736:					cgs.media.deferShader );
;737:			}
LABELV $452
line 740
;738:
;739:			// Draw powerup icons
;740:			if (right) {
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $457
line 741
;741:				xx = x;
ADDRLP4 12
ADDRLP4 44
INDIRI4
ASGNI4
line 742
;742:			} else {
ADDRGP4 $458
JUMPV
LABELV $457
line 743
;743:				xx = x + w - TINYCHAR_WIDTH;
ADDRLP4 12
ADDRLP4 44
INDIRI4
ADDRLP4 72
INDIRI4
ADDI4
CNSTI4 8
SUBI4
ASGNI4
line 744
;744:			}
LABELV $458
line 745
;745:			for (j = 0; j < PW_NUM_POWERUPS; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $459
line 746
;746:				if (ci->powerups & (1 << j)) {
ADDRLP4 4
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $463
line 749
;747:					gitem_t	*item;
;748:
;749:					item = BG_FindItemForPowerup( j );
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 128
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 124
ADDRLP4 128
INDIRP4
ASGNP4
line 751
;750:
;751:					CG_DrawPic( xx, y, TINYCHAR_WIDTH, TINYCHAR_HEIGHT, 
ADDRLP4 124
INDIRP4
CNSTI4 24
ADDP4
INDIRP4
ARGP4
ADDRLP4 132
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
ARGF4
ADDRLP4 136
CNSTF4 1090519040
ASGNF4
ADDRLP4 136
INDIRF4
ARGF4
ADDRLP4 136
INDIRF4
ARGF4
ADDRLP4 132
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 753
;752:						trap_R_RegisterShader( item->icon ) );
;753:					if (right) {
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $465
line 754
;754:						xx -= TINYCHAR_WIDTH;
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 8
SUBI4
ASGNI4
line 755
;755:					} else {
ADDRGP4 $466
JUMPV
LABELV $465
line 756
;756:						xx += TINYCHAR_WIDTH;
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 8
ADDI4
ASGNI4
line 757
;757:					}
LABELV $466
line 758
;758:				}
LABELV $463
line 759
;759:			}
LABELV $460
line 745
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 11
LTI4 $459
line 761
;760:
;761:			y += TINYCHAR_HEIGHT;
ADDRFP4 0
ADDRFP4 0
INDIRF4
CNSTF4 1090519040
ADDF4
ASGNF4
line 762
;762:		}
LABELV $436
line 763
;763:	}
LABELV $432
line 689
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $434
ADDRLP4 8
INDIRI4
ADDRGP4 numSortedTeamPlayers
INDIRI4
LTI4 $431
line 765
;764:
;765:	return ret_y;
ADDRLP4 80
INDIRI4
CVIF4 4
RETF4
LABELV $384
endproc CG_DrawTeamOverlay 140 36
proc CG_DrawUpperRight 12 12
line 775
;766:}
;767:
;768:
;769:/*
;770:=====================
;771:CG_DrawUpperRight
;772:
;773:=====================
;774:*/
;775:static void CG_DrawUpperRight( void ) {
line 778
;776:	float	y;
;777:
;778:	y = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 780
;779:
;780:	if ( cgs.gametype >= GT_TEAM && cg_drawTeamOverlay.integer == 1 ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $468
ADDRGP4 cg_drawTeamOverlay+12
INDIRI4
CNSTI4 1
NEI4 $468
line 781
;781:		y = CG_DrawTeamOverlay( y, qtrue, qtrue );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
CNSTI4 1
ASGNI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 CG_DrawTeamOverlay
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 8
INDIRF4
ASGNF4
line 782
;782:	} 
LABELV $468
line 783
;783:	if ( cg_drawSnapshot.integer ) {
ADDRGP4 cg_drawSnapshot+12
INDIRI4
CNSTI4 0
EQI4 $472
line 784
;784:		y = CG_DrawSnapshot( y );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 CG_DrawSnapshot
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 785
;785:	}
LABELV $472
line 786
;786:	if ( cg_drawFPS.integer ) {
ADDRGP4 cg_drawFPS+12
INDIRI4
CNSTI4 0
EQI4 $475
line 787
;787:		y = CG_DrawFPS( y );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 CG_DrawFPS
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 788
;788:	}
LABELV $475
line 789
;789:	if ( cg_drawTimer.integer ) {
ADDRGP4 cg_drawTimer+12
INDIRI4
CNSTI4 0
EQI4 $478
line 790
;790:		y = CG_DrawTimer( y );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 CG_DrawTimer
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 791
;791:	}
LABELV $478
line 792
;792:	if ( cg_drawAttacker.integer ) {
ADDRGP4 cg_drawAttacker+12
INDIRI4
CNSTI4 0
EQI4 $481
line 793
;793:		y = CG_DrawAttacker( y );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 CG_DrawAttacker
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 794
;794:	}
LABELV $481
line 796
;795:
;796:}
LABELV $467
endproc CG_DrawUpperRight 12 12
proc CG_DrawScores 76 20
line 813
;797:
;798:/*
;799:===========================================================================================
;800:
;801:  LOWER RIGHT CORNER
;802:
;803:===========================================================================================
;804:*/
;805:
;806:/*
;807:=================
;808:CG_DrawScores
;809:
;810:Draw the small two score display
;811:=================
;812:*/
;813:static float CG_DrawScores( float y ) {
line 822
;814:	const char	*s;
;815:	int			s1, s2, score;
;816:	int			x, w;
;817:	int			v;
;818:	vec4_t		color;
;819:	float		y1;
;820:	gitem_t		*item;
;821:
;822:	s1 = cgs.scores1;
ADDRLP4 28
ADDRGP4 cgs+24656
INDIRI4
ASGNI4
line 823
;823:	s2 = cgs.scores2;
ADDRLP4 32
ADDRGP4 cgs+24660
INDIRI4
ASGNI4
line 825
;824:
;825:	y -=  BIGCHAR_HEIGHT + 8;
ADDRFP4 0
ADDRFP4 0
INDIRF4
CNSTF4 1103101952
SUBF4
ASGNF4
line 827
;826:
;827:	y1 = y;
ADDRLP4 36
ADDRFP4 0
INDIRF4
ASGNF4
line 830
;828:
;829:	// draw from the right side to left
;830:	if ( cgs.gametype >= GT_TEAM ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $487
line 831
;831:		x = 640;
ADDRLP4 16
CNSTI4 640
ASGNI4
line 833
;832:
;833:		color[0] = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 834
;834:		color[1] = 0;
ADDRLP4 0+4
CNSTF4 0
ASGNF4
line 835
;835:		color[2] = 1;
ADDRLP4 0+8
CNSTF4 1065353216
ASGNF4
line 836
;836:		color[3] = 0.33;
ADDRLP4 0+12
CNSTF4 1051260355
ASGNF4
line 837
;837:		s = va( "%2i", s2 );
ADDRGP4 $493
ARGP4
ADDRLP4 32
INDIRI4
ARGI4
ADDRLP4 52
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 52
INDIRP4
ASGNP4
line 838
;838:		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH + 8;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 56
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 8
ADDI4
ASGNI4
line 839
;839:		x -= w;
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 840
;840:		CG_FillRect( x, y-4,  w, BIGCHAR_HEIGHT+8, color );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 841
;841:		if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_BLUE ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 2
NEI4 $494
line 842
;842:			CG_DrawPic( x, y-4, w, BIGCHAR_HEIGHT+8, cgs.media.selectShader );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRGP4 cgs+170516+140
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 843
;843:		}
LABELV $494
line 844
;844:		CG_DrawBigString( x + 4, y, s, 1.0F);
ADDRLP4 16
INDIRI4
CNSTI4 4
ADDI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 846
;845:
;846:		if ( cgs.gametype == GT_CTF ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 4
NEI4 $499
line 848
;847:			// Display flag status
;848:			item = BG_FindItemForPowerup( PW_BLUEFLAG );
CNSTI4 8
ARGI4
ADDRLP4 60
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 48
ADDRLP4 60
INDIRP4
ASGNP4
line 850
;849:
;850:			if (item) {
ADDRLP4 48
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $502
line 851
;851:				y1 = y - BIGCHAR_HEIGHT - 8;
ADDRLP4 36
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
SUBF4
CNSTF4 1090519040
SUBF4
ASGNF4
line 852
;852:				if( cgs.blueflag >= 0 && cgs.blueflag <= 2 ) {
ADDRGP4 cgs+24668
INDIRI4
CNSTI4 0
LTI4 $504
ADDRGP4 cgs+24668
INDIRI4
CNSTI4 2
GTI4 $504
line 853
;853:					CG_DrawPic( x, y1-4, w, BIGCHAR_HEIGHT+8, cgs.media.blueFlagShader[cgs.blueflag] );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 36
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRGP4 cgs+24668
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+40
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 854
;854:				}
LABELV $504
line 871
;855:#if 0
;856:				CG_RegisterItemVisuals( ITEM_INDEX(item) );
;857:				switch (cgs.blueflag) {
;858:				case 0 :  // at base
;859:					// Draw the icon
;860:					CG_DrawPic( x, y1-4, w, BIGCHAR_HEIGHT+8, trap_R_RegisterShader( item->icon ) );
;861:				case 1 : // taken
;862:					CG_FillRect( x, y1-4,  w, BIGCHAR_HEIGHT+8, color );
;863:					break;
;864:				case 2 : // droppped, grey background
;865:					color[0] = color[1] = color[2] = 1;
;866:					CG_FillRect( x, y1-4,  w, BIGCHAR_HEIGHT+8, color );
;867:					break;
;868:				// Other values won't draw (-1 is disabled)
;869:				}
;870:#endif
;871:			}
LABELV $502
line 872
;872:		}
LABELV $499
line 874
;873:
;874:		color[0] = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 875
;875:		color[1] = 0;
ADDRLP4 0+4
CNSTF4 0
ASGNF4
line 876
;876:		color[2] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 877
;877:		color[3] = 0.33;
ADDRLP4 0+12
CNSTF4 1051260355
ASGNF4
line 878
;878:		s = va( "%2i", s1 );
ADDRGP4 $493
ARGP4
ADDRLP4 28
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 60
INDIRP4
ASGNP4
line 879
;879:		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH + 8;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 64
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 8
ADDI4
ASGNI4
line 880
;880:		x -= w;
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 881
;881:		CG_FillRect( x, y-4,  w, BIGCHAR_HEIGHT+8, color );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 882
;882:		if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_RED ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 1
NEI4 $514
line 883
;883:			CG_DrawPic( x, y-4, w, BIGCHAR_HEIGHT+8, cgs.media.selectShader );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRGP4 cgs+170516+140
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 884
;884:		}
LABELV $514
line 885
;885:		CG_DrawBigString( x + 4, y, s, 1.0F);
ADDRLP4 16
INDIRI4
CNSTI4 4
ADDI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 887
;886:
;887:		if ( cgs.gametype == GT_CTF ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 4
NEI4 $519
line 889
;888:			// Display flag status
;889:			item = BG_FindItemForPowerup( PW_REDFLAG );
CNSTI4 7
ARGI4
ADDRLP4 68
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 48
ADDRLP4 68
INDIRP4
ASGNP4
line 891
;890:
;891:			if (item) {
ADDRLP4 48
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $522
line 892
;892:				y1 = y - BIGCHAR_HEIGHT - 8;
ADDRLP4 36
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
SUBF4
CNSTF4 1090519040
SUBF4
ASGNF4
line 893
;893:				if( cgs.redflag >= 0 && cgs.redflag <= 2 ) {
ADDRGP4 cgs+24664
INDIRI4
CNSTI4 0
LTI4 $524
ADDRGP4 cgs+24664
INDIRI4
CNSTI4 2
GTI4 $524
line 894
;894:					CG_DrawPic( x, y1-4, w, BIGCHAR_HEIGHT+8, cgs.media.redFlagShader[cgs.redflag] );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 36
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRGP4 cgs+24664
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+28
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 895
;895:				}
LABELV $524
line 913
;896:#if 0
;897:				CG_RegisterItemVisuals( ITEM_INDEX(item) );
;898:				switch (cgs.redflag) {
;899:				case 0 :  // at base
;900:					// Draw the icon
;901:					CG_DrawPic( x, y1-4, w, BIGCHAR_HEIGHT+8, trap_R_RegisterShader( item->icon ) );
;902:					break;
;903:				case 1 : // taken
;904:					CG_FillRect( x, y1-4,  w, BIGCHAR_HEIGHT+8, color );
;905:					break;
;906:				case 2 : // droppped, grey background
;907:					color[0] = color[1] = color[2] = 1;
;908:					CG_FillRect( x, y1-4,  w, BIGCHAR_HEIGHT+8, color );
;909:					break;
;910:				// Other values won't draw (-1 is disabled)
;911:				}
;912:#endif
;913:			}
LABELV $522
line 914
;914:		}
LABELV $519
line 917
;915:
;916:
;917:		if ( cgs.gametype == GT_CTF ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 4
NEI4 $531
line 918
;918:			v = cgs.capturelimit;
ADDRLP4 44
ADDRGP4 cgs+24304
INDIRI4
ASGNI4
line 919
;919:		} else {
ADDRGP4 $532
JUMPV
LABELV $531
line 920
;920:			v = cgs.fraglimit;
ADDRLP4 44
ADDRGP4 cgs+24300
INDIRI4
ASGNI4
line 921
;921:		}
LABELV $532
line 922
;922:		if ( v ) {
ADDRLP4 44
INDIRI4
CNSTI4 0
EQI4 $488
line 923
;923:			s = va( "%2i", v );
ADDRGP4 $493
ARGP4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 68
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 68
INDIRP4
ASGNP4
line 924
;924:			w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH + 8;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 72
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 8
ADDI4
ASGNI4
line 925
;925:			x -= w;
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 926
;926:			CG_DrawBigString( x + 4, y, s, 1.0F);
ADDRLP4 16
INDIRI4
CNSTI4 4
ADDI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 927
;927:		}
line 929
;928:
;929:	} else {
ADDRGP4 $488
JUMPV
LABELV $487
line 932
;930:		qboolean	spectator;
;931:
;932:		x = 640;
ADDRLP4 16
CNSTI4 640
ASGNI4
line 933
;933:		score = cg.snap->ps.persistant[PERS_SCORE];
ADDRLP4 40
ADDRGP4 cg+32
INDIRP4
CNSTI4 292
ADDP4
INDIRI4
ASGNI4
line 934
;934:		spectator = ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR );
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
NEI4 $541
ADDRLP4 56
CNSTI4 1
ASGNI4
ADDRGP4 $542
JUMPV
LABELV $541
ADDRLP4 56
CNSTI4 0
ASGNI4
LABELV $542
ADDRLP4 52
ADDRLP4 56
INDIRI4
ASGNI4
line 937
;935:
;936:		// always show your score in the second box if not in first place
;937:		if ( s1 != score ) {
ADDRLP4 28
INDIRI4
ADDRLP4 40
INDIRI4
EQI4 $543
line 938
;938:			s2 = score;
ADDRLP4 32
ADDRLP4 40
INDIRI4
ASGNI4
line 939
;939:		}
LABELV $543
line 940
;940:		if ( s2 != SCORE_NOT_PRESENT ) {
ADDRLP4 32
INDIRI4
CNSTI4 -9999
EQI4 $545
line 941
;941:			s = va( "%2i", s2 );
ADDRGP4 $493
ARGP4
ADDRLP4 32
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 60
INDIRP4
ASGNP4
line 942
;942:			w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH + 8;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 64
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 8
ADDI4
ASGNI4
line 943
;943:			x -= w;
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 944
;944:			if ( !spectator && score == s2 && score != s1 ) {
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $547
ADDRLP4 68
ADDRLP4 40
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
ADDRLP4 32
INDIRI4
NEI4 $547
ADDRLP4 68
INDIRI4
ADDRLP4 28
INDIRI4
EQI4 $547
line 945
;945:				color[0] = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 946
;946:				color[1] = 0;
ADDRLP4 0+4
CNSTF4 0
ASGNF4
line 947
;947:				color[2] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 948
;948:				color[3] = 0.33;
ADDRLP4 0+12
CNSTF4 1051260355
ASGNF4
line 949
;949:				CG_FillRect( x, y-4,  w, BIGCHAR_HEIGHT+8, color );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 950
;950:				CG_DrawPic( x, y-4, w, BIGCHAR_HEIGHT+8, cgs.media.selectShader );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRGP4 cgs+170516+140
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 951
;951:			} else {
ADDRGP4 $548
JUMPV
LABELV $547
line 952
;952:				color[0] = 0.5;
ADDRLP4 0
CNSTF4 1056964608
ASGNF4
line 953
;953:				color[1] = 0.5;
ADDRLP4 0+4
CNSTF4 1056964608
ASGNF4
line 954
;954:				color[2] = 0.5;
ADDRLP4 0+8
CNSTF4 1056964608
ASGNF4
line 955
;955:				color[3] = 0.33;
ADDRLP4 0+12
CNSTF4 1051260355
ASGNF4
line 956
;956:				CG_FillRect( x, y-4,  w, BIGCHAR_HEIGHT+8, color );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 957
;957:			}	
LABELV $548
line 958
;958:			CG_DrawBigString( x + 4, y, s, 1.0F);
ADDRLP4 16
INDIRI4
CNSTI4 4
ADDI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 959
;959:		}
LABELV $545
line 962
;960:
;961:		// first place
;962:		if ( s1 != SCORE_NOT_PRESENT ) {
ADDRLP4 28
INDIRI4
CNSTI4 -9999
EQI4 $557
line 963
;963:			s = va( "%2i", s1 );
ADDRGP4 $493
ARGP4
ADDRLP4 28
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 60
INDIRP4
ASGNP4
line 964
;964:			w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH + 8;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 64
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 8
ADDI4
ASGNI4
line 965
;965:			x -= w;
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 966
;966:			if ( !spectator && score == s1 ) {
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $559
ADDRLP4 40
INDIRI4
ADDRLP4 28
INDIRI4
NEI4 $559
line 967
;967:				color[0] = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 968
;968:				color[1] = 0;
ADDRLP4 0+4
CNSTF4 0
ASGNF4
line 969
;969:				color[2] = 1;
ADDRLP4 0+8
CNSTF4 1065353216
ASGNF4
line 970
;970:				color[3] = 0.33;
ADDRLP4 0+12
CNSTF4 1051260355
ASGNF4
line 971
;971:				CG_FillRect( x, y-4,  w, BIGCHAR_HEIGHT+8, color );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 972
;972:				CG_DrawPic( x, y-4, w, BIGCHAR_HEIGHT+8, cgs.media.selectShader );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRGP4 cgs+170516+140
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 973
;973:			} else {
ADDRGP4 $560
JUMPV
LABELV $559
line 974
;974:				color[0] = 0.5;
ADDRLP4 0
CNSTF4 1056964608
ASGNF4
line 975
;975:				color[1] = 0.5;
ADDRLP4 0+4
CNSTF4 1056964608
ASGNF4
line 976
;976:				color[2] = 0.5;
ADDRLP4 0+8
CNSTF4 1056964608
ASGNF4
line 977
;977:				color[3] = 0.33;
ADDRLP4 0+12
CNSTF4 1051260355
ASGNF4
line 978
;978:				CG_FillRect( x, y-4,  w, BIGCHAR_HEIGHT+8, color );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1082130432
SUBF4
ARGF4
ADDRLP4 20
INDIRI4
CVIF4 4
ARGF4
CNSTF4 1103101952
ARGF4
ADDRLP4 0
ARGP4
ADDRGP4 CG_FillRect
CALLV
pop
line 979
;979:			}	
LABELV $560
line 980
;980:			CG_DrawBigString( x + 4, y, s, 1.0F);
ADDRLP4 16
INDIRI4
CNSTI4 4
ADDI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 981
;981:		}
LABELV $557
line 983
;982:
;983:		if ( cgs.fraglimit ) {
ADDRGP4 cgs+24300
INDIRI4
CNSTI4 0
EQI4 $569
line 984
;984:			s = va( "%2i", cgs.fraglimit );
ADDRGP4 $493
ARGP4
ADDRGP4 cgs+24300
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 60
INDIRP4
ASGNP4
line 985
;985:			w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH + 8;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 64
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 8
ADDI4
ASGNI4
line 986
;986:			x -= w;
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
SUBI4
ASGNI4
line 987
;987:			CG_DrawBigString( x + 4, y, s, 1.0F);
ADDRLP4 16
INDIRI4
CNSTI4 4
ADDI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 988
;988:		}
LABELV $569
line 990
;989:
;990:	}
LABELV $488
line 992
;991:
;992:	return y1 - 8;
ADDRLP4 36
INDIRF4
CNSTF4 1090519040
SUBF4
RETF4
LABELV $484
endproc CG_DrawScores 76 20
data
align 4
LABELV $574
byte 4 1045220557
byte 4 1065353216
byte 4 1045220557
byte 4 1065353216
byte 4 1065353216
byte 4 1045220557
byte 4 1045220557
byte 4 1065353216
code
proc CG_DrawPowerups 208 20
line 1000
;993:}
;994:
;995:/*
;996:================
;997:CG_DrawPowerups
;998:================
;999:*/
;1000:static float CG_DrawPowerups( float y ) {
line 1015
;1001:	int		sorted[MAX_POWERUPS];
;1002:	int		sortedTime[MAX_POWERUPS];
;1003:	int		i, j, k;
;1004:	int		active;
;1005:	playerState_t	*ps;
;1006:	int		t;
;1007:	gitem_t	*item;
;1008:	int		x;
;1009:	int		color;
;1010:	float	size;
;1011:	float	f;
;1012:	static float colors[2][4] = { 
;1013:		{ 0.2, 1.0, 0.2, 1.0 } , { 1.0, 0.2, 0.2, 1.0 } };
;1014:
;1015:	ps = &cg.snap->ps;
ADDRLP4 152
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
line 1017
;1016:
;1017:	if ( ps->stats[STAT_HEALTH] <= 0 ) {
ADDRLP4 152
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $576
line 1018
;1018:		return y;
ADDRFP4 0
INDIRF4
RETF4
ADDRGP4 $573
JUMPV
LABELV $576
line 1022
;1019:	}
;1020:
;1021:	// sort the list by time remaining
;1022:	active = 0;
ADDRLP4 136
CNSTI4 0
ASGNI4
line 1023
;1023:	for ( i = 0 ; i < MAX_POWERUPS ; i++ ) {
ADDRLP4 144
CNSTI4 0
ASGNI4
LABELV $578
line 1024
;1024:		if ( !ps->powerups[ i ] ) {
ADDRLP4 144
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 152
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $582
line 1025
;1025:			continue;
ADDRGP4 $579
JUMPV
LABELV $582
line 1027
;1026:		}
;1027:		t = ps->powerups[ i ] - cg.time;
ADDRLP4 140
ADDRLP4 144
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 152
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
ASGNI4
line 1030
;1028:		// ZOID--don't draw if the power up has unlimited time (999 seconds)
;1029:		// This is true of the CTF flags
;1030:		if ( t < 0 || t > 999000) {
ADDRLP4 140
INDIRI4
CNSTI4 0
LTI4 $587
ADDRLP4 140
INDIRI4
CNSTI4 999000
LEI4 $585
LABELV $587
line 1031
;1031:			continue;
ADDRGP4 $579
JUMPV
LABELV $585
line 1035
;1032:		}
;1033:
;1034:		// insert into the list
;1035:		for ( j = 0 ; j < active ; j++ ) {
ADDRLP4 132
CNSTI4 0
ASGNI4
ADDRGP4 $591
JUMPV
LABELV $588
line 1036
;1036:			if ( sortedTime[j] >= t ) {
ADDRLP4 132
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
ADDRLP4 140
INDIRI4
LTI4 $592
line 1037
;1037:				for ( k = active - 1 ; k >= j ; k-- ) {
ADDRLP4 0
ADDRLP4 136
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRGP4 $597
JUMPV
LABELV $594
line 1038
;1038:					sorted[k+1] = sorted[k];
ADDRLP4 176
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 176
INDIRI4
ADDRLP4 68+4
ADDP4
ADDRLP4 176
INDIRI4
ADDRLP4 68
ADDP4
INDIRI4
ASGNI4
line 1039
;1039:					sortedTime[k+1] = sortedTime[k];
ADDRLP4 180
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 180
INDIRI4
ADDRLP4 4+4
ADDP4
ADDRLP4 180
INDIRI4
ADDRLP4 4
ADDP4
INDIRI4
ASGNI4
line 1040
;1040:				}
LABELV $595
line 1037
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
LABELV $597
ADDRLP4 0
INDIRI4
ADDRLP4 132
INDIRI4
GEI4 $594
line 1041
;1041:				break;
ADDRGP4 $590
JUMPV
LABELV $592
line 1043
;1042:			}
;1043:		}
LABELV $589
line 1035
ADDRLP4 132
ADDRLP4 132
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $591
ADDRLP4 132
INDIRI4
ADDRLP4 136
INDIRI4
LTI4 $588
LABELV $590
line 1044
;1044:		sorted[j] = i;
ADDRLP4 132
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 68
ADDP4
ADDRLP4 144
INDIRI4
ASGNI4
line 1045
;1045:		sortedTime[j] = t;
ADDRLP4 132
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ADDRLP4 140
INDIRI4
ASGNI4
line 1046
;1046:		active++;
ADDRLP4 136
ADDRLP4 136
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1047
;1047:	}
LABELV $579
line 1023
ADDRLP4 144
ADDRLP4 144
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 144
INDIRI4
CNSTI4 16
LTI4 $578
line 1050
;1048:
;1049:	// draw the icons and timers
;1050:	x = 640 - ICON_SIZE - CHAR_WIDTH * 2;
ADDRLP4 168
CNSTI4 528
ASGNI4
line 1051
;1051:	for ( i = 0 ; i < active ; i++ ) {
ADDRLP4 144
CNSTI4 0
ASGNI4
ADDRGP4 $603
JUMPV
LABELV $600
line 1052
;1052:		item = BG_FindItemForPowerup( sorted[i] );
ADDRLP4 144
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 68
ADDP4
INDIRI4
ARGI4
ADDRLP4 172
ADDRGP4 BG_FindItemForPowerup
CALLP4
ASGNP4
ADDRLP4 160
ADDRLP4 172
INDIRP4
ASGNP4
line 1054
;1053:
;1054:		color = 1;
ADDRLP4 164
CNSTI4 1
ASGNI4
line 1056
;1055:
;1056:		y -= ICON_SIZE;
ADDRFP4 0
ADDRFP4 0
INDIRF4
CNSTF4 1111490560
SUBF4
ASGNF4
line 1058
;1057:
;1058:		trap_R_SetColor( colors[color] );
ADDRLP4 164
INDIRI4
CNSTI4 4
LSHI4
ADDRGP4 $574
ADDP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1059
;1059:		CG_DrawField( x, y, 2, sortedTime[ i ] / 1000 );
ADDRLP4 168
INDIRI4
ARGI4
ADDRFP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 176
CNSTI4 2
ASGNI4
ADDRLP4 176
INDIRI4
ARGI4
ADDRLP4 144
INDIRI4
ADDRLP4 176
INDIRI4
LSHI4
ADDRLP4 4
ADDP4
INDIRI4
CNSTI4 1000
DIVI4
ARGI4
ADDRGP4 CG_DrawField
CALLV
pop
line 1061
;1060:
;1061:		t = ps->powerups[ sorted[i] ];
ADDRLP4 180
CNSTI4 2
ASGNI4
ADDRLP4 140
ADDRLP4 144
INDIRI4
ADDRLP4 180
INDIRI4
LSHI4
ADDRLP4 68
ADDP4
INDIRI4
ADDRLP4 180
INDIRI4
LSHI4
ADDRLP4 152
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ASGNI4
line 1062
;1062:		if ( t - cg.time >= POWERUP_BLINKS * POWERUP_BLINK_TIME ) {
ADDRLP4 140
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CNSTI4 5000
LTI4 $604
line 1063
;1063:			trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1064
;1064:		} else {
ADDRGP4 $605
JUMPV
LABELV $604
line 1067
;1065:			vec4_t	modulate;
;1066:
;1067:			f = (float)( t - cg.time ) / POWERUP_BLINK_TIME;
ADDRLP4 156
ADDRLP4 140
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 1068
;1068:			f -= (int)f;
ADDRLP4 156
ADDRLP4 156
INDIRF4
ADDRLP4 156
INDIRF4
CVFI4 4
CVIF4 4
SUBF4
ASGNF4
line 1069
;1069:			modulate[0] = modulate[1] = modulate[2] = modulate[3] = f;
ADDRLP4 184+12
ADDRLP4 156
INDIRF4
ASGNF4
ADDRLP4 184+8
ADDRLP4 156
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 156
INDIRF4
ASGNF4
ADDRLP4 184
ADDRLP4 156
INDIRF4
ASGNF4
line 1070
;1070:			trap_R_SetColor( modulate );
ADDRLP4 184
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1071
;1071:		}
LABELV $605
line 1073
;1072:
;1073:		if ( cg.powerupActive == sorted[i] && 
ADDRGP4 cg+111888
INDIRI4
ADDRLP4 144
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 68
ADDP4
INDIRI4
NEI4 $611
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+111892
INDIRI4
SUBI4
CNSTI4 200
GEI4 $611
line 1074
;1074:			cg.time - cg.powerupTime < PULSE_TIME ) {
line 1075
;1075:			f = 1.0 - ( ( (float)cg.time - cg.powerupTime ) / PULSE_TIME );
ADDRLP4 156
CNSTF4 1065353216
ADDRGP4 cg+105504
INDIRI4
CVIF4 4
ADDRGP4 cg+111892
INDIRI4
CVIF4 4
SUBF4
CNSTF4 1128792064
DIVF4
SUBF4
ASGNF4
line 1076
;1076:			size = ICON_SIZE * ( 1.0 + ( PULSE_SCALE - 1.0 ) * f );
ADDRLP4 148
CNSTF4 1111490560
CNSTF4 1056964608
ADDRLP4 156
INDIRF4
MULF4
CNSTF4 1065353216
ADDF4
MULF4
ASGNF4
line 1077
;1077:		} else {
ADDRGP4 $612
JUMPV
LABELV $611
line 1078
;1078:			size = ICON_SIZE;
ADDRLP4 148
CNSTF4 1111490560
ASGNF4
line 1079
;1079:		}
LABELV $612
line 1081
;1080:
;1081:		CG_DrawPic( 640 - size, y + ICON_SIZE / 2 - size / 2, 
ADDRLP4 160
INDIRP4
CNSTI4 24
ADDP4
INDIRP4
ARGP4
ADDRLP4 184
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
CNSTF4 1142947840
ADDRLP4 148
INDIRF4
SUBF4
ARGF4
ADDRFP4 0
INDIRF4
CNSTF4 1103101952
ADDF4
ADDRLP4 148
INDIRF4
CNSTF4 1073741824
DIVF4
SUBF4
ARGF4
ADDRLP4 148
INDIRF4
ARGF4
ADDRLP4 148
INDIRF4
ARGF4
ADDRLP4 184
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1083
;1082:			size, size, trap_R_RegisterShader( item->icon ) );
;1083:	}
LABELV $601
line 1051
ADDRLP4 144
ADDRLP4 144
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $603
ADDRLP4 144
INDIRI4
ADDRLP4 136
INDIRI4
LTI4 $600
line 1084
;1084:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1086
;1085:
;1086:	return y;
ADDRFP4 0
INDIRF4
RETF4
LABELV $573
endproc CG_DrawPowerups 208 20
proc CG_DrawLowerRight 12 12
line 1096
;1087:}
;1088:
;1089:
;1090:/*
;1091:=====================
;1092:CG_DrawLowerRight
;1093:
;1094:=====================
;1095:*/
;1096:static void CG_DrawLowerRight( void ) {
line 1099
;1097:	float	y;
;1098:
;1099:	y = 480 - ICON_SIZE;
ADDRLP4 0
CNSTF4 1138229248
ASGNF4
line 1101
;1100:
;1101:	if ( cgs.gametype >= GT_TEAM && cg_drawTeamOverlay.integer == 2 ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $619
ADDRGP4 cg_drawTeamOverlay+12
INDIRI4
CNSTI4 2
NEI4 $619
line 1102
;1102:		y = CG_DrawTeamOverlay( y, qtrue, qfalse );
ADDRLP4 0
INDIRF4
ARGF4
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 4
ADDRGP4 CG_DrawTeamOverlay
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 1103
;1103:	} 
LABELV $619
line 1105
;1104:
;1105:	y = CG_DrawScores( y );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 4
ADDRGP4 CG_DrawScores
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 1106
;1106:	y = CG_DrawPowerups( y );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 8
ADDRGP4 CG_DrawPowerups
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 8
INDIRF4
ASGNF4
line 1107
;1107:}
LABELV $618
endproc CG_DrawLowerRight 12 12
proc CG_DrawPickupItem 16 20
line 1114
;1108:
;1109:/*
;1110:===================
;1111:CG_DrawPickupItem
;1112:===================
;1113:*/
;1114:static int CG_DrawPickupItem( int y ) {
line 1118
;1115:	int		value;
;1116:	float	*fadeColor;
;1117:
;1118:	if ( cg.snap->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
GTI4 $624
line 1119
;1119:		return y;
ADDRFP4 0
INDIRI4
RETI4
ADDRGP4 $623
JUMPV
LABELV $624
line 1122
;1120:	}
;1121:
;1122:	y -= ICON_SIZE;
ADDRFP4 0
ADDRFP4 0
INDIRI4
CNSTI4 48
SUBI4
ASGNI4
line 1124
;1123:
;1124:	value = cg.itemPickup;
ADDRLP4 0
ADDRGP4 cg+111920
INDIRI4
ASGNI4
line 1125
;1125:	if ( value ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $628
line 1126
;1126:		fadeColor = CG_FadeColor( cg.itemPickupTime, 3000 );
ADDRGP4 cg+111924
INDIRI4
ARGI4
CNSTI4 3000
ARGI4
ADDRLP4 8
ADDRGP4 CG_FadeColor
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 1127
;1127:		if ( fadeColor ) {
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $631
line 1128
;1128:			CG_RegisterItemVisuals( value );
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_RegisterItemVisuals
CALLV
pop
line 1129
;1129:			trap_R_SetColor( fadeColor );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1130
;1130:			CG_DrawPic( 8, y, ICON_SIZE, ICON_SIZE, cg_items[ value ].icon );
CNSTF4 1090519040
ARGF4
ADDRFP4 0
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 12
CNSTF4 1111490560
ASGNF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
CNSTI4 24
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg_items+20
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1131
;1131:			CG_DrawBigString( ICON_SIZE + 16, y + (ICON_SIZE/2 - BIGCHAR_HEIGHT/2), bg_itemlist[ value ].pickup_name, fadeColor[0] );
CNSTI4 64
ARGI4
ADDRFP4 0
INDIRI4
CNSTI4 16
ADDI4
ARGI4
CNSTI4 56
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 bg_itemlist+28
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
INDIRP4
INDIRF4
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1132
;1132:			trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1133
;1133:		}
LABELV $631
line 1134
;1134:	}
LABELV $628
line 1136
;1135:	
;1136:	return y;
ADDRFP4 0
INDIRI4
RETI4
LABELV $623
endproc CG_DrawPickupItem 16 20
proc CG_DrawLowerLeft 16 12
line 1145
;1137:}
;1138:
;1139:/*
;1140:=====================
;1141:CG_DrawLowerLeft
;1142:
;1143:=====================
;1144:*/
;1145:static void CG_DrawLowerLeft( void ) {
line 1148
;1146:	float	y;
;1147:
;1148:	y = 480 - ICON_SIZE;
ADDRLP4 0
CNSTF4 1138229248
ASGNF4
line 1150
;1149:
;1150:	if ( cgs.gametype >= GT_TEAM && cg_drawTeamOverlay.integer == 3 ) {
ADDRLP4 4
CNSTI4 3
ASGNI4
ADDRGP4 cgs+24288
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $636
ADDRGP4 cg_drawTeamOverlay+12
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $636
line 1151
;1151:		y = CG_DrawTeamOverlay( y, qfalse, qfalse );
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 CG_DrawTeamOverlay
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 12
INDIRF4
ASGNF4
line 1152
;1152:	} 
LABELV $636
line 1155
;1153:
;1154:
;1155:	y = CG_DrawPickupItem( y );
ADDRLP4 0
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 8
ADDRGP4 CG_DrawPickupItem
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
CVIF4 4
ASGNF4
line 1156
;1156:}
LABELV $635
endproc CG_DrawLowerLeft 16 12
proc CG_DrawTeamInfo 56 36
line 1167
;1157:
;1158:
;1159:
;1160://===========================================================================================
;1161:
;1162:/*
;1163:=================
;1164:CG_DrawTeamInfo
;1165:=================
;1166:*/
;1167:static void CG_DrawTeamInfo( void ) {
line 1176
;1168:	int w, h;
;1169:	int i, len;
;1170:	vec4_t		hcolor;
;1171:	int		chatHeight;
;1172:
;1173:#define CHATLOC_Y 420 // bottom end
;1174:#define CHATLOC_X 0
;1175:
;1176:	if (cg_teamChatHeight.integer < TEAMCHAT_HEIGHT)
ADDRGP4 cg_teamChatHeight+12
INDIRI4
CNSTI4 8
GEI4 $641
line 1177
;1177:		chatHeight = cg_teamChatHeight.integer;
ADDRLP4 8
ADDRGP4 cg_teamChatHeight+12
INDIRI4
ASGNI4
ADDRGP4 $642
JUMPV
LABELV $641
line 1179
;1178:	else
;1179:		chatHeight = TEAMCHAT_HEIGHT;
ADDRLP4 8
CNSTI4 8
ASGNI4
LABELV $642
line 1180
;1180:	if (chatHeight <= 0)
ADDRLP4 8
INDIRI4
CNSTI4 0
GTI4 $645
line 1181
;1181:		return; // disabled
ADDRGP4 $640
JUMPV
LABELV $645
line 1183
;1182:
;1183:	if (cgs.teamLastChatPos != cgs.teamChatPos) {
ADDRGP4 cgs+170512
INDIRI4
ADDRGP4 cgs+170508
INDIRI4
EQI4 $647
line 1184
;1184:		if (cg.time - cgs.teamChatMsgTimes[cgs.teamLastChatPos % chatHeight] > cg_teamChatTime.integer) {
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cgs+170512
INDIRI4
ADDRLP4 8
INDIRI4
MODI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170476
ADDP4
INDIRI4
SUBI4
ADDRGP4 cg_teamChatTime+12
INDIRI4
LEI4 $651
line 1185
;1185:			cgs.teamLastChatPos++;
ADDRLP4 36
ADDRGP4 cgs+170512
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1186
;1186:		}
LABELV $651
line 1188
;1187:
;1188:		h = (cgs.teamChatPos - cgs.teamLastChatPos) * TINYCHAR_HEIGHT;
ADDRLP4 32
ADDRGP4 cgs+170508
INDIRI4
ADDRGP4 cgs+170512
INDIRI4
SUBI4
CNSTI4 3
LSHI4
ASGNI4
line 1190
;1189:
;1190:		w = 0;
ADDRLP4 28
CNSTI4 0
ASGNI4
line 1192
;1191:
;1192:		for (i = cgs.teamLastChatPos; i < cgs.teamChatPos; i++) {
ADDRLP4 0
ADDRGP4 cgs+170512
INDIRI4
ASGNI4
ADDRGP4 $663
JUMPV
LABELV $660
line 1193
;1193:			len = CG_DrawStrlen(cgs.teamChatMsgs[i % chatHeight]);
CNSTI4 241
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
MODI4
MULI4
ADDRGP4 cgs+168548
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 36
INDIRI4
ASGNI4
line 1194
;1194:			if (len > w)
ADDRLP4 4
INDIRI4
ADDRLP4 28
INDIRI4
LEI4 $667
line 1195
;1195:				w = len;
ADDRLP4 28
ADDRLP4 4
INDIRI4
ASGNI4
LABELV $667
line 1196
;1196:		}
LABELV $661
line 1192
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $663
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+170508
INDIRI4
LTI4 $660
line 1197
;1197:		w *= TINYCHAR_WIDTH;
ADDRLP4 28
ADDRLP4 28
INDIRI4
CNSTI4 3
LSHI4
ASGNI4
line 1198
;1198:		w += TINYCHAR_WIDTH * 2;
ADDRLP4 28
ADDRLP4 28
INDIRI4
CNSTI4 16
ADDI4
ASGNI4
line 1200
;1199:
;1200:		if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_RED ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 1
NEI4 $669
line 1201
;1201:			hcolor[0] = 1;
ADDRLP4 12
CNSTF4 1065353216
ASGNF4
line 1202
;1202:			hcolor[1] = 0;
ADDRLP4 12+4
CNSTF4 0
ASGNF4
line 1203
;1203:			hcolor[2] = 0;
ADDRLP4 12+8
CNSTF4 0
ASGNF4
line 1204
;1204:			hcolor[3] = 0.33;
ADDRLP4 12+12
CNSTF4 1051260355
ASGNF4
line 1205
;1205:		} else if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_BLUE ) {
ADDRGP4 $670
JUMPV
LABELV $669
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 2
NEI4 $675
line 1206
;1206:			hcolor[0] = 0;
ADDRLP4 12
CNSTF4 0
ASGNF4
line 1207
;1207:			hcolor[1] = 0;
ADDRLP4 12+4
CNSTF4 0
ASGNF4
line 1208
;1208:			hcolor[2] = 1;
ADDRLP4 12+8
CNSTF4 1065353216
ASGNF4
line 1209
;1209:			hcolor[3] = 0.33;
ADDRLP4 12+12
CNSTF4 1051260355
ASGNF4
line 1210
;1210:		} else {
ADDRGP4 $676
JUMPV
LABELV $675
line 1211
;1211:			hcolor[0] = 0;
ADDRLP4 12
CNSTF4 0
ASGNF4
line 1212
;1212:			hcolor[1] = 1;
ADDRLP4 12+4
CNSTF4 1065353216
ASGNF4
line 1213
;1213:			hcolor[2] = 0;
ADDRLP4 12+8
CNSTF4 0
ASGNF4
line 1214
;1214:			hcolor[3] = 0.33;
ADDRLP4 12+12
CNSTF4 1051260355
ASGNF4
line 1215
;1215:		}
LABELV $676
LABELV $670
line 1217
;1216:
;1217:		trap_R_SetColor( hcolor );
ADDRLP4 12
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1218
;1218:		CG_DrawPic( CHATLOC_X, CHATLOC_Y - h, 640, h, cgs.media.teamStatusBar );
CNSTF4 0
ARGF4
ADDRLP4 36
ADDRLP4 32
INDIRI4
ASGNI4
CNSTI4 420
ADDRLP4 36
INDIRI4
SUBI4
CVIF4 4
ARGF4
CNSTF4 1142947840
ARGF4
ADDRLP4 36
INDIRI4
CVIF4 4
ARGF4
ADDRGP4 cgs+170516+60
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1219
;1219:		trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1221
;1220:
;1221:		hcolor[0] = hcolor[1] = hcolor[2] = 1.0;
ADDRLP4 40
CNSTF4 1065353216
ASGNF4
ADDRLP4 12+8
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 40
INDIRF4
ASGNF4
line 1222
;1222:		hcolor[3] = 1.0;
ADDRLP4 12+12
CNSTF4 1065353216
ASGNF4
line 1224
;1223:
;1224:		for (i = cgs.teamChatPos - 1; i >= cgs.teamLastChatPos; i--) {
ADDRLP4 0
ADDRGP4 cgs+170508
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRGP4 $692
JUMPV
LABELV $689
line 1225
;1225:			CG_DrawStringExt( CHATLOC_X + TINYCHAR_WIDTH, 
ADDRLP4 44
CNSTI4 8
ASGNI4
ADDRLP4 44
INDIRI4
ARGI4
CNSTI4 420
ADDRGP4 cgs+170508
INDIRI4
ADDRLP4 0
INDIRI4
SUBI4
CNSTI4 3
LSHI4
SUBI4
ARGI4
CNSTI4 241
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
MODI4
MULI4
ADDRGP4 cgs+168548
ADDP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 52
CNSTI4 0
ASGNI4
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 1229
;1226:				CHATLOC_Y - (cgs.teamChatPos - i)*TINYCHAR_HEIGHT, 
;1227:				cgs.teamChatMsgs[i % chatHeight], hcolor, qfalse, qfalse,
;1228:				TINYCHAR_WIDTH, TINYCHAR_HEIGHT, 0 );
;1229:		}
LABELV $690
line 1224
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
LABELV $692
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+170512
INDIRI4
GEI4 $689
line 1230
;1230:	}
LABELV $647
line 1231
;1231:}
LABELV $640
endproc CG_DrawTeamInfo 56 36
proc CG_DrawHoldableItem 8 20
line 1238
;1232:
;1233:/*
;1234:===================
;1235:CG_DrawHoldableItem
;1236:===================
;1237:*/
;1238:static void CG_DrawHoldableItem( void ) { 
line 1241
;1239:	int		value;
;1240:
;1241:	value = cg.snap->ps.stats[STAT_HOLDABLE_ITEM];
ADDRLP4 0
ADDRGP4 cg+32
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
ASGNI4
line 1242
;1242:	if ( value ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $699
line 1243
;1243:		CG_RegisterItemVisuals( value );
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_RegisterItemVisuals
CALLV
pop
line 1244
;1244:		CG_DrawPic( 640-ICON_SIZE, (SCREEN_HEIGHT-ICON_SIZE)/2, ICON_SIZE, ICON_SIZE, cg_items[ value ].icon );
CNSTF4 1142161408
ARGF4
CNSTF4 1129840640
ARGF4
ADDRLP4 4
CNSTF4 1111490560
ASGNF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
CNSTI4 24
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg_items+20
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1245
;1245:	}
LABELV $699
line 1247
;1246:
;1247:}
LABELV $697
endproc CG_DrawHoldableItem 8 20
proc CG_DrawReward 24 20
line 1255
;1248:
;1249:
;1250:/*
;1251:===================
;1252:CG_DrawReward
;1253:===================
;1254:*/
;1255:static void CG_DrawReward( void ) { 
line 1260
;1256:	float	*color;
;1257:	int		i;
;1258:	float	x, y;
;1259:
;1260:	if ( !cg_drawRewards.integer ) {
ADDRGP4 cg_drawRewards+12
INDIRI4
CNSTI4 0
NEI4 $703
line 1261
;1261:		return;
ADDRGP4 $702
JUMPV
LABELV $703
line 1263
;1262:	}
;1263:	color = CG_FadeColor( cg.rewardTime, REWARD_TIME );
ADDRGP4 cg+111900
INDIRI4
ARGI4
CNSTI4 3000
ARGI4
ADDRLP4 16
ADDRGP4 CG_FadeColor
CALLP4
ASGNP4
ADDRLP4 12
ADDRLP4 16
INDIRP4
ASGNP4
line 1264
;1264:	if ( !color ) {
ADDRLP4 12
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $707
line 1265
;1265:		return;
ADDRGP4 $702
JUMPV
LABELV $707
line 1268
;1266:	}
;1267:
;1268:	trap_R_SetColor( color );
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1269
;1269:	y = 56;
ADDRLP4 8
CNSTF4 1113587712
ASGNF4
line 1270
;1270:	x = 320 - cg.rewardCount * ICON_SIZE/2;
ADDRLP4 4
CNSTI4 320
CNSTI4 48
ADDRGP4 cg+111904
INDIRI4
MULI4
CNSTI4 2
DIVI4
SUBI4
CVIF4 4
ASGNF4
line 1271
;1271:	for ( i = 0 ; i < cg.rewardCount ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $713
JUMPV
LABELV $710
line 1272
;1272:		CG_DrawPic( x, y, ICON_SIZE-4, ICON_SIZE-4, cg.rewardShader );
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 8
INDIRF4
ARGF4
ADDRLP4 20
CNSTF4 1110441984
ASGNF4
ADDRLP4 20
INDIRF4
ARGF4
ADDRLP4 20
INDIRF4
ARGF4
ADDRGP4 cg+111908
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1273
;1273:		x += ICON_SIZE;
ADDRLP4 4
ADDRLP4 4
INDIRF4
CNSTF4 1111490560
ADDF4
ASGNF4
line 1274
;1274:	}
LABELV $711
line 1271
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $713
ADDRLP4 0
INDIRI4
ADDRGP4 cg+111904
INDIRI4
LTI4 $710
line 1275
;1275:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1276
;1276:}
LABELV $702
endproc CG_DrawReward 24 20
export CG_AddLagometerFrameInfo
proc CG_AddLagometerFrameInfo 8 0
line 1307
;1277:
;1278:
;1279:/*
;1280:===============================================================================
;1281:
;1282:LAGOMETER
;1283:
;1284:===============================================================================
;1285:*/
;1286:
;1287:#define	LAG_SAMPLES		128
;1288:
;1289:
;1290:typedef struct {
;1291:	int		frameSamples[LAG_SAMPLES];
;1292:	int		frameCount;
;1293:	int		snapshotFlags[LAG_SAMPLES];
;1294:	int		snapshotSamples[LAG_SAMPLES];
;1295:	int		snapshotCount;
;1296:} lagometer_t;
;1297:
;1298:lagometer_t		lagometer;
;1299:
;1300:/*
;1301:==============
;1302:CG_AddLagometerFrameInfo
;1303:
;1304:Adds the current interpolate / extrapolate bar for this frame
;1305:==============
;1306:*/
;1307:void CG_AddLagometerFrameInfo( void ) {
line 1310
;1308:	int			offset;
;1309:
;1310:	offset = cg.time - cg.latestSnapshotTime;
ADDRLP4 0
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+28
INDIRI4
SUBI4
ASGNI4
line 1311
;1311:	lagometer.frameSamples[ lagometer.frameCount & ( LAG_SAMPLES - 1) ] = offset;
ADDRGP4 lagometer+512
INDIRI4
CNSTI4 127
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1312
;1312:	lagometer.frameCount++;
ADDRLP4 4
ADDRGP4 lagometer+512
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1313
;1313:}
LABELV $717
endproc CG_AddLagometerFrameInfo 8 0
export CG_AddLagometerSnapshotInfo
proc CG_AddLagometerSnapshotInfo 4 0
line 1325
;1314:
;1315:/*
;1316:==============
;1317:CG_AddLagometerSnapshotInfo
;1318:
;1319:Each time a snapshot is received, log its ping time and
;1320:the number of snapshots that were dropped before it.
;1321:
;1322:Pass NULL for a dropped packet.
;1323:==============
;1324:*/
;1325:void CG_AddLagometerSnapshotInfo( snapshot_t *snap ) {
line 1327
;1326:	// dropped packet
;1327:	if ( !snap ) {
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $723
line 1328
;1328:		lagometer.snapshotSamples[ lagometer.snapshotCount & ( LAG_SAMPLES - 1) ] = -1;
ADDRGP4 lagometer+1540
INDIRI4
CNSTI4 127
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer+1028
ADDP4
CNSTI4 -1
ASGNI4
line 1329
;1329:		lagometer.snapshotCount++;
ADDRLP4 0
ADDRGP4 lagometer+1540
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1330
;1330:		return;
ADDRGP4 $722
JUMPV
LABELV $723
line 1334
;1331:	}
;1332:
;1333:	// add this snapshot's info
;1334:	lagometer.snapshotSamples[ lagometer.snapshotCount & ( LAG_SAMPLES - 1) ] = snap->ping;
ADDRGP4 lagometer+1540
INDIRI4
CNSTI4 127
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer+1028
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 1335
;1335:	lagometer.snapshotFlags[ lagometer.snapshotCount & ( LAG_SAMPLES - 1) ] = snap->snapFlags;
ADDRGP4 lagometer+1540
INDIRI4
CNSTI4 127
BANDI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer+516
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 1336
;1336:	lagometer.snapshotCount++;
ADDRLP4 0
ADDRGP4 lagometer+1540
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1337
;1337:}
LABELV $722
endproc CG_AddLagometerSnapshotInfo 4 0
proc CG_DrawDisconnect 64 20
line 1346
;1338:
;1339:/*
;1340:==============
;1341:CG_DrawDisconnect
;1342:
;1343:Should we draw something differnet for long lag vs no packets?
;1344:==============
;1345:*/
;1346:static void CG_DrawDisconnect( void ) {
line 1354
;1347:	float		x, y;
;1348:	int			cmdNum;
;1349:	usercmd_t	cmd;
;1350:	const char		*s;
;1351:	int			w;
;1352:
;1353:	// draw the phone jack if we are completely past our buffers
;1354:	cmdNum = trap_GetCurrentCmdNumber() - CMD_BACKUP + 1;
ADDRLP4 44
ADDRGP4 trap_GetCurrentCmdNumber
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 44
INDIRI4
CNSTI4 64
SUBI4
CNSTI4 1
ADDI4
ASGNI4
line 1355
;1355:	trap_GetUserCmd( cmdNum, &cmd );
ADDRLP4 36
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_GetUserCmd
CALLI4
pop
line 1356
;1356:	if ( cmd.serverTime <= cg.snap->ps.commandTime
ADDRLP4 48
ADDRLP4 0
INDIRI4
ASGNI4
ADDRLP4 48
INDIRI4
ADDRGP4 cg+32
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
LEI4 $738
ADDRLP4 48
INDIRI4
ADDRGP4 cg+105504
INDIRI4
LEI4 $734
LABELV $738
line 1357
;1357:		|| cmd.serverTime > cg.time ) {	// special check for map_restart
line 1358
;1358:		return;
ADDRGP4 $733
JUMPV
LABELV $734
line 1362
;1359:	}
;1360:
;1361:	// also add text in center of screen
;1362:	s = "Connection Interrupted";
ADDRLP4 24
ADDRGP4 $739
ASGNP4
line 1363
;1363:	w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 52
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 52
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 1364
;1364:	CG_DrawBigString( 320 - w/2, 100, s, 1.0F);
CNSTI4 320
ADDRLP4 40
INDIRI4
CNSTI4 2
DIVI4
SUBI4
ARGI4
CNSTI4 100
ARGI4
ADDRLP4 24
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1367
;1365:
;1366:	// blink the icon
;1367:	if ( ( cg.time >> 9 ) & 1 ) {
ADDRGP4 cg+105504
INDIRI4
CNSTI4 9
RSHI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $740
line 1368
;1368:		return;
ADDRGP4 $733
JUMPV
LABELV $740
line 1371
;1369:	}
;1370:
;1371:	x = 640 - 48;
ADDRLP4 28
CNSTF4 1142161408
ASGNF4
line 1372
;1372:	y = 480 - 48;
ADDRLP4 32
CNSTF4 1138229248
ASGNF4
line 1374
;1373:
;1374:	CG_DrawPic( x, y, 48, 48, trap_R_RegisterShader("gfx/2d/net.tga" ) );
ADDRGP4 $743
ARGP4
ADDRLP4 56
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 28
INDIRF4
ARGF4
ADDRLP4 32
INDIRF4
ARGF4
ADDRLP4 60
CNSTF4 1111490560
ASGNF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRLP4 56
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1375
;1375:}
LABELV $733
endproc CG_DrawDisconnect 64 20
proc CG_DrawLagometer 68 36
line 1386
;1376:
;1377:
;1378:#define	MAX_LAGOMETER_PING	900
;1379:#define	MAX_LAGOMETER_RANGE	300
;1380:
;1381:/*
;1382:==============
;1383:CG_DrawLagometer
;1384:==============
;1385:*/
;1386:static void CG_DrawLagometer( void ) {
line 1393
;1387:	int		a, x, y, i;
;1388:	float	v;
;1389:	float	ax, ay, aw, ah, mid, range;
;1390:	int		color;
;1391:	float	vscale;
;1392:
;1393:	if ( !cg_lagometer.integer || cgs.localServer ) {
ADDRLP4 52
CNSTI4 0
ASGNI4
ADDRGP4 cg_lagometer+12
INDIRI4
ADDRLP4 52
INDIRI4
EQI4 $749
ADDRGP4 cgs+24284
INDIRI4
ADDRLP4 52
INDIRI4
EQI4 $745
LABELV $749
line 1394
;1394:		CG_DrawDisconnect();
ADDRGP4 CG_DrawDisconnect
CALLV
pop
line 1395
;1395:		return;
ADDRGP4 $744
JUMPV
LABELV $745
line 1401
;1396:	}
;1397:
;1398:	//
;1399:	// draw the graph
;1400:	//
;1401:	x = 640 - 48;
ADDRLP4 44
CNSTI4 592
ASGNI4
line 1402
;1402:	y = 480 - 48;
ADDRLP4 48
CNSTI4 432
ASGNI4
line 1404
;1403:
;1404:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1405
;1405:	CG_DrawPic( x, y, 48, 48, cgs.media.lagometerShader );
ADDRLP4 44
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 48
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 56
CNSTF4 1111490560
ASGNF4
ADDRLP4 56
INDIRF4
ARGF4
ADDRLP4 56
INDIRF4
ARGF4
ADDRGP4 cgs+170516+192
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1407
;1406:
;1407:	ax = x;
ADDRLP4 24
ADDRLP4 44
INDIRI4
CVIF4 4
ASGNF4
line 1408
;1408:	ay = y;
ADDRLP4 36
ADDRLP4 48
INDIRI4
CVIF4 4
ASGNF4
line 1409
;1409:	aw = 48;
ADDRLP4 12
CNSTF4 1111490560
ASGNF4
line 1410
;1410:	ah = 48;
ADDRLP4 32
CNSTF4 1111490560
ASGNF4
line 1411
;1411:	CG_AdjustFrom640( &ax, &ay, &aw, &ah );
ADDRLP4 24
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 32
ARGP4
ADDRGP4 CG_AdjustFrom640
CALLV
pop
line 1413
;1412:
;1413:	color = -1;
ADDRLP4 20
CNSTI4 -1
ASGNI4
line 1414
;1414:	range = ah / 3;
ADDRLP4 16
ADDRLP4 32
INDIRF4
CNSTF4 1077936128
DIVF4
ASGNF4
line 1415
;1415:	mid = ay + range;
ADDRLP4 40
ADDRLP4 36
INDIRF4
ADDRLP4 16
INDIRF4
ADDF4
ASGNF4
line 1417
;1416:
;1417:	vscale = range / MAX_LAGOMETER_RANGE;
ADDRLP4 28
ADDRLP4 16
INDIRF4
CNSTF4 1133903872
DIVF4
ASGNF4
line 1420
;1418:
;1419:	// draw the frame interpoalte / extrapolate graph
;1420:	for ( a = 0 ; a < aw ; a++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $755
JUMPV
LABELV $752
line 1421
;1421:		i = ( lagometer.frameCount - 1 - a ) & (LAG_SAMPLES - 1);
ADDRLP4 8
ADDRGP4 lagometer+512
INDIRI4
CNSTI4 1
SUBI4
ADDRLP4 4
INDIRI4
SUBI4
CNSTI4 127
BANDI4
ASGNI4
line 1422
;1422:		v = lagometer.frameSamples[i];
ADDRLP4 0
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 1423
;1423:		v *= vscale;
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 1424
;1424:		if ( v > 0 ) {
ADDRLP4 0
INDIRF4
CNSTF4 0
LEF4 $757
line 1425
;1425:			if ( color != 1 ) {
ADDRLP4 20
INDIRI4
CNSTI4 1
EQI4 $759
line 1426
;1426:				color = 1;
ADDRLP4 20
CNSTI4 1
ASGNI4
line 1427
;1427:				trap_R_SetColor( g_color_table[ColorIndex(COLOR_YELLOW)] );
ADDRGP4 g_color_table+48
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1428
;1428:			}
LABELV $759
line 1429
;1429:			if ( v > range ) {
ADDRLP4 0
INDIRF4
ADDRLP4 16
INDIRF4
LEF4 $762
line 1430
;1430:				v = range;
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 1431
;1431:			}
LABELV $762
line 1432
;1432:			trap_R_DrawStretchPic ( ax + aw - a, mid - v, 1, v, 0, 0, 0, 0, cgs.media.whiteShader );
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ADDRLP4 4
INDIRI4
CVIF4 4
SUBF4
ARGF4
ADDRLP4 40
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 64
CNSTF4 0
ASGNF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRGP4 cgs+170516+16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 1433
;1433:		} else if ( v < 0 ) {
ADDRGP4 $758
JUMPV
LABELV $757
ADDRLP4 0
INDIRF4
CNSTF4 0
GEF4 $766
line 1434
;1434:			if ( color != 2 ) {
ADDRLP4 20
INDIRI4
CNSTI4 2
EQI4 $768
line 1435
;1435:				color = 2;
ADDRLP4 20
CNSTI4 2
ASGNI4
line 1436
;1436:				trap_R_SetColor( g_color_table[ColorIndex(COLOR_BLUE)] );
ADDRGP4 g_color_table+64
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1437
;1437:			}
LABELV $768
line 1438
;1438:			v = -v;
ADDRLP4 0
ADDRLP4 0
INDIRF4
NEGF4
ASGNF4
line 1439
;1439:			if ( v > range ) {
ADDRLP4 0
INDIRF4
ADDRLP4 16
INDIRF4
LEF4 $771
line 1440
;1440:				v = range;
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 1441
;1441:			}
LABELV $771
line 1442
;1442:			trap_R_DrawStretchPic( ax + aw - a, mid, 1, v, 0, 0, 0, 0, cgs.media.whiteShader );
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ADDRLP4 4
INDIRI4
CVIF4 4
SUBF4
ARGF4
ADDRLP4 40
INDIRF4
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 60
CNSTF4 0
ASGNF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRLP4 60
INDIRF4
ARGF4
ADDRGP4 cgs+170516+16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 1443
;1443:		}
LABELV $766
LABELV $758
line 1444
;1444:	}
LABELV $753
line 1420
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $755
ADDRLP4 4
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRF4
LTF4 $752
line 1447
;1445:
;1446:	// draw the snapshot latency / drop graph
;1447:	range = ah / 2;
ADDRLP4 16
ADDRLP4 32
INDIRF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 1448
;1448:	vscale = range / MAX_LAGOMETER_PING;
ADDRLP4 28
ADDRLP4 16
INDIRF4
CNSTF4 1147207680
DIVF4
ASGNF4
line 1450
;1449:
;1450:	for ( a = 0 ; a < aw ; a++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $778
JUMPV
LABELV $775
line 1451
;1451:		i = ( lagometer.snapshotCount - 1 - a ) & (LAG_SAMPLES - 1);
ADDRLP4 8
ADDRGP4 lagometer+1540
INDIRI4
CNSTI4 1
SUBI4
ADDRLP4 4
INDIRI4
SUBI4
CNSTI4 127
BANDI4
ASGNI4
line 1452
;1452:		v = lagometer.snapshotSamples[i];
ADDRLP4 0
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer+1028
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 1453
;1453:		if ( v > 0 ) {
ADDRLP4 0
INDIRF4
CNSTF4 0
LEF4 $781
line 1454
;1454:			if ( lagometer.snapshotFlags[i] & SNAPFLAG_RATE_DELAYED ) {
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 lagometer+516
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $783
line 1455
;1455:				if ( color != 5 ) {
ADDRLP4 20
INDIRI4
CNSTI4 5
EQI4 $784
line 1456
;1456:					color = 5;	// YELLOW for rate delay
ADDRLP4 20
CNSTI4 5
ASGNI4
line 1457
;1457:					trap_R_SetColor( g_color_table[ColorIndex(COLOR_YELLOW)] );
ADDRGP4 g_color_table+48
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1458
;1458:				}
line 1459
;1459:			} else {
ADDRGP4 $784
JUMPV
LABELV $783
line 1460
;1460:				if ( color != 3 ) {
ADDRLP4 20
INDIRI4
CNSTI4 3
EQI4 $789
line 1461
;1461:					color = 3;
ADDRLP4 20
CNSTI4 3
ASGNI4
line 1462
;1462:					trap_R_SetColor( g_color_table[ColorIndex(COLOR_GREEN)] );
ADDRGP4 g_color_table+32
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1463
;1463:				}
LABELV $789
line 1464
;1464:			}
LABELV $784
line 1465
;1465:			v = v * vscale;
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 1466
;1466:			if ( v > range ) {
ADDRLP4 0
INDIRF4
ADDRLP4 16
INDIRF4
LEF4 $792
line 1467
;1467:				v = range;
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 1468
;1468:			}
LABELV $792
line 1469
;1469:			trap_R_DrawStretchPic( ax + aw - a, ay + ah - v, 1, v, 0, 0, 0, 0, cgs.media.whiteShader );
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ADDRLP4 4
INDIRI4
CVIF4 4
SUBF4
ARGF4
ADDRLP4 36
INDIRF4
ADDRLP4 32
INDIRF4
ADDF4
ADDRLP4 0
INDIRF4
SUBF4
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 64
CNSTF4 0
ASGNF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRGP4 cgs+170516+16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 1470
;1470:		} else if ( v < 0 ) {
ADDRGP4 $782
JUMPV
LABELV $781
ADDRLP4 0
INDIRF4
CNSTF4 0
GEF4 $796
line 1471
;1471:			if ( color != 4 ) {
ADDRLP4 20
INDIRI4
CNSTI4 4
EQI4 $798
line 1472
;1472:				color = 4;		// RED for dropped snapshots
ADDRLP4 20
CNSTI4 4
ASGNI4
line 1473
;1473:				trap_R_SetColor( g_color_table[ColorIndex(COLOR_RED)] );
ADDRGP4 g_color_table+16
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1474
;1474:			}
LABELV $798
line 1475
;1475:			trap_R_DrawStretchPic( ax + aw - a, ay + ah - range, 1, range, 0, 0, 0, 0, cgs.media.whiteShader );
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ADDRLP4 4
INDIRI4
CVIF4 4
SUBF4
ARGF4
ADDRLP4 36
INDIRF4
ADDRLP4 32
INDIRF4
ADDF4
ADDRLP4 16
INDIRF4
SUBF4
ARGF4
CNSTF4 1065353216
ARGF4
ADDRLP4 16
INDIRF4
ARGF4
ADDRLP4 64
CNSTF4 0
ASGNF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRLP4 64
INDIRF4
ARGF4
ADDRGP4 cgs+170516+16
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 1476
;1476:		}
LABELV $796
LABELV $782
line 1477
;1477:	}
LABELV $776
line 1450
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $778
ADDRLP4 4
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRF4
LTF4 $775
line 1479
;1478:
;1479:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1481
;1480:
;1481:	if ( cg_nopredict.integer || cg_syncronousClients.integer ) {
ADDRLP4 60
CNSTI4 0
ASGNI4
ADDRGP4 cg_nopredict+12
INDIRI4
ADDRLP4 60
INDIRI4
NEI4 $807
ADDRGP4 cg_syncronousClients+12
INDIRI4
ADDRLP4 60
INDIRI4
EQI4 $803
LABELV $807
line 1482
;1482:		CG_DrawBigString( ax, ay, "snc", 1.0 );
ADDRLP4 24
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 36
INDIRF4
CVFI4 4
ARGI4
ADDRGP4 $808
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1483
;1483:	}
LABELV $803
line 1485
;1484:
;1485:	CG_DrawDisconnect();
ADDRGP4 CG_DrawDisconnect
CALLV
pop
line 1486
;1486:}
LABELV $744
endproc CG_DrawLagometer 68 36
export CG_CenterPrint
proc CG_CenterPrint 8 12
line 1507
;1487:
;1488:
;1489:
;1490:/*
;1491:===============================================================================
;1492:
;1493:CENTER PRINTING
;1494:
;1495:===============================================================================
;1496:*/
;1497:
;1498:
;1499:/*
;1500:==============
;1501:CG_CenterPrint
;1502:
;1503:Called for important messages that should stay in the center of the screen
;1504:for a few moments
;1505:==============
;1506:*/
;1507:void CG_CenterPrint( const char *str, int y, int charWidth ) {
line 1510
;1508:	char	*s;
;1509:
;1510:	Q_strncpyz( cg.centerPrint, str, sizeof(cg.centerPrint) );
ADDRGP4 cg+110844
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1512
;1511:
;1512:	cg.centerPrintTime = cg.time;
ADDRGP4 cg+110832
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1513
;1513:	cg.centerPrintY = y;
ADDRGP4 cg+110840
ADDRFP4 4
INDIRI4
ASGNI4
line 1514
;1514:	cg.centerPrintCharWidth = charWidth;
ADDRGP4 cg+110836
ADDRFP4 8
INDIRI4
ASGNI4
line 1517
;1515:
;1516:	// count the number of lines for centering
;1517:	cg.centerPrintLines = 1;
ADDRGP4 cg+111868
CNSTI4 1
ASGNI4
line 1518
;1518:	s = cg.centerPrint;
ADDRLP4 0
ADDRGP4 cg+110844
ASGNP4
ADDRGP4 $819
JUMPV
LABELV $818
line 1519
;1519:	while( *s ) {
line 1520
;1520:		if (*s == '\n')
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 10
NEI4 $821
line 1521
;1521:			cg.centerPrintLines++;
ADDRLP4 4
ADDRGP4 cg+111868
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $821
line 1522
;1522:		s++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 1523
;1523:	}
LABELV $819
line 1519
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $818
line 1524
;1524:}
LABELV $809
endproc CG_CenterPrint 8 12
proc CG_DrawCenterString 1064 36
line 1532
;1525:
;1526:
;1527:/*
;1528:===================
;1529:CG_DrawCenterString
;1530:===================
;1531:*/
;1532:static void CG_DrawCenterString( void ) {
line 1538
;1533:	char	*start;
;1534:	int		l;
;1535:	int		x, y, w;
;1536:	float	*color;
;1537:
;1538:	if ( !cg.centerPrintTime ) {
ADDRGP4 cg+110832
INDIRI4
CNSTI4 0
NEI4 $825
line 1539
;1539:		return;
ADDRGP4 $824
JUMPV
LABELV $825
line 1542
;1540:	}
;1541:
;1542:	color = CG_FadeColor( cg.centerPrintTime, 1000 * cg_centertime.value );
ADDRGP4 cg+110832
INDIRI4
ARGI4
CNSTF4 1148846080
ADDRGP4 cg_centertime+8
INDIRF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 24
ADDRGP4 CG_FadeColor
CALLP4
ASGNP4
ADDRLP4 20
ADDRLP4 24
INDIRP4
ASGNP4
line 1543
;1543:	if ( !color ) {
ADDRLP4 20
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $830
line 1544
;1544:		return;
ADDRGP4 $824
JUMPV
LABELV $830
line 1547
;1545:	}
;1546:
;1547:	trap_R_SetColor( color );
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1549
;1548:
;1549:	start = cg.centerPrint;
ADDRLP4 0
ADDRGP4 cg+110844
ASGNP4
line 1551
;1550:
;1551:	y = cg.centerPrintY - cg.centerPrintLines * BIGCHAR_HEIGHT / 2;
ADDRLP4 8
ADDRGP4 cg+110840
INDIRI4
ADDRGP4 cg+111868
INDIRI4
CNSTI4 4
LSHI4
CNSTI4 2
DIVI4
SUBI4
ASGNI4
ADDRGP4 $836
JUMPV
LABELV $835
line 1553
;1552:
;1553:	while ( 1 ) {
line 1556
;1554:		char linebuffer[1024];
;1555:
;1556:		for ( l = 0; l < 40; l++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $838
line 1557
;1557:			if ( !start[l] || start[l] == '\n' ) {
ADDRLP4 1052
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 1052
INDIRI4
CNSTI4 0
EQI4 $844
ADDRLP4 1052
INDIRI4
CNSTI4 10
NEI4 $842
LABELV $844
line 1558
;1558:				break;
ADDRGP4 $840
JUMPV
LABELV $842
line 1560
;1559:			}
;1560:			linebuffer[l] = start[l];
ADDRLP4 4
INDIRI4
ADDRLP4 28
ADDP4
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI1
ASGNI1
line 1561
;1561:		}
LABELV $839
line 1556
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 40
LTI4 $838
LABELV $840
line 1562
;1562:		linebuffer[l] = 0;
ADDRLP4 4
INDIRI4
ADDRLP4 28
ADDP4
CNSTI1 0
ASGNI1
line 1564
;1563:
;1564:		w = cg.centerPrintCharWidth * CG_DrawStrlen( linebuffer );
ADDRLP4 28
ARGP4
ADDRLP4 1052
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
ADDRGP4 cg+110836
INDIRI4
ADDRLP4 1052
INDIRI4
MULI4
ASGNI4
line 1566
;1565:
;1566:		x = ( SCREEN_WIDTH - w ) / 2;
ADDRLP4 12
CNSTI4 640
ADDRLP4 16
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 1568
;1567:
;1568:		CG_DrawStringExt( x, y, linebuffer, color, qfalse, qtrue,
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 8
INDIRI4
ARGI4
ADDRLP4 28
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 1056
CNSTI4 0
ASGNI4
ADDRLP4 1056
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 cg+110836
INDIRI4
ARGI4
CNSTF4 1069547520
ADDRGP4 cg+110836
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ARGI4
ADDRLP4 1056
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 1571
;1569:			cg.centerPrintCharWidth, (int)(cg.centerPrintCharWidth * 1.5), 0 );
;1570:
;1571:		y += cg.centerPrintCharWidth * 1.5;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CVIF4 4
CNSTF4 1069547520
ADDRGP4 cg+110836
INDIRI4
CVIF4 4
MULF4
ADDF4
CVFI4 4
ASGNI4
ADDRGP4 $850
JUMPV
LABELV $849
line 1573
;1572:
;1573:		while ( *start && ( *start != '\n' ) ) {
line 1574
;1574:			start++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 1575
;1575:		}
LABELV $850
line 1573
ADDRLP4 1060
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 1060
INDIRI4
CNSTI4 0
EQI4 $852
ADDRLP4 1060
INDIRI4
CNSTI4 10
NEI4 $849
LABELV $852
line 1576
;1576:		if ( !*start ) {
ADDRLP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $853
line 1577
;1577:			break;
ADDRGP4 $837
JUMPV
LABELV $853
line 1579
;1578:		}
;1579:		start++;
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 1580
;1580:	}
LABELV $836
line 1553
ADDRGP4 $835
JUMPV
LABELV $837
line 1582
;1581:
;1582:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1583
;1583:}
LABELV $824
endproc CG_DrawCenterString 1064 36
proc CG_DrawCrosshair 52 36
line 1601
;1584:
;1585:
;1586:
;1587:/*
;1588:================================================================================
;1589:
;1590:CROSSHAIR
;1591:
;1592:================================================================================
;1593:*/
;1594:
;1595:
;1596:/*
;1597:=================
;1598:CG_DrawCrosshair
;1599:=================
;1600:*/
;1601:static void CG_DrawCrosshair(void) {
line 1607
;1602:	float		w, h;
;1603:	qhandle_t	hShader;
;1604:	float		f;
;1605:	float		x, y;
;1606:
;1607:	if ( !cg_drawCrosshair.integer ) {
ADDRGP4 cg_drawCrosshair+12
INDIRI4
CNSTI4 0
NEI4 $856
line 1608
;1608:		return;
ADDRGP4 $855
JUMPV
LABELV $856
line 1611
;1609:	}
;1610:
;1611:	if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
NEI4 $859
line 1612
;1612:		return;
ADDRGP4 $855
JUMPV
LABELV $859
line 1615
;1613:	}
;1614:
;1615:	if ( cg.renderingThirdPerson ) {
ADDRGP4 cg+105524
INDIRI4
CNSTI4 0
EQI4 $862
line 1616
;1616:		return;
ADDRGP4 $855
JUMPV
LABELV $862
line 1620
;1617:	}
;1618:
;1619:	// set color based on health
;1620:	if ( cg_crosshairHealth.integer ) {
ADDRGP4 cg_crosshairHealth+12
INDIRI4
CNSTI4 0
EQI4 $865
line 1623
;1621:		vec4_t		hcolor;
;1622:
;1623:		CG_ColorForHealth( hcolor );
ADDRLP4 24
ARGP4
ADDRGP4 CG_ColorForHealth
CALLV
pop
line 1624
;1624:		trap_R_SetColor( hcolor );
ADDRLP4 24
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1625
;1625:	} else {
ADDRGP4 $866
JUMPV
LABELV $865
line 1626
;1626:		trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1627
;1627:	}
LABELV $866
line 1629
;1628:
;1629:	w = h = cg_crosshairSize.value;
ADDRLP4 24
ADDRGP4 cg_crosshairSize+8
INDIRF4
ASGNF4
ADDRLP4 4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 24
INDIRF4
ASGNF4
line 1632
;1630:
;1631:	// pulse the size of the crosshair when picking up items
;1632:	f = cg.time - cg.itemPickupBlendTime;
ADDRLP4 8
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cg+111928
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 1633
;1633:	if ( f > 0 && f < ITEM_BLOB_TIME ) {
ADDRLP4 8
INDIRF4
CNSTF4 0
LEF4 $871
ADDRLP4 8
INDIRF4
CNSTF4 1128792064
GEF4 $871
line 1634
;1634:		f /= ITEM_BLOB_TIME;
ADDRLP4 8
ADDRLP4 8
INDIRF4
CNSTF4 1128792064
DIVF4
ASGNF4
line 1635
;1635:		w *= ( 1 + f );
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
ADDF4
MULF4
ASGNF4
line 1636
;1636:		h *= ( 1 + f );
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
ADDF4
MULF4
ASGNF4
line 1637
;1637:	}
LABELV $871
line 1639
;1638:
;1639:	x = cg_crosshairX.integer;
ADDRLP4 12
ADDRGP4 cg_crosshairX+12
INDIRI4
CVIF4 4
ASGNF4
line 1640
;1640:	y = cg_crosshairY.integer;
ADDRLP4 16
ADDRGP4 cg_crosshairY+12
INDIRI4
CVIF4 4
ASGNF4
line 1641
;1641:	CG_AdjustFrom640( &x, &y, &w, &h );
ADDRLP4 12
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 CG_AdjustFrom640
CALLV
pop
line 1643
;1642:
;1643:	hShader = cgs.media.crosshairShader[ cg_drawCrosshair.integer % NUM_CROSSHAIRS ];
ADDRLP4 20
ADDRGP4 cg_drawCrosshair+12
INDIRI4
CNSTI4 10
MODI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+170516+152
ADDP4
INDIRI4
ASGNI4
line 1645
;1644:
;1645:	trap_R_DrawStretchPic( x + cg.refdef.x + 0.5 * (cg.refdef.width - w), 
ADDRLP4 32
CNSTF4 1056964608
ASGNF4
ADDRLP4 36
ADDRLP4 0
INDIRF4
ASGNF4
ADDRLP4 12
INDIRF4
ADDRGP4 cg+106800
INDIRI4
CVIF4 4
ADDF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+106800+8
INDIRI4
CVIF4 4
ADDRLP4 36
INDIRF4
SUBF4
MULF4
ADDF4
ARGF4
ADDRLP4 40
ADDRLP4 4
INDIRF4
ASGNF4
ADDRLP4 16
INDIRF4
ADDRGP4 cg+106800+4
INDIRI4
CVIF4 4
ADDF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+106800+12
INDIRI4
CVIF4 4
ADDRLP4 40
INDIRF4
SUBF4
MULF4
ADDF4
ARGF4
ADDRLP4 36
INDIRF4
ARGF4
ADDRLP4 40
INDIRF4
ARGF4
ADDRLP4 44
CNSTF4 0
ASGNF4
ADDRLP4 44
INDIRF4
ARGF4
ADDRLP4 44
INDIRF4
ARGF4
ADDRLP4 48
CNSTF4 1065353216
ASGNF4
ADDRLP4 48
INDIRF4
ARGF4
ADDRLP4 48
INDIRF4
ARGF4
ADDRLP4 20
INDIRI4
ARGI4
ADDRGP4 trap_R_DrawStretchPic
CALLV
pop
line 1648
;1646:		y + cg.refdef.y + 0.5 * (cg.refdef.height - h), 
;1647:		w, h, 0, 0, 1, 1, hShader );
;1648:}
LABELV $855
endproc CG_DrawCrosshair 52 36
proc CG_ScanForCrosshairEntity 96 28
line 1657
;1649:
;1650:
;1651:
;1652:/*
;1653:=================
;1654:CG_ScanForCrosshairEntity
;1655:=================
;1656:*/
;1657:static void CG_ScanForCrosshairEntity( void ) {
line 1662
;1658:	trace_t		trace;
;1659:	vec3_t		start, end;
;1660:	int			content;
;1661:
;1662:	VectorCopy( cg.refdef.vieworg, start );
ADDRLP4 56
ADDRGP4 cg+106800+24
INDIRB
ASGNB 12
line 1663
;1663:	VectorMA( start, 8192, cg.refdef.viewaxis[0], end );
ADDRLP4 84
CNSTF4 1174405120
ASGNF4
ADDRLP4 68
ADDRLP4 56
INDIRF4
ADDRLP4 84
INDIRF4
ADDRGP4 cg+106800+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 68+4
ADDRLP4 56+4
INDIRF4
ADDRLP4 84
INDIRF4
ADDRGP4 cg+106800+36+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 68+8
ADDRLP4 56+8
INDIRF4
CNSTF4 1174405120
ADDRGP4 cg+106800+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1665
;1664:
;1665:	CG_Trace( &trace, start, vec3_origin, vec3_origin, end, 
ADDRLP4 0
ARGP4
ADDRLP4 56
ARGP4
ADDRLP4 88
ADDRGP4 vec3_origin
ASGNP4
ADDRLP4 88
INDIRP4
ARGP4
ADDRLP4 88
INDIRP4
ARGP4
ADDRLP4 68
ARGP4
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ARGI4
CNSTI4 33554433
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 1667
;1666:		cg.snap->ps.clientNum, CONTENTS_SOLID|CONTENTS_BODY );
;1667:	if ( trace.entityNum >= MAX_CLIENTS ) {
ADDRLP4 0+52
INDIRI4
CNSTI4 128
LTI4 $901
line 1668
;1668:		return;
ADDRGP4 $885
JUMPV
LABELV $901
line 1672
;1669:	}
;1670:
;1671:	// if the player is in fog, don't show it
;1672:	content = trap_CM_PointContents( trace.endpos, 0 );
ADDRLP4 0+12
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 92
ADDRGP4 trap_CM_PointContents
CALLI4
ASGNI4
ADDRLP4 80
ADDRLP4 92
INDIRI4
ASGNI4
line 1673
;1673:	if ( content & CONTENTS_FOG ) {
ADDRLP4 80
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
EQI4 $905
line 1674
;1674:		return;
ADDRGP4 $885
JUMPV
LABELV $905
line 1678
;1675:	}
;1676:
;1677:	// if the player is invisible, don't show it
;1678:	if ( cg_entities[ trace.entityNum ].currentState.powerups & ( 1 << PW_INVIS ) ) {
CNSTI4 680
ADDRLP4 0+52
INDIRI4
MULI4
ADDRGP4 cg_entities+188
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $907
line 1679
;1679:		return;
ADDRGP4 $885
JUMPV
LABELV $907
line 1683
;1680:	}
;1681:
;1682:	// update the fade timer
;1683:	cg.crosshairClientNum = trace.entityNum;
ADDRGP4 cg+111880
ADDRLP4 0+52
INDIRI4
ASGNI4
line 1684
;1684:	cg.crosshairClientTime = cg.time;
ADDRGP4 cg+111884
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1685
;1685:}
LABELV $885
endproc CG_ScanForCrosshairEntity 96 28
proc CG_DrawCrosshairNames 20 16
line 1693
;1686:
;1687:
;1688:/*
;1689:=====================
;1690:CG_DrawCrosshairNames
;1691:=====================
;1692:*/
;1693:static void CG_DrawCrosshairNames( void ) {
line 1698
;1694:	float		*color;
;1695:	char		*name;
;1696:	float		w;
;1697:
;1698:	if ( !cg_drawCrosshair.integer ) {
ADDRGP4 cg_drawCrosshair+12
INDIRI4
CNSTI4 0
NEI4 $916
line 1699
;1699:		return;
ADDRGP4 $915
JUMPV
LABELV $916
line 1701
;1700:	}
;1701:	if ( !cg_drawCrosshairNames.integer ) {
ADDRGP4 cg_drawCrosshairNames+12
INDIRI4
CNSTI4 0
NEI4 $919
line 1702
;1702:		return;
ADDRGP4 $915
JUMPV
LABELV $919
line 1704
;1703:	}
;1704:	if ( cg.renderingThirdPerson ) {
ADDRGP4 cg+105524
INDIRI4
CNSTI4 0
EQI4 $922
line 1705
;1705:		return;
ADDRGP4 $915
JUMPV
LABELV $922
line 1709
;1706:	}
;1707:
;1708:	// scan the known entities to see if the crosshair is sighted on one
;1709:	CG_ScanForCrosshairEntity();
ADDRGP4 CG_ScanForCrosshairEntity
CALLV
pop
line 1712
;1710:
;1711:	// draw the name of the player being looked at
;1712:	color = CG_FadeColor( cg.crosshairClientTime, 1000 );
ADDRGP4 cg+111884
INDIRI4
ARGI4
CNSTI4 1000
ARGI4
ADDRLP4 12
ADDRGP4 CG_FadeColor
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRP4
ASGNP4
line 1713
;1713:	if ( !color ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $926
line 1714
;1714:		trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1715
;1715:		return;
ADDRGP4 $915
JUMPV
LABELV $926
line 1718
;1716:	}
;1717:
;1718:	name = cgs.clientinfo[ cg.crosshairClientNum ].name;
ADDRLP4 4
CNSTI4 1076
ADDRGP4 cg+111880
INDIRI4
MULI4
ADDRGP4 cgs+30820+4
ADDP4
ASGNP4
line 1719
;1719:	w = CG_DrawStrlen( name ) * BIGCHAR_WIDTH;
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 16
INDIRI4
CNSTI4 4
LSHI4
CVIF4 4
ASGNF4
line 1720
;1720:	CG_DrawBigString( 320 - w / 2, 170, name, color[3] * 0.5 );
CNSTF4 1134559232
ADDRLP4 8
INDIRF4
CNSTF4 1073741824
DIVF4
SUBF4
CVFI4 4
ARGI4
CNSTI4 170
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
CNSTF4 1056964608
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
MULF4
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1722
;1721:
;1722:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1723
;1723:}
LABELV $915
endproc CG_DrawCrosshairNames 20 16
proc CG_DrawSpectator 0 16
line 1734
;1724:
;1725:
;1726:
;1727://==============================================================================
;1728:
;1729:/*
;1730:=================
;1731:CG_DrawSpectator
;1732:=================
;1733:*/
;1734:static void CG_DrawSpectator(void) {
line 1735
;1735:	CG_DrawBigString(320 - 9 * 8, 440, "SPECTATOR", 1.0F);
CNSTI4 248
ARGI4
CNSTI4 440
ARGI4
ADDRGP4 $932
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1736
;1736:	if ( cgs.gametype == GT_TOURNAMENT ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 1
NEI4 $933
line 1737
;1737:		CG_DrawBigString(320 - 15 * 8, 460, "waiting to play", 1.0F);
CNSTI4 200
ARGI4
CNSTI4 460
ARGI4
ADDRGP4 $936
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1738
;1738:	}
LABELV $933
line 1739
;1739:	if ( cgs.gametype == GT_TEAM || cgs.gametype == GT_CTF ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
EQI4 $941
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 4
NEI4 $937
LABELV $941
line 1740
;1740:		CG_DrawBigString(320 - 25 * 8, 460, "use the TEAM menu to play", 1.0F);
CNSTI4 120
ARGI4
CNSTI4 460
ARGI4
ADDRGP4 $942
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1741
;1741:	}
LABELV $937
line 1742
;1742:}
LABELV $931
endproc CG_DrawSpectator 0 16
proc CG_DrawVote 12 20
line 1749
;1743:
;1744:/*
;1745:=================
;1746:CG_DrawVote
;1747:=================
;1748:*/
;1749:static void CG_DrawVote(void) {
line 1753
;1750:	char	*s;
;1751:	int		sec;
;1752:
;1753:	if ( !cgs.voteTime ) {
ADDRGP4 cgs+24380
INDIRI4
CNSTI4 0
NEI4 $944
line 1754
;1754:		return;
ADDRGP4 $943
JUMPV
LABELV $944
line 1758
;1755:	}
;1756:
;1757:	// play a talk beep whenever it is modified
;1758:	if ( cgs.voteModified ) {
ADDRGP4 cgs+24392
INDIRI4
CNSTI4 0
EQI4 $947
line 1759
;1759:		cgs.voteModified = qfalse;
ADDRGP4 cgs+24392
CNSTI4 0
ASGNI4
line 1760
;1760:		trap_S_StartLocalSound( cgs.media.talkSound, CHAN_LOCAL_SOUND );
ADDRGP4 cgs+170516+640
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 1761
;1761:	}
LABELV $947
line 1763
;1762:
;1763:	sec = ( VOTE_TIME - ( cg.time - cgs.voteTime ) ) / 1000;
ADDRLP4 0
CNSTI4 30000
ADDRGP4 cg+105504
INDIRI4
ADDRGP4 cgs+24380
INDIRI4
SUBI4
SUBI4
CNSTI4 1000
DIVI4
ASGNI4
line 1764
;1764:	if ( sec < 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
GEI4 $955
line 1765
;1765:		sec = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 1766
;1766:	}
LABELV $955
line 1767
;1767:	s = va("VOTE(%i):%s yes(F1):%i no(F2):%i", sec, cgs.voteString, cgs.voteYes, cgs.voteNo );
ADDRGP4 $957
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 cgs+24396
ARGP4
ADDRGP4 cgs+24384
INDIRI4
ARGI4
ADDRGP4 cgs+24388
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 1768
;1768:	CG_DrawSmallString( 0, 58, s, 1.0F );
CNSTI4 0
ARGI4
CNSTI4 58
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawSmallString
CALLV
pop
line 1769
;1769:}
LABELV $943
endproc CG_DrawVote 12 20
proc CG_DrawIntermission 0 0
line 1776
;1770:
;1771:/*
;1772:=================
;1773:CG_DrawIntermission
;1774:=================
;1775:*/
;1776:static void CG_DrawIntermission( void ) {
line 1777
;1777:	if ( cgs.gametype == GT_SINGLE_PLAYER ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 2
NEI4 $962
line 1778
;1778:		CG_DrawCenterString();
ADDRGP4 CG_DrawCenterString
CALLV
pop
line 1779
;1779:		return;
ADDRGP4 $961
JUMPV
LABELV $962
line 1782
;1780:	}
;1781:
;1782:	cg.scoreFadeTime = cg.time;
ADDRGP4 cg+110796
ADDRGP4 cg+105504
INDIRI4
ASGNI4
line 1783
;1783:	CG_DrawScoreboard();
ADDRGP4 CG_DrawScoreboard
CALLI4
pop
line 1784
;1784:}
LABELV $961
endproc CG_DrawIntermission 0 0
proc CG_DrawFollow 32 36
line 1791
;1785:
;1786:/*
;1787:=================
;1788:CG_DrawFollow
;1789:=================
;1790:*/
;1791:static qboolean CG_DrawFollow( void ) {
line 1796
;1792:	float		x;
;1793:	vec4_t		color;
;1794:	const char	*name;
;1795:
;1796:	if ( !(cg.snap->ps.pm_flags & PMF_FOLLOW) ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
NEI4 $968
line 1797
;1797:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $967
JUMPV
LABELV $968
line 1799
;1798:	}
;1799:	color[0] = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 1800
;1800:	color[1] = 1;
ADDRLP4 0+4
CNSTF4 1065353216
ASGNF4
line 1801
;1801:	color[2] = 1;
ADDRLP4 0+8
CNSTF4 1065353216
ASGNF4
line 1802
;1802:	color[3] = 1;
ADDRLP4 0+12
CNSTF4 1065353216
ASGNF4
line 1805
;1803:
;1804:
;1805:	CG_DrawBigString( 320 - 9 * 8, 24, "following", 1.0F );
CNSTI4 248
ARGI4
CNSTI4 24
ARGI4
ADDRGP4 $974
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1807
;1806:
;1807:	name = cgs.clientinfo[ cg.snap->ps.clientNum ].name;
ADDRLP4 16
CNSTI4 1076
ADDRGP4 cg+32
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+30820+4
ADDP4
ASGNP4
line 1809
;1808:
;1809:	x = 0.5 * ( 640 - GIANT_WIDTH * CG_DrawStrlen( name ) );
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 20
CNSTF4 1056964608
CNSTI4 640
ADDRLP4 24
INDIRI4
CNSTI4 5
LSHI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 1811
;1810:
;1811:	CG_DrawStringExt( x, 40, name, color, qtrue, qtrue, GIANT_WIDTH, GIANT_HEIGHT, 0 );
ADDRLP4 20
INDIRF4
CVFI4 4
ARGI4
CNSTI4 40
ARGI4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 28
CNSTI4 1
ASGNI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
CNSTI4 32
ARGI4
CNSTI4 48
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 1813
;1812:
;1813:	return qtrue;
CNSTI4 1
RETI4
LABELV $967
endproc CG_DrawFollow 32 36
proc CG_DrawAmmoWarning 12 16
line 1823
;1814:}
;1815:
;1816:
;1817:
;1818:/*
;1819:=================
;1820:CG_DrawAmmoWarning
;1821:=================
;1822:*/
;1823:static void CG_DrawAmmoWarning( void ) {
line 1827
;1824:	const char	*s;
;1825:	int			w;
;1826:
;1827:	if ( cg_drawAmmoWarning.integer == 0 ) {
ADDRGP4 cg_drawAmmoWarning+12
INDIRI4
CNSTI4 0
NEI4 $979
line 1828
;1828:		return;
ADDRGP4 $978
JUMPV
LABELV $979
line 1831
;1829:	}
;1830:
;1831:	if ( !cg.lowAmmoWarning ) {
ADDRGP4 cg+111872
INDIRI4
CNSTI4 0
NEI4 $982
line 1832
;1832:		return;
ADDRGP4 $978
JUMPV
LABELV $982
line 1835
;1833:	}
;1834:
;1835:	if ( cg.lowAmmoWarning == 2 ) {
ADDRGP4 cg+111872
INDIRI4
CNSTI4 2
NEI4 $985
line 1836
;1836:		s = "OUT OF AMMO";
ADDRLP4 0
ADDRGP4 $988
ASGNP4
line 1837
;1837:	} else {
ADDRGP4 $986
JUMPV
LABELV $985
line 1838
;1838:		s = "LOW AMMO WARNING";
ADDRLP4 0
ADDRGP4 $989
ASGNP4
line 1839
;1839:	}
LABELV $986
line 1840
;1840:	w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 8
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 1841
;1841:	CG_DrawBigString(320 - w / 2, 64, s, 1.0F);
CNSTI4 320
ADDRLP4 4
INDIRI4
CNSTI4 2
DIVI4
SUBI4
ARGI4
CNSTI4 64
ARGI4
ADDRLP4 0
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1842
;1842:}
LABELV $978
endproc CG_DrawAmmoWarning 12 16
proc CG_DrawWarmup 52 36
line 1849
;1843:
;1844:/*
;1845:=================
;1846:CG_DrawWarmup
;1847:=================
;1848:*/
;1849:static void CG_DrawWarmup( void ) {
line 1857
;1850:	int			w;
;1851:	int			sec;
;1852:	int			i;
;1853:	clientInfo_t	*ci1, *ci2;
;1854:	int			cw;
;1855:	const char	*s;
;1856:
;1857:	sec = cg.warmup;
ADDRLP4 4
ADDRGP4 cg+111912
INDIRI4
ASGNI4
line 1858
;1858:	if ( !sec ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $992
line 1859
;1859:		return;
ADDRGP4 $990
JUMPV
LABELV $992
line 1862
;1860:	}
;1861:
;1862:	if ( sec < 0 ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
GEI4 $994
line 1863
;1863:		s = "Waiting for players";		
ADDRLP4 8
ADDRGP4 $996
ASGNP4
line 1864
;1864:		w = CG_DrawStrlen( s ) * BIGCHAR_WIDTH;
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 28
INDIRI4
CNSTI4 4
LSHI4
ASGNI4
line 1865
;1865:		CG_DrawBigString(320 - w / 2, 40, s, 1.0F);
CNSTI4 320
ADDRLP4 16
INDIRI4
CNSTI4 2
DIVI4
SUBI4
ARGI4
CNSTI4 40
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
CNSTF4 1065353216
ARGF4
ADDRGP4 CG_DrawBigString
CALLV
pop
line 1866
;1866:		cg.warmupCount = 0;
ADDRGP4 cg+111916
CNSTI4 0
ASGNI4
line 1867
;1867:		return;
ADDRGP4 $990
JUMPV
LABELV $994
line 1870
;1868:	}
;1869:
;1870:	if (cgs.gametype == GT_TOURNAMENT) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 1
NEI4 $998
line 1872
;1871:		// find the two active players
;1872:		ci1 = NULL;
ADDRLP4 20
CNSTP4 0
ASGNP4
line 1873
;1873:		ci2 = NULL;
ADDRLP4 24
CNSTP4 0
ASGNP4
line 1874
;1874:		for ( i = 0 ; i < cgs.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $1004
JUMPV
LABELV $1001
line 1875
;1875:			if ( cgs.clientinfo[i].infoValid && cgs.clientinfo[i].team == TEAM_FREE ) {
ADDRLP4 28
CNSTI4 1076
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 32
CNSTI4 0
ASGNI4
ADDRLP4 28
INDIRI4
ADDRGP4 cgs+30820
ADDP4
INDIRI4
ADDRLP4 32
INDIRI4
EQI4 $1006
ADDRLP4 28
INDIRI4
ADDRGP4 cgs+30820+68
ADDP4
INDIRI4
ADDRLP4 32
INDIRI4
NEI4 $1006
line 1876
;1876:				if ( !ci1 ) {
ADDRLP4 20
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1011
line 1877
;1877:					ci1 = &cgs.clientinfo[i];
ADDRLP4 20
CNSTI4 1076
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 1878
;1878:				} else {
ADDRGP4 $1012
JUMPV
LABELV $1011
line 1879
;1879:					ci2 = &cgs.clientinfo[i];
ADDRLP4 24
CNSTI4 1076
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cgs+30820
ADDP4
ASGNP4
line 1880
;1880:				}
LABELV $1012
line 1881
;1881:			}
LABELV $1006
line 1882
;1882:		}
LABELV $1002
line 1874
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1004
ADDRLP4 0
INDIRI4
ADDRGP4 cgs+24312
INDIRI4
LTI4 $1001
line 1884
;1883:
;1884:		if ( ci1 && ci2 ) {
ADDRLP4 28
CNSTU4 0
ASGNU4
ADDRLP4 20
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRU4
EQU4 $999
ADDRLP4 24
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRU4
EQU4 $999
line 1885
;1885:			s = va( "%s vs %s", ci1->name, ci2->name );
ADDRGP4 $1017
ARGP4
ADDRLP4 32
CNSTI4 4
ASGNI4
ADDRLP4 20
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
ARGP4
ADDRLP4 24
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 36
INDIRP4
ASGNP4
line 1886
;1886:			w = CG_DrawStrlen( s );
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 40
INDIRI4
ASGNI4
line 1887
;1887:			if ( w > 640 / GIANT_WIDTH ) {
ADDRLP4 16
INDIRI4
CNSTI4 20
LEI4 $1018
line 1888
;1888:				cw = 640 / w;
ADDRLP4 12
CNSTI4 640
ADDRLP4 16
INDIRI4
DIVI4
ASGNI4
line 1889
;1889:			} else {
ADDRGP4 $1019
JUMPV
LABELV $1018
line 1890
;1890:				cw = GIANT_WIDTH;
ADDRLP4 12
CNSTI4 32
ASGNI4
line 1891
;1891:			}
LABELV $1019
line 1892
;1892:			CG_DrawStringExt( 320 - w * cw/2, 20,s, colorWhite, 
CNSTI4 320
ADDRLP4 16
INDIRI4
ADDRLP4 12
INDIRI4
MULI4
CNSTI4 2
DIVI4
SUBI4
ARGI4
CNSTI4 20
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 colorWhite
ARGP4
ADDRLP4 48
CNSTI4 0
ASGNI4
ADDRLP4 48
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
CNSTF4 1069547520
ADDRLP4 12
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ARGI4
ADDRLP4 48
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 1894
;1893:					qfalse, qtrue, cw, (int)(cw * 1.5), 0 );
;1894:		}
line 1895
;1895:	} else {
ADDRGP4 $999
JUMPV
LABELV $998
line 1896
;1896:		if ( cgs.gametype == GT_FFA ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 0
NEI4 $1020
line 1897
;1897:			s = "Free For All";
ADDRLP4 8
ADDRGP4 $1023
ASGNP4
line 1898
;1898:		} else if ( cgs.gametype == GT_TEAM ) {
ADDRGP4 $1021
JUMPV
LABELV $1020
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
NEI4 $1024
line 1899
;1899:			s = "Team Deathmatch";
ADDRLP4 8
ADDRGP4 $1027
ASGNP4
line 1900
;1900:		} else if ( cgs.gametype == GT_CTF ) {
ADDRGP4 $1025
JUMPV
LABELV $1024
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 4
NEI4 $1028
line 1901
;1901:			s = "Capture the Flag";
ADDRLP4 8
ADDRGP4 $1031
ASGNP4
line 1902
;1902:		} else {
ADDRGP4 $1029
JUMPV
LABELV $1028
line 1903
;1903:			s = "";
ADDRLP4 8
ADDRGP4 $1032
ASGNP4
line 1904
;1904:		}
LABELV $1029
LABELV $1025
LABELV $1021
line 1905
;1905:		w = CG_DrawStrlen( s );
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 28
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 28
INDIRI4
ASGNI4
line 1906
;1906:		if ( w > 640 / GIANT_WIDTH ) {
ADDRLP4 16
INDIRI4
CNSTI4 20
LEI4 $1033
line 1907
;1907:			cw = 640 / w;
ADDRLP4 12
CNSTI4 640
ADDRLP4 16
INDIRI4
DIVI4
ASGNI4
line 1908
;1908:		} else {
ADDRGP4 $1034
JUMPV
LABELV $1033
line 1909
;1909:			cw = GIANT_WIDTH;
ADDRLP4 12
CNSTI4 32
ASGNI4
line 1910
;1910:		}
LABELV $1034
line 1911
;1911:		CG_DrawStringExt( 320 - w * cw/2, 20,s, colorWhite, 
CNSTI4 320
ADDRLP4 16
INDIRI4
ADDRLP4 12
INDIRI4
MULI4
CNSTI4 2
DIVI4
SUBI4
ARGI4
CNSTI4 20
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 colorWhite
ARGP4
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRLP4 36
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
CNSTF4 1069547520
ADDRLP4 12
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ARGI4
ADDRLP4 36
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 1913
;1912:				qfalse, qtrue, cw, (int)(cw * 1.5), 0 );
;1913:	}
LABELV $999
line 1915
;1914:
;1915:	sec = ( sec - cg.time ) / 1000;
ADDRLP4 4
ADDRLP4 4
INDIRI4
ADDRGP4 cg+105504
INDIRI4
SUBI4
CNSTI4 1000
DIVI4
ASGNI4
line 1916
;1916:	if ( sec < 0 ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
GEI4 $1036
line 1917
;1917:		sec = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 1918
;1918:	}
LABELV $1036
line 1919
;1919:	s = va( "Starts in: %i", sec + 1 );
ADDRGP4 $1038
ARGP4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 28
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 28
INDIRP4
ASGNP4
line 1920
;1920:	if ( sec != cg.warmupCount ) {
ADDRLP4 4
INDIRI4
ADDRGP4 cg+111916
INDIRI4
EQI4 $1039
line 1921
;1921:		cg.warmupCount = sec;
ADDRGP4 cg+111916
ADDRLP4 4
INDIRI4
ASGNI4
line 1922
;1922:		switch ( sec ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $1045
ADDRLP4 4
INDIRI4
CNSTI4 1
EQI4 $1048
ADDRLP4 4
INDIRI4
CNSTI4 2
EQI4 $1051
ADDRGP4 $1044
JUMPV
LABELV $1045
line 1924
;1923:		case 0:
;1924:			trap_S_StartLocalSound( cgs.media.count1Sound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+756
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 1925
;1925:			break;
ADDRGP4 $1044
JUMPV
LABELV $1048
line 1927
;1926:		case 1:
;1927:			trap_S_StartLocalSound( cgs.media.count2Sound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+752
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 1928
;1928:			break;
ADDRGP4 $1044
JUMPV
LABELV $1051
line 1930
;1929:		case 2:
;1930:			trap_S_StartLocalSound( cgs.media.count3Sound, CHAN_ANNOUNCER );
ADDRGP4 cgs+170516+748
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 1931
;1931:			break;
line 1933
;1932:		default:
;1933:			break;
LABELV $1044
line 1935
;1934:		}
;1935:	}
LABELV $1039
line 1936
;1936:	switch ( cg.warmupCount ) {
ADDRLP4 32
ADDRGP4 cg+111916
INDIRI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 0
EQI4 $1057
ADDRLP4 32
INDIRI4
CNSTI4 1
EQI4 $1058
ADDRLP4 32
INDIRI4
CNSTI4 2
EQI4 $1059
ADDRGP4 $1054
JUMPV
LABELV $1057
line 1938
;1937:	case 0:
;1938:		cw = 28;
ADDRLP4 12
CNSTI4 28
ASGNI4
line 1939
;1939:		break;
ADDRGP4 $1055
JUMPV
LABELV $1058
line 1941
;1940:	case 1:
;1941:		cw = 24;
ADDRLP4 12
CNSTI4 24
ASGNI4
line 1942
;1942:		break;
ADDRGP4 $1055
JUMPV
LABELV $1059
line 1944
;1943:	case 2:
;1944:		cw = 20;
ADDRLP4 12
CNSTI4 20
ASGNI4
line 1945
;1945:		break;
ADDRGP4 $1055
JUMPV
LABELV $1054
line 1947
;1946:	default:
;1947:		cw = 16;
ADDRLP4 12
CNSTI4 16
ASGNI4
line 1948
;1948:		break;
LABELV $1055
line 1951
;1949:	}
;1950:
;1951:	w = CG_DrawStrlen( s );
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 36
ADDRGP4 CG_DrawStrlen
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 36
INDIRI4
ASGNI4
line 1952
;1952:	CG_DrawStringExt( 320 - w * cw/2, 70, s, colorWhite, 
CNSTI4 320
ADDRLP4 16
INDIRI4
ADDRLP4 12
INDIRI4
MULI4
CNSTI4 2
DIVI4
SUBI4
ARGI4
CNSTI4 70
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 colorWhite
ARGP4
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 44
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
CNSTF4 1069547520
ADDRLP4 12
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ARGI4
ADDRLP4 44
INDIRI4
ARGI4
ADDRGP4 CG_DrawStringExt
CALLV
pop
line 1954
;1953:			qfalse, qtrue, cw, (int)(cw * 1.5), 0 );
;1954:}
LABELV $990
endproc CG_DrawWarmup 52 36
proc CG_Draw2D 40 20
line 1963
;1955:
;1956://==================================================================================
;1957:
;1958:/*
;1959:=================
;1960:CG_Draw2D
;1961:=================
;1962:*/
;1963:static void CG_Draw2D( void ) {
line 1966
;1964:	int contents;
;1965:	// if we are taking a levelshot for the menu, don't draw anything
;1966:	if ( cg.levelShot ) {
ADDRGP4 cg+8
INDIRI4
CNSTI4 0
EQI4 $1061
line 1967
;1967:		return;
ADDRGP4 $1060
JUMPV
LABELV $1061
line 1969
;1968:	}
;1969:	contents = CG_PointContents( cg.refdef.vieworg, -1 ) & (CONTENTS_WATER | CONTENTS_SLIME | CONTENTS_LAVA );
ADDRGP4 cg+106800+24
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 4
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 4
INDIRI4
CNSTI4 56
BANDI4
ASGNI4
line 1971
;1970:	
;1971:	if ( contents  )
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $1066
line 1972
;1972:	{
line 1975
;1973:		vec4_t		hcolor;
;1974:
;1975:		hcolor[3] = (rand() % 10) * 0.01 + 0.25;
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8+12
CNSTF4 1008981770
ADDRLP4 24
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
CNSTF4 1048576000
ADDF4
ASGNF4
line 1976
;1976:		if(contents & CONTENTS_LAVA)
ADDRLP4 0
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $1069
line 1977
;1977:		{
line 1978
;1978:			hcolor[0] = 1;
ADDRLP4 8
CNSTF4 1065353216
ASGNF4
line 1979
;1979:			if(hcolor[1] < .5)
ADDRLP4 8+4
INDIRF4
CNSTF4 1056964608
GEF4 $1071
line 1980
;1980:				hcolor[1] += (rand() % 10) * 0.07;
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8+4
ADDRLP4 8+4
INDIRF4
CNSTF4 1032805417
ADDRLP4 28
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
ADDF4
ASGNF4
LABELV $1071
line 1981
;1981:			hcolor[3] = (rand() % 10) * 0.025 + 0.5;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8+12
CNSTF4 1020054733
ADDRLP4 32
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 1982
;1982:		}
LABELV $1069
line 1983
;1983:		if(contents & CONTENTS_SLIME)
ADDRLP4 0
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $1076
line 1984
;1984:		{			
line 1985
;1985:			if(hcolor[0] < .5)
ADDRLP4 8
INDIRF4
CNSTF4 1056964608
GEF4 $1078
line 1986
;1986:				hcolor[0] += (rand() % 10) * 0.04;
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 8
INDIRF4
CNSTF4 1025758986
ADDRLP4 28
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
ADDF4
ASGNF4
LABELV $1078
line 1987
;1987:			hcolor[1] = 1;			
ADDRLP4 8+4
CNSTF4 1065353216
ASGNF4
line 1988
;1988:			if(hcolor[0] < .5)
ADDRLP4 8
INDIRF4
CNSTF4 1056964608
GEF4 $1081
line 1989
;1989:				hcolor[0] += (rand() % 10) * 0.04;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 8
INDIRF4
CNSTF4 1025758986
ADDRLP4 32
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
ADDF4
ASGNF4
LABELV $1081
line 1990
;1990:			hcolor[3] = (rand() % 10) * 0.025 + 0.5;
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8+12
CNSTF4 1020054733
ADDRLP4 36
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 1991
;1991:		}
LABELV $1076
line 1992
;1992:		if(contents & CONTENTS_WATER)
ADDRLP4 0
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $1084
line 1993
;1993:		{			
line 1994
;1994:			hcolor[2] = 1;
ADDRLP4 8+8
CNSTF4 1065353216
ASGNF4
line 1995
;1995:			if(hcolor[1] < 1)
ADDRLP4 8+4
INDIRF4
CNSTF4 1065353216
GEF4 $1087
line 1996
;1996:				hcolor[1] = 0.75 + (rand() % 10) * 0.025;
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8+4
CNSTF4 1020054733
ADDRLP4 28
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
CNSTF4 1061158912
ADDF4
ASGNF4
LABELV $1087
line 1997
;1997:			if(hcolor[0] < hcolor[1] * .5)
ADDRLP4 8
INDIRF4
CNSTF4 1056964608
ADDRLP4 8+4
INDIRF4
MULF4
GEF4 $1091
line 1998
;1998:				hcolor[0] += (rand() % 10) * 0.1 * hcolor[1];
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 8
INDIRF4
CNSTF4 1036831949
ADDRLP4 32
INDIRI4
CNSTI4 10
MODI4
CVIF4 4
MULF4
ADDRLP4 8+4
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $1091
line 1999
;1999:		}
LABELV $1084
line 2000
;2000:		trap_R_SetColor( hcolor );
ADDRLP4 8
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 2001
;2001:		CG_DrawPic( 0, 0, 640, 480, cgs.media.teamStatusBar );
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 28
INDIRF4
ARGF4
ADDRLP4 28
INDIRF4
ARGF4
CNSTF4 1142947840
ARGF4
CNSTF4 1139802112
ARGF4
ADDRGP4 cgs+170516+60
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 2002
;2002:		trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 2008
;2003:
;2004:		
;2005:		
;2006:		
;2007:
;2008:	}
LABELV $1066
line 2010
;2009:	
;2010:	if ( cg_draw2D.integer == 0 ) {
ADDRGP4 cg_draw2D+12
INDIRI4
CNSTI4 0
NEI4 $1097
line 2011
;2011:		return;
ADDRGP4 $1060
JUMPV
LABELV $1097
line 2014
;2012:	}
;2013:
;2014:	if ( cg.snap->ps.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 5
NEI4 $1100
line 2015
;2015:		CG_DrawIntermission();
ADDRGP4 CG_DrawIntermission
CALLV
pop
line 2016
;2016:		return;
ADDRGP4 $1060
JUMPV
LABELV $1100
line 2019
;2017:	}
;2018:
;2019:	if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
NEI4 $1103
line 2020
;2020:		CG_DrawSpectator();
ADDRGP4 CG_DrawSpectator
CALLV
pop
line 2021
;2021:		CG_DrawCrosshair();
ADDRGP4 CG_DrawCrosshair
CALLV
pop
line 2022
;2022:		CG_DrawCrosshairNames();
ADDRGP4 CG_DrawCrosshairNames
CALLV
pop
line 2023
;2023:	} else {
ADDRGP4 $1104
JUMPV
LABELV $1103
line 2025
;2024:		// don't draw any status if dead
;2025:		if ( cg.snap->ps.stats[STAT_HEALTH] > 0 ) {
ADDRGP4 cg+32
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
LEI4 $1106
line 2026
;2026:			CG_DrawStatusBar();
ADDRGP4 CG_DrawStatusBar
CALLV
pop
line 2027
;2027:			CG_DrawAmmoWarning();
ADDRGP4 CG_DrawAmmoWarning
CALLV
pop
line 2028
;2028:			CG_DrawCrosshair();
ADDRGP4 CG_DrawCrosshair
CALLV
pop
line 2029
;2029:			CG_DrawCrosshairNames();
ADDRGP4 CG_DrawCrosshairNames
CALLV
pop
line 2030
;2030:			CG_DrawWeaponSelect();
ADDRGP4 CG_DrawWeaponSelect
CALLV
pop
line 2031
;2031:			CG_DrawHoldableItem();
ADDRGP4 CG_DrawHoldableItem
CALLV
pop
line 2032
;2032:			CG_DrawReward();
ADDRGP4 CG_DrawReward
CALLV
pop
line 2033
;2033:		}
LABELV $1106
line 2034
;2034:		if ( cgs.gametype >= GT_TEAM ) {
ADDRGP4 cgs+24288
INDIRI4
CNSTI4 3
LTI4 $1109
line 2035
;2035:			CG_DrawTeamInfo();
ADDRGP4 CG_DrawTeamInfo
CALLV
pop
line 2036
;2036:		}
LABELV $1109
line 2037
;2037:	}
LABELV $1104
line 2039
;2038:
;2039:	CG_DrawVote();
ADDRGP4 CG_DrawVote
CALLV
pop
line 2041
;2040:
;2041:	CG_DrawLagometer();
ADDRGP4 CG_DrawLagometer
CALLV
pop
line 2043
;2042:
;2043:	CG_DrawUpperRight();
ADDRGP4 CG_DrawUpperRight
CALLV
pop
line 2045
;2044:
;2045:	CG_DrawLowerRight();
ADDRGP4 CG_DrawLowerRight
CALLV
pop
line 2047
;2046:
;2047:	CG_DrawLowerLeft();
ADDRGP4 CG_DrawLowerLeft
CALLV
pop
line 2049
;2048:
;2049:	if ( !CG_DrawFollow() ) {
ADDRLP4 8
ADDRGP4 CG_DrawFollow
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $1112
line 2050
;2050:		CG_DrawWarmup();
ADDRGP4 CG_DrawWarmup
CALLV
pop
line 2051
;2051:	}
LABELV $1112
line 2054
;2052:
;2053:	// don't draw center string if scoreboard is up
;2054:	if ( !CG_DrawScoreboard() ) {
ADDRLP4 12
ADDRGP4 CG_DrawScoreboard
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $1114
line 2055
;2055:		CG_DrawCenterString();
ADDRGP4 CG_DrawCenterString
CALLV
pop
line 2056
;2056:	}
LABELV $1114
line 2057
;2057:}
LABELV $1060
endproc CG_Draw2D 40 20
export CG_DrawActive
proc CG_DrawActive 24 4
line 2067
;2058:
;2059:
;2060:/*
;2061:=====================
;2062:CG_DrawActive
;2063:
;2064:Perform all drawing needed to completely fill the screen
;2065:=====================
;2066:*/
;2067:void CG_DrawActive( stereoFrame_t stereoView ) {
line 2071
;2068:	float		separation;
;2069:	vec3_t		baseOrg;
;2070:	// optionally draw the info screen instead
;2071:	if ( !cg.snap ) {
ADDRGP4 cg+32
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1117
line 2072
;2072:		CG_DrawInformation();
ADDRGP4 CG_DrawInformation
CALLV
pop
line 2073
;2073:		return;
ADDRGP4 $1116
JUMPV
LABELV $1117
line 2077
;2074:	}
;2075:	
;2076:	// optionally draw the tournement scoreboard instead
;2077:	if ( cg.snap->ps.persistant[PERS_TEAM] == TEAM_SPECTATOR &&
ADDRGP4 cg+32
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 3
NEI4 $1120
ADDRGP4 cg+32
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 8192
BANDI4
CNSTI4 0
EQI4 $1120
line 2078
;2078:		( cg.snap->ps.pm_flags & PMF_SCOREBOARD ) ) {
line 2079
;2079:		CG_DrawTourneyScoreboard();
ADDRGP4 CG_DrawTourneyScoreboard
CALLV
pop
line 2080
;2080:		return;
ADDRGP4 $1116
JUMPV
LABELV $1120
line 2083
;2081:	}
;2082:
;2083:	switch ( stereoView ) {
ADDRLP4 16
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
EQI4 $1127
ADDRLP4 16
INDIRI4
CNSTI4 1
EQI4 $1128
ADDRLP4 16
INDIRI4
CNSTI4 2
EQI4 $1130
ADDRGP4 $1124
JUMPV
LABELV $1127
line 2085
;2084:	case STEREO_CENTER:
;2085:		separation = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 2086
;2086:		break;
ADDRGP4 $1125
JUMPV
LABELV $1128
line 2088
;2087:	case STEREO_LEFT:
;2088:		separation = -cg_stereoSeparation.value / 2;
ADDRLP4 0
ADDRGP4 cg_stereoSeparation+8
INDIRF4
NEGF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 2089
;2089:		break;
ADDRGP4 $1125
JUMPV
LABELV $1130
line 2091
;2090:	case STEREO_RIGHT:
;2091:		separation = cg_stereoSeparation.value / 2;
ADDRLP4 0
ADDRGP4 cg_stereoSeparation+8
INDIRF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 2092
;2092:		break;
ADDRGP4 $1125
JUMPV
LABELV $1124
line 2094
;2093:	default:
;2094:		separation = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 2095
;2095:		CG_Error( "CG_DrawActive: Undefined stereoView" );
ADDRGP4 $1132
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 2096
;2096:	}
LABELV $1125
line 2100
;2097:
;2098:
;2099:	// clear around the rendered view if sized down
;2100:	CG_TileClear();
ADDRGP4 CG_TileClear
CALLV
pop
line 2103
;2101:
;2102:	// offset vieworg appropriately if we're doing stereo separation
;2103:	VectorCopy( cg.refdef.vieworg, baseOrg );
ADDRLP4 4
ADDRGP4 cg+106800+24
INDIRB
ASGNB 12
line 2104
;2104:	if ( separation != 0 ) {
ADDRLP4 0
INDIRF4
CNSTF4 0
EQF4 $1135
line 2105
;2105:		VectorMA( cg.refdef.vieworg, -separation, cg.refdef.viewaxis[1], cg.refdef.vieworg );
ADDRGP4 cg+106800+24
ADDRGP4 cg+106800+24
INDIRF4
ADDRGP4 cg+106800+36+12
INDIRF4
ADDRLP4 0
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+106800+24+4
ADDRGP4 cg+106800+24+4
INDIRF4
ADDRGP4 cg+106800+36+12+4
INDIRF4
ADDRLP4 0
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+106800+24+8
ADDRGP4 cg+106800+24+8
INDIRF4
ADDRGP4 cg+106800+36+12+8
INDIRF4
ADDRLP4 0
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 2106
;2106:	}
LABELV $1135
line 2110
;2107:
;2108:	
;2109:	// draw 3D view
;2110:	trap_R_RenderScene( &cg.refdef );
ADDRGP4 cg+106800
ARGP4
ADDRGP4 trap_R_RenderScene
CALLV
pop
line 2113
;2111:
;2112:	// restore original viewpoint if running stereo
;2113:	if ( separation != 0 ) {
ADDRLP4 0
INDIRF4
CNSTF4 0
EQF4 $1165
line 2114
;2114:		VectorCopy( baseOrg, cg.refdef.vieworg );
ADDRGP4 cg+106800+24
ADDRLP4 4
INDIRB
ASGNB 12
line 2115
;2115:	}
LABELV $1165
line 2118
;2116:
;2117:	// draw status bar and other floating elements
;2118:	CG_Draw2D();
ADDRGP4 CG_Draw2D
CALLV
pop
line 2119
;2119:}
LABELV $1116
endproc CG_DrawActive 24 4
bss
export lagometer
align 4
LABELV lagometer
skip 1544
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_AddLightToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_TransitionPlayerState
import CG_Respawn
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawTourneyScoreboard
import CG_DrawScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed2
import CG_Bleed
import CG_GibPlayer
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
export numSortedTeamPlayers
align 4
LABELV numSortedTeamPlayers
skip 4
export sortedTeamPlayers
align 4
LABELV sortedTeamPlayers
skip 32
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_railLength
import cg_railWidth
import cl_autoaim
import cg_MarkFadeTime
import cg_MarkStayTime
import cg_SphericalExplosions
import cg_CoolRailGun
import cg_BigHeadScale
import cg_BobItems
import cg_ScaleWeapons
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_syncronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $1132
byte 1 67
byte 1 71
byte 1 95
byte 1 68
byte 1 114
byte 1 97
byte 1 119
byte 1 65
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 101
byte 1 58
byte 1 32
byte 1 85
byte 1 110
byte 1 100
byte 1 101
byte 1 102
byte 1 105
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 101
byte 1 111
byte 1 86
byte 1 105
byte 1 101
byte 1 119
byte 1 0
align 1
LABELV $1038
byte 1 83
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 115
byte 1 32
byte 1 105
byte 1 110
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $1032
byte 1 0
align 1
LABELV $1031
byte 1 67
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 101
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $1027
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 68
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 109
byte 1 97
byte 1 116
byte 1 99
byte 1 104
byte 1 0
align 1
LABELV $1023
byte 1 70
byte 1 114
byte 1 101
byte 1 101
byte 1 32
byte 1 70
byte 1 111
byte 1 114
byte 1 32
byte 1 65
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $1017
byte 1 37
byte 1 115
byte 1 32
byte 1 118
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $996
byte 1 87
byte 1 97
byte 1 105
byte 1 116
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 115
byte 1 0
align 1
LABELV $989
byte 1 76
byte 1 79
byte 1 87
byte 1 32
byte 1 65
byte 1 77
byte 1 77
byte 1 79
byte 1 32
byte 1 87
byte 1 65
byte 1 82
byte 1 78
byte 1 73
byte 1 78
byte 1 71
byte 1 0
align 1
LABELV $988
byte 1 79
byte 1 85
byte 1 84
byte 1 32
byte 1 79
byte 1 70
byte 1 32
byte 1 65
byte 1 77
byte 1 77
byte 1 79
byte 1 0
align 1
LABELV $974
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $957
byte 1 86
byte 1 79
byte 1 84
byte 1 69
byte 1 40
byte 1 37
byte 1 105
byte 1 41
byte 1 58
byte 1 37
byte 1 115
byte 1 32
byte 1 121
byte 1 101
byte 1 115
byte 1 40
byte 1 70
byte 1 49
byte 1 41
byte 1 58
byte 1 37
byte 1 105
byte 1 32
byte 1 110
byte 1 111
byte 1 40
byte 1 70
byte 1 50
byte 1 41
byte 1 58
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $942
byte 1 117
byte 1 115
byte 1 101
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 84
byte 1 69
byte 1 65
byte 1 77
byte 1 32
byte 1 109
byte 1 101
byte 1 110
byte 1 117
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $936
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $932
byte 1 83
byte 1 80
byte 1 69
byte 1 67
byte 1 84
byte 1 65
byte 1 84
byte 1 79
byte 1 82
byte 1 0
align 1
LABELV $808
byte 1 115
byte 1 110
byte 1 99
byte 1 0
align 1
LABELV $743
byte 1 103
byte 1 102
byte 1 120
byte 1 47
byte 1 50
byte 1 100
byte 1 47
byte 1 110
byte 1 101
byte 1 116
byte 1 46
byte 1 116
byte 1 103
byte 1 97
byte 1 0
align 1
LABELV $739
byte 1 67
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 32
byte 1 73
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 114
byte 1 117
byte 1 112
byte 1 116
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $493
byte 1 37
byte 1 50
byte 1 105
byte 1 0
align 1
LABELV $450
byte 1 37
byte 1 51
byte 1 105
byte 1 32
byte 1 37
byte 1 51
byte 1 105
byte 1 0
align 1
LABELV $447
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $383
byte 1 37
byte 1 105
byte 1 58
byte 1 37
byte 1 105
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $379
byte 1 37
byte 1 105
byte 1 102
byte 1 112
byte 1 115
byte 1 0
align 1
LABELV $363
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 58
byte 1 37
byte 1 105
byte 1 32
byte 1 115
byte 1 110
byte 1 97
byte 1 112
byte 1 58
byte 1 37
byte 1 105
byte 1 32
byte 1 99
byte 1 109
byte 1 100
byte 1 58
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $361
byte 1 110
byte 1 0
align 1
LABELV $142
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $97
byte 1 37
byte 1 105
byte 1 0
