data
export pm_stopspeed
align 4
LABELV pm_stopspeed
byte 4 1120403456
export pm_duckScale
align 4
LABELV pm_duckScale
byte 4 1048576000
export pm_swimScale
align 4
LABELV pm_swimScale
byte 4 1056964608
export pm_wadeScale
align 4
LABELV pm_wadeScale
byte 4 1060320051
export pm_accelerate
align 4
LABELV pm_accelerate
byte 4 1092616192
export pm_airaccelerate
align 4
LABELV pm_airaccelerate
byte 4 1065353216
export pm_wateraccelerate
align 4
LABELV pm_wateraccelerate
byte 4 1082130432
export pm_flyaccelerate
align 4
LABELV pm_flyaccelerate
byte 4 1090519040
export pm_friction
align 4
LABELV pm_friction
byte 4 1086324736
export pm_waterfriction
align 4
LABELV pm_waterfriction
byte 4 1065353216
export pm_flightfriction
align 4
LABELV pm_flightfriction
byte 4 1077936128
export c_pmove
align 4
LABELV c_pmove
byte 4 0
export PM_AddEvent
code
proc PM_AddEvent 0 12
file "..\..\game\bg_pmove.c"
line 37
;1: // Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// bg_pmove.c -- both games player movement code
;4:// takes a playerstate and a usercmd as input and returns a modifed playerstate
;5:
;6:#include "q_shared.h"
;7:#include "bg_public.h"
;8:#include "bg_local.h"
;9:
;10:pmove_t		*pm;
;11:pml_t		pml;
;12:
;13:// movement parameters
;14:float	pm_stopspeed = 100;
;15:float	pm_duckScale = 0.25;
;16:float	pm_swimScale = 0.50;
;17:float	pm_wadeScale = 0.70;
;18:
;19:float	pm_accelerate = 10;
;20:float	pm_airaccelerate = 1;
;21:float	pm_wateraccelerate = 4;
;22:float	pm_flyaccelerate = 8;
;23:
;24:float	pm_friction = 6;
;25:float	pm_waterfriction = 1;
;26:float	pm_flightfriction = 3;
;27:
;28:int		c_pmove = 0;
;29:
;30:
;31:/*
;32:===============
;33:PM_AddEvent
;34:
;35:===============
;36:*/
;37:void PM_AddEvent( int newEvent ) {
line 38
;38:	BG_AddPredictableEventToPlayerstate( newEvent, 0, pm->ps );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 pm
INDIRP4
INDIRP4
ARGP4
ADDRGP4 BG_AddPredictableEventToPlayerstate
CALLV
pop
line 39
;39:}
LABELV $35
endproc PM_AddEvent 0 12
export PM_AddTouchEnt
proc PM_AddTouchEnt 12 0
line 46
;40:
;41:/*
;42:===============
;43:PM_AddTouchEnt
;44:===============
;45:*/
;46:void PM_AddTouchEnt( int entityNum ) {
line 49
;47:	int		i;
;48:
;49:	if ( entityNum == ENTITYNUM_WORLD ) {
ADDRFP4 0
INDIRI4
CNSTI4 1022
NEI4 $37
line 50
;50:		return;
ADDRGP4 $36
JUMPV
LABELV $37
line 52
;51:	}
;52:	if ( pm->numtouch == MAXTOUCH ) {
ADDRGP4 pm
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 32
NEI4 $39
line 53
;53:		return;
ADDRGP4 $36
JUMPV
LABELV $39
line 57
;54:	}
;55:
;56:	// see if it is already added
;57:	for ( i = 0 ; i < pm->numtouch ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $44
JUMPV
LABELV $41
line 58
;58:		if ( pm->touchents[ i ] == entityNum ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 pm
INDIRP4
CNSTI4 48
ADDP4
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $45
line 59
;59:			return;
ADDRGP4 $36
JUMPV
LABELV $45
line 61
;60:		}
;61:	}
LABELV $42
line 57
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $44
ADDRLP4 0
INDIRI4
ADDRGP4 pm
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
LTI4 $41
line 64
;62:
;63:	// add it
;64:	pm->touchents[pm->numtouch] = entityNum;
ADDRLP4 4
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 48
ADDP4
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 65
;65:	pm->numtouch++;
ADDRLP4 8
ADDRGP4 pm
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 66
;66:}
LABELV $36
endproc PM_AddTouchEnt 12 0
proc PM_StartTorsoAnim 8 0
line 73
;67:
;68:/*
;69:===================
;70:PM_StartTorsoAnim
;71:===================
;72:*/
;73:static void PM_StartTorsoAnim( int anim ) {
line 74
;74:	if ( pm->ps->pm_type >= PM_DEAD ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
LTI4 $48
line 75
;75:		return;
ADDRGP4 $47
JUMPV
LABELV $48
line 77
;76:	}
;77:	pm->ps->torsoAnim = ( ( pm->ps->torsoAnim & ANIM_TOGGLEBIT ) ^ ANIM_TOGGLEBIT )
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 84
ADDP4
ASGNP4
ADDRLP4 4
CNSTI4 128
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
BANDI4
ADDRLP4 4
INDIRI4
BXORI4
ADDRFP4 0
INDIRI4
BORI4
ASGNI4
line 79
;78:		| anim;
;79:}
LABELV $47
endproc PM_StartTorsoAnim 8 0
proc PM_StartLegsAnim 4 0
line 80
;80:static void PM_StartLegsAnim( int anim ) {
line 81
;81:	if ( pm->ps->pm_type >= PM_DEAD ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
LTI4 $51
line 82
;82:		return;
ADDRGP4 $50
JUMPV
LABELV $51
line 84
;83:	}
;84:	if ( pm->ps->legsTimer > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 0
LEI4 $53
line 85
;85:		return;		// a high priority animation is running
ADDRGP4 $50
JUMPV
LABELV $53
line 87
;86:	}
;87:	pm->ps->legsAnim = ( ( pm->ps->legsAnim & (ANIM_TOGGLEBIT | ANIM_CLIMBWALLS) ) ^ ANIM_TOGGLEBIT )
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 192
BANDI4
CNSTI4 128
BXORI4
ADDRFP4 0
INDIRI4
BORI4
ASGNI4
line 89
;88:		| anim;
;89:}
LABELV $50
endproc PM_StartLegsAnim 4 0
proc PM_ContinueLegsAnim 0 4
line 91
;90:
;91:static void PM_ContinueLegsAnim( int anim ) {
line 92
;92:	if ( ( pm->ps->legsAnim & ~(ANIM_TOGGLEBIT | ANIM_CLIMBWALLS)) == anim ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 -193
BANDI4
ADDRFP4 0
INDIRI4
NEI4 $56
line 93
;93:		return;
ADDRGP4 $55
JUMPV
LABELV $56
line 95
;94:	}
;95:	if ( pm->ps->legsTimer > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 0
LEI4 $58
line 96
;96:		return;		// a high priority animation is running
ADDRGP4 $55
JUMPV
LABELV $58
line 98
;97:	}
;98:	PM_StartLegsAnim( anim );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 PM_StartLegsAnim
CALLV
pop
line 99
;99:}
LABELV $55
endproc PM_ContinueLegsAnim 0 4
proc PM_ContinueTorsoAnim 0 4
line 101
;100:
;101:static void PM_ContinueTorsoAnim( int anim ) {
line 102
;102:	if ( ( pm->ps->torsoAnim & ~(ANIM_TOGGLEBIT | ANIM_CLIMBWALLS) ) == anim ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
CNSTI4 -193
BANDI4
ADDRFP4 0
INDIRI4
NEI4 $61
line 103
;103:		return;
ADDRGP4 $60
JUMPV
LABELV $61
line 105
;104:	}
;105:	if ( pm->ps->torsoTimer > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
INDIRI4
CNSTI4 0
LEI4 $63
line 106
;106:		return;		// a high priority animation is running
ADDRGP4 $60
JUMPV
LABELV $63
line 108
;107:	}
;108:	PM_StartTorsoAnim( anim );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 109
;109:}
LABELV $60
endproc PM_ContinueTorsoAnim 0 4
proc PM_ForceLegsAnim 0 4
line 111
;110:
;111:static void PM_ForceLegsAnim( int anim ) {
line 112
;112:	pm->ps->legsTimer = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
CNSTI4 0
ASGNI4
line 113
;113:	PM_StartLegsAnim( anim );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 PM_StartLegsAnim
CALLV
pop
line 114
;114:}
LABELV $65
endproc PM_ForceLegsAnim 0 4
export PM_ClipVelocity
proc PM_ClipVelocity 32 0
line 124
;115:
;116:
;117:/*
;118:==================
;119:PM_ClipVelocity
;120:
;121:Slide off of the impacting surface
;122:==================
;123:*/
;124:void PM_ClipVelocity( vec3_t in, vec3_t normal, vec3_t out, float overbounce ) {
line 129
;125:	float	backoff;
;126:	float	change;
;127:	int		i;
;128:	
;129:	backoff = DotProduct (in, normal);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 20
CNSTI4 4
ASGNI4
ADDRLP4 24
CNSTI4 8
ASGNI4
ADDRLP4 8
ADDRLP4 12
INDIRP4
INDIRF4
ADDRLP4 16
INDIRP4
INDIRF4
MULF4
ADDRLP4 12
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRF4
ADDRLP4 16
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 12
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRF4
ADDRLP4 16
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 131
;130:	
;131:	if ( backoff < 0 ) {
ADDRLP4 8
INDIRF4
CNSTF4 0
GEF4 $67
line 132
;132:		backoff *= overbounce;
ADDRLP4 8
ADDRLP4 8
INDIRF4
ADDRFP4 12
INDIRF4
MULF4
ASGNF4
line 133
;133:	} else {
ADDRGP4 $68
JUMPV
LABELV $67
line 134
;134:		backoff /= overbounce;
ADDRLP4 8
ADDRLP4 8
INDIRF4
ADDRFP4 12
INDIRF4
DIVF4
ASGNF4
line 135
;135:	}
LABELV $68
line 137
;136:
;137:	for ( i=0 ; i<3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $69
line 138
;138:		change = normal[i]*backoff;
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 8
INDIRF4
MULF4
ASGNF4
line 139
;139:		out[i] = in[i] - change;
ADDRLP4 28
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 28
INDIRI4
ADDRFP4 8
INDIRP4
ADDP4
ADDRLP4 28
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
SUBF4
ASGNF4
line 140
;140:	}
LABELV $70
line 137
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $69
line 141
;141:}
LABELV $66
endproc PM_ClipVelocity 32 0
proc PM_Friction 52 4
line 151
;142:
;143:
;144:/*
;145:==================
;146:PM_Friction
;147:
;148:Handles both ground friction and water friction
;149:==================
;150:*/
;151:static void PM_Friction( void ) {
line 157
;152:	vec3_t	vec;
;153:	float	*vel;
;154:	float	speed, newspeed, control;
;155:	float	drop;
;156:	
;157:	vel = pm->ps->velocity;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
line 159
;158:	
;159:	VectorCopy( vel, vec );
ADDRLP4 16
ADDRLP4 0
INDIRP4
INDIRB
ASGNB 12
line 160
;160:	if ( pml.walking ) {
ADDRGP4 pml+44
INDIRI4
CNSTI4 0
EQI4 $74
line 161
;161:		vec[2] = 0;	// ignore slope movement
ADDRLP4 16+8
CNSTF4 0
ASGNF4
line 162
;162:	}
LABELV $74
line 164
;163:
;164:	speed = VectorLength(vec);
ADDRLP4 16
ARGP4
ADDRLP4 32
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 8
ADDRLP4 32
INDIRF4
ASGNF4
line 165
;165:	if (speed < 1) {
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
GEF4 $78
line 166
;166:		vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTF4 0
ASGNF4
line 167
;167:		vel[1] = 0;		// allow sinking underwater
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTF4 0
ASGNF4
line 169
;168:		// FIXME: still have z friction underwater?
;169:		return;
ADDRGP4 $73
JUMPV
LABELV $78
line 172
;170:	}
;171:
;172:	drop = 0;
ADDRLP4 12
CNSTF4 0
ASGNF4
line 175
;173:
;174:	// apply ground friction
;175:	if ( pm->waterlevel <= 1 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
GTI4 $80
line 176
;176:		if ( pml.walking && !(pml.groundTrace.surfaceFlags & SURF_SLICK) ) {
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRGP4 pml+44
INDIRI4
ADDRLP4 36
INDIRI4
EQI4 $82
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 2
BANDI4
ADDRLP4 36
INDIRI4
NEI4 $82
line 178
;177:			// if getting knocked back, no friction
;178:			if ( ! (pm->ps->pm_flags & PMF_TIME_KNOCKBACK) ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $87
line 179
;179:				control = speed < pm_stopspeed ? pm_stopspeed : speed;
ADDRLP4 8
INDIRF4
ADDRGP4 pm_stopspeed
INDIRF4
GEF4 $90
ADDRLP4 40
ADDRGP4 pm_stopspeed
INDIRF4
ASGNF4
ADDRGP4 $91
JUMPV
LABELV $90
ADDRLP4 40
ADDRLP4 8
INDIRF4
ASGNF4
LABELV $91
ADDRLP4 28
ADDRLP4 40
INDIRF4
ASGNF4
line 180
;180:				drop += control*pm_friction*pml.frametime;
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 28
INDIRF4
ADDRGP4 pm_friction
INDIRF4
MULF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
line 181
;181:			}
LABELV $87
line 182
;182:		}
LABELV $82
line 183
;183:	}
LABELV $80
line 186
;184:
;185:	// apply water friction even if just wading
;186:	if ( pm->waterlevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 0
EQI4 $93
line 187
;187:		drop += speed*pm_waterfriction*pm->waterlevel*pml.frametime;
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 8
INDIRF4
ADDRGP4 pm_waterfriction
INDIRF4
MULF4
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
line 188
;188:	}
LABELV $93
line 191
;189:
;190:	// apply flying friction
;191:	if ( pm->ps->powerups[PW_FLIGHT] || pm->ps->pm_type == PM_SPECTATOR ) {
ADDRLP4 36
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
CNSTI4 0
NEI4 $98
ADDRLP4 36
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $96
LABELV $98
line 192
;192:		drop += speed*pm_flightfriction*pml.frametime;
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 8
INDIRF4
ADDRGP4 pm_flightfriction
INDIRF4
MULF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
line 193
;193:	}
LABELV $96
line 196
;194:
;195:	// scale the velocity
;196:	newspeed = speed - drop;
ADDRLP4 4
ADDRLP4 8
INDIRF4
ADDRLP4 12
INDIRF4
SUBF4
ASGNF4
line 197
;197:	if (newspeed < 0) {
ADDRLP4 4
INDIRF4
CNSTF4 0
GEF4 $100
line 198
;198:		newspeed = 0;
ADDRLP4 4
CNSTF4 0
ASGNF4
line 199
;199:	}
LABELV $100
line 200
;200:	newspeed /= speed;
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
DIVF4
ASGNF4
line 202
;201:
;202:	vel[0] = vel[0] * newspeed;
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 203
;203:	vel[1] = vel[1] * newspeed;
ADDRLP4 44
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 204
;204:	vel[2] = vel[2] * newspeed;
ADDRLP4 48
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 205
;205:}
LABELV $73
endproc PM_Friction 52 4
proc PM_Accelerate 32 0
line 215
;206:
;207:
;208:/*
;209:==============
;210:PM_Accelerate
;211:
;212:Handles user intended acceleration
;213:==============
;214:*/
;215:static void PM_Accelerate( vec3_t wishdir, float wishspeed, float accel ) {
line 221
;216:#if 1 
;217:	// q2 style
;218:	int			i;
;219:	float		addspeed, accelspeed, currentspeed;
;220:
;221:	currentspeed = DotProduct (pm->ps->velocity, wishdir);
ADDRLP4 16
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 16
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 20
INDIRP4
INDIRF4
MULF4
ADDRLP4 16
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 16
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 20
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 222
;222:	addspeed = wishspeed - currentspeed;
ADDRLP4 8
ADDRFP4 4
INDIRF4
ADDRLP4 12
INDIRF4
SUBF4
ASGNF4
line 223
;223:	if (addspeed <= 0) {
ADDRLP4 8
INDIRF4
CNSTF4 0
GTF4 $103
line 224
;224:		return;
ADDRGP4 $102
JUMPV
LABELV $103
line 226
;225:	}
;226:	accelspeed = accel*pml.frametime*wishspeed;
ADDRLP4 4
ADDRFP4 8
INDIRF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDRFP4 4
INDIRF4
MULF4
ASGNF4
line 227
;227:	if (accelspeed > addspeed) {
ADDRLP4 4
INDIRF4
ADDRLP4 8
INDIRF4
LEF4 $106
line 228
;228:		accelspeed = addspeed;
ADDRLP4 4
ADDRLP4 8
INDIRF4
ASGNF4
line 229
;229:	}
LABELV $106
line 231
;230:	
;231:	for (i=0 ; i<3 ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $108
line 232
;232:		pm->ps->velocity[i] += accelspeed*wishdir[i];	
ADDRLP4 24
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 28
ADDRLP4 24
INDIRI4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDRLP4 24
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 233
;233:	}
LABELV $109
line 231
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $108
line 252
;234:#else
;235:	// proper way (avoids strafe jump maxspeed bug), but feels bad
;236:	vec3_t		wishVelocity;
;237:	vec3_t		pushDir;
;238:	float		pushLen;
;239:	float		canPush;
;240:
;241:	VectorScale( wishdir, wishspeed, wishVelocity );
;242:	VectorSubtract( wishVelocity, pm->ps->velocity, pushDir );
;243:	pushLen = VectorNormalize( pushDir );
;244:
;245:	canPush = accel*pml.frametime*wishspeed;
;246:	if (canPush > pushLen) {
;247:		canPush = pushLen;
;248:	}
;249:
;250:	VectorMA( pm->ps->velocity, canPush, pushDir, pm->ps->velocity );
;251:#endif
;252:}
LABELV $102
endproc PM_Accelerate 32 0
proc PM_CmdScale 44 4
line 265
;253:
;254:
;255:
;256:/*
;257:============
;258:PM_CmdScale
;259:
;260:Returns the scale factor to apply to cmd movements
;261:This allows the clients to use axial -127 to 127 values for all directions
;262:without getting a sqrt(2) distortion in speed.
;263:============
;264:*/
;265:static float PM_CmdScale( usercmd_t *cmd ) {
line 270
;266:	int		max;
;267:	float	total;
;268:	float	scale;
;269:
;270:	max = abs( cmd->forwardmove );
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 12
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ASGNI4
line 271
;271:	if ( abs( cmd->rightmove ) > max ) {
ADDRFP4 0
INDIRP4
CNSTI4 21
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 16
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
ADDRLP4 0
INDIRI4
LEI4 $113
line 272
;272:		max = abs( cmd->rightmove );
ADDRFP4 0
INDIRP4
CNSTI4 21
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 20
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 20
INDIRI4
ASGNI4
line 273
;273:	}
LABELV $113
line 274
;274:	if ( abs( cmd->upmove ) > max ) {
ADDRFP4 0
INDIRP4
CNSTI4 22
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 20
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
ADDRLP4 0
INDIRI4
LEI4 $115
line 275
;275:		max = abs( cmd->upmove );
ADDRFP4 0
INDIRP4
CNSTI4 22
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 24
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 24
INDIRI4
ASGNI4
line 276
;276:	}
LABELV $115
line 277
;277:	if ( !max ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $117
line 278
;278:		return 0;
CNSTF4 0
RETF4
ADDRGP4 $112
JUMPV
LABELV $117
line 281
;279:	}
;280:
;281:	total = sqrt( cmd->forwardmove * cmd->forwardmove
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
ADDRLP4 24
INDIRP4
CNSTI4 20
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 32
ADDRLP4 24
INDIRP4
CNSTI4 21
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 36
ADDRLP4 24
INDIRP4
CNSTI4 22
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 28
INDIRI4
ADDRLP4 28
INDIRI4
MULI4
ADDRLP4 32
INDIRI4
ADDRLP4 32
INDIRI4
MULI4
ADDI4
ADDRLP4 36
INDIRI4
ADDRLP4 36
INDIRI4
MULI4
ADDI4
CVIF4 4
ARGF4
ADDRLP4 40
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 40
INDIRF4
ASGNF4
line 283
;282:		+ cmd->rightmove * cmd->rightmove + cmd->upmove * cmd->upmove );
;283:	scale = (float)pm->ps->speed * max / ( 127.0 * total );
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRI4
CVIF4 4
MULF4
CNSTF4 1123942400
ADDRLP4 4
INDIRF4
MULF4
DIVF4
ASGNF4
line 285
;284:	
;285:	return scale;
ADDRLP4 8
INDIRF4
RETF4
LABELV $112
endproc PM_CmdScale 44 4
proc PM_SetMovementDir 72 0
line 297
;286:}
;287:
;288:
;289:/*
;290:================
;291:PM_SetMovementDir
;292:
;293:Determine the rotation of the legs reletive
;294:to the facing dir
;295:================
;296:*/
;297:static void PM_SetMovementDir( void ) {
line 298
;298:	if ( pm->cmd.forwardmove || pm->cmd.rightmove ) {
ADDRLP4 0
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $122
ADDRLP4 0
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
EQI4 $120
LABELV $122
line 299
;299:		if ( pm->cmd.rightmove == 0 && pm->cmd.forwardmove > 0 ) {
ADDRLP4 8
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRLP4 8
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 12
INDIRI4
NEI4 $123
ADDRLP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 12
INDIRI4
LEI4 $123
line 300
;300:			pm->ps->movementDir = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 0
ASGNI4
line 301
;301:		} else if ( pm->cmd.rightmove < 0 && pm->cmd.forwardmove > 0 ) {
ADDRGP4 $121
JUMPV
LABELV $123
ADDRLP4 16
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 16
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 20
INDIRI4
GEI4 $125
ADDRLP4 16
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 20
INDIRI4
LEI4 $125
line 302
;302:			pm->ps->movementDir = 1;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 1
ASGNI4
line 303
;303:		} else if ( pm->cmd.rightmove < 0 && pm->cmd.forwardmove == 0 ) {
ADDRGP4 $121
JUMPV
LABELV $125
ADDRLP4 24
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 28
CNSTI4 0
ASGNI4
ADDRLP4 24
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 28
INDIRI4
GEI4 $127
ADDRLP4 24
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 28
INDIRI4
NEI4 $127
line 304
;304:			pm->ps->movementDir = 2;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 2
ASGNI4
line 305
;305:		} else if ( pm->cmd.rightmove < 0 && pm->cmd.forwardmove < 0 ) {
ADDRGP4 $121
JUMPV
LABELV $127
ADDRLP4 32
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRLP4 32
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 36
INDIRI4
GEI4 $129
ADDRLP4 32
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 36
INDIRI4
GEI4 $129
line 306
;306:			pm->ps->movementDir = 3;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 3
ASGNI4
line 307
;307:		} else if ( pm->cmd.rightmove == 0 && pm->cmd.forwardmove < 0 ) {
ADDRGP4 $121
JUMPV
LABELV $129
ADDRLP4 40
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 40
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 44
INDIRI4
NEI4 $131
ADDRLP4 40
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 44
INDIRI4
GEI4 $131
line 308
;308:			pm->ps->movementDir = 4;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 4
ASGNI4
line 309
;309:		} else if ( pm->cmd.rightmove > 0 && pm->cmd.forwardmove < 0 ) {
ADDRGP4 $121
JUMPV
LABELV $131
ADDRLP4 48
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 52
CNSTI4 0
ASGNI4
ADDRLP4 48
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 52
INDIRI4
LEI4 $133
ADDRLP4 48
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 52
INDIRI4
GEI4 $133
line 310
;310:			pm->ps->movementDir = 5;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 5
ASGNI4
line 311
;311:		} else if ( pm->cmd.rightmove > 0 && pm->cmd.forwardmove == 0 ) {
ADDRGP4 $121
JUMPV
LABELV $133
ADDRLP4 56
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 60
CNSTI4 0
ASGNI4
ADDRLP4 56
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 60
INDIRI4
LEI4 $135
ADDRLP4 56
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 60
INDIRI4
NEI4 $135
line 312
;312:			pm->ps->movementDir = 6;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 6
ASGNI4
line 313
;313:		} else if ( pm->cmd.rightmove > 0 && pm->cmd.forwardmove > 0 ) {
ADDRGP4 $121
JUMPV
LABELV $135
ADDRLP4 64
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 68
CNSTI4 0
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 68
INDIRI4
LEI4 $121
ADDRLP4 64
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 68
INDIRI4
LEI4 $121
line 314
;314:			pm->ps->movementDir = 7;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 7
ASGNI4
line 315
;315:		}
line 316
;316:	} else {
ADDRGP4 $121
JUMPV
LABELV $120
line 320
;317:		// if they aren't actively going directly sideways,
;318:		// change the animation to the diagonal so they
;319:		// don't stop too crooked
;320:		if ( pm->ps->movementDir == 2 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
CNSTI4 2
NEI4 $139
line 321
;321:			pm->ps->movementDir = 1;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 1
ASGNI4
line 322
;322:		} else if ( pm->ps->movementDir == 6 ) {
ADDRGP4 $140
JUMPV
LABELV $139
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
CNSTI4 6
NEI4 $141
line 323
;323:			pm->ps->movementDir = 7;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 88
ADDP4
CNSTI4 7
ASGNI4
line 324
;324:		} 
LABELV $141
LABELV $140
line 325
;325:	}
LABELV $121
line 328
;326:	
;327:	
;328:}
LABELV $119
endproc PM_SetMovementDir 72 0
proc PM_CheckJump 12 4
line 336
;329:
;330:
;331:/*
;332:=============
;333:PM_CheckJump
;334:=============
;335:*/
;336:static qboolean PM_CheckJump( void ) {
line 337
;337:	if ( pm->ps->pm_flags & PMF_RESPAWNED ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $144
line 338
;338:		return qfalse;		// don't allow jump until all buttons are up
CNSTI4 0
RETI4
ADDRGP4 $143
JUMPV
LABELV $144
line 341
;339:	}
;340:
;341:	if ( pm->cmd.upmove < 10 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CNSTI4 10
GEI4 $146
line 343
;342:		// not holding jump
;343:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $143
JUMPV
LABELV $146
line 346
;344:	}
;345:	// must wait for jump to be released
;346:	if ( pm->ps->pm_flags & PMF_JUMP_HELD ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $148
line 348
;347:		// clear upmove so cmdscale doesn't lower running speed
;348:		pm->cmd.upmove = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
CNSTI1 0
ASGNI1
line 349
;349:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $143
JUMPV
LABELV $148
line 352
;350:	}
;351:
;352:	pml.groundPlane = qfalse;		// jumping away
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 353
;353:	pml.walking = qfalse;
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 354
;354:	pm->ps->pm_flags |= PMF_JUMP_HELD;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 356
;355:
;356:	pm->ps->groundEntityNum = ENTITYNUM_NONE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
CNSTI4 1023
ASGNI4
line 357
;357:	if(	pm->ps->stats[STAT_JUMPSCALE] >= 0)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 0
LTI4 $152
line 358
;358:		pm->ps->velocity[2] = pm->ps->stats[STAT_JUMPSCALE];
ADDRLP4 4
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CVIF4 4
ASGNF4
ADDRGP4 $153
JUMPV
LABELV $152
line 360
;359:	else
;360:		pm->ps->velocity[2] = JUMP_VELOCITY;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1132920832
ASGNF4
LABELV $153
line 361
;361:	PM_AddEvent( EV_JUMP );
CNSTI4 14
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 363
;362:
;363:	if ( pm->cmd.forwardmove >= 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
LTI4 $154
line 364
;364:		PM_ForceLegsAnim( LEGS_JUMP );
CNSTI4 18
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 365
;365:		pm->ps->pm_flags &= ~PMF_BACKWARDS_JUMP;
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
line 366
;366:	} else {
ADDRGP4 $155
JUMPV
LABELV $154
line 367
;367:		PM_ForceLegsAnim( LEGS_JUMPB );
CNSTI4 20
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 368
;368:		pm->ps->pm_flags |= PMF_BACKWARDS_JUMP;
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 369
;369:	}
LABELV $155
line 371
;370:
;371:	return qtrue;
CNSTI4 1
RETI4
LABELV $143
endproc PM_CheckJump 12 4
proc PM_CheckWaterJump 56 8
line 379
;372:}
;373:
;374:/*
;375:=============
;376:PM_CheckWaterJump
;377:=============
;378:*/
;379:static qboolean	PM_CheckWaterJump( void ) {
line 384
;380:	vec3_t	spot;
;381:	int		cont;
;382:	vec3_t	flatforward;
;383:
;384:	if (pm->ps->pm_time) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 0
EQI4 $157
line 385
;385:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $156
JUMPV
LABELV $157
line 389
;386:	}
;387:
;388:	// check for water jump
;389:	if ( pm->waterlevel != 2 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 2
EQI4 $159
line 390
;390:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $156
JUMPV
LABELV $159
line 393
;391:	}
;392:
;393:	flatforward[0] = pml.forward[0];
ADDRLP4 12
ADDRGP4 pml
INDIRF4
ASGNF4
line 394
;394:	flatforward[1] = pml.forward[1];
ADDRLP4 12+4
ADDRGP4 pml+4
INDIRF4
ASGNF4
line 395
;395:	flatforward[2] = 0;
ADDRLP4 12+8
CNSTF4 0
ASGNF4
line 396
;396:	VectorNormalize (flatforward);
ADDRLP4 12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 398
;397:
;398:	VectorMA (pm->ps->origin, 30, flatforward, spot);
ADDRLP4 28
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 32
CNSTF4 1106247680
ASGNF4
ADDRLP4 0
ADDRLP4 28
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 28
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 12+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 1106247680
ADDRLP4 12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 399
;399:	spot[2] += 4;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1082130432
ADDF4
ASGNF4
line 400
;400:	cont = pm->pointcontents (spot, pm->ps->clientNum );
ADDRLP4 0
ARGP4
ADDRLP4 36
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 40
ADDRLP4 36
INDIRP4
CNSTI4 216
ADDP4
INDIRP4
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 40
INDIRI4
ASGNI4
line 401
;401:	if ( !(cont & CONTENTS_SOLID) ) {
ADDRLP4 24
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $169
line 402
;402:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $156
JUMPV
LABELV $169
line 405
;403:	}
;404:
;405:	spot[2] += 16;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1098907648
ADDF4
ASGNF4
line 406
;406:	cont = pm->pointcontents (spot, pm->ps->clientNum );
ADDRLP4 0
ARGP4
ADDRLP4 44
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 48
ADDRLP4 44
INDIRP4
CNSTI4 216
ADDP4
INDIRP4
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 48
INDIRI4
ASGNI4
line 407
;407:	if ( cont ) {
ADDRLP4 24
INDIRI4
CNSTI4 0
EQI4 $172
line 408
;408:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $156
JUMPV
LABELV $172
line 412
;409:	}
;410:
;411:	// jump out of water
;412:	VectorScale (pml.forward, 200, pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1128792064
ADDRGP4 pml
INDIRF4
MULF4
ASGNF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1128792064
ADDRGP4 pml+4
INDIRF4
MULF4
ASGNF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1128792064
ADDRGP4 pml+8
INDIRF4
MULF4
ASGNF4
line 413
;413:	pm->ps->velocity[2] = 350;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1135542272
ASGNF4
line 415
;414:
;415:	pm->ps->pm_flags |= PMF_TIME_WATERJUMP;
ADDRLP4 52
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRI4
CNSTI4 256
BORI4
ASGNI4
line 416
;416:	pm->ps->pm_time = 2000;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 2000
ASGNI4
line 418
;417:
;418:	return qtrue;
CNSTI4 1
RETI4
LABELV $156
endproc PM_CheckWaterJump 56 8
proc PM_WaterJumpMove 12 4
line 431
;419:}
;420:
;421://============================================================================
;422:
;423:
;424:/*
;425:===================
;426:PM_WaterJumpMove
;427:
;428:Flying out of the water
;429:===================
;430:*/
;431:static void PM_WaterJumpMove( void ) {
line 434
;432:	// waterjump has no control, but falls
;433:
;434:	PM_StepSlideMove( qtrue );
CNSTI4 1
ARGI4
ADDRGP4 PM_StepSlideMove
CALLV
pop
line 436
;435:
;436:	pm->ps->velocity[2] -= pm->ps->gravity * pml.frametime;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pml+36
INDIRF4
MULF4
SUBF4
ASGNF4
line 437
;437:	if (pm->ps->velocity[2] < 0) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 0
GEF4 $178
line 439
;438:		// cancel as soon as we are falling down again
;439:		pm->ps->pm_flags &= ~PMF_ALL_TIMES;
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -353
BANDI4
ASGNI4
line 440
;440:		pm->ps->pm_time = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 0
ASGNI4
line 441
;441:	}
LABELV $178
line 442
;442:}
LABELV $176
endproc PM_WaterJumpMove 12 4
proc PM_WaterMove 76 16
line 450
;443:
;444:/*
;445:===================
;446:PM_WaterMove
;447:
;448:===================
;449:*/
;450:static void PM_WaterMove( void ) {
line 458
;451:	int		i;
;452:	vec3_t	wishvel;
;453:	float	wishspeed;
;454:	vec3_t	wishdir;
;455:	float	scale;
;456:	float	vel;
;457:
;458:	if ( PM_CheckWaterJump() ) {
ADDRLP4 40
ADDRGP4 PM_CheckWaterJump
CALLI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 0
EQI4 $181
line 459
;459:		PM_WaterJumpMove();
ADDRGP4 PM_WaterJumpMove
CALLV
pop
line 460
;460:		return;
ADDRGP4 $180
JUMPV
LABELV $181
line 476
;461:	}
;462:#if 0
;463:	// jump = head for surface
;464:	if ( pm->cmd.upmove >= 10 ) {
;465:		if (pm->ps->velocity[2] > -300) {
;466:			if ( pm->watertype == CONTENTS_WATER ) {
;467:				pm->ps->velocity[2] = 100;
;468:			} else if (pm->watertype == CONTENTS_SLIME) {
;469:				pm->ps->velocity[2] = 80;
;470:			} else {
;471:				pm->ps->velocity[2] = 50;
;472:			}
;473:		}
;474:	}
;475:#endif
;476:	PM_Friction ();
ADDRGP4 PM_Friction
CALLV
pop
line 478
;477:
;478:	scale = PM_CmdScale( &pm->cmd );
ADDRGP4 pm
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 44
ADDRGP4 PM_CmdScale
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 44
INDIRF4
ASGNF4
line 482
;479:	//
;480:	// user intentions
;481:	//
;482:	if ( !scale ) {
ADDRLP4 4
INDIRF4
CNSTF4 0
NEF4 $183
line 483
;483:		wishvel[0] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
line 484
;484:		wishvel[1] = 0;
ADDRLP4 8+4
CNSTF4 0
ASGNF4
line 485
;485:		wishvel[2] = -60;		// sink towards bottom
ADDRLP4 8+8
CNSTF4 3262119936
ASGNF4
line 486
;486:	} else {
ADDRGP4 $184
JUMPV
LABELV $183
line 487
;487:		for (i=0 ; i<3 ; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $187
line 488
;488:			wishvel[i] = scale * pml.forward[i]*pm->cmd.forwardmove + scale * pml.right[i]*pm->cmd.rightmove;
ADDRLP4 48
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 56
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 48
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 4
INDIRF4
ADDRLP4 48
INDIRI4
ADDRGP4 pml
ADDP4
INDIRF4
MULF4
ADDRLP4 56
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CVIF4 4
MULF4
ADDRLP4 4
INDIRF4
ADDRLP4 48
INDIRI4
ADDRGP4 pml+12
ADDP4
INDIRF4
MULF4
ADDRLP4 56
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
CVIF4 4
MULF4
ADDF4
ASGNF4
LABELV $188
line 487
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $187
line 490
;489:
;490:		wishvel[2] += scale * pm->cmd.upmove;
ADDRLP4 8+8
ADDRLP4 8+8
INDIRF4
ADDRLP4 4
INDIRF4
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CVIF4 4
MULF4
ADDF4
ASGNF4
line 491
;491:	}
LABELV $184
line 493
;492:
;493:	VectorCopy (wishvel, wishdir);
ADDRLP4 24
ADDRLP4 8
INDIRB
ASGNB 12
line 494
;494:	wishspeed = VectorNormalize(wishdir);
ADDRLP4 24
ARGP4
ADDRLP4 48
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 48
INDIRF4
ASGNF4
line 496
;495:
;496:	if ( wishspeed > pm->ps->speed * pm_swimScale ) {
ADDRLP4 20
INDIRF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pm_swimScale
INDIRF4
MULF4
LEF4 $193
line 497
;497:		wishspeed = pm->ps->speed * pm_swimScale;
ADDRLP4 20
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pm_swimScale
INDIRF4
MULF4
ASGNF4
line 498
;498:	}
LABELV $193
line 500
;499:
;500:	PM_Accelerate (wishdir, wishspeed, pm_wateraccelerate);
ADDRLP4 24
ARGP4
ADDRLP4 20
INDIRF4
ARGF4
ADDRGP4 pm_wateraccelerate
INDIRF4
ARGF4
ADDRGP4 PM_Accelerate
CALLV
pop
line 503
;501:
;502:	// make sure we can go up slopes easily under water
;503:	if ( pml.groundPlane && DotProduct( pm->ps->velocity, pml.groundTrace.plane.normal ) < 0 ) {
ADDRGP4 pml+48
INDIRI4
CNSTI4 0
EQI4 $195
ADDRLP4 52
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 52
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 pml+52+24
INDIRF4
MULF4
ADDRLP4 52
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 pml+52+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 52
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 pml+52+24+8
INDIRF4
MULF4
ADDF4
CNSTF4 0
GEF4 $195
line 504
;504:		vel = VectorLength(pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRLP4 56
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 36
ADDRLP4 56
INDIRF4
ASGNF4
line 506
;505:		// slide along the ground plane
;506:		PM_ClipVelocity (pm->ps->velocity, pml.groundTrace.plane.normal, 
ADDRLP4 60
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 509
;507:			pm->ps->velocity, OVERCLIP );
;508:
;509:		VectorNormalize(pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 510
;510:		VectorScale(pm->ps->velocity, vel, pm->ps->velocity);
ADDRLP4 64
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 36
INDIRF4
MULF4
ASGNF4
ADDRLP4 68
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRLP4 36
INDIRF4
MULF4
ASGNF4
ADDRLP4 72
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 36
INDIRF4
MULF4
ASGNF4
line 511
;511:	}
LABELV $195
line 513
;512:
;513:	PM_SlideMove( qfalse );
CNSTI4 0
ARGI4
ADDRGP4 PM_SlideMove
CALLI4
pop
line 514
;514:}
LABELV $180
endproc PM_WaterMove 76 16
proc PM_FlyMove 52 12
line 525
;515:
;516:
;517:
;518:/*
;519:===================
;520:PM_FlyMove
;521:
;522:Only with the flight powerup
;523:===================
;524:*/
;525:static void PM_FlyMove( void ) {
line 533
;526:	int		i;
;527:	vec3_t	wishvel;
;528:	float	wishspeed;
;529:	vec3_t	wishdir;
;530:	float	scale;
;531:
;532:	// normal slowdown
;533:	PM_Friction ();
ADDRGP4 PM_Friction
CALLV
pop
line 535
;534:
;535:	scale = PM_CmdScale( &pm->cmd );
ADDRGP4 pm
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 36
ADDRGP4 PM_CmdScale
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 36
INDIRF4
ASGNF4
line 539
;536:	//
;537:	// user intentions
;538:	//
;539:	if ( !scale ) {
ADDRLP4 4
INDIRF4
CNSTF4 0
NEF4 $209
line 540
;540:		wishvel[0] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
line 541
;541:		wishvel[1] = 0;
ADDRLP4 8+4
CNSTF4 0
ASGNF4
line 542
;542:		wishvel[2] = 0;
ADDRLP4 8+8
CNSTF4 0
ASGNF4
line 543
;543:	} else {
ADDRGP4 $210
JUMPV
LABELV $209
line 544
;544:		for (i=0 ; i<3 ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $213
line 545
;545:			wishvel[i] = scale * pml.forward[i]*pm->cmd.forwardmove + scale * pml.right[i]*pm->cmd.rightmove;
ADDRLP4 40
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 48
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 40
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 4
INDIRF4
ADDRLP4 40
INDIRI4
ADDRGP4 pml
ADDP4
INDIRF4
MULF4
ADDRLP4 48
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CVIF4 4
MULF4
ADDRLP4 4
INDIRF4
ADDRLP4 40
INDIRI4
ADDRGP4 pml+12
ADDP4
INDIRF4
MULF4
ADDRLP4 48
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
CVIF4 4
MULF4
ADDF4
ASGNF4
line 546
;546:		}
LABELV $214
line 544
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $213
line 548
;547:
;548:		wishvel[2] += scale * pm->cmd.upmove;
ADDRLP4 8+8
ADDRLP4 8+8
INDIRF4
ADDRLP4 4
INDIRF4
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CVIF4 4
MULF4
ADDF4
ASGNF4
line 549
;549:	}
LABELV $210
line 551
;550:
;551:	VectorCopy (wishvel, wishdir);
ADDRLP4 20
ADDRLP4 8
INDIRB
ASGNB 12
line 552
;552:	wishspeed = VectorNormalize(wishdir);
ADDRLP4 20
ARGP4
ADDRLP4 40
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 40
INDIRF4
ASGNF4
line 554
;553:
;554:	PM_Accelerate (wishdir, wishspeed, pm_flyaccelerate);
ADDRLP4 20
ARGP4
ADDRLP4 32
INDIRF4
ARGF4
ADDRGP4 pm_flyaccelerate
INDIRF4
ARGF4
ADDRGP4 PM_Accelerate
CALLV
pop
line 556
;555:
;556:	PM_StepSlideMove( qfalse );
CNSTI4 0
ARGI4
ADDRGP4 PM_StepSlideMove
CALLV
pop
line 557
;557:}
LABELV $208
endproc PM_FlyMove 52 12
proc PM_AirMove 80 16
line 566
;558:
;559:
;560:/*
;561:===================
;562:PM_AirMove
;563:
;564:===================
;565:*/
;566:static void PM_AirMove( void ) {
line 575
;567:	int			i;
;568:	vec3_t		wishvel;
;569:	float		fmove, smove;
;570:	vec3_t		wishdir;
;571:	float		wishspeed;
;572:	float		scale;
;573:	usercmd_t	cmd;
;574:
;575:	PM_Friction();
ADDRGP4 PM_Friction
CALLV
pop
line 577
;576:
;577:	fmove = pm->cmd.forwardmove;
ADDRLP4 16
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 578
;578:	smove = pm->cmd.rightmove;
ADDRLP4 20
ADDRGP4 pm
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 580
;579:
;580:	cmd = pm->cmd;
ADDRLP4 44
ADDRGP4 pm
INDIRP4
CNSTI4 4
ADDP4
INDIRB
ASGNB 24
line 581
;581:	scale = PM_CmdScale( &cmd );
ADDRLP4 44
ARGP4
ADDRLP4 68
ADDRGP4 PM_CmdScale
CALLF4
ASGNF4
ADDRLP4 40
ADDRLP4 68
INDIRF4
ASGNF4
line 584
;582:
;583:	// set the movementDir so clients can rotate the legs for strafing
;584:	PM_SetMovementDir();
ADDRGP4 PM_SetMovementDir
CALLV
pop
line 587
;585:
;586:	// project moves down to flat plane
;587:	pml.forward[2] = 0;
ADDRGP4 pml+8
CNSTF4 0
ASGNF4
line 588
;588:	pml.right[2] = 0;
ADDRGP4 pml+12+8
CNSTF4 0
ASGNF4
line 589
;589:	VectorNormalize (pml.forward);
ADDRGP4 pml
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 590
;590:	VectorNormalize (pml.right);
ADDRGP4 pml+12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 592
;591:
;592:	for ( i = 0 ; i < 2 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $224
line 593
;593:		wishvel[i] = pml.forward[i]*fmove + pml.right[i]*smove;
ADDRLP4 72
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 72
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 72
INDIRI4
ADDRGP4 pml
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 72
INDIRI4
ADDRGP4 pml+12
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
line 594
;594:	}
LABELV $225
line 592
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LTI4 $224
line 595
;595:	wishvel[2] = 0;
ADDRLP4 4+8
CNSTF4 0
ASGNF4
line 597
;596:
;597:	VectorCopy (wishvel, wishdir);
ADDRLP4 24
ADDRLP4 4
INDIRB
ASGNB 12
line 598
;598:	wishspeed = VectorNormalize(wishdir);
ADDRLP4 24
ARGP4
ADDRLP4 72
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 36
ADDRLP4 72
INDIRF4
ASGNF4
line 599
;599:	wishspeed *= scale;
ADDRLP4 36
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ASGNF4
line 602
;600:
;601:	// not on ground, so little effect on velocity
;602:	PM_Accelerate (wishdir, wishspeed, pm_airaccelerate);
ADDRLP4 24
ARGP4
ADDRLP4 36
INDIRF4
ARGF4
ADDRGP4 pm_airaccelerate
INDIRF4
ARGF4
ADDRGP4 PM_Accelerate
CALLV
pop
line 607
;603:
;604:	// we may have a ground plane that is very steep, even
;605:	// though we don't have a groundentity
;606:	// slide along the steep plane
;607:	if ( pml.groundPlane ) {
ADDRGP4 pml+48
INDIRI4
CNSTI4 0
EQI4 $230
line 608
;608:		PM_ClipVelocity (pm->ps->velocity, pml.groundTrace.plane.normal, 
ADDRLP4 76
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRLP4 76
INDIRP4
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 610
;609:			pm->ps->velocity, OVERCLIP );
;610:	}
LABELV $230
line 622
;611:
;612:#if 0
;613:	//ZOID:  If we are on the grapple, try stair-stepping
;614:	//this allows a player to use the grapple to pull himself
;615:	//over a ledge
;616:	if (pm->ps->pm_flags & PMF_GRAPPLE_PULL)
;617:		PM_StepSlideMove ( qtrue );
;618:	else
;619:		PM_SlideMove ( qtrue );
;620:#endif
;621:
;622:	PM_StepSlideMove ( qtrue );
CNSTI4 1
ARGI4
ADDRGP4 PM_StepSlideMove
CALLV
pop
line 623
;623:}
LABELV $219
endproc PM_AirMove 80 16
proc PM_GrappleMove 52 4
line 631
;624:
;625:/*
;626:===================
;627:PM_GrappleMove
;628:
;629:===================
;630:*/
;631:static void PM_GrappleMove( void ) {
line 635
;632:	vec3_t vel, v;
;633:	float vlen;
;634:
;635:	VectorScale(pml.forward, -16, v);
ADDRLP4 28
CNSTF4 3246391296
ASGNF4
ADDRLP4 12
ADDRLP4 28
INDIRF4
ADDRGP4 pml
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 28
INDIRF4
ADDRGP4 pml+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+8
CNSTF4 3246391296
ADDRGP4 pml+8
INDIRF4
MULF4
ASGNF4
line 636
;636:	VectorAdd(pm->ps->grapplePoint, v, v);
ADDRLP4 32
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 32
INDIRP4
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 32
INDIRP4
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 12+8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDF4
ASGNF4
line 637
;637:	VectorSubtract(v, pm->ps->origin, vel);
ADDRLP4 36
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRF4
ADDRLP4 36
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 12+4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 12+8
INDIRF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
SUBF4
ASGNF4
line 638
;638:	vlen = VectorLength(vel);
ADDRLP4 0
ARGP4
ADDRLP4 40
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 40
INDIRF4
ASGNF4
line 639
;639:	VectorNormalize( vel );
ADDRLP4 0
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 641
;640:
;641:	if (vlen <= 100)
ADDRLP4 24
INDIRF4
CNSTF4 1120403456
GTF4 $248
line 642
;642:		VectorScale(vel, 10 * vlen, vel);
ADDRLP4 44
CNSTF4 1092616192
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1092616192
ADDRLP4 24
INDIRF4
MULF4
MULF4
ASGNF4
ADDRGP4 $249
JUMPV
LABELV $248
line 644
;643:	else
;644:		VectorScale(vel, 800, vel);
ADDRLP4 48
CNSTF4 1145569280
ASGNF4
ADDRLP4 0
ADDRLP4 48
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 48
INDIRF4
ADDRLP4 0+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+8
CNSTF4 1145569280
ADDRLP4 0+8
INDIRF4
MULF4
ASGNF4
LABELV $249
line 646
;645:
;646:	VectorCopy(vel, pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ADDRLP4 0
INDIRB
ASGNB 12
line 648
;647:
;648:	pml.groundPlane = qfalse;
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 649
;649:}
LABELV $235
endproc PM_GrappleMove 52 4
proc PM_CrawlMove 128 16
line 657
;650:
;651:/*
;652:===================
;653:PM_CrawlMove
;654:
;655:===================
;656:*/
;657:static void PM_CrawlMove( void ) {
line 668
;658:	int			i;
;659:	vec3_t		wishvel;
;660:	float		fmove, smove;
;661:	vec3_t		wishdir;
;662:	float		wishspeed;
;663:	float		scale;
;664:	usercmd_t	cmd;
;665:	float		accelerate;
;666:	float		vel;
;667:
;668:	if ( pm->waterlevel > 2 && DotProduct( pml.forward, pml.groundTrace.plane.normal ) > 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 2
LEI4 $260
ADDRGP4 pml
INDIRF4
ADDRGP4 pml+52+24
INDIRF4
MULF4
ADDRGP4 pml+4
INDIRF4
ADDRGP4 pml+52+24+4
INDIRF4
MULF4
ADDF4
ADDRGP4 pml+8
INDIRF4
ADDRGP4 pml+52+24+8
INDIRF4
MULF4
ADDF4
CNSTF4 0
LEF4 $260
line 670
;669:		// begin swimming
;670:		PM_WaterMove();
ADDRGP4 PM_WaterMove
CALLV
pop
line 671
;671:		return;
ADDRGP4 $259
JUMPV
LABELV $260
line 675
;672:	}
;673:
;674:
;675:	if ( PM_CheckJump () ) {
ADDRLP4 76
ADDRGP4 PM_CheckJump
CALLI4
ASGNI4
ADDRLP4 76
INDIRI4
CNSTI4 0
EQI4 $272
line 677
;676:		// jumped away
;677:		if ( pm->waterlevel > 1 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
LEI4 $274
line 678
;678:			PM_WaterMove();
ADDRGP4 PM_WaterMove
CALLV
pop
line 679
;679:		} else {
ADDRGP4 $259
JUMPV
LABELV $274
line 680
;680:			PM_AirMove();
ADDRGP4 PM_AirMove
CALLV
pop
line 681
;681:		}
line 682
;682:		return;
ADDRGP4 $259
JUMPV
LABELV $272
line 685
;683:	}
;684:
;685:	if(!(pm->ps->legsAnim & ANIM_CLIMBWALLS))
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $276
line 686
;686:		pm->ps->legsAnim |= ANIM_CLIMBWALLS;
ADDRLP4 80
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
LABELV $276
line 688
;687:
;688:	PM_Friction ();
ADDRGP4 PM_Friction
CALLV
pop
line 690
;689:
;690:	fmove = pm->cmd.forwardmove;
ADDRLP4 16
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 691
;691:	smove = pm->cmd.rightmove;
ADDRLP4 20
ADDRGP4 pm
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 693
;692:
;693:	cmd = pm->cmd;
ADDRLP4 48
ADDRGP4 pm
INDIRP4
CNSTI4 4
ADDP4
INDIRB
ASGNB 24
line 694
;694:	scale = PM_CmdScale( &cmd );
ADDRLP4 48
ARGP4
ADDRLP4 84
ADDRGP4 PM_CmdScale
CALLF4
ASGNF4
ADDRLP4 44
ADDRLP4 84
INDIRF4
ASGNF4
line 697
;695:
;696:	// set the movementDir so clients can rotate the legs for strafing
;697:	PM_SetMovementDir();
ADDRGP4 PM_SetMovementDir
CALLV
pop
line 704
;698:
;699:	// project moves down to flat plane
;700:	//pml.forward[2] = 0;
;701:	//pml.right[2] = 0;
;702:
;703:	// project the forward and right directions onto the ground plane
;704:	PM_ClipVelocity (pml.forward, pml.groundTrace.plane.normal, pml.forward, OVERCLIP );
ADDRLP4 88
ADDRGP4 pml
ASGNP4
ADDRLP4 88
INDIRP4
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRLP4 88
INDIRP4
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 705
;705:	PM_ClipVelocity (pml.right, pml.groundTrace.plane.normal, pml.right, OVERCLIP );
ADDRGP4 pml+12
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRGP4 pml+12
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 707
;706:	//
;707:	VectorNormalize (pml.forward);
ADDRGP4 pml
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 708
;708:	VectorNormalize (pml.right);
ADDRGP4 pml+12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 710
;709:
;710:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $285
line 711
;711:		wishvel[i] = pml.forward[i]*fmove + pml.right[i]*smove;
ADDRLP4 92
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 92
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 92
INDIRI4
ADDRGP4 pml
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 92
INDIRI4
ADDRGP4 pml+12
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
line 712
;712:	}
LABELV $286
line 710
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $285
line 716
;713:	// when going up or down slopes the wish velocity should Not be zero
;714://	wishvel[2] = 0;
;715:
;716:	VectorCopy (wishvel, wishdir);
ADDRLP4 32
ADDRLP4 4
INDIRB
ASGNB 12
line 717
;717:	wishspeed = VectorNormalize(wishdir);
ADDRLP4 32
ARGP4
ADDRLP4 92
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 28
ADDRLP4 92
INDIRF4
ASGNF4
line 718
;718:	wishspeed *= scale;
ADDRLP4 28
ADDRLP4 28
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ASGNF4
line 721
;719:
;720:	// clamp the speed lower if ducking
;721:	if ( pm->ps->pm_flags & PMF_DUCKED ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $290
line 722
;722:		if ( wishspeed > pm->ps->speed * pm_duckScale ) {
ADDRLP4 28
INDIRF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pm_duckScale
INDIRF4
MULF4
LEF4 $292
line 723
;723:			wishspeed = pm->ps->speed * pm_duckScale;
ADDRLP4 28
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pm_duckScale
INDIRF4
MULF4
ASGNF4
line 724
;724:		}
LABELV $292
line 725
;725:	}
LABELV $290
line 728
;726:
;727:	// clamp the speed lower if wading or walking on the bottom
;728:	if ( pm->waterlevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 0
EQI4 $294
line 731
;729:		float	waterScale;
;730:
;731:		waterScale = pm->waterlevel / 3.0;
ADDRLP4 96
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1077936128
DIVF4
ASGNF4
line 732
;732:		waterScale = 1.0 - ( 1.0 - pm_swimScale ) * waterScale;
ADDRLP4 100
CNSTF4 1065353216
ASGNF4
ADDRLP4 96
ADDRLP4 100
INDIRF4
ADDRLP4 100
INDIRF4
ADDRGP4 pm_swimScale
INDIRF4
SUBF4
ADDRLP4 96
INDIRF4
MULF4
SUBF4
ASGNF4
line 733
;733:		if ( wishspeed > pm->ps->speed * waterScale ) {
ADDRLP4 28
INDIRF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 96
INDIRF4
MULF4
LEF4 $296
line 734
;734:			wishspeed = pm->ps->speed * waterScale;
ADDRLP4 28
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 96
INDIRF4
MULF4
ASGNF4
line 735
;735:		}
LABELV $296
line 736
;736:	}
LABELV $294
line 740
;737:
;738:	// when a player gets hit, they temporarily lose
;739:	// full control, which allows them to be moved a bit
;740:	if ( ( pml.groundTrace.surfaceFlags & SURF_SLICK ) || pm->ps->pm_flags & PMF_TIME_KNOCKBACK ) {
ADDRLP4 96
CNSTI4 0
ASGNI4
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 2
BANDI4
ADDRLP4 96
INDIRI4
NEI4 $302
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 64
BANDI4
ADDRLP4 96
INDIRI4
EQI4 $298
LABELV $302
line 741
;741:		accelerate = pm_airaccelerate;
ADDRLP4 72
ADDRGP4 pm_airaccelerate
INDIRF4
ASGNF4
line 742
;742:	} else {
ADDRGP4 $299
JUMPV
LABELV $298
line 743
;743:		accelerate = pm_accelerate;
ADDRLP4 72
ADDRGP4 pm_accelerate
INDIRF4
ASGNF4
line 744
;744:	}
LABELV $299
line 746
;745:
;746:	PM_Accelerate (wishdir, wishspeed, accelerate);
ADDRLP4 32
ARGP4
ADDRLP4 28
INDIRF4
ARGF4
ADDRLP4 72
INDIRF4
ARGF4
ADDRGP4 PM_Accelerate
CALLV
pop
line 748
;747:
;748:	if ( ( pml.groundTrace.surfaceFlags & SURF_SLICK ) || pm->ps->pm_flags & PMF_TIME_KNOCKBACK ) {
ADDRLP4 100
CNSTI4 0
ASGNI4
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 2
BANDI4
ADDRLP4 100
INDIRI4
NEI4 $307
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 64
BANDI4
ADDRLP4 100
INDIRI4
EQI4 $303
LABELV $307
line 749
;749:		pm->ps->velocity[2] -= pm->ps->gravity * pml.frametime;
ADDRLP4 104
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 108
ADDRLP4 104
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 108
INDIRP4
ADDRLP4 108
INDIRP4
INDIRF4
ADDRLP4 104
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pml+36
INDIRF4
MULF4
SUBF4
ASGNF4
line 750
;750:	} else {
LABELV $303
line 753
;751:		// don't reset the z velocity for slopes
;752://		pm->ps->velocity[2] = 0;
;753:	}
LABELV $304
line 755
;754:
;755:	vel = VectorLength(pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRLP4 104
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 104
INDIRF4
ASGNF4
line 758
;756:
;757:	// slide along the ground plane
;758:	PM_ClipVelocity (pm->ps->velocity, pml.groundTrace.plane.normal, 
ADDRLP4 108
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 108
INDIRP4
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRLP4 108
INDIRP4
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 762
;759:		pm->ps->velocity, OVERCLIP );
;760:
;761:	// don't decrease velocity when going up or down a slope
;762:	VectorNormalize(pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 763
;763:	VectorScale(pm->ps->velocity, vel, pm->ps->velocity);
ADDRLP4 112
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 116
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 116
INDIRP4
ADDRLP4 116
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 120
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 120
INDIRP4
ADDRLP4 120
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
line 766
;764:
;765:	// don't do anything if standing still
;766:	if (DotProduct(pm->ps->velocity, pml.groundTrace.plane.normal) == vel) {
ADDRLP4 124
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 pml+52+24
INDIRF4
MULF4
ADDRLP4 124
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 pml+52+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 124
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 pml+52+24+8
INDIRF4
MULF4
ADDF4
ADDRLP4 24
INDIRF4
NEF4 $311
line 767
;767:		return;
ADDRGP4 $259
JUMPV
LABELV $311
line 770
;768:	}
;769:
;770:	PM_SlideMove( qfalse );
CNSTI4 0
ARGI4
ADDRGP4 PM_SlideMove
CALLI4
pop
line 773
;771:			
;772:
;773:}
LABELV $259
endproc PM_CrawlMove 128 16
proc PM_WalkMove 128 16
line 781
;774:
;775:/*
;776:===================
;777:PM_WalkMove
;778:
;779:===================
;780:*/
;781:static void PM_WalkMove( void ) {
line 792
;782:	int			i;
;783:	vec3_t		wishvel;
;784:	float		fmove, smove;
;785:	vec3_t		wishdir;
;786:	float		wishspeed;
;787:	float		scale;
;788:	usercmd_t	cmd;
;789:	float		accelerate;
;790:	float		vel;
;791:
;792:	if ( pm->waterlevel > 2 && DotProduct( pml.forward, pml.groundTrace.plane.normal ) > 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 2
LEI4 $322
ADDRGP4 pml
INDIRF4
ADDRGP4 pml+52+24
INDIRF4
MULF4
ADDRGP4 pml+4
INDIRF4
ADDRGP4 pml+52+24+4
INDIRF4
MULF4
ADDF4
ADDRGP4 pml+8
INDIRF4
ADDRGP4 pml+52+24+8
INDIRF4
MULF4
ADDF4
CNSTF4 0
LEF4 $322
line 794
;793:		// begin swimming
;794:		PM_WaterMove();
ADDRGP4 PM_WaterMove
CALLV
pop
line 795
;795:		return;
ADDRGP4 $321
JUMPV
LABELV $322
line 799
;796:	}
;797:
;798:
;799:	if ( PM_CheckJump () ) {
ADDRLP4 76
ADDRGP4 PM_CheckJump
CALLI4
ASGNI4
ADDRLP4 76
INDIRI4
CNSTI4 0
EQI4 $334
line 801
;800:		// jumped away
;801:		if ( pm->waterlevel > 1 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
LEI4 $336
line 802
;802:			PM_WaterMove();
ADDRGP4 PM_WaterMove
CALLV
pop
line 803
;803:		} else {
ADDRGP4 $321
JUMPV
LABELV $336
line 804
;804:			PM_AirMove();
ADDRGP4 PM_AirMove
CALLV
pop
line 805
;805:		}
line 806
;806:		return;
ADDRGP4 $321
JUMPV
LABELV $334
line 809
;807:	}
;808:
;809:	PM_Friction ();
ADDRGP4 PM_Friction
CALLV
pop
line 811
;810:
;811:	fmove = pm->cmd.forwardmove;
ADDRLP4 16
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 812
;812:	smove = pm->cmd.rightmove;
ADDRLP4 20
ADDRGP4 pm
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 814
;813:
;814:	cmd = pm->cmd;
ADDRLP4 48
ADDRGP4 pm
INDIRP4
CNSTI4 4
ADDP4
INDIRB
ASGNB 24
line 815
;815:	scale = PM_CmdScale( &cmd );
ADDRLP4 48
ARGP4
ADDRLP4 80
ADDRGP4 PM_CmdScale
CALLF4
ASGNF4
ADDRLP4 44
ADDRLP4 80
INDIRF4
ASGNF4
line 818
;816:
;817:	// set the movementDir so clients can rotate the legs for strafing
;818:	PM_SetMovementDir();
ADDRGP4 PM_SetMovementDir
CALLV
pop
line 821
;819:
;820:	// project moves down to flat plane
;821:	pml.forward[2] = 0;
ADDRGP4 pml+8
CNSTF4 0
ASGNF4
line 822
;822:	pml.right[2] = 0;
ADDRGP4 pml+12+8
CNSTF4 0
ASGNF4
line 825
;823:
;824:	// project the forward and right directions onto the ground plane
;825:	PM_ClipVelocity (pml.forward, pml.groundTrace.plane.normal, pml.forward, OVERCLIP );
ADDRLP4 84
ADDRGP4 pml
ASGNP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 826
;826:	PM_ClipVelocity (pml.right, pml.groundTrace.plane.normal, pml.right, OVERCLIP );
ADDRGP4 pml+12
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRGP4 pml+12
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 828
;827:	//
;828:	VectorNormalize (pml.forward);
ADDRGP4 pml
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 829
;829:	VectorNormalize (pml.right);
ADDRGP4 pml+12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 831
;830:
;831:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $348
line 832
;832:		wishvel[i] = pml.forward[i]*fmove + pml.right[i]*smove;
ADDRLP4 88
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 88
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 88
INDIRI4
ADDRGP4 pml
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 88
INDIRI4
ADDRGP4 pml+12
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
line 833
;833:	}
LABELV $349
line 831
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $348
line 837
;834:	// when going up or down slopes the wish velocity should Not be zero
;835://	wishvel[2] = 0;
;836:
;837:	VectorCopy (wishvel, wishdir);
ADDRLP4 32
ADDRLP4 4
INDIRB
ASGNB 12
line 838
;838:	wishspeed = VectorNormalize(wishdir);
ADDRLP4 32
ARGP4
ADDRLP4 88
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 88
INDIRF4
ASGNF4
line 839
;839:	wishspeed *= scale;
ADDRLP4 24
ADDRLP4 24
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ASGNF4
line 842
;840:
;841:	// clamp the speed lower if ducking
;842:	if ( pm->ps->pm_flags & PMF_DUCKED ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $353
line 843
;843:		if ( wishspeed > pm->ps->speed * pm_duckScale ) {
ADDRLP4 24
INDIRF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pm_duckScale
INDIRF4
MULF4
LEF4 $355
line 844
;844:			wishspeed = pm->ps->speed * pm_duckScale;
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pm_duckScale
INDIRF4
MULF4
ASGNF4
line 845
;845:		}
LABELV $355
line 846
;846:	}
LABELV $353
line 849
;847:
;848:	// clamp the speed lower if wading or walking on the bottom
;849:	if ( pm->waterlevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 0
EQI4 $357
line 852
;850:		float	waterScale;
;851:
;852:		waterScale = pm->waterlevel / 3.0;
ADDRLP4 92
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1077936128
DIVF4
ASGNF4
line 853
;853:		waterScale = 1.0 - ( 1.0 - pm_swimScale ) * waterScale;
ADDRLP4 96
CNSTF4 1065353216
ASGNF4
ADDRLP4 92
ADDRLP4 96
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 pm_swimScale
INDIRF4
SUBF4
ADDRLP4 92
INDIRF4
MULF4
SUBF4
ASGNF4
line 854
;854:		if ( wishspeed > pm->ps->speed * waterScale ) {
ADDRLP4 24
INDIRF4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 92
INDIRF4
MULF4
LEF4 $359
line 855
;855:			wishspeed = pm->ps->speed * waterScale;
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 92
INDIRF4
MULF4
ASGNF4
line 856
;856:		}
LABELV $359
line 857
;857:	}
LABELV $357
line 861
;858:
;859:	// when a player gets hit, they temporarily lose
;860:	// full control, which allows them to be moved a bit
;861:	if ( ( pml.groundTrace.surfaceFlags & SURF_SLICK ) || pm->ps->pm_flags & PMF_TIME_KNOCKBACK ) {
ADDRLP4 92
CNSTI4 0
ASGNI4
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 2
BANDI4
ADDRLP4 92
INDIRI4
NEI4 $365
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 64
BANDI4
ADDRLP4 92
INDIRI4
EQI4 $361
LABELV $365
line 862
;862:		accelerate = pm_airaccelerate;
ADDRLP4 72
ADDRGP4 pm_airaccelerate
INDIRF4
ASGNF4
line 863
;863:	} else {
ADDRGP4 $362
JUMPV
LABELV $361
line 864
;864:		accelerate = pm_accelerate;
ADDRLP4 72
ADDRGP4 pm_accelerate
INDIRF4
ASGNF4
line 865
;865:	}
LABELV $362
line 867
;866:
;867:	PM_Accelerate (wishdir, wishspeed, accelerate);
ADDRLP4 32
ARGP4
ADDRLP4 24
INDIRF4
ARGF4
ADDRLP4 72
INDIRF4
ARGF4
ADDRGP4 PM_Accelerate
CALLV
pop
line 869
;868:
;869:	if ( ( pml.groundTrace.surfaceFlags & SURF_SLICK ) || pm->ps->pm_flags & PMF_TIME_KNOCKBACK ) {
ADDRLP4 96
CNSTI4 0
ASGNI4
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 2
BANDI4
ADDRLP4 96
INDIRI4
NEI4 $370
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 64
BANDI4
ADDRLP4 96
INDIRI4
EQI4 $366
LABELV $370
line 870
;870:		pm->ps->velocity[2] -= pm->ps->gravity * pml.frametime;
ADDRLP4 100
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 104
ADDRLP4 100
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 104
INDIRP4
ADDRLP4 104
INDIRP4
INDIRF4
ADDRLP4 100
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CVIF4 4
ADDRGP4 pml+36
INDIRF4
MULF4
SUBF4
ASGNF4
line 871
;871:	} else {
LABELV $366
line 874
;872:		// don't reset the z velocity for slopes
;873://		pm->ps->velocity[2] = 0;
;874:	}
LABELV $367
line 876
;875:
;876:	vel = VectorLength(pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRLP4 100
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 28
ADDRLP4 100
INDIRF4
ASGNF4
line 879
;877:
;878:	// slide along the ground plane
;879:	PM_ClipVelocity (pm->ps->velocity, pml.groundTrace.plane.normal, 
ADDRLP4 104
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 104
INDIRP4
ARGP4
ADDRGP4 pml+52+24
ARGP4
ADDRLP4 104
INDIRP4
ARGP4
CNSTF4 1065361605
ARGF4
ADDRGP4 PM_ClipVelocity
CALLV
pop
line 883
;880:		pm->ps->velocity, OVERCLIP );
;881:
;882:	// don't decrease velocity when going up or down a slope
;883:	VectorNormalize(pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 884
;884:	VectorScale(pm->ps->velocity, vel, pm->ps->velocity);
ADDRLP4 108
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 108
INDIRP4
ADDRLP4 108
INDIRP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 112
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 112
INDIRP4
ADDRLP4 112
INDIRP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 116
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 116
INDIRP4
ADDRLP4 116
INDIRP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 887
;885:
;886:	// don't do anything if standing still
;887:	if (!pm->ps->velocity[0] && !pm->ps->velocity[1]) {
ADDRLP4 120
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 124
CNSTF4 0
ASGNF4
ADDRLP4 120
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 124
INDIRF4
NEF4 $374
ADDRLP4 120
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 124
INDIRF4
NEF4 $374
line 888
;888:		return;
ADDRGP4 $321
JUMPV
LABELV $374
line 891
;889:	}
;890:
;891:	PM_StepSlideMove( qfalse );
CNSTI4 0
ARGI4
ADDRGP4 PM_StepSlideMove
CALLV
pop
line 895
;892:	
;893:	//Com_Printf("velocity2 = %1.1f\n", VectorLength(pm->ps->velocity));
;894:
;895:}
LABELV $321
endproc PM_WalkMove 128 16
proc PM_DeadMove 20 4
line 902
;896:
;897:/*
;898:==============
;899:PM_DeadMove
;900:==============
;901:*/
;902:static void PM_DeadMove( void ) {
line 905
;903:	float	forward;
;904:
;905:	if ( !pml.walking ) {
ADDRGP4 pml+44
INDIRI4
CNSTI4 0
NEI4 $377
line 906
;906:		return;
ADDRGP4 $376
JUMPV
LABELV $377
line 911
;907:	}
;908:
;909:	// extra friction
;910:
;911:	forward = VectorLength (pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRLP4 4
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 4
INDIRF4
ASGNF4
line 912
;912:	forward -= 20;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1101004800
SUBF4
ASGNF4
line 913
;913:	if ( forward <= 0 ) {
ADDRLP4 0
INDIRF4
CNSTF4 0
GTF4 $380
line 914
;914:		VectorClear (pm->ps->velocity);
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 32
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 915
;915:	} else {
ADDRGP4 $381
JUMPV
LABELV $380
line 916
;916:		VectorNormalize (pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 917
;917:		VectorScale (pm->ps->velocity, forward, pm->ps->velocity);
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
ADDRLP4 12
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
ADDRLP4 16
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
line 918
;918:	}
LABELV $381
line 919
;919:}
LABELV $376
endproc PM_DeadMove 20 4
proc PM_NoclipMove 104 12
line 927
;920:
;921:
;922:/*
;923:===============
;924:PM_NoclipMove
;925:===============
;926:*/
;927:static void PM_NoclipMove( void ) {
line 936
;928:	float	speed, drop, friction, control, newspeed;
;929:	int			i;
;930:	vec3_t		wishvel;
;931:	float		fmove, smove;
;932:	vec3_t		wishdir;
;933:	float		wishspeed;
;934:	float		scale;
;935:
;936:	pm->ps->viewheight = DEFAULT_VIEWHEIGHT;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 26
ASGNI4
line 940
;937:
;938:	// friction
;939:
;940:	speed = VectorLength (pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRLP4 64
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 64
INDIRF4
ASGNF4
line 941
;941:	if (speed < 1)
ADDRLP4 24
INDIRF4
CNSTF4 1065353216
GEF4 $383
line 942
;942:	{
line 943
;943:		VectorCopy (vec3_origin, pm->ps->velocity);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ADDRGP4 vec3_origin
INDIRB
ASGNB 12
line 944
;944:	}
ADDRGP4 $384
JUMPV
LABELV $383
line 946
;945:	else
;946:	{
line 947
;947:		drop = 0;
ADDRLP4 52
CNSTF4 0
ASGNF4
line 949
;948:
;949:		friction = pm_friction*1.5;	// extra friction
ADDRLP4 56
CNSTF4 1069547520
ADDRGP4 pm_friction
INDIRF4
MULF4
ASGNF4
line 950
;950:		control = speed < pm_stopspeed ? pm_stopspeed : speed;
ADDRLP4 24
INDIRF4
ADDRGP4 pm_stopspeed
INDIRF4
GEF4 $386
ADDRLP4 68
ADDRGP4 pm_stopspeed
INDIRF4
ASGNF4
ADDRGP4 $387
JUMPV
LABELV $386
ADDRLP4 68
ADDRLP4 24
INDIRF4
ASGNF4
LABELV $387
ADDRLP4 60
ADDRLP4 68
INDIRF4
ASGNF4
line 951
;951:		drop += control*friction*pml.frametime;
ADDRLP4 52
ADDRLP4 52
INDIRF4
ADDRLP4 60
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
line 954
;952:
;953:		// scale the velocity
;954:		newspeed = speed - drop;
ADDRLP4 28
ADDRLP4 24
INDIRF4
ADDRLP4 52
INDIRF4
SUBF4
ASGNF4
line 955
;955:		if (newspeed < 0)
ADDRLP4 28
INDIRF4
CNSTF4 0
GEF4 $389
line 956
;956:			newspeed = 0;
ADDRLP4 28
CNSTF4 0
ASGNF4
LABELV $389
line 957
;957:		newspeed /= speed;
ADDRLP4 28
ADDRLP4 28
INDIRF4
ADDRLP4 24
INDIRF4
DIVF4
ASGNF4
line 959
;958:
;959:		VectorScale (pm->ps->velocity, newspeed, pm->ps->velocity);
ADDRLP4 72
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 76
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 80
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 960
;960:	}
LABELV $384
line 963
;961:
;962:	// accelerate
;963:	scale = PM_CmdScale( &pm->cmd );
ADDRGP4 pm
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRLP4 68
ADDRGP4 PM_CmdScale
CALLF4
ASGNF4
ADDRLP4 48
ADDRLP4 68
INDIRF4
ASGNF4
line 965
;964:
;965:	fmove = pm->cmd.forwardmove;
ADDRLP4 16
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 966
;966:	smove = pm->cmd.rightmove;
ADDRLP4 20
ADDRGP4 pm
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ASGNF4
line 968
;967:	
;968:	for (i=0 ; i<3 ; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $391
line 969
;969:		wishvel[i] = pml.forward[i]*fmove + pml.right[i]*smove;
ADDRLP4 72
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 72
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 72
INDIRI4
ADDRGP4 pml
ADDP4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 72
INDIRI4
ADDRGP4 pml+12
ADDP4
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
LABELV $392
line 968
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $391
line 970
;970:	wishvel[2] += pm->cmd.upmove;
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CVIF4 4
ADDF4
ASGNF4
line 972
;971:
;972:	VectorCopy (wishvel, wishdir);
ADDRLP4 32
ADDRLP4 4
INDIRB
ASGNB 12
line 973
;973:	wishspeed = VectorNormalize(wishdir);
ADDRLP4 32
ARGP4
ADDRLP4 76
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 44
ADDRLP4 76
INDIRF4
ASGNF4
line 974
;974:	wishspeed *= scale;
ADDRLP4 44
ADDRLP4 44
INDIRF4
ADDRLP4 48
INDIRF4
MULF4
ASGNF4
line 976
;975:
;976:	PM_Accelerate( wishdir, wishspeed, pm_accelerate );
ADDRLP4 32
ARGP4
ADDRLP4 44
INDIRF4
ARGF4
ADDRGP4 pm_accelerate
INDIRF4
ARGF4
ADDRGP4 PM_Accelerate
CALLV
pop
line 979
;977:
;978:	// move
;979:	VectorMA (pm->ps->origin, pml.frametime, pm->ps->velocity, pm->ps->origin);
ADDRLP4 80
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 84
ADDRLP4 80
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 88
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 92
ADDRLP4 88
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRF4
ADDRLP4 88
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 100
ADDRLP4 96
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRF4
ADDRLP4 96
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 pml+36
INDIRF4
MULF4
ADDF4
ASGNF4
line 980
;980:}
LABELV $382
endproc PM_NoclipMove 104 12
proc PM_FootstepForSurface 0 0
line 991
;981:
;982://============================================================================
;983:
;984:/*
;985:================
;986:PM_FootstepForSurface
;987:
;988:Returns an event number apropriate for the groundsurface
;989:================
;990:*/
;991:static int PM_FootstepForSurface( void ) {
line 992
;992:	if ( pml.groundTrace.surfaceFlags & SURF_NOSTEPS ) {
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 8192
BANDI4
CNSTI4 0
EQI4 $401
line 993
;993:		return 0;
CNSTI4 0
RETI4
ADDRGP4 $400
JUMPV
LABELV $401
line 995
;994:	}
;995:	if ( pml.groundTrace.surfaceFlags & SURF_METALSTEPS ) {
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $405
line 996
;996:		return EV_FOOTSTEP_METAL;
CNSTI4 2
RETI4
ADDRGP4 $400
JUMPV
LABELV $405
line 998
;997:	}
;998:	return EV_FOOTSTEP;
CNSTI4 1
RETI4
LABELV $400
endproc PM_FootstepForSurface 0 0
proc PM_CrashLand 64 4
line 1009
;999:}
;1000:
;1001:
;1002:/*
;1003:=================
;1004:PM_CrashLand
;1005:
;1006:Check for hard landings that generate sound events
;1007:=================
;1008:*/
;1009:static void PM_CrashLand( void ) {
line 1017
;1010:	float		delta;
;1011:	float		dist;
;1012:	float		vel, acc;
;1013:	float		t;
;1014:	float		a, b, c, den;
;1015:	float		mass;
;1016:	// decide which landing animation to use
;1017:	if ( pm->ps->pm_flags & PMF_BACKWARDS_JUMP ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $410
line 1018
;1018:		PM_ForceLegsAnim( LEGS_LANDB );
CNSTI4 21
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 1019
;1019:	} else {
ADDRGP4 $411
JUMPV
LABELV $410
line 1020
;1020:		PM_ForceLegsAnim( LEGS_LAND );
CNSTI4 19
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 1021
;1021:	}
LABELV $411
line 1023
;1022:
;1023:	pm->ps->legsTimer = TIMER_LAND;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
CNSTI4 130
ASGNI4
line 1026
;1024:
;1025:	// calculate the exact velocity on landing
;1026:	dist = pm->ps->origin[2] - pml.previous_origin[2];
ADDRLP4 28
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRGP4 pml+112+8
INDIRF4
SUBF4
ASGNF4
line 1027
;1027:	vel = pml.previous_velocity[2];
ADDRLP4 8
ADDRGP4 pml+124+8
INDIRF4
ASGNF4
line 1028
;1028:	acc = -pm->ps->gravity;
ADDRLP4 12
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
NEGI4
CVIF4 4
ASGNF4
line 1030
;1029:
;1030:	a = acc / 2;
ADDRLP4 16
ADDRLP4 12
INDIRF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 1031
;1031:	b = vel;
ADDRLP4 4
ADDRLP4 8
INDIRF4
ASGNF4
line 1032
;1032:	c = -dist;
ADDRLP4 36
ADDRLP4 28
INDIRF4
NEGF4
ASGNF4
line 1034
;1033:
;1034:	den =  b * b - 4 * a * c;
ADDRLP4 20
ADDRLP4 4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
CNSTF4 1082130432
ADDRLP4 16
INDIRF4
MULF4
ADDRLP4 36
INDIRF4
MULF4
SUBF4
ASGNF4
line 1035
;1035:	if ( den < 0 ) {
ADDRLP4 20
INDIRF4
CNSTF4 0
GEF4 $416
line 1036
;1036:		return;
ADDRGP4 $409
JUMPV
LABELV $416
line 1038
;1037:	}
;1038:	t = (-b - sqrt( den ) ) / ( 2 * a );
ADDRLP4 20
INDIRF4
ARGF4
ADDRLP4 44
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 4
INDIRF4
NEGF4
ADDRLP4 44
INDIRF4
SUBF4
CNSTF4 1073741824
ADDRLP4 16
INDIRF4
MULF4
DIVF4
ASGNF4
line 1040
;1039:
;1040:	delta = vel + t * acc;
ADDRLP4 0
ADDRLP4 8
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1041
;1041:	delta = delta*delta * 0.0001;
ADDRLP4 0
CNSTF4 953267991
ADDRLP4 0
INDIRF4
ADDRLP4 0
INDIRF4
MULF4
MULF4
ASGNF4
line 1044
;1042:
;1043:	// ducking while falling doubles damage
;1044:	if ( pm->ps->pm_flags & PMF_DUCKED ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $418
line 1045
;1045:		delta *= 2;
ADDRLP4 0
CNSTF4 1073741824
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
line 1046
;1046:	}
LABELV $418
line 1049
;1047:
;1048:	// never take falling damage if completely underwater
;1049:	if ( pm->waterlevel == 3 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 3
NEI4 $420
line 1050
;1050:		return;
ADDRGP4 $409
JUMPV
LABELV $420
line 1054
;1051:	}
;1052:
;1053:	// reduce falling damage if there is standing water
;1054:	if ( pm->waterlevel == 2 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 2
NEI4 $422
line 1055
;1055:		delta *= 0.25;
ADDRLP4 0
CNSTF4 1048576000
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
line 1056
;1056:	}
LABELV $422
line 1057
;1057:	if ( pm->waterlevel == 1 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
NEI4 $424
line 1058
;1058:		delta *= 0.5;
ADDRLP4 0
CNSTF4 1056964608
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
line 1059
;1059:	}
LABELV $424
line 1061
;1060:
;1061:	if ( delta < 1 ) {
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
GEF4 $426
line 1062
;1062:		return;
ADDRGP4 $409
JUMPV
LABELV $426
line 1069
;1063:	}
;1064:
;1065:	// create a local entity event to play the sound
;1066:
;1067:	// SURF_NODAMAGE is used for bounce pads where you don't ever
;1068:	// want to take damage or play a crunch sound
;1069:	if(pm->ps->stats[STAT_MASS])
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
EQI4 $428
line 1070
;1070:	{
line 1071
;1071:		mass = pm->ps->stats[STAT_MASS];
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 1072
;1072:	}
ADDRGP4 $429
JUMPV
LABELV $428
line 1074
;1073:	else
;1074:		mass = 200;
ADDRLP4 24
CNSTF4 1128792064
ASGNF4
LABELV $429
line 1075
;1075:	mass += BG_FindItemForWeapon(pm->ps->weapon)->mass;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ARGI4
ADDRLP4 52
ADDRGP4 BG_FindItemForWeapon
CALLP4
ASGNP4
ADDRLP4 24
ADDRLP4 24
INDIRF4
ADDRLP4 52
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 1078
;1076:	//if(pm->ps->stats[STAT_HOLDABLE_ITEM])
;1077:	//	mass += BG_FindItemForHoldable(pm->ps->stats[STAT_HOLDABLE_ITEM])->mass;
;1078:	delta *= sqrt(mass) / 14.0;
ADDRLP4 24
INDIRF4
ARGF4
ADDRLP4 56
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 56
INDIRF4
CNSTF4 1096810496
DIVF4
MULF4
ASGNF4
line 1079
;1079:	if ( !(pml.groundTrace.surfaceFlags & SURF_NODAMAGE) )  {
ADDRGP4 pml+52+44
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $430
line 1080
;1080:		if ( delta > 60 ) {
ADDRLP4 0
INDIRF4
CNSTF4 1114636288
LEF4 $434
line 1081
;1081:			PM_AddEvent( EV_FALL_FAR );
CNSTI4 12
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1082
;1082:		} else if ( delta > 40 ) {
ADDRGP4 $435
JUMPV
LABELV $434
ADDRLP4 0
INDIRF4
CNSTF4 1109393408
LEF4 $436
line 1084
;1083:			// this is a pain grunt, so don't play it if dead
;1084:			if ( pm->ps->stats[STAT_HEALTH] > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
LEI4 $437
line 1085
;1085:				PM_AddEvent( EV_FALL_MEDIUM );
CNSTI4 11
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1086
;1086:			}
line 1087
;1087:		} else if ( delta > 7 ) {
ADDRGP4 $437
JUMPV
LABELV $436
ADDRLP4 0
INDIRF4
CNSTF4 1088421888
LEF4 $440
line 1088
;1088:			PM_AddEvent( EV_FALL_SHORT );
CNSTI4 10
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1089
;1089:		} else {
ADDRGP4 $441
JUMPV
LABELV $440
line 1090
;1090:			PM_AddEvent( PM_FootstepForSurface() );
ADDRLP4 60
ADDRGP4 PM_FootstepForSurface
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1091
;1091:		}
LABELV $441
LABELV $437
LABELV $435
line 1092
;1092:	}
LABELV $430
line 1095
;1093:
;1094:	// start footstep cycle over
;1095:	pm->ps->bobCycle = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 0
ASGNI4
line 1096
;1096:}
LABELV $409
endproc PM_CrashLand 64 4
proc PM_CorrectAllSolid 0 8
line 1105
;1097:
;1098:
;1099:
;1100:/*
;1101:=============
;1102:PM_CorrectAllSolid
;1103:=============
;1104:*/
;1105:static void PM_CorrectAllSolid( void ) {
line 1106
;1106:	if ( pm->debugLevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 0
EQI4 $443
line 1107
;1107:		Com_Printf("%i:allsolid\n", c_pmove);
ADDRGP4 $445
ARGP4
ADDRGP4 c_pmove
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 1108
;1108:	}
LABELV $443
line 1112
;1109:
;1110:	// FIXME: jitter around
;1111:
;1112:	pm->ps->groundEntityNum = ENTITYNUM_NONE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
CNSTI4 1023
ASGNI4
line 1113
;1113:	pml.groundPlane = qfalse;
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 1114
;1114:	pml.walking = qfalse;
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 1115
;1115:}
LABELV $442
endproc PM_CorrectAllSolid 0 8
proc PM_GroundTraceMissed 80 28
line 1125
;1116:
;1117:
;1118:/*
;1119:=============
;1120:PM_GroundTraceMissed
;1121:
;1122:The ground trace didn't hit a surface, so we are in freefall
;1123:=============
;1124:*/
;1125:static void PM_GroundTraceMissed( void ) {
line 1129
;1126:	trace_t		trace;
;1127:	vec3_t		point;
;1128:
;1129:	if ( pm->ps->groundEntityNum != ENTITYNUM_NONE ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 1023
EQI4 $449
line 1131
;1130:		// we just transitioned into freefall
;1131:		if ( pm->debugLevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 0
EQI4 $451
line 1132
;1132:			Com_Printf("%i:lift\n", c_pmove);
ADDRGP4 $453
ARGP4
ADDRGP4 c_pmove
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 1133
;1133:		}
LABELV $451
line 1137
;1134:
;1135:		// if they aren't in a jumping animation and the ground is a ways away, force into it
;1136:		// if we didn't do the trace, the player would be backflipping down staircases
;1137:		VectorCopy( pm->ps->origin, point );
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1138
;1138:		point[2] -= 64;
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1115684864
SUBF4
ASGNF4
line 1140
;1139:
;1140:		pm->trace (&trace, pm->ps->origin, pm->mins, pm->maxs, point, pm->ps->clientNum, pm->tracemask);
ADDRLP4 12
ARGP4
ADDRLP4 68
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 72
ADDRLP4 68
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 68
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRLP4 68
INDIRP4
CNSTI4 188
ADDP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 72
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 68
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
ARGI4
ADDRLP4 68
INDIRP4
CNSTI4 212
ADDP4
INDIRP4
CALLV
pop
line 1141
;1141:		if ( trace.fraction == 1.0 ) {
ADDRLP4 12+8
INDIRF4
CNSTF4 1065353216
NEF4 $455
line 1142
;1142:			if ( pm->cmd.forwardmove >= 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
LTI4 $458
line 1143
;1143:				PM_ForceLegsAnim( LEGS_JUMP );
CNSTI4 18
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 1144
;1144:				pm->ps->pm_flags &= ~PMF_BACKWARDS_JUMP;
ADDRLP4 76
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
line 1145
;1145:			} else {
ADDRGP4 $459
JUMPV
LABELV $458
line 1146
;1146:				PM_ForceLegsAnim( LEGS_JUMPB );
CNSTI4 20
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 1147
;1147:				pm->ps->pm_flags |= PMF_BACKWARDS_JUMP;
ADDRLP4 76
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1148
;1148:			}
LABELV $459
line 1149
;1149:		}
LABELV $455
line 1150
;1150:	}
LABELV $449
line 1152
;1151:
;1152:	pm->ps->groundEntityNum = ENTITYNUM_NONE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
CNSTI4 1023
ASGNI4
line 1153
;1153:	pml.groundPlane = qfalse;
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 1154
;1154:	pml.walking = qfalse;
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 1155
;1155:}
LABELV $448
endproc PM_GroundTraceMissed 80 28
proc PM_GroundWallTrace 144 28
line 1163
;1156:
;1157:extern vec3_t	bytedirs[NUMVERTEXNORMALS];
;1158:/*
;1159:=============
;1160:PM_GroundWallTrace
;1161:=============
;1162:*/
;1163:static void PM_GroundWallTrace( void ) {
line 1170
;1164:	vec3_t		point, forward, right, up;
;1165:	vec3_t mins, maxs;
;1166:	trace_t		trace;
;1167:	int i;
;1168:
;1169:	
;1170:	AngleVectors(pm->ps->viewangles, forward, right, up);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 152
ADDP4
ARGP4
ADDRLP4 96
ARGP4
ADDRLP4 108
ARGP4
ADDRLP4 120
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 1171
;1171:	mins[0] = -15;
ADDRLP4 72
CNSTF4 3245342720
ASGNF4
line 1172
;1172:	mins[1] = -15;
ADDRLP4 72+4
CNSTF4 3245342720
ASGNF4
line 1173
;1173:	mins[2] = -15;
ADDRLP4 72+8
CNSTF4 3245342720
ASGNF4
line 1174
;1174:	maxs[0] = 15;
ADDRLP4 84
CNSTF4 1097859072
ASGNF4
line 1175
;1175:	maxs[1] = 15;
ADDRLP4 84+4
CNSTF4 1097859072
ASGNF4
line 1176
;1176:	maxs[2] = 15;
ADDRLP4 84+8
CNSTF4 1097859072
ASGNF4
line 1177
;1177:	pml.groundTrace.fraction = 1.1;
ADDRGP4 pml+52+8
CNSTF4 1066192077
ASGNF4
line 1187
;1178:	/*VectorMA(pm->ps->origin, 128, forward, point);
;1179:	pm->trace (&trace, pm->ps->origin, vec3_origin, vec3_origin, point, pm->ps->clientNum, pm->tracemask);
;1180:	if((128 * trace.fraction * DotProduct(forward, trace.plane.normal) < 32) && !(trace.surfaceFlags & (SURF_SKY | SURF_NOIMPACT)))
;1181:	{
;1182:		
;1183:		VectorMA(pm->ps->origin, DotProduct(forward, trace.plane.normal), trace.plane.normal, point);
;1184:		pm->trace (&trace, pm->ps->origin, vec3_origin, vec3_origin, point, pm->ps->clientNum, pm->tracemask);
;1185:	}*/
;1186:	//if(trace.fraction == 1.0 || (trace.surfaceFlags & (SURF_SKY | SURF_NOIMPACT)))
;1187:	{
line 1189
;1188:	
;1189:		for(i = 0; i < 5; i++)//i < NUMVERTEXNORMALS; i++)
ADDRLP4 56
CNSTI4 0
ASGNI4
LABELV $469
line 1190
;1190:		{
line 1191
;1191:			VectorCopy(pm->ps->origin, point);
ADDRLP4 60
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1194
;1192:
;1193:			
;1194:			switch (i)
ADDRLP4 56
INDIRI4
CNSTI4 0
LTI4 $473
ADDRLP4 56
INDIRI4
CNSTI4 5
GTI4 $473
ADDRLP4 56
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $485
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $485
address $475
address $477
address $479
address $481
address $482
address $483
code
line 1195
;1195:			{
LABELV $475
line 1197
;1196:			case 0:
;1197:				point[2] += 0.25;
ADDRLP4 60+8
ADDRLP4 60+8
INDIRF4
CNSTF4 1048576000
ADDF4
ASGNF4
line 1198
;1198:				break;
ADDRGP4 $474
JUMPV
LABELV $477
line 1200
;1199:			case 1:
;1200:				point[1] += 0.25;
ADDRLP4 60+4
ADDRLP4 60+4
INDIRF4
CNSTF4 1048576000
ADDF4
ASGNF4
line 1201
;1201:				break;
ADDRGP4 $474
JUMPV
LABELV $479
line 1203
;1202:			case 2:
;1203:				point[1] -= 0.25;
ADDRLP4 60+4
ADDRLP4 60+4
INDIRF4
CNSTF4 1048576000
SUBF4
ASGNF4
line 1204
;1204:				break;
ADDRGP4 $474
JUMPV
LABELV $481
line 1206
;1205:			case 3:
;1206:				point[0] += 0.25;
ADDRLP4 60
ADDRLP4 60
INDIRF4
CNSTF4 1048576000
ADDF4
ASGNF4
line 1207
;1207:				break;
ADDRGP4 $474
JUMPV
LABELV $482
line 1209
;1208:			case 4:
;1209:				point[0] -= 0.25;
ADDRLP4 60
ADDRLP4 60
INDIRF4
CNSTF4 1048576000
SUBF4
ASGNF4
line 1210
;1210:				break;
ADDRGP4 $474
JUMPV
LABELV $483
line 1212
;1211:			case 5:
;1212:				point[2] -= 0.25;
ADDRLP4 60+8
ADDRLP4 60+8
INDIRF4
CNSTF4 1048576000
SUBF4
ASGNF4
line 1213
;1213:				break;
LABELV $473
LABELV $474
line 1221
;1214:			}
;1215:
;1216:			/*
;1217:			if(i < 3)
;1218:				point[i] -= 0.25;
;1219:			else
;1220:				point[i - 3] += 0.25;*/
;1221:			pm->trace (&trace, pm->ps->origin, pm->mins, pm->maxs, point, pm->ps->clientNum, pm->tracemask);
ADDRLP4 0
ARGP4
ADDRLP4 136
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 140
ADDRLP4 136
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 140
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 136
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRLP4 136
INDIRP4
CNSTI4 188
ADDP4
ARGP4
ADDRLP4 60
ARGP4
ADDRLP4 140
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 136
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
ARGI4
ADDRLP4 136
INDIRP4
CNSTI4 212
ADDP4
INDIRP4
CALLV
pop
line 1229
;1222:			
;1223:			//if(bytedirs[i][2] < MIN_WALK_NORMAL)
;1224:			//{
;1225:			//	VectorMA(pm->ps->origin, 25, bytedirs[i], point);
;1226:			//	pm->trace (&trace, pm->ps->origin, vec3_origin, vec3_origin, point, pm->ps->clientNum, pm->tracemask);
;1227:			//
;1228:				
;1229:				if(trace.fraction < 1.0 && !(trace.surfaceFlags & (SURF_SKY | SURF_NOIMPACT)))
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
GEF4 $486
ADDRLP4 0+44
INDIRI4
CNSTI4 20
BANDI4
CNSTI4 0
NEI4 $486
line 1230
;1230:				{
line 1231
;1231:					pml.groundTrace = trace;
ADDRGP4 pml+52
ADDRLP4 0
INDIRB
ASGNB 56
line 1232
;1232:					break;
ADDRGP4 $471
JUMPV
LABELV $486
line 1234
;1233:				}
;1234:				else if ( trace.allsolid ) 
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $491
line 1235
;1235:				{// do something corrective if the trace starts in a solid...
line 1236
;1236:					PM_CorrectAllSolid();
ADDRGP4 PM_CorrectAllSolid
CALLV
pop
line 1237
;1237:					return;
ADDRGP4 $462
JUMPV
LABELV $491
line 1240
;1238:				}
;1239:			//}
;1240:		}
LABELV $470
line 1189
ADDRLP4 56
ADDRLP4 56
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 5
LTI4 $469
LABELV $471
line 1241
;1241:	}
line 1245
;1242:	
;1243:
;1244:	// if the trace didn't hit anything, we are in free fall
;1245:	if(pml.groundTrace.fraction >= 1.0 || (trace.surfaceFlags & (SURF_SKY | SURF_NOIMPACT)))
ADDRGP4 pml+52+8
INDIRF4
CNSTF4 1065353216
GEF4 $498
ADDRLP4 0+44
INDIRI4
CNSTI4 20
BANDI4
CNSTI4 0
EQI4 $493
LABELV $498
line 1246
;1246:	{		
line 1247
;1247:		pml.groundPlane = qfalse;
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 1248
;1248:		pml.walking = qfalse;
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 1249
;1249:		return;
ADDRGP4 $462
JUMPV
line 1250
;1250:		PM_GroundTraceMissed();
ADDRGP4 PM_GroundTraceMissed
CALLV
pop
line 1251
;1251:	}
LABELV $493
line 1254
;1252:	
;1253:	
;1254:	pml.groundPlane = qtrue;
ADDRGP4 pml+48
CNSTI4 1
ASGNI4
line 1255
;1255:	pml.walking = qtrue;
ADDRGP4 pml+44
CNSTI4 1
ASGNI4
line 1256
;1256:	if(!(pm->ps->legsAnim & ANIM_CLIMBWALLS))
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $503
line 1257
;1257:		pm->ps->legsAnim |= ANIM_CLIMBWALLS;
ADDRLP4 132
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 132
INDIRP4
ADDRLP4 132
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
LABELV $503
line 1260
;1258:
;1259:	// hitting solid ground will end a waterjump
;1260:	if (pm->ps->pm_flags & PMF_TIME_WATERJUMP)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $505
line 1261
;1261:	{
line 1262
;1262:		pm->ps->pm_flags &= ~(PMF_TIME_WATERJUMP | PMF_TIME_LAND);
ADDRLP4 136
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 136
INDIRP4
INDIRI4
CNSTI4 -289
BANDI4
ASGNI4
line 1263
;1263:		pm->ps->pm_time = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 0
ASGNI4
line 1264
;1264:	}
LABELV $505
line 1266
;1265:
;1266:	pm->ps->groundEntityNum = trace.entityNum;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
ADDRLP4 0+52
INDIRI4
ASGNI4
line 1267
;1267:	pml.groundTrace = trace;
ADDRGP4 pml+52
ADDRLP4 0
INDIRB
ASGNB 56
line 1268
;1268:	PM_AddTouchEnt( trace.entityNum );
ADDRLP4 0+52
INDIRI4
ARGI4
ADDRGP4 PM_AddTouchEnt
CALLV
pop
line 1269
;1269:}
LABELV $462
endproc PM_GroundWallTrace 144 28
proc PM_GroundTrace 100 28
line 1277
;1270:
;1271:
;1272:/*
;1273:=============
;1274:PM_GroundTrace
;1275:=============
;1276:*/
;1277:static void PM_GroundTrace( void ) {
line 1281
;1278:	vec3_t		point;
;1279:	trace_t		trace;
;1280:	
;1281:	if((pm->ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER) && (pm->cmd.upmove < 0))
ADDRLP4 68
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 72
CNSTI4 0
ASGNI4
ADDRLP4 68
INDIRP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
ADDRLP4 72
INDIRI4
EQI4 $511
ADDRLP4 68
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
ADDRLP4 72
INDIRI4
GEI4 $511
line 1282
;1282:	{		
line 1283
;1283:		if(!(pm->ps->legsAnim & ANIM_CLIMBWALLS))
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $513
line 1284
;1284:			pm->ps->legsAnim |= ANIM_CLIMBWALLS;
ADDRLP4 76
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
LABELV $513
line 1285
;1285:		PM_GroundWallTrace();			
ADDRGP4 PM_GroundWallTrace
CALLV
pop
line 1286
;1286:		if(pml.groundPlane)
ADDRGP4 pml+48
INDIRI4
CNSTI4 0
EQI4 $515
line 1287
;1287:			return;
ADDRGP4 $510
JUMPV
LABELV $515
line 1288
;1288:	}
LABELV $511
line 1290
;1289:		
;1290:	point[0] = pm->ps->origin[0];
ADDRLP4 56
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ASGNF4
line 1291
;1291:	point[1] = pm->ps->origin[1];
ADDRLP4 56+4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ASGNF4
line 1292
;1292:	point[2] = pm->ps->origin[2] - 0.25;
ADDRLP4 56+8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 1048576000
SUBF4
ASGNF4
line 1294
;1293:
;1294:	pm->trace (&trace, pm->ps->origin, pm->mins, pm->maxs, point, pm->ps->clientNum, pm->tracemask);
ADDRLP4 0
ARGP4
ADDRLP4 76
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 80
ADDRLP4 76
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRLP4 76
INDIRP4
CNSTI4 188
ADDP4
ARGP4
ADDRLP4 56
ARGP4
ADDRLP4 80
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
INDIRP4
CNSTI4 212
ADDP4
INDIRP4
CALLV
pop
line 1295
;1295:	pml.groundTrace = trace;
ADDRGP4 pml+52
ADDRLP4 0
INDIRB
ASGNB 56
line 1298
;1296:
;1297:	// do something corrective if the trace starts in a solid...
;1298:	if ( trace.allsolid ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $521
line 1299
;1299:		PM_CorrectAllSolid();
ADDRGP4 PM_CorrectAllSolid
CALLV
pop
line 1300
;1300:		return;
ADDRGP4 $510
JUMPV
LABELV $521
line 1304
;1301:	}
;1302:
;1303:	// if the trace didn't hit anything, we are in free fall
;1304:	if ( trace.fraction == 1.0 ) {
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
NEF4 $523
line 1305
;1305:		PM_GroundTraceMissed();
ADDRGP4 PM_GroundTraceMissed
CALLV
pop
line 1306
;1306:		pml.groundPlane = qfalse;
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 1307
;1307:		pml.walking = qfalse;		
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 1308
;1308:		return;
ADDRGP4 $510
JUMPV
LABELV $523
line 1312
;1309:	}
;1310:
;1311:	// check if getting thrown off the ground
;1312:	if ( pm->ps->velocity[2] > 0 && DotProduct( pm->ps->velocity, trace.plane.normal ) > 10 ) {
ADDRLP4 84
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 88
ADDRLP4 84
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ASGNF4
ADDRLP4 88
INDIRF4
CNSTF4 0
LEF4 $528
ADDRLP4 84
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 0+24
INDIRF4
MULF4
ADDRLP4 84
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 0+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 88
INDIRF4
ADDRLP4 0+24+8
INDIRF4
MULF4
ADDF4
CNSTF4 1092616192
LEF4 $528
line 1313
;1313:		if ( pm->debugLevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 0
EQI4 $535
line 1314
;1314:			Com_Printf("%i:kickoff\n", c_pmove);
ADDRGP4 $537
ARGP4
ADDRGP4 c_pmove
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 1315
;1315:		}
LABELV $535
line 1317
;1316:		// go into jump animation
;1317:		if ( pm->cmd.forwardmove >= 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
LTI4 $538
line 1318
;1318:			PM_ForceLegsAnim( LEGS_JUMP );
CNSTI4 18
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 1319
;1319:			pm->ps->pm_flags &= ~PMF_BACKWARDS_JUMP;
ADDRLP4 92
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
line 1320
;1320:		} else {
ADDRGP4 $539
JUMPV
LABELV $538
line 1321
;1321:			PM_ForceLegsAnim( LEGS_JUMPB );
CNSTI4 20
ARGI4
ADDRGP4 PM_ForceLegsAnim
CALLV
pop
line 1322
;1322:			pm->ps->pm_flags |= PMF_BACKWARDS_JUMP;
ADDRLP4 92
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1323
;1323:		}
LABELV $539
line 1325
;1324:
;1325:		pm->ps->groundEntityNum = ENTITYNUM_NONE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
CNSTI4 1023
ASGNI4
line 1326
;1326:		pml.groundPlane = qfalse;
ADDRGP4 pml+48
CNSTI4 0
ASGNI4
line 1327
;1327:		pml.walking = qfalse;
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 1328
;1328:		return;
ADDRGP4 $510
JUMPV
LABELV $528
line 1332
;1329:	}
;1330:	
;1331:	// slopes that are too steep will not be considered onground
;1332:	if ( trace.plane.normal[2] < MIN_WALK_NORMAL ) {
ADDRLP4 0+24+8
INDIRF4
CNSTF4 1060320051
GEF4 $542
line 1333
;1333:		if ( pm->debugLevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 0
EQI4 $546
line 1334
;1334:			Com_Printf("%i:steep\n", c_pmove);
ADDRGP4 $548
ARGP4
ADDRGP4 c_pmove
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 1335
;1335:		}
LABELV $546
line 1338
;1336:		// FIXME: if they can't slide down the slope, let them
;1337:		// walk (sharp crevices)
;1338:		pm->ps->groundEntityNum = ENTITYNUM_NONE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
CNSTI4 1023
ASGNI4
line 1339
;1339:		pml.groundPlane = qtrue;
ADDRGP4 pml+48
CNSTI4 1
ASGNI4
line 1340
;1340:		pml.walking = qfalse;
ADDRGP4 pml+44
CNSTI4 0
ASGNI4
line 1341
;1341:		return;
ADDRGP4 $510
JUMPV
LABELV $542
line 1344
;1342:	}
;1343:
;1344:	pml.groundPlane = qtrue;
ADDRGP4 pml+48
CNSTI4 1
ASGNI4
line 1345
;1345:	pml.walking = qtrue;
ADDRGP4 pml+44
CNSTI4 1
ASGNI4
line 1348
;1346:
;1347:	// hitting solid ground will end a waterjump
;1348:	if (pm->ps->pm_flags & PMF_TIME_WATERJUMP)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $553
line 1349
;1349:	{
line 1350
;1350:		pm->ps->pm_flags &= ~(PMF_TIME_WATERJUMP | PMF_TIME_LAND);
ADDRLP4 92
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 -289
BANDI4
ASGNI4
line 1351
;1351:		pm->ps->pm_time = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 0
ASGNI4
line 1352
;1352:	}
LABELV $553
line 1354
;1353:
;1354:	if ( pm->ps->groundEntityNum == ENTITYNUM_NONE ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $555
line 1356
;1355:		// just hit the ground
;1356:		if ( pm->debugLevel ) {
ADDRGP4 pm
INDIRP4
CNSTI4 32
ADDP4
INDIRI4
CNSTI4 0
EQI4 $557
line 1357
;1357:			Com_Printf("%i:Land\n", c_pmove);
ADDRGP4 $559
ARGP4
ADDRGP4 c_pmove
INDIRI4
ARGI4
ADDRGP4 Com_Printf
CALLV
pop
line 1358
;1358:		}
LABELV $557
line 1360
;1359:		
;1360:		PM_CrashLand();
ADDRGP4 PM_CrashLand
CALLV
pop
line 1363
;1361:
;1362:		// don't do landing time if we were just going down a slope
;1363:		if ( pml.previous_velocity[2] < -200 ) {
ADDRGP4 pml+124+8
INDIRF4
CNSTF4 3276275712
GEF4 $560
line 1365
;1364:			// don't allow another jump for a little while
;1365:			pm->ps->pm_flags |= PMF_TIME_LAND;
ADDRLP4 92
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 1366
;1366:			pm->ps->pm_time = pm->ps->stats[STAT_JUMP_PAUSE];
ADDRLP4 96
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 96
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
ASGNI4
line 1367
;1367:		}
LABELV $560
line 1368
;1368:	}
LABELV $555
line 1370
;1369:
;1370:	pm->ps->groundEntityNum = trace.entityNum;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
ADDRLP4 0+52
INDIRI4
ASGNI4
line 1375
;1371:
;1372:	// don't reset the z velocity for slopes
;1373://	pm->ps->velocity[2] = 0;
;1374:
;1375:	PM_AddTouchEnt( trace.entityNum );
ADDRLP4 0+52
INDIRI4
ARGI4
ADDRGP4 PM_AddTouchEnt
CALLV
pop
line 1376
;1376:}
LABELV $510
endproc PM_GroundTrace 100 28
proc PM_SetWaterLevel 48 8
line 1384
;1377:
;1378:
;1379:/*
;1380:=============
;1381:PM_SetWaterLevel	FIXME: avoid this twice?  certainly if not moving
;1382:=============
;1383:*/
;1384:static void PM_SetWaterLevel( void ) {
line 1393
;1385:	vec3_t		point;
;1386:	int			cont;
;1387:	int			sample1;
;1388:	int			sample2;
;1389:
;1390:	//
;1391:	// get waterlevel, accounting for ducking
;1392:	//
;1393:	pm->waterlevel = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 0
ASGNI4
line 1394
;1394:	pm->watertype = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 200
ADDP4
CNSTI4 0
ASGNI4
line 1396
;1395:
;1396:	point[0] = pm->ps->origin[0];
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ASGNF4
line 1397
;1397:	point[1] = pm->ps->origin[1];
ADDRLP4 0+4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ASGNF4
line 1398
;1398:	point[2] = pm->ps->origin[2] + MINS_Z + 1;	
ADDRLP4 0+8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3250585600
ADDF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1399
;1399:	cont = pm->pointcontents( point, pm->ps->clientNum );
ADDRLP4 0
ARGP4
ADDRLP4 24
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 28
ADDRLP4 24
INDIRP4
CNSTI4 216
ADDP4
INDIRP4
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 28
INDIRI4
ASGNI4
line 1401
;1400:
;1401:	if ( cont & MASK_WATER ) {
ADDRLP4 12
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $569
line 1402
;1402:		sample2 = pm->ps->viewheight - MINS_Z;
ADDRLP4 16
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 164
ADDP4
INDIRI4
CNSTI4 -24
SUBI4
ASGNI4
line 1403
;1403:		sample1 = sample2 / 2;
ADDRLP4 20
ADDRLP4 16
INDIRI4
CNSTI4 2
DIVI4
ASGNI4
line 1405
;1404:
;1405:		pm->watertype = cont;
ADDRGP4 pm
INDIRP4
CNSTI4 200
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 1406
;1406:		pm->waterlevel = 1;
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 1
ASGNI4
line 1407
;1407:		point[2] = pm->ps->origin[2] + MINS_Z + sample1;
ADDRLP4 0+8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3250585600
ADDF4
ADDRLP4 20
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 1408
;1408:		cont = pm->pointcontents (point, pm->ps->clientNum );
ADDRLP4 0
ARGP4
ADDRLP4 32
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 36
ADDRLP4 32
INDIRP4
CNSTI4 216
ADDP4
INDIRP4
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 36
INDIRI4
ASGNI4
line 1409
;1409:		if ( cont & MASK_WATER ) {
ADDRLP4 12
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $572
line 1410
;1410:			pm->waterlevel = 2;
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 2
ASGNI4
line 1411
;1411:			point[2] = pm->ps->origin[2] + MINS_Z + sample2;
ADDRLP4 0+8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
CNSTF4 3250585600
ADDF4
ADDRLP4 16
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 1412
;1412:			cont = pm->pointcontents (point, pm->ps->clientNum );
ADDRLP4 0
ARGP4
ADDRLP4 40
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 44
ADDRLP4 40
INDIRP4
CNSTI4 216
ADDP4
INDIRP4
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 44
INDIRI4
ASGNI4
line 1413
;1413:			if ( cont & MASK_WATER ){
ADDRLP4 12
INDIRI4
CNSTI4 56
BANDI4
CNSTI4 0
EQI4 $575
line 1414
;1414:				pm->waterlevel = 3;
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 3
ASGNI4
line 1415
;1415:			}
LABELV $575
line 1416
;1416:		}
LABELV $572
line 1417
;1417:	}
LABELV $569
line 1419
;1418:
;1419:}
LABELV $566
endproc PM_SetWaterLevel 48 8
proc PM_CheckDuck 72 28
line 1431
;1420:
;1421:
;1422:
;1423:/*
;1424:==============
;1425:PM_CheckDuck
;1426:
;1427:Sets mins, maxs, and pm->ps->viewheight
;1428:==============
;1429:*/
;1430:static void PM_CheckDuck (void)
;1431:{
line 1434
;1432:	trace_t	trace;
;1433:
;1434:	pm->mins[0] = -15;
ADDRGP4 pm
INDIRP4
CNSTI4 176
ADDP4
CNSTF4 3245342720
ASGNF4
line 1435
;1435:	pm->mins[1] = -15;
ADDRGP4 pm
INDIRP4
CNSTI4 180
ADDP4
CNSTF4 3245342720
ASGNF4
line 1437
;1436:
;1437:	pm->maxs[0] = 15;
ADDRGP4 pm
INDIRP4
CNSTI4 188
ADDP4
CNSTF4 1097859072
ASGNF4
line 1438
;1438:	pm->maxs[1] = 15;
ADDRGP4 pm
INDIRP4
CNSTI4 192
ADDP4
CNSTF4 1097859072
ASGNF4
line 1440
;1439:
;1440:	pm->mins[2] = MINS_Z;
ADDRGP4 pm
INDIRP4
CNSTI4 184
ADDP4
CNSTF4 3250585600
ASGNF4
line 1442
;1441:
;1442:	if (pm->ps->pm_type == PM_DEAD)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $578
line 1443
;1443:	{
line 1444
;1444:		pm->maxs[2] = -8;
ADDRGP4 pm
INDIRP4
CNSTI4 196
ADDP4
CNSTF4 3238002688
ASGNF4
line 1445
;1445:		pm->ps->viewheight = DEAD_VIEWHEIGHT;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 -16
ASGNI4
line 1446
;1446:		return;
ADDRGP4 $577
JUMPV
LABELV $578
line 1449
;1447:	}
;1448:
;1449:	if (pm->cmd.upmove < 0)
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
GEI4 $580
line 1450
;1450:	{	// duck
line 1451
;1451:		pm->ps->pm_flags |= PMF_DUCKED;
ADDRLP4 56
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRI4
CNSTI4 1
BORI4
ASGNI4
line 1452
;1452:	}
ADDRGP4 $581
JUMPV
LABELV $580
line 1454
;1453:	else
;1454:	{	// stand up if possible
line 1455
;1455:		if (pm->ps->pm_flags & PMF_DUCKED)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $582
line 1456
;1456:		{
line 1458
;1457:			// try to stand up
;1458:			pm->maxs[2] = 32;
ADDRGP4 pm
INDIRP4
CNSTI4 196
ADDP4
CNSTF4 1107296256
ASGNF4
line 1459
;1459:			pm->trace (&trace, pm->ps->origin, pm->mins, pm->maxs, pm->ps->origin, pm->ps->clientNum, pm->tracemask );
ADDRLP4 0
ARGP4
ADDRLP4 56
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 60
ADDRLP4 56
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 64
ADDRLP4 60
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 56
INDIRP4
CNSTI4 176
ADDP4
ARGP4
ADDRLP4 56
INDIRP4
CNSTI4 188
ADDP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
CNSTI4 140
ADDP4
INDIRI4
ARGI4
ADDRLP4 56
INDIRP4
CNSTI4 28
ADDP4
INDIRI4
ARGI4
ADDRLP4 56
INDIRP4
CNSTI4 212
ADDP4
INDIRP4
CALLV
pop
line 1460
;1460:			if (!trace.allsolid)
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $584
line 1461
;1461:				pm->ps->pm_flags &= ~PMF_DUCKED;
ADDRLP4 68
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
LABELV $584
line 1462
;1462:		}
LABELV $582
line 1463
;1463:	}
LABELV $581
line 1465
;1464:
;1465:	if(pm->ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $586
line 1466
;1466:	{
line 1467
;1467:		pm->maxs[2] = 24;
ADDRGP4 pm
INDIRP4
CNSTI4 196
ADDP4
CNSTF4 1103101952
ASGNF4
line 1468
;1468:		pm->ps->viewheight = 4;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 4
ASGNI4
line 1469
;1469:	}
ADDRGP4 $587
JUMPV
LABELV $586
line 1470
;1470:	else if (pm->ps->pm_flags & PMF_DUCKED)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $588
line 1471
;1471:	{
line 1472
;1472:		pm->maxs[2] = 16;
ADDRGP4 pm
INDIRP4
CNSTI4 196
ADDP4
CNSTF4 1098907648
ASGNF4
line 1473
;1473:		pm->ps->viewheight = CROUCH_VIEWHEIGHT;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 12
ASGNI4
line 1474
;1474:	}
ADDRGP4 $589
JUMPV
LABELV $588
line 1476
;1475:	else
;1476:	{
line 1477
;1477:		pm->maxs[2] = 32;
ADDRGP4 pm
INDIRP4
CNSTI4 196
ADDP4
CNSTF4 1107296256
ASGNF4
line 1478
;1478:		pm->ps->viewheight = DEFAULT_VIEWHEIGHT;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 26
ASGNI4
line 1479
;1479:	}
LABELV $589
LABELV $587
line 1480
;1480:}
LABELV $577
endproc PM_CheckDuck 72 28
proc PM_Footsteps 56 4
line 1492
;1481:
;1482:
;1483:
;1484://===================================================================
;1485:
;1486:
;1487:/*
;1488:===============
;1489:PM_Footsteps
;1490:===============
;1491:*/
;1492:static void PM_Footsteps( void ) {
line 1501
;1493:	float		bobmove;
;1494:	int			old;
;1495:	qboolean	footstep;
;1496:
;1497:	//
;1498:	// calculate speed and cycle to be used for
;1499:	// all cyclic walking effects
;1500:	//
;1501:	if((pm->ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER) && ( pml.groundPlane ) )
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
ADDRLP4 12
INDIRI4
EQI4 $591
ADDRGP4 pml+48
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $591
line 1502
;1502:	{
line 1503
;1503:		pm->xyspeed = DotProduct(pm->ps->velocity, pml.groundTrace.plane.normal);//sqrt( pm->ps->velocity[0] * pm->ps->velocity[0] +  pm->ps->velocity[1] * pm->ps->velocity[1] );
ADDRLP4 16
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 208
ADDP4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRGP4 pml+52+24
INDIRF4
MULF4
ADDRLP4 20
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRGP4 pml+52+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 20
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRGP4 pml+52+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1504
;1504:		if(!(pm->ps->legsAnim & ANIM_CLIMBWALLS))
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $592
line 1505
;1505:			pm->ps->legsAnim |= ANIM_CLIMBWALLS;
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 1507
;1506:
;1507:	}
ADDRGP4 $592
JUMPV
LABELV $591
line 1509
;1508:	else
;1509:		pm->xyspeed = sqrt( pm->ps->velocity[0] * pm->ps->velocity[0] +  pm->ps->velocity[1] * pm->ps->velocity[1] );
ADDRLP4 16
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 24
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ASGNF4
ADDRLP4 28
ADDRLP4 20
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ASGNF4
ADDRLP4 24
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ADDRLP4 28
INDIRF4
ADDRLP4 28
INDIRF4
MULF4
ADDF4
ARGF4
ADDRLP4 32
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 16
INDIRP4
CNSTI4 208
ADDP4
ADDRLP4 32
INDIRF4
ASGNF4
LABELV $592
line 1512
;1510:	
;1511:
;1512:	if ( pm->ps->groundEntityNum == ENTITYNUM_NONE ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $604
line 1514
;1513:		// airborne leaves position in cycle intact, but doesn't advance
;1514:		if ( pm->waterlevel > 1 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
LEI4 $590
line 1515
;1515:			PM_ContinueLegsAnim( LEGS_SWIM );
CNSTI4 17
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1516
;1516:		}
line 1517
;1517:		return;
ADDRGP4 $590
JUMPV
LABELV $604
line 1521
;1518:	}
;1519:
;1520:	// if not trying to move
;1521:	if ( !pm->cmd.forwardmove && !pm->cmd.rightmove ) {
ADDRLP4 36
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 40
CNSTI4 0
ASGNI4
ADDRLP4 36
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ADDRLP4 40
INDIRI4
NEI4 $608
ADDRLP4 36
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 40
INDIRI4
NEI4 $608
line 1522
;1522:		if (  pm->xyspeed < 5 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 208
ADDP4
INDIRF4
CNSTF4 1084227584
GEF4 $590
line 1523
;1523:			pm->ps->bobCycle = 0;	// start at beginning of cycle again
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 0
ASGNI4
line 1524
;1524:			if ( pm->ps->pm_flags & PMF_DUCKED ) 
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $612
line 1525
;1525:			{
line 1526
;1526:				PM_ContinueLegsAnim( LEGS_IDLECR );
CNSTI4 23
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1527
;1527:			} else {
ADDRGP4 $613
JUMPV
LABELV $612
line 1528
;1528:				PM_ContinueLegsAnim( LEGS_IDLE );
CNSTI4 22
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1529
;1529:			}
LABELV $613
line 1530
;1530:			if(pm->ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $590
line 1531
;1531:				if(!(pm->ps->legsAnim & ANIM_CLIMBWALLS))
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $590
line 1532
;1532:					pm->ps->legsAnim |= ANIM_CLIMBWALLS;			
ADDRLP4 44
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 1533
;1533:		}
line 1534
;1534:		return;
ADDRGP4 $590
JUMPV
LABELV $608
line 1538
;1535:	}
;1536:	
;1537:
;1538:	footstep = qfalse;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 1540
;1539:
;1540:	if ( pm->ps->pm_flags & PMF_DUCKED ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $618
line 1541
;1541:		bobmove = 0.5;	// ducked characters bob much faster
ADDRLP4 4
CNSTF4 1056964608
ASGNF4
line 1542
;1542:		PM_ContinueLegsAnim( LEGS_WALKCR );
CNSTI4 13
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1544
;1543:		// ducked characters never play footsteps
;1544:	} else 	if ( pm->ps->pm_flags & PMF_BACKWARDS_RUN ) {
ADDRGP4 $619
JUMPV
LABELV $618
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $620
line 1545
;1545:		if ( !( pm->cmd.buttons & BUTTON_WALKING ) ) {
ADDRGP4 pm
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 16
BANDI4
CNSTI4 0
NEI4 $622
line 1546
;1546:			bobmove = 0.4;	// faster speeds bob faster
ADDRLP4 4
CNSTF4 1053609165
ASGNF4
line 1547
;1547:			footstep = qtrue;
ADDRLP4 8
CNSTI4 1
ASGNI4
line 1548
;1548:		} else {
ADDRGP4 $623
JUMPV
LABELV $622
line 1549
;1549:			bobmove = 0.3;
ADDRLP4 4
CNSTF4 1050253722
ASGNF4
line 1550
;1550:		}
LABELV $623
line 1551
;1551:		PM_ContinueLegsAnim( LEGS_BACK );
CNSTI4 16
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1552
;1552:	} else {
ADDRGP4 $621
JUMPV
LABELV $620
line 1553
;1553:		if ( !( pm->cmd.buttons & BUTTON_WALKING ) ) {
ADDRGP4 pm
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 16
BANDI4
CNSTI4 0
NEI4 $624
line 1554
;1554:			bobmove = 0.4;	// faster speeds bob faster
ADDRLP4 4
CNSTF4 1053609165
ASGNF4
line 1555
;1555:			PM_ContinueLegsAnim( LEGS_RUN );
CNSTI4 15
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1556
;1556:			footstep = qtrue;
ADDRLP4 8
CNSTI4 1
ASGNI4
line 1557
;1557:		} else {
ADDRGP4 $625
JUMPV
LABELV $624
line 1558
;1558:			bobmove = 0.3;	// walking bobs slow
ADDRLP4 4
CNSTF4 1050253722
ASGNF4
line 1559
;1559:			PM_ContinueLegsAnim( LEGS_WALK );
CNSTI4 14
ARGI4
ADDRGP4 PM_ContinueLegsAnim
CALLV
pop
line 1560
;1560:		}
LABELV $625
line 1561
;1561:	}
LABELV $621
LABELV $619
line 1563
;1562:
;1563:	if(pm->ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER)
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $626
line 1564
;1564:	{
line 1565
;1565:		if(!(pm->ps->legsAnim & ANIM_CLIMBWALLS))
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
NEI4 $628
line 1566
;1566:			pm->ps->legsAnim |= ANIM_CLIMBWALLS;
ADDRLP4 44
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
LABELV $628
line 1567
;1567:	}
LABELV $626
line 1569
;1568:	// check for footstep / splash sounds
;1569:	old = pm->ps->bobCycle;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 1570
;1570:	pm->ps->bobCycle = (int)( old + bobmove * pml.msec ) & 255;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 0
INDIRI4
CVIF4 4
ADDRLP4 4
INDIRF4
ADDRGP4 pml+40
INDIRI4
CVIF4 4
MULF4
ADDF4
CVFI4 4
CNSTI4 255
BANDI4
ASGNI4
line 1573
;1571:
;1572:	// if we just crossed a cycle boundary, play an apropriate footstep event
;1573:	if ( ( ( old + 64 ) ^ ( pm->ps->bobCycle + 64 ) ) & 128 ) {
ADDRLP4 44
CNSTI4 64
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 44
INDIRI4
ADDI4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ADDRLP4 44
INDIRI4
ADDI4
BXORI4
CNSTI4 128
BANDI4
CNSTI4 0
EQI4 $631
line 1574
;1574:		if ( pm->waterlevel == 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 0
NEI4 $633
line 1576
;1575:			// on ground will only play sounds if running
;1576:			if ( footstep && !pm->noFootsteps ) {
ADDRLP4 48
CNSTI4 0
ASGNI4
ADDRLP4 8
INDIRI4
ADDRLP4 48
INDIRI4
EQI4 $634
ADDRGP4 pm
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
ADDRLP4 48
INDIRI4
NEI4 $634
line 1577
;1577:				PM_AddEvent( PM_FootstepForSurface() );
ADDRLP4 52
ADDRGP4 PM_FootstepForSurface
CALLI4
ASGNI4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1578
;1578:			}
line 1579
;1579:		} else if ( pm->waterlevel == 1 ) {
ADDRGP4 $634
JUMPV
LABELV $633
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
NEI4 $637
line 1581
;1580:			// splashing
;1581:			PM_AddEvent( EV_FOOTSPLASH );
CNSTI4 3
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1582
;1582:		} else if ( pm->waterlevel == 2 ) {
ADDRGP4 $638
JUMPV
LABELV $637
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 2
NEI4 $639
line 1584
;1583:			// wading / swimming at surface
;1584:			PM_AddEvent( EV_SWIM );
CNSTI4 5
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1585
;1585:		} else if ( pm->waterlevel == 3 ) {
ADDRGP4 $640
JUMPV
LABELV $639
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 3
NEI4 $641
line 1588
;1586:			// no sound when completely underwater
;1587:
;1588:		}
LABELV $641
LABELV $640
LABELV $638
LABELV $634
line 1589
;1589:	}
LABELV $631
line 1590
;1590:}
LABELV $590
endproc PM_Footsteps 56 4
proc PM_WaterEvents 16 4
line 1599
;1591:
;1592:/*
;1593:==============
;1594:PM_WaterEvents
;1595:
;1596:Generate sound events for entering and leaving water
;1597:==============
;1598:*/
;1599:static void PM_WaterEvents( void ) {		// FIXME?
line 1603
;1600:	//
;1601:	// if just entered a water volume, play a sound
;1602:	//
;1603:	if (!pml.previous_waterlevel && pm->waterlevel) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 pml+136
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $644
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
EQI4 $644
line 1604
;1604:		PM_AddEvent( EV_WATER_TOUCH );
CNSTI4 15
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1605
;1605:	}
LABELV $644
line 1610
;1606:
;1607:	//
;1608:	// if just completely exited a water volume, play a sound
;1609:	//
;1610:	if (pml.previous_waterlevel && !pm->waterlevel) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 pml+136
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $647
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $647
line 1611
;1611:		PM_AddEvent( EV_WATER_LEAVE );
CNSTI4 16
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1612
;1612:	}
LABELV $647
line 1617
;1613:
;1614:	//
;1615:	// check for head just going under water
;1616:	//
;1617:	if (pml.previous_waterlevel != 3 && pm->waterlevel == 3) {
ADDRLP4 8
CNSTI4 3
ASGNI4
ADDRGP4 pml+136
INDIRI4
ADDRLP4 8
INDIRI4
EQI4 $650
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $650
line 1618
;1618:		PM_AddEvent( EV_WATER_UNDER );
CNSTI4 17
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1619
;1619:	}
LABELV $650
line 1624
;1620:
;1621:	//
;1622:	// check for head just coming out of water
;1623:	//
;1624:	if (pml.previous_waterlevel == 3 && pm->waterlevel != 3) {
ADDRLP4 12
CNSTI4 3
ASGNI4
ADDRGP4 pml+136
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $653
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $653
line 1625
;1625:		PM_AddEvent( EV_WATER_CLEAR );
CNSTI4 18
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1626
;1626:	}
LABELV $653
line 1627
;1627:}
LABELV $643
endproc PM_WaterEvents 16 4
proc PM_BeginWeaponChange 8 4
line 1635
;1628:
;1629:
;1630:/*
;1631:===============
;1632:PM_BeginWeaponChange
;1633:===============
;1634:*/
;1635:static void PM_BeginWeaponChange( int weapon ) {
line 1636
;1636:	if ( weapon < WP_NONE || weapon >= WP_NUM_WEAPONS ) {
ADDRLP4 0
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $659
ADDRLP4 0
INDIRI4
CNSTI4 10
LTI4 $657
LABELV $659
line 1637
;1637:		return;
ADDRGP4 $656
JUMPV
LABELV $657
line 1642
;1638:	}
;1639:
;1640:	
;1641:
;1642:	if ( !( pm->ps->stats[STAT_WEAPONS] & ( 1 << weapon ) ) ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
ADDRFP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $660
line 1643
;1643:		return;
ADDRGP4 $656
JUMPV
LABELV $660
line 1646
;1644:	}
;1645:	
;1646:	if ( pm->ps->weaponstate == WEAPON_DROPPING ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
NEI4 $662
line 1647
;1647:		return;
ADDRGP4 $656
JUMPV
LABELV $662
line 1650
;1648:	}
;1649:
;1650:	if(weapon == WP_NONE)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $664
line 1651
;1651:	{
line 1653
;1652:			
;1653:	}
LABELV $664
line 1655
;1654:
;1655:	PM_AddEvent( EV_CHANGE_WEAPON );
CNSTI4 22
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1656
;1656:	pm->ps->weaponstate = WEAPON_DROPPING;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 1657
;1657:	pm->ps->weaponTime += 200;
ADDRLP4 4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 1658
;1658:	PM_StartTorsoAnim( TORSO_DROP );
CNSTI4 9
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1659
;1659:}
LABELV $656
endproc PM_BeginWeaponChange 8 4
proc PM_FinishWeaponChange 12 4
line 1667
;1660:
;1661:
;1662:/*
;1663:===============
;1664:PM_FinishWeaponChange
;1665:===============
;1666:*/
;1667:static void PM_FinishWeaponChange( void ) {
line 1670
;1668:	int		weapon;
;1669:
;1670:	weapon = pm->cmd.weapon;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
CNSTI4 9
ADDP4
INDIRU1
CVUI4 1
ASGNI4
line 1671
;1671:	if ( weapon < WP_NONE || weapon >= WP_NUM_WEAPONS ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LTI4 $669
ADDRLP4 0
INDIRI4
CNSTI4 10
LTI4 $667
LABELV $669
line 1672
;1672:		weapon = WP_NONE;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 1673
;1673:	}
LABELV $667
line 1675
;1674:
;1675:	if ( !( pm->ps->stats[STAT_WEAPONS] & ( 1 << weapon ) ) ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $670
line 1676
;1676:		weapon = WP_NONE;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 1677
;1677:	}
LABELV $670
line 1690
;1678:	/*if(weapon == WP_NONE && pm->ps->stats[STAT_WEAPONS] > 1)
;1679:	{
;1680:		int i;
;1681:		for(i = 1; i < MAX_WEAPONS; i++)
;1682:		{
;1683:			if(pm->ps->stats[STAT_WEAPONS] & (1 << i))
;1684:			{
;1685:				weapon = i;
;1686:				break;
;1687:			}
;1688:		}
;1689:	}*/
;1690:	pm->ps->weapon = weapon;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1691
;1691:	pm->ps->weaponstate = WEAPON_RAISING;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 1
ASGNI4
line 1692
;1692:	pm->ps->weaponTime += 250;
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 250
ADDI4
ASGNI4
line 1693
;1693:	PM_StartTorsoAnim( TORSO_RAISE );
CNSTI4 10
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1695
;1694:	
;1695:}
LABELV $666
endproc PM_FinishWeaponChange 12 4
proc PM_TorsoAnimation 0 4
line 1705
;1696:
;1697:
;1698:
;1699:/*
;1700:==============
;1701:PM_TorsoAnimation
;1702:
;1703:==============
;1704:*/
;1705:static void PM_TorsoAnimation( void ) {
line 1706
;1706:	if ( pm->ps->weaponstate == WEAPON_READY ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 0
NEI4 $673
line 1707
;1707:		if ( pm->ps->weapon <= WP_GAUNTLET ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1
GTI4 $675
line 1708
;1708:			PM_ContinueTorsoAnim( TORSO_STAND2 );
CNSTI4 12
ARGI4
ADDRGP4 PM_ContinueTorsoAnim
CALLV
pop
line 1709
;1709:		} else {
ADDRGP4 $672
JUMPV
LABELV $675
line 1710
;1710:			PM_ContinueTorsoAnim( TORSO_STAND );
CNSTI4 11
ARGI4
ADDRGP4 PM_ContinueTorsoAnim
CALLV
pop
line 1711
;1711:		}
line 1712
;1712:		return;
LABELV $673
line 1714
;1713:	}
;1714:}
LABELV $672
endproc PM_TorsoAnimation 0 4
proc PM_Weapon 40 12
line 1724
;1715:
;1716:
;1717:/*
;1718:==============
;1719:PM_Weapon
;1720:
;1721:Generates weapon events and modifes the weapon counter
;1722:==============
;1723:*/
;1724:static void PM_Weapon( void ) {
line 1728
;1725:	int		addTime;
;1726:
;1727:	// don't allow attack until all buttons are up
;1728:	if ( pm->ps->pm_flags & PMF_RESPAWNED ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $678
line 1729
;1729:		return;
ADDRGP4 $677
JUMPV
LABELV $678
line 1733
;1730:	}
;1731:
;1732:	// ignore if spectator
;1733:	if ( pm->ps->persistant[PERS_TEAM] == TEAM_SPECTATOR ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 3
NEI4 $680
line 1734
;1734:		return;
ADDRGP4 $677
JUMPV
LABELV $680
line 1738
;1735:	}
;1736:
;1737:	// check for dead player
;1738:	if ( pm->ps->stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $682
line 1739
;1739:		pm->ps->weapon = WP_NONE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
CNSTI4 0
ASGNI4
line 1740
;1740:		return;
ADDRGP4 $677
JUMPV
LABELV $682
line 1744
;1741:	}
;1742:
;1743:	// check for item using
;1744:	if ( pm->cmd.buttons & BUTTON_USE_HOLDABLE ) {
ADDRGP4 pm
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $684
line 1745
;1745:		if ( ! ( pm->ps->pm_flags & PMF_USE_ITEM_HELD ) ) 
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
NEI4 $685
line 1746
;1746:		{
line 1747
;1747:			if ( bg_itemlist[pm->ps->stats[STAT_HOLDABLE_ITEM]].giTag == HI_MEDKIT
ADDRLP4 4
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
CNSTI4 56
ADDRLP4 4
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
MULI4
ADDRGP4 bg_itemlist+40
ADDP4
INDIRI4
CNSTI4 2
NEI4 $688
ADDRLP4 4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 208
ADDP4
INDIRI4
LTI4 $688
line 1749
;1748:				&& pm->ps->stats[STAT_HEALTH] >= pm->ps->stats[STAT_MAX_HEALTH] ) 
;1749:			{
line 1751
;1750:				// don't use medkit if at max health
;1751:			} 
ADDRGP4 $677
JUMPV
LABELV $688
line 1752
;1752:			else if(bg_itemlist[pm->ps->stats[STAT_HOLDABLE_ITEM]].giType == IT_AMMO) 
CNSTI4 56
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
MULI4
ADDRGP4 bg_itemlist+36
ADDP4
INDIRI4
CNSTI4 2
NEI4 $691
line 1753
;1753:			{
line 1754
;1754:				BG_AddPredictableEventToPlayerstate( EV_ITEM_PICKUP, pm->ps->stats[STAT_HOLDABLE_ITEM], pm->ps );
CNSTI4 19
ARGI4
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 BG_AddPredictableEventToPlayerstate
CALLV
pop
line 1755
;1755:				pm->ps->pm_flags |= PMF_USE_ITEM_HELD;				
ADDRLP4 12
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1024
BORI4
ASGNI4
line 1756
;1756:				pm->ps->ammo[pm->ps->weapon] += bg_itemlist[pm->ps->stats[STAT_HOLDABLE_ITEM]].quantity;
ADDRLP4 16
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
INDIRP4
CNSTI4 376
ADDP4
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 56
ADDRLP4 16
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
MULI4
ADDRGP4 bg_itemlist+32
ADDP4
INDIRI4
ADDI4
ASGNI4
line 1757
;1757:				pm->ps->stats[STAT_HOLDABLE_ITEM] = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 0
ASGNI4
line 1758
;1758:			}
ADDRGP4 $677
JUMPV
LABELV $691
line 1760
;1759:			else 
;1760:			{
line 1761
;1761:				pm->ps->pm_flags |= PMF_USE_ITEM_HELD;
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1024
BORI4
ASGNI4
line 1762
;1762:				PM_AddEvent( EV_USE_ITEM0 + bg_itemlist[pm->ps->stats[STAT_HOLDABLE_ITEM]].giTag );
CNSTI4 56
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
MULI4
ADDRGP4 bg_itemlist+40
ADDP4
INDIRI4
CNSTI4 24
ADDI4
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1763
;1763:				pm->ps->stats[STAT_HOLDABLE_ITEM] = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 0
ASGNI4
line 1764
;1764:			}
line 1765
;1765:			return;
ADDRGP4 $677
JUMPV
line 1767
;1766:		}
;1767:	} else {
LABELV $684
line 1768
;1768:		pm->ps->pm_flags &= ~PMF_USE_ITEM_HELD;
ADDRLP4 4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -1025
BANDI4
ASGNI4
line 1769
;1769:	}
LABELV $685
line 1773
;1770:
;1771:
;1772:	// make weapon function
;1773:	if ( pm->ps->weaponTime > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 0
LEI4 $696
line 1774
;1774:		pm->ps->weaponTime -= pml.msec;
ADDRLP4 4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
ADDRGP4 pml+40
INDIRI4
SUBI4
ASGNI4
line 1775
;1775:	}
LABELV $696
line 1780
;1776:
;1777:	// check for weapon change
;1778:	// can't change if weapon is firing, but can change
;1779:	// again if lowering or raising
;1780:	if ( pm->ps->weaponTime <= 0 || pm->ps->weaponstate != WEAPON_FIRING ) {
ADDRLP4 4
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 0
LEI4 $701
ADDRLP4 4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 3
EQI4 $699
LABELV $701
line 1781
;1781:		if(pm->cmd.weapon == WP_NONE && pm->ps->weaponstate != WEAPON_READY)
ADDRLP4 8
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRLP4 8
INDIRP4
CNSTI4 9
ADDP4
INDIRU1
CVUI4 1
ADDRLP4 12
INDIRI4
NEI4 $702
ADDRLP4 8
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $702
line 1782
;1782:			return;
ADDRGP4 $677
JUMPV
LABELV $702
line 1783
;1783:		if ( pm->ps->weapon != pm->cmd.weapon ) {
ADDRLP4 16
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ADDRLP4 16
INDIRP4
CNSTI4 9
ADDP4
INDIRU1
CVUI4 1
EQI4 $704
line 1784
;1784:			PM_BeginWeaponChange( pm->cmd.weapon );
ADDRGP4 pm
INDIRP4
CNSTI4 9
ADDP4
INDIRU1
CVUI4 1
ARGI4
ADDRGP4 PM_BeginWeaponChange
CALLV
pop
line 1785
;1785:		}
LABELV $704
line 1786
;1786:	}
LABELV $699
line 1788
;1787:
;1788:	if ( pm->ps->weaponTime > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
INDIRI4
CNSTI4 0
LEI4 $706
line 1789
;1789:		return;
ADDRGP4 $677
JUMPV
LABELV $706
line 1793
;1790:	}
;1791:
;1792:	// change weapon if time
;1793:	if ( pm->ps->weaponstate == WEAPON_DROPPING ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
NEI4 $708
line 1794
;1794:		PM_FinishWeaponChange();
ADDRGP4 PM_FinishWeaponChange
CALLV
pop
line 1795
;1795:		return;
ADDRGP4 $677
JUMPV
LABELV $708
line 1798
;1796:	}
;1797:
;1798:	if ( pm->ps->weaponstate == WEAPON_RAISING ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 1
NEI4 $710
line 1799
;1799:		pm->ps->weaponstate = WEAPON_READY;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 0
ASGNI4
line 1800
;1800:		if ( pm->ps->weapon <= WP_GAUNTLET) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1
GTI4 $712
line 1801
;1801:			PM_StartTorsoAnim( TORSO_STAND2 );
CNSTI4 12
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1802
;1802:		} else {
ADDRGP4 $677
JUMPV
LABELV $712
line 1803
;1803:			PM_StartTorsoAnim( TORSO_STAND );
CNSTI4 11
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1804
;1804:		}
line 1805
;1805:		return;
ADDRGP4 $677
JUMPV
LABELV $710
line 1809
;1806:	}
;1807:
;1808:	// check for fire
;1809:	if ( ! (pm->cmd.buttons & 1) ) {
ADDRGP4 pm
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 1
BANDI4
CNSTI4 0
NEI4 $714
line 1810
;1810:		pm->ps->weaponTime = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
CNSTI4 0
ASGNI4
line 1811
;1811:		pm->ps->weaponstate = WEAPON_READY;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 0
ASGNI4
line 1812
;1812:		return;
ADDRGP4 $677
JUMPV
LABELV $714
line 1816
;1813:	}
;1814:
;1815:	// start the animation even if out of ammo
;1816:	if ( pm->ps->weapon <= WP_GAUNTLET ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1
GTI4 $716
line 1818
;1817:		// the guantlet only "fires" when it actually hits something
;1818:		if ( !pm->gauntletHit ) {
ADDRGP4 pm
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 0
NEI4 $718
line 1819
;1819:			pm->ps->weaponTime = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
CNSTI4 0
ASGNI4
line 1820
;1820:			pm->ps->weaponstate = WEAPON_READY;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 0
ASGNI4
line 1821
;1821:			return;
ADDRGP4 $677
JUMPV
LABELV $718
line 1823
;1822:		}
;1823:		PM_StartTorsoAnim( TORSO_ATTACK2 );
CNSTI4 8
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1824
;1824:	} else {
ADDRGP4 $717
JUMPV
LABELV $716
line 1825
;1825:		PM_StartTorsoAnim( TORSO_ATTACK );
CNSTI4 7
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1826
;1826:	}
LABELV $717
line 1828
;1827:
;1828:	pm->ps->weaponstate = WEAPON_FIRING;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 3
ASGNI4
line 1831
;1829:
;1830:	// check for out of ammo
;1831:	if(pm->ps->weapon == WP_GAUNTLET && pm->ps->ammo[ pm->ps->weapon ] == 1)
ADDRLP4 8
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 8
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
CNSTI4 1
ASGNI4
ADDRLP4 12
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $720
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $720
line 1832
;1832:	{
line 1833
;1833:		PM_AddEvent( EV_NOAMMO );
CNSTI4 21
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1834
;1834:	}
ADDRGP4 $721
JUMPV
LABELV $720
line 1835
;1835:	else if ( ! pm->ps->ammo[ pm->ps->weapon ] ) {		
ADDRLP4 20
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 20
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $722
line 1836
;1836:		PM_AddEvent( EV_NOAMMO );
CNSTI4 21
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1837
;1837:		pm->ps->weaponTime += 500;
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 500
ADDI4
ASGNI4
line 1838
;1838:		return;
ADDRGP4 $677
JUMPV
LABELV $722
LABELV $721
line 1842
;1839:	}
;1840:
;1841:	// take an ammo away if not infinite
;1842:	if ( pm->ps->ammo[ pm->ps->weapon ] != -1 ) {
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 24
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
CNSTI4 -1
EQI4 $724
line 1843
;1843:		pm->ps->ammo[ pm->ps->weapon ]--;
ADDRLP4 28
ADDRGP4 pm
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 32
ADDRLP4 28
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 28
INDIRP4
CNSTI4 376
ADDP4
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1844
;1844:	}
LABELV $724
line 1847
;1845:
;1846:	// fire weapon
;1847:	PM_AddEvent( EV_FIRE_WEAPON );
CNSTI4 23
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1849
;1848:
;1849:	switch( pm->ps->weapon ) {
ADDRLP4 28
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 -1
LTI4 $726
ADDRLP4 28
INDIRI4
CNSTI4 9
GTI4 $726
ADDRLP4 28
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $739+4
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $739
address $738
address $729
address $729
address $732
address $731
address $733
address $734
address $730
address $736
address $735
address $737
code
LABELV $726
LABELV $729
line 1853
;1850:	default:
;1851:	case WP_NONE:
;1852:	case WP_GAUNTLET:
;1853:		addTime = 400;
ADDRLP4 0
CNSTI4 400
ASGNI4
line 1854
;1854:		break;
ADDRGP4 $727
JUMPV
LABELV $730
line 1856
;1855:	case WP_LIGHTNING:
;1856:		addTime = 50;
ADDRLP4 0
CNSTI4 50
ASGNI4
line 1857
;1857:		break;
ADDRGP4 $727
JUMPV
LABELV $731
line 1859
;1858:	case WP_SHOTGUN:
;1859:		addTime = 1000;
ADDRLP4 0
CNSTI4 1000
ASGNI4
line 1860
;1860:		break;
ADDRGP4 $727
JUMPV
LABELV $732
line 1862
;1861:	case WP_MACHINEGUN:
;1862:		addTime = 100;
ADDRLP4 0
CNSTI4 100
ASGNI4
line 1863
;1863:		break;
ADDRGP4 $727
JUMPV
LABELV $733
line 1865
;1864:	case WP_GRENADE_LAUNCHER:
;1865:		addTime = 800;
ADDRLP4 0
CNSTI4 800
ASGNI4
line 1866
;1866:		break;
ADDRGP4 $727
JUMPV
LABELV $734
line 1868
;1867:	case WP_ROCKET_LAUNCHER:
;1868:		addTime = 800;
ADDRLP4 0
CNSTI4 800
ASGNI4
line 1869
;1869:		break;
ADDRGP4 $727
JUMPV
LABELV $735
line 1871
;1870:	case WP_PLASMAGUN:
;1871:		addTime = 100;
ADDRLP4 0
CNSTI4 100
ASGNI4
line 1872
;1872:		break;
ADDRGP4 $727
JUMPV
LABELV $736
line 1874
;1873:	case WP_RAILGUN:
;1874:		addTime = 1500;
ADDRLP4 0
CNSTI4 1500
ASGNI4
line 1875
;1875:		break;
ADDRGP4 $727
JUMPV
LABELV $737
line 1878
;1876:	case WP_BFG:
;1877://		addTime = 100;
;1878:		addTime = 200;
ADDRLP4 0
CNSTI4 200
ASGNI4
line 1879
;1879:		break;
ADDRGP4 $727
JUMPV
LABELV $738
line 1881
;1880:	case WP_GRAPPLING_HOOK:
;1881:		addTime = 400;
ADDRLP4 0
CNSTI4 400
ASGNI4
line 1882
;1882:		break;
LABELV $727
line 1885
;1883:	}
;1884:
;1885:	if ( pm->ps->powerups[PW_HASTE] ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 324
ADDP4
INDIRI4
CNSTI4 0
EQI4 $741
line 1886
;1886:		addTime /= 1.3;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CVIF4 4
CNSTF4 1067869798
DIVF4
CVFI4 4
ASGNI4
line 1887
;1887:	}
LABELV $741
line 1889
;1888:
;1889:	pm->ps->weaponTime += addTime;
ADDRLP4 36
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
ADDRLP4 0
INDIRI4
ADDI4
ASGNI4
line 1890
;1890:}
LABELV $677
endproc PM_Weapon 40 12
proc PM_Animate 4 4
line 1897
;1891:
;1892:/*
;1893:================
;1894:PM_Animate
;1895:================
;1896:*/
;1897:static void PM_Animate( void ) {
line 1898
;1898:	if ( pm->cmd.buttons & BUTTON_GESTURE ) {
ADDRLP4 0
CNSTI4 8
ASGNI4
ADDRGP4 pm
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRU1
CVUI4 1
ADDRLP4 0
INDIRI4
BANDI4
CNSTI4 0
EQI4 $744
line 1899
;1899:		if ( pm->ps->torsoTimer == 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
INDIRI4
CNSTI4 0
NEI4 $746
line 1900
;1900:			PM_StartTorsoAnim( TORSO_GESTURE );
CNSTI4 6
ARGI4
ADDRGP4 PM_StartTorsoAnim
CALLV
pop
line 1901
;1901:			pm->ps->torsoTimer = TIMER_GESTURE;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
CNSTI4 2294
ASGNI4
line 1902
;1902:			PM_AddEvent( EV_TAUNT );
CNSTI4 65
ARGI4
ADDRGP4 PM_AddEvent
CALLV
pop
line 1903
;1903:		}
LABELV $746
line 1904
;1904:	}
LABELV $744
line 1905
;1905:}
LABELV $743
endproc PM_Animate 4 4
proc PM_DropTimers 4 0
line 1913
;1906:
;1907:
;1908:/*
;1909:================
;1910:PM_DropTimers
;1911:================
;1912:*/
;1913:static void PM_DropTimers( void ) {
line 1915
;1914:	// drop misc timing counter
;1915:	if ( pm->ps->pm_time ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 0
EQI4 $749
line 1916
;1916:		if ( pml.msec >= pm->ps->pm_time ) {
ADDRGP4 pml+40
INDIRI4
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
LTI4 $751
line 1917
;1917:			pm->ps->pm_flags &= ~PMF_ALL_TIMES;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -353
BANDI4
ASGNI4
line 1918
;1918:			pm->ps->pm_time = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 0
ASGNI4
line 1919
;1919:		} else {
ADDRGP4 $752
JUMPV
LABELV $751
line 1920
;1920:			pm->ps->pm_time -= pml.msec;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 pml+40
INDIRI4
SUBI4
ASGNI4
line 1921
;1921:		}
LABELV $752
line 1922
;1922:	}
LABELV $749
line 1925
;1923:
;1924:	// drop animation counter
;1925:	if ( pm->ps->legsTimer > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 0
LEI4 $755
line 1926
;1926:		pm->ps->legsTimer -= pml.msec;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 pml+40
INDIRI4
SUBI4
ASGNI4
line 1927
;1927:		if ( pm->ps->legsTimer < 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
INDIRI4
CNSTI4 0
GEI4 $758
line 1928
;1928:			pm->ps->legsTimer = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 72
ADDP4
CNSTI4 0
ASGNI4
line 1929
;1929:		}
LABELV $758
line 1930
;1930:	}
LABELV $755
line 1932
;1931:
;1932:	if ( pm->ps->torsoTimer > 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
INDIRI4
CNSTI4 0
LEI4 $760
line 1933
;1933:		pm->ps->torsoTimer -= pml.msec;
ADDRLP4 0
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
ADDRGP4 pml+40
INDIRI4
SUBI4
ASGNI4
line 1934
;1934:		if ( pm->ps->torsoTimer < 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
INDIRI4
CNSTI4 0
GEI4 $763
line 1935
;1935:			pm->ps->torsoTimer = 0;
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 80
ADDP4
CNSTI4 0
ASGNI4
line 1936
;1936:		}
LABELV $763
line 1937
;1937:	}
LABELV $760
line 1938
;1938:}
LABELV $748
endproc PM_DropTimers 4 0
export PM_UpdateViewAngles
proc PM_UpdateViewAngles 20 0
line 1948
;1939:
;1940:/*
;1941:================
;1942:PM_UpdateViewAngles
;1943:
;1944:This can be used as another entry point when only the viewangles
;1945:are being updated isntead of a full move
;1946:================
;1947:*/
;1948:void PM_UpdateViewAngles( playerState_t *ps, const usercmd_t *cmd ) {
line 1952
;1949:	short		temp;
;1950:	int		i;
;1951:
;1952:	if ( ps->pm_type == PM_INTERMISSION ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 5
NEI4 $766
line 1953
;1953:		return;		// no view changes at all
ADDRGP4 $765
JUMPV
LABELV $766
line 1956
;1954:	}
;1955:
;1956:	if ( ps->pm_type != PM_SPECTATOR && ps->stats[STAT_HEALTH] <= 0 ) {
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
EQI4 $768
ADDRLP4 8
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $768
line 1957
;1957:		return;		// no view changes at all
ADDRGP4 $765
JUMPV
LABELV $768
line 1961
;1958:	}
;1959:
;1960:	// circularly clamp the angles with deltas
;1961:	for (i=0 ; i<3 ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $770
line 1962
;1962:		temp = cmd->angles[i] + ps->delta_angles[i];
ADDRLP4 12
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4
ADDRLP4 12
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDP4
INDIRI4
ADDI4
CVII2 4
ASGNI2
line 1963
;1963:		if ( (i == PITCH) )//&& !(ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER)) 
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $774
line 1964
;1964:		{
line 1967
;1965:			// don't let the player look up or down more than 90 degrees
;1966:			
;1967:			if ( temp > 16383 ) {
ADDRLP4 4
INDIRI2
CVII4 2
CNSTI4 16383
LEI4 $776
line 1968
;1968:				ps->delta_angles[i] = 16383 - cmd->angles[i];
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 16
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDP4
CNSTI4 16383
ADDRLP4 16
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDP4
INDIRI4
SUBI4
ASGNI4
line 1969
;1969:				temp = 16383;
ADDRLP4 4
CNSTI2 16383
ASGNI2
line 1970
;1970:			} else if ( temp < -16383 ) {
ADDRGP4 $777
JUMPV
LABELV $776
ADDRLP4 4
INDIRI2
CVII4 2
CNSTI4 -16383
GEI4 $778
line 1971
;1971:				ps->delta_angles[i] = -16383 - cmd->angles[i];
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 16
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDP4
CNSTI4 -16383
ADDRLP4 16
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDP4
INDIRI4
SUBI4
ASGNI4
line 1972
;1972:				temp = -16383;
ADDRLP4 4
CNSTI2 -16383
ASGNI2
line 1973
;1973:			}
LABELV $778
LABELV $777
line 1974
;1974:		}
LABELV $774
line 1975
;1975:		ps->viewangles[i] = SHORT2ANGLE(temp);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 152
ADDP4
ADDP4
CNSTF4 1001652224
ADDRLP4 4
INDIRI2
CVII4 2
CVIF4 4
MULF4
ASGNF4
line 1976
;1976:	}
LABELV $771
line 1961
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $770
line 1978
;1977:
;1978:}
LABELV $765
endproc PM_UpdateViewAngles 20 0
export PmoveSingle
proc PmoveSingle 72 16
line 1987
;1979:
;1980:
;1981:/*
;1982:================
;1983:PmoveSingle
;1984:
;1985:================
;1986:*/
;1987:void PmoveSingle (pmove_t *pmove) {
line 1988
;1988:	pm = pmove;
ADDRGP4 pm
ADDRFP4 0
INDIRP4
ASGNP4
line 1991
;1989:	// this counter lets us debug movement problems with a journal
;1990:	// by setting a conditional breakpoint fot the previous frame
;1991:	c_pmove++;
ADDRLP4 0
ADDRGP4 c_pmove
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1994
;1992:
;1993:	// clear results
;1994:	pm->numtouch = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 44
ADDP4
CNSTI4 0
ASGNI4
line 1995
;1995:	pm->watertype = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 200
ADDP4
CNSTI4 0
ASGNI4
line 1996
;1996:	pm->waterlevel = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 0
ASGNI4
line 1998
;1997:
;1998:	if ( pm->ps->stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
CNSTI4 0
GTI4 $781
line 1999
;1999:		pm->tracemask &= ~CONTENTS_BODY;	// corpses can fly through bodies
ADDRLP4 4
ADDRGP4 pm
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -33554433
BANDI4
ASGNI4
line 2000
;2000:	}
LABELV $781
line 2004
;2001:
;2002:	// make sure walking button is clear if they are running, to avoid
;2003:	// proxy no-footsteps cheats
;2004:	if ( abs( pm->cmd.forwardmove ) > 64 || abs( pm->cmd.rightmove ) > 64 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 4
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 64
GTI4 $785
ADDRGP4 pm
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ARGI4
ADDRLP4 8
ADDRGP4 abs
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 64
LEI4 $783
LABELV $785
line 2005
;2005:		pm->cmd.buttons &= ~BUTTON_WALKING;
ADDRLP4 12
ADDRGP4 pm
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRU1
CVUI4 1
CNSTI4 -17
BANDI4
CVIU4 4
CVUU1 4
ASGNU1
line 2006
;2006:	}
LABELV $783
line 2009
;2007:
;2008:	// set the talk balloon flag
;2009:	if ( pm->cmd.buttons & BUTTON_TALK ) {
ADDRGP4 pm
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $786
line 2010
;2010:		pm->ps->eFlags |= EF_TALK;
ADDRLP4 12
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 2011
;2011:	} else {
ADDRGP4 $787
JUMPV
LABELV $786
line 2012
;2012:		pm->ps->eFlags &= ~EF_TALK;
ADDRLP4 12
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 -4097
BANDI4
ASGNI4
line 2013
;2013:	}
LABELV $787
line 2016
;2014:
;2015:	// set the firing flag for continuous beam weapons
;2016:	if ( !(pm->ps->pm_flags & PMF_RESPAWNED) && pm->ps->pm_type != PM_INTERMISSION
ADDRLP4 12
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 12
INDIRP4
INDIRP4
ASGNP4
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 16
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 512
BANDI4
ADDRLP4 20
INDIRI4
NEI4 $788
ADDRLP4 16
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 5
EQI4 $788
ADDRLP4 12
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 1
BANDI4
ADDRLP4 20
INDIRI4
EQI4 $788
ADDRLP4 16
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
INDIRP4
CNSTI4 376
ADDP4
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
EQI4 $788
line 2017
;2017:		&& ( pm->cmd.buttons & BUTTON_ATTACK ) && pm->ps->ammo[ pm->ps->weapon ] ) {
line 2018
;2018:		pm->ps->eFlags |= EF_FIRING;
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 256
BORI4
ASGNI4
line 2019
;2019:	} else {
ADDRGP4 $789
JUMPV
LABELV $788
line 2020
;2020:		pm->ps->eFlags &= ~EF_FIRING;
ADDRLP4 24
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 104
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 -257
BANDI4
ASGNI4
line 2021
;2021:	}
LABELV $789
line 2024
;2022:
;2023:	// clear the respawned flag if attack and use are cleared
;2024:	if ( pm->ps->stats[STAT_HEALTH] > 0 && 
ADDRLP4 24
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 28
CNSTI4 0
ASGNI4
ADDRLP4 24
INDIRP4
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
ADDRLP4 28
INDIRI4
LEI4 $790
ADDRLP4 24
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 5
BANDI4
ADDRLP4 28
INDIRI4
NEI4 $790
line 2025
;2025:		!( pm->cmd.buttons & (BUTTON_ATTACK | BUTTON_USE_HOLDABLE) ) ) {
line 2026
;2026:		pm->ps->pm_flags &= ~PMF_RESPAWNED;
ADDRLP4 32
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI4
CNSTI4 -513
BANDI4
ASGNI4
line 2027
;2027:	}
LABELV $790
line 2032
;2028:
;2029:	// if talk button is down, dissallow all other input
;2030:	// this is to prevent any possible intercept proxy from
;2031:	// adding fake talk balloons
;2032:	if ( pmove->cmd.buttons & BUTTON_TALK ) {
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRU1
CVUI4 1
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $792
line 2033
;2033:		pmove->cmd.buttons = 0;
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTU1 0
ASGNU1
line 2034
;2034:		pmove->cmd.forwardmove = 0;
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTI1 0
ASGNI1
line 2035
;2035:		pmove->cmd.rightmove = 0;
ADDRFP4 0
INDIRP4
CNSTI4 25
ADDP4
CNSTI1 0
ASGNI1
line 2036
;2036:		pmove->cmd.upmove = 0;
ADDRFP4 0
INDIRP4
CNSTI4 26
ADDP4
CNSTI1 0
ASGNI1
line 2037
;2037:	}
LABELV $792
line 2040
;2038:
;2039:	// clear all pmove local vars
;2040:	memset (&pml, 0, sizeof(pml));
ADDRGP4 pml
ARGP4
CNSTI4 0
ARGI4
CNSTU4 140
ARGU4
ADDRGP4 memset
CALLP4
pop
line 2043
;2041:
;2042:	// determine the time
;2043:	pml.msec = pmove->cmd.serverTime - pm->ps->commandTime;
ADDRGP4 pml+40
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ADDRGP4 pm
INDIRP4
INDIRP4
INDIRI4
SUBI4
ASGNI4
line 2044
;2044:	if ( pml.msec < 1 ) {
ADDRGP4 pml+40
INDIRI4
CNSTI4 1
GEI4 $795
line 2045
;2045:		pml.msec = 1;
ADDRGP4 pml+40
CNSTI4 1
ASGNI4
line 2046
;2046:	} else if ( pml.msec > 200 ) {
ADDRGP4 $796
JUMPV
LABELV $795
ADDRGP4 pml+40
INDIRI4
CNSTI4 200
LEI4 $799
line 2047
;2047:		pml.msec = 200;
ADDRGP4 pml+40
CNSTI4 200
ASGNI4
line 2048
;2048:	}
LABELV $799
LABELV $796
line 2049
;2049:	pm->ps->commandTime = pmove->cmd.serverTime;
ADDRGP4 pm
INDIRP4
INDIRP4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 2052
;2050:
;2051:	// save old org in case we get stuck
;2052:	VectorCopy (pm->ps->origin, pml.previous_origin);
ADDRGP4 pml+112
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 2055
;2053:
;2054:	// save old velocity for crashlanding
;2055:	VectorCopy (pm->ps->velocity, pml.previous_velocity);
ADDRGP4 pml+124
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
INDIRB
ASGNB 12
line 2057
;2056:
;2057:	pml.frametime = pml.msec * 0.001;
ADDRGP4 pml+36
CNSTF4 981668463
ADDRGP4 pml+40
INDIRI4
CVIF4 4
MULF4
ASGNF4
line 2060
;2058:
;2059:	// update the viewangles
;2060:	PM_UpdateViewAngles( pm->ps, &pm->cmd );
ADDRLP4 32
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
CNSTI4 4
ADDP4
ARGP4
ADDRGP4 PM_UpdateViewAngles
CALLV
pop
line 2062
;2061:
;2062:	AngleVectors (pm->ps->viewangles, pml.forward, pml.right, pml.up);
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 152
ADDP4
ARGP4
ADDRGP4 pml
ARGP4
ADDRGP4 pml+12
ARGP4
ADDRGP4 pml+24
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2064
;2063:
;2064:	if ( pm->cmd.upmove < 10 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CNSTI4 10
GEI4 $809
line 2066
;2065:		// not holding jump
;2066:		pm->ps->pm_flags &= ~PMF_JUMP_HELD;
ADDRLP4 36
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 -3
BANDI4
ASGNI4
line 2067
;2067:	}
LABELV $809
line 2070
;2068:
;2069:	// decide if backpedaling animations should be used
;2070:	if ( pm->cmd.forwardmove < 0 ) {
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
GEI4 $811
line 2071
;2071:		pm->ps->pm_flags |= PMF_BACKWARDS_RUN;
ADDRLP4 36
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 2072
;2072:	} else if ( pm->cmd.forwardmove > 0 || ( pm->cmd.forwardmove == 0 && pm->cmd.rightmove ) ) {
ADDRGP4 $812
JUMPV
LABELV $811
ADDRLP4 36
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 36
INDIRP4
CNSTI4 24
ADDP4
INDIRI1
CVII4 1
ASGNI4
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 40
INDIRI4
ADDRLP4 44
INDIRI4
GTI4 $815
ADDRLP4 40
INDIRI4
ADDRLP4 44
INDIRI4
NEI4 $813
ADDRLP4 36
INDIRP4
CNSTI4 25
ADDP4
INDIRI1
CVII4 1
ADDRLP4 44
INDIRI4
EQI4 $813
LABELV $815
line 2073
;2073:		pm->ps->pm_flags &= ~PMF_BACKWARDS_RUN;
ADDRLP4 48
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRI4
CNSTI4 -17
BANDI4
ASGNI4
line 2074
;2074:	}
LABELV $813
LABELV $812
line 2076
;2075:
;2076:	if ( pm->ps->pm_type >= PM_DEAD ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
LTI4 $816
line 2077
;2077:		pm->cmd.forwardmove = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 24
ADDP4
CNSTI1 0
ASGNI1
line 2078
;2078:		pm->cmd.rightmove = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 25
ADDP4
CNSTI1 0
ASGNI1
line 2079
;2079:		pm->cmd.upmove = 0;
ADDRGP4 pm
INDIRP4
CNSTI4 26
ADDP4
CNSTI1 0
ASGNI1
line 2080
;2080:	}
LABELV $816
line 2082
;2081:
;2082:	if ( pm->ps->pm_type == PM_SPECTATOR ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $818
line 2083
;2083:		PM_CheckDuck ();
ADDRGP4 PM_CheckDuck
CALLV
pop
line 2084
;2084:		PM_FlyMove ();
ADDRGP4 PM_FlyMove
CALLV
pop
line 2085
;2085:		PM_DropTimers ();
ADDRGP4 PM_DropTimers
CALLV
pop
line 2086
;2086:		return;
ADDRGP4 $780
JUMPV
LABELV $818
line 2089
;2087:	}
;2088:
;2089:	if ( pm->ps->pm_type == PM_NOCLIP ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 1
NEI4 $820
line 2090
;2090:		PM_NoclipMove ();
ADDRGP4 PM_NoclipMove
CALLV
pop
line 2091
;2091:		PM_DropTimers ();
ADDRGP4 PM_DropTimers
CALLV
pop
line 2092
;2092:		return;
ADDRGP4 $780
JUMPV
LABELV $820
line 2095
;2093:	}
;2094:
;2095:	if (pm->ps->pm_type == PM_FREEZE) {
ADDRLP4 48
CNSTI4 4
ASGNI4
ADDRGP4 pm
INDIRP4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRI4
ADDRLP4 48
INDIRI4
NEI4 $822
line 2096
;2096:		return;		// no movement at all
ADDRGP4 $780
JUMPV
LABELV $822
line 2099
;2097:	}
;2098:
;2099:	if ( pm->ps->pm_type == PM_INTERMISSION ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 5
NEI4 $824
line 2100
;2100:		return;		// no movement at all
ADDRGP4 $780
JUMPV
LABELV $824
line 2104
;2101:	}
;2102:
;2103:	// set watertype, and waterlevel
;2104:	PM_SetWaterLevel();
ADDRGP4 PM_SetWaterLevel
CALLV
pop
line 2105
;2105:	pml.previous_waterlevel = pmove->waterlevel;
ADDRGP4 pml+136
ADDRFP4 0
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
ASGNI4
line 2108
;2106:
;2107:	// set mins, maxs, and viewheight
;2108:	PM_CheckDuck ();
ADDRGP4 PM_CheckDuck
CALLV
pop
line 2111
;2109:
;2110:	// set groundentity
;2111:	PM_GroundTrace();
ADDRGP4 PM_GroundTrace
CALLV
pop
line 2114
;2112:	
;2113:	
;2114:	if ( pm->ps->pm_type == PM_DEAD ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 3
NEI4 $827
line 2115
;2115:		PM_DeadMove ();
ADDRGP4 PM_DeadMove
CALLV
pop
line 2116
;2116:	}
LABELV $827
line 2118
;2117:
;2118:	PM_DropTimers();
ADDRGP4 PM_DropTimers
CALLV
pop
line 2120
;2119:	//
;2120:	if ( pm->ps->powerups[PW_FLIGHT] ) {
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
CNSTI4 0
EQI4 $829
line 2122
;2121:		// flight powerup doesn't allow jump and has different friction
;2122:		PM_FlyMove();
ADDRGP4 PM_FlyMove
CALLV
pop
line 2123
;2123:	} else if (pm->ps->pm_flags & PMF_GRAPPLE_PULL) {
ADDRGP4 $830
JUMPV
LABELV $829
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $831
line 2124
;2124:		PM_GrappleMove();
ADDRGP4 PM_GrappleMove
CALLV
pop
line 2126
;2125:		// We can wiggle a bit
;2126:		PM_AirMove();
ADDRGP4 PM_AirMove
CALLV
pop
line 2127
;2127:	} else if (pm->ps->pm_flags & PMF_TIME_WATERJUMP) {
ADDRGP4 $832
JUMPV
LABELV $831
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $833
line 2128
;2128:		PM_WaterJumpMove();
ADDRGP4 PM_WaterJumpMove
CALLV
pop
line 2129
;2129:	} else if ( pm->waterlevel > 1 ) {
ADDRGP4 $834
JUMPV
LABELV $833
ADDRGP4 pm
INDIRP4
CNSTI4 204
ADDP4
INDIRI4
CNSTI4 1
LEI4 $835
line 2131
;2130:		// swimming
;2131:		PM_WaterMove();
ADDRGP4 PM_WaterMove
CALLV
pop
line 2133
;2132:	
;2133:	}
ADDRGP4 $836
JUMPV
LABELV $835
line 2134
;2134:	else if((pm->ps->stats[STAT_EXTENDED_INFO] & EXT_WALLCLIMBER) && (pm->cmd.upmove < 0))
ADDRLP4 52
ADDRGP4 pm
INDIRP4
ASGNP4
ADDRLP4 56
CNSTI4 0
ASGNI4
ADDRLP4 52
INDIRP4
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 16
BANDI4
ADDRLP4 56
INDIRI4
EQI4 $837
ADDRLP4 52
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
ADDRLP4 56
INDIRI4
GEI4 $837
line 2135
;2135:	{
line 2137
;2136:
;2137:		if(pml.groundPlane)
ADDRGP4 pml+48
INDIRI4
CNSTI4 0
EQI4 $839
line 2138
;2138:		{
line 2139
;2139:			PM_CrawlMove();
ADDRGP4 PM_CrawlMove
CALLV
pop
line 2141
;2140:			
;2141:		}
ADDRGP4 $838
JUMPV
LABELV $839
line 2143
;2142:		else
;2143:			PM_AirMove();
ADDRGP4 PM_AirMove
CALLV
pop
line 2144
;2144:	} else if ( pml.walking ) {
ADDRGP4 $838
JUMPV
LABELV $837
ADDRGP4 pml+44
INDIRI4
CNSTI4 0
EQI4 $842
line 2146
;2145:		// walking on ground
;2146:		PM_WalkMove();
ADDRGP4 PM_WalkMove
CALLV
pop
line 2147
;2147:	} else {
ADDRGP4 $843
JUMPV
LABELV $842
line 2149
;2148:		// airborne
;2149:		PM_AirMove();
ADDRGP4 PM_AirMove
CALLV
pop
line 2150
;2150:	}
LABELV $843
LABELV $838
LABELV $836
LABELV $834
LABELV $832
LABELV $830
line 2152
;2151:
;2152:	PM_Animate();
ADDRGP4 PM_Animate
CALLV
pop
line 2155
;2153:
;2154:	// set groundentity, watertype, and waterlevel
;2155:	PM_GroundTrace();
ADDRGP4 PM_GroundTrace
CALLV
pop
line 2156
;2156:	PM_SetWaterLevel();
ADDRGP4 PM_SetWaterLevel
CALLV
pop
line 2159
;2157:
;2158:	// weapons
;2159:	PM_Weapon();
ADDRGP4 PM_Weapon
CALLV
pop
line 2162
;2160:
;2161:	// torso animation
;2162:	PM_TorsoAnimation();
ADDRGP4 PM_TorsoAnimation
CALLV
pop
line 2165
;2163:
;2164:	// footstep events / legs animations
;2165:	PM_Footsteps();
ADDRGP4 PM_Footsteps
CALLV
pop
line 2168
;2166:
;2167:	// entering / leaving water splashes
;2168:	PM_WaterEvents();
ADDRGP4 PM_WaterEvents
CALLV
pop
line 2171
;2169:
;2170:	// snap some parts of playerstate to save network bandwidth
;2171:	SnapVector( pm->ps->velocity );
ADDRLP4 60
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 64
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
ADDRLP4 68
ADDRGP4 pm
INDIRP4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
CVFI4 4
CVIF4 4
ASGNF4
line 2172
;2172:}
LABELV $780
endproc PmoveSingle 72 16
export Pmove
proc Pmove 12 4
line 2182
;2173:
;2174:
;2175:/*
;2176:================
;2177:Pmove
;2178:
;2179:Can be called by either the server or the client
;2180:================
;2181:*/
;2182:void Pmove (pmove_t *pmove) {
line 2185
;2183:	int			finalTime;
;2184:
;2185:	finalTime = pmove->cmd.serverTime;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 2187
;2186:
;2187:	if ( finalTime < pmove->ps->commandTime ) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
INDIRP4
INDIRI4
GEI4 $846
line 2188
;2188:		return;	// should not happen
ADDRGP4 $845
JUMPV
LABELV $846
line 2191
;2189:	}
;2190:
;2191:	if ( finalTime > pmove->ps->commandTime + 1000 ) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
INDIRP4
INDIRI4
CNSTI4 1000
ADDI4
LEI4 $851
line 2192
;2192:		pmove->ps->commandTime = finalTime - 1000;
ADDRFP4 0
INDIRP4
INDIRP4
ADDRLP4 0
INDIRI4
CNSTI4 1000
SUBI4
ASGNI4
line 2193
;2193:	}
ADDRGP4 $851
JUMPV
LABELV $850
line 2197
;2194:
;2195:	// chop the move up if it is too long, to prevent framerate
;2196:	// dependent behavior
;2197:	while ( pmove->ps->commandTime != finalTime ) {
line 2200
;2198:		int		msec;
;2199:
;2200:		msec = finalTime - pmove->ps->commandTime;
ADDRLP4 4
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
INDIRP4
INDIRI4
SUBI4
ASGNI4
line 2202
;2201:
;2202:		if ( msec > 66 ) {
ADDRLP4 4
INDIRI4
CNSTI4 66
LEI4 $853
line 2203
;2203:			msec = 66;
ADDRLP4 4
CNSTI4 66
ASGNI4
line 2204
;2204:		}
LABELV $853
line 2205
;2205:		pmove->cmd.serverTime = pmove->ps->commandTime + msec;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 8
INDIRP4
INDIRP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDI4
ASGNI4
line 2206
;2206:		PmoveSingle( pmove );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 PmoveSingle
CALLV
pop
line 2207
;2207:	}
LABELV $851
line 2197
ADDRFP4 0
INDIRP4
INDIRP4
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $850
line 2209
;2208:
;2209:}
LABELV $845
endproc Pmove 12 4
import PM_StepSlideMove
import PM_SlideMove
bss
export pml
align 4
LABELV pml
skip 140
export pm
align 4
LABELV pm
skip 4
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $559
byte 1 37
byte 1 105
byte 1 58
byte 1 76
byte 1 97
byte 1 110
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $548
byte 1 37
byte 1 105
byte 1 58
byte 1 115
byte 1 116
byte 1 101
byte 1 101
byte 1 112
byte 1 10
byte 1 0
align 1
LABELV $537
byte 1 37
byte 1 105
byte 1 58
byte 1 107
byte 1 105
byte 1 99
byte 1 107
byte 1 111
byte 1 102
byte 1 102
byte 1 10
byte 1 0
align 1
LABELV $453
byte 1 37
byte 1 105
byte 1 58
byte 1 108
byte 1 105
byte 1 102
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $445
byte 1 37
byte 1 105
byte 1 58
byte 1 97
byte 1 108
byte 1 108
byte 1 115
byte 1 111
byte 1 108
byte 1 105
byte 1 100
byte 1 10
byte 1 0
