// Copyright (C) 1999-2000 Id Software, Inc.
//
#ifndef __UI_PUBLIC_H__
#define __UI_PUBLIC_H__

#define UI_API_VERSION	4

typedef struct {
	connstate_t		connState;
	int				connectPacketCount;
	int				clientNum;
	char			servername[MAX_STRING_CHARS];
	char			updateInfoString[MAX_STRING_CHARS];
	char			messageString[MAX_STRING_CHARS];
} uiClientState_t;

typedef enum {
	UI_ERROR,//0
	UI_PRINT,//1
	UI_MILLISECONDS,//2
	UI_CVAR_SET,//3
	UI_CVAR_VARIABLEVALUE,//4
	UI_CVAR_VARIABLESTRINGBUFFER,//5
	UI_CVAR_SETVALUE,//6
	UI_CVAR_RESET,//7
	UI_CVAR_CREATE,//8
	UI_CVAR_INFOSTRINGBUFFER,//9
	UI_ARGC,//10
	UI_ARGV,//11
	UI_CMD_EXECUTETEXT,//12
	UI_FS_FOPENFILE,//13
	UI_FS_READ,//14
	UI_FS_WRITE,//15
	UI_FS_FCLOSEFILE,//16
	UI_FS_GETFILELIST,//17
	UI_R_REGISTERMODEL,//18
	UI_R_REGISTERSKIN,//19
	UI_R_REGISTERSHADERNOMIP,//20
	UI_R_CLEARSCENE,//21
	UI_R_ADDREFENTITYTOSCENE,//22
	UI_R_ADDPOLYTOSCENE,//23
	UI_R_ADDLIGHTTOSCENE,//24
	UI_R_RENDERSCENE,//25
	UI_R_SETCOLOR,//26
	UI_R_DRAWSTRETCHPIC,//27
	UI_UPDATESCREEN,//28
	UI_CM_LERPTAG,//29
	UI_CM_LOADMODEL,//30
	UI_S_REGISTERSOUND,//31
	UI_S_STARTLOCALSOUND,//32
	UI_KEY_KEYNUMTOSTRINGBUF,//33
	UI_KEY_GETBINDINGBUF,//34
	UI_KEY_SETBINDING,//35
	UI_KEY_ISDOWN,//36
	UI_KEY_GETOVERSTRIKEMODE,//37
	UI_KEY_SETOVERSTRIKEMODE,
	UI_KEY_CLEARSTATES,
	UI_KEY_GETCATCHER,
	UI_KEY_SETCATCHER,
	UI_GETCLIPBOARDDATA,
	UI_GETGLCONFIG,
	UI_GETCLIENTSTATE,
	UI_GETCONFIGSTRING,
	UI_LAN_GETLOCALSERVERCOUNT,
	UI_LAN_GETLOCALSERVERADDRESSSTRING,
	UI_LAN_GETGLOBALSERVERCOUNT,
	UI_LAN_GETGLOBALSERVERADDRESSSTRING,
	UI_LAN_GETPINGQUEUECOUNT,
	UI_LAN_CLEARPING,
	UI_LAN_GETPING,
	UI_LAN_GETPINGINFO,
	UI_CVAR_REGISTER,
	UI_CVAR_UPDATE,
	UI_MEMORY_REMAINING,
	UI_GET_CDKEY,
	UI_SET_CDKEY,

	UI_MEMSET = 100,
	UI_MEMCPY,
	UI_STRNCPY,
	UI_SIN,
	UI_COS,
	UI_ATAN2,
	UI_SQRT,
	UI_FLOOR,
	UI_CEIL

} uiImport_t;

typedef enum {
	UIMENU_NONE,
	UIMENU_MAIN,
	UIMENU_INGAME,
	UIMENU_NEED_CD,
	UIMENU_BAD_CD_KEY
} uiMenuCommand_t;

typedef enum {
	UI_GETAPIVERSION = 0,	// system reserved

	UI_INIT,
//	void	UI_Init( void );

	UI_SHUTDOWN,
//	void	UI_Shutdown( void );

	UI_KEY_EVENT,
//	void	UI_KeyEvent( int key );

	UI_MOUSE_EVENT,
//	void	UI_MouseEvent( int dx, int dy );

	UI_REFRESH,
//	void	UI_Refresh( int time );

	UI_IS_FULLSCREEN,
//	qboolean UI_IsFullscreen( void );

	UI_SET_ACTIVE_MENU,
//	void	UI_SetActiveMenu( uiMenuCommand_t menu );

	UI_CONSOLE_COMMAND,
//	qboolean UI_ConsoleCommand( void );

	UI_DRAW_CONNECT_SCREEN
//	void	UI_DrawConnectScreen( qboolean overlay );
// if !overlay, the background will be drawn, otherwise it will be
// overlayed over whatever the cgame has drawn.
// a GetClientState syscall will be made to get the current strings
} uiExport_t;

#endif
