export Team_InitGame
code
proc Team_InitGame 4 12
file "g_team.c"
line 27
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:#include <limits.h>
;5:
;6:#include "g_local.h"
;7:
;8:typedef enum _flag_status {
;9:	FLAG_ATBASE = 0,
;10:	FLAG_TAKEN,
;11:	FLAG_DROPPED
;12:} flagStatus_t;
;13:
;14:typedef struct teamgame_s
;15:{
;16:	float last_flag_capture;
;17:	int last_capture_team;
;18:	flagStatus_t redStatus;
;19:	flagStatus_t blueStatus;
;20:} teamgame_t;
;21:
;22:teamgame_t teamgame;
;23:
;24:void Team_SetFlagStatus( int team, flagStatus_t status );
;25:
;26:void Team_InitGame(void)
;27:{
line 28
;28:	memset(&teamgame, 0, sizeof teamgame);
ADDRGP4 teamgame
ARGP4
CNSTI4 0
ARGI4
CNSTU4 16
ARGU4
ADDRGP4 memset
CALLP4
pop
line 29
;29:	teamgame.redStatus = teamgame.blueStatus = -1; // Invalid to force update
ADDRLP4 0
CNSTI4 -1
ASGNI4
ADDRGP4 teamgame+12
ADDRLP4 0
INDIRI4
ASGNI4
ADDRGP4 teamgame+8
ADDRLP4 0
INDIRI4
ASGNI4
line 31
;30:
;31:	Team_SetFlagStatus( TEAM_RED, FLAG_ATBASE );
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 32
;32:	Team_SetFlagStatus( TEAM_BLUE, FLAG_ATBASE );
CNSTI4 2
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 33
;33:}
LABELV $46
endproc Team_InitGame 4 12
export OtherTeam
proc OtherTeam 0 0
line 35
;34:
;35:int OtherTeam(int team) {
line 36
;36:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $50
line 37
;37:		return TEAM_BLUE;
CNSTI4 2
RETI4
ADDRGP4 $49
JUMPV
LABELV $50
line 38
;38:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $52
line 39
;39:		return TEAM_RED;
CNSTI4 1
RETI4
ADDRGP4 $49
JUMPV
LABELV $52
line 40
;40:	return team;
ADDRFP4 0
INDIRI4
RETI4
LABELV $49
endproc OtherTeam 0 0
export TeamName
proc TeamName 0 0
line 43
;41:}
;42:
;43:const char *TeamName(int team)  {
line 44
;44:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $55
line 45
;45:		return "RED";
ADDRGP4 $57
RETP4
ADDRGP4 $54
JUMPV
LABELV $55
line 46
;46:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $58
line 47
;47:		return "BLUE";
ADDRGP4 $60
RETP4
ADDRGP4 $54
JUMPV
LABELV $58
line 48
;48:	else if (team==TEAM_SPECTATOR)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $61
line 49
;49:		return "SPECTATOR";
ADDRGP4 $63
RETP4
ADDRGP4 $54
JUMPV
LABELV $61
line 50
;50:	return "FREE";
ADDRGP4 $64
RETP4
LABELV $54
endproc TeamName 0 0
export OtherTeamName
proc OtherTeamName 0 0
line 53
;51:}
;52:
;53:const char *OtherTeamName(int team) {
line 54
;54:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $66
line 55
;55:		return "BLUE";
ADDRGP4 $60
RETP4
ADDRGP4 $65
JUMPV
LABELV $66
line 56
;56:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $68
line 57
;57:		return "RED";
ADDRGP4 $57
RETP4
ADDRGP4 $65
JUMPV
LABELV $68
line 58
;58:	else if (team==TEAM_SPECTATOR)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $70
line 59
;59:		return "SPECTATOR";
ADDRGP4 $63
RETP4
ADDRGP4 $65
JUMPV
LABELV $70
line 60
;60:	return "FREE";
ADDRGP4 $64
RETP4
LABELV $65
endproc OtherTeamName 0 0
export TeamColorString
proc TeamColorString 0 0
line 63
;61:}
;62:
;63:const char *TeamColorString(int team) {
line 64
;64:	if (team==TEAM_RED)
ADDRFP4 0
INDIRI4
CNSTI4 1
NEI4 $73
line 65
;65:		return S_COLOR_RED;
ADDRGP4 $75
RETP4
ADDRGP4 $72
JUMPV
LABELV $73
line 66
;66:	else if (team==TEAM_BLUE)
ADDRFP4 0
INDIRI4
CNSTI4 2
NEI4 $76
line 67
;67:		return S_COLOR_BLUE;
ADDRGP4 $78
RETP4
ADDRGP4 $72
JUMPV
LABELV $76
line 68
;68:	else if (team==TEAM_SPECTATOR)
ADDRFP4 0
INDIRI4
CNSTI4 3
NEI4 $79
line 69
;69:		return S_COLOR_YELLOW;
ADDRGP4 $81
RETP4
ADDRGP4 $72
JUMPV
LABELV $79
line 70
;70:	return S_COLOR_WHITE;
ADDRGP4 $82
RETP4
LABELV $72
endproc TeamColorString 0 0
export PrintMsg
proc PrintMsg 1048 12
line 74
;71:}
;72:
;73:// NULL for everyone
;74:void QDECL PrintMsg( gentity_t *ent, const char *fmt, ... ) {
line 79
;75:	char		msg[1024];
;76:	va_list		argptr;
;77:	char		*p;
;78:	
;79:	va_start (argptr,fmt);
ADDRLP4 1028
ADDRFP4 4+4
ASGNP4
line 80
;80:	if (vsprintf (msg, fmt, argptr) > sizeof(msg)) {
ADDRLP4 4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 1032
ADDRGP4 vsprintf
CALLI4
ASGNI4
ADDRLP4 1032
INDIRI4
CVIU4 4
CNSTU4 1024
LEU4 $85
line 81
;81:		G_Error ( "PrintMsg overrun" );
ADDRGP4 $87
ARGP4
ADDRGP4 G_Error
CALLV
pop
line 82
;82:	}
LABELV $85
line 83
;83:	va_end (argptr);
ADDRLP4 1028
CNSTP4 0
ASGNP4
ADDRGP4 $89
JUMPV
LABELV $88
line 87
;84:
;85:	// double quotes are bad
;86:	while ((p = strchr(msg, '"')) != NULL)
;87:		*p = '\'';
ADDRLP4 0
INDIRP4
CNSTI1 39
ASGNI1
LABELV $89
line 86
ADDRLP4 4
ARGP4
CNSTI4 34
ARGI4
ADDRLP4 1036
ADDRGP4 strchr
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 1036
INDIRP4
ASGNP4
ADDRLP4 1036
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $88
line 89
;88:
;89:	trap_SendServerCommand ( ( (ent == NULL) ? -1 : ent-g_entities ), va("print \"%s\"", msg ));
ADDRGP4 $92
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 1044
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $93
ADDRLP4 1040
CNSTI4 -1
ASGNI4
ADDRGP4 $94
JUMPV
LABELV $93
ADDRLP4 1040
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 792
DIVI4
ASGNI4
LABELV $94
ADDRLP4 1040
INDIRI4
ARGI4
ADDRLP4 1044
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 90
;90:}
LABELV $83
endproc PrintMsg 1048 12
export OnSameTeam
proc OnSameTeam 16 0
line 97
;91:
;92:/*
;93:==============
;94:OnSameTeam
;95:==============
;96:*/
;97:qboolean OnSameTeam( gentity_t *ent1, gentity_t *ent2 ) {
line 98
;98:	if ( !ent1->client || !ent2->client ) {
ADDRLP4 0
CNSTI4 504
ASGNI4
ADDRLP4 4
CNSTU4 0
ASGNU4
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRU4
EQU4 $98
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 4
INDIRU4
NEU4 $96
LABELV $98
line 99
;99:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $95
JUMPV
LABELV $96
line 102
;100:	}
;101:
;102:	if ( g_gametype.integer < GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
GEI4 $99
line 103
;103:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $95
JUMPV
LABELV $99
line 106
;104:	}
;105:
;106:	if ( ent1->client->sess.sessionTeam == ent2->client->sess.sessionTeam ) {
ADDRLP4 8
CNSTI4 504
ASGNI4
ADDRLP4 12
CNSTI4 592
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRI4
NEI4 $102
line 107
;107:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $95
JUMPV
LABELV $102
line 110
;108:	}
;109:
;110:	return qfalse;
CNSTI4 0
RETI4
LABELV $95
endproc OnSameTeam 16 0
export Team_SetFlagStatus
proc Team_SetFlagStatus 12 8
line 114
;111:}
;112:
;113:void Team_SetFlagStatus( int team, flagStatus_t status )
;114:{
line 115
;115:	qboolean modified = qfalse;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 117
;116:
;117:	switch (team) {
ADDRLP4 4
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 1
EQI4 $107
ADDRLP4 4
INDIRI4
CNSTI4 2
EQI4 $112
ADDRGP4 $105
JUMPV
LABELV $107
line 119
;118:	case TEAM_RED :
;119:		if ( teamgame.redStatus != status ) {
ADDRGP4 teamgame+8
INDIRI4
ADDRFP4 4
INDIRI4
EQI4 $106
line 120
;120:			teamgame.redStatus = status;
ADDRGP4 teamgame+8
ADDRFP4 4
INDIRI4
ASGNI4
line 121
;121:			modified = qtrue;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 122
;122:		}
line 123
;123:		break;
ADDRGP4 $106
JUMPV
LABELV $112
line 125
;124:	case TEAM_BLUE :
;125:		if ( teamgame.blueStatus != status ) {
ADDRGP4 teamgame+12
INDIRI4
ADDRFP4 4
INDIRI4
EQI4 $106
line 126
;126:			teamgame.blueStatus = status;
ADDRGP4 teamgame+12
ADDRFP4 4
INDIRI4
ASGNI4
line 127
;127:			modified = qtrue;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 128
;128:		}
line 129
;129:		break;
LABELV $105
LABELV $106
line 132
;130:	}
;131:
;132:	if (modified) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $117
line 135
;133:		char st[4];
;134:
;135:		st[0] = '0' + (int)teamgame.redStatus;
ADDRLP4 8
ADDRGP4 teamgame+8
INDIRI4
CNSTI4 48
ADDI4
CVII1 4
ASGNI1
line 136
;136:		st[1] = '0' + (int)teamgame.blueStatus;
ADDRLP4 8+1
ADDRGP4 teamgame+12
INDIRI4
CNSTI4 48
ADDI4
CVII1 4
ASGNI1
line 137
;137:		st[2] = 0;
ADDRLP4 8+2
CNSTI1 0
ASGNI1
line 139
;138:
;139:		trap_SetConfigstring( CS_FLAGSTATUS, st );
CNSTI4 15
ARGI4
ADDRLP4 8
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 140
;140:	}
LABELV $117
line 141
;141:}
LABELV $104
endproc Team_SetFlagStatus 12 8
export Team_CheckDroppedItem
proc Team_CheckDroppedItem 4 8
line 144
;142:
;143:void Team_CheckDroppedItem( gentity_t *dropped )
;144:{
line 145
;145:	if (dropped->item->giTag == PW_REDFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 7
NEI4 $124
line 146
;146:		Team_SetFlagStatus( TEAM_RED, FLAG_DROPPED );
CNSTI4 1
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
ADDRGP4 $125
JUMPV
LABELV $124
line 147
;147:	else if (dropped->item->giTag == PW_BLUEFLAG)
ADDRFP4 0
INDIRP4
CNSTI4 784
ADDP4
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 8
NEI4 $126
line 148
;148:		Team_SetFlagStatus( TEAM_BLUE, FLAG_DROPPED );
ADDRLP4 0
CNSTI4 2
ASGNI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
LABELV $126
LABELV $125
line 149
;149:}
LABELV $123
endproc Team_CheckDroppedItem 4 8
export Team_FragBonuses
proc Team_FragBonuses 256 16
line 162
;150:
;151:
;152:/*
;153:================
;154:Team_FragBonuses
;155:
;156:Calculate the bonuses for flag defense, flag carrier defense, etc.
;157:Note that bonuses are not cumlative.  You get one, they are in importance
;158:order.
;159:================
;160:*/
;161:void Team_FragBonuses(gentity_t *targ, gentity_t *inflictor, gentity_t *attacker)
;162:{
line 167
;163:	int i;
;164:	gentity_t *ent;
;165:	int flag_pw, enemy_flag_pw;
;166:	int otherteam;
;167:	gentity_t *flag, *carrier = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
line 173
;168:	char *c;
;169:	vec3_t v1, v2;
;170:	int team;
;171:
;172:	// no bonus for fragging yourself
;173:	if (!targ->client || !attacker->client || targ == attacker)
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 64
CNSTI4 504
ASGNI4
ADDRLP4 68
CNSTU4 0
ASGNU4
ADDRLP4 60
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 68
INDIRU4
EQU4 $132
ADDRLP4 72
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 68
INDIRU4
EQU4 $132
ADDRLP4 60
INDIRP4
CVPU4 4
ADDRLP4 72
INDIRP4
CVPU4 4
NEU4 $129
LABELV $132
line 174
;174:		return;
ADDRGP4 $128
JUMPV
LABELV $129
line 176
;175:
;176:	team = targ->client->sess.sessionTeam;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 177
;177:	otherteam = OtherTeam(targ->client->sess.sessionTeam);
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 76
ADDRGP4 OtherTeam
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 76
INDIRI4
ASGNI4
line 178
;178:	if (otherteam < 0)
ADDRLP4 36
INDIRI4
CNSTI4 0
GEI4 $133
line 179
;179:		return; // whoever died isn't on a team
ADDRGP4 $128
JUMPV
LABELV $133
line 182
;180:
;181:	// same team, if the flag at base, check to he has the enemy flag
;182:	if (team == TEAM_RED) {
ADDRLP4 52
INDIRI4
CNSTI4 1
NEI4 $135
line 183
;183:		flag_pw = PW_REDFLAG;
ADDRLP4 16
CNSTI4 7
ASGNI4
line 184
;184:		enemy_flag_pw = PW_BLUEFLAG;
ADDRLP4 56
CNSTI4 8
ASGNI4
line 185
;185:	} else {
ADDRGP4 $136
JUMPV
LABELV $135
line 186
;186:		flag_pw = PW_BLUEFLAG;
ADDRLP4 16
CNSTI4 8
ASGNI4
line 187
;187:		enemy_flag_pw = PW_REDFLAG;
ADDRLP4 56
CNSTI4 7
ASGNI4
line 188
;188:	}
LABELV $136
line 191
;189:
;190:	// did the attacker frag the flag carrier?
;191:	if (targ->client->ps.powerups[enemy_flag_pw]) {
ADDRLP4 56
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $137
line 192
;192:		attacker->client->pers.teamState.lastfraggedcarrier = level.time;
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 572
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
line 193
;193:		AddScore(attacker, CTF_FRAG_CARRIER_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 194
;194:		attacker->client->pers.teamState.fragcarrier++;
ADDRLP4 80
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 552
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 195
;195:		PrintMsg(NULL, "%s" S_COLOR_WHITE " fragged %s's flag carrier!\n",
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 84
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $140
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 200
;196:			attacker->client->pers.netname, TeamName(team));
;197:
;198:		// the target had the flag, clear the hurt carrier
;199:		// field on the other team
;200:		for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $144
JUMPV
LABELV $141
line 201
;201:			ent = g_entities + i;
ADDRLP4 12
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 202
;202:			if (ent->inuse && ent->client->sess.sessionTeam == otherteam)
ADDRLP4 12
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
CNSTI4 0
EQI4 $146
ADDRLP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ADDRLP4 36
INDIRI4
NEI4 $146
line 203
;203:				ent->client->pers.teamState.lasthurtcarrier = 0;
ADDRLP4 12
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 0
ASGNF4
LABELV $146
line 204
;204:		}
LABELV $142
line 200
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $144
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $141
line 205
;205:		return;
ADDRGP4 $128
JUMPV
LABELV $137
line 208
;206:	}
;207:
;208:	if (targ->client->pers.teamState.lasthurtcarrier &&
ADDRLP4 80
CNSTI4 504
ASGNI4
ADDRLP4 84
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRP4
CNSTI4 560
ADDP4
INDIRF4
ASGNF4
ADDRLP4 84
INDIRF4
CNSTF4 0
EQF4 $148
ADDRGP4 level+32
INDIRI4
CVIF4 4
ADDRLP4 84
INDIRF4
SUBF4
CNSTF4 1174011904
GEF4 $148
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 8
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $148
line 210
;209:		level.time - targ->client->pers.teamState.lasthurtcarrier < CTF_CARRIER_DANGER_PROTECT_TIMEOUT &&
;210:		!attacker->client->ps.powerups[flag_pw]) {
line 213
;211:		// attacker is on the same team as the flag carrier and
;212:		// fragged a guy who hurt our flag carrier
;213:		AddScore(attacker, CTF_CARRIER_DANGER_PROTECT_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 215
;214:
;215:		attacker->client->pers.teamState.carrierdefense++;
ADDRLP4 88
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 544
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 216
;216:		targ->client->pers.teamState.lasthurtcarrier = 0;
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 0
ASGNF4
line 218
;217:
;218:		team = attacker->client->sess.sessionTeam;
ADDRLP4 52
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
line 219
;219:		PrintMsg(NULL, "%s" S_COLOR_WHITE " defends %s's flag carrier against an agressive enemy\n",
ADDRLP4 52
INDIRI4
ARGI4
ADDRLP4 92
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $151
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 221
;220:			attacker->client->pers.netname, TeamName(team));
;221:		return;
ADDRGP4 $128
JUMPV
LABELV $148
line 229
;222:	}
;223:
;224:	// flag and flag carrier area defense bonuses
;225:
;226:	// we have to find the flag and carrier entities
;227:
;228:	// find the flag
;229:	switch (attacker->client->sess.sessionTeam) {
ADDRLP4 88
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ASGNI4
ADDRLP4 88
INDIRI4
CNSTI4 1
EQI4 $155
ADDRLP4 88
INDIRI4
CNSTI4 2
EQI4 $157
ADDRGP4 $128
JUMPV
LABELV $155
line 231
;230:	case TEAM_RED:
;231:		c = "team_CTF_redflag";
ADDRLP4 20
ADDRGP4 $156
ASGNP4
line 232
;232:		break;
ADDRGP4 $153
JUMPV
LABELV $157
line 234
;233:	case TEAM_BLUE:
;234:		c = "team_CTF_blueflag";
ADDRLP4 20
ADDRGP4 $158
ASGNP4
line 235
;235:		break;		
line 237
;236:	default:
;237:		return;
LABELV $153
line 240
;238:	}
;239:
;240:	flag = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
ADDRGP4 $160
JUMPV
LABELV $159
line 241
;241:	while ((flag = G_Find (flag, FOFS(classname), c)) != NULL) {
line 242
;242:		if (!(flag->flags & FL_DROPPED_ITEM))
ADDRLP4 8
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
NEI4 $162
line 243
;243:			break;
ADDRGP4 $161
JUMPV
LABELV $162
line 244
;244:	}
LABELV $160
line 241
ADDRLP4 8
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 96
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 96
INDIRP4
ASGNP4
ADDRLP4 96
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $159
LABELV $161
line 246
;245:
;246:	if (!flag)
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $164
line 247
;247:		return; // can't find attacker's flag
ADDRGP4 $128
JUMPV
LABELV $164
line 250
;248:
;249:	// find attacker's team's flag carrier
;250:	for (i = 0; i < g_maxclients.integer; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $169
JUMPV
LABELV $166
line 251
;251:		carrier = g_entities + i;
ADDRLP4 0
CNSTI4 792
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 252
;252:		if (carrier->inuse && carrier->client->ps.powerups[flag_pw])
ADDRLP4 104
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
INDIRI4
ADDRLP4 104
INDIRI4
EQI4 $171
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
ADDRLP4 104
INDIRI4
EQI4 $171
line 253
;253:			break;
ADDRGP4 $168
JUMPV
LABELV $171
line 254
;254:		carrier = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
line 255
;255:	}
LABELV $167
line 250
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $169
ADDRLP4 4
INDIRI4
ADDRGP4 g_maxclients+12
INDIRI4
LTI4 $166
LABELV $168
line 260
;256:
;257:	// ok we have the attackers flag and a pointer to the carrier
;258:
;259:	// check to see if we are defending the base's flag
;260:	VectorSubtract(targ->r.currentOrigin, flag->r.currentOrigin, v1);
ADDRLP4 100
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 104
CNSTI4 476
ASGNI4
ADDRLP4 24
ADDRLP4 100
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 112
CNSTI4 480
ASGNI4
ADDRLP4 24+4
ADDRLP4 100
INDIRP4
ADDRLP4 112
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 112
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 116
CNSTI4 484
ASGNI4
ADDRLP4 24+8
ADDRFP4 0
INDIRP4
ADDRLP4 116
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 116
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 261
;261:	VectorSubtract(attacker->r.currentOrigin, flag->r.currentOrigin, v2);
ADDRLP4 120
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 124
CNSTI4 476
ASGNI4
ADDRLP4 40
ADDRLP4 120
INDIRP4
ADDRLP4 124
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 124
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 132
CNSTI4 480
ASGNI4
ADDRLP4 40+4
ADDRLP4 120
INDIRP4
ADDRLP4 132
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 132
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 136
CNSTI4 484
ASGNI4
ADDRLP4 40+8
ADDRFP4 8
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 263
;262:
;263:	if ( ( ( VectorLength(v1) < CTF_TARGET_PROTECT_RADIUS &&
ADDRLP4 24
ARGP4
ADDRLP4 140
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 140
INDIRF4
CNSTF4 1148846080
GEF4 $180
ADDRLP4 144
CNSTI4 476
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 144
INDIRI4
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ADDRLP4 144
INDIRI4
ADDP4
ARGP4
ADDRLP4 148
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 148
INDIRI4
CNSTI4 0
NEI4 $179
LABELV $180
ADDRLP4 40
ARGP4
ADDRLP4 152
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 152
INDIRF4
CNSTF4 1148846080
GEF4 $177
ADDRLP4 156
CNSTI4 476
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 156
INDIRI4
ADDP4
ARGP4
ADDRFP4 8
INDIRP4
ADDRLP4 156
INDIRI4
ADDP4
ARGP4
ADDRLP4 160
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
EQI4 $177
LABELV $179
ADDRLP4 164
CNSTI4 504
ASGNI4
ADDRLP4 168
CNSTI4 592
ASGNI4
ADDRFP4 8
INDIRP4
ADDRLP4 164
INDIRI4
ADDP4
INDIRP4
ADDRLP4 168
INDIRI4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 164
INDIRI4
ADDP4
INDIRP4
ADDRLP4 168
INDIRI4
ADDP4
INDIRI4
EQI4 $177
line 267
;264:		trap_InPVS(flag->r.currentOrigin, targ->r.currentOrigin ) ) ||
;265:		( VectorLength(v2) < CTF_TARGET_PROTECT_RADIUS &&
;266:		trap_InPVS(flag->r.currentOrigin, attacker->r.currentOrigin ) ) ) &&
;267:		attacker->client->sess.sessionTeam != targ->client->sess.sessionTeam) {
line 270
;268:
;269:		// we defended the base flag
;270:		AddScore(attacker, CTF_FLAG_DEFENSE_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 271
;271:		attacker->client->pers.teamState.basedefense++;
ADDRLP4 172
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 540
ADDP4
ASGNP4
ADDRLP4 172
INDIRP4
ADDRLP4 172
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 272
;272:		if (flag->r.svFlags & SVF_NOCLIENT) {
ADDRLP4 8
INDIRP4
CNSTI4 416
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $181
line 273
;273:			PrintMsg(NULL, "%s" S_COLOR_WHITE " defends the %s base.\n",
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $183
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 276
;274:				attacker->client->pers.netname, 
;275:				TeamName(attacker->client->sess.sessionTeam));
;276:		} else {
ADDRGP4 $128
JUMPV
LABELV $181
line 277
;277:			PrintMsg(NULL, "%s" S_COLOR_WHITE " defends the %s flag.\n",
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 176
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $184
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 176
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 280
;278:				attacker->client->pers.netname, 
;279:				TeamName(attacker->client->sess.sessionTeam));
;280:		}
line 281
;281:		return;
ADDRGP4 $128
JUMPV
LABELV $177
line 284
;282:	}
;283:
;284:	if (carrier && carrier != attacker) {
ADDRLP4 172
ADDRLP4 0
INDIRP4
CVPU4 4
ASGNU4
ADDRLP4 172
INDIRU4
CNSTU4 0
EQU4 $185
ADDRLP4 172
INDIRU4
ADDRFP4 8
INDIRP4
CVPU4 4
EQU4 $185
line 285
;285:		VectorSubtract(targ->r.currentOrigin, carrier->r.currentOrigin, v1);
ADDRLP4 176
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 180
CNSTI4 476
ASGNI4
ADDRLP4 24
ADDRLP4 176
INDIRP4
ADDRLP4 180
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 180
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 188
CNSTI4 480
ASGNI4
ADDRLP4 24+4
ADDRLP4 176
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 192
CNSTI4 484
ASGNI4
ADDRLP4 24+8
ADDRFP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 286
;286:		VectorSubtract(attacker->r.currentOrigin, carrier->r.currentOrigin, v1);
ADDRLP4 196
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 200
CNSTI4 476
ASGNI4
ADDRLP4 24
ADDRLP4 196
INDIRP4
ADDRLP4 200
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 200
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 208
CNSTI4 480
ASGNI4
ADDRLP4 24+4
ADDRLP4 196
INDIRP4
ADDRLP4 208
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 208
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 212
CNSTI4 484
ASGNI4
ADDRLP4 24+8
ADDRFP4 8
INDIRP4
ADDRLP4 212
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 212
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 288
;287:
;288:		if ( ( ( VectorLength(v1) < CTF_ATTACKER_PROTECT_RADIUS &&
ADDRLP4 24
ARGP4
ADDRLP4 216
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 216
INDIRF4
CNSTF4 1148846080
GEF4 $194
ADDRLP4 220
CNSTI4 476
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 220
INDIRI4
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ADDRLP4 220
INDIRI4
ADDP4
ARGP4
ADDRLP4 224
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 224
INDIRI4
CNSTI4 0
NEI4 $193
LABELV $194
ADDRLP4 40
ARGP4
ADDRLP4 228
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 228
INDIRF4
CNSTF4 1148846080
GEF4 $191
ADDRLP4 232
CNSTI4 476
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 232
INDIRI4
ADDP4
ARGP4
ADDRFP4 8
INDIRP4
ADDRLP4 232
INDIRI4
ADDP4
ARGP4
ADDRLP4 236
ADDRGP4 trap_InPVS
CALLI4
ASGNI4
ADDRLP4 236
INDIRI4
CNSTI4 0
EQI4 $191
LABELV $193
ADDRLP4 240
CNSTI4 504
ASGNI4
ADDRLP4 244
CNSTI4 592
ASGNI4
ADDRFP4 8
INDIRP4
ADDRLP4 240
INDIRI4
ADDP4
INDIRP4
ADDRLP4 244
INDIRI4
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
ADDRLP4 240
INDIRI4
ADDP4
INDIRP4
ADDRLP4 244
INDIRI4
ADDP4
INDIRI4
EQI4 $191
line 292
;289:			trap_InPVS(carrier->r.currentOrigin, targ->r.currentOrigin ) ) ||
;290:			( VectorLength(v2) < CTF_ATTACKER_PROTECT_RADIUS &&
;291:				trap_InPVS(carrier->r.currentOrigin, attacker->r.currentOrigin ) ) ) &&
;292:			attacker->client->sess.sessionTeam != targ->client->sess.sessionTeam) {
line 293
;293:			AddScore(attacker, CTF_CARRIER_PROTECT_BONUS);
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 AddScore
CALLV
pop
line 294
;294:			attacker->client->pers.teamState.carrierdefense++;
ADDRLP4 248
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 544
ADDP4
ASGNP4
ADDRLP4 248
INDIRP4
ADDRLP4 248
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 295
;295:			PrintMsg(NULL, "%s" S_COLOR_WHITE " defends the %s's flag carrier.\n",
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
ARGI4
ADDRLP4 252
ADDRGP4 TeamName
CALLP4
ASGNP4
CNSTP4 0
ARGP4
ADDRGP4 $195
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 484
ADDP4
ARGP4
ADDRLP4 252
INDIRP4
ARGP4
ADDRGP4 PrintMsg
CALLV
pop
line 298
;296:				attacker->client->pers.netname, 
;297:				TeamName(attacker->client->sess.sessionTeam));
;298:			return;
LABELV $191
line 300
;299:		}
;300:	}
LABELV $185
line 301
;301:}
LABELV $128
endproc Team_FragBonuses 256 16
export Team_CheckHurtCarrier
proc Team_CheckHurtCarrier 24 0
line 312
;302:
;303:/*
;304:================
;305:Team_CheckHurtCarrier
;306:
;307:Check to see if attacker hurt the flag carrier.  Needed when handing out bonuses for assistance to flag
;308:carrier defense.
;309:================
;310:*/
;311:void Team_CheckHurtCarrier(gentity_t *targ, gentity_t *attacker)
;312:{
line 315
;313:	int flag_pw;
;314:
;315:	if (!targ->client || !attacker->client)
ADDRLP4 4
CNSTI4 504
ASGNI4
ADDRLP4 8
CNSTU4 0
ASGNU4
ADDRFP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRU4
EQU4 $199
ADDRFP4 4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRU4
NEU4 $197
LABELV $199
line 316
;316:		return;
ADDRGP4 $196
JUMPV
LABELV $197
line 318
;317:
;318:	if (targ->client->sess.sessionTeam == TEAM_RED)
ADDRFP4 0
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 592
ADDP4
INDIRI4
CNSTI4 1
NEI4 $200
line 319
;319:		flag_pw = PW_BLUEFLAG;
ADDRLP4 0
CNSTI4 8
ASGNI4
ADDRGP4 $201
JUMPV
LABELV $200
line 321
;320:	else
;321:		flag_pw = PW_REDFLAG;
ADDRLP4 0
CNSTI4 7
ASGNI4
LABELV $201
line 323
;322:
;323:	if (targ->client->ps.powerups[flag_pw] &&
ADDRLP4 12
CNSTI4 504
ASGNI4
ADDRLP4 16
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 16
INDIRP4
CNSTI4 312
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $202
ADDRLP4 20
CNSTI4 592
ASGNI4
ADDRLP4 16
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
EQI4 $202
line 325
;324:		targ->client->sess.sessionTeam != attacker->client->sess.sessionTeam)
;325:		attacker->client->pers.teamState.lasthurtcarrier = level.time;
ADDRFP4 4
INDIRP4
CNSTI4 504
ADDP4
INDIRP4
CNSTI4 560
ADDP4
ADDRGP4 level+32
INDIRI4
CVIF4 4
ASGNF4
LABELV $202
line 326
;326:}
LABELV $196
endproc Team_CheckHurtCarrier 24 0
export Team_ResetFlag
proc Team_ResetFlag 20 12
line 330
;327:
;328:
;329:gentity_t *Team_ResetFlag(int team)
;330:{
line 332
;331:	char *c;
;332:	gentity_t *ent, *rent = NULL;
ADDRLP4 8
CNSTP4 0
ASGNP4
line 334
;333:
;334:	switch (team) {
ADDRLP4 12
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 1
EQI4 $208
ADDRLP4 12
INDIRI4
CNSTI4 2
EQI4 $209
ADDRGP4 $206
JUMPV
LABELV $208
line 336
;335:	case TEAM_RED:
;336:		c = "team_CTF_redflag";
ADDRLP4 4
ADDRGP4 $156
ASGNP4
line 337
;337:		break;
ADDRGP4 $207
JUMPV
LABELV $209
line 339
;338:	case TEAM_BLUE:
;339:		c = "team_CTF_blueflag";
ADDRLP4 4
ADDRGP4 $158
ASGNP4
line 340
;340:		break;
ADDRGP4 $207
JUMPV
LABELV $206
line 342
;341:	default:
;342:		return NULL;
CNSTP4 0
RETP4
ADDRGP4 $205
JUMPV
LABELV $207
line 345
;343:	}
;344:
;345:	ent = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $211
JUMPV
LABELV $210
line 346
;346:	while ((ent = G_Find (ent, FOFS(classname), c)) != NULL) {
line 347
;347:		if (ent->flags & FL_DROPPED_ITEM)
ADDRLP4 0
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $213
line 348
;348:			G_FreeEntity(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
ADDRGP4 $214
JUMPV
LABELV $213
line 349
;349:		else {
line 350
;350:			rent = ent;
ADDRLP4 8
ADDRLP4 0
INDIRP4
ASGNP4
line 351
;351:			RespawnItem(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 RespawnItem
CALLV
pop
line 352
;352:		}
LABELV $214
line 353
;353:	}
LABELV $211
line 346
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 512
ARGI4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $210
line 355
;354:
;355:	Team_SetFlagStatus( team, FLAG_ATBASE );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Team_SetFlagStatus
CALLV
pop
line 357
;356:
;357:	return rent;
ADDRLP4 8
INDIRP4
RETP4
LABELV $205
endproc Team_ResetFlag 20 12
export Team_ResetFlags
proc Team_ResetFlags 40 8
line 362
;358:}
;359:gentity_t *ReturnedPlayer;
;360:gentity_t *TossClientWeapon(gentity_t *self, int weapon);
;361:void Team_ResetFlags(void)
;362:{
line 364
;363:	char *c;
;364:	gentity_t *red = Team_ResetFlag(TEAM_RED), *blue = Team_ResetFlag(TEAM_BLUE);
CNSTI4 1
ARGI4
ADDRLP4 12
ADDRGP4 Team_ResetFlag
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 12
INDIRP4
ASGNP4
CNSTI4 2
ARGI4
ADDRLP4 16
ADDRGP4 Team_ResetFlag
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 16
INDIRP4
ASGNP4
line 366
;365:
;366:	if(ReturnedPlayer != NULL)
ADDRGP4 ReturnedPlayer
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $216
line 367
;367:		if (ReturnedPlayer->s.weapon == WP_BALL)
ADDRGP4 ReturnedPlayer
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 10
NEI4 $218
line 368
;368:		{
line 369
;369:			gentity_t *ball = TossClientWeapon(ReturnedPlayer, WP_BALL);
ADDRGP4 ReturnedPlayer
INDIRP4
ARGP4
CNSTI4 10
ARGI4
ADDRLP4 24
ADDRGP4 TossClientWeapon
CALLP4
ASGNP4
ADDRLP4 20
ADDRLP4 24
INDIRP4
ASGNP4
line 370
;370:			ReturnedPlayer = NULL;
ADDRGP4 ReturnedPlayer
CNSTP4 0
ASGNP4
line 371
;371:			ball->s.pos.trBase[0] = (red->s.origin[0] + blue->s.origin[0]) / 2;
ADDRLP4 28
CNSTI4 92
ASGNI4
ADDRLP4 20
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRF4
ADDRLP4 4
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRF4
ADDF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 372
;372:			ball->s.pos.trBase[1] = (red->s.origin[1] + blue->s.origin[1]) / 2;
ADDRLP4 32
CNSTI4 96
ASGNI4
ADDRLP4 20
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 4
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 373
;373:			ball->s.pos.trBase[2] = (red->s.origin[2] + blue->s.origin[2]) / 2;
ADDRLP4 36
CNSTI4 100
ASGNI4
ADDRLP4 20
INDIRP4
CNSTI4 32
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
ADDRLP4 4
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRF4
ADDF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 374
;374:			ball->s.pos.trDelta[0] = 0;
ADDRLP4 20
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 0
ASGNF4
line 375
;375:			ball->s.pos.trDelta[1] = 0;
ADDRLP4 20
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 0
ASGNF4
line 376
;376:			ball->s.pos.trDelta[2] = 0;
ADDRLP4 20
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 0
ASGNF4
line 377
;377:		}
LABELV $218
LABELV $216
line 378
;378:	}
LABELV $215
endproc Team_ResetFlags 40 8
export Team_ReturnFlagSound
proc Team_ReturnFlagSound 0 0
endproc Team_ReturnFlagSound 0 0
export Team_ReturnFlag
proc Team_ReturnFlag 0 0
endproc Team_ReturnFlag 0 0
export Team_FreeEntity
proc Team_FreeEntity 0 0
endproc Team_FreeEntity 0 0
export Team_DroppedFlagThink
proc Team_DroppedFlagThink 0 0
endproc Team_DroppedFlagThink 0 0
export Team_TouchOurFlag
proc Team_TouchOurFlag 0 0
endproc Team_TouchOurFlag 0 0
export Team_TouchEnemyFlag
proc Team_TouchEnemyFlag 0 0
endproc Team_TouchEnemyFlag 0 0
export Pickup_Team
proc Pickup_Team 0 0
endproc Pickup_Team 0 0
export Team_GetLocation
proc Team_GetLocation 0 0
endproc Team_GetLocation 0 0
export Team_GetLocationMsg
proc Team_GetLocationMsg 0 0
endproc Team_GetLocationMsg 0 0
export SelectRandomTeamSpawnPoint
proc SelectRandomTeamSpawnPoint 0 0
endproc SelectRandomTeamSpawnPoint 0 0
export SelectCTFSpawnPoint
proc SelectCTFSpawnPoint 0 0
endproc SelectCTFSpawnPoint 0 0
proc SortClients 0 0
endproc SortClients 0 0
export TeamplayInfoMessage
proc TeamplayInfoMessage 0 0
endproc TeamplayInfoMessage 0 0
export CheckTeamStatus
proc CheckTeamStatus 0 0
endproc CheckTeamStatus 0 0
export SP_team_CTF_redplayer
proc SP_team_CTF_redplayer 0 0
endproc SP_team_CTF_redplayer 0 0
export SP_team_CTF_blueplayer
proc SP_team_CTF_blueplayer 0 0
endproc SP_team_CTF_blueplayer 0 0
export SP_team_CTF_redspawn
proc SP_team_CTF_redspawn 0 0
endproc SP_team_CTF_redspawn 0 0
export SP_team_CTF_bluespawn
proc SP_team_CTF_bluespawn 0 0
endproc SP_team_CTF_bluespawn 0 0
import TossClientWeapon
bss
export ReturnedPlayer
align 4
LABELV ReturnedPlayer
skip 4
export teamgame
align 4
LABELV teamgame
skip 16
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_View
import trap_EA_Move
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_SelectWeapon
import trap_EA_Command
import trap_EA_Gesture
import trap_EA_DropInv
import trap_EA_UseInv
import trap_EA_DropItem
import trap_EA_UseItem
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_BotUserCommand
import trap_BotGetConsoleMessage
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_LudicrousGibs
import g_ResetScoresWhenDead
import g_GenericEnergyAmmo
import g_MissilesAddVelocity
import g_RocketVeer
import g_RocketTrack
import g_RocketAccel
import g_RocketSpeed
import g_HeadScale
import g_PlayerClasses
import g_ImpactGrenades
import g_BleedToDeath
import g_InventoryAmmo
import g_SelfDamageFactor
import g_CorpseStayTime
import g_SpawnHealthBonus
import g_OneWeaponPerPlayer
import g_allowPowerups
import g_allowArmor
import g_allowHealth
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_syncronousClients
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_needpass
import g_password
import g_friendlyFire
import g_capturelimit
import g_timelimit
import g_fraglimit
import g_dmflags
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_entities
import level
import p_class
import p_classes
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_QueueBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import Svcmd_AbortPodium_f
import SpawnModelsOnVictoryPads
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import G_RunClient
import ClientEndFrame
import ClientThink
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import FindIntermissionPoint
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import InitClientResp
import InitClientPersistant
import BeginIntermission
import respawn
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamCount
import Weapon_HookThink
import Weapon_HookFree
import CheckMeleeAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import fire_grapple
import fire_bfg
import fire_rocket
import fire_grenade
import fire_plasma
import fire_blaster
import G_RunMissile
import TossClientItems
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vectoyaw
import vtos
import tv
import G_TouchSolids
import G_TouchTriggers
import G_FreeEntity
import G_Sound
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_Find
import G_KillBox
import G_TeamCommand
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityState
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindAmmoForWeapon
import BG_FindItem
import gametype
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import g_gravity
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey
import Info_RemoveKey
import Info_ValueForKey
import va
import Swap_Init
import LittleFloat
import BigFloat
import LittleLong
import BigLong
import LittleShort
import BigShort
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import PlaneTypeForNormal
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_log2
import VectorRotate
import Vector4Scale
import VectorInverse
import VectorNormalize2
import VectorNormalizeFast
import VectorNormalize
import CrossProduct
import DistanceSquared
import Distance
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import is_wctype
import iswctype
import towlower
import towupper
import isleadbyte
import iswascii
import iswcntrl
import iswgraph
import iswprint
import iswalnum
import iswpunct
import iswspace
import iswxdigit
import iswdigit
import iswlower
import iswupper
import iswalpha
import __iscsym
import __iscsymf
import __toascii
import __isascii
import _toupper
import _tolower
import tolower
import toupper
import iscntrl
import isgraph
import isprint
import isalnum
import ispunct
import isspace
import isxdigit
import isdigit
import islower
import isupper
import isalpha
import _isctype
import _pwctype
import _pctype
import _ctype
import _wstrtime
import _wstrdate
import wcsftime
import _wctime
import _wasctime
import _setsystime
import _getsystime
import _tzset
import time
import _strtime
import _strdate
import strftime
import mktime
import localtime
import gmtime
import difftime
import clock
import ctime
import asctime
import _tzname
import _timezone
import _dstbias
import _daylight
import _sleep
import _beep
import _seterrormode
import _wsplitpath
import _wsearchenv
import _wputenv
import _wmakepath
import _wfullpath
import _swab
import _splitpath
import _searchenv
import _rotr
import _rotl
import _putenv
import _onexit
import _makepath
import _lrotr
import _lrotl
import _gcvt
import _fullpath
import _fcvt
import _exit
import _ecvt
import _wtol
import _wtoi
import _wsystem
import _wgetenv
import wcstoul
import wcstol
import wcstod
import _ultow
import _ltow
import _itow
import wcstombs
import wctomb
import _ultoa
import system
import strtoul
import strtol
import strtod
import srand
import _set_error_mode
import realloc
import rand
import qsort
import mbstowcs
import mbtowc
import _mbstrlen
import mblen
import malloc
import _ltoa
import ldiv
import _itoa
import getenv
import free
import div
import calloc
import bsearch
import atol
import atoi
import atexit
import exit
import abort
import _winminor
import _winmajor
import _winver
import _osver
import _fileinfo
import _fmode
import _wpgmptr
import _pgmptr
import _wenviron
import _environ
import __wargv
import __argv
import __argc
import _sys_nerr
import _sys_errlist
import _doserrno
import errno
import __mb_cur_max
import _wcsnicoll
import _wcsncoll
import _wcsicoll
import wcscoll
import wcsxfrm
import _wcsupr
import _wcslwr
import _wcsset
import _wcsrev
import _wcsnset
import _wcsnicmp
import _wcsicmp
import _wcsdup
import wcstok
import wcsstr
import wcsspn
import wcsrchr
import wcspbrk
import wcsncpy
import wcsncmp
import wcsncat
import wcslen
import wcscspn
import wcscpy
import wcscmp
import wcschr
import wcscat
import strxfrm
import _strupr
import strtok
import strstr
import strspn
import _strrev
import strrchr
import strpbrk
import _strnset
import strncpy
import _strnicmp
import strncmp
import strncat
import _strlwr
import strerror
import _strerror
import _strdup
import strcspn
import _strnicoll
import _strncoll
import _stricoll
import strcoll
import _stricmp
import _strcmpi
import strchr
import memmove
import _memicmp
import memchr
import _memccpy
import strlen
import strcmp
import strcat
import strcpy
import _strset
import memset
import memcmp
import memcpy
import _wtmpnam
import _wtempnam
import _wremove
import _wpopen
import _wperror
import _wfreopen
import _wfopen
import _wfdopen
import wscanf
import swscanf
import fwscanf
import vswprintf
import _vsnwprintf
import vwprintf
import vfwprintf
import swprintf
import _snwprintf
import wprintf
import fwprintf
import _putws
import _getws
import fputws
import fgetws
import ungetwc
import putwchar
import putwc
import getwchar
import getwc
import _fputwchar
import fputwc
import _fgetwchar
import fgetwc
import _wfsopen
import vsprintf
import _vsnprintf
import vprintf
import vfprintf
import _unlink
import ungetc
import tmpnam
import tmpfile
import _tempnam
import sscanf
import sprintf
import _snprintf
import setvbuf
import _setmaxstdio
import setbuf
import scanf
import _rmtmp
import rewind
import rename
import remove
import _putw
import puts
import putchar
import putc
import printf
import _popen
import _pclose
import perror
import _getw
import gets
import _getmaxstdio
import getchar
import getc
import fwrite
import ftell
import fseek
import fsetpos
import fscanf
import freopen
import fread
import fputs
import _fputchar
import fputc
import fprintf
import fopen
import _flushall
import _fileno
import fgets
import fgetpos
import _fgetchar
import fgetc
import fflush
import ferror
import feof
import _fdopen
import _fcloseall
import fclose
import clearerr
import _fsopen
import _flsbuf
import _filbuf
import _iob
import _yn
import _y1
import _y0
import modf
import _matherr
import ldexp
import _jn
import _j1
import _j0
import _hypot
import frexp
import floor
import ceil
import _cabs
import atof
import sqrt
import tanh
import tan
import sinh
import sin
import pow
import log10
import log
import labs
import fmod
import fabs
import exp
import cosh
import cos
import atan2
import atan
import asin
import acos
import abs
import _HUGE
import _assert
lit
align 1
LABELV $395
byte 1 116
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 32
byte 1 37
byte 1 105
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $391
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $353
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $350
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $347
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $344
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $338
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $337
byte 1 37
byte 1 99
byte 1 37
byte 1 99
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $310
byte 1 68
byte 1 111
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 32
byte 1 119
byte 1 104
byte 1 97
byte 1 116
byte 1 32
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 111
byte 1 110
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $301
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 103
byte 1 111
byte 1 116
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $296
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 100
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $291
byte 1 83
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 63
byte 1 0
align 1
LABELV $286
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 103
byte 1 101
byte 1 116
byte 1 115
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 115
byte 1 115
byte 1 105
byte 1 115
byte 1 116
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $282
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 103
byte 1 101
byte 1 116
byte 1 115
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 115
byte 1 115
byte 1 105
byte 1 115
byte 1 116
byte 1 32
byte 1 102
byte 1 111
byte 1 114
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $262
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 99
byte 1 97
byte 1 112
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $261
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 99
byte 1 97
byte 1 112
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $257
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 99
byte 1 97
byte 1 112
byte 1 116
byte 1 117
byte 1 114
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $253
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 98
byte 1 97
byte 1 108
byte 1 108
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $246
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $230
byte 1 84
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 104
byte 1 97
byte 1 115
byte 1 32
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 101
byte 1 100
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $225
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 116
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $224
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 47
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 116
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $223
byte 1 87
byte 1 97
byte 1 114
byte 1 110
byte 1 105
byte 1 110
byte 1 103
byte 1 58
byte 1 32
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 112
byte 1 97
byte 1 115
byte 1 115
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 82
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 83
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $195
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 39
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $184
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $183
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 116
byte 1 104
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 98
byte 1 97
byte 1 115
byte 1 101
byte 1 46
byte 1 10
byte 1 0
align 1
LABELV $158
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $156
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 67
byte 1 84
byte 1 70
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $151
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 39
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 32
byte 1 97
byte 1 103
byte 1 97
byte 1 105
byte 1 110
byte 1 115
byte 1 116
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 103
byte 1 114
byte 1 101
byte 1 115
byte 1 115
byte 1 105
byte 1 118
byte 1 101
byte 1 32
byte 1 101
byte 1 110
byte 1 101
byte 1 109
byte 1 121
byte 1 10
byte 1 0
align 1
LABELV $140
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 102
byte 1 114
byte 1 97
byte 1 103
byte 1 103
byte 1 101
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 39
byte 1 115
byte 1 32
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 32
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $92
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 34
byte 1 0
align 1
LABELV $87
byte 1 80
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 77
byte 1 115
byte 1 103
byte 1 32
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 114
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $82
byte 1 94
byte 1 55
byte 1 0
align 1
LABELV $81
byte 1 94
byte 1 51
byte 1 0
align 1
LABELV $78
byte 1 94
byte 1 52
byte 1 0
align 1
LABELV $75
byte 1 94
byte 1 49
byte 1 0
align 1
LABELV $64
byte 1 70
byte 1 82
byte 1 69
byte 1 69
byte 1 0
align 1
LABELV $63
byte 1 83
byte 1 80
byte 1 69
byte 1 67
byte 1 84
byte 1 65
byte 1 84
byte 1 79
byte 1 82
byte 1 0
align 1
LABELV $60
byte 1 66
byte 1 76
byte 1 85
byte 1 69
byte 1 0
align 1
LABELV $57
byte 1 82
byte 1 69
byte 1 68
byte 1 0
