// Copyright (C) 1999-2000 Id Software, Inc.
//
// bg_public.h -- definitions shared by both the server game and client game modules

// because games can change separately from the main system version, we need a
// second version that must match between game and cgame

#define	GAME_VERSION		"Quake-Fu 0.4.5b"

#define	DEFAULT_GRAVITY		(g_gravity.value)
extern	vmCvar_t		g_gravity;
extern	vmCvar_t		g_HasteFactor;

#define	GIB_HEALTH			-40
#define	ARMOR_PROTECTION	0.66

#define	MAX_ITEMS			256

#define	RANK_TIED_FLAG		0x4000

#define DEFAULT_SHOTGUN_SPREAD	800//700
#define DEFAULT_SHOTGUN_COUNT	15//11
#define	DEFAULT_SHOTGUN_DAMAGE	6//10

#define DEFAULT_ROCKET_DAMAGE	250
#define DEFAULT_ROCKET_DURATION	900
#define DEFAULT_ROCKET_RADIUS	128

#define DEFAULT_GRENADE_DAMAGE	125
#define DEFAULT_GRENADE_DURATION	600
#define DEFAULT_GRENADE_RADIUS	200

#define	ITEM_RADIUS			15		// item sizes are needed for client side pickup detection

#define	LIGHTNING_RANGE		1024
#define	FLAMETHROWER_RANGE	144

#define ROCKET_SPEED		150
#define ROCKET_ACCEL		6000
#define ROCKET_VEER			5


#define	SCORE_NOT_PRESENT	-9999	// for the CS_SCORES[12] when only one player is present

#define	VOTE_TIME			30000	// 30 seconds before vote times out

#define	MINS_Z				-24
#define	DEFAULT_VIEWHEIGHT	26
#define CROUCH_VIEWHEIGHT	12
#define	DEAD_VIEWHEIGHT		-16

//
// config strings are a general means of communicating variable length strings
// from the server to all connected clients.
//

// CS_SERVERINFO and CS_SYSTEMINFO are defined in q_shared.h
#define	CS_MUSIC			2
#define	CS_MESSAGE			3		// from the map worldspawn's message field
#define	CS_MOTD				4		// g_motd string for server message of the day
#define	CS_WARMUP			5		// server time when the match will be restarted
#define	CS_SCORES1			6
#define	CS_SCORES2			7
#define CS_VOTE_TIME		8
#define CS_VOTE_STRING		9
#define	CS_VOTE_YES			10
#define	CS_VOTE_NO			11
#define	CS_GAME_VERSION		12
#define	CS_LEVEL_START_TIME	13		// so the timer only shows the current level
#define	CS_INTERMISSION		14		// when 1, fraglimit/timelimit has been hit and intermission will start in a second or two
#define CS_FLAGSTATUS		15		// string indicating flag status in CTF


#define	CS_ITEMS			27		// string of 0's and 1's that tell which items are present
#define CS_CORPSES			28

#define CS_MODELS			32
#define	CS_SOUNDS			(CS_MODELS+MAX_MODELS)
#define	CS_PLAYERS			(CS_SOUNDS+MAX_SOUNDS)
#define CS_LOCATIONS		(CS_PLAYERS+MAX_CLIENTS)
#define CS_MAX				(CS_LOCATIONS+MAX_LOCATIONS)

#if (CS_MAX) > MAX_CONFIGSTRINGS
#error overflow: (CS_MAX) > MAX_CONFIGSTRINGS
#endif


#define	CS_CORPSESTRINGS	(CI_MODELS - CI_CORPSES)


typedef enum {
	GT_FFA,				// free for all
	GT_TOURNAMENT,		// one on one tournament
	GT_SINGLE_PLAYER,	// single player tournament

	//-- team games go after this --

	GT_TEAM,			// team deathmatch
	GT_CTF,				// capture the flag
	GT_RUGBY,			// rugby

	GT_MAX_GAME_TYPE
} gametype_t;

typedef enum { GENDER_MALE, GENDER_FEMALE, GENDER_NEUTER } gender_t;

/*
===================================================================================

PMOVE MODULE

The pmove code takes a player_state_t and a usercmd_t and generates a new player_state_t
and some other output data.  Used for local prediction on the client game and true
movement on the server game.
===================================================================================
*/

typedef enum {
	PM_NORMAL,		// can accelerate and turn
	PM_NOCLIP,		// noclip movement
	PM_SPECTATOR,	// still run into walls
	PM_DEAD,		// no acceleration or turning, but free falling
	PM_FREEZE,		// stuck in place with no control
	PM_INTERMISSION	// no movement or status bar
} pmtype_t;

typedef enum {
	WEAPON_READY, 
	WEAPON_RAISING,
	WEAPON_DROPPING,
	WEAPON_FIRING
} weaponstate_t;

typedef enum {
	BG_PRINT,
	BG_ERROR,
	BG_MILLISECONDS,
	BG_CVAR_REGISTER,
	BG_CVAR_UPDATE,
	BG_CVAR_SET,
	BG_CVAR_VARIABLESTRINGBUFFER,
	BG_ARGC,
	BG_ARGV,
	BG_ARGS,
	BG_FS_FOPENFILE,
	BG_FS_READ,
	BG_FS_WRITE,
	BG_FS_FCLOSEFILE,
} bgameImport_t;
// pmove->pm_flags
#define	PMF_DUCKED			1		// holding the duck button
#define	PMF_JUMP_HELD		2		// holding the jump button
#define	PMF_BACKWARDS_JUMP	8		// go into backwards land
#define	PMF_BACKWARDS_RUN	16		// coast down to backwards run
#define	PMF_TIME_LAND		32		// pm_time is time before rejump
#define	PMF_TIME_KNOCKBACK	64		// pm_time is an air-accelerate only time
#define	PMF_TIME_WATERJUMP	256		// pm_time is waterjump
#define	PMF_RESPAWNED		512		// clear after attack and jump buttons come up
#define	PMF_USE_ITEM_HELD	1024	// holding the use button
#define PMF_GRAPPLE_PULL	2048	// pull towards grapple location
#define PMF_FOLLOW			4096	// spectate following another player
#define PMF_SCOREBOARD		8192	// spectate as a scoreboard
#define	PMF_FIRE_HELD		16384	// fire button held
#define	PMF_ALL_TIMES	(PMF_TIME_WATERJUMP|PMF_TIME_LAND|PMF_TIME_KNOCKBACK)

#define	MAXTOUCH	32
typedef struct {
	// state (in / out)
	playerState_t	*ps;

	// command (in)
	usercmd_t	cmd;
	int			tracemask;			// collide against these types of surfaces
	int			debugLevel;			// if set, diagnostic output will be printed
	qboolean	noFootsteps;		// if the game is setup for no footsteps by the server
	qboolean	gauntletHit;		// true if a gauntlet attack would actually hit something

	// results (out)
	int			numtouch;
	int			touchents[MAXTOUCH];

//	vec3_t		MuzzlePoint, ViewPoint;
	vec3_t		mins, maxs;			// bounding box size

	int			watertype;
	int			waterlevel;

	float		xyspeed;

	// callbacks to test the world
	// these will be different functions during game and cgame
	void		(*trace)( trace_t *results, const vec3_t start, const vec3_t mins, const vec3_t maxs, const vec3_t end, int passEntityNum, int contentMask );
	int			(*pointcontents)( const vec3_t point, int passEntityNum );
} pmove_t;

// if a full pmove isn't done on the client, you can just update the angles
void PM_UpdateViewAngles( playerState_t *ps, const usercmd_t *cmd );
void Pmove (pmove_t *pmove);

//===================================================================================


// player_state->stats[] indexes
typedef enum {
	STAT_HEALTH,
	STAT_LEG_DAMAGE,				// leg damage - the more you get, the slower you go (low health compounds this)
	STAT_HEAD_DAMAGE,				// head damage - the more you get, the more wobbly your vision gets
	STAT_BLEEDING,					// how badly we're bleeding
	STAT_FATIGUE,					// how tired we are
	STAT_ARMOR,						// % of damage saved by armor
	STAT_JUMPSCALE,					// from player class - needed for client-side prediction of jump height
	STAT_JUMP_PAUSE,				// from player class - needed for client-side prediction of jump height
	STAT_MASS,						// mass - from player class
	STAT_STRENGTH,					// strength - from player class
	STAT_EXTENDED_INFO,				// various server-required info, mostly playerclass stuff
	STAT_DEAD_YAW,					// look this direction when dead (FIXME: get rid of?)
	STAT_CLIENTS_READY				// bit mask of clients wishing to exit the intermission (FIXME: configstring?)
	
} statIndex_t;

#define MAX_HEALTH				100

#define	EXT_WALLCLIMBER			0x00000020 // Special player class - can climb up walls/ceiling
#define EXT_USING_INVENTORY		0x00001000 // special command to use inventory as ammo/weapon.

// player_state->persistant[] indexes
// these fields are the only part of player_state that isn't
// cleared on respawn
typedef enum {
	PERS_SCORE,						// !!! MUST NOT CHANGE, SERVER AND GAME BOTH REFERENCE !!!
	PERS_HITS,						// total points damage inflicted so damage beeps can sound on change
	PERS_RANK,				
	PERS_TEAM,				
	PERS_SPAWN_COUNT,				// incremented every respawn
	PERS_REWARD_COUNT,				// incremented for each reward sound
	PERS_REWARD,					// a reward_t
	PERS_ATTACKER,					// clientnum of last damage inflicter
	PERS_KILLED,					// count of the number of times you died
	// these were added for single player awards tracking
	PERS_IMPRESSIVE_COUNT,
	PERS_EXCELLENT_COUNT,
	PERS_GAUNTLET_FRAG_COUNT,
	PERS_ACCURACY_SHOTS,
	PERS_ACCURACY_HITS,
	PERS_HEAD_HITS
} persEnum_t;


// entityState_t->eFlags
#define	EF_DEAD				0x00000001		// don't draw a foe marker over players with EF_DEAD
#define	EF_TELEPORT_BIT		0x00000004		// toggled every time the origin abruptly changes
#define	EF_AWARD_EXCELLENT	0x00000008		// draw an excellent sprite
#define	EF_BOUNCE			0x00000010		// for missiles
#define	EF_BOUNCE_HALF		0x00000020		// for missiles
#define	EF_AWARD_GAUNTLET	0x00000040		// draw a gauntlet sprite
#define	EF_NODRAW			0x00000080		// may have an event, but no model (unspawned items)
#define	EF_FIRING			0x00000100		// for lightning gun
#define	EF_MOVER_STOP		0x00000400		// will push otherwise
#define	EF_TALK				0x00001000		// draw a talk balloon
#define	EF_CONNECTION		0x00002000		// draw a connection trouble sprite
#define	EF_AWARD_HEADSHOT	0x00004000		// draw a decapitation sprite
#define	EF_AWARD_IMPRESSIVE	0x00008000		// draw an impressive sprite


#define AMMO_CURRENT 0
//AMMO_SHELLS is still 1
#define AMMO_ITEM1	 2
#define AMMO_QTY_1	 3
#define AMMO_ITEM2	 4
#define AMMO_QTY_2	 5
#define AMMO_ITEM3	 6
#define AMMO_QTY_3	 7
#define AMMO_ITEM4	 8
#define AMMO_QTY_4	 9
#define AMMO_ITEM5	10
#define AMMO_QTY_5	11
#define AMMO_ITEM6	12
#define AMMO_QTY_6	13
#define AMMO_ITEM7	14 // this is AMMO_ITEM_BIG
#define AMMO_QTY_7	15
#define AMMO_ITEMS	16
#define AMMO_ITEM_BIG  (AMMO_ITEMS - 2)

typedef enum {
	AMMO_NONE,
	AMMO_SHELLS,
	AMMO_BULLETS,
	AMMO_GRENADES,
	AMMO_ROCKETS,
	AMMO_CELLS,
	AMMO_SLUGS,
	AMMO_NAPALM,
	AMMO_NUM_AMMO

} ammo_t;

typedef enum {
	WPM_NONE = 0,
	WPM_AT_HIP,
	WPM_ONE_HANDED,
	WPM_NUM_POSES,

	WPM_RELOAD = 7,
	WPM_SWITCH,
	WPM_DROP,
	WPM_NUM_WEAPONMODES
} weaponmode_t;

typedef enum {
	HEALTH_NORMAL,
	HEALTH_AMPHETAMINE,
	HEALTH_NUM_HEALTHTYPES
} health_t;
typedef enum {
	PW_NONE,

	PW_QUAD,
	PW_BATTLESUIT,
	PW_HASTE,
	PW_INVIS,
	PW_REGEN,
	PW_FLIGHT,
	PW_BERZERK,
	PW_NUM_POWERUPS,
	PW_ARMOR,	// these aren't powerups, but get used as powerup bitflags in entityState_t 
	PW_REDFLAG,
	PW_BLUEFLAG,
	PW_BALL,
	
} powerup_t;

typedef enum {
	WP_NONE,

	WP_SWORD,
	WP_GAUNTLET,
	WP_SINGLE_SHOTGUN,
	WP_SHOTGUN,
	WP_MACHINEGUN,
	WP_CHAINGUN,
	WP_GRENADE_LAUNCHER,
	WP_ROCKET_LAUNCHER,
	WP_PLASMAGUN,
	WP_RAILGUN,
	WP_FLAMETHROWER,
	WP_LIGHTNING,
	WP_HAND_GRENADE, 
	
	WP_REDFLAG,
	WP_BLUEFLAG,
	WP_BALL,

	WP_NUM_WEAPONS
} weapon_t;

// reward sounds
typedef enum {
	REWARD_BAD,

	REWARD_IMPRESSIVE,
	REWARD_EXCELLENT,
	REWARD_DENIED,
	REWARD_GAUNTLET
} reward_t;


// entityState_t->event values
// entity events are for effects that take place reletive
// to an existing entities origin.  Very network efficient.

// two bits at the top of the entityState->event field
// will be incremented with each change in the event so
// that an identical event started twice in a row can
// be distinguished.  And off the value with ~EV_EVENT_BITS
// to retrieve the actual event number
#define	EV_EVENT_BIT1		0x00000100
#define	EV_EVENT_BIT2		0x00000200
#define	EV_EVENT_BITS		(EV_EVENT_BIT1|EV_EVENT_BIT2)

typedef enum {
	EV_NONE,

	EV_FOOTSTEP,
	EV_FOOTSTEP_METAL,
	EV_FOOTSPLASH,
	EV_FOOTWADE,
	EV_SWIM,

	EV_STEP_4,
	EV_STEP_8,
	EV_STEP_12,
	EV_STEP_16,

	EV_FALL_SHORT,
	EV_FALL_MEDIUM,
	EV_FALL_FAR,

	EV_JUMP_PAD,	// boing sound at origin, jump sound on player

	EV_JUMP,
	EV_WATER_TOUCH,	// foot touches
	EV_WATER_LEAVE,	// foot leaves
	EV_WATER_UNDER,	// head touches
	EV_WATER_CLEAR,	// head leaves

	EV_ITEM_PICKUP,			// normal item pickups are predictable
	EV_GLOBAL_ITEM_PICKUP,	// powerup / team sounds are broadcast to everyone

	EV_NOAMMO,
	EV_RELOAD,
	EV_CHANGE_WEAPON,
	EV_CHANGE_STANCE,
	EV_DROP_WEAPON,
	EV_FIRE_WEAPON,
	EV_FIRE_WEAPON_FROMITEM,	
	
	EV_USE_BERZERK,

	EV_ITEM_RESPAWN,
	EV_ITEM_POP,
	EV_PLAYER_TELEPORT_IN,
	EV_PLAYER_TELEPORT_OUT,

	EV_GRENADE_BOUNCE,		// eventParm will be the soundindex

	EV_GENERAL_SOUND,
	EV_GLOBAL_SOUND,		// no attenuation

	EV_MISSILE_HIT,
	EV_MISSILE_HIT_ROBOT,
	EV_MISSILE_MISS,
	EV_RAILTRAIL,
	EV_SHOTGUN,
	EV_BULLET,				// otherEntity is the shooter

	EV_BLOOD,
	EV_BLOOD_SPURT,
	EV_ONFIRE,
	EV_PAIN,	
	EV_DEATH1,
	EV_DEATH2,
	EV_DEATH3,
	EV_HEAD_EXPLODEY1,
	EV_HEAD_EXPLODEY2,
	EV_HEAD_EXPLODEY3,
	EV_OBITUARY,

	EV_POWERUP_QUAD,
	EV_POWERUP_BATTLESUIT,
	EV_POWERUP_REGEN,
	EV_POWERUP_FLIGHT,

	EV_GIB_PLAYER,			// gib a previously living fleshy player
	EV_GIB_NOBLOOD,			// gib a previously living robot player
	EV_SPAWN_CORPSE,		// copy a client to the body que

	EV_DEBUG_LINE,
	EV_TAUNT
	
} entity_event_t;

extern char *animNames[];
// animations
typedef enum {
	BOTH_DEATH1,//0
	BOTH_DEAD1,//1
	BOTH_DEATH2,//2 
	BOTH_DEAD2,//3
	BOTH_DEATH3,//4
	BOTH_DEAD3,//5

	TORSO_GESTURE,//6

	TORSO_ATTACK,//7
	TORSO_ATTACK2,//8

	TORSO_DROP,//9
	TORSO_RAISE,//10

	TORSO_STAND,//11
	TORSO_STAND2,//12

	LEGS_WALKCR,//13
	LEGS_WALK,//14
	LEGS_RUN,//15
	LEGS_BACK,//16
	LEGS_SWIM,//17

	LEGS_JUMP,//18
	LEGS_LAND,//19

	LEGS_JUMPB,//20
	LEGS_LANDB,//21

	LEGS_IDLE,//22
	LEGS_IDLECR,//23

	LEGS_TURN,//24

	MAX_ANIMATIONS
} animNumber_t;
#define DEATH_ANIMATIONS	TORSO_GESTURE
#define TORSO_ANIMATIONS	LEGS_WALKCR

typedef struct animation_s {
	int		firstFrame;
	int		numFrames;
	int		loopFrames;			// 0 to numFrames
	int		frameLerp;			// msec between frames
	int		initialLerp;		// msec to get to first frame
} animation_t;


typedef struct tag_s {	
	char				origin[3];		// normalized origin
	char				dir;			// this is a bytedir
} tag_t;

typedef struct animation_frame_s {	
	int					frame;
	char				time;			// if you need a time of > 255, duplicate a frame.
	tag_t				tag[4];			// if you need more than 4 tags, subdivide your model.
} animation_frame_t;

typedef struct animation_data_s {
	char				frames;			// how many frames are in this animation
	char				loop;			// which frame index to go to when the last frame is reached [negative means start a new anim sequence]
	animation_frame_t	frame[32];		// the frame data for each frame
} animation_data_t;

typedef enum {
	BONE_LINKDIR,
	BONE_VIEWDIR,
	NUM_BONES
} bone_t;

typedef struct submodel_s {
	char				parent;			// this is the sub-model that this model links to.
	char				linktag;		// this is the tag index of the parent sub-model
	float				boneweights[8];	// the weights of each bone 
	char				boundsize;		// bounding bubble for hit detection	
	char				animations;		// how many animation sequences this sub-model has
	char				tags;			// how many tags this sub-model has
	animation_data_t	animation[128];	// FIXME: maximum 128 animations?
} submodel_t;

typedef struct playermodel_info_s {
	char				models;
	submodel_t			model[16];
} playermodel_info_t;

// flip the togglebit every time an animation
// changes so a restart of the same anim can be detected
#define	ANIM_CLIMBWALLS		64
#define	ANIM_TOGGLEBIT		128


typedef enum {
	TEAM_FREE,
	TEAM_RED,
	TEAM_BLUE,
	TEAM_SPECTATOR,

	TEAM_NUM_TEAMS
} team_t;

// Time between location updates
#define TEAM_LOCATION_UPDATE_TIME		1000

// How many players on the overlay
#define TEAM_MAXOVERLAY		8

// means of death
typedef enum {
	MOD_UNKNOWN,
	MOD_SHOTGUN,
	MOD_GAUNTLET,
	MOD_MACHINEGUN,
	MOD_GRENADE,
	MOD_GRENADE_SPLASH,
	MOD_ROCKET,
	MOD_ROCKET_SPLASH,
	MOD_PLASMA,
	MOD_PLASMA_SPLASH,
	MOD_RAILGUN,
	MOD_LIGHTNING,
	MOD_FLAMETHROWER,
	MOD_CHAINGUN,
	MOD_WATER,
	MOD_SLIME,
	MOD_LAVA,
	MOD_CRUSH,
	MOD_TELEFRAG,
	MOD_FALLING,
	MOD_SUICIDE,
	MOD_TARGET_LASER,
	MOD_TRIGGER_HURT,
	MOD_PUNCH,
	MOD_BLEED,
	MOD_BERZERK,
	MOD_SWORD,
	MOD_PENALTY
} meansOfDeath_t;


//---------------------------------------------------------

// ## HENTAI ##
// gitem_t->type
typedef enum {
	IT_BAD,
	IT_WEAPON,
	IT_AMMO,
	IT_ARMOR,
	IT_HEALTH,
	IT_POWERUP,
	IT_HOLDABLE
} itemType_t;
// ## HENTAI ##

#define MAX_ITEM_MODELS 4

typedef struct gweapon_s {
		
	int		max_ammo;	
} gweapon_t;

typedef struct gitem_s {
	char		*classname;	// spawning name
	char		*pickup_sound;
	char		*world_model[MAX_ITEM_MODELS];

	char		*icon;
	char		*pickup_name;	// for printing on pickup

	int			quantity;		// for weapons capacity, for ammo how much, for powerups duration
	itemType_t  giType;			// IT_* flags
	int			giTag;
	int			giUses;
	
	float		mass;

	char		*precaches;		// string of all models and images this item will use
	char		*sounds;		// string of all sounds this item will use
} gitem_t;

// included in both the game dll and the client
extern	gitem_t	bg_itemlist[];
extern	int		bg_numItems;
extern	int		gametype;

gitem_t	*BG_FindItem( const char *pickupName );
gitem_t	*BG_FindAmmoForWeapon( weapon_t weapon );
gitem_t	*BG_FindItemForWeapon( weapon_t weapon );
gitem_t	*BG_FindItemForPowerup( powerup_t pw );
#define	ITEM_INDEX(x) ((x)-bg_itemlist)

qboolean	BG_CanItemBeGrabbed( const entityState_t *ent, const playerState_t *ps );


// g_dmflags->integer flags
#define	DF_NO_FALLING			8
#define DF_FIXED_FOV			16
#define	DF_NO_FOOTSTEPS			32

// content masks
#define	MASK_ALL				(-1)
#define	MASK_SOLID				(CONTENTS_SOLID)
#define	MASK_PLAYERSOLID		(CONTENTS_SOLID|CONTENTS_PLAYERCLIP|CONTENTS_BODY)
#define	MASK_DEADSOLID			(CONTENTS_SOLID|CONTENTS_PLAYERCLIP)
#define	MASK_WATER				(CONTENTS_WATER|CONTENTS_LAVA|CONTENTS_SLIME)
#define	MASK_OPAQUE				(CONTENTS_SOLID|CONTENTS_SLIME|CONTENTS_LAVA)
#define	MASK_SHOT				(CONTENTS_SOLID|CONTENTS_BODY|CONTENTS_CORPSE)


//
// entityState_t->eType
//
typedef enum {
	ET_GENERAL,
	ET_PLAYER,
	ET_ITEM,
	ET_MISSILE,
	ET_MOVER,
	ET_BEAM,
	ET_PORTAL,
	ET_SPEAKER,
	ET_PUSH_TRIGGER,
	ET_TELEPORT_TRIGGER,
	ET_INVISIBLE,
	ET_GRAPPLE,				// grapple hooked on wall
	ET_CORPSE,

	ET_EVENTS				// any of the EV_* events can be added freestanding
							// by setting eType to ET_EVENTS + eventNum
							// this avoids having to set eFlags and eventNum
} entityType_t;

typedef struct playerclass_s
{
	char		name[32];
	float		speed;
	float		crouchspeed;
	float		jumpspeed;
	float		jumppause;
	float		jumpfactor;
	float		jumpgravity;
	float		head_dmgfactor;
	float		torso_dmgfactor;
	float		legs_dmgfactor;
	float		headsize;
	float		waistsize;
	int			mass;	
	int			strength;
	qboolean	bleeds;
	qboolean	wallclimber;
	vec3_t		crouch;
	vec3_t		stand;
	vec3_t		walk;
	vec3_t		run;
	vec3_t		jump;
	vec3_t		head;
	vec3_t		gun;
	animation_t		animations[MAX_ANIMATIONS];
	vec3_t		tag_head[256];
	vec3_t		tag_torso[256];
	vec3_t		tag_weapon[256];
} playerclass_t;
#define MAX_PCLASSES	256
extern int				p_classes;
extern playerclass_t	p_class[MAX_PCLASSES];

// filesystem access
// returns length of file
int			trap_FS_FOpenFile( const char *qpath, fileHandle_t *f, fsMode_t mode );
void		trap_FS_Read( void *buffer, int len, fileHandle_t f );
void		trap_FS_Write( const void *buffer, int len, fileHandle_t f );
void		trap_FS_FCloseFile( fileHandle_t f );
void trap_GetConfigstring(int index, char *buffer, int bufferSize);

void	BG_EvaluateTrajectory( const trajectory_t *tr, int atTime, vec3_t result );
void	BG_EvaluateTrajectoryDelta( const trajectory_t *tr, int atTime, vec3_t result );

void	BG_AddPredictableEventToPlayerstate( int newEvent, int eventParm, playerState_t *ps );

void	BG_PlayerStateToEntityState( playerState_t *ps, entityState_t *s, int time, qboolean snap );

qboolean	BG_PlayerTouchesItem( playerState_t *ps, entityState_t *item, int atTime );

char *BG_GetCorpseModel(int index);

qboolean BG_ParseClass(const char *skinname, playerclass_t *pclass);
int BG_PlayerClass(char *model);

float BG_PlayerAngles(int playerclass, int legsFrame, int torsoFrame, vec3_t viewangles, vec3_t velocity, vec3_t muzzle, vec3_t headpoint ) ;

#define ARENAS_PER_TIER		4
#define MAX_ARENAS			1024
#define	MAX_ARENAS_TEXT		8192

#define MAX_BOTS			1024
#define MAX_BOTS_TEXT		8192
