#include "g_local.h"
#include "m_player.h"

qboolean	Pickup_Weapon (edict_t *ent, edict_t *other);
int			Use_Weapon (edict_t *ent, gitem_t *inv);

int			Use_Nothing (edict_t *ent, gitem_t *inv)
{
	gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
	return 0;
}
void		Drop_Weapon (edict_t *ent, gitem_t *inv);
int 		Use_Health (edict_t *ent, gitem_t *inv);

qboolean	CheckEncumbrance(edict_t *ent, float bulk);

void CalcMass(edict_t *ent);
#define GRENADES_WEIGHT	1.5
#define SHELLS_WEIGHT	0.1
#define BULLETS_WEIGHT	0.02
#define SLUGS_WEIGHT	0.3
#define ROCKETS_WEIGHT	3.5
#define NAPALM_WEIGHT	0.01

void Weapon_Punch (edict_t *ent);
void Weapon_Claws (edict_t *ent);
void Weapon_FaerieWand (edict_t *ent);
void Weapon_Lightning (edict_t *ent);
void Weapon_Blaster (edict_t *ent);
void Weapon_Shotgun (edict_t *ent);
void Weapon_SuperShotgun (edict_t *ent);
void Weapon_Machinegun (edict_t *ent);
void Weapon_Chaingun (edict_t *ent);
void Weapon_Flamethrower (edict_t *ent);
void Weapon_HyperBlaster (edict_t *ent);
void Weapon_MiniMissile(edict_t *ent);
void Weapon_RocketLauncher (edict_t *ent);
void Weapon_Grenade (edict_t *ent);
void Weapon_GrenadeLauncher (edict_t *ent);
void Weapon_Railgun (edict_t *ent);
void Weapon_BFG (edict_t *ent);

//=========
//Rogue Weapons
void Weapon_ChainFist (edict_t *ent);
void Weapon_Disintegrator (edict_t *ent);
void Weapon_ETF_Rifle (edict_t *ent);
void Weapon_Heatbeam (edict_t *ent);
void Weapon_Prox (edict_t *ent);
void Weapon_Tesla (edict_t *ent);
//void Weapon_ProxLauncher (edict_t *ent);

//void Weapon_Nuke (edict_t *ent);
//Rogue Weapons
//=========

gitem_armor_t jacketarmor_info	= { 25,  50, .30, .10, false, true, false, ARMOR_JACKET};
gitem_armor_t combatarmor_info	= { 50, 100, .60, .30, false, true, false, ARMOR_COMBAT};
gitem_armor_t bodyarmor_info	= {100, 200, .80, .60, true, true, true, ARMOR_BODY};
gitem_armor_t platearmor_info	= {100, 200, 1.0, 1.0, true, true, true, ARMOR_PLATE};
gitem_armor_t bandolier_info	= {  0,   0, .00, .00, false, false, false, ARMOR_NONE};
gitem_armor_t backpack_info		= {  0,   0, .00, .00, false, false, false, ARMOR_NONE};
gitem_armor_t power_screen_info	= {  0,   0, .00, .00, false, false, false, ARMOR_POWER_SCREEN};
gitem_armor_t power_shield_info	= {  0,   0, .00, .00, false, false, false, ARMOR_POWER_SHIELD};

gitem_weapon_t wand_info = {-1, -1, MOD_BLASTER, 1};
gitem_weapon_t chainfist_info = {-1, -1, MOD_CHAINFIST, 1};
gitem_weapon_t blaster_info = {-1, -1, MOD_BLASTER, 0};
gitem_weapon_t shotgun_info = {25, 1, MOD_SHOTGUN, 0};
gitem_weapon_t sshotgun_info = {12, 2, MOD_SSHOTGUN, 1};
gitem_weapon_t machinegun_info = {-1, -1, MOD_MACHINEGUN, 0};
gitem_weapon_t etf_info = {-1, -1, MOD_ETF_RIFLE, 1};
gitem_weapon_t chaingun_info = {-1, -1, MOD_CHAINGUN, 1};
gitem_weapon_t hgrenade_info = {-1, -1, MOD_HANDGRENADE, 0};
gitem_weapon_t grenade_info = {10, 1, MOD_GRENADE, 0};
gitem_weapon_t prox_info = {-1, -1, MOD_PROX, 1};
gitem_weapon_t minimissile_info = {4, 1, MOD_ROCKET, 1};
gitem_weapon_t rocket_info = {4, 1, MOD_ROCKET, 1};
gitem_weapon_t hyperblaster_info = {-1, -1, MOD_HYPERBLASTER, 1};
gitem_weapon_t flamethrower_info = {-1, -1, MOD_FIRE, 1};
gitem_weapon_t plasma_info = {-1, -1, MOD_HEATBEAM, 1};
gitem_weapon_t railgun_info = {1, 1, MOD_RAILGUN, 1};
gitem_weapon_t bfg_info = {-1, -1, MOD_BFG_BLAST, 1};
gitem_weapon_t disruptor_info = {-1, -1, MOD_DISINTEGRATOR, 1};
gitem_weapon_t grapple_info = {-1, -1, MOD_GRAPPLE, 0};

static int  plate_armor_index;
static int	jacket_armor_index;
static int	combat_armor_index;
static int	body_armor_index;
static int	bandolier_index;
static int	backpack_index;
static int	power_screen_index;
static int	power_shield_index;

//======================================================================

/*
===============
GetItemByIndex
===============
*/
gitem_t	*GetItemByIndex (int index)
{
	if (index == 0 || index >= game.num_items)
		return NULL;

	return &itemlist[index];
}


/*
===============
FindItemByClassname

===============
*/
gitem_t	*FindItemByClassname (char *classname)
{
	int		i;
	gitem_t	*it;

	it = itemlist;
	for (i=0 ; i<game.num_items ; i++, it++)
	{
		if (!it->classname)
			continue;
		if (!Q_stricmp(it->classname, classname))
			return it;
	}

	return NULL;
}

/*
===============
FindItem

===============
*/
gitem_t	*FindItem (char *pickup_name)
{
	int		i;
	gitem_t	*it;

	it = itemlist;
	for (i=0 ; i<game.num_items ; i++, it++)
	{
		if (!it->pickup_name)
			continue;
		if (!Q_strncasecmp(it->pickup_name, pickup_name, strlen(it->pickup_name)))
			return it;
	}

	return NULL;
}

//======================================================================

void DoRespawn (edict_t *ent)
{
	if (ent->team)
	{
		edict_t	*master;
		int	count;
		int choice;

		master = ent->teammaster;

//ZOID
//in ctf, when we are weapons stay, only the master of a team of weapons
//is spawned
		
		if (ctf->value &&
			((int)dmflags->value & DF_WEAPONS_STAY) &&
			master->item && (master->item->flags & IT_WEAPON))
			ent = master;
		else {
//ZOID

			for (count = 0, ent = master; ent; ent = ent->chain, count++)
				;

			choice = rand() % count;

			for (count = 0, ent = master; count < choice; ent = ent->chain, count++)
				;
		}
	}

	ent->svflags &= ~SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	gi.linkentity (ent);

	// send an effect
	ent->s.event = EV_ITEM_RESPAWN;
}

void SetRespawn (edict_t *ent, float delay)
{
	//if ((int)dmflags->value & DF_WEAPONS_STAY)
	//{
		ent->nextthink = level.time + 1;
		ent->think = G_FreeEdict;
		return;
	//}
	ent->flags |= FL_RESPAWN;
	ent->svflags |= SVF_NOCLIENT;
	ent->solid = SOLID_NOT;
	ent->nextthink = level.time + delay;
	ent->think = DoRespawn;
	gi.linkentity (ent);
}


//======================================================================

qboolean Pickup_Powerup (edict_t *ent, edict_t *other)
{
	int		quantity;

	quantity = other->client->pers.inventory[ITEM_INDEX(ent->item)];
	if ((skill->value == 1 && quantity >= 2) || (skill->value >= 2 && quantity >= 1))
		return false;

	if ((coop->value) && (ent->item->flags & IT_STAY_COOP) && (quantity > 0))
		return false;

	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;

	if (deathmatch->value)
	{
		if (!(ent->spawnflags & DROPPED_ITEM) )
			SetRespawn (ent, ent->item->quantity);		
	}

	return true;
}

qboolean Pickup_Useable (edict_t *ent, edict_t *other)
{
	/*
	int		quantity;
	
	quantity = other->client->pers.inventory[ITEM_INDEX(ent->item)];
	if ((skill->value == 1 && quantity >= 2) || (skill->value >= 2 && quantity >= 1))
		return false;

	if ((coop->value) && (ent->item->flags & IT_STAY_COOP) && (quantity > 0))
		return false;
	*/	
	if(ent->item->use == Use_Health && other->client && !other->client->canbleed)
	{
		if(other->client && other->touch_debounce_time < level.time)
			gi.cprintf(other, PRINT_HIGH, "You have no use for this.\n");		
		other->touch_debounce_time = level.time + 1;
		return false;
	}
	if (!CheckEncumbrance(other, ent->item->bulk))
		return false;

	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
	other->client->encumbrance += ent->item->bulk;
	CalcMass(other);
	if (deathmatch->value)
	{
		if (!(ent->spawnflags & DROPPED_ITEM) )
			SetRespawn (ent, 300);
	}

	return true;
}

int Drop_General (edict_t *ent, gitem_t *item)
{
	Drop_Item (ent, item);
	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ent->client->encumbrance -= item->bulk;
	CalcMass(ent);
	ValidateSelectedItem (ent);
	return 1;
}

int Drop_Goggles (edict_t *ent, gitem_t *item)
{
	ent->client->ps.fov = 90;
	ent->client->using_ir = 0;
	Drop_General(ent, item);
	return 1;
}

// ================
// PGM
void Use_IR (edict_t *ent, gitem_t *item)
{
//	ent->client->pers.inventory[ITEM_INDEX(item)]--;
//	ValidateSelectedItem (ent);

	
/*
	if (ent->client->ir_framenum > level.framenum)
		ent->client->ir_framenum += 600;
	else
		ent->client->ir_framenum = level.framenum + 600;
*/
	//ent->client->ir_framenum = 0;
	ent->client->using_ir = !ent->client->using_ir;
	if(ent->client->ir_framenum < 0)
		ent->client->ir_framenum = 0;
	gi.sound(ent, CHAN_ITEM, gi.soundindex("misc/ir_start.wav"), 1, ATTN_NORM, 0);
}

//======================================================================
int Use_Health (edict_t *ent, gitem_t *item)
{
	ent->client->pers.inventory[ITEM_INDEX(item)]--;
	ent->client->encumbrance -= item->bulk;
	CalcMass(ent);
	ValidateSelectedItem (ent);
	ent->health += item->quantity;
	gi.sound(ent, CHAN_VOICE, gi.soundindex("items/s_health.wav"), 1, ATTN_NORM, 0);
	
	if(ent->health > ent->max_health)
		ent->health = ent->max_health;
	ent->client->bleeding = 0;
	ent->client->leg_damage = ent->client->leg_damage / 2;
	ValidateSelectedItem (ent);
	return 1;
}

qboolean Pickup_Key (edict_t *ent, edict_t *other)
{
	if (coop->value)
	{
		if (strcmp(ent->classname, "key_power_cube") == 0)
		{
			if (other->client->pers.power_cubes & ((ent->spawnflags & 0x0000ff00)>> 8))
				return false;
			other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
			other->client->pers.power_cubes |= ((ent->spawnflags & 0x0000ff00) >> 8);
		}
		else
		{
			if (other->client->pers.inventory[ITEM_INDEX(ent->item)])
				return false;
			other->client->pers.inventory[ITEM_INDEX(ent->item)] = 1;
		}
		return true;
	}
	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
	return true;
}

//======================================================================

qboolean Add_Ammo (edict_t *ent, gitem_t *item, int count)
{
	int			index;

	if (!ent->client)
		return false;

	
	/*
	if (item->tag == AMMO_BULLETS)
		max = ent->client->pers.max_bullets;
	else if (item->tag == AMMO_SHELLS)
		max = ent->client->pers.max_shells;
	else if (item->tag == AMMO_ROCKETS)
		max = ent->client->pers.max_rockets;
	else if (item->tag == AMMO_GRENADES)
		max = ent->client->pers.max_grenades;
	else if (item->tag == AMMO_CELLS)
		max = ent->client->pers.max_cells;
	else if (item->tag == AMMO_SLUGS)
		max = ent->client->pers.max_slugs;
	else
		return false;
	*/
	index = ITEM_INDEX(item);

	//if (ent->client->pers.inventory[index] == max)
	//	return false;

	ent->client->pers.inventory[index] += count;

	//if (ent->client->pers.inventory[index] > max)
	//	ent->client->pers.inventory[index] = max;

	return true;
}

qboolean Pickup_Ammo (edict_t *ent, edict_t *other)
{
	int			oldcount;
	int			count;
	qboolean	weapon;

	weapon = (ent->item->flags & IT_WEAPON);
	if ( (weapon) && ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		count = 1000;
	else if (ent->count)
		count = ent->count;
	else
		count = ent->item->quantity;

	if(!CheckEncumbrance(other, ent->item->bulk * count))
		return false;
	
	oldcount = other->client->pers.inventory[ITEM_INDEX(ent->item)];
	other->client->pers.inventory[ITEM_INDEX(ent->item)] += count;
	other->client->encumbrance += ent->item->bulk * count;
	CalcMass(other);
	
	
	if(weapon && other->client->pers.weapon == NULL)
	{
		other->client->pers.weapon = ent->item;
		other->client->newweapon = ent->item;
	}		
	
	if (!(ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM)) && (deathmatch->value))
		SetRespawn (ent, 240);
	return true;
}

void AmmoDie(edict_t *ent, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
int Drop_Ammo (edict_t *ent, gitem_t *item)
{
	edict_t	*dropped;
	int		index;

	index = ITEM_INDEX(item);
	
	dropped = Drop_Item (ent, item);
	dropped->die = AmmoDie;
	/*
	if(item->tag == AMMO_SHELLS && ent->health > 0)
	{
		dropped->count = 1;
		dropped->s.angles[0] = 90;
		dropped->s.angles[1] = random() * 360;
		VectorSet (dropped->mins, -1, -1, -1);
		VectorSet (dropped->maxs, 1, 1, 1);	
		gi.setmodel (dropped, "models/items/ammo/shells/single/tris.md2");
	}
	else if(item->tag == AMMO_ROCKETS)
	{
		VectorSet (dropped->mins, -4, -4, -2);
		VectorSet (dropped->maxs, 4, 4, 2);	
		gi.setmodel (dropped, "models/items/ammo/rockets/single/tris.md2");
		dropped->count = 1;
	}
	*/
	//if(item->tag == AMMO_CELLS && ent->deadflag)
	if(ent->deadflag)
		dropped->count = ent->client->pers.inventory[index];
	else if (ent->client->pers.inventory[index] >= item->quantity)
		dropped->count = item->quantity;
	else
		dropped->count = ent->client->pers.inventory[index];
	ent->client->pers.inventory[index] -= dropped->count;
	ent->client->encumbrance -= item->bulk * dropped->count;
	CalcMass(ent);
	
	ValidateSelectedItem (ent);
	return 1;
}


//======================================================================

//======================================================================

int ArmorIndex (edict_t *ent)
{
	int index = 0;
	if (!ent->client)
		return 0;

	for(index = 0; index < MAX_ITEMS; index++)
	{
		if(ent->client->pers.inventory[index] > 0)
		{
			if(GetItemByIndex(index)->flags & IT_ARMOR)
				return index;
		}
	}
	return 0;
}


int Drop_Armor (edict_t *ent, gitem_t *item)
{
	edict_t	*dropped;
	int		index;
	index = ITEM_INDEX(item);
	if(index == backpack_index)
		ent->client->max_weapons -= 3;
	else if(index == bandolier_index)
		ent->client->max_weapons -= 2;
	dropped = Drop_Item (ent, item);
	dropped->count = ent->client->pers.inventory[index];
	dropped->health = dropped->count * 5;
	ent->client->pers.inventory[index] = 0;
	if(ent->deadflag)
		return 1;
	index = MAX_ITEMS - 1;
	while(ent->client->encumbrance > ent->client->max_carry || ent->client->weapons_carried > ent->client->max_weapons)
	{
		while(ent->client->pers.inventory[index] == 0)
			index--;
		if(GetItemByIndex(index)->flags & IT_WEAPON || ent->client->weapons_carried <= ent->client->max_weapons)
		{
			gitem_t *item = GetItemByIndex(index);
			if(!item->drop(ent, item))
				index--;
		}
		if(index < 0)
			break;
	}
	ent->s.modelindex4 = 0;
	CalcMass(ent);	
	ValidateSelectedItem (ent);
	return true;
}

qboolean Pickup_Armor (edict_t *ent, edict_t *other)
{
	// get info on new armor
	if(other->client && !other->client->wears_armor)
	{
		if(other->touch_debounce_time < level.time)
			gi.cprintf(other, PRINT_HIGH, "You cannot wear this.\n");		
		other->touch_debounce_time = level.time + 1;		
		return false;
	}
	if(ArmorIndex (other))
	{
		if(other->client && other->touch_debounce_time < level.time)
			gi.cprintf(other, PRINT_HIGH, "You're already wearing a %s.\n", GetItemByIndex(ArmorIndex(other))->pickup_name);		
		other->touch_debounce_time = level.time + 1;
		other->client->pers.selected_item = ArmorIndex(other);
			return false;
	}
	if(ent->health)
		ent->count = ent->health;
	other->client->pers.inventory[ITEM_INDEX(ent->item)] = ent->count;
	CalcMass(other);
	if(ITEM_INDEX(ent->item) == backpack_index)
		other->client->max_weapons += 3;
	else if(ITEM_INDEX(ent->item) == bandolier_index)
		other->client->max_weapons += 2;
	other->s.modelindex4 = gi.modelindex(ent->item->view_model);
	if (!(ent->spawnflags & DROPPED_ITEM) && (deathmatch->value))
		SetRespawn (ent, 600);

	return true;
}

//======================================================================

int PowerArmorType (edict_t *ent)
{
	if (!ent->client)
		return POWER_ARMOR_NONE;

	if (!(ent->flags & FL_POWER_ARMOR))
		return POWER_ARMOR_NONE;

	if (ent->client->pers.inventory[power_shield_index] > 0)
		return POWER_ARMOR_SHIELD;

	if (ent->client->pers.inventory[power_screen_index] > 0)
		return POWER_ARMOR_SCREEN;

	return POWER_ARMOR_NONE;
}

int Use_PowerArmor (edict_t *ent, gitem_t *item)
{
	int		index;

	if (ent->flags & FL_POWER_ARMOR)
	{
		ent->flags &= ~FL_POWER_ARMOR;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/power2.wav"), 1, ATTN_NORM, 0);
	}
	else
	{
		index = ITEM_INDEX(FindItem("cells"));
		if (!ent->client->pers.inventory[index])
		{
			gi.cprintf (ent, PRINT_HIGH, "No cells for power armor.\n");
			return 0;
		}
		ent->flags |= FL_POWER_ARMOR;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("misc/power1.wav"), 1, ATTN_NORM, 0);
		return 1;
	}
	return 0;
}

qboolean Pickup_PowerArmor (edict_t *ent, edict_t *other)
{
	int		quantity;

	if(ArmorIndex (other))
		return false;

	quantity = other->client->pers.inventory[ITEM_INDEX(ent->item)];

	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
	other->client->encumbrance += ent->item->bulk;
	CalcMass(other);
	
	
	if (deathmatch->value)
	{
		if (!(ent->spawnflags & DROPPED_ITEM) )
			SetRespawn (ent, ent->item->quantity);
		// auto-use for DM only if we didn't already have one
		if (!quantity)
			ent->item->use (other, ent->item);
	}

	return true;
}

int Drop_PowerArmor (edict_t *ent, gitem_t *item)
{
	if ((ent->flags & FL_POWER_ARMOR) && (ent->client->pers.inventory[ITEM_INDEX(item)] == 1))
		Use_PowerArmor (ent, item);
	return Drop_Armor (ent, item);
}

//======================================================================

/*
===============
Touch_Item
===============
*/
void Touch_Item (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	qboolean	taken;

	//gi.dprintf("touched %s\n", ent->item->classname);
	if (!other->client)
		return; // only players can pick up
	if (other->health < 1 || other->s.modelindex != 255 || other->deadflag)
		return;		// dead people can't pickup
	if (!ent->item->pickup)
		return;		// not a grabbable item?
	if(other->client->pers.weapon && other->client->ammo_index != ITEM_INDEX(other->client->pers.weapon) && other->client->pers.inventory[ITEM_INDEX(other->client->pers.weapon)] > 1 || (other->client->pers.weapon == other->client->heavy_weapon && other->client->pers.weapon != NULL) )
	{
		if(other->touch_debounce_time < level.time)
			gi.cprintf(other, PRINT_HIGH, "Your hands are full.\n");		

		other->touch_debounce_time = level.time + 1;
		
		return;
	}
	//if((other->client->ps.pmove.pm_flags & PMF_DUCKED) == 0)
	//	return;		// only grab if crouched

	taken = ent->item->pickup(ent, other);

	if (taken)
	{
		// flash the screen
		other->client->bonus_alpha = 0.25;

		// show icon and name on status bar
		other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(ent->item->icon);
		other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(ent->item);
		other->client->pickup_msg_time = level.time + 3.0;

		// change selected item
		if (ent->item->use)
			other->client->pers.selected_item = other->client->ps.stats[STAT_SELECTED_ITEM] = ITEM_INDEX(ent->item);

		gi.sound(other, CHAN_ITEM, gi.soundindex(ent->item->pickup_sound), 1, ATTN_NORM, 0);
	}

	if (!(ent->spawnflags & ITEM_TARGETS_USED))
	{
		G_UseTargets (ent, other);
		ent->spawnflags |= ITEM_TARGETS_USED;
	}

	if (!taken)
		return;

	if (!((coop->value) &&  (ent->item->flags & IT_STAY_COOP)) || (ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM)))
	{
		if (ent->flags & FL_RESPAWN)
			ent->flags &= ~FL_RESPAWN;
		else
			G_FreeEdict (ent);
	}
}

//======================================================================

static void drop_temp_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	Touch_Item (ent, other, plane, surf);
}

static void drop_make_touchable (edict_t *ent)
{
	ent->touch = Touch_Item;
	ent->owner = NULL;	
		
}
void BecomeExplosion(edict_t *ent, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	BecomeExplosion1(ent);
}
void MakeGone(edict_t *ent, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
edict_t *Drop_Item (edict_t *ent, gitem_t *item)
{
	edict_t	*dropped;
	vec3_t	forward, right;
	vec3_t	offset;

	dropped = G_Spawn();

	dropped->classname = item->classname;
	dropped->item = item;
	//dropped->spawnflags = DROPPED_ITEM;
	dropped->s.effects = 0;//item->world_model_flags;
	dropped->s.renderfx = RF_GLOW;
	//VectorSet (dropped->mins, -8, -8, -15);
	//VectorSet (dropped->maxs, 8, 8, 0);
	dropped->mins[0] = -item->width;
	dropped->mins[1] = -item->width;
	dropped->mins[2] = -15;
	
	dropped->maxs[0] = item->width;
	dropped->maxs[1] = item->width;
	dropped->maxs[2] = item->height - 15;
	
	gi.setmodel (dropped, dropped->item->world_model);
	dropped->solid = SOLID_BBOX;
	//dropped->svflags = SVF_MONSTER;
	//dropped->solid = SOLID_BBOX;//SOLID_TRIGGER;
	
	dropped->movetype = MOVETYPE_TOSS;  
	dropped->touch = drop_temp_touch;
	dropped->owner = ent;

	if (ent->client && !ent->deadflag)
	{
		trace_t trace;
		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 24, 0, -16);
		G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
		trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
		VectorCopy (trace.endpos, dropped->s.origin);
	}
	else
	{
		AngleVectors (ent->s.angles, forward, right, NULL);
		VectorCopy (ent->s.origin, dropped->s.origin);
	}
	dropped->s.effects &= ~EF_ROTATE;
	VectorScale (forward, 100, dropped->velocity);
	dropped->velocity[2] = 300;
	dropped->s.angles[1] = random() * 360;

	dropped->think = drop_make_touchable;
	dropped->nextthink = level.time + 1;

	gi.linkentity (dropped);	
	dropped->max_health = 5000;
	dropped->health = 1000;
	dropped->takedamage = DAMAGE_YES;
	dropped->mass = item->bulk;
	//dropped->die = BecomeExplosion;
	if (dropped->item->flags & IT_AMMO)
	{
		dropped->die = AmmoDie;
		dropped->mass *= dropped->count;
		dropped->mass++;
		dropped->health = 25;
	}
	else if(dropped->item->flags & IT_WEAPON)
	{
		if(dropped->item->ammo)
			dropped->mass += dropped->count * FindItem (dropped->item->ammo)->bulk;
		dropped->die = AmmoDie;
		
	}
	else if(dropped->item->flags & IT_ARMOR)
	{
		dropped->health = dropped->count * 5;
	}
	else
		dropped->die = MakeGone;
	return dropped;
}

void Use_Item (edict_t *ent, edict_t *other, edict_t *activator)
{
	ent->svflags &= ~SVF_NOCLIENT;
	ent->use = NULL;

	if (ent->spawnflags & ITEM_NO_TOUCH)
	{
		ent->solid = SOLID_BBOX;
		ent->touch = NULL;
	}
	else
	{
		ent->solid = SOLID_TRIGGER;
		ent->touch = Touch_Item;
	}

	gi.linkentity (ent);
}

//======================================================================

/*
================
droptofloor
================
*/
void ShowBounds (edict_t *ent)
{
	vec3_t point;
	int i;
	edict_t *corner;
	
	for(i = 0; i < 8; i++)
	{
		corner = G_Spawn();
		corner->classname = "corner";
		if(i & 1)
			corner->s.origin[0] = ent->s.origin[0] + ent->maxs[0];
		else
			corner->s.origin[0] = ent->s.origin[0] + ent->mins[0];
		if(i & 2)
			corner->s.origin[1] = ent->s.origin[1] + ent->maxs[1];
		else
			corner->s.origin[1] = ent->s.origin[1] + ent->mins[1];
		if(i & 4)
			corner->s.origin[2] = ent->s.origin[2] + ent->maxs[2];
		else
			corner->s.origin[2] = ent->s.origin[2] + ent->mins[2];
		corner->s.modelindex = gi.modelindex("models/objects/dball/tris2.md2");
		gi.linkentity (corner);
		corner->nextthink = level.time + FRAMETIME;
		corner->think = G_FreeEdict;
	}
	
	
}

void droptofloor (edict_t *ent)
{
	trace_t		tr;
	vec3_t		dest;
	float		*v;
	//edict_t		*corner;
	//int			i;

	//v = tv(-8,-8,-15);
	//VectorCopy (v, ent->mins);
	//v = tv(8,8,0);
	//VectorCopy (v, ent->maxs);
	ent->mins[0] = -ent->item->width;
	ent->mins[1] = -ent->item->width;
	ent->mins[2] = -15;
	
	ent->maxs[0] = ent->item->width;
	ent->maxs[1] = ent->item->width;
	ent->maxs[2] = -15 + ent->item->height;
	if (ent->model)
		gi.setmodel (ent, ent->model);
	else
		gi.setmodel (ent, ent->item->world_model);
	ent->solid = SOLID_BBOX;//SOLID_TRIGGER;
	//ent->svflags |= SVF_DEADMONSTER;

	ent->movetype = MOVETYPE_TOSS;  
	ent->touch = Touch_Item;
	ent->mass = ent->item->bulk;
	v = tv(0,0,-128);
	VectorAdd (ent->s.origin, v, dest);

	tr = gi.trace (ent->s.origin, ent->mins, ent->maxs, dest, ent, MASK_SOLID);
	if (tr.startsolid)
	{
		gi.dprintf ("droptofloor: %s startsolid at %s\n", ent->classname, vtos(ent->s.origin));
		G_FreeEdict (ent);
		return;
	}

	VectorCopy (tr.endpos, ent->s.origin);

	if (ent->team)
	{
		ent->flags &= ~FL_TEAMSLAVE;
		ent->chain = ent->teamchain;
		ent->teamchain = NULL;

		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
		if (ent == ent->teammaster)
		{
			ent->nextthink = level.time + FRAMETIME;
			ent->think = DoRespawn;
		}
	}

	if (ent->spawnflags & ITEM_NO_TOUCH)
	{
		ent->solid = SOLID_BBOX;
		ent->touch = NULL;
		ent->s.effects &= ~EF_ROTATE;
		ent->s.renderfx &= ~RF_GLOW;
	}
	ent->s.effects &= ~EF_ROTATE;
	
	if (ent->spawnflags & ITEM_TRIGGER_SPAWN)
	{
		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
		ent->use = Use_Item;
	}

	if (ent->item->flags & IT_AMMO)
	{
		ent->die = AmmoDie;
		if(!ent->count)
			ent->count = ent->item->quantity;
		ent->mass *= ent->count;
		ent->health = 25;
	}
	else if (ent->item->flags & IT_WEAPON)
	{
		
		ent->die = AmmoDie;
		if(ent->item->ammo)
			ent->mass += ent->count * FindItem (ent->item->ammo)->bulk;
		
	}
	
	//ShowBounds(ent);

	gi.linkentity (ent);
}


/*
===============
PrecacheItem

Precaches all data needed for a given item.
This will be called for each item spawned in a level,
and for each item in each client's inventory.
===============
*/
void PrecacheItem (gitem_t *it)
{
	char	*s, *start;
	char	data[MAX_QPATH];
	int		len;
	gitem_t	*ammo;
	//FILE *logfile = fopen("log.txt", "a");
	//fprintf(logfile, "PrecacheItem(%s)\n", it->classname);
	//fclose(logfile);
	
	if (!it)
		return;
	//if (it->flags & IT_WEAPON)
	//{
	//	sprintf(it->world_model, "players/male/%s.md2", it->icon);	
	//}
	if (it->pickup_sound)
		gi.soundindex (it->pickup_sound);
	if (it->world_model)
		gi.modelindex (it->world_model);
	if (it->view_model)
		gi.modelindex (it->view_model);
	if (it->view_model2)
		gi.modelindex (it->view_model2);
	if (it->icon)
		gi.imageindex (it->icon);

	// parse everything for its ammo
	if (it->ammo && it->ammo[0])
	{
		ammo = FindItem (it->ammo);
		if (ammo != it)
			PrecacheItem (ammo);
	}

	// parse the space seperated precache string for other items
	s = it->precaches;
	if (!s || !s[0])
		return;

	while (*s)
	{
		start = s;
		while (*s && *s != ' ')
			s++;

		len = s-start;
		if (len >= MAX_QPATH || len < 5)
			gi.error ("PrecacheItem: %s has bad precache string", it->classname);
		memcpy (data, start, len);
		data[len] = 0;
		if (*s)
			s++;

		// determine type based on extension
		if ((!strcmp(data+len-3, "md2")) || (!strcmp(data+len-3, "sp2")))
			gi.modelindex (data);
		else if (!strcmp(data+len-3, "wav"))
			gi.soundindex (data);
		if (!strcmp(data+len-3, "pcx"))
			gi.imageindex (data);
	}
}

/*
============
SpawnItem

Sets the clipping size and plants the object on the floor.

Items can't be immediately dropped to floor, because they might
be on an entity that hasn't spawned yet.
============
*/
void BecomeExplosion(edict_t *ent, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);

void Grenade_Explode (edict_t *ent);
void AmmoExplode(edict_t *ent)
{
	if(ent->item->tag == AMMO_GRENADES)
	{
		Grenade_Explode(ent);
		return;
	}
	else if(ent->item->tag == AMMO_SHELLS || ent->item->tag == AMMO_ROCKETS || ent->item->tag == AMMO_BULLETS)
	{
		int i, dmg = 10;
		if(!ent->count)
			ent->count = ent->item->quantity;

		if(ent->count > 32)
		{
			ent->dmg = 10 * ent->count / 32;
			ent->count = 32;
		}
		for(i = 0; i < ent->count; i++)
		{
			vec3_t sdir;
			sdir[0] = crandom();
			sdir[1] = crandom();
			sdir[2] = crandom();
			VectorNormalize(sdir);
			
			if(ent->item->tag == AMMO_BULLETS)
			{
				fire_bullet(ent, ent->s.origin, sdir, dmg, 0, 0, 0, MOD_MACHINEGUN);
				gi.WriteByte (svc_muzzleflash);
				gi.WriteShort (ent-g_edicts);
				gi.WriteByte (MZ_MACHINEGUN);
				gi.multicast (ent->s.origin, MULTICAST_PVS);	
			}
			else if(ent->item->tag == AMMO_SHELLS)
			{
				fire_shotgun (ent, ent->s.origin, sdir, dmg, 0, 500, 500, 5, MOD_SHOTGUN);				
				gi.WriteByte (svc_temp_entity);
				gi.WriteByte (TE_GUNSHOT);
				gi.WritePosition (ent->s.origin);
				gi.WriteDir (vec3_origin);
				gi.multicast (ent->s.origin, MULTICAST_PVS);
				
			}
			else if(ent->item->tag == AMMO_ROCKETS)
			{
				//if(sdir[2] < 0)
				//	sdir[2] = -sdir[2];
				//ent->s.origin[2]++;
				sdir[2] = fabs(sdir[2]);
				//ent->s.origin[0] += crandom() * 10;
				//ent->s.origin[1] += crandom() * 10;
				ent->s.origin[2] += 4;
				fire_rocket(ent, ent->s.origin, sdir, 150, 50 + rand() % 50, 200, 150);//(ent, ent->s.origin, sdir, 150, 0, 200, 150);
				gi.WriteByte (svc_muzzleflash);
				gi.WriteShort (ent-g_edicts);
				gi.WriteByte (MZ_ROCKET);
				gi.multicast (ent->s.origin, MULTICAST_PVS);	
			}
	
			
		}
		ent->think = BecomeExplosion1;
		ent->nextthink = level.time + FRAMETIME;
		return;
	}
	else
	{
		
		ent->think = G_FreeEdict;
		ent->nextthink = level.time + FRAMETIME;
		//gi.dprintf("lame");
		return;
	}	
	
}
void AmmoDie(edict_t *ent, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	//FILE *logfile = fopen("log.txt", "a");
	//fprintf(logfile, "AmmoDie(%s)\n", ent->classname);
	//fclose(logfile);
	ent->die = MakeGone;
	ent->think = AmmoExplode;
	ent->nextthink = level.time + FRAMETIME;
}
void MakeGone(edict_t *ent, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	G_FreeEdict(ent);
}
void SpawnItem (edict_t *ent, gitem_t *item)
{
	//FILE *logfile = fopen("log.txt", "a");
	//fprintf(logfile, "SpawnItem(%s)\n", ent->classname);
	//fclose(logfile);
	
	PrecacheItem (item);

	if (ent->spawnflags)
	{
		if (strcmp(ent->classname, "key_power_cube") != 0)
		{
			ent->spawnflags = 0;
			gi.dprintf("%s at %s has invalid spawnflags set\n", ent->classname, vtos(ent->s.origin));
		}
	}
    
	// some items will be prevented in deathmatch
	if (deathmatch->value)
	{
		if ( (int)dmflags->value & DF_NO_ARMOR )
		{
			if (item->pickup == Pickup_Armor || item->pickup == Pickup_PowerArmor)
			{
				G_FreeEdict (ent);
				return;
			}
		}
		if ( (int)dmflags->value & DF_NO_ITEMS )
		{
			if (item->pickup == Pickup_Powerup)
			{
				G_FreeEdict (ent);
				return;
			}
		}
		if ( (int)dmflags->value & DF_INFINITE_AMMO )
		{
			if ( (item->flags == IT_AMMO) || (strcmp(ent->classname, "weapon_bfg") == 0) )
			{
				G_FreeEdict (ent);
				return;
			}
		}
	}
	ent->max_health = 5000;
	ent->health = 25;
	ent->takedamage = DAMAGE_YES;
	ent->die = MakeGone;
	if (item->flags & IT_AMMO)
	{
		ent->die = AmmoDie;
	}
	else if (item->pickup == Pickup_Weapon)
	{
		if(((gitem_weapon_t *)item->info)->capacity > 0)
			ent->count = ((gitem_weapon_t *)item->info)->capacity;
		ent->die = AmmoDie;
		ent->health = 1000;
	}
	else if (item->pickup == Pickup_Armor)
	{
		ent->count = item->quantity;
		ent->health = item->quantity;		
	}
	
	if (coop->value && (strcmp(ent->classname, "key_power_cube") == 0))
	{
		ent->spawnflags |= (1 << (8 + level.power_cubes));
		level.power_cubes++;
	}

	
	// don't let them drop items that stay in a coop game
	if ((coop->value) && (item->flags & IT_STAY_COOP))
	{
		item->drop = NULL;
	}

//ZOID
//Don't spawn the flags unless enabled
	if (!ctf->value &&
		(strcmp(ent->classname, "item_flag_team1") == 0 ||
		strcmp(ent->classname, "item_flag_team2") == 0)) {
		G_FreeEdict(ent);
		return;
	}
//ZOID

	ent->item = item;
	ent->nextthink = level.time + 2 * FRAMETIME;    // items start after other solids
	ent->think = droptofloor;
	//ent->s.effects = item->world_model_flags;
	ent->s.renderfx = RF_GLOW;
	if (ent->model)
		gi.modelindex (ent->model);

//ZOID
//flags are server animated and have special handling
	if (strcmp(ent->classname, "item_flag_team1") == 0 ||
		strcmp(ent->classname, "item_flag_team2") == 0) {
		ent->think = CTFFlagSetup;
	}
//ZOID

}

//======================================================================

gitem_t	itemlist[] = 
{
	{
		NULL
	},	// leave index 0 alone

	//
	// ARMOR
	//

	{
		"item_armor_plate", 
		NULL,
		NULL,
		NULL,
		NULL,
		"misc/ar1_pkup.wav",
		NULL, 0.0, 0, 0,
		NULL, NULL,
/* icon */		"p_invulnerability",
/* pickup */	"Plate Armor",
/* width */		3,
		200,
		NULL,
		IT_ARMOR,
		&platearmor_info,
		ARMOR_PLATE,
/* precache */ ""
	},

/*QUAKED item_armor_body (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_armor_body", 
		Pickup_Armor,
		Use_Nothing,
		Drop_Armor, 
		NULL,
		"misc/ar1_pkup.wav",
		"models/items/armor/body/tris.md2", 30.0, 8, 12,
		"players/male/i_bodyarmor.md2", NULL,
/* icon */		"i_bodyarmor",
/* pickup */	"Body Armor",
/* width */		3,
		200,
		NULL,
		IT_ARMOR,
		&bodyarmor_info,
		ARMOR_BODY,
/* precache */ ""
	},

	{
		"item_armor_body", 
		NULL,
		NULL,
		NULL,
		NULL,
		"misc/ar1_pkup.wav",
		"models/items/armor/body/tris.md2", 30.0, 8, 12,
		"players/male/i_bodyarmor.md2", NULL,
/* icon */		"i_bodyarmor",
/* pickup */	"builtin Body Armor",
/* width */		3,
		200,
		NULL,
		IT_ARMOR,
		&bodyarmor_info,
		ARMOR_BODY,
/* precache */ ""
	},

/*QUAKED item_armor_combat (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_armor_combat", 
		Pickup_Armor,
		Use_Nothing,
		Drop_Armor,
		NULL,
		"misc/ar1_pkup.wav",
		"models/items/armor/combat/tris.md2", 25.0, 8, 12,
		"players/male/i_combatarmor.md2", NULL,
/* icon */		"i_combatarmor",
/* pickup */	"Combat Armor",
/* width */		3,
		100,
		NULL,
		IT_ARMOR,
		&combatarmor_info,
		ARMOR_COMBAT,
/* precache */ ""
	},

/*QUAKED item_armor_combat (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_armor_combat", 
		NULL,
		NULL,
		NULL,
		NULL,
		"misc/ar1_pkup.wav",
		"models/items/armor/combat/tris.md2", 25.0, 0, 0,
		"players/male/i_combatarmor.md2", NULL,
/* icon */		"i_combatarmor",
/* pickup */	"builtin Combat Armor",
/* width */		3,
		100,
		NULL,
		IT_ARMOR,
		&combatarmor_info,
		ARMOR_COMBAT,
/* precache */ ""
	},

/*QUAKED item_armor_jacket (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_armor_jacket", 
		Pickup_Armor,
		Use_Nothing,
		Drop_Armor,
		NULL,
		"misc/ar1_pkup.wav",
		"models/items/armor/jacket/tris.md2", 20.0, 8, 12,
		NULL, NULL,
/* icon */		"i_jacketarmor",
/* pickup */	"Jacket Armor",
/* width */		3,
		50,
		NULL,
		IT_ARMOR,
		&jacketarmor_info,
		ARMOR_JACKET,
/* precache */ ""
	},

/*QUAKED item_power_screen (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_power_screen", 
		Pickup_PowerArmor,
		Use_PowerArmor,
		Drop_PowerArmor,
		NULL,
		"misc/ar3_pkup.wav",
		"models/items/armor/screen/tris.md2", 12.5, 8, 16,
		NULL, NULL,
/* icon */		"i_powerscreen",
/* pickup */	"Power Screen",
/* width */		0,
		50,
		NULL,
		IT_ARMOR,
		&power_screen_info,
		ARMOR_POWER_SCREEN,
/* precache */ ""
	},

/*QUAKED item_power_shield (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_power_shield",
		Pickup_PowerArmor,
		Use_PowerArmor,
		Drop_PowerArmor,
		NULL,
		"misc/ar3_pkup.wav",
		"models/items/armor/shield/tris.md2", 16.0, 8, 16,
		NULL, NULL,
/* icon */		"i_powershield",
/* pickup */	"Power Shield",
/* width */		0,
		50,
		NULL,
		IT_ARMOR,
		&power_shield_info,
		ARMOR_POWER_SHIELD,
/* precache */ "misc/power2.wav misc/power1.wav"
	},

/*QUAKED item_bandolier (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_bandolier",
		Pickup_Armor,
		Use_Nothing,
		Drop_Armor,
		NULL,
		"items/pkup.wav",
		"models/items/armor/band/tris.md2", 10.0, 8, 16,
		NULL, NULL,
/* icon */		"p_bandolier",
/* pickup */	"Bandolier",
/* width */		0,
		1,
		NULL,
		IT_ARMOR,
		&bandolier_info,
		ARMOR_NONE,
/* precache */ ""
	},

/*QUAKED item_pack (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_pack",
		Pickup_Armor,
		Use_Nothing,
		Drop_Armor,
		NULL,
		"items/pkup.wav",
		"models/items/armor/backpack/tris.md2", 12.0, 8, 12,
		NULL, NULL,
/* icon */		"i_pack",
/* pickup */	"Backpack", 
/* width */		0,
		1,
		NULL,
		IT_ARMOR,
		&backpack_info,
		ARMOR_NONE,
/* precache */ ""
	},


	//
	// WEAPONS 
	//

/* weapon_blaster (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_claw", 
		NULL,
		Use_Weapon,
		NULL,
		Weapon_Claws,
		"misc/w_pkup.wav",
		NULL, 0, 0, 0,
		NULL, NULL,
/* icon */		"p_quad",
/* pickup */	"Claws",
		0,
		0,
		NULL,
		IT_WEAPON,
		&wand_info,
		0,
/* precache */ NULL
	},

	/* weapon_blaster (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_wand1", 
		NULL,
		Use_Weapon,
		NULL,
		Weapon_Lightning,
		"misc/w_pkup.wav",
		NULL, 0, 0, 0,
		"models/weapons/v_staff/tris.md2", NULL,
/* icon */		"p_invulnerability",
/* pickup */	"Lightning Wand",
		0,
		0,
		NULL,
		IT_WEAPON,
		&wand_info,
		0,
/* precache */ "weapons/blastf1a.wav misc/lasfly.wav"
	},

		{
		"weapon_wand2", 
		NULL,
		Use_Weapon,
		NULL,
		Weapon_FaerieWand,
		"misc/w_pkup.wav",
		NULL, 0, 0, 0,
		"models/weapons/v_wand/tris.md2", NULL,
/* icon */		"w_faerie",
/* pickup */	"Faerie Wand",
		0,
		0,
		NULL,
		IT_WEAPON,
		&wand_info,
		0,
/* precache */ "weapons/blastf1a.wav misc/lasfly.wav"
	},

/* weapon_grapple (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_grapple", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		CTFWeapon_Grapple,
		"misc/w_pkup.wav",
		"models/weapons/g_hook/tris.md2", 2.5, 9, 5,
		"models/weapons/grapple/tris.md2", "models/weapons/grapple/tris.md2",
/* icon */		"w_grapple",
/* pickup */	"Grapple",
		0,
		0,
		NULL,
		IT_WEAPON,
		&grapple_info,
		0,
/* precache */ "weapons/grapple/grfire.wav weapons/grapple/grpull.wav weapons/grapple/grhang.wav weapons/grapple/grreset.wav weapons/grapple/grhit.wav"
	},

/*QUAKED weapon_chainfist (.3 .3 1) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN
*/
	{
		"weapon_chainfist",									// classname
		Pickup_Weapon,										// pickup function
		Use_Weapon,											// use function
		Drop_Weapon,										// drop function
		Weapon_ChainFist,									// weapon think function
		"misc/w_pkup.wav",									// pick up sound
		"models/weapons/g_chainf/tris.md2", 12.0, 12, 6,	// world model, world model flags
		"models/weapons/v_chainf/tris.md2",	NULL,			// view model
		"w_chainfist",										// icon
		"Chainfist",										// name printed when picked up 
		0,													// number of digits for statusbar
		0,													// amount used / contained
		NULL,												// ammo type used 
		IT_WEAPON | IT_MELEE,								// inventory flags
		&chainfist_info,									// info (void *)
		1,													// tag
		"weapons/sawidle.wav weapons/sawhit.wav",			// precaches
	},


/* weapon_blaster (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_blaster", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Blaster,
		"misc/w_pkup.wav",
		"models/weapons/g_blast/tris.md2", 4.2, 7, 4,
		"models/weapons/v_blast/tris.md2", "models/weapons/v_2blast/tris.md2",
/* icon */		"w_blaster",
/* pickup */	"Blaster",
		0,
		1,
		"Cells",
		IT_WEAPON|IT_STAY_COOP,
		&blaster_info,
		0,
/* precache */ "weapons/blastf1a.wav misc/lasfly.wav"
	},
	
/*QUAKED weapon_shotgun (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_shotgun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Shotgun,
		"misc/w_pkup.wav",
		"models/weapons/g_shotg/tris.md2", 6.4,	10, 6,
		"models/weapons/v_shotg/tris.md2", "models/weapons/v_2shotg/tris.md2",
/* icon */		"w_shotgun",
/* pickup */	"Shotgun",
		0,
		1,
		"Shells",
		IT_WEAPON|IT_STAY_COOP,
		&shotgun_info,
		0,
/* precache */ "weapons/shotgf1b.wav weapons/shotgr1b.wav"
	},

/*QUAKED weapon_supershotgun (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_supershotgun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_SuperShotgun,
		"misc/w_pkup.wav",
		"models/weapons/g_shotg2/tris.md2", 7.2, 11, 6,
		"models/weapons/v_shotg2/tris.md2", NULL,
/* icon */		"w_sshotgun",
/* pickup */	"Super Shotgun",
		0,
		2,
		"Shells",
		IT_WEAPON|IT_STAY_COOP,
		&sshotgun_info,
		0,
/* precache */ "weapons/sshotf1b.wav"
	},

/*QUAKED weapon_machinegun (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_machinegun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Machinegun,
		"misc/w_pkup.wav",
		"models/weapons/g_machn/tris.md2", 10.0, 9, 5,
		"models/weapons/v_machn/tris.md2", "models/weapons/v_2machn/tris.md2",
/* icon */		"w_machinegun",
/* pickup */	"Machinegun",
		0,
		1,
		"Bullets",
		IT_WEAPON|IT_STAY_COOP,
		&machinegun_info,
		0,
/* precache */ "weapons/machgf1b.wav weapons/machgf2b.wav weapons/machgf3b.wav weapons/machgf4b.wav weapons/machgf5b.wav"
	},

/*QUAKED weapon_chaingun (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_chaingun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Chaingun,
		"misc/w_pkup.wav",
		"models/weapons/g_chain/tris.md2", 27.5, 12, 5,
		"models/weapons/v_chain/tris.md2", "models/weapons/v_2chain/tris.md2",
/* icon */		"w_chaingun",
/* pickup */	"Chaingun",
		0,
		1,
		"Bullets",
		IT_WEAPON|IT_STAY_COOP,
		&chaingun_info,
		0,
/* precache */ "weapons/chngnu1a.wav weapons/chngnl1a.wav weapons/machgf3b.wav` weapons/chngnd1a.wav"
	},

/*QUAKED weapon_chaingun (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_chaingun", 
		NULL,
		Use_Weapon,
		NULL,
		Weapon_Chaingun,
		"misc/w_pkup.wav",
		"models/weapons/g_chain/tris.md2", 27.5, 0, 0,
		"models/weapons/v_chain/tris.md2", "models/weapons/v_2chain/tris.md2",
/* icon */		"w_chaingun",
/* pickup */	"builtin Chaingun",
		0,
		1,
		"Bullets",
		IT_WEAPON|IT_STAY_COOP,
		&chaingun_info,
		0,
/* precache */ "weapons/chngnu1a.wav weapons/chngnl1a.wav weapons/machgf3b.wav` weapons/chngnd1a.wav"
	},

// ROGUE
/*QUAKED weapon_etf_rifle (.3 .3 1) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN
*/
	{
		"weapon_etf_rifle",									// classname
		Pickup_Weapon,										// pickup function
		Use_Weapon,											// use function
		Drop_Weapon,										// drop function
		Weapon_ETF_Rifle,									// weapon think function
		"misc/w_pkup.wav",									// pick up sound
		"models/weapons/g_etf_rifle/tris.md2", 19.0, 8, 8,	// world model, world model flags
		"models/weapons/v_etf_rifle/tris.md2",	NULL,			// view model
		"w_etf_rifle",										// icon
		"ETF Rifle",										// name printed when picked up 
		0,													// number of digits for statusbar
		1,													// amount used / contained
		"Flechettes",										// ammo type used 
		IT_WEAPON,											// inventory flags		
		&etf_info,												// info (void *)
		0,													// tag
		"weapons/nail1.wav models/proj/flechette/tris.md2",	// precaches
	},

	// rogue

/*QUAKED ammo_grenades (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_grenades",
		Pickup_Ammo,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Grenade,
		"misc/am_pkup.wav",
		"models/items/ammo/grenades/small/tris.md2", GRENADES_WEIGHT, 2, 4,
		"models/weapons/v_handgr/tris.md2", "models/weapons/v_handgr/tris.md2",
/* icon */		"a_grenades",
/* pickup */	"Grenades",
/* width */		3,
		1,
		"grenades",
		IT_AMMO|IT_WEAPON,
		&hgrenade_info,
		AMMO_GRENADES,
/* precache */ "weapons/hgrent1a.wav weapons/hgrena1b.wav weapons/hgrenc1b.wav weapons/hgrenb1a.wav weapons/hgrenb2a.wav "
	},

/*QUAKED weapon_grenadelauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_grenadelauncher",
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_GrenadeLauncher,
		"misc/w_pkup.wav",
		"models/weapons/g_launch/tris.md2", 8.5, 8, 5,
		"models/weapons/v_launch/tris.md2", "models/weapons/v_2launch/tris.md2",
/* icon */		"w_glauncher",
/* pickup */	"Grenade Launcher",
		0,
		1,
		"Grenades",
		IT_WEAPON|IT_STAY_COOP,
		&grenade_info,
		0,
/* precache */ "models/objects/grenade/tris.md2 weapons/grenlf1a.wav weapons/grenlr1b.wav weapons/grenlb1b.wav"
	},

#if 0
	// ROGUE
/*QUAKED weapon_proxlauncher (.3 .3 1) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN
*/
	{
		"weapon_proxlauncher",								// classname
		Pickup_Weapon,										// pickup
		Use_Weapon,											// use
		Drop_Weapon,										// drop
		Weapon_ProxLauncher,								// weapon think
		"misc/w_pkup.wav",									// pick up sound
		"models/weapons/g_plaunch/tris.md2", 8.5, 8, 5,		// world model, world model flags
		"models/weapons/v_plaunch/tris.md2", NULL,			// view model
		"w_proxlaunch",										// icon
		"Prox Launcher",									// name printed when picked up
		0,													// number of digits for statusbar
		1,													// amount used
		"Prox",												// ammo type used
		IT_WEAPON,											// inventory flags
		&prox_info,											// info (void *)
		0,													// tag
		"weapons/grenlf1a.wav weapons/grenlr1b.wav weapons/grenlb1b.wav weapons/proxwarn.wav weapons/proxopen.wav",
	},
	// rogue

#endif

/*QUAKED ammo_grenades (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_minimissile",
		NULL,
		Use_Weapon,
		NULL,
		Weapon_MiniMissile,
		"misc/am_pkup.wav",
		NULL, 0, 2, 4,
		NULL, NULL,
/* icon */		"a_rockets",
/* pickup */	"Mini Missiles",
/* width */		3,
		1,
		"mini missiles",
		IT_AMMO|IT_WEAPON,
		&minimissile_info,
		AMMO_MINIMISSILE,
/* precache */ "weapons/hgrent1a.wav weapons/hgrena1b.wav weapons/hgrenc1b.wav weapons/hgrenb1a.wav weapons/hgrenb2a.wav "
	},

/*QUAKED weapon_rocketlauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_rocketlauncher",
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_RocketLauncher,
		"misc/w_pkup.wav",
		"models/weapons/g_rocket/tris.md2", 18.0, 13, 6,
		"models/weapons/v_rocket/tris.md2", NULL,
/* icon */		"w_rlauncher",
/* pickup */	"Rocket Launcher",
		0,
		1,
		"Rockets",
		IT_WEAPON|IT_STAY_COOP,
		&rocket_info,
		0,
/* precache */ "models/objects/rocket/tris.md2 weapons/rockfly.wav weapons/rocklf1a.wav weapons/rocklr1b.wav models/objects/debris2/tris.md2"
	},

/*QUAKED weapon_hyperblaster (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_hyperblaster", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_HyperBlaster,
		"misc/w_pkup.wav",
		"models/weapons/g_hyperb/tris.md2", 12.0, 12, 5,
		"models/weapons/v_hyperb/tris.md2", NULL,
/* icon */		"w_hyperblaster",
/* pickup */	"HyperBlaster",
		50,
		1,
		"Cells",
		IT_WEAPON|IT_STAY_COOP,
		&hyperblaster_info,
		0,
/* precache */ "weapons/hyprbu1a.wav weapons/hyprbl1a.wav weapons/hyprbf1a.wav weapons/hyprbd1a.wav misc/lasfly.wav"
	},


/*QUAKED weapon_hyperblaster (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_hyperblaster", 
		NULL,
		Use_Weapon,
		NULL,
		Weapon_HyperBlaster,
		"misc/w_pkup.wav",
		"models/weapons/g_hyperb/tris.md2", 0, 0, 0,
		"models/weapons/v_hyper_builtin/tris.md2", NULL,
/* icon */		"w_hyperblaster",
/* pickup */	"builtin HyperBlaster",
		50,
		1,
		"Cells",
		IT_WEAPON|IT_STAY_COOP,
		&hyperblaster_info,
		0,
/* precache */ "weapons/hyprbu1a.wav weapons/hyprbl1a.wav weapons/hyprbf1a.wav weapons/hyprbd1a.wav misc/lasfly.wav"
	},

	// ROGUE
/*QUAKED weapon_plasmabeam (.3 .3 1) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN
*/ 
	{
		"weapon_plasmabeam",								// classname
		Pickup_Weapon,										// pickup function
		Use_Weapon,											// use function
		Drop_Weapon,										// drop function
		Weapon_Heatbeam,									// weapon think function
		"misc/w_pkup.wav",									// pick up sound
		"models/weapons/g_beamer/tris.md2", 13.5, 12, 5,	// world model, world model flags
		"models/weapons/v_beamer/tris.md2",	NULL,			// view model
		"w_plasma",											// icon
		"Plasma Beam",											// name printed when picked up 
		0,													// number of digits for statusbar
		// FIXME - if this changes, change it in NoAmmoWeaponChange as well
		2,													// amount used / contained
		"Cells",											// ammo type used 
		IT_WEAPON,											// inventory flags
		&plasma_info,												// info (void *)
		0,													// tag
		"models/weapons/v_beamer2/tris.md2 weapons/bfg__l1a.wav",		// precaches
	},
	//rogue


/* weapon_flamethrower (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_flamethrower", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Flamethrower,
		"misc/w_pkup.wav",
		"models/weapons/g_fthrow/tris.md2", 4.2, 7, 4,
		"models/weapons/v_fthrow/tris.md2", NULL,
/* icon */		"w_fthrow",
/* pickup */	"Flamethrower",
		0,
		1,
		"Napalm",
		IT_WEAPON,
		&flamethrower_info,
		0,
/* precache */ "models/objects/fire/tris.md2 models/objects/fire/c_tris.md2 weapons/rockfly.wav"
	},


/*QUAKED weapon_railgun (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_railgun", 
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_Railgun,
		"misc/w_pkup.wav",
		"models/weapons/g_rail/tris.md2", 15.6, 13, 6,
		"models/weapons/v_rail/tris.md2", NULL,
/* icon */		"w_railgun",
/* pickup */	"Railgun",
		0,
		1,
		"Slugs",
		IT_WEAPON|IT_STAY_COOP,
		&railgun_info,
		0,
/* precache */ "weapons/rg_hum.wav"
	},

/*QUAKED weapon_bfg (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"weapon_bfg",
		Pickup_Weapon,
		Use_Weapon,
		Drop_Weapon,
		Weapon_BFG,
		"misc/w_pkup.wav",
		"models/weapons/g_bfg/tris.md2", 25.0, 16, 8,
		"models/weapons/v_bfg/tris.md2", NULL,
/* icon */		"w_bfg",
/* pickup */	"BFG10K",
		250,
		50,
		"Cells",
		IT_WEAPON|IT_STAY_COOP,
		&bfg_info,
		0,
/* precache */ "sprites/s_bfg1.sp2 sprites/s_bfg2.sp2 sprites/s_bfg3.sp2 weapons/bfg__f1y.wav weapons/bfg__l1a.wav weapons/bfg__x1b.wav weapons/bfg_hum.wav"
	},
// =========================
// ROGUE WEAPONS
/*QUAKED weapon_disintegrator (.3 .3 1) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN
*/
	{
		"weapon_disintegrator",								// classname
		Pickup_Weapon,										// pickup function
		Use_Weapon,											// use function
		Drop_Weapon,										// drop function
		Weapon_Disintegrator,								// weapon think function
		"misc/w_pkup.wav",									// pick up sound
		"models/weapons/g_dist/tris.md2", 27.0,	10, 10,		// world model, world model flags
		"models/weapons/v_dist/tris.md2", NULL,				// view model
		"w_disintegrator",									// icon
		"Disruptor",										// name printed when picked up 
		0,													// number of digits for statusbar
		1,													// amount used / contained
		"Rounds",											// ammo type used 
		IT_WEAPON,											// inventory flags
		&disruptor_info,									// info (void *)
		1,													// tag
		"models/items/spawngro/tris.md2 models/proj/disintegrator/tris.md2 weapons/disrupt.wav weapons/disint2.wav weapons/disrupthit.wav",	// precaches
	},

// ROGUE WEAPONS
// =========================


	//
	// AMMO ITEMS
	//

/*QUAKED ammo_shells (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_shells",
		Pickup_Ammo,
		Use_Nothing,
		Drop_Ammo,
		NULL,
		"misc/am_pkup.wav",
		"models/items/ammo/shells/small/tris.md2", SHELLS_WEIGHT, 4, 6,
		NULL, NULL,
/* icon */		"a_shells",
/* pickup */	"Shells",
/* width */		3,
		24,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_SHELLS,
/* precache */ ""
	},

	/*QUAKED ammo_bullets (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_bullets",
		Pickup_Ammo,
		Use_Nothing,
		Drop_Ammo,
		NULL,
		"misc/am_pkup.wav",
		"models/items/ammo/bullets/small/tris.md2", BULLETS_WEIGHT, 4, 7,
		NULL, NULL,
/* icon */		"a_bullets",
/* pickup */	"Bullets",
/* width */		3,
		30,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_BULLETS,
/* precache */ ""
	},

/*QUAKED ammo_cells (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_cells",
		Pickup_Ammo,
		Use_Nothing,
		Drop_Ammo,
		NULL,
		"misc/am_pkup.wav",
		"models/items/ammo/cells/small/tris.md2", 0.0, 2, 4,
		NULL, NULL,
/* icon */		"a_cells",
/* pickup */	"Cells",
/* width */		3,
		50,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_CELLS,
/* precache */ ""
	},

/*QUAKED ammo_rockets (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_rockets",
		Pickup_Ammo,
		Use_Nothing,
		Drop_Ammo,
		NULL,
		"misc/am_pkup.wav",
		"models/items/ammo/rockets/small/tris.md2", ROCKETS_WEIGHT, 4, 10,
		NULL, NULL,
/* icon */		"a_rockets",
/* pickup */	"Rockets",
/* width */		3,
		4,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_ROCKETS,
/* precache */ ""
	},

/*QUAKED ammo_slugs (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_slugs",
		Pickup_Ammo,
		Use_Nothing,
		Drop_Ammo,
		NULL,
		"misc/am_pkup.wav",
		"models/items/ammo/slugs/small/tris.md2", SLUGS_WEIGHT, 3, 6,
		NULL, NULL,
/* icon */		"a_slugs",
/* pickup */	"Slugs",
/* width */		3,
		18,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_SLUGS,
/* precache */ ""
	},

/*QUAKED ammo_slugs (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"ammo_napalm",
		Pickup_Ammo,
		Use_Nothing,
		Drop_Ammo,
		NULL,
		"misc/am_pkup.wav",
		"models/items/ammo/napalm/small/tris.md2", NAPALM_WEIGHT, 2, 4,
		NULL, NULL,
/* icon */		"a_napalm",
/* pickup */	"Napalm",
/* width */		3,
		100,
		NULL,
		IT_AMMO,
		NULL,
		AMMO_NAPALM,
/* precache */ ""
	},

/*QUAKED item_ir_goggles (.3 .3 1) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN
*/
	{
		"item_ir_goggles",
		Pickup_Useable,
		Use_IR,
		Drop_Goggles,
		NULL,
		"items/pkup.wav",
		"models/items/goggles/tris.md2", 1.5, 3, 3,
		NULL, NULL,
/* icon */		"p_ir",
/* pickup */	"Imaging Goggles",
/* width */		2,
		60,
		NULL,
		IT_POWERUP,
		NULL,
		0,
/* precache */ "misc/ir_start.wav"
	},

#if 0
/*QUAKED item_breather (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_breather",
		Pickup_Useable,
		Use_Breather,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/breather/tris.md2", 2, 4, 4,
		NULL, NULL,
/* icon */		"p_rebreather",
/* pickup */	"Rebreather",
/* width */		2,
		60,
		NULL,
		IT_STAY_COOP|IT_POWERUP,
		NULL,
		0,
/* precache */ "items/airout.wav"
	},

/*QUAKED item_enviro (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
	{
		"item_enviro",
		Pickup_Useable,
		Use_Envirosuit,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/enviro/tris.md2", 10, 8, 8,
		NULL, NULL,
/* icon */		"p_envirosuit",
/* pickup */	"Environment Suit",
/* width */		2,
		60,
		NULL,
		IT_STAY_COOP|IT_POWERUP,
		NULL,
		0,
/* precache */ "items/airout.wav"
	},
#endif
	//
	// KEYS
	//
/*QUAKED key_data_cd (0 .5 .8) (-16 -16 -16) (16 16 16)
key for computer centers
*/
	{
		"key_data_cd",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/data_cd/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_datacd",
		"Data CD",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_power_cube (0 .5 .8) (-16 -16 -16) (16 16 16) TRIGGER_SPAWN NO_TOUCH
warehouse circuits
*/
	{
		"key_power_cube",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/power/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_powercube",
		"Power Cube",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_pyramid (0 .5 .8) (-16 -16 -16) (16 16 16)
key for the entrance of jail3
*/
	{
		"key_pyramid",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/pyramid/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_pyramid",
		"Pyramid Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_pyramid (0 .5 .8) (-16 -16 -16) (16 16 16)
key for the entrance of jail3
*/
	{
		"item_scanner",
		NULL,
		Use_Nothing,
		NULL,
		NULL,
		"items/pkup.wav",
		NULL, 0, 0, 0,
		NULL, NULL,
		"k_pyramid",
		"builtin Scanner",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_data_spinner (0 .5 .8) (-16 -16 -16) (16 16 16)
key for the city computer
*/
	{
		"key_data_spinner",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/spinner/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_dataspin",
		"Data Spinner",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_pass (0 .5 .8) (-16 -16 -16) (16 16 16)
security pass for the security level
*/
	{
		"key_pass",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/pass/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_security",
		"Security Pass",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_blue_key (0 .5 .8) (-16 -16 -16) (16 16 16)
normal door key - blue
*/
	{
		"key_blue_key",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/key/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_bluekey",
		"Blue Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_red_key (0 .5 .8) (-16 -16 -16) (16 16 16)
normal door key - red
*/
	{
		"key_red_key",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/red_key/tris.md2", 0, 0, 0,
		NULL, NULL,
		"k_redkey",
		"Red Key",
		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_commander_head (0 .5 .8) (-16 -16 -16) (16 16 16)
tank commander's head
*/
	{
		"key_commander_head",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/monsters/commandr/head/tris.md2", 1, 0, 0,
		NULL, NULL,
/* icon */		"k_comhead",
/* pickup */	"Commander's Head",
/* width */		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

/*QUAKED key_airstrike_target (0 .5 .8) (-16 -16 -16) (16 16 16)
tank commander's head
*/
	{
		"key_airstrike_target",
		Pickup_Key,
		Use_Nothing,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/keys/target/tris.md2", 2, 4, 4,
		NULL, NULL,
/* icon */		"i_airstrike",
/* pickup */	"Airstrike Marker",
/* width */		2,
		0,
		NULL,
		IT_STAY_COOP|IT_KEY,
		NULL,
		0,
/* precache */ ""
	},

	{
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		"items/pkup.wav",
		NULL, 0, 0, 0,
		NULL, NULL,
/* icon */		"i_health",
/* pickup */	"Health",
/* width */		3,
		0,
		NULL,
		IT_HEALTH,
		NULL,
		0,
/* precache */ ""
	},

	{
		"item_stimpak",
		Pickup_Useable,
		Use_Health,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/health/stimpack/tris.md2", 2.0, 2, 4,
		NULL, NULL,
/* icon */		"i_health1",
/* pickup */	"Bandages",
/* width */		3,
		0,
		NULL,
		IT_HEALTH,
		NULL,
		0,
/* precache */ ""
	},


	{
		"item_medipak",
		Pickup_Useable,
		Use_Health,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/health/medium/tris.md2", 5.0, 4, 3,
		NULL, NULL,
/* icon */		"i_health2",
/* pickup */	"Medipak",
/* width */		3,
		5,
		NULL,
		IT_HEALTH,
		NULL,
		0,
/* precache */ ""
	},

	{
		"item_medikit",
		Pickup_Useable,
		Use_Health,
		Drop_General,
		NULL,
		"items/pkup.wav",
		"models/items/health/large/tris.md2", 8.0, 4, 4,
		NULL, NULL,
/* icon */		"i_health3",
/* pickup */	"Medikit",
/* width */		3,
		10,
		NULL,
		IT_HEALTH,
		NULL,
		0,
/* precache */ ""
	},


//ZOID
/*QUAKED item_flag_team1 (1 0.2 0) (-16 -16 -24) (16 16 32)
*/
	{
		"item_flag_team1",
		CTFPickup_Flag,
		Use_Nothing,
		CTFDrop_Flag, //Should this be null if we don't want players to drop it manually?
		NULL,
		"ctf/flagtk.wav",
		"players/male/flag1.md2", 15, 0, 0,
		NULL, NULL,
/* icon */		"i_ctf1",
/* pickup */	"Red Flag",
/* width */		2,
		0,
		NULL,
		0,
		NULL,
		0,
/* precache */ "ctf/flagcap.wav"
	},

/*QUAKED item_flag_team2 (1 0.2 0) (-16 -16 -24) (16 16 32)
*/
	{
		"item_flag_team2",
		CTFPickup_Flag,
		Use_Nothing,
		CTFDrop_Flag, //Should this be null if we don't want players to drop it manually?
		NULL,
		"ctf/flagtk.wav",
		"players/male/flag2.md2", 15, 0, 0,
		NULL, NULL,
/* icon */		"i_ctf2",
/* pickup */	"Blue Flag",
/* width */		2,
		0,
		NULL,
		0,
		NULL,
		0,
/* precache */ "ctf/flagcap.wav"
	},

	// end of list marker
	{NULL}
};


/*QUAKED item_health (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	self->count = 10;
	SpawnItem (self, FindItem ("Medipak"));
	gi.soundindex ("items/n_health.wav");
}

/*QUAKED item_health_small (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health_small (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	SpawnItem (self, FindItem ("Bandages"));
	//self->style = HEALTH_IGNORE_MAX;
	gi.soundindex ("items/s_health.wav");
}

/*QUAKED item_health_large (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health_large (edict_t *self)
{
	if ( deathmatch->value && ((int)dmflags->value & DF_NO_HEALTH) )
	{
		G_FreeEdict (self);
		return;
	}

	SpawnItem (self, FindItem ("Medikit"));
	gi.soundindex ("items/l_health.wav");
}

/*QUAKED item_health_mega (.3 .3 1) (-16 -16 -16) (16 16 16)
*/
void SP_item_health_mega (edict_t *self)
{
	G_FreeEdict (self);
	return;
	
	self->model = "models/items/mega_h/tris.md2";
	self->count = 100;
	SpawnItem (self, FindItem ("Health"));
	gi.soundindex ("items/m_health.wav");
	//self->style = HEALTH_IGNORE_MAX|HEALTH_TIMED;
}


void InitItems (void)
{
	game.num_items = sizeof(itemlist)/sizeof(itemlist[0]) - 1;
}



/*
===============
SetItemNames

Called by worldspawn
===============
*/
void SetItemNames (void)
{
	int		i;
	gitem_t	*it;

	for (i=0 ; i<game.num_items ; i++)
	{
		it = &itemlist[i];
		gi.configstring (CS_ITEMS+i, it->pickup_name);
	}
	
	plate_armor_index = ITEM_INDEX(FindItem("Plate Armor"));
	jacket_armor_index = ITEM_INDEX(FindItem("Jacket Armor"));
	combat_armor_index = ITEM_INDEX(FindItem("Combat Armor"));
	body_armor_index   = ITEM_INDEX(FindItem("Body Armor"));
	bandolier_index    = ITEM_INDEX(FindItem("Bandolier"));
	backpack_index    = ITEM_INDEX(FindItem("Backpack"));
	power_screen_index = ITEM_INDEX(FindItem("Power Screen"));
	power_shield_index = ITEM_INDEX(FindItem("Power Shield"));
}

float CalcBulk(edict_t *ent)
{
	gitem_t *item;
	float bulk = 0;
	int i;
	for(i = 0; i < MAX_ITEMS; i++)
	if(ent->client->pers.inventory[i])
	{
		item = GetItemByIndex(i);
		if(item->flags & IT_ARMOR)
			bulk += 0;
		else
			bulk += item->bulk * ent->client->pers.inventory[i];
	}
	return bulk;
}

void CalcMass(edict_t *ent)
{
	ent->mass = ent->client->basemass + ent->client->encumbrance 
		            + ent->client->pers.shotgun_ammo * SHELLS_WEIGHT
					+ ent->client->pers.sshotgun_ammo * SHELLS_WEIGHT
					+ ent->client->pers.grenade_ammo * GRENADES_WEIGHT
					+ ent->client->pers.rocket_ammo * ROCKETS_WEIGHT
					+ ent->client->pers.railgun_ammo * SLUGS_WEIGHT;
	if(ArmorIndex(ent))
		ent->mass += GetItemByIndex(ArmorIndex(ent))->bulk;
	
	
	
}
qboolean CheckEncumbrance(edict_t *ent, float bulk)
{
	if(ArmorIndex(ent) == backpack_index)
	{
		if(ent->client->encumbrance + bulk > 2 * ent->client->max_carry) return false;
	}
	else if(ArmorIndex(ent) == bandolier_index)
	{
		if(ent->client->encumbrance + bulk > 3 * ent->client->max_carry / 2) return false;
	}
	else if(ent->client->encumbrance + bulk > ent->client->max_carry)
		return false;
	return true;
}