    #include "g_local.h"
    #include "m_player.h"

    static int	sound_idle;
    static int	sound_sight1;
    static int	sound_sight2;
    static int	sound_pain;
    static int	sound_death;

// STAND frames
void railbot_idle (edict_t *self)
{
	if (random() > 0.8)
		gi.sound (self, CHAN_VOICE, sound_idle, 1, ATTN_IDLE, 0);
}

void railbot_stand (edict_t *self);

mframe_t railbot_frames_stand1 [] =
{
    ai_stand, 0, railbot_idle,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,

    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,

    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,

    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL
};
mmove_t railbot_move_stand1 = {FRAME_stand01, FRAME_stand40, railbot_frames_stand1, railbot_stand};

void railbot_stand (edict_t *self)
{
    self->monsterinfo.currentmove = &railbot_move_stand1;
}


// TAUNT frames
void railbot_taunt (edict_t *self);

mframe_t railbot_frames_taunt1 [] =
{
    ai_stand, 0, railbot_idle,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,

    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL
};
mmove_t railbot_move_taunt1 = {FRAME_taunt01, FRAME_taunt17, railbot_frames_taunt1, railbot_taunt};

void railbot_taunt (edict_t *self)
{
    self->monsterinfo.currentmove = &railbot_move_taunt1;
}


//
// RUN frames
//
void railbot_run (edict_t *self);
mframe_t railbot_frames_run [] =
{
    ai_run, 10, NULL,
    ai_run, 11, NULL,
    ai_run, 11, NULL,
    ai_run, 16, NULL,
    ai_run, 10, NULL,
    ai_run, 15, NULL
};
mmove_t railbot_move_run = {FRAME_run1, FRAME_run6, railbot_frames_run, railbot_run};

void railbot_run (edict_t *self)
{
    if (self->monsterinfo.aiflags & AI_STAND_GROUND)
    {
        self->monsterinfo.currentmove = &railbot_move_stand1;
        return;
    }

    self->monsterinfo.currentmove = &railbot_move_run;
}


//
// PAIN frames
//
mframe_t railbot_frames_pain1 [] =
{
	ai_move, -3, NULL,
	ai_move, 4,  NULL,
	ai_move, 1,  NULL,
	ai_move, 0,  NULL
};
mmove_t railbot_move_pain1 = {FRAME_pain101, FRAME_pain104, railbot_frames_pain1, railbot_run};

void railbot_pain (edict_t *self, edict_t *other, float kick, int damage)
{
    if (level.time < self->pain_debounce_time)
        return;

    self->pain_debounce_time = level.time + 3;
    gi.sound (self, CHAN_VOICE, sound_pain, 1, ATTN_NORM, 0);
    self->monsterinfo.currentmove = &railbot_move_pain1;
}


//
// ATTACK frames
//
static int blaster_flash [] = {MZ2_SOLDIER_BLASTER_1, MZ2_SOLDIER_BLASTER_2, MZ2_SOLDIER_BLASTER_3, MZ2_SOLDIER_BLASTER_4, MZ2_SOLDIER_BLASTER_5, MZ2_SOLDIER_BLASTER_6, MZ2_SOLDIER_BLASTER_7, MZ2_SOLDIER_BLASTER_8};
static int shotgun_flash [] = {MZ2_SOLDIER_SHOTGUN_1, MZ2_SOLDIER_SHOTGUN_2, MZ2_SOLDIER_SHOTGUN_3, MZ2_SOLDIER_SHOTGUN_4, MZ2_SOLDIER_SHOTGUN_5, MZ2_SOLDIER_SHOTGUN_6, MZ2_SOLDIER_SHOTGUN_7, MZ2_SOLDIER_SHOTGUN_8};
static int machinegun_flash [] = {MZ2_SOLDIER_MACHINEGUN_1, MZ2_SOLDIER_MACHINEGUN_2, MZ2_SOLDIER_MACHINEGUN_3, MZ2_SOLDIER_MACHINEGUN_4, MZ2_SOLDIER_MACHINEGUN_5, MZ2_SOLDIER_MACHINEGUN_6, MZ2_SOLDIER_MACHINEGUN_7, MZ2_SOLDIER_MACHINEGUN_8};

void RailBot_fire (edict_t *self, int flash_number)
{
    vec3_t  start;
    vec3_t  forward, right, up;
    vec3_t  aim;
    vec3_t  dir;
    vec3_t  end;
    float   r, u;
    int     flash_index;

    flash_index = shotgun_flash[flash_number];

    AngleVectors (self->s.angles, forward, right, NULL);
    G_ProjectSource (self->s.origin, monster_flash_offset[flash_index], forward, right, start);

    if (flash_number == 5 || flash_number == 6)
    {
        VectorCopy (forward, aim);
    }
    else
    {
        VectorCopy (self->enemy->s.origin, end);
        end[2] += self->enemy->viewheight;
        VectorSubtract (end, start, aim);
        vectoangles (aim, dir);
        AngleVectors (dir, forward, right, up);

        r = crandom()*1000;
        u = crandom()*500;
        VectorMA (start, 8192, forward, end);
        VectorMA (end, r, right, end);
        VectorMA (end, u, up, end);

        VectorSubtract (end, start, aim);
        VectorNormalize (aim);
    }

    monster_fire_railgun (self, start, aim, 50, 100, MZ2_GLADIATOR_RAILGUN_1);
}

// Fire weapon
void RailBot_fire1 (edict_t *self)
{
    RailBot_fire (self, 0);
}

mframe_t RailBot_frames_attack1 [] =
{
    ai_charge, 0,  NULL,
    ai_charge, 0,  NULL,
    ai_charge, 0,  RailBot_fire1,
    ai_charge, 0,  NULL,
    ai_charge, 0,  NULL,
    ai_charge, 0,  NULL,
    ai_charge, 0,  NULL,
    ai_charge, 0,  NULL
};
mmove_t RailBot_move_attack1 = {FRAME_attack1, FRAME_attack8, RailBot_frames_attack1, railbot_run};

void RailBot_attack(edict_t *self)
{
    self->monsterinfo.currentmove = &RailBot_move_attack1;
}

  //
  // SIGHT logic
  //
  void railbot_sight(edict_t *self, edict_t *other)
	{
	if (random() < 0.5)
		gi.sound (self, CHAN_VOICE, sound_sight1, 1, ATTN_NORM, 0);
	else
		gi.sound (self, CHAN_VOICE, sound_sight2, 1, ATTN_NORM, 0);
	}

  //
  // DEATH sequence
  //
  void railbot_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
	{
	//	int		n;

	if (self->deadflag == DEAD_DEAD)
		return;

	self->deadflag = DEAD_DEAD;
	self->takedamage = DAMAGE_YES;

	gi.sound (self, CHAN_VOICE, sound_death, 1, ATTN_NORM, 0);

        //do a BFG kind of explosion where the railbot was
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_EXPLOSION);
	gi.WritePosition (self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);

	//Clear pointer of owner
        self->creator->railbot = NULL;

	//Remove entity instead of playing death sequence
	G_FreeEdict (self);

	}

  //
  // SPAWN
  //
  void spawn_railbot (edict_t *owner)
  {
      edict_t *self;
      vec3_t forward;

      self = G_Spawn();

      // Place railbot 100 units forward of our position
      AngleVectors(owner->client->v_angle, forward, NULL, NULL);
      VectorMA(owner->s.origin, 100, forward, self->s.origin);
 
      //Link two entities together
      owner->railbot = self;      //for the owner, this is a pointer to the railbot
      self->creator = owner;    //for the railbot, this is a pointer to the owner

      //Use same model and skin as the person creating railbot
      self->model = owner->model;
      self->s.skinnum = owner->s.skinnum;
      self->s.modelindex = owner->s.modelindex;
      self->s.modelindex2 = owner->s.modelindex;

      self->s.effects = 0;
      self->s.frame = 0;
      self->classname = "railbot";
      self->health = 100;
      self->max_health = 100;
      self->tw_team = owner->tw_team;
	
      self->monsterinfo.scale = MODEL_SCALE;
      VectorSet (self->mins, -16, -16, -24);
      VectorSet (self->maxs, 16, 16, 32);
      self->movetype = MOVETYPE_STEP;
      self->solid = SOLID_BBOX;
      self->clipmask = MASK_PLAYERSOLID;
      self->takedamage = DAMAGE_AIM;

      self->mass = 100;
      self->pain = railbot_pain;
      self->die = railbot_die;
      self->monsterinfo.stand = railbot_stand;
      self->monsterinfo.walk = NULL;
      self->monsterinfo.run = railbot_run;
      self->monsterinfo.dodge = NULL;
      self->monsterinfo.attack = RailBot_attack;
      self->monsterinfo.melee = NULL;
      self->monsterinfo.sight = railbot_sight;

      //Dont attack anything to start with
      self->monsterinfo.aiflags & AI_GOOD_GUY;

      //Set up sounds
      sound_idle =    gi.soundindex ("soldier/solidle1.wav");
      sound_sight1 =  gi.soundindex ("soldier/solsght1.wav");
      sound_sight2 =  gi.soundindex ("soldier/solsrch1.wav");
      sound_pain = gi.soundindex ("soldier/solpain1.wav");
      sound_death = gi.soundindex ("misc/keyuse.wav");
      gi.soundindex ("soldier/solatck1.wav");

      self->health = 30;
      self->gib_health = -30;

      // Face the railbot the same direction as player
      self->s.angles[PITCH] = owner->s.angles[PITCH];
      self->s.angles[YAW] = owner->s.angles[YAW];
      self->s.angles[ROLL] = owner->s.angles[ROLL];

      gi.linkentity (self);

      // First animation sequence
      self->monsterinfo.stand (self);

      //Let monster code control this railbot
      walkmonster_start (self);
  }

  // SP_RailBot Handle railbot command
  void SP_RailBot(edict_t *self) 
  {

      //See if we should railbot turn it on or off
      char    *string;
      int  turnon;

      string=gi.args();

      if (Q_stricmp ( string, "on") == 0) 
          turnon = true;
      else if (Q_stricmp ( string, "off") == 0) 
          turnon = false;
      else {  //toggle status
          if (self->railbot) turnon = false;
              else turnon = true;
      }


      //If they want to turn it on and it's already on, return
      if ( (turnon == true) && (self->railbot) ) return;

      //If they want to turn it off and it's already off, return
      if ( (turnon == false) && !(self->railbot) ) return;

      //Remove railbot if it exists
      if ( self->railbot ) 
      {
          G_FreeEdict(self->railbot);
          self->railbot = NULL;
          gi.cprintf (self, PRINT_HIGH, "RailBot destroyed.\n");
          return;
          }

      //Create railbot
      spawn_railbot(self);

      gi.cprintf (self, PRINT_HIGH, "RailBot created.\n");
      }


