#include "main.h"

static const char *g_windowClass = "f_gltriad";
static const char *g_windowTitle = "GLTriad";

static int g_fullScreen = 0;

int g_displayWidth = 0;
int g_displayHeight = 0;

LPDIRECT3D8 g_pD3D = NULL;
LPDIRECT3DDEVICE8 g_pd3dDevice = NULL;
LPDIRECT3DVERTEXBUFFER8 g_pVB = NULL;

int g_keysPressed[NUM_KEYS];
int g_keysDebounce[NUM_KEYS];


//standard message box print
void Window_Print (const char *string, ...)
{
	char finalString[MAX_PRINT_CHARS];
	va_list args;
	
	va_start(args, string);
	vsprintf(finalString, string, args);
	va_end(args);

	//XBOXFIXME
	/*
	if (g_hWnd)
	{
		MessageBox(g_hWnd, finalString, "Error", MB_OK);

		//clear debounce keys since we won't get keyup messages while this is up
		memset(g_keysDebounce, 0, sizeof(g_keysDebounce));
		memset(g_keysPressed, 0, sizeof(g_keysPressed));
	}
	*/
}

//called to resize the window
void Window_Resize(int width, int height)
{
	if (height <= 0)
	{
		assert(0);
		height = 1;
	}
	if (width <= 0)
	{
		assert(0);
		width = 1;
	}

	glViewport(0, 0, width, height);

	g_displayWidth = width;
	g_displayHeight = height;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	GL_CalcPerspective(45.0f, (float)width/(float)height, Z_NEAR, Z_FAR);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

//called to close window
void Window_Close(void)
{
	/*
	if (g_fullScreen)
	{
		ChangeDisplaySettings(NULL, 0);
		ShowCursor(TRUE);
	}

	if (g_hRC)
	{
		wglMakeCurrent(NULL, NULL);
		wglDeleteContext(g_hRC);
		g_hRC = 0;
	}

	if (g_hDC && !ReleaseDC(g_hWnd, g_hDC))
	{
		g_hDC = 0;
	}

	if (g_hWnd && !DestroyWindow(g_hWnd))
	{
		g_hWnd = 0;
	}

	if (!UnregisterClass(g_windowClass, g_hInstance))
	{
		g_hInstance = 0;
	}
	*/
	//xbox does not need cleanup
}

//create the main window
int Window_Create(HWND wnd, int width, int height, int bits, int fullScreen)
{
	g_pD3D = Direct3DCreate8(D3D_SDK_VERSION);
	if (!g_pD3D)
	{
		return E_FAIL;
	}

	D3DPRESENT_PARAMETERS d3dpp; 

	memset(&d3dpp, 0, sizeof(d3dpp));
	d3dpp.BackBufferWidth = width;
	d3dpp.BackBufferHeight = height;
	d3dpp.BackBufferFormat = D3DFMT_LIN_X8R8G8B8;
	d3dpp.BackBufferCount = 1;
	d3dpp.EnableAutoDepthStencil = TRUE;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D24S8;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE_OR_IMMEDIATE;

	if (FAILED(g_pD3D->CreateDevice(0, D3DDEVTYPE_HAL, NULL, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &g_pd3dDevice)))
	{
		return E_FAIL;
	}

	Window_Resize(width, height);

	if (!GL_Init())
	{
		Window_Close();
		return 0;
	}

	return 1;
}
