#include "main.h"

#ifndef _USE_SAVECFG

#define CONFIG_NAME "XTriad.cfg"

//save userinfo
int User_SaveUI(void)
{
	int fileHandle;
	char p[MAX_PATH_CHARS];

	sprintf(p, "T:\\%s", CONFIG_NAME);
	fileHandle = _open(p, _O_WRONLY|_O_BINARY|_O_CREAT, _S_IWRITE);

	if (fileHandle == -1)
	{
		return 0;
	}

	_write(fileHandle, &g_userInfo, sizeof(g_userInfo));
	_close(fileHandle);
	return 1;
}

//load userinfo
int User_LoadUI(void)
{
	int fileHandle;
	char p[MAX_PATH_CHARS];

	sprintf(p, "T:\\%s", CONFIG_NAME);

	fileHandle = _open(p, _O_RDONLY|_O_BINARY, _S_IREAD);

	if (fileHandle == -1)
	{
		return 0;
	}

	_read(fileHandle, &g_userInfo, sizeof(g_userInfo));
	_close(fileHandle);
	return 1;
}

#else

#define CONFIG_NAME "gltriad.cfg"

//save userinfo
int User_SaveUI(void)
{
	int fileHandle;
	char p[MAX_PATH_CHARS];

	sprintf(p, "%s\\%s", g_workingDir, CONFIG_NAME);
	fileHandle = _open(p, _O_WRONLY|_O_BINARY|_O_CREAT, _S_IWRITE);

	if (fileHandle == -1)
	{
		return 0;
	}

	_write(fileHandle, &g_userInfo, sizeof(g_userInfo));
	_close(fileHandle);
	return 1;
}

//load userinfo
int User_LoadUI(void)
{
	int fileHandle;
	char p[MAX_PATH_CHARS];

	sprintf(p, "%s\\%s", g_workingDir, CONFIG_NAME);

	fileHandle = _open(p, _O_RDONLY|_O_BINARY, _S_IREAD);

	if (fileHandle == -1)
	{
		return 0;
	}

	_read(fileHandle, &g_userInfo, sizeof(g_userInfo));
	_close(fileHandle);
	return 1;
}

#endif
