#define _USE_WINSOCK

#ifdef _USE_WINSOCK

//#include <afxsock.h>
#include <Winsockx.h>

/*
#define MAX_PACKET_SIZE		32
typedef struct basePacketHeader_s
{
	int			totalSize;
	int			sequences;
} basePacketHeader_t;
*/
#define MAX_SEND_BUFFER_SIZE	8192

typedef struct packetHeader_s
{
	int			pType;
	int			dataLen;
} packetHeader_t;

class CAsyncSocket
{
public:
	CAsyncSocket();
	~CAsyncSocket();

	virtual BOOL Accept(CAsyncSocket& rConnectedSocket,
		SOCKADDR* lpSockAddr = NULL, int* lpSockAddrLen = NULL);
	virtual void Close();

	BOOL Create(UINT nSocketPort = 0, int nSocketType=SOCK_STREAM,
		long lEvent = 0,
		LPCTSTR lpszSocketAddress = NULL);
	BOOL Connect(LPCTSTR lpszHostAddress, UINT nHostPort);
	BOOL Listen(int nConnectionBacklog=5);
	virtual int Receive(void* lpBuf, int nBufLen, int nFlags = 0);
	virtual int Send(const void* lpBuf, int nBufLen, int nFlags = 0);

	bool SocketLogic(void);

	void SetSocket(SOCKET socket) { m_socket = socket; }
	void SetNetThread(HANDLE thread) { m_netThread = thread; }
	void SetActive(bool active) { m_transferActive = active; }

protected:
	virtual void OnSend(int nErrorCode);
	virtual void OnAccept(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);

private:
	SOCKET			m_socket;
	HANDLE			m_netThread;
	bool			m_listening;
	bool			m_transferActive;

	SOCKET			m_acceptSocket;
	byte			m_incoming[256];
	int				m_inLen;

	packetHeader_t	m_testBuffer;
	//byte			m_testBuffer;
	bool			m_hasTestBuffer;

	int				m_sendBufferSize;
	char			m_sendBuffer[MAX_SEND_BUFFER_SIZE];
};

//custom socket class
class CTriadSocket : public CAsyncSocket
{
public:
	void PacketSend(void *data, int type, int len);
protected:
	virtual void OnSend(int nErrorCode);
	virtual void OnAccept(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);
};

#define PTYPE_REQUESTSTATE			0
#define PTYPE_SENDSTATE				1
#define PTYPE_SENDCARDS				2
#define PTYPE_SENDCHOICE			3
#define PTYPE_SENDELEM				4
#define PTYPE_SENDGENERAL			5
#define PTYPE_RESTART				6
#define PTYPE_RESTART2				7

typedef struct sendCard_s
{
	/*
	int			num;
	int			altTex;
	int			pCardIndex;
	int			gotoGrid;
	int			selected;
	*/
	byte		num;
	byte		altTex;
	byte		pCardIndex;
	byte		gotoGrid;
	byte		selected;
} sendCard_t;

typedef struct sendChoice_s
{
	int			decision;
} sendChoice_t;

typedef struct sendGeneral_s
{
	int			score;
} sendGeneral_t;

//extern funcs/vars
void Game_TallyCards(void);
void Game_SetupLocalPlayerTurn(void);

extern drawCard_t g_pl1Cards[NUM_CARDS_PER_PLAYER];
extern drawCard_t g_pl2Cards[NUM_CARDS_PER_PLAYER];
#endif
