#include "dshow.h"

#ifndef _USE_DSHOW
#define MAX_ATTACHED_PACKETS		3
#define MAX_PACKET_BYTES			32768//((2 * 2 * 36 * 128)*4)
static XWmaFileMediaObject *g_pWMASourceFilter = NULL;
static XFileMediaObject *g_pSourceFilter = NULL;
static IDirectSoundStream *g_pRenderFilter = NULL;
static void *g_pvSourceBuffer = NULL;

bool Music_Init(void)
{
	return false;
}

static DWORD g_packetStatus[MAX_ATTACHED_PACKETS] = {
	XMEDIAPACKET_STATUS_SUCCESS,
	XMEDIAPACKET_STATUS_SUCCESS,
	XMEDIAPACKET_STATUS_SUCCESS };

void Music_FrameChecks(int packetNum)
{
	DWORD dwTotalSourceUsed   = 0;
	DWORD dwSourceUsed;
	XMEDIAPACKET xmp;
	HRESULT r;

	if (!g_pvSourceBuffer)
	{
		return;
	}

	DirectSoundDoWork();

	if (g_packetStatus[packetNum] == XMEDIAPACKET_STATUS_PENDING)
	{
		return;
	}

	memset(&xmp, 0, sizeof(xmp));
	xmp.pvBuffer = (BYTE *)g_pvSourceBuffer+(packetNum*MAX_PACKET_BYTES);
	xmp.dwMaxSize = MAX_PACKET_BYTES;
	xmp.pdwCompletedSize = &dwSourceUsed;

    while (dwTotalSourceUsed < MAX_PACKET_BYTES)
    {
		if (g_pWMASourceFilter)
		{
			g_pWMASourceFilter->DoWork();
			r = g_pWMASourceFilter->Process(NULL, &xmp);
		}
		else
		{
			r = g_pSourceFilter->Process(NULL, &xmp);
		}
		if (FAILED(r))
		{
			return;
		}

		dwTotalSourceUsed += dwSourceUsed;

		if (dwSourceUsed < xmp.dwMaxSize)
		{
			xmp.pvBuffer  = (BYTE*)xmp.pvBuffer + dwSourceUsed;
			xmp.dwMaxSize = xmp.dwMaxSize - dwSourceUsed;
		    
			if (g_pWMASourceFilter)
			{
				//r = g_pWMASourceFilter->Seek(0, FILE_BEGIN, NULL);
				r = g_pWMASourceFilter->Flush();
			}
			else
			{
				r = g_pSourceFilter->Seek(0, FILE_BEGIN, NULL);
			}
			if (FAILED(r))
			{
				return;
			}
		}
    }

	memset(&xmp, 0, sizeof(xmp));
	xmp.pvBuffer = (BYTE *)g_pvSourceBuffer+(packetNum*MAX_PACKET_BYTES);
	xmp.dwMaxSize = MAX_PACKET_BYTES;
	xmp.pdwStatus = &g_packetStatus[packetNum];

	r = g_pRenderFilter->Process( &xmp, NULL );
	if (FAILED(r))
	{
		return;
	}
}

bool Music_PlaySample(const char *filename)
{
	HRESULT r;
	WAVEFORMATEX waveFormat;
	LPCWAVEFORMATEX pwfxSourceFormat;
	DSSTREAMDESC dssd;

	if (strstr(filename, ".wma"))
	{
		WMAXMODECODERPARAMETERS param;

		param.pszFileName = filename;
		param.hFile = 0;
		param.dwFileOffset = 0;
		param.dwLookaheadBufferSize = MAX_PACKET_BYTES*8;//8192;//4096;
		r = XWmaDecoderCreateMediaObject(&param, &g_pWMASourceFilter);
		memset(&waveFormat, 0, sizeof(waveFormat));
		waveFormat.cbSize = 0;
		waveFormat.wFormatTag = WAVE_FORMAT_PCM; //standard pcm wave data
		waveFormat.nChannels = 2; //stereo
		waveFormat.wBitsPerSample = 16; //16 bits
		waveFormat.nSamplesPerSec = 44100; //44.1kHz
		waveFormat.nBlockAlign = waveFormat.nChannels*(waveFormat.wBitsPerSample/8); //hmm, don't ask me, this is what MSDN says it should be.
		waveFormat.nAvgBytesPerSec = (waveFormat.nSamplesPerSec*waveFormat.nBlockAlign); //ditto
		pwfxSourceFormat = &waveFormat;
	}
	else
	{
		r = XWaveFileCreateMediaObject(filename, &pwfxSourceFormat, &g_pSourceFilter);
	}
	if (FAILED(r))
	{
		return false;
	}

	memset(&dssd, 0, sizeof(dssd));
	dssd.dwMaxAttachedPackets = MAX_ATTACHED_PACKETS;
	dssd.lpwfxFormat = (LPWAVEFORMATEX)pwfxSourceFormat;

	r = DirectSoundCreateStream(&dssd, &g_pRenderFilter);
	if (FAILED(r))
	{
		return false;
	}

	if (!g_pvSourceBuffer)
	{
		g_pvSourceBuffer = XPhysicalAlloc(MAX_PACKET_BYTES * MAX_ATTACHED_PACKETS,
											MAXULONG_PTR,
											0,
											PAGE_READWRITE | PAGE_NOCACHE);
	}

	return true;
}

bool Music_StartSampleCurrent(const char *filename)
{
	return false;
}

void Music_Shutdown(void)
{
}

#else

#include <malloc.h>

 //eh, yeah. crazy base class sdk shit.
#include <ctlutil.cpp>
#include <mtype.cpp>
#include <wxlist.cpp>
#include <wxutil.cpp>
#include <combase.cpp>
#include <amfilter.cpp>
#include <renbase.cpp>

static IGraphBuilder *g_builder = NULL;
static ICaptureGraphBuilder2 *g_capBuild = NULL;

static IMediaControl *g_pMC = NULL;
static IMediaPosition *g_pMP = NULL;
static IMediaSeeking *g_pMS = NULL;
static IMediaEvent *g_pME = NULL;
static IBaseFilter *g_src = NULL;
static IPin *g_pPin = NULL;

static bool g_musicInit = false;
static bool g_musicPlaying = false;

static char g_lastFilePlayed[MAX_PATH_CHARS];

static bool g_restartOnNext = false;

static DWORD g_musicThreadID = 0;
static HANDLE g_musicThreadHandle = 0;

//forward declarations
bool Music_StartSampleCurrent(const char *filename);
void Music_FrameChecks(void);

//music thread proc function
DWORD WINAPI Music_ThreadProc(LPVOID lpParameter)
{
	while (1)
	{
		Music_FrameChecks();
		Sleep(1000); //delay the next frame
	}

	return S_OK;
}


//dshow module init
bool Music_Init(void)
{
	HRESULT r;

	if (g_musicInit)
	{ //already initialized
		return true;
	}

	r = CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, IID_IGraphBuilder, (void **)&g_builder);
	if (FAILED(r))
	{
		return false;
	}

	r = CoCreateInstance(CLSID_CaptureGraphBuilder2, NULL, CLSCTX_INPROC_SERVER, IID_ICaptureGraphBuilder2, (void**)&g_capBuild);
	if (FAILED(r))
	{
		return false;
	}
	g_capBuild->SetFiltergraph(g_builder);

	g_builder->QueryInterface(&g_pMC);
	g_builder->QueryInterface(&g_pMP);
	g_builder->QueryInterface(&g_pMS);
	g_builder->QueryInterface(&g_pME);

	g_musicInit = true;

	//Create a thread for music routines to be performed on
	SECURITY_ATTRIBUTES threadSecur;
	threadSecur.nLength = sizeof(threadSecur);
	threadSecur.lpSecurityDescriptor = NULL; //inherit
	threadSecur.bInheritHandle = TRUE;
	g_musicThreadHandle = CreateThread(NULL, 0, Music_ThreadProc, NULL, 0, &g_musicThreadID);

	if (!g_musicThreadHandle)
	{
		return false;
	}

	//eh, i'll let it use default priority, but sleep it.
	//SetThreadPriority(g_musicThreadHandle, THREAD_PRIORITY_IDLE);

	return true;
}

//perframe checks
void Music_FrameChecks(void)
{
	if (!g_musicInit)
	{
		return;
	}

	if (g_restartOnNext)
	{
		Music_StartSampleCurrent(g_lastFilePlayed);

		g_restartOnNext = false;
		return;
	}

	if (g_musicPlaying)
	{
		long event, p1, p2;

		HRESULT r = g_pME->GetEvent(&event, &p1, &p2, 0);

		if (FAILED(r))
		{
			return;
		}

		if (event == EC_COMPLETE)
		{ //restart ^^
			g_builder->Abort();
			g_pMC->Stop();
			g_restartOnNext = true;
		}
	}
}

//schedule file to be played on music thread
bool Music_PlaySample(const char *filename)
{
	if (g_musicPlaying)
	{
		g_musicPlaying = false;
		g_builder->Abort();
		g_pMC->Stop();
	}

	strcpy(g_lastFilePlayed, filename);
	g_restartOnNext = true;
}

//play a music file
bool Music_StartSampleCurrent(const char *filename)
{
	HRESULT r;

	if (!g_musicInit)
	{
		return false;
	}

	//stop if something is already playing
	g_pMC->Stop();

	unsigned short wFilename[MAX_PATH_CHARS];
	MultiByteToWideChar(CP_ACP, 0, filename, -1, wFilename, MAX_PATH_CHARS);

	if (g_src)
	{
		g_builder->RemoveFilter(g_src);

		g_src->Release();
		g_src = NULL;
	}

	r = g_builder->AddSourceFilter(wFilename, wFilename, &g_src);
	if (FAILED(r))
	{
		return false;
	}
//===============================================================
	if (g_pPin)
	{
		g_pPin->Release();
		g_pPin = NULL;
	}
	r = g_src->FindPin(L"Output", &g_pPin);
	if (FAILED(r))
	{
		return false;
	}

	//hmm, why do this? should be adding filter according to filename.
#if 0
	unsigned short fName[128];
	MultiByteToWideChar(CP_ACP, 0, "AudioShizzle", -1, fName, 128);

    IEnumFilters *pFilterEnum = NULL;
    if (SUCCEEDED(r = g_builder->EnumFilters(&pFilterEnum))) {
        int iFiltCount = 0;
        int iPos = 0;

        // Need to know how many filters. If we add/remove filters during the
        // enumeration we'll invalidate the enumerator
        while (S_OK == pFilterEnum->Skip(1)) {
            iFiltCount++;
        }

        // Allocate space, then pull out all of the 
        IBaseFilter **ppFilters = reinterpret_cast<IBaseFilter **>
                                  (_alloca(sizeof(IBaseFilter *) * iFiltCount));
        pFilterEnum->Reset();

        while (S_OK == pFilterEnum->Next(1, &(ppFilters[iPos++]), NULL));
        if (pFilterEnum)
		{
			pFilterEnum->Release();
		}

        for (iPos = 0; iPos < iFiltCount; iPos++) {
            g_builder->RemoveFilter(ppFilters[iPos]);
			// Put the filter back, unless it is the old source
			if (ppFilters[iPos] != NULL) {
				g_builder->AddFilter(ppFilters[iPos], fName);
            }
			if (ppFilters[iPos])
			{
				ppFilters[iPos]->Release();
			}
        }
    }
#endif

	if (FAILED(r))
	{
		return false;
	}

	r = g_builder->Render(g_pPin);

//===============================================================
	//what the fuck, ogg says it can do seeking but crashes when you try it. so fucking stupid.
	//oh well, it can go to hell, cause seeking works with mp3.	
	DWORD checkCaps = AM_SEEKING_CanSeekAbsolute|AM_SEEKING_CanSeekForwards|AM_SEEKING_CanSeekBackwards;
	if (g_pMS->CheckCapabilities(&checkCaps) == S_OK)
	{
		LONGLONG llPos = 0;
		r = g_pMS->SetPositions(&llPos, AM_SEEKING_AbsolutePositioning, &llPos, AM_SEEKING_NoPositioning);
		if (FAILED(r))
		{
			return false;
		}
	}
	

	r = g_pMC->Run();
	if (FAILED(r))
	{
		return false;
	}

	g_musicPlaying = true;

	return true;
}

//dsound module shutdown
void Music_Shutdown(void)
{
	if (g_musicInit)
	{ //release everything.
		g_pMC->Release();
		g_pMP->Release();
		g_pME->Release();
		g_capBuild->Release();
		g_builder->Release();

		if (g_src)
		{
			g_src->Release();
			g_src = NULL;
		}
		if (g_pPin)
		{
			g_pPin->Release();
			g_pPin = NULL;
		}

		g_pMC = NULL;
		g_pMP = NULL;
		g_pME = NULL;
		g_capBuild = NULL;
		g_builder = NULL;

		g_musicPlaying = false;

		TerminateThread(g_musicThreadHandle, 0);
		CloseHandle(g_musicThreadHandle);
		g_musicThreadHandle = 0;
	}

	g_musicInit = false;
}

#endif //_USE_DSHOW
