#include <xtl.h>
#include <io.h>
#include <stdio.h>
//#include <afxwin.h>
//#include <afxdlgs.h>
#include <fcntl.h>
#include <sys/stat.h>
//#include <gl/gl.h>
#include <assert.h>
#include <math.h>
#include <direct.h>
//#include <dshow.h>
//#include "resource.h"

//#include <commctrl.h>

#include "gld3d.h"

//xbox hax
#define VK_RETURN		1
#define VK_ESCAPE		2
#define VK_BACK			3
#define VK_UP			4
#define VK_DOWN			5
#define VK_LEFT			6
#define VK_RIGHT		7
#define VK_SPACE		8

#define MAX_PATH_CHARS			1024
#define MAX_PRINT_CHARS			1024
#define MAX_CARDNAME_CHARS		128
#define MAX_MENUS				64
#define MAX_VIDMODES			32

#define MAX_TIM_READ_LENGTH		1048576

#define NUM_CARDS				110
#define NUM_LEVELS				10
#define	NUM_CARDS_PER_LEVEL		11
#define NUM_CARDS_PER_PLAYER	5

#define	NUM_KEYS				256

#define NET_SYNC_DURATION		300

#define TIM_PM_4BIT				0
#define TIM_PM_8BIT				1
#define TIM_PM_15BIT			2
#define TIM_PM_24BIT			3
#define TIM_PM_MIXED			4

#define GAMMA_CORRECTION		8
//since a clut rgb value is 5 bits, that means it can only be 0-31.
//the color range for one of our rgba pixels is 0-255, so multiplying
//by 8 gives roughly the correct relative color brightness
//(32*8=256)

//this order is important - it actually corresponds to the order of
//the icons in the tim we are ripping them from.
typedef enum
{
	CARD_ELEM_NONE = 0,
	CARD_ELEM_FIRE,
	CARD_ELEM_ICE,
	CARD_ELEM_THUNDER,
	CARD_ELEM_EARTH,
	CARD_ELEM_POISON,
	CARD_ELEM_WIND,
	CARD_ELEM_WATER,
	CARD_ELEM_HOLY,
	CARD_ELEM_NUM
} cardElements_t;


#define CARD_PIXELS				62
#define CARD_BORDERING_PIXELS	1
#define CARD_INIMAGE_PIXELS		(CARD_PIXELS+(CARD_BORDERING_PIXELS*2))

#define PI						3.14159265358979323846
#define Z_NEAR					4.0f//0.1f
#define Z_FAR					32.0f

#define SPINNY_CARD_TIME		4000

//=============================
//image structures
//=============================
//standard pixel format
typedef struct rgbaPixel_s
{
	BYTE			r;
	BYTE			g;
	BYTE			b;
	BYTE			a;
} rgbaPixel_t;

//standard image info header
typedef struct imageInfo_s
{
	LONG			width;
	LONG			height;
} imageInfo_t;

//p is the beginning of pixel data
typedef struct pixelImage_s
{
	imageInfo_t		i;
	rgbaPixel_t		p;
} pixelImage_t;

//=============================
//tim structures
//=============================
//flag section of the tim, information on the
//the pixel mode and if it has a clut (although
//I would think the pixelmode would indicate
//that anyway)
typedef struct timFLAG_s
{
	BYTE			pixelMode : 3;
	BYTE			hasCLUT : 1;
} timFLAG_t;

//a pixel entry for a 4-bit tim, composed
//of a 4 4-bit indexes to CLUT entries
typedef struct tim4BitPixelEntry_s
{
	BYTE			p1 : 4;
	BYTE			p2 : 4;
	BYTE			p3 : 4;
	BYTE			p4 : 4;
} tim4BitPixelEntry_t;

//a pixel entry for an 8-bit tim, composed
//of a 2 8-bit indexes to CLUT entries
typedef struct tim8BitPixelEntry_s
{
	BYTE			p1 : 8;
	BYTE			p2 : 8;
} tim8BitPixelEntry_t;

//a pixel entry for a direct 24-bit tim,
//composed of 6 rgb bytes
typedef struct tim24BitPixelEntry_s
{
	BYTE			r0;
	BYTE			g0;
	BYTE			b0;
	BYTE			r1;
	BYTE			g1;
	BYTE			b1;
} tim24BitPixelEntry_t;

//standard tim CLUT header
typedef struct timCLUT_s
{
	DWORD			length;
	WORD			xCoord;
	WORD			yCoord;
	WORD			width;
	WORD			height;
} timCLUT_t;

//standard tim pixel header
typedef struct timPixels_s
{
	DWORD			length;
	WORD			xCoord;
	WORD			yCoord;
	WORD			width;
	WORD			height;
} timPixels_t;

//made-up tim structure
typedef struct tim_s
{
	int				pixelMode;
	int				bpp;
	int				width;
	int				height;
	timCLUT_t		*clut;
	timPixels_t		*pixels;
} tim_t;

//=============================
//misc structures
//=============================
typedef struct image_s
{
	pixelImage_t	*pImage;
	int				glTexNum;
	int				glTexNum2;
} image_t;

//=============================
//game/rendering structures
//=============================
typedef struct playingCard_s
{
	char		cardName[MAX_CARDNAME_CHARS];
	int			level;
	int			row;
	int			col;

	int			up;
	int			down;
	int			right;
	int			left;

	int			elemental;

	image_t		*image;
} playingCard_t;

typedef struct drawCard_s
{
	float			pos[3];
	float			ang[3];
	float			wRadius;
	float			hRadius;
	playingCard_t	*pCard;
	drawCard_s		*next;
	int				altTex;

	unsigned long	predictionTake;

	float			desiredPos[3];
	float			desiredAng[3];

	int				gridSpot;
	int				gotoGridSpot;

	unsigned long	gridTravelTime;

	int				cardIndex;
	int				selected;

	int				initialPlayer;

	unsigned long	menuSelectTime;

	unsigned long	takenTime;
	int				takenStep;
	int				takenSound;
	unsigned long	takenSoundTime;
	int				takenSide;
} drawCard_t;

//flat 2-sided object
typedef struct drawObject_s
{
	float			pos[3];
	float			ang[3];
	float			wRadius;
	float			hRadius;
	int				srcBlend;
	int				dstBlend;
	int				alphaTest;
	int				noDepth;
	int				img;
	int				imgBack;
	drawObject_s	*next;
} drawObject_t;

typedef struct clientGameState_s
{
	unsigned long	pStrTime;
	char			pStr[MAX_PRINT_CHARS];

	unsigned long	pCStrTime;
	char			pCStr[MAX_PRINT_CHARS];
	float			pCX;
	float			pCY;

	unsigned long	doink;
} clientGameState_t;

typedef struct gameState_s
{
	unsigned long	arrowDeciding; //arrow deciding who should go first
	int				arrowDecided; //arrow has decided - 0 if none, 1 if local player, 2 if comp/remote
	int				waitingTurn; //waiting for player to make turn - 0 none, 1 local, 2 comp/rem
	int				chosenCards; //non-0 if local client has finished choosing cards

	int				setWaiting; //set turn after a duration
	unsigned long	setWaitingTime; //the duration

	float			arrowRot; //rotational value for the turn arrow

	int				cardPage; //page when selecting cards
	int				cardSelected; //card on page when selecting
	int				cardsChosen; //number of cards chosen so far during card selection

	int				pl2Computer; //if non-0, player 2 is ai-controlled and not a remote player

	int				p1Turn_Selection; //card index selected when doing turn
	int				p1Turn_OnBoard; //is the player selecting a board space to place a card?
	int				p1Turn_OnBoard_Grid; //which grid is selected?

	unsigned long	ai_nextDecisionTime; //debounce time for ai decisions during turn
	drawCard_t		*ai_selected; //card ai currently has selected
	drawCard_t		*ai_bestCard; //best card to place for ai
	int				ai_gridSpace; //grid space ai wants to put card on
	int				ai_simulation; //ai is running a simulation to check card takes
	int				ai_taken; //total weight of cards taken in a simulated test

	int				p2ChosenCards; //has player 2 chosen their cards yet?

	int				elementalGrid[9]; //elemental values for grid spaces, in case of elemental rule

	int				p1Total; //total cards player 1 has in deck and on board
	int				p2Total; //total cards player 2 has in deck and on board

	int				drawP2Total; //for netplay

	int				gameDone; //non-0 if game over. -1 draw, 1 pl1 win, 2 pl2 win
	float			perfectVert; //vertical coordinate of perfect, to scroll onto screen

	unsigned long	scorePredictionSet; //for netplay
} gameState_t;

typedef struct menuEntry_s
{
	char			title[MAX_PRINT_CHARS];
	char			status[MAX_PRINT_CHARS];
	int				inuse;
	void			(*set)(int index);
	void			(*use)(int index);
} menuEntry_t;

typedef struct gameMenu_s
{
	menuEntry_t		menus[MAX_MENUS];
	int				active;
	int				menu;
	int				numMenus;
} gameMenu_t;

typedef struct menuInput_s
{
	void			(*update)(menuInput_s *obj);
	char			*buffer;
	int				active;
	menuEntry_t		*entry;
	int				entryIndex;
} menuInput_t;

typedef struct userInfo_s
{
	char			infoPath[MAX_PATH_CHARS];
	char			connIP[256];
	int				connPort;
	int				background;
	int				texFilter;
	int				vidMode;
	int				bpp;
	int				fullScreen;
	int				limitFramerate;
	int				timByteOffsets[64]; //oversized, but it doesn't really matter
} userInfo_t;

typedef struct vidMode_s
{
	int				width;
	int				height;
} vidMode_t;

typedef struct textureStorage_s
{
	//background textures
	int				backgroundImage;
	int				backgroundImage2;

	//menu/general interface textures
	int				misterPointy;
	int				letterTextures[NUM_KEYS];

	//card overlay textures
	int				cardNumTextures[11];
	int				cardElemTextures[CARD_ELEM_NUM];

	//misc display gfx
	int				doubleTex;
	int				tripleTex;
	int				triggerTex;
	int				perfectTex;

	//ekeke^^;;
	int				doinkTxt;
	int				doinkBubble;
} textureStorage_t;

typedef struct cardGameRules_s
{
	int				open;
	int				same;
	int				plus;
	int				combo;
	int				suddenDeath;
	int				random;
	int				sameWall;
	int				elemental;

	int				set;
} cardGameRules_t;

//sound structs
typedef enum
{
	BUFFER1,
	BUFFER2,
	BUFFER3,
	/*
	BUFFER4,
	BUFFER5,
	BUFFER6,
	BUFFER7,
	BUFFER8,
	*/
	NUM_SECONDARY_BUFFERS
} secBuffers_t;

typedef struct waveFileFmt_s
{
	DWORD		id;
	DWORD		size;
	WORD		format;
	WORD		channels;
	DWORD		sampleRate;
	DWORD		byteRate;
	WORD		blockAlign;
	WORD		bps;
} waveFileFmt_t;

typedef struct waveFileData_s
{
	DWORD		id;
	DWORD		size;
	BYTE		data;
} waveFileData_t;

typedef struct waveFile_s
{
	BYTE			id[4]; //"RIFF"
	DWORD			chunkSize;
	BYTE			format[4];  //"WAVE"
	waveFileFmt_t	fmt;
	waveFileData_t	data;
} waveFile_t;

//=============================
//functions
//=============================
//tim.cpp
int CreateTIMBuffer(const char *fileName);
pixelImage_t *GetTIMFromBuffer(int byteOffset, int readLen);
void FreeTIMBuffer(void);

//window.cpp
void Window_Print (const char *string, ...);
int Window_Create(HWND wnd, int width, int height, int bits, int fullScreen);
void Window_Close(void);

//gl.cpp
int GL_CreateGLTextureFromCard(playingCard_t *card, int tint);
int GL_CreateGLTextureFromImage(image_t *image);
int GL_CreateGLTextureFromImageRegion(image_t *image, int x, int y, int w, int h);
void GL_CardBackface(image_t *image);
void GL_CalcPerspective(float fovy, float aspect, float zNear, float zFar);
int GL_Init(void);
void GL_AddDrawCard(drawCard_t *card);
void GL_AddDrawObject(drawObject_t *obj);
void GL_DrawFrame(void);

//game.cpp
int Game_ElementalHandicap(drawCard_t *c);
void Game_MenuInit(void);
void Game_Init(void);
void Game_Logic(void);
void Game_Print (const char *string, ...);
void Game_CoordPrint (float x, float y, const char *string, ...);

//main.cpp
const unsigned int GetCRCForOffset(int byteOffset);
const unsigned int SetOffsetForCRC(unsigned int crc, int newOffset);
void Shutdown(void);
int Initialize(void);

//user.cpp
int User_SaveUI(void);
int User_LoadUI(void);

//net.cpp
void Net_Init(void);
void Net_Listen(int port);
void Net_Connect(int port, const char *ip);
void Net_Disconnect(void);
void Net_SendElementGrid(void);
void Net_SendArrowChoice(void);
void Net_SendCards(void);
void Net_SyncSend(void);
void Net_SendReinit(void);

//dsound.cpp
void S_PlayRawData(BYTE *wave, unsigned long size, int bufferNum);
void S_PlaySoundFromFile(const char *fileName, int bufferNum);
waveFile_t *S_GetWaveData(const char *fileName);

//crc32.cpp
void CRC_CreateTable(void);
unsigned int CRC_CalcChecksum(BYTE *buffer, int size);

//=============================
//externed globals
//=============================
extern playingCard_t g_playingCards[NUM_CARDS];
extern int g_keysPressed[NUM_KEYS];
extern int g_keysDebounce[NUM_KEYS];
extern int g_finishLoop;
extern int g_rendererReinit;
extern int g_displayWidth;
extern int g_displayHeight;
extern int g_linearTex;
extern int g_bgMirrorSecond;
extern int g_bgMirrorFirst;
extern int g_bgOnePart;
extern char g_workingDir[MAX_PATH_CHARS];
extern userInfo_t g_userInfo;
extern gameMenu_t g_gameMenu;
extern gameMenu_t g_ruleMenu;
extern menuInput_t g_menuInput;
extern int g_numVidmodes;
extern g_multilayeredClutChoice;
extern unsigned long g_Time;
extern gameState_t g_gameState;
extern clientGameState_t g_CGS;
extern textureStorage_t g_texStorage;
extern cardGameRules_t g_gameRules;
extern int g_hostPlayer;
extern int g_socketCreated;
extern int g_listenSocketCreated;
extern int g_useCRC;

extern LPDIRECT3D8 g_pD3D;
extern LPDIRECT3DDEVICE8 g_pd3dDevice;
extern LPDIRECT3DVERTEXBUFFER8 g_pVB;
