#include "main.h"
#include <xgraphics.h>
#include <map>

/*
typedef struct tgaHeader_s
{
	byte		identSize;
	byte		colorMapType;
	byte		imageType;

	short		colorMapStart;
	short		colorMapLength;
	byte		colorMapBits;

	short		xStart;
	short		yStart;
	short		width;
	short		height;
	byte		bits;
	byte		descriptor;
} tgaHeader_t;
*/

//#define _VERT_TEST

//=========================================
//wrapper functionality: clear
//=========================================
static byte g_lastClearColor[3] = {0, 0, 0};
static float g_lastClearDepth = 1.0f;
static DWORD g_lastClearStencil = 0;

//=========================================
//wrapper functionality: states (culling, depth, etc)
//=========================================
static D3DCULL g_cullMethod = D3DCULL_CW;
static bool g_culling = false;
static D3DCMPFUNC g_depthFunc = D3DCMP_LESSEQUAL;
static bool g_depthTesting = true;
static D3DCMPFUNC g_alphaFunc = D3DCMP_GREATER;
static byte g_alphaRef = 0;
static bool g_alphaTesting = false;
static bool g_texture2dEnabled = false;
static bool g_alphaBlending = false;

//=========================================
//wrapper functionality: textures
//=========================================
typedef enum {
	D3D_GL_TEXTURE_1D,
	D3D_GL_TEXTURE_2D,
	D3D_GL_TEXTURE_3D,
	D3D_GL_TEXTURE_NUM
} d3dGLTexture_t;
static int g_activeTextureType = D3D_GL_TEXTURE_2D;
static unsigned int g_activeTexture[D3D_GL_TEXTURE_NUM];
std::map<int,IDirect3DTexture8 *> g_d3dTextureMap;
int D3DWrapperTextureForGL(int glTexture)
{
	if (glTexture == GL_TEXTURE_1D)
	{
		return D3D_GL_TEXTURE_1D;
	}
	else if (glTexture == GL_TEXTURE_2D)
	{
		return D3D_GL_TEXTURE_2D;
	}

	//XBOXFIXME support other texture modes?
	return -1;
}

//=========================================
//wrapper functionality: primitives
//=========================================
static D3DTRANSFORMSTATETYPE g_matrixMode = D3DTS_VIEW;

#define MATRIX_STACK_SIZE	16
D3DXMATRIX g_matStackProj[MATRIX_STACK_SIZE];
int g_matStackProjNum = 0;
D3DXMATRIX g_matStackView[MATRIX_STACK_SIZE];
int g_matStackViewNum = 0;

#ifdef _VERT_TEST
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ)
struct CUSTOMVERTEX
{
	FLOAT x, y, z;
};
#else
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1)
struct CUSTOMVERTEX
{
	FLOAT x, y, z;
	DWORD color;
	FLOAT s, t;
};
#endif
LPDIRECT3DVERTEXBUFFER8 g_pVertexBuffer = NULL;

static byte g_currentRGBA[4] = {1, 1, 1, 1};
static float g_currentTexCoords[2] = {0, 0};

#define MAX_GEOMETRY_BUFFER		1024 //since gltriad does not draw anything complex
static int g_primType = -1;
static int g_primCount = 0;
static int g_vertCount = 0;
static int g_primBufferCount = 0;
static BYTE g_primBuffer[MAX_GEOMETRY_BUFFER];

//================================================================
//gl wrapper emulation functions
//================================================================
void glClear (GLbitfield mask)
{
	int d3dMask = 0;

	if (mask & GL_COLOR_BUFFER_BIT)
	{
		d3dMask |= D3DCLEAR_TARGET;
	}
	if (mask & GL_DEPTH_BUFFER_BIT)
	{
		d3dMask |= D3DCLEAR_ZBUFFER;
	}
	if (mask & GL_STENCIL_BUFFER_BIT)
	{
		d3dMask |= D3DCLEAR_STENCIL;
	}

	g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
		D3DCOLOR_XRGB(g_lastClearColor[0], g_lastClearColor[1], g_lastClearColor[2]), g_lastClearDepth, g_lastClearStencil);
}

void glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	//XBOXFIXME
}

void glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
	g_lastClearColor[0] = (byte)(red*255.0f);
	g_lastClearColor[1] = (byte)(green*255.0f);
	g_lastClearColor[2] = (byte)(blue*255.0f);
	glClear(GL_COLOR_BUFFER_BIT);
}

void glClearDepth (GLclampd depth)
{
	g_lastClearDepth = (float)depth;
	glClear(GL_DEPTH_BUFFER_BIT);
}

void glClearIndex (GLfloat c)
{
	//XBOXFIXME
}

void glClearStencil (GLint s)
{
	g_lastClearStencil = s;
	glClear(GL_STENCIL_BUFFER_BIT);
}

void glPushMatrix (void)
{
	D3DXMATRIX *stack = NULL;
	int *stackNum = NULL;

	if (g_matrixMode == D3DTS_VIEW)
	{
		stack = g_matStackView;
		stackNum = &g_matStackViewNum;
	}
	else if (g_matrixMode == D3DTS_PROJECTION)
	{
		stack = g_matStackProj;
		stackNum = &g_matStackProjNum;
	}

	if (!stack)
	{ //not supported, ha ha ha!
		return;
	}

	assert((*stackNum) < MATRIX_STACK_SIZE);

	g_pd3dDevice->GetTransform(g_matrixMode, &stack[(*stackNum)]);
	(*stackNum)++;
}

void glPopMatrix (void)
{
	D3DXMATRIX *stack = NULL;
	int *stackNum = NULL;

	if (g_matrixMode == D3DTS_VIEW)
	{
		stack = g_matStackView;
		stackNum = &g_matStackViewNum;
	}
	else if (g_matrixMode == D3DTS_PROJECTION)
	{
		stack = g_matStackProj;
		stackNum = &g_matStackProjNum;
	}

	if (!stack)
	{ //not supported, ha ha ha!
		return;
	}

	(*stackNum)--;
	assert((*stackNum) >= 0);

	g_pd3dDevice->SetTransform(g_matrixMode, &stack[(*stackNum)]);
}

void glShadeModel (GLenum mode)
{
	//XBOXFIXME
}

void glHint (GLenum target, GLenum mode)
{
	//XBOXFIXME
}

void glEnable (GLenum cap)
{
	switch (cap)
	{
	case GL_CULL_FACE:
		g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, g_cullMethod);
		g_culling = true;
		break;
	case GL_DEPTH_TEST:
		g_pd3dDevice->SetRenderState(D3DRS_ZFUNC, g_depthFunc);
		g_depthTesting = true;
		break;
	case GL_ALPHA_TEST:
		g_pd3dDevice->SetRenderState(D3DRS_ALPHATESTENABLE, true);
		g_alphaTesting = true;
		break;
	case GL_TEXTURE_2D:
		g_pd3dDevice->SetTexture(0, g_d3dTextureMap[g_activeTexture[D3DWrapperTextureForGL(GL_TEXTURE_2D)]]);
		g_texture2dEnabled = true;
		break;
	case GL_BLEND:
		g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
		g_alphaBlending = true;
		break;
	default:
		break;
	}
}

void glDisable (GLenum cap)
{
	switch (cap)
	{
	case GL_CULL_FACE:
		g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
		g_culling = false;
		break;
	case GL_DEPTH_TEST:
		g_pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
		g_depthTesting = false;
		break;
	case GL_ALPHA_TEST:
		g_pd3dDevice->SetRenderState(D3DRS_ALPHATESTENABLE, false);
		g_alphaTesting = false;
		break;
	case GL_TEXTURE_2D:
		g_pd3dDevice->SetTexture(0, NULL);
		g_texture2dEnabled = false;
		break;
	case GL_BLEND:
		g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
		g_alphaBlending = false;
		break;
	default:
		break;
	}
}

void glBegin (GLenum mode)
{
	if (g_primType != -1)
	{ //already drawing a primitive
		assert(0);
		return;
	}

	g_primCount = 1;
	g_vertCount = 0;

	if (!g_pVertexBuffer)
	{ //create the vertex buffer now
		g_pd3dDevice->CreateVertexBuffer(MAX_GEOMETRY_BUFFER, D3DUSAGE_WRITEONLY, 
			D3DFVF_CUSTOMVERTEX, D3DPOOL_DEFAULT, &g_pVertexBuffer);
	}

	switch (mode)
	{
	case GL_POINTS:
		g_primType = D3DPT_POINTLIST;
		break;
	case GL_LINES:
		g_primType = D3DPT_LINELIST;
		break;
	case GL_LINE_LOOP:
		g_primType = -1; //unsupported
		break;
	case GL_LINE_STRIP:
		g_primType = D3DPT_LINESTRIP;
		break;
	case GL_TRIANGLES:
		g_primType = D3DPT_TRIANGLELIST;
		break;
	case GL_TRIANGLE_STRIP:
		g_primType = D3DPT_TRIANGLESTRIP;
		break;
	case GL_TRIANGLE_FAN:
		g_primType = D3DPT_TRIANGLEFAN;
		break;
	case GL_QUADS:
		g_primType = -2; //hax
		break;
		//rest unsupported
		/*
	case GL_QUAD_STRIP:
		g_primType = D3DPT_POINTLIST;
		break;
	case GL_POLYGON:
		g_primType = D3DPT_POINTLIST;
		break;
		*/
	default:
		break;
	}
}

void glEnd (void)
{
	if (g_primType == -1 || !g_pVertexBuffer || g_primBufferCount <= 0)
	{
		assert(0);
		return;
	}

	int l = 1;

	if (g_primType == -2)
	{ //hack for quads. would be more efficient to add into tri list and pass in primCount of 2.
		//but i don't really care.
		g_primType = D3DPT_TRIANGLELIST;
		g_primCount = 1;
		l = 2;
	}

	int i = 0;
	while (i < l)
	{
		//lock the vertex buffer and copy our primitive buffer into it
		HRESULT r;
		BYTE *pVertices = NULL;
		r = g_pVertexBuffer->Lock(0, g_primBufferCount, &pVertices, 0);
		assert(r == D3D_OK);
		memcpy(pVertices, g_primBuffer, g_primBufferCount);
		r = g_pVertexBuffer->Unlock();
		assert(r == D3D_OK);

		r = g_pd3dDevice->SetStreamSource(0, g_pVertexBuffer, sizeof(CUSTOMVERTEX));
		assert(r == D3D_OK);
		r = g_pd3dDevice->SetVertexShader(D3DFVF_CUSTOMVERTEX);
		assert(r == D3D_OK);
		r = g_pd3dDevice->DrawPrimitive((D3DPRIMITIVETYPE)g_primType, 0, g_primCount);
		assert(r == D3D_OK);

		if (l > 1)
		{ //scramble
			CUSTOMVERTEX v1, v2, v3;

			memcpy(&v1, g_primBuffer+(sizeof(CUSTOMVERTEX)*0), sizeof(v1));
			memcpy(&v2, g_primBuffer+(sizeof(CUSTOMVERTEX)*2), sizeof(v2));
			memcpy(&v3, g_primBuffer+(sizeof(CUSTOMVERTEX)*3), sizeof(v3));

			memcpy(g_primBuffer+(sizeof(CUSTOMVERTEX)*0), &v1, sizeof(v1));
			memcpy(g_primBuffer+(sizeof(CUSTOMVERTEX)*1), &v2, sizeof(v2));
			memcpy(g_primBuffer+(sizeof(CUSTOMVERTEX)*2), &v3, sizeof(v3));
		}

		i++;
	}

	//since we drew it, reset
	g_primType = -1;
	g_primBufferCount = 0;
}

void glBindTexture (GLenum target, GLuint texture)
{
	int t = D3DWrapperTextureForGL(target);
	if (t != -1)
	{
		g_activeTexture[t] = texture;

		IDirect3DTexture8 *d3dtexture = g_d3dTextureMap[g_activeTexture[t]];
		if (d3dtexture)
		{ //ok then, set it
			//FIXME allow multitexturing
			if (g_texture2dEnabled)
			{
				g_pd3dDevice->SetTexture(0, d3dtexture);
			}
		}
	}
}

void glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
	int t = D3DWrapperTextureForGL(target);
	
	if (t != -1)
	{
		int d3dFormat = -1;

		//FIXME could just change the GL defines to reflect directly
		if (format == GL_RGBA)
		{
			d3dFormat = D3DFMT_A8B8G8R8;
		}
		else if (format == GL_RGB)
		{ //not supported on xbox?!
			d3dFormat = -1;//D3DFMT_R8G8B8;
		}

		if (d3dFormat != -1)
		{
			IDirect3DTexture8 *texture = g_d3dTextureMap[g_activeTexture[t]];

			if (texture)
			{ //if it exists then kill it first
				texture->Release();
				texture = NULL;
			}

			HRESULT r = D3DXCreateTexture(g_pd3dDevice, width, height, 1, 0, (D3DFORMAT)d3dFormat,
				D3DPOOL_DEFAULT, &texture);
			assert(r == D3D_OK);

			DWORD i = 0;
			DWORD mipCount = texture->GetLevelCount();
			assert(mipCount == 1);
			while (i < mipCount)
			{
				D3DLOCKED_RECT d3dRect;

				r = texture->LockRect(i, &d3dRect, 0, 0);
				assert(r == D3D_OK);

				XGSwizzleRect(pixels, d3dRect.Pitch, NULL,
					d3dRect.pBits, width, height, NULL, 4);

				r = texture->UnlockRect(i);
				assert(r == D3D_OK);

				i++;
			}

			g_d3dTextureMap[g_activeTexture[t]] = texture;
			//FIXME allow multitexturing
			if (g_texture2dEnabled)
			{
				g_pd3dDevice->SetTexture(0, texture);
			}
		}
	}
}

void glAlphaFunc (GLenum func, GLclampf ref)
{
	switch (func)
	{
	case GL_NEVER:
		g_alphaFunc = D3DCMP_NEVER;
		break;
	case GL_LESS:
		g_alphaFunc = D3DCMP_LESS;
		break;
	case GL_EQUAL:
		g_alphaFunc = D3DCMP_EQUAL;
		break;
	case GL_LEQUAL:
		g_alphaFunc = D3DCMP_LESSEQUAL;
		break;
	case GL_GREATER:
		g_alphaFunc = D3DCMP_GREATER;
		break;
	case GL_NOTEQUAL:
		g_alphaFunc = D3DCMP_NOTEQUAL;
		break;
	case GL_GEQUAL:
		g_alphaFunc = D3DCMP_GREATEREQUAL;
		break;
	case GL_ALWAYS:
		g_alphaFunc = D3DCMP_ALWAYS;
		break;
	}

	g_alphaRef = (byte)(ref*255.0f);

	g_pd3dDevice->SetRenderState(D3DRS_ALPHAFUNC, g_alphaFunc);
	g_pd3dDevice->SetRenderState(D3DRS_ALPHAREF, g_alphaRef);
}

static D3DBLEND D3DBlendForGLMode(int blend)
{
	switch (blend)
	{
	case GL_ZERO:
		return D3DBLEND_ZERO;
	case GL_ONE:
		return D3DBLEND_ONE;
	case GL_SRC_COLOR:
		return D3DBLEND_SRCCOLOR;
	case GL_ONE_MINUS_SRC_COLOR:
		return D3DBLEND_INVSRCCOLOR;
	case GL_SRC_ALPHA:
		return D3DBLEND_SRCALPHA;
	case GL_ONE_MINUS_SRC_ALPHA:
		return D3DBLEND_INVSRCALPHA;
	case GL_DST_ALPHA:
		return D3DBLEND_DESTALPHA;
	case GL_ONE_MINUS_DST_ALPHA:
		return D3DBLEND_INVDESTALPHA;
	case GL_DST_COLOR:
		return D3DBLEND_DESTCOLOR;
	case GL_ONE_MINUS_DST_COLOR:
		return D3DBLEND_INVDESTCOLOR;
	case GL_SRC_ALPHA_SATURATE:
		return D3DBLEND_SRCALPHASAT;
	}

	return D3DBLEND_ZERO;
}

void glBlendFunc (GLenum sfactor, GLenum dfactor)
{
	g_pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBlendForGLMode(sfactor));
	g_pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBlendForGLMode(dfactor));
}

void glCullFace (GLenum mode)
{
	if (mode == GL_FRONT)
	{
		g_cullMethod = D3DCULL_CCW;
	}
	else if (mode == GL_BACK)
	{
		g_cullMethod = D3DCULL_CW;
	}

	if (g_culling)
	{
		g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, g_cullMethod);
	}
}

void glTexCoord2f (GLfloat s, GLfloat t)
{
	g_currentTexCoords[0] = s;
	g_currentTexCoords[1] = t;
}

void glVertex2f (GLfloat x, GLfloat y)
{
	if (g_primType == -1)
	{
		return;
	}

	float v;

	v = x-320;
	memcpy(&g_primBuffer[g_primBufferCount], &v, sizeof(GLfloat));
	g_primBufferCount += sizeof(GLfloat);
	v = (-y)+240;
	memcpy(&g_primBuffer[g_primBufferCount], &v, sizeof(GLfloat));
	g_primBufferCount += sizeof(GLfloat);
	v = 0.0f;
	memcpy(&g_primBuffer[g_primBufferCount], &v, sizeof(GLfloat));
	g_primBufferCount += sizeof(GLfloat);

#ifndef _VERT_TEST
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[0], sizeof(byte));
	g_primBufferCount += sizeof(byte);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[1], sizeof(byte));
	g_primBufferCount += sizeof(byte);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[2], sizeof(byte));
	g_primBufferCount += sizeof(byte);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[3], sizeof(byte));
	g_primBufferCount += sizeof(byte);

	memcpy(&g_primBuffer[g_primBufferCount], &g_currentTexCoords[0], sizeof(float));
	g_primBufferCount += sizeof(float);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentTexCoords[1], sizeof(float));
	g_primBufferCount += sizeof(float);
#endif

	g_vertCount++;
	if (g_vertCount > 3)
	{
		g_vertCount = 0;
		g_primCount++;
	}
}

void glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
	if (g_primType == -1)
	{
		return;
	}

	memcpy(&g_primBuffer[g_primBufferCount], &x, sizeof(GLfloat));
	g_primBufferCount += sizeof(GLfloat);
	memcpy(&g_primBuffer[g_primBufferCount], &y, sizeof(GLfloat));
	g_primBufferCount += sizeof(GLfloat);
	memcpy(&g_primBuffer[g_primBufferCount], &z, sizeof(GLfloat));
	g_primBufferCount += sizeof(GLfloat);

#ifndef _VERT_TEST
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[0], sizeof(byte));
	g_primBufferCount += sizeof(byte);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[1], sizeof(byte));
	g_primBufferCount += sizeof(byte);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[2], sizeof(byte));
	g_primBufferCount += sizeof(byte);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentRGBA[3], sizeof(byte));
	g_primBufferCount += sizeof(byte);

	memcpy(&g_primBuffer[g_primBufferCount], &g_currentTexCoords[0], sizeof(float));
	g_primBufferCount += sizeof(float);
	memcpy(&g_primBuffer[g_primBufferCount], &g_currentTexCoords[1], sizeof(float));
	g_primBufferCount += sizeof(float);
#endif

	g_vertCount++;
	if (g_vertCount > 3)
	{
		g_vertCount = 0;
		g_primCount++;
	}
}

void glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
	g_currentRGBA[0] = (byte)(blue*255.0f);
	g_currentRGBA[1] = (byte)(green*255.0f);
	g_currentRGBA[2] = (byte)(red*255.0f);
}

void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	g_currentRGBA[0] = (byte)(blue*255.0f);
	g_currentRGBA[1] = (byte)(green*255.0f);
	g_currentRGBA[2] = (byte)(red*255.0f);
	g_currentRGBA[3] = (byte)(alpha*255.0f);
}

void glDepthFunc (GLenum func)
{
	switch (func)
	{
	case GL_NEVER:
		g_depthFunc = D3DCMP_NEVER;
		break;
	case GL_LESS:
		g_depthFunc = D3DCMP_LESS;
		break;
	case GL_EQUAL:
		g_depthFunc = D3DCMP_EQUAL;
		break;
	case GL_LEQUAL:
		g_depthFunc = D3DCMP_LESSEQUAL;
		break;
	case GL_GREATER:
		g_depthFunc = D3DCMP_GREATER;
		break;
	case GL_NOTEQUAL:
		g_depthFunc = D3DCMP_NOTEQUAL;
		break;
	case GL_GEQUAL:
		g_depthFunc = D3DCMP_GREATEREQUAL;
		break;
	case GL_ALWAYS:
		g_depthFunc = D3DCMP_ALWAYS;
		break;
	}

	if (g_depthTesting)
	{
		g_pd3dDevice->SetRenderState(D3DRS_ZFUNC, g_depthFunc);
	}
}

void glDepthMask (GLboolean flag)
{
	g_pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, flag);
}

void glDepthRange (GLclampd zNear, GLclampd zFar)
{
	//XBOXFIXME
}

void glTexParameterf (GLenum target, GLenum pname, GLfloat param)
{
	if (target == GL_TEXTURE_2D)
	{ //only this supported for now
		D3DTEXTURESTAGESTATETYPE d3dStageType;
		switch (pname)
		{
		case GL_TEXTURE_MIN_FILTER:
			d3dStageType = D3DTSS_MINFILTER;
			break;
		case GL_TEXTURE_MAG_FILTER:
			d3dStageType = D3DTSS_MAGFILTER;
			break;
		case GL_TEXTURE_WRAP_S:
			d3dStageType = D3DTSS_ADDRESSU;
			break;
		case GL_TEXTURE_WRAP_T:
			d3dStageType = D3DTSS_ADDRESSV;
			break;
		default:
			return;
		}

		DWORD value;
		if (param == GL_LINEAR)
		{
			value = D3DTEXF_LINEAR;
		}
		else if (param == GL_NEAREST)
		{
			value = D3DTEXF_POINT;
		}
		else if (param == GL_CLAMP_TO_EDGE)
		{
			value = D3DTADDRESS_CLAMP;
		}
		else if (param == GL_CLAMP)
		{
			value = D3DTADDRESS_CLAMPTOEDGE;
		}
		else if (param == GL_REPEAT)
		{
			value = D3DTADDRESS_WRAP;
		}
		else
		{
			return;
		}

		g_pd3dDevice->SetTextureStageState( 0, d3dStageType, value );
	}
}

void glTranslatef (GLfloat x, GLfloat y, GLfloat z)
{
	D3DMATRIX modelViewMatrix;
	g_pd3dDevice->GetTransform(g_matrixMode, &modelViewMatrix);

	D3DXMATRIX modelView = modelViewMatrix;

	D3DXMATRIX translation;
	D3DXMatrixTranslation(&translation, x, y, z);

	modelView *= translation;

	g_pd3dDevice->SetTransform(g_matrixMode, &modelView);
}

void glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
	D3DXMATRIX rotMat;

	//terrible hax
	if (x != 0.0f)
	{
		D3DXMatrixRotationX(&rotMat, angle*0.0174532925f);
	}
	else if (y != 0.0f)
	{
		D3DXMatrixRotationY(&rotMat, angle*0.0174532925f);
	}
	else if (z != 0.0f)
	{
		D3DXMatrixRotationZ(&rotMat, angle*0.0174532925f);
	}

	D3DMATRIX modelViewMatrix;
	g_pd3dDevice->GetTransform(g_matrixMode, &modelViewMatrix);

	rotMat *= modelViewMatrix;

	g_pd3dDevice->SetTransform(g_matrixMode, &rotMat);
}

void glLoadIdentity (void)
{
	D3DXMATRIX mat;
	D3DXMatrixIdentity(&mat);
	g_pd3dDevice->SetTransform(g_matrixMode, &mat);
}

void glMatrixMode (GLenum mode)
{
	switch (mode)
	{
	case GL_MODELVIEW:
		g_matrixMode = D3DTS_VIEW;
		break;
	case GL_PROJECTION:
		g_matrixMode = D3DTS_PROJECTION;
		break;
	case GL_TEXTURE: //FIXME multitexture support
		g_matrixMode = D3DTS_TEXTURE0;
		break;
	default:
		g_matrixMode = D3DTS_VIEW;
		break;
	}
}

void glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
	D3DXMATRIX matProj;
	D3DXMatrixOrthoRH(&matProj, (FLOAT)800, (FLOAT)600, (FLOAT)zNear, (FLOAT)zFar);
	g_pd3dDevice->SetTransform(g_matrixMode, &matProj);
}

void glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
	//XBOXFIXME
}

void glViewport (GLint x, GLint y, GLsizei width, GLsizei height)
{
}
