#include "main.h"

gameMenu_t g_gameMenu;
gameMenu_t g_ruleMenu;
menuInput_t g_menuInput;
unsigned long g_Time = 0;
unsigned long g_lastTime = 0;
unsigned long g_lastFrameDif = 0;

static unsigned long g_sendTime = 0;

gameState_t g_gameState;
clientGameState_t g_CGS;
cardGameRules_t g_gameRules;

drawCard_t g_pl1Cards[NUM_CARDS_PER_PLAYER];
drawCard_t g_pl2Cards[NUM_CARDS_PER_PLAYER];
drawCard_t g_previewCard;

extern waveFile_t *g_sound_cardWoosh;
extern waveFile_t *g_sound_menuMove;
extern waveFile_t *g_sound_menuUse;

static const float g_cardZoom = -16.0f;

static const char *g_bgStrings[] =
{
	"BG00",
	"Mountains",
	"Field",
	"Red fire",
	"Open sky",
	"Blue fire",
	"Bleak",
	"Energy",
	"Sun rock",
	"Moon",
	"Dark sky",
	"Firewall",
	NULL
};

static const char *g_txStrings[] =
{
	"Nearest",
	"Linear",
	NULL
};

static const char *g_vidStrings[] =
{
	"640x480",
	"800x600",
	"1024x768",
	"1280x960",
	"1280x1024",
	"1600x1200",
	"320x240",
	"512x384",
	NULL
};

static const char *g_fsStrings[] =
{
	"No",
	"Yes",
	NULL
};

void Game_CheckTakes(drawCard_t *c, int gridSpot, int powerOnly);

//use a hardcoded coordinate position based on the "position type"
//default player1 card start positions
#define CPOS_CARDP1_1			0
#define CPOS_CARDP1_2			1
#define CPOS_CARDP1_3			2
#define CPOS_CARDP1_4			3
#define CPOS_CARDP1_5			4
//default player2 card start positions
#define CPOS_CARDP2_1			5
#define CPOS_CARDP2_2			6
#define CPOS_CARDP2_3			7
#define CPOS_CARDP2_4			8
#define CPOS_CARDP2_5			9
//card on-board positions
#define CPOS_CARDX_1			10
#define CPOS_CARDX_2			11
#define CPOS_CARDX_3			12
#define CPOS_CARDX_4			13
#define CPOS_CARDX_5			14
#define CPOS_CARDX_6			15
#define CPOS_CARDX_7			16
#define CPOS_CARDX_8			17
#define CPOS_CARDX_9			18
//offscreen positions
#define CPOS_CARDOFF_1			19
#define CPOS_CARDOFF_2			20
#define CPOS_CARDOFF_S			21
//preview card onscreen
#define CPOS_CARDPRE_S			22
extern int g_depthHack;
void Game_CardPosition(int type, float *pos)
{
	switch(type)
	{
	//default player1 card start positions
	case CPOS_CARDP1_1:
		pos[0] = 7.0f;
		pos[1] = 4.2f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDP1_2:
		pos[0] = 7.0f;
		pos[1] = 2.2f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.1f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;
	case CPOS_CARDP1_3:
		pos[0] = 7.0f;
		pos[1] = 0.2f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.2f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;
	case CPOS_CARDP1_4:
		pos[0] = 7.0f;
		pos[1] = -1.8f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.3f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;
	case CPOS_CARDP1_5:
		pos[0] = 7.0f;
		pos[1] = -3.8f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.4f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;

	//default player2 card start positions
	case CPOS_CARDP2_1:
		pos[0] = -7.0f;
		pos[1] = 4.2f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDP2_2:
		pos[0] = -7.0f;
		pos[1] = 2.2f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.1f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;
	case CPOS_CARDP2_3:
		pos[0] = -7.0f;
		pos[1] = 0.2f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.2f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;
	case CPOS_CARDP2_4:
		pos[0] = -7.0f;
		pos[1] = -1.8f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.3f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;
	case CPOS_CARDP2_5:
		pos[0] = -7.0f;
		pos[1] = -3.8f;
		if (g_depthHack)
		{
			pos[2] = g_cardZoom+0.4f;
		}
		else
		{
			pos[2] = g_cardZoom;
		}
		break;

	//on-board positions
	case CPOS_CARDX_1:
		pos[0] = -3.3f;
		pos[1] = 4.2f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_2:
		pos[0] = 0.0f;
		pos[1] = 4.2f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_3:
		pos[0] = 3.3f;
		pos[1] = 4.2f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_4:
		pos[0] = -3.3f;
		pos[1] = 0.1f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_5:
		pos[0] = 0.0f;
		pos[1] = 0.1f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_6:
		pos[0] = 3.3f;
		pos[1] = 0.1f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_7:
		pos[0] = -3.3f;
		pos[1] = -4.0f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_8:
		pos[0] = 0.0f;
		pos[1] = -4.0f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDX_9:
		pos[0] = 3.3f;
		pos[1] = -4.0f;
		pos[2] = g_cardZoom;
		break;

	//offscreen
	case CPOS_CARDOFF_1:
		pos[0] = 7.0f;
		pos[1] = -9.0f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDOFF_2:
		pos[0] = -7.0f;
		pos[1] = -9.0f;
		pos[2] = g_cardZoom;
		break;
	case CPOS_CARDOFF_S:
		pos[0] = 3.0f;
		pos[1] = -9.0f;
		pos[2] = g_cardZoom;
		break;

	//preview card
	case CPOS_CARDPRE_S:
		pos[0] = 3.0f;
		pos[1] = -2.0f;
		pos[2] = g_cardZoom;
		break;

	default:
		break;
	}
}


//input update
void Game_MI_Use(menuInput_t *obj)
{
	int modified = 0;
	const unsigned int maxInput = 64;

	if (g_keysPressed[VK_RETURN] && !g_keysDebounce[VK_RETURN])
	{
		obj->active = 0;
		g_keysDebounce[VK_RETURN] = 1;
		return;
	}
	else if (g_keysPressed[VK_ESCAPE] && !g_keysDebounce[VK_ESCAPE])
	{
		obj->active = 0;
		g_keysDebounce[VK_ESCAPE] = 1;
		return;
	}

	if (g_keysPressed[VK_BACK] && !g_keysDebounce[VK_BACK])
	{
		if (strlen(obj->buffer) > 1)//0)
		{
			obj->buffer[strlen(obj->buffer)-1] = 0;
		}
		g_keysDebounce[VK_BACK] = 1;
		modified = 1;
	}
	if (g_keysPressed[VK_LEFT] && !g_keysDebounce[VK_LEFT])
	{
		if (strlen(obj->buffer) > 1)//0)
		{
			obj->buffer[strlen(obj->buffer)-1] = 0;
		}
		g_keysDebounce[VK_LEFT] = 1;
		modified = 1;
	}

	if (g_keysPressed[VK_UP] && !g_keysDebounce[VK_UP])
	{
		if (strlen(obj->buffer) > 0)
		{
			int l = strlen(obj->buffer)-1;
			if (obj->buffer[l] == '.')
			{
				obj->buffer[l] = '0';
			}
			else
			{
				obj->buffer[l]++;
				if (obj->buffer[l] > '9')
				{
					obj->buffer[l] = '.';
				}
			}
		}
		g_keysDebounce[VK_UP] = 1;
		modified = 1;
	}

	if (g_keysPressed[VK_DOWN] && !g_keysDebounce[VK_DOWN])
	{
		if (strlen(obj->buffer) > 0)
		{
			int l = strlen(obj->buffer)-1;
			if (obj->buffer[l] == '.')
			{
				obj->buffer[l] = '9';
			}
			else
			{
				obj->buffer[l]--;
				if (obj->buffer[l] < '0')
				{
					obj->buffer[l] = '.';
				}
			}
		}
		g_keysDebounce[VK_DOWN] = 1;
		modified = 1;
	}

	if (g_keysPressed[VK_RIGHT] && !g_keysDebounce[VK_RIGHT])
	{
		if (strlen(obj->buffer) < maxInput)
		{
			strcat(obj->buffer, ".");
		}
		g_keysDebounce[VK_RIGHT] = 1;
		modified = 1;
	}

	/*
	char s[8];
	char l = 'A';
	while (l <= 'Z')
	{
		if (g_keysPressed[l] && !g_keysDebounce[l])
		{
			sprintf(s, "%c", l);
			if (strlen(obj->buffer) < maxInput)
			{
				modified = 1;
				strcat(obj->buffer, s);
			}

			g_keysDebounce[l] = 1;
		}
		l++;
	}
	l = 'a';
	while (l <= 'z')
	{
		if (g_keysPressed[l] && !g_keysDebounce[l])
		{
			sprintf(s, "%c", l);
			if (strlen(obj->buffer) < maxInput)
			{
				modified = 1;
				strcat(obj->buffer, s);
			}

			g_keysDebounce[l] = 1;
		}
		l++;
	}
	l = '0';
	while (l <= '9')
	{
		if (g_keysPressed[l] && !g_keysDebounce[l])
		{
			sprintf(s, "%c", l);
			if (strlen(obj->buffer) < maxInput)
			{
				modified = 1;
				strcat(obj->buffer, s);
			}

			g_keysDebounce[l] = 1;
		}
		l++;
	}

	if (g_keysPressed[190] && !g_keysDebounce[190])
	{
		sprintf(s, ".");
		if (strlen(obj->buffer) < maxInput)
		{
			modified = 1;
			strcat(obj->buffer, s);
		}

		g_keysDebounce[190] = 1;
	}
	*/

	if (modified)
	{
		obj->entry->set(obj->entryIndex);
	}
}


//==========================
//New menu entry
//==========================
void Game_MenuNew_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "New");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuNew_Use(int index)
{
	Net_Disconnect();
	memset(&g_gameRules, 0, sizeof(g_gameRules));
	Game_Init();
	g_gameMenu.active = 0;
}


//==========================
//Host menu entry
//==========================
void Game_MenuHost_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Host");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuHost_Use(int index)
{
	Net_Listen(g_userInfo.connPort);
}


//==========================
//Connect menu entry
//==========================
void Game_MenuConnect_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Connect");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuConnect_Use(int index)
{
	Net_Connect(g_userInfo.connPort, g_userInfo.connIP);
}


//==========================
//Disconnect menu entry
//==========================
void Game_MenuDisconnect_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Disconnect/Stop hosting");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuDisconnect_Use(int index)
{
	Net_Disconnect();
}


//==========================
//IP menu entry
//==========================
void Game_MenuIP_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "IP");
	strcpy(g_gameMenu.menus[index].status, g_userInfo.connIP);
}

void Game_MenuIP_Use(int index)
{
	if (!g_menuInput.active)
	{
		g_menuInput.buffer = &g_userInfo.connIP[0];
		g_menuInput.entry = &g_gameMenu.menus[index];
		g_menuInput.entryIndex = index;
		g_menuInput.update = Game_MI_Use;
		g_menuInput.active = 1;		
	}
	else
	{
		g_menuInput.active = 0;
	}
}


//==========================
//Port menu entry
//==========================
static char g_portStr[MAX_PRINT_CHARS]={0};
void Game_MenuPort_Set(int index)
{
	if (!g_menuInput.active)
	{
		sprintf(g_portStr, "%i", g_userInfo.connPort);
	}
	strcpy(g_gameMenu.menus[index].title, "Port");
	strcpy(g_gameMenu.menus[index].status, g_portStr);
	g_userInfo.connPort = atoi(g_portStr);
}

void Game_MenuPort_Use(int index)
{
	if (!g_menuInput.active)
	{
		sprintf(g_portStr, "%i", g_userInfo.connPort);
		g_menuInput.buffer = &g_portStr[0];
		g_menuInput.entry = &g_gameMenu.menus[index];
		g_menuInput.entryIndex = index;
		g_menuInput.update = Game_MI_Use;
		g_menuInput.active = 1;		
	}
	else
	{
		g_menuInput.active = 0;
	}
}


//==========================
//Background menu entry
//==========================
void Game_MenuBackground_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Background");
	strcpy(g_gameMenu.menus[index].status, g_bgStrings[g_userInfo.background]);
}

void Game_MenuBackground_Use(int index)
{
	if (g_userInfo.background < 11)
	{
		g_userInfo.background++;
	}
	else
	{
		g_userInfo.background = 1;
	}
}


//==========================
//Texfilter menu entry
//==========================
void Game_MenuTexfilter_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Texture filtering");
	strcpy(g_gameMenu.menus[index].status, g_txStrings[g_userInfo.texFilter]);
}

void Game_MenuTexfilter_Use(int index)
{
	if (!g_userInfo.texFilter)
	{
		g_userInfo.texFilter = 1;
	}
	else
	{
		g_userInfo.texFilter = 0;
	}
}


//==========================
//Vidmode menu entry
//==========================
void Game_MenuVidmode_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Video mode");
	strcpy(g_gameMenu.menus[index].status, g_vidStrings[g_userInfo.vidMode]);
}

void Game_MenuVidmode_Use(int index)
{
	if (g_userInfo.vidMode == g_numVidmodes-1)
	{
		g_userInfo.vidMode = 0;
	}
	else
	{
		g_userInfo.vidMode++;
	}
}


//==========================
//BPP menu entry
//==========================
void Game_MenuBPP_Set(int index)
{
	char s[16];
	strcpy(g_gameMenu.menus[index].title, "Bits per pixel");
	sprintf(s, "%i", g_userInfo.bpp);
	strcpy(g_gameMenu.menus[index].status, s);
}

void Game_MenuBPP_Use(int index)
{
	if (g_userInfo.bpp == 32)
	{
		g_userInfo.bpp = 16;
	}
	else
	{
		g_userInfo.bpp = 32;
	}
}


//==========================
//Fullscreen menu entry
//==========================
void Game_MenuFullscreen_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Fullscreen");
	strcpy(g_gameMenu.menus[index].status, g_fsStrings[g_userInfo.fullScreen]);
}

void Game_MenuFullscreen_Use(int index)
{
	if (!g_userInfo.fullScreen)
	{
		g_userInfo.fullScreen = 1;
	}
	else
	{
		g_userInfo.fullScreen = 0;
	}
}


//==========================
//Limit framerate menu entry
//==========================
void Game_MenuLimitFramerate_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Limit framerate");
	strcpy(g_gameMenu.menus[index].status, g_fsStrings[g_userInfo.limitFramerate]);
}

void Game_MenuLimitFramerate_Use(int index)
{
	if (!g_userInfo.limitFramerate)
	{
		g_userInfo.limitFramerate = 1;
	}
	else
	{
		g_userInfo.limitFramerate = 0;
	}
}


//==========================
//Apply menu entry
//==========================
void Game_MenuApply_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "Apply/Save");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuApply_Use(int index)
{
	User_SaveUI();
	g_gameMenu.active = 0;
	g_rendererReinit = 1;
}


//==========================
//Quit menu entry
//==========================
void Game_MenuQuit_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "To dashboard");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuQuit_Use(int index)
{
	g_gameMenu.active = 0;
	//g_finishLoop = 1;

	LD_LAUNCH_DASHBOARD launchData = {XLD_LAUNCH_DASHBOARD_MAIN_MENU};
	XLaunchNewImage(NULL, (LAUNCH_DATA *)&launchData);
}


//==========================
//Credit menu entry
//==========================
void Game_MenuByMe_Set(int index)
{
	strcpy(g_gameMenu.menus[index].title, "\nXTriad - Written by MrAdults.\nhttp://www.telefragged.com/thefatal/");
	strcpy(g_gameMenu.menus[index].status, "");
}

void Game_MenuByMe_Use(int index)
{
	g_CGS.doink = g_Time + 100;
}


//==========================
//Open rule menu entry
//==========================
void Game_RuleMenuOpen_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Open");
	if (g_gameRules.open)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuOpen_Use(int index)
{
	g_gameRules.open = !g_gameRules.open;
}


//==========================
//Same rule menu entry
//==========================
void Game_RuleMenuSame_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Same");
	if (g_gameRules.same)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuSame_Use(int index)
{
	g_gameRules.same = !g_gameRules.same;
}


//==========================
//Plus rule menu entry
//==========================
void Game_RuleMenuPlus_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Plus");
	if (g_gameRules.plus)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuPlus_Use(int index)
{
	g_gameRules.plus = !g_gameRules.plus;
}


//==========================
//Combo rule menu entry
//==========================
void Game_RuleMenuCombo_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Combo");
	if (g_gameRules.combo)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuCombo_Use(int index)
{
	g_gameRules.combo = !g_gameRules.combo;
}


//==========================
//SD rule menu entry
//==========================
void Game_RuleMenuSD_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Sudden death");
	if (g_gameRules.suddenDeath)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuSD_Use(int index)
{
	g_gameRules.suddenDeath = !g_gameRules.suddenDeath;
}


//==========================
//Random rule menu entry
//==========================
void Game_RuleMenuRandom_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Random");
	if (g_gameRules.random)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuRandom_Use(int index)
{
	g_gameRules.random = !g_gameRules.random;
}


//==========================
//SW rule menu entry
//==========================
void Game_RuleMenuSW_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Same Wall");
	if (g_gameRules.sameWall)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuSW_Use(int index)
{
	g_gameRules.sameWall = !g_gameRules.sameWall;
}


//==========================
//Elem rule menu entry
//==========================
void Game_RuleMenuElem_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Elemental");
	if (g_gameRules.elemental)
	{
		strcpy(g_ruleMenu.menus[index].status, "Yes");
	}
	else
	{
		strcpy(g_ruleMenu.menus[index].status, "No");
	}
}

void Game_RuleMenuElem_Use(int index)
{
	g_gameRules.elemental = !g_gameRules.elemental;
}


//==========================
//Done rule menu entry
//==========================
void Game_RuleMenuDone_Set(int index)
{
	strcpy(g_ruleMenu.menus[index].title, "Done");
	strcpy(g_ruleMenu.menus[index].status, "");
}

//set up the element grid
void Game_SetupElements(void)
{
	if (g_gameRules.elemental &&
		g_hostPlayer)
	{ //set up the elemental grid
		int gridChoice;
		int numGridElem = 0;

		while (numGridElem < 2)
		{ //put 2 elementals randomly on the board
			gridChoice = rand()%9;
			if (!g_gameState.elementalGrid[gridChoice])
			{
				g_gameState.elementalGrid[gridChoice] = (rand()%(CARD_ELEM_NUM-1))+1;
				numGridElem++;
			}
		}

		if (g_socketCreated)
		{
			Net_SendElementGrid();
		}
	}
}

void Game_RuleMenuDone_Use(int index)
{
	g_gameRules.set = 1;
	g_ruleMenu.active = 0;
}


//initialize game menus
void Game_MenuInit(void)
{
	int i = 0;
	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuNew_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuNew_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

#if 1 //netplay
	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuHost_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuHost_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuConnect_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuConnect_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuDisconnect_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuDisconnect_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuIP_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuIP_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuPort_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuPort_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;
#endif

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuBackground_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuBackground_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuTexfilter_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuTexfilter_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	/*
	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuVidmode_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuVidmode_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuBPP_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuBPP_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuFullscreen_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuFullscreen_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuLimitFramerate_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuLimitFramerate_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;
	*/

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuApply_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuApply_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuQuit_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuQuit_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	g_gameMenu.menus[g_gameMenu.numMenus].set = Game_MenuByMe_Set;
	g_gameMenu.menus[g_gameMenu.numMenus].use = Game_MenuByMe_Use;
	g_gameMenu.menus[g_gameMenu.numMenus].inuse = 1;
	g_gameMenu.numMenus++;

	while (i < g_gameMenu.numMenus)
	{
		g_gameMenu.menus[i].set(i);
		i++;
	}

	//set up the rule menu now
	i = 0;
	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuOpen_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuOpen_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuSame_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuSame_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuPlus_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuPlus_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuCombo_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuCombo_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuSD_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuSD_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuRandom_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuRandom_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuSW_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuSW_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuElem_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuElem_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	g_ruleMenu.menus[g_ruleMenu.numMenus].set = Game_RuleMenuDone_Set;
	g_ruleMenu.menus[g_ruleMenu.numMenus].use = Game_RuleMenuDone_Use;
	g_ruleMenu.menus[g_ruleMenu.numMenus].inuse = 1;
	g_ruleMenu.numMenus++;

	while (i < g_ruleMenu.numMenus)
	{
		g_ruleMenu.menus[i].set(i);
		i++;
	}
}

//menu key input
void Game_MenuInput(gameMenu_t *menu)
{
	if (g_menuInput.active)
	{ //a single control has focus currently
		g_menuInput.update(&g_menuInput);
		return;
	}

	if (g_keysPressed[VK_UP] && !g_keysDebounce[VK_UP])
	{ //scroll up
		menu->menu--;
		if (menu->menu < 0)
		{
			menu->menu = menu->numMenus-1;
		}
		if (g_sound_menuMove)
		{
			S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
		}
		g_keysDebounce[VK_UP] = 1;
	}

	if (g_keysPressed[VK_DOWN] && !g_keysDebounce[VK_DOWN])
	{ //scroll down
		menu->menu++;
		if (menu->menu == menu->numMenus)
		{
			menu->menu = 0;
		}
		if (g_sound_menuMove)
		{
			S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
		}
		g_keysDebounce[VK_DOWN] = 1;
	}

	if (g_keysPressed[VK_RETURN] && !g_keysDebounce[VK_RETURN])
	{ //use the selected item
		g_keysDebounce[VK_RETURN] = 1;
		menu->menus[menu->menu].use(menu->menu);
		menu->menus[menu->menu].set(menu->menu);
		if (g_sound_menuUse)
		{
			S_PlayRawData(&g_sound_menuUse->data.data, g_sound_menuUse->data.size, BUFFER1);
		}
	}
}

//card totals for each player
void Game_TallyCards(void)
{
	int i = 0;
	int p1 = 0;
	int p2 = 0;
	drawCard_t *c;

	while (i < NUM_CARDS_PER_PLAYER*2)
	{
		if (i < NUM_CARDS_PER_PLAYER)
		{ //player 1
			c = &g_pl1Cards[i];
		}
		else
		{ //player 2
			c = &g_pl2Cards[i-NUM_CARDS_PER_PLAYER];
		}

		if (c->altTex)
		{
			p2++;
		}
		else
		{
			p1++;
		}

		i++;
	}

	g_gameState.p1Total = p1;
	g_gameState.p2Total = p2;
	g_gameState.drawP2Total = p2;
}

//player has finished choosing cards
void Game_BeginRound(void)
{
	if (!g_socketCreated)
	{
		g_gameState.pl2Computer = 1;
	}

	if (g_gameState.pl2Computer)
	{ //pick random cards
		drawCard_t *base = &g_pl2Cards[0];
		int i = 0;

		while (i < NUM_CARDS_PER_PLAYER)
		{
			base->pCard = &g_playingCards[rand()%NUM_CARDS];
			base++;
			i++;
		}

		g_gameState.p2ChosenCards = 1;
	}

	Game_SetupElements();

	if (g_socketCreated)
	{
		Net_SendCards();
	}

	if (g_gameState.p2ChosenCards)
	{
		Game_TallyCards();
		g_gameState.arrowDeciding = g_Time + 2000;
	}
}

//card selection screen input
void Game_CardScreenInput(void)
{
	int updateCard = 0;

	if (g_keysPressed[VK_UP] && !g_keysDebounce[VK_UP])
	{ //scroll up
		g_gameState.cardSelected--;
		if (g_gameState.cardSelected < 0)
		{
			g_gameState.cardSelected = NUM_CARDS_PER_LEVEL-1;
		}
		g_keysDebounce[VK_UP] = 1;
		updateCard = 1;
		if (g_sound_menuMove)
		{
			S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
		}
	}

	if (g_keysPressed[VK_DOWN] && !g_keysDebounce[VK_DOWN])
	{ //scroll down
		g_gameState.cardSelected++;
		if (g_gameState.cardSelected == NUM_CARDS_PER_LEVEL)
		{
			g_gameState.cardSelected = 0;
		}
		g_keysDebounce[VK_DOWN] = 1;
		updateCard = 1;
		if (g_sound_menuMove)
		{
			S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
		}
	}

	if (g_keysPressed[VK_LEFT] && !g_keysDebounce[VK_LEFT])
	{ //page left
		g_gameState.cardPage--;
		if (g_gameState.cardPage < 0)
		{
			g_gameState.cardPage = NUM_LEVELS-1;
		}
		g_keysDebounce[VK_LEFT] = 1;
		updateCard = 1;
		if (g_sound_menuMove)
		{
			S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
		}
	}

	if (g_keysPressed[VK_RIGHT] && !g_keysDebounce[VK_RIGHT])
	{ //page right
		g_gameState.cardPage++;
		if (g_gameState.cardPage == NUM_LEVELS)
		{
			g_gameState.cardPage = 0;
		}
		g_keysDebounce[VK_RIGHT] = 1;
		updateCard = 1;
		if (g_sound_menuMove)
		{
			S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
		}
	}

	if (g_keysPressed[VK_RETURN] && !g_keysDebounce[VK_RETURN])
	{ //pick this card
		if (g_sound_menuUse)
		{
			S_PlayRawData(&g_sound_menuUse->data.data, g_sound_menuUse->data.size, BUFFER1);
		}
		g_keysDebounce[VK_RETURN] = 1;
		if (g_gameState.cardsChosen == NUM_CARDS_PER_PLAYER)
		{
			g_gameState.chosenCards = 1;
			Game_BeginRound();
		}
		else
		{
			playingCard_t *baseList = &g_playingCards[0];
			baseList += (g_gameState.cardPage*NUM_CARDS_PER_LEVEL)+g_gameState.cardSelected;

			g_pl1Cards[g_gameState.cardsChosen].pCard = baseList;
			g_gameState.cardsChosen++;
		}
	}

	if (g_keysPressed[VK_SPACE] && !g_keysDebounce[VK_SPACE])
	{ //cancel last card
		if (g_sound_menuUse)
		{
			S_PlayRawData(&g_sound_menuUse->data.data, g_sound_menuUse->data.size, BUFFER1);
		}
		if (g_gameState.cardsChosen > 0)
		{
			g_gameState.cardsChosen--;
		}
		g_keysDebounce[VK_SPACE] = 1;
	}

	if (updateCard)
	{ //changed the card so update it now
		playingCard_t *baseList = &g_playingCards[0];
		baseList += (g_gameState.cardPage*NUM_CARDS_PER_LEVEL)+g_gameState.cardSelected;

		g_previewCard.pCard = baseList;
		Game_CardPosition(CPOS_CARDOFF_S, g_previewCard.pos);
	}
}

//see if any other card already occupies a grid space
drawCard_t *Game_CardOccupied(int space)
{
	int i = 0;
	drawCard_t *c;

	while (i < (NUM_CARDS_PER_PLAYER*2))
	{
		if (i < NUM_CARDS_PER_PLAYER)
		{ //player 1
			c = &g_pl1Cards[i];
		}
		else
		{ //player 2
			c = &g_pl2Cards[i-NUM_CARDS_PER_PLAYER];
		}

		if (c->gotoGridSpot == space)
		{ //this guy is heading there or is there now
			return c;
		}

		i++;
	}

	//no one
	return NULL;
}

//check key input
void Game_Input(void)
{
	if (!g_menuInput.active &&
		g_keysPressed[VK_ESCAPE] && !g_keysDebounce[VK_ESCAPE])
	{ //toggle menu
		if (g_gameMenu.active)
		{
			g_gameMenu.active = 0;
		}
		else
		{
			g_gameMenu.active = 1;
		}
		g_gameMenu.menu = 0;
		g_keysDebounce[VK_ESCAPE] = 1;
	}

	if (!g_menuInput.active &&
		g_keysPressed[VK_SPACE] && !g_keysDebounce[VK_SPACE])
	{ //toggle menu only to off
		if (g_gameMenu.active)
		{
			g_gameMenu.active = 0;
			g_gameMenu.menu = 0;
			g_keysDebounce[VK_SPACE] = 1;
		}
	}

	if (g_gameMenu.active)
	{ //redirect input to menu function
		Game_MenuInput(&g_gameMenu);
		return;
	}

	if (g_ruleMenu.active)
	{ //redirect input to menu function
		Game_MenuInput(&g_ruleMenu);
		return;
	}

	if (!g_gameRules.set && !g_hostPlayer)
	{ //waiting for rules from host
		return;
	}

	if (g_listenSocketCreated)
	{ //waiting for a connection
		return;
	}

	if (g_socketCreated &&
		g_gameState.chosenCards &&
		!g_gameState.p2ChosenCards)
	{ //waiting for card choices from remote player
		return;
	}

	if (!g_gameState.chosenCards)
	{ //card selection screen
		if (g_gameRules.random)
		{ //force a random deck
			g_gameState.cardsChosen = 0;

			while (g_gameState.cardsChosen < NUM_CARDS_PER_PLAYER)
			{
				g_pl1Cards[g_gameState.cardsChosen].pCard = &g_playingCards[rand()%NUM_CARDS];
				g_gameState.cardsChosen++;
			}
			g_gameState.chosenCards = 1;
			Game_BeginRound();
			return;
		}
		Game_CardScreenInput();
		return;
	}

	if (g_gameState.waitingTurn == 1)
	{ //it's my turn
		int i = 0;

		if (!g_gameState.p1Turn_OnBoard)
		{ //selecting from deck still
			if (g_keysPressed[VK_UP] && !g_keysDebounce[VK_UP])
			{ //scroll up
				i = g_gameState.p1Turn_Selection-1;
				while (i != g_gameState.p1Turn_Selection)
				{ //loop through and find the first card in this direction
					if (i < 0)
					{
						i = NUM_CARDS_PER_PLAYER-1;
					}

					if (g_pl1Cards[i].gotoGridSpot <= CPOS_CARDP2_5)
					{ //still in the deck, so it's valid
						break;
					}

					i--;
				}
				g_pl1Cards[g_gameState.p1Turn_Selection].selected = 0;
				g_gameState.p1Turn_Selection = i;
				g_pl1Cards[g_gameState.p1Turn_Selection].selected = 1;

				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
				}

				g_keysDebounce[VK_UP] = 1;
			}
			if (g_keysPressed[VK_DOWN] && !g_keysDebounce[VK_DOWN])
			{ //scroll down
				i = g_gameState.p1Turn_Selection+1;
				while (i != g_gameState.p1Turn_Selection)
				{ //loop through and find the first card in this direction
					if (i >= NUM_CARDS_PER_PLAYER)
					{
						i = 0;
					}

					if (g_pl1Cards[i].gotoGridSpot <= CPOS_CARDP2_5)
					{ //still in the deck, so it's valid
						break;
					}

					i++;
				}
				g_pl1Cards[g_gameState.p1Turn_Selection].selected = 0;
				g_gameState.p1Turn_Selection = i;
				g_pl1Cards[g_gameState.p1Turn_Selection].selected = 1;

				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
				}

				g_keysDebounce[VK_DOWN] = 1;
			}
			if (g_keysPressed[VK_RETURN] && !g_keysDebounce[VK_RETURN])
			{ //place this card
				if (g_sound_menuUse)
				{
					S_PlayRawData(&g_sound_menuUse->data.data, g_sound_menuUse->data.size, BUFFER1);
				}
				g_gameState.p1Turn_OnBoard = 1;
				g_keysDebounce[VK_RETURN] = 1;
			}
		}
		else
		{ //on-board placement
			if (g_keysPressed[VK_UP] && !g_keysDebounce[VK_UP])
			{ //move up on grid
				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
				}
				g_gameState.p1Turn_OnBoard_Grid -= 3;
				if (g_gameState.p1Turn_OnBoard_Grid < CPOS_CARDX_1)
				{
					g_gameState.p1Turn_OnBoard_Grid += 9;
				}
				g_keysDebounce[VK_UP] = 1;
			}
			if (g_keysPressed[VK_DOWN] && !g_keysDebounce[VK_DOWN])
			{ //move down on grid
				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
				}
				g_gameState.p1Turn_OnBoard_Grid += 3;
				if (g_gameState.p1Turn_OnBoard_Grid > CPOS_CARDX_9)
				{
					g_gameState.p1Turn_OnBoard_Grid -= 9;
				}
				g_keysDebounce[VK_DOWN] = 1;
			}
			if (g_keysPressed[VK_RIGHT] && !g_keysDebounce[VK_RIGHT])
			{ //move right on grid
				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
				}
				g_gameState.p1Turn_OnBoard_Grid++;
				if (g_gameState.p1Turn_OnBoard_Grid == CPOS_CARDX_9+1 ||
					g_gameState.p1Turn_OnBoard_Grid == CPOS_CARDX_6+1 ||
					g_gameState.p1Turn_OnBoard_Grid == CPOS_CARDX_3+1)
				{
					g_gameState.p1Turn_OnBoard_Grid -= 3;
				}
				g_keysDebounce[VK_RIGHT] = 1;
			}
			if (g_keysPressed[VK_LEFT] && !g_keysDebounce[VK_LEFT])
			{ //move left on grid
				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER1);
				}
				g_gameState.p1Turn_OnBoard_Grid--;
				if (g_gameState.p1Turn_OnBoard_Grid == CPOS_CARDX_1-1 ||
					g_gameState.p1Turn_OnBoard_Grid == CPOS_CARDX_4-1 ||
					g_gameState.p1Turn_OnBoard_Grid == CPOS_CARDX_7-1)
				{
					g_gameState.p1Turn_OnBoard_Grid += 3;
				}
				g_keysDebounce[VK_LEFT] = 1;
			}

			if (g_keysPressed[VK_SPACE] && !g_keysDebounce[VK_SPACE])
			{ //cancel
				if (g_sound_menuUse)
				{
					S_PlayRawData(&g_sound_menuUse->data.data, g_sound_menuUse->data.size, BUFFER1);
				}
				g_gameState.p1Turn_OnBoard = 0;
				g_keysDebounce[VK_SPACE] = 1;
			}

			if (g_keysPressed[VK_RETURN] && !g_keysDebounce[VK_RETURN])
			{ //place the card
				if (!Game_CardOccupied(g_gameState.p1Turn_OnBoard_Grid))
				{
					if (g_sound_cardWoosh)
					{
						S_PlayRawData(&g_sound_cardWoosh->data.data, g_sound_cardWoosh->data.size, BUFFER2);
					}
					if (g_sound_menuUse)
					{
						S_PlayRawData(&g_sound_menuUse->data.data, g_sound_menuUse->data.size, BUFFER1);
					}

					drawCard_t *selected = &g_pl1Cards[g_gameState.p1Turn_Selection];
					g_gameState.p1Turn_OnBoard = 0;
					g_gameState.waitingTurn = 0;
					selected->selected = 0;
					selected->gridTravelTime = g_Time + 1000;
					selected->gotoGridSpot = g_gameState.p1Turn_OnBoard_Grid;
				}
				g_keysDebounce[VK_RETURN] = 1;
			}
		}
	}
}

//game initialization functions
void Game_Init(void)
{
	int i = 0;
	drawCard_t *c;

	//seed random number based on time
	srand(GetTickCount());

	memset(&g_gameState, 0, sizeof(g_gameState));

	while (i < g_ruleMenu.numMenus)
	{
		g_ruleMenu.menus[i].set(i);
		i++;
	}
	i = 0;

	g_CGS.pCStrTime = 0;
	g_gameState.perfectVert = -7.0f;

	//init all player cards
	while (i < (NUM_CARDS_PER_PLAYER*2)+1)
	{
		if (i < NUM_CARDS_PER_PLAYER)
		{ //player 1
			c = &g_pl1Cards[i];
		}
		else if (i < (NUM_CARDS_PER_PLAYER*2))
		{ //player 2
			c = &g_pl2Cards[i-NUM_CARDS_PER_PLAYER];
		}
		else
		{ //preview card
			c = &g_previewCard;
		}

		memset(c, 0, sizeof(drawCard_t));

		if (i < NUM_CARDS_PER_PLAYER || i >= (NUM_CARDS_PER_PLAYER*2))
		{ //player 1
			c->cardIndex = i;
			c->altTex = 0;
			c->initialPlayer = 1;
		}
		else
		{ //player 2
			c->cardIndex = (i-NUM_CARDS_PER_PLAYER);
			c->altTex = 1;
			c->initialPlayer = 2;
		}

		c->desiredAng[0] = 0.0f; //pitch
		if (i < NUM_CARDS_PER_PLAYER)
		{ //player 1
			Game_CardPosition(CPOS_CARDOFF_1, c->pos);
			c->desiredAng[1] = 180.0f; //yaw
		}
		else if (i < (NUM_CARDS_PER_PLAYER*2))
		{ //player 2
			Game_CardPosition(CPOS_CARDOFF_2, c->pos);
			c->desiredAng[1] = 0.0f; //yaw
		}
		else
		{ //preview card
			Game_CardPosition(CPOS_CARDOFF_S, c->pos);
			c->ang[1] = 180.0f;
		}
		c->desiredAng[2] = 0.0f; //roll

		c->hRadius = 2.0f;
		c->wRadius = 1.6f;

		//start it out at the correct z
		c->pos[2] = g_cardZoom;

		Game_CardPosition(i, c->desiredPos);
		c->gridSpot = i;
		c->gotoGridSpot = i;

		//just assign it for now, the player will have to choose anyway
		c->pCard = &g_playingCards[0];

		i++;
	}
}

//move card pos to desiredPos
void Game_LerpCardPos(drawCard_t *c, float speed)
{
	int i = 0;

	float speedMod = g_lastFrameDif*0.08f;

	while (i < 3)
	{
		if (c->pos[i] < c->desiredPos[i])
		{
			c->pos[i] += speed*speedMod;
			if (c->pos[i] > c->desiredPos[i])
			{
				c->pos[i] = c->desiredPos[i];
			}
		}
		else if (c->pos[i] > c->desiredPos[i])
		{
			c->pos[i] -= speed*speedMod;
			if (c->pos[i] < c->desiredPos[i])
			{
				c->pos[i] = c->desiredPos[i];
			}
		}
		i++;
	}
}

//move card ang to desiredAng
void Game_LerpCardAngles(drawCard_t *c, float speed)
{
	int i = 0;

	float speedMod = g_lastFrameDif*0.08f;

	while (i < 3)
	{
		if (c->ang[i] < c->desiredAng[i])
		{
			c->ang[i] += speed*speedMod;
			if (c->ang[i] > c->desiredAng[i])
			{
				c->ang[i] = c->desiredAng[i];
			}
		}
		else if (c->ang[i] > c->desiredAng[i])
		{
			c->ang[i] -= speed*speedMod;
			if (c->ang[i] < c->desiredAng[i])
			{
				c->ang[i] = c->desiredAng[i];
			}
		}
		i++;
	}
}

//set up local player's turn stuff
void Game_SetupLocalPlayerTurn(void)
{
	drawCard_t *base = &g_pl1Cards[0];
	drawCard_t *first = NULL;
	int i = 0;

	while (i < NUM_CARDS_PER_PLAYER)
	{
		if (base->gotoGridSpot <= CPOS_CARDP2_5)
		{ //still in the deck
			first = base;
			break;
		}
		base++;
		i++;
	}

	if (first)
	{
		drawCard_t *selected;

		g_gameState.p1Turn_Selection = first->cardIndex;
		selected = &g_pl1Cards[g_gameState.p1Turn_Selection];
		selected->selected = 1;

		g_gameState.p1Turn_OnBoard = 0;
		g_gameState.p1Turn_OnBoard_Grid = CPOS_CARDX_5;
	}
}

//get neighbor, up down left or right
#define CARD_RIGHT			0
#define CARD_LEFT			1
#define CARD_UP				2
#define CARD_DOWN			3
drawCard_t *Game_NeighboringCard(int gridSpot, int dir, int ignoreTeam)
{
	int g = gridSpot;
	drawCard_t *r;

	if (dir == CARD_RIGHT)
	{
		g++;
		if (g == CPOS_CARDX_3+1 ||
			g == CPOS_CARDX_6+1 ||
			g == CPOS_CARDX_9+1)
		{ //against a wall in this dir
			return NULL;
		}
	}
	else if (dir == CARD_LEFT)
	{
		g--;
		if (g == CPOS_CARDX_1-1 ||
			g == CPOS_CARDX_4-1 ||
			g == CPOS_CARDX_7-1)
		{ //against a wall in this dir
			return NULL;
		}
	}
	else if (dir == CARD_UP)
	{
		g -= 3;
		if (g < CPOS_CARDX_1)
		{ //against a wall in this dir
			return NULL;
		}
	}
	else if (dir == CARD_DOWN)
	{
		g += 3;
		if (g > CPOS_CARDX_9)
		{ //against a wall in this dir
			return NULL;
		}
	}

	r = Game_CardOccupied(g);

	if (ignoreTeam != -1)
	{
		if (r && r->altTex == ignoreTeam)
		{
			return NULL;
		}
	}

	return r;
}

//see if a grid spot neighbors a wall in said direction
int Game_NeighboringWall(int gridSpot, int dir)
{
	int g = gridSpot;

	if (dir == CARD_RIGHT)
	{
		g++;
		if (g == CPOS_CARDX_3+1 ||
			g == CPOS_CARDX_6+1 ||
			g == CPOS_CARDX_9+1)
		{ //against a wall in this dir
			return 1;
		}
	}
	else if (dir == CARD_LEFT)
	{
		g--;
		if (g == CPOS_CARDX_1-1 ||
			g == CPOS_CARDX_4-1 ||
			g == CPOS_CARDX_7-1)
		{ //against a wall in this dir
			return 1;
		}
	}
	else if (dir == CARD_UP)
	{
		g -= 3;
		if (g < CPOS_CARDX_1)
		{ //against a wall in this dir
			return 1;
		}
	}
	else if (dir == CARD_DOWN)
	{
		g += 3;
		if (g > CPOS_CARDX_9)
		{ //against a wall in this dir
			return 1;
		}
	}

	return 0;
}

//take a card on the board
int Game_CardTaken(drawCard_t *taker, drawCard_t *taken, int allowRecursion)
{
	if (!taken)
	{ //happens, since I'm too lazy to check if it's a wall
		return 0;
	}


	if (g_gameRules.combo && allowRecursion)
	{ //take other cards in the name of the taker
		int currentTex = taken->altTex;
		taken->altTex = taker->altTex;
		assert(taken->altTex >= 0);

		Game_CheckTakes(taken, -1, 1);

		//we will actually switch textures during the flipping
		taken->altTex = currentTex;
		assert(taken->altTex >= 0);
	}

	if (taken->takenStep)
	{ //already in the process of being taken
		return 0;
	}

	if (g_gameState.ai_simulation)
	{ //add to the value we would take in this scenario
		g_gameState.ai_taken += (taken->pCard->up+taken->pCard->down+taken->pCard->left+taken->pCard->right);
	}
	else
	{
		taken->takenSide = taker->altTex;
		taken->takenStep = 3;
		taken->takenTime = 0;
	}

	return 1;
}

//difference caused by elemental handicap
int Game_ElementalHandicap(drawCard_t *c)
{
	int elem;

	if (!g_gameRules.elemental)
	{ //none
		return 0;
	}

	if (c->gridSpot < CPOS_CARDX_1 ||
		c->gridSpot > CPOS_CARDX_9)
	{ //not on a grid spot
		return 0;
	}

	if (c->gridSpot != c->gotoGridSpot)
	{ //not settled
		return 0;
	}

	if (c->cardIndex == (NUM_CARDS_PER_PLAYER*2))
	{ //preview card
		return 0;
	}

	elem = g_gameState.elementalGrid[c->gridSpot-CPOS_CARDX_1];

	if (!elem)
	{ //no elem on this grid space
		return 0;
	}

	if (c->pCard->elemental != elem)
	{ //elem does not match, -1
		return -1;
	}

	//elem matches, +1
	return 1;
}

//value of card, taking elementals into account
int Game_CardValue(drawCard_t *c, int dir)
{
	int base = 0;
	if (dir == CARD_UP)
	{
		base = c->pCard->up;
	}
	else if (dir == CARD_DOWN)
	{
		base = c->pCard->down;
	}
	else if (dir == CARD_RIGHT)
	{
		base = c->pCard->right;
	}
	else if (dir == CARD_LEFT)
	{
		base = c->pCard->left;
	}

	return base+Game_ElementalHandicap(c);
}

//see if a freshly placed (or taken, if combo) card can take any others near itself
void Game_CheckTakes(drawCard_t *c, int gridSpot, int powerOnly)
{
	drawCard_t *up;
	drawCard_t *down;
	drawCard_t *right;
	drawCard_t *left;
	int up_u, up_d, up_l, up_r;
	int down_u, down_d, down_l, down_r;
	int right_u, right_d, right_l, right_r;
	int left_u, left_d, left_l, left_r;
	int me_u, me_d, me_l, me_r;
	int r = 0;
	int plusBonus = 0;
	int sameBonus = 0;
	int gridCheck;

	if (!c)
	{
		return;
	}

	if (gridSpot == -1)
	{
		gridCheck = c->gridSpot;
	}
	else
	{ //override check
		gridCheck = gridSpot;
	}

	up = Game_NeighboringCard(gridCheck, CARD_UP, c->altTex);
	down = Game_NeighboringCard(gridCheck, CARD_DOWN, c->altTex);
	right = Game_NeighboringCard(gridCheck, CARD_RIGHT, c->altTex);
	left = Game_NeighboringCard(gridCheck, CARD_LEFT, c->altTex);

	me_u = Game_CardValue(c, CARD_UP);
	me_d = Game_CardValue(c, CARD_DOWN);
	me_l = Game_CardValue(c, CARD_LEFT);
	me_r = Game_CardValue(c, CARD_RIGHT);

	//get appropriate values for each card neighbor taking
	//elemental mods into account
	if (!up)
	{
		up_u = up_d = up_l = up_r = -1;
	}
	else
	{
		up_u = Game_CardValue(up, CARD_UP);
		up_d = Game_CardValue(up, CARD_DOWN);
		up_l = Game_CardValue(up, CARD_LEFT);
		up_r = Game_CardValue(up, CARD_RIGHT);
	}
	if (!down)
	{
		down_u = down_d = down_l = down_r = -1;
	}
	else
	{
		down_u = Game_CardValue(down, CARD_UP);
		down_d = Game_CardValue(down, CARD_DOWN);
		down_l = Game_CardValue(down, CARD_LEFT);
		down_r = Game_CardValue(down, CARD_RIGHT);
	}
	if (!right)
	{
		right_u = right_d = right_l = right_r = -1;
	}
	else
	{
		right_u = Game_CardValue(right, CARD_UP);
		right_d = Game_CardValue(right, CARD_DOWN);
		right_l = Game_CardValue(right, CARD_LEFT);
		right_r = Game_CardValue(right, CARD_RIGHT);
	}
	if (!left)
	{
		left_u = left_d = left_l = left_r = -1;
	}
	else
	{
		left_u = Game_CardValue(left, CARD_UP);
		left_d = Game_CardValue(left, CARD_DOWN);
		left_l = Game_CardValue(left, CARD_LEFT);
		left_r = Game_CardValue(left, CARD_RIGHT);
	}

	//do normal rule takes
	if (me_u > up_d)
	{
		Game_CardTaken(c, up, 0);
#ifdef _RULE_DEBUG
		Game_Print("STANDARD!! 1");
#endif
	}
	if (me_r > right_l)
	{
		Game_CardTaken(c, right, 0);
#ifdef _RULE_DEBUG
		Game_Print("STANDARD!! 2");
#endif
	}
	if (me_d > down_u)
	{
		Game_CardTaken(c, down, 0);
#ifdef _RULE_DEBUG
		Game_Print("STANDARD!! 3");
#endif
	}
	if (me_l > left_r)
	{
		Game_CardTaken(c, left, 0);
#ifdef _RULE_DEBUG
		Game_Print("STANDARD!! 4");
#endif
	}

	if (powerOnly)
	{ //called as the result of a combo
		return;
	}

	if (g_gameRules.plus)
	{ //see if anything can be taken under the plus rule
		if (me_u+me_r == up_d+right_l &&
			up_d != -1 && right_l != -1)
		{
			Game_CardTaken(c, up, 1);
			Game_CardTaken(c, right, 1);
#ifdef _RULE_DEBUG
			Game_Print("PLUS!! 1");
#endif
			plusBonus = 1;
		}
		if (me_r+me_d == right_l+down_u &&
			right_l != -1 && down_u != -1)
		{
			Game_CardTaken(c, right, 1);
			Game_CardTaken(c, down, 1);
#ifdef _RULE_DEBUG
			Game_Print("PLUS!! 2");
#endif
			plusBonus = 1;
		}
		if (me_d+me_l == down_u+left_r &&
			down_u != -1 && left_r != -1)
		{
			Game_CardTaken(c, down, 1);
			Game_CardTaken(c, left, 1);
#ifdef _RULE_DEBUG
			Game_Print("PLUS!! 3");
#endif
			plusBonus = 1;
		}
		if (me_l+me_u == left_r+up_d &&
			left_r != -1 && up_d != -1)
		{
			Game_CardTaken(c, left, 1);
			Game_CardTaken(c, up, 1);
#ifdef _RULE_DEBUG
			Game_Print("PLUS!! 4");
#endif
			plusBonus = 1;
		}

		if (me_u+me_d == down_u+up_d &&
			down_u != -1 && up_d != -1)
		{
			Game_CardTaken(c, up, 1);
			Game_CardTaken(c, down, 1);
#ifdef _RULE_DEBUG
			Game_Print("PLUS!! 5");
#endif
			plusBonus = 1;
		}

		if (me_l+me_r == left_r+right_l &&
			left_r != -1 && right_l != -1)
		{
			Game_CardTaken(c, left, 1);
			Game_CardTaken(c, right, 1);
#ifdef _RULE_DEBUG
			Game_Print("PLUS!! 6");
#endif
			plusBonus = 1;
		}
	}

	if (g_gameRules.same)
	{ //see if anything can be taken under the same rule
		if (g_gameRules.sameWall)
		{ //then wall has value of 10 to assist in taking other cards
			if (Game_NeighboringWall(gridCheck, CARD_UP))
			{
				up_d = 10;
			}
			if (Game_NeighboringWall(gridCheck, CARD_DOWN))
			{
				down_u = 10;
			}
			if (Game_NeighboringWall(gridCheck, CARD_RIGHT))
			{
				right_l = 10;
			}
			if (Game_NeighboringWall(gridCheck, CARD_LEFT))
			{
				left_r = 10;
			}
		}

		if (me_u == up_d &&
			up_d != -1 &&
			me_r == right_l &&
			right_l != -1)
		{
			Game_CardTaken(c, up, 1);
			Game_CardTaken(c, right, 1);
#ifdef _RULE_DEBUG
			Game_Print("SAME!! 1");
#endif
			if (up || right)
			{
				sameBonus = 1;
			}
		}
		if (me_r == right_l &&
			right_l != -1 &&
			me_d == down_u &&
			down_u != -1)
		{
			Game_CardTaken(c, right, 1);
			Game_CardTaken(c, down, 1);
#ifdef _RULE_DEBUG
			Game_Print("SAME!! 2");
#endif
			if (right || down)
			{
				sameBonus = 1;
			}
		}
		if (me_d == down_u &&
			down_u != -1 &&
			me_l == left_r &&
			left_r != -1)
		{
			Game_CardTaken(c, down, 1);
			Game_CardTaken(c, left, 1);
#ifdef _RULE_DEBUG
			Game_Print("SAME!! 3");
#endif
			if (down || left)
			{
				sameBonus = 1;
			}
		}
		if (me_l == left_r &&
			left_r != -1 &&
			me_u == up_d &&
			up_d != -1)
		{
			Game_CardTaken(c, left, 1);
			Game_CardTaken(c, up, 1);
#ifdef _RULE_DEBUG
			Game_Print("SAME!! 5");
#endif
			if (left || up)
			{
				sameBonus = 1;
			}
		}

		if (me_u == up_d &&
			up_d != -1 &&
			me_d == down_u &&
			down_u != -1)
		{
			Game_CardTaken(c, up, 1);
			Game_CardTaken(c, down, 1);
#ifdef _RULE_DEBUG
			Game_Print("SAME!! 6");
#endif
			if (up || down)
			{
				sameBonus = 1;
			}
		}

		if (me_l == left_r &&
			left_r != -1 &&
			me_r == right_l &&
			right_l != -1)
		{
			Game_CardTaken(c, left, 1);
			Game_CardTaken(c, right, 1);
#ifdef _RULE_DEBUG
			Game_Print("SAME!! 7");
#endif
			if (left || right)
			{
				sameBonus = 1;
			}
		}
	}

	if (!g_gameState.ai_simulation)
	{
		if (sameBonus)
		{
			Game_CoordPrint(640.0f/2.0f-55.0f, 480.0f/2.0f, "Same!");
		}
		else if (plusBonus)
		{
			Game_CoordPrint(640.0f/2.0f-55.0f, 480.0f/2.0f, "Plus!");
		}
	}
}

//a card arrives at a spot on the game board
void Game_CardPlaced(drawCard_t *c)
{
	Game_CheckTakes(c, -1, 0);

	//set up the turn for the next player
	if (c->initialPlayer == 1)
	{
		g_gameState.setWaiting = 2;
	}
	else
	{
		g_gameState.setWaiting = 1;
	}

	g_gameState.setWaitingTime = g_Time + 300;
}

//do card logic so cards can update themselves
void Game_CardThink(drawCard_t *c)
{
	if (c->gridSpot != c->gotoGridSpot)
	{
		//invalidate the grid spot until arrival
		c->gridSpot = -1;

		if (c->gridTravelTime > g_Time)
		{ //go up above the spot so we can float down from above the screen
			float newSpot[3];
			long dif = c->gridTravelTime;
			
			dif -= g_Time;

			Game_CardPosition(c->gotoGridSpot, newSpot);
			c->desiredPos[1] = 10.0f;
			if (dif >= 500)
			{ //lift upward first
				float sideSpot[3];

				if (c->initialPlayer == 1)
				{
					Game_CardPosition(CPOS_CARDP1_1, sideSpot);
				}
				else
				{
					Game_CardPosition(CPOS_CARDP2_1, sideSpot);
				}

				c->desiredPos[0] = sideSpot[0];
				c->desiredPos[2] = newSpot[2]+0.2f;
			}
			else
			{
				c->desiredPos[0] = newSpot[0];
				c->desiredPos[2] = -0.1f;
			}
		}
		else
		{
			Game_CardPosition(c->gotoGridSpot, c->desiredPos);

			//see if we have travelled to the spot yet
			if (c->pos[0] == c->desiredPos[0] &&
				c->pos[1] == c->desiredPos[1] &&
				c->pos[2] == c->desiredPos[2])
			{ //we made it
				c->gridSpot = c->gotoGridSpot;

				if (c->gridSpot >= CPOS_CARDX_1 &&
					c->gridSpot <= CPOS_CARDX_9)
				{ //we were going to a board spot, that means a player just made his turn
					if (g_sound_cardWoosh)
					{
						S_PlayRawData(&g_sound_cardWoosh->data.data, g_sound_cardWoosh->data.size, BUFFER2);
					}
					Game_CardPlaced(c);
				}
			}
		}
	}


	if (c->initialPlayer == 1 &&
		!g_gameState.chosenCards)
	{ //only display cards that are chosen so far
		if (c->cardIndex == (NUM_CARDS_PER_PLAYER*2))
		{ //preview card
			if (c->desiredPos[0] != c->pos[0] ||
				c->desiredPos[1] != c->pos[1] ||
				c->desiredPos[2] != c->pos[2])
			{ //unless we're at the desired pos then don't start the spin timer
				c->menuSelectTime = g_Time + SPINNY_CARD_TIME;
			}

			if (c->menuSelectTime < g_Time)
			{
				c->desiredAng[0] = 0.0f;
				if (c->ang[0] == c->desiredAng[0])
				{
					c->ang[0] = 360.0f;
				}

				c->desiredAng[1] = 0.0f;
				if (c->ang[1] == c->desiredAng[1])
				{
					c->ang[1] = 360.0f;
				}
			}
			else
			{
				c->ang[0] = 0.0f;
				c->ang[1] = 180.0f;
				c->desiredAng[0] = 0.0f;
				c->desiredAng[1] = 180.0f;
			}
			Game_CardPosition(CPOS_CARDPRE_S, c->desiredPos);
			Game_LerpCardPos(c, 0.3f);
			Game_LerpCardAngles(c, 1.0f);
			return;
		}
		else if (c->cardIndex >= g_gameState.cardsChosen)
		{ //desired pos is offscreen then
			c->ang[1] = 180.0f;
			Game_CardPosition(CPOS_CARDOFF_1, c->desiredPos);
			Game_LerpCardPos(c, 0.3f);
			Game_LerpCardAngles(c, 3.0f);
			return;
		}
	}

	if (g_gameState.chosenCards && //don't do this while choosing cards
		c->gridSpot == c->gotoGridSpot &&
		c->gridSpot <= CPOS_CARDP2_5)
	{ //this card is still in the player deck and not on the board
		drawCard_t *base;
		drawCard_t *next = NULL;
		int i = 0;
		int closest = -1;
		int lowestGrid;
		int otherMoving = 0;

		if (c->initialPlayer == 2)
		{ //player 2
			base = &g_pl2Cards[0];
			lowestGrid = CPOS_CARDP2_5;
		}
		else
		{ //player 1
			base = &g_pl1Cards[0];
			lowestGrid = CPOS_CARDP1_5;
		}

		//lets go through the cards, and find the one closest below us
		while (i < NUM_CARDS_PER_PLAYER)
		{
			if (base->gridSpot == -1)
			{ //can't move while another card is moving (to avoid cards collapsing on each other)
				next = NULL;
				otherMoving = 1;
				break;
			}

			if (base->gridSpot <= CPOS_CARDP2_5)
			{ //this card is still in the deck
				if (base->gridSpot > c->gridSpot)
				{ //this card is below me
					if (closest == -1 ||
						((base->gridSpot-c->gridSpot) < closest))
					{ //closest card to us we've found so far
						closest = (base->gridSpot-c->gridSpot);
						next = base;
					}
				}
			}

			base++;
			i++;
		}

		if (next &&
			next->gridSpot > c->gridSpot+1)
		{ //the next card in the deck is more than 1 spot away from me, move down to meet it
			c->gotoGridSpot = next->gridSpot-1;
		}
		else if (!next && !otherMoving)
		{ //drop to the lowest spot, no one is below us
			c->gotoGridSpot = lowestGrid;
		}
	}

	if (c->initialPlayer == 2)
	{ //a card belonging to the other player
		if (c->gotoGridSpot > CPOS_CARDP2_5)
		{ //reveal it if it is moved, or if open rule is active
			long dif = c->gridTravelTime;
			
			dif -= g_Time;

			if (dif < 500 ||
				c->gridSpot != -1 ||
				(g_gameRules.open && g_gameState.p2ChosenCards))
			{
				c->desiredAng[1] = 180.0f;
			}
			else
			{
				c->desiredAng[1] = 0.0f;
			}
		}
		else
		{ //otherwise make sure it is hidden (unless open)
			if (g_gameRules.open && g_gameState.p2ChosenCards)
			{
				c->desiredAng[1] = 180.0f;
			}
			else
			{
				c->desiredAng[1] = 0.0f;
			}
		}
	}

	if (c->gridSpot == c->gotoGridSpot &&
		c->gridSpot <= CPOS_CARDP2_5)
	{
		if (c->selected)
		{ //this card is "highlighted", move it out a tad
			Game_CardPosition(c->gridSpot, c->desiredPos);
			if (c->initialPlayer == 2)
			{ //player 2, move to right
				c->desiredPos[0] += 0.4f;
			}
			else
			{ //player 1, move to left
				c->desiredPos[0] -= 0.4f;
			}
		}
		else
		{ //keep it in place
			Game_CardPosition(c->gridSpot, c->desiredPos);
		}
	}

	if (c->takenStep)
	{ //was taken, do the "effects" and declare ownership
		if (c->takenTime < g_Time)
		{
			switch(c->takenStep)
			{
			case 3:
				c->desiredAng[0] = 360.0f;
				c->takenTime = g_Time + 1000;
				break;
			case 2:
				c->altTex = c->takenSide;
				c->predictionTake = g_Time + 500; //don't change based on network input til this timer expires
				assert(c->altTex >= 0);
				c->takenTime = g_Time + 1500;
				c->takenSoundTime = g_Time + 1000;
				c->takenSound = 1;
				Game_CardPosition(c->gridSpot, c->desiredPos);
				break;
			case 1:
				c->desiredAng[0] = 0.0f;
				c->ang[0] = 0.0f;
				break;
			default:
				break;
			}
			c->takenStep--;
		}

		if (c->takenStep == 2)
		{
			Game_CardPosition(c->gridSpot, c->desiredPos);
			c->desiredPos[2] += 5.0f;
		}
	}
	
	if (c->takenSound && c->takenSoundTime < g_Time)
	{
		static int takenSoundBuf = 0;

		if (g_sound_cardWoosh)
		{
			S_PlayRawData(&g_sound_cardWoosh->data.data, g_sound_cardWoosh->data.size, BUFFER2+takenSoundBuf);
		}
		takenSoundBuf++;
		if (takenSoundBuf > 1)
		{
			takenSoundBuf = 0;
		}
		c->takenSound = 0;
	}

	if (c->takenStep)
	{ //slow floating movement
		Game_LerpCardPos(c, 0.05f);
	}
	else
	{
		Game_LerpCardPos(c, 0.3f);
	}
	Game_LerpCardAngles(c, 3.0f);
}

//manage adding the turn arrow if it should be added
void Game_TurnArrow(void)
{
	drawObject_t o;

	if (!g_gameState.arrowDeciding &&
		!g_gameState.waitingTurn)
	{
		return;
	}

	if (g_gameState.arrowDeciding)
	{ //fast rotation
		g_gameState.arrowRot -= (rand()%20)+60.0f;

		if (!g_gameState.arrowDecided)
		{
			static unsigned long arrowSoundTime = 0;

			if (arrowSoundTime < g_Time)
			{
				if (g_sound_menuMove)
				{
					S_PlayRawData(&g_sound_menuMove->data.data, g_sound_menuMove->data.size, BUFFER3);
				}
				arrowSoundTime = g_Time + 10;
			}
		}
	}
	else
	{
		float speedMod = g_lastFrameDif*0.08f;
		g_gameState.arrowRot -= (1.5f * speedMod);
	}

	if (g_gameState.arrowRot < 0.0f)
	{
		g_gameState.arrowRot += 360.0f;
	}

	if (g_gameState.arrowDeciding)
	{
		if (!g_hostPlayer &&
			!g_gameState.arrowDecided)
		{ //keep it going until the host tells us who goes first
			g_gameState.arrowDeciding = g_Time + 2000;
		}

		if (g_gameState.arrowDeciding < g_Time &&
			!g_gameState.arrowDecided)
		{ //time to decide who to pick
			if (g_gameState.arrowRot < 180.0f)
			{
				g_gameState.arrowDecided = 1;
			}
			else
			{
				g_gameState.arrowDecided = 2;
			}
			if (g_socketCreated)
			{
				Net_SendArrowChoice();
			}
		}

		o.ang[0] = 90.0f;
		o.ang[1] = 0.0f;
		if (g_gameState.arrowDecided == 1)
		{ //decided on player 1
			o.ang[2] = 90.0f;
		}
		else if (g_gameState.arrowDecided == 2)
		{ //decided on player 2
			o.ang[2] = 270.0f;
		}
		else
		{ //still deciding
			o.ang[2] = g_gameState.arrowRot;
		}
	}
	else
	{
		o.ang[0] = 30.0f;
		o.ang[1] = g_gameState.arrowRot;
		o.ang[2] = 0.0f;
	}

	if (g_gameState.arrowDeciding &&
		g_gameState.arrowDecided &&
		(g_Time-g_gameState.arrowDeciding) > 1000)
	{ //set whose turn it is, the arrow has spoken.
		g_gameState.waitingTurn = g_gameState.arrowDecided;

		Game_TallyCards();

		if (g_gameState.waitingTurn == 1)
		{
			Game_SetupLocalPlayerTurn();
		}
		g_gameState.arrowDecided = 0;
		g_gameState.arrowDeciding = 0;
	}

	if (g_gameState.arrowDeciding)
	{ //middle
		o.pos[0] = 0.0f;
		o.pos[1] = 0.0f;
		o.pos[2] = -10.0f;
	}
	else if (g_gameState.waitingTurn == 1)
	{ //player 1 turn
		o.pos[0] = 6.7f;
		o.pos[1] = 6.0f;
		o.pos[2] = -15.0f;
	}
	else
	{ //player 2 turn
		o.pos[0] = -6.7f;
		o.pos[1] = 6.0f;
		o.pos[2] = -15.0f;
	}
	o.img = -1;

	o.noDepth = 0;

	GL_AddDrawObject(&o);
}

//get the next card owned by the player that's still in this deck list
drawCard_t *Game_NextCardStillInDeck(int curIndex, drawCard_t *cards)
{
	int next = curIndex;
	int i = 0;

	while (i < NUM_CARDS_PER_PLAYER)
	{
		next++;
		if (next >= NUM_CARDS_PER_PLAYER)
		{ //loop back around
			next = 0;
		}

		if (cards[next].gotoGridSpot <= CPOS_CARDP2_5)
		{ //still in one of the deck spots
			return &cards[next];
		}

		i++;
	}

	return NULL;
}


//position vulnerability evaluation
void Game_P2AI_EvaluateVulnerability(drawCard_t *card, int gridSpot)
{
	drawCard_t *n;
	int dir = CARD_RIGHT;
	int cardDirValue = 0;
	
	while (dir <= CARD_DOWN)
	{
		n = Game_NeighboringCard(gridSpot, dir, -1);

		if (!n && !Game_NeighboringWall(gridSpot, dir))
		{ //no other card here, and it's not the wall, we are exposed.
			switch (dir)
			{
			case CARD_RIGHT:
				cardDirValue = card->pCard->right;
				break;
			case CARD_LEFT:
				cardDirValue = card->pCard->left;
				break;
			case CARD_UP:
				cardDirValue = card->pCard->up;
				break;
			case CARD_DOWN:
				cardDirValue = card->pCard->down;
				break;
			default:
				cardDirValue = 10;
				break;
			}

			//the higher it is, the less risk we are taking by exposing it.
			g_gameState.ai_taken -= (10-cardDirValue);			
		}

		dir++;
	}
}

//evaluate the best place we could put this card and set the weight based on how
//good it would be to do.
void Game_P2AI_EvaluateCard(drawCard_t *card, int *place, int *weight)
{
	int gridSpot = CPOS_CARDX_1;
	int idealPlace = -1;
	int idealWeight = 0;
	//set simulation to 1 so we don't actually perform card takes,
	//and reset the ai taken amount.
	while (gridSpot <= CPOS_CARDX_9)
	{ //go through all the grid spots and check them
		if (!Game_CardOccupied(gridSpot))
		{ //no one is occupying this spot, let's evaluate it.
			g_gameState.ai_simulation = 1;
			g_gameState.ai_taken = 0;
			Game_CheckTakes(card, gridSpot, 0);

			//subtract from ai_taken based on how vulnerable this card will be
			//when placed in this spot
			Game_P2AI_EvaluateVulnerability(card, gridSpot);

			if (idealPlace == -1 ||
				(g_gameState.ai_taken > idealWeight))
			{ //this is the best we've got so far for this card
				idealPlace = gridSpot;
				idealWeight = g_gameState.ai_taken;
			}

			//we are done simulating.. for now
			g_gameState.ai_simulation = 0;
		}
		gridSpot++;
	}

	//our final ideals
	*place = idealPlace;
	*weight = idealWeight;
}

//find what we think is the best card and the best place to put it.
void Game_P2AI_SelectCard(void)
{
	//evaluate the possibilities for each card in the deck
	drawCard_t *firstCard = Game_NextCardStillInDeck(4, g_pl2Cards);
	drawCard_t *idealCard = NULL;
	drawCard_t *curCard;
	int place, weight;
	int idealPlace = -1, idealWeight;

	if (!firstCard)
	{ //no cards in deck!
		return;
	}

	curCard = Game_NextCardStillInDeck(firstCard->cardIndex, g_pl2Cards);

	if (!curCard || curCard == firstCard)
	{ //we have only this choice.
		idealCard = firstCard;
		Game_P2AI_EvaluateCard(idealCard, &idealPlace, &idealWeight);
	}
	else
	{
		while (curCard)
		{
			Game_P2AI_EvaluateCard(curCard, &place, &weight);
			if (idealPlace == -1 ||
				(weight > idealWeight))
			{ //this is the best choice so far
				idealCard = curCard;
				idealPlace = place;
				idealWeight = weight;
			}

			if (curCard == firstCard)
			{ //we looped around and checked them all, break out
				break;
			}
			curCard = Game_NextCardStillInDeck(curCard->cardIndex, g_pl2Cards);
		}
	}

	if (idealCard && idealPlace != -1)
	{
		g_gameState.ai_bestCard = idealCard;
		g_gameState.ai_gridSpace = idealPlace;
	}
}

//computer "AI" for player 2
void Game_P2AI(void)
{
	drawCard_t *base = &g_pl2Cards[0];
	drawCard_t *next = NULL;
	int i = 0;

	if (g_gameState.ai_nextDecisionTime > g_Time)
	{ //still making choices
		return;
	}

	g_gameState.ai_nextDecisionTime = g_Time + rand()%3000 + 500;

	if (!g_gameState.ai_bestCard)
	{ //don't have a selected card
		Game_P2AI_SelectCard();
		g_gameState.ai_selected = Game_NextCardStillInDeck(4, g_pl2Cards);
		g_gameState.ai_selected->selected = 1;
	}
	else
	{ //place the card
		if (g_gameState.ai_selected != g_gameState.ai_bestCard)
		{ //go to the card first
			drawCard_t *current;

			if (g_gameState.ai_selected)
			{
				g_gameState.ai_selected->selected = 0;
				current = g_gameState.ai_selected;
			}
			else
			{
				current = Game_NextCardStillInDeck(4, g_pl2Cards);
			}

			if (current)
			{
				drawCard_t *next = Game_NextCardStillInDeck(current->cardIndex, g_pl2Cards);

				if (next)
				{
					next->selected = 1;
					g_gameState.ai_selected = next;
				}
			}
		}
		else
		{
			if (g_sound_cardWoosh)
			{
				S_PlayRawData(&g_sound_cardWoosh->data.data, g_sound_cardWoosh->data.size, BUFFER2);
			}
			g_gameState.ai_selected->selected = 0;
			g_gameState.ai_selected->gridTravelTime = g_Time + 1000;
			g_gameState.ai_selected->gotoGridSpot = g_gameState.ai_gridSpace;
			g_gameState.ai_selected = NULL;
			g_gameState.ai_bestCard = NULL;

			g_gameState.waitingTurn = 0;
		}
	}
}

//make sure all cards are settled into their desired positions and things
//before starting the next turn
int Game_CardsSettled(void)
{
	int i = 0;
	drawCard_t *c;

	while (i < NUM_CARDS_PER_PLAYER*2)
	{
		if (i < NUM_CARDS_PER_PLAYER)
		{ //player 2
			c = &g_pl1Cards[i];
		}
		else
		{ //player 2
			c = &g_pl2Cards[i-NUM_CARDS_PER_PLAYER];
		}

		if (c->gridSpot != c->gotoGridSpot ||
			/*c->desiredAng[0] != c->ang[0] ||
			c->desiredAng[1] != c->ang[1] ||
			c->desiredAng[2] != c->ang[2] ||
			c->desiredPos[0] != c->pos[0] ||
			c->desiredPos[1] != c->pos[1] ||
			c->desiredPos[2] != c->pos[2] ||*/
			c->takenStep) //for now, at least, I only care about these two
		{ //not where we want to be, or being "taken"
			return 0;
		}

		i++;
	}

	//all the cards are happy
	return 1;
}

//see if all grid spaces are filled
int Game_AllDone(void)
{
	int i = CPOS_CARDX_1;

	while (i <= CPOS_CARDX_9)
	{
		if (!Game_CardOccupied(i))
		{ //a grid space not occupied, the game is not over yet
			return 0;
		}
		i++;
	}

	//it's over..
	if (g_gameState.p1Total == g_gameState.p2Total)
	{ //draw
		return -1;
	}
	else if (g_gameState.p1Total > g_gameState.p2Total)
	{ //player 1 won
		return 1;
	}
	else
	{ //player 2 won
		return 2;
	}
}

//main game frame
void Game_Logic(void)
{
	int i = 0;
	drawCard_t *c;

	/*
	g_Time = GetTickCount();
	if (g_lastTime > g_Time)
	{ //OS fault, I guess.
		g_finishLoop = 1;
	}
	g_lastTime = g_Time;
	*/
	g_lastTime = g_Time;
	g_Time = GetTickCount();

	if (g_lastTime > g_Time)
	{ //OS fault, I guess.
		//lets just exit cause i don't even wanna think about all the timer crap this would break.
		g_finishLoop = 1;
	}

	g_lastFrameDif = (g_Time-g_lastTime);
	if (g_lastFrameDif < 0)
	{
		g_lastFrameDif = 100;
	}
	else if (g_lastFrameDif > 1500)
	{
		g_lastFrameDif = 1500;
	}


	//check input
	Game_Input();

	if (g_socketCreated &&
		g_sendTime < g_Time)
	{ //general info update to assure sync
		Net_SyncSend();
		g_sendTime = g_Time + NET_SYNC_DURATION;
	}

	if (g_listenSocketCreated)
	{
		Game_Print("Waiting for connection.");
		return;
	}

	if (g_socketCreated &&
		g_gameState.chosenCards &&
		!g_gameState.p2ChosenCards)
	{
		Game_Print("Waiting for remote player.");
	}

	/*
	if (g_keysPressed['C'] && !g_keysDebounce['C'])
	{
		g_keysDebounce['C'] = 1;
		Net_Connect(g_userInfo.connPort, g_userInfo.connIP);
	}

	if (g_keysPressed['L'] && !g_keysDebounce['L'])
	{
		g_keysDebounce['L'] = 1;
		Net_Listen(g_userInfo.connPort);
	}

	if (g_keysPressed['D'] && !g_keysDebounce['D'])
	{
		g_keysDebounce['D'] = 1;
		Net_Disconnect();
	}
	*/

	if (!g_gameRules.set)
	{
		if (!g_hostPlayer)
		{ //do nothing while awaiting rules
			g_ruleMenu.active = 0;
			Game_Print("Connecting...");
			return;
		}
		g_ruleMenu.active = 1;
		return;
	}

	if (g_gameState.gameDone)
	{
		if (g_gameState.gameDone == 1)
		{ //p1 won
			if (g_gameState.p1Total == 9)
			{ //perfect
				drawObject_t o;

				o.ang[0] = 0.0f;
				o.ang[1] = 180.0f;
				o.ang[2] = 0.0f;
				o.hRadius = 1.0f;
				o.wRadius = 4.0f;
				o.pos[0] = 1.5f;
				o.pos[1] = g_gameState.perfectVert;
				o.pos[2] = -13.0f;
				o.img = g_texStorage.perfectTex;
				o.imgBack = -1;
				o.noDepth = 0;
				o.srcBlend = -1;
				o.dstBlend = -1;
				o.alphaTest = GL_GREATER;

				if (g_gameState.perfectVert < 0.0f)
				{
					g_gameState.perfectVert += 0.5f;
				}

				GL_AddDrawObject(&o);
			}
			else
			{ //just a victory
				Game_CoordPrint(640.0f/2.0f-110.0f, 480.0f/2.0f, "You Win!");
			}
		}
		else if (g_gameState.gameDone == 2)
		{ //p2 won
			Game_CoordPrint(640.0f/2.0f-130.0f, 480.0f/2.0f, "You Lose!");
		}
		else
		{ //draw
			Game_CoordPrint(640.0f/2.0f-60.0f, 480.0f/2.0f, "Draw");
		}

		if (g_keysPressed[VK_RETURN] && !g_keysDebounce[VK_RETURN])
		{ //restart
			g_keysDebounce[VK_RETURN] = 1;
			Game_Init();
			if (g_socketCreated)
			{
				Net_SendReinit();
			}
		}
	}

	if (g_gameRules.elemental)
	{ //add the elemental icons
		int k = 0;
		drawObject_t o;
		float gridPos[3];

		o.ang[0] = 0.0f;
		o.ang[1] = 180.0f;
		o.ang[2] = 0.0f;
		o.hRadius = 0.8f;
		o.wRadius = 0.8f;
		o.imgBack = -1;
		o.srcBlend = GL_SRC_ALPHA;
		o.dstBlend = GL_DST_ALPHA;
		o.alphaTest = GL_GREATER;
		o.noDepth = 1;

		while (k < 9)
		{
			if (g_gameState.elementalGrid[k])
			{
				Game_CardPosition(CPOS_CARDX_1+k, gridPos);

				o.img = g_texStorage.cardElemTextures[g_gameState.elementalGrid[k]];
				o.pos[0] = gridPos[0];
				o.pos[1] = gridPos[1]-0.2f;
				o.pos[2] = gridPos[2]-1.5f;

				GL_AddDrawObject(&o);
			}
			k++;
		}
	}

	//add cards for each player
	while (i < NUM_CARDS_PER_PLAYER*2)
	{
		if (i < NUM_CARDS_PER_PLAYER)
		{ //player 1
			c = &g_pl1Cards[i];
		}
		else
		{ //player 2
			c = &g_pl2Cards[i-NUM_CARDS_PER_PLAYER];
		}

		Game_CardThink(c);
		GL_AddDrawCard(c);
		i++;
	}

	if (!g_gameState.chosenCards)
	{ //add the preview card
		Game_CardThink(&g_previewCard);
		GL_AddDrawCard(&g_previewCard);
	}

	if (g_gameState.chosenCards &&
		g_gameState.p2ChosenCards)
	{ //draw the card total for each player
		drawObject_t o;

		//player 1
		o.ang[0] = 0.0f;
		o.ang[1] = 180.0f;
		o.ang[2] = 0.0f;
		o.hRadius = 0.6f;
		o.wRadius = 0.6f;
		o.pos[0] = 6.3f;
		o.pos[1] = -5.3f;
		o.pos[2] = -14.0f;
		o.img = g_texStorage.cardNumTextures[g_gameState.p1Total];
		o.imgBack = -1;
		o.noDepth = 0;
		o.srcBlend = -1;
		o.dstBlend = -1;
		o.alphaTest = GL_GREATER;

		GL_AddDrawObject(&o);

		//player 2
		o.pos[0] = -5.9f;
		o.img = g_texStorage.cardNumTextures[g_gameState.drawP2Total];
		GL_AddDrawObject(&o);
	}

	//manage the turn arrow
	Game_TurnArrow();

	if (g_gameState.waitingTurn)
	{
		if (g_gameState.waitingTurn == 1)
		{ //local player
			drawCard_t *selected = &g_pl1Cards[g_gameState.p1Turn_Selection];
			drawObject_t o;

			//add the pointer as a "3D" object next to the selected card
			o.ang[0] = 0.0f;
			o.ang[1] = 180.0f;
			o.ang[2] = 0.0f;
			o.hRadius = 0.8f;
			o.wRadius = 0.8f;
			o.pos[0] = selected->pos[0]-2.5f;
			o.pos[1] = selected->pos[1]+0.1f;
			o.pos[2] = selected->pos[2]+0.5f;
			o.img = g_texStorage.misterPointy;
			o.imgBack = -1;
			o.noDepth = 0;

			if (g_gameState.p1Turn_OnBoard)
			{ //make the deck pointer transparent when selecting the board position
				o.srcBlend = GL_DST_COLOR;
				o.dstBlend = GL_DST_COLOR;
			}
			else
			{
				o.srcBlend = -1;
				o.dstBlend = -1;
			}
			o.alphaTest = GL_GREATER;

			GL_AddDrawObject(&o);

			if (g_gameState.p1Turn_OnBoard)
			{ //draw a non-transparent pointer on the board where our prospective place is
				o.srcBlend = -1;
				o.dstBlend = -1;

				Game_CardPosition(g_gameState.p1Turn_OnBoard_Grid, o.pos);
				o.pos[0] -= 0.8f;
				o.pos[1] += 0.1f;
				o.pos[2] += 0.5f;

				GL_AddDrawObject(&o);
			}
		}
		else
		{ //remote player/computer
			if (g_gameState.pl2Computer)
			{
				Game_P2AI();
			}
		}
	}

	if (g_gameState.setWaiting)
	{
		g_gameState.scorePredictionSet = g_Time + 500;
	}

	if (g_gameState.setWaiting &&
		g_gameState.setWaitingTime < g_Time &&
		Game_CardsSettled())
	{ //set the turn
		Game_TallyCards();
		g_gameState.gameDone = Game_AllDone();

		if (!g_gameState.gameDone)
		{
			g_gameState.waitingTurn = g_gameState.setWaiting;
			g_gameState.setWaiting = 0;

			if (g_gameState.waitingTurn == 1)
			{
				Game_SetupLocalPlayerTurn();
			}
		}
		else if (g_gameState.gameDone == -1 &&
			g_gameRules.suddenDeath)
		{ //if it's a draw then see if we can invoke sudden death
			playingCard_t *plCards[NUM_CARDS_PER_PLAYER*2];
			drawCard_t *c;
			int j = 0;
			int p1Cards = 0;
			int p2Cards = 5;
			int setCards = 0;
			g_gameState.gameDone = 0;

			memset(&plCards, 0, sizeof(plCards));

			//rearrange all the cards and proclaim actual ownership by player
			while (setCards < 2)
			{
				if (j < NUM_CARDS_PER_PLAYER)
				{ //player 1
					c = &g_pl1Cards[j];
				}
				else
				{ //player 2
					c = &g_pl2Cards[j-NUM_CARDS_PER_PLAYER];
				}

				if (setCards == 0)
				{
					if (!c->altTex)
					{ //belongs to player 1 as of currently
						plCards[p1Cards] = c->pCard;
						p1Cards++;
					}
					else
					{
						plCards[p2Cards] = c->pCard;
						p2Cards++;
					}
				}
				else if (setCards == 1)
				{
					c->pCard = plCards[j];
					if (c->initialPlayer == 1)
					{
						c->altTex = 0;
					}
					else
					{
						c->altTex = 1;
					}
					Game_CardPosition(j, c->desiredPos);
					c->gotoGridSpot = j;
				}
				else
				{
					break;
				}

				j++;
				if (j >= NUM_CARDS_PER_PLAYER*2)
				{
					setCards++;
					j = 0;
				}
			}

			g_gameState.waitingTurn = g_gameState.setWaiting;
			g_gameState.setWaiting = 0;

			if (g_gameState.waitingTurn == 1)
			{
				Game_SetupLocalPlayerTurn();
			}

			Game_CoordPrint(640.0f/2.0f-190.0f, 480.0f/2.0f, "Sudden Death!");
		}
	}
}

//game print function
void Game_Print (const char *string, ...)
{
	char finalString[MAX_PRINT_CHARS];
	va_list args;
	
	va_start(args, string);
	vsprintf(finalString, string, args);
	va_end(args);

	strcpy(g_CGS.pStr, finalString);
	g_CGS.pStrTime = GetTickCount() + 4000;

}

//game center print function
void Game_CoordPrint (float x, float y, const char *string, ...)
{
	char finalString[MAX_PRINT_CHARS];
	va_list args;
	
	va_start(args, string);
	vsprintf(finalString, string, args);
	va_end(args);

	strcpy(g_CGS.pCStr, finalString);
	g_CGS.pCStrTime = g_Time + 4000;
	g_CGS.pCX = x;
	g_CGS.pCY = y;
}
