#include "main.h"

#define _USE_DSOUND

#ifndef _USE_DSOUND
static int S_GetWaveDataFromFile(const char *fileName, waveFile_t **wave)
{
	return 0;
}

void S_PlaySoundFromFile(const char *fileName, int bufferNum)
{
}

waveFile_t *S_GetWaveData(const char *fileName)
{
	return NULL;
}

int S_Init()
{
	return 0;
}

void S_PlayRawData(BYTE *wave, unsigned long size, int bufferNum)
{
}

#else

//FIXME this implementation is all completely terrible.
//port sound system from rcube.

//#include <mmsystem.h>

#include <dsound.h>

void S_PlayRawData(BYTE *wave, unsigned long size, int bufferNum);

//#define FX_TEST

static LPDIRECTSOUND8 g_dsound;
static DSBUFFERDESC g_dsBufferDesc;
static LPDIRECTSOUNDBUFFER g_dsBuffer;
static WAVEFORMATEX g_waveFormat;
static int g_initStatus = 0;


static LPDIRECTSOUNDBUFFER g_secondaryBuffers[NUM_SECONDARY_BUFFERS];

//mainly for debugging, get a string error for the specific error given.
static char *S_ErrForNum(HRESULT err)
{
#if 0
	switch (err)
	{
	//Errors only applicable, apparently, to versions of dsound later than 5?
	case DS_NO_VIRTUALIZATION:
		return "The buffer was created, but another 3-D algorithm was substituted.";
	case DS_INCOMPLETE:
		return "The method succeeded, but not all the optional effects were obtained.";
	case DSERR_ACCESSDENIED:
		return "The request failed because access was denied.";
	case DSERR_BADSENDBUFFERGUID:
		return "The GUID specified in an audiopath file does not match a valid mix-in buffer.";
	case DSERR_BUFFERTOOSMALL:
		return "The buffer size is not great enough to enable effects processing.";
	case DSERR_FXUNAVAILABLE:
		return "The effects requested could not be found on the system, or they are in the wrong order or in the wrong location; for example, an effect expected in hardware was found in software.";
	case DSERR_OBJECTNOTFOUND:
		return "The requested object was not found.";
	case DSERR_SENDLOOP:
		return "A circular loop of send effects was detected.";

	case DSERR_ALLOCATED:
		return "The request failed because resources, such as a priority level, were already in use by another caller.";
	case DSERR_ALREADYINITIALIZED:
		return "The object is already initialized.";
	case DSERR_BADFORMAT:
		return "The specified wave format is not supported.";
	case DSERR_BUFFERLOST:
		return "The buffer memory has been lost and must be restored.";
	case DSERR_CONTROLUNAVAIL:
		return "The buffer control (volume, pan, and so on) requested by the caller is not available. Controls must be specified when the buffer is created, using the dwFlags member of DSBUFFERDESC.";
	case DSERR_GENERIC:
		return "An undetermined error occurred inside the DirectSound subsystem.";
	case DSERR_INVALIDCALL:
		return "This function is not valid for the current state of this object.";
	case DSERR_INVALIDPARAM:
		return "An invalid parameter was passed to the returning function.";
	case DSERR_NOAGGREGATION:
		return "The object does not support aggregation.";
	case DSERR_NODRIVER:
		return "No sound driver is available for use, or the given GUID is not a valid DirectSound device ID.";
	case DSERR_NOINTERFACE:
		return "The requested COM interface is not available.";
	case DSERR_OTHERAPPHASPRIO:
		return "Another application has a higher priority level, preventing this call from succeeding.";
	case DSERR_OUTOFMEMORY:
		return "The DirectSound subsystem could not allocate sufficient memory to complete the caller's request.";
	case DSERR_PRIOLEVELNEEDED:
		return "A cooperative level of DSSCL_PRIORITY or higher is required.";
	case DSERR_UNINITIALIZED:
		return "The Initialize method has not been called or has not been called successfully before other methods were called.";
	case DSERR_UNSUPPORTED:
		return "The function called is not supported at this time.";
	}

	//hmm...
	return "Sorry, pal, no idea.";
#else
	return "U";
#endif
}

//get raw waveform data from a file
static int S_GetWaveDataFromFile(const char *fileName, waveFile_t **wave)
{
	unsigned long readLen;
	int fileHandle = _open(fileName, _O_RDONLY|_O_BINARY, _S_IREAD);
	BYTE *fileBuffer;
	waveFile_t *w;

	if (fileHandle == -1)
	{
		Window_Print("Open for %s failed\n", fileName);
		return 0;
	}

	//get the length of the file, stuff the whole thing into a buffer
	readLen = _filelength(fileHandle);
	fileBuffer = (BYTE *)malloc(readLen);
	_read(fileHandle, fileBuffer, readLen);

	//no longer need the file around
	_close(fileHandle);

	w = (waveFile_t *)fileBuffer;

	if (fileBuffer[0] != 'R' ||
		fileBuffer[1] != 'I' ||
		fileBuffer[2] != 'F' ||
		fileBuffer[3] != 'F' ||
		w->data.size > readLen)
	{ //some really loose checking
		Window_Print("%s does not appear to be a valid wave file.\n", fileName);
		free(fileBuffer);
		return 0;
	}

	*wave = w;
	return 1;
}

//get waveform data from a file and try to play it on said buffer.
void S_PlaySoundFromFile(const char *fileName, int bufferNum)
{
	waveFile_t *wave;

	if (!g_initStatus)
	{
		Window_Print("S_PlaySoundFromFile call without initializing sound system.\n");
		return;
	}

	if (!S_GetWaveDataFromFile(fileName, &wave))
	{
		return;
	}


#ifdef FX_TEST
	LPDIRECTSOUNDBUFFER8 newDXObject;

	g_secondaryBuffers[bufferNum]->QueryInterface(IID_IDirectSoundBuffer8, (void **)&newDXObject);

	DSEFFECTDESC fx;
	DWORD fxR;
	fx.dwSize = sizeof(fx);
	fx.dwFlags = 0;
	fx.guidDSFXClass = GUID_DSFX_STANDARD_DISTORTION;
	fx.dwReserved1 = 0;
	fx.dwReserved2 = 0;
	HRESULT r = newDXObject->SetFX(1, &fx, &fxR);
	if (SUCCEEDED(r))
	{
		LPDIRECTSOUNDFXDISTORTION8 distor;
		newDXObject->GetObjectInPath(GUID_All_Objects, 0, IID_IDirectSoundFXDistortion8, (void **)&distor);

		DSFXDistortion shizzle;
		shizzle.fGain = -18.0f;
		shizzle.fEdge = 15.0f;
		shizzle.fPostEQCenterFrequency = 2400.0f;
		shizzle.fPostEQBandwidth = 2400.0f;
		shizzle.fPreLowpassCutoff = 8000.0f;
		distor->SetAllParameters(&shizzle);
	}
	else
	{
		S_ErrForNum(r);
	}
#endif

	S_PlayRawData(&wave->data.data, wave->data.size, bufferNum);
	free(wave);
}

//get wave data
waveFile_t *S_GetWaveData(const char *fileName)
{
	waveFile_t *wave = NULL;

	if (!S_GetWaveDataFromFile(fileName, &wave))
	{
		return NULL;
	}

	return wave;
}

//initialize directsound
int S_Init()
{
	HRESULT r;
	DSBUFFERDESC secBufferDesc;
	int i = 0;

	//pass in a pointer to a pointer of our dsound object.
	r = DirectSoundCreate(0, &g_dsound, 0);
	if (!SUCCEEDED(r))
	{
		Window_Print("DirectSound failed to initialize.\n(creating, err result %s)\n", S_ErrForNum(r));
		return 0;
	}

	//fill in our wave format spec for the buffer we are about to create.
	memset(&g_waveFormat, 0, sizeof(g_waveFormat));
	g_waveFormat.cbSize = 0;
	g_waveFormat.wFormatTag = WAVE_FORMAT_PCM; //standard pcm wave data
	g_waveFormat.nChannels = 2; //stereo
	g_waveFormat.wBitsPerSample = 16; //16 bits
	g_waveFormat.nSamplesPerSec = 44100; //44.1kHz
	g_waveFormat.nBlockAlign = g_waveFormat.nChannels*(g_waveFormat.wBitsPerSample/8); //hmm, don't ask me, this is what MSDN says it should be.
	g_waveFormat.nAvgBytesPerSec = (g_waveFormat.nSamplesPerSec*g_waveFormat.nBlockAlign); //ditto

	//fill in buffer description object to create our primary sound buffer.
	memset(&g_dsBufferDesc, 0, sizeof(g_dsBufferDesc));
	g_dsBufferDesc.dwSize = sizeof(g_dsBufferDesc);

	g_dsBufferDesc.dwFlags = 0;//(DSBCAPS_PRIMARYBUFFER);
	g_dsBufferDesc.lpwfxFormat = &g_waveFormat; //we will set this after we create the buffer. apparently this is only for non-primary buffers.

	//g_dsBufferDesc.guid3DAlgorithm = DS3DALG_DEFAULT;

	//set cooperative level to priority
	/*
	r = g_dsound->SetCooperativeLevel(wnd, DSSCL_PRIORITY);
	if (!SUCCEEDED(r))
	{
		Window_Print("DirectSound failed to set coop level. (err result %s)\n", S_ErrForNum(r));
		return 0;
	}
	*/

	//now try creating the buffer
	r = g_dsound->CreateSoundBuffer(&g_dsBufferDesc, &g_dsBuffer, 0);
	if (!SUCCEEDED(r))
	{
		Window_Print("DirectSound failed to create\na sound buffer. (err result %s)\n", S_ErrForNum(r));
		return 0;
	}

	//set the buffer wave format
	r = g_dsBuffer->SetFormat(&g_waveFormat);
	if (!SUCCEEDED(r))
	{
		Window_Print("DirectSound failed to set wave format. (err result %s)\n", S_ErrForNum(r));
		return 0;
	}

	//set up the secondary sound buffer description.
	secBufferDesc = g_dsBufferDesc;
#ifdef FX_TEST
	secBufferDesc.dwFlags = (DSBCAPS_CTRLVOLUME|DSBCAPS_CTRLPAN|DSBCAPS_CTRLFREQUENCY|DSBCAPS_CTRLFX);
#else
	secBufferDesc.dwFlags = (DSBCAPS_CTRLVOLUME|DSBCAPS_CTRLFREQUENCY);
#endif
	secBufferDesc.lpwfxFormat = &g_waveFormat;
	secBufferDesc.dwBufferBytes = 2097152;//DSBSIZE_MAX;

	while (i < NUM_SECONDARY_BUFFERS)
	{ //now create all of our secondary buffers
		if (i == 0)
		{ //the first secondary buffer..
			r = g_dsound->CreateSoundBuffer(&secBufferDesc, &g_secondaryBuffers[i], 0);
		}
		else
		{ //then duplicate the others off of the first secondary buffer.
			//r = g_dsound->DuplicateSoundBuffer(g_secondaryBuffers[0], &g_secondaryBuffers[i]);
			r = g_dsound->CreateSoundBuffer(&secBufferDesc, &g_secondaryBuffers[i], 0);
		}
		if (!SUCCEEDED(r))
		{
			if (i == 0)
			{ //never fail on first secondary buffer
				Window_Print("DirectSound failed to create\nsecondary sound buffer. (err result %s)\n", S_ErrForNum(r));
				return 0;
			}
			else
			{ //oh well, we get what we get...
				break;
			}
		}

		i++;
	}

	g_initStatus = i;
	return 1;
}

//play some waveform data in one of the buffers
void S_PlayRawData(BYTE *wave, unsigned long size, int bufferNum)
{
	if (!wave)
	{
		return;
	}

#if 0 //making use of circular buffers.. sadly, this cannot work for normal sounds, because there is no functionality in "play"
	//to play for only x bytes in the buffer.
	void *writeBuffer1;
	void *writeBuffer2;
	unsigned long writeBytes1;
	unsigned long writeBytes2;
	LPDIRECTSOUNDBUFFER buf;

	if (bufferNum > g_initStatus)
	{ //we didn't get that many buffers! Oh well, cap it.
		bufferNum = g_initStatus;
	}
		
	buf = g_secondaryBuffers[bufferNum];

	if (!g_initStatus)
	{
		Window_Print("S_PlayRawData call without initializing sound system.\n");
		return;
	}

	//lock the buffer
	buf->Lock(0, size, &writeBuffer1, &writeBytes1, &writeBuffer2, &writeBytes2, DSBLOCK_FROMWRITECURSOR);

	//write to it
	memcpy(writeBuffer1, wave, writeBytes1);
	//did we get it all?
	if (size > writeBytes1)
	{ //apparently not, write the other half to the second part of the buffer (it must have looped around)
		memcpy(writeBuffer2, wave+writeBytes1, writeBytes2);
	}

	//unlock it
	buf->Unlock(writeBuffer1, writeBytes1, writeBuffer2, writeBytes2);

	//play
	buf->Play(0, 0, DSBPLAY_LOOPING);
#else
	void *writeBuffer1;
	unsigned long writeBytes1;
	LPDIRECTSOUNDBUFFER buf;

	if (bufferNum > g_initStatus)
	{ //we didn't get that many buffers! Oh well, cap it.
		bufferNum = g_initStatus;
	}
		
	buf = g_secondaryBuffers[bufferNum];

	if (!g_initStatus)
	{
		Window_Print("S_PlayRawData call without initializing sound system.\n");
		return;
	}

	//lock the buffer
	buf->Lock(0, 0, &writeBuffer1, &writeBytes1, NULL, NULL, DSBLOCK_ENTIREBUFFER);

	//write to it
	memset(writeBuffer1, 0, writeBytes1);
	memcpy(writeBuffer1, wave, size);

	//unlock it
	buf->Unlock(writeBuffer1, size, NULL, 0);

	//play
	buf->SetCurrentPosition(0);
	buf->Play(0, 0, 0);
#endif
}

#endif //_USE_DSOUND
