#include "main.h"

static unsigned int g_table[256];

//reflect
static inline unsigned long CRC_Reflect(unsigned long ref, char ch)
{
	unsigned long value = 0;
	for (int i = 1; i < (ch + 1); i++)
	{
		if (ref & 1)
		{
			value |= 1 << (ch - i);
		}
		ref >>= 1;
	}
	return value;
}

//create crc table
void CRC_CreateTable(void)
{
	unsigned long ulPolynomial = 0x04C11DB7;

	for (int i = 0; i <= 0xFF; i++)
	{
		g_table[i] = CRC_Reflect(i, 8) << 24;
		for (int j = 0; j < 8; j++)
		{
			g_table[i] = (g_table[i] << 1) ^ (g_table[i] & (1 << 31) ? ulPolynomial : 0);
		}
		g_table[i] = CRC_Reflect(g_table[i],  32);
	}
}

//calculate checksum
unsigned int CRC_CalcChecksum(BYTE *buffer, int size)
{
	unsigned int crc = 0xFFFFFFFF;

	while (size > 0)
	{
		crc = (crc >> 8) ^ g_table[(crc & 0xFF) ^ *buffer++];
		size--;
	}

	return crc ^ 0xFFFFFFFF;
}
