#include "main.h"

#define CARD_OFFSETS		17

//offsets for all tim files in the main file
#if 1
static int g_timDataOffsets[] =
{
	247664640,			//00
	247629824,			//01
	247595008,			//02
	247789568,			//03
	247988224,			//04
	248057856,			//05
	247422976,			//06
	249452544,			//07
	246857728,			//08
	249569280,			//09
	247887872,			//10
	247922688,			//11
	250148864,			//12
	249673728,			//13
	200345600,			//14
	200974292,			//15
	65536,				//16
	247957504,			//17

	//card offsets here
	199413760,			//1
	199464960,			//2
	199516160,			//3
	199567360,			//4
	199618560,			//5
	199669760,			//6
	199720960,			//7
	199772160,			//8
	199823360,			//9
	199874560,			//10
	-1
};
#else //for making sure the crc junk works
static int g_timDataOffsets[] =
{
	1,//247664640,			//00
	1,//247629824,			//01
	1,//247595008,			//02
	1,//247789568,			//03
	1,//247988224,			//04
	1,//248057856,			//05
	1,//247422976,			//06
	1,//249452544,			//07
	1,//246857728,			//08
	1,//249569280,			//09
	1,//247887872,			//10
	1,//247922688,			//11
	1,//250148864,			//12
	1,//249673728,			//13
	1,//200345600,			//14
	1,//200974292,			//15
	1,//65536,				//16
	1,//247957504,			//17

	//card offsets here
	1,//199413760,			//1
	1,//199464960,			//2
	1,//199516160,			//3
	1,//199567360,			//4
	1,//199618560,			//5
	1,//199669760,			//6
	1,//199720960,			//7
	1,//199772160,			//8
	1,//199823360,			//9
	1,//199874560,			//10
	-1
};
#endif

static int g_ntscTimDataOffsets[] =
{
	247664640,			//00
	247629824,			//01
	247595008,			//02
	247789568,			//03
	247988224,			//04
	248057856,			//05
	247422976,			//06
	249452544,			//07
	246857728,			//08
	249569280,			//09
	247887872,			//10
	247922688,			//11
	250148864,			//12
	249673728,			//13
	200345600,			//14
	200974292,			//15
	65536,				//16
	247957504,			//17

	//card offsets here
	199413760,			//1
	199464960,			//2
	199516160,			//3
	199567360,			//4
	199618560,			//5
	199669760,			//6
	199720960,			//7
	199772160,			//8
	199823360,			//9
	199874560,			//10
	-1
};

static const unsigned int g_timDataCRCs[] =
{
	0x5539c3ec,			//00
	0x45d8f27e,			//01
	0x8e7eb9bc,			//02
	0xd6462833,			//03
	0x5a4123d7,			//04
	0x722009da,			//05
	0xd6e5142a,			//06
	0xb91b0650,			//07
	0xf1bc8f97,			//08
	0x3d133d62,			//09
	0x4341acb2,			//10
	0x69ec9284,			//11
	0xfdd44fb8,			//12
	0xf6f78307,			//13
	0xaf56b395,			//14
	0x614a5cc8,			//15
	0xf045feb8,			//16
	0x477c1dec,			//17

	//card crc's here
	0x28aad9bc,			//1
	0xa8352351,			//2
	0xb38aa081,			//3
	0x20411431,			//4
	0x5dade261,			//5
	0x94700f38,			//6
	0x0383383b,			//7
	0x3e51d30b,			//8
	0xa9cadf8a,			//9
	0x5603ef42			//10
};

//get the crc given the matching intended offset
const unsigned int GetCRCForOffset(int byteOffset)
{
	int i = 0;
	while (g_ntscTimDataOffsets[i] != -1)
	{
		if (g_ntscTimDataOffsets[i] == byteOffset)
		{
			return g_timDataCRCs[i];
		}
		i++;
	}

	return 0;
}

//set the offset given the matching intended crc
const unsigned int SetOffsetForCRC(unsigned int crc, int newOffset)
{
	int i = 0;
	while (g_timDataOffsets[i] != -1)
	{
		if (g_timDataCRCs[i] == crc)
		{
			g_timDataOffsets[i] = newOffset;
		}
		i++;
	}

	return 0;
}

static image_t *g_cardImages[NUM_LEVELS+1] =
{
	NULL,			//0
	NULL,			//1
	NULL,			//2
	NULL,			//3
	NULL,			//4
	NULL,			//5
	NULL,			//6
	NULL,			//7
	NULL,			//8
	NULL,			//9
	NULL,			//10
};

int g_useCRC = 0;

int g_finishLoop = 0;
int g_rendererReinit = 0;

static int g_backGroundNum = 1;

static int g_bgByteOffset = -1;
static int g_bgByteOffset2 = -1;
int g_bgMirrorSecond = -1;
int g_bgMirrorFirst = -1;
int g_bgOnePart = 0;

char g_workingDir[MAX_PATH_CHARS];
userInfo_t g_userInfo;

int g_numVidmodes;
vidMode_t g_vidModes[MAX_VIDMODES];

//storing all the gl texture handles in here
textureStorage_t g_texStorage;

//initialize all the cards in a static global array
playingCard_t g_playingCards[NUM_CARDS] =
{
	//LEVEL 1
	{ "Geezard", 1, 1, 1, 1, 1, 4, 5, CARD_ELEM_NONE, NULL },
	{ "Funguar", 1, 1, 2, 5, 1, 1, 3, CARD_ELEM_NONE, NULL },
	{ "Bite Bug", 1, 1, 3, 1, 3, 3, 5, CARD_ELEM_NONE, NULL },
	{ "Red Bat", 1, 1, 4, 6, 1, 1, 2, CARD_ELEM_NONE, NULL },
	{ "Blora", 1, 2, 1, 2, 1, 3, 5, CARD_ELEM_NONE, NULL },
	{ "Gayla", 1, 2, 2, 2, 4, 1, 4, CARD_ELEM_THUNDER, NULL },
	{ "Gesper", 1, 2, 3, 1, 4, 5, 1, CARD_ELEM_NONE, NULL },
	{ "Fastitocalon-F", 1, 2, 4, 3, 2, 5, 1, CARD_ELEM_EARTH, NULL },
	{ "Blood Soul", 1, 3, 1, 2, 6, 1, 1, CARD_ELEM_NONE, NULL },
	{ "Caterchipillar", 1, 3, 2, 4, 4, 2, 3, CARD_ELEM_NONE, NULL },
	{ "Cockatrice", 1, 3, 3, 2, 2, 1, 6, CARD_ELEM_THUNDER, NULL },

	//LEVEL 2
	{ "Grat", 2, 1, 1, 7, 3, 1, 1, CARD_ELEM_NONE, NULL },
	{ "Buel", 2, 1, 2, 6, 2, 2, 3, CARD_ELEM_NONE, NULL },
	{ "Mermerize", 2, 1, 3, 5, 3, 3, 4, CARD_ELEM_NONE, NULL },
	{ "Glacial Eye", 2, 1, 4, 6, 4, 1, 3, CARD_ELEM_ICE, NULL },
	{ "Belhelmel", 2, 2, 1, 3, 5, 4, 3, CARD_ELEM_NONE, NULL },
	{ "Thrustaevis", 2, 2, 2, 5, 2, 3, 5, CARD_ELEM_WIND, NULL },
	{ "Anacondaur", 2, 2, 3, 5, 3, 1, 5, CARD_ELEM_POISON, NULL },
	{ "Creeps", 2, 2, 4, 5, 5, 2, 2, CARD_ELEM_THUNDER, NULL },
	{ "Grendel", 2, 3, 1, 4, 5, 4, 2, CARD_ELEM_THUNDER, NULL },
	{ "Jelleye", 2, 3, 2, 3, 1, 2, 7, CARD_ELEM_NONE, NULL },
	{ "Grand Mantis", 2, 3, 3, 5, 5, 2, 3, CARD_ELEM_NONE, NULL },

	//LEVEL 3
	{ "Forbidden", 3, 1, 1, 6, 3, 6, 2, CARD_ELEM_NONE, NULL },
	{ "Armadodo", 3, 1, 2, 6, 1, 3, 6, CARD_ELEM_EARTH, NULL },
	{ "Tri-Face", 3, 1, 3, 3, 5, 5, 5, CARD_ELEM_POISON, NULL },
	{ "Fastitocalon", 3, 1, 4, 7, 1, 5, 3, CARD_ELEM_EARTH, NULL },
	{ "Snow Lion", 3, 2, 1, 7, 5, 1, 3, CARD_ELEM_ICE, NULL },
	{ "Ochu", 3, 2, 2, 5, 3, 6, 3, CARD_ELEM_NONE, NULL },
	{ "SAM08G", 3, 2, 3, 5, 2, 6, 4, CARD_ELEM_FIRE, NULL },
	{ "Death Claw", 3, 2, 4, 5, 2, 6, 4, CARD_ELEM_FIRE, NULL },
	{ "Cactuar", 3, 3, 1, 6, 6, 2, 3, CARD_ELEM_NONE, NULL },
	{ "Tonberry", 3, 3, 2, 3, 4, 6, 4, CARD_ELEM_NONE, NULL },
	{ "Abyss Worm", 3, 3, 3, 7, 3, 2, 5, CARD_ELEM_EARTH, NULL },

	//LEVEL 4
	{ "Turtapod", 4, 1, 1, 2, 6, 3, 7, CARD_ELEM_NONE, NULL },
	{ "Vysage", 4, 1, 2, 6, 4, 5, 5, CARD_ELEM_NONE, NULL },
	{ "T-Rexuar", 4, 1, 3, 4, 2, 6, 7, CARD_ELEM_NONE, NULL },
	{ "Bomb", 4, 1, 4, 2, 6, 7, 3, CARD_ELEM_FIRE, NULL },
	{ "Blitz", 4, 2, 1, 1, 4, 6, 7, CARD_ELEM_THUNDER, NULL },
	{ "Wendigo", 4, 2, 2, 7, 1, 3, 6, CARD_ELEM_NONE, NULL },
	{ "Torama", 4, 2, 3, 7, 4, 4, 4, CARD_ELEM_NONE, NULL },
	{ "Imp", 4, 2, 4, 3, 3, 7, 6, CARD_ELEM_NONE, NULL },
	{ "Blue Dragon", 4, 3, 1, 6, 7, 2, 3, CARD_ELEM_POISON, NULL },
	{ "Adamantoise", 4, 3, 2, 4, 5, 5, 6, CARD_ELEM_EARTH, NULL },
	{ "Hexadragon", 4, 3, 3, 7, 4, 5, 3, CARD_ELEM_FIRE, NULL },

	//LEVEL 5
	{ "Iron Giant", 5, 1, 1, 6, 6, 5, 5, CARD_ELEM_NONE, NULL },
	{ "Behemoth", 5, 1, 2, 3, 5, 6, 7, CARD_ELEM_NONE, NULL },
	{ "Chimera", 5, 1, 3, 7, 5, 6, 3, CARD_ELEM_WATER, NULL },
	{ "PuPu", 5, 1, 4, 3, 2, 10, 1, CARD_ELEM_NONE, NULL },
	{ "Elastoid", 5, 2, 1, 6, 6, 2, 7, CARD_ELEM_NONE, NULL },
	{ "GIM47N", 5, 2, 2, 5, 7, 5, 4, CARD_ELEM_NONE, NULL },
	{ "Malboro", 5, 2, 3, 7, 4, 7, 2, CARD_ELEM_POISON, NULL },
	{ "Ruby Dragon", 5, 2, 4, 7, 7, 2, 4, CARD_ELEM_FIRE, NULL },
	{ "Elnoyle", 5, 3, 1, 5, 7, 3, 6, CARD_ELEM_NONE, NULL },
	{ "Tonberry King", 5, 3, 2, 4, 7, 6, 4, CARD_ELEM_NONE, NULL },
	{ "Biggs and Wedge", 5, 3, 3, 6, 2, 6, 7, CARD_ELEM_NONE, NULL },

	//LEVEL 6
	{ "Fujin and Raijin", 6, 1, 1, 2, 8, 8, 4, CARD_ELEM_NONE, NULL },
	{ "Elvoret", 6, 1, 2, 7, 3, 8, 4, CARD_ELEM_WIND, NULL },
	{ "X-ATM092", 6, 1, 3, 4, 7, 8, 3, CARD_ELEM_NONE, NULL },
	{ "Granaldo", 6, 1, 4, 7, 8, 2, 5, CARD_ELEM_NONE, NULL },
	{ "Gerogero", 6, 2, 1, 1, 8, 8, 3, CARD_ELEM_POISON, NULL },
	{ "Iguion", 6, 2, 2, 8, 8, 2, 2, CARD_ELEM_NONE, NULL },
	{ "Abadon", 6, 2, 3, 6, 4, 8, 5, CARD_ELEM_NONE, NULL },
	{ "Trauma", 6, 2, 4, 6, 4, 8, 5, CARD_ELEM_NONE, NULL },
	{ "Oilboyle", 6, 3, 1, 1, 4, 8, 8, CARD_ELEM_NONE, NULL },
	{ "Shumi Tribe", 6, 3, 2, 6, 8, 5, 4, CARD_ELEM_NONE, NULL },
	{ "Krysta", 6, 3, 3, 7, 8, 5, 1, CARD_ELEM_NONE, NULL },

	//LEVEL 7
	{ "Propagator", 7, 1, 1, 8, 4, 4, 8, CARD_ELEM_NONE, NULL },
	{ "Jumbo Cactuar", 7, 1, 2, 8, 4, 8, 4, CARD_ELEM_NONE, NULL },
	{ "Tri-Point", 7, 1, 3, 8, 2, 5, 8, CARD_ELEM_THUNDER, NULL },
	{ "Gargantua", 7, 1, 4, 5, 6, 6, 8, CARD_ELEM_NONE, NULL },
	{ "Mobile Type 8", 7, 2, 1, 8, 7, 6, 3, CARD_ELEM_NONE, NULL },
	{ "Sphinxara", 7, 2, 2, 8, 5, 3, 8, CARD_ELEM_NONE, NULL },
	{ "Tiamat", 7, 2, 3, 8, 5, 8, 4, CARD_ELEM_NONE, NULL },
	{ "BGH251F2", 7, 2, 4, 5, 8, 7, 5, CARD_ELEM_NONE, NULL },
	{ "Red Giant", 7, 3, 1, 6, 4, 8, 7, CARD_ELEM_NONE, NULL },
	{ "Shumi Tribe", 7, 3, 2, 6, 8, 5, 4, CARD_ELEM_NONE, NULL },
	{ "Catoblepas", 7, 3, 3, 1, 7, 8, 7, CARD_ELEM_NONE, NULL },

	//LEVEL 8
	{ "Chubby Chocobo", 8, 1, 1, 4, 8, 4, 9, CARD_ELEM_NONE, NULL },
	{ "Angelo", 8, 1, 2, 9, 7, 6, 3, CARD_ELEM_NONE, NULL },
	{ "Gilgamesh", 8, 1, 3, 3, 9, 7, 6, CARD_ELEM_NONE, NULL },
	{ "MiniMog", 8, 1, 4, 9, 9, 3, 2, CARD_ELEM_NONE, NULL },
	{ "Chicobo", 8, 2, 1, 9, 8, 4, 4, CARD_ELEM_NONE, NULL },
	{ "Quezacotl", 8, 2, 2, 2, 9, 9, 4, CARD_ELEM_THUNDER, NULL },
	{ "Shiva", 8, 2, 3, 6, 4, 7, 9, CARD_ELEM_ICE, NULL },
	{ "Ifrit", 8, 2, 4, 9, 2, 6, 8, CARD_ELEM_FIRE, NULL },
	{ "Siren", 8, 3, 1, 8, 6, 9, 2, CARD_ELEM_NONE, NULL },
	{ "Sacred", 8, 3, 2, 5, 9, 1, 9, CARD_ELEM_EARTH, NULL },
	{ "Minotaur", 8, 3, 3, 9, 2, 5, 9, CARD_ELEM_EARTH, NULL },

	//LEVEL 9
	{ "Carbuncle", 9, 1, 1, 8, 10, 4, 4, CARD_ELEM_NONE, NULL },
	{ "Diablos", 9, 1, 2, 5, 8, 10, 3, CARD_ELEM_NONE, NULL },
	{ "Leviathan", 9, 1, 3, 7, 1, 10, 7, CARD_ELEM_WATER, NULL },
	{ "Odin", 9, 1, 4, 8, 3, 10, 5, CARD_ELEM_NONE, NULL },
	{ "Pandemonia", 9, 2, 1, 10, 7, 1, 7, CARD_ELEM_WIND, NULL },
	{ "Cerberus", 9, 2, 2, 7, 6, 4, 10, CARD_ELEM_NONE, NULL },
	{ "Alexander", 9, 2, 3, 9, 4, 10, 2, CARD_ELEM_HOLY, NULL },
	{ "Phoenix", 9, 2, 4, 7, 7, 2, 10, CARD_ELEM_FIRE, NULL },
	{ "Bahamut", 9, 3, 1, 10, 2, 8, 6, CARD_ELEM_NONE, NULL },
	{ "Doomtrain", 9, 3, 2, 3, 10, 1, 10, CARD_ELEM_POISON, NULL },
	{ "Eden", 9, 3, 3, 4, 10, 4, 10, CARD_ELEM_NONE, NULL },

	//LEVEL 10
	{ "Ward", 10, 1, 1, 10, 2, 7, 8, CARD_ELEM_NONE, NULL },
	{ "Kiros", 10, 1, 2, 6, 6, 7, 10, CARD_ELEM_NONE, NULL },
	{ "Laguna", 10, 1, 3, 5, 3, 10, 9, CARD_ELEM_NONE, NULL },
	{ "Selphie", 10, 1, 4, 10, 6, 8, 4, CARD_ELEM_NONE, NULL },
	{ "Quistis", 10, 2, 1, 9, 10, 6, 2, CARD_ELEM_NONE, NULL },
	{ "Irvine", 10, 2, 2, 2, 9, 6, 10, CARD_ELEM_NONE, NULL },
	{ "Zell", 10, 2, 3, 8, 10, 5, 6, CARD_ELEM_NONE, NULL },
	{ "Rinoa", 10, 2, 4, 4, 2, 10, 10, CARD_ELEM_NONE, NULL },
	{ "Edea", 10, 3, 1, 10, 3, 10, 3, CARD_ELEM_NONE, NULL },
	{ "Seifer", 10, 3, 2, 6, 10, 9, 4, CARD_ELEM_NONE, NULL },
	{ "Squall", 10, 3, 3, 10, 4, 6, 9, CARD_ELEM_NONE, NULL }
};

//global card image memory cleanup
void CleanCardImages(void)
{
	int i = 0;

	while (i < NUM_LEVELS+1)
	{
		if (g_cardImages[i])
		{
			if (g_cardImages[i]->pImage)
			{
				free(g_cardImages[i]->pImage);
				g_cardImages[i]->pImage = 0;
			}
			free(g_cardImages[i]);
			g_cardImages[i] = 0;
		}
		i++;
	}
}

//card memory cleanup
void CleanCardImage(playingCard_t *card)
{
	if (card->image)
	{
		free(card->image);
		card->image = 0;
	}
}

//initialize the image for the card
int CreateCardImage(playingCard_t *card)
{
	if (!g_cardImages[card->level])
	{ //cache this card image set
		int byteOffset = g_timDataOffsets[CARD_OFFSETS+card->level];

		if (byteOffset < 0)
		{
			return 0;
		}

		g_cardImages[card->level] = (image_t *)malloc(sizeof(image_t));
tryAgain:
		g_cardImages[card->level]->pImage = GetTIMFromBuffer(byteOffset, MAX_TIM_READ_LENGTH);

		if (!g_cardImages[card->level]->pImage)
		{
			if (!g_useCRC)
			{ //then, let's look based on crc's.
				Window_Print("This does not appear to be the North American distribution. Please be patient while the image is scanned for images based on CRC's. THIS MAY TAKE UP TO 10 MINUTES DEPENDING ON THE SPEED OF YOUR MACHINE due to the amount of data that must be evaluated. Note, however, that this will only be done once, subsequent startups should be instant.");
				g_useCRC = 1;

				memcpy(g_timDataOffsets, g_ntscTimDataOffsets, sizeof(g_timDataOffsets));
				byteOffset = g_timDataOffsets[CARD_OFFSETS+card->level];
				goto tryAgain;
			}
			free(g_cardImages[card->level]);
			g_cardImages[card->level] = 0;
			return 0;
		}
	}

	//now allocate an image_t for this individual card, and give a pointer to the
	//main image which holds all our card data
	card->image = (image_t *)malloc(sizeof(image_t));
	card->image->pImage = g_cardImages[card->level]->pImage;
	card->image->glTexNum = GL_CreateGLTextureFromCard(card, 0);
	card->image->glTexNum2 = GL_CreateGLTextureFromCard(card, 1);

	return 1;
}


//create the background texture
int CreateBackgroundImage(void)
{
	int oldLin = g_linearTex;
	image_t scratch;

	g_bgOnePart = 0;

	if (g_backGroundNum == 1)
	{
		g_bgByteOffset = g_timDataOffsets[0];
		g_bgByteOffset2 = g_timDataOffsets[1];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 0;
	}
	else if (g_backGroundNum == 2)
	{
		g_bgByteOffset = g_timDataOffsets[2];
		g_bgByteOffset2 = g_timDataOffsets[2];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 1;
	}
	else if (g_backGroundNum == 3)
	{
		g_bgByteOffset = g_timDataOffsets[3];
		g_bgByteOffset2 = g_timDataOffsets[3];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 0;
	}
	else if (g_backGroundNum == 4)
	{
		g_bgByteOffset = g_timDataOffsets[4];
		g_bgByteOffset2 = g_timDataOffsets[5];
		g_bgMirrorFirst = 1;
		g_bgMirrorSecond = 0;
	}
	else if (g_backGroundNum == 5)
	{
		g_bgByteOffset = g_timDataOffsets[6];
		g_bgByteOffset2 = g_timDataOffsets[6];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 1;
	}
	else if (g_backGroundNum == 6)
	{
		g_bgByteOffset = g_timDataOffsets[7];
		g_bgByteOffset2 = g_timDataOffsets[7];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 1;
	}
	else if (g_backGroundNum == 7)
	{
		g_bgByteOffset = g_timDataOffsets[8];
		g_bgByteOffset2 = g_timDataOffsets[8];
		g_bgMirrorFirst = 1;
		g_bgMirrorSecond = 0;
	}
	else if (g_backGroundNum == 8)
	{
		g_bgByteOffset = g_timDataOffsets[9];
		g_bgByteOffset2 = g_timDataOffsets[9];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 0;
	}
	else if (g_backGroundNum == 9)
	{
		g_bgByteOffset = g_timDataOffsets[10];
		g_bgByteOffset2 = g_timDataOffsets[11];
		g_bgMirrorFirst = 1;
		g_bgMirrorSecond = 1;
	}
	else if (g_backGroundNum == 10)
	{
		g_bgByteOffset = g_timDataOffsets[12];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 0;
		g_bgOnePart = 1;
	}
	else
	{
		g_bgByteOffset = g_timDataOffsets[13];
		g_bgByteOffset2 = g_timDataOffsets[13];
		g_bgMirrorFirst = 0;
		g_bgMirrorSecond = 1;
	}

	if (g_linearTex)
	{ //clamp with linear filter
		g_linearTex = 2;
	}
	else
	{ //clamp with no linear
		g_linearTex = 3;
	}

	g_multilayeredClutChoice = 0;
	scratch.pImage = GetTIMFromBuffer(g_bgByteOffset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	g_texStorage.backgroundImage = GL_CreateGLTextureFromImage(&scratch);

	//don't actually need this around after we load the gl tex from it
	free(scratch.pImage);

	if (!g_bgOnePart)
	{
		scratch.pImage = GetTIMFromBuffer(g_bgByteOffset2, MAX_TIM_READ_LENGTH);

		if (!scratch.pImage)
		{ //invalid img?
			return 0;
		}

		g_texStorage.backgroundImage2 = GL_CreateGLTextureFromImage(&scratch);

		free(scratch.pImage);
	}

	g_linearTex = oldLin;

	return 1;
}

//set alpha to 0 on all pixels that add up below tolerance
void AlphaImage(pixelImage_t *img, int tolerance)
{
	int i = 0;
	assert(img);
	rgbaPixel_t *p = &img->p;

	while (i < (img->i.width*img->i.height))
	{
		if ((p->r+p->g+p->b) < tolerance)
		{
			p->a = 0;
		}
		p++;
		i++;
	}
}

//set alpha to 0 on all pixels for specified amount starting at specified offset
void AlphaPixels(pixelImage_t *img, int offsetX, int offsetY, int pixels)
{
	int i = 0;
	assert(img);
	rgbaPixel_t *p = &img->p;

	p += (offsetY*img->i.width)+offsetX;

	while (i < pixels)
	{
		p->a = 0;
		p++;
		i++;
	}

}

//create other images
int CreateMiscImages(void)
{
	int offset;
	int oldLin = g_linearTex;
	image_t scratch;

	if (g_linearTex)
	{ //clamp with linear filter
		g_linearTex = 2;
	}
	else
	{ //clamp with no linear
		g_linearTex = 3;
	}

	//=================
	//pointer
	//=================
	offset = g_timDataOffsets[14];
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	AlphaImage(scratch.pImage, 10);
	g_texStorage.misterPointy = GL_CreateGLTextureFromImageRegion(&scratch, 224, 160, 32, 32);
	free(scratch.pImage);

	//=================
	//char set
	//=================
	int xOff = 0;
	int yOff = 45;
	const int fontW = 16;
	const int fontH = 18;
	char l = '0';

	memset(g_texStorage.letterTextures, 0, sizeof(g_texStorage.letterTextures));

	offset = g_timDataOffsets[15];
	g_multilayeredClutChoice = 16*2;
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	AlphaImage(scratch.pImage, 10);
	while (l <= '9')
	{ //number chars
		g_texStorage.letterTextures[l] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
		xOff += 16;
		l++;
	}
	xOff = 16;
	yOff = 61;
	l = 'A';
	while (l <= 'O')
	{ //cap letter chars 1
		g_texStorage.letterTextures[l] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
		xOff += 16;
		l++;
	}
	xOff = 0;
	yOff = 77;
	l = 'P';
	while (l <= 'Z')
	{ //cap letter chars 2
		g_texStorage.letterTextures[l] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
		xOff += 16;
		l++;
	}
	xOff = 16;
	yOff = 93;
	l = 'a';
	while (l <= 'o')
	{ //lowercase letter chars 1
		g_texStorage.letterTextures[l] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
		xOff += 16;
		l++;
	}
	xOff = 0;
	yOff = 109;
	l = 'p';
	while (l <= 'z')
	{ //lowercase letter chars 2
		if (l == 'w' || l == 'z')
		{ //these letters have a pixel hanging down from above from the lower case g and j
			AlphaPixels(scratch.pImage, xOff, yOff, fontW);
		}
		g_texStorage.letterTextures[l] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
		xOff += 16;
		l++;
	}

	//special chars
	xOff = 0;
	yOff = 61;
	g_texStorage.letterTextures[' '] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 16;
	yOff = 29;
	g_texStorage.letterTextures['!'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 48;
	yOff = 29;
	g_texStorage.letterTextures['#'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 64;
	yOff = 29;
	g_texStorage.letterTextures['$'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 70;
	yOff = 29;
	g_texStorage.letterTextures['%'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 86;
	yOff = 29;
	g_texStorage.letterTextures['&'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 160;
	yOff = 45;
	g_texStorage.letterTextures[':'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 176;
	yOff = 45;
	g_texStorage.letterTextures[';'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 192;
	yOff = 45;
	g_texStorage.letterTextures['<'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 208;
	yOff = 45;
	g_texStorage.letterTextures['='] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 224;
	yOff = 45;
	g_texStorage.letterTextures['>'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 240;
	yOff = 45;
	g_texStorage.letterTextures['?'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 207;
	yOff = 29;
	g_texStorage.letterTextures['-'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 176;
	yOff = 29;
	g_texStorage.letterTextures['+'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 240;
	yOff = 29;
	g_texStorage.letterTextures['/'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
	g_texStorage.letterTextures['\\'] = g_texStorage.letterTextures['/'];

	xOff = 240;
	yOff = 77;
	g_texStorage.letterTextures['_'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 208;
	yOff = 77;
	g_texStorage.letterTextures[']'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 208;
	yOff = 77;
	g_texStorage.letterTextures['['] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	xOff = 93;
	yOff = 0;
	g_texStorage.letterTextures['`'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);
	g_texStorage.letterTextures['\''] = g_texStorage.letterTextures['`'];

	xOff = 160;
	yOff = 39;
	AlphaPixels(scratch.pImage, xOff, yOff, fontW); //strip pixel from the asterisk above
	g_texStorage.letterTextures['.'] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, fontW, fontH);

	free(scratch.pImage);

	//=================
	//card numbers
	//=================
	int i = 0;

	xOff = 0;
	yOff = 80;
	offset = g_timDataOffsets[16];
	g_multilayeredClutChoice = 16*2;
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	AlphaImage(scratch.pImage, 100);
	while (i <= 9)
	{ //number chars
		g_texStorage.cardNumTextures[i] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, 10, 14);
		xOff += 16;
		i++;
	}
	//get the 'A'
	g_texStorage.cardNumTextures[10] = GL_CreateGLTextureFromImageRegion(&scratch, 144, 128, 10, 14);
	free(scratch.pImage);

	//=================
	//elemental icons
	//=================
	i = CARD_ELEM_FIRE;

	xOff = 128;
	yOff = 160;
	//offset = g_timDataOffsets[16];
	g_multilayeredClutChoice = 16*8;
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	AlphaImage(scratch.pImage, 100);
	while (i < CARD_ELEM_NUM)
	{ //number chars
		g_texStorage.cardElemTextures[i] = GL_CreateGLTextureFromImageRegion(&scratch, xOff, yOff, 16, 12);
		xOff += 16;
		i++;
	}
	free(scratch.pImage);

	//=================
	//double!! and triple!!
	//=================
	//offset = g_timDataOffsets[16];
	g_multilayeredClutChoice = 16*11;
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	AlphaImage(scratch.pImage, 1);

	g_texStorage.doubleTex = GL_CreateGLTextureFromImageRegion(&scratch, 0, 176, 48, 10);
	g_texStorage.tripleTex = GL_CreateGLTextureFromImageRegion(&scratch, 0, 192, 48, 10);

	free(scratch.pImage);

	//=================
	//trigger! and perfect!!
	//=================
	//offset = g_timDataOffsets[16];
	g_multilayeredClutChoice = 16*14;
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	AlphaImage(scratch.pImage, 1);

	g_texStorage.triggerTex = GL_CreateGLTextureFromImageRegion(&scratch, 64, 202, 80, 20);
	g_texStorage.perfectTex = GL_CreateGLTextureFromImageRegion(&scratch, 163, 201, 80, 20);

	free(scratch.pImage);

	//=================
	//tonberry stuff
	//=================
	offset = g_timDataOffsets[17];
	g_multilayeredClutChoice = 0;
	scratch.pImage = GetTIMFromBuffer(offset, MAX_TIM_READ_LENGTH);

	if (!scratch.pImage)
	{ //invalid img?
		return 0;
	}

	g_linearTex = 0;
	g_texStorage.doinkTxt = GL_CreateGLTextureFromImageRegion(&scratch, 15, 14, 83, 31);
	AlphaImage(scratch.pImage, 1);
	g_texStorage.doinkBubble = GL_CreateGLTextureFromImageRegion(&scratch, 127, 0, 113, 64);

	free(scratch.pImage);


	g_linearTex = oldLin;
	return 1;
}

//clean up for shudown or renderer reinit
void Shutdown(void)
{
	int i = 0;
	//clean up the main image stash
	CleanCardImages();
	while (i < NUM_CARDS)
	{ //clean individual card images
		CleanCardImage(&g_playingCards[i]);
		i++;
	}
}

//prompt the user to find their ff8disc1.img
void ImgFilePrompt(void)
{
	/*
	static char fType[MAX_PRINT_CHARS];
	
	strcpy(fType, "FF8 Disc 1 IMG|ff8disc1.img||");
	CFileDialog openBox(TRUE, NULL, NULL, 0, fType, NULL);

	if (openBox.DoModal() == IDOK)
	{
		CString path = openBox.GetPathName();
		strcpy(g_userInfo.infoPath, path.GetBuffer(MAX_PATH_CHARS));
		path.ReleaseBuffer();
	}
	*/
	strcpy(g_userInfo.infoPath, "D:\\ff8disc1.img");
	//sprintf(g_userInfo.infoPath, "%s/ff8disc1.img", g_workingDir);
}

//on startup or after renderer reinit
extern int g_glTexNum;
int Initialize(void)
{
	int i = 0;

	g_glTexNum = 0;

	//make sure all our keys init to 0
	memset(g_keysPressed, 0, sizeof(g_keysPressed));
	memset(g_keysDebounce, 0, sizeof(g_keysDebounce));

	g_backGroundNum = g_userInfo.background;
	g_linearTex = g_userInfo.texFilter;

	if (!g_userInfo.infoPath[0])
	{
		ImgFilePrompt();

		if (!g_userInfo.infoPath[0])
		{
			Window_Print("No data, exiting.");
			return 0;
		}

		//save the path to the file
		User_SaveUI();
	}

	/*
	if (!CreateTIMBuffer(g_userInfo.infoPath))
	{
		Window_Print("Failed to open '%s'", g_userInfo.infoPath);
		return 0;
	}
	*/
	if (!CreateTIMBuffer(g_userInfo.infoPath))
	{
		return 0;
	}

#if 0 //get crc's
	while (g_timDataOffsets[i] != -1)
	{
		image_t scratch;
		scratch.pImage = GetTIMFromBuffer(g_timDataOffsets[i], MAX_TIM_READ_LENGTH);

		if (scratch.pImage)
		{
			free(scratch.pImage);
		}
		i++;
	}
#endif

	while (i < NUM_CARDS)
	{
		if (!CreateCardImage(&g_playingCards[i]))
		{ //probably couldn't find the image or something
			Window_Print("Failed to allocate image for '%s' card.", g_playingCards[i].cardName);
			return 0;
		}
		i++;
	}

	//create background texture
	if (!CreateBackgroundImage())
	{
		Window_Print("Background load failed. Is your selected img valid?");
		return 0;
	}

	//create other images
	if (!CreateMiscImages())
	{
		Window_Print("Image load failed. Is your selected img valid?");
		return 0;
	}

	//make sure card images are still loaded
	if (!g_cardImages[1])
	{
		Window_Print("Unexpected card image load failure. Is your selected img valid?");
		return 0;
	}

	//create the texture for the back of a card
	GL_CardBackface(g_cardImages[1]);

	//don't need it anymore after we've created all our images
	FreeTIMBuffer();

	return 1;
}


extern void Music_Shutdown(void);
extern bool Music_Init(void);
extern bool Music_PlaySample(const char *filename);
extern void Music_FrameChecks(int packetNum);
extern int S_Init();

HANDLE g_xboxController = 0;
XINPUT_GAMEPAD g_xboxPadState;

DWORD WINAPI XboxMusicThread(VOID *pParameter)
{
	while (1)
	{
		int i = 0;
		while (i < 3)
		{
			Music_FrameChecks(i);
			i++;
		}

		Sleep(100);
	}
}

//xbox stuff (controller etc)
void XBox_Init(void)
{
	XDEVICE_PREALLOC_TYPE xpt;

	xpt.DeviceType = XDEVICE_TYPE_GAMEPAD;
	xpt.dwPreallocCount = 1;

	XInitDevices(1, &xpt);

	while (!g_xboxController)
	{ //if no controller wait for them to plug it in
		g_xboxController = XInputOpen(XDEVICE_TYPE_GAMEPAD,
			XDEVICE_PORT0, XDEVICE_NO_SLOT, NULL);
		if (g_xboxController)
		{
			break;
		}
		Sleep(100);
	}

	CreateThread(NULL, 0, XboxMusicThread, NULL, 0, NULL);
}

//update gamepad
//terrible hax to update the old gltriad keys array
void XBox_UpdateGamepad(void)
{
	XINPUT_STATE state;

	XInputGetState(g_xboxController, &state);

	g_xboxPadState = state.Gamepad;

	if (g_xboxPadState.wButtons & XINPUT_GAMEPAD_DPAD_UP)
	{
		g_keysPressed[VK_UP] = 1;
	}
	else
	{
		g_keysPressed[VK_UP] = 0;
		g_keysDebounce[VK_UP] = 0;
	}

	if (g_xboxPadState.wButtons & XINPUT_GAMEPAD_DPAD_DOWN)
	{
		g_keysPressed[VK_DOWN] = 1;
	}
	else
	{
		g_keysPressed[VK_DOWN] = 0;
		g_keysDebounce[VK_DOWN] = 0;
	}

	if (g_xboxPadState.wButtons & XINPUT_GAMEPAD_DPAD_LEFT)
	{
		g_keysPressed[VK_LEFT] = 1;
	}
	else
	{
		g_keysPressed[VK_LEFT] = 0;
		g_keysDebounce[VK_LEFT] = 0;
	}

	if (g_xboxPadState.wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)
	{
		g_keysPressed[VK_RIGHT] = 1;
	}
	else
	{
		g_keysPressed[VK_RIGHT] = 0;
		g_keysDebounce[VK_RIGHT] = 0;
	}

	if (g_xboxPadState.wButtons & XINPUT_GAMEPAD_START)
	{
		g_keysPressed[VK_ESCAPE] = 1;
	}
	else
	{
		g_keysPressed[VK_ESCAPE] = 0;
		g_keysDebounce[VK_ESCAPE] = 0;
	}

	if (g_xboxPadState.bAnalogButtons[XINPUT_GAMEPAD_B] > 1)
	{
		g_keysPressed[VK_SPACE] = 1;
		g_keysPressed[VK_BACK] = 1;
	}
	else
	{
		g_keysPressed[VK_SPACE] = 0;
		g_keysDebounce[VK_SPACE] = 0;
		g_keysPressed[VK_BACK] = 0;
		g_keysDebounce[VK_BACK] = 0;
	}

	if (g_xboxPadState.bAnalogButtons[XINPUT_GAMEPAD_A] > 1)
	{
		g_keysPressed[VK_RETURN] = 1;
	}
	else
	{
		g_keysPressed[VK_RETURN] = 0;
		g_keysDebounce[VK_RETURN] = 0;
	}
}

int g_depthHack = 0;

waveFile_t *g_sound_cardWoosh = NULL;
waveFile_t *g_sound_menuMove = NULL;
waveFile_t *g_sound_menuUse = NULL;

//initialization function
void __cdecl main()
{
	unsigned short wcName[1024];
	MultiByteToWideChar(CP_ACP, 0, "XTriad", -1, wcName, 1024);
	XSetNickname(wcName, TRUE);

	CRC_CreateTable();

	//init menu
	memset(&g_gameMenu, 0, sizeof(g_gameMenu));
	memset(&g_ruleMenu, 0, sizeof(g_gameMenu));
	memset(&g_menuInput, 0, sizeof(g_menuInput));

	memset(&g_gameRules, 0, sizeof(g_gameRules));
	memset(&g_userInfo, 0, sizeof(g_userInfo));

	/*
	if (!_getcwd(g_workingDir, MAX_PATH_CHARS))
	{ //oh no!
		return;
	}
	*/
	g_workingDir[0] = 0;

	if (!User_LoadUI())
	{ //if load failed, then set defaults
		g_userInfo.vidMode = 0;
		g_userInfo.bpp = 32;
		g_userInfo.background = 1;
		g_userInfo.texFilter = 1;
		g_userInfo.fullScreen = 0;
		g_userInfo.connPort = 24123;
		strcpy(g_userInfo.connIP, "127.0.0.1");
		g_userInfo.limitFramerate = 0;

		memcpy(g_userInfo.timByteOffsets, g_timDataOffsets, sizeof(g_timDataOffsets));
	}
	else
	{ //shove the existing offsets into what we intend to use
		memcpy(g_timDataOffsets, g_userInfo.timByteOffsets, sizeof(g_timDataOffsets));
	}

	//if (!Window_Create(0, g_vidModes[g_userInfo.vidMode].width, g_vidModes[g_userInfo.vidMode].height, g_userInfo.bpp, g_userInfo.fullScreen))
	if (!Window_Create(0, 640, 480, 32, 1))
	{ //complete failure
		return;
	}

	S_Init();

	//do init for textures etc.
	if (!Initialize())
	{
		//if init fails, invalidate the info path and save the cfg
		//so they are prompted for it again on next startup.
		g_userInfo.infoPath[0] = 0;
		User_SaveUI();
		return;
	}

	g_sound_cardWoosh = S_GetWaveData("D:\\sounds\\snd_game_whoosh.wav");
	g_sound_menuMove = S_GetWaveData("D:\\sounds\\snd_mnu_move.wav");
	g_sound_menuUse = S_GetWaveData("D:\\sounds\\snd_mnu_select.wav");

    if (!Music_PlaySample("D:\\sounds\\music.wma"))
	{
		Music_PlaySample("D:\\sounds\\music.wav");
	}

	if (g_useCRC)
	{ //if we successfully found data using the crc checks, save the offsets
		memcpy(g_userInfo.timByteOffsets, g_timDataOffsets, sizeof(g_timDataOffsets));
		User_SaveUI();
	}

	//init networking stuff
	//Net_Init();
	//done as needed (for xbox)

	//init menu
	Game_MenuInit();

	//init game
	Game_Init();

	//xbox stuff
	XBox_Init();

	//===================================
	//main loop
	while (1)
	{
		XBox_UpdateGamepad();

		Game_Logic();
		GL_DrawFrame();
		
		//SwapBuffers(g_hDC);
		g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

		if (g_rendererReinit /*&& !g_finishLoop*/)
		{ //reload
			Shutdown();
			Window_Close();

			if (!Initialize())
			{
				return;
			}
			g_rendererReinit = 0;
		}
	}
	//===================================
}
