!!ARBfp1.0

#standard lighting with normal mapping plus paralax mapping (adaption
#of standard lighting program)
#written by Rich Whitehouse
#---------------------------------------------------------------------
#please credit me if you find something here useful or informative. ^^
#it is written to closely imitate the general behaviour of register
#combiners (thus the normal expansion) because the implementation in
#my engine is mostly shared between the nv combiner path and the
#fragment program path.
#---------------------------------------------------------------------

#texture3 is the reference cubemap
#texture2 is the decal
#texture1 contains view vectors
#texture0 is the normal map, with the heightmap in the alpha channel

PARAM	mulf = {2.0, 2.0, 2.0};
PARAM	subf = {1.0, 1.0, 1.0};

OUTPUT	out = result.color;
TEMP	cbrf, nrml, dcal, temp, height, eyevects, newtexcoord;

#as per parallax_mapping.pdf by Terry Welsh
DP3	temp, fragment.texcoord[1], fragment.texcoord[1];
RSQ	temp, temp.x;
MUL	eyevects, fragment.texcoord[1], temp;

#fetch normal map texture
TEX	height, fragment.texcoord[0], texture[0], 2D;

#copy alpha into rgb
MOV	height.r, height.a;
MOV	height.g, height.a;
MOV	height.b, height.a;

#scale and bias
#MAD	height, height, 1.16, -1.08;
MAD	height, height, 0.16, -0.08;
#MAD	height, height, 0.04, -0.02;

#scale based on alpha, which is based on music beat ^^
MUL	height, height, fragment.color.primary.a;

MAD	newtexcoord, height, eyevects, fragment.texcoord[0];

#fetch the textures
TEX	cbrf, fragment.texcoord[3], texture[3], CUBE;
TEX	nrml, newtexcoord, texture[0], 2D;
TEX	dcal, newtexcoord, texture[2], 2D;

#expand the normals
MUL	nrml, nrml, mulf;
SUB	nrml, nrml, subf;
MUL	cbrf, cbrf, mulf;
SUB	cbrf, cbrf, subf;

DP3	temp, nrml, cbrf; #do the dot3

MUL	temp, temp, fragment.color; #factor in light color
MUL	temp, dcal, temp; #factor in decal

MOV	temp.a, dcal.a; #set alpha component by decal

MOV	out, temp;

END
