#ifndef _SHAREDTYPES_H
#define _SHAREDTYPES_H

#define _CRT_SECURE_NO_DEPRECATE
#pragma warning(disable:4996)

//DO NOT modify this file (except where otherwise noted). These types
//are all shared with the engine code and if they are modified, then
//obviously the engine will not be aware of the change and it will
//break things.

#define PITCH		0
#define YAW			1
#define ROLL		2

#define MAX_NET_CLIENTS		16
#define CAM_TRACK_NUM		(MAX_NET_CLIENTS+1) //fetus blaster
#define MAP_OBJ_NUM			(CAM_TRACK_NUM+1)

#define MAX_CLIENT_INFO_SIZE	32
#define	MAX_GAME_STRINGS		1024

typedef struct modelMatrix_s
{
	float				x1[3];
	float				x2[3];
	float				x3[3];
	float				o[3];
} modelMatrix_t;

typedef struct fourxMatrix_s
{
	float				c1[4];
	float				c2[4];
	float				c3[4];
	float				c4[4];
} fourxMatrix_t;

typedef struct viewFrustum_s
{
	float			planes[6][4];
	modelMatrix_t	ori;

	float			lenNear;
	float			lenFar;
	float			lenRight;
	float			lenUp;
} viewFrustum_t;

typedef enum
{
	OBJ_TYPE_SPRITE,
	OBJ_TYPE_MAP,
	OBJ_TYPE_MODEL,
	OBJ_TYPE_NETEVENT,
	OBJ_TYPE_CAM,
	OBJ_TYPE_PROJECTILE,
	OBJ_TYPE_GENERAL,
	OBJ_TYPE_LIGHT,
	OBJ_TYPE_VISBLOCK,
	OBJ_TYPE_USER, //reserved for custom logic modules
	NUM_OBJ_TYPES
} objTypes_e;

typedef enum
{
	NETEVENT_SOUND,
	NETEVENT_PARTICLES,
	NETEVENT_DECAL,
	NETEVENT_DEBUGBOX,
	NUM_NETEVENT_TYPES
} objNetEvent_e;

typedef enum
{
	CLEV_UPDATEHIGHSCORE,
	CLEV_DISPLAYMUL,
	CLEV_TRIGGERFLASH,
	CLEV_VIEWTRAILS,
	NUM_CL_EVENTS
} clientEventTypes_e;

#define OBJPHYS_NOROTATION				(1<<0)
#define OBJPHYS_NOPHYSREACTION			(1<<1)
#define OBJPHYS_NOFRICTION				(1<<2)
#define OBJPHYS_NOGRAVITY				(1<<3)
#define OBJPHYS_NOTRANSLATION			(1<<4)

//collision structure
typedef struct collObj_s
{
	float			endPos[3];
	float			endNormal[3];
	bool			containsSolid;
	int				hitObjectIndex;
	float			distance;
	bool			inSolid;
	bool			hit;
	void			*hitTex;
	float			hitTexPos[2];
} collObj_t;

#define CLIPFL_PROJECTILE	(1<<0)
#define CLIPFL_BOXMOVE		(1<<1)
//collision model format
typedef struct rcColModel_s
{
	void			*intrnModel;
	int				frame;
	float			pos[3];
	float			ang[3];
	float			modelScale[3];
	float			mins[3];
	float			maxs[3];
	float			radius;
	int				gameOwner;
	int				gameIgnore;
	int				solid;
	int				clipFlags;
} rcColModel_t;

#define INUSE_ACTIVE	(1<<0)
#define INUSE_NONET		(1<<1)

#define FXFL_SHELLRED		(1<<0)
#define FXFL_HIDDEN			(1<<1)
#define FXFL_ILLUMINATE		(1<<2)
#define FXFL_VIEWFLARE		(1<<3)
#define FXFL_NOSPRORI		(1<<4)
#define FXFL_FPSMODE		(1<<5)
#define FXFL_SPECIALBLEND	(1<<6)
#define FXFL_MUSICAL		(1<<7)
#define FXFL_SHELL1			(1<<8)
#define FXFL_SHELL2			(1<<9)

#define LIGHTFL_DOUBLE		(1<<0)
#define LIGHTFL_AMBPROG		(1<<1)
#define LIGHTFL_FULLAMB		(1<<2)

//shared between client and server, one per game object.
//THIS STRUCTURE MUST REMAIN DWORD-ALIGNED. otherwise everything
//will explode. horribly. i suggest not adding anything but
//ints, unless you want to do something like 2 shorts right
//next to each other.
typedef struct gameObjNet_s
{
	int					index;

	int					type;

	float				pos[3];
	float				ang[3];
	float				vel[3];
	int					velTime;

	float				mins[3];
	float				maxs[3];

	int					renderEffects;

	float				modelScale[3];

	float				deformOverride;

	int					solid;
	int					owner;	//quake-style logic, don't collide with
								//my owner or things i own

	int					frame; //for simple server-logic-based animating
	int					lerpDuration;

	//string index for entity name
	int					entNameIndex;

	//used for sprites or whatever else.
	int					strIndex;
	int					strIndexB;

	//optimizations for static objects and lights
	int					staticIndex;

	//hack, player stuff (can be reused for other things)
	int					lives;
	int					plAmmo;

	//Below here you can add more values if you want them
	//to be sent across the network. Don't modify anything
	//above here, since the above values may be referenced
	//by engine code.
} gameObjNet_t;

typedef struct objArgs_s
{
	char		*key;
	char		*val;
} objArgs_t;

typedef enum
{
	BUTTON_UP,
	BUTTON_DOWN,
	BUTTON_LEFT,
	BUTTON_RIGHT,
	BUTTON_CHARMENU,
	BUTTON_ACTION,
	BUTTON_JUMP,
	BUTTON_EVENT1,
	BUTTON_EVENT2,
	BUTTON_EVENT3,
	BUTTON_EVENT4,
	BUTTON_EVENT5,
	BUTTON_EVENT6,
	BUTTON_EVENT7,
	BUTTON_EVENT8,
	BUTTON_EVENT9,
	MAX_BUTTONS
} buttonEnum_e;

#endif //_SHAREDTYPES_H
