/*
=============================================================================
Module Information
------------------
Name:			obj_bigjesus.cpp
Author:			Rich Whitehouse
Description:	=O
=============================================================================
*/

#include "main.h"

#define BJFL_ENGAGE		(1<<0)
#define BJFL_PURIFIED	(1<<1)

static modelMatrix_t g_jesusIdent =
{
	{1.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 1.0f},
	{0.0f, 0.0f, 0.0f}
};

typedef enum
{
	JESUS_HAND_L,
	JESUS_HAND_R,
	JESUS_ARM_L,
	JESUS_ARM_R,
	JESUS_TORSO,
	JESUS_WAIST,
	JESUS_HEAD,
	JESUS_FOOT_L,
	JESUS_FOOT_R,
	JESUS_THIGH_L,
	JESUS_THIGH_R,
	JESUS_LEG_L,
	JESUS_LEG_R,
	NUM_JESUS_PARTS
} jesusPart_e;

typedef struct jesusPart_s
{
	jesusPart_e		partType;
	gameObject_t	*obj;
	modelMatrix_t	mat;
	modelMatrix_t	transMat;
	jesusPart_s		*parent;
	float			offPos[3];
	float			offAng[3];
	unsigned long	transTime;

	float			nsMins[3];
	float			nsMaxs[3];
	float			nsRad;
	float			nsModelScale[3];
} jesusPart_t;
static jesusPart_t g_jesusParts[NUM_JESUS_PARTS];
static float g_jesusPos[3];
static float g_jesusAng[3];
static float g_jesusCOG[3];

typedef enum
{
	JESUSSTATE_IDLE,
	JESUSSTATE_RUNNING,
	JESUSSTATE_TWIRLING,
	JESUSSTATE_TWIRLING2,
	NUM_JESUS_STATES
} jesusState_e;
static jesusState_e g_jesusState = JESUSSTATE_IDLE;

//offset the part
void ObjBigJesus_OffsetPart(jesusPart_t *part, float *pos, float *ang)
{
	if (!pos)
	{
		pos = part->offPos;
	}
	if (!ang)
	{
		ang = part->offAng;
	}
	Math_CreateMatrixFromOrientation(pos, ang, &part->mat);
	Math_VecCopy(pos, part->offPos);
	Math_VecCopy(ang, part->offAng);
}

//scale a jesus part
void ObjBigJesus_ScalePart(jesusPart_t *part, float scale)
{
	if (!part->obj || !part->obj->inuse)
	{
		return;
	}

	part->nsRad = part->obj->radius;

	part->obj->radius *= scale;
	for (int i = 0; i < 3; i++)
	{
		part->nsMins[i] = part->obj->spawnMins[i];
		part->nsMaxs[i] = part->obj->spawnMaxs[i];
		part->nsModelScale[i] = part->obj->net.modelScale[i];

		part->obj->net.modelScale[i] *= scale;
		part->obj->spawnMins[i] *= scale;
		part->obj->spawnMaxs[i] *= scale;
		part->obj->net.mins[i] *= scale;
		part->obj->net.maxs[i] *= scale;
	}
	if (part->obj->rcColModel)
	{
		LServ_UpdateRClip(part->obj);
	}
}

//jesus cleansing
void ObjBigJesus_HolyJustice(gameObject_t *obj)
{
	for (int i = MAX_NET_CLIENTS; i < g_gameObjectSlots; i++)
	{
		gameObject_t *other = &g_gameObjects[i];
		if (!other->inuse || !other->hurtable || other->health <= 0 ||
			other->net.owner == obj->net.index)
		{
			continue;
		}
		Util_DamageObject(obj, other, 9999999);
	}
}

//get the part where it's supposed to be on the skeleton
void ObjBigJesus_PartToSkeleton(gameObject_t *jesus, jesusPart_t *part, float timeMod)
{
	if (!part->obj || !part->obj->inuse)
	{
		return;
	}

	float oldPos[3];
	Math_VecCopy(part->obj->net.pos, oldPos);

	float f = 0.2f;//0.07f;
	if (g_jesusState == JESUSSTATE_TWIRLING ||
		g_jesusState == JESUSSTATE_TWIRLING2)
	{
		if (jesus->debounce2 >= g_curTime)
		{
			f = 0.05f;
		}
	}
	part->obj->net.pos[0] = Util_NudgeValue(part->obj->net.pos[0], part->transMat.o[0], timeMod*f);
	part->obj->net.pos[1] = Util_NudgeValue(part->obj->net.pos[1], part->transMat.o[1], timeMod*f);
	part->obj->net.pos[2] = Util_NudgeValue(part->obj->net.pos[2], part->transMat.o[2], timeMod*f);
	Math_VecCopy(g_jesusAng, part->obj->net.ang);

	if (part->obj->net.pos[0] != oldPos[0] ||
		part->obj->net.pos[1] != oldPos[1] ||
		part->obj->net.pos[2] != oldPos[2])
	{
		collObj_t col;
		g_sharedFn->Coll_RadiusTranslation(part->obj->rcColModel, &col, oldPos, part->obj->net.pos, part->obj->radius, NULL, false);
		if (col.hit && col.hitObjectIndex >= 0 && col.hitObjectIndex <= MAX_GAME_OBJECTS)
		{
			Util_TouchObjects(part->obj, &g_gameObjects[col.hitObjectIndex], &col);
		}
	}
}

//jesus's part needs transforming
void ObjBigJesus_TransformJesusPart(jesusPart_t *part)
{
	if (part->parent)
	{ //transform the parent of this jesus part first
		ObjBigJesus_TransformJesusPart(part->parent);
	}

	if (part->transTime == g_curTime)
	{ //this part was already transformed this frame
		return;
	}

	if (part->parent)
	{
		Math_MatrixMultiply(&part->parent->transMat, &part->mat, &part->transMat);
	}
	else
	{
		part->transMat = part->mat;
	}

	part->transTime = g_curTime;
}

//transform the jesus
void ObjBigJesus_TransformJesus(gameObject_t *obj)
{
	for (int i = 0; i < NUM_JESUS_PARTS; i++)
	{
        ObjBigJesus_TransformJesusPart(&g_jesusParts[i]);
	}
}

//what does jesus think? NOW WE ALL KNOW.
void ObjBigJesus_CoreAI(gameObject_t *obj, float timeMod)
{
	gameObject_t *cam = &g_gameObjects[CAM_TRACK_NUM];
	if (cam->inuse)
	{
		g_jesusCOG[0] = cam->net.pos[0];
		g_jesusCOG[1] = cam->net.pos[1];
	}

	//find an enemy
	float bestD = 0.0f;
	gameObject_t *en = NULL;
	for (int i = 0; i < MAX_NET_CLIENTS; i++)
	{
		gameObject_t *pl = &g_gameObjects[i];
		if (pl->inuse)
		{
			float d[3];
			Math_VecSub(g_jesusPos, pl->net.pos, d);
			float dist = Math_VecLen(d);
			if (!en || dist < bestD)
			{
				en = pl;
				bestD = dist;
			}
		}
	}
	if (en)
	{
		if (!obj->enemy)
		{
			obj->enemy = en;
		}
		else
		{
			float d[3];
			Math_VecSub(g_jesusPos, obj->enemy->net.pos, d);
			float dist = Math_VecLen(d);
			if ((bestD+256.0f) < dist)
			{
				obj->enemy = en;
			}
		}
	}

	float enPos[3];
	if (obj->enemy)
	{
		Math_VecCopy(obj->enemy->net.pos, enPos);
	}
	else
	{
		enPos[0] = 0.0f;
		enPos[1] = 0.0f;
		enPos[2] = 0.0f;
	}
	if (g_jesusState == JESUSSTATE_RUNNING)
	{
		float jesusMoveSpeed = 48.0f*timeMod;
		float nang[3], ndir[3];
		Math_VecSub(g_jesusPos, enPos, ndir);
		Math_VecNorm(ndir);
		Math_VecToAngles(ndir, nang);
		float angleBlend = 0.3f;
		for (int i = 0; i < 3; i++)
		{
			float ang = (360.0f/65536.0f)*((int)(nang[i]*(65536.0f/360.0f)) & 65535);
			if (i == 0 && ang > 30.0f)
			{
				ang = 30.0f;
			}
			g_jesusAng[i] = Math_BlendAngle(g_jesusAng[i], ang, timeMod*angleBlend);
		}
		//g_jesusAng[PITCH] = 0.0f;

		float yawOnly[3] = {0.0f, g_jesusAng[YAW], 0.0f};
		Math_AngleVectors(yawOnly, ndir, 0, 0);
		g_jesusPos[0] -= ndir[0]*jesusMoveSpeed;
		g_jesusPos[1] -= ndir[1]*jesusMoveSpeed;
		//g_jesusPos[2] -= ndir[2]*jesusMoveSpeed;
	}
	else if (g_jesusState == JESUSSTATE_TWIRLING ||
		g_jesusState == JESUSSTATE_TWIRLING2)
	{
		float factor = 0.002f;
		if (g_jesusState == JESUSSTATE_TWIRLING2)
		{
			factor = 0.005f;
		}
		float twirlTimeBase = (float)g_curTime*factor;
		float twirlRadius = 1600.0f;//1024.0f;

		if (g_jesusState == JESUSSTATE_TWIRLING2)
		{
			g_jesusPos[0] = g_jesusCOG[0] + sinf(twirlTimeBase)*twirlRadius;
			g_jesusPos[1] = g_jesusCOG[1] + cosf(twirlTimeBase*0.5f)*twirlRadius;
		}
		else
		{
			g_jesusPos[0] = g_jesusCOG[0] + sinf(twirlTimeBase)*twirlRadius;
			g_jesusPos[1] = g_jesusCOG[1] + cosf(twirlTimeBase)*twirlRadius;
		}
		g_jesusAng[PITCH] = 0.0f;
		g_jesusAng[YAW] -= 24.0f*timeMod;

		if (obj->debounce3 < g_curTime)
		{
			ObjSound_Create(obj->net.pos, "assets/sound/other/jesustwirl.wav", 1.0f, -1);
			obj->debounce3 = g_curTime+400;
		}
	}
}

//jesus has been destroyed in his whirlwind of fury. it is time for him to ponder.
void ObjBigJesus_ThinkDestroyed(gameObject_t *obj, float timeMod)
{
	float basePos[3];
	Math_VecCopy(g_jesusCOG, basePos);

	basePos[0] += (-1600.0f + (float)(rand()%3200));
	basePos[1] += (-1600.0f + (float)(rand()%3200));

	float up[3] = {-90.0f, 0.0f, 0.0f};
	ObjParticles_Create("jesuspart/death", basePos, up, -1);
	ObjSound_Create(basePos, "assets/sound/other/pulse_blow.wav", 1.0f, -1);
	ObjSound_Create(basePos, "assets/sound/other/jesuspain.wav", 1.0f, -1);

	obj->thinkTime = g_curTime + 300;
}

//jesus think
void ObjBigJesus_Think(gameObject_t *obj, float timeMod)
{
	if (!(obj->generalFlag & BJFL_ENGAGE))
	{
		gameObject_t *cam = &g_gameObjects[CAM_TRACK_NUM];
		if (cam->inuse && g_camFrustumFresh)
		{
			if (!(obj->generalFlag & BJFL_PURIFIED))
			{
				const float waitDist = 7096.0f*7096.0f;
				if (Util_CamProx2D(obj->net.pos, waitDist))
				{ //go
					obj->generalFlag |= BJFL_PURIFIED;
					//jesus boss music engage!
					g_sharedFn->Common_ServerString("$$assets/music/l2boss.mp3");
					ObjBigJesus_HolyJustice(obj); //destroy sinners
				}
			}
			else
			{
				const float waitDist = 2048.0f*2048.0f;
				if (Util_CamProx2D(obj->net.pos, waitDist))
				{ //go
					obj->generalFlag |= BJFL_ENGAGE;
				}
			}
		}
	}

	if (obj->generalFlag & BJFL_ENGAGE)
	{
		if (obj->debounce < g_curTime)
		{
			jesusState_e oldState = g_jesusState;
			obj->debounce = g_curTime + 1000 + rand()%4000;
			g_jesusState = (jesusState_e)(rand()%(NUM_JESUS_STATES-1));
            g_jesusState = (jesusState_e)((int)g_jesusState + 1);
			if (oldState != g_jesusState)
			{
				obj->debounce2 = g_curTime+1000;
			}
		}

		ObjBigJesus_CoreAI(obj, timeMod);

		if (!g_jesusParts[JESUS_TORSO].obj ||
			!g_jesusParts[JESUS_TORSO].obj->inuse)
		{ //reclaim a torso piece
			jesusPart_t *part = NULL;
			bool found = false;
			for (int i = 0; i < NUM_JESUS_PARTS; i++)
			{
				part = &g_jesusParts[i];
				if (part->obj && part->obj->inuse)
				{
					found = true;
					break;
				}
			}
            if (found)
			{
				g_jesusParts[JESUS_TORSO].obj = part->obj;
				part->obj = NULL;
			}
			else
			{ //it's all over for you, jesus. ALL OVER.
				obj->think = ObjBigJesus_ThinkDestroyed;
				g_sharedFn->Common_MapChange("*credits");
			}
		}
		if (g_jesusParts[JESUS_TORSO].obj &&
			g_jesusParts[JESUS_TORSO].obj->inuse)
		{
			float f = 0.1f;
			jesusPart_t *part = &g_jesusParts[JESUS_TORSO];
			part->obj->radius = Util_NudgeValue(part->obj->radius, part->nsRad, timeMod*f);
			for (int i = 0; i < 3; i++)
			{
				part->obj->spawnMins[i] = Util_NudgeValue(part->obj->spawnMins[i], part->nsMins[i], timeMod*f);
				part->obj->spawnMaxs[i] = Util_NudgeValue(part->obj->spawnMaxs[i], part->nsMaxs[i], timeMod*f);
				part->obj->net.mins[i] = Util_NudgeValue(part->obj->net.mins[i], part->nsMins[i], timeMod*f);
				part->obj->net.maxs[i] = Util_NudgeValue(part->obj->net.maxs[i], part->nsMaxs[i], timeMod*f);
				part->obj->net.modelScale[i] = Util_NudgeValue(part->obj->net.modelScale[i], part->nsModelScale[i], timeMod*f);
			}
		}

		for (int i = 0; i < NUM_JESUS_PARTS; i++)
		{
			jesusPart_t *part = &g_jesusParts[i];
			g_jesusParts[i].offAng[0] = 0.0f;
			g_jesusParts[i].offAng[1] = 0.0f;
			g_jesusParts[i].offAng[2] = 0.0f;
			ObjBigJesus_OffsetPart(&g_jesusParts[i], NULL, NULL);
		}

		float animTimeBase = (float)g_curTime*0.01f;
		switch (g_jesusState)
		{ //could optionally add more programmer-controlled animations here
		case JESUSSTATE_RUNNING:
			g_jesusParts[JESUS_THIGH_L].offAng[PITCH] = sinf(animTimeBase)*70.0f;
			ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_THIGH_L], NULL, NULL);
			g_jesusParts[JESUS_THIGH_R].offAng[PITCH] = -cosf(animTimeBase)*70.0f;
			ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_THIGH_R], NULL, NULL);

			if (obj->debounce4 < g_curTime)
			{ //run sounds
				float walkTol = 50.0f;
				if ((g_jesusParts[JESUS_THIGH_L].obj && g_jesusParts[JESUS_THIGH_L].obj->inuse && fabsf(g_jesusParts[JESUS_THIGH_L].offAng[PITCH]) > walkTol) ||
					(g_jesusParts[JESUS_THIGH_R].obj && g_jesusParts[JESUS_THIGH_R].obj->inuse && fabsf(g_jesusParts[JESUS_THIGH_R].offAng[PITCH]) > walkTol))
				{
					ObjSound_Create(obj->net.pos, "assets/sound/other/jesusrun.wav", 1.0f, -1);
					obj->debounce4 = g_curTime+500;
				}
			}

			g_jesusParts[JESUS_ARM_L].offAng[YAW] = -90.0f;
			g_jesusParts[JESUS_ARM_L].offAng[ROLL] = cosf(animTimeBase)*30.0f;
			ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_ARM_L], NULL, NULL);
			g_jesusParts[JESUS_ARM_R].offAng[YAW] = 90.0f;
			g_jesusParts[JESUS_ARM_R].offAng[ROLL] = sinf(animTimeBase)*30.0f;
			ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_ARM_R], NULL, NULL);
			break;
		default:
			break;
		}

		//update jesus root
		Math_CreateMatrixFromOrientation(g_jesusPos, g_jesusAng, &g_jesusParts[JESUS_WAIST].mat);

		ObjBigJesus_TransformJesus(obj);

		for (int i = 0; i < NUM_JESUS_PARTS; i++)
		{
			jesusPart_t *part = &g_jesusParts[i];
			ObjBigJesus_PartToSkeleton(obj, part, timeMod);

			if (!part->obj || !part->obj->inuse)
			{
				continue;
			}
			if (part->obj->rcColModel)
			{
				LServ_UpdateRClip(part->obj);
			}
		}
	}
}

//define the hierarchies of jesus
void ObjBigJesus_DefineHierarchies(gameObject_t *obj, float *basePos, float *baseAng)
{
	g_jesusParts[JESUS_WAIST].parent = NULL;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_WAIST], basePos, baseAng);

	g_jesusParts[JESUS_HAND_L].parent = &g_jesusParts[JESUS_ARM_L];
	g_jesusParts[JESUS_HAND_R].parent = &g_jesusParts[JESUS_ARM_R];
	g_jesusParts[JESUS_ARM_L].parent = &g_jesusParts[JESUS_TORSO];
	g_jesusParts[JESUS_ARM_R].parent = &g_jesusParts[JESUS_TORSO];
	g_jesusParts[JESUS_TORSO].parent = &g_jesusParts[JESUS_WAIST];
	g_jesusParts[JESUS_HEAD].parent = &g_jesusParts[JESUS_TORSO];
	g_jesusParts[JESUS_FOOT_L].parent = &g_jesusParts[JESUS_LEG_L];
	g_jesusParts[JESUS_FOOT_R].parent = &g_jesusParts[JESUS_LEG_R];
	g_jesusParts[JESUS_THIGH_L].parent = &g_jesusParts[JESUS_WAIST];
	g_jesusParts[JESUS_THIGH_R].parent = &g_jesusParts[JESUS_WAIST];
	g_jesusParts[JESUS_LEG_L].parent = &g_jesusParts[JESUS_THIGH_L];
	g_jesusParts[JESUS_LEG_R].parent = &g_jesusParts[JESUS_THIGH_R];

	//set up offsets
	float offset[3];

	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_WAIST], 0.6f);

	offset[0] = 0.0f;
	offset[1] = 0.0f;
	offset[2] = 256.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_TORSO], offset, NULL);

	offset[0] = 0.0f;
	offset[1] = 0.0f;
	offset[2] = 256.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_HEAD], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_HEAD], 0.7f);

	offset[0] = 0.0f;
	offset[1] = -400.0f;
	offset[2] = 0.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_ARM_L], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_ARM_L], 0.7f);
	offset[0] = 0.0f;
	offset[1] = -350.0f;
	offset[2] = 0.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_HAND_L], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_HAND_L], 0.3f);

	offset[0] = 0.0f;
	offset[1] = 400.0f;
	offset[2] = 0.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_ARM_R], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_ARM_R], 0.7f);
	offset[0] = 0.0f;
	offset[1] = 350.0f;
	offset[2] = 0.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_HAND_R], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_HAND_R], 0.3f);

	offset[0] = 0.0f;
	offset[1] = -100.0f;
	offset[2] = -200.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_THIGH_L], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_THIGH_L], 0.7f);
	offset[0] = 0.0f;
	offset[1] = -100.0f;
	offset[2] = -300.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_LEG_L], offset, NULL);
	offset[0] = 0.0f;
	offset[1] = -32.0f;
	offset[2] = -350.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_FOOT_L], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_FOOT_L], 0.5f);

	offset[0] = 0.0f;
	offset[1] = 100.0f;
	offset[2] = -200.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_THIGH_R], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_THIGH_R], 0.7f);
	offset[0] = 0.0f;
	offset[1] = 100.0f;
	offset[2] = -300.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_LEG_R], offset, NULL);
	offset[0] = 0.0f;
	offset[1] = 32.0f;
	offset[2] = -350.0f;
	ObjBigJesus_OffsetPart(&g_jesusParts[JESUS_FOOT_R], offset, NULL);
	ObjBigJesus_ScalePart(&g_jesusParts[JESUS_FOOT_R], 0.5f);
}

//one of jesus's parts died
void ObjBigJesus_PartDeath(gameObject_s *obj, gameObject_s *killer)
{
	float up[3] = {-90.0f, 0.0f, 0.0f};
	ObjParticles_Create("jesuspart/death", obj->net.pos, up, -1);
	ObjSound_Create(obj->net.pos, "assets/sound/other/pulse_blow.wav", 1.0f, -1);
	ObjSound_Create(obj->net.pos, "assets/sound/other/jesuspain.wav", 1.0f, -1);

	obj->think = ObjGeneral_RemoveThink;
	obj->thinkTime = g_curTime;
}

//you hurt the christpart~
void ObjBigJesus_PartPain(gameObject_t *obj, gameObject_t *hurter, int dmg)
{
	char *snd;
	int r = rand()%30;
	if (r > 20)
	{
		snd = "assets/sound/other/pulse_b1.wav";
	}
	else if (r > 10)
	{
		snd = "assets/sound/other/pulse_b2.wav";
	}
	else
	{
		snd = "assets/sound/other/pulse_b3.wav";
	}
	ObjSound_Create(obj->net.pos, snd, 1.0f, -1);
}

//you touched jesus's part
void ObjBigJesus_PartTouch(gameObject_s *obj, gameObject_s *other, const collObj_t *col)
{
	if (other && other->inuse && other->projDamage && col)
	{ //projectile impact
		float ang[3];
		float n[3];
		n[0] = col->endNormal[0];
		n[1] = col->endNormal[1];
		n[2] = col->endNormal[2];
		Math_VecToAngles(n, ang);
		ObjParticles_Create("jesuspart/bleed", obj->net.pos, ang, -1);
	}
}

//jesus spawn
void ObjBigJesus_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	g_sharedFn->Common_ServerString("&&jesuspart/death");
	g_sharedFn->Common_ServerString("&&jesuspart/bleed");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_blow.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b1.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b2.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b3.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/jesuspain.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/jesusrun.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/jesustwirl.wav");

	Math_VecCopy(obj->net.pos, g_jesusPos);
	g_jesusPos[0] -= 512.0f;
	g_jesusPos[2] -= 2400.0f;
	Math_VecCopy(obj->net.ang, g_jesusAng);

	Math_VecCopy(g_jesusPos, g_jesusCOG);
	g_jesusCOG[0] -= 600.0f;

	g_jesusState = JESUSSTATE_IDLE;//JESUSSTATE_RUNNING;

	for (int i = 0; i < NUM_JESUS_PARTS; i++)
	{
		gameObject_t *part = LServ_ObjectFromName("obj_gen_jesuspiece",
			g_jesusPos, obj->net.ang, NULL, 0);
		assert(part);
		part->net.owner = obj->net.index;
		part->death = ObjBigJesus_PartDeath;
		part->pain = ObjBigJesus_PartPain;
		part->touch = ObjBigJesus_PartTouch;
		if (part->rcColModel)
		{
			part->rcColModel->gameIgnore = obj->net.index;
			part->rcColModel->gameOwner = obj->net.index;
		}
		g_jesusParts[i].partType = (jesusPart_e)i;
		g_jesusParts[i].obj = part;
		g_jesusParts[i].mat = g_jesusIdent;
		part->generalFlag = i;
		ObjBigJesus_ScalePart(&g_jesusParts[i], 1.0f);
	}
	ObjBigJesus_DefineHierarchies(obj, g_jesusPos, g_jesusAng);
	obj->think = ObjBigJesus_Think;
	obj->thinkTime = g_curTime+50;
}
