/*
=============================================================================
Module Information
------------------
Name:			clstars.cpp
Author:			Rich Whitehouse
Description:	star system
=============================================================================
*/

#include "clmain.h"

typedef struct starCluster_s
{
	int				index;
	drawObject_t	obj;
	float			verts[3*4];
	simpleSprite_t	spr;
	bool			inuse;
} starCluster_t;

#define NUM_STAR_TEXTURES		7
#define MAX_STAR_CLUSTERS		400//160 //the total number of star sheets
#define STAR_DENSITY			4.0f;//8.0f; //controls the distance between sheets of stars

texContainer_t g_starTextures[NUM_STAR_TEXTURES];
starCluster_t g_starClusters[MAX_STAR_CLUSTERS];

//add star clusters and move them around
void LCl_StarClusterLogic(void)
{
	const float fieldExtent = 6000.0f;//4096.0f;

	clientObject_t *cam = &g_clientObjects[CAM_TRACK_NUM];
	int i = 0;
	while (i < MAX_STAR_CLUSTERS)
	{
		starCluster_t *star = &g_starClusters[i];
		if (!star->inuse)
		{
			float paveX = -fieldExtent;
			float paveY = -fieldExtent;
			int j = 0;
			while (j < i)
			{
				paveY += 2048.0f;
				if (paveY >= fieldExtent)
				{
					paveX += 2048.0f;
					paveY = -fieldExtent;
				}
				j++;
			}
			star->obj.pos[0] = cam->projPos[0]+paveX;
			star->obj.pos[1] = cam->projPos[1]+paveY;
			star->inuse = true;
		}
		else
		{
			if (g_musicalMode)
			{
				float timeFactor = 0.0001f;
				star->obj.blendRGBA[0] = fabsf(sinf((float)g_curTime * timeFactor)) * (0.25f + 0.5f * g_musicFrac);
				star->obj.blendRGBA[1] = fabsf(cos((float)g_curTime * timeFactor)) * (0.25f + 0.5f * g_musicFrac);
				star->obj.blendRGBA[2] = (1.0f-fabsf(sinf((float)g_curTime * timeFactor))) * (0.25f + 0.5f * g_musicFrac);
				star->obj.objDynamicIllumination = true;
			}
			else
			{
				star->obj.blendRGBA[0] = 1.0f;
				star->obj.blendRGBA[1] = 1.0f;
				star->obj.blendRGBA[2] = 1.0f;
				star->obj.objDynamicIllumination = false;
			}
			int j = 0;
			while (j < 2)
			{
				if (fabsf(cam->projPos[j]-star->obj.pos[j]) > fieldExtent)
				{
					bool getNewTex = false;
					if (cam->projPos[j] > star->obj.pos[j])
					{
						star->obj.pos[j] += fieldExtent*2;
						getNewTex = true;
					}
					else if (cam->projPos[j] < star->obj.pos[j])
					{
						star->obj.pos[j] -= fieldExtent*2;
						getNewTex = true;
					}

					if (getNewTex)
					{ //keep things more random by modifying the texture and spin
						star->obj.texture = g_starTextures[rand()%NUM_STAR_TEXTURES];
						star->obj.ang[1] = (float)(rand()%360);
					}
				}
				j++;
			}
		}

		if (star->inuse)
		{
			float heightOffset = 2048.0f;
			float height = -4096.0f;
			heightOffset += cam->obj.pos[2]*0.1f; //give a slight sense of scale moving away from stars
			height += ((float)star->index)*STAR_DENSITY;
			star->obj.pos[2] = (cam->obj.pos[2]-heightOffset)+height;

			g_sharedFn->GL_AddDrawObject(&star->obj);
		}
		i++;
	}
}

//init star cluster
void LCl_InitStarCluster(starCluster_t *star)
{
	const float starSpriteW = 2048.0f;
	const float starSpriteH = 2048.0f;
	const float starSpriteZ = 0.0f;
	float *verts = star->verts;

	star->spr.verts = verts;
	verts[0] = (((float)starSpriteW)/2.0f);
	verts[1] = -(((float)starSpriteH)/2.0f);
	verts[2] = starSpriteZ;
	verts += 3;
	verts[0] = (((float)starSpriteW)/2.0f);
	verts[1] = (((float)starSpriteH)/2.0f);
	verts[2] = starSpriteZ;
	verts += 3;
	verts[0] = -(((float)starSpriteW)/2.0f);
	verts[1] = (((float)starSpriteH)/2.0f);
	verts[2] = starSpriteZ;
	verts += 3;
	verts[0] = -(((float)starSpriteW)/2.0f);
	verts[1] = -(((float)starSpriteH)/2.0f);
	verts[2] = starSpriteZ;

	star->spr.tc = NULL;

	star->obj.ssprite = &star->spr;

	float height = -4096.0f;
	height += ((float)star->index)*STAR_DENSITY;
	star->obj.pos[2] = height;

	star->obj.ang[0] = 0.0f;
	star->obj.ang[1] = (float)(rand()%360);
	star->obj.ang[2] = 0.0f;

	star->obj.blendSrc = 2; //GL_ONE
	star->obj.blendDst = 2; //GL_ONE
	star->obj.blendRGBA[0] = 1.0f;
	star->obj.blendRGBA[1] = 1.0f;
	star->obj.blendRGBA[2] = 1.0f;
	star->obj.blendRGBA[3] = 1.0f;

	star->spr.noDepthWrite = true;

	star->obj.texture = g_starTextures[rand()%NUM_STAR_TEXTURES];
}

//the star system
void LCl_StarSystemInit(void)
{
	memset(g_starClusters, 0, sizeof(g_starClusters));

	int i = 0;
	while (i < NUM_STAR_TEXTURES)
	{
		char starTex[256];
		sprintf(starTex, "assets/sprites/stars_%02i", i);
		g_sharedFn->Img_TextureLoad(starTex, &g_starTextures[i]);
		i++;
	}

	i = 0;
	while (i < MAX_STAR_CLUSTERS)
	{
		g_starClusters[i].index = i;
		LCl_InitStarCluster(&g_starClusters[i]);
		i++;
	}
}
