#ifndef _CLSHARED_H

#define _CLSHARED_H

#define CL_LOGIC_API_VERSION	1338

class CSafeModelPtr;
typedef struct rda_s rda_t;
typedef struct texShader_s texShader_t;
typedef struct rsprite_s rsprite_t;
typedef struct cubicGridSpace_s cubicGridSpace_t;
typedef struct waveFile_s waveFile_t;
typedef struct particleInstance_s particleInstance_t;

typedef struct clientString_s
{
	char		p[64];
} clientString_t;

typedef struct texContainer_s
{
	bool			inuse;
#ifdef _DEBUG
	bool			pad1;
	bool			pad2;
	bool			pad3;
#endif
	texShader_t		*shader;
} texContainer_t;

typedef enum
{
	FLARETEX_CORONA,
	FLARETEX_MID,
	FLARETEX_MID2,
	FLARETEX_MID3,
	FLARETEX_BURST,
	FLARETEX_END,
	FLARETEX_NUM
} flareTextures_e;

typedef struct lensFlare_s
{
	unsigned long		inViewTime;

	int					numMidSections;
	float				length;
	float				sizeScale;
	texContainer_t		textures[FLARETEX_NUM];
} lensFlare_t;

typedef struct ambientLight_s
{
	//ambientLightInteraction_t	*interactions;
	//int						numInteractions;
	float						worldTranslation[3];
	//float						mins[3];
	//float						maxs[3];

	float						scale[3];
	int							glTex;
} ambientLight_t;

typedef struct sceneLight_s
{
	float			pos[3];
	float			color[3];
	float			radius;
	bool			shadows;
	ambientLight_t	*ambientLight;
	int				staticIndex;
	bool			hasFrameScissor;
	bool			doFrameScissor;
	float			frameScissor[6];
	int				lightFlags;

	sceneLight_s	*next;
} sceneLight_t;

typedef struct simpleSprite_s
{
	//float			verts[3*4];
	//float			tc[2*4];
	float			*verts;
	float			*tc;
	float			scaleX;
	float			scaleY;
	bool			noDepthWrite;
} simpleSprite_t;

typedef struct genericDraw_s
{
	int				primType;

	int				numVerts;
	float			*verts;
	float			*texCoords;
	float			*colors;

	float			pos[3];
	float			ang[3];

	bool			freeBuffers;
	bool			forceNoDepth;

	genericDraw_s	*next;
} genericDraw_t;

typedef struct drawObject_s
{
	float				pos[3];
	float				ang[3];

	CSafeModelPtr		*model;
	rda_t				*anim;
	float				modelScale[3];

	cubicGridSpace_t	*cgrid;
	int					cgridNum;

	rsprite_t			*rspr;
	int					rsprAng;
	bool				rsprNoOri;

	int					blendFrame; //applicable only for skeletal animation
	int					frame;
	float				lerpAmount; //applicable only for skeletal animation

	simpleSprite_t		*ssprite;

	lensFlare_t			*lensFlare;

	texContainer_t		texture;
	int					deforms;
	float				deformPropA;
	float				deformPropB;
	float				deformPropC;
	float				deformPropD;

	int					blendSrc;
	int					blendDst;
	float				blendRGBA[4];

	int					staticIndex;

	bool				angAbsolute;

	bool				objDynamicIllumination;

	bool				noShadows;

	int					gridColorFrame;
	float				gridColor[3];
	float				gridNormal[3];

	bool				frameCulled;
	bool				didFrameCulling;

	bool				hasRepInfo;
	float				cheapModelScale;

	float				modelMat[16];
	float				modelToLocalMat[16];
	modelMatrix_t		invModelMat;
	float				testMins[3];
	float				testMaxs[3];

	/*
	//SSHX THIS MUST REMAIN IN THE LAST 160 BYTES
	int					hasModelMat;
	float				modelMat[16];
	int					hasModelToLocalMat;
	float				modelToLocalMat[16];
	float				testMins[3];
	float				testMaxs[3];
	*/
} drawObject_t;

typedef struct clientObject_s
{
	bool			active;

	CSafeModelPtr	*model;
	rda_t			*anim;

	lensFlare_t		flare;

	float			projPos[3];
	float			projAng[3];
	float			projScale[3];

	bool			postAdd; //add after everything else

	BYTE			*objectData;
	bool			checkedProps;

	unsigned long	clAnimTime;

	unsigned long	clLerpAnimTime;
	int				clLerpAnimFrame;
	int				clLerpAnimBlendFrame;

	bool			hasSoundData;
	float			soundData;

	drawObject_t	obj;
	gameObjNet_t	net;
} clientObject_t;

typedef struct menuScript_s menuScript_t;
typedef struct mscriptNode_s mscriptNode_t;

//max args in a single script instruction
#define MAX_MENUSCRIPT_ARGS		8

typedef struct menu_s
{
    char				name[64];
	char				*text;
	int					x;
	int					y;
	int					w;
	int					h;
	texContainer_t		texture;
	int					drawTypeID;

	int					textOffX;
	int					textOffY;
	int					inputTextOffX;
	int					inputTextOffY;

	int					blendSrc;
	int					blendDst;
	float				blendRGBA[4];

	bool				selectable;
	bool				textSelector;
	char				*textSelPtr;
	int					textSelLineCount;
	float				fontScaleX;
	float				fontScaleY;

	bool				takeInput;
	char				inputStr[64];

	bool				inuse;
	bool				server; //if true, then input etc should be sent to the server.

	char				activateScript[64];
	char				onEscape[64];
	bool				draw;

	texContainer_t		ptrTexture;
} menu_t;

typedef struct mscriptArg_s
{
	char			p[64];
} mscriptArg_t;

typedef struct mscriptHandler_s
{
	char			*name;
	bool			(*handlerFunc)(mscriptNode_t *node, menuScript_t *mscript);
	int				argNum;
} mscriptHandler_t;

typedef struct mscriptNode_s
{
	mscriptArg_t		menuArgs[MAX_MENUSCRIPT_ARGS];
	mscriptHandler_t	*nodeHandler;

	mscriptNode_t		*next;
} mscriptNode_t;

typedef struct menuScript_s
{
	char			name[64];

	unsigned long	scriptTime;
	mscriptNode_t	*nodes;
	mscriptNode_t	*curNode;

	bool			inuse;
} menuScript_t;

typedef struct sharedCLFunctions_s
{
	//called back into by the engine
	void					(*LCl_Frame)(unsigned long time, int numObj, int localCl, bool clientInterpolate,
										bool isMulti, float musicFrac, float *viewPos, float *viewAng);
	void					(*LCl_Draw2D)(void);
	void					(*LCl_CacheResources)(void);
	void					(*LCl_NetEvent)(clientEventTypes_e e, BYTE *data, int dataSize);
	void					(*LCl_FreshClientObject)(clientObject_t *obj);
	void					(*LCl_UserMenu)(const char *callName, mscriptNode_t *node, menuScript_t *mscript);

	//math routines
	void					(*Math_CalcPlaneEq)(float *x, float *y, float *z, float *planeEq);
	float					(*Math_VecNorm2)(float *v);
	float					(*Math_VecNorm)(float *v);
	float					(*Math_PlaneNorm)(float *plane);
	float					(*Math_VecLen)(float *a);
	float					(*Math_PlaneDist)(const float *pl, const float *p);
	void					(*Math_ProjectOntoPlane)(const float *plane, const float *pos, float *out);
	void					(*Math_VecCopy)(float *a, float *out);
	void					(*Math_VecSub)(float *a, float *b, float *out);
	void					(*Math_VecAdd)(float *a, float *b, float *out);
	void					(*Math_VecScale)(float *a, float scale);
	float					(*Math_Max2)(float a, float b);
	float					(*Math_Max3)(float a, float b, float c);
	void					(*Math_TransformPointByMatrix)(modelMatrix_t *matrix, float *in, float *out);
	void					(*Math_TransformPointByMatrix3x3)(modelMatrix_t *matrix, float *in, float *out);
	void					(*Math_TransformPoint)(float *basePos, float *scale, float *eAngles, float *in, float *out);
	void					(*Math_VecMA)( float *veca, float scale, float *vecb, float *vecc);
	void					(*Math_VecToAngles)(const float *value1, float *angles);
	void					(*Math_TransformPoint2)(float *basePos, float *scale, float *eAngles, float *in, float *out);
	void					(*Math_MatrixInverse)(modelMatrix_t *in, modelMatrix_t *out);
	void					(*Math_MatrixMultiply)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void					(*Math_MatrixMultiply3x3)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void					(*Math_MatrixMultiply4x4)(fourxMatrix_t *in, fourxMatrix_t *in2, fourxMatrix_t *out);
	void					(*Math_AnglesToMat)(const float *incAngles, modelMatrix_t *mat);
	void					(*Math_CrossProduct)(const float *v1, const float *v2, float *cross);
	float					(*Math_DotProduct)(const float *v1, const float *v2);
	float					(*Math_AngleMod)(float angle);
	void					(*Math_InterpolateVector)(float *old, float *cur, float val, float tresh, float *out);
	float					(*Math_BlendAngle)(float in, float goal, float factor);
	void					(*Math_AngleVectors)(float *angles, float *forward, float *right, float *up);
	void					(*Math_CreateMatrixFromOrientation)(float *origin, float *angles, modelMatrix_t *mat);
	void					(*Math_RotationMatrix)(float phi, int axis, modelMatrix_t *mat);
	bool					(*Math_BoxesOverlap)(float *mins1, float *maxs1, float *mins2, float *maxs2);
	void					(*Math_ExpandBounds)(float *baseMins, float *baseMaxs, float *mins, float *maxs);
	void					(*Math_CreateFrustum)(float fov, float *pos, float *ang, viewFrustum_t *out);
	int						(*Math_PointRelativeToPlane)(float *pos, float *side, float *planeEq);
	void					(*Math_GetBoundsPoints)(float *mins, float *maxs, float *bp, float *baxis);
	bool					(*Math_PointInFrustum)(viewFrustum_t *frustum, float *point, float radius);
	int						(*Math_BoxInFrustum)(viewFrustum_t *frustum, float *mins, float *maxs);

	//file system
	int						(*FileSys_OpenFile)(const char *filename, int mode1, int mode2);
	void					(*FileSys_CloseFile)(int handle);
	int						(*FileSys_GetLen)(int handle);
	bool					(*FileSys_ReadFile)(int handle, void *out, int len);
	bool					(*FileSys_WriteFile)(int handle, void *in, int len);
	char					*(*FileSys_GetFileList)(const char *searchPath, const char *searchType);

	void					*(*Common_RCMalloc)(unsigned int size); //malloc
	void					(*Common_RCFree)(void *ptr); //free

	//resource functions
	BYTE					*(*RCO_GetEntryForObject)(const char *objName);
	const char				*(*RCO_GetValForKey)(BYTE *aobj, const char *keyName);
	void					(*RCO_SetValForKey)(BYTE *aobj, const char *keyName, const char *value);
	int						(*Img_TextureLoad)(const char *name, texContainer_t *tx);
	CSafeModelPtr			*(*Model_Allocate)(const char *filename);
	void					(*Model_Free)(CSafeModelPtr *model);
	void					(*Model_ProjectDecal)(drawObject_t *modelSceneObj, float *start, float *end, float decalSize, texContainer_t *decalTex, int lifeTime, int fadeTime);
	rda_t					*(*Anim_Allocate)(const char *filename);
	waveFile_t				*(*S_CacheSound)(const char *filename);
	int						(*S_PlayWave)(waveFile_t *wave, float *pos, float volume, bool neverStomp, int attachClientObj, int forceChannel);
	particleInstance_t		*(*ClPcl_CreateParticles)(const char *pclName, float *pos, float *angles, int clOwner);

	//gl interface
	void					(*GL_AddDrawObject)(drawObject_t *obj);
	void					(*GL_AddSceneLight)(sceneLight_t *light);
	void					(*GL_AddGenericObject)(genericDraw_t *obj);
	void					(*GL_BindTexContainer)(texContainer_t *tx);
	float					(*GL_ScaleBasedOnResW)(float f);
	float					(*GL_ScaleBasedOnResH)(float f);
	void					(*GL_VertProgramBegin)(bool untextured);
	void					(*GL_VertProgramEnd)(void);
	void					(*GL_PrepareForDraw)(void);
	int						(*GL_DrawRawText)(int x, int y, int w, int h, float scaleX, float scaleY,
								char *txPtr, bool isInput, bool lineWrapping);
	void					(*GL_SetFlash)(unsigned long duration, unsigned long time);
	void					(*GL_SetViewTrails)(float amount, float decay);

	//menu interface
	menu_t					*(*Menu_GetMenu)(char *menuName);
	bool					(*Menu_StartScript)(char *scriptName);

	//network interface
	void					(*Net_DoChat)(const char *str);
} sharedCLFunctions_t;

#endif //_CLSHARED_H
