#ifndef _CLMAIN_H
#define _CLMAIN_H

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <assert.h>
#include "../logicsv/sharedtypes.h"
#include "clshared.h"

extern sharedCLFunctions_t *g_sharedFn;
extern clientObject_t *g_clientObjects;
extern clientString_t *g_clientStrings;
extern unsigned long g_curTime;
extern int g_numActiveGameObj;
extern int g_selfClientNum;
extern float g_musicFrac;
extern bool g_musicalMode;

extern int g_musicClHighScore;
extern int g_musicScoreMul;
extern unsigned long g_musicScoreMulTime;

typedef struct clientResources_s
{
	texContainer_t			novaTex;
	texContainer_t			lifeTex;
} clientResources_t;
extern clientResources_t g_clRes;

//for convenience
#define Math_CalcPlaneEq						g_sharedFn->Math_CalcPlaneEq
#define Math_VecNorm2							g_sharedFn->Math_VecNorm2
#define Math_VecNorm							g_sharedFn->Math_VecNorm
#define Math_PlaneNorm							g_sharedFn->Math_PlaneNorm
#define Math_VecLen								g_sharedFn->Math_VecLen
#define Math_PlaneDist							g_sharedFn->Math_PlaneDist
#define Math_ProjectOntoPlane					g_sharedFn->Math_ProjectOntoPlane
#define Math_VecCopy							g_sharedFn->Math_VecCopy
#define Math_VecSub								g_sharedFn->Math_VecSub
#define Math_VecAdd								g_sharedFn->Math_VecAdd
#define Math_VecScale							g_sharedFn->Math_VecScale
#define Math_Max2								g_sharedFn->Math_Max2
#define Math_Max3								g_sharedFn->Math_Max3
#define Math_TransformPointByMatrix				g_sharedFn->Math_TransformPointByMatrix
#define Math_TransformPointByMatrix3x3			g_sharedFn->Math_TransformPointByMatrix3x3
#define Math_TransformPoint						g_sharedFn->Math_TransformPoint
#define Math_VecMA								g_sharedFn->Math_VecMA
#define Math_VecToAngles						g_sharedFn->Math_VecToAngles
#define Math_TransformPoint2					g_sharedFn->Math_TransformPoint2
#define Math_MatrixInverse						g_sharedFn->Math_MatrixInverse
#define Math_MatrixMultiply						g_sharedFn->Math_MatrixMultiply
#define Math_MatrixMultiply3x3					g_sharedFn->Math_MatrixMultiply3x3
#define Math_MatrixMultiply4x4					g_sharedFn->Math_MatrixMultiply4x4
#define Math_AnglesToMat						g_sharedFn->Math_AnglesToMat
#define Math_CrossProduct						g_sharedFn->Math_CrossProduct
#define Math_DotProduct							g_sharedFn->Math_DotProduct
#define Math_AngleMod							g_sharedFn->Math_AngleMod
#define Math_InterpolateVector					g_sharedFn->Math_InterpolateVector
#define Math_BlendAngle							g_sharedFn->Math_BlendAngle
#define Math_AngleVectors						g_sharedFn->Math_AngleVectors
#define Math_CreateMatrixFromOrientation		g_sharedFn->Math_CreateMatrixFromOrientation
#define Math_RotationMatrix						g_sharedFn->Math_RotationMatrix
#define Math_BoxesOverlap						g_sharedFn->Math_BoxesOverlap
#define Math_ExpandBounds						g_sharedFn->Math_ExpandBounds
#define Math_CreateFrustum						g_sharedFn->Math_CreateFrustum
#define Math_PointRelativeToPlane				g_sharedFn->Math_PointRelativeToPlane
#define Math_GetBoundsPoints					g_sharedFn->Math_GetBoundsPoints
#define Math_PointInFrustum						g_sharedFn->Math_PointInFrustum
#define Math_BoxInFrustum						g_sharedFn->Math_BoxInFrustum

//cldraw.cpp
extern void LCl_DrawHudElements(void);

//clevents.cpp
extern void LCl_NetEvent(clientEventTypes_e e, BYTE *data, int dataSize);
extern void LCl_FreshClientObject(clientObject_t *obj);

//clstars.cpp
void LCl_StarSystemInit(void);
void LCl_StarClusterLogic(void);

#endif //_CLMAIN_H
