/*
=============================================================================
Module Information
------------------
Name:			clmain.cpp
Author:			Rich Whitehouse
Description:	core client logic module implementation.
=============================================================================
*/

#include "clmain.h"

sharedCLFunctions_t *g_sharedFn;
clientObject_t *g_clientObjects;
clientString_t *g_clientStrings;
unsigned long g_curTime;
int g_numActiveGameObj = 0;
int g_selfClientNum = 0;
float g_musicFrac = 0.0f;
bool g_musicalMode = false;
float *g_viewPos;
float *g_viewAng;
clientResources_t g_clRes;

int g_musicClHighScore = 0;
int g_musicScoreMul = 0;
unsigned long g_musicScoreMulTime = 0;

//return api version
int LCl_GetAPIVersion(void)
{
	return CL_LOGIC_API_VERSION;
}

//set the render view
void LCl_SetViewPos(void)
{
	g_viewAng[YAW] = 90.0f;
	g_viewAng[PITCH] = -90.0f;
	g_viewAng[ROLL] = 0.0f;
	//Math_VecCopy(g_clientObjects[g_selfClientNum].projPos, g_viewPos);
	g_viewPos[0] = 0.0f;
	g_viewPos[1] = 0.0f;
	g_viewPos[2] = 0.0f;

	if (g_clientObjects[CAM_TRACK_NUM].active)
	{
		g_viewPos[0] = g_clientObjects[CAM_TRACK_NUM].projPos[0];
		g_viewPos[1] = g_clientObjects[CAM_TRACK_NUM].projPos[1];
		g_viewPos[2] = g_clientObjects[CAM_TRACK_NUM].projPos[2];
		g_viewAng[PITCH] += g_clientObjects[CAM_TRACK_NUM].projAng[PITCH];
		g_viewAng[YAW] += g_clientObjects[CAM_TRACK_NUM].projAng[YAW];
		g_viewAng[ROLL] += g_clientObjects[CAM_TRACK_NUM].projAng[ROLL];
	}
	int x = 0;
	while (x < 3)
	{
		while (g_viewAng[x] < 0.0f)
		{
			g_viewAng[x] += 360.0f;
		}
		while (g_viewAng[x] > 360.0f)
		{
			g_viewAng[x] -= 360.0f;
		}
		x++;
	}
}

//decide position
void LCl_InterpolateObjectPos(clientObject_t *obj, bool clientInterpolate)
{
	if (clientInterpolate)
	{
		Math_InterpolateVector(obj->projPos, obj->net.pos, 0.3f, 1024.0f, obj->obj.pos);
	}
	else
	{
		Math_VecCopy(obj->net.pos, obj->obj.pos);
	}

	if (obj->net.type == OBJ_TYPE_PROJECTILE)
	{
		Math_VecCopy(obj->net.ang, obj->obj.ang);
	}
	else
	{
		if (clientInterpolate)
		{
			int i = 0;
			while (i < 3)
			{
				float ang = (360.0f / 65536) * ((int)(obj->net.ang[i] * (65536 / 360.0f)) & 65535);
				obj->obj.ang[i] = Math_BlendAngle(obj->projAng[i], ang, 0.1f);
				i++;
			}
		}
		else
		{
			Math_VecCopy(obj->net.ang, obj->obj.ang);
		}
	}

	Math_VecCopy(obj->obj.pos, obj->projPos);
	Math_VecCopy(obj->obj.ang, obj->projAng);
}

//frame
void LCl_Frame(unsigned long time, int numObj, int localCl, bool clientInterpolate,
			   bool isMulti, float musicFrac, float *viewPos, float *viewAng)
{
	g_curTime = time;
	g_viewPos = viewPos;
	g_viewAng = viewAng;
	g_numActiveGameObj = numObj;
	g_selfClientNum = localCl;
	g_musicFrac = musicFrac;

	clientObject_t *cam = (g_numActiveGameObj > CAM_TRACK_NUM && g_clientObjects[CAM_TRACK_NUM].active) ? &g_clientObjects[CAM_TRACK_NUM] : NULL;

	if (cam && (cam->net.renderEffects & FXFL_MUSICAL))
	{ //musical!
		g_musicalMode = true;
	}
	else
	{
		g_musicalMode = false;
	}

	//typically all transparent objects will be above the star layers
	if (cam && !(cam->net.renderEffects & FXFL_FPSMODE))
	{ //don't render stars in fps mode
		LCl_StarClusterLogic();
	}

	int i = 0;
	while (i < g_numActiveGameObj)
	{
		if (g_clientObjects[i].active)
		{
			LCl_InterpolateObjectPos(&g_clientObjects[i], clientInterpolate);
		}
		i++;
	}

	LCl_SetViewPos();
}

//draw hud and other game-specific elements
void LCl_Draw2D(void)
{
	LCl_DrawHudElements();
}

//load resources
void LCl_CacheResources(void)
{
	g_sharedFn->Img_TextureLoad("assets/textures/hud_nova", &g_clRes.novaTex);
	g_sharedFn->Img_TextureLoad("assets/textures/hud_life", &g_clRes.lifeTex);

	LCl_StarSystemInit();
}

//custom menu handler
void LCl_UserMenu(const char *callName, mscriptNode_t *node, menuScript_t *mscript)
{
	//user menu handlers can be added here
}

//module init
int LCl_Initialize(sharedCLFunctions_t *sharedFunc, clientObject_t *clientObjects, clientString_t *clientStrings)
{
	g_sharedFn = sharedFunc;
	g_clientObjects = clientObjects;
	g_clientStrings = clientStrings;

	g_sharedFn->LCl_Frame = LCl_Frame;
	g_sharedFn->LCl_Draw2D = LCl_Draw2D;
	g_sharedFn->LCl_CacheResources = LCl_CacheResources;
	g_sharedFn->LCl_NetEvent = LCl_NetEvent;
	g_sharedFn->LCl_FreshClientObject = LCl_FreshClientObject;
	g_sharedFn->LCl_UserMenu = LCl_UserMenu;
	return 1;
}

//module shutdown
void LCl_Shutdown(void)
{
}
