/*
=============================================================================
Module Information
------------------
Name:			clevents.cpp
Author:			Rich Whitehouse
Description:	client object event routines
=============================================================================
*/

#include "clmain.h"

//incoming network event
void LCl_NetEvent(clientEventTypes_e e, BYTE *data, int dataSize)
{
	switch (e)
	{
	case CLEV_UPDATEHIGHSCORE:
		if (dataSize >= sizeof(int))
		{
			g_musicClHighScore = *((int *)data);			
		}
		break;
	case CLEV_DISPLAYMUL:
		if (dataSize >= sizeof(int))
		{
			g_musicScoreMul = *((int *)data);
			g_musicScoreMulTime = g_curTime + 1500;
			g_sharedFn->GL_SetFlash(300, g_curTime+300);
		}
		break;
	case CLEV_TRIGGERFLASH:
		if (dataSize >= sizeof(int))
		{
			int flash = *((int *)data);
			g_sharedFn->GL_SetFlash(flash, g_curTime+flash);
		}
		break;
	case CLEV_VIEWTRAILS:
		if (dataSize >= sizeof(float)*2)
		{
			float amount = *((float *)data);
			float decay = *(((float *)data)+1);
			g_sharedFn->GL_SetViewTrails(amount, decay);
		}
		break;
	default:
		break;
	}
}

//just receieved this in the object list.
void LCl_FreshClientObject(clientObject_t *obj)
{
	Math_VecCopy(obj->net.pos, obj->projPos);
	Math_VecCopy(obj->net.ang, obj->projAng);
	Math_VecCopy(obj->net.modelScale, obj->projScale);

	if (g_clientStrings[obj->net.entNameIndex].p)
	{
        obj->objectData = g_sharedFn->RCO_GetEntryForObject(g_clientStrings[obj->net.entNameIndex].p);
	}
	else
	{
		obj->objectData = NULL;
	}

	switch (obj->net.type)
	{
	case OBJ_TYPE_NETEVENT:
		if (obj->net.frame == NETEVENT_SOUND)
		{
			if (g_clientStrings[obj->net.strIndex].p[0] == '$')
			{
				//g_clientStrings[obj->net.strIndex].p+1;
				waveFile_t *w = g_sharedFn->S_CacheSound(g_clientStrings[obj->net.strIndex].p+1);
				if (w)
				{
					g_sharedFn->S_PlayWave(w, obj->net.pos, obj->net.modelScale[0], !!obj->net.owner, obj->net.solid, -1);
				}
			}
		}
		else if (obj->net.frame == NETEVENT_PARTICLES)
		{
			if (g_clientStrings[obj->net.strIndex].p[0] == '&' && g_clientStrings[obj->net.strIndex].p[1] == '&')
			{
				g_sharedFn->ClPcl_CreateParticles(g_clientStrings[obj->net.strIndex].p+2, obj->net.pos, obj->net.ang, obj->net.owner);
			}
		}
		else if (obj->net.frame == NETEVENT_DECAL)
		{
			if (g_clientObjects && obj->net.solid >= 0 && obj->net.solid < g_numActiveGameObj &&
				g_clientStrings[obj->net.strIndex].p[0] == '^')
			{
				clientObject_t *clObj = &g_clientObjects[obj->net.solid];
				if (clObj->active && clObj->obj.model)
				{
					texContainer_t decal;
					if (g_sharedFn->Img_TextureLoad(g_clientStrings[obj->net.strIndex].p+1, &decal))
					{
						g_sharedFn->Model_ProjectDecal(&clObj->obj, obj->net.pos, obj->net.ang, obj->net.modelScale[0], &decal, (int)obj->net.modelScale[1], (int)obj->net.modelScale[2]);
					}
				}
			}
		}
		else if (obj->net.frame == NETEVENT_DEBUGBOX)
		{
#ifdef _DEBUG
			static float verts[4096];
			static float colors[4096];
			static int tempMemPt = 0;
			genericDraw_t g;
			memset(&g, 0, sizeof(g));
			float *v = &verts[tempMemPt];
			float *c = &colors[tempMemPt];
			tempMemPt += 32;
			if (tempMemPt >= 4096)
			{
				tempMemPt = 0;
			}
			c[0] = obj->net.ang[0];
			c[1] = obj->net.ang[1];
			c[2] = obj->net.ang[2];
			c[3] = 1.0f;
			Math_VecCopy(obj->net.mins, v);
			//Math_VecAdd(v, obj->net.pos, v);
			Math_VecCopy(obj->net.maxs, &v[3]);
			//Math_VecAdd(&v[3], obj->net.pos, &v[3]);
			g.verts = v;
			g.numVerts = 2;
			g.colors = c;
			g.primType = -1;
			g_sharedFn->GL_AddGenericObject(&g);
#endif
		}
		break;

	default:
		break;
	}
}
